--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: obat; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA obat;


SET search_path = obat, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: bmumap; Type: TABLE; Schema: obat; Owner: -; Tablespace: 
--

CREATE TABLE bmumap (
    bmu integer,
    type text,
    number bigint,
    classid integer,
    coord point
);


--
-- Name: bmus; Type: TABLE; Schema: obat; Owner: -; Tablespace: 
--

CREATE TABLE bmus (
    seqno integer NOT NULL,
    bmu integer,
    coord point
);


--
-- Name: bmus_seqno_seq; Type: SEQUENCE; Schema: obat; Owner: -
--

CREATE SEQUENCE bmus_seqno_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: bmus_seqno_seq; Type: SEQUENCE OWNED BY; Schema: obat; Owner: -
--

ALTER SEQUENCE bmus_seqno_seq OWNED BY bmus.seqno;


--
-- Name: bmus_seqno_seq; Type: SEQUENCE SET; Schema: obat; Owner: -
--

SELECT pg_catalog.setval('bmus_seqno_seq', 34736, true);


--
-- Name: newunits; Type: TABLE; Schema: obat; Owner: -; Tablespace: 
--

CREATE TABLE newunits (
    nationid integer,
    nationality text,
    obslotno integer,
    name text,
    nation integer,
    classid integer,
    class text,
    cost integer,
    size integer,
    crew integer,
    speed integer,
    swimspd integer,
    moveclassid integer,
    moveclass text,
    radio integer,
    survivability integer,
    liftcap integer,
    loadcost integer,
    startmonthavail integer,
    startyearavail integer,
    lastmonthavail integer,
    lastyearavail integer,
    firecontrol integer,
    stabiliser integer,
    vision integer,
    nrsd integer,
    rateoffire integer,
    ew integer,
    rangefinder integer,
    weapon1 integer,
    wpn1name text,
    wpn1herds integer,
    wpn1aprds integer,
    wpn1heatrds integer,
    wpn1sabotrds integer,
    wpn1sound integer,
    weapon2 integer,
    wpn2name text,
    wpn2herds integer,
    wpn2aprds integer,
    wpn2sound integer,
    weapon3 integer,
    wpn3name text,
    wpn3herds integer,
    wpn3aprds integer,
    wpn3sound integer,
    weapon4 integer,
    wpn4name text,
    wpn4herds integer,
    wpn4aprds integer,
    wpn4sound integer,
    steelhf integer,
    steelhs integer,
    steelhr integer,
    steeltf integer,
    steelts integer,
    steeltr integer,
    steeltop integer,
    heathf integer,
    heaths integer,
    heathr integer,
    heattf integer,
    heatts integer,
    heattr integer,
    heattop integer,
    erahf integer,
    erahs integer,
    erahr integer,
    eratf integer,
    erats integer,
    eratr integer,
    eratop integer,
    unitsound integer,
    graphiciconid integer,
    picturelbmid integer,
    void text
);


--
-- Name: temp2; Type: TABLE; Schema: obat; Owner: -; Tablespace: 
--

CREATE TABLE temp2 (
    bmu integer,
    "?column?" text,
    max bigint
);


--
-- Name: units; Type: TABLE; Schema: obat; Owner: -; Tablespace: 
--

CREATE TABLE units (
    nationid integer,
    nationality text,
    obslotno integer,
    name text,
    nation integer,
    classid integer,
    class text,
    cost integer,
    size integer,
    crew integer,
    speed integer,
    swimspd integer,
    moveclassid integer,
    moveclass text,
    radio integer,
    survivability integer,
    liftcap integer,
    loadcost integer,
    startmonthavail integer,
    startyearavail integer,
    lastmonthavail integer,
    lastyearavail integer,
    firecontrol integer,
    stabiliser integer,
    vision integer,
    nrsd integer,
    rateoffire integer,
    ew integer,
    rangefinder integer,
    weapon1 integer,
    wpn1name text,
    wpn1herds integer,
    wpn1aprds integer,
    wpn1heatrds integer,
    wpn1sabotrds integer,
    wpn1sound integer,
    weapon2 integer,
    wpn2name text,
    wpn2herds integer,
    wpn2aprds integer,
    wpn2sound integer,
    weapon3 integer,
    wpn3name text,
    wpn3herds integer,
    wpn3aprds integer,
    wpn3sound integer,
    weapon4 integer,
    wpn4name text,
    wpn4herds integer,
    wpn4aprds integer,
    wpn4sound integer,
    steelhf integer,
    steelhs integer,
    steelhr integer,
    steeltf integer,
    steelts integer,
    steeltr integer,
    steeltop integer,
    heathf integer,
    heaths integer,
    heathr integer,
    heattf integer,
    heatts integer,
    heattr integer,
    heattop integer,
    erahf integer,
    erahs integer,
    erahr integer,
    eratf integer,
    erats integer,
    eratr integer,
    eratop integer,
    unitsound integer,
    graphiciconid integer,
    picturelbmid integer,
    void text,
    seqno integer,
    bmu integer
);


--
-- Name: weapons; Type: TABLE; Schema: obat; Owner: -; Tablespace: 
--

CREATE TABLE weapons (
    nationid integer,
    nationality text,
    obslotno integer,
    name text,
    weaponclass integer,
    weaponsize text,
    warheadsize integer,
    hepen integer,
    hekill integer,
    appen integer,
    apkill integer,
    accuracy integer,
    range integer,
    sabotrange integer,
    sabotpen integer,
    heatpen integer,
    void text
);


--
-- Name: seqno; Type: DEFAULT; Schema: obat; Owner: -
--

ALTER TABLE bmus ALTER COLUMN seqno SET DEFAULT nextval('bmus_seqno_seq'::regclass);


--
-- Data for Name: bmumap; Type: TABLE DATA; Schema: obat; Owner: -
--

COPY bmumap (bmu, type, number, classid, coord) FROM stdin;
2182	3 x Light Helicopter	3	204	(19.186533479473212,41.5)
2311	6 x Rivercraft  -  3 x APC (Wheel)  -  1 x Light APC  -  1 x Heavy Truck  -  1 x Light Support APC  -  1 x FO Vehicle	6	197	(27.413774815425377,43.75)
276	2 x Commandos  -  1 x Militia  -  1 x Rangers	2	83	(31.310889132455351,5.5)
850	9 x Engineer Tank  -  2 x Flame Tank	9	37	(9.2272413359521668,16.75)
1288	1 x Fortifications  -  1 x SP Artillery	1	0	(7.0621778264910704,25)
599	2 x Mech Support Squad  -  2 x Marine Engineers  -  1 x Guerrilla Inf Squad  -  1 x Militia	2	171	(33.908965343808667,11.5)
1083	5 x MBT  -  1 x Engineer Tank	5	59	(3.1650635094610968,21.25)
856	8 x SP Mortar  -  5 x Flame Tank  -  2 x SP Rocket Launcher  -  2 x SP Gun	8	38	(14.423393758658799,16.75)
2285	26 x Attack Helicopter  -  7 x Light Attack Helicopter  -  1 x Helicopter	26	203	(4.897114317029974,43.75)
756	1 x LMG Section	1	65	(31.310889132455351,14.5)
2091	31 x Fighter-Bomber  -  1 x COIN Fighter Plane	31	44	(9.6602540378443873,40)
1231	1 x Flak	1	8	(26.98076211353316,23.5)
151	10 x Infantry  -  4 x Mechanised Infantry  -  2 x Guards Infantry  -  2 x Motorised Inf Section  -  2 x Marine Support Squad  -  2 x Heavy Infantry  -  1 x Medium Mech Infantry  -  1 x Marines  -  1 x Rangers  -  1 x Ski Troops  -  1 x Reserve Infantry  -  1 x Engineer Support Squad  -  1 x Paratroops  -  1 x Militia	10	1	(27.413774815425377,3.25)
2247	2 x Fighter-Bomber	2	44	(6.196152422706632,43)
921	50 x MBT  -  12 x Mine Clearing Tank  -  8 x CS MBT  -  8 x Medium Tank  -  2 x Main Battle Tank  -  1 x Close Support Tank  -  1 x Obsolete Tank	50	59	(1.4330127018922194,18.25)
2020	5 x Fighter-Bomber	5	44	(17.454482671904334,38.5)
253	2 x O/M Rocket Arty	2	31	(11.392304845413264,5.5)
2241	38 x Attack Helicopter  -  5 x Light Attack Helicopter	38	203	(1,43)
119	3 x Engineer  -  2 x Para Engineers	3	20	(33.908965343808667,2.5)
270	2 x Partisan Band  -  2 x Irregulars  -  1 x Commando Engineers  -  1 x COIN Infantry Squad  -  1 x Hvy Bicycle Squad  -  1 x Cavalry  -  1 x Reserve Infantry	2	78	(26.114736709748719,5.5)
1269	2 x Para Hy Inf-ATGM  -  1 x Mortar(Sub Type D)	2	213	(25.681724007856502,24.25)
1820	1 x Fighter-Bomber	1	44	(17.887495373796554,34.75)
437	4 x Mercenaries  -  3 x Heavy Mech Infantry  -  1 x Para light Infantry  -  1 x Motorised Inf Section  -  1 x Paratroops  -  1 x Infantry  -  1 x Militia  -  1 x Commandos  -  1 x Marines  -  1 x Heavy Ski Troops  -  1 x Partisan Scouts	4	218	(32.176914536239792,8.5)
1283	17 x MBT  -  10 x Medium Tank  -  2 x Cavalry Tank  -  1 x CS Infantry Tank  -  1 x Close Support Tank  -  1 x CS MBT	17	59	(2.7320508075688772,25)
2055	19 x Level Bomber	19	62	(13.55736835487436,39.25)
101	38 x O/M Field Artillery	38	10	(18.320508075688775,2.5)
339	70 x Fortifications	70	0	(16.588457268119896,7)
2148	15 x Heavy Amphibian  -  2 x Hovercraft  -  1 x Mine Clearing Tank  -  1 x LCG  -  1 x FO Vehicle  -  1 x Engineer Tank  -  1 x Light Amphibian	15	34	(24.815698604072061,40.75)
2310	19 x Light Amphibian  -  13 x Heavy Amphibian  -  1 x Fortifications	19	33	(26.54774941164094,43.75)
82	37 x Fortifications	37	0	(1.8660254037844386,2.5)
2397	41 x Air OP Aircraft	41	50	(32.609927238132009,45.25)
25	1 x Marines  -  1 x Commando Engineers	1	145	(21.784609690826528,1)
1048	1 x CS Infantry Tank	1	106	(7.0621778264910704,20.5)
1465	1 x Marine Infantry AT  -  1 x Inf-ATGM Team  -  1 x Heavy Inf-ATGM	1	244	(21.784609690826528,28)
1253	16 x SP Gun  -  9 x Assault Gun  -  9 x Cavalry Tank  -  2 x Close Support Tank  -  1 x Infantry Tank  -  1 x Light Cavalry Tank	16	39	(11.825317547305483,24.25)
2169		0	\N	\N
359	1 x Ski Troops  -  1 x Paratroops  -  1 x Fortifications  -  1 x Infantry  -  1 x Bicycle Squad	1	1	(33.908965343808667,7)
2389	11 x Helicopter	11	53	(25.681724007856502,45.25)
1060	1 x SP Artillery	1	21	(17.454482671904334,20.5)
1879	20 x Scout Vehicle  -  8 x Utility Vehicle  -  4 x Light Support APC  -  2 x Light APC  -  1 x Armoured Car	20	32	(33.908965343808667,35.5)
2156	114 x Medium Truck  -  19 x Artillery Prime Mover  -  13 x Utility Vehicle  -  4 x APC (Wheel)  -  1 x Light Truck	114	27	(31.743901834347572,40.75)
26	9 x Marines  -  8 x Commandos  -  6 x Rangers  -  4 x Heavy Infantry  -  3 x Paratroops  -  3 x Para Medium Infantry  -  3 x Infantry  -  2 x Para Engineers  -  2 x Marine Support Squad  -  2 x Commando Engineers  -  2 x Medium Infantry  -  2 x Light Infantry  -  2 x Engineer Support Squad  -  1 x Marine Light Infantry  -  1 x Para light Infantry  -  1 x Motorised Inf Section  -  1 x Reserve Infantry  -  1 x COIN Infantry Squad  -  1 x Ski Troops  -  1 x Guards Squad	9	110	(22.650635094610966,1)
2328	1 x SP ATGM	1	19	(7.0621778264910704,44.5)
1229	8 x Mortar(Sub Type D)  -  1 x Howitzer  -  1 x Light SP Mortar  -  1 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type B)	8	255	(25.248711305964282,23.5)
1662	7 x Fortifications	7	0	(19.619546181365433,31.75)
136	1 x O/M Heavy Artillery	1	156	(14.423393758658799,3.25)
2150	30 x Heavy Amphibian  -  26 x Light Amphibian  -  8 x Rivercraft  -  4 x LCG  -  3 x Hovercraft  -  2 x Patrol Boat	30	34	(26.54774941164094,40.75)
196	1 x Commando Support	1	84	(31.310889132455351,4)
218	2 x O/M Heavy Artillery  -  1 x O/M Rocket Arty	2	156	(16.155444566227676,4.75)
1403	1 x MBT	1	59	(3.1650635094610968,27.25)
1864	18 x SP Flak  -  1 x Light SPAA Vehicle  -  1 x Assault Gun  -  1 x FO Vehicle	18	22	(20.918584287042091,35.5)
1945	5 x CS Infantry Tank  -  4 x SP Flak  -  1 x Light Support APC  -  1 x Gun APC (Tracked)  -  1 x Airborne Lt Tank  -  1 x MRV APC	5	106	(21.784609690826528,37)
969	25 x Engineer Tank  -  1 x Mine Clearing Tank	25	37	(7.9282032302755088,19)
1726	1 x Gunship Aircraft	1	215	(5.7631397208144124,33.25)
2261	12 x Light Helicopter  -  7 x Helicopter  -  1 x Attack Helicopter	12	204	(18.320508075688775,43)
1171	29 x Light Tank  -  10 x MBT  -  1 x Cavalry Tank  -  1 x Armoured Car  -  1 x Obsolete Tank	29	12	(10.093266739736606,22.75)
2228	5 x Landing Barge  -  1 x Fortifications	5	41	(24.815698604072061,42.25)
230	9 x Infantry  -  4 x Motorised Inf Section  -  4 x Mechanised Infantry  -  3 x Paratroops  -  3 x Ski Troops  -  3 x Rangers  -  2 x Militia  -  1 x Guards Squad  -  1 x Irregulars  -  1 x Guards Engineers  -  1 x Paratroop Support  -  1 x Reserve Infantry  -  1 x Commando Support  -  1 x Heavy Infantry  -  1 x Light Mech Infantry  -  1 x Medium Mech Infantry	9	1	(26.54774941164094,4.75)
1587	1 x Light SP ATGM	1	129	(23.949673200287624,30.25)
1578	21 x Infantry SAM  -  1 x SP SAM	21	29	(16.155444566227676,30.25)
414	4 x SP Mortar  -  1 x Attack Helicopter	4	38	(12.258330249197702,8.5)
785	10 x O/M Field Artillery	10	10	(22.217622392718749,15.25)
1116	4 x Irregulars  -  3 x Motorcycle(Heavy Inf)  -  1 x Motorcycle(Light Inf)  -  1 x Patrol	4	75	(31.743901834347572,21.25)
1920	4 x Scout Vehicle  -  4 x Motorcycle  -  3 x Light Support APC  -  2 x SP Artillery  -  1 x Improvised APC  -  1 x Motorcycle(Heavy Inf)  -  1 x SP Mortar  -  1 x Light APC  -  1 x CS Infantry Tank  -  1 x SP Flak	4	32	(35.208003449485325,36.25)
2206	18 x Fighter-Bomber	18	44	(5.7631397208144124,42.25)
449	1 x Gun APC (Wheeled)	1	126	(8.3612159321677293,9.25)
667	1 x Para Mortar Team	1	173	(23.516660498395403,13)
1146	1 x Field Gun	1	9	(22.650635094610966,22)
1487	20 x Armoured Car  -  11 x Light Tank  -  5 x Scout Vehicle  -  4 x Light Cavalry Tank  -  3 x Light Support APC  -  2 x MBT  -  1 x Cavalry Tank  -  1 x Close Support Tank  -  1 x Heavy Armoured Car  -  1 x FO Vehicle	20	11	(6.6291651245988508,28.75)
899	1 x SP Rocket Launcher  -  1 x Rocket Launcher	1	151	(16.588457268119896,17.5)
1108	19 x Field Gun  -  2 x Howitzer  -  1 x Pack Howitzer	19	9	(24.815698604072061,21.25)
1120	1 x Commando Scouts	1	88	(35.208003449485325,21.25)
1600	51 x Art Observer  -  13 x Para Forward Observer  -  9 x FO Vehicle  -  3 x Marine Forward Observer  -  2 x Flak  -  1 x Air OP Aircraft	51	63	(35.208003449485325,30.25)
786	4 x O/M Field Artillery  -  1 x O/M Heavy Artillery	4	10	(23.083647796503186,15.25)
1665	2 x Heavy Amphibian	2	34	(22.217622392718749,31.75)
149	3 x Infantry  -  3 x Guards Squad  -  2 x Ski Troops  -  2 x Medium Mech Infantry  -  1 x Rifle Squad  -  1 x Guerrilla Lt Inf Squad  -  1 x Infantry SAM  -  1 x Militia  -  1 x Medium Guards Squad  -  1 x Motorised Inf Section  -  1 x Commando Scouts  -  1 x Light Mech Infantry	3	1	(25.681724007856502,3.25)
2050	38 x Fighter-Bomber  -  2 x COIN Fighter Plane	38	44	(9.2272413359521668,39.25)
307	2 x Partisans  -  1 x Heavy Guards Squad  -  1 x Ski Troops  -  1 x Reserve Infantry  -  1 x Light Infantry	2	76	(23.949673200287624,6.25)
1289	1 x Fortifications	1	0	(7.9282032302755088,25)
2219	1 x Mine Clearing Tank	1	36	(17.021469970012117,42.25)
1009	3 x Engineer Tank  -  1 x Mine Clearing Tank  -  1 x Fortifications	3	37	(8.3612159321677293,19.75)
1295	1 x Fortifications	1	0	(13.124355652982141,25)
1582	4 x Heavy Inf-ATGM  -  2 x Inf-ATGM Team	4	212	(19.619546181365433,30.25)
2255	31 x Fighter-Bomber  -  1 x COIN Fighter Plane	31	44	(13.124355652982141,43)
1897	30 x Fighter-Bomber  -  1 x COIN Fighter Plane	30	44	(15.289419162443238,36.25)
1100	10 x Field Gun	10	9	(17.887495373796554,21.25)
1408	1 x Armoured Car	1	11	(7.49519052838329,27.25)
1065	3 x Field Gun  -  1 x Howitzer	3	9	(21.784609690826528,20.5)
252	2 x Patrol Boat	2	199	(10.526279441628825,5.5)
1742	1 x SP ATGM  -  1 x Fortifications	1	0	(19.619546181365433,33.25)
1871	3 x FO Vehicle  -  1 x Scout Vehicle  -  1 x Light APC  -  1 x Ammo Carrier  -  1 x Armoured Car	3	57	(26.98076211353316,35.5)
537	13 x Heavy Mortar  -  2 x Mortar  -  1 x Mortar(Sub Type C)	13	152	(15.289419162443238,10.75)
839	10 x Scout  -  4 x Ski Scouts  -  2 x Militia  -  2 x Commandos  -  1 x Paratroop Scouts  -  1 x Infantry  -  1 x Guerrilla Lt Inf Squad  -  1 x Mech Scouts	10	58	(33.908965343808667,16)
1829	1 x SP Mortar	1	38	(25.681724007856502,34.75)
1984	9 x Light APC  -  9 x FO Vehicle  -  1 x MRV IFV  -  1 x Light Support APC	9	121	(21.351596988934308,37.75)
2300	9 x Light Helicopter  -  4 x Attack Helicopter  -  4 x Helicopter  -  3 x Light Attack Helicopter  -  2 x COIN Armed Helo	9	204	(17.887495373796554,43.75)
1914	1 x Scout Vehicle	1	32	(30.011851026778693,36.25)
1293	1 x Patrol Boat  -  1 x Assault Gun  -  1 x APC (Wheel)	1	199	(11.392304845413264,25)
1473	1 x Ski Inf-AT	1	165	(28.712812921102035,28)
2293	2 x SEAD Aircraft  -  1 x Fighter-Bomber	2	214	(11.825317547305483,43.75)
974	6 x SP Artillery	6	21	(12.258330249197702,19)
178	48 x O/M Heavy Artillery  -  8 x O/M Medium Artillery  -  4 x O/M Field Artillery	48	156	(15.722431864335457,4)
2165	3 x Fighter-Bomber  -  1 x COIN Fighter Plane	3	44	(4.4641016151377544,41.5)
1757	7 x Sniper  -  4 x Commando Sniper  -  3 x Para Sniper  -  2 x Marine Sniper  -  1 x Guerrilla Sniper	7	45	(32.609927238132009,33.25)
1320	5 x HQ	5	55	(34.774990747593108,25)
241	12 x Fortifications	12	0	(1,5.5)
357	3 x Paratroops  -  2 x Reserve Infantry  -  2 x Engineer Support Squad  -  2 x Heavy Infantry  -  2 x Infantry  -  1 x Marine Support Squad  -  1 x Mechanised Infantry	3	96	(32.176914536239792,7)
812	3 x SP Artillery	3	21	(10.526279441628825,16)
958	2 x Para Engineers  -  1 x Engineer	2	141	(33.47595264191645,18.25)
1926	4 x Fighter-Bomber	4	44	(5.3301270189221936,37)
17	51 x O/M Medium Artillery  -  27 x O/M Heavy Artillery  -  12 x O/M Field Artillery	51	155	(14.856406460551018,1)
1021	2 x SP Artillery  -  1 x SP Howitzer	2	21	(18.753520777580992,19.75)
1768	40 x Fighter-Bomber  -  1 x COIN Fighter Plane	40	44	(7.0621778264910704,34)
980	12 x SP Artillery  -  1 x Light SP Mortar  -  1 x Assault Gun	12	21	(17.454482671904334,19)
2304	3 x Helicopter  -  2 x Heavy Helicopter	3	53	(21.351596988934308,43.75)
861	2 x SP Rocket Launcher  -  1 x Rocket Launcher	2	137	(18.753520777580992,16.75)
1749	1 x Light SP ATGM	1	129	(25.681724007856502,33.25)
33	29 x Infantry  -  18 x Mechanised Infantry  -  14 x Heavy Infantry  -  12 x Rangers  -  9 x Paratroops  -  8 x Marines  -  8 x Motorised Inf Section  -  7 x Ski Troops  -  5 x Medium Infantry  -  4 x Commandos  -  4 x Heavy Mech Infantry  -  4 x Legionnaires  -  4 x Ranger Lt Infantry Squad  -  3 x Marine Support Squad  -  3 x Guards Infantry  -  3 x Heavy Ski Troops  -  2 x Light Guards Squad  -  2 x Airmobile Rifle Squad  -  2 x Light Mech Infantry  -  2 x Medium Mech Infantry  -  2 x Guards Squad  -  2 x Ranger Support Squad  -  1 x Para Engineers  -  1 x Engineer  -  1 x Rifle Squad  -  1 x Native Troops  -  1 x Mercenaries  -  1 x Ranger Hvy Infantry Squad  -  1 x Engineer Support Squad  -  1 x Reserve Infantry  -  1 x Paratroop Support  -  1 x Militia	29	1	(28.712812921102035,1)
1003	1 x Medium Tank	1	103	(3.1650635094610968,19.75)
1188	3 x Pack Howitzer  -  1 x Field Gun	3	196	(24.815698604072061,22.75)
816	6 x SP Mortar	6	38	(13.99038105676658,16)
1333	40 x Amphibian Tank  -  9 x MBT  -  6 x Light Tank  -  4 x SP Artillery  -  3 x CS MBT  -  1 x Medium Tank	40	35	(11.825317547305483,25.75)
900	1 x COIN Fighter Plane  -  1 x Fighter-Bomber  -  1 x SP Mortar	1	223	(17.454482671904334,17.5)
1079	6 x Scout  -  5 x Paratroop Scouts  -  2 x Irregulars  -  2 x Marine Heavy Infantry  -  1 x Guerrilla Scout  -  1 x Commando Scouts  -  1 x Partisans	6	58	(33.908965343808667,20.5)
1783	13 x SP ATGM  -  2 x Light SP ATGM	13	19	(20.05255888325765,34)
109	5 x Infantry  -  3 x Light Mech Infantry  -  3 x Native Troops  -  1 x Paratroops  -  1 x LMG Section  -  1 x Guerrilla Lt Inf Squad  -  1 x Light Infantry  -  1 x Guerrilla Inf Squad  -  1 x Para light Infantry	5	1	(25.248711305964282,2.5)
1740	7 x Fighter-Bomber	7	44	(17.887495373796554,33.25)
1927	2 x Fighter-Bomber	2	44	(6.196152422706632,37)
914	1 x Mortar(Sub Type A)	1	200	(29.578838324886476,17.5)
524	9 x Heavy Tank  -  2 x MBT  -  1 x CS MBT	9	14	(4.0310889132455356,10.75)
1129	2 x MBT  -  2 x Medium Tank  -  1 x CS MBT	2	59	(7.9282032302755088,22)
1489	1 x SP Gun	1	39	(8.3612159321677293,28.75)
644	18 x MBT  -  8 x Medium Tank  -  4 x Obsolete Tank  -  2 x Close Support Tank  -  2 x SP Artillery  -  1 x CS MBT	18	59	(3.598076211353316,13)
1987	4 x Scout Vehicle  -  1 x Gun APC (Wheeled)  -  1 x MRV Light IFV	4	32	(23.949673200287624,37.75)
2396	126 x Air OP Aircraft  -  1 x FO Vehicle	126	50	(31.743901834347572,45.25)
763	4 x MBT  -  1 x Infantry Tank	4	59	(3.1650635094610968,15.25)
296	8 x O/M Rocket Arty	8	31	(14.423393758658799,6.25)
686	1 x Heavy MRV APC  -  1 x MBT	1	220	(5.7631397208144124,13.75)
2168	4 x Fighter-Bomber  -  1 x Level Bomber	4	44	(7.0621778264910704,41.5)
282	14 x Fortifications	14	0	(2.299038105676658,6.25)
10	24 x O/M Heavy Artillery  -  22 x O/M Medium Artillery  -  9 x O/M Field Artillery	24	156	(8.794228634059948,1)
1117	6 x SMG Section  -  4 x Scout  -  2 x Guerrilla Lt Inf Squad  -  2 x Guerrilla Scout  -  2 x Light Infantry  -  2 x Irregulars  -  2 x Patrol  -  1 x Marine Light Infantry  -  1 x Para Mortar Team  -  1 x Commandos  -  1 x Mech Scouts  -  1 x Partisans  -  1 x Light Militia	6	66	(32.609927238132009,21.25)
2115	1 x Artillery Prime Mover	1	180	(30.444863728670914,40)
2376	81 x Area SAM	81	16	(14.423393758658799,45.25)
1847	7 x Fighter-Bomber  -  1 x COIN Fighter Plane	7	44	(6.196152422706632,35.5)
2167	8 x Fighter-Bomber	8	44	(6.196152422706632,41.5)
146	3 x Guerrilla Inf Support  -  3 x Marines  -  2 x Marine Light Infantry  -  2 x Heavy Militia  -  1 x Mechanised Infantry  -  1 x Partisan Support  -  1 x Mech Support Squad  -  1 x Reserve Infantry  -  1 x Guerrilla Lt Inf Squad  -  1 x Paratroops  -  1 x Infantry  -  1 x Militia  -  1 x Ranger Lt Infantry Squad  -  1 x Rangers  -  1 x Native Troops  -  1 x Police	3	233	(23.083647796503186,3.25)
752	5 x Machine Gun Section  -  3 x MG Unit  -  1 x MG Section  -  1 x Heavy MG  -  1 x Flak  -  1 x para MG Section	5	4	(27.846787517317598,14.5)
98	6 x O/M Heavy Artillery  -  3 x O/M Medium Artillery  -  1 x O/M Field Artillery	6	156	(15.722431864335457,2.5)
193	1 x Patrol  -  1 x Cavalry Scouts	1	82	(28.712812921102035,4)
1364	3 x Light Tank  -  1 x Cavalry Tank  -  1 x MBT	3	12	(3.598076211353316,26.5)
1389	1 x Inf-AT	1	2	(25.248711305964282,26.5)
655	2 x SP Rocket Launcher  -  1 x Heavy Mortar	2	137	(13.124355652982141,13)
2049	3 x Fighter-Bomber	3	44	(8.3612159321677293,39.25)
2021	3 x Fighter-Bomber	3	44	(18.320508075688775,38.5)
243	16 x Fortifications	16	0	(2.7320508075688772,5.5)
617	27 x Heavy Mortar  -  4 x Mortar  -  2 x Mortar(Sub Type D)  -  2 x Mortar(Sub Type B)	27	152	(15.289419162443238,12.25)
674	2 x Reserve Infantry  -  1 x Medium Mech Infantry	2	160	(29.578838324886476,13)
167	45 x Fortifications	45	0	(6.196152422706632,4)
1416	10 x SP Gun  -  8 x Assault Gun  -  1 x Scout Vehicle	10	39	(14.423393758658799,27.25)
1569	1 x Light Support APC	1	122	(8.3612159321677293,30.25)
1911	21 x Ammo Carrier  -  19 x Armoured Car  -  19 x FO Vehicle  -  9 x Scout Vehicle  -  2 x Gun APC (Wheeled)  -  1 x MBT  -  1 x Light Tank	21	56	(27.413774815425377,36.25)
672	7 x Rifle Squad  -  4 x Irregulars  -  4 x Reserve Infantry  -  3 x Patrol  -  3 x Militia  -  3 x Infantry  -  3 x Light Infantry  -  2 x Legionnaires  -  2 x Police  -  2 x Motorised Inf Section  -  2 x Medium Infantry  -  1 x Partisan Band  -  1 x Para light Infantry  -  1 x Marine Scout  -  1 x Light Militia  -  1 x Guards Infantry  -  1 x Engineer Support Squad	7	68	(27.846787517317598,13)
1275	3 x Motorcycle(Light Inf)  -  1 x Light Militia  -  1 x Motorcycle	3	187	(30.877876430563134,24.25)
1723	3 x FO Vehicle  -  1 x Scout Vehicle  -  1 x SP SAM	3	57	(3.1650635094610968,33.25)
1717	61 x Sniper  -  9 x Para Sniper  -  3 x Ranger Sniper  -  1 x Ski Sniper	61	45	(32.176914536239792,32.5)
813	5 x SP Mortar	5	38	(11.392304845413264,16)
2061	1 x Fighter-Bomber	1	44	(18.753520777580992,39.25)
771	13 x Armoured Car  -  3 x Light Tank  -  2 x Heavy Armoured Car  -  1 x Scout Vehicle  -  1 x MBT	13	11	(10.093266739736606,15.25)
478	11 x Infantry  -  5 x Light Infantry  -  4 x Reserve Infantry  -  4 x Paratroops  -  4 x Rifle Squad  -  3 x Motorised Inf Section  -  3 x Mech Support Squad  -  2 x Light Mech Infantry  -  2 x Mechanised Infantry  -  1 x Airmobile Spt Section  -  1 x Light Commandos  -  1 x Militia  -  1 x Mech Scouts  -  1 x Heavy Militia  -  1 x Engineer Support Squad  -  1 x Light Militia  -  1 x Marines	11	1	(33.47595264191645,9.25)
1736	14 x Fighter-Bomber	14	44	(14.423393758658799,33.25)
1708	29 x Wheeled SP-ATGM  -  18 x Light SP ATGM  -  15 x SP ATGM  -  1 x SP Gun	29	52	(24.382685902179844,32.5)
1488	3 x APC (Track)  -  2 x Light Support APC  -  1 x Scout Vehicle	3	25	(7.49519052838329,28.75)
2092	16 x Fighter-Bomber	16	44	(10.526279441628825,40)
956	3 x Militia  -  3 x Para Mortar Team  -  3 x Police  -  1 x Para light Infantry  -  1 x Heavy Commandos  -  1 x Guards Infantry  -  1 x Light Infantry  -  1 x Guerrilla Lt Inf Squad  -  1 x Paratroop Support	3	173	(31.743901834347572,18.25)
1280	1 x Art Observer  -  1 x Para Forward Observer	1	63	(35.208003449485325,24.25)
1366	4 x Light Tank  -  2 x Close Support Tank  -  1 x SP Gun  -  1 x MBT  -  1 x Armoured Car  -  1 x Light Cavalry Tank	4	12	(5.3301270189221936,26.5)
145	12 x Rangers  -  9 x Infantry  -  6 x Commandos  -  6 x Mechanised Infantry  -  5 x Marine Heavy Infantry  -  5 x Marines  -  4 x Motorised Inf Section  -  4 x Paratroops  -  3 x Police  -  3 x Light Commandos  -  3 x Mercenaries  -  2 x Reserve Infantry  -  2 x Partisan Band  -  2 x Mech Support Squad  -  2 x Light Mech Infantry  -  2 x Light Guards Squad  -  1 x Ranger Pioneer  -  1 x Ranger Scout  -  1 x Patrol  -  1 x Engineer Support Squad  -  1 x Ski Troops  -  1 x Heavy Infantry  -  1 x Ranger Lt Infantry Squad	12	111	(22.217622392718749,3.25)
1715	94 x Sniper  -  21 x Para Sniper  -  8 x Commando Sniper  -  8 x Ski Sniper  -  6 x Guerrilla Sniper  -  4 x Ranger Sniper  -  2 x Marine Sniper	94	45	(30.444863728670914,32.5)
2038	2 x Utility Vehicle  -  2 x APC (Wheel)  -  1 x Scout Vehicle  -  1 x Artillery Prime Mover  -  1 x FO Vehicle	2	26	(33.042939940024233,38.5)
104	2 x Mech Support Squad  -  1 x Marines  -  1 x Para light Infantry  -  1 x Light Infantry	2	73	(20.918584287042091,2.5)
629	5 x Para Mortar Team	5	173	(25.681724007856502,12.25)
163	10 x Fortifications	10	0	(2.7320508075688772,4)
413	2 x Scout Vehicle  -  2 x SP Flak  -  2 x Armoured Car	2	32	(11.392304845413264,8.5)
1081	6 x MBT	6	59	(1.4330127018922194,21.25)
1858	17 x Fighter-Bomber  -  2 x COIN Fighter Plane	17	44	(15.722431864335457,35.5)
1134	1 x SP Artillery	1	21	(12.258330249197702,22)
71	1 x Paratroop Support	1	97	(27.413774815425377,1.75)
533	2 x Flame Tank  -  1 x SP Howitzer	2	17	(11.825317547305483,10.75)
588	2 x Light Infantry  -  1 x Guerrilla Lt Inf Squad	2	51	(24.382685902179844,11.5)
1606	7 x APC (Wheel)  -  2 x Light APC  -  2 x Scout Vehicle  -  2 x Light Support APC  -  1 x Armoured Car  -  1 x Heavy APC  -  1 x APC	7	23	(5.3301270189221936,31)
1026	10 x Field Gun  -  2 x Pack Howitzer  -  1 x Howitzer  -  1 x Airborne Field Howitzer	10	9	(23.083647796503186,19.75)
1153	4 x Flak  -  1 x AA Truck	4	8	(28.712812921102035,22)
624	12 x Mortar  -  2 x Mortar(Sub Type A)  -  2 x Mortar(Sub Type B)	12	5	(21.351596988934308,12.25)
2390	2 x Paratroop Transport  -  2 x Utility Vehicle	2	26	(26.54774941164094,45.25)
186	8 x Mechanised Infantry  -  5 x Marines  -  4 x Infantry  -  3 x Reserve Infantry  -  3 x Police  -  3 x Airmobile Rifle Squad  -  2 x Rangers  -  2 x Marine Light Infantry  -  1 x Guerrilla Inf Support  -  1 x Rifle Squad  -  1 x Paratroops  -  1 x Native Troops  -  1 x Medium Infantry  -  1 x Marine Heavy Infantry  -  1 x Para Medium Infantry  -  1 x Light Commandos  -  1 x Partisan Support  -  1 x Heavy Guards Squad  -  1 x Partisan Band  -  1 x Ski Troops	8	69	(22.650635094610966,4)
626	2 x Mortar  -  1 x Light Mortar  -  1 x Ranger Support Squad	2	5	(23.083647796503186,12.25)
823	3 x Rocket Launcher  -  1 x O/M Rocket Arty	3	151	(20.05255888325765,16)
1528	2 x Armoured Car	2	11	(7.0621778264910704,29.5)
480	10 x Infantry  -  8 x LMG Section  -  5 x Reserve Infantry  -  5 x Motorised Inf Section  -  4 x Light Infantry  -  3 x Guerrilla Inf Squad  -  3 x Mechanised Infantry  -  2 x Partisan Support  -  2 x Ranger Support Squad  -  2 x Rangers  -  1 x Guerrilla Hvy Inf Squad  -  1 x Partisans  -  1 x Bicycle Squad  -  1 x Guards Engineers  -  1 x Ski Troops  -  1 x Irregulars  -  1 x Medium Commandos  -  1 x Engineer Support Squad  -  1 x Rifle Squad  -  1 x Militia	10	1	(35.208003449485325,9.25)
280	4 x Commandos  -  2 x Engineer Support Squad  -  1 x Para light Infantry  -  1 x Paratroop Scouts	4	83	(34.774990747593108,5.5)
727	6 x APC (Track)  -  5 x Airborne APC  -  1 x MRV IFV	6	25	(6.196152422706632,14.5)
886	3 x MRV APC	3	217	(5.3301270189221936,17.5)
1374	7 x SP Gun  -  5 x Assault Gun  -  2 x MBT  -  1 x Obsolete Tank	7	39	(12.258330249197702,26.5)
1527	1 x Scout Vehicle  -  1 x Heavy Armoured Car  -  1 x Gun APC (Tracked)	1	32	(6.196152422706632,29.5)
297	2 x O/M Rocket Arty	2	31	(15.289419162443238,6.25)
1981	54 x Fighter-Bomber  -  8 x COIN Fighter Plane	54	44	(18.753520777580992,37.75)
1164	4 x CS MBT  -  2 x Mine Clearing Tank  -  1 x Medium Tank	4	104	(4.0310889132455356,22.75)
314	1 x Marines  -  1 x Light Commandos  -  1 x Paratroops	1	85	(30.011851026778693,6.25)
400	3 x Paratroops  -  2 x Paratroop Support  -  1 x Marines  -  1 x Mechanised Infantry  -  1 x Fortifications  -  1 x Commandos	3	96	(35.208003449485325,7.75)
689	1 x Airborne APC  -  1 x Assault Gun  -  1 x Armoured Car	1	11	(8.3612159321677293,13.75)
893	9 x SP Artillery  -  2 x Amphibian Tank  -  2 x SP Howitzer  -  1 x Light SP Mortar	9	21	(11.392304845413264,17.5)
1804	10 x SP Flak  -  5 x Flak  -  1 x Gunship Aircraft	10	22	(4.0310889132455356,34.75)
1902	18 x Fighter-Bomber  -  14 x Air OP Aircraft  -  9 x Level Bomber  -  1 x Paratroop Transport	18	44	(19.619546181365433,36.25)
2363	3 x Attack Helicopter	3	203	(3.1650635094610968,45.25)
1401	1 x Heavy Tank  -  1 x Light Cavalry Tank	1	14	(1.4330127018922194,27.25)
210	1 x Patrol Boat  -  1 x Landing Barge	1	199	(9.2272413359521668,4.75)
473	7 x Marines  -  5 x Mechanised Infantry  -  5 x Infantry  -  3 x Motorised Inf Section  -  3 x Paratroops  -  2 x Rangers  -  2 x Patrol  -  1 x Light Infantry  -  1 x COIN Infantry Squad  -  1 x Heavy Infantry  -  1 x Commandos  -  1 x Medium Infantry	7	110	(29.145825622994256,9.25)
1000	12 x Medium Mech Infantry  -  8 x Scout  -  7 x Ski Troops  -  6 x Marine Support Squad  -  5 x Commando Scouts  -  5 x Medium Infantry  -  4 x Paratroop Support  -  3 x Guerrilla Inf Support  -  3 x Infantry  -  3 x Guerrilla Scout  -  3 x Para light Infantry  -  3 x Ranger Support Squad  -  3 x Mech Scouts  -  3 x Mech Support Squad  -  2 x Heavy Ski Troops  -  2 x Guerrilla Inf Squad  -  2 x Reserve Infantry  -  2 x Medium Commandos  -  2 x Fortifications  -  1 x Guerrilla Hvy Inf Squad  -  1 x Ski SMG Squad  -  1 x Light Mech Infantry  -  1 x Partisans  -  1 x Heavy Infantry  -  1 x Light Commandos  -  1 x Marine Light Infantry	12	71	(34.774990747593108,19)
2270	1 x Heavy Amphibian	1	34	(26.114736709748719,43)
819	70 x SP Rocket Launcher	70	137	(16.588457268119896,16)
47	5 x Fortifications	5	0	(6.6291651245988508,1.75)
2217	1 x Level Bomber	1	62	(15.289419162443238,42.25)
515	1 x Medium Infantry	1	64	(30.444863728670914,10)
2333	2 x Fighter-Bomber  -  2 x SP SAM  -  1 x COIN Fighter Plane	2	30	(11.392304845413264,44.5)
1958	2 x Light APC  -  2 x Light Support APC  -  1 x Improvised APC	2	121	(33.042939940024233,37)
2184	2 x Heavy Amphibian  -  1 x Patrol Boat  -  1 x Hovercraft  -  1 x APC (Track)	2	34	(20.918584287042091,41.5)
211	7 x Patrol Boat	7	199	(10.093266739736606,4.75)
1252	4 x SP Gun	4	39	(10.959292143521045,24.25)
2186	39 x Landing Barge  -  7 x LCG	39	41	(22.650635094610966,41.5)
970	2 x Engineer Tank	2	37	(8.794228634059948,19)
1963	1 x Fighter-Bomber	1	44	(3.1650635094610968,37.75)
15	8 x O/M Medium Artillery  -  3 x O/M Field Artillery  -  2 x O/M Heavy Artillery	8	155	(13.124355652982141,1)
77	11 x Commando Scouts  -  7 x Commando Engineers  -  6 x Commandos  -  6 x Ranger Pioneer  -  4 x Paratroop Scouts  -  3 x Light Commandos  -  3 x Paratroops  -  2 x Inf-AT  -  2 x Engineer Support Squad  -  2 x Guerrilla Hvy Inf Squad  -  2 x Para Medium Infantry  -  1 x Marine Infantry AT  -  1 x Para Engineers	11	88	(32.609927238132009,1.75)
125	4 x Fortifications	4	0	(4.897114317029974,3.25)
1759	64 x Sniper  -  11 x Para Sniper  -  10 x Commando Sniper  -  3 x Marine Sniper  -  2 x Ski Sniper  -  2 x Ranger Sniper  -  1 x Guerrilla Sniper	64	45	(34.341978045700891,33.25)
140	7 x O/M Field Artillery  -  2 x O/M Medium Artillery	7	10	(17.887495373796554,3.25)
153	17 x Infantry  -  7 x Native Troops  -  7 x Mechanised Infantry  -  7 x Reserve Infantry  -  4 x Militia  -  4 x Irregulars  -  4 x Medium Mech Infantry  -  4 x Marines  -  3 x Guerrilla Inf Squad  -  3 x Rangers  -  3 x Heavy Militia  -  3 x Motorised Inf Section  -  3 x Heavy Infantry  -  2 x Light Infantry  -  2 x Partisan Band  -  2 x Heavy Commandos  -  1 x Commandos  -  1 x Paratroops  -  1 x Rifle Squad  -  1 x Partisans  -  1 x Ski Troops  -  1 x Rifle Section  -  1 x Medium Infantry  -  1 x Police	17	1	(29.145825622994256,3.25)
1632	3 x SP Gun  -  2 x Assault Gun	3	39	(27.846787517317598,31)
1747	3 x SP ATGM  -  2 x Cavalry Tank  -  2 x Wheeled SP-ATGM  -  1 x Light SP ATGM	3	19	(23.949673200287624,33.25)
2004	24 x SEAD Aircraft  -  5 x Fighter-Bomber	24	214	(3.598076211353316,38.5)
806	4 x APC (Track)  -  4 x Heavy APC	4	120	(5.3301270189221936,16)
1201	3 x Engineer Tank  -  1 x Infantry Tank  -  1 x MBT  -  1 x Obsolete Tank	3	37	(1,23.5)
579	2 x Heavy Mortar  -  1 x Mortar	2	152	(16.588457268119896,11.5)
1628	6 x SP ATGM	6	19	(24.382685902179844,31)
1734	1 x Fighter-Bomber	1	44	(12.691342951089922,33.25)
946	5 x Mortar(Sub Type A)  -  4 x Mortar(Sub Type C)  -  2 x Heavy Mortar  -  2 x Mortar(Sub Type B)	5	200	(23.083647796503186,18.25)
2028	18 x APC (Wheel)  -  4 x Light Support APC  -  4 x Light APC  -  2 x APC  -  2 x Utility Vehicle  -  1 x Heavy APC  -  1 x APC (Track)	18	23	(24.382685902179844,38.5)
123	24 x Fortifications	24	0	(3.1650635094610968,3.25)
2183	3 x Ammo Carrier  -  2 x FO Vehicle	3	56	(20.05255888325765,41.5)
1463	5 x Fortifications	5	0	(20.05255888325765,28)
1647	24 x Armoured Car  -  17 x Scout Vehicle  -  13 x Light Support APC  -  7 x APC (Wheel)  -  4 x Light APC  -  1 x Gun APC (Wheeled)  -  1 x Utility Vehicle	24	11	(6.6291651245988508,31.75)
1414	2 x Infantry Tank  -  2 x Assault Gun  -  2 x Obsolete Tank  -  1 x SP Gun  -  1 x Mine Clearing Tank  -  1 x Light Tank  -  1 x MBT	2	18	(12.691342951089922,27.25)
2072	5 x APC (Track)  -  3 x Ammo Carrier  -  1 x Light APC  -  1 x Heavy APC  -  1 x Artillery Prime Mover	5	25	(28.279800219209818,39.25)
2373	25 x SP SAM  -  8 x Area SAM	25	30	(11.825317547305483,45.25)
885	2 x Light Tank  -  1 x APC (Track)  -  1 x Gun APC (Tracked)  -  1 x Armoured Car	2	12	(4.4641016151377544,17.5)
1917	19 x Scout Vehicle  -  9 x Light Support APC  -  8 x Light APC  -  3 x Utility Vehicle  -  1 x Airborne APC  -  1 x Airborne Support APC  -  1 x Light Truck	19	32	(32.609927238132009,36.25)
2155	2 x Medium Truck	2	27	(30.877876430563134,40.75)
468	1 x Light Commandos	1	85	(24.815698604072061,9.25)
880	4 x Paratroop Scouts  -  2 x Para Mortar Team  -  2 x Mech Scouts  -  2 x Heavy Infantry  -  2 x Scout  -  2 x Pioneers  -  2 x Guards Squad  -  1 x Bicycle Squad  -  1 x Heavy Mech Infantry  -  1 x Inf-AT  -  1 x Light Infantry  -  1 x Guards Infantry  -  1 x Ski Scouts  -  1 x Guerrilla Inf Support  -  1 x Light Mech Infantry  -  1 x Infantry  -  1 x Militia	4	101	(35.208003449485325,16.75)
333	1 x O/M Rocket Arty	1	31	(11.392304845413264,7)
800	2 x Scout  -  2 x Motorcycle(Light Inf)  -  2 x Commando Scouts  -  2 x Patrol  -  2 x Paratroop Scouts	2	82	(35.208003449485325,15.25)
1530	2 x Light Amphibian  -  1 x APC (Track)	2	33	(8.794228634059948,29.5)
2112	3 x APC (Track)  -  1 x Light Support APC  -  1 x Artillery Prime Mover	3	25	(27.846787517317598,40)
1865	5 x SP Flak  -  1 x FO Vehicle	5	22	(21.784609690826528,35.5)
787	29 x O/M Field Artillery	29	10	(23.949673200287624,15.25)
189	5 x Infantry  -  1 x Marines  -  1 x Heavy Infantry  -  1 x Paratroops  -  1 x Cavalry  -  1 x Guards Squad	5	1	(25.248711305964282,4)
915	1 x MG Section	1	194	(30.444863728670914,17.5)
2339	4 x Light Helicopter  -  2 x Light Attack Helicopter  -  1 x Attack Helicopter	4	204	(16.588457268119896,44.5)
712	16 x LMG Section  -  2 x Para Medium Infantry	16	65	(28.279800219209818,13.75)
1306	76 x AT Gun  -  18 x Light AT Gun  -  2 x Heavy AT Gun  -  1 x Gun APC (Wheeled)	76	6	(22.650635094610966,25)
1346	1 x Light AT Gun	1	157	(23.083647796503186,25.75)
2079	3 x Light Truck  -  1 x Medium Truck  -  1 x Utility Vehicle	3	183	(34.341978045700891,39.25)
547	1 x Pioneers  -  1 x Guerrilla Inf Support	1	140	(23.949673200287624,10.75)
1453	8 x MBT  -  1 x SP Gun  -  1 x Infantry Tank  -  1 x Medium Tank  -  1 x Obsolete Tank	8	59	(11.392304845413264,28)
2391	1 x Paratroop Transport	1	60	(27.413774815425377,45.25)
952	1 x Mortar(Sub Type A)	1	200	(28.279800219209818,18.25)
997	5 x Rifle Section  -  3 x Partisans  -  3 x Rangers  -  3 x Native Troops  -  2 x Motorcycle(Heavy Inf)  -  2 x Infantry  -  2 x SMG Section  -  1 x Ranger Scout  -  1 x Marines  -  1 x Light Infantry  -  1 x Light Militia  -  1 x Partisan Support  -  1 x Guerrilla Inf Squad  -  1 x Reserve Infantry  -  1 x Cavalry Scouts  -  1 x Militia	5	67	(32.176914536239792,19)
1989	4 x Light Support APC  -  3 x Utility Vehicle  -  2 x APC (Track)  -  2 x Light MRV APC  -  1 x Light APC  -  1 x MRV APC  -  1 x Gun APC (Wheeled)  -  1 x Heavy APC  -  1 x APC (Wheel)	4	122	(25.681724007856502,37.75)
578	2 x Heavy Mortar	2	152	(15.722431864335457,11.5)
1892	21 x Fighter-Bomber  -  2 x COIN Fighter Plane  -  1 x COIN Bomber	21	44	(10.959292143521045,36.25)
2179	1 x Fighter-Bomber  -  1 x Level Bomber	1	62	(16.588457268119896,41.5)
376	1 x O/M Rocket Arty	1	31	(14.423393758658799,7.75)
723	11 x MBT  -  3 x Medium Tank  -  2 x Obsolete Heavy Tank  -  2 x CS MBT  -  1 x Close Support Tank  -  1 x Obsolete Tank	11	59	(2.7320508075688772,14.5)
879	2 x Mech Scouts  -  2 x Commando Scouts  -  2 x Guerrilla Inf Squad  -  1 x Paratroop Scouts  -  1 x Militia  -  1 x Commandos  -  1 x Guards Infantry  -  1 x Ranger Scout  -  1 x Partisan Scouts  -  1 x Infantry	2	81	(34.341978045700891,16.75)
1372	1 x Assault Gun	1	18	(10.526279441628825,26.5)
566	7 x MBT  -  7 x Medium Tank  -  2 x Obsolete Tank	7	59	(5.3301270189221936,11.5)
1427	63 x Inf-AT  -  13 x Para Inf-AT  -  6 x Commando Inf-AT  -  2 x Guerrilla Inf Support  -  2 x Ski Inf-AT  -  1 x Para-RR Team	63	2	(23.949673200287624,27.25)
695	2 x SP Mortar  -  1 x Gun APC (Wheeled)	2	38	(13.55736835487436,13.75)
2323	16 x Attack Helicopter  -  1 x Helicopter  -  1 x Light Attack Helicopter  -  1 x Light Helicopter	16	203	(2.7320508075688772,44.5)
737	21 x SP Rocket Launcher  -  3 x O/M Rocket Arty  -  2 x Fighter-Bomber	21	137	(14.856406460551018,14.5)
1542	9 x Inf-ATGM Team  -  4 x Heavy Inf-ATGM  -  2 x Guerrilla Inf Support  -  1 x Para-ATGM Team	9	206	(19.186533479473212,29.5)
2044	13 x Fighter-Bomber  -  6 x SEAD Aircraft	13	44	(4.0310889132455356,39.25)
1698	3 x Fighter-Bomber  -  1 x COIN Fighter Plane	3	44	(15.722431864335457,32.5)
303	7 x Fortifications	7	0	(20.48557158514987,6.25)
1551	1 x Airborne Support APC	1	124	(26.98076211353316,29.5)
2372	10 x Area SAM  -  7 x SP SAM	10	16	(10.959292143521045,45.25)
1296	19 x AT Gun  -  2 x Heavy AT Gun	19	6	(13.99038105676658,25)
610	6 x Armoured Car  -  1 x Scout Vehicle	6	11	(9.2272413359521668,12.25)
782	21 x Rocket Launcher  -  4 x SP Rocket Launcher  -  2 x Guerrilla Rocket	21	151	(19.619546181365433,15.25)
1611	7 x APC (Wheel)  -  3 x Light APC  -  2 x Light Support APC  -  1 x Heavy Amphibian  -  1 x Scout Vehicle  -  1 x Heavy APC	7	23	(9.6602540378443873,31)
165	24 x Fortifications	24	0	(4.4641016151377544,4)
287	7 x Fortifications	7	0	(6.6291651245988508,6.25)
1792	4 x SP Flak	4	22	(27.846787517317598,34)
748	42 x O/M Field Artillery  -  2 x O/M Heavy Artillery	42	10	(24.382685902179844,14.5)
2343	3 x Helicopter  -  1 x Heavy Helicopter	3	53	(20.05255888325765,44.5)
21	37 x O/M Field Artillery  -  1 x O/M Medium Artillery	37	10	(18.320508075688775,1)
1630	1 x Light SP ATGM	1	129	(26.114736709748719,31)
1607	1 x APC (Track)	1	25	(6.196152422706632,31)
401	3 x MBT  -  3 x Obsolete Tank  -  1 x Medium Tank	3	59	(1,8.5)
570	17 x Armoured Car  -  1 x Light Tank	17	11	(8.794228634059948,11.5)
1156	20 x Motorcycle(Light Inf)	20	187	(31.310889132455351,22)
281	48 x Fortifications	48	0	(1.4330127018922194,6.25)
301	8 x Fortifications	8	0	(18.753520777580992,6.25)
1274	1 x Police  -  1 x Heavy Infantry  -  1 x Para Mortar Team	1	173	(30.011851026778693,24.25)
2349	1 x Light Amphibian	1	33	(25.248711305964282,44.5)
2181	30 x Light Helicopter	30	204	(18.320508075688775,41.5)
1830	1 x Ammo Carrier	1	56	(26.54774941164094,34.75)
1412	8 x SP Gun  -  7 x Assault Gun	8	39	(10.959292143521045,27.25)
367	8 x Fortifications	8	0	(6.6291651245988508,7.75)
1137	35 x Field Gun	35	9	(14.856406460551018,22)
1701	2 x SP SAM  -  1 x Fortifications	2	30	(18.320508075688775,32.5)
822	18 x Rocket Launcher  -  3 x Guerrilla Rocket  -  1 x SP Rocket Launcher  -  1 x SP Mortar	18	151	(19.186533479473212,16)
896	3 x SP Mortar	3	38	(13.99038105676658,17.5)
609	9 x Light Tank  -  3 x MBT  -  1 x Medium Tank  -  1 x Obsolete Tank	9	12	(8.3612159321677293,12.25)
429	3 x Partisans  -  1 x Marines  -  1 x Heavy Ski Troops	3	76	(25.248711305964282,8.5)
718	4 x Cavalry Scouts	4	150	(33.47595264191645,13.75)
1242	3 x Medium Tank  -  2 x Engineer Tank  -  1 x CS Infantry Tank  -  1 x Close Support Tank  -  1 x MBT	3	13	(2.299038105676658,24.25)
690	1 x APC (Track)	1	25	(9.2272413359521668,13.75)
911	72 x Flak  -  2 x AA Truck	72	8	(26.98076211353316,17.5)
2305	3 x Heavy Helicopter  -  2 x Helicopter	3	205	(22.217622392718749,43.75)
112	10 x Infantry  -  8 x Ski Troops  -  3 x Rifle Section  -  3 x Partisans  -  3 x Paratroops  -  3 x Motorised Inf Section  -  2 x Bicycle Squad  -  1 x Heavy Ski Troops  -  1 x Mechanised Infantry  -  1 x Reserve Infantry  -  1 x Partisan Band  -  1 x Militia  -  1 x Marines	10	1	(27.846787517317598,2.5)
2075	1 x Scout Vehicle  -  1 x Improvised APC  -  1 x Utility Vehicle	1	32	(30.877876430563134,39.25)
1806	6 x Fighter-Bomber	6	44	(5.7631397208144124,34.75)
1211	1 x Airborne Lt Tank  -  1 x Medium Tank	1	175	(9.6602540378443873,23.5)
1460	34 x Inf-ATGM Team  -  5 x Inf-AT  -  1 x Para Inf-AT  -  1 x Para-ATGM Team	34	206	(17.454482671904334,28)
2098	48 x Level Bomber  -  6 x Fighter-Bomber  -  2 x COIN Fighter Plane  -  2 x COIN Bomber  -  1 x CS MBT	48	62	(15.722431864335457,40)
2153	2 x Heavy Truck  -  2 x Artillery Prime Mover  -  1 x Medium Truck	2	28	(29.145825622994256,40.75)
2312	23 x Artillery Prime Mover  -  4 x Wagon  -  2 x APC (Wheel)  -  1 x APC (Track)  -  1 x Heavy MRV APC  -  1 x Snow Vehicle	23	180	(28.279800219209818,43.75)
2361	43 x Attack Helicopter	43	203	(1.4330127018922194,45.25)
1491	4 x SP Gun  -  1 x Flame Tank	4	39	(10.093266739736606,28.75)
1706	20 x SP ATGM  -  18 x Light SP ATGM  -  9 x Wheeled SP-ATGM  -  3 x Airborne Support APC  -  2 x Cavalry Tank  -  2 x Airborne Lt Tank  -  1 x Scout Vehicle	20	19	(22.650635094610966,32.5)
954	40 x Mortar(Sub Type A)  -  12 x Mortar(Sub Type B)  -  8 x Light Mortar  -  2 x Para Mortar Team  -  1 x Mortar	40	200	(30.011851026778693,18.25)
1029	17 x Mortar(Sub Type A)  -  9 x Mortar(Sub Type B)  -  3 x Mortar  -  2 x Mortar(Sub Type C)	17	200	(25.681724007856502,19.75)
1776	82 x Fighter-Bomber  -  1 x COIN Fighter Plane	82	44	(13.99038105676658,34)
600	9 x Engineer  -  7 x Commando Engineers  -  4 x Marine Engineers  -  3 x Para Engineers  -  3 x Guerrilla Hvy Inf Squad  -  2 x Ranger Pioneer  -  2 x Commandos  -  1 x Pioneers  -  1 x Partisan Band  -  1 x Guerrilla Inf Squad  -  1 x Paratroops	9	20	(34.774990747593108,11.5)
1561	2 x APC (Wheel)  -  1 x Scout Vehicle  -  1 x APC (Track)  -  1 x Heavy APC	2	23	(1.4330127018922194,30.25)
1930	11 x Fighter-Bomber  -  2 x COIN Fighter Plane	11	44	(8.794228634059948,37)
319	3 x Infantry  -  2 x Medium Commandos  -  2 x Heavy Commandos  -  2 x Paratroops  -  1 x Heavy Infantry  -  1 x Commandos  -  1 x Mech Scouts  -  1 x Rangers  -  1 x Ski Troops  -  1 x Light Infantry  -  1 x Reserve Infantry  -  1 x Commando Support  -  1 x Engineer Support Squad	3	1	(34.341978045700891,6.25)
1790	38 x SP Flak  -  15 x SP Mortar	38	22	(26.114736709748719,34)
435	7 x Infantry  -  5 x Marine Light Infantry  -  5 x Mechanised Infantry  -  5 x Reserve Infantry  -  3 x Paratroops  -  3 x Motorised Inf Section  -  3 x Marines  -  2 x Commandos  -  1 x Marine Support Squad  -  1 x Mercenaries  -  1 x Rifle Squad	7	1	(30.444863728670914,8.5)
889	3 x Engineer Tank  -  1 x Mine Clearing Tank	3	37	(7.9282032302755088,17.5)
653	1 x APC (Track)	1	25	(11.392304845413264,13)
1405	6 x Armoured Car  -  2 x Scout Vehicle  -  2 x Heavy Armoured Car  -  1 x SP Gun  -  1 x Gun APC (Wheeled)  -  1 x Light Cavalry Tank	6	11	(4.897114317029974,27.25)
2124	13 x Fighter-Bomber	13	44	(4.0310889132455356,40.75)
108	5 x Infantry  -  3 x Reserve Infantry  -  2 x Pioneers  -  2 x Rangers  -  2 x Engineer Support Squad  -  1 x Marine Support Squad  -  1 x Native Troops  -  1 x Marines  -  1 x Engineer  -  1 x Guerrilla Lt Inf Squad  -  1 x Militia Support  -  1 x Ski Troops  -  1 x Medium Mech Infantry	5	1	(24.382685902179844,2.5)
589	6 x Heavy Infantry  -  3 x Paratroop Support  -  2 x Para Medium Infantry  -  1 x Irregulars  -  1 x Partisans	6	40	(25.248711305964282,11.5)
913	3 x Flak  -  2 x MG Unit	3	8	(28.712812921102035,17.5)
1051	10 x Engineer Tank  -  5 x Mine Clearing Tank  -  1 x Medium Tank  -  1 x Obsolete Tank	10	37	(9.6602540378443873,20.5)
2362	48 x Attack Helicopter	48	203	(2.299038105676658,45.25)
1089	10 x MBT  -  7 x Medium Tank  -  2 x Close Support Tank  -  1 x CS MBT  -  1 x Assault Gun  -  1 x Engineer Tank	10	59	(8.3612159321677293,21.25)
1941	3 x Fighter-Bomber	3	44	(18.320508075688775,37)
65	1 x Paratroops  -  1 x Commandos  -  1 x Rangers	1	83	(22.217622392718749,1.75)
366	3 x Fortifications	3	0	(5.7631397208144124,7.75)
1885	17 x SEAD Aircraft	17	214	(4.897114317029974,36.25)
440	16 x Mechanised Infantry  -  8 x Heavy Infantry  -  6 x Infantry  -  4 x Light Infantry  -  4 x Paratroops  -  3 x Reserve Infantry  -  2 x Paratroop Support  -  2 x Medium Infantry  -  1 x Commando Engineers  -  1 x Fortifications  -  1 x Guerrilla Inf Squad  -  1 x Marines	16	69	(34.774990747593108,8.5)
2027	2 x APC (Wheel)  -  1 x Light APC  -  1 x Utility Vehicle  -  1 x Armoured Car  -  1 x Snow Vehicle	2	23	(23.516660498395403,38.5)
2322	3 x Attack Helicopter	3	203	(1.8660254037844386,44.5)
2326	2 x Attack Helicopter	2	203	(5.3301270189221936,44.5)
85	55 x Fortifications	55	0	(4.4641016151377544,2.5)
1022	3 x Field Gun	3	9	(19.619546181365433,19.75)
1832	2 x Armoured Car  -  1 x SP Flak  -  1 x Light Support APC	2	11	(28.279800219209818,34.75)
2191	1 x Heavy Amphibian	1	34	(26.98076211353316,41.5)
1978	21 x Fighter-Bomber  -  1 x COIN Fighter Plane	21	44	(16.155444566227676,37.75)
32	4 x Fortifications  -  4 x Guards Infantry  -  3 x Paratroops  -  1 x Commandos  -  1 x Cavalry Scouts  -  1 x Paratroop Support  -  1 x Airmobile Rifle Squad	4	89	(27.846787517317598,1)
1122	3 x CS MBT  -  2 x Mine Clearing Tank  -  1 x MBT  -  1 x FO Vehicle	3	104	(1.8660254037844386,22)
1381	1 x AT Gun	1	6	(18.320508075688775,26.5)
546	3 x AGL	3	7	(23.083647796503186,10.75)
358	9 x Fortifications  -  1 x Paratroops	9	0	(33.042939940024233,7)
701	15 x Mortar  -  1 x Mortar(Sub Type A)  -  1 x Light Mortar  -  1 x Mortar(Sub Type C)	15	5	(18.753520777580992,13.75)
1537	59 x Infantry SAM  -  2 x Heavy Ski Troops  -  1 x Paratroop Support  -  1 x Partisan Support  -  1 x Mech Support Squad  -  1 x Para light Infantry	59	29	(14.856406460551018,29.5)
1993	10 x Light MRV APC  -  9 x MRV APC  -  6 x Scout Vehicle  -  3 x APC (Wheel)  -  1 x Light Support APC  -  1 x Heavy APC  -  1 x Artillery Prime Mover  -  1 x Heavy MRV APC	10	219	(29.145825622994256,37.75)
736	1 x SP Rocket Launcher  -  1 x Fighter-Bomber	1	137	(13.99038105676658,14.5)
1505	4 x Inf-ATGM Team  -  1 x Inf-AT	4	206	(22.217622392718749,28.75)
1006	1 x Mine Clearing Tank	1	36	(5.7631397208144124,19.75)
278	3 x Airmobile Spt Section  -  3 x Mech Scouts  -  3 x Light Infantry  -  1 x Guards Infantry  -  1 x Commando Engineers  -  1 x Paratroops	3	81	(33.042939940024233,5.5)
941	29 x SP Artillery  -  16 x SP Howitzer  -  1 x SP Gun  -  1 x Light SP Mortar  -  1 x SP Mortar	29	21	(18.753520777580992,18.25)
1181	2 x Flak	2	8	(18.753520777580992,22.75)
603	32 x MBT  -  13 x Medium Tank  -  3 x CS MBT  -  1 x Close Support Tank	32	59	(3.1650635094610968,12.25)
875	15 x MG Section  -  9 x MG Unit  -  5 x Machine Gun Section  -  1 x Para MG  -  1 x Flak	15	194	(30.877876430563134,16.75)
2353	23 x Paratroop Transport  -  3 x Transport Aircraft	23	60	(28.712812921102035,44.5)
289	7 x Heavy Amphibian  -  2 x Patrol Boat  -  2 x Amphibian Tank	7	34	(8.3612159321677293,6.25)
637	1 x COIN Infantry Squad	1	224	(32.609927238132009,12.25)
1602	3 x Light Tank  -  3 x APC (Track)  -  2 x Armoured Car  -  2 x Heavy APC  -  1 x Light Cavalry Tank  -  1 x Heavy Armoured Car  -  1 x FO Vehicle  -  1 x Light APC  -  1 x APC  -  1 x Gun APC (Wheeled)	3	25	(1.8660254037844386,31)
1819	2 x Fighter-Bomber	2	44	(17.021469970012117,34.75)
443	2 x Medium Tank  -  2 x Assault Gun  -  2 x Fortifications  -  1 x Obsolete Tank  -  1 x Flame Tank  -  1 x FO Vehicle  -  1 x CS MBT  -  1 x MBT	2	18	(3.1650635094610968,9.25)
416	4 x Mortar  -  4 x Heavy Mortar  -  4 x Mortar(Sub Type D)  -  1 x Mortar(Sub Type B)	4	255	(13.99038105676658,8.5)
758	5 x Motorcycle(Light Inf)  -  1 x Scout  -  1 x Commando Scouts	5	187	(33.042939940024233,14.5)
892	4 x SP Mortar	4	38	(10.526279441628825,17.5)
232	1 x Medium Infantry	1	64	(28.279800219209818,4.75)
692	1 x Armoured Car	1	11	(10.959292143521045,13.75)
427	12 x LMG Section  -  2 x Medium Infantry	12	65	(23.516660498395403,8.5)
2207	32 x Fighter-Bomber  -  2 x COIN Fighter Plane	32	44	(6.6291651245988508,42.25)
803	3 x Medium Tank  -  2 x Cavalry Tank  -  2 x MBT  -  1 x Engineer Tank	3	13	(2.7320508075688772,16)
113	14 x Infantry  -  12 x Mechanised Infantry  -  10 x Motorised Inf Section  -  4 x Rangers  -  3 x Commandos  -  3 x Rifle Section  -  3 x Paratroops  -  2 x Heavy Mech Infantry  -  2 x Partisan Band  -  2 x Engineer Support Squad  -  2 x Heavy Infantry  -  2 x Light Mech Infantry  -  2 x Mercenaries  -  1 x Rifle Squad  -  1 x Reserve Infantry  -  1 x Irregulars  -  1 x Light Infantry  -  1 x Guards Infantry	14	1	(28.712812921102035,2.5)
1091	1 x Heavy Tank  -  1 x Engineer Tank  -  1 x Mine Clearing Tank	1	14	(10.093266739736606,21.25)
1517	2 x Sniper  -  2 x Commando Sniper	2	45	(32.609927238132009,28.75)
2103	8 x Engineer Tank	8	37	(20.05255888325765,40)
24	10 x Marines  -  5 x Police  -  4 x Rangers  -  3 x Ski Troops  -  2 x Mech Support Squad  -  2 x Para Medium Infantry  -  2 x Commando Support  -  2 x Heavy Commandos  -  1 x MG Unit  -  1 x Paratroop Support  -  1 x Medium Infantry  -  1 x Guerrilla Inf Squad  -  1 x Engineer Support Squad  -  1 x Medium Mech Infantry	10	110	(20.918584287042091,1)
1633	28 x SP Gun  -  3 x Wheeled SP-ATGM  -  1 x Light Amphibian  -  1 x Assault Gun	28	39	(28.712812921102035,31)
494	3 x Flame Tank  -  3 x APC (Track)  -  2 x Native Troops  -  1 x Heavy Militia	3	25	(12.258330249197702,10)
1018	2 x SP Artillery	2	21	(16.155444566227676,19.75)
1235	1 x Light Militia  -  1 x Police	1	190	(30.444863728670914,23.5)
1934	48 x Level Bomber  -  5 x COIN Bomber	48	62	(12.258330249197702,37)
68	3 x Heavy Infantry  -  2 x Police  -  2 x Infantry  -  2 x Paratroop Scouts  -  2 x Ski Troops  -  2 x Medium Mech Infantry  -  2 x Light Commandos  -  1 x Marines  -  1 x Heavy Ski Troops  -  1 x Guards Infantry  -  1 x Mechanised Infantry  -  1 x Guerrilla Inf Squad  -  1 x Heavy Commandos  -  1 x Mercenaries  -  1 x Para Engineers	3	40	(24.815698604072061,1.75)
652	1 x Light Tank  -  1 x Armoured Car  -  1 x APC (Wheel)	1	12	(10.526279441628825,13)
1265	5 x AT Gun	5	6	(22.217622392718749,24.25)
535	1 x Flak	1	8	(13.55736835487436,10.75)
565	1 x Light Tank  -  1 x MBT	1	12	(4.4641016151377544,11.5)
1233	10 x AGL  -  2 x AA Truck  -  1 x Para MG	10	7	(28.712812921102035,23.5)
456	6 x Mortar  -  1 x Light Mortar  -  1 x Mortar(Sub Type C)	6	5	(14.423393758658799,9.25)
300	36 x Fortifications	36	0	(17.887495373796554,6.25)
1952	11 x Scout Vehicle  -  5 x Utility Vehicle  -  4 x Light MRV APC  -  3 x Armoured Car  -  2 x Light Support APC  -  2 x Light APC  -  1 x MRV IFV  -  1 x SP Flak	11	32	(27.846787517317598,37)
2384	15 x Heavy Helicopter  -  14 x Helicopter  -  2 x Light Helicopter	15	205	(21.351596988934308,45.25)
1873	3 x FO Vehicle	3	57	(28.712812921102035,35.5)
2274	15 x Paratroop Transport  -  5 x Transport Aircraft	15	60	(29.578838324886476,43)
928	8 x Engineer Tank  -  7 x Mine Clearing Tank  -  4 x MBT  -  1 x Medium Tank	8	37	(7.49519052838329,18.25)
1812	6 x Fighter-Bomber	6	44	(10.959292143521045,34.75)
1893	19 x Fighter-Bomber  -  1 x COIN Fighter Plane	19	44	(11.825317547305483,36.25)
2122	4 x SEAD Aircraft	4	214	(2.299038105676658,40.75)
1629	2 x SP ATGM  -  1 x SP Gun	2	19	(25.248711305964282,31)
256	11 x O/M Rocket Arty	11	31	(13.99038105676658,5.5)
1733	3 x Fighter-Bomber  -  1 x Gunship Aircraft	3	44	(11.825317547305483,33.25)
2232	8 x Utility Vehicle	8	26	(28.279800219209818,42.25)
216	2 x O/M Rocket Arty	2	31	(14.423393758658799,4.75)
202	3 x Fortifications	3	0	(2.299038105676658,4.75)
2174	4 x Fighter-Bomber	4	44	(12.258330249197702,41.5)
2355	1 x Paratroop Transport	1	60	(30.444863728670914,44.5)
865	1 x Field Gun	1	9	(22.217622392718749,16.75)
987	2 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type A)  -  1 x SP Mortar	2	202	(23.516660498395403,19)
266	3 x Marine Light Infantry  -  2 x Medium Infantry  -  2 x Guerrilla Inf Squad  -  2 x Guards Squad  -  2 x Native Troops  -  1 x Patrol  -  1 x Militia  -  1 x Irregulars  -  1 x Light Guards Squad  -  1 x Partisan Band	3	112	(22.650635094610966,5.5)
1850	1 x Fighter-Bomber	1	44	(8.794228634059948,35.5)
483	2 x CS Infantry Tank  -  1 x Close Support Tank  -  1 x CS MBT  -  1 x Obsolete Tank	2	106	(2.7320508075688772,10)
1869	58 x Ammo Carrier  -  12 x FO Vehicle  -  3 x Light APC  -  1 x APC (Track)  -  1 x APC (Wheel)	58	56	(25.248711305964282,35.5)
2262	50 x Helicopter  -  1 x Attack Helicopter  -  1 x Light Attack Helicopter  -  1 x Light Helicopter	50	53	(19.186533479473212,43)
2069	3 x Light Support APC  -  3 x MRV APC  -  2 x Scout Vehicle  -  2 x APC (Track)  -  2 x Utility Vehicle  -  1 x Gun APC (Wheeled)  -  1 x FO Vehicle  -  1 x Armoured Car  -  1 x Cavalry Tank  -  1 x Light APC	3	217	(25.681724007856502,39.25)
1815	2 x Fighter-Bomber	2	44	(13.55736835487436,34.75)
1432	18 x Inf-AT  -  4 x Ski Inf-AT  -  4 x Para Inf-AT  -  2 x Commando Inf-AT  -  2 x Partisan Support  -  1 x Reserve Supt Squad  -  1 x Inf-RR Team	18	2	(28.279800219209818,27.25)
80	111 x Engineer  -  17 x Para Engineers  -  3 x Marine Engineers  -  3 x Ski Pioneers  -  2 x Engineer Support Squad  -  2 x Pioneers  -  1 x Guards Engineers  -  1 x Ranger Pioneer  -  1 x Inf-AT	111	20	(35.208003449485325,1.75)
1501	27 x Inf-ATGM Team  -  4 x Para-ATGM Team  -  1 x Inf-AT  -  1 x Para Inf-AT	27	206	(18.753520777580992,28.75)
881	9 x MBT  -  1 x Mine Clearing Tank	9	59	(1,17.5)
1721	1 x Assault Gun	1	18	(1.4330127018922194,33.25)
1595	1 x SP Gun	1	39	(30.877876430563134,30.25)
318	3 x Infantry  -  2 x Engineer Support Squad  -  2 x Paratroops  -  2 x Light Infantry  -  2 x Fortifications  -  2 x Reserve Infantry  -  1 x Commando Engineers  -  1 x Rangers	3	1	(33.47595264191645,6.25)
312	2 x Irregulars  -  2 x Guerrilla Inf Squad  -  2 x Native Troops  -  1 x Commando Engineers  -  1 x Heavy Commandos	2	79	(28.279800219209818,6.25)
2047	4 x Fighter-Bomber	4	44	(6.6291651245988508,39.25)
2395	3 x Paratroop Transport  -  1 x Scout Vehicle  -  1 x Light APC  -  1 x Engineer Tank  -  1 x Transport Aircraft	3	60	(30.877876430563134,45.25)
1956	1 x Improvised APC  -  1 x APC (Wheel)  -  1 x Light Truck	1	136	(31.310889132455351,37)
2034	22 x APC (Wheel)  -  2 x Light Support APC  -  1 x APC  -  1 x Light MRV APC  -  1 x Heavy APC	22	23	(29.578838324886476,38.5)
470	1 x Irregulars  -  1 x Guerrilla Inf Squad  -  1 x Paratroops  -  1 x Commandos	1	83	(26.54774941164094,9.25)
542	2 x Machine Gun Section	2	4	(19.619546181365433,10.75)
685	3 x Medium Tank  -  1 x Close Support Tank  -  1 x Light Tank	3	13	(4.897114317029974,13.75)
1341	6 x AT Gun  -  1 x Light AT Gun	6	6	(18.753520777580992,25.75)
1525	7 x APC (Track)  -  3 x Heavy APC  -  1 x Scout Vehicle  -  1 x MRV Light IFV  -  1 x Light Support APC	7	25	(4.4641016151377544,29.5)
1738	4 x Fighter-Bomber	4	44	(16.155444566227676,33.25)
1213	2 x Medium Tank  -  1 x SP Gun  -  1 x MBT	2	59	(11.392304845413264,23.5)
1564	2 x Armoured Car  -  1 x Heavy Armoured Car	2	11	(4.0310889132455356,30.25)
1415	3 x SP Gun  -  2 x Airborne Lt Tank	3	39	(13.55736835487436,27.25)
110	4 x Infantry  -  4 x Motorised Inf Section  -  2 x Paratroops  -  1 x Light Mech Infantry  -  1 x Mercenaries  -  1 x Irregulars  -  1 x Rangers  -  1 x Mechanised Infantry  -  1 x Para light Infantry	4	1	(26.114736709748719,2.5)
1753	87 x Sniper  -  5 x Guerrilla Sniper  -  4 x Para Sniper  -  2 x Ski Sniper  -  2 x Marine Sniper  -  2 x Ranger Sniper  -  1 x Commando Sniper	87	45	(29.145825622994256,33.25)
2344	1 x Helicopter  -  1 x Light Helicopter	1	204	(20.918584287042091,44.5)
175	23 x O/M Heavy Artillery  -  12 x O/M Medium Artillery  -  6 x O/M Field Artillery	23	156	(13.124355652982141,4)
1342	35 x AT Gun  -  22 x Inf-AT  -  1 x SP Gun  -  1 x Ski Inf-AT	35	6	(19.619546181365433,25.75)
1860	12 x Fighter-Bomber	12	44	(17.454482671904334,35.5)
99	6 x O/M Medium Artillery  -  3 x O/M Field Artillery	6	155	(16.588457268119896,2.5)
1128	24 x MBT  -  12 x Medium Tank  -  1 x Mine Clearing Tank  -  1 x Obsolete Tank	24	59	(7.0621778264910704,22)
1005	3 x Mine Clearing Tank	3	36	(4.897114317029974,19.75)
28	9 x Commandos  -  8 x Marines  -  8 x Heavy Infantry  -  6 x Commando Support  -  5 x Para Medium Infantry  -  4 x Mechanised Infantry  -  4 x Heavy Commandos  -  4 x Infantry  -  4 x Marine Scout  -  3 x Paratroop Support  -  2 x Marine Support Squad  -  2 x Rangers  -  2 x Heavy Ski Troops  -  2 x Police  -  2 x Heavy Militia  -  1 x Light Commandos  -  1 x Light Infantry  -  1 x Partisan Support  -  1 x Ski Troops  -  1 x Medium Infantry	9	83	(24.382685902179844,1)
94	28 x O/M Field Artillery  -  9 x O/M Medium Artillery  -  2 x O/M Heavy Artillery	28	10	(12.258330249197702,2.5)
262	50 x Fortifications	50	0	(19.186533479473212,5.5)
313	2 x Marines  -  2 x Para Medium Infantry  -  1 x Marine Light Infantry  -  1 x Heavy Commandos  -  1 x Marine Support Squad	2	99	(29.145825622994256,6.25)
1884	4 x Fighter-Bomber  -  2 x SEAD Aircraft	4	44	(4.0310889132455356,36.25)
2105	3 x MRV APC  -  2 x Airborne Support APC  -  2 x APC (Wheel)  -  1 x APC (Track)  -  1 x Heavy APC	3	217	(21.784609690826528,40)
1322	3 x MBT  -  1 x Medium Tank	3	59	(2.299038105676658,25.75)
1762	2 x Close Support Tank  -  1 x Light Tank  -  1 x APC	2	15	(1.8660254037844386,34)
2053	49 x Fighter-Bomber  -  1 x COIN Fighter Plane	49	44	(11.825317547305483,39.25)
162	4 x Fortifications	4	0	(1.8660254037844386,4)
587	3 x Para Mortar Team	3	173	(23.516660498395403,11.5)
482	3 x Medium Tank  -  2 x SP Gun  -  1 x CS MBT  -  1 x Fortifications  -  1 x SP Artillery  -  1 x MBT  -  1 x Light Tank	3	13	(1.8660254037844386,10)
1259	1 x Heavy AT Gun  -  1 x Flak	1	8	(17.021469970012117,24.25)
1010	2 x Engineer Tank  -  1 x Close Support Tank	2	37	(9.2272413359521668,19.75)
208		0	\N	\N
30	5 x Paratroops  -  3 x Ranger Hvy Infantry Squad  -  3 x Heavy Infantry  -  3 x Mechanised Infantry  -  3 x Mercenaries  -  2 x Ranger Lt Infantry Squad  -  2 x Heavy Guards Squad  -  2 x Partisan Band  -  2 x Guerrilla Inf Squad  -  2 x Rifle Squad  -  2 x Infantry  -  2 x Commandos  -  2 x Marine Support Squad  -  2 x Ski Troops  -  1 x Heavy Mech Infantry  -  1 x Para Medium Infantry  -  1 x Airmobile Rifle Squad  -  1 x Heavy Commandos  -  1 x Light Mech Infantry  -  1 x Rangers  -  1 x Rifle Section  -  1 x Native Troops  -  1 x Light Infantry  -  1 x Marines	5	96	(26.114736709748719,1)
1778	2 x Fighter-Bomber	2	44	(15.722431864335457,34)
1312	43 x Inf-RR Team  -  37 x Inf-AT  -  5 x Para Inf-AT  -  4 x Marine Infantry AT  -  3 x Partisan Support  -  2 x Para-RR Team  -  1 x Commando Inf-AT	43	208	(27.846787517317598,25)
1591	55 x SP Gun  -  5 x Wheeled SP-ATGM  -  4 x Assault Gun  -  1 x Scout Vehicle  -  1 x Self Propelled Gun  -  1 x Armoured Car	55	39	(27.413774815425377,30.25)
1050	5 x MBT  -  4 x Medium Tank  -  2 x Engineer Tank  -  1 x Close Support Tank  -  1 x CS MBT  -  1 x Infantry Tank	5	59	(8.794228634059948,20.5)
1271	5 x Engineer Support Squad  -  3 x AGL  -  2 x Inf-AT  -  2 x Heavy Infantry  -  1 x Para Inf-AT  -  1 x Ski Inf-AT	5	195	(27.413774815425377,24.25)
1684	25 x FO Vehicle	25	57	(3.598076211353316,32.5)
2260	4 x Light Helicopter  -  2 x Attack Helicopter  -  2 x Light Attack Helicopter  -  1 x COIN Armed Helo	4	204	(17.454482671904334,43)
122	1 x Fortifications	1	0	(2.299038105676658,3.25)
1764	2 x FO Vehicle	2	57	(3.598076211353316,34)
1942	42 x Fighter-Bomber  -  2 x COIN Fighter Plane	42	44	(19.186533479473212,37)
2385	24 x Light Helicopter  -  19 x Helicopter  -  3 x Heavy Helicopter	24	204	(22.217622392718749,45.25)
514	11 x Infantry  -  5 x Rangers  -  3 x Marines  -  3 x Paratroops  -  2 x Legion Support Wpns  -  2 x Legion SMG Squad  -  2 x Mechanised Infantry  -  2 x Legionnaires  -  2 x Para light Infantry  -  2 x Irregulars  -  2 x Guards Scouts  -  1 x COIN Infantry Squad  -  1 x Guards Infantry  -  1 x Guards Support Squad  -  1 x Ski Troops  -  1 x Motorised Inf Section  -  1 x Light Mech Infantry  -  1 x Rifle Squad  -  1 x Marine Scout  -  1 x Militia  -  1 x Native Troops  -  1 x Rifle Section	11	1	(29.578838324886476,10)
1267	6 x Pack Howitzer  -  1 x SP Gun	6	196	(23.949673200287624,24.25)
762	8 x MBT  -  5 x Medium Tank  -  3 x CS Infantry Tank  -  2 x Cavalry Tank	8	59	(2.299038105676658,15.25)
1995	2 x Scout Vehicle  -  1 x APC (Wheel)	2	32	(30.877876430563134,37.75)
531	12 x Light Tank  -  3 x Cavalry Tank  -  1 x Close Support Tank  -  1 x MBT  -  1 x Obsolete Tank	12	12	(10.093266739736606,10.75)
1040	14 x Scout  -  7 x Guerrilla Scout  -  5 x Commando Scouts  -  4 x Ski SMG Squad  -  3 x Ski Troops  -  3 x SP Gun  -  3 x Militia  -  3 x Infantry  -  3 x Ski Scouts  -  2 x Rangers  -  1 x Reserve Infantry  -  1 x Motorcycle(Light Inf)  -  1 x Irregulars	14	58	(35.208003449485325,19.75)
390	2 x Paratroops  -  2 x Infantry  -  1 x Heavy Infantry	2	1	(26.54774941164094,7.75)
1244	4 x Medium Tank  -  3 x MBT  -  1 x Mine Clearing Tank	4	59	(4.0310889132455356,24.25)
628	6 x Marines  -  6 x Paratroop Scouts  -  4 x Reserve Infantry  -  3 x Light Infantry  -  2 x Mech Scouts  -  1 x Militia  -  1 x Partisans  -  1 x Native Troops  -  1 x Rifle Section  -  1 x Guerrilla Inf Squad  -  1 x Light Commandos  -  1 x Partisan Scouts  -  1 x HQ	6	101	(24.815698604072061,12.25)
1859	3 x Fighter-Bomber  -  1 x COIN Fighter Plane	3	44	(16.588457268119896,35.5)
1511	2 x Inf-AT  -  2 x Reserve Supt Squad  -  2 x Inf-RR Team  -  1 x Ski Inf-AT	2	161	(27.413774815425377,28.75)
1130	1 x Light Tank	1	12	(8.794228634059948,22)
1867	1 x Rivercraft  -  1 x SP Mortar	1	38	(23.516660498395403,35.5)
560	25 x Engineer  -  13 x Commando Engineers  -  10 x Para Engineers  -  8 x Paratroops  -  5 x Marine Engineers  -  4 x Pioneers  -  2 x Ski Pioneers  -  2 x Militia  -  2 x Commandos  -  2 x Guerrilla Inf Squad  -  1 x Ski Scouts  -  1 x Commando Support  -  1 x Cavalry  -  1 x Medium Commandos	25	20	(35.208003449485325,10.75)
1937	10 x Fighter-Bomber  -  1 x COIN Fighter Plane	10	44	(14.856406460551018,37)
2299	29 x Light Helicopter  -  9 x Attack Helicopter  -  9 x Light Attack Helicopter  -  2 x Helicopter	29	204	(17.021469970012117,43.75)
2146	2 x LCG	2	46	(23.083647796503186,40.75)
1492	1 x CS Infantry Tank	1	106	(10.959292143521045,28.75)
1868	7 x FO Vehicle	7	57	(24.382685902179844,35.5)
1057	15 x SP Artillery  -  4 x SP Howitzer  -  3 x SP Mortar  -  1 x Light SP Mortar	15	21	(14.856406460551018,20.5)
940	3 x SP Artillery  -  2 x SP Howitzer	3	21	(17.887495373796554,18.25)
487	4 x Medium Tank  -  2 x MBT  -  1 x Light Tank  -  1 x Cavalry Tank  -  1 x Obsolete Tank	4	13	(6.196152422706632,10)
1761	25 x APC (Track)  -  6 x Heavy APC  -  3 x SP ATGM  -  3 x Scout Vehicle  -  2 x Gun APC (Tracked)  -  2 x Light APC  -  1 x APC (Wheel)  -  1 x Airborne APC  -  1 x Light Tank  -  1 x APC  -  1 x Light Support APC	25	25	(1,34)
1767	2 x Fighter-Bomber	2	44	(6.196152422706632,34)
1510	4 x Inf-AT  -  2 x Inf-RR Team	4	2	(26.54774941164094,28.75)
1433	1 x Inf-AT  -  1 x Para Inf-AT	1	142	(29.145825622994256,27.25)
1979	1 x Fighter-Bomber	1	44	(17.021469970012117,37.75)
553	4 x Infantry  -  2 x Motorised Inf Section  -  2 x Engineer  -  1 x Partisan Support  -  1 x Heavy Infantry  -  1 x Mercenaries  -  1 x Medium Guards Squad  -  1 x Paratroops  -  1 x Commandos  -  1 x Rangers  -  1 x Native Troops  -  1 x Medium Infantry  -  1 x Para Medium Infantry  -  1 x Heavy Mech Infantry  -  1 x Police  -  1 x Light Commandos	4	1	(29.145825622994256,10.75)
1190	3 x Flak  -  1 x AGL	3	8	(26.54774941164094,22.75)
1339	14 x AT Gun	14	6	(17.021469970012117,25.75)
1696	3 x Fighter-Bomber	3	44	(13.99038105676658,32.5)
2280	34 x Air OP Aircraft  -  2 x Utility Vehicle	34	50	(34.774990747593108,43)
2177	2 x Level Bomber	2	62	(14.856406460551018,41.5)
831	6 x MG Section  -  4 x Heavy MG  -  3 x MG Unit  -  3 x Flak  -  2 x Machine Gun Section	6	194	(26.98076211353316,16)
2176	1 x Level Bomber	1	62	(13.99038105676658,41.5)
379		0	\N	\N
380		0	\N	\N
2313	9 x Artillery Prime Mover  -  2 x Paratroop Transport  -  1 x Improvised APC	9	180	(29.145825622994256,43.75)
1198	1 x Partisan Scouts	1	80	(33.47595264191645,22.75)
155	9 x Irregulars  -  5 x Paratroop Scouts  -  3 x Ski Scouts  -  3 x Light Militia  -  3 x Commandos  -  3 x Militia  -  2 x Native Troops  -  2 x Para Medium Infantry  -  2 x Commando Scouts  -  2 x Light Mech Infantry  -  2 x Ranger Scout  -  1 x Patrol  -  1 x Marine Forward Observer  -  1 x Guerrilla Inf Squad  -  1 x Infantry  -  1 x Light Commandos  -  1 x Paratroop Support  -  1 x Heavy Militia  -  1 x SMG Section  -  1 x Heavy Commandos  -  1 x Guards Engineers	9	75	(30.877876430563134,3.25)
446	3 x MBT  -  3 x Close Support Tank  -  2 x Obsolete Tank  -  2 x Infantry Tank  -  1 x CS Infantry Tank  -  1 x Light Tank  -  1 x Medium Tank  -  1 x Flame Tank	3	15	(5.7631397208144124,9.25)
434	4 x Marines  -  1 x Paratroops  -  1 x Marine Support Squad	4	110	(29.578838324886476,8.5)
1115	3 x Light Militia  -  2 x Partisan Scouts  -  1 x Irregulars  -  1 x Police	3	190	(30.877876430563134,21.25)
605	4 x Light Tank  -  1 x Close Support Tank  -  1 x MBT	4	12	(4.897114317029974,12.25)
1240	212 x Art Observer  -  21 x Para Forward Observer  -  1 x Marine Forward Observer	212	63	(34.774990747593108,23.5)
2086	11 x Fighter-Bomber	11	44	(5.3301270189221936,40)
842	3 x MBT	3	59	(2.299038105676658,16.75)
2035	42 x APC (Track)  -  10 x Light APC  -  7 x Light Support APC  -  5 x APC (Halftrack)  -  4 x Heavy APC  -  2 x Artillery Prime Mover  -  2 x APC (Wheel)  -  1 x Scout Vehicle	42	25	(30.444863728670914,38.5)
1282	8 x Medium Tank  -  5 x MBT  -  1 x Obsolete Tank	8	13	(1.8660254037844386,25)
2214	23 x Fighter-Bomber  -  1 x COIN Fighter Plane	23	44	(12.691342951089922,42.25)
2291	1 x COIN Fighter Plane	1	223	(10.093266739736606,43.75)
2025	5 x APC (Wheel)  -  3 x FO Vehicle  -  1 x Scout Vehicle  -  1 x Gun APC (Wheeled)  -  1 x Armoured Car	5	23	(21.784609690826528,38.5)
1438	3 x Scout  -  1 x Pioneers  -  1 x Patrol  -  1 x Paratroop Scouts	3	58	(33.47595264191645,27.25)
639	2 x Guerrilla Lt Inf Squad  -  1 x Light Commandos  -  1 x Pioneers  -  1 x Ski Pioneers  -  1 x Engineer	2	231	(34.341978045700891,12.25)
187	4 x Mechanised Infantry  -  4 x Infantry  -  1 x Para light Infantry  -  1 x Paratroop Scouts  -  1 x Commandos	4	1	(23.516660498395403,4)
1367	1 x Self Propelled Gun  -  1 x SP Gun	1	139	(6.196152422706632,26.5)
1843	2 x Flak  -  1 x SP Flak  -  1 x Wheeled SP-ATGM	2	8	(2.7320508075688772,35.5)
1623	43 x Inf-ATGM Team  -  26 x Heavy Inf-ATGM  -  10 x Inf-AT  -  9 x Para Inf-AT  -  4 x AT Gun  -  1 x Ranger Hvy Infantry Squad  -  1 x Para-ATGM Team  -  1 x Ski Inf-AT  -  1 x Commando Inf-AT	43	206	(20.05255888325765,31)
1770	15 x Fighter-Bomber	15	44	(8.794228634059948,34)
1669	27 x SP ATGM  -  23 x Light SP ATGM  -  14 x Wheeled SP-ATGM  -  4 x SP Gun  -  2 x Airborne Support APC	27	19	(25.681724007856502,31.75)
2303	3 x Helicopter  -  2 x Heavy Helicopter	3	53	(20.48557158514987,43.75)
351	3 x Guards Engineers  -  1 x Partisan Band	3	170	(26.98076211353316,7)
1504	6 x Inf-ATGM Team  -  2 x Para-ATGM Team  -  2 x Heavy Inf-ATGM  -  1 x Inf-AT  -  1 x Ranger Hvy Infantry Squad  -  1 x Para Inf-AT	6	206	(21.351596988934308,28.75)
2218	1 x Level Bomber	1	62	(16.155444566227676,42.25)
2350	1 x Utility Vehicle	1	26	(26.114736709748719,44.5)
2371	26 x SP SAM	26	30	(10.093266739736606,45.25)
2374	79 x Area SAM  -  12 x SP SAM	79	16	(12.691342951089922,45.25)
302	8 x Fortifications	8	0	(19.619546181365433,6.25)
386	5 x LMG Section  -  1 x Partisan Support  -  1 x Militia Support  -  1 x Medium Infantry  -  1 x Ranger Support Squad  -  1 x Heavy Ski Troops	5	65	(23.083647796503186,7.75)
2170	45 x Fighter-Bomber  -  2 x COIN Fighter Plane	45	44	(8.794228634059948,41.5)
126	11 x Fortifications	11	0	(5.7631397208144124,3.25)
511	22 x Infantry  -  8 x Rifle Squad  -  6 x Para light Infantry  -  6 x Rifle Section  -  6 x Guerrilla Inf Squad  -  5 x Medium Infantry  -  4 x Paratroops  -  4 x Marines  -  4 x Engineer Support Squad  -  3 x Light Infantry  -  3 x Reserve Infantry  -  3 x Commandos  -  2 x Marine Support Squad  -  2 x Heavy Infantry  -  2 x Native Troops  -  2 x Irregulars  -  2 x Bicycle Squad  -  2 x Mechanised Infantry  -  2 x Motorised Inf Section  -  1 x Rangers  -  1 x Guards Infantry  -  1 x Partisan Band  -  1 x Ski Troops  -  1 x Cavalry Scouts  -  1 x Legion SMG Squad  -  1 x COIN Inf Support Squad  -  1 x LMG Section  -  1 x Legionnaires  -  1 x Guards Squad	22	1	(26.98076211353316,10)
1313	3 x Inf-AT  -  3 x Ski Inf-AT  -  2 x Inf-RR Team  -  1 x Partisan Support	3	165	(28.712812921102035,25)
1615	3 x Armoured Car  -  2 x Light Tank  -  1 x Scout Vehicle  -  1 x MBT  -  1 x SP Mortar	3	11	(13.124355652982141,31)
2095	2 x Level Bomber	2	62	(13.124355652982141,40)
506	6 x Machine Gun Section  -  1 x Heavy Commandos  -  1 x Medium Commandos	6	4	(22.650635094610966,10)
968	2 x Engineer Tank	2	37	(7.0621778264910704,19)
336	68 x O/M Rocket Arty	68	31	(13.99038105676658,7)
1483	5 x MRV APC  -  1 x Scout Vehicle  -  1 x Patrol Boat  -  1 x Assault Gun  -  1 x MRV IFV  -  1 x SP SAM  -  1 x APC (Wheel)  -  1 x MRV Light IFV	5	217	(3.1650635094610968,28.75)
2085	8 x SEAD Aircraft  -  6 x Fighter-Bomber	8	214	(4.4641016151377544,40)
2282	5 x Attack Helicopter	5	203	(2.299038105676658,43.75)
369	11 x Patrol Boat  -  6 x Rivercraft  -  2 x FO Vehicle  -  1 x LCS  -  1 x Hovercraft	11	199	(8.3612159321677293,7.75)
1880	2 x Scout Vehicle	2	32	(34.774990747593108,35.5)
1176	3 x AT Gun	3	6	(14.423393758658799,22.75)
788	23 x O/M Field Artillery  -  2 x O/M Heavy Artillery	23	10	(24.815698604072061,15.25)
1008	13 x Mine Clearing Tank  -  5 x Engineer Tank  -  1 x Close Support Tank	13	36	(7.49519052838329,19.75)
1413	2 x SP Gun  -  2 x MBT  -  1 x Assault Gun	2	59	(11.825317547305483,27.25)
849	4 x MBT  -  3 x Medium Tank	4	59	(8.3612159321677293,16.75)
1032	32 x Pack Howitzer  -  2 x Mortar(Sub Type C)  -  1 x Light Mortar  -  1 x Howitzer  -  1 x Field Gun  -  1 x Mortar(Sub Type A)  -  1 x Ranger Support Squad	32	196	(28.279800219209818,19.75)
1055	13 x SP Artillery  -  1 x SP Howitzer	13	21	(13.124355652982141,20.5)
1642	3 x APC (Wheel)  -  2 x Heavy APC  -  1 x Light APC  -  1 x Armoured Car	3	23	(2.299038105676658,31.75)
1406	4 x Armoured Car  -  2 x Heavy Armoured Car  -  2 x Light Tank  -  2 x Assault Gun  -  2 x Light Cavalry Tank  -  1 x MBT	4	11	(5.7631397208144124,27.25)
1652	8 x Scout Vehicle  -  7 x APC (Track)  -  5 x Light Support APC  -  2 x APC  -  2 x Light MRV APC  -  1 x APC (Wheel)  -  1 x Gun APC (Wheeled)  -  1 x APC (Halftrack)  -  1 x Utility Vehicle  -  1 x Armoured Car	8	32	(10.959292143521045,31.75)
2197	8 x Artillery Prime Mover  -  2 x Medium Truck  -  2 x Utility Vehicle  -  2 x Snow Vehicle  -  2 x Light Truck	8	180	(32.176914536239792,41.5)
464	8 x Machine Gun Section  -  3 x MG Section  -  2 x MG Unit	8	4	(21.351596988934308,9.25)
1004	2 x MBT  -  2 x Medium Tank	2	59	(4.0310889132455356,19.75)
1353	20 x Inf-AT	20	2	(29.145825622994256,25.75)
1745	2 x SP ATGM  -  1 x Wheeled SP-ATGM	2	19	(22.217622392718749,33.25)
2400	91 x Ammo Carrier	91	56	(35.208003449485325,45.25)
1392	13 x Inf-AT  -  1 x Ski Inf-AT  -  1 x Commando Inf-AT	13	2	(27.846787517317598,26.5)
2345	31 x Helicopter  -  13 x Heavy Helicopter	31	53	(21.784609690826528,44.5)
1440	27 x Art Observer  -  9 x Para Forward Observer  -  4 x Paratroop Scouts  -  3 x Scout  -  2 x HQ  -  1 x Marine Forward Observer  -  1 x Marine Heavy Infantry	27	63	(35.208003449485325,27.25)
1248	2 x Flame Tank  -  2 x Medium Tank  -  1 x Heavy Tank	2	17	(7.49519052838329,24.25)
2289	56 x SP Flak	56	22	(8.3612159321677293,43.75)
477	5 x Infantry  -  4 x Guerrilla Inf Squad  -  3 x Mechanised Infantry  -  2 x Light Infantry  -  1 x Motorised Inf Section  -  1 x Rifle Squad  -  1 x Guerrilla Inf Support  -  1 x Commandos  -  1 x Partisans  -  1 x Reserve Infantry	5	1	(32.609927238132009,9.25)
2161	7 x SP Flak  -  1 x Attack Helicopter	7	22	(1,41.5)
1905	39 x SP Flak  -  3 x Light SPAA Vehicle  -  1 x CS Infantry Tank  -  1 x Heavy APC	39	22	(22.217622392718749,36.25)
291	1 x Patrol Boat	1	199	(10.093266739736606,6.25)
1169	3 x MBT  -  2 x Infantry Tank  -  1 x CS Infantry Tank  -  1 x Cavalry Tank	3	59	(8.3612159321677293,22.75)
2252	1 x Fighter-Bomber	1	44	(10.526279441628825,43)
1075	2 x Light Militia  -  2 x Reserve Infantry	2	160	(30.444863728670914,20.5)
1565	10 x APC (Track)  -  2 x Scout Vehicle  -  2 x Gun APC (Wheeled)  -  1 x Light APC  -  1 x Wheeled SP-ATGM  -  1 x APC (Wheel)	10	25	(4.897114317029974,30.25)
973	6 x SP Artillery  -  1 x SP Howitzer	6	21	(11.392304845413264,19)
845	7 x APC (Track)  -  2 x Light APC	7	25	(4.897114317029974,16.75)
1323	10 x MBT  -  9 x Medium Tank  -  3 x CS MBT  -  1 x Obsolete Tank	10	59	(3.1650635094610968,25.75)
1852	13 x Fighter-Bomber	13	44	(10.526279441628825,35.5)
1291	7 x Assault Gun  -  6 x SP Gun  -  1 x Self Propelled Gun	7	18	(9.6602540378443873,25)
1441	9 x Heavy APC  -  4 x Gun APC (Tracked)  -  3 x APC  -  2 x APC (Track)	9	120	(1,28)
1813	5 x Fighter-Bomber  -  3 x COIN Fighter Plane	5	44	(11.825317547305483,34.75)
76	1 x Militia	1	189	(31.743901834347572,1.75)
334	6 x O/M Rocket Arty	6	31	(12.258330249197702,7)
1163	4 x Medium Tank  -  3 x Mine Clearing Tank  -  2 x CS MBT  -  1 x MBT  -  1 x Fortifications	4	13	(3.1650635094610968,22.75)
1098	33 x Field Gun  -  1 x Howitzer  -  1 x O/M Medium Artillery	33	9	(16.155444566227676,21.25)
1960	72 x Pack Animals  -  2 x Cavalry  -  1 x Improvised APC  -  1 x Rivercraft	72	182	(34.774990747593108,37)
219	2 x O/M Heavy Artillery  -  2 x O/M Medium Artillery	2	156	(17.021469970012117,4.75)
273	1 x Guards Engineers	1	170	(28.712812921102035,5.5)
521	4 x Medium Tank	4	13	(1.4330127018922194,10.75)
79	8 x Engineer  -  3 x Para Engineers  -  1 x Ranger Pioneer	8	20	(34.341978045700891,1.75)
450	2 x Amphibian Tank	2	35	(9.2272413359521668,9.25)
715	6 x Police  -  4 x Irregulars  -  2 x Militia  -  2 x Rifle Section	6	178	(30.877876430563134,13.75)
481	4 x Obsolete Tank  -  2 x Close Support Tank  -  1 x SP Gun  -  1 x CS MBT  -  1 x Medium Tank	4	102	(1,10)
1711	1 x Light SP ATGM	1	129	(26.98076211353316,32.5)
134	2 x O/M Medium Artillery  -  2 x O/M Field Artillery	2	10	(12.691342951089922,3.25)
1309	7 x AT Gun  -  1 x SP Gun  -  1 x Field Gun  -  1 x Fortifications	7	6	(25.248711305964282,25)
192	1 x Mechanised Infantry  -  1 x Reserve Infantry  -  1 x Motorised Inf Section  -  1 x Light Mech Infantry	1	160	(27.846787517317598,4)
1234	4 x Mortar(Sub Type A)  -  2 x Guerrilla Lt Inf Squad  -  1 x AGL  -  1 x Partisan Scouts  -  1 x Light SP Mortar  -  1 x AA Truck	4	200	(29.578838324886476,23.5)
1648	4 x Light APC  -  2 x APC (Wheel)  -  1 x Scout Vehicle	4	121	(7.49519052838329,31.75)
1851	13 x Fighter-Bomber	13	44	(9.6602540378443873,35.5)
271	4 x Infantry  -  3 x Marines  -  2 x Light Infantry  -  2 x Heavy Infantry  -  2 x Rangers  -  1 x Medium Infantry  -  1 x Ranger Pioneer  -  1 x Light Mech Infantry  -  1 x Paratroops  -  1 x Mechanised Infantry  -  1 x Guards Infantry  -  1 x Engineer  -  1 x Motorised Inf Section  -  1 x Commando Scouts	4	1	(26.98076211353316,5.5)
2204	3 x Light Attack Helicopter  -  1 x Attack Helicopter	3	221	(4.0310889132455356,42.25)
1221	2 x Flak	2	8	(18.320508075688775,23.5)
1891	16 x Fighter-Bomber  -  5 x COIN Fighter Plane	16	44	(10.093266739736606,36.25)
1347	2 x AT Gun  -  1 x SP Gun  -  1 x Inf-RR Team  -  1 x Light AT Gun	2	6	(23.949673200287624,25.75)
794	33 x MG Section  -  31 x MG Unit  -  18 x Machine Gun Section  -  2 x Heavy MG  -  1 x Para MG	33	194	(30.011851026778693,15.25)
1716	5 x Sniper  -  2 x Commando Sniper  -  2 x Marine Sniper  -  1 x Para Sniper	5	45	(31.310889132455351,32.5)
1688	2 x FO Vehicle	2	57	(7.0621778264910704,32.5)
607	7 x MBT  -  7 x Medium Tank  -  1 x Obsolete Heavy Tank  -  1 x Infantry Tank  -  1 x Cavalry Tank	7	59	(6.6291651245988508,12.25)
381		0	\N	\N
382		0	\N	\N
2065	6 x MRV IFV  -  1 x MRV Light IFV  -  1 x Heavy MRV APC  -  1 x Light MRV APC	6	237	(22.217622392718749,39.25)
235	2 x Paratroop Scouts	2	101	(30.877876430563134,4.75)
1683	2 x SP Flak  -  2 x CS Infantry Tank  -  2 x MRV Light IFV  -  1 x Scout Vehicle  -  1 x FO Vehicle  -  1 x APC (Track)  -  1 x Light APC	2	238	(2.7320508075688772,32.5)
2292	14 x Fighter-Bomber  -  5 x SEAD Aircraft	14	44	(10.959292143521045,43.75)
84	2 x Fortifications	2	0	(3.598076211353316,2.5)
932	2 x SP Artillery  -  1 x Mine Clearing Tank	2	21	(10.959292143521045,18.25)
1610	15 x Armoured Car  -  13 x APC (Wheel)  -  12 x Scout Vehicle  -  8 x Light Support APC  -  4 x Light APC  -  2 x APC (Track)  -  1 x Light Amphibian  -  1 x Gun APC (Wheeled)  -  1 x Heavy APC  -  1 x APC	15	11	(8.794228634059948,31)
1641	7 x APC (Wheel)  -  6 x Scout Vehicle  -  5 x Light APC  -  4 x APC (Track)  -  4 x Armoured Car  -  2 x FO Vehicle  -  2 x Heavy Armoured Car  -  2 x APC  -  1 x Light Support APC  -  1 x Heavy APC  -  1 x MBT  -  1 x SP Gun	7	23	(1.4330127018922194,31.75)
74	10 x Infantry  -  4 x Mechanised Infantry  -  4 x Irregulars  -  1 x Reserve Infantry  -  1 x Heavy Infantry  -  1 x Mech Scouts  -  1 x Guards Squad  -  1 x Marines  -  1 x Light Infantry  -  1 x Guards Infantry  -  1 x Airmobile Rifle Squad	10	1	(30.011851026778693,1.75)
1560	2 x Art Observer  -  1 x Air OP Aircraft	2	63	(34.774990747593108,29.5)
6	19 x Fortifications	19	0	(5.3301270189221936,1)
2139	9 x Level Bomber  -  2 x Fighter-Bomber	9	62	(17.021469970012117,40.75)
2369	1 x SP SAM	1	30	(8.3612159321677293,45.25)
159	3 x Engineer  -  1 x Engineer Support Squad  -  1 x Ranger Pioneer	3	20	(34.341978045700891,3.25)
1158	15 x Scout  -  7 x Ski Scouts  -  5 x Paratroop Scouts  -  4 x Ranger Scout  -  3 x COIN Scout  -  2 x Partisan Scouts  -  2 x Guerrilla Scout  -  1 x Patrol  -  1 x Pioneers  -  1 x Light Militia  -  1 x Marine Scout  -  1 x Mech Scouts	15	58	(33.042939940024233,22)
1182	26 x Flak	26	8	(19.619546181365433,22.75)
267	1 x Marines  -  1 x Infantry  -  1 x Militia  -  1 x Commandos  -  1 x Ranger Lt Infantry Squad	1	83	(23.516660498395403,5.5)
354	1 x Marine Light Infantry  -  1 x Commandos  -  1 x Light Infantry	1	83	(29.578838324886476,7)
41	19 x Fortifications	19	0	(1.4330127018922194,1.75)
516	1 x Guards Infantry  -  1 x Police  -  1 x Marine Scout  -  1 x Native Troops	1	241	(31.310889132455351,10)
713	3 x Militia  -  1 x Guards Infantry  -  1 x Light Mech Infantry  -  1 x Guerrilla Lt Inf Squad  -  1 x Heavy Militia  -  1 x Rangers  -  1 x Light Infantry	3	189	(29.145825622994256,13.75)
1111	1 x Flak	1	8	(27.413774815425377,21.25)
1977	84 x Fighter-Bomber  -  6 x COIN Fighter Plane	84	44	(15.289419162443238,37.75)
1237	67 x Scout  -  5 x Guards Scouts  -  3 x Partisan Scouts  -  2 x Paratroop Scouts  -  2 x Guerrilla Scout  -  2 x Commando Scouts  -  1 x Mech Scouts  -  1 x Ranger Scout	67	58	(32.176914536239792,23.5)
141	13 x O/M Field Artillery  -  1 x O/M Medium Artillery	13	10	(18.753520777580992,3.25)
1594	1 x Self Propelled Gun	1	139	(30.011851026778693,30.25)
1619	9 x Infantry SAM	9	29	(16.588457268119896,31)
698	2 x SP Rocket Launcher	2	137	(16.155444566227676,13.75)
1899	18 x Fighter-Bomber	18	44	(17.021469970012117,36.25)
720	31 x Commando Scouts  -  11 x Scout  -  8 x Paratroop Scouts  -  4 x Patrol  -  3 x COIN Scout  -  3 x Marine Scout  -  2 x Motorcycle(Light Inf)  -  2 x Police  -  2 x Guerrilla Inf Squad  -  1 x Ranger Scout  -  1 x Paratroop Support  -  1 x Guards Squad  -  1 x Rangers  -  1 x Guerrilla Lt Inf Squad	31	88	(35.208003449485325,13.75)
840	40 x Scout  -  18 x Ski Scouts  -  14 x Paratroop Scouts  -  7 x Commando Scouts  -  5 x Mech Scouts  -  2 x Militia  -  2 x Patrol  -  2 x Ranger Scout  -  1 x Light Mech Infantry  -  1 x Guerrilla Scout  -  1 x Light Militia  -  1 x Medium Commandos  -  1 x Guards Infantry  -  1 x Paratroops  -  1 x Guards Scouts  -  1 x COIN Hvy Infantry Squad	40	58	(34.774990747593108,16)
999	1 x Partisan Support  -  1 x Infantry  -  1 x Light Infantry	1	1	(33.908965343808667,19)
1041	37 x MBT  -  12 x Mine Clearing Tank  -  6 x CS MBT  -  5 x FO Vehicle  -  3 x Obsolete Tank  -  3 x Medium Tank  -  3 x Main Battle Tank  -  1 x Close Support Tank  -  1 x CS Infantry Tank	37	59	(1,20.5)
2386	43 x Light Helicopter  -  2 x Helicopter	43	204	(23.083647796503186,45.25)
564	8 x MBT  -  2 x Medium Tank	8	59	(3.598076211353316,11.5)
1714	1 x Sniper	1	45	(29.578838324886476,32.5)
904	2 x Mortar(Sub Type A)  -  1 x Heavy Mortar  -  1 x Mortar(Sub Type B)	2	200	(20.918584287042091,17.5)
402	2 x Flame Tank	2	17	(1.8660254037844386,8.5)
467	1 x Ranger Hvy Infantry Squad  -  1 x LMG Section	1	247	(23.949673200287624,9.25)
2128	7 x Fighter-Bomber  -  3 x COIN Fighter Plane  -  3 x Level Bomber	7	44	(7.49519052838329,40.75)
171	2 x Patrol Boat	2	199	(9.6602540378443873,4)
648	1 x APC (Wheel)	1	23	(7.0621778264910704,13)
1126	10 x MBT  -  2 x Medium Tank  -  1 x Close Support Tank  -  1 x Obsolete Tank	10	59	(5.3301270189221936,22)
227	1 x Marines  -  1 x Partisan Scouts  -  1 x Commandos  -  1 x Rangers	1	83	(23.949673200287624,4.75)
1095	4 x SP Artillery	4	21	(13.55736835487436,21.25)
1579	8 x Infantry SAM	8	29	(17.021469970012117,30.25)
247	5 x Fortifications	5	0	(6.196152422706632,5.5)
992	17 x Mortar(Sub Type A)  -  6 x Mortar  -  5 x Mortar(Sub Type B)  -  1 x Light Mortar  -  1 x Mortar(Sub Type C)	17	200	(27.846787517317598,19)
2315	7 x Paratroop Transport  -  2 x Heavy Truck  -  1 x Improvised APC  -  1 x Transport Aircraft  -  1 x Utility Vehicle  -  1 x Light Truck	7	60	(30.877876430563134,43.75)
1112	50 x Flak	50	8	(28.279800219209818,21.25)
311	4 x Militia  -  2 x Irregulars  -  1 x Partisan Band	4	189	(27.413774815425377,6.25)
1464	38 x Inf-ATGM Team  -  11 x Heavy Inf-ATGM  -  10 x Para-ATGM Team  -  5 x Inf-AT  -  3 x Para Hy Inf-ATGM  -  2 x Para Inf-AT  -  2 x AT Gun  -  1 x Ranger Hvy Infantry Squad	38	206	(20.918584287042091,28)
1266	2 x AT Gun	2	6	(23.083647796503186,24.25)
347	14 x Guards Squad  -  11 x Infantry  -  6 x Reserve Infantry  -  6 x Partisans  -  5 x Heavy Infantry  -  5 x Light Infantry  -  4 x Native Troops  -  3 x Rifle Squad  -  3 x Partisan Band  -  3 x Rangers  -  3 x Para light Infantry  -  3 x Irregulars  -  3 x Motorised Inf Section  -  2 x Legionnaires  -  2 x Para SMG Squad  -  2 x Rifle Section  -  1 x Medium Guards Squad  -  1 x Medium Infantry  -  1 x Mercenaries  -  1 x Mechanised Infantry  -  1 x Guards Infantry  -  1 x Marines  -  1 x Paratroops  -  1 x Commandos	14	90	(23.516660498395403,7)
1090	12 x MBT  -  3 x CS MBT  -  2 x Medium Tank	12	59	(9.2272413359521668,21.25)
517	2 x Reserve Infantry  -  2 x Infantry  -  1 x Militia  -  1 x Mech Scouts  -  1 x Heavy Militia  -  1 x Light Militia  -  1 x Light Infantry  -  1 x Medium Commandos	2	1	(32.176914536239792,10)
1769	33 x Fighter-Bomber	33	44	(7.9282032302755088,34)
138	12 x O/M Medium Artillery  -  8 x O/M Heavy Artillery  -  5 x O/M Field Artillery	12	155	(16.155444566227676,3.25)
242	4 x Fortifications	4	0	(1.8660254037844386,5.5)
2237	23 x Paratroop Transport  -  6 x Pack Animals  -  5 x Snow Vehicle  -  3 x Wagon  -  2 x Glider  -  1 x Utility Vehicle  -  1 x Transport Aircraft	23	60	(32.609927238132009,42.25)
1290	3 x Fortifications  -  3 x Medium Tank  -  2 x MBT  -  2 x SP Artillery  -  1 x CS MBT	3	0	(8.794228634059948,25)
1380	6 x AT Gun	6	6	(17.454482671904334,26.5)
766	9 x APC (Track)  -  4 x Heavy APC  -  2 x APC  -  1 x Light APC  -  1 x Gun APC (Tracked)  -  1 x APC (Wheel)	9	25	(5.7631397208144124,15.25)
858	1 x SP Rocket Launcher	1	137	(16.155444566227676,16.75)
1349	6 x Inf-RR Team  -  2 x Ski Inf-AT  -  1 x Inf-AT	6	208	(25.681724007856502,25.75)
2340	16 x Helicopter  -  3 x Light Helicopter	16	53	(17.454482671904334,44.5)
190	6 x Infantry  -  4 x Ski Troops  -  3 x Militia  -  2 x Mechanised Infantry  -  2 x Light Mech Infantry  -  2 x Heavy Mech Infantry  -  1 x Hvy Bicycle Squad  -  1 x Patrol  -  1 x Reserve Infantry  -  1 x Medium Mech Infantry  -  1 x Heavy Infantry  -  1 x Medium Infantry	6	1	(26.114736709748719,4)
54	2 x O/M Medium Artillery  -  2 x O/M Field Artillery	2	10	(12.691342951089922,1.75)
1445	1 x Heavy Armoured Car  -  1 x SP Gun	1	39	(4.4641016151377544,28)
1948	2 x FO Vehicle  -  1 x Light APC	2	57	(24.382685902179844,37)
574	3 x Scout Vehicle  -  2 x Armoured Car  -  1 x Obsolete Tank	3	32	(12.258330249197702,11.5)
993	16 x Mortar(Sub Type A)  -  10 x Mortar(Sub Type B)  -  2 x Light Mortar  -  2 x Para Mortar Team  -  1 x Mortar	16	200	(28.712812921102035,19)
2317	91 x Assault Boat  -  8 x Rivercraft  -  1 x LCG	91	42	(32.609927238132009,43.75)
854	14 x SP Mortar	14	38	(12.691342951089922,16.75)
1155	9 x Cavalry Scouts  -  1 x HQ	9	150	(30.444863728670914,22)
663	26 x Mortar  -  2 x Mortar(Sub Type A)  -  2 x Mortar(Sub Type B)  -  1 x Mortar(Sub Type C)	26	5	(20.05255888325765,13)
1028	12 x Pack Howitzer  -  3 x Field Gun  -  1 x Mortar(Sub Type B)	12	196	(24.815698604072061,19.75)
1643	3 x Armoured Car  -  2 x Light Cavalry Tank  -  1 x APC (Track)  -  1 x Gun APC (Tracked)	3	11	(3.1650635094610968,31.75)
103	9 x Machine Gun Section  -  5 x MG Section  -  1 x Legion Support Wpns	9	4	(20.05255888325765,2.5)
2159	131 x Utility Vehicle  -  9 x Light APC  -  6 x Scout Vehicle  -  5 x FO Vehicle  -  4 x Light Support APC  -  2 x Airborne Support APC  -  1 x Ammo Carrier	131	26	(34.341978045700891,40.75)
2307	2 x Helicopter	2	53	(23.949673200287624,43.75)
115	1 x Guerrilla Inf Squad  -  1 x Medium Commandos  -  1 x Light Mech Infantry  -  1 x Ranger Scout	1	248	(30.444863728670914,2.5)
1526	1 x Scout Vehicle	1	32	(5.3301270189221936,29.5)
2365	20 x Attack Helicopter  -  15 x Light Attack Helicopter	20	203	(4.897114317029974,45.25)
148	2 x Light Infantry	2	51	(24.815698604072061,3.25)
236	3 x Medium Mech Infantry  -  1 x Guerrilla Inf Squad  -  1 x Commando Engineers  -  1 x Para light Infantry  -  1 x Heavy Infantry  -  1 x Mercenaries	3	71	(31.743901834347572,4.75)
888	4 x Mine Clearing Tank  -  2 x Engineer Tank  -  2 x Medium Tank	4	36	(7.0621778264910704,17.5)
1241	46 x MBT  -  18 x Medium Tank  -  6 x Cavalry Tank  -  4 x Close Support Tank  -  1 x Engineer Tank  -  1 x Obsolete Tank	46	59	(1.4330127018922194,24.25)
1724	48 x FO Vehicle	48	57	(4.0310889132455356,33.25)
1808	2 x Fighter-Bomber	2	44	(7.49519052838329,34.75)
2111	46 x APC (Track)  -  4 x Light Support APC  -  2 x Artillery Prime Mover  -  2 x APC (Wheel)  -  2 x Heavy Amphibian  -  2 x Ammo Carrier  -  1 x Rivercraft  -  1 x Heavy APC	46	25	(26.98076211353316,40)
1147	37 x Field Gun  -  2 x Howitzer	37	9	(23.516660498395403,22)
1992	17 x APC (Track)  -  2 x Light Support APC  -  1 x Heavy APC  -  1 x APC (Wheel)  -  1 x Artillery Prime Mover  -  1 x MRV IFV  -  1 x MRV APC  -  1 x Light APC	17	25	(28.279800219209818,37.75)
323	1 x Fortifications	1	0	(2.7320508075688772,7)
678	3 x Cavalry Scouts	3	150	(33.042939940024233,13)
322	3 x Fortifications	3	0	(1.8660254037844386,7)
810	1 x Mine Clearing Tank	1	36	(8.794228634059948,16)
1508	27 x Inf-AT  -  10 x Para Inf-AT  -  4 x Ski Inf-AT  -  3 x Commando Inf-AT  -  2 x Paratroop Support  -  1 x Marine Infantry AT	27	2	(24.815698604072061,28.75)
1618	51 x Infantry SAM	51	29	(15.722431864335457,31)
2320	70 x Engineer Tank  -  2 x Mine Clearing Tank	70	37	(35.208003449485325,43.75)
1204	7 x Engineer Tank  -  6 x Mine Clearing Tank  -  1 x CS MBT  -  1 x MBT	7	37	(3.598076211353316,23.5)
1214	1 x SP Gun  -  1 x Assault Gun  -  1 x Cavalry Tank	1	18	(12.258330249197702,23.5)
1035	2 x Militia  -  1 x Police	2	189	(30.877876430563134,19.75)
1311	2 x Inf-AT  -  2 x Inf-RR Team  -  1 x Para Inf-AT  -  1 x Reserve Supt Squad	2	2	(26.98076211353316,25)
1397	1 x Irregulars	1	75	(32.176914536239792,26.5)
1398	16 x Scout  -  10 x Paratroop Scouts  -  4 x Motorcycle(Light Inf)  -  2 x Ranger Scout  -  1 x Commando Scouts  -  1 x HQ  -  1 x Marine Scout  -  1 x Ski Scouts	16	58	(33.042939940024233,26.5)
1668	1 x Heavy Amphibian	1	34	(24.815698604072061,31.75)
294	1 x O/M Rocket Arty	1	31	(12.691342951089922,6.25)
368	2 x Fortifications	2	0	(7.49519052838329,7.75)
857	1 x SP Artillery	1	21	(15.289419162443238,16.75)
1494	28 x Armoured Car  -  6 x Light Tank  -  1 x Scout Vehicle  -  1 x Heavy Armoured Car	28	11	(12.691342951089922,28.75)
1205	13 x Mine Clearing Tank  -  7 x Engineer Tank  -  4 x MBT  -  3 x CS MBT  -  1 x Close Support Tank  -  1 x Medium Tank	13	36	(4.4641016151377544,23.5)
36	6 x Paratroops  -  4 x Para Engineers  -  3 x Engineer  -  2 x Medium Commandos  -  2 x Commandos  -  2 x Rangers  -  2 x Partisan Band  -  1 x Heavy Infantry  -  1 x Commando Engineers	6	96	(31.310889132455351,1)
1493	2 x Light Tank  -  1 x Heavy Armoured Car  -  1 x MBT  -  1 x Armoured Car  -  1 x Obsolete Tank	2	12	(11.825317547305483,28.75)
1227	13 x Pack Howitzer  -  4 x Airborne Field Howitzer  -  1 x Howitzer  -  1 x Heavy AT Gun  -  1 x Field Gun  -  1 x SP Artillery	13	196	(23.516660498395403,23.5)
2171	5 x Fighter-Bomber  -  2 x COIN Fighter Plane	5	44	(9.6602540378443873,41.5)
1890	2 x Fighter-Bomber	2	44	(9.2272413359521668,36.25)
1038	1 x Light Infantry	1	51	(33.47595264191645,19.75)
451	1 x Scout Vehicle	1	32	(10.093266739736606,9.25)
1268	1 x AT Gun	1	6	(24.815698604072061,24.25)
4	7 x Fortifications	7	0	(3.598076211353316,1)
1675	1 x Sniper	1	45	(30.877876430563134,31.75)
1666	4 x Light SP ATGM	4	129	(23.083647796503186,31.75)
200	40 x Engineer  -  11 x Pioneers  -  8 x Ranger Pioneer  -  6 x Para Engineers  -  5 x Light Commandos  -  4 x Marine Engineers  -  3 x Engineer Support Squad  -  2 x Commando Engineers  -  2 x Irregulars  -  2 x Commandos  -  1 x Para light Infantry  -  1 x Guerrilla Inf Squad  -  1 x Paratroops	40	20	(34.774990747593108,4)
257	4 x O/M Rocket Arty  -  1 x Rocket Launcher	4	31	(14.856406460551018,5.5)
1743	32 x SP ATGM  -  5 x Light SP ATGM  -  3 x Wheeled SP-ATGM	32	19	(20.48557158514987,33.25)
1544	30 x Inf-ATGM Team  -  4 x Heavy Inf-ATGM  -  2 x Para Inf-AT  -  2 x Para-ATGM Team  -  1 x Commando Inf-AT  -  1 x Ranger Hvy Infantry Squad  -  1 x Marine Infantry AT  -  1 x Inf-AT	30	206	(20.918584287042091,29.5)
1645	3 x Scout Vehicle  -  1 x Gun APC (Wheeled)  -  1 x APC (Track)  -  1 x Light Support APC  -  1 x Heavy APC  -  1 x APC (Wheel)  -  1 x SP Mortar	3	32	(4.897114317029974,31.75)
53	4 x O/M Heavy Artillery  -  2 x O/M Medium Artillery	4	156	(11.825317547305483,1.75)
1336	25 x AT Gun	25	6	(14.423393758658799,25.75)
222	7 x Fortifications	7	0	(19.619546181365433,4.75)
275	12 x Motorised Inf Section  -  11 x Infantry  -  9 x Paratroops  -  6 x Mechanised Infantry  -  3 x Medium Mech Infantry  -  3 x Light Mech Infantry  -  3 x Cavalry  -  3 x Marines  -  1 x Rangers  -  1 x Rifle Section  -  1 x Ski Troops  -  1 x Heavy Guards Squad  -  1 x Para light Infantry  -  1 x Heavy Infantry  -  1 x Rifle Squad  -  1 x Commandos  -  1 x Marine Support Squad	12	148	(30.444863728670914,5.5)
1703	5 x SP ATGM  -  1 x Wheeled SP-ATGM	5	19	(20.05255888325765,32.5)
613	28 x Armoured Car  -  4 x Scout Vehicle  -  3 x Light Tank  -  2 x Heavy Armoured Car  -  1 x Medium Tank	28	11	(11.825317547305483,12.25)
948	16 x Mortar(Sub Type C)  -  9 x Mortar(Sub Type A)  -  6 x Heavy Mortar  -  2 x Mortar(Sub Type B)  -  1 x Mortar	16	202	(24.815698604072061,18.25)
1039	3 x Marine Light Infantry  -  3 x Infantry  -  2 x Partisan Scouts  -  2 x Partisans  -  1 x Irregulars  -  1 x Medium Infantry	3	1	(34.341978045700891,19.75)
1286	1 x Medium Tank	1	13	(5.3301270189221936,25)
1751	2 x SP Flak  -  1 x Airborne Support APC  -  1 x AA Truck	2	22	(27.413774815425377,33.25)
44	36 x Fortifications	36	0	(4.0310889132455356,1.75)
1474	1 x Commando Inf-AT	1	146	(29.578838324886476,28)
2226	1 x Heavy Amphibian  -  1 x Amphibian Tank	1	34	(23.083647796503186,42.25)
2387	2 x Light Helicopter	2	204	(23.949673200287624,45.25)
371	4 x Heavy Amphibian  -  1 x LCG	4	34	(10.093266739736606,7.75)
650	1 x Light Tank	1	12	(8.794228634059948,13)
990	33 x Mortar(Sub Type A)  -  13 x Mortar(Sub Type B)  -  9 x Mortar  -  2 x Mortar(Sub Type C)	33	200	(26.114736709748719,19)
936	37 x SP Artillery  -  8 x SP Mortar  -  2 x SP Howitzer	37	21	(14.423393758658799,18.25)
568	18 x MBT  -  4 x Medium Tank  -  3 x Obsolete Tank  -  2 x Infantry Tank  -  1 x Cavalry Tank	18	59	(7.0621778264910704,11.5)
1994	6 x APC (Track)  -  1 x Light APC  -  1 x Light Support APC  -  1 x Heavy APC  -  1 x Artillery Prime Mover	6	25	(30.011851026778693,37.75)
2016	32 x Level Bomber  -  2 x Fighter-Bomber  -  1 x COIN Bomber	32	62	(13.99038105676658,38.5)
814	31 x SP Mortar  -  8 x Light SP Mortar	31	38	(12.258330249197702,16)
1166	3 x CS MBT	3	104	(5.7631397208144124,22.75)
1520	9 x Art Observer  -  4 x Para Forward Observer  -  1 x Marine Forward Observer	9	63	(35.208003449485325,28.75)
960	6 x Engineer  -  5 x Marine Light Infantry  -  4 x Ski Pioneers  -  4 x Para Engineers  -  3 x Scout  -  2 x Commando Engineers  -  2 x Partisans  -  2 x Heavy Infantry  -  1 x Pioneers  -  1 x Fortifications  -  1 x Medium Commandos  -  1 x Paratroop Support	6	20	(35.208003449485325,18.25)
998	2 x Infantry	2	1	(33.042939940024233,19)
1391	2 x Inf-AT	2	2	(26.98076211353316,26.5)
544	1 x Light Militia  -  1 x Flak  -  1 x Heavy Militia	1	191	(21.351596988934308,10.75)
754	2 x Machine Gun Section  -  2 x para MG Section  -  1 x MG Unit  -  1 x MG Section  -  1 x LMG Section  -  1 x Flak	2	4	(29.578838324886476,14.5)
2383	3 x Helicopter  -  2 x Heavy Helicopter	3	53	(20.48557158514987,45.25)
677	2 x Police  -  1 x Cavalry Scouts	2	178	(32.176914536239792,13)
791	8 x Heavy MG  -  2 x Machine Gun Section  -  2 x MG Section  -  1 x MG Unit  -  1 x Para MG  -  1 x Flak	8	176	(27.413774815425377,15.25)
1196	6 x Irregulars  -  2 x Guerrilla Scout	6	75	(31.743901834347572,22.75)
1685	3 x FO Vehicle  -  1 x MRV Light IFV	3	57	(4.4641016151377544,32.5)
387		0	\N	\N
403		0	\N	\N
58	28 x O/M Medium Artillery  -  12 x O/M Field Artillery	28	155	(16.155444566227676,1.75)
1113	12 x Flak  -  1 x Heavy MG  -  1 x AA Truck	12	8	(29.145825622994256,21.25)
1172	9 x MBT  -  4 x Medium Tank  -  1 x SP Gun  -  1 x Assault Gun  -  1 x Obsolete Tank	9	59	(10.959292143521045,22.75)
1	195 x Fortifications	195	0	(1,1)
2083	2 x Fighter-Bomber  -  1 x COIN Fighter Plane	2	44	(2.7320508075688772,40)
2253	2 x Fighter-Bomber	2	44	(11.392304845413264,43)
666	3 x AGL  -  1 x Para Mortar Team	3	7	(22.650635094610966,13)
290	3 x Patrol Boat  -  3 x Rivercraft	3	199	(9.2272413359521668,6.25)
890	8 x Engineer Tank	8	37	(8.794228634059948,17.5)
1601	3 x Light Tank  -  1 x APC (Track)  -  1 x Scout Vehicle  -  1 x Armoured Car  -  1 x APC (Wheel)  -  1 x Light Cavalry Tank  -  1 x Light Support APC	3	12	(1,31)
1943	1 x Gunship Aircraft	1	215	(20.05255888325765,37)
2332	2 x SP SAM  -  1 x Area SAM  -  1 x Fighter-Bomber	2	30	(10.526279441628825,44.5)
1012	2 x SP Mortar  -  1 x SP Howitzer  -  1 x SP Artillery	2	38	(10.959292143521045,19.75)
1352	63 x Inf-AT  -  4 x Para Inf-AT  -  2 x Marine Infantry AT  -  1 x Partisan Support  -  1 x Ski Inf-AT	63	2	(28.279800219209818,25.75)
1356	91 x Crew  -  5 x Rivercraft  -  1 x Irregulars  -  1 x Police  -  1 x Pioneers  -  1 x Air OP Aircraft	91	54	(31.743901834347572,25.75)
1260	5 x Flak	5	8	(17.887495373796554,24.25)
1976	1 x CS MBT	1	104	(14.423393758658799,37.75)
2331	4 x SP SAM	4	30	(9.6602540378443873,44.5)
682	13 x MBT  -  12 x Medium Tank  -  2 x Obsolete Tank  -  2 x Infantry Tank  -  2 x Close Support Tank  -  1 x Engineer Tank  -  1 x CS Infantry Tank	13	59	(2.299038105676658,13.75)
1797	1 x Ski Sniper	1	164	(32.176914536239792,34)
2141	13 x Fighter-Bomber  -  2 x COIN Fighter Plane	13	44	(18.753520777580992,40.75)
111	8 x Paratroops  -  3 x Mechanised Infantry  -  2 x Motorised Inf Section  -  1 x Mercenaries  -  1 x Infantry  -  1 x Engineer  -  1 x Heavy Mech Infantry  -  1 x Guards Support Squad  -  1 x Engineer Support Squad	8	96	(26.98076211353316,2.5)
2052	16 x Fighter-Bomber	16	44	(10.959292143521045,39.25)
237	1 x Guerrilla Inf Squad	1	230	(32.609927238132009,4.75)
364	23 x Fortifications	23	0	(4.0310889132455356,7.75)
1846	1 x Fighter-Bomber	1	44	(5.3301270189221936,35.5)
2060	92 x Fighter-Bomber  -  5 x COIN Fighter Plane	92	44	(17.887495373796554,39.25)
372	2 x Airborne Support APC  -  1 x Improvised APC  -  1 x APC (Track)	2	124	(10.959292143521045,7.75)
2222	3 x Helicopter	3	53	(19.619546181365433,42.25)
1256	20 x AT Gun  -  1 x Heavy AT Gun  -  1 x Airborne Field Howitzer	20	6	(14.423393758658799,24.25)
1822	36 x Fighter-Bomber  -  7 x Air OP Aircraft  -  7 x Level Bomber  -  1 x COIN Fighter Plane	36	44	(19.619546181365433,34.75)
86	1 x Fortifications	1	0	(5.3301270189221936,2.5)
1149	3 x Field Gun	3	9	(25.248711305964282,22)
2131	2 x Fighter-Bomber  -  1 x COIN Fighter Plane	2	44	(10.093266739736606,40.75)
768	1 x Light Tank  -  1 x SP Flak  -  1 x Airborne Lt Tank	1	12	(7.49519052838329,15.25)
1363	9 x MBT  -  4 x Medium Tank  -  1 x SP Gun	9	59	(2.7320508075688772,26.5)
1580	2 x Infantry SAM  -  1 x Para Hy Inf-ATGM	2	29	(17.887495373796554,30.25)
1803	1 x Gunship Aircraft	1	215	(3.1650635094610968,34.75)
860	3 x Fighter-Bomber	3	44	(17.887495373796554,16.75)
1365	8 x Armoured Car  -  4 x Light Cavalry Tank  -  3 x Heavy Armoured Car  -  3 x Assault Gun  -  1 x Heavy APC	8	11	(4.4641016151377544,26.5)
978	3 x SP Gun  -  2 x SP Artillery  -  1 x Assault Gun	3	39	(15.722431864335457,19)
360	8 x Paratroops  -  7 x Light Infantry  -  5 x Marines  -  5 x Heavy Infantry  -  5 x Infantry  -  5 x Commandos  -  5 x Heavy Mech Infantry  -  4 x Mech Support Squad  -  3 x Bicycle Squad  -  3 x Mercenaries  -  3 x Mechanised Infantry  -  3 x Heavy Ski Troops  -  1 x Airmobile Section  -  1 x Mech Scouts  -  1 x Rifle Section  -  1 x Paratroop Support  -  1 x Airmobile Spt Section  -  1 x Commando Engineers  -  1 x Ski Troops  -  1 x Heavy Commandos  -  1 x Medium Infantry  -  1 x Para Medium Infantry  -  1 x Para Mortar Team	8	96	(34.774990747593108,7)
912	3 x AA Truck  -  2 x Flak	3	181	(27.846787517317598,17.5)
1576	1 x Guerrilla Inf Support	1	233	(14.423393758658799,30.25)
1620	42 x Infantry SAM  -  5 x SP SAM  -  1 x Area SAM	42	29	(17.454482671904334,31)
1297	7 x AT Gun	7	6	(14.856406460551018,25)
1886	7 x Fighter-Bomber  -  2 x SEAD Aircraft	7	44	(5.7631397208144124,36.25)
70	8 x Infantry  -  5 x Heavy Infantry  -  4 x Motorised Inf Section  -  4 x Heavy Mech Infantry  -  3 x Paratroops  -  2 x Mercenaries  -  2 x Light Mech Infantry  -  2 x Rangers  -  2 x Native Troops  -  2 x Marines  -  2 x Mechanised Infantry  -  2 x Medium Infantry  -  2 x Ranger Hvy Infantry Squad  -  1 x Light Guards Squad  -  1 x Guerrilla Inf Squad  -  1 x Medium Mech Infantry  -  1 x Commandos  -  1 x Marine Support Squad  -  1 x Rifle Section  -  1 x Ranger Lt Infantry Squad  -  1 x Airmobile Rifle Squad	8	1	(26.54774941164094,1.75)
1058	5 x SP Artillery  -  1 x SP Howitzer	5	21	(15.722431864335457,20.5)
1577	23 x Infantry SAM  -  2 x Paratroop Support  -  2 x Heavy Ski Troops	23	29	(15.289419162443238,30.25)
45	34 x Fortifications	34	0	(4.897114317029974,1.75)
1932	7 x Fighter-Bomber  -  1 x COIN Fighter Plane	7	44	(10.526279441628825,37)
2215	11 x Fighter-Bomber  -  1 x COIN Fighter Plane	11	44	(13.55736835487436,42.25)
743	1 x Mortar	1	5	(20.05255888325765,14.5)
1720	4 x Para Sniper  -  1 x Sniper  -  1 x Ranger Sniper  -  1 x Commando Inf-AT	4	143	(34.774990747593108,32.5)
225	1 x Irregulars  -  1 x Light Infantry	1	51	(22.217622392718749,4.75)
760	5 x Scout  -  5 x Commando Scouts  -  2 x Paratroop Scouts  -  2 x Ranger Scout  -  1 x Militia	5	58	(34.774990747593108,14.5)
780	3 x SP Rocket Launcher  -  3 x Rocket Launcher	3	151	(17.887495373796554,15.25)
404		0	\N	\N
251	20 x Patrol Boat  -  6 x Rivercraft  -  2 x FO Vehicle  -  1 x Landing Barge	20	199	(9.6602540378443873,5.5)
1548	3 x Inf-AT  -  1 x Inf-ATGM Team	3	2	(24.382685902179844,29.5)
2026	17 x APC (Wheel)  -  4 x Light APC  -  3 x Scout Vehicle  -  2 x Light Support APC  -  2 x Armoured Car  -  1 x APC  -  1 x Light MRV APC  -  1 x MRV APC  -  1 x Heavy APC  -  1 x Airborne APC  -  1 x MRV Light IFV	17	23	(22.650635094610966,38.5)
887	2 x SP Mortar  -  1 x O/M Heavy Artillery  -  1 x Engineer Tank  -  1 x Heavy APC	2	38	(6.196152422706632,17.5)
2024	1 x SP Rocket Launcher  -  1 x Engineer Tank	1	137	(20.918584287042091,38.5)
1513	5 x Ski Inf-AT  -  4 x Para Inf-AT  -  1 x SP Gun  -  1 x Engineer Support Squad  -  1 x Ranger Support Squad	5	165	(29.145825622994256,28.75)
1070	20 x Pack Howitzer  -  1 x Field Gun	20	196	(26.114736709748719,20.5)
1350	13 x Inf-RR Team  -  12 x Inf-AT  -  5 x Para-RR Team  -  1 x Paratroop Support  -  1 x Para Inf-AT  -  1 x Light AT Gun	13	208	(26.54774941164094,25.75)
1080	3 x Commando Scouts  -  2 x Motorcycle(Light Inf)  -  1 x Para Inf-AT  -  1 x Motorcycle  -  1 x Militia  -  1 x Armoured Car  -  1 x Inf-AT  -  1 x Commando Inf-AT  -  1 x Pioneers	3	88	(34.774990747593108,20.5)
1209	1 x MBT	1	59	(7.9282032302755088,23.5)
2263	2 x Helicopter  -  1 x Attack Helicopter	2	53	(20.05255888325765,43)
2306	41 x Helicopter  -  7 x Heavy Helicopter	41	53	(23.083647796503186,43.75)
1087	4 x Medium Tank  -  2 x MBT  -  1 x Obsolete Heavy Tank	4	13	(6.6291651245988508,21.25)
209	6 x Landing Barge	6	41	(8.3612159321677293,4.75)
1404	1 x Light Tank  -  1 x Airborne Lt Tank	1	12	(4.0310889132455356,27.25)
1617	6 x Infantry SAM	6	29	(14.856406460551018,31)
199	4 x Para Engineers  -  4 x Engineer  -  3 x Commando Engineers  -  2 x Light Commandos	4	20	(33.908965343808667,4)
1895	5 x Fighter-Bomber  -  4 x COIN Fighter Plane	5	44	(13.55736835487436,36.25)
1904	1 x Light Tank  -  1 x SP Flak  -  1 x Gun APC (Tracked)	1	12	(21.351596988934308,36.25)
1410	7 x SP Gun  -  3 x Assault Gun	7	39	(9.2272413359521668,27.25)
1750	4 x SP Artillery	4	21	(26.54774941164094,33.25)
945	24 x Heavy Mortar  -  3 x Mortar(Sub Type A)  -  1 x Mortar(Sub Type C)  -  1 x Pack Howitzer  -  1 x Mortar(Sub Type B)	24	152	(22.217622392718749,18.25)
1583	3 x Heavy Inf-ATGM  -  1 x Inf-ATGM Team	3	212	(20.48557158514987,30.25)
495	1 x Ranger Support Squad	1	114	(13.124355652982141,10)
2321	31 x Attack Helicopter	31	203	(1,44.5)
981	2 x SP Howitzer	2	130	(18.320508075688775,19)
2106	5 x APC (Track)  -  3 x Heavy Amphibian  -  1 x Airborne Support APC  -  1 x Engineer Tank  -  1 x Mine Clearing Tank  -  1 x LCS  -  1 x MRV IFV	5	25	(22.650635094610966,40)
60	44 x O/M Field Artillery  -  10 x O/M Medium Artillery	44	10	(17.887495373796554,1.75)
1923	15 x Fighter-Bomber	15	44	(2.7320508075688772,37)
1719	2 x Gunship Aircraft	2	215	(33.908965343808667,32.5)
2094	15 x Fighter-Bomber  -  1 x COIN Fighter Plane	15	44	(12.258330249197702,40)
2370	48 x SP SAM  -  7 x Area SAM	48	30	(9.2272413359521668,45.25)
671	1 x Para light Infantry  -  1 x Heavy Militia	1	191	(26.98076211353316,13)
618	25 x Heavy Mortar  -  5 x Mortar  -  1 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type D)  -  1 x Mortar(Sub Type B)	25	152	(16.155444566227676,12.25)
895	23 x SP Mortar  -  2 x Light SP Mortar  -  1 x SP Artillery	23	38	(13.124355652982141,17.5)
975	5 x SP Artillery	5	21	(13.124355652982141,19)
2198	1 x Paratroop Transport  -  1 x Utility Vehicle	1	26	(33.042939940024233,41.5)
894	5 x SP Artillery  -  1 x SP Mortar	5	21	(12.258330249197702,17.5)
1054	39 x SP Artillery  -  2 x SP Howitzer	39	21	(12.258330249197702,20.5)
1773	2 x Fighter-Bomber	2	44	(11.392304845413264,34)
422	2 x Machine Gun Section	2	4	(19.186533479473212,8.5)
1307	3 x AT Gun	3	6	(23.516660498395403,25)
1393	13 x Inf-AT  -  4 x Para Inf-AT  -  2 x Ski Inf-AT  -  2 x Commando Inf-AT  -  1 x Motorcycle(Light Inf)  -  1 x Marine Support Squad	13	2	(28.712812921102035,26.5)
105	3 x Medium Infantry  -  3 x Heavy Commandos  -  2 x Paratroop Support  -  2 x Heavy Ski Troops  -  2 x Mechanised Infantry  -  2 x Mech Support Squad  -  2 x Para light Infantry  -  2 x Heavy Infantry  -  2 x Infantry  -  1 x Marines  -  1 x Paratroops  -  1 x Marine Light Infantry  -  1 x Light Commandos  -  1 x Commandos  -  1 x Ranger Lt Infantry Squad  -  1 x Para Medium Infantry	3	64	(21.784609690826528,2.5)
327	8 x Fortifications	8	0	(6.196152422706632,7)
668	3 x Rangers  -  3 x Light Infantry  -  2 x Reserve Infantry  -  1 x Marines  -  1 x Patrol	3	111	(24.382685902179844,13)
2273	3 x Glider	3	47	(28.712812921102035,43)
1277	123 x Sniper  -  18 x Guerrilla Sniper  -  5 x Irregulars  -  3 x Patrol  -  2 x Ranger Sniper  -  1 x Ski Sniper	123	45	(32.609927238132009,24.25)
75	2 x Heavy Infantry  -  2 x Militia  -  1 x Ski Troops  -  1 x Infantry  -  1 x Medium Mech Infantry	2	189	(30.877876430563134,1.75)
469	4 x Infantry  -  3 x COIN Infantry Squad  -  2 x Reserve Infantry  -  2 x Paratroops  -  2 x Ski Troops  -  1 x Para light Infantry  -  1 x Cavalry  -  1 x Commandos  -  1 x Rifle Squad	4	1	(25.681724007856502,9.25)
1053	1 x SP Howitzer  -  1 x SP Artillery	1	130	(11.392304845413264,20.5)
1024	15 x Field Gun  -  1 x Howitzer	15	9	(21.351596988934308,19.75)
1521	12 x APC (Track)  -  3 x MRV APC  -  2 x Heavy Armoured Car  -  2 x Light Tank  -  2 x SP Flak  -  2 x Heavy APC  -  2 x Gun APC (Tracked)  -  2 x Light APC  -  1 x FO Vehicle  -  1 x SP Gun  -  1 x MRV IFV	12	25	(1,29.5)
124	23 x Fortifications	23	0	(4.0310889132455356,3.25)
905	58 x Field Gun  -  2 x Howitzer  -  2 x Heavy Mortar	58	9	(21.784609690826528,17.5)
1094	4 x SP Artillery	4	21	(12.691342951089922,21.25)
1660	15 x SP SAM  -  1 x Light SPAA Vehicle	15	30	(17.887495373796554,31.75)
1965	4 x Fighter-Bomber	4	44	(4.897114317029974,37.75)
1121	60 x MBT  -  25 x Medium Tank  -  3 x CS MBT  -  3 x Engineer Tank  -  3 x Mine Clearing Tank	60	59	(1,22)
229	2 x Heavy Infantry  -  2 x Paratroops  -  1 x SMG Section  -  1 x Reserve Infantry  -  1 x Infantry  -  1 x Mechanised Infantry  -  1 x Militia  -  1 x Ski Troops	2	40	(25.681724007856502,4.75)
510	3 x Partisan Band  -  1 x Heavy Ski Troops	3	78	(26.114736709748719,10)
1272	1 x Inf-AT  -  1 x Engineer Support Squad  -  1 x Inf-RR Team	1	195	(28.279800219209818,24.25)
245	2 x Fortifications	2	0	(4.4641016151377544,5.5)
425	34 x Machine Gun Section  -  6 x Para MG  -  5 x MG Section  -  1 x MG Unit  -  1 x LMG Section  -  1 x para MG Section	34	4	(21.784609690826528,8.5)
1044	2 x CS MBT  -  2 x Medium Tank	2	104	(3.598076211353316,20.5)
1390	47 x Inf-AT  -  12 x Para Inf-AT  -  3 x Marine Infantry AT  -  1 x Ranger Hvy Infantry Squad  -  1 x Inf-RR Team  -  1 x Ski Inf-AT	47	2	(26.114736709748719,26.5)
1870	1 x FO Vehicle	1	57	(26.114736709748719,35.5)
43	10 x Fortifications	10	0	(3.1650635094610968,1.75)
2346	16 x Helicopter  -  10 x Light Helicopter	16	53	(22.650635094610966,44.5)
1970	1 x Fighter-Bomber	1	44	(9.2272413359521668,37.75)
2377	29 x Area SAM  -  1 x SP SAM	29	16	(15.289419162443238,45.25)
2071	70 x APC (Track)  -  16 x Utility Vehicle  -  9 x Light APC  -  4 x Artillery Prime Mover  -  4 x Light Support APC  -  4 x Heavy APC  -  1 x APC  -  1 x APC (Wheel)  -  1 x Ammo Carrier	70	25	(27.413774815425377,39.25)
1015	2 x SP Mortar	2	38	(13.55736835487436,19.75)
166	17 x Fortifications	17	0	(5.3301270189221936,4)
1086	6 x MBT  -  5 x Medium Tank	6	59	(5.7631397208144124,21.25)
2269	92 x Landing Barge	92	41	(25.248711305964282,43)
1931	1 x Fighter-Bomber	1	44	(9.6602540378443873,37)
2029	8 x APC (Track)  -  4 x Scout Vehicle  -  3 x Light Support APC  -  1 x Light Amphibian  -  1 x Ammo Carrier  -  1 x Heavy APC  -  1 x APC (Wheel)	8	25	(25.248711305964282,38.5)
1855	5 x Fighter-Bomber  -  3 x COIN Fighter Plane	5	44	(13.124355652982141,35.5)
2178	41 x Level Bomber  -  2 x COIN Fighter Plane  -  1 x Flame Tank  -  1 x Fighter-Bomber  -  1 x Improvised APC	41	62	(15.722431864335457,41.5)
1650	9 x APC (Wheel)  -  2 x APC  -  1 x Light APC  -  1 x APC (Track)	9	23	(9.2272413359521668,31.75)
1857	7 x Fighter-Bomber  -  1 x COIN Fighter Plane	7	44	(14.856406460551018,35.5)
731	16 x Armoured Car  -  9 x Scout Vehicle  -  1 x Heavy Armoured Car	16	11	(9.6602540378443873,14.5)
920	7 x Heavy Infantry  -  3 x Ski Scouts  -  3 x Engineer Support Squad  -  3 x Airmobile Hvy Infantry  -  3 x Pioneers  -  2 x Inf-AT  -  2 x Ski Troops  -  2 x Guerrilla Inf Support  -  1 x Guards Infantry  -  1 x Guerrilla Lt Inf Squad  -  1 x Light Mech Infantry  -  1 x Paratroop Scouts  -  1 x Rangers	7	40	(34.774990747593108,17.5)
1187	30 x Field Gun  -  18 x Pack Howitzer  -  3 x Howitzer	30	9	(23.949673200287624,22.75)
1866	2 x SP Flak	2	22	(22.650635094610966,35.5)
522	9 x Flame Tank	9	17	(2.299038105676658,10.75)
1471	42 x Inf-AT  -  6 x Para Inf-AT  -  2 x Ski Inf-AT  -  1 x Guerrilla Inf Support  -  1 x Marine Support Squad  -  1 x Commando Inf-AT  -  1 x Marine Infantry AT  -  1 x Militia Support	42	2	(26.98076211353316,28)
423	41 x Machine Gun Section  -  6 x MG Section  -  5 x MG Unit  -  4 x Para MG  -  4 x Heavy MG Section  -  2 x Heavy MG  -  1 x Infantry SAM	41	4	(20.05255888325765,8.5)
1257	1 x AT Gun	1	6	(15.289419162443238,24.25)
1957	11 x Medium Truck  -  8 x Light Support APC  -  6 x Scout Vehicle  -  5 x Utility Vehicle  -  3 x Snow Vehicle  -  2 x APC (Wheel)  -  1 x APC (Track)  -  1 x Improvised APC  -  1 x Light Amphibian	11	27	(32.176914536239792,37)
3	5 x Fortifications	5	0	(2.7320508075688772,1)
431	4 x Mechanised Infantry  -  2 x Para light Infantry  -  2 x Medium Mech Infantry  -  1 x Paratroops  -  1 x Infantry  -  1 x Guerrilla Hvy Inf Squad  -  1 x Commandos  -  1 x Guerrilla Inf Squad  -  1 x Heavy Infantry	4	69	(26.98076211353316,8.5)
645	2 x Light Tank	2	12	(4.4641016151377544,13)
1585	1 x Inf-AT	1	2	(22.217622392718749,30.25)
201	63 x Fortifications	63	0	(1.4330127018922194,4.75)
597	4 x Para Mortar Team  -  3 x Guerrilla Scout  -  3 x Light Commandos  -  2 x Guards Scouts  -  2 x Commandos  -  2 x Police  -  1 x Rangers  -  1 x Motorcycle(Light Inf)  -  1 x COIN Lt Infantry Squad  -  1 x Guerrilla Inf Squad  -  1 x Ranger Pioneer  -  1 x Irregulars	4	173	(32.176914536239792,11.5)
2002	2 x SEAD Aircraft  -  1 x Fighter-Bomber	2	214	(1.8660254037844386,38.5)
2382	37 x Helicopter  -  14 x Heavy Helicopter  -  2 x Attack Helicopter	37	53	(19.619546181365433,45.25)
176	2 x O/M Heavy Artillery  -  1 x O/M Medium Artillery	2	156	(13.99038105676658,4)
797	2 x Motorcycle  -  1 x Para Inf-AT  -  1 x LMG Section	2	49	(32.609927238132009,15.25)
1444	3 x SP ATGM  -  1 x CS MBT  -  1 x MBT	3	19	(3.598076211353316,28)
2175	3 x Fighter-Bomber	3	44	(13.124355652982141,41.5)
87	8 x Fortifications	8	0	(6.196152422706632,2.5)
2039	1 x Wagon  -  1 x Artillery Prime Mover	1	109	(33.908965343808667,38.5)
2081	12 x Fighter-Bomber  -  9 x SEAD Aircraft	12	44	(1,40)
2309	1 x Heavy Amphibian	1	34	(25.681724007856502,43.75)
388	5 x Guards Squad  -  3 x Paratroops	5	90	(24.815698604072061,7.75)
1515	1 x COIN Fighter Plane  -  1 x Patrol	1	82	(30.877876430563134,28.75)
14	1 x O/M Heavy Artillery	1	156	(12.258330249197702,1)
884	5 x MBT  -  2 x FO Vehicle  -  1 x Medium Tank	5	59	(3.598076211353316,17.5)
344	12 x Machine Gun Section  -  5 x MG Section  -  4 x Para MG	12	4	(20.918584287042091,7)
476	3 x Light Mech Infantry  -  1 x Partisan Scouts  -  1 x Infantry  -  1 x Partisans	3	72	(31.743901834347572,9.25)
1988	7 x APC (Wheel)  -  5 x APC (Track)  -  4 x Light APC  -  2 x Light Support APC  -  1 x Scout Vehicle  -  1 x APC  -  1 x Gun APC (Tracked)  -  1 x Heavy APC  -  1 x Gun APC (Wheeled)	7	23	(24.815698604072061,37.75)
2190	2 x Heavy Amphibian  -  2 x Landing Barge  -  1 x Light Amphibian	2	34	(26.114736709748719,41.5)
1193	7 x Flak	7	8	(29.145825622994256,22.75)
472	1 x Infantry	1	1	(28.279800219209818,9.25)
649	1 x Close Support Tank  -  1 x Armoured Car  -  1 x MRV APC	1	15	(7.9282032302755088,13)
1616	3 x SP SAM	3	30	(13.99038105676658,31)
1794	2 x Light SPAA Vehicle	2	128	(29.578838324886476,34)
147	5 x Guerrilla Lt Inf Squad  -  3 x Militia Support  -  2 x Light Mech Infantry  -  2 x Marine Light Infantry  -  1 x Infantry  -  1 x Pioneers  -  1 x Ski Troops  -  1 x Heavy Infantry	5	231	(23.949673200287624,3.25)
873	1 x Machine Gun Section  -  1 x MG Unit	1	4	(29.145825622994256,16.75)
1431	4 x Inf-AT  -  1 x Ranger Hvy Infantry Squad  -  1 x Para Inf-AT	4	2	(27.413774815425377,27.25)
121	10 x Fortifications  -  5 x SP Mortar	10	0	(1.4330127018922194,3.25)
1206	2 x Medium Tank  -  1 x Engineer Tank  -  1 x MBT  -  1 x SP Artillery	2	13	(5.3301270189221936,23.5)
859	6 x Rocket Launcher	6	151	(17.021469970012117,16.75)
1318	36 x Scout  -  3 x Paratroop Scouts  -  2 x Guerrilla Scout  -  2 x Marine Scout  -  1 x Patrol  -  1 x Ski Scouts  -  1 x Commando Scouts	36	58	(33.042939940024233,25)
2242	4 x Attack Helicopter  -  3 x Light Attack Helicopter	4	203	(1.8660254037844386,43)
659	42 x Heavy Mortar  -  10 x Mortar  -  2 x Mortar(Sub Type A)  -  2 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type D)	42	152	(16.588457268119896,13)
1562	2 x APC (Track)  -  1 x APC  -  1 x Light Support APC  -  1 x APC (Wheel)	2	25	(2.299038105676658,30.25)
1849	6 x Fighter-Bomber	6	44	(7.9282032302755088,35.5)
1192	15 x Flak  -  1 x AA Truck	15	8	(28.279800219209818,22.75)
716	8 x Police  -  6 x Light Infantry  -  5 x Partisans  -  2 x Marine Scout  -  2 x Militia  -  1 x Light Militia  -  1 x Infantry  -  1 x Irregulars	8	178	(31.743901834347572,13.75)
916	2 x Irregulars  -  1 x Light Militia  -  1 x Patrol	2	75	(31.310889132455351,17.5)
1384	3 x Engineer Support Squad  -  2 x Inf-AT	3	195	(20.918584287042091,26.5)
161	9 x Fortifications	9	0	(1,4)
1036	38 x Militia  -  22 x Light Militia  -  18 x Reserve Infantry  -  12 x Infantry  -  7 x Partisans  -  4 x Light Infantry  -  4 x Rifle Squad  -  3 x Rifle Section  -  2 x Reserve Supt Squad  -  2 x Police  -  2 x COIN Lt Infantry Squad  -  1 x Partisan Band  -  1 x Cavalry  -  1 x HQ  -  1 x Commandos  -  1 x Partisan Scouts  -  1 x Guerrilla Inf Squad  -  1 x Light Commandos  -  1 x COIN Infantry Squad	38	189	(31.743901834347572,19.75)
1436	1 x Sniper	1	45	(31.743901834347572,27.25)
2033	41 x APC (Wheel)  -  5 x Light APC  -  3 x Light Support APC  -  3 x Light MRV APC  -  3 x MRV APC  -  3 x APC  -  2 x Heavy MRV APC  -  1 x Armoured Car	41	23	(28.712812921102035,38.5)
154	5 x Light Mech Infantry  -  3 x Reserve Infantry  -  3 x Rangers  -  1 x Ski Troops  -  1 x Commandos  -  1 x Ranger Scout  -  1 x Rifle Section  -  1 x Light Infantry  -  1 x Light Guards Squad  -  1 x COIN Infantry Squad  -  1 x Guerrilla Inf Squad  -  1 x Militia Support	5	72	(30.011851026778693,3.25)
584	1 x Mortar(Sub Type A)	1	200	(20.918584287042091,11.5)
1360	64 x HQ  -  56 x Art Observer  -  7 x Para Forward Observer	64	55	(35.208003449485325,25.75)
1127	2 x MBT	2	59	(6.196152422706632,22)
1329	3 x Fortifications  -  2 x CS MBT  -  1 x SP Artillery	3	0	(8.3612159321677293,25.75)
1694	19 x Fighter-Bomber  -  1 x COIN Bomber	19	44	(12.258330249197702,32.5)
1760	52 x Sniper  -  13 x Para Sniper  -  4 x Commando Sniper  -  2 x Marine Sniper  -  1 x Guerrilla Sniper  -  1 x Ski Sniper  -  1 x Ranger Sniper	52	45	(35.208003449485325,33.25)
35	7 x Engineer  -  3 x Pioneers  -  2 x Commando Engineers  -  1 x Paratroops	7	20	(30.444863728670914,1)
2001	1 x Fighter-Bomber	1	44	(1,38.5)
1609	2 x Light APC  -  2 x Light Support APC  -  1 x Heavy Amphibian  -  1 x APC (Track)  -  1 x APC (Wheel)	2	121	(7.9282032302755088,31)
1315	5 x Motorcycle  -  5 x SP Artillery  -  3 x SP Howitzer  -  1 x Light SP Mortar	5	21	(30.444863728670914,25)
1316	1 x Irregulars	1	75	(31.310889132455351,25)
1689	1 x Light Support APC  -  1 x Light MRV APC	1	219	(7.9282032302755088,32.5)
657	6 x Heavy Mortar  -  4 x Mortar(Sub Type A)	6	152	(14.856406460551018,13)
503	1 x Machine Gun Section  -  1 x MG Section	1	4	(20.05255888325765,10)
1245	6 x Engineer Tank  -  2 x Close Support Tank  -  1 x Mine Clearing Tank  -  1 x FO Vehicle	6	37	(4.897114317029974,24.25)
2067	21 x APC (Wheel)  -  5 x Light APC  -  4 x Heavy APC  -  4 x Scout Vehicle  -  3 x Light Support APC  -  1 x Armoured Car  -  1 x Improvised APC	21	23	(23.949673200287624,39.25)
173	10 x O/M Heavy Artillery  -  3 x O/M Medium Artillery	10	156	(11.392304845413264,4)
1249	30 x MBT  -  13 x Medium Tank  -  5 x Close Support Tank  -  4 x Obsolete Tank  -  3 x CS MBT  -  2 x Obsolete Heavy Tank  -  1 x Heavy Tank	30	59	(8.3612159321677293,24.25)
1455	1 x SP Gun	1	39	(13.124355652982141,28)
963	1 x Cavalry Tank  -  1 x MBT	1	59	(2.7320508075688772,19)
1037	2 x Police	2	178	(32.609927238132009,19.75)
1168	1 x Close Support Tank	1	15	(7.49519052838329,22.75)
1687	3 x FO Vehicle  -  2 x Armoured Car  -  1 x Scout Vehicle  -  1 x Heavy APC	3	57	(6.196152422706632,32.5)
2258	3 x Attack Helicopter	3	203	(15.722431864335457,43)
2394	89 x Paratroop Transport  -  1 x Transport Aircraft	89	60	(30.011851026778693,45.25)
878	9 x Scout  -  4 x Paratroop Scouts  -  2 x Commando Scouts  -  2 x Guerrilla Inf Squad  -  1 x Medium Commandos  -  1 x Militia  -  1 x Mech Scouts  -  1 x Ranger Scout	9	58	(33.47595264191645,16.75)
2097	6 x Level Bomber  -  1 x Fighter-Bomber	6	62	(14.856406460551018,40)
2134	43 x Fighter-Bomber  -  1 x COIN Fighter Plane	43	44	(12.691342951089922,40.75)
375	4 x O/M Rocket Arty	4	31	(13.55736835487436,7.75)
792	49 x MG Section  -  33 x MG Unit  -  22 x Heavy MG  -  20 x Machine Gun Section  -  18 x Flak  -  5 x Para MG  -  1 x Infantry SAM  -  1 x Heavy MG Section	49	194	(28.279800219209818,15.25)
784	5 x O/M Heavy Artillery  -  3 x O/M Medium Artillery  -  3 x O/M Field Artillery	5	156	(21.351596988934308,15.25)
2163	5 x SEAD Aircraft  -  1 x SP Flak	5	214	(2.7320508075688772,41.5)
2381	10 x Heavy Helicopter  -  10 x Helicopter	10	53	(18.753520777580992,45.25)
448	12 x Light Tank  -  6 x Medium Tank  -  5 x MBT  -  4 x Armoured Car  -  2 x Heavy Armoured Car  -  1 x Infantry Tank  -  1 x Obsolete Tank	12	12	(7.49519052838329,9.25)
1145	19 x Field Gun  -  17 x Pack Howitzer  -  2 x Howitzer	19	9	(21.784609690826528,22)
1894	3 x Fighter-Bomber  -  2 x Level Bomber	3	44	(12.691342951089922,36.25)
1883	1 x Flak	1	8	(3.1650635094610968,36.25)
2123	15 x SEAD Aircraft  -  7 x Fighter-Bomber	15	214	(3.1650635094610968,40.75)
907	2 x Mortar(Sub Type A)	2	200	(23.516660498395403,17.5)
1159	3 x Militia	3	189	(33.908965343808667,22)
2227	11 x Landing Barge	11	41	(23.949673200287624,42.25)
933	5 x SP Artillery	5	21	(11.825317547305483,18.25)
306	6 x Infantry  -  4 x Guerrilla Inf Squad  -  2 x Militia  -  2 x Irregulars  -  1 x Marine Light Infantry  -  1 x Native Troops  -  1 x Light Commandos  -  1 x Reserve Infantry  -  1 x Guards Squad	6	1	(23.083647796503186,6.25)
757	6 x Patrol  -  5 x Cavalry Scouts  -  5 x Guerrilla Scout  -  5 x Scout  -  4 x Guerrilla Lt Inf Squad  -  2 x Guards Scouts  -  2 x Light Militia  -  1 x COIN Scout	6	82	(32.176914536239792,14.5)
773	1 x SP Artillery	1	21	(11.825317547305483,15.25)
1027	15 x Pack Howitzer  -  3 x Field Gun  -  1 x Mortar(Sub Type A)	15	196	(23.949673200287624,19.75)
1608	33 x APC (Wheel)  -  4 x Light Support APC  -  3 x Light APC  -  1 x Heavy APC  -  1 x APC (Track)  -  1 x APC  -  1 x Heavy Amphibian	33	23	(7.0621778264910704,31)
1570	1 x SP Gun  -  1 x APC (Wheel)	1	39	(9.2272413359521668,30.25)
345	1 x Light Commandos	1	85	(21.784609690826528,7)
442	4 x CS MBT  -  4 x SP Artillery  -  1 x MBT  -  1 x Medium Tank	4	104	(2.299038105676658,9.25)
989	3 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type A)  -  1 x Heavy Mortar  -  1 x Mortar(Sub Type B)	3	202	(25.248711305964282,19)
2042	1 x Fighter-Bomber	1	44	(2.299038105676658,39.25)
436	5 x Mechanised Infantry  -  5 x Light Infantry  -  3 x Heavy Infantry  -  2 x Marines  -  1 x Commando Engineers  -  1 x Rifle Squad  -  1 x Paratroops  -  1 x Infantry  -  1 x Heavy Militia  -  1 x Medium Infantry  -  1 x Reserve Infantry	5	51	(31.310889132455351,8.5)
972	1 x SP Howitzer	1	130	(10.526279441628825,19)
1326	4 x MBT  -  3 x Medium Tank  -  2 x Cavalry Tank  -  1 x SP Gun  -  1 x Assault Gun  -  1 x Light MRV APC	4	59	(5.7631397208144124,25.75)
150	1 x Marines  -  1 x Infantry	1	1	(26.54774941164094,3.25)
308	2 x Paratroops  -  1 x Para light Infantry  -  1 x Infantry  -  1 x Commandos  -  1 x Rangers  -  1 x Medium Infantry	2	96	(24.815698604072061,6.25)
943	16 x Rocket Launcher  -  4 x Guerrilla Rocket  -  2 x Mortar(Sub Type C)  -  1 x SP Rocket Launcher	16	151	(20.48557158514987,18.25)
1030	4 x Mortar(Sub Type A)  -  2 x Mortar(Sub Type C)  -  1 x Field Gun	4	200	(26.54774941164094,19.75)
1411	12 x SP Gun  -  9 x Assault Gun  -  2 x Fortifications  -  1 x Obsolete Tank	12	39	(10.093266739736606,27.25)
490	18 x Light Tank  -  18 x MBT  -  3 x Obsolete Tank  -  2 x Medium Tank  -  2 x Light Cavalry Tank  -  2 x Infantry Tank  -  1 x Cavalry Tank  -  1 x CS MBT  -  1 x Close Support Tank	18	12	(8.794228634059948,10)
926	1 x CS MBT	1	104	(5.7631397208144124,18.25)
2041	38 x Fighter-Bomber  -  15 x SEAD Aircraft  -  1 x COIN Fighter Plane	38	44	(1.4330127018922194,39.25)
331	5 x Patrol Boat  -  2 x Torpedo Boat  -  1 x Heavy Amphibian  -  1 x Rivercraft	5	199	(9.6602540378443873,7)
798	2 x Militia	2	189	(33.47595264191645,15.25)
1547	6 x Inf-AT  -  6 x Para Inf-AT  -  6 x Inf-RR Team  -  4 x Para-RR Team  -  3 x Marine Infantry AT  -  1 x Heavy Inf-ATGM  -  1 x Ski Inf-AT  -  1 x AT Gun  -  1 x Inf-ATGM Team	6	142	(23.516660498395403,29.5)
874	10 x Machine Gun Section  -  9 x MG Unit  -  8 x MG Section  -  2 x Reserve Supt Squad	10	4	(30.011851026778693,16.75)
1939	3 x Fighter-Bomber	3	44	(16.588457268119896,37)
63	1 x MG Unit  -  1 x Marine Support Squad	1	193	(20.48557158514987,1.75)
1695	23 x Fighter-Bomber	23	44	(13.124355652982141,32.5)
711	1 x Para light Infantry	1	98	(27.413774815425377,13.75)
917	8 x Scout  -  3 x Militia  -  2 x Motorcycle(Light Inf)  -  2 x Paratroop Scouts  -  2 x Infantry  -  2 x Medium Commandos  -  1 x Heavy Militia  -  1 x Light Militia  -  1 x Guerrilla Inf Squad  -  1 x Ski Scouts  -  1 x Commando Scouts  -  1 x Mech Scouts	8	58	(32.176914536239792,17.5)
260	1 x Fortifications	1	0	(17.454482671904334,5.5)
411	4 x Scout Vehicle  -  2 x Light APC  -  1 x Heavy Amphibian  -  1 x Light Support APC  -  1 x Gun APC (Tracked)  -  1 x MRV APC	4	32	(9.6602540378443873,8.5)
445	2 x Mine Clearing Tank	2	36	(4.897114317029974,9.25)
1302	15 x AT Gun  -  2 x Light AT Gun  -  1 x Heavy MG	15	6	(19.186533479473212,25)
832	5 x MG Section  -  1 x MG Unit  -  1 x Heavy MG  -  1 x para MG Section	5	194	(27.846787517317598,16)
1160	247 x HQ	247	55	(34.774990747593108,22)
908	4 x Mortar(Sub Type C)  -  2 x Mortar(Sub Type D)  -  2 x Mortar(Sub Type B)  -  1 x Mortar(Sub Type A)  -  1 x Heavy Mortar	4	202	(24.382685902179844,17.5)
1900	7 x Fighter-Bomber	7	44	(17.887495373796554,36.25)
1324	2 x Light Tank  -  1 x Gun APC (Tracked)	2	12	(4.0310889132455356,25.75)
2137	21 x Level Bomber  -  2 x COIN Bomber  -  1 x Fighter-Bomber	21	62	(15.289419162443238,40.75)
88	26 x Fortifications	26	0	(7.0621778264910704,2.5)
118	2 x Marine Engineers  -  2 x Commando Engineers  -  2 x Para Engineers  -  2 x Engineer	2	171	(33.042939940024233,2.5)
130	26 x Patrol Boat  -  2 x Heavy Amphibian  -  1 x Amphibian Tank	26	199	(9.2272413359521668,3.25)
272	4 x Commandos  -  3 x Commando Scouts  -  2 x Guards Squad  -  1 x Motorised Inf Section  -  1 x Paratroops  -  1 x Para Engineers  -  1 x Motorcycle(Heavy Inf)  -  1 x Rangers  -  1 x Guards Infantry  -  1 x Engineer  -  1 x Commando Engineers  -  1 x Ski Troops	4	83	(27.846787517317598,5.5)
1161	15 x MBT  -  6 x CS MBT  -  2 x Medium Tank  -  1 x Heavy APC	15	59	(1.4330127018922194,22.75)
1667	1 x Heavy Amphibian	1	34	(23.949673200287624,31.75)
223	88 x Fortifications	88	0	(20.48557158514987,4.75)
240	13 x Engineer  -  8 x Pioneers  -  7 x Commando Engineers  -  5 x Para Engineers  -  4 x Commandos  -  2 x Rangers  -  2 x Commando Scouts  -  1 x Ranger Pioneer  -  1 x Infantry  -  1 x Rifle Section  -  1 x Paratroop Support  -  1 x Light Commandos  -  1 x Ranger Hvy Infantry Squad  -  1 x Partisan Band  -  1 x Commando Support  -  1 x Mercenaries	13	20	(35.208003449485325,4.75)
1084	22 x MBT  -  13 x Medium Tank  -  4 x Main Battle Tank  -  2 x Fortifications  -  1 x CS MBT  -  1 x FO Vehicle	22	59	(4.0310889132455356,21.25)
283	36 x Fortifications	36	0	(3.1650635094610968,6.25)
1774	1 x Fighter-Bomber	1	44	(12.258330249197702,34)
772	7 x SP Artillery  -  2 x SP Howitzer	7	21	(10.959292143521045,15.25)
1088	5 x Medium Tank  -  1 x CS Infantry Tank	5	13	(7.49519052838329,21.25)
1888	2 x Fighter-Bomber	2	44	(7.49519052838329,36.25)
231	7 x Heavy Infantry  -  5 x Rifle Section  -  4 x Medium Infantry  -  4 x Infantry  -  4 x Rangers  -  2 x Marine Support Squad  -  2 x Reserve Infantry  -  1 x Light Mech Infantry  -  1 x Paratroop Scouts  -  1 x Guerrilla Hvy Inf Squad  -  1 x Native Troops  -  1 x Light Infantry  -  1 x Legionnaires  -  1 x Heavy Mech Infantry  -  1 x Marines  -  1 x Mechanised Infantry  -  1 x Paratroop Support  -  1 x Motorised Inf Section  -  1 x Engineer Support Squad  -  1 x Commando Scouts	7	40	(27.413774815425377,4.75)
2352	59 x Paratroop Transport  -  2 x Transport Aircraft	59	60	(27.846787517317598,44.5)
1424	26 x Inf-ATGM Team  -  8 x Para-ATGM Team  -  6 x Inf-AT  -  4 x Para Inf-AT  -  3 x Heavy Inf-ATGM  -  2 x Ranger Hvy Infantry Squad	26	206	(21.351596988934308,27.25)
383	1 x Machine Gun Section	1	4	(20.48557158514987,7.75)
1195	5 x Motorcycle(Light Inf)  -  1 x Motorcycle	5	187	(30.877876430563134,22.75)
1454	15 x Light Tank  -  6 x MBT  -  1 x CS MBT  -  1 x Armoured Car	15	12	(12.258330249197702,28)
2341	20 x Helicopter	20	53	(18.320508075688775,44.5)
612	6 x Armoured Car  -  2 x Scout Vehicle  -  2 x Light Tank  -  1 x MBT  -  1 x Obsolete Tank	6	11	(10.959292143521045,12.25)
405		0	\N	\N
925	7 x MBT  -  7 x Medium Tank  -  2 x Close Support Tank  -  1 x Heavy Tank  -  1 x Armoured Car	7	59	(4.897114317029974,18.25)
1918	3 x Improvised APC  -  1 x Scout Vehicle  -  1 x Light APC  -  1 x Light Support APC	3	136	(33.47595264191645,36.25)
2283	8 x Attack Helicopter  -  2 x Light Attack Helicopter	8	203	(3.1650635094610968,43.75)
2281	50 x Attack Helicopter	50	203	(1.4330127018922194,43.75)
1791	4 x SP Flak	4	22	(26.98076211353316,34)
1538	31 x Infantry SAM  -  1 x Para light Infantry	31	29	(15.722431864335457,29.5)
962	6 x MBT  -  1 x CS Infantry Tank  -  1 x Obsolete Tank	6	59	(1.8660254037844386,19)
1119	24 x Paratroop Scouts  -  12 x Motorcycle(Light Inf)  -  9 x Scout  -  8 x Ranger Scout  -  5 x Marine Scout  -  4 x Guerrilla Scout  -  4 x Commando Scouts  -  3 x Ski Scouts  -  1 x Ranger Pioneer  -  1 x Inf-AT  -  1 x Irregulars	24	101	(34.341978045700891,21.25)
1534	23 x SP Flak  -  8 x Armoured Car  -  1 x Light Tank	23	22	(12.258330249197702,29.5)
1709	7 x Wheeled SP-ATGM  -  3 x SP ATGM	7	52	(25.248711305964282,32.5)
263	1 x Fortifications	1	0	(20.05255888325765,5.5)
740	3 x SP Rocket Launcher	3	137	(17.454482671904334,14.5)
1379	32 x AT Gun  -  1 x Heavy AT Gun  -  1 x Light AT Gun	32	6	(16.588457268119896,26.5)
1801	2 x Close Support Tank  -  2 x MBT  -  1 x Amphibian Tank  -  1 x Light APC  -  1 x APC (Track)  -  1 x APC (Wheel)	2	15	(1.4330127018922194,34.75)
2209	1 x Fighter-Bomber	1	44	(8.3612159321677293,42.25)
1185	25 x Field Gun  -  1 x Howitzer  -  1 x Pack Howitzer	25	9	(22.217622392718749,22.75)
7	107 x Fortifications	107	0	(6.196152422706632,1)
453	4 x Armoured Car  -  3 x SP Mortar  -  3 x SP Flak  -  2 x Light Tank  -  1 x Ammo Carrier  -  1 x MBT  -  1 x Light Cavalry Tank	4	11	(11.825317547305483,9.25)
106	2 x Light Infantry  -  1 x Marines  -  1 x Marine Light Infantry  -  1 x Infantry  -  1 x Paratroop Scouts  -  1 x Guards Squad	2	51	(22.650635094610966,2.5)
120	2 x Inf-AT  -  2 x Irregulars	2	2	(34.774990747593108,2.5)
285	5 x Fortifications	5	0	(4.897114317029974,6.25)
681	3 x MBT  -  2 x Mine Clearing Tank  -  1 x Close Support Tank  -  1 x Medium Tank  -  1 x Obsolete Tank	3	59	(1.4330127018922194,13.75)
2334	3 x SP SAM	3	30	(12.258330249197702,44.5)
866	27 x Field Gun  -  1 x Howitzer	27	9	(23.083647796503186,16.75)
601	26 x MBT  -  17 x Heavy Tank  -  8 x CS MBT  -  7 x Medium Tank  -  5 x Flame Tank  -  3 x Obsolete Tank  -  2 x Fortifications  -  1 x Close Support Tank	26	59	(1.4330127018922194,12.25)
664	38 x Mortar  -  1 x Mortar(Sub Type C)  -  1 x Heavy Mortar  -  1 x Para Mortar Team	38	5	(20.918584287042091,13)
647	1 x Light Tank  -  1 x Armoured Car  -  1 x Obsolete Tank	1	12	(6.196152422706632,13)
1351	1 x Inf-RR Team	1	208	(27.413774815425377,25.75)
1046	12 x Mine Clearing Tank  -  5 x Engineer Tank  -  2 x CS MBT  -  2 x Medium Tank  -  2 x Obsolete Tank	12	36	(5.3301270189221936,20.5)
1191	41 x Flak	41	8	(27.413774815425377,22.75)
1167	13 x MBT  -  5 x Medium Tank  -  1 x Close Support Tank  -  1 x Mine Clearing Tank	13	59	(6.6291651245988508,22.75)
1495	1 x Scout Vehicle  -  1 x Light Tank  -  1 x Armoured Car	1	32	(13.55736835487436,28.75)
665	36 x Mortar  -  4 x Mortar(Sub Type A)  -  4 x Mortar(Sub Type B)	36	5	(21.784609690826528,13)
577	17 x Heavy Mortar  -  9 x Mortar  -  2 x Mortar(Sub Type A)  -  1 x Mortar(Sub Type B)	17	152	(14.856406460551018,11.5)
2342	27 x Helicopter  -  11 x Heavy Helicopter  -  1 x Attack Helicopter	27	53	(19.186533479473212,44.5)
1848	1 x Fighter-Bomber	1	44	(7.0621778264910704,35.5)
550	1 x Rifle Section	1	67	(26.54774941164094,10.75)
1439	16 x Scout  -  8 x HQ  -  8 x Paratroop Scouts  -  2 x Marine Scout  -  1 x Patrol  -  1 x Guerrilla Scout  -  1 x Mech Scouts  -  1 x Native Troops  -  1 x Ranger Scout	16	58	(34.341978045700891,27.25)
1728	4 x Fighter-Bomber	4	44	(7.49519052838329,33.25)
1676	39 x Sniper  -  1 x Para Sniper  -  1 x Ranger Sniper	39	45	(31.743901834347572,31.75)
807	2 x MRV IFV  -  2 x APC (Track)  -  1 x Heavy MRV APC  -  1 x APC (Wheel)	2	25	(6.196152422706632,16)
1929	39 x Fighter-Bomber  -  1 x COIN Fighter Plane	39	44	(7.9282032302755088,37)
2056	2 x Level Bomber	2	62	(14.423393758658799,39.25)
384	1 x Machine Gun Section	1	4	(21.351596988934308,7.75)
1946	7 x Scout Vehicle  -  1 x Light MRV APC	7	32	(22.650635094610966,37)
399	3 x Infantry  -  2 x Heavy Infantry  -  1 x Legion SMG Squad  -  1 x Paratroops  -  1 x Commandos  -  1 x Rangers	3	1	(34.341978045700891,7.75)
700	3 x Para Mortar Team	3	173	(17.887495373796554,13.75)
1076	18 x Light Militia  -  6 x Militia  -  4 x Light Infantry  -  3 x Guerrilla Inf Squad  -  3 x Police  -  3 x Irregulars  -  2 x Mech Scouts  -  1 x Commandos  -  1 x Motorcycle(Heavy Inf)  -  1 x Infantry  -  1 x Partisans	18	190	(31.310889132455351,20.5)
1143	1 x Field Gun	1	9	(20.05255888325765,22)
1872	21 x FO Vehicle  -  2 x APC (Wheel)  -  1 x Scout Vehicle  -  1 x Light APC  -  1 x SP Flak	21	57	(27.846787517317598,35.5)
1831	29 x SP Flak  -  2 x Light SPAA Vehicle	29	22	(27.413774815425377,34.75)
1545	26 x Inf-ATGM Team  -  4 x Para Inf-AT  -  3 x Inf-AT  -  2 x Para-ATGM Team  -  2 x Ski Inf-AT  -  1 x Para Hy Inf-ATGM	26	206	(21.784609690826528,29.5)
518	2 x Guerrilla Lt Inf Squad  -  1 x Partisan Scouts	2	231	(33.042939940024233,10)
1174	1 x Airborne Lt Tank	1	175	(12.691342951089922,22.75)
268	2 x Marines  -  1 x Reserve Infantry  -  1 x Infantry  -  1 x Rangers	2	110	(24.382685902179844,5.5)
549	5 x Rifle Squad  -  4 x Irregulars  -  3 x Partisan Scouts  -  3 x Light Infantry  -  3 x COIN Lt Infantry Squad  -  3 x Patrol  -  2 x Militia  -  2 x Heavy Infantry  -  2 x Native Troops  -  2 x Engineer  -  2 x Medium Infantry  -  2 x Guerrilla Inf Squad  -  1 x Commando Engineers  -  1 x Partisan Band  -  1 x Commando Scouts  -  1 x Marines  -  1 x Infantry  -  1 x Guerrilla Hvy Inf Squad  -  1 x Partisans	5	68	(25.681724007856502,10.75)
1512	1 x Improvised APC	1	136	(28.279800219209818,28.75)
1092	1 x CS MBT  -  1 x APC (Track)  -  1 x Heavy APC	1	120	(10.959292143521045,21.25)
1085	4 x Medium Tank  -  1 x CS MBT  -  1 x Mine Clearing Tank  -  1 x MBT  -  1 x Fortifications	4	13	(4.897114317029974,21.25)
406		0	\N	\N
407		0	\N	\N
1680	56 x Sniper  -  23 x Para Sniper  -  18 x Commando Sniper  -  5 x Ski Sniper  -  2 x Ranger Sniper  -  1 x AGL  -  1 x Commando Inf-AT  -  1 x Guerrilla Sniper  -  1 x Patrol  -  1 x Flak  -  1 x Marine Sniper	56	45	(35.208003449485325,31.75)
214	29 x O/M Rocket Arty	29	31	(12.691342951089922,4.75)
310	1 x Guerrilla Inf Squad  -  1 x Partisan Band	1	230	(26.54774941164094,6.25)
2121	26 x Fighter-Bomber	26	44	(1.4330127018922194,40.75)
2162	3 x SP Flak  -  1 x Attack Helicopter	3	22	(1.8660254037844386,41.5)
1541	10 x Inf-ATGM Team  -  2 x Para Inf-AT	10	206	(18.320508075688775,29.5)
1614	8 x Armoured Car  -  8 x FO Vehicle  -  6 x Scout Vehicle  -  2 x Light APC  -  1 x Heavy Armoured Car	8	11	(12.258330249197702,31)
397	2 x Engineer Support Squad  -  1 x Commando Engineers  -  1 x Heavy Infantry  -  1 x Infantry  -  1 x Commandos	2	195	(32.609927238132009,7.75)
1627	6 x Light SP ATGM  -  4 x Wheeled SP-ATGM  -  2 x Airborne Support APC  -  2 x SP ATGM	6	129	(23.516660498395403,31)
1659	4 x Infantry SAM	4	29	(17.021469970012117,31.75)
836	3 x LMG Section  -  2 x Ranger Support Squad  -  1 x MG Unit	3	65	(31.310889132455351,16)
1490	2 x SP Gun  -  1 x Assault Gun	2	39	(9.2272413359521668,28.75)
2136	8 x Level Bomber  -  2 x Fighter-Bomber  -  1 x COIN Bomber	8	62	(14.423393758658799,40.75)
1746	1 x Airborne Support APC	1	124	(23.083647796503186,33.25)
486	1 x Medium Tank	1	13	(5.3301270189221936,10)
1519	7 x Scout  -  4 x Airborne Support APC  -  4 x FO Vehicle  -  3 x Paratroop Scouts  -  2 x Marine Scout  -  1 x AGL  -  1 x Patrol  -  1 x Mech Scouts  -  1 x Marine Sniper  -  1 x Art Observer  -  1 x MG Unit  -  1 x Sniper  -  1 x Motorcycle(Light Inf)  -  1 x Guerrilla Sniper	7	58	(34.341978045700891,28.75)
2324	7 x Attack Helicopter  -  5 x Helicopter  -  3 x Light Attack Helicopter	7	203	(3.598076211353316,44.5)
330	13 x Patrol Boat  -  6 x Rivercraft  -  1 x LCG	13	199	(8.794228634059948,7)
2366	12 x Attack Helicopter  -  1 x Light Attack Helicopter	12	203	(5.7631397208144124,45.25)
1476	87 x Sniper  -  8 x Guerrilla Sniper  -  5 x Ski Sniper  -  4 x Para Sniper  -  2 x Marine Sniper  -  1 x Ranger Sniper  -  1 x Commando Sniper  -  1 x Partisan Scouts  -  1 x Patrol	87	45	(31.310889132455351,28)
1069	4 x Pack Howitzer  -  2 x Field Gun  -  1 x Mortar(Sub Type A)  -  1 x Mortar(Sub Type B)	4	196	(25.248711305964282,20.5)
1462	6 x Inf-AT  -  5 x Inf-ATGM Team  -  4 x Para-ATGM Team  -  1 x Fortifications  -  1 x Heavy Inf-ATGM	6	2	(19.186533479473212,28)
2301	29 x Helicopter  -  6 x Attack Helicopter	29	53	(18.753520777580992,43.75)
2082	3 x Fighter-Bomber	3	44	(1.8660254037844386,40)
2187	30 x Landing Barge  -  12 x Ammo Carrier  -  7 x LCG	30	41	(23.516660498395403,41.5)
1818	4 x Fighter-Bomber  -  1 x COIN Fighter Plane	4	44	(16.155444566227676,34.75)
1250	1 x Heavy Tank	1	14	(9.2272413359521668,24.25)
957	11 x Scout  -  3 x Paratroop Scouts  -  2 x Ranger Pioneer  -  2 x HQ  -  2 x Ranger Scout  -  1 x Rangers  -  1 x Police	11	58	(32.609927238132009,18.25)
1162	23 x MBT  -  4 x CS MBT  -  1 x Captured Tank  -  1 x Medium Tank	23	59	(2.299038105676658,22.75)
2399	90 x Ammo Carrier  -  8 x Demolition  -  1 x Utility Vehicle	90	56	(34.341978045700891,45.25)
292	1 x Patrol Boat  -  1 x Hovercraft	1	199	(10.959292143521045,6.25)
168	3 x Fortifications	3	0	(7.0621778264910704,4)
2109	9 x APC (Wheel)  -  1 x Scout Vehicle  -  1 x APC  -  1 x Light Support APC  -  1 x Snow Vehicle	9	23	(25.248711305964282,40)
1383	1 x Inf-AT	1	2	(20.05255888325765,26.5)
2221	17 x Light Helicopter  -  8 x Helicopter	17	204	(18.753520777580992,42.25)
238	2 x Mechanised Infantry  -  2 x Para Engineers  -  1 x Engineer	2	69	(33.47595264191645,4.75)
1802	3 x Heavy AT Gun  -  2 x Heavy APC  -  1 x Armoured Car  -  1 x FO Vehicle	3	158	(2.299038105676658,34.75)
1922	4 x Fighter-Bomber	4	44	(1.8660254037844386,37)
1933	2 x COIN Fighter Plane  -  2 x Fighter-Bomber  -  1 x Level Bomber	2	223	(11.392304845413264,37)
27	2 x Ski Troops  -  1 x Marines  -  1 x Para Medium Infantry  -  1 x Mech Support Squad	2	162	(23.516660498395403,1)
1854	19 x Fighter-Bomber  -  3 x COIN Fighter Plane	19	44	(12.258330249197702,35.5)
2185	6 x LCG  -  1 x Patrol Boat	6	46	(21.784609690826528,41.5)
765	7 x Light APC  -  5 x APC (Track)  -  1 x Airborne APC  -  1 x APC (Wheel)	7	121	(4.897114317029974,15.25)
942	5 x SP Rocket Launcher  -  2 x SP Gun  -  1 x Rocket Launcher	5	137	(19.619546181365433,18.25)
1399	8 x Para Forward Observer  -  1 x Guards Scouts	8	229	(33.908965343808667,26.5)
2233	83 x Heavy Transporter	83	138	(29.145825622994256,42.25)
2130	4 x Fighter-Bomber  -  1 x COIN Fighter Plane	4	44	(9.2272413359521668,40.75)
1093	2 x Light SP Mortar	2	133	(11.825317547305483,21.25)
2116	2 x Medium Truck  -  2 x Light Truck  -  1 x Artillery Prime Mover	2	27	(31.310889132455351,40)
261	4 x Fortifications	4	0	(18.320508075688775,5.5)
1502	2 x Inf-ATGM Team  -  1 x Inf-AT  -  1 x Heavy Inf-ATGM	2	206	(19.619546181365433,28.75)
335	10 x O/M Rocket Arty	10	31	(13.124355652982141,7)
1597	38 x Art Observer  -  7 x Para Forward Observer  -  2 x Marine Forward Observer	38	63	(32.609927238132009,30.25)
1898	4 x Fighter-Bomber  -  3 x COIN Fighter Plane	4	44	(16.155444566227676,36.25)
2229	1 x Rivercraft	1	197	(25.681724007856502,42.25)
555	6 x Marine Light Infantry  -  2 x Guards Scouts  -  2 x Para light Infantry  -  2 x Guerrilla Inf Squad  -  2 x Cavalry Scouts  -  2 x Native Troops  -  2 x Mechanised Infantry  -  1 x Marine Support Squad  -  1 x Rangers  -  1 x Ranger Lt Infantry Squad  -  1 x Light Infantry  -  1 x Militia Support  -  1 x Partisan Scouts  -  1 x Commando Engineers  -  1 x Reserve Infantry  -  1 x Light Mech Infantry  -  1 x Militia	6	112	(30.877876430563134,10.75)
838	1 x Guerrilla Lt Inf Squad  -  1 x Militia Support  -  1 x Infantry  -  1 x Militia	1	1	(33.042939940024233,16)
1073	1 x Pack Howitzer	1	196	(28.712812921102035,20.5)
57	3 x O/M Heavy Artillery  -  2 x O/M Medium Artillery	3	156	(15.289419162443238,1.75)
239	4 x Engineer  -  1 x Rangers	4	20	(34.341978045700891,4.75)
1243	8 x MBT  -  2 x Mine Clearing Tank  -  1 x Main Battle Tank  -  1 x Obsolete Tank	8	59	(3.1650635094610968,24.25)
554	11 x Infantry  -  8 x Partisans  -  7 x Rangers  -  6 x Marines  -  4 x Light Infantry  -  4 x Mechanised Infantry  -  3 x Marine Light Infantry  -  3 x Guards Infantry  -  3 x Militia  -  3 x Motorised Inf Section  -  3 x Commando Scouts  -  2 x Reserve Infantry  -  2 x Police  -  2 x Paratroops  -  1 x Heavy Mech Infantry  -  1 x Guards Support Squad  -  1 x Partisan Support  -  1 x Guerrilla Inf Squad  -  1 x Guerrilla Inf Support  -  1 x Heavy Infantry  -  1 x Hvy Bicycle Squad  -  1 x Rifle Squad  -  1 x Medium Guards Squad  -  1 x Guards Squad  -  1 x Heavy Militia  -  1 x Rifle Section  -  1 x Legionnaires	11	1	(30.011851026778693,10.75)
805	5 x APC (Track)  -  1 x APC	5	25	(4.4641016151377544,16)
1777	1 x Fighter-Bomber	1	44	(14.856406460551018,34)
191	2 x Reserve Infantry  -  1 x Heavy Infantry	2	160	(26.98076211353316,4)
1388	11 x Inf-AT  -  1 x Inf-RR Team	11	2	(24.382685902179844,26.5)
815	5 x SP Mortar	5	38	(13.124355652982141,16)
833	2 x Machine Gun Section  -  1 x MG Unit  -  1 x Flak	2	4	(28.712812921102035,16)
2267	1 x Rocket APC	1	245	(23.516660498395403,43)
295	17 x O/M Rocket Arty	17	31	(13.55736835487436,6.25)
11	28 x O/M Medium Artillery  -  13 x O/M Heavy Artillery  -  5 x O/M Field Artillery	28	155	(9.6602540378443873,1)
1980	44 x Fighter-Bomber  -  1 x COIN Fighter Plane	44	44	(17.887495373796554,37.75)
2090	10 x Fighter-Bomber  -  2 x COIN Fighter Plane	10	44	(8.794228634059948,40)
2193	4 x Heavy Truck	4	28	(28.712812921102035,41.5)
135	8 x O/M Field Artillery	8	10	(13.55736835487436,3.25)
228	1 x Partisan Support  -  1 x Rangers	1	77	(24.815698604072061,4.75)
2220	1 x Light Helicopter	1	204	(17.887495373796554,42.25)
1573	2 x SP Flak	2	22	(11.825317547305483,30.25)
39	33 x Engineer  -  3 x Paratroops  -  3 x Paratroop Scouts  -  3 x Para Engineers  -  2 x Commando Engineers  -  1 x Commando Scouts  -  1 x Inf-AT  -  1 x Guards Engineers  -  1 x Pioneers  -  1 x Light Commandos  -  1 x Marine Engineers  -  1 x Engineer Support Squad	33	20	(33.908965343808667,1)
1047	5 x Engineer Tank  -  3 x Mine Clearing Tank  -  1 x Close Support Tank  -  1 x Fortifications	5	37	(6.196152422706632,20.5)
834	8 x MG Unit  -  8 x MG Section  -  6 x Machine Gun Section  -  2 x Para MG	8	194	(29.578838324886476,16)
882	5 x MBT  -  1 x CS MBT  -  1 x Medium Tank  -  1 x Obsolete Tank	5	59	(1.8660254037844386,17.5)
1210	1 x Obsolete Tank	1	102	(8.794228634059948,23.5)
1821	23 x Fighter-Bomber  -  16 x Level Bomber  -  1 x COIN Fighter Plane	23	44	(18.753520777580992,34.75)
508	8 x Light Infantry  -  4 x Medium Infantry  -  4 x Guerrilla Inf Squad  -  3 x Mechanised Infantry  -  3 x Cavalry  -  2 x Medium Mech Infantry  -  2 x Ski Troops  -  2 x Reserve Supt Squad  -  1 x Rifle Squad  -  1 x Motorcycle(Light Inf)	8	51	(24.382685902179844,10)
2302	25 x Helicopter  -  6 x Heavy Helicopter  -  6 x Attack Helicopter	25	53	(19.619546181365433,43.75)
1961	40 x Fighter-Bomber  -  1 x SEAD Aircraft	40	44	(1.4330127018922194,37.75)
662	36 x Mortar  -  2 x Mortar(Sub Type A)  -  1 x Mortar(Sub Type D)  -  1 x Mortar(Sub Type B)	36	5	(19.186533479473212,13)
2216	10 x Level Bomber  -  3 x Fighter-Bomber  -  2 x COIN Bomber	10	62	(14.423393758658799,42.25)
1718	52 x Sniper  -  16 x Para Sniper  -  8 x Ski Sniper  -  2 x Ranger Sniper  -  1 x Commando Sniper	52	45	(33.042939940024233,32.5)
1031	25 x Mortar(Sub Type A)  -  9 x Mortar(Sub Type B)  -  5 x Mortar  -  3 x Mortar(Sub Type C)	25	200	(27.413774815425377,19.75)
1222	28 x Flak  -  1 x SP Flak	28	8	(19.186533479473212,23.5)
471	3 x Commando Engineers	3	145	(27.413774815425377,9.25)
2196	63 x Wagon	63	109	(31.310889132455351,41.5)
255	17 x O/M Rocket Arty	17	31	(13.124355652982141,5.5)
1033	18 x Pack Howitzer  -  3 x Field Gun  -  1 x Light Mortar	18	196	(29.145825622994256,19.75)
1833	6 x SP Flak  -  3 x AA Truck  -  2 x Motorcycle  -  1 x Light SPAA Vehicle  -  1 x Engineer Tank	6	22	(29.145825622994256,34.75)
1019	20 x SP Artillery  -  1 x SP Mortar  -  1 x SP Howitzer	20	21	(17.021469970012117,19.75)
1125	10 x MBT  -  6 x Medium Tank  -  1 x Close Support Tank	10	59	(4.4641016151377544,22)
1811	2 x Fighter-Bomber  -  1 x COIN Fighter Plane	2	44	(10.093266739736606,34.75)
465	20 x Machine Gun Section  -  3 x MG Section  -  2 x para MG Section  -  1 x MG Unit	20	4	(22.217622392718749,9.25)
1304	1 x AT Gun  -  1 x Gun APC (Wheeled)	1	126	(20.918584287042091,25)
2132	2 x Fighter-Bomber	2	44	(10.959292143521045,40.75)
66	3 x Marines  -  1 x Para Medium Infantry  -  1 x Commandos	3	110	(23.083647796503186,1.75)
563	11 x MBT  -  3 x Flame Tank  -  1 x Close Support Tank  -  1 x CS MBT  -  1 x Medium Tank  -  1 x Obsolete Tank	11	59	(2.7320508075688772,11.5)
1377	7 x AT Gun  -  1 x Gun APC (Wheeled)	7	6	(14.856406460551018,26.5)
827	18 x O/M Field Artillery  -  1 x O/M Heavy Artillery	18	10	(23.516660498395403,16)
479	1 x Mechanised Infantry  -  1 x Mech Support Squad  -  1 x Paratroops  -  1 x Infantry	1	1	(34.341978045700891,9.25)
1400	4 x HQ  -  2 x Scout  -  1 x Art Observer	4	55	(34.774990747593108,26.5)
2392	136 x Paratroop Transport  -  5 x Transport Aircraft	136	60	(28.279800219209818,45.25)
160	54 x Engineer  -  9 x Para Engineers  -  5 x Ski Pioneers  -  4 x Engineer Support Squad  -  4 x Commando Engineers  -  3 x Pioneers  -  1 x Rangers	54	20	(35.208003449485325,3.25)
640	2 x Medium Commandos  -  1 x Guerrilla Lt Inf Squad  -  1 x Motorcycle(Light Inf)  -  1 x Light Commandos  -  1 x Pioneers  -  1 x Para Sniper  -  1 x Partisan Scouts  -  1 x Engineer Support Squad  -  1 x Commando Scouts  -  1 x Light Mech Infantry  -  1 x Commandos  -  1 x Rangers  -  1 x Marine Forward Observer  -  1 x Engineer	2	86	(35.208003449485325,12.25)
2005	3 x Fighter-Bomber  -  3 x SEAD Aircraft	3	214	(4.4641016151377544,38.5)
2213	31 x Fighter-Bomber	31	44	(11.825317547305483,42.25)
1954	12 x Light Support APC  -  5 x Scout Vehicle  -  5 x Armoured Car  -  2 x APC (Track)  -  2 x Light APC  -  2 x Utility Vehicle  -  2 x Gun APC (Wheeled)  -  1 x APC (Wheel)	12	122	(29.578838324886476,37)
512	4 x Rangers	4	111	(27.846787517317598,10)
1104	28 x Field Gun  -  2 x Howitzer  -  1 x Airborne Field Howitzer  -  1 x Pack Howitzer	28	9	(21.351596988934308,21.25)
779	1 x SP Rocket Launcher	1	137	(17.021469970012117,15.25)
31	12 x Paratroops  -  11 x Commandos  -  11 x Mechanised Infantry  -  9 x Infantry  -  6 x Rangers  -  5 x Heavy Mech Infantry  -  5 x Paratroop Support  -  5 x Heavy Infantry  -  3 x Light Infantry  -  3 x Para light Infantry  -  2 x Mercenaries  -  2 x Reserve Infantry  -  2 x Medium Commandos  -  2 x Light Mech Infantry  -  2 x Marine Heavy Infantry  -  2 x Para Engineers  -  1 x Paratroop Scouts  -  1 x Militia  -  1 x Legionnaires  -  1 x Airmobile Rifle Squad  -  1 x Guards Squad  -  1 x Para Medium Infantry  -  1 x Rifle Section  -  1 x Ranger Support Squad  -  1 x Light Guards Squad  -  1 x Commando Scouts	12	96	(26.98076211353316,1)
738	5 x SP Rocket Launcher	5	137	(15.722431864335457,14.5)
1584	12 x Inf-ATGM Team  -  9 x Inf-AT  -  4 x Para-ATGM Team	12	206	(21.351596988934308,30.25)
1997	1 x Medium Truck  -  1 x Heavy Truck	1	27	(32.609927238132009,37.75)
1592	50 x SP Gun  -  15 x Wheeled SP-ATGM  -  6 x Assault Gun  -  1 x Light Amphibian  -  1 x Airborne Support APC	50	39	(28.279800219209818,30.25)
817	2 x SP Rocket Launcher	2	137	(14.856406460551018,16)
949	2 x Mortar(Sub Type B)  -  1 x Mortar  -  1 x Mortar(Sub Type A)	2	201	(25.681724007856502,18.25)
34	5 x Rangers  -  4 x Infantry  -  4 x Paratroops  -  4 x Mechanised Infantry  -  3 x Heavy Mech Infantry  -  2 x Motorised Inf Section  -  2 x Light Guards Squad  -  2 x Reserve Infantry  -  1 x Marines  -  1 x Ski Troops  -  1 x Commandos  -  1 x Guards Squad  -  1 x Partisan Band  -  1 x Native Troops  -  1 x Paratroop Support	5	111	(29.578838324886476,1)
505	47 x Machine Gun Section  -  7 x MG Section  -  4 x Para MG  -  3 x MG Unit  -  3 x para MG Section  -  1 x Heavy MG  -  1 x Heavy MG Section	47	4	(21.784609690826528,10)
1308	7 x AT Gun  -  1 x SP Gun  -  1 x Gun APC (Wheeled)  -  1 x Inf-RR Team  -  1 x Fortifications  -  1 x Light AT Gun	7	6	(24.382685902179844,25)
2158	7 x Utility Vehicle	7	26	(33.47595264191645,40.75)
12	4 x O/M Minelet Arty Bty	4	211	(10.526279441628825,1)
1887	1 x Fighter-Bomber	1	44	(6.6291651245988508,36.25)
1469	1 x Inf-AT	1	2	(25.248711305964282,28)
321	20 x Fortifications	20	0	(1,7)
2118	21 x Utility Vehicle  -  3 x Light Truck  -  2 x Light APC  -  1 x Medium Truck  -  1 x Scout Vehicle  -  1 x APC (Wheel)  -  1 x Artillery Prime Mover	21	26	(33.042939940024233,40)
324	7 x Fortifications	7	0	(3.598076211353316,7)
2240	7 x Native Troops  -  1 x Irregulars  -  1 x Air OP Aircraft  -  1 x Pack Animals  -  1 x Ammo Carrier	7	79	(35.208003449485325,42.25)
1337	9 x AT Gun	9	6	(15.289419162443238,25.75)
18	19 x O/M Field Artillery  -  3 x O/M Medium Artillery  -  1 x O/M Heavy Artillery	19	10	(15.722431864335457,1)
139	1 x O/M Heavy Artillery  -  1 x O/M Medium Artillery	1	156	(17.021469970012117,3.25)
848	3 x APC (Track)  -  2 x Mine Clearing Tank  -  2 x Heavy APC  -  1 x Engineer Tank  -  1 x MBT  -  1 x Medium Tank	3	25	(7.49519052838329,16.75)
143	2 x SP Mortar  -  1 x Light APC	2	38	(20.48557158514987,3.25)
2108	1 x Heavy Amphibian	1	34	(24.382685902179844,40)
424	54 x Machine Gun Section  -  10 x Para MG  -  8 x MG Section  -  4 x Ski SMG Squad  -  2 x MG Unit  -  2 x para MG Section  -  1 x Heavy MG Section	54	4	(20.918584287042091,8.5)
927	1 x Engineer Tank  -  1 x Mine Clearing Tank	1	36	(6.6291651245988508,18.25)
408	1 x Amphibian Tank	1	35	(7.0621778264910704,8.5)
1656	3 x SP SAM	3	30	(14.423393758658799,31.75)
466	6 x Machine Gun Section  -  3 x Militia Support  -  2 x Ranger Hvy Infantry Squad  -  1 x Medium Infantry	6	4	(23.083647796503186,9.25)
1704	44 x SP ATGM  -  1 x Wheeled SP-ATGM	44	19	(20.918584287042091,32.5)
1809	2 x Fighter-Bomber  -  1 x COIN Fighter Plane	2	44	(8.3612159321677293,34.75)
2133	4 x Fighter-Bomber	4	44	(11.825317547305483,40.75)
250	15 x Landing Barge  -  1 x LCG	15	41	(8.794228634059948,5.5)
1479	4 x Scout  -  4 x Paratroop Scouts  -  2 x Motorcycle  -  1 x Marine Heavy Infantry  -  1 x Commando Scouts	4	58	(33.908965343808667,28)
1225	8 x Pack Howitzer  -  4 x Howitzer  -  4 x Field Gun  -  1 x Heavy AT Gun  -  1 x Airborne Field Howitzer	8	196	(21.784609690826528,23.5)
1919	3 x Scout Vehicle	3	32	(34.341978045700891,36.25)
918	1 x Scout  -  1 x Ranger Pioneer	1	58	(33.042939940024233,17.5)
2201	14 x Attack Helicopter  -  1 x Light Attack Helicopter	14	203	(1.4330127018922194,42.25)
64	7 x Commandos  -  5 x Rangers  -  3 x Mercenaries  -  3 x Marines  -  3 x Infantry  -  2 x COIN Infantry Squad  -  2 x Mechanised Infantry  -  2 x Guerrilla Inf Squad  -  2 x Paratroops  -  1 x Airmobile Rifle Squad  -  1 x COIN Hvy Infantry Squad  -  1 x Medium Infantry  -  1 x Para Medium Infantry	7	83	(21.351596988934308,1.75)
1109	1 x SP Artillery	1	21	(25.681724007856502,21.25)
777	3 x SP Rocket Launcher	3	137	(15.289419162443238,15.25)
1298	66 x AT Gun  -  2 x Heavy AT Gun  -  1 x SP Gun  -  1 x Light AT Gun	66	6	(15.722431864335457,25)
1725	21 x FO Vehicle	21	57	(4.897114317029974,33.25)
2145	2 x MRV IFV  -  1 x APC (Track)	2	237	(22.217622392718749,40.75)
315	1 x Paratroops  -  1 x Cavalry	1	3	(30.877876430563134,6.25)
1554	2 x SP Gun	2	39	(29.578838324886476,29.5)
1014	1 x SP Artillery	1	21	(12.691342951089922,19.75)
2	4 x Fortifications	4	0	(1.8660254037844386,1)
796	34 x LMG Section  -  11 x Guerrilla Inf Support  -  8 x MG Unit  -  6 x Medium Infantry  -  5 x MG Section  -  2 x Legion SMG Squad	34	65	(31.743901834347572,15.25)
72	4 x Infantry  -  2 x Motorised Inf Section  -  2 x Paratroops  -  2 x Rangers  -  2 x Medium Infantry  -  1 x Engineer Support Squad  -  1 x Mechanised Infantry  -  1 x Paratroop Support  -  1 x Reserve Infantry  -  1 x Para Medium Infantry	4	1	(28.279800219209818,1.75)
234	11 x Infantry  -  11 x Mechanised Infantry  -  5 x Marines  -  4 x Patrol  -  3 x Commando Scouts  -  3 x Para Medium Infantry  -  3 x Guards Squad  -  3 x Mech Scouts  -  3 x Rangers  -  3 x Engineer Support Squad  -  3 x Commandos  -  2 x Ski Pioneers  -  2 x Paratroops  -  1 x Rifle Section  -  1 x Para light Infantry  -  1 x Motorised Inf Section  -  1 x Rifle Squad  -  1 x Marine Support Squad	11	1	(30.011851026778693,4.75)
1877	71 x Scout Vehicle  -  21 x Light Support APC  -  19 x Light APC  -  14 x Utility Vehicle  -  3 x Light SPAA Vehicle  -  1 x FO Vehicle	71	32	(32.176914536239792,35.5)
1567	1 x Light Support APC  -  1 x Armoured Car  -  1 x APC (Wheel)	1	11	(6.6291651245988508,30.25)
206		0	\N	\N
1841	29 x APC (Track)  -  9 x Heavy APC  -  4 x Light APC  -  2 x Light Support APC  -  2 x Gun APC (Tracked)  -  1 x Cavalry Tank  -  1 x Close Support Tank  -  1 x Gun APC (HalfTrack)  -  1 x Light Amphibian	29	25	(1,35.5)
1598	12 x FO Vehicle  -  9 x Art Observer  -  5 x Para Forward Observer	12	57	(33.47595264191645,30.25)
1373	1 x Light Tank	1	12	(11.392304845413264,26.5)
2154	56 x Artillery Prime Mover  -  31 x Medium Truck  -  9 x Heavy Truck  -  2 x Utility Vehicle  -  1 x Light Truck	56	180	(30.011851026778693,40.75)
346	2 x Guerrilla Inf Squad  -  1 x Guerrilla Inf Support  -  1 x Commandos	2	230	(22.650635094610966,7)
1509	19 x Inf-AT  -  5 x Para Inf-AT  -  3 x Ski Inf-AT  -  3 x Commando Inf-AT  -  1 x Reserve Supt Squad	19	2	(25.681724007856502,28.75)
841	34 x MBT  -  8 x Medium Tank  -  6 x Obsolete Tank  -  1 x Mine Clearing Tank  -  1 x FO Vehicle	34	59	(1.4330127018922194,16.75)
1451	13 x SP Gun  -  8 x Assault Gun  -  2 x Self Propelled Gun	13	39	(9.6602540378443873,28)
1394	2 x Inf-AT  -  1 x Ski Inf-AT	2	2	(29.578838324886476,26.5)
1150	1 x Flak	1	8	(26.114736709748719,22)
1281	13 x MBT  -  12 x Medium Tank  -  2 x Cavalry Tank  -  1 x Light Tank  -  1 x Obsolete Tank	13	59	(1,25)
696	1 x SP Rocket Launcher	1	137	(14.423393758658799,13.75)
1772	59 x Fighter-Bomber	59	44	(10.526279441628825,34)
2286	4 x Light Attack Helicopter  -  2 x Attack Helicopter  -  2 x Light Helicopter	4	221	(5.7631397208144124,43.75)
938	46 x SP Artillery  -  1 x SP Howitzer	46	21	(16.155444566227676,18.25)
627	5 x Light Mortar  -  1 x Para Mortar Team	5	153	(23.949673200287624,12.25)
1063	23 x Field Gun  -  1 x Howitzer	23	9	(20.05255888325765,20.5)
391	18 x Rangers  -  14 x Light Mech Infantry  -  8 x Infantry  -  7 x Heavy Infantry  -  7 x Commandos  -  5 x Marines  -  4 x Marine Support Squad  -  4 x Light Infantry  -  3 x Guards Infantry  -  3 x Cavalry Scouts  -  2 x Para MG  -  2 x Heavy MG Section  -  2 x Native Troops  -  2 x Irregulars  -  1 x Commando Engineers  -  1 x Heavy Militia  -  1 x Partisans  -  1 x Ski Troops  -  1 x Paratroop Support  -  1 x Mechanised Infantry  -  1 x Militia  -  1 x Medium Mech Infantry	18	111	(27.413774815425377,7.75)
444	2 x Light Tank  -  2 x Assault Gun  -  2 x Medium Tank  -  1 x Close Support Tank  -  1 x SP Gun	2	12	(4.0310889132455356,9.25)
274	3 x Paratroops  -  2 x Mechanised Infantry  -  2 x Pioneers  -  2 x Marine Light Infantry  -  2 x Medium Commandos  -  2 x Commando Scouts  -  1 x Paratroop Scouts  -  1 x Rangers  -  1 x Mercenaries  -  1 x Para Medium Infantry  -  1 x Para light Infantry  -  1 x Commando Support	3	96	(29.578838324886476,5.5)
1702	1 x SP ATGM  -  1 x Fortifications	1	0	(19.186533479473212,32.5)
1842	1 x SP Gun	1	39	(1.8660254037844386,35.5)
1023	24 x Field Gun  -  1 x Howitzer	24	9	(20.48557158514987,19.75)
1140	36 x Flak  -  1 x AA Truck	36	8	(17.454482671904334,22)
320	9 x Commandos  -  8 x Infantry  -  8 x Paratroops  -  8 x Heavy Infantry  -  6 x Heavy Ski Troops  -  6 x Light Mech Infantry  -  6 x Paratroop Support  -  2 x Medium Commandos  -  2 x Mechanised Infantry  -  2 x Heavy Commandos  -  2 x Scout Vehicle  -  1 x Guards Infantry  -  1 x Para light Infantry  -  1 x Commando Scouts  -  1 x Commando Engineers  -  1 x Mercenaries  -  1 x Ski Troops  -  1 x Mech Support Squad  -  1 x Fortifications  -  1 x Para Medium Infantry  -  1 x Bicycle Squad  -  1 x Commando Support  -  1 x Medium Infantry	9	83	(35.208003449485325,6.25)
1518	1 x FO Vehicle	1	57	(33.47595264191645,28.75)
426	7 x Machine Gun Section  -  2 x Militia Support  -  1 x Para MG  -  1 x LMG Section	7	4	(22.650635094610966,8.5)
1840	4 x Scout Vehicle	4	32	(35.208003449485325,34.75)
412	11 x APC (Track)  -  4 x Light APC  -  4 x Armoured Car  -  4 x Airborne Support APC  -  2 x Light Tank  -  2 x Scout Vehicle  -  1 x Heavy APC  -  1 x Artillery Prime Mover  -  1 x FO Vehicle  -  1 x Airborne APC  -  1 x Close Support Tank  -  1 x MBT  -  1 x Gun APC (Tracked)  -  1 x Ammo Carrier	11	25	(10.526279441628825,8.5)
1571	2 x APC (Wheel)  -  1 x Light APC  -  1 x APC  -  1 x APC (Track)  -  1 x Utility Vehicle	2	23	(10.093266739736606,30.25)
2212	35 x Fighter-Bomber  -  2 x COIN Fighter Plane	35	44	(10.959292143521045,42.25)
741	2 x Para Mortar Team	2	173	(18.320508075688775,14.5)
1758	6 x Commando Sniper  -  4 x Sniper  -  2 x Para Sniper  -  2 x Marine Sniper	6	147	(33.47595264191645,33.25)
2231	1 x Ammo Carrier	1	56	(27.413774815425377,42.25)
46	7 x Fortifications	7	0	(5.7631397208144124,1.75)
1878	1 x Utility Vehicle	1	26	(33.042939940024233,35.5)
1985	5 x Scout Vehicle  -  1 x Airborne APC  -  1 x Light APC  -  1 x APC (Track)  -  1 x Light Support APC  -  1 x Gun APC (Tracked)  -  1 x Armoured Car  -  1 x SP Mortar  -  1 x FO Vehicle	5	32	(22.217622392718749,37.75)
1690	1 x SP ATGM  -  1 x Light Support APC  -  1 x Light MRV APC	1	219	(8.794228634059948,32.5)
83	5 x Fortifications	5	0	(2.7320508075688772,2.5)
919	2 x Engineer Support Squad  -  2 x Hvy Bicycle Squad  -  2 x Rifle Section  -  1 x Para Medium Infantry  -  1 x Para Mortar Team  -  1 x Guerrilla Inf Squad  -  1 x Medium Commandos	2	195	(33.908965343808667,17.5)
851	14 x Engineer Tank  -  3 x Mine Clearing Tank	14	37	(10.093266739736606,16.75)
361	3 x Fortifications	3	0	(1.4330127018922194,7.75)
1219	35 x Flak	35	8	(16.588457268119896,23.5)
1681	3 x Heavy APC  -  1 x Scout Vehicle  -  1 x Heavy Armoured Car  -  1 x MRV IFV  -  1 x APC (Track)  -  1 x APC (Wheel)  -  1 x APC	3	120	(1,32.5)
1386	3 x Inf-AT	3	2	(22.650635094610966,26.5)
474	1 x Rangers	1	111	(30.011851026778693,9.25)
687	1 x Airborne APC  -  1 x APC (Track)	1	25	(6.6291651245988508,13.75)
2375	6 x Area SAM	6	16	(13.55736835487436,45.25)
1924	48 x Fighter-Bomber	48	44	(3.598076211353316,37)
73	8 x Mechanised Infantry  -  8 x Infantry  -  4 x Motorised Inf Section  -  3 x Medium Mech Infantry  -  3 x Reserve Infantry  -  2 x Heavy Infantry  -  2 x Heavy Mech Infantry  -  1 x Light Infantry  -  1 x Ski Troops  -  1 x Commando Scouts  -  1 x Paratroops  -  1 x Militia  -  1 x Police	8	1	(29.145825622994256,1.75)
631	3 x Infantry  -  2 x Reserve Infantry  -  1 x Marines  -  1 x Reserve Supt Squad  -  1 x Militia  -  1 x Light Infantry	3	1	(27.413774815425377,12.25)
182	10 x Fortifications	10	0	(19.186533479473212,4)
355	1 x LMG Section	1	65	(30.444863728670914,7)
410		0	\N	\N
1407	15 x Light Tank  -  13 x Armoured Car  -  5 x MBT  -  1 x Scout Vehicle  -  1 x Infantry Tank  -  1 x Assault Gun  -  1 x Heavy Armoured Car  -  1 x SP Gun	15	12	(6.6291651245988508,27.25)
1748	2 x SP ATGM  -  2 x Light SP ATGM  -  1 x SP Gun  -  1 x APC (Track)  -  1 x Wheeled SP-ATGM	2	129	(24.815698604072061,33.25)
2325	3 x Attack Helicopter	3	203	(4.4641016151377544,44.5)
277	6 x Mechanised Infantry  -  5 x Heavy Ski Troops  -  5 x Paratroops  -  4 x Heavy Infantry  -  3 x Marine Light Infantry  -  3 x Para Medium Infantry  -  3 x Legionnaires  -  2 x Infantry  -  2 x Airmobile Section  -  1 x Airmobile Rifle Squad  -  1 x Airmobile Spt Section  -  1 x Fortifications  -  1 x Marines  -  1 x Airmobile Engineers  -  1 x Heavy Militia  -  1 x Engineer  -  1 x Ski Troops	6	69	(32.176914536239792,5.5)
2068	13 x APC (Wheel)  -  7 x MRV APC  -  3 x Light APC  -  2 x Armoured Car  -  2 x Light Support APC  -  1 x FO Vehicle  -  1 x APC  -  1 x Heavy APC	13	23	(24.815698604072061,39.25)
348	1 x Light Commandos  -  1 x Commando Support  -  1 x Rifle Section	1	85	(24.382685902179844,7)
984	7 x Field Gun	7	9	(20.918584287042091,19)
1064	21 x Field Gun  -  1 x Howitzer	21	9	(20.918584287042091,20.5)
1215	7 x Heavy AT Gun  -  1 x AT Gun  -  1 x SP Gun	7	158	(13.124355652982141,23.5)
965	8 x MBT  -  5 x CS MBT  -  1 x Medium Tank	8	59	(4.4641016151377544,19)
2070	6 x APC (Wheel)  -  5 x APC (Track)  -  2 x Light APC  -  2 x Light Support APC  -  1 x APC  -  1 x Artillery Prime Mover	6	23	(26.54774941164094,39.25)
730	2 x Light Tank  -  1 x Heavy Armoured Car  -  1 x Amphibian Tank  -  1 x SP Gun  -  1 x Light Support APC  -  1 x Gun APC (Tracked)  -  1 x Scout Vehicle  -  1 x Armoured Car	2	12	(8.794228634059948,14.5)
1223	1 x Flak	1	8	(20.05255888325765,23.5)
2245	4 x Light Attack Helicopter	4	221	(4.4641016151377544,43)
1232	17 x AGL  -  1 x Engineer Support Squad	17	7	(27.846787517317598,23.5)
2398	7 x Ammo Carrier  -  2 x Paratroop Transport  -  1 x Air OP Aircraft	7	56	(33.47595264191645,45.25)
569	2 x MBT  -  1 x Light Tank	2	59	(7.9282032302755088,11.5)
1901	2 x COIN Fighter Plane  -  2 x Fighter-Bomber	2	223	(18.753520777580992,36.25)
596	13 x Motorcycle(Heavy Inf)  -  9 x Guerrilla Inf Squad  -  8 x Partisans  -  5 x Police  -  4 x Militia  -  4 x Guards Squad  -  4 x Irregulars  -  4 x Rifle Squad  -  4 x Light Militia  -  3 x COIN Infantry Squad  -  3 x Heavy Militia  -  3 x Rifle Section  -  3 x Light Infantry  -  2 x Marines  -  2 x Rangers  -  2 x Infantry  -  2 x Guards Infantry  -  1 x Partisan Support  -  1 x Legionnaires  -  1 x Marine Light Infantry  -  1 x Cavalry Scouts	13	188	(31.310889132455351,11.5)
2359	75 x Ammo Carrier	75	56	(33.908965343808667,44.5)
485	11 x MBT  -  10 x Medium Tank  -  5 x Obsolete Tank  -  3 x SP Gun  -  2 x Assault Gun  -  2 x Light Tank  -  2 x Heavy Tank  -  1 x Close Support Tank	11	59	(4.4641016151377544,10)
1863	4 x Fighter-Bomber  -  1 x Light APC	4	44	(20.05255888325765,35.5)
1258	6 x Heavy AT Gun  -  3 x AT Gun  -  1 x Pack Howitzer	6	158	(16.155444566227676,24.25)
2259	3 x Attack Helicopter  -  3 x Light Helicopter	3	204	(16.588457268119896,43)
226	9 x Infantry  -  6 x Irregulars  -  4 x Rangers  -  3 x Partisan Band  -  2 x Light Infantry  -  2 x Ski Troops  -  2 x Paratroops  -  1 x Guards Squad  -  1 x Guerrilla Inf Support  -  1 x Guards Infantry	9	1	(23.083647796503186,4.75)
1955	19 x Scout Vehicle  -  10 x APC (Track)  -  9 x Utility Vehicle  -  7 x Light Support APC  -  7 x Light APC  -  2 x Armoured Car  -  1 x Gun APC (Wheeled)  -  1 x APC  -  1 x APC (Wheel)  -  1 x Artillery Prime Mover	19	32	(30.444863728670914,37)
500	3 x Machine Gun Section	3	4	(17.454482671904334,10)
13	19 x O/M Minelet Rocket Bty  -  15 x O/M Heavy Artillery  -  13 x O/M Medium Artillery  -  9 x O/M Minelet Arty Bty  -  2 x O/M Field Artillery	19	210	(11.392304845413264,1)
1152	67 x Flak	67	8	(27.846787517317598,22)
2234	1 x Utility Vehicle	1	26	(30.011851026778693,42.25)
1226	2 x AT Gun  -  2 x SP Gun  -  1 x Field Gun	2	39	(22.650635094610966,23.5)
2101	16 x Fighter-Bomber  -  4 x COIN Fighter Plane	16	44	(18.320508075688775,40)
1810	2 x Fighter-Bomber	2	44	(9.2272413359521668,34.75)
91	1 x Mortar(Sub Type A)	1	200	(9.6602540378443873,2.5)
2058	1 x Level Bomber	1	62	(16.155444566227676,39.25)
770	6 x MBT  -  2 x Light Tank  -  1 x Close Support Tank  -  1 x Obsolete Tank	6	59	(9.2272413359521668,15.25)
1359	26 x Scout  -  4 x COIN Scout  -  3 x Paratroop Scouts  -  1 x Guards Scouts  -  1 x Ranger Scout  -  1 x Mortar(Sub Type B)  -  1 x Patrol  -  1 x Marine Scout	26	58	(34.341978045700891,25.75)
2138	1 x Improvised APC	1	136	(16.155444566227676,40.75)
1605	7 x Light APC  -  3 x APC  -  2 x Scout Vehicle  -  2 x APC (Track)  -  1 x APC (Wheel)	7	121	(4.4641016151377544,31)
540	2 x Flak	2	8	(17.887495373796554,10.75)
1828	4 x Ammo Carrier  -  2 x SP Mortar  -  1 x SP Flak	4	56	(24.815698604072061,34.75)
543	17 x Machine Gun Section  -  4 x MG Unit  -  3 x Para MG  -  2 x MG Section  -  1 x para MG Section	17	4	(20.48557158514987,10.75)
1449	1 x MBT  -  1 x Obsolete Tank	1	59	(7.9282032302755088,28)
365	11 x Fortifications	11	0	(4.897114317029974,7.75)
2037	9 x Scout Vehicle  -  2 x Light Support APC  -  2 x Utility Vehicle  -  1 x Light APC  -  1 x Gun APC (Wheeled)  -  1 x APC (Track)	9	32	(32.176914536239792,38.5)
2256	3 x Fighter-Bomber	3	44	(13.99038105676658,43)
1524	3 x APC (Track)  -  2 x Scout Vehicle  -  2 x Heavy APC	3	25	(3.598076211353316,29.5)
1691	3 x Light MRV APC  -  1 x Scout Vehicle  -  1 x Light APC  -  1 x APC (Track)  -  1 x Gun APC (Tracked)	3	219	(9.6602540378443873,32.5)
1705	2 x SP ATGM  -  2 x Wheeled SP-ATGM  -  1 x Light SP ATGM	2	19	(21.784609690826528,32.5)
1780	4 x Fighter-Bomber	4	44	(17.454482671904334,34)
976	1 x SP Artillery	1	21	(13.99038105676658,19)
1522	3 x Light APC  -  2 x APC (Track)  -  1 x Light Tank  -  1 x MRV APC	3	121	(1.8660254037844386,29.5)
152	26 x Infantry  -  8 x Motorised Inf Section  -  8 x Heavy Infantry  -  5 x Mechanised Infantry  -  5 x Reserve Infantry  -  4 x Rangers  -  3 x Guerrilla Inf Squad  -  3 x Motorcycle(Heavy Inf)  -  2 x Heavy Militia  -  2 x Partisans  -  1 x Heavy Ski Troops  -  1 x SMG Section  -  1 x Ski Troops  -  1 x Light Mech Infantry  -  1 x Paratroops  -  1 x Rifle Section  -  1 x Bicycle Squad  -  1 x Medium Infantry  -  1 x Light Infantry  -  1 x Irregulars	26	1	(28.279800219209818,3.25)
475	10 x Infantry  -  6 x Rangers  -  2 x Motorised Inf Section  -  2 x Marines  -  2 x Mechanised Infantry  -  2 x Rifle Section  -  1 x Guards Infantry  -  1 x Medium Infantry  -  1 x Ranger Lt Infantry Squad  -  1 x Legion SMG Squad	10	1	(30.877876430563134,9.25)
536	6 x Heavy Mortar  -  2 x Mortar(Sub Type B)  -  1 x Mortar	6	152	(14.423393758658799,10.75)
719	8 x Patrol  -  7 x Scout  -  6 x Paratroop Scouts  -  4 x Motorcycle(Light Inf)  -  4 x Cavalry Scouts  -  3 x Ski SMG Squad  -  2 x Reserve Infantry  -  1 x Marine Scout  -  1 x Guards Squad  -  1 x Mech Scouts  -  1 x Motorcycle(Heavy Inf)  -  1 x Rangers  -  1 x Ranger Scout	8	82	(34.341978045700891,13.75)
2388	101 x Light Helicopter  -  10 x Helicopter	101	204	(24.815698604072061,45.25)
5	11 x Fortifications	11	0	(4.4641016151377544,1)
462	2 x Machine Gun Section	2	4	(19.619546181365433,9.25)
1935	1 x Fighter-Bomber	1	44	(13.124355652982141,37)
461	70 x Machine Gun Section  -  23 x Heavy MG Section  -  16 x Heavy MG  -  5 x MG Section  -  5 x Para MG  -  2 x MG Unit	70	4	(18.753520777580992,9.25)
789	1 x O/M Field Artillery	1	10	(25.681724007856502,15.25)
1944	2 x FO Vehicle  -  1 x Light Tank  -  1 x Airborne Lt Tank  -  1 x Armoured Car	2	57	(20.918584287042091,37)
340	2 x Fortifications	2	0	(17.454482671904334,7)
593	1 x Marines  -  1 x Heavy Infantry	1	40	(28.712812921102035,11.5)
1007	2 x Mine Clearing Tank  -  1 x Engineer Tank	2	36	(6.6291651245988508,19.75)
2000	6 x Wagon  -  4 x Pack Animals	6	109	(35.208003449485325,37.75)
661	22 x Mortar  -  2 x Mortar(Sub Type A)  -  2 x Mortar(Sub Type B)	22	5	(18.320508075688775,13)
2223	2 x Helicopter	2	53	(20.48557158514987,42.25)
1321	16 x MBT  -  14 x Medium Tank  -  3 x Infantry Tank  -  2 x Cavalry Tank	16	59	(1.4330127018922194,25.75)
2276	6 x Rivercraft  -  1 x Snow Vehicle	6	197	(31.310889132455351,43)
392	1 x Ski Troops  -  1 x Paratroops  -  1 x Guerrilla Hvy Inf Squad	1	162	(28.279800219209818,7.75)
1340	21 x AT Gun  -  3 x Light AT Gun	21	6	(17.887495373796554,25.75)
2066	1 x APC (Track)	1	25	(23.083647796503186,39.25)
1417	50 x AT Gun  -  1 x Light AT Gun	50	6	(15.289419162443238,27.25)
979	4 x SP Mortar  -  3 x Assault Gun  -  1 x SP Gun  -  1 x SP Artillery	4	38	(16.588457268119896,19)
994	3 x Mortar(Sub Type A)	3	200	(29.578838324886476,19)
1011	2 x Engineer Tank  -  1 x Mine Clearing Tank  -  1 x Obsolete Tank	2	37	(10.093266739736606,19.75)
1766	4 x Air OP Aircraft	4	50	(5.3301270189221936,34)
1357	1 x Scout	1	58	(32.609927238132009,25.75)
1186	7 x Pack Howitzer  -  6 x Field Gun	7	196	(23.083647796503186,22.75)
2007	16 x Fighter-Bomber  -  2 x COIN Fighter Plane	16	44	(6.196152422706632,38.5)
519	3 x Mechanised Infantry	3	69	(33.908965343808667,10)
1387	1 x Inf-AT  -  1 x Fortifications  -  1 x Inf-RR Team  -  1 x Light AT Gun	1	0	(23.516660498395403,26.5)
432	1 x Mechanised Infantry  -  1 x Reserve Infantry  -  1 x Motorised Inf Section  -  1 x Infantry	1	1	(27.846787517317598,8.5)
846	2 x Heavy Amphibian  -  1 x SP ATGM  -  1 x Gun APC (Tracked)  -  1 x MRV APC	2	34	(5.7631397208144124,16.75)
1834	77 x FO Vehicle  -  4 x Scout Vehicle  -  2 x AA Truck  -  1 x SP Flak  -  1 x Ammo Carrier  -  1 x Utility Vehicle	77	57	(30.011851026778693,34.75)
673	26 x Reserve Infantry  -  9 x Infantry  -  6 x Militia  -  6 x Motorised Inf Section  -  5 x Light Infantry  -  3 x COIN Infantry Squad  -  1 x Engineer Support Squad  -  1 x Partisan Band  -  1 x Bicycle Squad  -  1 x Rifle Section  -  1 x Partisan Scouts  -  1 x Mechanised Infantry	26	160	(28.712812921102035,13)
931	2 x Engineer Tank	2	37	(10.093266739736606,18.25)
254	10 x O/M Rocket Arty	10	31	(12.258330249197702,5.5)
625	6 x Light Mortar  -  1 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type D)	6	153	(22.217622392718749,12.25)
656	3 x Heavy Mortar	3	152	(13.99038105676658,13)
1203	24 x MBT  -  10 x Medium Tank  -  4 x Obsolete Tank  -  1 x Main Battle Tank	24	59	(2.7320508075688772,23.5)
2104	33 x Engineer Tank  -  3 x Snow Vehicle  -  3 x MRV IFV  -  2 x Mine Clearing Tank  -  1 x SP Mortar  -  1 x FO Vehicle  -  1 x Light Amphibian  -  1 x MRV Light IFV  -  1 x APC (Track)	33	37	(20.918584287042091,40)
2295	1 x Fighter-Bomber	1	44	(13.55736835487436,43.75)
818	10 x SP Rocket Launcher	10	137	(15.722431864335457,16)
396	4 x Heavy Infantry  -  3 x Mechanised Infantry  -  3 x Heavy Ski Troops  -  2 x Para Medium Infantry  -  1 x Heavy Commandos  -  1 x Light Mech Infantry  -  1 x Marine Support Squad  -  1 x Heavy Militia  -  1 x Partisans  -  1 x Paratroop Support  -  1 x Marines	4	40	(31.743901834347572,7.75)
107	2 x Infantry  -  2 x Mech Scouts	2	81	(23.516660498395403,2.5)
820	4 x SP Rocket Launcher  -  1 x Rocket Launcher	4	137	(17.454482671904334,16)
1613	5 x Light Tank  -  4 x Airborne APC  -  3 x MRV Light IFV  -  1 x Scout Vehicle  -  1 x FO Vehicle	5	12	(11.392304845413264,31)
2337	9 x Area SAM  -  6 x SP SAM	9	16	(14.856406460551018,44.5)
935	2 x SP Mortar  -  1 x SP Artillery	2	38	(13.55736835487436,18.25)
2076	3 x Improvised APC  -  1 x Light APC  -  1 x APC (Wheel)	3	136	(31.743901834347572,39.25)
1148	7 x Field Gun  -  3 x Pack Howitzer	7	9	(24.382685902179844,22)
2279	227 x NO UNIT  -  90 x Ammo Carrier  -  78 x Air OP Aircraft  -  34 x Fortifications  -  6 x Utility Vehicle	227	216	(33.908965343808667,43)
1506	2 x Para Inf-AT	2	142	(23.083647796503186,28.75)
1996	1 x Improvised APC	1	136	(31.743901834347572,37.75)
2202	4 x Attack Helicopter  -  2 x Light Attack Helicopter	4	203	(2.299038105676658,42.25)
1378	3 x AT Gun	3	6	(15.722431864335457,26.5)
1001	2 x CS Infantry Tank  -  1 x CS MBT  -  1 x MBT	2	106	(1.4330127018922194,19.75)
1779	71 x Fighter-Bomber  -  7 x COIN Fighter Plane	71	44	(16.588457268119896,34)
19	3 x O/M Field Artillery	3	10	(16.588457268119896,1)
2040	79 x Utility Vehicle  -  25 x Light Truck  -  2 x Medium Truck  -  1 x Scout Vehicle  -  1 x Airborne APC  -  1 x FO Vehicle	79	26	(34.774990747593108,38.5)
1236	1 x Police	1	178	(31.310889132455351,23.5)
2113	1 x Heavy Truck  -  1 x APC (Wheel)	1	28	(28.712812921102035,40)
2284	5 x Attack Helicopter  -  2 x Light Attack Helicopter	5	203	(4.0310889132455356,43.75)
398	13 x Heavy Infantry  -  7 x Heavy Ski Troops  -  7 x Mechanised Infantry  -  7 x Infantry  -  5 x Paratroops  -  4 x Bicycle Squad  -  4 x Heavy Mech Infantry  -  4 x Motorised Inf Section  -  4 x Heavy Commandos  -  3 x Commandos  -  3 x Guards Infantry  -  3 x Marines  -  3 x Para Medium Infantry  -  2 x Medium Infantry  -  2 x Paratroop Support  -  2 x Mercenaries  -  1 x Legion SMG Squad  -  1 x Mech Support Squad  -  1 x Reserve Infantry  -  1 x Militia  -  1 x Para Mortar Team  -  1 x Airmobile Section  -  1 x Marine Support Squad  -  1 x Rangers  -  1 x Partisans  -  1 x Light Infantry	13	40	(33.47595264191645,7.75)
2084	8 x Fighter-Bomber  -  5 x SEAD Aircraft	8	44	(3.598076211353316,40)
966	2 x MBT  -  1 x Mine Clearing Tank  -  1 x Obsolete Tank	2	59	(5.3301270189221936,19)
215	8 x O/M Heavy Artillery	8	156	(13.55736835487436,4.75)
2246	1 x Light Attack Helicopter	1	221	(5.3301270189221936,43)
1370	11 x MBT  -  4 x Flame Tank  -  3 x Medium Tank  -  2 x CS MBT  -  2 x Fortifications  -  2 x Obsolete Tank  -  1 x Close Support Tank	11	59	(8.794228634059948,26.5)
2318	6 x Ammo Carrier	6	56	(33.47595264191645,43.75)
2357	8 x Ammo Carrier	8	56	(32.176914536239792,44.5)
317	9 x Mechanised Infantry  -  6 x Marines  -  3 x Motorised Inf Section  -  3 x Mercenaries  -  3 x Commandos  -  2 x Infantry  -  2 x Paratroop Support  -  2 x Heavy Infantry  -  2 x Paratroops  -  2 x Airmobile Section  -  1 x Marine Support Squad  -  1 x Engineer Support Squad  -  1 x Legionnaires	9	69	(32.609927238132009,6.25)
1457	1 x AT Gun  -  1 x SP Gun	1	39	(14.856406460551018,28)
1735	1 x Gunship Aircraft	1	215	(13.55736835487436,33.25)
1477	1 x Militia Support	1	192	(32.176914536239792,28)
37	70 x Engineer  -  18 x Pioneers  -  15 x Para Engineers  -  9 x Commandos  -  9 x Paratroops  -  8 x Commando Engineers  -  5 x Para light Infantry  -  3 x Mercenaries  -  2 x Marines  -  1 x Ski Pioneers  -  1 x Commando Scouts  -  1 x Medium Commandos  -  1 x Ranger Pioneer  -  1 x Partisan Band  -  1 x Infantry  -  1 x Heavy Guards Squad  -  1 x Medium Mech Infantry  -  1 x Ranger Hvy Infantry Squad  -  1 x Rangers  -  1 x Paratroop Support  -  1 x Guards Engineers  -  1 x Light Infantry	70	20	(32.176914536239792,1)
1533	4 x MBT  -  2 x Light Tank  -  1 x SP Flak  -  1 x Obsolete Tank	4	59	(11.392304845413264,29.5)
1135	26 x SP Artillery  -  5 x SP Howitzer  -  1 x SP Mortar	26	21	(13.124355652982141,22)
1817	9 x Fighter-Bomber  -  2 x COIN Fighter Plane	9	44	(15.289419162443238,34.75)
1062	43 x Field Gun  -  3 x Howitzer	43	9	(19.186533479473212,20.5)
1889	32 x Fighter-Bomber  -  2 x COIN Fighter Plane	32	44	(8.3612159321677293,36.25)
1626	25 x Light SP ATGM  -  20 x SP ATGM  -  10 x Airborne Support APC  -  8 x Wheeled SP-ATGM	25	129	(22.650635094610966,31)
212		0	\N	\N
213		0	\N	\N
2380	53 x Helicopter  -  18 x Heavy Helicopter  -  1 x Light Helicopter	53	53	(17.887495373796554,45.25)
164	6 x Fortifications	6	0	(3.598076211353316,4)
1448	3 x Assault Gun  -  3 x Light Tank  -  2 x Armoured Car  -  2 x SP Gun  -  2 x Heavy Armoured Car  -  1 x Self Propelled Gun  -  1 x MBT  -  1 x Gun APC (Tracked)  -  1 x Captured Tank	3	12	(7.0621778264910704,28)
326	84 x Fortifications	84	0	(5.3301270189221936,7)
2238	1 x Paratroop Transport	1	60	(33.47595264191645,42.25)
704	1 x Mortar	1	5	(21.351596988934308,13.75)
78	4 x Commando Engineers  -  3 x Engineer  -  3 x Para Forward Observer  -  2 x Marine Forward Observer  -  2 x Pioneers  -  2 x Guards Engineers  -  1 x Para Engineers  -  1 x Guerrilla Hvy Inf Squad  -  1 x Guards Scouts  -  1 x Engineer Support Squad  -  1 x Partisan Band  -  1 x Commando Scouts	4	145	(33.47595264191645,1.75)
1328	4 x MBT  -  2 x Fortifications  -  2 x Medium Tank  -  1 x Obsolete Heavy Tank  -  1 x Obsolete Tank	4	59	(7.49519052838329,25.75)
1986	5 x Scout Vehicle  -  2 x Light APC  -  2 x Armoured Car  -  2 x APC (Wheel)  -  1 x FO Vehicle	5	32	(23.083647796503186,37.75)
133	27 x O/M Field Artillery  -  15 x O/M Medium Artillery  -  7 x O/M Heavy Artillery	27	10	(11.825317547305483,3.25)
1202	2 x MBT  -  1 x Mine Clearing Tank  -  1 x Medium Tank	2	59	(1.8660254037844386,23.5)
1644	2 x APC (Track)  -  1 x Light APC  -  1 x APC  -  1 x Heavy APC	2	25	(4.0310889132455356,31.75)
279	2 x Light Infantry	2	51	(33.908965343808667,5.5)
2080	13 x Utility Vehicle  -  1 x Motorcycle  -  1 x APC (Wheel)  -  1 x Light Truck	13	26	(35.208003449485325,39.25)
100	2 x O/M Field Artillery	2	10	(17.454482671904334,2.5)
1739	16 x Fighter-Bomber  -  1 x Demolition	16	44	(17.021469970012117,33.25)
492	8 x Close Support Tank  -  4 x MBT  -  1 x Gunship Aircraft  -  1 x Light Tank  -  1 x Medium Tank  -  1 x Obsolete Tank	8	15	(10.526279441628825,10)
638	1 x Irregulars  -  1 x Militia	1	189	(33.47595264191645,12.25)
755	1 x Militia  -  1 x Motorcycle(Heavy Inf)	1	188	(30.444863728670914,14.5)
1220	41 x Flak	41	8	(17.454482671904334,23.5)
158	23 x Engineer  -  9 x Ranger Pioneer  -  8 x Pioneers  -  5 x Para Engineers  -  4 x Irregulars  -  2 x Ski Pioneers  -  1 x Engineer Support Squad  -  1 x Rangers  -  1 x Marine Engineers	23	20	(33.47595264191645,3.25)
1343	11 x AT Gun	11	6	(20.48557158514987,25.75)
2093	19 x Fighter-Bomber  -  1 x COIN Fighter Plane	19	44	(11.392304845413264,40)
2172	1 x Fighter-Bomber	1	44	(10.526279441628825,41.5)
2368	27 x Attack Helicopter  -  1 x Light Attack Helicopter	27	203	(7.49519052838329,45.25)
170	11 x Patrol Boat  -  2 x Landing Barge  -  2 x LCS  -  2 x LCG	11	199	(8.794228634059948,4)
1355	19 x Cavalry  -  11 x Ammo Carrier  -  8 x FO Vehicle  -  4 x Motorcycle  -  3 x Light Truck  -  3 x Light APC  -  1 x Utility Vehicle  -  1 x Bicycle Squad  -  1 x Air OP Aircraft  -  1 x Cavalry Scouts	19	3	(30.877876430563134,25.75)
244	4 x Fortifications  -  1 x SP Mortar	4	0	(3.598076211353316,5.5)
38	11 x Engineer  -  5 x Para Engineers  -  3 x Pioneers  -  3 x Ranger Hvy Infantry Squad  -  3 x Ski Pioneers  -  2 x Militia  -  2 x Guards Scouts  -  2 x Rangers  -  1 x Partisan Scouts  -  1 x Para light Infantry  -  1 x Commando Scouts  -  1 x Commando Engineers	11	20	(33.042939940024233,1)
128	1 x Fortifications	1	0	(7.49519052838329,3.25)
1361	1 x MBT  -  1 x Medium Tank	1	59	(1,26.5)
1657	1 x SP SAM	1	30	(15.289419162443238,31.75)
332		0	\N	\N
337		0	\N	\N
338		0	\N	\N
353	3 x Commando Engineers  -  3 x Mechanised Infantry  -  2 x Commandos  -  2 x Para Medium Infantry  -  1 x Rangers  -  1 x Guards Engineers  -  1 x Mech Support Squad  -  1 x Heavy Guards Squad  -  1 x Engineer Support Squad	3	145	(28.712812921102035,7)
1622	2 x Heavy Inf-ATGM  -  1 x Inf-ATGM Team  -  1 x Para-ATGM Team	2	212	(19.186533479473212,31)
1990	7 x APC (Track)  -  7 x APC (Wheel)  -  2 x MRV APC  -  1 x Light APC  -  1 x Light MRV APC	7	25	(26.54774941164094,37.75)
1663	1 x Commando Inf-AT	1	146	(20.48557158514987,31.75)
2126	21 x Fighter-Bomber  -  1 x COIN Fighter Plane	21	44	(5.7631397208144124,40.75)
722	1 x MBT	1	59	(1.8660254037844386,14.5)
1330	2 x Fortifications	2	0	(9.2272413359521668,25.75)
1078	2 x Marine Heavy Infantry  -  1 x Guerrilla Inf Squad	2	240	(33.042939940024233,20.5)
2336	2 x Area SAM  -  1 x SP SAM	2	16	(13.99038105676658,44.5)
646	1 x MBT	1	59	(5.3301270189221936,13)
1876	1 x Scout Vehicle	1	32	(31.310889132455351,35.5)
1157	4 x Mortar(Sub Type B)  -  2 x Police  -  1 x Partisan Scouts	4	201	(32.176914536239792,22)
129	6 x Fortifications	6	0	(8.3612159321677293,3.25)
195	3 x Guards Engineers  -  2 x Paratroop Scouts  -  2 x Marine Forward Observer  -  1 x Para Engineers  -  1 x Commando Scouts  -  1 x Commando Support  -  1 x Patrol	3	170	(30.444863728670914,4)
744	5 x O/M Field Artillery	5	10	(20.918584287042091,14.5)
1106	31 x Field Gun	31	9	(23.083647796503186,21.25)
2064	6 x Engineer Tank  -  1 x Mine Clearing Tank  -  1 x Light Support APC	6	37	(21.351596988934308,39.25)
1230	14 x AGL  -  2 x Marine Infantry AT  -  1 x Para MG	14	7	(26.114736709748719,23.5)
1947	18 x FO Vehicle  -  3 x Scout Vehicle  -  1 x Ammo Carrier	18	57	(23.516660498395403,37)
1430	16 x Inf-AT  -  7 x Para Inf-AT  -  4 x Inf-RR Team  -  3 x Ski Inf-AT  -  1 x Reserve Supt Squad	16	2	(26.54774941164094,27.25)
1402	1 x Light Cavalry Tank	1	132	(2.299038105676658,27.25)
971	4 x SP Rocket Launcher  -  2 x Mine Clearing Tank  -  2 x SP Artillery  -  1 x Engineer Tank	4	137	(9.6602540378443873,19)
2356	13 x Ammo Carrier  -  2 x FO Vehicle	13	56	(31.310889132455351,44.5)
1572	4 x Scout Vehicle  -  4 x APC (Track)  -  2 x APC (Wheel)  -  1 x Heavy Amphibian  -  1 x Light Support APC	4	32	(10.959292143521045,30.25)
551	2 x Partisan Scouts  -  1 x Legion SMG Squad	2	80	(27.413774815425377,10.75)
930	1 x Engineer Tank	1	37	(9.2272413359521668,18.25)
2319	7 x Ammo Carrier	7	56	(34.341978045700891,43.75)
179	10 x O/M Heavy Artillery  -  8 x O/M Medium Artillery  -  6 x O/M Field Artillery	10	156	(16.588457268119896,4)
2051	11 x Fighter-Bomber  -  2 x COIN Fighter Plane	11	44	(10.093266739736606,39.25)
855	21 x SP Mortar	21	38	(13.55736835487436,16.75)
2194	101 x Heavy Truck  -  2 x Medium Truck  -  1 x Utility Vehicle  -  1 x Artillery Prime Mover	101	28	(29.578838324886476,41.5)
877	1 x Militia Support  -  1 x Reserve Supt Squad  -  1 x LMG Section	1	192	(32.609927238132009,16.75)
959	2 x Commando Engineers  -  2 x Paratroop Scouts  -  2 x Engineer  -  1 x Pioneers	2	145	(34.341978045700891,18.25)
1825	5 x SP SAM	5	30	(22.217622392718749,34.75)
1925	34 x Fighter-Bomber  -  3 x SEAD Aircraft	34	44	(4.4641016151377544,37)
2144	8 x Ammo Carrier	8	56	(21.351596988934308,40.75)
693	7 x Gunship Aircraft  -  1 x APC (Wheel)  -  1 x FO Vehicle	7	215	(11.825317547305483,13.75)
1916	6 x Scout Vehicle  -  2 x Light Support APC  -  1 x Improvised APC  -  1 x Armoured Car  -  1 x Light Truck	6	32	(31.743901834347572,36.25)
370	6 x Patrol Boat  -  1 x LCS  -  1 x LCG	6	199	(9.2272413359521668,7.75)
1368	1 x SP Gun	1	39	(7.0621778264910704,26.5)
2008	11 x Fighter-Bomber  -  1 x COIN Fighter Plane	11	44	(7.0621778264910704,38.5)
622	3 x Mortar  -  2 x Mortar(Sub Type B)  -  1 x Mortar(Sub Type A)	3	5	(19.619546181365433,12.25)
1563	1 x Light APC  -  1 x APC (Track)  -  1 x Light Support APC	1	25	(3.1650635094610968,30.25)
1971	4 x Fighter-Bomber	4	44	(10.093266739736606,37.75)
48	1 x Fortifications	1	0	(7.49519052838329,1.75)
821	28 x SP Rocket Launcher	28	137	(18.320508075688775,16)
204	19 x Fortifications	19	0	(4.0310889132455356,4.75)
1099	2 x Mortar(Sub Type A)	2	200	(17.021469970012117,21.25)
2243	14 x Attack Helicopter  -  4 x Light Attack Helicopter	14	203	(2.7320508075688772,43)
1968	37 x Fighter-Bomber  -  2 x COIN Fighter Plane	37	44	(7.49519052838329,37.75)
356	1 x Fortifications	1	0	(31.310889132455351,7)
299	2 x Fortifications	2	0	(17.021469970012117,6.25)
95	32 x O/M Field Artillery  -  1 x O/M Medium Artillery	32	10	(13.124355652982141,2.5)
1908	1 x FO Vehicle	1	57	(24.815698604072061,36.25)
1603	10 x APC (Track)  -  4 x APC (Wheel)  -  3 x Light Support APC  -  2 x Light APC  -  2 x Heavy APC  -  2 x Scout Vehicle  -  1 x APC  -  1 x Gun APC (Wheeled)	10	25	(2.7320508075688772,31)
871	17 x Flak	17	8	(27.413774815425377,16.75)
623	15 x Mortar  -  1 x Light Mortar	15	5	(20.48557158514987,12.25)
751	2 x Machine Gun Section  -  1 x Scout Vehicle  -  1 x MG Unit  -  1 x para MG Section  -  1 x FO Vehicle	2	4	(26.98076211353316,14.5)
2188	5 x Landing Barge	5	41	(24.382685902179844,41.5)
2189	4 x Heavy Amphibian  -  2 x Landing Barge  -  1 x Hovercraft  -  1 x Rivercraft	4	34	(25.248711305964282,41.5)
454	2 x APC (Track)  -  2 x Gun APC (Tracked)	2	25	(12.691342951089922,9.25)
2057	7 x Level Bomber	7	62	(15.289419162443238,39.25)
127	22 x Fortifications	22	0	(6.6291651245988508,3.25)
939	3 x SP Artillery  -  2 x SP Mortar  -  1 x Obsolete Tank	3	21	(17.021469970012117,18.25)
1529	16 x APC (Track)  -  9 x Scout Vehicle  -  7 x Light Support APC  -  3 x Light Tank  -  2 x Heavy APC	16	25	(7.9282032302755088,29.5)
2275	2 x Glider	2	47	(30.444863728670914,43)
114	6 x Infantry  -  5 x Native Troops  -  5 x Militia  -  3 x Irregulars  -  2 x Heavy Militia  -  2 x Light Commandos  -  2 x Guards Infantry  -  1 x Medium Infantry  -  1 x Light Infantry  -  1 x Light Mech Infantry  -  1 x COIN Infantry Squad  -  1 x Mechanised Infantry  -  1 x Rangers	6	1	(29.578838324886476,2.5)
342		0	\N	\N
439	5 x Infantry  -  4 x Mechanised Infantry  -  3 x Paratroops  -  3 x Heavy Mech Infantry  -  3 x Heavy Ski Troops  -  2 x Heavy Infantry  -  2 x Mech Support Squad  -  2 x Heavy Commandos  -  2 x Commandos  -  1 x Light Infantry  -  1 x Mercenaries  -  1 x Paratroop Support  -  1 x Ski Troops  -  1 x Reserve Infantry  -  1 x Motorised Inf Section  -  1 x Para Medium Infantry  -  1 x Guerrilla Hvy Inf Squad  -  1 x Guards Squad  -  1 x Medium Infantry	5	1	(33.908965343808667,8.5)
1303	2 x AT Gun	2	6	(20.05255888325765,25)
1612	16 x APC (Wheel)  -  4 x Scout Vehicle  -  2 x Light APC  -  2 x Light Support APC  -  2 x Heavy APC  -  1 x MRV APC	16	23	(10.526279441628825,31)
1906	1 x CS Infantry Tank  -  1 x SP Flak	1	106	(23.083647796503186,36.25)
669	16 x Para Mortar Team  -  3 x Paratroop Support  -  1 x Para light Infantry  -  1 x Partisans	16	173	(25.248711305964282,13)
2348	18 x Light Helicopter	18	204	(24.382685902179844,44.5)
1480	22 x Scout  -  14 x Paratroop Scouts  -  11 x Art Observer  -  7 x Commando Scouts  -  5 x Para Forward Observer  -  3 x Ranger Scout  -  3 x HQ  -  2 x Marine Heavy Infantry  -  1 x Marine Scout  -  1 x Para Mortar Team  -  1 x Commandos  -  1 x Ski Scouts	22	58	(34.774990747593108,28)
1765	10 x FO Vehicle  -  1 x MRV Light IFV	10	57	(4.4641016151377544,34)
117	2 x Engineer	2	20	(32.176914536239792,2.5)
991	6 x Mortar(Sub Type A)  -  5 x Mortar(Sub Type B)	6	200	(26.98076211353316,19)
438	8 x Infantry  -  7 x Mechanised Infantry  -  6 x Ski Troops  -  5 x Paratroops  -  4 x Heavy Infantry  -  3 x Marines  -  2 x Guerrilla Inf Squad  -  2 x Paratroop Support  -  2 x Motorised Inf Section  -  1 x Heavy Ski Troops  -  1 x Light Commandos  -  1 x Partisan Band  -  1 x Guerrilla Inf Support  -  1 x Medium Commandos  -  1 x Light Mech Infantry  -  1 x Guards Squad  -  1 x Light Infantry	8	1	(33.042939940024233,8.5)
1470	61 x Inf-AT  -  19 x Inf-RR Team  -  10 x Para Inf-AT  -  5 x Para-RR Team  -  3 x Ski Inf-AT  -  2 x Guerrilla Inf Support  -  2 x Marine Infantry AT	61	2	(26.114736709748719,28)
1953	8 x Scout Vehicle  -  5 x Light Support APC  -  2 x Armoured Car  -  1 x Light APC  -  1 x APC  -  1 x FO Vehicle	8	32	(28.712812921102035,37)
2011	17 x Fighter-Bomber  -  3 x COIN Fighter Plane	17	44	(9.6602540378443873,38.5)
2200	85 x Ammo Carrier  -  37 x FO Vehicle  -  3 x Air OP Aircraft  -  2 x SP Gun  -  2 x Utility Vehicle  -  2 x Light APC  -  1 x Scout Vehicle	85	56	(34.774990747593108,41.5)
309	3 x Irregulars  -  1 x Guerrilla Inf Squad	3	75	(25.681724007856502,6.25)
1151	2 x Flak	2	8	(26.98076211353316,22)
795	4 x LMG Section  -  1 x MG Unit  -  1 x Para Medium Infantry  -  1 x Paratroop Support  -  1 x MG Section  -  1 x Militia Support	4	65	(30.877876430563134,15.25)
1651	10 x APC (Track)  -  1 x Airborne APC  -  1 x Light Support APC	10	25	(10.093266739736606,31.75)
349	1 x Militia	1	189	(25.248711305964282,7)
363	16 x Fortifications	16	0	(3.1650635094610968,7.75)
341	25 x Fortifications	25	0	(18.320508075688775,7)
2330	5 x SP SAM	5	30	(8.794228634059948,44.5)
632	50 x Infantry  -  35 x Reserve Infantry  -  7 x Rifle Section  -  6 x Militia  -  5 x Motorised Inf Section  -  3 x Light Infantry  -  3 x Police  -  3 x Rifle Squad  -  3 x Heavy Militia  -  2 x Guerrilla Inf Squad  -  2 x Mechanised Infantry  -  2 x Cavalry  -  2 x Light Militia  -  2 x SMG Section  -  1 x Guards Infantry  -  1 x Marines  -  1 x Partisans  -  1 x Ski Troops	50	1	(28.279800219209818,12.25)
286	4 x Fortifications	4	0	(5.7631397208144124,6.25)
409	1 x Patrol Boat	1	199	(7.9282032302755088,8.5)
676	21 x Reserve Infantry  -  19 x Infantry  -  16 x Militia  -  14 x Rifle Section  -  6 x Cavalry Scouts  -  6 x Motorcycle(Heavy Inf)  -  6 x Police  -  4 x Light Guards Squad  -  3 x SMG Section  -  2 x Partisan Scouts  -  1 x Light Infantry  -  1 x Irregulars  -  1 x Guerrilla Inf Squad  -  1 x Reserve Supt Squad  -  1 x Rifle Squad  -  1 x Rangers  -  1 x Legionnaires	21	160	(31.310889132455351,13)
1154	9 x AA Truck  -  5 x SP Flak  -  1 x Light SPAA Vehicle  -  1 x Flak	9	181	(29.578838324886476,22)
986	2 x Field Gun  -  2 x Mortar(Sub Type B)  -  1 x Mortar(Sub Type C)	2	201	(22.650635094610966,19)
1376	6 x AT Gun  -  2 x Light AT Gun	6	6	(13.99038105676658,26.5)
950	2 x Mortar(Sub Type C)	2	202	(26.54774941164094,18.25)
717	2 x Militia  -  1 x Police  -  1 x Light Militia  -  1 x Cavalry Scouts  -  1 x Light Infantry	2	189	(32.609927238132009,13.75)
1697	1 x COIN Fighter Plane	1	223	(14.856406460551018,32.5)
691	2 x Scout Vehicle  -  2 x Armoured Car	2	32	(10.093266739736606,13.75)
217		0	\N	\N
220		0	\N	\N
1949	22 x Scout Vehicle  -  19 x Armoured Car  -  13 x FO Vehicle  -  2 x Ammo Carrier  -  1 x Cavalry Tank  -  1 x APC (Track)  -  1 x Assault Gun  -  1 x Light Tank  -  1 x APC (Wheel)  -  1 x Light APC	22	32	(25.248711305964282,37)
389	3 x Infantry  -  2 x Medium Mech Infantry  -  2 x COIN Hvy Infantry Squad  -  1 x Ski Troops  -  1 x Commandos  -  1 x Light Infantry  -  1 x Light Mech Infantry	3	1	(25.681724007856502,7.75)
767	2 x Amphibian Tank  -  2 x APC  -  2 x APC (Track)  -  1 x Heavy Amphibian  -  1 x SP ATGM  -  1 x Heavy APC	2	251	(6.6291651245988508,15.25)
2364	26 x Attack Helicopter  -  5 x Light Attack Helicopter  -  3 x Helicopter	26	203	(4.0310889132455356,45.25)
702	3 x Mortar  -  2 x Mortar(Sub Type A)  -  1 x Mortar(Sub Type C)  -  1 x Para Mortar Team	3	5	(19.619546181365433,13.75)
2257	7 x Level Bomber  -  1 x Fighter-Bomber	7	62	(14.856406460551018,43)
1844	5 x SP SAM  -  4 x SEAD Aircraft  -  3 x Area SAM  -  2 x Fighter-Bomber	5	30	(3.598076211353316,35.5)
205	2 x Fortifications	2	0	(4.897114317029974,4.75)
1907	30 x FO Vehicle  -  1 x Heavy Armoured Car  -  1 x Utility Vehicle	30	57	(23.949673200287624,36.25)
197	9 x Engineer  -  6 x Para Engineers  -  5 x Pioneers  -  5 x Engineer Support Squad  -  4 x Cavalry  -  4 x Marine Engineers  -  3 x Commando Engineers  -  2 x Commando Support  -  2 x Commandos  -  1 x Bicycle Squad  -  1 x Guerrilla Inf Squad  -  1 x Ski Pioneers  -  1 x Ranger Pioneer  -  1 x Paratroops  -  1 x Rangers	9	20	(32.176914536239792,4)
1067	11 x Field Gun  -  1 x Pack Howitzer	11	9	(23.516660498395403,20.5)
1103	11 x Field Gun	11	9	(20.48557158514987,21.25)
447	4 x Medium Tank  -  3 x MBT	4	13	(6.6291651245988508,9.25)
1814	33 x Fighter-Bomber  -  5 x COIN Fighter Plane	33	44	(12.691342951089922,34.75)
343		0	\N	\N
362		0	\N	\N
558	2 x Mech Support Squad  -  2 x Paratroops  -  1 x Guerrilla Lt Inf Squad  -  1 x Guerrilla Inf Squad  -  1 x Infantry  -  1 x Engineer	2	73	(33.47595264191645,10.75)
156	7 x Para Engineers  -  5 x Ranger Pioneer  -  4 x Engineer  -  2 x Scout  -  2 x Paratroop Scouts	7	141	(31.743901834347572,3.25)
1962	8 x Fighter-Bomber	8	44	(2.299038105676658,37.75)
1670	12 x SP ATGM  -  12 x Wheeled SP-ATGM  -  8 x Light SP ATGM  -  7 x SP Gun	12	19	(26.54774941164094,31.75)
2264	15 x Helicopter  -  4 x Heavy Helicopter	15	53	(20.918584287042091,43)
934	32 x SP Artillery  -  2 x SP Howitzer	32	21	(12.691342951089922,18.25)
951	1 x Flak	1	8	(27.413774815425377,18.25)
2127	26 x Fighter-Bomber  -  6 x COIN Fighter Plane	26	44	(6.6291651245988508,40.75)
249	11 x Landing Barge  -  1 x LCG	11	41	(7.9282032302755088,5.5)
269	11 x Infantry  -  6 x Motorised Inf Section  -  5 x Mechanised Infantry  -  5 x Rangers  -  3 x Guerrilla Inf Squad  -  3 x Paratroops  -  3 x Rifle Squad  -  2 x Ranger Lt Infantry Squad  -  2 x Guards Infantry  -  2 x Marines  -  1 x Ski Troops  -  1 x Light Guards Squad  -  1 x Patrol	11	1	(25.248711305964282,5.5)
1020	4 x SP Artillery	4	21	(17.887495373796554,19.75)
194	2 x Marine Light Infantry  -  2 x Mechanised Infantry  -  2 x Medium Mech Infantry  -  1 x Engineer Support Squad  -  1 x Paratroop Scouts	2	71	(29.578838324886476,4)
835	36 x MG Unit  -  21 x MG Section  -  13 x Machine Gun Section  -  2 x LMG Section  -  1 x Para MG  -  1 x Guerrilla Hvy Inf Squad  -  1 x Medium Infantry	36	193	(30.444863728670914,16)
844	2 x Heavy MRV APC  -  1 x Light Tank  -  1 x Cavalry Tank	2	220	(4.0310889132455356,16.75)
964	17 x Medium Tank  -  12 x MBT  -  10 x CS MBT  -  4 x Main Battle Tank  -  4 x Mine Clearing Tank  -  1 x Heavy Tank	17	13	(3.598076211353316,19)
316	1 x Paratroop Support  -  1 x Paratroops  -  1 x Guerrilla Hvy Inf Squad	1	97	(31.743901834347572,6.25)
2205	3 x Fighter-Bomber  -  2 x Gunship Aircraft	3	44	(4.897114317029974,42.25)
132	1 x O/M Medium Artillery  -  1 x O/M Field Artillery	1	10	(10.959292143521045,3.25)
520	2 x Engineer  -  1 x Medium Commandos  -  1 x Engineer Support Squad  -  1 x Commandos	2	20	(34.774990747593108,10)
688	10 x Airborne APC  -  3 x APC (Track)  -  1 x Light Support APC	10	123	(7.49519052838329,13.75)
2063	19 x Engineer Tank	19	37	(20.48557158514987,39.25)
721	9 x MBT  -  5 x Medium Tank  -  2 x Obsolete Tank  -  1 x Close Support Tank  -  1 x Mine Clearing Tank	9	59	(1,14.5)
1216	31 x AT Gun  -  5 x Heavy AT Gun	31	6	(13.99038105676658,23.5)
1362	10 x MBT  -  6 x Medium Tank	10	59	(1.8660254037844386,26.5)
67	1 x Heavy Infantry	1	40	(23.949673200287624,1.75)
457	9 x Mortar  -  6 x Mortar(Sub Type A)  -  6 x Mortar(Sub Type B)  -  1 x Mortar(Sub Type C)  -  1 x Mortar(Sub Type D)	9	5	(15.289419162443238,9.25)
2347	63 x Helicopter  -  28 x Light Helicopter	63	53	(23.516660498395403,44.5)
352	1 x Commando Scouts  -  1 x Infantry  -  1 x Commandos	1	83	(27.846787517317598,7)
395	8 x Marines  -  6 x Infantry  -  5 x Motorised Inf Section  -  5 x Paratroops  -  4 x Mechanised Infantry  -  4 x Cavalry  -  3 x Marine Scout  -  3 x Commandos  -  3 x Rangers  -  2 x COIN Infantry Squad  -  2 x Marine Light Infantry  -  2 x Guards Infantry  -  2 x Para Medium Infantry  -  2 x Heavy Infantry  -  2 x Mercenaries  -  2 x Rifle Section  -  1 x Police  -  1 x Legionnaires  -  1 x Ranger Lt Infantry Squad  -  1 x Light Mech Infantry	8	110	(30.877876430563134,7.75)
1928	20 x Fighter-Bomber	20	44	(7.0621778264910704,37)
2003	16 x Fighter-Bomber  -  10 x SEAD Aircraft	16	44	(2.7320508075688772,38.5)
2195	5 x Utility Vehicle	5	26	(30.444863728670914,41.5)
703	3 x Mortar	3	5	(20.48557158514987,13.75)
761	18 x MBT  -  5 x Medium Tank  -  4 x Obsolete Tank  -  2 x FO Vehicle  -  1 x Engineer Tank  -  1 x Mine Clearing Tank  -  1 x Main Battle Tank	18	59	(1.4330127018922194,15.25)
947	22 x Mortar(Sub Type B)  -  18 x Mortar(Sub Type C)  -  17 x Heavy Mortar  -  8 x Mortar(Sub Type A)  -  6 x Mortar  -  1 x Mortar(Sub Type D)	22	201	(23.949673200287624,18.25)
1786	59 x SP SAM	59	30	(22.650635094610966,34)
1066	2 x Field Gun	2	9	(22.650635094610966,20.5)
224	4 x Cavalry	4	3	(21.351596988934308,4.75)
660	2 x Heavy Mortar  -  1 x Mortar(Sub Type B)	2	152	(17.454482671904334,13)
1325	2 x Light Tank  -  1 x Amphibian Tank  -  1 x Medium Tank	2	12	(4.897114317029974,25.75)
1686	2 x FO Vehicle  -  1 x Airborne APC	2	57	(5.3301270189221936,32.5)
513	2 x Heavy Ski Troops  -  1 x Marines  -  1 x Partisan Scouts  -  1 x Guards Squad	2	163	(28.712812921102035,10)
586	45 x Light Mortar  -  12 x Mortar  -  6 x Mortar(Sub Type A)  -  1 x Mortar(Sub Type D)  -  1 x Mortar(Sub Type B)	45	153	(22.650635094610966,11.5)
2250	22 x SP Flak	22	22	(8.794228634059948,43)
2358	91 x Barge Carrier  -  5 x Air OP Aircraft  -  1 x Rivercraft	91	48	(33.042939940024233,44.5)
221		0	\N	\N
233		0	\N	\N
2244	12 x Attack Helicopter  -  4 x Light Attack Helicopter  -  1 x Helicopter	12	203	(3.598076211353316,43)
51	1 x O/M Heavy Artillery  -  1 x O/M Minelet Arty Bty	1	211	(10.093266739736606,1.75)
1973	19 x Fighter-Bomber  -  5 x COIN Fighter Plane	19	44	(11.825317547305483,37.75)
2236	4 x Snow Vehicle  -  1 x Light Amphibian	4	167	(31.743901834347572,42.25)
1132	7 x Amphibian Tank  -  4 x Light Tank  -  1 x MBT	7	35	(10.526279441628825,22)
2225	12 x Heavy Amphibian  -  12 x Hovercraft  -  2 x Patrol Boat  -  1 x Rivercraft  -  1 x LCG	12	34	(22.217622392718749,42.25)
2088	3 x Fighter-Bomber  -  1 x COIN Fighter Plane	3	44	(7.0621778264910704,40)
69	1 x Light Commandos	1	85	(25.681724007856502,1.75)
460	5 x Machine Gun Section  -  1 x MG Section	5	4	(17.887495373796554,9.25)
2298	1 x Attack Helicopter	1	203	(16.155444566227676,43.75)
203	3 x Fortifications	3	0	(3.1650635094610968,4.75)
529	1 x Medium Tank	1	13	(8.3612159321677293,10.75)
385	1 x Para MG	1	144	(22.217622392718749,7.75)
441	37 x MBT  -  16 x Medium Tank  -  6 x Obsolete Tank  -  2 x Close Support Tank  -  1 x CS Infantry Tank	37	59	(1.4330127018922194,9.25)
373		0	\N	\N
374		0	\N	\N
377		0	\N	\N
378		0	\N	\N
393	6 x Light Infantry  -  5 x Marines  -  3 x Mechanised Infantry  -  2 x Medium Commandos  -  2 x Para Medium Infantry  -  1 x Patrol  -  1 x Light Mech Infantry  -  1 x Commandos  -  1 x Partisans  -  1 x Engineer  -  1 x Commando Engineers	6	51	(29.145825622994256,7.75)
81	4 x Fortifications	4	0	(1,2.5)
557	1 x Marines  -  1 x Guerrilla Lt Inf Squad  -  1 x Infantry	1	1	(32.609927238132009,10.75)
778	3 x SP Rocket Launcher	3	137	(16.155444566227676,15.25)
2006	5 x Fighter-Bomber  -  1 x COIN Fighter Plane	5	44	(5.3301270189221936,38.5)
2117	9 x Light Truck  -  1 x Utility Vehicle	9	183	(32.176914536239792,40)
870	22 x Flak	22	8	(26.54774941164094,16.75)
1197	132 x Scout  -  6 x Partisan Scouts  -  4 x Ranger Scout  -  2 x Guards Scouts  -  2 x Guerrilla Scout  -  1 x Patrol  -  1 x Paratroop Scouts  -  1 x Native Troops  -  1 x Rifle Section  -  1 x Light Militia  -  1 x COIN Scout  -  1 x Ski Scouts  -  1 x Commando Scouts	132	58	(32.609927238132009,22.75)
42	1 x Fortifications	1	0	(2.299038105676658,1.75)
1596	7 x Art Observer	7	63	(31.743901834347572,30.25)
1472	2 x Inf-AT  -  2 x Para Inf-AT	2	142	(27.846787517317598,28)
59	1 x O/M Medium Artillery	1	155	(17.021469970012117,1.75)
1013	1 x SP Howitzer	1	130	(11.825317547305483,19.75)
1604	4 x APC (Track)  -  3 x Light Support APC  -  2 x Heavy APC  -  2 x APC (Wheel)	4	25	(3.598076211353316,31)
1254	2 x Assault Gun  -  1 x Airborne Lt Tank	2	18	(12.691342951089922,24.25)
621	2 x Mortar  -  1 x Mortar(Sub Type B)	2	5	(18.753520777580992,12.25)
734	27 x SP Mortar  -  7 x Light SP Mortar  -  2 x SP Artillery  -  1 x Armoured Car	27	38	(12.258330249197702,14.5)
1068	24 x Field Gun  -  7 x Pack Howitzer  -  3 x Airborne Field Howitzer  -  2 x Howitzer	24	9	(24.382685902179844,20.5)
2367	53 x Attack Helicopter  -  2 x Light Attack Helicopter	53	203	(6.6291651245988508,45.25)
116	2 x Engineer  -  1 x SMG Section  -  1 x Engineer Support Squad  -  1 x Police  -  1 x Ranger Pioneer  -  1 x Militia  -  1 x Ski Pioneers	2	20	(31.310889132455351,2.5)
350	6 x Light Infantry  -  1 x Commando Scouts	6	51	(26.114736709748719,7)
1807	49 x Fighter-Bomber	49	44	(6.6291651245988508,34.75)
1969	11 x Fighter-Bomber	11	44	(8.3612159321677293,37.75)
2157	54 x Light Truck  -  33 x Utility Vehicle  -  1 x Light APC  -  1 x Light Support APC	54	183	(32.609927238132009,40.75)
1287	34 x MBT  -  12 x Medium Tank  -  6 x CS MBT  -  3 x Flame Tank  -  1 x Close Support Tank  -  1 x Fortifications	34	59	(6.196152422706632,25)
1574	2 x Light Tank  -  2 x SP Flak  -  1 x MBT  -  1 x Armoured Car  -  1 x Obsolete Tank	2	12	(12.691342951089922,30.25)
394	3 x Infantry	3	1	(30.011851026778693,7.75)
2048	2 x Fighter-Bomber	2	44	(7.49519052838329,39.25)
1025	3 x Field Gun	3	9	(22.217622392718749,19.75)
862	1 x SP Rocket Launcher	1	137	(19.619546181365433,16.75)
501	9 x Machine Gun Section  -  4 x Heavy MG  -  3 x Heavy MG Section  -  1 x MG Section	9	4	(18.320508075688775,10)
1481	4 x APC (Track)  -  2 x Light Tank  -  1 x MRV IFV  -  1 x Heavy APC  -  1 x APC (Wheel)	4	25	(1.4330127018922194,28.75)
1507	3 x Inf-RR Team  -  1 x Inf-AT  -  1 x Para Inf-AT	3	208	(23.949673200287624,28.75)
1637	2 x FO Vehicle	2	57	(32.176914536239792,31)
2379	4 x Light Helicopter  -  2 x Light Attack Helicopter  -  1 x Helicopter	4	204	(17.021469970012117,45.25)
207	1 x Fortifications	1	0	(6.6291651245988508,4.75)
2327	3 x Attack Helicopter  -  1 x Light Attack Helicopter	3	203	(6.196152422706632,44.5)
1664	3 x Light SP ATGM  -  2 x Wheeled SP-ATGM  -  1 x SP ATGM	3	129	(21.351596988934308,31.75)
2009	3 x Fighter-Bomber	3	44	(7.9282032302755088,38.5)
1467	4 x Inf-AT  -  3 x Commando Inf-AT  -  1 x Marine Infantry AT  -  1 x Para Inf-AT	4	2	(23.516660498395403,28)
418	14 x Light Mortar  -  7 x Mortar  -  7 x Mortar(Sub Type B)  -  2 x Mortar(Sub Type A)	14	153	(15.722431864335457,8.5)
1523	2 x Heavy APC  -  1 x Light APC	2	120	(2.7320508075688772,29.5)
1514	10 x Partisan Support  -  4 x Engineer Support Squad  -  4 x Commando Inf-AT  -  2 x AGL  -  1 x Gun APC (Wheeled)  -  1 x Wheeled SP-ATGM  -  1 x Ski Inf-AT  -  1 x Inf-AT	10	77	(30.011851026778693,28.75)
463	2 x Machine Gun Section  -  2 x para MG Section  -  1 x MG Section  -  1 x Heavy MG Section	2	4	(20.48557158514987,9.25)
2077	4 x Light MRV APC	4	219	(32.609927238132009,39.25)
246	28 x Fortifications	28	0	(5.3301270189221936,5.5)
8		0	\N	\N
9		0	\N	\N
16		0	\N	\N
20		0	\N	\N
22		0	\N	\N
23		0	\N	\N
29		0	\N	\N
40		0	\N	\N
49		0	\N	\N
50		0	\N	\N
52		0	\N	\N
55		0	\N	\N
56		0	\N	\N
61		0	\N	\N
62		0	\N	\N
89		0	\N	\N
90		0	\N	\N
92		0	\N	\N
93		0	\N	\N
96		0	\N	\N
97		0	\N	\N
102		0	\N	\N
131		0	\N	\N
137		0	\N	\N
142		0	\N	\N
144		0	\N	\N
157		0	\N	\N
169		0	\N	\N
172		0	\N	\N
174		0	\N	\N
177		0	\N	\N
180		0	\N	\N
181		0	\N	\N
183		0	\N	\N
184		0	\N	\N
185		0	\N	\N
188		0	\N	\N
198		0	\N	\N
248		0	\N	\N
258		0	\N	\N
259		0	\N	\N
264		0	\N	\N
265		0	\N	\N
284		0	\N	\N
288		0	\N	\N
293		0	\N	\N
298		0	\N	\N
304		0	\N	\N
305		0	\N	\N
325		0	\N	\N
328		0	\N	\N
329		0	\N	\N
415		0	\N	\N
417		0	\N	\N
419		0	\N	\N
420		0	\N	\N
421		0	\N	\N
428		0	\N	\N
430		0	\N	\N
433		0	\N	\N
452		0	\N	\N
455		0	\N	\N
458		0	\N	\N
459		0	\N	\N
484		0	\N	\N
488		0	\N	\N
489		0	\N	\N
491		0	\N	\N
493		0	\N	\N
496		0	\N	\N
497		0	\N	\N
498		0	\N	\N
499		0	\N	\N
502		0	\N	\N
504		0	\N	\N
507		0	\N	\N
509		0	\N	\N
523		0	\N	\N
525		0	\N	\N
526		0	\N	\N
527		0	\N	\N
528		0	\N	\N
530		0	\N	\N
532		0	\N	\N
534		0	\N	\N
538		0	\N	\N
539		0	\N	\N
541		0	\N	\N
545		0	\N	\N
548		0	\N	\N
552		0	\N	\N
556		0	\N	\N
559		0	\N	\N
561		0	\N	\N
562		0	\N	\N
567		0	\N	\N
571		0	\N	\N
572		0	\N	\N
573		0	\N	\N
575		0	\N	\N
576		0	\N	\N
580		0	\N	\N
581		0	\N	\N
582		0	\N	\N
583		0	\N	\N
585		0	\N	\N
590		0	\N	\N
591		0	\N	\N
592		0	\N	\N
594		0	\N	\N
595		0	\N	\N
598		0	\N	\N
602		0	\N	\N
604		0	\N	\N
606		0	\N	\N
608		0	\N	\N
611		0	\N	\N
614		0	\N	\N
615		0	\N	\N
616		0	\N	\N
619		0	\N	\N
620		0	\N	\N
630		0	\N	\N
633		0	\N	\N
634		0	\N	\N
635		0	\N	\N
636		0	\N	\N
641		0	\N	\N
642		0	\N	\N
643		0	\N	\N
651		0	\N	\N
654		0	\N	\N
658		0	\N	\N
670		0	\N	\N
675		0	\N	\N
679		0	\N	\N
680		0	\N	\N
683		0	\N	\N
684		0	\N	\N
694		0	\N	\N
697		0	\N	\N
699		0	\N	\N
705		0	\N	\N
706		0	\N	\N
707		0	\N	\N
708		0	\N	\N
709		0	\N	\N
710		0	\N	\N
714		0	\N	\N
724		0	\N	\N
725		0	\N	\N
726		0	\N	\N
728		0	\N	\N
729		0	\N	\N
732		0	\N	\N
733		0	\N	\N
735		0	\N	\N
739		0	\N	\N
742		0	\N	\N
745		0	\N	\N
746		0	\N	\N
747		0	\N	\N
749		0	\N	\N
750		0	\N	\N
753		0	\N	\N
759		0	\N	\N
764		0	\N	\N
769		0	\N	\N
774		0	\N	\N
775		0	\N	\N
776		0	\N	\N
781		0	\N	\N
783		0	\N	\N
790		0	\N	\N
793		0	\N	\N
799		0	\N	\N
801		0	\N	\N
802		0	\N	\N
804		0	\N	\N
808		0	\N	\N
809		0	\N	\N
811		0	\N	\N
824		0	\N	\N
825		0	\N	\N
826		0	\N	\N
828		0	\N	\N
829		0	\N	\N
830		0	\N	\N
837		0	\N	\N
843		0	\N	\N
847		0	\N	\N
852		0	\N	\N
853		0	\N	\N
863		0	\N	\N
864		0	\N	\N
867		0	\N	\N
868		0	\N	\N
869		0	\N	\N
872		0	\N	\N
876		0	\N	\N
883		0	\N	\N
891		0	\N	\N
897		0	\N	\N
898		0	\N	\N
901		0	\N	\N
902		0	\N	\N
903		0	\N	\N
906		0	\N	\N
909		0	\N	\N
910		0	\N	\N
922		0	\N	\N
923		0	\N	\N
924		0	\N	\N
929		0	\N	\N
937		0	\N	\N
944		0	\N	\N
953		0	\N	\N
955		0	\N	\N
961		0	\N	\N
967		0	\N	\N
977		0	\N	\N
982		0	\N	\N
983		0	\N	\N
985		0	\N	\N
988		0	\N	\N
995		0	\N	\N
996		0	\N	\N
1002		0	\N	\N
1016		0	\N	\N
1017		0	\N	\N
1034		0	\N	\N
1042		0	\N	\N
1043		0	\N	\N
1045		0	\N	\N
1049		0	\N	\N
1052		0	\N	\N
1056		0	\N	\N
1059		0	\N	\N
1061		0	\N	\N
1071		0	\N	\N
1072		0	\N	\N
1074		0	\N	\N
1077		0	\N	\N
1082		0	\N	\N
1096		0	\N	\N
1097		0	\N	\N
1101		0	\N	\N
1102		0	\N	\N
1105		0	\N	\N
1107		0	\N	\N
1110		0	\N	\N
1114		0	\N	\N
1118		0	\N	\N
1123		0	\N	\N
1124		0	\N	\N
1131		0	\N	\N
1133		0	\N	\N
1136		0	\N	\N
1138		0	\N	\N
1139		0	\N	\N
1141		0	\N	\N
1142		0	\N	\N
1144		0	\N	\N
1165		0	\N	\N
1170		0	\N	\N
1173		0	\N	\N
1175		0	\N	\N
1177		0	\N	\N
1178		0	\N	\N
1179		0	\N	\N
1180		0	\N	\N
1183		0	\N	\N
1184		0	\N	\N
1189		0	\N	\N
1194		0	\N	\N
1199		0	\N	\N
1200		0	\N	\N
1207		0	\N	\N
1208		0	\N	\N
1212		0	\N	\N
1217		0	\N	\N
1218		0	\N	\N
1224		0	\N	\N
1228		0	\N	\N
1238		0	\N	\N
1239		0	\N	\N
1246		0	\N	\N
1247		0	\N	\N
1251		0	\N	\N
1255		0	\N	\N
1261		0	\N	\N
1262		0	\N	\N
1263		0	\N	\N
1264		0	\N	\N
1270		0	\N	\N
1273		0	\N	\N
1276		0	\N	\N
1278		0	\N	\N
1279		0	\N	\N
1284		0	\N	\N
1285		0	\N	\N
1292		0	\N	\N
1294		0	\N	\N
1299		0	\N	\N
1300		0	\N	\N
1301		0	\N	\N
1305		0	\N	\N
1310		0	\N	\N
1314		0	\N	\N
1317		0	\N	\N
1319		0	\N	\N
1327		0	\N	\N
1331		0	\N	\N
1332		0	\N	\N
1334		0	\N	\N
1335		0	\N	\N
1338		0	\N	\N
1344		0	\N	\N
1345		0	\N	\N
1348		0	\N	\N
1354		0	\N	\N
1358		0	\N	\N
1369		0	\N	\N
1371		0	\N	\N
1375		0	\N	\N
1382		0	\N	\N
1385		0	\N	\N
1395		0	\N	\N
1396		0	\N	\N
1409		0	\N	\N
1418		0	\N	\N
1419		0	\N	\N
1420		0	\N	\N
1421		0	\N	\N
1422		0	\N	\N
1423		0	\N	\N
1425		0	\N	\N
1426		0	\N	\N
1428		0	\N	\N
1429		0	\N	\N
1434		0	\N	\N
1435		0	\N	\N
1437		0	\N	\N
1442		0	\N	\N
1443		0	\N	\N
1446		0	\N	\N
1447		0	\N	\N
1450		0	\N	\N
1452		0	\N	\N
1456		0	\N	\N
1458		0	\N	\N
1459		0	\N	\N
1461		0	\N	\N
1466		0	\N	\N
1468		0	\N	\N
1475		0	\N	\N
1478		0	\N	\N
1482		0	\N	\N
1484		0	\N	\N
1485		0	\N	\N
1486		0	\N	\N
1496		0	\N	\N
1497		0	\N	\N
1498		0	\N	\N
1499		0	\N	\N
1500		0	\N	\N
1503		0	\N	\N
1516		0	\N	\N
1531		0	\N	\N
1532		0	\N	\N
1535		0	\N	\N
1536		0	\N	\N
1539		0	\N	\N
1540		0	\N	\N
1543		0	\N	\N
1546		0	\N	\N
1549		0	\N	\N
1550		0	\N	\N
1552		0	\N	\N
1553		0	\N	\N
1555		0	\N	\N
1556		0	\N	\N
1557		0	\N	\N
1558		0	\N	\N
1559		0	\N	\N
1566		0	\N	\N
1568		0	\N	\N
1575		0	\N	\N
1581		0	\N	\N
1586		0	\N	\N
1588		0	\N	\N
1589		0	\N	\N
1590		0	\N	\N
1593		0	\N	\N
1599		0	\N	\N
1621		0	\N	\N
1624		0	\N	\N
1625		0	\N	\N
1631		0	\N	\N
1634		0	\N	\N
1635		0	\N	\N
1636		0	\N	\N
1638		0	\N	\N
1639		0	\N	\N
1640		0	\N	\N
1646		0	\N	\N
1649		0	\N	\N
1653		0	\N	\N
1654		0	\N	\N
1655		0	\N	\N
1658		0	\N	\N
1661		0	\N	\N
1671		0	\N	\N
1672		0	\N	\N
1673		0	\N	\N
1674		0	\N	\N
1677		0	\N	\N
1678		0	\N	\N
1679		0	\N	\N
1682		0	\N	\N
1692		0	\N	\N
1693		0	\N	\N
1699		0	\N	\N
1700		0	\N	\N
1707		0	\N	\N
1710		0	\N	\N
1712		0	\N	\N
1713		0	\N	\N
1722		0	\N	\N
1727		0	\N	\N
1729		0	\N	\N
1730		0	\N	\N
1731		0	\N	\N
1732		0	\N	\N
1737		0	\N	\N
1741		0	\N	\N
1744		0	\N	\N
1752		0	\N	\N
1754		0	\N	\N
1755		0	\N	\N
1756		0	\N	\N
1763		0	\N	\N
1771		0	\N	\N
1775		0	\N	\N
1781		0	\N	\N
1782		0	\N	\N
1784		0	\N	\N
1785		0	\N	\N
1787		0	\N	\N
1788		0	\N	\N
1789		0	\N	\N
1793		0	\N	\N
1795		0	\N	\N
1796		0	\N	\N
1798		0	\N	\N
1799		0	\N	\N
1800		0	\N	\N
1805		0	\N	\N
1816		0	\N	\N
1823		0	\N	\N
1824		0	\N	\N
1826		0	\N	\N
1827		0	\N	\N
1835		0	\N	\N
1836		0	\N	\N
1837		0	\N	\N
1838		0	\N	\N
1839		0	\N	\N
1845		0	\N	\N
1853		0	\N	\N
1856		0	\N	\N
1861		0	\N	\N
1862		0	\N	\N
1874		0	\N	\N
1875		0	\N	\N
1881		0	\N	\N
1882		0	\N	\N
1896		0	\N	\N
1903		0	\N	\N
1909		0	\N	\N
1910		0	\N	\N
1912		0	\N	\N
1913		0	\N	\N
1915		0	\N	\N
1921		0	\N	\N
1936		0	\N	\N
1938		0	\N	\N
1940		0	\N	\N
1950		0	\N	\N
1951		0	\N	\N
1959		0	\N	\N
1964		0	\N	\N
1966		0	\N	\N
1967		0	\N	\N
1972		0	\N	\N
1974		0	\N	\N
1975		0	\N	\N
1982		0	\N	\N
1983		0	\N	\N
1991		0	\N	\N
1998		0	\N	\N
1999		0	\N	\N
2010		0	\N	\N
2012		0	\N	\N
2013		0	\N	\N
2014		0	\N	\N
2015		0	\N	\N
2017		0	\N	\N
2018		0	\N	\N
2019		0	\N	\N
2022		0	\N	\N
2023		0	\N	\N
2030		0	\N	\N
2031		0	\N	\N
2032		0	\N	\N
2036		0	\N	\N
2043		0	\N	\N
2045		0	\N	\N
2046		0	\N	\N
2054		0	\N	\N
2059		0	\N	\N
2062		0	\N	\N
2073		0	\N	\N
2074		0	\N	\N
2078		0	\N	\N
2087		0	\N	\N
2089		0	\N	\N
2096		0	\N	\N
2099		0	\N	\N
2100		0	\N	\N
2102		0	\N	\N
2107		0	\N	\N
2110		0	\N	\N
2114		0	\N	\N
2119		0	\N	\N
2120		0	\N	\N
2125		0	\N	\N
2129		0	\N	\N
2135		0	\N	\N
2140		0	\N	\N
2142		0	\N	\N
2143		0	\N	\N
2147		0	\N	\N
2149		0	\N	\N
2151		0	\N	\N
2152		0	\N	\N
2160		0	\N	\N
2164		0	\N	\N
2166		0	\N	\N
2173		0	\N	\N
2180		0	\N	\N
2192		0	\N	\N
2199		0	\N	\N
2203		0	\N	\N
2208		0	\N	\N
2210		0	\N	\N
2211		0	\N	\N
2224		0	\N	\N
2230		0	\N	\N
2235		0	\N	\N
2239		0	\N	\N
2248		0	\N	\N
2249		0	\N	\N
2251		0	\N	\N
2254		0	\N	\N
2265		0	\N	\N
2266		0	\N	\N
2268		0	\N	\N
2271		0	\N	\N
2272		0	\N	\N
2277		0	\N	\N
2278		0	\N	\N
2287		0	\N	\N
2288		0	\N	\N
2290		0	\N	\N
2294		0	\N	\N
2296		0	\N	\N
2297		0	\N	\N
2308		0	\N	\N
2314		0	\N	\N
2316		0	\N	\N
2329		0	\N	\N
2335		0	\N	\N
2338		0	\N	\N
2351		0	\N	\N
2354		0	\N	\N
2360		0	\N	\N
2378		0	\N	\N
2393		0	\N	\N
\.


--
-- Data for Name: bmus; Type: TABLE DATA; Schema: obat; Owner: -
--

COPY bmus (seqno, bmu, coord) FROM stdin;
1	1333	(11.825317547305483,25.75)
2	1333	(11.825317547305483,25.75)
3	1613	(11.392304845413264,31)
4	1494	(12.691342951089922,28.75)
5	1494	(12.691342951089922,28.75)
6	1454	(12.258330249197702,28)
7	1414	(12.691342951089922,27.25)
8	1413	(11.825317547305483,27.25)
9	1453	(11.392304845413264,28)
10	1090	(9.2272413359521668,21.25)
11	1090	(9.2272413359521668,21.25)
12	568	(7.0621778264910704,11.5)
13	487	(6.196152422706632,10)
14	441	(1.4330127018922194,9.25)
15	441	(1.4330127018922194,9.25)
16	603	(3.1650635094610968,12.25)
17	644	(3.598076211353316,13)
18	601	(1.4330127018922194,12.25)
19	1249	(8.3612159321677293,24.25)
20	1249	(8.3612159321677293,24.25)
21	1287	(6.196152422706632,25)
22	1287	(6.196152422706632,25)
23	1287	(6.196152422706632,25)
24	1283	(2.7320508075688772,25)
25	1283	(2.7320508075688772,25)
26	1241	(1.4330127018922194,24.25)
27	1241	(1.4330127018922194,24.25)
28	1241	(1.4330127018922194,24.25)
29	1041	(1,20.5)
30	1041	(1,20.5)
31	1041	(1,20.5)
32	762	(2.299038105676658,15.25)
33	762	(2.299038105676658,15.25)
34	1202	(1.8660254037844386,23.5)
35	1201	(1,23.5)
36	2156	(31.743901834347572,40.75)
37	2034	(29.578838324886476,38.5)
38	2034	(29.578838324886476,38.5)
39	1610	(8.794228634059948,31)
40	1608	(7.0621778264910704,31)
41	2028	(24.382685902179844,38.5)
42	1608	(7.0621778264910704,31)
43	1988	(24.815698604072061,37.75)
44	1761	(1,34)
45	1955	(30.444863728670914,37)
46	2111	(26.98076211353316,40)
47	2111	(26.98076211353316,40)
48	2069	(25.681724007856502,39.25)
49	1841	(1,35.5)
50	1841	(1,35.5)
51	2069	(25.681724007856502,39.25)
52	1603	(2.7320508075688772,31)
53	846	(5.7631397208144124,16.75)
54	665	(21.784609690826528,13)
55	663	(20.05255888325765,13)
56	663	(20.05255888325765,13)
57	659	(16.588457268119896,13)
58	659	(16.588457268119896,13)
59	945	(22.217622392718749,18.25)
60	904	(20.918584287042091,17.5)
61	543	(20.48557158514987,10.75)
62	543	(20.48557158514987,10.75)
63	543	(20.48557158514987,10.75)
64	542	(19.619546181365433,10.75)
65	543	(20.48557158514987,10.75)
66	1149	(25.248711305964282,22)
67	1069	(25.248711305964282,20.5)
68	1147	(23.516660498395403,22)
69	1148	(24.382685902179844,22)
70	1064	(20.918584287042091,20.5)
71	1062	(19.186533479473212,20.5)
72	1103	(20.48557158514987,21.25)
73	1063	(20.05255888325765,20.5)
74	905	(21.784609690826528,17.5)
75	905	(21.784609690826528,17.5)
76	1342	(19.619546181365433,25.75)
77	1352	(28.279800219209818,25.75)
78	1352	(28.279800219209818,25.75)
79	1392	(27.846787517317598,26.5)
80	1427	(23.949673200287624,27.25)
81	1350	(26.54774941164094,25.75)
82	2346	(22.650635094610966,44.5)
83	2347	(23.516660498395403,44.5)
84	2386	(23.083647796503186,45.25)
85	2382	(19.619546181365433,45.25)
86	2264	(20.918584287042091,43)
87	2302	(19.619546181365433,43.75)
88	2382	(19.619546181365433,45.25)
89	2382	(19.619546181365433,45.25)
90	2345	(21.784609690826528,44.5)
91	2302	(19.619546181365433,43.75)
92	2380	(17.887495373796554,45.25)
93	2364	(4.0310889132455356,45.25)
94	2364	(4.0310889132455356,45.25)
95	2299	(17.021469970012117,43.75)
96	2281	(1.4330127018922194,43.75)
97	2241	(1,43)
98	2241	(1,43)
99	1779	(16.588457268119896,34)
100	1981	(18.753520777580992,37.75)
101	1695	(13.124355652982141,32.5)
102	1695	(13.124355652982141,32.5)
103	1695	(13.124355652982141,32.5)
104	1860	(17.454482671904334,35.5)
105	1779	(16.588457268119896,34)
106	1821	(18.753520777580992,34.75)
107	1822	(19.619546181365433,34.75)
108	1902	(19.619546181365433,36.25)
109	1772	(10.526279441628825,34)
110	1694	(12.258330249197702,32.5)
111	1769	(7.9282032302755088,34)
112	2101	(18.320508075688775,40)
113	1769	(7.9282032302755088,34)
114	2060	(17.887495373796554,39.25)
115	1807	(6.6291651245988508,34.75)
116	2206	(5.7631397208144124,42.25)
117	2207	(6.6291651245988508,42.25)
118	2052	(10.959292143521045,39.25)
119	2170	(8.794228634059948,41.5)
120	1770	(8.794228634059948,34)
121	2020	(17.454482671904334,38.5)
122	2053	(11.825317547305483,39.25)
123	1925	(4.4641016151377544,37)
124	2094	(12.258330249197702,40)
125	1822	(19.619546181365433,34.75)
126	1807	(6.6291651245988508,34.75)
127	2052	(10.959292143521045,39.25)
128	1851	(9.6602540378443873,35.5)
129	1851	(9.6602540378443873,35.5)
130	1807	(6.6291651245988508,34.75)
131	2213	(11.825317547305483,42.25)
132	2052	(10.959292143521045,39.25)
133	2207	(6.6291651245988508,42.25)
134	2212	(10.959292143521045,42.25)
135	2134	(12.691342951089922,40.75)
136	2121	(1.4330127018922194,40.75)
137	2292	(10.959292143521045,43.75)
138	2292	(10.959292143521045,43.75)
139	21	(18.320508075688775,1)
140	101	(18.320508075688775,2.5)
141	58	(16.155444566227676,1.75)
142	17	(14.856406460551018,1)
143	17	(14.856406460551018,1)
144	17	(14.856406460551018,1)
145	178	(15.722431864335457,4)
146	10	(8.794228634059948,1)
147	178	(15.722431864335457,4)
148	178	(15.722431864335457,4)
149	7	(6.196152422706632,1)
150	7	(6.196152422706632,1)
151	5	(4.4641016151377544,1)
152	45	(4.897114317029974,1.75)
153	243	(2.7320508075688772,5.5)
154	321	(1,7)
155	321	(1,7)
156	321	(1,7)
157	321	(1,7)
158	1152	(27.846787517317598,22)
159	1222	(19.186533479473212,23.5)
160	911	(26.98076211353316,17.5)
161	911	(26.98076211353316,17.5)
162	1191	(27.413774815425377,22.75)
163	1140	(17.454482671904334,22)
164	1182	(19.619546181365433,22.75)
165	1222	(19.186533479473212,23.5)
166	2320	(35.208003449485325,43.75)
167	969	(7.9282032302755088,19)
168	1205	(4.4641016151377544,23.5)
169	850	(9.2272413359521668,16.75)
170	597	(32.176914536239792,11.5)
171	1424	(21.351596988934308,27.25)
172	1462	(19.186533479473212,28)
173	1462	(19.186533479473212,28)
174	1393	(28.712812921102035,26.5)
175	1433	(29.145825622994256,27.25)
176	1427	(23.949673200287624,27.25)
177	2071	(27.413774815425377,39.25)
178	2040	(34.774990747593108,38.5)
179	1955	(30.444863728670914,37)
180	2159	(34.341978045700891,40.75)
181	2040	(34.774990747593108,38.5)
182	2159	(34.341978045700891,40.75)
183	2159	(34.341978045700891,40.75)
184	2038	(33.042939940024233,38.5)
185	2371	(10.093266739736606,45.25)
186	1825	(22.217622392718749,34.75)
187	1592	(28.279800219209818,30.25)
188	1592	(28.279800219209818,30.25)
189	2400	(35.208003449485325,45.25)
190	2200	(34.774990747593108,41.5)
191	2398	(33.47595264191645,45.25)
192	1869	(25.248711305964282,35.5)
193	2399	(34.341978045700891,45.25)
194	1160	(34.774990747593108,22)
195	1160	(34.774990747593108,22)
196	1160	(34.774990747593108,22)
197	1439	(34.341978045700891,27.25)
198	2317	(32.609927238132009,43.75)
199	2269	(25.248711305964282,43)
200	2358	(33.042939940024233,44.5)
201	1356	(31.743901834347572,25.75)
202	2310	(26.54774941164094,43.75)
203	2310	(26.54774941164094,43.75)
204	1832	(28.279800219209818,34.75)
205	1080	(34.774990747593108,20.5)
206	1949	(25.248711305964282,37)
207	1534	(12.258330249197702,29.5)
208	1494	(12.691342951089922,28.75)
209	1494	(12.691342951089922,28.75)
210	1911	(27.413774815425377,36.25)
211	1494	(12.691342951089922,28.75)
212	1341	(18.753520777580992,25.75)
213	1298	(15.722431864335457,25)
214	1342	(19.619546181365433,25.75)
215	1298	(15.722431864335457,25)
216	1417	(15.289419162443238,27.25)
217	1298	(15.722431864335457,25)
218	1336	(14.423393758658799,25.75)
219	1296	(13.99038105676658,25)
220	1256	(14.423393758658799,24.25)
221	1216	(13.99038105676658,23.5)
222	1216	(13.99038105676658,23.5)
223	1306	(22.650635094610966,25)
224	1501	(18.753520777580992,28.75)
225	1501	(18.753520777580992,28.75)
226	1501	(18.753520777580992,28.75)
227	2374	(12.691342951089922,45.25)
228	2334	(12.258330249197702,44.5)
229	1786	(22.650635094610966,34)
230	2370	(9.2272413359521668,45.25)
231	1660	(17.887495373796554,31.75)
232	1537	(14.856406460551018,29.5)
233	1577	(15.289419162443238,30.25)
234	1618	(15.722431864335457,31)
235	2374	(12.691342951089922,45.25)
236	2374	(12.691342951089922,45.25)
237	2374	(12.691342951089922,45.25)
238	2376	(14.423393758658799,45.25)
239	2376	(14.423393758658799,45.25)
240	2336	(13.99038105676658,44.5)
241	2376	(14.423393758658799,45.25)
242	2377	(15.289419162443238,45.25)
243	1790	(26.114736709748719,34)
244	1905	(22.217622392718749,36.25)
245	2289	(8.3612159321677293,43.75)
246	1804	(4.0310889132455356,34.75)
247	1804	(4.0310889132455356,34.75)
248	2250	(8.794228634059948,43)
249	1790	(26.114736709748719,34)
250	522	(2.299038105676658,10.75)
251	1370	(8.794228634059948,26.5)
252	601	(1.4330127018922194,12.25)
253	601	(1.4330127018922194,12.25)
254	1250	(9.2272413359521668,24.25)
255	941	(18.753520777580992,18.25)
256	979	(16.588457268119896,19)
257	1374	(12.258330249197702,26.5)
258	1374	(12.258330249197702,26.5)
259	1415	(13.55736835487436,27.25)
260	1451	(9.6602540378443873,28)
261	1291	(9.6602540378443873,25)
262	1172	(10.959292143521045,22.75)
263	482	(1.8660254037844386,10)
264	1411	(10.093266739736606,27.25)
265	1411	(10.093266739736606,27.25)
266	2194	(29.578838324886476,41.5)
267	941	(18.753520777580992,18.25)
268	979	(16.588457268119896,19)
269	482	(1.8660254037844386,10)
270	973	(11.392304845413264,19)
271	1054	(12.258330249197702,20.5)
272	1670	(26.54774941164094,31.75)
273	1670	(26.54774941164094,31.75)
274	1669	(25.681724007856502,31.75)
275	1626	(22.650635094610966,31)
276	1708	(24.382685902179844,32.5)
277	1708	(24.382685902179844,32.5)
278	1743	(20.48557158514987,33.25)
279	1704	(20.918584287042091,32.5)
280	1704	(20.918584287042091,32.5)
281	1704	(20.918584287042091,32.5)
282	854	(12.691342951089922,16.75)
283	854	(12.691342951089922,16.75)
284	814	(12.258330249197702,16)
285	1834	(30.011851026778693,34.75)
286	1907	(23.949673200287624,36.25)
287	1725	(4.897114317029974,33.25)
288	1984	(21.351596988934308,37.75)
289	1984	(21.351596988934308,37.75)
290	1277	(32.609927238132009,24.25)
291	1277	(32.609927238132009,24.25)
292	1476	(31.310889132455351,28)
293	1753	(29.145825622994256,33.25)
294	1715	(30.444863728670914,32.5)
295	1676	(31.743901834347572,31.75)
296	1717	(32.176914536239792,32.5)
297	1759	(34.341978045700891,33.25)
298	1757	(32.609927238132009,33.25)
299	1759	(34.341978045700891,33.25)
300	1760	(35.208003449485325,33.25)
301	1680	(35.208003449485325,31.75)
302	673	(28.712812921102035,13)
303	673	(28.712812921102035,13)
304	151	(27.413774815425377,3.25)
305	113	(28.712812921102035,2.5)
306	113	(28.712812921102035,2.5)
307	1765	(4.4641016151377544,34)
308	1765	(4.4641016151377544,34)
309	1724	(4.0310889132455356,33.25)
310	673	(28.712812921102035,13)
311	673	(28.712812921102035,13)
312	152	(28.279800219209818,3.25)
313	113	(28.712812921102035,2.5)
314	113	(28.712812921102035,2.5)
315	554	(30.011851026778693,10.75)
316	554	(30.011851026778693,10.75)
317	554	(30.011851026778693,10.75)
318	152	(28.279800219209818,3.25)
319	113	(28.712812921102035,2.5)
320	194	(29.578838324886476,4)
321	194	(29.578838324886476,4)
322	37	(32.176914536239792,1)
323	80	(35.208003449485325,1.75)
324	37	(32.176914536239792,1)
325	80	(35.208003449485325,1.75)
326	37	(32.176914536239792,1)
327	80	(35.208003449485325,1.75)
328	37	(32.176914536239792,1)
329	80	(35.208003449485325,1.75)
330	1240	(34.774990747593108,23.5)
331	1240	(34.774990747593108,23.5)
332	1240	(34.774990747593108,23.5)
333	1360	(35.208003449485325,25.75)
334	1480	(34.774990747593108,28)
335	1600	(35.208003449485325,30.25)
336	37	(32.176914536239792,1)
337	31	(26.98076211353316,1)
338	31	(26.98076211353316,1)
339	274	(29.578838324886476,5.5)
340	274	(29.578838324886476,5.5)
341	554	(30.011851026778693,10.75)
342	151	(27.413774815425377,3.25)
343	113	(28.712812921102035,2.5)
344	112	(27.846787517317598,2.5)
345	1036	(31.743901834347572,19.75)
346	1036	(31.743901834347572,19.75)
347	632	(28.279800219209818,12.25)
348	673	(28.712812921102035,13)
349	632	(28.279800219209818,12.25)
350	632	(28.279800219209818,12.25)
351	632	(28.279800219209818,12.25)
352	1237	(32.176914536239792,23.5)
353	1237	(32.176914536239792,23.5)
354	1237	(32.176914536239792,23.5)
355	1237	(32.176914536239792,23.5)
356	1197	(32.609927238132009,22.75)
357	1197	(32.609927238132009,22.75)
358	1439	(34.341978045700891,27.25)
359	757	(32.176914536239792,14.5)
360	757	(32.176914536239792,14.5)
361	719	(34.341978045700891,13.75)
362	719	(34.341978045700891,13.75)
363	719	(34.341978045700891,13.75)
364	195	(30.444863728670914,4)
365	2157	(32.609927238132009,40.75)
366	2156	(31.743901834347572,40.75)
367	1917	(32.609927238132009,36.25)
368	1955	(30.444863728670914,37)
369	1877	(32.176914536239792,35.5)
370	1877	(32.176914536239792,35.5)
371	1917	(32.609927238132009,36.25)
372	1952	(27.846787517317598,37)
373	1610	(8.794228634059948,31)
374	1647	(6.6291651245988508,31.75)
375	2067	(23.949673200287624,39.25)
376	1993	(29.145825622994256,37.75)
377	1524	(3.598076211353316,29.5)
378	1687	(6.196152422706632,32.5)
379	511	(26.98076211353316,10)
380	673	(28.712812921102035,13)
381	151	(27.413774815425377,3.25)
382	113	(28.712812921102035,2.5)
383	1119	(34.341978045700891,21.25)
384	1119	(34.341978045700891,21.25)
385	1398	(33.042939940024233,26.5)
386	1440	(35.208003449485325,27.25)
387	794	(30.011851026778693,15.25)
388	794	(30.011851026778693,15.25)
389	794	(30.011851026778693,15.25)
390	792	(28.279800219209818,15.25)
391	792	(28.279800219209818,15.25)
392	1119	(34.341978045700891,21.25)
393	1119	(34.341978045700891,21.25)
394	1398	(33.042939940024233,26.5)
395	878	(33.47595264191645,16.75)
396	1480	(34.774990747593108,28)
397	992	(27.846787517317598,19)
398	990	(26.114736709748719,19)
399	987	(23.516660498395403,19)
400	1392	(27.846787517317598,26.5)
401	1471	(26.98076211353316,28)
402	1467	(23.516660498395403,28)
403	1467	(23.516660498395403,28)
404	1424	(21.351596988934308,27.25)
405	1462	(19.186533479473212,28)
406	1502	(19.619546181365433,28.75)
407	1542	(19.186533479473212,29.5)
408	1542	(19.186533479473212,29.5)
409	223	(20.48557158514987,4.75)
410	223	(20.48557158514987,4.75)
411	223	(20.48557158514987,4.75)
412	300	(17.887495373796554,6.25)
413	339	(16.588457268119896,7)
414	339	(16.588457268119896,7)
415	2187	(23.516660498395403,41.5)
416	2146	(23.083647796503186,40.75)
417	130	(9.2272413359521668,3.25)
418	170	(8.794228634059948,4)
419	2081	(1,40)
420	2081	(1,40)
421	1822	(19.619546181365433,34.75)
422	2098	(15.722431864335457,40)
423	2016	(13.99038105676658,38.5)
424	2016	(13.99038105676658,38.5)
425	2016	(13.99038105676658,38.5)
426	2176	(13.99038105676658,41.5)
427	2394	(30.011851026778693,45.25)
428	2394	(30.011851026778693,45.25)
429	2394	(30.011851026778693,45.25)
430	2392	(28.279800219209818,45.25)
431	2352	(27.846787517317598,44.5)
432	2352	(27.846787517317598,44.5)
433	2392	(28.279800219209818,45.25)
434	257	(14.856406460551018,5.5)
435	336	(13.99038105676658,7)
436	295	(13.55736835487436,6.25)
437	294	(12.691342951089922,6.25)
438	254	(12.258330249197702,5.5)
439	214	(12.691342951089922,4.75)
440	782	(19.619546181365433,15.25)
441	823	(20.05255888325765,16)
442	737	(14.856406460551018,14.5)
443	821	(18.320508075688775,16)
444	819	(16.588457268119896,16)
445	819	(16.588457268119896,16)
446	738	(15.722431864335457,14.5)
447	2233	(29.145825622994256,42.25)
448	2154	(30.011851026778693,40.75)
449	2312	(28.279800219209818,43.75)
450	1955	(30.444863728670914,37)
451	2111	(26.98076211353316,40)
452	2196	(31.310889132455351,41.5)
453	719	(34.341978045700891,13.75)
454	1960	(34.774990747593108,37)
455	2280	(34.774990747593108,43)
456	1902	(19.619546181365433,36.25)
457	2396	(31.743901834347572,45.25)
458	2359	(33.908965343808667,44.5)
459	2279	(33.908965343808667,43)
460	2396	(31.743901834347572,45.25)
461	367	(6.6291651245988508,7.75)
462	327	(6.196152422706632,7)
463	326	(5.3301270189221936,7)
464	326	(5.3301270189221936,7)
465	326	(5.3301270189221936,7)
466	326	(5.3301270189221936,7)
467	1	(1,1)
468	1	(1,1)
469	1	(1,1)
470	2051	(10.093266739736606,39.25)
471	2050	(9.2272413359521668,39.25)
472	2050	(9.2272413359521668,39.25)
473	2050	(9.2272413359521668,39.25)
474	1333	(11.825317547305483,25.75)
475	441	(1.4330127018922194,9.25)
476	603	(3.1650635094610968,12.25)
477	522	(2.299038105676658,10.75)
478	601	(1.4330127018922194,12.25)
479	1046	(5.3301270189221936,20.5)
480	1370	(8.794228634059948,26.5)
481	1046	(5.3301270189221936,20.5)
482	964	(3.598076211353316,19)
483	964	(3.598076211353316,19)
484	401	(1,8.5)
485	603	(3.1650635094610968,12.25)
486	446	(5.7631397208144124,9.25)
487	603	(3.1650635094610968,12.25)
488	1164	(4.0310889132455356,22.75)
489	1203	(2.7320508075688772,23.5)
490	1162	(2.299038105676658,22.75)
491	964	(3.598076211353316,19)
492	1333	(11.825317547305483,25.75)
493	1121	(1,22)
494	402	(1.8660254037844386,8.5)
495	1121	(1,22)
496	841	(1.4330127018922194,16.75)
497	1706	(22.650635094610966,32.5)
498	1412	(10.959292143521045,27.25)
499	1411	(10.093266739736606,27.25)
500	601	(1.4330127018922194,12.25)
501	1253	(11.825317547305483,24.25)
502	1708	(24.382685902179844,32.5)
503	1708	(24.382685902179844,32.5)
504	1708	(24.382685902179844,32.5)
505	1708	(24.382685902179844,32.5)
506	1708	(24.382685902179844,32.5)
507	855	(13.55736835487436,16.75)
508	987	(23.516660498395403,19)
509	1054	(12.258330249197702,20.5)
510	938	(16.155444566227676,18.25)
511	934	(12.691342951089922,18.25)
512	2289	(8.3612159321677293,43.75)
513	1790	(26.114736709748719,34)
514	1905	(22.217622392718749,36.25)
515	2289	(8.3612159321677293,43.75)
516	2371	(10.093266739736606,45.25)
517	1786	(22.650635094610966,34)
518	1786	(22.650635094610966,34)
519	2374	(12.691342951089922,45.25)
520	2374	(12.691342951089922,45.25)
521	2374	(12.691342951089922,45.25)
522	2373	(11.825317547305483,45.25)
523	1954	(29.578838324886476,37)
524	1610	(8.794228634059948,31)
525	1647	(6.6291651245988508,31.75)
526	2111	(26.98076211353316,40)
527	1608	(7.0621778264910704,31)
528	2034	(29.578838324886476,38.5)
529	2111	(26.98076211353316,40)
530	2069	(25.681724007856502,39.25)
531	2034	(29.578838324886476,38.5)
532	1786	(22.650635094610966,34)
533	2374	(12.691342951089922,45.25)
534	2111	(26.98076211353316,40)
535	2071	(27.413774815425377,39.25)
536	1525	(4.4641016151377544,29.5)
537	1525	(4.4641016151377544,29.5)
538	2194	(29.578838324886476,41.5)
539	2197	(32.176914536239792,41.5)
540	1350	(26.54774941164094,25.75)
541	1306	(22.650635094610966,25)
542	1547	(23.516660498395403,29.5)
543	1471	(26.98076211353316,28)
544	1424	(21.351596988934308,27.25)
545	1424	(21.351596988934308,27.25)
546	2374	(12.691342951089922,45.25)
547	1622	(19.186533479473212,31)
548	2374	(12.691342951089922,45.25)
549	1664	(21.351596988934308,31.75)
550	1298	(15.722431864335457,25)
551	1843	(2.7320508075688772,35.5)
552	1219	(16.588457268119896,23.5)
553	1298	(15.722431864335457,25)
554	1298	(15.722431864335457,25)
555	1256	(14.423393758658799,24.25)
556	1379	(16.588457268119896,26.5)
557	2375	(13.55736835487436,45.25)
558	911	(26.98076211353316,17.5)
559	911	(26.98076211353316,17.5)
560	1192	(28.279800219209818,22.75)
561	1140	(17.454482671904334,22)
562	1187	(23.949673200287624,22.75)
563	1024	(21.351596988934308,19.75)
564	1024	(21.351596988934308,19.75)
565	424	(20.918584287042091,8.5)
566	424	(20.918584287042091,8.5)
567	1843	(2.7320508075688772,35.5)
568	831	(26.98076211353316,16)
569	1234	(29.578838324886476,23.5)
570	33	(28.712812921102035,1)
571	33	(28.712812921102035,1)
572	33	(28.712812921102035,1)
573	70	(26.54774941164094,1.75)
574	30	(26.114736709748719,1)
575	151	(27.413774815425377,3.25)
576	1715	(30.444863728670914,32.5)
577	1718	(33.042939940024233,32.5)
578	1476	(31.310889132455351,28)
579	1753	(29.145825622994256,33.25)
580	80	(35.208003449485325,1.75)
581	80	(35.208003449485325,1.75)
582	80	(35.208003449485325,1.75)
583	79	(34.341978045700891,1.75)
584	1715	(30.444863728670914,32.5)
585	1718	(33.042939940024233,32.5)
586	2262	(19.186533479473212,43)
587	2325	(4.4641016151377544,44.5)
588	2347	(23.516660498395403,44.5)
589	2301	(18.753520777580992,43.75)
590	2342	(19.186533479473212,44.5)
591	2362	(2.299038105676658,45.25)
592	2342	(19.186533479473212,44.5)
593	2364	(4.0310889132455356,45.25)
594	2347	(23.516660498395403,44.5)
595	2323	(2.7320508075688772,44.5)
596	2362	(2.299038105676658,45.25)
597	2361	(1.4330127018922194,45.25)
598	2321	(1,44.5)
599	1821	(18.753520777580992,34.75)
600	1822	(19.619546181365433,34.75)
601	1860	(17.454482671904334,35.5)
602	1822	(19.619546181365433,34.75)
603	1772	(10.526279441628825,34)
604	1772	(10.526279441628825,34)
605	1772	(10.526279441628825,34)
606	1769	(7.9282032302755088,34)
607	1780	(17.454482671904334,34)
608	1772	(10.526279441628825,34)
609	1977	(15.289419162443238,37.75)
610	1977	(15.289419162443238,37.75)
611	2060	(17.887495373796554,39.25)
612	1768	(7.0621778264910704,34)
613	1977	(15.289419162443238,37.75)
614	2011	(9.6602540378443873,38.5)
615	2060	(17.887495373796554,39.25)
616	1768	(7.0621778264910704,34)
617	2091	(9.6602540378443873,40)
618	2206	(5.7631397208144124,42.25)
619	2215	(13.55736835487436,42.25)
620	2085	(4.4641016151377544,40)
621	1977	(15.289419162443238,37.75)
622	1770	(8.794228634059948,34)
623	2255	(13.124355652982141,43)
624	2255	(13.124355652982141,43)
625	1884	(4.0310889132455356,36.25)
626	1925	(4.4641016151377544,37)
627	1973	(11.825317547305483,37.75)
628	1973	(11.825317547305483,37.75)
629	2127	(6.6291651245988508,40.75)
630	1961	(1.4330127018922194,37.75)
631	1961	(1.4330127018922194,37.75)
632	819	(16.588457268119896,16)
633	823	(20.05255888325765,16)
634	334	(12.258330249197702,7)
635	818	(15.722431864335457,16)
636	821	(18.320508075688775,16)
637	334	(12.258330249197702,7)
638	782	(19.619546181365433,15.25)
639	821	(18.320508075688775,16)
640	256	(13.99038105676658,5.5)
641	1508	(24.815698604072061,28.75)
642	101	(18.320508075688775,2.5)
643	10	(8.794228634059948,1)
644	101	(18.320508075688775,2.5)
645	58	(16.155444566227676,1.75)
646	140	(17.887495373796554,3.25)
647	17	(14.856406460551018,1)
648	10	(8.794228634059948,1)
649	11	(9.6602540378443873,1)
650	748	(24.382685902179844,14.5)
651	787	(23.949673200287624,15.25)
652	748	(24.382685902179844,14.5)
653	2187	(23.516660498395403,41.5)
654	2187	(23.516660498395403,41.5)
655	17	(14.856406460551018,1)
656	950	(26.54774941164094,18.25)
657	950	(26.54774941164094,18.25)
658	58	(16.155444566227676,1.75)
659	7	(6.196152422706632,1)
660	7	(6.196152422706632,1)
661	7	(6.196152422706632,1)
662	45	(4.897114317029974,1.75)
663	45	(4.897114317029974,1.75)
664	283	(3.1650635094610968,6.25)
665	281	(1.4330127018922194,6.25)
666	201	(1.4330127018922194,4.75)
667	1920	(35.208003449485325,36.25)
668	1804	(4.0310889132455356,34.75)
669	1804	(4.0310889132455356,34.75)
670	1537	(14.856406460551018,29.5)
671	949	(25.681724007856502,18.25)
672	1617	(14.856406460551018,31)
673	91	(9.6602540378443873,2.5)
674	807	(6.196152422706632,16)
675	1483	(3.1650635094610968,28.75)
676	964	(3.598076211353316,19)
677	970	(8.794228634059948,19)
678	1249	(8.3612159321677293,24.25)
679	1508	(24.815698604072061,28.75)
680	424	(20.918584287042091,8.5)
681	831	(26.98076211353316,16)
682	1464	(20.918584287042091,28)
683	1470	(26.114736709748719,28)
684	681	(1.4330127018922194,13.75)
685	928	(7.49519052838329,18.25)
686	1046	(5.3301270189221936,20.5)
687	1205	(4.4641016151377544,23.5)
688	1046	(5.3301270189221936,20.5)
689	964	(3.598076211353316,19)
690	1508	(24.815698604072061,28.75)
691	1137	(14.856406460551018,22)
692	928	(7.49519052838329,18.25)
693	928	(7.49519052838329,18.25)
694	1046	(5.3301270189221936,20.5)
695	964	(3.598076211353316,19)
696	2400	(35.208003449485325,45.25)
697	2200	(34.774990747593108,41.5)
698	2356	(31.310889132455351,44.5)
699	2200	(34.774990747593108,41.5)
700	2399	(34.341978045700891,45.25)
701	964	(3.598076211353316,19)
702	423	(20.05255888325765,8.5)
703	2104	(20.918584287042091,40)
704	2104	(20.918584287042091,40)
705	2104	(20.918584287042091,40)
706	2104	(20.918584287042091,40)
707	2104	(20.918584287042091,40)
708	453	(11.825317547305483,9.25)
709	1160	(34.774990747593108,22)
710	1160	(34.774990747593108,22)
711	1360	(35.208003449485325,25.75)
712	1360	(35.208003449485325,25.75)
713	2317	(32.609927238132009,43.75)
714	2269	(25.248711305964282,43)
715	2358	(33.042939940024233,44.5)
716	1356	(31.743901834347572,25.75)
717	971	(9.6602540378443873,19)
718	445	(4.897114317029974,9.25)
719	2104	(20.918584287042091,40)
720	80	(35.208003449485325,1.75)
721	240	(35.208003449485325,4.75)
722	553	(29.145825622994256,10.75)
723	33	(28.712812921102035,1)
724	33	(28.712812921102035,1)
725	33	(28.712812921102035,1)
726	31	(26.98076211353316,1)
727	35	(30.444863728670914,1)
728	30	(26.114736709748719,1)
729	391	(27.413774815425377,7.75)
730	391	(27.413774815425377,7.75)
731	391	(27.413774815425377,7.75)
732	391	(27.413774815425377,7.75)
733	390	(26.54774941164094,7.75)
734	395	(30.877876430563134,7.75)
735	391	(27.413774815425377,7.75)
736	391	(27.413774815425377,7.75)
737	395	(30.877876430563134,7.75)
738	391	(27.413774815425377,7.75)
739	391	(27.413774815425377,7.75)
740	391	(27.413774815425377,7.75)
741	391	(27.413774815425377,7.75)
742	391	(27.413774815425377,7.75)
743	396	(31.743901834347572,7.75)
744	391	(27.413774815425377,7.75)
745	395	(30.877876430563134,7.75)
746	28	(24.382685902179844,1)
747	28	(24.382685902179844,1)
748	28	(24.382685902179844,1)
749	28	(24.382685902179844,1)
750	31	(26.98076211353316,1)
751	31	(26.98076211353316,1)
752	1424	(21.351596988934308,27.25)
753	1424	(21.351596988934308,27.25)
754	879	(34.341978045700891,16.75)
755	879	(34.341978045700891,16.75)
756	840	(34.774990747593108,16)
757	840	(34.774990747593108,16)
758	840	(34.774990747593108,16)
759	777	(15.289419162443238,15.25)
760	819	(16.588457268119896,16)
761	899	(16.588457268119896,17.5)
762	737	(14.856406460551018,14.5)
763	253	(11.392304845413264,5.5)
764	152	(28.279800219209818,3.25)
765	190	(26.114736709748719,4)
766	155	(30.877876430563134,3.25)
767	878	(33.47595264191645,16.75)
768	676	(31.310889132455351,13)
769	395	(30.877876430563134,7.75)
770	2091	(9.6602540378443873,40)
771	2206	(5.7631397208144124,42.25)
772	1814	(12.691342951089922,34.75)
773	151	(27.413774815425377,3.25)
774	189	(25.248711305964282,4)
775	839	(33.908965343808667,16)
776	152	(28.279800219209818,3.25)
777	151	(27.413774815425377,3.25)
778	151	(27.413774815425377,3.25)
779	150	(26.54774941164094,3.25)
780	839	(33.908965343808667,16)
781	113	(28.712812921102035,2.5)
782	114	(29.578838324886476,2.5)
783	73	(29.145825622994256,1.75)
784	73	(29.145825622994256,1.75)
785	113	(28.712812921102035,2.5)
786	113	(28.712812921102035,2.5)
787	840	(34.774990747593108,16)
788	30	(26.114736709748719,1)
789	74	(30.011851026778693,1.75)
790	111	(26.98076211353316,2.5)
791	115	(30.444863728670914,2.5)
792	840	(34.774990747593108,16)
793	30	(26.114736709748719,1)
794	230	(26.54774941164094,4.75)
795	111	(26.98076211353316,2.5)
796	231	(27.413774815425377,4.75)
797	1398	(33.042939940024233,26.5)
798	964	(3.598076211353316,19)
799	1121	(1,22)
800	1476	(31.310889132455351,28)
801	1753	(29.145825622994256,33.25)
802	423	(20.05255888325765,8.5)
803	424	(20.918584287042091,8.5)
804	424	(20.918584287042091,8.5)
805	461	(18.753520777580992,9.25)
806	792	(28.279800219209818,15.25)
807	2321	(1,44.5)
808	2321	(1,44.5)
809	2321	(1,44.5)
810	391	(27.413774815425377,7.75)
811	391	(27.413774815425377,7.75)
812	391	(27.413774815425377,7.75)
813	391	(27.413774815425377,7.75)
814	2016	(13.99038105676658,38.5)
815	2178	(15.722431864335457,41.5)
816	2016	(13.99038105676658,38.5)
817	2178	(15.722431864335457,41.5)
818	2178	(15.722431864335457,41.5)
819	1342	(19.619546181365433,25.75)
820	1392	(27.846787517317598,26.5)
821	1392	(27.846787517317598,26.5)
822	1350	(26.54774941164094,25.75)
823	2218	(16.155444566227676,42.25)
824	2257	(14.856406460551018,43)
825	1070	(26.114736709748719,20.5)
826	1027	(23.949673200287624,19.75)
827	1033	(29.145825622994256,19.75)
828	1394	(29.578838324886476,26.5)
829	1229	(25.248711305964282,23.5)
830	189	(25.248711305964282,4)
831	150	(26.54774941164094,3.25)
832	34	(29.578838324886476,1)
833	74	(30.011851026778693,1.75)
834	151	(27.413774815425377,3.25)
835	151	(27.413774815425377,3.25)
836	30	(26.114736709748719,1)
837	30	(26.114736709748719,1)
838	880	(35.208003449485325,16.75)
839	880	(35.208003449485325,16.75)
840	880	(35.208003449485325,16.75)
841	1398	(33.042939940024233,26.5)
842	1439	(34.341978045700891,27.25)
843	1955	(30.444863728670914,37)
844	1615	(13.124355652982141,31)
845	1495	(13.55736835487436,28.75)
846	574	(12.258330249197702,11.5)
847	1911	(27.413774815425377,36.25)
848	1084	(4.0310889132455356,21.25)
849	1084	(4.0310889132455356,21.25)
850	1529	(7.9282032302755088,29.5)
851	856	(14.423393758658799,16.75)
852	813	(11.392304845413264,16)
853	1604	(3.598076211353316,31)
854	964	(3.598076211353316,19)
855	964	(3.598076211353316,19)
856	1954	(29.578838324886476,37)
857	1610	(8.794228634059948,31)
858	1647	(6.6291651245988508,31.75)
859	445	(4.897114317029974,9.25)
860	524	(4.0310889132455356,10.75)
861	1751	(27.413774815425377,33.25)
862	2111	(26.98076211353316,40)
863	1608	(7.0621778264910704,31)
864	1011	(10.093266739736606,19.75)
865	971	(9.6602540378443873,19)
866	1414	(12.691342951089922,27.25)
867	1534	(12.258330249197702,29.5)
868	1645	(4.897114317029974,31.75)
869	2376	(14.423393758658799,45.25)
870	2348	(24.382685902179844,44.5)
871	2394	(30.011851026778693,45.25)
872	2392	(28.279800219209818,45.25)
873	2392	(28.279800219209818,45.25)
874	2302	(19.619546181365433,43.75)
875	2200	(34.774990747593108,41.5)
876	1872	(27.846787517317598,35.5)
877	1907	(23.949673200287624,36.25)
878	2159	(34.341978045700891,40.75)
879	1709	(25.248711305964282,32.5)
880	1709	(25.248711305964282,32.5)
881	190	(26.114736709748719,4)
882	151	(27.413774815425377,3.25)
883	73	(29.145825622994256,1.75)
884	2034	(29.578838324886476,38.5)
885	1984	(21.351596988934308,37.75)
886	1761	(1,34)
887	412	(10.526279441628825,8.5)
888	845	(4.897114317029974,16.75)
889	1724	(4.0310889132455356,33.25)
890	1907	(23.949673200287624,36.25)
891	1715	(30.444863728670914,32.5)
892	1718	(33.042939940024233,32.5)
893	2040	(34.774990747593108,38.5)
894	2311	(27.413774815425377,43.75)
895	2038	(33.042939940024233,38.5)
896	839	(33.908965343808667,16)
897	839	(33.908965343808667,16)
898	840	(34.774990747593108,16)
899	840	(34.774990747593108,16)
900	1398	(33.042939940024233,26.5)
901	1984	(21.351596988934308,37.75)
902	2159	(34.341978045700891,40.75)
903	2068	(24.815698604072061,39.25)
904	840	(34.774990747593108,16)
905	1947	(23.516660498395403,37)
906	190	(26.114736709748719,4)
907	151	(27.413774815425377,3.25)
908	33	(28.712812921102035,1)
909	33	(28.712812921102035,1)
910	33	(28.712812921102035,1)
911	30	(26.114736709748719,1)
912	30	(26.114736709748719,1)
913	238	(33.47595264191645,4.75)
914	80	(35.208003449485325,1.75)
915	80	(35.208003449485325,1.75)
916	80	(35.208003449485325,1.75)
917	80	(35.208003449485325,1.75)
918	79	(34.341978045700891,1.75)
919	424	(20.918584287042091,8.5)
920	424	(20.918584287042091,8.5)
921	424	(20.918584287042091,8.5)
922	424	(20.918584287042091,8.5)
923	423	(20.05255888325765,8.5)
924	1424	(21.351596988934308,27.25)
925	1424	(21.351596988934308,27.25)
926	1622	(19.186533479473212,31)
927	1464	(20.918584287042091,28)
928	1464	(20.918584287042091,28)
929	1350	(26.54774941164094,25.75)
930	1547	(23.516660498395403,29.5)
931	1470	(26.114736709748719,28)
932	1464	(20.918584287042091,28)
933	1464	(20.918584287042091,28)
934	1424	(21.351596988934308,27.25)
935	1424	(21.351596988934308,27.25)
936	1240	(34.774990747593108,23.5)
937	1240	(34.774990747593108,23.5)
938	1399	(33.908965343808667,26.5)
939	1440	(35.208003449485325,27.25)
940	1600	(35.208003449485325,30.25)
941	95	(13.124355652982141,2.5)
942	133	(11.825317547305483,3.25)
943	173	(11.392304845413264,4)
944	418	(15.722431864335457,8.5)
945	418	(15.722431864335457,8.5)
946	457	(15.289419162443238,9.25)
947	457	(15.289419162443238,9.25)
948	457	(15.289419162443238,9.25)
949	457	(15.289419162443238,9.25)
950	659	(16.588457268119896,13)
951	659	(16.588457268119896,13)
952	618	(16.155444566227676,12.25)
953	657	(14.856406460551018,13)
954	657	(14.856406460551018,13)
955	657	(14.856406460551018,13)
956	657	(14.856406460551018,13)
957	659	(16.588457268119896,13)
958	908	(24.382685902179844,17.5)
959	908	(24.382685902179844,17.5)
960	947	(23.949673200287624,18.25)
961	1240	(34.774990747593108,23.5)
962	1240	(34.774990747593108,23.5)
963	1240	(34.774990747593108,23.5)
964	1596	(31.743901834347572,30.25)
965	1597	(32.609927238132009,30.25)
966	1600	(35.208003449485325,30.25)
967	1108	(24.815698604072061,21.25)
968	1135	(13.124355652982141,22)
969	2197	(32.176914536239792,41.5)
970	2156	(31.743901834347572,40.75)
971	2154	(30.011851026778693,40.75)
972	2157	(32.609927238132009,40.75)
973	2157	(32.609927238132009,40.75)
974	1135	(13.124355652982141,22)
975	2233	(29.145825622994256,42.25)
976	1455	(13.124355652982141,28)
977	1296	(13.99038105676658,25)
978	934	(12.691342951089922,18.25)
979	1708	(24.382685902179844,32.5)
980	1256	(14.423393758658799,24.25)
981	2170	(8.794228634059948,41.5)
982	2090	(8.794228634059948,40)
983	2091	(9.6602540378443873,40)
984	2206	(5.7631397208144124,42.25)
985	1464	(20.918584287042091,28)
986	2374	(12.691342951089922,45.25)
987	2373	(11.825317547305483,45.25)
988	2334	(12.258330249197702,44.5)
989	2070	(26.54774941164094,39.25)
990	2070	(26.54774941164094,39.25)
991	1608	(7.0621778264910704,31)
992	1608	(7.0621778264910704,31)
993	2373	(11.825317547305483,45.25)
994	1645	(4.897114317029974,31.75)
995	1565	(4.897114317029974,30.25)
996	2068	(24.815698604072061,39.25)
997	2279	(33.908965343808667,43)
998	1801	(1.4330127018922194,34.75)
999	1565	(4.897114317029974,30.25)
1000	1565	(4.897114317029974,30.25)
1001	1645	(4.897114317029974,31.75)
1002	1645	(4.897114317029974,31.75)
1003	1483	(3.1650635094610968,28.75)
1004	1879	(33.908965343808667,35.5)
1005	1683	(2.7320508075688772,32.5)
1006	2274	(29.578838324886476,43)
1007	1955	(30.444863728670914,37)
1008	1987	(23.949673200287624,37.75)
1009	2123	(3.1650635094610968,40.75)
1010	1989	(25.681724007856502,37.75)
1011	2392	(28.279800219209818,45.25)
1012	2392	(28.279800219209818,45.25)
1013	190	(26.114736709748719,4)
1014	151	(27.413774815425377,3.25)
1015	33	(28.712812921102035,1)
1016	2000	(35.208003449485325,37.75)
1017	2359	(33.908965343808667,44.5)
1018	2279	(33.908965343808667,43)
1019	2370	(9.2272413359521668,45.25)
1020	2370	(9.2272413359521668,45.25)
1021	2370	(9.2272413359521668,45.25)
1022	2369	(8.3612159321677293,45.25)
1023	1620	(17.454482671904334,31)
1024	1786	(22.650635094610966,34)
1025	104	(20.918584287042091,2.5)
1026	31	(26.98076211353316,1)
1027	105	(21.784609690826528,2.5)
1028	31	(26.98076211353316,1)
1029	1680	(35.208003449485325,31.75)
1030	1181	(18.753520777580992,22.75)
1031	875	(30.877876430563134,16.75)
1032	831	(26.98076211353316,16)
1033	831	(26.98076211353316,16)
1034	870	(26.54774941164094,16.75)
1035	200	(34.774990747593108,4)
1036	200	(34.774990747593108,4)
1037	238	(33.47595264191645,4.75)
1038	920	(34.774990747593108,17.5)
1039	920	(34.774990747593108,17.5)
1040	920	(34.774990747593108,17.5)
1041	1464	(20.918584287042091,28)
1042	1464	(20.918584287042091,28)
1043	1464	(20.918584287042091,28)
1044	30	(26.114736709748719,1)
1045	30	(26.114736709748719,1)
1046	28	(24.382685902179844,1)
1047	28	(24.382685902179844,1)
1048	313	(29.145825622994256,6.25)
1049	312	(28.279800219209818,6.25)
1050	1759	(34.341978045700891,33.25)
1051	30	(26.114736709748719,1)
1052	1759	(34.341978045700891,33.25)
1053	443	(3.1650635094610968,9.25)
1054	1046	(5.3301270189221936,20.5)
1055	601	(1.4330127018922194,12.25)
1056	443	(3.1650635094610968,9.25)
1057	1249	(8.3612159321677293,24.25)
1058	1249	(8.3612159321677293,24.25)
1059	401	(1,8.5)
1060	524	(4.0310889132455356,10.75)
1061	524	(4.0310889132455356,10.75)
1062	2156	(31.743901834347572,40.75)
1063	2156	(31.743901834347572,40.75)
1064	2156	(31.743901834347572,40.75)
1065	2156	(31.743901834347572,40.75)
1066	2040	(34.774990747593108,38.5)
1067	2156	(31.743901834347572,40.75)
1068	2263	(20.05255888325765,43)
1069	2263	(20.05255888325765,43)
1070	2071	(27.413774815425377,39.25)
1071	1483	(3.1650635094610968,28.75)
1072	1483	(3.1650635094610968,28.75)
1073	1761	(1,34)
1074	1525	(4.4641016151377544,29.5)
1075	1525	(4.4641016151377544,29.5)
1076	1761	(1,34)
1077	807	(6.196152422706632,16)
1078	1521	(1,29.5)
1079	1683	(2.7320508075688772,32.5)
1080	1822	(19.619546181365433,34.75)
1081	1772	(10.526279441628825,34)
1082	1772	(10.526279441628825,34)
1083	1772	(10.526279441628825,34)
1084	1772	(10.526279441628825,34)
1085	1769	(7.9282032302755088,34)
1086	1852	(10.526279441628825,35.5)
1087	1852	(10.526279441628825,35.5)
1088	2397	(32.609927238132009,45.25)
1089	2200	(34.774990747593108,41.5)
1090	2200	(34.774990747593108,41.5)
1091	2200	(34.774990747593108,41.5)
1092	1917	(32.609927238132009,36.25)
1093	2190	(26.114736709748719,41.5)
1094	1333	(11.825317547305483,25.75)
1095	1609	(7.9282032302755088,31)
1096	1416	(14.423393758658799,27.25)
1097	1413	(11.825317547305483,27.25)
1098	2310	(26.54774941164094,43.75)
1099	2398	(33.47595264191645,45.25)
1100	2310	(26.54774941164094,43.75)
1101	1411	(10.093266739736606,27.25)
1102	1411	(10.093266739736606,27.25)
1103	964	(3.598076211353316,19)
1104	964	(3.598076211353316,19)
1105	964	(3.598076211353316,19)
1106	601	(1.4330127018922194,12.25)
1107	2237	(32.609927238132009,42.25)
1108	2353	(28.712812921102035,44.5)
1109	601	(1.4330127018922194,12.25)
1110	482	(1.8660254037844386,10)
1111	521	(1.4330127018922194,10.75)
1112	1916	(31.743901834347572,36.25)
1113	1877	(32.176914536239792,35.5)
1114	574	(12.258330249197702,11.5)
1115	1877	(32.176914536239792,35.5)
1116	246	(5.3301270189221936,5.5)
1117	246	(5.3301270189221936,5.5)
1118	246	(5.3301270189221936,5.5)
1119	223	(20.48557158514987,4.75)
1120	223	(20.48557158514987,4.75)
1121	300	(17.887495373796554,6.25)
1122	300	(17.887495373796554,6.25)
1123	1	(1,1)
1124	299	(17.021469970012117,6.25)
1125	1463	(20.05255888325765,28)
1126	1463	(20.05255888325765,28)
1127	1463	(20.05255888325765,28)
1128	331	(9.6602540378443873,7)
1129	2184	(20.918584287042091,41.5)
1130	171	(9.6602540378443873,4)
1131	2228	(24.815698604072061,42.25)
1132	2228	(24.815698604072061,42.25)
1133	2228	(24.815698604072061,42.25)
1134	2186	(22.650635094610966,41.5)
1135	2229	(25.681724007856502,42.25)
1136	2186	(22.650635094610966,41.5)
1137	1867	(23.516660498395403,35.5)
1138	11	(9.6602540378443873,1)
1139	178	(15.722431864335457,4)
1140	10	(8.794228634059948,1)
1141	11	(9.6602540378443873,1)
1142	17	(14.856406460551018,1)
1143	971	(9.6602540378443873,19)
1144	1920	(35.208003449485325,36.25)
1145	878	(33.47595264191645,16.75)
1146	879	(34.341978045700891,16.75)
1147	879	(34.341978045700891,16.75)
1148	840	(34.774990747593108,16)
1149	597	(32.176914536239792,11.5)
1150	514	(29.578838324886476,10)
1151	1483	(3.1650635094610968,28.75)
1152	2320	(35.208003449485325,43.75)
1153	1608	(7.0621778264910704,31)
1154	2065	(22.217622392718749,39.25)
1155	632	(28.279800219209818,12.25)
1156	632	(28.279800219209818,12.25)
1157	516	(31.310889132455351,10)
1158	632	(28.279800219209818,12.25)
1159	154	(30.011851026778693,3.25)
1160	33	(28.712812921102035,1)
1161	33	(28.712812921102035,1)
1162	632	(28.279800219209818,12.25)
1163	672	(27.846787517317598,13)
1164	672	(27.846787517317598,13)
1165	676	(31.310889132455351,13)
1166	672	(27.846787517317598,13)
1167	270	(26.114736709748719,5.5)
1168	191	(26.98076211353316,4)
1169	672	(27.846787517317598,13)
1170	632	(28.279800219209818,12.25)
1171	31	(26.98076211353316,1)
1172	997	(32.176914536239792,19)
1173	669	(25.248711305964282,13)
1174	999	(33.908965343808667,19)
1175	1158	(33.042939940024233,22)
1176	1714	(29.578838324886476,32.5)
1177	315	(30.877876430563134,6.25)
1178	596	(31.310889132455351,11.5)
1179	44	(4.0310889132455356,1.75)
1180	161	(1,4)
1181	1877	(32.176914536239792,35.5)
1182	1879	(33.908965343808667,35.5)
1183	1957	(32.176914536239792,37)
1184	2178	(15.722431864335457,41.5)
1185	2047	(6.6291651245988508,39.25)
1186	1821	(18.753520777580992,34.75)
1187	2170	(8.794228634059948,41.5)
1188	2090	(8.794228634059948,40)
1189	2170	(8.794228634059948,41.5)
1190	2081	(1,40)
1191	2123	(3.1650635094610968,40.75)
1192	1768	(7.0621778264910704,34)
1193	2302	(19.619546181365433,43.75)
1194	2284	(4.0310889132455356,43.75)
1195	2323	(2.7320508075688772,44.5)
1196	2363	(3.1650635094610968,45.25)
1197	2322	(1.8660254037844386,44.5)
1198	2380	(17.887495373796554,45.25)
1199	2181	(18.320508075688775,41.5)
1200	2385	(22.217622392718749,45.25)
1201	2342	(19.186533479473212,44.5)
1202	2326	(5.3301270189221936,44.5)
1203	2279	(33.908965343808667,43)
1204	1333	(11.825317547305483,25.75)
1205	1574	(12.691342951089922,30.25)
1206	1533	(11.392304845413264,29.5)
1207	1493	(11.825317547305483,28.75)
1208	568	(7.0621778264910704,11.5)
1209	485	(4.4641016151377544,10)
1210	485	(4.4641016151377544,10)
1211	441	(1.4330127018922194,9.25)
1212	681	(1.4330127018922194,13.75)
1213	603	(3.1650635094610968,12.25)
1214	603	(3.1650635094610968,12.25)
1215	644	(3.598076211353316,13)
1216	601	(1.4330127018922194,12.25)
1217	601	(1.4330127018922194,12.25)
1218	1249	(8.3612159321677293,24.25)
1219	882	(1.8660254037844386,17.5)
1220	1287	(6.196152422706632,25)
1221	1287	(6.196152422706632,25)
1222	1287	(6.196152422706632,25)
1223	921	(1.4330127018922194,18.25)
1224	1203	(2.7320508075688772,23.5)
1225	1203	(2.7320508075688772,23.5)
1226	1203	(2.7320508075688772,23.5)
1227	841	(1.4330127018922194,16.75)
1228	921	(1.4330127018922194,18.25)
1229	2156	(31.743901834347572,40.75)
1230	2034	(29.578838324886476,38.5)
1231	2034	(29.578838324886476,38.5)
1232	1610	(8.794228634059948,31)
1233	1608	(7.0621778264910704,31)
1234	1608	(7.0621778264910704,31)
1235	2111	(26.98076211353316,40)
1236	2111	(26.98076211353316,40)
1237	2072	(28.279800219209818,39.25)
1238	1841	(1,35.5)
1239	1841	(1,35.5)
1240	1761	(1,34)
1241	992	(27.846787517317598,19)
1242	665	(21.784609690826528,13)
1243	947	(23.949673200287624,18.25)
1244	990	(26.114736709748719,19)
1245	663	(20.05255888325765,13)
1246	947	(23.949673200287624,18.25)
1247	947	(23.949673200287624,18.25)
1248	659	(16.588457268119896,13)
1249	659	(16.588457268119896,13)
1250	947	(23.949673200287624,18.25)
1251	945	(22.217622392718749,18.25)
1252	904	(20.918584287042091,17.5)
1253	1149	(25.248711305964282,22)
1254	1187	(23.949673200287624,22.75)
1255	1187	(23.949673200287624,22.75)
1256	1068	(24.382685902179844,20.5)
1257	1104	(21.351596988934308,21.25)
1258	1103	(20.48557158514987,21.25)
1259	1063	(20.05255888325765,20.5)
1260	1023	(20.48557158514987,19.75)
1261	1098	(16.155444566227676,21.25)
1262	905	(21.784609690826528,17.5)
1263	543	(20.48557158514987,10.75)
1264	543	(20.48557158514987,10.75)
1265	543	(20.48557158514987,10.75)
1266	542	(19.619546181365433,10.75)
1267	543	(20.48557158514987,10.75)
1268	666	(22.650635094610966,13)
1269	1501	(18.753520777580992,28.75)
1270	1460	(17.454482671904334,28)
1271	1460	(17.454482671904334,28)
1272	1501	(18.753520777580992,28.75)
1273	1541	(18.320508075688775,29.5)
1274	2388	(24.815698604072061,45.25)
1275	2347	(23.516660498395403,44.5)
1276	2347	(23.516660498395403,44.5)
1277	2299	(17.021469970012117,43.75)
1278	2303	(20.48557158514987,43.75)
1279	2342	(19.186533479473212,44.5)
1280	2384	(21.351596988934308,45.25)
1281	2384	(21.351596988934308,45.25)
1282	2384	(21.351596988934308,45.25)
1283	2259	(16.588457268119896,43)
1284	2362	(2.299038105676658,45.25)
1285	2362	(2.299038105676658,45.25)
1286	2321	(1,44.5)
1287	2321	(1,44.5)
1288	2364	(4.0310889132455356,45.25)
1289	1942	(19.186533479473212,37)
1290	1860	(17.454482671904334,35.5)
1291	1890	(9.2272413359521668,36.25)
1292	1779	(16.588457268119896,34)
1293	1695	(13.124355652982141,32.5)
1294	1822	(19.619546181365433,34.75)
1295	1772	(10.526279441628825,34)
1296	1902	(19.619546181365433,36.25)
1297	1893	(11.825317547305483,36.25)
1298	1772	(10.526279441628825,34)
1299	1772	(10.526279441628825,34)
1300	2101	(18.320508075688775,40)
1301	1772	(10.526279441628825,34)
1302	1929	(7.9282032302755088,37)
1303	2053	(11.825317547305483,39.25)
1304	1807	(6.6291651245988508,34.75)
1305	1807	(6.6291651245988508,34.75)
1306	2060	(17.887495373796554,39.25)
1307	2134	(12.691342951089922,40.75)
1308	2206	(5.7631397208144124,42.25)
1309	1925	(4.4641016151377544,37)
1310	2213	(11.825317547305483,42.25)
1311	2041	(1.4330127018922194,39.25)
1312	2207	(6.6291651245988508,42.25)
1313	1770	(8.794228634059948,34)
1314	2060	(17.887495373796554,39.25)
1315	2053	(11.825317547305483,39.25)
1316	2214	(12.691342951089922,42.25)
1317	2255	(13.124355652982141,43)
1318	1925	(4.4641016151377544,37)
1319	1925	(4.4641016151377544,37)
1320	1884	(4.0310889132455356,36.25)
1321	1822	(19.619546181365433,34.75)
1322	2098	(15.722431864335457,40)
1323	2094	(12.258330249197702,40)
1324	1807	(6.6291651245988508,34.75)
1325	7	(6.196152422706632,1)
1326	7	(6.196152422706632,1)
1327	7	(6.196152422706632,1)
1328	1742	(19.619546181365433,33.25)
1329	201	(1.4330127018922194,4.75)
1330	321	(1,7)
1331	321	(1,7)
1332	245	(4.4641016151377544,5.5)
1333	247	(6.196152422706632,5.5)
1334	3	(2.7320508075688772,1)
1335	367	(6.6291651245988508,7.75)
1336	367	(6.6291651245988508,7.75)
1337	326	(5.3301270189221936,7)
1338	326	(5.3301270189221936,7)
1339	2320	(35.208003449485325,43.75)
1340	1009	(8.3612159321677293,19.75)
1341	1205	(4.4641016151377544,23.5)
1342	969	(7.9282032302755088,19)
1343	1342	(19.619546181365433,25.75)
1344	1392	(27.846787517317598,26.5)
1345	1427	(23.949673200287624,27.25)
1346	1427	(23.949673200287624,27.25)
1347	1470	(26.114736709748719,28)
1348	1350	(26.54774941164094,25.75)
1349	1917	(32.609927238132009,36.25)
1350	1955	(30.444863728670914,37)
1351	1953	(28.712812921102035,37)
1352	2067	(23.949673200287624,39.25)
1353	1955	(30.444863728670914,37)
1354	1949	(25.248711305964282,37)
1355	1494	(12.691342951089922,28.75)
1356	1953	(28.712812921102035,37)
1357	1610	(8.794228634059948,31)
1358	1647	(6.6291651245988508,31.75)
1359	1687	(6.196152422706632,32.5)
1360	2067	(23.949673200287624,39.25)
1361	2399	(34.341978045700891,45.25)
1362	2200	(34.774990747593108,41.5)
1363	2072	(28.279800219209818,39.25)
1364	1160	(34.774990747593108,22)
1365	1160	(34.774990747593108,22)
1366	1160	(34.774990747593108,22)
1367	1439	(34.341978045700891,27.25)
1368	2317	(32.609927238132009,43.75)
1369	2269	(25.248711305964282,43)
1370	2358	(33.042939940024233,44.5)
1371	1356	(31.743901834347572,25.75)
1372	2189	(25.248711305964282,41.5)
1373	2394	(30.011851026778693,45.25)
1374	2394	(30.011851026778693,45.25)
1375	2352	(27.846787517317598,44.5)
1376	2392	(28.279800219209818,45.25)
1377	913	(28.712812921102035,17.5)
1378	1113	(29.145825622994256,21.25)
1379	912	(27.846787517317598,17.5)
1380	911	(26.98076211353316,17.5)
1381	870	(26.54774941164094,16.75)
1382	1152	(27.846787517317598,22)
1383	1140	(17.454482671904334,22)
1384	1182	(19.619546181365433,22.75)
1385	1790	(26.114736709748719,34)
1386	1905	(22.217622392718749,36.25)
1387	2289	(8.3612159321677293,43.75)
1388	1537	(14.856406460551018,29.5)
1389	1578	(16.155444566227676,30.25)
1390	1618	(15.722431864335457,31)
1391	563	(2.7320508075688772,11.5)
1392	601	(1.4330127018922194,12.25)
1393	1287	(6.196152422706632,25)
1394	1834	(30.011851026778693,34.75)
1395	1907	(23.949673200287624,36.25)
1396	1907	(23.949673200287624,36.25)
1397	1765	(4.4641016151377544,34)
1398	601	(1.4330127018922194,12.25)
1399	601	(1.4330127018922194,12.25)
1400	601	(1.4330127018922194,12.25)
1401	1342	(19.619546181365433,25.75)
1402	1414	(12.691342951089922,27.25)
1403	1412	(10.959292143521045,27.25)
1404	1410	(9.2272413359521668,27.25)
1405	482	(1.8660254037844386,10)
1406	1411	(10.093266739736606,27.25)
1407	1293	(11.392304845413264,25)
1408	1227	(23.516660498395403,23.5)
1409	936	(14.423393758658799,18.25)
1410	442	(2.299038105676658,9.25)
1411	973	(11.392304845413264,19)
1412	1019	(17.021469970012117,19.75)
1413	1135	(13.124355652982141,22)
1414	1708	(24.382685902179844,32.5)
1415	1708	(24.382685902179844,32.5)
1416	1708	(24.382685902179844,32.5)
1417	1708	(24.382685902179844,32.5)
1418	1708	(24.382685902179844,32.5)
1419	1073	(28.712812921102035,20.5)
1420	936	(14.423393758658799,18.25)
1421	2158	(33.47595264191645,40.75)
1422	2040	(34.774990747593108,38.5)
1423	2080	(35.208003449485325,39.25)
1424	2079	(34.341978045700891,39.25)
1425	2040	(34.774990747593108,38.5)
1426	2079	(34.341978045700891,39.25)
1427	2194	(29.578838324886476,41.5)
1428	673	(28.712812921102035,13)
1429	632	(28.279800219209818,12.25)
1430	673	(28.712812921102035,13)
1431	152	(28.279800219209818,3.25)
1432	153	(29.145825622994256,3.25)
1433	673	(28.712812921102035,13)
1434	632	(28.279800219209818,12.25)
1435	673	(28.712812921102035,13)
1436	152	(28.279800219209818,3.25)
1437	113	(28.712812921102035,2.5)
1438	151	(27.413774815425377,3.25)
1439	113	(28.712812921102035,2.5)
1440	34	(29.578838324886476,1)
1441	34	(29.578838324886476,1)
1442	145	(22.217622392718749,3.25)
1443	438	(33.042939940024233,8.5)
1444	439	(33.908965343808667,8.5)
1445	145	(22.217622392718749,3.25)
1446	37	(32.176914536239792,1)
1447	160	(35.208003449485325,3.25)
1448	37	(32.176914536239792,1)
1449	160	(35.208003449485325,3.25)
1450	37	(32.176914536239792,1)
1451	80	(35.208003449485325,1.75)
1452	37	(32.176914536239792,1)
1453	80	(35.208003449485325,1.75)
1454	1277	(32.609927238132009,24.25)
1455	1277	(32.609927238132009,24.25)
1456	1476	(31.310889132455351,28)
1457	1753	(29.145825622994256,33.25)
1458	1715	(30.444863728670914,32.5)
1459	1676	(31.743901834347572,31.75)
1460	1717	(32.176914536239792,32.5)
1461	1718	(33.042939940024233,32.5)
1462	1680	(35.208003449485325,31.75)
1463	1240	(34.774990747593108,23.5)
1464	1240	(34.774990747593108,23.5)
1465	1360	(35.208003449485325,25.75)
1466	1440	(35.208003449485325,27.25)
1467	113	(28.712812921102035,2.5)
1468	34	(29.578838324886476,1)
1469	31	(26.98076211353316,1)
1470	31	(26.98076211353316,1)
1471	31	(26.98076211353316,1)
1472	1237	(32.176914536239792,23.5)
1473	1237	(32.176914536239792,23.5)
1474	1197	(32.609927238132009,22.75)
1475	1439	(34.341978045700891,27.25)
1476	399	(34.341978045700891,7.75)
1477	673	(28.712812921102035,13)
1478	632	(28.279800219209818,12.25)
1479	632	(28.279800219209818,12.25)
1480	152	(28.279800219209818,3.25)
1481	153	(29.145825622994256,3.25)
1482	1117	(32.609927238132009,21.25)
1483	1117	(32.609927238132009,21.25)
1484	114	(29.578838324886476,2.5)
1485	153	(29.145825622994256,3.25)
1486	74	(30.011851026778693,1.75)
1487	391	(27.413774815425377,7.75)
1488	312	(28.279800219209818,6.25)
1489	555	(30.877876430563134,10.75)
1490	78	(33.47595264191645,1.75)
1491	78	(33.47595264191645,1.75)
1492	199	(33.908965343808667,4)
1493	199	(33.908965343808667,4)
1494	74	(30.011851026778693,1.75)
1495	101	(18.320508075688775,2.5)
1496	101	(18.320508075688775,2.5)
1497	141	(18.753520777580992,3.25)
1498	58	(16.155444566227676,1.75)
1499	17	(14.856406460551018,1)
1500	17	(14.856406460551018,1)
1501	17	(14.856406460551018,1)
1502	10	(8.794228634059948,1)
1503	178	(15.722431864335457,4)
1504	2156	(31.743901834347572,40.75)
1505	2154	(30.011851026778693,40.75)
1506	2111	(26.98076211353316,40)
1507	2072	(28.279800219209818,39.25)
1508	2233	(29.145825622994256,42.25)
1509	2374	(12.691342951089922,45.25)
1510	2374	(12.691342951089922,45.25)
1511	1786	(22.650635094610966,34)
1512	2370	(9.2272413359521668,45.25)
1513	1786	(22.650635094610966,34)
1514	2373	(11.825317547305483,45.25)
1515	1342	(19.619546181365433,25.75)
1516	1343	(20.48557158514987,25.75)
1517	1298	(15.722431864335457,25)
1518	1298	(15.722431864335457,25)
1519	1377	(14.856406460551018,26.5)
1520	1298	(15.722431864335457,25)
1521	1296	(13.99038105676658,25)
1522	1336	(14.423393758658799,25.75)
1523	1336	(14.423393758658799,25.75)
1524	1256	(14.423393758658799,24.25)
1525	1216	(13.99038105676658,23.5)
1526	1216	(13.99038105676658,23.5)
1527	1306	(22.650635094610966,25)
1528	412	(10.526279441628825,8.5)
1529	1960	(34.774990747593108,37)
1530	2196	(31.310889132455351,41.5)
1531	2359	(33.908965343808667,44.5)
1532	2279	(33.908965343808667,43)
1533	782	(19.619546181365433,15.25)
1534	822	(19.186533479473212,16)
1535	821	(18.320508075688775,16)
1536	819	(16.588457268119896,16)
1537	738	(15.722431864335457,14.5)
1538	737	(14.856406460551018,14.5)
1539	336	(13.99038105676658,7)
1540	256	(13.99038105676658,5.5)
1541	214	(12.691342951089922,4.75)
1542	13	(11.392304845413264,1)
1543	295	(13.55736835487436,6.25)
1544	2280	(34.774990747593108,43)
1545	1902	(19.619546181365433,36.25)
1546	2396	(31.743901834347572,45.25)
1547	1902	(19.619546181365433,36.25)
1548	1821	(18.753520777580992,34.75)
1549	2016	(13.99038105676658,38.5)
1550	2055	(13.55736835487436,39.25)
1551	262	(19.186533479473212,5.5)
1552	223	(20.48557158514987,4.75)
1553	223	(20.48557158514987,4.75)
1554	301	(18.753520777580992,6.25)
1555	339	(16.588457268119896,7)
1556	1	(1,1)
1557	1	(1,1)
1558	1	(1,1)
1559	2400	(35.208003449485325,45.25)
1560	364	(4.0310889132455356,7.75)
1561	363	(3.1650635094610968,7.75)
1562	1290	(8.794228634059948,25)
1563	1370	(8.794228634059948,26.5)
1564	1574	(12.691342951089922,30.25)
1565	1533	(11.392304845413264,29.5)
1566	1493	(11.825317547305483,28.75)
1567	568	(7.0621778264910704,11.5)
1568	441	(1.4330127018922194,9.25)
1569	681	(1.4330127018922194,13.75)
1570	644	(3.598076211353316,13)
1571	1328	(7.49519052838329,25.75)
1572	1203	(2.7320508075688772,23.5)
1573	1203	(2.7320508075688772,23.5)
1574	1203	(2.7320508075688772,23.5)
1575	7	(6.196152422706632,1)
1576	321	(1,7)
1577	247	(6.196152422706632,5.5)
1578	3	(2.7320508075688772,1)
1579	339	(16.588457268119896,7)
1580	2127	(6.6291651245988508,40.75)
1581	2279	(33.908965343808667,43)
1582	485	(4.4641016151377544,10)
1583	1533	(11.392304845413264,29.5)
1584	482	(1.8660254037844386,10)
1585	490	(8.794228634059948,10)
1586	566	(5.3301270189221936,11.5)
1587	568	(7.0621778264910704,11.5)
1588	568	(7.0621778264910704,11.5)
1589	770	(9.2272413359521668,15.25)
1590	1374	(12.258330249197702,26.5)
1591	1090	(9.2272413359521668,21.25)
1592	1050	(8.794228634059948,20.5)
1593	1323	(3.1650635094610968,25.75)
1594	1323	(3.1650635094610968,25.75)
1595	1323	(3.1650635094610968,25.75)
1596	1323	(3.1650635094610968,25.75)
1597	966	(5.3301270189221936,19)
1598	966	(5.3301270189221936,19)
1599	965	(4.4641016151377544,19)
1600	1128	(7.0621778264910704,22)
1601	1206	(5.3301270189221936,23.5)
1602	1206	(5.3301270189221936,23.5)
1603	761	(1.4330127018922194,15.25)
1604	761	(1.4330127018922194,15.25)
1605	762	(2.299038105676658,15.25)
1606	884	(3.598076211353316,17.5)
1607	884	(3.598076211353316,17.5)
1608	884	(3.598076211353316,17.5)
1609	884	(3.598076211353316,17.5)
1610	1283	(2.7320508075688772,25)
1611	1283	(2.7320508075688772,25)
1612	1283	(2.7320508075688772,25)
1613	1241	(1.4330127018922194,24.25)
1614	1241	(1.4330127018922194,24.25)
1615	962	(1.8660254037844386,19)
1616	962	(1.8660254037844386,19)
1617	962	(1.8660254037844386,19)
1618	962	(1.8660254037844386,19)
1619	962	(1.8660254037844386,19)
1620	962	(1.8660254037844386,19)
1621	1041	(1,20.5)
1622	1041	(1,20.5)
1623	681	(1.4330127018922194,13.75)
1624	928	(7.49519052838329,18.25)
1625	1244	(4.0310889132455356,24.25)
1626	1244	(4.0310889132455356,24.25)
1627	1283	(2.7320508075688772,25)
1628	925	(4.897114317029974,18.25)
1629	925	(4.897114317029974,18.25)
1630	925	(4.897114317029974,18.25)
1631	1206	(5.3301270189221936,23.5)
1632	925	(4.897114317029974,18.25)
1633	1041	(1,20.5)
1634	1041	(1,20.5)
1635	1041	(1,20.5)
1636	1041	(1,20.5)
1637	1041	(1,20.5)
1638	1041	(1,20.5)
1639	1041	(1,20.5)
1640	1041	(1,20.5)
1641	1041	(1,20.5)
1642	1041	(1,20.5)
1643	1041	(1,20.5)
1644	841	(1.4330127018922194,16.75)
1645	1041	(1,20.5)
1646	1041	(1,20.5)
1647	841	(1.4330127018922194,16.75)
1648	1041	(1,20.5)
1649	1041	(1,20.5)
1650	1956	(31.310889132455351,37)
1651	1957	(32.176914536239792,37)
1652	2154	(30.011851026778693,40.75)
1653	2033	(28.712812921102035,38.5)
1654	2033	(28.712812921102035,38.5)
1655	1957	(32.176914536239792,37)
1656	2035	(30.444863728670914,38.5)
1657	1652	(10.959292143521045,31.75)
1658	2111	(26.98076211353316,40)
1659	2070	(26.54774941164094,39.25)
1660	2106	(22.650635094610966,40)
1661	2105	(21.784609690826528,40)
1662	848	(7.49519052838329,16.75)
1663	848	(7.49519052838329,16.75)
1664	848	(7.49519052838329,16.75)
1665	1494	(12.691342951089922,28.75)
1666	574	(12.258330249197702,11.5)
1667	574	(12.258330249197702,11.5)
1668	1534	(12.258330249197702,29.5)
1669	612	(10.959292143521045,12.25)
1670	570	(8.794228634059948,11.5)
1671	1448	(7.0621778264910704,28)
1672	1831	(27.413774815425377,34.75)
1673	1786	(22.650635094610966,34)
1674	1786	(22.650635094610966,34)
1675	1864	(20.918584287042091,35.5)
1676	1864	(20.918584287042091,35.5)
1677	1864	(20.918584287042091,35.5)
1678	2250	(8.794228634059948,43)
1679	2289	(8.3612159321677293,43.75)
1680	1804	(4.0310889132455356,34.75)
1681	2376	(14.423393758658799,45.25)
1682	2376	(14.423393758658799,45.25)
1683	2376	(14.423393758658799,45.25)
1684	2376	(14.423393758658799,45.25)
1685	1833	(29.145825622994256,34.75)
1686	2320	(35.208003449485325,43.75)
1687	1051	(9.6602540378443873,20.5)
1688	1205	(4.4641016151377544,23.5)
1689	1245	(4.897114317029974,24.25)
1690	889	(7.9282032302755088,17.5)
1691	848	(7.49519052838329,16.75)
1692	2103	(20.05255888325765,40)
1693	1051	(9.6602540378443873,20.5)
1694	1205	(4.4641016151377544,23.5)
1695	1008	(7.49519052838329,19.75)
1696	1205	(4.4641016151377544,23.5)
1697	1041	(1,20.5)
1698	1041	(1,20.5)
1699	1041	(1,20.5)
1700	1041	(1,20.5)
1701	848	(7.49519052838329,16.75)
1702	848	(7.49519052838329,16.75)
1703	1471	(26.98076211353316,28)
1704	1470	(26.114736709748719,28)
1705	1393	(28.712812921102035,26.5)
1706	1352	(28.279800219209818,25.75)
1707	1390	(26.114736709748719,26.5)
1708	1471	(26.98076211353316,28)
1709	1509	(25.681724007856502,28.75)
1710	1424	(21.351596988934308,27.25)
1711	1424	(21.351596988934308,27.25)
1712	1424	(21.351596988934308,27.25)
1713	1545	(21.784609690826528,29.5)
1714	1544	(20.918584287042091,29.5)
1715	1544	(20.918584287042091,29.5)
1716	1583	(20.48557158514987,30.25)
1717	1623	(20.05255888325765,31)
1718	1623	(20.05255888325765,31)
1719	1623	(20.05255888325765,31)
1720	1538	(15.722431864335457,29.5)
1721	1537	(14.856406460551018,29.5)
1722	1578	(16.155444566227676,30.25)
1723	632	(28.279800219209818,12.25)
1724	1038	(33.47595264191645,19.75)
1725	1339	(17.021469970012117,25.75)
1726	1302	(19.186533479473212,25)
1727	1298	(15.722431864335457,25)
1728	1298	(15.722431864335457,25)
1729	1336	(14.423393758658799,25.75)
1730	1306	(22.650635094610966,25)
1731	1112	(28.279800219209818,21.25)
1732	1152	(27.846787517317598,22)
1733	1182	(19.619546181365433,22.75)
1734	1222	(19.186533479473212,23.5)
1735	1152	(27.846787517317598,22)
1736	835	(30.444863728670914,16)
1737	835	(30.444863728670914,16)
1738	754	(29.578838324886476,14.5)
1739	835	(30.444863728670914,16)
1740	875	(30.877876430563134,16.75)
1741	835	(30.444863728670914,16)
1742	792	(28.279800219209818,15.25)
1743	792	(28.279800219209818,15.25)
1744	666	(22.650635094610966,13)
1745	1514	(30.011851026778693,28.75)
1746	1190	(26.54774941164094,22.75)
1747	554	(30.011851026778693,10.75)
1748	511	(26.98076211353316,10)
1749	511	(26.98076211353316,10)
1750	72	(28.279800219209818,1.75)
1751	31	(26.98076211353316,1)
1752	31	(26.98076211353316,1)
1753	511	(26.98076211353316,10)
1754	146	(23.083647796503186,3.25)
1755	68	(24.815698604072061,1.75)
1756	28	(24.382685902179844,1)
1757	28	(24.382685902179844,1)
1758	38	(33.042939940024233,1)
1759	80	(35.208003449485325,1.75)
1760	37	(32.176914536239792,1)
1761	37	(32.176914536239792,1)
1762	37	(32.176914536239792,1)
1763	145	(22.217622392718749,3.25)
1764	145	(22.217622392718749,3.25)
1765	112	(27.846787517317598,2.5)
1766	274	(29.578838324886476,5.5)
1767	274	(29.578838324886476,5.5)
1768	274	(29.578838324886476,5.5)
1769	160	(35.208003449485325,3.25)
1770	37	(32.176914536239792,1)
1771	37	(32.176914536239792,1)
1772	37	(32.176914536239792,1)
1773	36	(31.310889132455351,1)
1774	554	(30.011851026778693,10.75)
1775	554	(30.011851026778693,10.75)
1776	271	(26.98076211353316,5.5)
1777	272	(27.846787517317598,5.5)
1778	272	(27.846787517317598,5.5)
1779	272	(27.846787517317598,5.5)
1780	554	(30.011851026778693,10.75)
1781	145	(22.217622392718749,3.25)
1782	160	(35.208003449485325,3.25)
1783	1149	(25.248711305964282,22)
1784	1147	(23.516660498395403,22)
1785	1068	(24.382685902179844,20.5)
1786	1185	(22.217622392718749,22.75)
1787	1062	(19.186533479473212,20.5)
1788	1023	(20.48557158514987,19.75)
1789	905	(21.784609690826528,17.5)
1790	905	(21.784609690826528,17.5)
1791	1137	(14.856406460551018,22)
1792	21	(18.320508075688775,1)
1793	94	(12.258330249197702,2.5)
1794	95	(13.124355652982141,2.5)
1795	133	(11.825317547305483,3.25)
1796	133	(11.825317547305483,3.25)
1797	175	(13.124355652982141,4)
1798	175	(13.124355652982141,4)
1799	11	(9.6602540378443873,1)
1800	175	(13.124355652982141,4)
1801	215	(13.55736835487436,4.75)
1802	13	(11.392304845413264,1)
1803	1480	(34.774990747593108,28)
1804	1160	(34.774990747593108,22)
1805	1160	(34.774990747593108,22)
1806	1320	(34.774990747593108,25)
1807	1440	(35.208003449485325,27.25)
1808	2317	(32.609927238132009,43.75)
1809	2269	(25.248711305964282,43)
1810	2358	(33.042939940024233,44.5)
1811	1356	(31.743901834347572,25.75)
1812	254	(12.258330249197702,5.5)
1813	335	(13.124355652982141,7)
1814	295	(13.55736835487436,6.25)
1815	819	(16.588457268119896,16)
1816	696	(14.423393758658799,13.75)
1817	778	(16.155444566227676,15.25)
1818	2261	(18.320508075688775,43)
1819	336	(13.99038105676658,7)
1820	255	(13.124355652982141,5.5)
1821	214	(12.691342951089922,4.75)
1822	2347	(23.516660498395403,44.5)
1823	2347	(23.516660498395403,44.5)
1824	2261	(18.320508075688775,43)
1825	2299	(17.021469970012117,43.75)
1826	2341	(18.320508075688775,44.5)
1827	2380	(17.887495373796554,45.25)
1828	2304	(21.351596988934308,43.75)
1829	2303	(20.48557158514987,43.75)
1830	2383	(20.48557158514987,45.25)
1831	2380	(17.887495373796554,45.25)
1832	2365	(4.897114317029974,45.25)
1833	2261	(18.320508075688775,43)
1834	2282	(2.299038105676658,43.75)
1835	2281	(1.4330127018922194,43.75)
1836	2281	(1.4330127018922194,43.75)
1837	2281	(1.4330127018922194,43.75)
1838	2365	(4.897114317029974,45.25)
1839	2367	(6.6291651245988508,45.25)
1840	2367	(6.6291651245988508,45.25)
1841	2281	(1.4330127018922194,43.75)
1842	2281	(1.4330127018922194,43.75)
1843	2241	(1,43)
1844	2201	(1.4330127018922194,42.25)
1845	2178	(15.722431864335457,41.5)
1846	1695	(13.124355652982141,32.5)
1847	1696	(13.99038105676658,32.5)
1848	1931	(9.6602540378443873,37)
1849	1942	(19.186533479473212,37)
1850	1893	(11.825317547305483,36.25)
1851	1889	(8.3612159321677293,36.25)
1852	1779	(16.588457268119896,34)
1853	1779	(16.588457268119896,34)
1854	2060	(17.887495373796554,39.25)
1855	1776	(13.99038105676658,34)
1856	1977	(15.289419162443238,37.75)
1857	1852	(10.526279441628825,35.5)
1858	2141	(18.753520777580992,40.75)
1859	2060	(17.887495373796554,39.25)
1860	2215	(13.55736835487436,42.25)
1861	2127	(6.6291651245988508,40.75)
1862	1937	(14.856406460551018,37)
1863	1928	(7.0621778264910704,37)
1864	1968	(7.49519052838329,37.75)
1865	2008	(7.0621778264910704,38.5)
1866	1923	(2.7320508075688772,37)
1867	2008	(7.0621778264910704,38.5)
1868	1923	(2.7320508075688772,37)
1869	1977	(15.289419162443238,37.75)
1870	1891	(10.093266739736606,36.25)
1871	1891	(10.093266739736606,36.25)
1872	2134	(12.691342951089922,40.75)
1873	2167	(6.196152422706632,41.5)
1874	2088	(7.0621778264910704,40)
1875	2081	(1,40)
1876	2081	(1,40)
1877	1924	(3.598076211353316,37)
1878	1923	(2.7320508075688772,37)
1879	2126	(5.7631397208144124,40.75)
1880	2130	(9.2272413359521668,40.75)
1881	1924	(3.598076211353316,37)
1882	2124	(4.0310889132455356,40.75)
1883	2212	(10.959292143521045,42.25)
1884	2126	(5.7631397208144124,40.75)
1885	1961	(1.4330127018922194,37.75)
1886	2212	(10.959292143521045,42.25)
1887	2126	(5.7631397208144124,40.75)
1888	2121	(1.4330127018922194,40.75)
1889	2121	(1.4330127018922194,40.75)
1890	2170	(8.794228634059948,41.5)
1891	2041	(1.4330127018922194,39.25)
1892	2081	(1,40)
1893	2081	(1,40)
1894	2081	(1,40)
1895	2394	(30.011851026778693,45.25)
1896	2392	(28.279800219209818,45.25)
1897	2392	(28.279800219209818,45.25)
1898	2353	(28.712812921102035,44.5)
1899	2040	(34.774990747593108,38.5)
1900	2194	(29.578838324886476,41.5)
1901	2194	(29.578838324886476,41.5)
1902	2040	(34.774990747593108,38.5)
1903	2040	(34.774990747593108,38.5)
1904	1879	(33.908965343808667,35.5)
1905	2365	(4.897114317029974,45.25)
1906	2299	(17.021469970012117,43.75)
1907	2339	(16.588457268119896,44.5)
1908	1520	(35.208003449485325,28.75)
1909	1240	(34.774990747593108,23.5)
1910	1240	(34.774990747593108,23.5)
1911	1360	(35.208003449485325,25.75)
1912	1597	(32.609927238132009,30.25)
1913	1597	(32.609927238132009,30.25)
1914	751	(26.98076211353316,14.5)
1915	1907	(23.949673200287624,36.25)
1916	1245	(4.897114317029974,24.25)
1917	761	(1.4330127018922194,15.25)
1918	884	(3.598076211353316,17.5)
1919	884	(3.598076211353316,17.5)
1920	1041	(1,20.5)
1921	1041	(1,20.5)
1922	1041	(1,20.5)
1923	1041	(1,20.5)
1924	1598	(33.47595264191645,30.25)
1925	1355	(30.877876430563134,25.75)
1926	1600	(35.208003449485325,30.25)
1927	1724	(4.0310889132455356,33.25)
1928	1725	(4.897114317029974,33.25)
1929	2187	(23.516660498395403,41.5)
1930	2187	(23.516660498395403,41.5)
1931	1041	(1,20.5)
1932	1911	(27.413774815425377,36.25)
1933	2200	(34.774990747593108,41.5)
1934	1869	(25.248711305964282,35.5)
1935	2399	(34.341978045700891,45.25)
1936	2400	(35.208003449485325,45.25)
1937	2279	(33.908965343808667,43)
1938	2189	(25.248711305964282,41.5)
1939	2080	(35.208003449485325,39.25)
1940	1592	(28.279800219209818,30.25)
1941	1627	(23.516660498395403,31)
1942	1626	(22.650635094610966,31)
1943	1626	(22.650635094610966,31)
1944	1626	(22.650635094610966,31)
1945	7	(6.196152422706632,1)
1946	7	(6.196152422706632,1)
1947	6	(5.3301270189221936,1)
1948	6	(5.3301270189221936,1)
1949	5	(4.4641016151377544,1)
1950	283	(3.1650635094610968,6.25)
1951	282	(2.299038105676658,6.25)
1952	321	(1,7)
1953	163	(2.7320508075688772,4)
1954	163	(2.7320508075688772,4)
1955	121	(1.4330127018922194,3.25)
1956	324	(3.598076211353316,7)
1957	1411	(10.093266739736606,27.25)
1958	246	(5.3301270189221936,5.5)
1959	223	(20.48557158514987,4.75)
1960	261	(18.320508075688775,5.5)
1961	341	(18.320508075688775,7)
1962	339	(16.588457268119896,7)
1963	2159	(34.341978045700891,40.75)
1964	2159	(34.341978045700891,40.75)
1965	2071	(27.413774815425377,39.25)
1966	2118	(33.042939940024233,40)
1967	1691	(9.6602540378443873,32.5)
1968	2159	(34.341978045700891,40.75)
1969	1955	(30.444863728670914,37)
1970	1984	(21.351596988934308,37.75)
1971	1119	(34.341978045700891,21.25)
1972	1119	(34.341978045700891,21.25)
1973	1119	(34.341978045700891,21.25)
1974	1119	(34.341978045700891,21.25)
1975	917	(32.176914536239792,17.5)
1976	1440	(35.208003449485325,27.25)
1977	1480	(34.774990747593108,28)
1978	1704	(20.918584287042091,32.5)
1979	848	(7.49519052838329,16.75)
1980	848	(7.49519052838329,16.75)
1981	887	(6.196152422706632,17.5)
1982	1480	(34.774990747593108,28)
1983	1237	(32.176914536239792,23.5)
1984	1237	(32.176914536239792,23.5)
1985	840	(34.774990747593108,16)
1986	840	(34.774990747593108,16)
1987	1480	(34.774990747593108,28)
1988	1715	(30.444863728670914,32.5)
1989	1759	(34.341978045700891,33.25)
1990	1760	(35.208003449485325,33.25)
1991	1680	(35.208003449485325,31.75)
1992	1533	(11.392304845413264,29.5)
1993	1494	(12.691342951089922,28.75)
1994	1454	(12.258330249197702,28)
1995	1373	(11.392304845413264,26.5)
1996	627	(23.949673200287624,12.25)
1997	627	(23.949673200287624,12.25)
1998	625	(22.217622392718749,12.25)
1999	627	(23.949673200287624,12.25)
2000	625	(22.217622392718749,12.25)
2001	665	(21.784609690826528,13)
2002	618	(16.155444566227676,12.25)
2003	662	(19.186533479473212,13)
2004	662	(19.186533479473212,13)
2005	577	(14.856406460551018,11.5)
2006	659	(16.588457268119896,13)
2007	618	(16.155444566227676,12.25)
2008	656	(13.99038105676658,13)
2009	945	(22.217622392718749,18.25)
2010	945	(22.217622392718749,18.25)
2011	656	(13.99038105676658,13)
2012	426	(22.650635094610966,8.5)
2013	426	(22.650635094610966,8.5)
2014	505	(21.784609690826528,10)
2015	425	(21.784609690826528,8.5)
2016	505	(21.784609690826528,10)
2017	425	(21.784609690826528,8.5)
2018	461	(18.753520777580992,9.25)
2019	461	(18.753520777580992,9.25)
2020	425	(21.784609690826528,8.5)
2021	505	(21.784609690826528,10)
2022	425	(21.784609690826528,8.5)
2023	1513	(29.145825622994256,28.75)
2024	1253	(11.825317547305483,24.25)
2025	1309	(25.248711305964282,25)
2026	1374	(12.258330249197702,26.5)
2027	1308	(24.382685902179844,25)
2028	1592	(28.279800219209818,30.25)
2029	1453	(11.392304845413264,28)
2030	1267	(23.949673200287624,24.25)
2031	1669	(25.681724007856502,31.75)
2032	1783	(20.05255888325765,34)
2033	1627	(23.516660498395403,31)
2034	1626	(22.650635094610966,31)
2035	1626	(22.650635094610966,31)
2036	1626	(22.650635094610966,31)
2037	1626	(22.650635094610966,31)
2038	1704	(20.918584287042091,32.5)
2039	1704	(20.918584287042091,32.5)
2040	1704	(20.918584287042091,32.5)
2041	1704	(20.918584287042091,32.5)
2042	1704	(20.918584287042091,32.5)
2043	1704	(20.918584287042091,32.5)
2044	1704	(20.918584287042091,32.5)
2045	855	(13.55736835487436,16.75)
2046	896	(13.99038105676658,17.5)
2047	936	(14.423393758658799,18.25)
2048	814	(12.258330249197702,16)
2049	895	(13.124355652982141,17.5)
2050	854	(12.691342951089922,16.75)
2051	1015	(13.55736835487436,19.75)
2052	1015	(13.55736835487436,19.75)
2053	1109	(25.681724007856502,21.25)
2054	934	(12.691342951089922,18.25)
2055	980	(17.454482671904334,19)
2056	936	(14.423393758658799,18.25)
2057	938	(16.155444566227676,18.25)
2058	936	(14.423393758658799,18.25)
2059	1054	(12.258330249197702,20.5)
2060	938	(16.155444566227676,18.25)
2061	938	(16.155444566227676,18.25)
2062	1057	(14.856406460551018,20.5)
2063	1058	(15.722431864335457,20.5)
2064	597	(32.176914536239792,11.5)
2065	597	(32.176914536239792,11.5)
2066	597	(32.176914536239792,11.5)
2067	1390	(26.114736709748719,26.5)
2068	1424	(21.351596988934308,27.25)
2069	1545	(21.784609690826528,29.5)
2070	1544	(20.918584287042091,29.5)
2071	1623	(20.05255888325765,31)
2072	1623	(20.05255888325765,31)
2073	1544	(20.918584287042091,29.5)
2074	1623	(20.05255888325765,31)
2075	992	(27.846787517317598,19)
2076	954	(30.011851026778693,18.25)
2077	993	(28.712812921102035,19)
2078	993	(28.712812921102035,19)
2079	990	(26.114736709748719,19)
2080	990	(26.114736709748719,19)
2081	948	(24.815698604072061,18.25)
2082	946	(23.083647796503186,18.25)
2083	947	(23.949673200287624,18.25)
2084	947	(23.949673200287624,18.25)
2085	1099	(17.021469970012117,21.25)
2086	945	(22.217622392718749,18.25)
2087	945	(22.217622392718749,18.25)
2088	1099	(17.021469970012117,21.25)
2089	1715	(30.444863728670914,32.5)
2090	1757	(32.609927238132009,33.25)
2091	1759	(34.341978045700891,33.25)
2092	1760	(35.208003449485325,33.25)
2093	1680	(35.208003449485325,31.75)
2094	2396	(31.743901834347572,45.25)
2095	2396	(31.743901834347572,45.25)
2096	1822	(19.619546181365433,34.75)
2097	1902	(19.619546181365433,36.25)
2098	130	(9.2272413359521668,3.25)
2099	170	(8.794228634059948,4)
2100	2104	(20.918584287042091,40)
2101	2396	(31.743901834347572,45.25)
2102	2396	(31.743901834347572,45.25)
2103	1652	(10.959292143521045,31.75)
2104	1652	(10.959292143521045,31.75)
2105	1652	(10.959292143521045,31.75)
2106	1572	(10.959292143521045,30.25)
2107	451	(10.093266739736606,9.25)
2108	1691	(9.6602540378443873,32.5)
2109	2038	(33.042939940024233,38.5)
2110	1879	(33.908965343808667,35.5)
2111	1914	(30.011851026778693,36.25)
2112	554	(30.011851026778693,10.75)
2113	230	(26.54774941164094,4.75)
2114	72	(28.279800219209818,1.75)
2115	31	(26.98076211353316,1)
2116	31	(26.98076211353316,1)
2117	1476	(31.310889132455351,28)
2118	1753	(29.145825622994256,33.25)
2119	1715	(30.444863728670914,32.5)
2120	1676	(31.743901834347572,31.75)
2121	1717	(32.176914536239792,32.5)
2122	1718	(33.042939940024233,32.5)
2123	1759	(34.341978045700891,33.25)
2124	1760	(35.208003449485325,33.25)
2125	1680	(35.208003449485325,31.75)
2126	13	(11.392304845413264,1)
2127	748	(24.382685902179844,14.5)
2128	788	(24.815698604072061,15.25)
2129	2156	(31.743901834347572,40.75)
2130	2154	(30.011851026778693,40.75)
2131	2233	(29.145825622994256,42.25)
2132	1240	(34.774990747593108,23.5)
2133	1240	(34.774990747593108,23.5)
2134	1360	(35.208003449485325,25.75)
2135	1440	(35.208003449485325,27.25)
2136	1480	(34.774990747593108,28)
2137	1520	(35.208003449485325,28.75)
2138	1600	(35.208003449485325,30.25)
2139	566	(5.3301270189221936,11.5)
2140	568	(7.0621778264910704,11.5)
2141	770	(9.2272413359521668,15.25)
2142	1323	(3.1650635094610968,25.75)
2143	966	(5.3301270189221936,19)
2144	1041	(1,20.5)
2145	1041	(1,20.5)
2146	1041	(1,20.5)
2147	962	(1.8660254037844386,19)
2148	1041	(1,20.5)
2149	1041	(1,20.5)
2150	434	(29.578838324886476,8.5)
2151	2050	(9.2272413359521668,39.25)
2152	2050	(9.2272413359521668,39.25)
2153	2050	(9.2272413359521668,39.25)
2154	2050	(9.2272413359521668,39.25)
2155	2050	(9.2272413359521668,39.25)
2156	2090	(8.794228634059948,40)
2157	2050	(9.2272413359521668,39.25)
2158	2050	(9.2272413359521668,39.25)
2159	2050	(9.2272413359521668,39.25)
2160	2050	(9.2272413359521668,39.25)
2161	2090	(8.794228634059948,40)
2162	2241	(1,43)
2163	2241	(1,43)
2164	2241	(1,43)
2165	2283	(3.1650635094610968,43.75)
2166	2283	(3.1650635094610968,43.75)
2167	2201	(1.4330127018922194,42.25)
2168	2279	(33.908965343808667,43)
2169	2279	(33.908965343808667,43)
2170	609	(8.3612159321677293,12.25)
2171	1171	(10.093266739736606,22.75)
2172	1281	(1,25)
2173	1281	(1,25)
2174	607	(6.6291651245988508,12.25)
2175	607	(6.6291651245988508,12.25)
2176	1121	(1,22)
2177	1121	(1,22)
2178	1129	(7.9282032302755088,22)
2179	1129	(7.9282032302755088,22)
2180	1281	(1,25)
2181	1281	(1,25)
2182	1121	(1,22)
2183	1121	(1,22)
2184	2320	(35.208003449485325,43.75)
2185	1051	(9.6602540378443873,20.5)
2186	2104	(20.918584287042091,40)
2187	1242	(2.299038105676658,24.25)
2188	1121	(1,22)
2189	1121	(1,22)
2190	1121	(1,22)
2191	1242	(2.299038105676658,24.25)
2192	1253	(11.825317547305483,24.25)
2193	1592	(28.279800219209818,30.25)
2194	1554	(29.578838324886476,29.5)
2195	1595	(30.877876430563134,30.25)
2196	1591	(27.413774815425377,30.25)
2197	1592	(28.279800219209818,30.25)
2198	1591	(27.413774815425377,30.25)
2199	1670	(26.54774941164094,31.75)
2200	1628	(24.382685902179844,31)
2201	1626	(22.650635094610966,31)
2202	1742	(19.619546181365433,33.25)
2203	1554	(29.578838324886476,29.5)
2204	1628	(24.382685902179844,31)
2205	1670	(26.54774941164094,31.75)
2206	938	(16.155444566227676,18.25)
2207	1057	(14.856406460551018,20.5)
2208	934	(12.691342951089922,18.25)
2209	936	(14.423393758658799,18.25)
2210	933	(11.825317547305483,18.25)
2211	894	(12.258330249197702,17.5)
2212	1095	(13.55736835487436,21.25)
2213	1095	(13.55736835487436,21.25)
2214	740	(17.454482671904334,14.5)
2215	1054	(12.258330249197702,20.5)
2216	1831	(27.413774815425377,34.75)
2217	1534	(12.258330249197702,29.5)
2218	1534	(12.258330249197702,29.5)
2219	2289	(8.3612159321677293,43.75)
2220	2370	(9.2272413359521668,45.25)
2221	1660	(17.887495373796554,31.75)
2222	2370	(9.2272413359521668,45.25)
2223	1538	(15.722431864335457,29.5)
2224	1618	(15.722431864335457,31)
2225	1619	(16.588457268119896,31)
2226	1652	(10.959292143521045,31.75)
2227	613	(11.825317547305483,12.25)
2228	1834	(30.011851026778693,34.75)
2229	1642	(2.299038105676658,31.75)
2230	1601	(1,31)
2231	1614	(12.258330249197702,31)
2232	1610	(8.794228634059948,31)
2233	1986	(23.083647796503186,37.75)
2234	2027	(23.516660498395403,38.5)
2235	1703	(20.05255888325765,32.5)
2236	1986	(23.083647796503186,37.75)
2237	412	(10.526279441628825,8.5)
2238	2035	(30.444863728670914,38.5)
2239	412	(10.526279441628825,8.5)
2240	807	(6.196152422706632,16)
2241	807	(6.196152422706632,16)
2242	2159	(34.341978045700891,40.75)
2243	1652	(10.959292143521045,31.75)
2244	1652	(10.959292143521045,31.75)
2245	2028	(24.382685902179844,38.5)
2246	2027	(23.516660498395403,38.5)
2247	2025	(21.784609690826528,38.5)
2248	1154	(29.578838324886476,22)
2249	1220	(17.454482671904334,23.5)
2250	1220	(17.454482671904334,23.5)
2251	453	(11.825317547305483,9.25)
2252	453	(11.825317547305483,9.25)
2253	414	(12.258330249197702,8.5)
2254	453	(11.825317547305483,9.25)
2255	414	(12.258330249197702,8.5)
2256	1834	(30.011851026778693,34.75)
2257	1614	(12.258330249197702,31)
2258	1686	(5.3301270189221936,32.5)
2259	1764	(3.598076211353316,34)
2260	2376	(14.423393758658799,45.25)
2261	2376	(14.423393758658799,45.25)
2262	2337	(14.856406460551018,44.5)
2263	2376	(14.423393758658799,45.25)
2264	2370	(9.2272413359521668,45.25)
2265	1352	(28.279800219209818,25.75)
2266	1390	(26.114736709748719,26.5)
2267	1312	(27.846787517317598,25)
2268	1312	(27.846787517317598,25)
2269	1430	(26.54774941164094,27.25)
2270	1470	(26.114736709748719,28)
2271	1508	(24.815698604072061,28.75)
2272	1430	(26.54774941164094,27.25)
2273	1424	(21.351596988934308,27.25)
2274	1504	(21.351596988934308,28.75)
2275	1623	(20.05255888325765,31)
2276	1623	(20.05255888325765,31)
2277	1424	(21.351596988934308,27.25)
2278	1547	(23.516660498395403,29.5)
2279	623	(20.48557158514987,12.25)
2280	623	(20.48557158514987,12.25)
2281	623	(20.48557158514987,12.25)
2282	537	(15.289419162443238,10.75)
2283	537	(15.289419162443238,10.75)
2284	617	(15.289419162443238,12.25)
2285	1225	(21.784609690826528,23.5)
2286	866	(23.083647796503186,16.75)
2287	1098	(16.155444566227676,21.25)
2288	673	(28.712812921102035,13)
2289	269	(25.248711305964282,5.5)
2290	269	(25.248711305964282,5.5)
2291	112	(27.846787517317598,2.5)
2292	31	(26.98076211353316,1)
2293	186	(22.650635094610966,4)
2294	186	(22.650635094610966,4)
2295	105	(21.784609690826528,2.5)
2296	31	(26.98076211353316,1)
2297	269	(25.248711305964282,5.5)
2298	229	(25.681724007856502,4.75)
2299	113	(28.712812921102035,2.5)
2300	31	(26.98076211353316,1)
2301	186	(22.650635094610966,4)
2302	186	(22.650635094610966,4)
2303	105	(21.784609690826528,2.5)
2304	31	(26.98076211353316,1)
2305	1197	(32.609927238132009,22.75)
2306	917	(32.176914536239792,17.5)
2307	840	(34.774990747593108,16)
2308	840	(34.774990747593108,16)
2309	840	(34.774990747593108,16)
2310	60	(17.887495373796554,1.75)
2311	138	(16.155444566227676,3.25)
2312	10	(8.794228634059948,1)
2313	138	(16.155444566227676,3.25)
2314	10	(8.794228634059948,1)
2315	11	(9.6602540378443873,1)
2316	178	(15.722431864335457,4)
2317	178	(15.722431864335457,4)
2318	10	(8.794228634059948,1)
2319	11	(9.6602540378443873,1)
2320	737	(14.856406460551018,14.5)
2321	214	(12.691342951089922,4.75)
2322	13	(11.392304845413264,1)
2323	255	(13.124355652982141,5.5)
2324	375	(13.55736835487436,7.75)
2325	1160	(34.774990747593108,22)
2326	1160	(34.774990747593108,22)
2327	1398	(33.042939940024233,26.5)
2328	2317	(32.609927238132009,43.75)
2329	2269	(25.248711305964282,43)
2330	2358	(33.042939940024233,44.5)
2331	1356	(31.743901834347572,25.75)
2332	1476	(31.310889132455351,28)
2333	1753	(29.145825622994256,33.25)
2334	1715	(30.444863728670914,32.5)
2335	1718	(33.042939940024233,32.5)
2336	1760	(35.208003449485325,33.25)
2337	1680	(35.208003449485325,31.75)
2338	2194	(29.578838324886476,41.5)
2339	2154	(30.011851026778693,40.75)
2340	1240	(34.774990747593108,23.5)
2341	1240	(34.774990747593108,23.5)
2342	1596	(31.743901834347572,30.25)
2343	2157	(32.609927238132009,40.75)
2344	1598	(33.47595264191645,30.25)
2345	1600	(35.208003449485325,30.25)
2346	2279	(33.908965343808667,43)
2347	2279	(33.908965343808667,43)
2348	1822	(19.619546181365433,34.75)
2349	103	(20.05255888325765,2.5)
2350	103	(20.05255888325765,2.5)
2351	103	(20.05255888325765,2.5)
2352	103	(20.05255888325765,2.5)
2353	103	(20.05255888325765,2.5)
2354	103	(20.05255888325765,2.5)
2355	2225	(22.217622392718749,42.25)
2356	958	(33.47595264191645,18.25)
2357	156	(31.743901834347572,3.25)
2358	156	(31.743901834347572,3.25)
2359	156	(31.743901834347572,3.25)
2360	2159	(34.341978045700891,40.75)
2361	1518	(33.47595264191645,28.75)
2362	1840	(35.208003449485325,34.75)
2363	748	(24.382685902179844,14.5)
2364	787	(23.949673200287624,15.25)
2365	787	(23.949673200287624,15.25)
2366	1	(1,1)
2367	7	(6.196152422706632,1)
2368	7	(6.196152422706632,1)
2369	7	(6.196152422706632,1)
2370	1355	(30.877876430563134,25.75)
2371	2399	(34.341978045700891,45.25)
2372	2400	(35.208003449485325,45.25)
2373	1869	(25.248711305964282,35.5)
2374	2279	(33.908965343808667,43)
2375	2388	(24.815698604072061,45.25)
2376	2181	(18.320508075688775,41.5)
2377	2388	(24.815698604072061,45.25)
2378	2388	(24.815698604072061,45.25)
2379	2388	(24.815698604072061,45.25)
2380	2386	(23.083647796503186,45.25)
2381	2386	(23.083647796503186,45.25)
2382	2389	(25.681724007856502,45.25)
2383	2347	(23.516660498395403,44.5)
2384	2262	(19.186533479473212,43)
2385	2306	(23.083647796503186,43.75)
2386	2385	(22.217622392718749,45.25)
2387	2380	(17.887495373796554,45.25)
2388	2281	(1.4330127018922194,43.75)
2389	2285	(4.897114317029974,43.75)
2390	2258	(15.722431864335457,43)
2391	2281	(1.4330127018922194,43.75)
2392	2241	(1,43)
2393	2241	(1,43)
2394	2367	(6.6291651245988508,45.25)
2395	2281	(1.4330127018922194,43.75)
2396	2367	(6.6291651245988508,45.25)
2397	1776	(13.99038105676658,34)
2398	1941	(18.320508075688775,37)
2399	1980	(17.887495373796554,37.75)
2400	2060	(17.887495373796554,39.25)
2401	1928	(7.0621778264910704,37)
2402	1973	(11.825317547305483,37.75)
2403	1924	(3.598076211353316,37)
2404	2007	(6.196152422706632,38.5)
2405	2134	(12.691342951089922,40.75)
2406	2051	(10.093266739736606,39.25)
2407	2008	(7.0621778264910704,38.5)
2408	2050	(9.2272413359521668,39.25)
2409	2134	(12.691342951089922,40.75)
2410	1924	(3.598076211353316,37)
2411	2081	(1,40)
2412	1924	(3.598076211353316,37)
2413	2121	(1.4330127018922194,40.75)
2414	2121	(1.4330127018922194,40.75)
2415	2085	(4.4641016151377544,40)
2416	2085	(4.4641016151377544,40)
2417	2041	(1.4330127018922194,39.25)
2418	2163	(2.7320508075688772,41.5)
2419	2123	(3.1650635094610968,40.75)
2420	2016	(13.99038105676658,38.5)
2421	1934	(12.258330249197702,37)
2422	1934	(12.258330249197702,37)
2423	1934	(12.258330249197702,37)
2424	1934	(12.258330249197702,37)
2425	2178	(15.722431864335457,41.5)
2426	2055	(13.55736835487436,39.25)
2427	2178	(15.722431864335457,41.5)
2428	2136	(14.423393758658799,40.75)
2429	2394	(30.011851026778693,45.25)
2430	2394	(30.011851026778693,45.25)
2431	2392	(28.279800219209818,45.25)
2432	1340	(17.887495373796554,25.75)
2433	1306	(22.650635094610966,25)
2434	1306	(22.650635094610966,25)
2435	1306	(22.650635094610966,25)
2436	1306	(22.650635094610966,25)
2437	186	(22.650635094610966,4)
2438	105	(21.784609690826528,2.5)
2439	269	(25.248711305964282,5.5)
2440	229	(25.681724007856502,4.75)
2441	112	(27.846787517317598,2.5)
2442	31	(26.98076211353316,1)
2443	31	(26.98076211353316,1)
2444	65	(22.217622392718749,1.75)
2445	31	(26.98076211353316,1)
2446	1715	(30.444863728670914,32.5)
2447	1718	(33.042939940024233,32.5)
2448	1760	(35.208003449485325,33.25)
2449	1680	(35.208003449485325,31.75)
2450	958	(33.47595264191645,18.25)
2451	156	(31.743901834347572,3.25)
2452	156	(31.743901834347572,3.25)
2453	156	(31.743901834347572,3.25)
2454	156	(31.743901834347572,3.25)
2455	669	(25.248711305964282,13)
2456	669	(25.248711305964282,13)
2457	669	(25.248711305964282,13)
2458	1480	(34.774990747593108,28)
2459	1390	(26.114736709748719,26.5)
2460	1312	(27.846787517317598,25)
2461	1430	(26.54774941164094,27.25)
2462	1470	(26.114736709748719,28)
2463	1508	(24.815698604072061,28.75)
2464	1430	(26.54774941164094,27.25)
2465	1424	(21.351596988934308,27.25)
2466	1504	(21.351596988934308,28.75)
2467	1547	(23.516660498395403,29.5)
2468	1623	(20.05255888325765,31)
2469	1424	(21.351596988934308,27.25)
2470	2312	(28.279800219209818,43.75)
2471	2154	(30.011851026778693,40.75)
2472	2233	(29.145825622994256,42.25)
2473	2071	(27.413774815425377,39.25)
2474	2306	(23.083647796503186,43.75)
2475	2306	(23.083647796503186,43.75)
2476	2345	(21.784609690826528,44.5)
2477	2345	(21.784609690826528,44.5)
2478	2384	(21.351596988934308,45.25)
2479	2343	(20.05255888325765,44.5)
2480	2384	(21.351596988934308,45.25)
2481	2384	(21.351596988934308,45.25)
2482	2384	(21.351596988934308,45.25)
2483	2302	(19.619546181365433,43.75)
2484	2380	(17.887495373796554,45.25)
2485	2380	(17.887495373796554,45.25)
2486	2285	(4.897114317029974,43.75)
2487	2241	(1,43)
2488	1897	(15.289419162443238,36.25)
2489	1454	(12.258330249197702,28)
2490	490	(8.794228634059948,10)
2491	609	(8.3612159321677293,12.25)
2492	612	(10.959292143521045,12.25)
2493	1454	(12.258330249197702,28)
2494	1407	(6.6291651245988508,27.25)
2495	1407	(6.6291651245988508,27.25)
2496	1801	(1.4330127018922194,34.75)
2497	1762	(1.8660254037844386,34)
2498	1406	(5.7631397208144124,27.25)
2499	1406	(5.7631397208144124,27.25)
2500	1365	(4.4641016151377544,26.5)
2501	1405	(4.897114317029974,27.25)
2502	612	(10.959292143521045,12.25)
2503	568	(7.0621778264910704,11.5)
2504	566	(5.3301270189221936,11.5)
2505	607	(6.6291651245988508,12.25)
2506	682	(2.299038105676658,13.75)
2507	682	(2.299038105676658,13.75)
2508	849	(8.3612159321677293,16.75)
2509	848	(7.49519052838329,16.75)
2510	1362	(1.8660254037844386,26.5)
2511	1362	(1.8660254037844386,26.5)
2512	1362	(1.8660254037844386,26.5)
2513	1362	(1.8660254037844386,26.5)
2514	1081	(1.4330127018922194,21.25)
2515	884	(3.598076211353316,17.5)
2516	884	(3.598076211353316,17.5)
2517	1081	(1.4330127018922194,21.25)
2518	1081	(1.4330127018922194,21.25)
2519	1081	(1.4330127018922194,21.25)
2520	1081	(1.4330127018922194,21.25)
2521	485	(4.4641016151377544,10)
2522	939	(17.021469970012117,18.25)
2523	939	(17.021469970012117,18.25)
2524	1347	(23.949673200287624,25.75)
2525	1253	(11.825317547305483,24.25)
2526	1253	(11.825317547305483,24.25)
2527	1592	(28.279800219209818,30.25)
2528	533	(11.825317547305483,10.75)
2529	934	(12.691342951089922,18.25)
2530	978	(15.722431864335457,19)
2531	980	(17.454482671904334,19)
2532	980	(17.454482671904334,19)
2533	938	(16.155444566227676,18.25)
2534	1054	(12.258330249197702,20.5)
2535	1054	(12.258330249197702,20.5)
2536	1058	(15.722431864335457,20.5)
2537	1058	(15.722431864335457,20.5)
2538	1054	(12.258330249197702,20.5)
2539	2330	(8.794228634059948,44.5)
2540	2370	(9.2272413359521668,45.25)
2541	2337	(14.856406460551018,44.5)
2542	2337	(14.856406460551018,44.5)
2543	1844	(3.598076211353316,35.5)
2544	1660	(17.887495373796554,31.75)
2545	1620	(17.454482671904334,31)
2546	1494	(12.691342951089922,28.75)
2547	612	(10.959292143521045,12.25)
2548	751	(26.98076211353316,14.5)
2549	613	(11.825317547305483,12.25)
2550	610	(9.2272413359521668,12.25)
2551	1407	(6.6291651245988508,27.25)
2552	1487	(6.6291651245988508,28.75)
2553	1610	(8.794228634059948,31)
2554	1405	(4.897114317029974,27.25)
2555	1652	(10.959292143521045,31.75)
2556	1949	(25.248711305964282,37)
2557	610	(9.2272413359521668,12.25)
2558	1614	(12.258330249197702,31)
2559	1949	(25.248711305964282,37)
2560	1405	(4.897114317029974,27.25)
2561	691	(10.093266739736606,13.75)
2562	1487	(6.6291651245988508,28.75)
2563	1405	(4.897114317029974,27.25)
2564	2104	(20.918584287042091,40)
2565	1834	(30.011851026778693,34.75)
2566	1877	(32.176914536239792,35.5)
2567	1877	(32.176914536239792,35.5)
2568	1986	(23.083647796503186,37.75)
2569	2035	(30.444863728670914,38.5)
2570	1652	(10.959292143521045,31.75)
2571	1652	(10.959292143521045,31.75)
2572	2035	(30.444863728670914,38.5)
2573	1992	(28.279800219209818,37.75)
2574	1992	(28.279800219209818,37.75)
2575	1992	(28.279800219209818,37.75)
2576	1604	(3.598076211353316,31)
2577	1602	(1.8660254037844386,31)
2578	1641	(1.4330127018922194,31.75)
2579	1521	(1,29.5)
2580	2028	(24.382685902179844,38.5)
2581	2028	(24.382685902179844,38.5)
2582	2067	(23.949673200287624,39.25)
2583	1340	(17.887495373796554,25.75)
2584	1339	(17.021469970012117,25.75)
2585	2118	(33.042939940024233,40)
2586	1917	(32.609927238132009,36.25)
2587	2118	(33.042939940024233,40)
2588	1834	(30.011851026778693,34.75)
2589	2069	(25.681724007856502,39.25)
2590	1352	(28.279800219209818,25.75)
2591	1390	(26.114736709748719,26.5)
2592	1312	(27.846787517317598,25)
2593	1312	(27.846787517317598,25)
2594	1430	(26.54774941164094,27.25)
2595	1470	(26.114736709748719,28)
2596	1470	(26.114736709748719,28)
2597	1545	(21.784609690826528,29.5)
2598	1464	(20.918584287042091,28)
2599	1464	(20.918584287042091,28)
2600	1464	(20.918584287042091,28)
2601	1544	(20.918584287042091,29.5)
2602	1545	(21.784609690826528,29.5)
2603	1544	(20.918584287042091,29.5)
2604	1623	(20.05255888325765,31)
2605	230	(26.54774941164094,4.75)
2606	394	(30.011851026778693,7.75)
2607	394	(30.011851026778693,7.75)
2608	480	(35.208003449485325,9.25)
2609	277	(32.176914536239792,5.5)
2610	277	(32.176914536239792,5.5)
2611	360	(34.774990747593108,7)
2612	396	(31.743901834347572,7.75)
2613	960	(35.208003449485325,18.25)
2614	960	(35.208003449485325,18.25)
2615	1000	(34.774990747593108,19)
2616	277	(32.176914536239792,5.5)
2617	277	(32.176914536239792,5.5)
2618	360	(34.774990747593108,7)
2619	1694	(12.258330249197702,32.5)
2620	1898	(16.155444566227676,36.25)
2621	1772	(10.526279441628825,34)
2622	1977	(15.289419162443238,37.75)
2623	1891	(10.093266739736606,36.25)
2624	1929	(7.9282032302755088,37)
2625	1892	(10.959292143521045,36.25)
2626	1893	(11.825317547305483,36.25)
2627	1779	(16.588457268119896,34)
2628	2255	(13.124355652982141,43)
2629	1977	(15.289419162443238,37.75)
2630	1930	(8.794228634059948,37)
2631	2011	(9.6602540378443873,38.5)
2632	2041	(1.4330127018922194,39.25)
2633	2041	(1.4330127018922194,39.25)
2634	2041	(1.4330127018922194,39.25)
2635	1968	(7.49519052838329,37.75)
2636	2003	(2.7320508075688772,38.5)
2637	2004	(3.598076211353316,38.5)
2638	2003	(2.7320508075688772,38.5)
2639	1977	(15.289419162443238,37.75)
2640	1813	(11.825317547305483,34.75)
2641	1895	(13.55736835487436,36.25)
2642	2057	(15.289419162443238,39.25)
2643	1929	(7.9282032302755088,37)
2644	2060	(17.887495373796554,39.25)
2645	1779	(16.588457268119896,34)
2646	1821	(18.753520777580992,34.75)
2647	1779	(16.588457268119896,34)
2648	1779	(16.588457268119896,34)
2649	900	(17.454482671904334,17.5)
2650	1858	(15.722431864335457,35.5)
2651	1858	(15.722431864335457,35.5)
2652	1779	(16.588457268119896,34)
2653	2098	(15.722431864335457,40)
2654	1776	(13.99038105676658,34)
2655	1897	(15.289419162443238,36.25)
2656	1776	(13.99038105676658,34)
2657	1978	(16.155444566227676,37.75)
2658	1776	(13.99038105676658,34)
2659	1817	(15.289419162443238,34.75)
2660	1978	(16.155444566227676,37.75)
2661	1930	(8.794228634059948,37)
2662	1977	(15.289419162443238,37.75)
2663	1930	(8.794228634059948,37)
2664	1847	(6.196152422706632,35.5)
2665	2007	(6.196152422706632,38.5)
2666	1924	(3.598076211353316,37)
2667	2213	(11.825317547305483,42.25)
2668	2127	(6.6291651245988508,40.75)
2669	2051	(10.093266739736606,39.25)
2670	2011	(9.6602540378443873,38.5)
2671	1925	(4.4641016151377544,37)
2672	2257	(14.856406460551018,43)
2673	1925	(4.4641016151377544,37)
2674	2126	(5.7631397208144124,40.75)
2675	2086	(5.3301270189221936,40)
2676	1934	(12.258330249197702,37)
2677	2127	(6.6291651245988508,40.75)
2678	2126	(5.7631397208144124,40.75)
2679	2041	(1.4330127018922194,39.25)
2680	2041	(1.4330127018922194,39.25)
2681	2004	(3.598076211353316,38.5)
2682	2257	(14.856406460551018,43)
2683	2050	(9.2272413359521668,39.25)
2684	2127	(6.6291651245988508,40.75)
2685	1885	(4.897114317029974,36.25)
2686	2086	(5.3301270189221936,40)
2687	2007	(6.196152422706632,38.5)
2688	2086	(5.3301270189221936,40)
2689	2257	(14.856406460551018,43)
2690	2292	(10.959292143521045,43.75)
2691	2124	(4.0310889132455356,40.75)
2692	2292	(10.959292143521045,43.75)
2693	2088	(7.0621778264910704,40)
2694	2292	(10.959292143521045,43.75)
2695	1844	(3.598076211353316,35.5)
2696	2004	(3.598076211353316,38.5)
2697	2003	(2.7320508075688772,38.5)
2698	1929	(7.9282032302755088,37)
2699	2398	(33.47595264191645,45.25)
2700	2313	(29.145825622994256,43.75)
2701	2394	(30.011851026778693,45.25)
2702	2313	(29.145825622994256,43.75)
2703	2392	(28.279800219209818,45.25)
2704	2392	(28.279800219209818,45.25)
2705	1393	(28.712812921102035,26.5)
2706	2349	(25.248711305964282,44.5)
2707	2150	(26.54774941164094,40.75)
2708	2150	(26.54774941164094,40.75)
2709	1610	(8.794228634059948,31)
2710	2150	(26.54774941164094,40.75)
2711	1530	(8.794228634059948,29.5)
2712	1530	(8.794228634059948,29.5)
2713	1237	(32.176914536239792,23.5)
2714	1237	(32.176914536239792,23.5)
2715	1237	(32.176914536239792,23.5)
2716	1359	(34.341978045700891,25.75)
2717	1160	(34.774990747593108,22)
2718	1160	(34.774990747593108,22)
2719	1360	(35.208003449485325,25.75)
2720	2317	(32.609927238132009,43.75)
2721	2269	(25.248711305964282,43)
2722	2358	(33.042939940024233,44.5)
2723	1356	(31.743901834347572,25.75)
2724	396	(31.743901834347572,7.75)
2725	713	(29.145825622994256,13.75)
2726	435	(30.444863728670914,8.5)
2727	476	(31.743901834347572,9.25)
2728	395	(30.877876430563134,7.75)
2729	476	(31.743901834347572,9.25)
2730	395	(30.877876430563134,7.75)
2731	476	(31.743901834347572,9.25)
2732	277	(32.176914536239792,5.5)
2733	154	(30.011851026778693,3.25)
2734	277	(32.176914536239792,5.5)
2735	154	(30.011851026778693,3.25)
2736	360	(34.774990747593108,7)
2737	154	(30.011851026778693,3.25)
2738	277	(32.176914536239792,5.5)
2739	154	(30.011851026778693,3.25)
2740	835	(30.444863728670914,16)
2741	875	(30.877876430563134,16.75)
2742	875	(30.877876430563134,16.75)
2743	792	(28.279800219209818,15.25)
2744	796	(31.743901834347572,15.25)
2745	425	(21.784609690826528,8.5)
2746	505	(21.784609690826528,10)
2747	503	(20.05255888325765,10)
2748	505	(21.784609690826528,10)
2749	505	(21.784609690826528,10)
2750	505	(21.784609690826528,10)
2751	320	(35.208003449485325,6.25)
2752	347	(23.516660498395403,7)
2753	347	(23.516660498395403,7)
2754	347	(23.516660498395403,7)
2755	347	(23.516660498395403,7)
2756	347	(23.516660498395403,7)
2757	347	(23.516660498395403,7)
2758	1198	(33.47595264191645,22.75)
2759	1197	(32.609927238132009,22.75)
2760	347	(23.516660498395403,7)
2761	874	(30.011851026778693,16.75)
2762	505	(21.784609690826528,10)
2763	1916	(31.743901834347572,36.25)
2764	2313	(29.145825622994256,43.75)
2765	2037	(32.176914536239792,38.5)
2766	553	(29.145825622994256,10.75)
2767	395	(30.877876430563134,7.75)
2768	395	(30.877876430563134,7.75)
2769	277	(32.176914536239792,5.5)
2770	277	(32.176914536239792,5.5)
2771	277	(32.176914536239792,5.5)
2772	186	(22.650635094610966,4)
2773	347	(23.516660498395403,7)
2774	347	(23.516660498395403,7)
2775	514	(29.578838324886476,10)
2776	514	(29.578838324886476,10)
2777	347	(23.516660498395403,7)
2778	437	(32.176914536239792,8.5)
2779	277	(32.176914536239792,5.5)
2780	277	(32.176914536239792,5.5)
2781	277	(32.176914536239792,5.5)
2782	278	(33.042939940024233,5.5)
2783	80	(35.208003449485325,1.75)
2784	80	(35.208003449485325,1.75)
2785	197	(32.176914536239792,4)
2786	80	(35.208003449485325,1.75)
2787	1352	(28.279800219209818,25.75)
2788	1390	(26.114736709748719,26.5)
2789	1312	(27.846787517317598,25)
2790	1312	(27.846787517317598,25)
2791	1430	(26.54774941164094,27.25)
2792	1470	(26.114736709748719,28)
2793	1470	(26.114736709748719,28)
2794	1464	(20.918584287042091,28)
2795	1464	(20.918584287042091,28)
2796	1504	(21.351596988934308,28.75)
2797	1544	(20.918584287042091,29.5)
2798	1545	(21.784609690826528,29.5)
2799	1544	(20.918584287042091,29.5)
2800	1623	(20.05255888325765,31)
2801	511	(26.98076211353316,10)
2802	511	(26.98076211353316,10)
2803	186	(22.650635094610966,4)
2804	398	(33.47595264191645,7.75)
2805	186	(22.650635094610966,4)
2806	277	(32.176914536239792,5.5)
2807	360	(34.774990747593108,7)
2808	277	(32.176914536239792,5.5)
2809	277	(32.176914536239792,5.5)
2810	277	(32.176914536239792,5.5)
2811	277	(32.176914536239792,5.5)
2812	277	(32.176914536239792,5.5)
2813	277	(32.176914536239792,5.5)
2814	277	(32.176914536239792,5.5)
2815	277	(32.176914536239792,5.5)
2816	993	(28.712812921102035,19)
2817	551	(27.413774815425377,10.75)
2818	511	(26.98076211353316,10)
2819	514	(29.578838324886476,10)
2820	514	(29.578838324886476,10)
2821	514	(29.578838324886476,10)
2822	395	(30.877876430563134,7.75)
2823	398	(33.47595264191645,7.75)
2824	317	(32.609927238132009,6.25)
2825	277	(32.176914536239792,5.5)
2826	399	(34.341978045700891,7.75)
2827	277	(32.176914536239792,5.5)
2828	277	(32.176914536239792,5.5)
2829	1753	(29.145825622994256,33.25)
2830	158	(33.47595264191645,3.25)
2831	158	(33.47595264191645,3.25)
2832	158	(33.47595264191645,3.25)
2833	158	(33.47595264191645,3.25)
2834	158	(33.47595264191645,3.25)
2835	197	(32.176914536239792,4)
2836	1715	(30.444863728670914,32.5)
2837	1676	(31.743901834347572,31.75)
2838	1718	(33.042939940024233,32.5)
2839	1759	(34.341978045700891,33.25)
2840	1720	(34.774990747593108,32.5)
2841	391	(27.413774815425377,7.75)
2842	391	(27.413774815425377,7.75)
2843	391	(27.413774815425377,7.75)
2844	389	(25.681724007856502,7.75)
2845	352	(27.846787517317598,7)
2846	37	(32.176914536239792,1)
2847	37	(32.176914536239792,1)
2848	80	(35.208003449485325,1.75)
2849	80	(35.208003449485325,1.75)
2850	80	(35.208003449485325,1.75)
2851	80	(35.208003449485325,1.75)
2852	197	(32.176914536239792,4)
2853	993	(28.712812921102035,19)
2854	1394	(29.578838324886476,26.5)
2855	1473	(28.712812921102035,28)
2856	1427	(23.949673200287624,27.25)
2857	1197	(32.609927238132009,22.75)
2858	1158	(33.042939940024233,22)
2859	1158	(33.042939940024233,22)
2860	230	(26.54774941164094,4.75)
2861	230	(26.54774941164094,4.75)
2862	230	(26.54774941164094,4.75)
2863	277	(32.176914536239792,5.5)
2864	439	(33.908965343808667,8.5)
2865	513	(28.712812921102035,10)
2866	513	(28.712812921102035,10)
2867	277	(32.176914536239792,5.5)
2868	320	(35.208003449485325,6.25)
2869	1476	(31.310889132455351,28)
2870	1753	(29.145825622994256,33.25)
2871	1715	(30.444863728670914,32.5)
2872	1718	(33.042939940024233,32.5)
2873	1759	(34.341978045700891,33.25)
2874	1427	(23.949673200287624,27.25)
2875	469	(25.681724007856502,9.25)
2876	1033	(29.145825622994256,19.75)
2877	469	(25.681724007856502,9.25)
2878	469	(25.681724007856502,9.25)
2879	586	(22.650635094610966,11.5)
2880	586	(22.650635094610966,11.5)
2881	664	(20.918584287042091,13)
2882	622	(19.619546181365433,12.25)
2883	701	(18.753520777580992,13.75)
2884	416	(13.99038105676658,8.5)
2885	617	(15.289419162443238,12.25)
2886	617	(15.289419162443238,12.25)
2887	1106	(23.083647796503186,21.25)
2888	866	(23.083647796503186,16.75)
2889	866	(23.083647796503186,16.75)
2890	1098	(16.155444566227676,21.25)
2891	1026	(23.083647796503186,19.75)
2892	618	(16.155444566227676,12.25)
2893	1068	(24.382685902179844,20.5)
2894	2279	(33.908965343808667,43)
2895	2200	(34.774990747593108,41.5)
2896	2357	(32.176914536239792,44.5)
2897	2399	(34.341978045700891,45.25)
2898	485	(4.4641016151377544,10)
2899	1091	(10.093266739736606,21.25)
2900	601	(1.4330127018922194,12.25)
2901	664	(20.918584287042091,13)
2902	652	(10.526279441628825,13)
2903	1545	(21.784609690826528,29.5)
2904	814	(12.258330249197702,16)
2905	2188	(24.382685902179844,41.5)
2906	2150	(26.54774941164094,40.75)
2907	893	(11.392304845413264,17.5)
2908	130	(9.2272413359521668,3.25)
2909	2226	(23.083647796503186,42.25)
2910	814	(12.258330249197702,16)
2911	895	(13.124355652982141,17.5)
2912	1993	(29.145825622994256,37.75)
2913	943	(20.48557158514987,18.25)
2914	1315	(30.444863728670914,25)
2915	1153	(28.712812921102035,22)
2916	1219	(16.588457268119896,23.5)
2917	2376	(14.423393758658799,45.25)
2918	2376	(14.423393758658799,45.25)
2919	2337	(14.856406460551018,44.5)
2920	2374	(12.691342951089922,45.25)
2921	1831	(27.413774815425377,34.75)
2922	1534	(12.258330249197702,29.5)
2923	2250	(8.794228634059948,43)
2924	1905	(22.217622392718749,36.25)
2925	2225	(22.217622392718749,42.25)
2926	1670	(26.54774941164094,31.75)
2927	1670	(26.54774941164094,31.75)
2928	1669	(25.681724007856502,31.75)
2929	1761	(1,34)
2930	1761	(1,34)
2931	1706	(22.650635094610966,32.5)
2932	1705	(21.784609690826528,32.5)
2933	1670	(26.54774941164094,31.75)
2934	1627	(23.516660498395403,31)
2935	1743	(20.48557158514987,33.25)
2936	1664	(21.351596988934308,31.75)
2937	2330	(8.794228634059948,44.5)
2938	1705	(21.784609690826528,32.5)
2939	1960	(34.774990747593108,37)
2940	2040	(34.774990747593108,38.5)
2941	1957	(32.176914536239792,37)
2942	1957	(32.176914536239792,37)
2943	2194	(29.578838324886476,41.5)
2944	1957	(32.176914536239792,37)
2945	617	(15.289419162443238,12.25)
2946	617	(15.289419162443238,12.25)
2947	2040	(34.774990747593108,38.5)
2948	1917	(32.609927238132009,36.25)
2949	1234	(29.578838324886476,23.5)
2950	1620	(17.454482671904334,31)
2951	2364	(4.0310889132455356,45.25)
2952	2365	(4.897114317029974,45.25)
2953	2301	(18.753520777580992,43.75)
2954	2262	(19.186533479473212,43)
2955	2262	(19.186533479473212,43)
2956	2364	(4.0310889132455356,45.25)
2957	2364	(4.0310889132455356,45.25)
2958	2367	(6.6291651245988508,45.25)
2959	2367	(6.6291651245988508,45.25)
2960	2367	(6.6291651245988508,45.25)
2961	2339	(16.588457268119896,44.5)
2962	2379	(17.021469970012117,45.25)
2963	2299	(17.021469970012117,43.75)
2964	2367	(6.6291651245988508,45.25)
2965	2367	(6.6291651245988508,45.25)
2966	2201	(1.4330127018922194,42.25)
2967	2201	(1.4330127018922194,42.25)
2968	2242	(1.8660254037844386,43)
2969	2201	(1.4330127018922194,42.25)
2970	2388	(24.815698604072061,45.25)
2971	2348	(24.382685902179844,44.5)
2972	2389	(25.681724007856502,45.25)
2973	2285	(4.897114317029974,43.75)
2974	2388	(24.815698604072061,45.25)
2975	2261	(18.320508075688775,43)
2976	2299	(17.021469970012117,43.75)
2977	2347	(23.516660498395403,44.5)
2978	2260	(17.454482671904334,43)
2979	2339	(16.588457268119896,44.5)
2980	2307	(23.949673200287624,43.75)
2981	2262	(19.186533479473212,43)
2982	2262	(19.186533479473212,43)
2983	2340	(17.454482671904334,44.5)
2984	2306	(23.083647796503186,43.75)
2985	2342	(19.186533479473212,44.5)
2986	2379	(17.021469970012117,45.25)
2987	2380	(17.887495373796554,45.25)
2988	2340	(17.454482671904334,44.5)
2989	2385	(22.217622392718749,45.25)
2990	2358	(33.042939940024233,44.5)
2991	2358	(33.042939940024233,44.5)
2992	2367	(6.6291651245988508,45.25)
2993	2367	(6.6291651245988508,45.25)
2994	1237	(32.176914536239792,23.5)
2995	1439	(34.341978045700891,27.25)
2996	1519	(34.341978045700891,28.75)
2997	38	(33.042939940024233,1)
2998	38	(33.042939940024233,1)
2999	38	(33.042939940024233,1)
3000	37	(32.176914536239792,1)
3001	1614	(12.258330249197702,31)
3002	693	(11.825317547305483,13.75)
3003	1834	(30.011851026778693,34.75)
3004	1947	(23.516660498395403,37)
3005	1911	(27.413774815425377,36.25)
3006	1873	(28.712812921102035,35.5)
3007	1684	(3.598076211353316,32.5)
3008	1684	(3.598076211353316,32.5)
3009	1725	(4.897114317029974,33.25)
3010	1868	(24.382685902179844,35.5)
3011	1620	(17.454482671904334,31)
3012	175	(13.124355652982141,4)
3013	94	(12.258330249197702,2.5)
3014	175	(13.124355652982141,4)
3015	13	(11.392304845413264,1)
3016	13	(11.392304845413264,1)
3017	13	(11.392304845413264,1)
3018	13	(11.392304845413264,1)
3019	214	(12.691342951089922,4.75)
3020	737	(14.856406460551018,14.5)
3021	487	(6.196152422706632,10)
3022	1356	(31.743901834347572,25.75)
3023	788	(24.815698604072061,15.25)
3024	827	(23.516660498395403,16)
3025	827	(23.516660498395403,16)
3026	786	(23.083647796503186,15.25)
3027	1904	(21.351596988934308,36.25)
3028	1527	(6.196152422706632,29.5)
3029	1641	(1.4330127018922194,31.75)
3030	1602	(1.8660254037844386,31)
3031	2400	(35.208003449485325,45.25)
3032	88	(7.0621778264910704,2.5)
3033	88	(7.0621778264910704,2.5)
3034	82	(1.8660254037844386,2.5)
3035	4	(3.598076211353316,1)
3036	4	(3.598076211353316,1)
3037	43	(3.1650635094610968,1.75)
3038	341	(18.320508075688775,7)
3039	339	(16.588457268119896,7)
3040	1051	(9.6602540378443873,20.5)
3041	851	(10.093266739736606,16.75)
3042	2103	(20.05255888325765,40)
3043	721	(1,14.5)
3044	2064	(21.351596988934308,39.25)
3045	931	(10.093266739736606,18.25)
3046	2104	(20.918584287042091,40)
3047	931	(10.093266739736606,18.25)
3048	887	(6.196152422706632,17.5)
3049	2104	(20.918584287042091,40)
3050	1240	(34.774990747593108,23.5)
3051	1360	(35.208003449485325,25.75)
3052	1597	(32.609927238132009,30.25)
3053	1600	(35.208003449485325,30.25)
3054	1725	(4.897114317029974,33.25)
3055	2397	(32.609927238132009,45.25)
3056	2397	(32.609927238132009,45.25)
3057	1724	(4.0310889132455356,33.25)
3058	1724	(4.0310889132455356,33.25)
3059	339	(16.588457268119896,7)
3060	339	(16.588457268119896,7)
3061	339	(16.588457268119896,7)
3062	731	(9.6602540378443873,14.5)
3063	2328	(7.0621778264910704,44.5)
3064	2154	(30.011851026778693,40.75)
3065	2233	(29.145825622994256,42.25)
3066	357	(32.176914536239792,7)
3067	438	(33.042939940024233,8.5)
3068	1240	(34.774990747593108,23.5)
3069	1360	(35.208003449485325,25.75)
3070	1597	(32.609927238132009,30.25)
3071	1600	(35.208003449485325,30.25)
3072	1366	(5.3301270189221936,26.5)
3073	885	(4.4641016151377544,17.5)
3074	1601	(1,31)
3075	1587	(23.949673200287624,30.25)
3076	1761	(1,34)
3077	1743	(20.48557158514987,33.25)
3078	1626	(22.650635094610966,31)
3079	1664	(21.351596988934308,31.75)
3080	1664	(21.351596988934308,31.75)
3081	278	(33.042939940024233,5.5)
3082	1683	(2.7320508075688772,32.5)
3083	1751	(27.413774815425377,33.25)
3084	1152	(27.846787517317598,22)
3085	1219	(16.588457268119896,23.5)
3086	1751	(27.413774815425377,33.25)
3087	2091	(9.6602540378443873,40)
3088	2123	(3.1650635094610968,40.75)
3089	2006	(5.3301270189221936,38.5)
3090	2366	(5.7631397208144124,45.25)
3091	2202	(2.299038105676658,42.25)
3092	2324	(3.598076211353316,44.5)
3093	2324	(3.598076211353316,44.5)
3094	2060	(17.887495373796554,39.25)
3095	2141	(18.753520777580992,40.75)
3096	2194	(29.578838324886476,41.5)
3097	2194	(29.578838324886476,41.5)
3098	2040	(34.774990747593108,38.5)
3099	2040	(34.774990747593108,38.5)
3100	2118	(33.042939940024233,40)
3101	2040	(34.774990747593108,38.5)
3102	2040	(34.774990747593108,38.5)
3103	1891	(10.093266739736606,36.25)
3104	1779	(16.588457268119896,34)
3105	1930	(8.794228634059948,37)
3106	2011	(9.6602540378443873,38.5)
3107	2011	(9.6602540378443873,38.5)
3108	1895	(13.55736835487436,36.25)
3109	900	(17.454482671904334,17.5)
3110	1858	(15.722431864335457,35.5)
3111	1857	(14.856406460551018,35.5)
3112	1977	(15.289419162443238,37.75)
3113	1847	(6.196152422706632,35.5)
3114	2051	(10.093266739736606,39.25)
3115	2007	(6.196152422706632,38.5)
3116	2051	(10.093266739736606,39.25)
3117	2011	(9.6602540378443873,38.5)
3118	2127	(6.6291651245988508,40.75)
3119	2171	(9.6602540378443873,41.5)
3120	2088	(7.0621778264910704,40)
3121	1977	(15.289419162443238,37.75)
3122	2006	(5.3301270189221936,38.5)
3123	2098	(15.722431864335457,40)
3124	1934	(12.258330249197702,37)
3125	2098	(15.722431864335457,40)
3126	2137	(15.289419162443238,40.75)
3127	2137	(15.289419162443238,40.75)
3128	2136	(14.423393758658799,40.75)
3129	2016	(13.99038105676658,38.5)
3130	1934	(12.258330249197702,37)
3131	1683	(2.7320508075688772,32.5)
3132	1683	(2.7320508075688772,32.5)
3133	1602	(1.8660254037844386,31)
3134	1487	(6.6291651245988508,28.75)
3135	1487	(6.6291651245988508,28.75)
3136	1602	(1.8660254037844386,31)
3137	1090	(9.2272413359521668,21.25)
3138	1090	(9.2272413359521668,21.25)
3139	1050	(8.794228634059948,20.5)
3140	1090	(9.2272413359521668,21.25)
3141	568	(7.0621778264910704,11.5)
3142	1172	(10.959292143521045,22.75)
3143	487	(6.196152422706632,10)
3144	485	(4.4641016151377544,10)
3145	1089	(8.3612159321677293,21.25)
3146	1323	(3.1650635094610968,25.75)
3147	1322	(2.299038105676658,25.75)
3148	1322	(2.299038105676658,25.75)
3149	1282	(1.8660254037844386,25)
3150	1162	(2.299038105676658,22.75)
3151	1162	(2.299038105676658,22.75)
3152	1162	(2.299038105676658,22.75)
3153	1162	(2.299038105676658,22.75)
3154	1161	(1.4330127018922194,22.75)
3155	1161	(1.4330127018922194,22.75)
3156	1161	(1.4330127018922194,22.75)
3157	1161	(1.4330127018922194,22.75)
3158	1121	(1,22)
3159	1121	(1,22)
3160	1121	(1,22)
3161	1121	(1,22)
3162	1121	(1,22)
3163	1282	(1.8660254037844386,25)
3164	1281	(1,25)
3165	1161	(1.4330127018922194,22.75)
3166	446	(5.7631397208144124,9.25)
3167	1401	(1.4330127018922194,27.25)
3168	483	(2.7320508075688772,10)
3169	492	(10.526279441628825,10)
3170	446	(5.7631397208144124,9.25)
3171	1121	(1,22)
3172	890	(8.794228634059948,17.5)
3173	850	(9.2272413359521668,16.75)
3174	889	(7.9282032302755088,17.5)
3175	1205	(4.4641016151377544,23.5)
3176	2104	(20.918584287042091,40)
3177	1911	(27.413774815425377,36.25)
3178	1494	(12.691342951089922,28.75)
3179	570	(8.794228634059948,11.5)
3180	2104	(20.918584287042091,40)
3181	771	(10.093266739736606,15.25)
3182	1602	(1.8660254037844386,31)
3183	2064	(21.351596988934308,39.25)
3184	1949	(25.248711305964282,37)
3185	1949	(25.248711305964282,37)
3186	1949	(25.248711305964282,37)
3187	1947	(23.516660498395403,37)
3188	1946	(22.650635094610966,37)
3189	1985	(22.217622392718749,37.75)
3190	1161	(1.4330127018922194,22.75)
3191	1947	(23.516660498395403,37)
3192	1683	(2.7320508075688772,32.5)
3193	1161	(1.4330127018922194,22.75)
3194	1001	(1.4330127018922194,19.75)
3195	1121	(1,22)
3196	320	(35.208003449485325,6.25)
3197	105	(21.784609690826528,2.5)
3198	105	(21.784609690826528,2.5)
3199	2104	(20.918584287042091,40)
3200	2395	(30.877876430563134,45.25)
3201	560	(35.208003449485325,10.75)
3202	560	(35.208003449485325,10.75)
3203	960	(35.208003449485325,18.25)
3204	320	(35.208003449485325,6.25)
3205	320	(35.208003449485325,6.25)
3206	318	(33.47595264191645,6.25)
3207	320	(35.208003449485325,6.25)
3208	28	(24.382685902179844,1)
3209	320	(35.208003449485325,6.25)
3210	105	(21.784609690826528,2.5)
3211	28	(24.382685902179844,1)
3212	320	(35.208003449485325,6.25)
3213	24	(20.918584287042091,1)
3214	105	(21.784609690826528,2.5)
3215	105	(21.784609690826528,2.5)
3216	24	(20.918584287042091,1)
3217	105	(21.784609690826528,2.5)
3218	320	(35.208003449485325,6.25)
3219	105	(21.784609690826528,2.5)
3220	319	(34.341978045700891,6.25)
3221	396	(31.743901834347572,7.75)
3222	36	(31.310889132455351,1)
3223	396	(31.743901834347572,7.75)
3224	475	(30.877876430563134,9.25)
3225	477	(32.609927238132009,9.25)
3226	477	(32.609927238132009,9.25)
3227	438	(33.042939940024233,8.5)
3228	320	(35.208003449485325,6.25)
3229	398	(33.47595264191645,7.75)
3230	398	(33.47595264191645,7.75)
3231	398	(33.47595264191645,7.75)
3232	28	(24.382685902179844,1)
3233	37	(32.176914536239792,1)
3234	37	(32.176914536239792,1)
3235	36	(31.310889132455351,1)
3236	479	(34.341978045700891,9.25)
3237	320	(35.208003449485325,6.25)
3238	396	(31.743901834347572,7.75)
3239	398	(33.47595264191645,7.75)
3240	398	(33.47595264191645,7.75)
3241	439	(33.908965343808667,8.5)
3242	320	(35.208003449485325,6.25)
3243	37	(32.176914536239792,1)
3244	37	(32.176914536239792,1)
3245	36	(31.310889132455351,1)
3246	439	(33.908965343808667,8.5)
3247	560	(35.208003449485325,10.75)
3248	398	(33.47595264191645,7.75)
3249	398	(33.47595264191645,7.75)
3250	398	(33.47595264191645,7.75)
3251	439	(33.908965343808667,8.5)
3252	320	(35.208003449485325,6.25)
3253	560	(35.208003449485325,10.75)
3254	560	(35.208003449485325,10.75)
3255	560	(35.208003449485325,10.75)
3256	960	(35.208003449485325,18.25)
3257	560	(35.208003449485325,10.75)
3258	560	(35.208003449485325,10.75)
3259	560	(35.208003449485325,10.75)
3260	960	(35.208003449485325,18.25)
3261	1476	(31.310889132455351,28)
3262	1753	(29.145825622994256,33.25)
3263	1715	(30.444863728670914,32.5)
3264	1718	(33.042939940024233,32.5)
3265	1760	(35.208003449485325,33.25)
3266	560	(35.208003449485325,10.75)
3267	560	(35.208003449485325,10.75)
3268	560	(35.208003449485325,10.75)
3269	960	(35.208003449485325,18.25)
3270	1680	(35.208003449485325,31.75)
3271	1197	(32.609927238132009,22.75)
3272	1197	(32.609927238132009,22.75)
3273	840	(34.774990747593108,16)
3274	960	(35.208003449485325,18.25)
3275	21	(18.320508075688775,1)
3276	60	(17.887495373796554,1.75)
3277	18	(15.722431864335457,1)
3278	175	(13.124355652982141,4)
3279	10	(8.794228634059948,1)
3280	173	(11.392304845413264,4)
3281	175	(13.124355652982141,4)
3282	215	(13.55736835487436,4.75)
3283	13	(11.392304845413264,1)
3284	13	(11.392304845413264,1)
3285	13	(11.392304845413264,1)
3286	133	(11.825317547305483,3.25)
3287	13	(11.392304845413264,1)
3288	214	(12.691342951089922,4.75)
3289	13	(11.392304845413264,1)
3290	788	(24.815698604072061,15.25)
3291	785	(22.217622392718749,15.25)
3292	785	(22.217622392718749,15.25)
3293	785	(22.217622392718749,15.25)
3294	960	(35.208003449485325,18.25)
3295	283	(3.1650635094610968,6.25)
3296	7	(6.196152422706632,1)
3297	7	(6.196152422706632,1)
3298	7	(6.196152422706632,1)
3299	82	(1.8660254037844386,2.5)
3300	82	(1.8660254037844386,2.5)
3301	124	(4.0310889132455356,3.25)
3302	82	(1.8660254037844386,2.5)
3303	960	(35.208003449485325,18.25)
3304	760	(34.774990747593108,14.5)
3305	794	(30.011851026778693,15.25)
3306	835	(30.444863728670914,16)
3307	792	(28.279800219209818,15.25)
3308	791	(27.413774815425377,15.25)
3309	834	(29.578838324886476,16)
3310	751	(26.98076211353316,14.5)
3311	792	(28.279800219209818,15.25)
3312	792	(28.279800219209818,15.25)
3313	423	(20.05255888325765,8.5)
3314	505	(21.784609690826528,10)
3315	24	(20.918584287042091,1)
3316	63	(20.48557158514987,1.75)
3317	2283	(3.1650635094610968,43.75)
3318	21	(18.320508075688775,1)
3319	60	(17.887495373796554,1.75)
3320	19	(16.588457268119896,1)
3321	175	(13.124355652982141,4)
3322	10	(8.794228634059948,1)
3323	133	(11.825317547305483,3.25)
3324	175	(13.124355652982141,4)
3325	175	(13.124355652982141,4)
3326	18	(15.722431864335457,1)
3327	178	(15.722431864335457,4)
3328	302	(19.619546181365433,6.25)
3329	358	(33.042939940024233,7)
3330	358	(33.042939940024233,7)
3331	318	(33.47595264191645,6.25)
3332	1783	(20.05255888325765,34)
3333	1743	(20.48557158514987,33.25)
3334	318	(33.47595264191645,6.25)
3335	1480	(34.774990747593108,28)
3336	1709	(25.248711305964282,32.5)
3337	1783	(20.05255888325765,34)
3338	720	(35.208003449485325,13.75)
3339	1743	(20.48557158514987,33.25)
3340	1743	(20.48557158514987,33.25)
3341	1743	(20.48557158514987,33.25)
3342	1743	(20.48557158514987,33.25)
3343	1743	(20.48557158514987,33.25)
3344	1463	(20.05255888325765,28)
3345	1662	(19.619546181365433,31.75)
3346	1662	(19.619546181365433,31.75)
3347	485	(4.4641016151377544,10)
3348	1253	(11.825317547305483,24.25)
3349	1632	(27.846787517317598,31)
3350	1448	(7.0621778264910704,28)
3351	1547	(23.516660498395403,29.5)
3352	1390	(26.114736709748719,26.5)
3353	1470	(26.114736709748719,28)
3354	1470	(26.114736709748719,28)
3355	1424	(21.351596988934308,27.25)
3356	1464	(20.918584287042091,28)
3357	1623	(20.05255888325765,31)
3358	1393	(28.712812921102035,26.5)
3359	1591	(27.413774815425377,30.25)
3360	1623	(20.05255888325765,31)
3361	1374	(12.258330249197702,26.5)
3362	444	(4.0310889132455356,9.25)
3363	1547	(23.516660498395403,29.5)
3364	1507	(23.949673200287624,28.75)
3365	1594	(30.011851026778693,30.25)
3366	1448	(7.0621778264910704,28)
3367	1298	(15.722431864335457,25)
3368	1160	(34.774990747593108,22)
3369	1160	(34.774990747593108,22)
3370	1160	(34.774990747593108,22)
3371	1400	(34.774990747593108,26.5)
3372	2317	(32.609927238132009,43.75)
3373	2269	(25.248711305964282,43)
3374	2358	(33.042939940024233,44.5)
3375	1356	(31.743901834347572,25.75)
3376	2317	(32.609927238132009,43.75)
3377	2311	(27.413774815425377,43.75)
3378	1716	(31.310889132455351,32.5)
3379	1758	(33.47595264191645,33.25)
3380	1680	(35.208003449485325,31.75)
3381	1258	(16.155444566227676,24.25)
3382	1306	(22.650635094610966,25)
3383	1306	(22.650635094610966,25)
3384	737	(14.856406460551018,14.5)
3385	1306	(22.650635094610966,25)
3386	1680	(35.208003449485325,31.75)
3387	2035	(30.444863728670914,38.5)
3388	1990	(26.54774941164094,37.75)
3389	1643	(3.1650635094610968,31.75)
3390	1990	(26.54774941164094,37.75)
3391	1562	(2.299038105676658,30.25)
3392	1521	(1,29.5)
3393	1521	(1,29.5)
3394	1521	(1,29.5)
3395	1481	(1.4330127018922194,28.75)
3396	1612	(10.526279441628825,31)
3397	1990	(26.54774941164094,37.75)
3398	1990	(26.54774941164094,37.75)
3399	2395	(30.877876430563134,45.25)
3400	1872	(27.846787517317598,35.5)
3401	2026	(22.650635094610966,38.5)
3402	1481	(1.4330127018922194,28.75)
3403	1990	(26.54774941164094,37.75)
3404	1990	(26.54774941164094,37.75)
3405	2159	(34.341978045700891,40.75)
3406	1989	(25.681724007856502,37.75)
3407	1955	(30.444863728670914,37)
3408	1613	(11.392304845413264,31)
3409	2159	(34.341978045700891,40.75)
3410	1990	(26.54774941164094,37.75)
3411	1990	(26.54774941164094,37.75)
3412	2157	(32.609927238132009,40.75)
3413	2117	(32.176914536239792,40)
3414	2157	(32.609927238132009,40.75)
3415	2194	(29.578838324886476,41.5)
3416	2154	(30.011851026778693,40.75)
3417	2154	(30.011851026778693,40.75)
3418	2150	(26.54774941164094,40.75)
3419	2189	(25.248711305964282,41.5)
3420	2188	(24.382685902179844,41.5)
3421	2150	(26.54774941164094,40.75)
3422	1957	(32.176914536239792,37)
3423	1907	(23.949673200287624,36.25)
3424	1765	(4.4641016151377544,34)
3425	2200	(34.774990747593108,41.5)
3426	1911	(27.413774815425377,36.25)
3427	1949	(25.248711305964282,37)
3428	1949	(25.248711305964282,37)
3429	1724	(4.0310889132455356,33.25)
3430	1949	(25.248711305964282,37)
3431	1947	(23.516660498395403,37)
3432	2104	(20.918584287042091,40)
3433	1240	(34.774990747593108,23.5)
3434	1240	(34.774990747593108,23.5)
3435	1400	(34.774990747593108,26.5)
3436	1597	(32.609927238132009,30.25)
3437	1598	(33.47595264191645,30.25)
3438	1520	(35.208003449485325,28.75)
3439	1715	(30.444863728670914,32.5)
3440	1718	(33.042939940024233,32.5)
3441	1680	(35.208003449485325,31.75)
3442	438	(33.042939940024233,8.5)
3443	438	(33.042939940024233,8.5)
3444	438	(33.042939940024233,8.5)
3445	320	(35.208003449485325,6.25)
3446	398	(33.47595264191645,7.75)
3447	398	(33.47595264191645,7.75)
3448	398	(33.47595264191645,7.75)
3449	320	(35.208003449485325,6.25)
3450	396	(31.743901834347572,7.75)
3451	105	(21.784609690826528,2.5)
3452	26	(22.650635094610966,1)
3453	1598	(33.47595264191645,30.25)
3454	2027	(23.516660498395403,38.5)
3455	885	(4.4641016151377544,17.5)
3456	1715	(30.444863728670914,32.5)
3457	1718	(33.042939940024233,32.5)
3458	1680	(35.208003449485325,31.75)
3459	1600	(35.208003449485325,30.25)
3460	1119	(34.341978045700891,21.25)
3461	1119	(34.341978045700891,21.25)
3462	1119	(34.341978045700891,21.25)
3463	720	(35.208003449485325,13.75)
3464	1480	(34.774990747593108,28)
3465	720	(35.208003449485325,13.75)
3466	1600	(35.208003449485325,30.25)
3467	320	(35.208003449485325,6.25)
3468	319	(34.341978045700891,6.25)
3469	26	(22.650635094610966,1)
3470	319	(34.341978045700891,6.25)
3471	28	(24.382685902179844,1)
3472	319	(34.341978045700891,6.25)
3473	320	(35.208003449485325,6.25)
3474	319	(34.341978045700891,6.25)
3475	600	(34.774990747593108,11.5)
3476	560	(35.208003449485325,10.75)
3477	560	(35.208003449485325,10.75)
3478	600	(34.774990747593108,11.5)
3479	1724	(4.0310889132455356,33.25)
3480	478	(33.47595264191645,9.25)
3481	320	(35.208003449485325,6.25)
3482	320	(35.208003449485325,6.25)
3483	320	(35.208003449485325,6.25)
3484	1989	(25.681724007856502,37.75)
3485	2156	(31.743901834347572,40.75)
3486	665	(21.784609690826528,13)
3487	661	(18.320508075688775,13)
3488	701	(18.753520777580992,13.75)
3489	743	(20.05255888325765,14.5)
3490	2117	(32.176914536239792,40)
3491	537	(15.289419162443238,10.75)
3492	320	(35.208003449485325,6.25)
3493	2159	(34.341978045700891,40.75)
3494	1626	(22.650635094610966,31)
3495	1626	(22.650635094610966,31)
3496	1626	(22.650635094610966,31)
3497	1626	(22.650635094610966,31)
3498	1519	(34.341978045700891,28.75)
3499	1519	(34.341978045700891,28.75)
3500	320	(35.208003449485325,6.25)
3501	2104	(20.918584287042091,40)
3502	1481	(1.4330127018922194,28.75)
3503	320	(35.208003449485325,6.25)
3504	320	(35.208003449485325,6.25)
3505	1526	(5.3301270189221936,29.5)
3506	1565	(4.897114317029974,30.25)
3507	1525	(4.4641016151377544,29.5)
3508	2200	(34.774990747593108,41.5)
3509	814	(12.258330249197702,16)
3510	814	(12.258330249197702,16)
3511	2279	(33.908965343808667,43)
3512	1623	(20.05255888325765,31)
3513	1547	(23.516660498395403,29.5)
3514	2400	(35.208003449485325,45.25)
3515	1355	(30.877876430563134,25.75)
3516	2357	(32.176914536239792,44.5)
3517	2399	(34.341978045700891,45.25)
3518	1393	(28.712812921102035,26.5)
3519	1623	(20.05255888325765,31)
3520	1464	(20.918584287042091,28)
3521	1424	(21.351596988934308,27.25)
3522	1470	(26.114736709748719,28)
3523	1470	(26.114736709748719,28)
3524	1390	(26.114736709748719,26.5)
3525	1547	(23.516660498395403,29.5)
3526	772	(10.959292143521045,15.25)
3527	973	(11.392304845413264,19)
3528	1547	(23.516660498395403,29.5)
3529	936	(14.423393758658799,18.25)
3530	1135	(13.124355652982141,22)
3531	1054	(12.258330249197702,20.5)
3532	938	(16.155444566227676,18.25)
3533	938	(16.155444566227676,18.25)
3534	1057	(14.856406460551018,20.5)
3535	1054	(12.258330249197702,20.5)
3536	1507	(23.949673200287624,28.75)
3537	26	(22.650635094610966,1)
3538	704	(21.351596988934308,13.75)
3539	1055	(13.124355652982141,20.5)
3540	2105	(21.784609690826528,40)
3541	978	(15.722431864335457,19)
3542	936	(14.423393758658799,18.25)
3543	1098	(16.155444566227676,21.25)
3544	2104	(20.918584287042091,40)
3545	856	(14.423393758658799,16.75)
3546	855	(13.55736835487436,16.75)
3547	734	(12.258330249197702,14.5)
3548	734	(12.258330249197702,14.5)
3549	734	(12.258330249197702,14.5)
3550	1152	(27.846787517317598,22)
3551	1220	(17.454482671904334,23.5)
3552	1220	(17.454482671904334,23.5)
3553	1147	(23.516660498395403,22)
3554	1145	(21.784609690826528,22)
3555	1104	(21.351596988934308,21.25)
3556	1023	(20.48557158514987,19.75)
3557	866	(23.083647796503186,16.75)
3558	1098	(16.155444566227676,21.25)
3559	2337	(14.856406460551018,44.5)
3560	2370	(9.2272413359521668,45.25)
3561	2370	(9.2272413359521668,45.25)
3562	1701	(18.320508075688775,32.5)
3563	2337	(14.856406460551018,44.5)
3564	1538	(15.722431864335457,29.5)
3565	1619	(16.588457268119896,31)
3566	1620	(17.454482671904334,31)
3567	1620	(17.454482671904334,31)
3568	1579	(17.021469970012117,30.25)
3569	1620	(17.454482671904334,31)
3570	1620	(17.454482671904334,31)
3571	1620	(17.454482671904334,31)
3572	2337	(14.856406460551018,44.5)
3573	2333	(11.392304845413264,44.5)
3574	1811	(10.093266739736606,34.75)
3575	2127	(6.6291651245988508,40.75)
3576	1779	(16.588457268119896,34)
3577	1779	(16.588457268119896,34)
3578	1863	(20.05255888325765,35.5)
3579	1892	(10.959292143521045,36.25)
3580	1779	(16.588457268119896,34)
3581	1821	(18.753520777580992,34.75)
3582	2178	(15.722431864335457,41.5)
3583	1977	(15.289419162443238,37.75)
3584	1821	(18.753520777580992,34.75)
3585	2048	(7.49519052838329,39.25)
3586	2049	(8.3612159321677293,39.25)
3587	2127	(6.6291651245988508,40.75)
3588	1968	(7.49519052838329,37.75)
3589	2137	(15.289419162443238,40.75)
3590	2051	(10.093266739736606,39.25)
3591	1891	(10.093266739736606,36.25)
3592	2136	(14.423393758658799,40.75)
3593	2090	(8.794228634059948,40)
3594	2170	(8.794228634059948,41.5)
3595	1924	(3.598076211353316,37)
3596	2050	(9.2272413359521668,39.25)
3597	1924	(3.598076211353316,37)
3598	2213	(11.825317547305483,42.25)
3599	2011	(9.6602540378443873,38.5)
3600	2007	(6.196152422706632,38.5)
3601	2170	(8.794228634059948,41.5)
3602	1937	(14.856406460551018,37)
3603	1924	(3.598076211353316,37)
3604	2050	(9.2272413359521668,39.25)
3605	2170	(8.794228634059948,41.5)
3606	2047	(6.6291651245988508,39.25)
3607	2048	(7.49519052838329,39.25)
3608	2127	(6.6291651245988508,40.75)
3609	2293	(11.825317547305483,43.75)
3610	2053	(11.825317547305483,39.25)
3611	2136	(14.423393758658799,40.75)
3612	2170	(8.794228634059948,41.5)
3613	2011	(9.6602540378443873,38.5)
3614	2255	(13.124355652982141,43)
3615	2257	(14.856406460551018,43)
3616	2216	(14.423393758658799,42.25)
3617	2216	(14.423393758658799,42.25)
3618	2178	(15.722431864335457,41.5)
3619	2178	(15.722431864335457,41.5)
3620	2178	(15.722431864335457,41.5)
3621	2178	(15.722431864335457,41.5)
3622	2178	(15.722431864335457,41.5)
3623	2098	(15.722431864335457,40)
3624	1779	(16.588457268119896,34)
3625	1779	(16.588457268119896,34)
3626	1779	(16.588457268119896,34)
3627	1899	(17.021469970012117,36.25)
3628	2137	(15.289419162443238,40.75)
3629	2123	(3.1650635094610968,40.75)
3630	2170	(8.794228634059948,41.5)
3631	2123	(3.1650635094610968,40.75)
3632	2170	(8.794228634059948,41.5)
3633	2216	(14.423393758658799,42.25)
3634	2216	(14.423393758658799,42.25)
3635	2123	(3.1650635094610968,40.75)
3636	1968	(7.49519052838329,37.75)
3637	2358	(33.042939940024233,44.5)
3638	2397	(32.609927238132009,45.25)
3639	2394	(30.011851026778693,45.25)
3640	2397	(32.609927238132009,45.25)
3641	2392	(28.279800219209818,45.25)
3642	2392	(28.279800219209818,45.25)
3643	2392	(28.279800219209818,45.25)
3644	2098	(15.722431864335457,40)
3645	1934	(12.258330249197702,37)
3646	1934	(12.258330249197702,37)
3647	2214	(12.691342951089922,42.25)
3648	2306	(23.083647796503186,43.75)
3649	2388	(24.815698604072061,45.25)
3650	2221	(18.753520777580992,42.25)
3651	2221	(18.753520777580992,42.25)
3652	2221	(18.753520777580992,42.25)
3653	2384	(21.351596988934308,45.25)
3654	2347	(23.516660498395403,44.5)
3655	2221	(18.753520777580992,42.25)
3656	2306	(23.083647796503186,43.75)
3657	2306	(23.083647796503186,43.75)
3658	2345	(21.784609690826528,44.5)
3659	2264	(20.918584287042091,43)
3660	2380	(17.887495373796554,45.25)
3661	2385	(22.217622392718749,45.25)
3662	2345	(21.784609690826528,44.5)
3663	2221	(18.753520777580992,42.25)
3664	2345	(21.784609690826528,44.5)
3665	2345	(21.784609690826528,44.5)
3666	2367	(6.6291651245988508,45.25)
3667	2261	(18.320508075688775,43)
3668	2385	(22.217622392718749,45.25)
3669	2241	(1,43)
3670	2367	(6.6291651245988508,45.25)
3671	2368	(7.49519052838329,45.25)
3672	2368	(7.49519052838329,45.25)
3673	2201	(1.4330127018922194,42.25)
3674	2367	(6.6291651245988508,45.25)
3675	2368	(7.49519052838329,45.25)
3676	2241	(1,43)
3677	2367	(6.6291651245988508,45.25)
3678	2368	(7.49519052838329,45.25)
3679	2324	(3.598076211353316,44.5)
3680	2283	(3.1650635094610968,43.75)
3681	734	(12.258330249197702,14.5)
3682	2397	(32.609927238132009,45.25)
3683	771	(10.093266739736606,15.25)
3684	1602	(1.8660254037844386,31)
3685	1612	(10.526279441628825,31)
3686	1989	(25.681724007856502,37.75)
3687	414	(12.258330249197702,8.5)
3688	2263	(20.05255888325765,43)
3689	1613	(11.392304845413264,31)
3690	1613	(11.392304845413264,31)
3691	1613	(11.392304845413264,31)
3692	1685	(4.4641016151377544,32.5)
3693	1765	(4.4641016151377544,34)
3694	1525	(4.4641016151377544,29.5)
3695	2313	(29.145825622994256,43.75)
3696	2154	(30.011851026778693,40.75)
3697	2233	(29.145825622994256,42.25)
3698	2384	(21.351596988934308,45.25)
3699	2264	(20.918584287042091,43)
3700	2264	(20.918584287042091,43)
3701	2384	(21.351596988934308,45.25)
3702	2264	(20.918584287042091,43)
3703	2375	(13.55736835487436,45.25)
3704	2377	(15.289419162443238,45.25)
3705	2377	(15.289419162443238,45.25)
3706	2377	(15.289419162443238,45.25)
3707	2337	(14.856406460551018,44.5)
3708	2223	(20.48557158514987,42.25)
3709	2223	(20.48557158514987,42.25)
3710	2104	(20.918584287042091,40)
3711	2292	(10.959292143521045,43.75)
3712	1884	(4.0310889132455356,36.25)
3713	2003	(2.7320508075688772,38.5)
3714	2293	(11.825317547305483,43.75)
3715	1961	(1.4330127018922194,37.75)
3716	2123	(3.1650635094610968,40.75)
3717	2123	(3.1650635094610968,40.75)
3718	2123	(3.1650635094610968,40.75)
3719	2163	(2.7320508075688772,41.5)
3720	1601	(1,31)
3721	1601	(1,31)
3722	1521	(1,29.5)
3723	1521	(1,29.5)
3724	1481	(1.4330127018922194,28.75)
3725	1481	(1.4330127018922194,28.75)
3726	272	(27.846787517317598,5.5)
3727	272	(27.846787517317598,5.5)
3728	272	(27.846787517317598,5.5)
3729	1821	(18.753520777580992,34.75)
3730	1779	(16.588457268119896,34)
3731	1779	(16.588457268119896,34)
3732	1892	(10.959292143521045,36.25)
3733	1933	(11.392304845413264,37)
3734	105	(21.784609690826528,2.5)
3735	28	(24.382685902179844,1)
3736	24	(20.918584287042091,1)
3737	26	(22.650635094610966,1)
3738	319	(34.341978045700891,6.25)
3739	26	(22.650635094610966,1)
3740	105	(21.784609690826528,2.5)
3741	320	(35.208003449485325,6.25)
3742	28	(24.382685902179844,1)
3743	1090	(9.2272413359521668,21.25)
3744	1090	(9.2272413359521668,21.25)
3745	1050	(8.794228634059948,20.5)
3746	1090	(9.2272413359521668,21.25)
3747	1089	(8.3612159321677293,21.25)
3748	1323	(3.1650635094610968,25.75)
3749	1323	(3.1650635094610968,25.75)
3750	1323	(3.1650635094610968,25.75)
3751	1283	(2.7320508075688772,25)
3752	1283	(2.7320508075688772,25)
3753	1242	(2.299038105676658,24.25)
3754	1162	(2.299038105676658,22.75)
3755	1162	(2.299038105676658,22.75)
3756	1161	(1.4330127018922194,22.75)
3757	1162	(2.299038105676658,22.75)
3758	1162	(2.299038105676658,22.75)
3759	1161	(1.4330127018922194,22.75)
3760	1161	(1.4330127018922194,22.75)
3761	1161	(1.4330127018922194,22.75)
3762	1121	(1,22)
3763	1121	(1,22)
3764	1121	(1,22)
3765	1161	(1.4330127018922194,22.75)
3766	1001	(1.4330127018922194,19.75)
3767	1161	(1.4330127018922194,22.75)
3768	1560	(34.774990747593108,29.5)
3769	1765	(4.4641016151377544,34)
3770	2200	(34.774990747593108,41.5)
3771	354	(29.578838324886476,7)
3772	106	(22.650635094610966,2.5)
3773	2150	(26.54774941164094,40.75)
3774	2150	(26.54774941164094,40.75)
3775	2065	(22.217622392718749,39.25)
3776	2106	(22.650635094610966,40)
3777	2145	(22.217622392718749,40.75)
3778	1992	(28.279800219209818,37.75)
3779	2104	(20.918584287042091,40)
3780	2145	(22.217622392718749,40.75)
3781	2104	(20.918584287042091,40)
3782	31	(26.98076211353316,1)
3783	1000	(34.774990747593108,19)
3784	320	(35.208003449485325,6.25)
3785	28	(24.382685902179844,1)
3786	28	(24.382685902179844,1)
3787	320	(35.208003449485325,6.25)
3788	28	(24.382685902179844,1)
3789	28	(24.382685902179844,1)
3790	352	(27.846787517317598,7)
3791	28	(24.382685902179844,1)
3792	359	(33.908965343808667,7)
3793	1438	(33.47595264191645,27.25)
3794	2060	(17.887495373796554,39.25)
3795	1779	(16.588457268119896,34)
3796	106	(22.650635094610966,2.5)
3797	30	(26.114736709748719,1)
3798	272	(27.846787517317598,5.5)
3799	26	(22.650635094610966,1)
3800	145	(22.217622392718749,3.25)
3801	1230	(26.114736709748719,23.5)
3802	1230	(26.114736709748719,23.5)
3803	272	(27.846787517317598,5.5)
3804	272	(27.846787517317598,5.5)
3805	145	(22.217622392718749,3.25)
3806	145	(22.217622392718749,3.25)
3807	1158	(33.042939940024233,22)
3808	1438	(33.47595264191645,27.25)
3809	2279	(33.908965343808667,43)
3810	1684	(3.598076211353316,32.5)
3811	1684	(3.598076211353316,32.5)
3812	1724	(4.0310889132455356,33.25)
3813	78	(33.47595264191645,1.75)
3814	78	(33.47595264191645,1.75)
3815	78	(33.47595264191645,1.75)
3816	1597	(32.609927238132009,30.25)
3817	1600	(35.208003449485325,30.25)
3818	78	(33.47595264191645,1.75)
3819	351	(26.98076211353316,7)
3820	78	(33.47595264191645,1.75)
3821	351	(26.98076211353316,7)
3822	155	(30.877876430563134,3.25)
3823	351	(26.98076211353316,7)
3824	195	(30.444863728670914,4)
3825	195	(30.444863728670914,4)
3826	195	(30.444863728670914,4)
3827	273	(28.712812921102035,5.5)
3828	353	(28.712812921102035,7)
3829	78	(33.47595264191645,1.75)
3830	78	(33.47595264191645,1.75)
3831	155	(30.877876430563134,3.25)
3832	195	(30.444863728670914,4)
3833	195	(30.444863728670914,4)
3834	1600	(35.208003449485325,30.25)
3835	77	(32.609927238132009,1.75)
3836	77	(32.609927238132009,1.75)
3837	77	(32.609927238132009,1.75)
3838	77	(32.609927238132009,1.75)
3839	77	(32.609927238132009,1.75)
3840	77	(32.609927238132009,1.75)
3841	2279	(33.908965343808667,43)
3842	1779	(16.588457268119896,34)
3843	2178	(15.722431864335457,41.5)
3844	2137	(15.289419162443238,40.75)
3845	2137	(15.289419162443238,40.75)
3846	1891	(10.093266739736606,36.25)
3847	1851	(9.6602540378443873,35.5)
3848	1933	(11.392304845413264,37)
3849	1889	(8.3612159321677293,36.25)
3850	2124	(4.0310889132455356,40.75)
3851	2041	(1.4330127018922194,39.25)
3852	2291	(10.093266739736606,43.75)
3853	1920	(35.208003449485325,36.25)
3854	2159	(34.341978045700891,40.75)
3855	2279	(33.908965343808667,43)
3856	1333	(11.825317547305483,25.75)
3857	1333	(11.825317547305483,25.75)
3858	485	(4.4641016151377544,10)
3859	441	(1.4330127018922194,9.25)
3860	603	(3.1650635094610968,12.25)
3861	601	(1.4330127018922194,12.25)
3862	1592	(28.279800219209818,30.25)
3863	1670	(26.54774941164094,31.75)
3864	1952	(27.846787517317598,37)
3865	1610	(8.794228634059948,31)
3866	1647	(6.6291651245988508,31.75)
3867	1647	(6.6291651245988508,31.75)
3868	1957	(32.176914536239792,37)
3869	1956	(31.310889132455351,37)
3870	1957	(32.176914536239792,37)
3871	1877	(32.176914536239792,35.5)
3872	1877	(32.176914536239792,35.5)
3873	2111	(26.98076211353316,40)
3874	2071	(27.413774815425377,39.25)
3875	1610	(8.794228634059948,31)
3876	1687	(6.196152422706632,32.5)
3877	2111	(26.98076211353316,40)
3878	2034	(29.578838324886476,38.5)
3879	1993	(29.145825622994256,37.75)
3880	663	(20.05255888325765,13)
3881	659	(16.588457268119896,13)
3882	659	(16.588457268119896,13)
3883	992	(27.846787517317598,19)
3884	1031	(27.413774815425377,19.75)
3885	990	(26.114736709748719,19)
3886	948	(24.815698604072061,18.25)
3887	908	(24.382685902179844,17.5)
3888	945	(22.217622392718749,18.25)
3889	796	(31.743901834347572,15.25)
3890	795	(30.877876430563134,15.25)
3891	835	(30.444863728670914,16)
3892	835	(30.444863728670914,16)
3893	794	(30.011851026778693,15.25)
3894	835	(30.444863728670914,16)
3895	832	(27.846787517317598,16)
3896	831	(26.98076211353316,16)
3897	424	(20.918584287042091,8.5)
3898	424	(20.918584287042091,8.5)
3899	460	(17.887495373796554,9.25)
3900	501	(18.320508075688775,10)
3901	1108	(24.815698604072061,21.25)
3902	1104	(21.351596988934308,21.25)
3903	1023	(20.48557158514987,19.75)
3904	101	(18.320508075688775,2.5)
3905	58	(16.155444566227676,1.75)
3906	17	(14.856406460551018,1)
3907	1070	(26.114736709748719,20.5)
3908	1028	(24.815698604072061,19.75)
3909	2320	(35.208003449485325,43.75)
3910	1350	(26.54774941164094,25.75)
3911	1392	(27.846787517317598,26.5)
3912	1471	(26.98076211353316,28)
3913	1427	(23.949673200287624,27.25)
3914	1501	(18.753520777580992,28.75)
3915	1501	(18.753520777580992,28.75)
3916	1460	(17.454482671904334,28)
3917	1460	(17.454482671904334,28)
3918	1460	(17.454482671904334,28)
3919	1537	(14.856406460551018,29.5)
3920	1577	(15.289419162443238,30.25)
3921	1427	(23.949673200287624,27.25)
3922	1427	(23.949673200287624,27.25)
3923	1377	(14.856406460551018,26.5)
3924	1336	(14.423393758658799,25.75)
3925	1306	(22.650635094610966,25)
3926	796	(31.743901834347572,15.25)
3927	796	(31.743901834347572,15.25)
3928	796	(31.743901834347572,15.25)
3929	796	(31.743901834347572,15.25)
3930	796	(31.743901834347572,15.25)
3931	1117	(32.609927238132009,21.25)
3932	1117	(32.609927238132009,21.25)
3933	1117	(32.609927238132009,21.25)
3934	1117	(32.609927238132009,21.25)
3935	1117	(32.609927238132009,21.25)
3936	1117	(32.609927238132009,21.25)
3937	913	(28.712812921102035,17.5)
3938	911	(26.98076211353316,17.5)
3939	911	(26.98076211353316,17.5)
3940	911	(26.98076211353316,17.5)
3941	1152	(27.846787517317598,22)
3942	1181	(18.753520777580992,22.75)
3943	167	(6.196152422706632,4)
3944	167	(6.196152422706632,4)
3945	167	(6.196152422706632,4)
3946	7	(6.196152422706632,1)
3947	6	(5.3301270189221936,1)
3948	6	(5.3301270189221936,1)
3949	87	(6.196152422706632,2.5)
3950	43	(3.1650635094610968,1.75)
3951	81	(1,2.5)
3952	242	(1.8660254037844386,5.5)
3953	223	(20.48557158514987,4.75)
3954	223	(20.48557158514987,4.75)
3955	262	(19.186533479473212,5.5)
3956	223	(20.48557158514987,4.75)
3957	223	(20.48557158514987,4.75)
3958	222	(19.619546181365433,4.75)
3959	1833	(29.145825622994256,34.75)
3960	1833	(29.145825622994256,34.75)
3961	1154	(29.578838324886476,22)
3962	1865	(21.784609690826528,35.5)
3963	2289	(8.3612159321677293,43.75)
3964	1786	(22.650635094610966,34)
3965	2385	(22.217622392718749,45.25)
3966	2382	(19.619546181365433,45.25)
3967	2388	(24.815698604072061,45.25)
3968	2345	(21.784609690826528,44.5)
3969	2400	(35.208003449485325,45.25)
3970	2200	(34.774990747593108,41.5)
3971	2399	(34.341978045700891,45.25)
3972	2187	(23.516660498395403,41.5)
3973	1160	(34.774990747593108,22)
3974	1160	(34.774990747593108,22)
3975	1160	(34.774990747593108,22)
3976	2317	(32.609927238132009,43.75)
3977	2269	(25.248711305964282,43)
3978	2358	(33.042939940024233,44.5)
3979	1356	(31.743901834347572,25.75)
3980	1960	(34.774990747593108,37)
3981	2196	(31.310889132455351,41.5)
3982	2359	(33.908965343808667,44.5)
3983	2279	(33.908965343808667,43)
3984	2187	(23.516660498395403,41.5)
3985	2194	(29.578838324886476,41.5)
3986	822	(19.186533479473212,16)
3987	943	(20.48557158514987,18.25)
3988	782	(19.619546181365433,15.25)
3989	943	(20.48557158514987,18.25)
3990	942	(19.619546181365433,18.25)
3991	943	(20.48557158514987,18.25)
3992	859	(17.021469970012117,16.75)
3993	821	(18.320508075688775,16)
3994	819	(16.588457268119896,16)
3995	942	(19.619546181365433,18.25)
3996	942	(19.619546181365433,18.25)
3997	942	(19.619546181365433,18.25)
3998	943	(20.48557158514987,18.25)
3999	942	(19.619546181365433,18.25)
4000	819	(16.588457268119896,16)
4001	823	(20.05255888325765,16)
4002	257	(14.856406460551018,5.5)
4003	257	(14.856406460551018,5.5)
4004	336	(13.99038105676658,7)
4005	336	(13.99038105676658,7)
4006	2157	(32.609927238132009,40.75)
4007	2118	(33.042939940024233,40)
4008	2080	(35.208003449485325,39.25)
4009	2080	(35.208003449485325,39.25)
4010	2156	(31.743901834347572,40.75)
4011	2194	(29.578838324886476,41.5)
4012	1917	(32.609927238132009,36.25)
4013	2159	(34.341978045700891,40.75)
4014	1877	(32.176914536239792,35.5)
4015	1917	(32.609927238132009,36.25)
4016	2157	(32.609927238132009,40.75)
4017	2156	(31.743901834347572,40.75)
4018	1036	(31.743901834347572,19.75)
4019	1036	(31.743901834347572,19.75)
4020	1036	(31.743901834347572,19.75)
4021	1076	(31.310889132455351,20.5)
4022	1076	(31.310889132455351,20.5)
4023	147	(23.949673200287624,3.25)
4024	147	(23.949673200287624,3.25)
4025	147	(23.949673200287624,3.25)
4026	108	(24.382685902179844,2.5)
4027	154	(30.011851026778693,3.25)
4028	1477	(32.176914536239792,28)
4029	877	(32.609927238132009,16.75)
4030	838	(33.042939940024233,16)
4031	676	(31.310889132455351,13)
4032	676	(31.310889132455351,13)
4033	676	(31.310889132455351,13)
4034	676	(31.310889132455351,13)
4035	152	(28.279800219209818,3.25)
4036	152	(28.279800219209818,3.25)
4037	112	(27.846787517317598,2.5)
4038	112	(27.846787517317598,2.5)
4039	1037	(32.609927238132009,19.75)
4040	1037	(32.609927238132009,19.75)
4041	554	(30.011851026778693,10.75)
4042	554	(30.011851026778693,10.75)
4043	553	(29.145825622994256,10.75)
4044	73	(29.145825622994256,1.75)
4045	153	(29.145825622994256,3.25)
4046	1036	(31.743901834347572,19.75)
4047	628	(24.815698604072061,12.25)
4048	640	(35.208003449485325,12.25)
4049	639	(34.341978045700891,12.25)
4050	676	(31.310889132455351,13)
4051	676	(31.310889132455351,13)
4052	1036	(31.743901834347572,19.75)
4053	227	(23.949673200287624,4.75)
4054	673	(28.712812921102035,13)
4055	879	(34.341978045700891,16.75)
4056	437	(32.176914536239792,8.5)
4057	640	(35.208003449485325,12.25)
4058	476	(31.743901834347572,9.25)
4059	518	(33.042939940024233,10)
4060	553	(29.145825622994256,10.75)
4061	553	(29.145825622994256,10.75)
4062	111	(26.98076211353316,2.5)
4063	33	(28.712812921102035,1)
4064	37	(32.176914536239792,1)
4065	159	(34.341978045700891,3.25)
4066	160	(35.208003449485325,3.25)
4067	239	(34.341978045700891,4.75)
4068	118	(33.042939940024233,2.5)
4069	1119	(34.341978045700891,21.25)
4070	1197	(32.609927238132009,22.75)
4071	1080	(34.774990747593108,20.5)
4072	1080	(34.774990747593108,20.5)
4073	1079	(33.908965343808667,20.5)
4074	1120	(35.208003449485325,21.25)
4075	1080	(34.774990747593108,20.5)
4076	1040	(35.208003449485325,19.75)
4077	840	(34.774990747593108,16)
4078	640	(35.208003449485325,12.25)
4079	720	(35.208003449485325,13.75)
4080	840	(34.774990747593108,16)
4081	800	(35.208003449485325,15.25)
4082	320	(35.208003449485325,6.25)
4083	840	(34.774990747593108,16)
4084	1277	(32.609927238132009,24.25)
4085	1277	(32.609927238132009,24.25)
4086	1277	(32.609927238132009,24.25)
4087	1476	(31.310889132455351,28)
4088	1753	(29.145825622994256,33.25)
4089	1715	(30.444863728670914,32.5)
4090	1676	(31.743901834347572,31.75)
4091	1717	(32.176914536239792,32.5)
4092	1718	(33.042939940024233,32.5)
4093	1759	(34.341978045700891,33.25)
4094	1760	(35.208003449485325,33.25)
4095	1760	(35.208003449485325,33.25)
4096	1680	(35.208003449485325,31.75)
4097	1240	(34.774990747593108,23.5)
4098	1240	(34.774990747593108,23.5)
4099	1360	(35.208003449485325,25.75)
4100	1520	(35.208003449485325,28.75)
4101	1117	(32.609927238132009,21.25)
4102	1076	(31.310889132455351,20.5)
4103	346	(22.650635094610966,7)
4104	431	(26.98076211353316,8.5)
4105	227	(23.949673200287624,4.75)
4106	511	(26.98076211353316,10)
4107	879	(34.341978045700891,16.75)
4108	477	(32.609927238132009,9.25)
4109	640	(35.208003449485325,12.25)
4110	511	(26.98076211353316,10)
4111	520	(34.774990747593108,10)
4112	153	(29.145825622994256,3.25)
4113	393	(29.145825622994256,7.75)
4114	438	(33.042939940024233,8.5)
4115	560	(35.208003449485325,10.75)
4116	393	(29.145825622994256,7.75)
4117	520	(34.774990747593108,10)
4118	1000	(34.774990747593108,19)
4119	1000	(34.774990747593108,19)
4120	960	(35.208003449485325,18.25)
4121	480	(35.208003449485325,9.25)
4122	1277	(32.609927238132009,24.25)
4123	1277	(32.609927238132009,24.25)
4124	1277	(32.609927238132009,24.25)
4125	1476	(31.310889132455351,28)
4126	1515	(30.877876430563134,28.75)
4127	1680	(35.208003449485325,31.75)
4128	917	(32.176914536239792,17.5)
4129	917	(32.176914536239792,17.5)
4130	640	(35.208003449485325,12.25)
4131	223	(20.48557158514987,4.75)
4132	223	(20.48557158514987,4.75)
4133	223	(20.48557158514987,4.75)
4134	341	(18.320508075688775,7)
4135	300	(17.887495373796554,6.25)
4136	339	(16.588457268119896,7)
4137	1	(1,1)
4138	1	(1,1)
4139	2240	(35.208003449485325,42.25)
4140	2240	(35.208003449485325,42.25)
4141	2240	(35.208003449485325,42.25)
4142	1	(1,1)
4143	1	(1,1)
4144	1	(1,1)
4145	1234	(29.578838324886476,23.5)
4146	1739	(17.021469970012117,33.25)
4147	2178	(15.722431864335457,41.5)
4148	2138	(16.155444566227676,40.75)
4149	2399	(34.341978045700891,45.25)
4150	2399	(34.341978045700891,45.25)
4151	2279	(33.908965343808667,43)
4152	447	(6.6291651245988508,9.25)
4153	485	(4.4641016151377544,10)
4154	1213	(11.392304845413264,23.5)
4155	1090	(9.2272413359521668,21.25)
4156	1090	(9.2272413359521668,21.25)
4157	1089	(8.3612159321677293,21.25)
4158	1282	(1.8660254037844386,25)
4159	1162	(2.299038105676658,22.75)
4160	1162	(2.299038105676658,22.75)
4161	682	(2.299038105676658,13.75)
4162	682	(2.299038105676658,13.75)
4163	1128	(7.0621778264910704,22)
4164	1128	(7.0621778264910704,22)
4165	1323	(3.1650635094610968,25.75)
4166	1128	(7.0621778264910704,22)
4167	761	(1.4330127018922194,15.25)
4168	1283	(2.7320508075688772,25)
4169	1283	(2.7320508075688772,25)
4170	1241	(1.4330127018922194,24.25)
4171	1241	(1.4330127018922194,24.25)
4172	964	(3.598076211353316,19)
4173	1282	(1.8660254037844386,25)
4174	1161	(1.4330127018922194,22.75)
4175	1161	(1.4330127018922194,22.75)
4176	1161	(1.4330127018922194,22.75)
4177	1121	(1,22)
4178	1121	(1,22)
4179	2035	(30.444863728670914,38.5)
4180	2071	(27.413774815425377,39.25)
4181	1651	(10.093266739736606,31.75)
4182	1572	(10.959292143521045,30.25)
4183	1603	(2.7320508075688772,31)
4184	1761	(1,34)
4185	766	(5.7631397208144124,15.25)
4186	766	(5.7631397208144124,15.25)
4187	2156	(31.743901834347572,40.75)
4188	1612	(10.526279441628825,31)
4189	2067	(23.949673200287624,39.25)
4190	648	(7.0621778264910704,13)
4191	1642	(2.299038105676658,31.75)
4192	1302	(19.186533479473212,25)
4193	1298	(15.722431864335457,25)
4194	1298	(15.722431864335457,25)
4195	1306	(22.650635094610966,25)
4196	1104	(21.351596988934308,21.25)
4197	418	(15.722431864335457,8.5)
4198	418	(15.722431864335457,8.5)
4199	456	(14.423393758658799,9.25)
4200	577	(14.856406460551018,11.5)
4201	577	(14.856406460551018,11.5)
4202	617	(15.289419162443238,12.25)
4203	1147	(23.516660498395403,22)
4204	1106	(23.083647796503186,21.25)
4205	1104	(21.351596988934308,21.25)
4206	1103	(20.48557158514987,21.25)
4207	905	(21.784609690826528,17.5)
4208	905	(21.784609690826528,17.5)
4209	905	(21.784609690826528,17.5)
4210	2181	(18.320508075688775,41.5)
4211	2299	(17.021469970012117,43.75)
4212	2385	(22.217622392718749,45.25)
4213	2299	(17.021469970012117,43.75)
4214	2385	(22.217622392718749,45.25)
4215	2389	(25.681724007856502,45.25)
4216	2262	(19.186533479473212,43)
4217	2343	(20.05255888325765,44.5)
4218	2385	(22.217622392718749,45.25)
4219	2380	(17.887495373796554,45.25)
4220	2380	(17.887495373796554,45.25)
4221	2321	(1,44.5)
4222	2244	(3.598076211353316,43)
4223	2281	(1.4330127018922194,43.75)
4224	2281	(1.4330127018922194,43.75)
4225	1822	(19.619546181365433,34.75)
4226	1779	(16.588457268119896,34)
4227	1899	(17.021469970012117,36.25)
4228	1928	(7.0621778264910704,37)
4229	2060	(17.887495373796554,39.25)
4230	1892	(10.959292143521045,36.25)
4231	1892	(10.959292143521045,36.25)
4232	1977	(15.289419162443238,37.75)
4233	2060	(17.887495373796554,39.25)
4234	1928	(7.0621778264910704,37)
4235	1968	(7.49519052838329,37.75)
4236	2214	(12.691342951089922,42.25)
4237	2081	(1,40)
4238	2212	(10.959292143521045,42.25)
4239	1961	(1.4330127018922194,37.75)
4240	1924	(3.598076211353316,37)
4241	2091	(9.6602540378443873,40)
4242	2207	(6.6291651245988508,42.25)
4243	2213	(11.825317547305483,42.25)
4244	2093	(11.392304845413264,40)
4245	1968	(7.49519052838329,37.75)
4246	2214	(12.691342951089922,42.25)
4247	21	(18.320508075688775,1)
4248	60	(17.887495373796554,1.75)
4249	18	(15.722431864335457,1)
4250	133	(11.825317547305483,3.25)
4251	178	(15.722431864335457,4)
4252	138	(16.155444566227676,3.25)
4253	94	(12.258330249197702,2.5)
4254	178	(15.722431864335457,4)
4255	88	(7.0621778264910704,2.5)
4256	7	(6.196152422706632,1)
4257	6	(5.3301270189221936,1)
4258	6	(5.3301270189221936,1)
4259	126	(5.7631397208144124,3.25)
4260	283	(3.1650635094610968,6.25)
4261	283	(3.1650635094610968,6.25)
4262	124	(4.0310889132455356,3.25)
4263	124	(4.0310889132455356,3.25)
4264	165	(4.4641016151377544,4)
4265	1342	(19.619546181365433,25.75)
4266	1352	(28.279800219209818,25.75)
4267	1352	(28.279800219209818,25.75)
4268	1390	(26.114736709748719,26.5)
4269	1509	(25.681724007856502,28.75)
4270	1509	(25.681724007856502,28.75)
4271	1592	(28.279800219209818,30.25)
4272	1592	(28.279800219209818,30.25)
4273	1591	(27.413774815425377,30.25)
4274	2320	(35.208003449485325,43.75)
4275	850	(9.2272413359521668,16.75)
4276	1205	(4.4641016151377544,23.5)
4277	970	(8.794228634059948,19)
4278	1008	(7.49519052838329,19.75)
4279	2392	(28.279800219209818,45.25)
4280	2394	(30.011851026778693,45.25)
4281	2392	(28.279800219209818,45.25)
4282	2392	(28.279800219209818,45.25)
4283	1627	(23.516660498395403,31)
4284	1627	(23.516660498395403,31)
4285	1626	(22.650635094610966,31)
4286	1626	(22.650635094610966,31)
4287	1253	(11.825317547305483,24.25)
4288	2280	(34.774990747593108,43)
4289	2396	(31.743901834347572,45.25)
4290	2396	(31.743901834347572,45.25)
4291	2396	(31.743901834347572,45.25)
4292	2400	(35.208003449485325,45.25)
4293	2200	(34.774990747593108,41.5)
4294	1869	(25.248711305964282,35.5)
4295	2399	(34.341978045700891,45.25)
4296	2040	(34.774990747593108,38.5)
4297	1989	(25.681724007856502,37.75)
4298	2159	(34.341978045700891,40.75)
4299	2159	(34.341978045700891,40.75)
4300	2159	(34.341978045700891,40.75)
4301	1160	(34.774990747593108,22)
4302	1160	(34.774990747593108,22)
4303	1160	(34.774990747593108,22)
4304	1320	(34.774990747593108,25)
4305	1360	(35.208003449485325,25.75)
4306	2317	(32.609927238132009,43.75)
4307	2269	(25.248711305964282,43)
4308	2358	(33.042939940024233,44.5)
4309	1356	(31.743901834347572,25.75)
4310	1960	(34.774990747593108,37)
4311	2196	(31.310889132455351,41.5)
4312	2359	(33.908965343808667,44.5)
4313	2279	(33.908965343808667,43)
4314	448	(7.49519052838329,9.25)
4315	444	(4.0310889132455356,9.25)
4316	485	(4.4641016151377544,10)
4317	1454	(12.258330249197702,28)
4318	1487	(6.6291651245988508,28.75)
4319	1487	(6.6291651245988508,28.75)
4320	1628	(24.382685902179844,31)
4321	1628	(24.382685902179844,31)
4322	1704	(20.918584287042091,32.5)
4323	1703	(20.05255888325765,32.5)
4324	855	(13.55736835487436,16.75)
4325	855	(13.55736835487436,16.75)
4326	941	(18.753520777580992,18.25)
4327	941	(18.753520777580992,18.25)
4328	980	(17.454482671904334,19)
4329	936	(14.423393758658799,18.25)
4330	936	(14.423393758658799,18.25)
4331	938	(16.155444566227676,18.25)
4332	1021	(18.753520777580992,19.75)
4333	1534	(12.258330249197702,29.5)
4334	2250	(8.794228634059948,43)
4335	2289	(8.3612159321677293,43.75)
4336	2289	(8.3612159321677293,43.75)
4337	1112	(28.279800219209818,21.25)
4338	1222	(19.186533479473212,23.5)
4339	1222	(19.186533479473212,23.5)
4340	2376	(14.423393758658799,45.25)
4341	2376	(14.423393758658799,45.25)
4342	2376	(14.423393758658799,45.25)
4343	2370	(9.2272413359521668,45.25)
4344	1786	(22.650635094610966,34)
4345	2330	(8.794228634059948,44.5)
4346	1955	(30.444863728670914,37)
4347	1877	(32.176914536239792,35.5)
4348	1877	(32.176914536239792,35.5)
4349	1879	(33.908965343808667,35.5)
4350	1877	(32.176914536239792,35.5)
4351	1879	(33.908965343808667,35.5)
4352	1920	(35.208003449485325,36.25)
4353	1911	(27.413774815425377,36.25)
4354	1949	(25.248711305964282,37)
4355	1944	(20.918584287042091,37)
4356	1494	(12.691342951089922,28.75)
4357	612	(10.959292143521045,12.25)
4358	570	(8.794228634059948,11.5)
4359	1949	(25.248711305964282,37)
4360	771	(10.093266739736606,15.25)
4361	1879	(33.908965343808667,35.5)
4362	2194	(29.578838324886476,41.5)
4363	2067	(23.949673200287624,39.25)
4364	1642	(2.299038105676658,31.75)
4365	1403	(3.1650635094610968,27.25)
4366	1161	(1.4330127018922194,22.75)
4367	1441	(1,28)
4368	1441	(1,28)
4369	1538	(15.722431864335457,29.5)
4370	1537	(14.856406460551018,29.5)
4371	1620	(17.454482671904334,31)
4372	1618	(15.722431864335457,31)
4373	1538	(15.722431864335457,29.5)
4374	1618	(15.722431864335457,31)
4375	1424	(21.351596988934308,27.25)
4376	1464	(20.918584287042091,28)
4377	1464	(20.918584287042091,28)
4378	1582	(19.619546181365433,30.25)
4379	1623	(20.05255888325765,31)
4380	1240	(34.774990747593108,23.5)
4381	1240	(34.774990747593108,23.5)
4382	1240	(34.774990747593108,23.5)
4383	1360	(35.208003449485325,25.75)
4384	1440	(35.208003449485325,27.25)
4385	1597	(32.609927238132009,30.25)
4386	1600	(35.208003449485325,30.25)
4387	1834	(30.011851026778693,34.75)
4388	1598	(33.47595264191645,30.25)
4389	1600	(35.208003449485325,30.25)
4390	425	(21.784609690826528,8.5)
4391	425	(21.784609690826528,8.5)
4392	505	(21.784609690826528,10)
4393	465	(22.217622392718749,9.25)
4394	423	(20.05255888325765,8.5)
4395	461	(18.753520777580992,9.25)
4396	1277	(32.609927238132009,24.25)
4397	1277	(32.609927238132009,24.25)
4398	1476	(31.310889132455351,28)
4399	1753	(29.145825622994256,33.25)
4400	1715	(30.444863728670914,32.5)
4401	1676	(31.743901834347572,31.75)
4402	1717	(32.176914536239792,32.5)
4403	1718	(33.042939940024233,32.5)
4404	1759	(34.341978045700891,33.25)
4405	1760	(35.208003449485325,33.25)
4406	1680	(35.208003449485325,31.75)
4407	37	(32.176914536239792,1)
4408	80	(35.208003449485325,1.75)
4409	37	(32.176914536239792,1)
4410	80	(35.208003449485325,1.75)
4411	37	(32.176914536239792,1)
4412	80	(35.208003449485325,1.75)
4413	37	(32.176914536239792,1)
4414	80	(35.208003449485325,1.75)
4415	632	(28.279800219209818,12.25)
4416	231	(27.413774815425377,4.75)
4417	112	(27.846787517317598,2.5)
4418	234	(30.011851026778693,4.75)
4419	234	(30.011851026778693,4.75)
4420	33	(28.712812921102035,1)
4421	33	(28.712812921102035,1)
4422	33	(28.712812921102035,1)
4423	234	(30.011851026778693,4.75)
4424	231	(27.413774815425377,4.75)
4425	33	(28.712812921102035,1)
4426	113	(28.712812921102035,2.5)
4427	234	(30.011851026778693,4.75)
4428	597	(32.176914536239792,11.5)
4429	596	(31.310889132455351,11.5)
4430	554	(30.011851026778693,10.75)
4431	153	(29.145825622994256,3.25)
4432	672	(27.846787517317598,13)
4433	231	(27.413774815425377,4.75)
4434	33	(28.712812921102035,1)
4435	113	(28.712812921102035,2.5)
4436	234	(30.011851026778693,4.75)
4437	231	(27.413774815425377,4.75)
4438	73	(29.145825622994256,1.75)
4439	234	(30.011851026778693,4.75)
4440	234	(30.011851026778693,4.75)
4441	234	(30.011851026778693,4.75)
4442	231	(27.413774815425377,4.75)
4443	155	(30.877876430563134,3.25)
4444	194	(29.578838324886476,4)
4445	235	(30.877876430563134,4.75)
4446	235	(30.877876430563134,4.75)
4447	234	(30.011851026778693,4.75)
4448	234	(30.011851026778693,4.75)
4449	234	(30.011851026778693,4.75)
4450	347	(23.516660498395403,7)
4451	554	(30.011851026778693,10.75)
4452	347	(23.516660498395403,7)
4453	596	(31.310889132455351,11.5)
4454	719	(34.341978045700891,13.75)
4455	1240	(34.774990747593108,23.5)
4456	1399	(33.908965343808667,26.5)
4457	1440	(35.208003449485325,27.25)
4458	1597	(32.609927238132009,30.25)
4459	1598	(33.47595264191645,30.25)
4460	1600	(35.208003449485325,30.25)
4461	1237	(32.176914536239792,23.5)
4462	1197	(32.609927238132009,22.75)
4463	1197	(32.609927238132009,22.75)
4464	1318	(33.042939940024233,25)
4465	948	(24.815698604072061,18.25)
4466	948	(24.815698604072061,18.25)
4467	947	(23.949673200287624,18.25)
4468	2157	(32.609927238132009,40.75)
4469	2156	(31.743901834347572,40.75)
4470	835	(30.444863728670914,16)
4471	835	(30.444863728670914,16)
4472	875	(30.877876430563134,16.75)
4473	835	(30.444863728670914,16)
4474	794	(30.011851026778693,15.25)
4475	792	(28.279800219209818,15.25)
4476	586	(22.650635094610966,11.5)
4477	665	(21.784609690826528,13)
4478	662	(19.186533479473212,13)
4479	954	(30.011851026778693,18.25)
4480	992	(27.846787517317598,19)
4481	990	(26.114736709748719,19)
4482	2312	(28.279800219209818,43.75)
4483	2154	(30.011851026778693,40.75)
4484	2233	(29.145825622994256,42.25)
4485	223	(20.48557158514987,4.75)
4486	223	(20.48557158514987,4.75)
4487	223	(20.48557158514987,4.75)
4488	263	(20.05255888325765,5.5)
4489	1069	(25.248711305964282,20.5)
4490	300	(17.887495373796554,6.25)
4491	341	(18.320508075688775,7)
4492	341	(18.320508075688775,7)
4493	339	(16.588457268119896,7)
4494	1	(1,1)
4495	1	(1,1)
4496	1	(1,1)
4497	448	(7.49519052838329,9.25)
4498	412	(10.526279441628825,8.5)
4499	609	(8.3612159321677293,12.25)
4500	1171	(10.093266739736606,22.75)
4501	1487	(6.6291651245988508,28.75)
4502	844	(4.0310889132455356,16.75)
4503	490	(8.794228634059948,10)
4504	568	(7.0621778264910704,11.5)
4505	682	(2.299038105676658,13.75)
4506	1128	(7.0621778264910704,22)
4507	1128	(7.0621778264910704,22)
4508	1128	(7.0621778264910704,22)
4509	761	(1.4330127018922194,15.25)
4510	1283	(2.7320508075688772,25)
4511	1283	(2.7320508075688772,25)
4512	1162	(2.299038105676658,22.75)
4513	1162	(2.299038105676658,22.75)
4514	1162	(2.299038105676658,22.75)
4515	644	(3.598076211353316,13)
4516	721	(1,14.5)
4517	721	(1,14.5)
4518	644	(3.598076211353316,13)
4519	1249	(8.3612159321677293,24.25)
4520	1287	(6.196152422706632,25)
4521	925	(4.897114317029974,18.25)
4522	841	(1.4330127018922194,16.75)
4523	882	(1.8660254037844386,17.5)
4524	841	(1.4330127018922194,16.75)
4525	882	(1.8660254037844386,17.5)
4526	1125	(4.4641016151377544,22)
4527	1084	(4.0310889132455356,21.25)
4528	921	(1.4330127018922194,18.25)
4529	1244	(4.0310889132455356,24.25)
4530	936	(14.423393758658799,18.25)
4531	938	(16.155444566227676,18.25)
4532	938	(16.155444566227676,18.25)
4533	1019	(17.021469970012117,19.75)
4534	934	(12.691342951089922,18.25)
4535	936	(14.423393758658799,18.25)
4536	938	(16.155444566227676,18.25)
4537	613	(11.825317547305483,12.25)
4538	1949	(25.248711305964282,37)
4539	1407	(6.6291651245988508,27.25)
4540	1602	(1.8660254037844386,31)
4541	1606	(5.3301270189221936,31)
4542	1606	(5.3301270189221936,31)
4543	1652	(10.959292143521045,31.75)
4544	2035	(30.444863728670914,38.5)
4545	2111	(26.98076211353316,40)
4546	2111	(26.98076211353316,40)
4547	2071	(27.413774815425377,39.25)
4548	2071	(27.413774815425377,39.25)
4549	1529	(7.9282032302755088,29.5)
4550	2071	(27.413774815425377,39.25)
4551	1841	(1,35.5)
4552	1761	(1,34)
4553	1683	(2.7320508075688772,32.5)
4554	1761	(1,34)
4555	1748	(24.815698604072061,33.25)
4556	2156	(31.743901834347572,40.75)
4557	2034	(29.578838324886476,38.5)
4558	2034	(29.578838324886476,38.5)
4559	1608	(7.0621778264910704,31)
4560	1187	(23.949673200287624,22.75)
4561	1225	(21.784609690826528,23.5)
4562	1033	(29.145825622994256,19.75)
4563	1032	(28.279800219209818,19.75)
4564	1032	(28.279800219209818,19.75)
4565	1027	(23.949673200287624,19.75)
4566	586	(22.650635094610966,11.5)
4567	664	(20.918584287042091,13)
4568	662	(19.186533479473212,13)
4569	577	(14.856406460551018,11.5)
4570	659	(16.588457268119896,13)
4571	617	(15.289419162443238,12.25)
4572	425	(21.784609690826528,8.5)
4573	506	(22.650635094610966,10)
4574	465	(22.217622392718749,9.25)
4575	461	(18.753520777580992,9.25)
4576	461	(18.753520777580992,9.25)
4577	461	(18.753520777580992,9.25)
4578	1147	(23.516660498395403,22)
4579	1185	(22.217622392718749,22.75)
4580	1185	(22.217622392718749,22.75)
4581	1103	(20.48557158514987,21.25)
4582	1062	(19.186533479473212,20.5)
4583	866	(23.083647796503186,16.75)
4584	905	(21.784609690826528,17.5)
4585	1098	(16.155444566227676,21.25)
4586	1100	(17.887495373796554,21.25)
4587	1302	(19.186533479473212,25)
4588	1298	(15.722431864335457,25)
4589	1343	(20.48557158514987,25.75)
4590	1298	(15.722431864335457,25)
4591	1296	(13.99038105676658,25)
4592	1216	(13.99038105676658,23.5)
4593	1306	(22.650635094610966,25)
4594	1860	(17.454482671904334,35.5)
4595	1860	(17.454482671904334,35.5)
4596	1942	(19.186533479473212,37)
4597	1899	(17.021469970012117,36.25)
4598	1942	(19.186533479473212,37)
4599	1897	(15.289419162443238,36.25)
4600	1980	(17.887495373796554,37.75)
4601	1929	(7.9282032302755088,37)
4602	1776	(13.99038105676658,34)
4603	1776	(13.99038105676658,34)
4604	1978	(16.155444566227676,37.75)
4605	1779	(16.588457268119896,34)
4606	2093	(11.392304845413264,40)
4607	1968	(7.49519052838329,37.75)
4608	2126	(5.7631397208144124,40.75)
4609	2256	(13.99038105676658,43)
4610	2053	(11.825317547305483,39.25)
4611	2214	(12.691342951089922,42.25)
4612	2170	(8.794228634059948,41.5)
4613	1822	(19.619546181365433,34.75)
4614	1980	(17.887495373796554,37.75)
4615	2053	(11.825317547305483,39.25)
4616	2003	(2.7320508075688772,38.5)
4617	2207	(6.6291651245988508,42.25)
4618	1807	(6.6291651245988508,34.75)
4619	2060	(17.887495373796554,39.25)
4620	1768	(7.0621778264910704,34)
4621	2255	(13.124355652982141,43)
4622	1807	(6.6291651245988508,34.75)
4623	2255	(13.124355652982141,43)
4624	1925	(4.4641016151377544,37)
4625	2053	(11.825317547305483,39.25)
4626	2003	(2.7320508075688772,38.5)
4627	2003	(2.7320508075688772,38.5)
4628	2212	(10.959292143521045,42.25)
4629	21	(18.320508075688775,1)
4630	2092	(10.526279441628825,40)
4631	60	(17.887495373796554,1.75)
4632	60	(17.887495373796554,1.75)
4633	17	(14.856406460551018,1)
4634	17	(14.856406460551018,1)
4635	10	(8.794228634059948,1)
4636	178	(15.722431864335457,4)
4637	138	(16.155444566227676,3.25)
4638	15	(13.124355652982141,1)
4639	178	(15.722431864335457,4)
4640	178	(15.722431864335457,4)
4641	7	(6.196152422706632,1)
4642	5	(4.4641016151377544,1)
4643	45	(4.897114317029974,1.75)
4644	165	(4.4641016151377544,4)
4645	283	(3.1650635094610968,6.25)
4646	281	(1.4330127018922194,6.25)
4647	321	(1,7)
4648	366	(5.7631397208144124,7.75)
4649	1008	(7.49519052838329,19.75)
4650	2320	(35.208003449485325,43.75)
4651	1051	(9.6602540378443873,20.5)
4652	2104	(20.918584287042091,40)
4653	1047	(6.196152422706632,20.5)
4654	2186	(22.650635094610966,41.5)
4655	1902	(19.619546181365433,36.25)
4656	1822	(19.619546181365433,34.75)
4657	2178	(15.722431864335457,41.5)
4658	1934	(12.258330249197702,37)
4659	2178	(15.722431864335457,41.5)
4660	1934	(12.258330249197702,37)
4661	2056	(14.423393758658799,39.25)
4662	748	(24.382685902179844,14.5)
4663	827	(23.516660498395403,16)
4664	1790	(26.114736709748719,34)
4665	855	(13.55736835487436,16.75)
4666	855	(13.55736835487436,16.75)
4667	894	(12.258330249197702,17.5)
4668	1869	(25.248711305964282,35.5)
4669	1869	(25.248711305964282,35.5)
4670	1538	(15.722431864335457,29.5)
4671	1537	(14.856406460551018,29.5)
4672	1577	(15.289419162443238,30.25)
4673	1537	(14.856406460551018,29.5)
4674	1659	(17.021469970012117,31.75)
4675	1618	(15.722431864335457,31)
4676	2194	(29.578838324886476,41.5)
4677	2040	(34.774990747593108,38.5)
4678	2156	(31.743901834347572,40.75)
4679	2159	(34.341978045700891,40.75)
4680	2040	(34.774990747593108,38.5)
4681	2040	(34.774990747593108,38.5)
4682	2200	(34.774990747593108,41.5)
4683	1869	(25.248711305964282,35.5)
4684	2399	(34.341978045700891,45.25)
4685	2400	(35.208003449485325,45.25)
4686	1911	(27.413774815425377,36.25)
4687	1831	(27.413774815425377,34.75)
4688	1790	(26.114736709748719,34)
4689	1534	(12.258330249197702,29.5)
4690	1905	(22.217622392718749,36.25)
4691	1905	(22.217622392718749,36.25)
4692	1866	(22.650635094610966,35.5)
4693	2289	(8.3612159321677293,43.75)
4694	1160	(34.774990747593108,22)
4695	1160	(34.774990747593108,22)
4696	1160	(34.774990747593108,22)
4697	2317	(32.609927238132009,43.75)
4698	2269	(25.248711305964282,43)
4699	2358	(33.042939940024233,44.5)
4700	1356	(31.743901834347572,25.75)
4701	2225	(22.217622392718749,42.25)
4702	292	(10.959292143521045,6.25)
4703	1220	(17.454482671904334,23.5)
4704	1883	(3.1650635094610968,36.25)
4705	1112	(28.279800219209818,21.25)
4706	1152	(27.846787517317598,22)
4707	1219	(16.588457268119896,23.5)
4708	1140	(17.454482671904334,22)
4709	1182	(19.619546181365433,22.75)
4710	2388	(24.815698604072061,45.25)
4711	2299	(17.021469970012117,43.75)
4712	2386	(23.083647796503186,45.25)
4713	2299	(17.021469970012117,43.75)
4714	2181	(18.320508075688775,41.5)
4715	2347	(23.516660498395403,44.5)
4716	2264	(20.918584287042091,43)
4717	2222	(19.619546181365433,42.25)
4718	2262	(19.186533479473212,43)
4719	2302	(19.619546181365433,43.75)
4720	2381	(18.753520777580992,45.25)
4721	2382	(19.619546181365433,45.25)
4722	2381	(18.753520777580992,45.25)
4723	2305	(22.217622392718749,43.75)
4724	2302	(19.619546181365433,43.75)
4725	2345	(21.784609690826528,44.5)
4726	2382	(19.619546181365433,45.25)
4727	2285	(4.897114317029974,43.75)
4728	2363	(3.1650635094610968,45.25)
4729	2368	(7.49519052838329,45.25)
4730	2324	(3.598076211353316,44.5)
4731	2365	(4.897114317029974,45.25)
4732	2365	(4.897114317029974,45.25)
4733	2367	(6.6291651245988508,45.25)
4734	2367	(6.6291651245988508,45.25)
4735	2327	(6.196152422706632,44.5)
4736	2321	(1,44.5)
4737	2321	(1,44.5)
4738	2321	(1,44.5)
4739	2243	(2.7320508075688772,43)
4740	632	(28.279800219209818,12.25)
4741	632	(28.279800219209818,12.25)
4742	632	(28.279800219209818,12.25)
4743	632	(28.279800219209818,12.25)
4744	33	(28.712812921102035,1)
4745	73	(29.145825622994256,1.75)
4746	151	(27.413774815425377,3.25)
4747	398	(33.47595264191645,7.75)
4748	33	(28.712812921102035,1)
4749	113	(28.712812921102035,2.5)
4750	73	(29.145825622994256,1.75)
4751	192	(27.846787517317598,4)
4752	632	(28.279800219209818,12.25)
4753	33	(28.712812921102035,1)
4754	33	(28.712812921102035,1)
4755	33	(28.712812921102035,1)
4756	31	(26.98076211353316,1)
4757	879	(34.341978045700891,16.75)
4758	33	(28.712812921102035,1)
4759	840	(34.774990747593108,16)
4760	33	(28.712812921102035,1)
4761	1036	(31.743901834347572,19.75)
4762	1036	(31.743901834347572,19.75)
4763	1036	(31.743901834347572,19.75)
4764	1076	(31.310889132455351,20.5)
4765	1036	(31.743901834347572,19.75)
4766	1036	(31.743901834347572,19.75)
4767	37	(32.176914536239792,1)
4768	80	(35.208003449485325,1.75)
4769	37	(32.176914536239792,1)
4770	80	(35.208003449485325,1.75)
4771	1237	(32.176914536239792,23.5)
4772	1197	(32.609927238132009,22.75)
4773	1040	(35.208003449485325,19.75)
4774	1040	(35.208003449485325,19.75)
4775	1352	(28.279800219209818,25.75)
4776	1352	(28.279800219209818,25.75)
4777	1390	(26.114736709748719,26.5)
4778	1312	(27.846787517317598,25)
4779	1312	(27.846787517317598,25)
4780	1430	(26.54774941164094,27.25)
4781	1427	(23.949673200287624,27.25)
4782	1427	(23.949673200287624,27.25)
4783	1427	(23.949673200287624,27.25)
4784	1424	(21.351596988934308,27.25)
4785	1462	(19.186533479473212,28)
4786	1467	(23.516660498395403,28)
4787	1462	(19.186533479473212,28)
4788	1462	(19.186533479473212,28)
4789	1277	(32.609927238132009,24.25)
4790	1277	(32.609927238132009,24.25)
4791	1277	(32.609927238132009,24.25)
4792	1476	(31.310889132455351,28)
4793	1753	(29.145825622994256,33.25)
4794	1715	(30.444863728670914,32.5)
4795	1676	(31.743901834347572,31.75)
4796	1717	(32.176914536239792,32.5)
4797	1718	(33.042939940024233,32.5)
4798	1759	(34.341978045700891,33.25)
4799	1760	(35.208003449485325,33.25)
4800	716	(31.743901834347572,13.75)
4801	716	(31.743901834347572,13.75)
4802	717	(32.609927238132009,13.75)
4803	485	(4.4641016151377544,10)
4804	1253	(11.825317547305483,24.25)
4805	1591	(27.413774815425377,30.25)
4806	1633	(28.712812921102035,31)
4807	941	(18.753520777580992,18.25)
4808	2352	(27.846787517317598,44.5)
4809	2394	(30.011851026778693,45.25)
4810	2392	(28.279800219209818,45.25)
4811	2392	(28.279800219209818,45.25)
4812	2352	(27.846787517317598,44.5)
4813	2392	(28.279800219209818,45.25)
4814	2392	(28.279800219209818,45.25)
4815	2237	(32.609927238132009,42.25)
4816	170	(8.794228634059948,4)
4817	1545	(21.784609690826528,29.5)
4818	1545	(21.784609690826528,29.5)
4819	1464	(20.918584287042091,28)
4820	1464	(20.918584287042091,28)
4821	1544	(20.918584287042091,29.5)
4822	1312	(27.846787517317598,25)
4823	1312	(27.846787517317598,25)
4824	1430	(26.54774941164094,27.25)
4825	1430	(26.54774941164094,27.25)
4826	1877	(32.176914536239792,35.5)
4827	1995	(30.877876430563134,37.75)
4828	1877	(32.176914536239792,35.5)
4829	2118	(33.042939940024233,40)
4830	1993	(29.145825622994256,37.75)
4831	1993	(29.145825622994256,37.75)
4832	2109	(25.248711305964282,40)
4833	2067	(23.949673200287624,39.25)
4834	1240	(34.774990747593108,23.5)
4835	1240	(34.774990747593108,23.5)
4836	1240	(34.774990747593108,23.5)
4837	1240	(34.774990747593108,23.5)
4838	1360	(35.208003449485325,25.75)
4839	1440	(35.208003449485325,27.25)
4840	1597	(32.609927238132009,30.25)
4841	1600	(35.208003449485325,30.25)
4842	1834	(30.011851026778693,34.75)
4843	1355	(30.877876430563134,25.75)
4844	1871	(26.98076211353316,35.5)
4845	1911	(27.413774815425377,36.25)
4846	1724	(4.0310889132455356,33.25)
4847	2157	(32.609927238132009,40.75)
4848	2156	(31.743901834347572,40.75)
4849	859	(17.021469970012117,16.75)
4850	780	(17.887495373796554,15.25)
4851	698	(16.155444566227676,13.75)
4852	819	(16.588457268119896,16)
4853	819	(16.588457268119896,16)
4854	336	(13.99038105676658,7)
4855	295	(13.55736835487436,6.25)
4856	216	(14.423393758658799,4.75)
4857	336	(13.99038105676658,7)
4858	336	(13.99038105676658,7)
4859	2375	(13.55736835487436,45.25)
4860	2377	(15.289419162443238,45.25)
4861	2376	(14.423393758658799,45.25)
4862	2373	(11.825317547305483,45.25)
4863	2373	(11.825317547305483,45.25)
4864	2371	(10.093266739736606,45.25)
4865	2279	(33.908965343808667,43)
4866	1902	(19.619546181365433,36.25)
4867	2280	(34.774990747593108,43)
4868	2396	(31.743901834347572,45.25)
4869	2396	(31.743901834347572,45.25)
4870	2312	(28.279800219209818,43.75)
4871	2154	(30.011851026778693,40.75)
4872	2313	(29.145825622994256,43.75)
4873	2233	(29.145825622994256,42.25)
4874	1960	(34.774990747593108,37)
4875	2196	(31.310889132455351,41.5)
4876	2359	(33.908965343808667,44.5)
4877	2279	(33.908965343808667,43)
4878	2310	(26.54774941164094,43.75)
4879	1669	(25.681724007856502,31.75)
4880	1743	(20.48557158514987,33.25)
4881	1669	(25.681724007856502,31.75)
4882	1669	(25.681724007856502,31.75)
4883	1628	(24.382685902179844,31)
4884	1628	(24.382685902179844,31)
4885	1669	(25.681724007856502,31.75)
4886	835	(30.444863728670914,16)
4887	915	(30.444863728670914,17.5)
4888	835	(30.444863728670914,16)
4889	792	(28.279800219209818,15.25)
4890	792	(28.279800219209818,15.25)
4891	792	(28.279800219209818,15.25)
4892	954	(30.011851026778693,18.25)
4893	1031	(27.413774815425377,19.75)
4894	990	(26.114736709748719,19)
4895	948	(24.815698604072061,18.25)
4896	947	(23.949673200287624,18.25)
4897	946	(23.083647796503186,18.25)
4898	1885	(4.897114317029974,36.25)
4899	1925	(4.4641016151377544,37)
4900	1885	(4.897114317029974,36.25)
4901	2003	(2.7320508075688772,38.5)
4902	2004	(3.598076211353316,38.5)
4903	1925	(4.4641016151377544,37)
4904	1885	(4.897114317029974,36.25)
4905	223	(20.48557158514987,4.75)
4906	223	(20.48557158514987,4.75)
4907	223	(20.48557158514987,4.75)
4908	301	(18.753520777580992,6.25)
4909	339	(16.588457268119896,7)
4910	339	(16.588457268119896,7)
4911	1	(1,1)
4912	1	(1,1)
4913	1	(1,1)
4914	1000	(34.774990747593108,19)
4915	1000	(34.774990747593108,19)
4916	1427	(23.949673200287624,27.25)
4917	1427	(23.949673200287624,27.25)
4918	1427	(23.949673200287624,27.25)
4919	1467	(23.516660498395403,28)
4920	1333	(11.825317547305483,25.75)
4921	1333	(11.825317547305483,25.75)
4922	447	(6.6291651245988508,9.25)
4923	443	(3.1650635094610968,9.25)
4924	682	(2.299038105676658,13.75)
4925	482	(1.8660254037844386,10)
4926	564	(3.598076211353316,11.5)
4927	603	(3.1650635094610968,12.25)
4928	521	(1.4330127018922194,10.75)
4929	1290	(8.794228634059948,25)
4930	1249	(8.3612159321677293,24.25)
4931	1249	(8.3612159321677293,24.25)
4932	1248	(7.49519052838329,24.25)
4933	841	(1.4330127018922194,16.75)
4934	1286	(5.3301270189221936,25)
4935	882	(1.8660254037844386,17.5)
4936	1328	(7.49519052838329,25.75)
4937	1287	(6.196152422706632,25)
4938	1287	(6.196152422706632,25)
4939	1202	(1.8660254037844386,23.5)
4940	841	(1.4330127018922194,16.75)
4941	1203	(2.7320508075688772,23.5)
4942	921	(1.4330127018922194,18.25)
4943	1203	(2.7320508075688772,23.5)
4944	1203	(2.7320508075688772,23.5)
4945	1203	(2.7320508075688772,23.5)
4946	841	(1.4330127018922194,16.75)
4947	841	(1.4330127018922194,16.75)
4948	965	(4.4641016151377544,19)
4949	1203	(2.7320508075688772,23.5)
4950	1203	(2.7320508075688772,23.5)
4951	1203	(2.7320508075688772,23.5)
4952	965	(4.4641016151377544,19)
4953	1162	(2.299038105676658,22.75)
4954	921	(1.4330127018922194,18.25)
4955	921	(1.4330127018922194,18.25)
4956	921	(1.4330127018922194,18.25)
4957	1162	(2.299038105676658,22.75)
4958	841	(1.4330127018922194,16.75)
4959	921	(1.4330127018922194,18.25)
4960	921	(1.4330127018922194,18.25)
4961	921	(1.4330127018922194,18.25)
4962	921	(1.4330127018922194,18.25)
4963	921	(1.4330127018922194,18.25)
4964	921	(1.4330127018922194,18.25)
4965	921	(1.4330127018922194,18.25)
4966	921	(1.4330127018922194,18.25)
4967	921	(1.4330127018922194,18.25)
4968	921	(1.4330127018922194,18.25)
4969	921	(1.4330127018922194,18.25)
4970	921	(1.4330127018922194,18.25)
4971	921	(1.4330127018922194,18.25)
4972	921	(1.4330127018922194,18.25)
4973	80	(35.208003449485325,1.75)
4974	80	(35.208003449485325,1.75)
4975	79	(34.341978045700891,1.75)
4976	921	(1.4330127018922194,18.25)
4977	990	(26.114736709748719,19)
4978	682	(2.299038105676658,13.75)
4979	1164	(4.0310889132455356,22.75)
4980	443	(3.1650635094610968,9.25)
4981	524	(4.0310889132455356,10.75)
4982	601	(1.4330127018922194,12.25)
4983	601	(1.4330127018922194,12.25)
4984	603	(3.1650635094610968,12.25)
4985	1249	(8.3612159321677293,24.25)
4986	1249	(8.3612159321677293,24.25)
4987	482	(1.8660254037844386,10)
4988	1249	(8.3612159321677293,24.25)
4989	1046	(5.3301270189221936,20.5)
4990	1287	(6.196152422706632,25)
4991	1287	(6.196152422706632,25)
4992	1204	(3.598076211353316,23.5)
4993	964	(3.598076211353316,19)
4994	990	(26.114736709748719,19)
4995	560	(35.208003449485325,10.75)
4996	478	(33.47595264191645,9.25)
4997	478	(33.47595264191645,9.25)
4998	478	(33.47595264191645,9.25)
4999	439	(33.908965343808667,8.5)
5000	560	(35.208003449485325,10.75)
5001	388	(24.815698604072061,7.75)
5002	558	(33.47595264191645,10.75)
5003	1427	(23.949673200287624,27.25)
5004	400	(35.208003449485325,7.75)
5005	360	(34.774990747593108,7)
5006	360	(34.774990747593108,7)
5007	1137	(14.856406460551018,22)
5008	1137	(14.856406460551018,22)
5009	436	(31.310889132455351,8.5)
5010	477	(32.609927238132009,9.25)
5011	398	(33.47595264191645,7.75)
5012	440	(34.774990747593108,8.5)
5013	477	(32.609927238132009,9.25)
5014	477	(32.609927238132009,9.25)
5015	477	(32.609927238132009,9.25)
5016	398	(33.47595264191645,7.75)
5017	398	(33.47595264191645,7.75)
5018	440	(34.774990747593108,8.5)
5019	400	(35.208003449485325,7.75)
5020	440	(34.774990747593108,8.5)
5021	360	(34.774990747593108,7)
5022	145	(22.217622392718749,3.25)
5023	146	(23.083647796503186,3.25)
5024	105	(21.784609690826528,2.5)
5025	438	(33.042939940024233,8.5)
5026	400	(35.208003449485325,7.75)
5027	400	(35.208003449485325,7.75)
5028	360	(34.774990747593108,7)
5029	279	(33.908965343808667,5.5)
5030	477	(32.609927238132009,9.25)
5031	477	(32.609927238132009,9.25)
5032	477	(32.609927238132009,9.25)
5033	398	(33.47595264191645,7.75)
5034	440	(34.774990747593108,8.5)
5035	440	(34.774990747593108,8.5)
5036	440	(34.774990747593108,8.5)
5037	360	(34.774990747593108,7)
5038	2137	(15.289419162443238,40.75)
5039	1770	(8.794228634059948,34)
5040	1814	(12.691342951089922,34.75)
5041	1739	(17.021469970012117,33.25)
5042	1739	(17.021469970012117,33.25)
5043	1772	(10.526279441628825,34)
5044	1863	(20.05255888325765,35.5)
5045	1822	(19.619546181365433,34.75)
5046	1694	(12.258330249197702,32.5)
5047	1893	(11.825317547305483,36.25)
5048	1694	(12.258330249197702,32.5)
5049	1893	(11.825317547305483,36.25)
5050	1977	(15.289419162443238,37.75)
5051	1977	(15.289419162443238,37.75)
5052	1863	(20.05255888325765,35.5)
5053	1977	(15.289419162443238,37.75)
5054	1728	(7.49519052838329,33.25)
5055	1728	(7.49519052838329,33.25)
5056	1728	(7.49519052838329,33.25)
5057	2207	(6.6291651245988508,42.25)
5058	2247	(6.196152422706632,43)
5059	1965	(4.897114317029974,37.75)
5060	1965	(4.897114317029974,37.75)
5061	2134	(12.691342951089922,40.75)
5062	2247	(6.196152422706632,43)
5063	2003	(2.7320508075688772,38.5)
5064	2041	(1.4330127018922194,39.25)
5065	2053	(11.825317547305483,39.25)
5066	1767	(6.196152422706632,34)
5067	1925	(4.4641016151377544,37)
5068	2207	(6.6291651245988508,42.25)
5069	2207	(6.6291651245988508,42.25)
5070	2085	(4.4641016151377544,40)
5071	2085	(4.4641016151377544,40)
5072	2084	(3.598076211353316,40)
5073	2209	(8.3612159321677293,42.25)
5074	2084	(3.598076211353316,40)
5075	2128	(7.49519052838329,40.75)
5076	2005	(4.4641016151377544,38.5)
5077	2127	(6.6291651245988508,40.75)
5078	2207	(6.6291651245988508,42.25)
5079	2127	(6.6291651245988508,40.75)
5080	2127	(6.6291651245988508,40.75)
5081	2082	(1.8660254037844386,40)
5082	1965	(4.897114317029974,37.75)
5083	2172	(10.526279441628825,41.5)
5084	2127	(6.6291651245988508,40.75)
5085	2207	(6.6291651245988508,42.25)
5086	2004	(3.598076211353316,38.5)
5087	2123	(3.1650635094610968,40.75)
5088	101	(18.320508075688775,2.5)
5089	58	(16.155444566227676,1.75)
5090	17	(14.856406460551018,1)
5091	17	(14.856406460551018,1)
5092	17	(14.856406460551018,1)
5093	10	(8.794228634059948,1)
5094	10	(8.794228634059948,1)
5095	178	(15.722431864335457,4)
5096	785	(22.217622392718749,15.25)
5097	785	(22.217622392718749,15.25)
5098	785	(22.217622392718749,15.25)
5099	785	(22.217622392718749,15.25)
5100	2124	(4.0310889132455356,40.75)
5101	2150	(26.54774941164094,40.75)
5102	2187	(23.516660498395403,41.5)
5103	2186	(22.650635094610966,41.5)
5104	178	(15.722431864335457,4)
5105	283	(3.1650635094610968,6.25)
5106	321	(1,7)
5107	321	(1,7)
5108	241	(1,5.5)
5109	321	(1,7)
5110	241	(1,5.5)
5111	7	(6.196152422706632,1)
5112	7	(6.196152422706632,1)
5113	6	(5.3301270189221936,1)
5114	45	(4.897114317029974,1.75)
5115	45	(4.897114317029974,1.75)
5116	82	(1.8660254037844386,2.5)
5117	2225	(22.217622392718749,42.25)
5118	2225	(22.217622392718749,42.25)
5119	2148	(24.815698604072061,40.75)
5120	2186	(22.650635094610966,41.5)
5121	1	(1,1)
5122	1	(1,1)
5123	805	(4.4641016151377544,16)
5124	1254	(12.691342951089922,24.25)
5125	1648	(7.49519052838329,31.75)
5126	1605	(4.4641016151377544,31)
5127	1563	(3.1650635094610968,30.25)
5128	1605	(4.4641016151377544,31)
5129	1762	(1.8660254037844386,34)
5130	2200	(34.774990747593108,41.5)
5131	1911	(27.413774815425377,36.25)
5132	1725	(4.897114317029974,33.25)
5133	439	(33.908965343808667,8.5)
5134	1725	(4.897114317029974,33.25)
5135	1684	(3.598076211353316,32.5)
5136	1603	(2.7320508075688772,31)
5137	1523	(2.7320508075688772,29.5)
5138	2371	(10.093266739736606,45.25)
5139	1521	(1,29.5)
5140	1100	(17.887495373796554,21.25)
5141	11	(9.6602540378443873,1)
5142	15	(13.124355652982141,1)
5143	2085	(4.4641016151377544,40)
5144	2004	(3.598076211353316,38.5)
5145	2123	(3.1650635094610968,40.75)
5146	2200	(34.774990747593108,41.5)
5147	2356	(31.310889132455351,44.5)
5148	1869	(25.248711305964282,35.5)
5149	2123	(3.1650635094610968,40.75)
5150	2044	(4.0310889132455356,39.25)
5151	2123	(3.1650635094610968,40.75)
5152	2085	(4.4641016151377544,40)
5153	2399	(34.341978045700891,45.25)
5154	2400	(35.208003449485325,45.25)
5155	2159	(34.341978045700891,40.75)
5156	1952	(27.846787517317598,37)
5157	2350	(26.114736709748719,44.5)
5158	2041	(1.4330127018922194,39.25)
5159	1160	(34.774990747593108,22)
5160	1160	(34.774990747593108,22)
5161	1360	(35.208003449485325,25.75)
5162	2317	(32.609927238132009,43.75)
5163	2269	(25.248711305964282,43)
5164	2358	(33.042939940024233,44.5)
5165	1356	(31.743901834347572,25.75)
5166	1240	(34.774990747593108,23.5)
5167	1240	(34.774990747593108,23.5)
5168	1360	(35.208003449485325,25.75)
5169	1480	(34.774990747593108,28)
5170	821	(18.320508075688775,16)
5171	777	(15.289419162443238,15.25)
5172	821	(18.320508075688775,16)
5173	818	(15.722431864335457,16)
5174	737	(14.856406460551018,14.5)
5175	255	(13.124355652982141,5.5)
5176	336	(13.99038105676658,7)
5177	214	(12.691342951089922,4.75)
5178	295	(13.55736835487436,6.25)
5179	214	(12.691342951089922,4.75)
5180	13	(11.392304845413264,1)
5181	971	(9.6602540378443873,19)
5182	254	(12.258330249197702,5.5)
5183	1955	(30.444863728670914,37)
5184	1952	(27.846787517317598,37)
5185	1610	(8.794228634059948,31)
5186	1648	(7.49519052838329,31.75)
5187	1527	(6.196152422706632,29.5)
5188	1521	(1,29.5)
5189	1521	(1,29.5)
5190	861	(18.753520777580992,16.75)
5191	737	(14.856406460551018,14.5)
5192	1520	(35.208003449485325,28.75)
5193	1440	(35.208003449485325,27.25)
5194	1911	(27.413774815425377,36.25)
5195	1116	(31.743901834347572,21.25)
5196	2371	(10.093266739736606,45.25)
5197	1786	(22.650635094610966,34)
5198	1786	(22.650635094610966,34)
5199	2372	(10.959292143521045,45.25)
5200	2371	(10.093266739736606,45.25)
5201	1786	(22.650635094610966,34)
5202	1786	(22.650635094610966,34)
5203	1786	(22.650635094610966,34)
5204	2332	(10.526279441628825,44.5)
5205	2372	(10.959292143521045,45.25)
5206	2374	(12.691342951089922,45.25)
5207	2374	(12.691342951089922,45.25)
5208	2373	(11.825317547305483,45.25)
5209	2372	(10.959292143521045,45.25)
5210	2372	(10.959292143521045,45.25)
5211	2332	(10.526279441628825,44.5)
5212	2397	(32.609927238132009,45.25)
5213	2397	(32.609927238132009,45.25)
5214	2397	(32.609927238132009,45.25)
5215	2035	(30.444863728670914,38.5)
5216	2033	(28.712812921102035,38.5)
5217	2033	(28.712812921102035,38.5)
5218	2109	(25.248711305964282,40)
5219	1650	(9.2272413359521668,31.75)
5220	1606	(5.3301270189221936,31)
5221	1641	(1.4330127018922194,31.75)
5222	1605	(4.4641016151377544,31)
5223	1562	(2.299038105676658,30.25)
5224	767	(6.6291651245988508,15.25)
5225	767	(6.6291651245988508,15.25)
5226	2348	(24.382685902179844,44.5)
5227	2348	(24.382685902179844,44.5)
5228	2262	(19.186533479473212,43)
5229	2364	(4.0310889132455356,45.25)
5230	2285	(4.897114317029974,43.75)
5231	2306	(23.083647796503186,43.75)
5232	2345	(21.784609690826528,44.5)
5233	2342	(19.186533479473212,44.5)
5234	2382	(19.619546181365433,45.25)
5235	478	(33.47595264191645,9.25)
5236	478	(33.47595264191645,9.25)
5237	478	(33.47595264191645,9.25)
5238	479	(34.341978045700891,9.25)
5239	145	(22.217622392718749,3.25)
5240	105	(21.784609690826528,2.5)
5241	360	(34.774990747593108,7)
5242	558	(33.47595264191645,10.75)
5243	439	(33.908965343808667,8.5)
5244	1393	(28.712812921102035,26.5)
5245	2111	(26.98076211353316,40)
5246	2112	(27.846787517317598,40)
5247	2070	(26.54774941164094,39.25)
5248	1681	(1,32.5)
5249	1841	(1,35.5)
5250	1841	(1,35.5)
5251	1761	(1,34)
5252	1761	(1,34)
5253	1522	(1.8660254037844386,29.5)
5254	2371	(10.093266739736606,45.25)
5255	2105	(21.784609690826528,40)
5256	2105	(21.784609690826528,40)
5257	2106	(22.650635094610966,40)
5258	2070	(26.54774941164094,39.25)
5259	886	(5.3301270189221936,17.5)
5260	846	(5.7631397208144124,16.75)
5261	886	(5.3301270189221936,17.5)
5262	360	(34.774990747593108,7)
5263	348	(24.382685902179844,7)
5264	240	(35.208003449485325,4.75)
5265	437	(32.176914536239792,8.5)
5266	439	(33.908965343808667,8.5)
5267	2381	(18.753520777580992,45.25)
5268	2380	(17.887495373796554,45.25)
5269	2380	(17.887495373796554,45.25)
5270	2388	(24.815698604072061,45.25)
5271	2323	(2.7320508075688772,44.5)
5272	2085	(4.4641016151377544,40)
5273	2084	(3.598076211353316,40)
5274	2128	(7.49519052838329,40.75)
5275	1934	(12.258330249197702,37)
5276	2005	(4.4641016151377544,38.5)
5277	2244	(3.598076211353316,43)
5278	2284	(4.0310889132455356,43.75)
5279	2362	(2.299038105676658,45.25)
5280	2241	(1,43)
5281	2362	(2.299038105676658,45.25)
5282	2243	(2.7320508075688772,43)
5283	2241	(1,43)
5284	2241	(1,43)
5285	2241	(1,43)
5286	2281	(1.4330127018922194,43.75)
5287	2241	(1,43)
5288	2241	(1,43)
5289	2241	(1,43)
5290	2241	(1,43)
5291	2055	(13.55736835487436,39.25)
5292	1934	(12.258330249197702,37)
5293	1670	(26.54774941164094,31.75)
5294	1934	(12.258330249197702,37)
5295	1749	(25.681724007856502,33.25)
5296	1708	(24.382685902179844,32.5)
5297	1708	(24.382685902179844,32.5)
5298	1708	(24.382685902179844,32.5)
5299	1708	(24.382685902179844,32.5)
5300	1708	(24.382685902179844,32.5)
5301	1706	(22.650635094610966,32.5)
5302	1706	(22.650635094610966,32.5)
5303	1444	(3.598076211353316,28)
5304	846	(5.7631397208144124,16.75)
5305	1219	(16.588457268119896,23.5)
5306	1427	(23.949673200287624,27.25)
5307	1471	(26.98076211353316,28)
5308	1509	(25.681724007856502,28.75)
5309	1545	(21.784609690826528,29.5)
5310	1623	(20.05255888325765,31)
5311	2241	(1,43)
5312	1790	(26.114736709748719,34)
5313	1831	(27.413774815425377,34.75)
5314	1790	(26.114736709748719,34)
5315	1905	(22.217622392718749,36.25)
5316	2289	(8.3612159321677293,43.75)
5317	2289	(8.3612159321677293,43.75)
5318	2289	(8.3612159321677293,43.75)
5319	2161	(1,41.5)
5320	2161	(1,41.5)
5321	1706	(22.650635094610966,32.5)
5322	1706	(22.650635094610966,32.5)
5323	1619	(16.588457268119896,31)
5324	1537	(14.856406460551018,29.5)
5325	1618	(15.722431864335457,31)
5326	1619	(16.588457268119896,31)
5327	1620	(17.454482671904334,31)
5328	2163	(2.7320508075688772,41.5)
5329	2242	(1.8660254037844386,43)
5330	911	(26.98076211353316,17.5)
5331	870	(26.54774941164094,16.75)
5332	1191	(27.413774815425377,22.75)
5333	1182	(19.619546181365433,22.75)
5334	1182	(19.619546181365433,22.75)
5335	1186	(23.083647796503186,22.75)
5336	1104	(21.351596988934308,21.25)
5337	1103	(20.48557158514987,21.25)
5338	1103	(20.48557158514987,21.25)
5339	1023	(20.48557158514987,19.75)
5340	1137	(14.856406460551018,22)
5341	1137	(14.856406460551018,22)
5342	2330	(8.794228634059948,44.5)
5343	1460	(17.454482671904334,28)
5344	1460	(17.454482671904334,28)
5345	1541	(18.320508075688775,29.5)
5346	1542	(19.186533479473212,29.5)
5347	1542	(19.186533479473212,29.5)
5348	1542	(19.186533479473212,29.5)
5349	1117	(32.609927238132009,21.25)
5350	1583	(20.48557158514987,30.25)
5351	1582	(19.619546181365433,30.25)
5352	904	(20.918584287042091,17.5)
5353	412	(10.526279441628825,8.5)
5354	1040	(35.208003449485325,19.75)
5355	1040	(35.208003449485325,19.75)
5356	1040	(35.208003449485325,19.75)
5357	1000	(34.774990747593108,19)
5358	1000	(34.774990747593108,19)
5359	1000	(34.774990747593108,19)
5360	1000	(34.774990747593108,19)
5361	358	(33.042939940024233,7)
5362	358	(33.042939940024233,7)
5363	358	(33.042939940024233,7)
5364	80	(35.208003449485325,1.75)
5365	80	(35.208003449485325,1.75)
5366	80	(35.208003449485325,1.75)
5367	79	(34.341978045700891,1.75)
5368	768	(7.49519052838329,15.25)
5369	1427	(23.949673200287624,27.25)
5370	1427	(23.949673200287624,27.25)
5371	1427	(23.949673200287624,27.25)
5372	1508	(24.815698604072061,28.75)
5373	1545	(21.784609690826528,29.5)
5374	1412	(10.959292143521045,27.25)
5375	1451	(9.6602540378443873,28)
5376	1174	(12.691342951089922,22.75)
5377	1544	(20.918584287042091,29.5)
5378	1490	(9.2272413359521668,28.75)
5379	1490	(9.2272413359521668,28.75)
5380	1137	(14.856406460551018,22)
5381	443	(3.1650635094610968,9.25)
5382	1248	(7.49519052838329,24.25)
5383	522	(2.299038105676658,10.75)
5384	1287	(6.196152422706632,25)
5385	1416	(14.423393758658799,27.25)
5386	1592	(28.279800219209818,30.25)
5387	1451	(9.6602540378443873,28)
5388	1547	(23.516660498395403,29.5)
5389	688	(7.49519052838329,13.75)
5390	688	(7.49519052838329,13.75)
5391	688	(7.49519052838329,13.75)
5392	688	(7.49519052838329,13.75)
5393	601	(1.4330127018922194,12.25)
5394	601	(1.4330127018922194,12.25)
5395	601	(1.4330127018922194,12.25)
5396	601	(1.4330127018922194,12.25)
5397	1411	(10.093266739736606,27.25)
5398	280	(34.774990747593108,5.5)
5399	320	(35.208003449485325,6.25)
5400	28	(24.382685902179844,1)
5401	24	(20.918584287042091,1)
5402	28	(24.382685902179844,1)
5403	37	(32.176914536239792,1)
5404	969	(7.9282032302755088,19)
5405	1205	(4.4641016151377544,23.5)
5406	1011	(10.093266739736606,19.75)
5407	1205	(4.4641016151377544,23.5)
5408	921	(1.4330127018922194,18.25)
5409	921	(1.4330127018922194,18.25)
5410	921	(1.4330127018922194,18.25)
5411	921	(1.4330127018922194,18.25)
5412	2064	(21.351596988934308,39.25)
5413	921	(1.4330127018922194,18.25)
5414	1019	(17.021469970012117,19.75)
5415	1135	(13.124355652982141,22)
5416	1135	(13.124355652982141,22)
5417	1135	(13.124355652982141,22)
5418	240	(35.208003449485325,4.75)
5419	1135	(13.124355652982141,22)
5420	971	(9.6602540378443873,19)
5421	360	(34.774990747593108,7)
5422	1476	(31.310889132455351,28)
5423	1760	(35.208003449485325,33.25)
5424	1715	(30.444863728670914,32.5)
5425	1717	(32.176914536239792,32.5)
5426	1718	(33.042939940024233,32.5)
5427	1759	(34.341978045700891,33.25)
5428	1760	(35.208003449485325,33.25)
5429	1680	(35.208003449485325,31.75)
5430	412	(10.526279441628825,8.5)
5431	412	(10.526279441628825,8.5)
5432	1746	(23.083647796503186,33.25)
5433	1119	(34.341978045700891,21.25)
5434	1119	(34.341978045700891,21.25)
5435	1119	(34.341978045700891,21.25)
5436	782	(19.619546181365433,15.25)
5437	822	(19.186533479473212,16)
5438	1249	(8.3612159321677293,24.25)
5439	1248	(7.49519052838329,24.25)
5440	1715	(30.444863728670914,32.5)
5441	1718	(33.042939940024233,32.5)
5442	1759	(34.341978045700891,33.25)
5443	1680	(35.208003449485325,31.75)
5444	2016	(13.99038105676658,38.5)
5445	1812	(10.959292143521045,34.75)
5446	2217	(15.289419162443238,42.25)
5447	2016	(13.99038105676658,38.5)
5448	1933	(11.392304845413264,37)
5449	2178	(15.722431864335457,41.5)
5450	2177	(14.856406460551018,41.5)
5451	2128	(7.49519052838329,40.75)
5452	2128	(7.49519052838329,40.75)
5453	2315	(30.877876430563134,43.75)
5454	2394	(30.011851026778693,45.25)
5455	2238	(33.47595264191645,42.25)
5456	2274	(29.578838324886476,43)
5457	2274	(29.578838324886476,43)
5458	2274	(29.578838324886476,43)
5459	2274	(29.578838324886476,43)
5460	1205	(4.4641016151377544,23.5)
5461	1537	(14.856406460551018,29.5)
5462	1973	(11.825317547305483,37.75)
5463	1651	(10.093266739736606,31.75)
5464	2154	(30.011851026778693,40.75)
5465	1992	(28.279800219209818,37.75)
5466	2197	(32.176914536239792,41.5)
5467	1952	(27.846787517317598,37)
5468	1515	(30.877876430563134,28.75)
5469	880	(35.208003449485325,16.75)
5470	920	(34.774990747593108,17.5)
5471	1697	(14.856406460551018,32.5)
5472	2170	(8.794228634059948,41.5)
5473	921	(1.4330127018922194,18.25)
5474	1633	(28.712812921102035,31)
5475	921	(1.4330127018922194,18.25)
5476	921	(1.4330127018922194,18.25)
5477	907	(23.516660498395403,17.5)
5478	921	(1.4330127018922194,18.25)
5479	945	(22.217622392718749,18.25)
5480	907	(23.516660498395403,17.5)
5481	1215	(13.124355652982141,23.5)
5482	1215	(13.124355652982141,23.5)
5483	752	(27.846787517317598,14.5)
5484	794	(30.011851026778693,15.25)
5485	794	(30.011851026778693,15.25)
5486	792	(28.279800219209818,15.25)
5487	831	(26.98076211353316,16)
5488	831	(26.98076211353316,16)
5489	1417	(15.289419162443238,27.25)
5490	1298	(15.722431864335457,25)
5491	1298	(15.722431864335457,25)
5492	1256	(14.423393758658799,24.25)
5493	1379	(16.588457268119896,26.5)
5494	1470	(26.114736709748719,28)
5495	941	(18.753520777580992,18.25)
5496	1256	(14.423393758658799,24.25)
5497	1298	(15.722431864335457,25)
5498	1802	(2.299038105676658,34.75)
5499	1802	(2.299038105676658,34.75)
5500	1349	(25.681724007856502,25.75)
5501	1547	(23.516660498395403,29.5)
5502	1229	(25.248711305964282,23.5)
5503	936	(14.423393758658799,18.25)
5504	855	(13.55736835487436,16.75)
5505	813	(11.392304845413264,16)
5506	895	(13.124355652982141,17.5)
5507	1057	(14.856406460551018,20.5)
5508	972	(10.526279441628825,19)
5509	1013	(11.825317547305483,19.75)
5510	1232	(27.846787517317598,23.5)
5511	601	(1.4330127018922194,12.25)
5512	2154	(30.011851026778693,40.75)
5513	2194	(29.578838324886476,41.5)
5514	971	(9.6602540378443873,19)
5515	1623	(20.05255888325765,31)
5516	1411	(10.093266739736606,27.25)
5517	1411	(10.093266739736606,27.25)
5518	1411	(10.093266739736606,27.25)
5519	1519	(34.341978045700891,28.75)
5520	442	(2.299038105676658,9.25)
5521	483	(2.7320508075688772,10)
5522	1211	(9.6602540378443873,23.5)
5523	482	(1.8660254037844386,10)
5524	841	(1.4330127018922194,16.75)
5525	1333	(11.825317547305483,25.75)
5526	2372	(10.959292143521045,45.25)
5527	2372	(10.959292143521045,45.25)
5528	921	(1.4330127018922194,18.25)
5529	964	(3.598076211353316,19)
5530	1705	(21.784609690826528,32.5)
5531	1705	(21.784609690826528,32.5)
5532	921	(1.4330127018922194,18.25)
5533	921	(1.4330127018922194,18.25)
5534	1706	(22.650635094610966,32.5)
5535	841	(1.4330127018922194,16.75)
5536	1162	(2.299038105676658,22.75)
5537	921	(1.4330127018922194,18.25)
5538	921	(1.4330127018922194,18.25)
5539	921	(1.4330127018922194,18.25)
5540	841	(1.4330127018922194,16.75)
5541	1600	(35.208003449485325,30.25)
5542	1645	(4.897114317029974,31.75)
5543	1725	(4.897114317029974,33.25)
5544	1706	(22.650635094610966,32.5)
5545	1706	(22.650635094610966,32.5)
5546	1706	(22.650635094610966,32.5)
5547	2241	(1,43)
5548	805	(4.4641016151377544,16)
5549	805	(4.4641016151377544,16)
5550	805	(4.4641016151377544,16)
5551	805	(4.4641016151377544,16)
5552	845	(4.897114317029974,16.75)
5553	845	(4.897114317029974,16.75)
5554	805	(4.4641016151377544,16)
5555	765	(4.897114317029974,15.25)
5556	765	(4.897114317029974,15.25)
5557	765	(4.897114317029974,15.25)
5558	845	(4.897114317029974,16.75)
5559	845	(4.897114317029974,16.75)
5560	689	(8.3612159321677293,13.75)
5561	688	(7.49519052838329,13.75)
5562	727	(6.196152422706632,14.5)
5563	727	(6.196152422706632,14.5)
5564	1761	(1,34)
5565	1841	(1,35.5)
5566	1664	(21.351596988934308,31.75)
5567	1626	(22.650635094610966,31)
5568	688	(7.49519052838329,13.75)
5569	2070	(26.54774941164094,39.25)
5570	1652	(10.959292143521045,31.75)
5571	1650	(9.2272413359521668,31.75)
5572	1608	(7.0621778264910704,31)
5573	814	(12.258330249197702,16)
5574	1605	(4.4641016151377544,31)
5575	865	(22.217622392718749,16.75)
5576	1098	(16.155444566227676,21.25)
5577	1488	(7.49519052838329,28.75)
5578	687	(6.6291651245988508,13.75)
5579	727	(6.196152422706632,14.5)
5580	727	(6.196152422706632,14.5)
5581	765	(4.897114317029974,15.25)
5582	1761	(1,34)
5583	372	(10.959292143521045,7.75)
5584	1205	(4.4641016151377544,23.5)
5585	965	(4.4641016151377544,19)
5586	412	(10.526279441628825,8.5)
5587	964	(3.598076211353316,19)
5588	964	(3.598076211353316,19)
5589	1164	(4.0310889132455356,22.75)
5590	1706	(22.650635094610966,32.5)
5591	1706	(22.650635094610966,32.5)
5592	1706	(22.650635094610966,32.5)
5593	1162	(2.299038105676658,22.75)
5594	921	(1.4330127018922194,18.25)
5595	1164	(4.0310889132455356,22.75)
5596	1164	(4.0310889132455356,22.75)
5597	965	(4.4641016151377544,19)
5598	119	(33.908965343808667,2.5)
5599	119	(33.908965343808667,2.5)
5600	964	(3.598076211353316,19)
5601	964	(3.598076211353316,19)
5602	964	(3.598076211353316,19)
5603	1291	(9.6602540378443873,25)
5604	2127	(6.6291651245988508,40.75)
5605	1684	(3.598076211353316,32.5)
5606	1541	(18.320508075688775,29.5)
5607	372	(10.959292143521045,7.75)
5608	1610	(8.794228634059948,31)
5609	1724	(4.0310889132455356,33.25)
5610	1647	(6.6291651245988508,31.75)
5611	1606	(5.3301270189221936,31)
5612	1561	(1.4330127018922194,30.25)
5613	1605	(4.4641016151377544,31)
5614	920	(34.774990747593108,17.5)
5615	1524	(3.598076211353316,29.5)
5616	1605	(4.4641016151377544,31)
5617	436	(31.310889132455351,8.5)
5618	347	(23.516660498395403,7)
5619	118	(33.042939940024233,2.5)
5620	560	(35.208003449485325,10.75)
5621	24	(20.918584287042091,1)
5622	119	(33.908965343808667,2.5)
5623	118	(33.042939940024233,2.5)
5624	347	(23.516660498395403,7)
5625	1439	(34.341978045700891,27.25)
5626	1479	(33.908965343808667,28)
5627	145	(22.217622392718749,3.25)
5628	145	(22.217622392718749,3.25)
5629	24	(20.918584287042091,1)
5630	104	(20.918584287042091,2.5)
5631	104	(20.918584287042091,2.5)
5632	105	(21.784609690826528,2.5)
5633	360	(34.774990747593108,7)
5634	599	(33.908965343808667,11.5)
5635	1480	(34.774990747593108,28)
5636	320	(35.208003449485325,6.25)
5637	396	(31.743901834347572,7.75)
5638	437	(32.176914536239792,8.5)
5639	398	(33.47595264191645,7.75)
5640	438	(33.042939940024233,8.5)
5641	400	(35.208003449485325,7.75)
5642	28	(24.382685902179844,1)
5643	28	(24.382685902179844,1)
5644	28	(24.382685902179844,1)
5645	28	(24.382685902179844,1)
5646	66	(23.083647796503186,1.75)
5647	37	(32.176914536239792,1)
5648	37	(32.176914536239792,1)
5649	27	(23.516660498395403,1)
5650	28	(24.382685902179844,1)
5651	28	(24.382685902179844,1)
5652	1119	(34.341978045700891,21.25)
5653	1119	(34.341978045700891,21.25)
5654	720	(35.208003449485325,13.75)
5655	720	(35.208003449485325,13.75)
5656	720	(35.208003449485325,13.75)
5657	1480	(34.774990747593108,28)
5658	28	(24.382685902179844,1)
5659	28	(24.382685902179844,1)
5660	1040	(35.208003449485325,19.75)
5661	1040	(35.208003449485325,19.75)
5662	37	(32.176914536239792,1)
5663	37	(32.176914536239792,1)
5664	640	(35.208003449485325,12.25)
5665	200	(34.774990747593108,4)
5666	200	(34.774990747593108,4)
5667	353	(28.712812921102035,7)
5668	280	(34.774990747593108,5.5)
5669	280	(34.774990747593108,5.5)
5670	1117	(32.609927238132009,21.25)
5671	1117	(32.609927238132009,21.25)
5672	957	(32.609927238132009,18.25)
5673	1439	(34.341978045700891,27.25)
5674	1480	(34.774990747593108,28)
5675	1623	(20.05255888325765,31)
5676	1508	(24.815698604072061,28.75)
5677	80	(35.208003449485325,1.75)
5678	1620	(17.454482671904334,31)
5679	1620	(17.454482671904334,31)
5680	80	(35.208003449485325,1.75)
5681	2398	(33.47595264191645,45.25)
5682	2310	(26.54774941164094,43.75)
5683	2310	(26.54774941164094,43.75)
5684	2374	(12.691342951089922,45.25)
5685	481	(1,10)
5686	841	(1.4330127018922194,16.75)
5687	921	(1.4330127018922194,18.25)
5688	921	(1.4330127018922194,18.25)
5689	841	(1.4330127018922194,16.75)
5690	965	(4.4641016151377544,19)
5691	965	(4.4641016151377544,19)
5692	727	(6.196152422706632,14.5)
5693	727	(6.196152422706632,14.5)
5694	727	(6.196152422706632,14.5)
5695	727	(6.196152422706632,14.5)
5696	765	(4.897114317029974,15.25)
5697	1057	(14.856406460551018,20.5)
5698	1724	(4.0310889132455356,33.25)
5699	1242	(2.299038105676658,24.25)
5700	841	(1.4330127018922194,16.75)
5701	921	(1.4330127018922194,18.25)
5702	1804	(4.0310889132455356,34.75)
5703	1057	(14.856406460551018,20.5)
5704	1600	(35.208003449485325,30.25)
5705	1009	(8.3612159321677293,19.75)
5706	1190	(26.54774941164094,22.75)
5707	1605	(4.4641016151377544,31)
5708	1641	(1.4330127018922194,31.75)
5709	1256	(14.423393758658799,24.25)
5710	1216	(13.99038105676658,23.5)
5711	1215	(13.124355652982141,23.5)
5712	1216	(13.99038105676658,23.5)
5713	11	(9.6602540378443873,1)
5714	11	(9.6602540378443873,1)
5715	11	(9.6602540378443873,1)
5716	10	(8.794228634059948,1)
5717	1137	(14.856406460551018,22)
5718	11	(9.6602540378443873,1)
5719	938	(16.155444566227676,18.25)
5720	1057	(14.856406460551018,20.5)
5721	1600	(35.208003449485325,30.25)
5722	946	(23.083647796503186,18.25)
5723	1804	(4.0310889132455356,34.75)
5724	681	(1.4330127018922194,13.75)
5725	682	(2.299038105676658,13.75)
5726	682	(2.299038105676658,13.75)
5727	1945	(21.784609690826528,37)
5728	11	(9.6602540378443873,1)
5729	2161	(1,41.5)
5730	10	(8.794228634059948,1)
5731	11	(9.6602540378443873,1)
5732	360	(34.774990747593108,7)
5733	440	(34.774990747593108,8.5)
5734	145	(22.217622392718749,3.25)
5735	145	(22.217622392718749,3.25)
5736	64	(21.351596988934308,1.75)
5737	37	(32.176914536239792,1)
5738	320	(35.208003449485325,6.25)
5739	280	(34.774990747593108,5.5)
5740	280	(34.774990747593108,5.5)
5741	1203	(2.7320508075688772,23.5)
5742	1162	(2.299038105676658,22.75)
5743	921	(1.4330127018922194,18.25)
5744	921	(1.4330127018922194,18.25)
5745	28	(24.382685902179844,1)
5746	280	(34.774990747593108,5.5)
5747	320	(35.208003449485325,6.25)
5748	28	(24.382685902179844,1)
5749	24	(20.918584287042091,1)
5750	37	(32.176914536239792,1)
5751	1040	(35.208003449485325,19.75)
5752	1040	(35.208003449485325,19.75)
5753	1000	(34.774990747593108,19)
5754	1000	(34.774990747593108,19)
5755	1000	(34.774990747593108,19)
5756	765	(4.897114317029974,15.25)
5757	964	(3.598076211353316,19)
5758	964	(3.598076211353316,19)
5759	964	(3.598076211353316,19)
5760	964	(3.598076211353316,19)
5761	2289	(8.3612159321677293,43.75)
5762	2162	(1.8660254037844386,41.5)
5763	2237	(32.609927238132009,42.25)
5764	2273	(28.712812921102035,43)
5765	560	(35.208003449485325,10.75)
5766	240	(35.208003449485325,4.75)
5767	119	(33.908965343808667,2.5)
5768	240	(35.208003449485325,4.75)
5769	1945	(21.784609690826528,37)
5770	2028	(24.382685902179844,38.5)
5771	2028	(24.382685902179844,38.5)
5772	1920	(35.208003449485325,36.25)
5773	920	(34.774990747593108,17.5)
5774	599	(33.908965343808667,11.5)
5775	1802	(2.299038105676658,34.75)
5776	240	(35.208003449485325,4.75)
5777	1000	(34.774990747593108,19)
5778	921	(1.4330127018922194,18.25)
5779	1000	(34.774990747593108,19)
5780	1652	(10.959292143521045,31.75)
5781	1680	(35.208003449485325,31.75)
5782	437	(32.176914536239792,8.5)
5783	437	(32.176914536239792,8.5)
5784	437	(32.176914536239792,8.5)
5785	439	(33.908965343808667,8.5)
5786	2122	(2.299038105676658,40.75)
5787	2123	(3.1650635094610968,40.75)
5788	2123	(3.1650635094610968,40.75)
5789	119	(33.908965343808667,2.5)
5790	920	(34.774990747593108,17.5)
5791	920	(34.774990747593108,17.5)
5792	920	(34.774990747593108,17.5)
5793	400	(35.208003449485325,7.75)
5794	2372	(10.959292143521045,45.25)
5795	2372	(10.959292143521045,45.25)
5796	84	(3.598076211353316,2.5)
5797	241	(1,5.5)
5798	359	(33.908965343808667,7)
5799	241	(1,5.5)
5800	971	(9.6602540378443873,19)
5801	971	(9.6602540378443873,19)
5802	971	(9.6602540378443873,19)
5803	2034	(29.578838324886476,38.5)
5804	1240	(34.774990747593108,23.5)
5805	1240	(34.774990747593108,23.5)
5806	1440	(35.208003449485325,27.25)
5807	1600	(35.208003449485325,30.25)
5808	178	(15.722431864335457,4)
5809	1012	(10.959292143521045,19.75)
5810	1057	(14.856406460551018,20.5)
5811	1053	(11.392304845413264,20.5)
5812	1137	(14.856406460551018,22)
5813	1137	(14.856406460551018,22)
5814	2379	(17.021469970012117,45.25)
5815	2379	(17.021469970012117,45.25)
5816	1905	(22.217622392718749,36.25)
5817	2289	(8.3612159321677293,43.75)
5818	2373	(11.825317547305483,45.25)
5819	2384	(21.351596988934308,45.25)
5820	2374	(12.691342951089922,45.25)
5821	965	(4.4641016151377544,19)
5822	2323	(2.7320508075688772,44.5)
5823	2216	(14.423393758658799,42.25)
5824	2216	(14.423393758658799,42.25)
5825	2241	(1,43)
5826	2241	(1,43)
5827	2184	(20.918584287042091,41.5)
5828	1893	(11.825317547305483,36.25)
5829	1772	(10.526279441628825,34)
5830	1854	(12.258330249197702,35.5)
5831	1779	(16.588457268119896,34)
5832	2241	(1,43)
5833	2101	(18.320508075688775,40)
5834	2281	(1.4330127018922194,43.75)
5835	2241	(1,43)
5836	1973	(11.825317547305483,37.75)
5837	2323	(2.7320508075688772,44.5)
5838	2170	(8.794228634059948,41.5)
5839	2124	(4.0310889132455356,40.75)
5840	2124	(4.0310889132455356,40.75)
5841	1844	(3.598076211353316,35.5)
5842	1973	(11.825317547305483,37.75)
5843	1973	(11.825317547305483,37.75)
5844	1973	(11.825317547305483,37.75)
5845	2050	(9.2272413359521668,39.25)
5846	2050	(9.2272413359521668,39.25)
5847	2128	(7.49519052838329,40.75)
5848	2123	(3.1650635094610968,40.75)
5849	2006	(5.3301270189221936,38.5)
5850	2008	(7.0621778264910704,38.5)
5851	2131	(10.093266739736606,40.75)
5852	2128	(7.49519052838329,40.75)
5853	189	(25.248711305964282,4)
5854	2163	(2.7320508075688772,41.5)
5855	2202	(2.299038105676658,42.25)
5856	2284	(4.0310889132455356,43.75)
5857	2283	(3.1650635094610968,43.75)
5858	2243	(2.7320508075688772,43)
5859	2283	(3.1650635094610968,43.75)
5860	2324	(3.598076211353316,44.5)
5861	2323	(2.7320508075688772,44.5)
5862	2241	(1,43)
5863	2241	(1,43)
5864	941	(18.753520777580992,18.25)
5865	2242	(1.8660254037844386,43)
5866	2241	(1,43)
5867	1985	(22.217622392718749,37.75)
5868	980	(17.454482671904334,19)
5869	1905	(22.217622392718749,36.25)
5870	400	(35.208003449485325,7.75)
5871	2041	(1.4330127018922194,39.25)
5872	2041	(1.4330127018922194,39.25)
5873	2041	(1.4330127018922194,39.25)
5874	2190	(26.114736709748719,41.5)
5875	1627	(23.516660498395403,31)
5876	1627	(23.516660498395403,31)
5877	1627	(23.516660498395403,31)
5878	1626	(22.650635094610966,31)
5879	400	(35.208003449485325,7.75)
5880	1135	(13.124355652982141,22)
5881	2233	(29.145825622994256,42.25)
5882	2200	(34.774990747593108,41.5)
5883	2159	(34.341978045700891,40.75)
5884	601	(1.4330127018922194,12.25)
5885	601	(1.4330127018922194,12.25)
5886	524	(4.0310889132455356,10.75)
5887	2279	(33.908965343808667,43)
5888	1404	(4.0310889132455356,27.25)
5889	601	(1.4330127018922194,12.25)
5890	1011	(10.093266739736606,19.75)
5891	609	(8.3612159321677293,12.25)
5892	492	(10.526279441628825,10)
5893	494	(12.258330249197702,10)
5894	851	(10.093266739736606,16.75)
5895	850	(9.2272413359521668,16.75)
5896	1008	(7.49519052838329,19.75)
5897	607	(6.6291651245988508,12.25)
5898	723	(2.7320508075688772,14.5)
5899	723	(2.7320508075688772,14.5)
5900	682	(2.299038105676658,13.75)
5901	1128	(7.0621778264910704,22)
5902	1128	(7.0621778264910704,22)
5903	1283	(2.7320508075688772,25)
5904	925	(4.897114317029974,18.25)
5905	1241	(1.4330127018922194,24.25)
5906	925	(4.897114317029974,18.25)
5907	850	(9.2272413359521668,16.75)
5908	1041	(1,20.5)
5909	1041	(1,20.5)
5910	1041	(1,20.5)
5911	1592	(28.279800219209818,30.25)
5912	1745	(22.217622392718749,33.25)
5913	1669	(25.681724007856502,31.75)
5914	1626	(22.650635094610966,31)
5915	814	(12.258330249197702,16)
5916	851	(10.093266739736606,16.75)
5917	1244	(4.0310889132455356,24.25)
5918	1202	(1.8660254037844386,23.5)
5919	934	(12.691342951089922,18.25)
5920	2320	(35.208003449485325,43.75)
5921	1041	(1,20.5)
5922	850	(9.2272413359521668,16.75)
5923	936	(14.423393758658799,18.25)
5924	936	(14.423393758658799,18.25)
5925	1054	(12.258330249197702,20.5)
5926	454	(12.691342951089922,9.25)
5927	936	(14.423393758658799,18.25)
5928	454	(12.691342951089922,9.25)
5929	1591	(27.413774815425377,30.25)
5930	1831	(27.413774815425377,34.75)
5931	1534	(12.258330249197702,29.5)
5932	1112	(28.279800219209818,21.25)
5933	1804	(4.0310889132455356,34.75)
5934	1660	(17.887495373796554,31.75)
5935	2376	(14.423393758658799,45.25)
5936	2376	(14.423393758658799,45.25)
5937	1804	(4.0310889132455356,34.75)
5938	613	(11.825317547305483,12.25)
5939	1614	(12.258330249197702,31)
5940	2376	(14.423393758658799,45.25)
5941	2080	(35.208003449485325,39.25)
5942	2153	(29.145825622994256,40.75)
5943	2153	(29.145825622994256,40.75)
5944	1877	(32.176914536239792,35.5)
5945	1641	(1.4330127018922194,31.75)
5946	1681	(1,32.5)
5947	1504	(21.351596988934308,28.75)
5948	1917	(32.609927238132009,36.25)
5949	1879	(33.908965343808667,35.5)
5950	2037	(32.176914536239792,38.5)
5951	2153	(29.145825622994256,40.75)
5952	1878	(33.042939940024233,35.5)
5953	1879	(33.908965343808667,35.5)
5954	1312	(27.846787517317598,25)
5955	1312	(27.846787517317598,25)
5956	1430	(26.54774941164094,27.25)
5957	1545	(21.784609690826528,29.5)
5958	1584	(21.351596988934308,30.25)
5959	1584	(21.351596988934308,30.25)
5960	1623	(20.05255888325765,31)
5961	1617	(14.856406460551018,31)
5962	1618	(15.722431864335457,31)
5963	418	(15.722431864335457,8.5)
5964	664	(20.918584287042091,13)
5965	662	(19.186533479473212,13)
5966	2037	(32.176914536239792,38.5)
5967	577	(14.856406460551018,11.5)
5968	1620	(17.454482671904334,31)
5969	1106	(23.083647796503186,21.25)
5970	1104	(21.351596988934308,21.25)
5971	866	(23.083647796503186,16.75)
5972	1137	(14.856406460551018,22)
5973	1137	(14.856406460551018,22)
5974	1137	(14.856406460551018,22)
5975	1137	(14.856406460551018,22)
5976	1620	(17.454482671904334,31)
5977	1230	(26.114736709748719,23.5)
5978	1230	(26.114736709748719,23.5)
5979	1230	(26.114736709748719,23.5)
5980	1659	(17.021469970012117,31.75)
5981	655	(13.124355652982141,13)
5982	816	(13.99038105676658,16)
5983	418	(15.722431864335457,8.5)
5984	1623	(20.05255888325765,31)
5985	1623	(20.05255888325765,31)
5986	1623	(20.05255888325765,31)
5987	2285	(4.897114317029974,43.75)
5988	2368	(7.49519052838329,45.25)
5989	2368	(7.49519052838329,45.25)
5990	2382	(19.619546181365433,45.25)
5991	2380	(17.887495373796554,45.25)
5992	2380	(17.887495373796554,45.25)
5993	1384	(20.918584287042091,26.5)
5994	537	(15.289419162443238,10.75)
5995	2385	(22.217622392718749,45.25)
5996	2262	(19.186533479473212,43)
5997	2262	(19.186533479473212,43)
5998	2281	(1.4330127018922194,43.75)
5999	2285	(4.897114317029974,43.75)
6000	2244	(3.598076211353316,43)
6001	2281	(1.4330127018922194,43.75)
6002	2243	(2.7320508075688772,43)
6003	1384	(20.918584287042091,26.5)
6004	2303	(20.48557158514987,43.75)
6005	2381	(18.753520777580992,45.25)
6006	2380	(17.887495373796554,45.25)
6007	1889	(8.3612159321677293,36.25)
6008	1776	(13.99038105676658,34)
6009	1889	(8.3612159321677293,36.25)
6010	1779	(16.588457268119896,34)
6011	1814	(12.691342951089922,34.75)
6012	1897	(15.289419162443238,36.25)
6013	1895	(13.55736835487436,36.25)
6014	1889	(8.3612159321677293,36.25)
6015	1886	(5.7631397208144124,36.25)
6016	1929	(7.9282032302755088,37)
6017	1886	(5.7631397208144124,36.25)
6018	2094	(12.258330249197702,40)
6019	2214	(12.691342951089922,42.25)
6020	2051	(10.093266739736606,39.25)
6021	2050	(9.2272413359521668,39.25)
6022	2170	(8.794228634059948,41.5)
6023	2083	(2.7320508075688772,40)
6024	1924	(3.598076211353316,37)
6025	2084	(3.598076211353316,40)
6026	1738	(16.155444566227676,33.25)
6027	1891	(10.093266739736606,36.25)
6028	2167	(6.196152422706632,41.5)
6029	1814	(12.691342951089922,34.75)
6030	2007	(6.196152422706632,38.5)
6031	2212	(10.959292143521045,42.25)
6032	1977	(15.289419162443238,37.75)
6033	2011	(9.6602540378443873,38.5)
6034	60	(17.887495373796554,1.75)
6035	18	(15.722431864335457,1)
6036	138	(16.155444566227676,3.25)
6037	10	(8.794228634059948,1)
6038	11	(9.6602540378443873,1)
6039	2388	(24.815698604072061,45.25)
6040	2389	(25.681724007856502,45.25)
6041	13	(11.392304845413264,1)
6042	141	(18.753520777580992,3.25)
6043	140	(17.887495373796554,3.25)
6044	140	(17.887495373796554,3.25)
6045	135	(13.55736835487436,3.25)
6046	179	(16.588457268119896,4)
6047	179	(16.588457268119896,4)
6048	179	(16.588457268119896,4)
6049	2342	(19.186533479473212,44.5)
6050	2381	(18.753520777580992,45.25)
6051	2340	(17.454482671904334,44.5)
6052	2380	(17.887495373796554,45.25)
6053	2285	(4.897114317029974,43.75)
6054	2244	(3.598076211353316,43)
6055	2186	(22.650635094610966,41.5)
6056	130	(9.2272413359521668,3.25)
6057	450	(9.2272413359521668,9.25)
6058	2148	(24.815698604072061,40.75)
6059	289	(8.3612159321677293,6.25)
6060	289	(8.3612159321677293,6.25)
6061	2150	(26.54774941164094,40.75)
6062	2148	(24.815698604072061,40.75)
6063	2148	(24.815698604072061,40.75)
6064	2148	(24.815698604072061,40.75)
6065	2227	(23.949673200287624,42.25)
6066	2225	(22.217622392718749,42.25)
6067	2225	(22.217622392718749,42.25)
6068	2148	(24.815698604072061,40.75)
6069	846	(5.7631397208144124,16.75)
6070	2186	(22.650635094610966,41.5)
6071	2186	(22.650635094610966,41.5)
6072	2299	(17.021469970012117,43.75)
6073	2187	(23.516660498395403,41.5)
6074	250	(8.794228634059948,5.5)
6075	250	(8.794228634059948,5.5)
6076	2050	(9.2272413359521668,39.25)
6077	2041	(1.4330127018922194,39.25)
6078	2130	(9.2272413359521668,40.75)
6079	2170	(8.794228634059948,41.5)
6080	1973	(11.825317547305483,37.75)
6081	2084	(3.598076211353316,40)
6082	2256	(13.99038105676658,43)
6083	1934	(12.258330249197702,37)
6084	1934	(12.258330249197702,37)
6085	2095	(13.124355652982141,40)
6086	2095	(13.124355652982141,40)
6087	2084	(3.598076211353316,40)
6088	2252	(10.526279441628825,43)
6089	2084	(3.598076211353316,40)
6090	1973	(11.825317547305483,37.75)
6091	1973	(11.825317547305483,37.75)
6092	2332	(10.526279441628825,44.5)
6093	2044	(4.0310889132455356,39.25)
6094	1973	(11.825317547305483,37.75)
6095	2098	(15.722431864335457,40)
6096	2126	(5.7631397208144124,40.75)
6097	1977	(15.289419162443238,37.75)
6098	2090	(8.794228634059948,40)
6099	1934	(12.258330249197702,37)
6100	1240	(34.774990747593108,23.5)
6101	2098	(15.722431864335457,40)
6102	1597	(32.609927238132009,30.25)
6103	1440	(35.208003449485325,27.25)
6104	1614	(12.258330249197702,31)
6105	1834	(30.011851026778693,34.75)
6106	1598	(33.47595264191645,30.25)
6107	1684	(3.598076211353316,32.5)
6108	2399	(34.341978045700891,45.25)
6109	2200	(34.774990747593108,41.5)
6110	1520	(35.208003449485325,28.75)
6111	2081	(1,40)
6112	2253	(11.392304845413264,43)
6113	1600	(35.208003449485325,30.25)
6114	2347	(23.516660498395403,44.5)
6115	2342	(19.186533479473212,44.5)
6116	2255	(13.124355652982141,43)
6117	2165	(4.4641016151377544,41.5)
6118	2255	(13.124355652982141,43)
6119	1773	(11.392304845413264,34)
6120	1480	(34.774990747593108,28)
6121	1160	(34.774990747593108,22)
6122	1160	(34.774990747593108,22)
6123	1360	(35.208003449485325,25.75)
6124	1439	(34.341978045700891,27.25)
6125	2317	(32.609927238132009,43.75)
6126	2269	(25.248711305964282,43)
6127	2358	(33.042939940024233,44.5)
6128	1356	(31.743901834347572,25.75)
6129	2396	(31.743901834347572,45.25)
6130	2279	(33.908965343808667,43)
6131	1766	(5.3301270189221936,34)
6132	2396	(31.743901834347572,45.25)
6133	2397	(32.609927238132009,45.25)
6134	2243	(2.7320508075688772,43)
6135	2243	(2.7320508075688772,43)
6136	2243	(2.7320508075688772,43)
6137	2264	(20.918584287042091,43)
6138	10	(8.794228634059948,1)
6139	1476	(31.310889132455351,28)
6140	1753	(29.145825622994256,33.25)
6141	1715	(30.444863728670914,32.5)
6142	1716	(31.310889132455351,32.5)
6143	1757	(32.609927238132009,33.25)
6144	1758	(33.47595264191645,33.25)
6145	1759	(34.341978045700891,33.25)
6146	1760	(35.208003449485325,33.25)
6147	1680	(35.208003449485325,31.75)
6148	1759	(34.341978045700891,33.25)
6149	1031	(27.413774815425377,19.75)
6150	1030	(26.54774941164094,19.75)
6151	1029	(25.681724007856502,19.75)
6152	601	(1.4330127018922194,12.25)
6153	418	(15.722431864335457,8.5)
6154	135	(13.55736835487436,3.25)
6155	601	(1.4330127018922194,12.25)
6156	1271	(27.413774815425377,24.25)
6157	1346	(23.083647796503186,25.75)
6158	1232	(27.846787517317598,23.5)
6159	820	(17.454482671904334,16)
6160	214	(12.691342951089922,4.75)
6161	737	(14.856406460551018,14.5)
6162	1623	(20.05255888325765,31)
6163	1548	(24.382685902179844,29.5)
6164	1777	(14.856406460551018,34)
6165	2141	(18.753520777580992,40.75)
6166	1889	(8.3612159321677293,36.25)
6167	1547	(23.516660498395403,29.5)
6168	108	(24.382685902179844,2.5)
6169	555	(30.877876430563134,10.75)
6170	435	(30.444863728670914,8.5)
6171	434	(29.578838324886476,8.5)
6172	313	(29.145825622994256,6.25)
6173	26	(22.650635094610966,1)
6174	26	(22.650635094610966,1)
6175	1869	(25.248711305964282,35.5)
6176	2400	(35.208003449485325,45.25)
6177	2183	(20.05255888325765,41.5)
6178	2183	(20.05255888325765,41.5)
6179	2183	(20.05255888325765,41.5)
6180	1911	(27.413774815425377,36.25)
6181	2279	(33.908965343808667,43)
6182	954	(30.011851026778693,18.25)
6183	954	(30.011851026778693,18.25)
6184	993	(28.712812921102035,19)
6185	1600	(35.208003449485325,30.25)
6186	1312	(27.846787517317598,25)
6187	1312	(27.846787517317598,25)
6188	1312	(27.846787517317598,25)
6189	2380	(17.887495373796554,45.25)
6190	2380	(17.887495373796554,45.25)
6191	2384	(21.351596988934308,45.25)
6192	2384	(21.351596988934308,45.25)
6193	2380	(17.887495373796554,45.25)
6194	2380	(17.887495373796554,45.25)
6195	2243	(2.7320508075688772,43)
6196	2244	(3.598076211353316,43)
6197	2243	(2.7320508075688772,43)
6198	2244	(3.598076211353316,43)
6199	2301	(18.753520777580992,43.75)
6200	200	(34.774990747593108,4)
6201	1398	(33.042939940024233,26.5)
6202	640	(35.208003449485325,12.25)
6203	640	(35.208003449485325,12.25)
6204	195	(30.444863728670914,4)
6205	156	(31.743901834347572,3.25)
6206	1440	(35.208003449485325,27.25)
6207	1480	(34.774990747593108,28)
6208	1759	(34.341978045700891,33.25)
6209	1760	(35.208003449485325,33.25)
6210	1597	(32.609927238132009,30.25)
6211	1600	(35.208003449485325,30.25)
6212	1680	(35.208003449485325,31.75)
6213	313	(29.145825622994256,6.25)
6214	234	(30.011851026778693,4.75)
6215	26	(22.650635094610966,1)
6216	28	(24.382685902179844,1)
6217	66	(23.083647796503186,1.75)
6218	27	(23.516660498395403,1)
6219	28	(24.382685902179844,1)
6220	274	(29.578838324886476,5.5)
6221	313	(29.145825622994256,6.25)
6222	234	(30.011851026778693,4.75)
6223	26	(22.650635094610966,1)
6224	989	(25.248711305964282,19)
6225	948	(24.815698604072061,18.25)
6226	948	(24.815698604072061,18.25)
6227	593	(28.712812921102035,11.5)
6228	104	(20.918584287042091,2.5)
6229	25	(21.784609690826528,1)
6230	234	(30.011851026778693,4.75)
6231	234	(30.011851026778693,4.75)
6232	234	(30.011851026778693,4.75)
6233	234	(30.011851026778693,4.75)
6234	33	(28.712812921102035,1)
6235	434	(29.578838324886476,8.5)
6236	234	(30.011851026778693,4.75)
6237	434	(29.578838324886476,8.5)
6238	313	(29.145825622994256,6.25)
6239	313	(29.145825622994256,6.25)
6240	314	(30.011851026778693,6.25)
6241	80	(35.208003449485325,1.75)
6242	80	(35.208003449485325,1.75)
6243	80	(35.208003449485325,1.75)
6244	80	(35.208003449485325,1.75)
6245	80	(35.208003449485325,1.75)
6246	118	(33.042939940024233,2.5)
6247	118	(33.042939940024233,2.5)
6248	118	(33.042939940024233,2.5)
6249	516	(31.310889132455351,10)
6250	719	(34.341978045700891,13.75)
6251	514	(29.578838324886476,10)
6252	395	(30.877876430563134,7.75)
6253	395	(30.877876430563134,7.75)
6254	395	(30.877876430563134,7.75)
6255	269	(25.248711305964282,5.5)
6256	145	(22.217622392718749,3.25)
6257	234	(30.011851026778693,4.75)
6258	234	(30.011851026778693,4.75)
6259	234	(30.011851026778693,4.75)
6260	234	(30.011851026778693,4.75)
6261	77	(32.609927238132009,1.75)
6262	1352	(28.279800219209818,25.75)
6263	1390	(26.114736709748719,26.5)
6264	1471	(26.98076211353316,28)
6265	1467	(23.516660498395403,28)
6266	1547	(23.516660498395403,29.5)
6267	1547	(23.516660498395403,29.5)
6268	1230	(26.114736709748719,23.5)
6269	1230	(26.114736709748719,23.5)
6270	425	(21.784609690826528,8.5)
6271	465	(22.217622392718749,9.25)
6272	464	(21.351596988934308,9.25)
6273	463	(20.48557158514987,9.25)
6274	461	(18.753520777580992,9.25)
6275	461	(18.753520777580992,9.25)
6276	461	(18.753520777580992,9.25)
6277	500	(17.454482671904334,10)
6278	835	(30.444863728670914,16)
6279	835	(30.444863728670914,16)
6280	834	(29.578838324886476,16)
6281	792	(28.279800219209818,15.25)
6282	794	(30.011851026778693,15.25)
6283	792	(28.279800219209818,15.25)
6284	791	(27.413774815425377,15.25)
6285	463	(20.48557158514987,9.25)
6286	425	(21.784609690826528,8.5)
6287	465	(22.217622392718749,9.25)
6288	464	(21.351596988934308,9.25)
6289	461	(18.753520777580992,9.25)
6290	461	(18.753520777580992,9.25)
6291	461	(18.753520777580992,9.25)
6292	501	(18.320508075688775,10)
6293	464	(21.351596988934308,9.25)
6294	7	(6.196152422706632,1)
6295	7	(6.196152422706632,1)
6296	44	(4.0310889132455356,1.75)
6297	44	(4.0310889132455356,1.75)
6298	1	(1,1)
6299	41	(1.4330127018922194,1.75)
6300	41	(1.4330127018922194,1.75)
6301	1	(1,1)
6302	44	(4.0310889132455356,1.75)
6303	41	(1.4330127018922194,1.75)
6304	1041	(1,20.5)
6305	1001	(1.4330127018922194,19.75)
6306	962	(1.8660254037844386,19)
6307	1001	(1.4330127018922194,19.75)
6308	1041	(1,20.5)
6309	1041	(1,20.5)
6310	1041	(1,20.5)
6311	1041	(1,20.5)
6312	251	(9.6602540378443873,5.5)
6313	251	(9.6602540378443873,5.5)
6314	251	(9.6602540378443873,5.5)
6315	251	(9.6602540378443873,5.5)
6316	251	(9.6602540378443873,5.5)
6317	251	(9.6602540378443873,5.5)
6318	170	(8.794228634059948,4)
6319	170	(8.794228634059948,4)
6320	289	(8.3612159321677293,6.25)
6321	369	(8.3612159321677293,7.75)
6322	330	(8.794228634059948,7)
6323	330	(8.794228634059948,7)
6324	330	(8.794228634059948,7)
6325	369	(8.3612159321677293,7.75)
6326	330	(8.794228634059948,7)
6327	331	(9.6602540378443873,7)
6328	290	(9.2272413359521668,6.25)
6329	290	(9.2272413359521668,6.25)
6330	290	(9.2272413359521668,6.25)
6331	251	(9.6602540378443873,5.5)
6332	369	(8.3612159321677293,7.75)
6333	1724	(4.0310889132455356,33.25)
6334	2285	(4.897114317029974,43.75)
6335	2286	(5.7631397208144124,43.75)
6336	2281	(1.4330127018922194,43.75)
6337	2281	(1.4330127018922194,43.75)
6338	2241	(1,43)
6339	2241	(1,43)
6340	2065	(22.217622392718749,39.25)
6341	2065	(22.217622392718749,39.25)
6342	2104	(20.918584287042091,40)
6343	2159	(34.341978045700891,40.75)
6344	2159	(34.341978045700891,40.75)
6345	2159	(34.341978045700891,40.75)
6346	2377	(15.289419162443238,45.25)
6347	1932	(10.526279441628825,37)
6348	1776	(13.99038105676658,34)
6349	1852	(10.526279441628825,35.5)
6350	1889	(8.3612159321677293,36.25)
6351	1813	(11.825317547305483,34.75)
6352	1855	(13.124355652982141,35.5)
6353	1934	(12.258330249197702,37)
6354	1934	(12.258330249197702,37)
6355	1934	(12.258330249197702,37)
6356	723	(2.7320508075688772,14.5)
6357	682	(2.299038105676658,13.75)
6358	1008	(7.49519052838329,19.75)
6359	1167	(6.6291651245988508,22.75)
6360	1205	(4.4641016151377544,23.5)
6361	1283	(2.7320508075688772,25)
6362	1242	(2.299038105676658,24.25)
6363	925	(4.897114317029974,18.25)
6364	533	(11.825317547305483,10.75)
6365	223	(20.48557158514987,4.75)
6366	223	(20.48557158514987,4.75)
6367	223	(20.48557158514987,4.75)
6368	223	(20.48557158514987,4.75)
6369	222	(19.619546181365433,4.75)
6370	341	(18.320508075688775,7)
6371	339	(16.588457268119896,7)
6372	260	(17.454482671904334,5.5)
6373	2154	(30.011851026778693,40.75)
6374	1917	(32.609927238132009,36.25)
6375	1879	(33.908965343808667,35.5)
6376	1879	(33.908965343808667,35.5)
6377	2037	(32.176914536239792,38.5)
6378	1641	(1.4330127018922194,31.75)
6379	1681	(1,32.5)
6380	10	(8.794228634059948,1)
6381	10	(8.794228634059948,1)
6382	11	(9.6602540378443873,1)
6383	11	(9.6602540378443873,1)
6384	60	(17.887495373796554,1.75)
6385	19	(16.588457268119896,1)
6386	139	(17.021469970012117,3.25)
6387	10	(8.794228634059948,1)
6388	11	(9.6602540378443873,1)
6389	10	(8.794228634059948,1)
6390	11	(9.6602540378443873,1)
6391	1879	(33.908965343808667,35.5)
6392	1879	(33.908965343808667,35.5)
6393	2037	(32.176914536239792,38.5)
6394	693	(11.825317547305483,13.75)
6395	2205	(4.897114317029974,42.25)
6396	2205	(4.897114317029974,42.25)
6397	1804	(4.0310889132455356,34.75)
6398	2041	(1.4330127018922194,39.25)
6399	2090	(8.794228634059948,40)
6400	2216	(14.423393758658799,42.25)
6401	2128	(7.49519052838329,40.75)
6402	2292	(10.959292143521045,43.75)
6403	2098	(15.722431864335457,40)
6404	2055	(13.55736835487436,39.25)
6405	2055	(13.55736835487436,39.25)
6406	2292	(10.959292143521045,43.75)
6407	2041	(1.4330127018922194,39.25)
6408	2216	(14.423393758658799,42.25)
6409	1934	(12.258330249197702,37)
6410	2130	(9.2272413359521668,40.75)
6411	1844	(3.598076211353316,35.5)
6412	1934	(12.258330249197702,37)
6413	1934	(12.258330249197702,37)
6414	2122	(2.299038105676658,40.75)
6415	1884	(4.0310889132455356,36.25)
6416	2121	(1.4330127018922194,40.75)
6417	2170	(8.794228634059948,41.5)
6418	2170	(8.794228634059948,41.5)
6419	2394	(30.011851026778693,45.25)
6420	2352	(27.846787517317598,44.5)
6421	2352	(27.846787517317598,44.5)
6422	2392	(28.279800219209818,45.25)
6423	2352	(27.846787517317598,44.5)
6424	10	(8.794228634059948,1)
6425	2106	(22.650635094610966,40)
6426	2148	(24.815698604072061,40.75)
6427	2106	(22.650635094610966,40)
6428	1091	(10.093266739736606,21.25)
6429	1242	(2.299038105676658,24.25)
6430	1243	(3.1650635094610968,24.25)
6431	966	(5.3301270189221936,19)
6432	925	(4.897114317029974,18.25)
6433	1008	(7.49519052838329,19.75)
6434	1041	(1,20.5)
6435	1857	(14.856406460551018,35.5)
6436	1898	(16.155444566227676,36.25)
6437	1981	(18.753520777580992,37.75)
6438	1814	(12.691342951089922,34.75)
6439	1814	(12.691342951089922,34.75)
6440	1895	(13.55736835487436,36.25)
6441	1814	(12.691342951089922,34.75)
6442	1933	(11.392304845413264,37)
6443	1892	(10.959292143521045,36.25)
6444	1855	(13.124355652982141,35.5)
6445	2007	(6.196152422706632,38.5)
6446	2126	(5.7631397208144124,40.75)
6447	2091	(9.6602540378443873,40)
6448	2170	(8.794228634059948,41.5)
6449	2044	(4.0310889132455356,39.25)
6450	1054	(12.258330249197702,20.5)
6451	656	(13.99038105676658,13)
6452	816	(13.99038105676658,16)
6453	1128	(7.0621778264910704,22)
6454	1041	(1,20.5)
6455	1167	(6.6291651245988508,22.75)
6456	1041	(1,20.5)
6457	1041	(1,20.5)
6458	1041	(1,20.5)
6459	1041	(1,20.5)
6460	2345	(21.784609690826528,44.5)
6461	1985	(22.217622392718749,37.75)
6462	2037	(32.176914536239792,38.5)
6463	1879	(33.908965343808667,35.5)
6464	1880	(34.774990747593108,35.5)
6465	1840	(35.208003449485325,34.75)
6466	1840	(35.208003449485325,34.75)
6467	88	(7.0621778264910704,2.5)
6468	82	(1.8660254037844386,2.5)
6469	82	(1.8660254037844386,2.5)
6470	82	(1.8660254037844386,2.5)
6471	82	(1.8660254037844386,2.5)
6472	82	(1.8660254037844386,2.5)
6473	87	(6.196152422706632,2.5)
6474	87	(6.196152422706632,2.5)
6475	165	(4.4641016151377544,4)
6476	124	(4.0310889132455356,3.25)
6477	124	(4.0310889132455356,3.25)
6478	124	(4.0310889132455356,3.25)
6479	130	(9.2272413359521668,3.25)
6480	411	(9.6602540378443873,8.5)
6481	2225	(22.217622392718749,42.25)
6482	2225	(22.217622392718749,42.25)
6483	369	(8.3612159321677293,7.75)
6484	330	(8.794228634059948,7)
6485	369	(8.3612159321677293,7.75)
6486	28	(24.382685902179844,1)
6487	26	(22.650635094610966,1)
6488	391	(27.413774815425377,7.75)
6489	24	(20.918584287042091,1)
6490	24	(20.918584287042091,1)
6491	393	(29.145825622994256,7.75)
6492	393	(29.145825622994256,7.75)
6493	393	(29.145825622994256,7.75)
6494	393	(29.145825622994256,7.75)
6495	393	(29.145825622994256,7.75)
6496	28	(24.382685902179844,1)
6497	66	(23.083647796503186,1.75)
6498	28	(24.382685902179844,1)
6499	26	(22.650635094610966,1)
6500	26	(22.650635094610966,1)
6501	26	(22.650635094610966,1)
6502	26	(22.650635094610966,1)
6503	26	(22.650635094610966,1)
6504	156	(31.743901834347572,3.25)
6505	156	(31.743901834347572,3.25)
6506	66	(23.083647796503186,1.75)
6507	24	(20.918584287042091,1)
6508	77	(32.609927238132009,1.75)
6509	471	(27.413774815425377,9.25)
6510	471	(27.413774815425377,9.25)
6511	471	(27.413774815425377,9.25)
6512	391	(27.413774815425377,7.75)
6513	353	(28.712812921102035,7)
6514	353	(28.712812921102035,7)
6515	25	(21.784609690826528,1)
6516	77	(32.609927238132009,1.75)
6517	240	(35.208003449485325,4.75)
6518	240	(35.208003449485325,4.75)
6519	758	(33.042939940024233,14.5)
6520	1479	(33.908965343808667,28)
6521	1480	(34.774990747593108,28)
6522	1480	(34.774990747593108,28)
6523	1519	(34.341978045700891,28.75)
6524	1158	(33.042939940024233,22)
6525	1318	(33.042939940024233,25)
6526	1318	(33.042939940024233,25)
6527	1359	(34.341978045700891,25.75)
6528	1439	(34.341978045700891,27.25)
6529	1519	(34.341978045700891,28.75)
6530	1519	(34.341978045700891,28.75)
6531	1439	(34.341978045700891,27.25)
6532	24	(20.918584287042091,1)
6533	24	(20.918584287042091,1)
6534	24	(20.918584287042091,1)
6535	24	(20.918584287042091,1)
6536	24	(20.918584287042091,1)
6537	24	(20.918584287042091,1)
6538	24	(20.918584287042091,1)
6539	1240	(34.774990747593108,23.5)
6540	1360	(35.208003449485325,25.75)
6541	1440	(35.208003449485325,27.25)
6542	1480	(34.774990747593108,28)
6543	1600	(35.208003449485325,30.25)
6544	1230	(26.114736709748719,23.5)
6545	1230	(26.114736709748719,23.5)
6546	1272	(28.279800219209818,24.25)
6547	1271	(27.413774815425377,24.25)
6548	1390	(26.114736709748719,26.5)
6549	1470	(26.114736709748719,28)
6550	1547	(23.516660498395403,29.5)
6551	1230	(26.114736709748719,23.5)
6552	1680	(35.208003449485325,31.75)
6553	555	(30.877876430563134,10.75)
6554	555	(30.877876430563134,10.75)
6555	555	(30.877876430563134,10.75)
6556	435	(30.444863728670914,8.5)
6557	435	(30.444863728670914,8.5)
6558	435	(30.444863728670914,8.5)
6559	435	(30.444863728670914,8.5)
6560	435	(30.444863728670914,8.5)
6561	395	(30.877876430563134,7.75)
6562	395	(30.877876430563134,7.75)
6563	354	(29.578838324886476,7)
6564	105	(21.784609690826528,2.5)
6565	1480	(34.774990747593108,28)
6566	1306	(22.650635094610966,25)
6567	1306	(22.650635094610966,25)
6568	1068	(24.382685902179844,20.5)
6569	1027	(23.949673200287624,19.75)
6570	1039	(34.341978045700891,19.75)
6571	1039	(34.341978045700891,19.75)
6572	1039	(34.341978045700891,19.75)
6573	960	(35.208003449485325,18.25)
6574	960	(35.208003449485325,18.25)
6575	960	(35.208003449485325,18.25)
6576	960	(35.208003449485325,18.25)
6577	960	(35.208003449485325,18.25)
6578	1000	(34.774990747593108,19)
6579	274	(29.578838324886476,5.5)
6580	274	(29.578838324886476,5.5)
6581	313	(29.145825622994256,6.25)
6582	1078	(33.042939940024233,20.5)
6583	1079	(33.908965343808667,20.5)
6584	1078	(33.042939940024233,20.5)
6585	1079	(33.908965343808667,20.5)
6586	1440	(35.208003449485325,27.25)
6587	1480	(34.774990747593108,28)
6588	1479	(33.908965343808667,28)
6589	1480	(34.774990747593108,28)
6590	1041	(1,20.5)
6591	1041	(1,20.5)
6592	369	(8.3612159321677293,7.75)
6593	938	(16.155444566227676,18.25)
6594	1057	(14.856406460551018,20.5)
6595	2380	(17.887495373796554,45.25)
6596	2292	(10.959292143521045,43.75)
6597	2081	(1,40)
6598	2090	(8.794228634059948,40)
6599	2041	(1.4330127018922194,39.25)
6600	2333	(11.392304845413264,44.5)
6601	2292	(10.959292143521045,43.75)
6602	2382	(19.619546181365433,45.25)
6603	2126	(5.7631397208144124,40.75)
6604	1891	(10.093266739736606,36.25)
6605	1891	(10.093266739736606,36.25)
6606	1891	(10.093266739736606,36.25)
6607	2007	(6.196152422706632,38.5)
6608	1891	(10.093266739736606,36.25)
6609	1892	(10.959292143521045,36.25)
6610	1933	(11.392304845413264,37)
6611	1776	(13.99038105676658,34)
6612	1858	(15.722431864335457,35.5)
6613	1814	(12.691342951089922,34.75)
6614	1897	(15.289419162443238,36.25)
6615	1977	(15.289419162443238,37.75)
6616	2060	(17.887495373796554,39.25)
6617	2060	(17.887495373796554,39.25)
6618	1929	(7.9282032302755088,37)
6619	1977	(15.289419162443238,37.75)
6620	1932	(10.526279441628825,37)
6621	1977	(15.289419162443238,37.75)
6622	1977	(15.289419162443238,37.75)
6623	2083	(2.7320508075688772,40)
6624	1924	(3.598076211353316,37)
6625	1844	(3.598076211353316,35.5)
6626	1895	(13.55736835487436,36.25)
6627	2163	(2.7320508075688772,41.5)
6628	1151	(26.98076211353316,22)
6629	540	(17.887495373796554,10.75)
6630	540	(17.887495373796554,10.75)
6631	1804	(4.0310889132455356,34.75)
6632	1804	(4.0310889132455356,34.75)
6633	1804	(4.0310889132455356,34.75)
6634	2041	(1.4330127018922194,39.25)
6635	2041	(1.4330127018922194,39.25)
6636	2376	(14.423393758658799,45.25)
6637	223	(20.48557158514987,4.75)
6638	223	(20.48557158514987,4.75)
6639	223	(20.48557158514987,4.75)
6640	223	(20.48557158514987,4.75)
6641	223	(20.48557158514987,4.75)
6642	182	(19.186533479473212,4)
6643	182	(19.186533479473212,4)
6644	182	(19.186533479473212,4)
6645	182	(19.186533479473212,4)
6646	182	(19.186533479473212,4)
6647	182	(19.186533479473212,4)
6648	182	(19.186533479473212,4)
6649	2071	(27.413774815425377,39.25)
6650	2250	(8.794228634059948,43)
6651	2250	(8.794228634059948,43)
6652	2233	(29.145825622994256,42.25)
6653	2376	(14.423393758658799,45.25)
6654	842	(2.299038105676658,16.75)
6655	842	(2.299038105676658,16.75)
6656	441	(1.4330127018922194,9.25)
6657	492	(10.526279441628825,10)
6658	441	(1.4330127018922194,9.25)
6659	563	(2.7320508075688772,11.5)
6660	721	(1,14.5)
6661	761	(1.4330127018922194,15.25)
6662	761	(1.4330127018922194,15.25)
6663	761	(1.4330127018922194,15.25)
6664	761	(1.4330127018922194,15.25)
6665	761	(1.4330127018922194,15.25)
6666	1283	(2.7320508075688772,25)
6667	1243	(3.1650635094610968,24.25)
6668	1203	(2.7320508075688772,23.5)
6669	1203	(2.7320508075688772,23.5)
6670	1203	(2.7320508075688772,23.5)
6671	1084	(4.0310889132455356,21.25)
6672	1084	(4.0310889132455356,21.25)
6673	1084	(4.0310889132455356,21.25)
6674	1084	(4.0310889132455356,21.25)
6675	1084	(4.0310889132455356,21.25)
6676	964	(3.598076211353316,19)
6677	964	(3.598076211353316,19)
6678	964	(3.598076211353316,19)
6679	1083	(3.1650635094610968,21.25)
6680	1083	(3.1650635094610968,21.25)
6681	841	(1.4330127018922194,16.75)
6682	1084	(4.0310889132455356,21.25)
6683	1084	(4.0310889132455356,21.25)
6684	605	(4.897114317029974,12.25)
6685	645	(4.4641016151377544,13)
6686	685	(4.897114317029974,13.75)
6687	1004	(4.0310889132455356,19.75)
6688	1791	(26.98076211353316,34)
6689	453	(11.825317547305483,9.25)
6690	1790	(26.114736709748719,34)
6691	1905	(22.217622392718749,36.25)
6692	2289	(8.3612159321677293,43.75)
6693	1219	(16.588457268119896,23.5)
6694	1804	(4.0310889132455356,34.75)
6695	1954	(29.578838324886476,37)
6696	1955	(30.444863728670914,37)
6697	2037	(32.176914536239792,38.5)
6698	2157	(32.609927238132009,40.75)
6699	2157	(32.609927238132009,40.75)
6700	2040	(34.774990747593108,38.5)
6701	2159	(34.341978045700891,40.75)
6702	1841	(1,35.5)
6703	2111	(26.98076211353316,40)
6704	2071	(27.413774815425377,39.25)
6705	2111	(26.98076211353316,40)
6706	1841	(1,35.5)
6707	1603	(2.7320508075688772,31)
6708	2034	(29.578838324886476,38.5)
6709	1610	(8.794228634059948,31)
6710	2070	(26.54774941164094,39.25)
6711	1603	(2.7320508075688772,31)
6712	1312	(27.846787517317598,25)
6713	1349	(25.681724007856502,25.75)
6714	1390	(26.114736709748719,26.5)
6715	1547	(23.516660498395403,29.5)
6716	618	(16.155444566227676,12.25)
6717	624	(21.351596988934308,12.25)
6718	624	(21.351596988934308,12.25)
6719	662	(19.186533479473212,13)
6720	618	(16.155444566227676,12.25)
6721	537	(15.289419162443238,10.75)
6722	945	(22.217622392718749,18.25)
6723	660	(17.454482671904334,13)
6724	1306	(22.650635094610966,25)
6725	1302	(19.186533479473212,25)
6726	1340	(17.887495373796554,25.75)
6727	1417	(15.289419162443238,27.25)
6728	1296	(13.99038105676658,25)
6729	1417	(15.289419162443238,27.25)
6730	1379	(16.588457268119896,26.5)
6731	1216	(13.99038105676658,23.5)
6732	1068	(24.382685902179844,20.5)
6733	1068	(24.382685902179844,20.5)
6734	1104	(21.351596988934308,21.25)
6735	1062	(19.186533479473212,20.5)
6736	1103	(20.48557158514987,21.25)
6737	984	(20.918584287042091,19)
6738	984	(20.918584287042091,19)
6739	1098	(16.155444566227676,21.25)
6740	1336	(14.423393758658799,25.75)
6741	586	(22.650635094610966,11.5)
6742	586	(22.650635094610966,11.5)
6743	624	(21.351596988934308,12.25)
6744	584	(20.918584287042091,11.5)
6745	622	(19.619546181365433,12.25)
6746	940	(17.887495373796554,18.25)
6747	934	(12.691342951089922,18.25)
6748	772	(10.959292143521045,15.25)
6749	812	(10.526279441628825,16)
6750	1057	(14.856406460551018,20.5)
6751	2347	(23.516660498395403,44.5)
6752	2386	(23.083647796503186,45.25)
6753	2262	(19.186533479473212,43)
6754	2342	(19.186533479473212,44.5)
6755	2342	(19.186533479473212,44.5)
6756	2301	(18.753520777580992,43.75)
6757	2341	(18.320508075688775,44.5)
6758	2380	(17.887495373796554,45.25)
6759	2262	(19.186533479473212,43)
6760	2262	(19.186533479473212,43)
6761	2302	(19.619546181365433,43.75)
6762	2341	(18.320508075688775,44.5)
6763	2382	(19.619546181365433,45.25)
6764	2340	(17.454482671904334,44.5)
6765	2379	(17.021469970012117,45.25)
6766	2300	(17.887495373796554,43.75)
6767	2324	(3.598076211353316,44.5)
6768	2384	(21.351596988934308,45.25)
6769	1772	(10.526279441628825,34)
6770	1822	(19.619546181365433,34.75)
6771	1739	(17.021469970012117,33.25)
6772	2101	(18.320508075688775,40)
6773	1772	(10.526279441628825,34)
6774	1821	(18.753520777580992,34.75)
6775	1772	(10.526279441628825,34)
6776	1893	(11.825317547305483,36.25)
6777	1772	(10.526279441628825,34)
6778	2255	(13.124355652982141,43)
6779	2060	(17.887495373796554,39.25)
6780	1768	(7.0621778264910704,34)
6781	1739	(17.021469970012117,33.25)
6782	1807	(6.6291651245988508,34.75)
6783	2053	(11.825317547305483,39.25)
6784	2052	(10.959292143521045,39.25)
6785	1847	(6.196152422706632,35.5)
6786	2091	(9.6602540378443873,40)
6787	1924	(3.598076211353316,37)
6788	2044	(4.0310889132455356,39.25)
6789	2041	(1.4330127018922194,39.25)
6790	2082	(1.8660254037844386,40)
6791	2082	(1.8660254037844386,40)
6792	2060	(17.887495373796554,39.25)
6793	1807	(6.6291651245988508,34.75)
6794	2212	(10.959292143521045,42.25)
6795	2207	(6.6291651245988508,42.25)
6796	141	(18.753520777580992,3.25)
6797	141	(18.753520777580992,3.25)
6798	58	(16.155444566227676,1.75)
6799	58	(16.155444566227676,1.75)
6800	17	(14.856406460551018,1)
6801	17	(14.856406460551018,1)
6802	98	(15.722431864335457,2.5)
6803	98	(15.722431864335457,2.5)
6804	11	(9.6602540378443873,1)
6805	12	(10.526279441628825,1)
6806	141	(18.753520777580992,3.25)
6807	140	(17.887495373796554,3.25)
6808	178	(15.722431864335457,4)
6809	249	(7.9282032302755088,5.5)
6810	249	(7.9282032302755088,5.5)
6811	249	(7.9282032302755088,5.5)
6812	2186	(22.650635094610966,41.5)
6813	2124	(4.0310889132455356,40.75)
6814	7	(6.196152422706632,1)
6815	7	(6.196152422706632,1)
6816	7	(6.196152422706632,1)
6817	45	(4.897114317029974,1.75)
6818	85	(4.4641016151377544,2.5)
6819	281	(1.4330127018922194,6.25)
6820	281	(1.4330127018922194,6.25)
6821	202	(2.299038105676658,4.75)
6822	281	(1.4330127018922194,6.25)
6823	281	(1.4330127018922194,6.25)
6824	1	(1,1)
6825	1	(1,1)
6826	1	(1,1)
6827	41	(1.4330127018922194,1.75)
6828	1	(1,1)
6829	424	(20.918584287042091,8.5)
6830	424	(20.918584287042091,8.5)
6831	464	(21.351596988934308,9.25)
6832	461	(18.753520777580992,9.25)
6833	461	(18.753520777580992,9.25)
6834	461	(18.753520777580992,9.25)
6835	365	(4.897114317029974,7.75)
6836	365	(4.897114317029974,7.75)
6837	326	(5.3301270189221936,7)
6838	326	(5.3301270189221936,7)
6839	364	(4.0310889132455356,7.75)
6840	1501	(18.753520777580992,28.75)
6841	1501	(18.753520777580992,28.75)
6842	1501	(18.753520777580992,28.75)
6843	1501	(18.753520777580992,28.75)
6844	1542	(19.186533479473212,29.5)
6845	2200	(34.774990747593108,41.5)
6846	2399	(34.341978045700891,45.25)
6847	1725	(4.897114317029974,33.25)
6848	1877	(32.176914536239792,35.5)
6849	1600	(35.208003449485325,30.25)
6850	1240	(34.774990747593108,23.5)
6851	1240	(34.774990747593108,23.5)
6852	1360	(35.208003449485325,25.75)
6853	1597	(32.609927238132009,30.25)
6854	1834	(30.011851026778693,34.75)
6855	761	(1.4330127018922194,15.25)
6856	1084	(4.0310889132455356,21.25)
6857	1160	(34.774990747593108,22)
6858	1160	(34.774990747593108,22)
6859	1160	(34.774990747593108,22)
6860	1360	(35.208003449485325,25.75)
6861	2317	(32.609927238132009,43.75)
6862	2269	(25.248711305964282,43)
6863	2358	(33.042939940024233,44.5)
6864	1356	(31.743901834347572,25.75)
6865	1600	(35.208003449485325,30.25)
6866	841	(1.4330127018922194,16.75)
6867	1597	(32.609927238132009,30.25)
6868	1598	(33.47595264191645,30.25)
6869	1476	(31.310889132455351,28)
6870	1753	(29.145825622994256,33.25)
6871	1715	(30.444863728670914,32.5)
6872	1716	(31.310889132455351,32.5)
6873	1757	(32.609927238132009,33.25)
6874	1759	(34.341978045700891,33.25)
6875	1760	(35.208003449485325,33.25)
6876	1680	(35.208003449485325,31.75)
6877	1083	(3.1650635094610968,21.25)
6878	2320	(35.208003449485325,43.75)
6879	888	(7.0621778264910704,17.5)
6880	2320	(35.208003449485325,43.75)
6881	842	(2.299038105676658,16.75)
6882	1237	(32.176914536239792,23.5)
6883	1237	(32.176914536239792,23.5)
6884	1237	(32.176914536239792,23.5)
6885	1197	(32.609927238132009,22.75)
6886	757	(32.176914536239792,14.5)
6887	1197	(32.609927238132009,22.75)
6888	1359	(34.341978045700891,25.75)
6889	1439	(34.341978045700891,27.25)
6890	2280	(34.774990747593108,43)
6891	2396	(31.743901834347572,45.25)
6892	2396	(31.743901834347572,45.25)
6893	2397	(32.609927238132009,45.25)
6894	2397	(32.609927238132009,45.25)
6895	2396	(31.743901834347572,45.25)
6896	33	(28.712812921102035,1)
6897	895	(13.124355652982141,17.5)
6898	1057	(14.856406460551018,20.5)
6899	855	(13.55736835487436,16.75)
6900	895	(13.124355652982141,17.5)
6901	835	(30.444863728670914,16)
6902	794	(30.011851026778693,15.25)
6903	834	(29.578838324886476,16)
6904	794	(30.011851026778693,15.25)
6905	792	(28.279800219209818,15.25)
6906	792	(28.279800219209818,15.25)
6907	792	(28.279800219209818,15.25)
6908	347	(23.516660498395403,7)
6909	347	(23.516660498395403,7)
6910	347	(23.516660498395403,7)
6911	149	(25.681724007856502,3.25)
6912	112	(27.846787517317598,2.5)
6913	112	(27.846787517317598,2.5)
6914	73	(29.145825622994256,1.75)
6915	33	(28.712812921102035,1)
6916	33	(28.712812921102035,1)
6917	33	(28.712812921102035,1)
6918	554	(30.011851026778693,10.75)
6919	554	(30.011851026778693,10.75)
6920	554	(30.011851026778693,10.75)
6921	554	(30.011851026778693,10.75)
6922	190	(26.114736709748719,4)
6923	151	(27.413774815425377,3.25)
6924	31	(26.98076211353316,1)
6925	112	(27.846787517317598,2.5)
6926	33	(28.712812921102035,1)
6927	33	(28.712812921102035,1)
6928	224	(21.351596988934308,4.75)
6929	224	(21.351596988934308,4.75)
6930	224	(21.351596988934308,4.75)
6931	224	(21.351596988934308,4.75)
6932	391	(27.413774815425377,7.75)
6933	391	(27.413774815425377,7.75)
6934	391	(27.413774815425377,7.75)
6935	80	(35.208003449485325,1.75)
6936	160	(35.208003449485325,3.25)
6937	39	(33.908965343808667,1)
6938	37	(32.176914536239792,1)
6939	160	(35.208003449485325,3.25)
6940	200	(34.774990747593108,4)
6941	38	(33.042939940024233,1)
6942	108	(24.382685902179844,2.5)
6943	200	(34.774990747593108,4)
6944	160	(35.208003449485325,3.25)
6945	108	(24.382685902179844,2.5)
6946	37	(32.176914536239792,1)
6947	1036	(31.743901834347572,19.75)
6948	676	(31.310889132455351,13)
6949	673	(28.712812921102035,13)
6950	632	(28.279800219209818,12.25)
6951	145	(22.217622392718749,3.25)
6952	186	(22.650635094610966,4)
6953	145	(22.217622392718749,3.25)
6954	145	(22.217622392718749,3.25)
6955	145	(22.217622392718749,3.25)
6956	145	(22.217622392718749,3.25)
6957	712	(28.279800219209818,13.75)
6958	712	(28.279800219209818,13.75)
6959	712	(28.279800219209818,13.75)
6960	712	(28.279800219209818,13.75)
6961	712	(28.279800219209818,13.75)
6962	712	(28.279800219209818,13.75)
6963	78	(33.47595264191645,1.75)
6964	1355	(30.877876430563134,25.75)
6965	200	(34.774990747593108,4)
6966	80	(35.208003449485325,1.75)
6967	1397	(32.176914536239792,26.5)
6968	589	(25.248711305964282,11.5)
6969	468	(24.815698604072061,9.25)
6970	234	(30.011851026778693,4.75)
6971	197	(32.176914536239792,4)
6972	197	(32.176914536239792,4)
6973	78	(33.47595264191645,1.75)
6974	197	(32.176914536239792,4)
6975	118	(33.042939940024233,2.5)
6976	31	(26.98076211353316,1)
6977	31	(26.98076211353316,1)
6978	30	(26.114736709748719,1)
6979	31	(26.98076211353316,1)
6980	1513	(29.145825622994256,28.75)
6981	1513	(29.145825622994256,28.75)
6982	1513	(29.145825622994256,28.75)
6983	1513	(29.145825622994256,28.75)
6984	628	(24.815698604072061,12.25)
6985	628	(24.815698604072061,12.25)
6986	1757	(32.609927238132009,33.25)
6987	1759	(34.341978045700891,33.25)
6988	1680	(35.208003449485325,31.75)
6989	628	(24.815698604072061,12.25)
6990	628	(24.815698604072061,12.25)
6991	1352	(28.279800219209818,25.75)
6992	77	(32.609927238132009,1.75)
6993	1352	(28.279800219209818,25.75)
6994	1431	(27.413774815425377,27.25)
6995	1432	(28.279800219209818,27.25)
6996	1470	(26.114736709748719,28)
6997	1271	(27.413774815425377,24.25)
6998	1508	(24.815698604072061,28.75)
6999	1227	(23.516660498395403,23.5)
7000	1187	(23.949673200287624,22.75)
7001	1187	(23.949673200287624,22.75)
7002	1032	(28.279800219209818,19.75)
7003	1070	(26.114736709748719,20.5)
7004	1070	(26.114736709748719,20.5)
7005	1028	(24.815698604072061,19.75)
7006	700	(17.887495373796554,13.75)
7007	621	(18.753520777580992,12.25)
7008	700	(17.887495373796554,13.75)
7009	660	(17.454482671904334,13)
7010	1577	(15.289419162443238,30.25)
7011	1618	(15.722431864335457,31)
7012	1619	(16.588457268119896,31)
7013	1471	(26.98076211353316,28)
7014	1470	(26.114736709748719,28)
7015	632	(28.279800219209818,12.25)
7016	632	(28.279800219209818,12.25)
7017	632	(28.279800219209818,12.25)
7018	632	(28.279800219209818,12.25)
7019	191	(26.98076211353316,4)
7020	152	(28.279800219209818,3.25)
7021	112	(27.846787517317598,2.5)
7022	911	(26.98076211353316,17.5)
7023	911	(26.98076211353316,17.5)
7024	870	(26.54774941164094,16.75)
7025	911	(26.98076211353316,17.5)
7026	870	(26.54774941164094,16.75)
7027	951	(27.413774815425377,18.25)
7028	1219	(16.588457268119896,23.5)
7029	1140	(17.454482671904334,22)
7030	1219	(16.588457268119896,23.5)
7031	1220	(17.454482671904334,23.5)
7032	2394	(30.011851026778693,45.25)
7033	2394	(30.011851026778693,45.25)
7034	2237	(32.609927238132009,42.25)
7035	2392	(28.279800219209818,45.25)
7036	2394	(30.011851026778693,45.25)
7037	2394	(30.011851026778693,45.25)
7038	2237	(32.609927238132009,42.25)
7039	2392	(28.279800219209818,45.25)
7040	2274	(29.578838324886476,43)
7041	1877	(32.176914536239792,35.5)
7042	1917	(32.609927238132009,36.25)
7043	1877	(32.176914536239792,35.5)
7044	1985	(22.217622392718749,37.75)
7045	1821	(18.753520777580992,34.75)
7046	1934	(12.258330249197702,37)
7047	2098	(15.722431864335457,40)
7048	2016	(13.99038105676658,38.5)
7049	2216	(14.423393758658799,42.25)
7050	1934	(12.258330249197702,37)
7051	1333	(11.825317547305483,25.75)
7052	1333	(11.825317547305483,25.75)
7053	1132	(10.526279441628825,22)
7054	1132	(10.526279441628825,22)
7055	1325	(4.897114317029974,25.75)
7056	767	(6.6291651245988508,15.25)
7057	2137	(15.289419162443238,40.75)
7058	1132	(10.526279441628825,22)
7059	2365	(4.897114317029974,45.25)
7060	2302	(19.619546181365433,43.75)
7061	2302	(19.619546181365433,43.75)
7062	2367	(6.6291651245988508,45.25)
7063	2367	(6.6291651245988508,45.25)
7064	2367	(6.6291651245988508,45.25)
7065	2367	(6.6291651245988508,45.25)
7066	2366	(5.7631397208144124,45.25)
7067	2366	(5.7631397208144124,45.25)
7068	1747	(23.949673200287624,33.25)
7069	1706	(22.650635094610966,32.5)
7070	2069	(25.681724007856502,39.25)
7071	1747	(23.949673200287624,33.25)
7072	1706	(22.650635094610966,32.5)
7073	1747	(23.949673200287624,33.25)
7074	1706	(22.650635094610966,32.5)
7075	1706	(22.650635094610966,32.5)
7076	1451	(9.6602540378443873,28)
7077	1633	(28.712812921102035,31)
7078	1416	(14.423393758658799,27.25)
7079	1451	(9.6602540378443873,28)
7080	1591	(27.413774815425377,30.25)
7081	1367	(6.196152422706632,26.5)
7082	524	(4.0310889132455356,10.75)
7083	1656	(14.423393758658799,31.75)
7084	2331	(9.6602540378443873,44.5)
7085	1620	(17.454482671904334,31)
7086	1825	(22.217622392718749,34.75)
7087	1291	(9.6602540378443873,25)
7088	978	(15.722431864335457,19)
7089	1451	(9.6602540378443873,28)
7090	782	(19.619546181365433,15.25)
7091	822	(19.186533479473212,16)
7092	820	(17.454482671904334,16)
7093	820	(17.454482671904334,16)
7094	780	(17.887495373796554,15.25)
7095	737	(14.856406460551018,14.5)
7096	818	(15.722431864335457,16)
7097	821	(18.320508075688775,16)
7098	766	(5.7631397208144124,15.25)
7099	819	(16.588457268119896,16)
7100	818	(15.722431864335457,16)
7101	1669	(25.681724007856502,31.75)
7102	1626	(22.650635094610966,31)
7103	1626	(22.650635094610966,31)
7104	296	(14.423393758658799,6.25)
7105	254	(12.258330249197702,5.5)
7106	334	(12.258330249197702,7)
7107	256	(13.99038105676658,5.5)
7108	295	(13.55736835487436,6.25)
7109	336	(13.99038105676658,7)
7110	336	(13.99038105676658,7)
7111	336	(13.99038105676658,7)
7112	13	(11.392304845413264,1)
7113	1514	(30.011851026778693,28.75)
7114	2275	(30.444863728670914,43)
7115	2194	(29.578838324886476,41.5)
7116	2156	(31.743901834347572,40.75)
7117	2004	(3.598076211353316,38.5)
7118	1885	(4.897114317029974,36.25)
7119	2004	(3.598076211353316,38.5)
7120	2004	(3.598076211353316,38.5)
7121	2373	(11.825317547305483,45.25)
7122	2371	(10.093266739736606,45.25)
7123	2374	(12.691342951089922,45.25)
7124	2374	(12.691342951089922,45.25)
7125	2374	(12.691342951089922,45.25)
7126	2375	(13.55736835487436,45.25)
7127	1620	(17.454482671904334,31)
7128	2400	(35.208003449485325,45.25)
7129	2154	(30.011851026778693,40.75)
7130	1960	(34.774990747593108,37)
7131	2196	(31.310889132455351,41.5)
7132	2233	(29.145825622994256,42.25)
7133	761	(1.4330127018922194,15.25)
7134	761	(1.4330127018922194,15.25)
7135	721	(1,14.5)
7136	721	(1,14.5)
7137	761	(1.4330127018922194,15.25)
7138	1243	(3.1650635094610968,24.25)
7139	1203	(2.7320508075688772,23.5)
7140	441	(1.4330127018922194,9.25)
7141	492	(10.526279441628825,10)
7142	441	(1.4330127018922194,9.25)
7143	490	(8.794228634059948,10)
7144	563	(2.7320508075688772,11.5)
7145	1828	(24.815698604072061,34.75)
7146	2111	(26.98076211353316,40)
7147	2111	(26.98076211353316,40)
7148	2108	(24.382685902179844,40)
7149	1841	(1,35.5)
7150	1309	(25.248711305964282,25)
7151	1308	(24.382685902179844,25)
7152	1308	(24.382685902179844,25)
7153	1271	(27.413774815425377,24.25)
7154	1271	(27.413774815425377,24.25)
7155	302	(19.619546181365433,6.25)
7156	302	(19.619546181365433,6.25)
7157	302	(19.619546181365433,6.25)
7158	340	(17.454482671904334,7)
7159	340	(17.454482671904334,7)
7160	339	(16.588457268119896,7)
7161	1760	(35.208003449485325,33.25)
7162	1680	(35.208003449485325,31.75)
7163	2359	(33.908965343808667,44.5)
7164	2279	(33.908965343808667,43)
7165	2225	(22.217622392718749,42.25)
7166	2279	(33.908965343808667,43)
7167	881	(1,17.5)
7168	2070	(26.54774941164094,39.25)
7169	395	(30.877876430563134,7.75)
7170	1761	(1,34)
7171	2040	(34.774990747593108,38.5)
7172	1012	(10.959292143521045,19.75)
7173	1501	(18.753520777580992,28.75)
7174	1541	(18.320508075688775,29.5)
7175	1542	(19.186533479473212,29.5)
7176	1807	(6.6291651245988508,34.75)
7177	2093	(11.392304845413264,40)
7178	2052	(10.959292143521045,39.25)
7179	1847	(6.196152422706632,35.5)
7180	2041	(1.4330127018922194,39.25)
7181	1761	(1,34)
7182	767	(6.6291651245988508,15.25)
7183	767	(6.6291651245988508,15.25)
7184	2374	(12.691342951089922,45.25)
7185	255	(13.124355652982141,5.5)
7186	255	(13.124355652982141,5.5)
7187	1405	(4.897114317029974,27.25)
7188	817	(14.856406460551018,16)
7189	145	(22.217622392718749,3.25)
7190	2035	(30.444863728670914,38.5)
7191	490	(8.794228634059948,10)
7192	33	(28.712812921102035,1)
7193	33	(28.712812921102035,1)
7194	2279	(33.908965343808667,43)
7195	1221	(18.320508075688775,23.5)
7196	1221	(18.320508075688775,23.5)
7197	1791	(26.98076211353316,34)
7198	1229	(25.248711305964282,23.5)
7199	1229	(25.248711305964282,23.5)
7200	1240	(34.774990747593108,23.5)
7201	1399	(33.908965343808667,26.5)
7202	1440	(35.208003449485325,27.25)
7203	1597	(32.609927238132009,30.25)
7204	1598	(33.47595264191645,30.25)
7205	1600	(35.208003449485325,30.25)
7206	2279	(33.908965343808667,43)
7207	2200	(34.774990747593108,41.5)
7208	1871	(26.98076211353316,35.5)
7209	1355	(30.877876430563134,25.75)
7210	1355	(30.877876430563134,25.75)
7211	2200	(34.774990747593108,41.5)
7212	1355	(30.877876430563134,25.75)
7213	1863	(20.05255888325765,35.5)
7214	1869	(25.248711305964282,35.5)
7215	1869	(25.248711305964282,35.5)
7216	1869	(25.248711305964282,35.5)
7217	2051	(10.093266739736606,39.25)
7218	2050	(9.2272413359521668,39.25)
7219	1973	(11.825317547305483,37.75)
7220	2090	(8.794228634059948,40)
7221	1806	(5.7631397208144124,34.75)
7222	1806	(5.7631397208144124,34.75)
7223	1847	(6.196152422706632,35.5)
7224	1847	(6.196152422706632,35.5)
7225	1847	(6.196152422706632,35.5)
7226	1847	(6.196152422706632,35.5)
7227	2124	(4.0310889132455356,40.75)
7228	2165	(4.4641016151377544,41.5)
7229	1453	(11.392304845413264,28)
7230	1492	(10.959292143521045,28.75)
7231	447	(6.6291651245988508,9.25)
7232	446	(5.7631397208144124,9.25)
7233	447	(6.6291651245988508,9.25)
7234	1050	(8.794228634059948,20.5)
7235	1089	(8.3612159321677293,21.25)
7236	1089	(8.3612159321677293,21.25)
7237	1241	(1.4330127018922194,24.25)
7238	1201	(1,23.5)
7239	446	(5.7631397208144124,9.25)
7240	1241	(1.4330127018922194,24.25)
7241	1241	(1.4330127018922194,24.25)
7242	1201	(1,23.5)
7243	1201	(1,23.5)
7244	1089	(8.3612159321677293,21.25)
7245	1491	(10.093266739736606,28.75)
7246	2320	(35.208003449485325,43.75)
7247	1010	(9.2272413359521668,19.75)
7248	1010	(9.2272413359521668,19.75)
7249	1089	(8.3612159321677293,21.25)
7250	2320	(35.208003449485325,43.75)
7251	1241	(1.4330127018922194,24.25)
7252	1241	(1.4330127018922194,24.25)
7253	569	(7.9282032302755088,11.5)
7254	1041	(1,20.5)
7255	446	(5.7631397208144124,9.25)
7256	890	(8.794228634059948,17.5)
7257	2071	(27.413774815425377,39.25)
7258	1651	(10.093266739736606,31.75)
7259	483	(2.7320508075688772,10)
7260	1651	(10.093266739736606,31.75)
7261	1610	(8.794228634059948,31)
7262	1448	(7.0621778264910704,28)
7263	730	(8.794228634059948,14.5)
7264	1681	(1,32.5)
7265	1681	(1,32.5)
7266	1591	(27.413774815425377,30.25)
7267	1591	(27.413774815425377,30.25)
7268	1592	(28.279800219209818,30.25)
7269	1955	(30.444863728670914,37)
7270	1911	(27.413774815425377,36.25)
7271	1872	(27.846787517317598,35.5)
7272	1949	(25.248711305964282,37)
7273	1949	(25.248711305964282,37)
7274	1871	(26.98076211353316,35.5)
7275	1612	(10.526279441628825,31)
7276	570	(8.794228634059948,11.5)
7277	771	(10.093266739736606,15.25)
7278	1010	(9.2272413359521668,19.75)
7279	1050	(8.794228634059948,20.5)
7280	1089	(8.3612159321677293,21.25)
7281	1089	(8.3612159321677293,21.25)
7282	1241	(1.4330127018922194,24.25)
7283	1241	(1.4330127018922194,24.25)
7284	1241	(1.4330127018922194,24.25)
7285	1241	(1.4330127018922194,24.25)
7286	1041	(1,20.5)
7287	554	(30.011851026778693,10.75)
7288	511	(26.98076211353316,10)
7289	347	(23.516660498395403,7)
7290	435	(30.444863728670914,8.5)
7291	145	(22.217622392718749,3.25)
7292	511	(26.98076211353316,10)
7293	511	(26.98076211353316,10)
7294	357	(32.176914536239792,7)
7295	357	(32.176914536239792,7)
7296	318	(33.47595264191645,6.25)
7297	318	(33.47595264191645,6.25)
7298	26	(22.650635094610966,1)
7299	319	(34.341978045700891,6.25)
7300	26	(22.650635094610966,1)
7301	628	(24.815698604072061,12.25)
7302	628	(24.815698604072061,12.25)
7303	880	(35.208003449485325,16.75)
7304	880	(35.208003449485325,16.75)
7305	319	(34.341978045700891,6.25)
7306	107	(23.516660498395403,2.5)
7307	107	(23.516660498395403,2.5)
7308	1393	(28.712812921102035,26.5)
7309	1390	(26.114736709748719,26.5)
7310	1390	(26.114736709748719,26.5)
7311	1470	(26.114736709748719,28)
7312	1508	(24.815698604072061,28.75)
7313	1470	(26.114736709748719,28)
7314	1545	(21.784609690826528,29.5)
7315	1623	(20.05255888325765,31)
7316	1623	(20.05255888325765,31)
7317	423	(20.05255888325765,8.5)
7318	465	(22.217622392718749,9.25)
7319	505	(21.784609690826528,10)
7320	344	(20.918584287042091,7)
7321	344	(20.918584287042091,7)
7322	560	(35.208003449485325,10.75)
7323	560	(35.208003449485325,10.75)
7324	560	(35.208003449485325,10.75)
7325	158	(33.47595264191645,3.25)
7326	158	(33.47595264191645,3.25)
7327	158	(33.47595264191645,3.25)
7328	600	(34.774990747593108,11.5)
7329	600	(34.774990747593108,11.5)
7330	1538	(15.722431864335457,29.5)
7331	1620	(17.454482671904334,31)
7332	1277	(32.609927238132009,24.25)
7333	1476	(31.310889132455351,28)
7334	1753	(29.145825622994256,33.25)
7335	1715	(30.444863728670914,32.5)
7336	1718	(33.042939940024233,32.5)
7337	1760	(35.208003449485325,33.25)
7338	1680	(35.208003449485325,31.75)
7339	1680	(35.208003449485325,31.75)
7340	560	(35.208003449485325,10.75)
7341	560	(35.208003449485325,10.75)
7342	1613	(11.392304845413264,31)
7343	1613	(11.392304845413264,31)
7344	1613	(11.392304845413264,31)
7345	1613	(11.392304845413264,31)
7346	240	(35.208003449485325,4.75)
7347	200	(34.774990747593108,4)
7348	200	(34.774990747593108,4)
7349	240	(35.208003449485325,4.75)
7350	195	(30.444863728670914,4)
7351	196	(31.310889132455351,4)
7352	274	(29.578838324886476,5.5)
7353	319	(34.341978045700891,6.25)
7354	800	(35.208003449485325,15.25)
7355	800	(35.208003449485325,15.25)
7356	1519	(34.341978045700891,28.75)
7357	21	(18.320508075688775,1)
7358	60	(17.887495373796554,1.75)
7359	60	(17.887495373796554,1.75)
7360	18	(15.722431864335457,1)
7361	175	(13.124355652982141,4)
7362	11	(9.6602540378443873,1)
7363	1686	(5.3301270189221936,32.5)
7364	1527	(6.196152422706632,29.5)
7365	1108	(24.815698604072061,21.25)
7366	1026	(23.083647796503186,19.75)
7367	1298	(15.722431864335457,25)
7368	1258	(16.155444566227676,24.25)
7369	1306	(22.650635094610966,25)
7370	1306	(22.650635094610966,25)
7371	1152	(27.846787517317598,22)
7372	1222	(19.186533479473212,23.5)
7373	7	(6.196152422706632,1)
7374	47	(6.6291651245988508,1.75)
7375	43	(3.1650635094610968,1.75)
7376	43	(3.1650635094610968,1.75)
7377	1462	(19.186533479473212,28)
7378	1662	(19.619546181365433,31.75)
7379	43	(3.1650635094610968,1.75)
7380	2186	(22.650635094610966,41.5)
7381	2186	(22.650635094610966,41.5)
7382	2186	(22.650635094610966,41.5)
7383	209	(8.3612159321677293,4.75)
7384	1872	(27.846787517317598,35.5)
7385	2200	(34.774990747593108,41.5)
7386	1614	(12.258330249197702,31)
7387	1684	(3.598076211353316,32.5)
7388	1724	(4.0310889132455356,33.25)
7389	1240	(34.774990747593108,23.5)
7390	1240	(34.774990747593108,23.5)
7391	1597	(32.609927238132009,30.25)
7392	1600	(35.208003449485325,30.25)
7393	1160	(34.774990747593108,22)
7394	1160	(34.774990747593108,22)
7395	1036	(31.743901834347572,19.75)
7396	2317	(32.609927238132009,43.75)
7397	2269	(25.248711305964282,43)
7398	2358	(33.042939940024233,44.5)
7399	1356	(31.743901834347572,25.75)
7400	1955	(30.444863728670914,37)
7401	2159	(34.341978045700891,40.75)
7402	1984	(21.351596988934308,37.75)
7403	2193	(28.712812921102035,41.5)
7404	2154	(30.011851026778693,40.75)
7405	2117	(32.176914536239792,40)
7406	2117	(32.176914536239792,40)
7407	2067	(23.949673200287624,39.25)
7408	2026	(22.650635094610966,38.5)
7409	1952	(27.846787517317598,37)
7410	2150	(26.54774941164094,40.75)
7411	2150	(26.54774941164094,40.75)
7412	893	(11.392304845413264,17.5)
7413	2355	(30.444863728670914,44.5)
7414	2396	(31.743901834347572,45.25)
7415	2398	(33.47595264191645,45.25)
7416	2397	(32.609927238132009,45.25)
7417	2394	(30.011851026778693,45.25)
7418	2392	(28.279800219209818,45.25)
7419	2392	(28.279800219209818,45.25)
7420	1897	(15.289419162443238,36.25)
7421	1813	(11.825317547305483,34.75)
7422	1776	(13.99038105676658,34)
7423	2400	(35.208003449485325,45.25)
7424	1355	(30.877876430563134,25.75)
7425	2399	(34.341978045700891,45.25)
7426	2357	(32.176914536239792,44.5)
7427	2279	(33.908965343808667,43)
7428	665	(21.784609690826528,13)
7429	662	(19.186533479473212,13)
7430	662	(19.186533479473212,13)
7431	662	(19.186533479473212,13)
7432	537	(15.289419162443238,10.75)
7433	665	(21.784609690826528,13)
7434	665	(21.784609690826528,13)
7435	702	(19.619546181365433,13.75)
7436	702	(19.619546181365433,13.75)
7437	814	(12.258330249197702,16)
7438	814	(12.258330249197702,16)
7439	1306	(22.650635094610966,25)
7440	1783	(20.05255888325765,34)
7441	2377	(15.289419162443238,45.25)
7442	2377	(15.289419162443238,45.25)
7443	893	(11.392304845413264,17.5)
7444	894	(12.258330249197702,17.5)
7445	787	(23.949673200287624,15.25)
7446	785	(22.217622392718749,15.25)
7447	785	(22.217622392718749,15.25)
7448	748	(24.382685902179844,14.5)
7449	2317	(32.609927238132009,43.75)
7450	2317	(32.609927238132009,43.75)
7451	2311	(27.413774815425377,43.75)
7452	436	(31.310889132455351,8.5)
7453	438	(33.042939940024233,8.5)
7454	440	(34.774990747593108,8.5)
7455	511	(26.98076211353316,10)
7456	145	(22.217622392718749,3.25)
7457	478	(33.47595264191645,9.25)
7458	317	(32.609927238132009,6.25)
7459	357	(32.176914536239792,7)
7460	357	(32.176914536239792,7)
7461	318	(33.47595264191645,6.25)
7462	318	(33.47595264191645,6.25)
7463	26	(22.650635094610966,1)
7464	26	(22.650635094610966,1)
7465	319	(34.341978045700891,6.25)
7466	1197	(32.609927238132009,22.75)
7467	1158	(33.042939940024233,22)
7468	1197	(32.609927238132009,22.75)
7469	1438	(33.47595264191645,27.25)
7470	1480	(34.774990747593108,28)
7471	720	(35.208003449485325,13.75)
7472	720	(35.208003449485325,13.75)
7473	760	(34.774990747593108,14.5)
7474	760	(34.774990747593108,14.5)
7475	1480	(34.774990747593108,28)
7476	1779	(16.588457268119896,34)
7477	1819	(17.021469970012117,34.75)
7478	1733	(11.825317547305483,33.25)
7479	1942	(19.186533479473212,37)
7480	1733	(11.825317547305483,33.25)
7481	1897	(15.289419162443238,36.25)
7482	1899	(17.021469970012117,36.25)
7483	1779	(16.588457268119896,34)
7484	1779	(16.588457268119896,34)
7485	1821	(18.753520777580992,34.75)
7486	1973	(11.825317547305483,37.75)
7487	1968	(7.49519052838329,37.75)
7488	2127	(6.6291651245988508,40.75)
7489	1889	(8.3612159321677293,36.25)
7490	2052	(10.959292143521045,39.25)
7491	2055	(13.55736835487436,39.25)
7492	2016	(13.99038105676658,38.5)
7493	2060	(17.887495373796554,39.25)
7494	1924	(3.598076211353316,37)
7495	2292	(10.959292143521045,43.75)
7496	2214	(12.691342951089922,42.25)
7497	2052	(10.959292143521045,39.25)
7498	2253	(11.392304845413264,43)
7499	2091	(9.6602540378443873,40)
7500	2212	(10.959292143521045,42.25)
7501	2086	(5.3301270189221936,40)
7502	2121	(1.4330127018922194,40.75)
7503	2050	(9.2272413359521668,39.25)
7504	2050	(9.2272413359521668,39.25)
7505	2004	(3.598076211353316,38.5)
7506	2004	(3.598076211353316,38.5)
7507	2292	(10.959292143521045,43.75)
7508	2098	(15.722431864335457,40)
7509	2098	(15.722431864335457,40)
7510	2137	(15.289419162443238,40.75)
7511	2055	(13.55736835487436,39.25)
7512	2137	(15.289419162443238,40.75)
7513	2137	(15.289419162443238,40.75)
7514	1934	(12.258330249197702,37)
7515	2098	(15.722431864335457,40)
7516	2016	(13.99038105676658,38.5)
7517	2181	(18.320508075688775,41.5)
7518	2388	(24.815698604072061,45.25)
7519	2388	(24.815698604072061,45.25)
7520	2386	(23.083647796503186,45.25)
7521	2341	(18.320508075688775,44.5)
7522	2262	(19.186533479473212,43)
7523	2262	(19.186533479473212,43)
7524	2380	(17.887495373796554,45.25)
7525	2380	(17.887495373796554,45.25)
7526	2345	(21.784609690826528,44.5)
7527	2285	(4.897114317029974,43.75)
7528	2281	(1.4330127018922194,43.75)
7529	2242	(1.8660254037844386,43)
7530	2283	(3.1650635094610968,43.75)
7531	2201	(1.4330127018922194,42.25)
7532	2201	(1.4330127018922194,42.25)
7533	2282	(2.299038105676658,43.75)
7534	511	(26.98076211353316,10)
7535	438	(33.042939940024233,8.5)
7536	357	(32.176914536239792,7)
7537	357	(32.176914536239792,7)
7538	318	(33.47595264191645,6.25)
7539	318	(33.47595264191645,6.25)
7540	26	(22.650635094610966,1)
7541	319	(34.341978045700891,6.25)
7542	357	(32.176914536239792,7)
7543	632	(28.279800219209818,12.25)
7544	632	(28.279800219209818,12.25)
7545	357	(32.176914536239792,7)
7546	357	(32.176914536239792,7)
7547	318	(33.47595264191645,6.25)
7548	318	(33.47595264191645,6.25)
7549	26	(22.650635094610966,1)
7550	319	(34.341978045700891,6.25)
7551	1393	(28.712812921102035,26.5)
7552	1390	(26.114736709748719,26.5)
7553	1390	(26.114736709748719,26.5)
7554	1470	(26.114736709748719,28)
7555	1508	(24.815698604072061,28.75)
7556	1623	(20.05255888325765,31)
7557	318	(33.47595264191645,6.25)
7558	26	(22.650635094610966,1)
7559	319	(34.341978045700891,6.25)
7560	26	(22.650635094610966,1)
7561	760	(34.774990747593108,14.5)
7562	760	(34.774990747593108,14.5)
7563	1480	(34.774990747593108,28)
7564	600	(34.774990747593108,11.5)
7565	600	(34.774990747593108,11.5)
7566	318	(33.47595264191645,6.25)
7567	26	(22.650635094610966,1)
7568	320	(35.208003449485325,6.25)
7569	1508	(24.815698604072061,28.75)
7570	1663	(20.48557158514987,31.75)
7571	794	(30.011851026778693,15.25)
7572	835	(30.444863728670914,16)
7573	834	(29.578838324886476,16)
7574	751	(26.98076211353316,14.5)
7575	1519	(34.341978045700891,28.75)
7576	1032	(28.279800219209818,19.75)
7577	1032	(28.279800219209818,19.75)
7578	1030	(26.54774941164094,19.75)
7579	1030	(26.54774941164094,19.75)
7580	1960	(34.774990747593108,37)
7581	1438	(33.47595264191645,27.25)
7582	1519	(34.341978045700891,28.75)
7583	2154	(30.011851026778693,40.75)
7584	2233	(29.145825622994256,42.25)
7585	2124	(4.0310889132455356,40.75)
7586	1613	(11.392304845413264,31)
7587	490	(8.794228634059948,10)
7588	531	(10.093266739736606,10.75)
7589	1171	(10.093266739736606,22.75)
7590	1454	(12.258330249197702,28)
7591	1407	(6.6291651245988508,27.25)
7592	1407	(6.6291651245988508,27.25)
7593	1171	(10.093266739736606,22.75)
7594	1453	(11.392304845413264,28)
7595	1453	(11.392304845413264,28)
7596	448	(7.49519052838329,9.25)
7597	1050	(8.794228634059948,20.5)
7598	1089	(8.3612159321677293,21.25)
7599	1323	(3.1650635094610968,25.75)
7600	1162	(2.299038105676658,22.75)
7601	1162	(2.299038105676658,22.75)
7602	1162	(2.299038105676658,22.75)
7603	1121	(1,22)
7604	1323	(3.1650635094610968,25.75)
7605	1121	(1,22)
7606	1321	(1.4330127018922194,25.75)
7607	1281	(1,25)
7608	1362	(1.8660254037844386,26.5)
7609	1362	(1.8660254037844386,26.5)
7610	1081	(1.4330127018922194,21.25)
7611	568	(7.0621778264910704,11.5)
7612	682	(2.299038105676658,13.75)
7613	682	(2.299038105676658,13.75)
7614	1128	(7.0621778264910704,22)
7615	1128	(7.0621778264910704,22)
7616	1244	(4.0310889132455356,24.25)
7617	1283	(2.7320508075688772,25)
7618	1241	(1.4330127018922194,24.25)
7619	1241	(1.4330127018922194,24.25)
7620	1241	(1.4330127018922194,24.25)
7621	1041	(1,20.5)
7622	1041	(1,20.5)
7623	1084	(4.0310889132455356,21.25)
7624	1084	(4.0310889132455356,21.25)
7625	1084	(4.0310889132455356,21.25)
7626	1955	(30.444863728670914,37)
7627	2035	(30.444863728670914,38.5)
7628	2071	(27.413774815425377,39.25)
7629	2029	(25.248711305964282,38.5)
7630	1988	(24.815698604072061,37.75)
7631	1602	(1.8660254037844386,31)
7632	1603	(2.7320508075688772,31)
7633	1441	(1,28)
7634	1441	(1,28)
7635	1761	(1,34)
7636	766	(5.7631397208144124,15.25)
7637	766	(5.7631397208144124,15.25)
7638	1441	(1,28)
7639	1441	(1,28)
7640	2156	(31.743901834347572,40.75)
7641	2028	(24.382685902179844,38.5)
7642	2067	(23.949673200287624,39.25)
7643	1993	(29.145825622994256,37.75)
7644	1645	(4.897114317029974,31.75)
7645	586	(22.650635094610966,11.5)
7646	2156	(31.743901834347572,40.75)
7647	665	(21.784609690826528,13)
7648	664	(20.918584287042091,13)
7649	662	(19.186533479473212,13)
7650	661	(18.320508075688775,13)
7651	577	(14.856406460551018,11.5)
7652	617	(15.289419162443238,12.25)
7653	423	(20.05255888325765,8.5)
7654	465	(22.217622392718749,9.25)
7655	344	(20.918584287042091,7)
7656	461	(18.753520777580992,9.25)
7657	1187	(23.949673200287624,22.75)
7658	1066	(22.650635094610966,20.5)
7659	905	(21.784609690826528,17.5)
7660	905	(21.784609690826528,17.5)
7661	1137	(14.856406460551018,22)
7662	1098	(16.155444566227676,21.25)
7663	2344	(20.918584287042091,44.5)
7664	2388	(24.815698604072061,45.25)
7665	2221	(18.753520777580992,42.25)
7666	2386	(23.083647796503186,45.25)
7667	2386	(23.083647796503186,45.25)
7668	2299	(17.021469970012117,43.75)
7669	2365	(4.897114317029974,45.25)
7670	2244	(3.598076211353316,43)
7671	2281	(1.4330127018922194,43.75)
7672	2281	(1.4330127018922194,43.75)
7673	2365	(4.897114317029974,45.25)
7674	2367	(6.6291651245988508,45.25)
7675	2367	(6.6291651245988508,45.25)
7676	2283	(3.1650635094610968,43.75)
7677	2201	(1.4330127018922194,42.25)
7678	2281	(1.4330127018922194,43.75)
7679	1779	(16.588457268119896,34)
7680	1821	(18.753520777580992,34.75)
7681	1978	(16.155444566227676,37.75)
7682	1779	(16.588457268119896,34)
7683	1889	(8.3612159321677293,36.25)
7684	1889	(8.3612159321677293,36.25)
7685	1978	(16.155444566227676,37.75)
7686	2053	(11.825317547305483,39.25)
7687	1978	(16.155444566227676,37.75)
7688	1892	(10.959292143521045,36.25)
7689	1977	(15.289419162443238,37.75)
7690	1817	(15.289419162443238,34.75)
7691	2053	(11.825317547305483,39.25)
7692	2127	(6.6291651245988508,40.75)
7693	2127	(6.6291651245988508,40.75)
7694	1924	(3.598076211353316,37)
7695	2212	(10.959292143521045,42.25)
7696	1977	(15.289419162443238,37.75)
7697	2053	(11.825317547305483,39.25)
7698	1923	(2.7320508075688772,37)
7699	2081	(1,40)
7700	2121	(1.4330127018922194,40.75)
7701	1924	(3.598076211353316,37)
7702	2091	(9.6602540378443873,40)
7703	2212	(10.959292143521045,42.25)
7704	2081	(1,40)
7705	2121	(1.4330127018922194,40.75)
7706	2091	(9.6602540378443873,40)
7707	2170	(8.794228634059948,41.5)
7708	2081	(1,40)
7709	2121	(1.4330127018922194,40.75)
7710	1924	(3.598076211353316,37)
7711	7	(6.196152422706632,1)
7712	7	(6.196152422706632,1)
7713	45	(4.897114317029974,1.75)
7714	85	(4.4641016151377544,2.5)
7715	283	(3.1650635094610968,6.25)
7716	283	(3.1650635094610968,6.25)
7717	282	(2.299038105676658,6.25)
7718	201	(1.4330127018922194,4.75)
7719	1538	(15.722431864335457,29.5)
7720	1538	(15.722431864335457,29.5)
7721	1579	(17.021469970012117,30.25)
7722	1618	(15.722431864335457,31)
7723	1618	(15.722431864335457,31)
7724	1618	(15.722431864335457,31)
7725	1618	(15.722431864335457,31)
7726	2280	(34.774990747593108,43)
7727	1968	(7.49519052838329,37.75)
7728	2212	(10.959292143521045,42.25)
7729	2098	(15.722431864335457,40)
7730	1046	(5.3301270189221936,20.5)
7731	2320	(35.208003449485325,43.75)
7732	890	(8.794228634059948,17.5)
7733	890	(8.794228634059948,17.5)
7734	1205	(4.4641016151377544,23.5)
7735	1046	(5.3301270189221936,20.5)
7736	1205	(4.4641016151377544,23.5)
7737	1534	(12.258330249197702,29.5)
7738	2250	(8.794228634059948,43)
7739	1670	(26.54774941164094,31.75)
7740	1626	(22.650635094610966,31)
7741	1664	(21.351596988934308,31.75)
7742	1783	(20.05255888325765,34)
7743	1783	(20.05255888325765,34)
7744	1743	(20.48557158514987,33.25)
7745	1706	(22.650635094610966,32.5)
7746	1704	(20.918584287042091,32.5)
7747	1704	(20.918584287042091,32.5)
7748	1745	(22.217622392718749,33.25)
7749	814	(12.258330249197702,16)
7750	935	(13.55736835487436,18.25)
7751	855	(13.55736835487436,16.75)
7752	854	(12.691342951089922,16.75)
7753	814	(12.258330249197702,16)
7754	895	(13.124355652982141,17.5)
7755	1592	(28.279800219209818,30.25)
7756	1591	(27.413774815425377,30.25)
7757	1591	(27.413774815425377,30.25)
7758	2279	(33.908965343808667,43)
7759	2400	(35.208003449485325,45.25)
7760	2200	(34.774990747593108,41.5)
7761	1869	(25.248711305964282,35.5)
7762	2399	(34.341978045700891,45.25)
7763	2071	(27.413774815425377,39.25)
7764	938	(16.155444566227676,18.25)
7765	936	(14.423393758658799,18.25)
7766	1054	(12.258330249197702,20.5)
7767	1054	(12.258330249197702,20.5)
7768	1054	(12.258330249197702,20.5)
7769	1058	(15.722431864335457,20.5)
7770	974	(12.258330249197702,19)
7771	1057	(14.856406460551018,20.5)
7772	1160	(34.774990747593108,22)
7773	1160	(34.774990747593108,22)
7774	1360	(35.208003449485325,25.75)
7775	2317	(32.609927238132009,43.75)
7776	2269	(25.248711305964282,43)
7777	2358	(33.042939940024233,44.5)
7778	1356	(31.743901834347572,25.75)
7779	2194	(29.578838324886476,41.5)
7780	2370	(9.2272413359521668,45.25)
7781	2370	(9.2272413359521668,45.25)
7782	1660	(17.887495373796554,31.75)
7783	2376	(14.423393758658799,45.25)
7784	2377	(15.289419162443238,45.25)
7785	2376	(14.423393758658799,45.25)
7786	2376	(14.423393758658799,45.25)
7787	2336	(13.99038105676658,44.5)
7788	1844	(3.598076211353316,35.5)
7789	1534	(12.258330249197702,29.5)
7790	1534	(12.258330249197702,29.5)
7791	1494	(12.691342951089922,28.75)
7792	570	(8.794228634059948,11.5)
7793	1949	(25.248711305964282,37)
7794	771	(10.093266739736606,15.25)
7795	691	(10.093266739736606,13.75)
7796	1487	(6.6291651245988508,28.75)
7797	1365	(4.4641016151377544,26.5)
7798	1365	(4.4641016151377544,26.5)
7799	1186	(23.083647796503186,22.75)
7800	1145	(21.784609690826528,22)
7801	1032	(28.279800219209818,19.75)
7802	1032	(28.279800219209818,19.75)
7803	1152	(27.846787517317598,22)
7804	871	(27.413774815425377,16.75)
7805	1222	(19.186533479473212,23.5)
7806	1222	(19.186533479473212,23.5)
7807	1612	(10.526279441628825,31)
7808	1643	(3.1650635094610968,31.75)
7809	1487	(6.6291651245988508,28.75)
7810	1641	(1.4330127018922194,31.75)
7811	1610	(8.794228634059948,31)
7812	1957	(32.176914536239792,37)
7813	1877	(32.176914536239792,35.5)
7814	1877	(32.176914536239792,35.5)
7815	1995	(30.877876430563134,37.75)
7816	1641	(1.4330127018922194,31.75)
7817	2040	(34.774990747593108,38.5)
7818	2156	(31.743901834347572,40.75)
7819	2159	(34.341978045700891,40.75)
7820	2040	(34.774990747593108,38.5)
7821	2159	(34.341978045700891,40.75)
7822	2200	(34.774990747593108,41.5)
7823	2200	(34.774990747593108,41.5)
7824	1871	(26.98076211353316,35.5)
7825	1907	(23.949673200287624,36.25)
7826	1600	(35.208003449485325,30.25)
7827	1393	(28.712812921102035,26.5)
7828	1390	(26.114736709748719,26.5)
7829	1470	(26.114736709748719,28)
7830	1424	(21.351596988934308,27.25)
7831	1584	(21.351596988934308,30.25)
7832	1464	(20.918584287042091,28)
7833	1623	(20.05255888325765,31)
7834	1584	(21.351596988934308,30.25)
7835	1545	(21.784609690826528,29.5)
7836	1623	(20.05255888325765,31)
7837	1312	(27.846787517317598,25)
7838	1312	(27.846787517317598,25)
7839	1470	(26.114736709748719,28)
7840	2157	(32.609927238132009,40.75)
7841	2156	(31.743901834347572,40.75)
7842	2154	(30.011851026778693,40.75)
7843	1342	(19.619546181365433,25.75)
7844	1379	(16.588457268119896,26.5)
7845	1379	(16.588457268119896,26.5)
7846	1298	(15.722431864335457,25)
7847	632	(28.279800219209818,12.25)
7848	554	(30.011851026778693,10.75)
7849	74	(30.011851026778693,1.75)
7850	70	(26.54774941164094,1.75)
7851	230	(26.54774941164094,4.75)
7852	230	(26.54774941164094,4.75)
7853	70	(26.54774941164094,1.75)
7854	30	(26.114736709748719,1)
7855	80	(35.208003449485325,1.75)
7856	39	(33.908965343808667,1)
7857	80	(35.208003449485325,1.75)
7858	39	(33.908965343808667,1)
7859	80	(35.208003449485325,1.75)
7860	38	(33.042939940024233,1)
7861	554	(30.011851026778693,10.75)
7862	230	(26.54774941164094,4.75)
7863	110	(26.114736709748719,2.5)
7864	70	(26.54774941164094,1.75)
7865	1277	(32.609927238132009,24.25)
7866	1476	(31.310889132455351,28)
7867	1753	(29.145825622994256,33.25)
7868	1715	(30.444863728670914,32.5)
7869	1676	(31.743901834347572,31.75)
7870	1717	(32.176914536239792,32.5)
7871	1718	(33.042939940024233,32.5)
7872	1759	(34.341978045700891,33.25)
7873	1760	(35.208003449485325,33.25)
7874	1760	(35.208003449485325,33.25)
7875	1680	(35.208003449485325,31.75)
7876	1197	(32.609927238132009,22.75)
7877	1197	(32.609927238132009,22.75)
7878	1197	(32.609927238132009,22.75)
7879	957	(32.609927238132009,18.25)
7880	1398	(33.042939940024233,26.5)
7881	1439	(34.341978045700891,27.25)
7882	676	(31.310889132455351,13)
7883	676	(31.310889132455351,13)
7884	306	(23.083647796503186,6.25)
7885	34	(29.578838324886476,1)
7886	1036	(31.743901834347572,19.75)
7887	1036	(31.743901834347572,19.75)
7888	1036	(31.743901834347572,19.75)
7889	1240	(34.774990747593108,23.5)
7890	1240	(34.774990747593108,23.5)
7891	1240	(34.774990747593108,23.5)
7892	1597	(32.609927238132009,30.25)
7893	1600	(35.208003449485325,30.25)
7894	145	(22.217622392718749,3.25)
7895	28	(24.382685902179844,1)
7896	28	(24.382685902179844,1)
7897	720	(35.208003449485325,13.75)
7898	720	(35.208003449485325,13.75)
7899	720	(35.208003449485325,13.75)
7900	2394	(30.011851026778693,45.25)
7901	2392	(28.279800219209818,45.25)
7902	794	(30.011851026778693,15.25)
7903	875	(30.877876430563134,16.75)
7904	752	(27.846787517317598,14.5)
7905	792	(28.279800219209818,15.25)
7906	335	(13.124355652982141,7)
7907	255	(13.124355652982141,5.5)
7908	214	(12.691342951089922,4.75)
7909	1253	(11.825317547305483,24.25)
7910	21	(18.320508075688775,1)
7911	60	(17.887495373796554,1.75)
7912	178	(15.722431864335457,4)
7913	138	(16.155444566227676,3.25)
7914	11	(9.6602540378443873,1)
7915	11	(9.6602540378443873,1)
7916	10	(8.794228634059948,1)
7917	748	(24.382685902179844,14.5)
7918	788	(24.815698604072061,15.25)
7919	367	(6.6291651245988508,7.75)
7920	326	(5.3301270189221936,7)
7921	326	(5.3301270189221936,7)
7922	1960	(34.774990747593108,37)
7923	1773	(11.392304845413264,34)
7924	1818	(16.155444566227676,34.75)
7925	2343	(20.05255888325765,44.5)
7926	2305	(22.217622392718749,43.75)
7927	2306	(23.083647796503186,43.75)
7928	2345	(21.784609690826528,44.5)
7929	2264	(20.918584287042091,43)
7930	2380	(17.887495373796554,45.25)
7931	1844	(3.598076211353316,35.5)
7932	2041	(1.4330127018922194,39.25)
7933	2041	(1.4330127018922194,39.25)
7934	2041	(1.4330127018922194,39.25)
7935	2041	(1.4330127018922194,39.25)
7936	330	(8.794228634059948,7)
7937	719	(34.341978045700891,13.75)
7938	2312	(28.279800219209818,43.75)
7939	2154	(30.011851026778693,40.75)
7940	2233	(29.145825622994256,42.25)
7941	766	(5.7631397208144124,15.25)
7942	766	(5.7631397208144124,15.25)
7943	806	(5.3301270189221936,16)
7944	806	(5.3301270189221936,16)
7945	806	(5.3301270189221936,16)
7946	806	(5.3301270189221936,16)
7947	731	(9.6602540378443873,14.5)
7948	1602	(1.8660254037844386,31)
7949	1603	(2.7320508075688772,31)
7950	1441	(1,28)
7951	1761	(1,34)
7952	766	(5.7631397208144124,15.25)
7953	766	(5.7631397208144124,15.25)
7954	1441	(1,28)
7955	110	(26.114736709748719,2.5)
7956	30	(26.114736709748719,1)
7957	1811	(10.093266739736606,34.75)
7958	2050	(9.2272413359521668,39.25)
7959	2050	(9.2272413359521668,39.25)
7960	2090	(8.794228634059948,40)
7961	2090	(8.794228634059948,40)
7962	2050	(9.2272413359521668,39.25)
7963	2050	(9.2272413359521668,39.25)
7964	1333	(11.825317547305483,25.75)
7965	1333	(11.825317547305483,25.75)
7966	446	(5.7631397208144124,9.25)
7967	1453	(11.392304845413264,28)
7968	1162	(2.299038105676658,22.75)
7969	1121	(1,22)
7970	609	(8.3612159321677293,12.25)
7971	1089	(8.3612159321677293,21.25)
7972	1283	(2.7320508075688772,25)
7973	1241	(1.4330127018922194,24.25)
7974	721	(1,14.5)
7975	721	(1,14.5)
7976	1126	(5.3301270189221936,22)
7977	441	(1.4330127018922194,9.25)
7978	441	(1.4330127018922194,9.25)
7979	603	(3.1650635094610968,12.25)
7980	603	(3.1650635094610968,12.25)
7981	644	(3.598076211353316,13)
7982	521	(1.4330127018922194,10.75)
7983	1249	(8.3612159321677293,24.25)
7984	1086	(5.7631397208144124,21.25)
7985	1328	(7.49519052838329,25.75)
7986	685	(4.897114317029974,13.75)
7987	568	(7.0621778264910704,11.5)
7988	1287	(6.196152422706632,25)
7989	1287	(6.196152422706632,25)
7990	1087	(6.6291651245988508,21.25)
7991	1203	(2.7320508075688772,23.5)
7992	1125	(4.4641016151377544,22)
7993	1125	(4.4641016151377544,22)
7994	1084	(4.0310889132455356,21.25)
7995	1125	(4.4641016151377544,22)
7996	1084	(4.0310889132455356,21.25)
7997	1084	(4.0310889132455356,21.25)
7998	1125	(4.4641016151377544,22)
7999	1790	(26.114736709748719,34)
8000	1905	(22.217622392718749,36.25)
8001	2289	(8.3612159321677293,43.75)
8002	1905	(22.217622392718749,36.25)
8003	2289	(8.3612159321677293,43.75)
8004	1660	(17.887495373796554,31.75)
8005	1833	(29.145825622994256,34.75)
8006	1154	(29.578838324886476,22)
8007	1494	(12.691342951089922,28.75)
8008	1187	(23.949673200287624,22.75)
8009	1145	(21.784609690826528,22)
8010	1033	(29.145825622994256,19.75)
8011	1070	(26.114736709748719,20.5)
8012	1028	(24.815698604072061,19.75)
8013	1027	(23.949673200287624,19.75)
8014	1652	(10.959292143521045,31.75)
8015	2111	(26.98076211353316,40)
8016	2111	(26.98076211353316,40)
8017	2071	(27.413774815425377,39.25)
8018	2071	(27.413774815425377,39.25)
8019	1529	(7.9282032302755088,29.5)
8020	1841	(1,35.5)
8021	1841	(1,35.5)
8022	1761	(1,34)
8023	2071	(27.413774815425377,39.25)
8024	586	(22.650635094610966,11.5)
8025	625	(22.217622392718749,12.25)
8026	1529	(7.9282032302755088,29.5)
8027	1841	(1,35.5)
8028	1529	(7.9282032302755088,29.5)
8029	665	(21.784609690826528,13)
8030	663	(20.05255888325765,13)
8031	662	(19.186533479473212,13)
8032	659	(16.588457268119896,13)
8033	659	(16.588457268119896,13)
8034	945	(22.217622392718749,18.25)
8035	1147	(23.516660498395403,22)
8036	1187	(23.949673200287624,22.75)
8037	1104	(21.351596988934308,21.25)
8038	1064	(20.918584287042091,20.5)
8039	1062	(19.186533479473212,20.5)
8040	1100	(17.887495373796554,21.25)
8041	1063	(20.05255888325765,20.5)
8042	866	(23.083647796503186,16.75)
8043	1063	(20.05255888325765,20.5)
8044	1098	(16.155444566227676,21.25)
8045	1137	(14.856406460551018,22)
8046	1137	(14.856406460551018,22)
8047	905	(21.784609690826528,17.5)
8048	423	(20.05255888325765,8.5)
8049	424	(20.918584287042091,8.5)
8050	424	(20.918584287042091,8.5)
8051	461	(18.753520777580992,9.25)
8052	501	(18.320508075688775,10)
8053	2181	(18.320508075688775,41.5)
8054	2386	(23.083647796503186,45.25)
8055	2385	(22.217622392718749,45.25)
8056	2388	(24.815698604072061,45.25)
8057	2347	(23.516660498395403,44.5)
8058	2347	(23.516660498395403,44.5)
8059	2384	(21.351596988934308,45.25)
8060	2264	(20.918584287042091,43)
8061	2306	(23.083647796503186,43.75)
8062	2306	(23.083647796503186,43.75)
8063	2345	(21.784609690826528,44.5)
8064	2382	(19.619546181365433,45.25)
8065	2382	(19.619546181365433,45.25)
8066	2362	(2.299038105676658,45.25)
8067	2364	(4.0310889132455356,45.25)
8068	2366	(5.7631397208144124,45.25)
8069	2365	(4.897114317029974,45.25)
8070	2367	(6.6291651245988508,45.25)
8071	2361	(1.4330127018922194,45.25)
8072	2368	(7.49519052838329,45.25)
8073	2299	(17.021469970012117,43.75)
8074	2298	(16.155444566227676,43.75)
8075	1902	(19.619546181365433,36.25)
8076	1977	(15.289419162443238,37.75)
8077	1779	(16.588457268119896,34)
8078	1977	(15.289419162443238,37.75)
8079	1892	(10.959292143521045,36.25)
8080	1769	(7.9282032302755088,34)
8081	1807	(6.6291651245988508,34.75)
8082	1772	(10.526279441628825,34)
8083	1893	(11.825317547305483,36.25)
8084	1769	(7.9282032302755088,34)
8085	1977	(15.289419162443238,37.75)
8086	1769	(7.9282032302755088,34)
8087	1977	(15.289419162443238,37.75)
8088	1768	(7.0621778264910704,34)
8089	1977	(15.289419162443238,37.75)
8090	1924	(3.598076211353316,37)
8091	2214	(12.691342951089922,42.25)
8092	2052	(10.959292143521045,39.25)
8093	2206	(5.7631397208144124,42.25)
8094	1977	(15.289419162443238,37.75)
8095	1807	(6.6291651245988508,34.75)
8096	1925	(4.4641016151377544,37)
8097	1902	(19.619546181365433,36.25)
8098	2206	(5.7631397208144124,42.25)
8099	2053	(11.825317547305483,39.25)
8100	1925	(4.4641016151377544,37)
8101	1924	(3.598076211353316,37)
8102	1924	(3.598076211353316,37)
8103	2003	(2.7320508075688772,38.5)
8104	2092	(10.526279441628825,40)
8105	2171	(9.6602540378443873,41.5)
8106	2213	(11.825317547305483,42.25)
8107	2206	(5.7631397208144124,42.25)
8108	2207	(6.6291651245988508,42.25)
8109	1885	(4.897114317029974,36.25)
8110	2060	(17.887495373796554,39.25)
8111	21	(18.320508075688775,1)
8112	95	(13.124355652982141,2.5)
8113	133	(11.825317547305483,3.25)
8114	58	(16.155444566227676,1.75)
8115	17	(14.856406460551018,1)
8116	15	(13.124355652982141,1)
8117	17	(14.856406460551018,1)
8118	57	(15.289419162443238,1.75)
8119	179	(16.588457268119896,4)
8120	179	(16.588457268119896,4)
8121	10	(8.794228634059948,1)
8122	178	(15.722431864335457,4)
8123	10	(8.794228634059948,1)
8124	219	(17.021469970012117,4.75)
8125	1822	(19.619546181365433,34.75)
8126	2016	(13.99038105676658,38.5)
8127	1934	(12.258330249197702,37)
8128	2098	(15.722431864335457,40)
8129	2098	(15.722431864335457,40)
8130	7	(6.196152422706632,1)
8131	7	(6.196152422706632,1)
8132	85	(4.4641016151377544,2.5)
8133	165	(4.4641016151377544,4)
8134	243	(2.7320508075688772,5.5)
8135	321	(1,7)
8136	321	(1,7)
8137	281	(1.4330127018922194,6.25)
8138	281	(1.4330127018922194,6.25)
8139	364	(4.0310889132455356,7.75)
8140	326	(5.3301270189221936,7)
8141	326	(5.3301270189221936,7)
8142	12	(10.526279441628825,1)
8143	13	(11.392304845413264,1)
8144	2320	(35.208003449485325,43.75)
8145	969	(7.9282032302755088,19)
8146	1206	(5.3301270189221936,23.5)
8147	1046	(5.3301270189221936,20.5)
8148	850	(9.2272413359521668,16.75)
8149	2104	(20.918584287042091,40)
8150	1920	(35.208003449485325,36.25)
8151	854	(12.691342951089922,16.75)
8152	855	(13.55736835487436,16.75)
8153	895	(13.124355652982141,17.5)
8154	936	(14.423393758658799,18.25)
8155	936	(14.423393758658799,18.25)
8156	1748	(24.815698604072061,33.25)
8157	1708	(24.382685902179844,32.5)
8158	1708	(24.382685902179844,32.5)
8159	1706	(22.650635094610966,32.5)
8160	1743	(20.48557158514987,33.25)
8161	1342	(19.619546181365433,25.75)
8162	1339	(17.021469970012117,25.75)
8163	1339	(17.021469970012117,25.75)
8164	1298	(15.722431864335457,25)
8165	1296	(13.99038105676658,25)
8166	1297	(14.856406460551018,25)
8167	1256	(14.423393758658799,24.25)
8168	1257	(15.289419162443238,24.25)
8169	1336	(14.423393758658799,25.75)
8170	1256	(14.423393758658799,24.25)
8171	1216	(13.99038105676658,23.5)
8172	1216	(13.99038105676658,23.5)
8173	1306	(22.650635094610966,25)
8174	1160	(34.774990747593108,22)
8175	1160	(34.774990747593108,22)
8176	1360	(35.208003449485325,25.75)
8177	2317	(32.609927238132009,43.75)
8178	2269	(25.248711305964282,43)
8179	2358	(33.042939940024233,44.5)
8180	1356	(31.743901834347572,25.75)
8181	2190	(26.114736709748719,41.5)
8182	2098	(15.722431864335457,40)
8183	2094	(12.258330249197702,40)
8184	1980	(17.887495373796554,37.75)
8185	2396	(31.743901834347572,45.25)
8186	1902	(19.619546181365433,36.25)
8187	2396	(31.743901834347572,45.25)
8188	2396	(31.743901834347572,45.25)
8189	2396	(31.743901834347572,45.25)
8190	1708	(24.382685902179844,32.5)
8191	1708	(24.382685902179844,32.5)
8192	1706	(22.650635094610966,32.5)
8193	1393	(28.712812921102035,26.5)
8194	1342	(19.619546181365433,25.75)
8195	1350	(26.54774941164094,25.75)
8196	1470	(26.114736709748719,28)
8197	1427	(23.949673200287624,27.25)
8198	1471	(26.98076211353316,28)
8199	1427	(23.949673200287624,27.25)
8200	1427	(23.949673200287624,27.25)
8201	1433	(29.145825622994256,27.25)
8202	1460	(17.454482671904334,28)
8203	1460	(17.454482671904334,28)
8204	1460	(17.454482671904334,28)
8205	1460	(17.454482671904334,28)
8206	1460	(17.454482671904334,28)
8207	1615	(13.124355652982141,31)
8208	1615	(13.124355652982141,31)
8209	1574	(12.691342951089922,30.25)
8210	1911	(27.413774815425377,36.25)
8211	692	(10.959292143521045,13.75)
8212	1615	(13.124355652982141,31)
8213	1407	(6.6291651245988508,27.25)
8214	1487	(6.6291651245988508,28.75)
8215	1405	(4.897114317029974,27.25)
8216	1448	(7.0621778264910704,28)
8217	1647	(6.6291651245988508,31.75)
8218	1987	(23.949673200287624,37.75)
8219	1877	(32.176914536239792,35.5)
8220	1993	(29.145825622994256,37.75)
8221	1610	(8.794228634059948,31)
8222	1647	(6.6291651245988508,31.75)
8223	1647	(6.6291651245988508,31.75)
8224	1153	(28.712812921102035,22)
8225	911	(26.98076211353316,17.5)
8226	870	(26.54774941164094,16.75)
8227	870	(26.54774941164094,16.75)
8228	1193	(29.145825622994256,22.75)
8229	1182	(19.619546181365433,22.75)
8230	1647	(6.6291651245988508,31.75)
8231	412	(10.526279441628825,8.5)
8232	2157	(32.609927238132009,40.75)
8233	2156	(31.743901834347572,40.75)
8234	2194	(29.578838324886476,41.5)
8235	794	(30.011851026778693,15.25)
8236	794	(30.011851026778693,15.25)
8237	794	(30.011851026778693,15.25)
8238	792	(28.279800219209818,15.25)
8239	831	(26.98076211353316,16)
8240	2033	(28.712812921102035,38.5)
8241	2033	(28.712812921102035,38.5)
8242	1610	(8.794228634059948,31)
8243	1608	(7.0621778264910704,31)
8244	1608	(7.0621778264910704,31)
8245	1565	(4.897114317029974,30.25)
8246	2067	(23.949673200287624,39.25)
8247	2028	(24.382685902179844,38.5)
8248	2400	(35.208003449485325,45.25)
8249	2200	(34.774990747593108,41.5)
8250	1869	(25.248711305964282,35.5)
8251	2399	(34.341978045700891,45.25)
8252	2279	(33.908965343808667,43)
8253	1955	(30.444863728670914,37)
8254	2040	(34.774990747593108,38.5)
8255	2156	(31.743901834347572,40.75)
8256	2159	(34.341978045700891,40.75)
8257	2040	(34.774990747593108,38.5)
8258	1954	(29.578838324886476,37)
8259	522	(2.299038105676658,10.75)
8260	601	(1.4330127018922194,12.25)
8261	1989	(25.681724007856502,37.75)
8262	2159	(34.341978045700891,40.75)
8263	1232	(27.846787517317598,23.5)
8264	2154	(30.011851026778693,40.75)
8265	1219	(16.588457268119896,23.5)
8266	1219	(16.588457268119896,23.5)
8267	2040	(34.774990747593108,38.5)
8268	1412	(10.959292143521045,27.25)
8269	1410	(9.2272413359521668,27.25)
8270	1451	(9.6602540378443873,28)
8271	1411	(10.093266739736606,27.25)
8272	1411	(10.093266739736606,27.25)
8273	1592	(28.279800219209818,30.25)
8274	1591	(27.413774815425377,30.25)
8275	1407	(6.6291651245988508,27.25)
8276	1055	(13.124355652982141,20.5)
8277	1019	(17.021469970012117,19.75)
8278	975	(13.124355652982141,19)
8279	1135	(13.124355652982141,22)
8280	1055	(13.124355652982141,20.5)
8281	1054	(12.258330249197702,20.5)
8282	941	(18.753520777580992,18.25)
8283	2374	(12.691342951089922,45.25)
8284	2374	(12.691342951089922,45.25)
8285	2337	(14.856406460551018,44.5)
8286	2337	(14.856406460551018,44.5)
8287	2376	(14.423393758658799,45.25)
8288	2373	(11.825317547305483,45.25)
8289	1786	(22.650635094610966,34)
8290	2370	(9.2272413359521668,45.25)
8291	2370	(9.2272413359521668,45.25)
8292	2370	(9.2272413359521668,45.25)
8293	1786	(22.650635094610966,34)
8294	2370	(9.2272413359521668,45.25)
8295	1537	(14.856406460551018,29.5)
8296	1577	(15.289419162443238,30.25)
8297	1618	(15.722431864335457,31)
8298	1834	(30.011851026778693,34.75)
8299	2200	(34.774990747593108,41.5)
8300	1907	(23.949673200287624,36.25)
8301	1907	(23.949673200287624,36.25)
8302	1907	(23.949673200287624,36.25)
8303	1947	(23.516660498395403,37)
8304	1602	(1.8660254037844386,31)
8305	1947	(23.516660498395403,37)
8306	1958	(33.042939940024233,37)
8307	511	(26.98076211353316,10)
8308	480	(35.208003449485325,9.25)
8309	480	(35.208003449485325,9.25)
8310	480	(35.208003449485325,9.25)
8311	2118	(33.042939940024233,40)
8312	1000	(34.774990747593108,19)
8313	39	(33.908965343808667,1)
8314	478	(33.47595264191645,9.25)
8315	438	(33.042939940024233,8.5)
8316	108	(24.382685902179844,2.5)
8317	108	(24.382685902179844,2.5)
8318	108	(24.382685902179844,2.5)
8319	108	(24.382685902179844,2.5)
8320	480	(35.208003449485325,9.25)
8321	480	(35.208003449485325,9.25)
8322	480	(35.208003449485325,9.25)
8323	151	(27.413774815425377,3.25)
8324	72	(28.279800219209818,1.75)
8325	73	(29.145825622994256,1.75)
8326	73	(29.145825622994256,1.75)
8327	993	(28.712812921102035,19)
8328	993	(28.712812921102035,19)
8329	992	(27.846787517317598,19)
8330	663	(20.05255888325765,13)
8331	1029	(25.681724007856502,19.75)
8332	947	(23.949673200287624,18.25)
8333	908	(24.382685902179844,17.5)
8334	398	(33.47595264191645,7.75)
8335	398	(33.47595264191645,7.75)
8336	398	(33.47595264191645,7.75)
8337	37	(32.176914536239792,1)
8338	80	(35.208003449485325,1.75)
8339	37	(32.176914536239792,1)
8340	80	(35.208003449485325,1.75)
8341	80	(35.208003449485325,1.75)
8342	37	(32.176914536239792,1)
8343	37	(32.176914536239792,1)
8344	80	(35.208003449485325,1.75)
8345	39	(33.908965343808667,1)
8346	1237	(32.176914536239792,23.5)
8347	1237	(32.176914536239792,23.5)
8348	1197	(32.609927238132009,22.75)
8349	1359	(34.341978045700891,25.75)
8350	1439	(34.341978045700891,27.25)
8351	28	(24.382685902179844,1)
8352	28	(24.382685902179844,1)
8353	28	(24.382685902179844,1)
8354	70	(26.54774941164094,1.75)
8355	145	(22.217622392718749,3.25)
8356	145	(22.217622392718749,3.25)
8357	187	(23.516660498395403,4)
8358	36	(31.310889132455351,1)
8359	720	(35.208003449485325,13.75)
8360	720	(35.208003449485325,13.75)
8361	720	(35.208003449485325,13.75)
8362	438	(33.042939940024233,8.5)
8363	438	(33.042939940024233,8.5)
8364	438	(33.042939940024233,8.5)
8365	1277	(32.609927238132009,24.25)
8366	1277	(32.609927238132009,24.25)
8367	1476	(31.310889132455351,28)
8368	1753	(29.145825622994256,33.25)
8369	1715	(30.444863728670914,32.5)
8370	1676	(31.743901834347572,31.75)
8371	1717	(32.176914536239792,32.5)
8372	1718	(33.042939940024233,32.5)
8373	1759	(34.341978045700891,33.25)
8374	1760	(35.208003449485325,33.25)
8375	438	(33.042939940024233,8.5)
8376	1240	(34.774990747593108,23.5)
8377	1240	(34.774990747593108,23.5)
8378	1360	(35.208003449485325,25.75)
8379	1440	(35.208003449485325,27.25)
8380	1598	(33.47595264191645,30.25)
8381	2396	(31.743901834347572,45.25)
8382	108	(24.382685902179844,2.5)
8383	668	(24.382685902179844,13)
8384	668	(24.382685902179844,13)
8385	108	(24.382685902179844,2.5)
8386	108	(24.382685902179844,2.5)
8387	1036	(31.743901834347572,19.75)
8388	1036	(31.743901834347572,19.75)
8389	673	(28.712812921102035,13)
8390	1036	(31.743901834347572,19.75)
8391	1036	(31.743901834347572,19.75)
8392	1036	(31.743901834347572,19.75)
8393	1040	(35.208003449485325,19.75)
8394	676	(31.310889132455351,13)
8395	514	(29.578838324886476,10)
8396	514	(29.578838324886476,10)
8397	113	(28.712812921102035,2.5)
8398	399	(34.341978045700891,7.75)
8399	1841	(1,35.5)
8400	1841	(1,35.5)
8401	1761	(1,34)
8402	1945	(21.784609690826528,37)
8403	1945	(21.784609690826528,37)
8404	2353	(28.712812921102035,44.5)
8405	2392	(28.279800219209818,45.25)
8406	2352	(27.846787517317598,44.5)
8407	2392	(28.279800219209818,45.25)
8408	2392	(28.279800219209818,45.25)
8409	2392	(28.279800219209818,45.25)
8410	688	(7.49519052838329,13.75)
8411	1602	(1.8660254037844386,31)
8412	2312	(28.279800219209818,43.75)
8413	2154	(30.011851026778693,40.75)
8414	2038	(33.042939940024233,38.5)
8415	2233	(29.145825622994256,42.25)
8416	782	(19.619546181365433,15.25)
8417	822	(19.186533479473212,16)
8418	821	(18.320508075688775,16)
8419	821	(18.320508075688775,16)
8420	819	(16.588457268119896,16)
8421	862	(19.619546181365433,16.75)
8422	819	(16.588457268119896,16)
8423	821	(18.320508075688775,16)
8424	336	(13.99038105676658,7)
8425	295	(13.55736835487436,6.25)
8426	375	(13.55736835487436,7.75)
8427	335	(13.124355652982141,7)
8428	255	(13.124355652982141,5.5)
8429	336	(13.99038105676658,7)
8430	13	(11.392304845413264,1)
8431	1412	(10.959292143521045,27.25)
8432	1410	(9.2272413359521668,27.25)
8433	1412	(10.959292143521045,27.25)
8434	1410	(9.2272413359521668,27.25)
8435	1411	(10.093266739736606,27.25)
8436	481	(1,10)
8437	601	(1.4330127018922194,12.25)
8438	1290	(8.794228634059948,25)
8439	1288	(7.0621778264910704,25)
8440	1085	(4.897114317029974,21.25)
8441	1084	(4.0310889132455356,21.25)
8442	1084	(4.0310889132455356,21.25)
8443	1047	(6.196152422706632,20.5)
8444	1084	(4.0310889132455356,21.25)
8445	2359	(33.908965343808667,44.5)
8446	223	(20.48557158514987,4.75)
8447	223	(20.48557158514987,4.75)
8448	223	(20.48557158514987,4.75)
8449	2196	(31.310889132455351,41.5)
8450	1960	(34.774990747593108,37)
8451	300	(17.887495373796554,6.25)
8452	339	(16.588457268119896,7)
8453	1	(1,1)
8454	1	(1,1)
8455	1	(1,1)
8456	1949	(25.248711305964282,37)
8457	1567	(6.6291651245988508,30.25)
8458	1704	(20.918584287042091,32.5)
8459	1626	(22.650635094610966,31)
8460	2029	(25.248711305964282,38.5)
8461	2065	(22.217622392718749,39.25)
8462	1370	(8.794228634059948,26.5)
8463	1249	(8.3612159321677293,24.25)
8464	1047	(6.196152422706632,20.5)
8465	721	(1,14.5)
8466	1249	(8.3612159321677293,24.25)
8467	2279	(33.908965343808667,43)
8468	2029	(25.248711305964282,38.5)
8469	1642	(2.299038105676658,31.75)
8470	1570	(9.2272413359521668,30.25)
8471	2105	(21.784609690826528,40)
8472	1125	(4.4641016151377544,22)
8473	1084	(4.0310889132455356,21.25)
8474	1087	(6.6291651245988508,21.25)
8475	1249	(8.3612159321677293,24.25)
8476	1249	(8.3612159321677293,24.25)
8477	1328	(7.49519052838329,25.75)
8478	1036	(31.743901834347572,19.75)
8479	840	(34.774990747593108,16)
8480	1470	(26.114736709748719,28)
8481	1036	(31.743901834347572,19.75)
8482	360	(34.774990747593108,7)
8483	1470	(26.114736709748719,28)
8484	1471	(26.98076211353316,28)
8485	1470	(26.114736709748719,28)
8486	1623	(20.05255888325765,31)
8487	480	(35.208003449485325,9.25)
8488	1076	(31.310889132455351,20.5)
8489	1040	(35.208003449485325,19.75)
8490	1040	(35.208003449485325,19.75)
8491	838	(33.042939940024233,16)
8492	1117	(32.609927238132009,21.25)
8493	1439	(34.341978045700891,27.25)
8494	713	(29.145825622994256,13.75)
8495	231	(27.413774815425377,4.75)
8496	146	(23.083647796503186,3.25)
8497	920	(34.774990747593108,17.5)
8498	1079	(33.908965343808667,20.5)
8499	1040	(35.208003449485325,19.75)
8500	1476	(31.310889132455351,28)
8501	439	(33.908965343808667,8.5)
8502	37	(32.176914536239792,1)
8503	1080	(34.774990747593108,20.5)
8504	920	(34.774990747593108,17.5)
8505	959	(34.341978045700891,18.25)
8506	880	(35.208003449485325,16.75)
8507	1439	(34.341978045700891,27.25)
8508	628	(24.815698604072061,12.25)
8509	880	(35.208003449485325,16.75)
8510	64	(21.351596988934308,1.75)
8511	145	(22.217622392718749,3.25)
8512	110	(26.114736709748719,2.5)
8513	37	(32.176914536239792,1)
8514	240	(35.208003449485325,4.75)
8515	438	(33.042939940024233,8.5)
8516	1000	(34.774990747593108,19)
8517	146	(23.083647796503186,3.25)
8518	701	(18.753520777580992,13.75)
8519	416	(13.99038105676658,8.5)
8520	623	(20.48557158514987,12.25)
8521	993	(28.712812921102035,19)
8522	991	(26.98076211353316,19)
8523	1029	(25.681724007856502,19.75)
8524	947	(23.949673200287624,18.25)
8525	1306	(22.650635094610966,25)
8526	662	(19.186533479473212,13)
8527	625	(22.217622392718749,12.25)
8528	659	(16.588457268119896,13)
8529	327	(6.196152422706632,7)
8530	13	(11.392304845413264,1)
8531	1137	(14.856406460551018,22)
8532	2310	(26.54774941164094,43.75)
8533	792	(28.279800219209818,15.25)
8534	1960	(34.774990747593108,37)
8535	1960	(34.774990747593108,37)
8536	1955	(30.444863728670914,37)
8537	1958	(33.042939940024233,37)
8538	1989	(25.681724007856502,37.75)
8539	1567	(6.6291651245988508,30.25)
8540	201	(1.4330127018922194,4.75)
8541	165	(4.4641016151377544,4)
8542	2050	(9.2272413359521668,39.25)
8543	2091	(9.6602540378443873,40)
8544	2170	(8.794228634059948,41.5)
8545	2123	(3.1650635094610968,40.75)
8546	2262	(19.186533479473212,43)
8547	2345	(21.784609690826528,44.5)
8548	2380	(17.887495373796554,45.25)
8549	2285	(4.897114317029974,43.75)
8550	2281	(1.4330127018922194,43.75)
8551	2380	(17.887495373796554,45.25)
8552	822	(19.186533479473212,16)
8553	1958	(33.042939940024233,37)
8554	1512	(28.279800219209818,28.75)
8555	1234	(29.578838324886476,23.5)
8556	2098	(15.722431864335457,40)
8557	2399	(34.341978045700891,45.25)
8558	2399	(34.341978045700891,45.25)
8559	1976	(14.423393758658799,37.75)
8560	2279	(33.908965343808667,43)
8561	1050	(8.794228634059948,20.5)
8562	490	(8.794228634059948,10)
8563	566	(5.3301270189221936,11.5)
8564	566	(5.3301270189221936,11.5)
8565	529	(8.3612159321677293,10.75)
8566	1050	(8.794228634059948,20.5)
8567	1089	(8.3612159321677293,21.25)
8568	1282	(1.8660254037844386,25)
8569	1282	(1.8660254037844386,25)
8570	1363	(2.7320508075688772,26.5)
8571	1323	(3.1650635094610968,25.75)
8572	1283	(2.7320508075688772,25)
8573	1323	(3.1650635094610968,25.75)
8574	1203	(2.7320508075688772,23.5)
8575	1282	(1.8660254037844386,25)
8576	1084	(4.0310889132455356,21.25)
8577	1084	(4.0310889132455356,21.25)
8578	1004	(4.0310889132455356,19.75)
8579	1161	(1.4330127018922194,22.75)
8580	1161	(1.4330127018922194,22.75)
8581	841	(1.4330127018922194,16.75)
8582	644	(3.598076211353316,13)
8583	644	(3.598076211353316,13)
8584	685	(4.897114317029974,13.75)
8585	1290	(8.794228634059948,25)
8586	1249	(8.3612159321677293,24.25)
8587	1287	(6.196152422706632,25)
8588	1125	(4.4641016151377544,22)
8589	1203	(2.7320508075688772,23.5)
8590	1203	(2.7320508075688772,23.5)
8591	964	(3.598076211353316,19)
8592	921	(1.4330127018922194,18.25)
8593	1084	(4.0310889132455356,21.25)
8594	2370	(9.2272413359521668,45.25)
8595	1786	(22.650635094610966,34)
8596	2370	(9.2272413359521668,45.25)
8597	2289	(8.3612159321677293,43.75)
8598	2162	(1.8660254037844386,41.5)
8599	2111	(26.98076211353316,40)
8600	1608	(7.0621778264910704,31)
8601	1608	(7.0621778264910704,31)
8602	2111	(26.98076211353316,40)
8603	1841	(1,35.5)
8604	1841	(1,35.5)
8605	1761	(1,34)
8606	1761	(1,34)
8607	1911	(27.413774815425377,36.25)
8608	2159	(34.341978045700891,40.75)
8609	1949	(25.248711305964282,37)
8610	2194	(29.578838324886476,41.5)
8611	1949	(25.248711305964282,37)
8612	1298	(15.722431864335457,25)
8613	1298	(15.722431864335457,25)
8614	1297	(14.856406460551018,25)
8615	1306	(22.650635094610966,25)
8616	1306	(22.650635094610966,25)
8617	1306	(22.650635094610966,25)
8618	665	(21.784609690826528,13)
8619	701	(18.753520777580992,13.75)
8620	537	(15.289419162443238,10.75)
8621	617	(15.289419162443238,12.25)
8622	945	(22.217622392718749,18.25)
8623	1147	(23.516660498395403,22)
8624	1147	(23.516660498395403,22)
8625	1188	(24.815698604072061,22.75)
8626	1188	(24.815698604072061,22.75)
8627	1069	(25.248711305964282,20.5)
8628	1025	(22.217622392718749,19.75)
8629	1104	(21.351596988934308,21.25)
8630	1062	(19.186533479473212,20.5)
8631	866	(23.083647796503186,16.75)
8632	905	(21.784609690826528,17.5)
8633	1137	(14.856406460551018,22)
8634	905	(21.784609690826528,17.5)
8635	1063	(20.05255888325765,20.5)
8636	1747	(23.949673200287624,33.25)
8637	1706	(22.650635094610966,32.5)
8638	1706	(22.650635094610966,32.5)
8639	1706	(22.650635094610966,32.5)
8640	772	(10.959292143521045,15.25)
8641	1020	(17.887495373796554,19.75)
8642	973	(11.392304845413264,19)
8643	973	(11.392304845413264,19)
8644	1014	(12.691342951089922,19.75)
8645	1053	(11.392304845413264,20.5)
8646	2386	(23.083647796503186,45.25)
8647	2386	(23.083647796503186,45.25)
8648	2379	(17.021469970012117,45.25)
8649	2347	(23.516660498395403,44.5)
8650	2382	(19.619546181365433,45.25)
8651	2382	(19.619546181365433,45.25)
8652	2342	(19.186533479473212,44.5)
8653	2382	(19.619546181365433,45.25)
8654	2380	(17.887495373796554,45.25)
8655	2367	(6.6291651245988508,45.25)
8656	2361	(1.4330127018922194,45.25)
8657	2321	(1,44.5)
8658	2325	(4.4641016151377544,44.5)
8659	2367	(6.6291651245988508,45.25)
8660	2365	(4.897114317029974,45.25)
8661	2244	(3.598076211353316,43)
8662	2361	(1.4330127018922194,45.25)
8663	2361	(1.4330127018922194,45.25)
8664	570	(8.794228634059948,11.5)
8665	1647	(6.6291651245988508,31.75)
8666	2181	(18.320508075688775,41.5)
8667	2380	(17.887495373796554,45.25)
8668	179	(16.588457268119896,4)
8669	99	(16.588457268119896,2.5)
8670	179	(16.588457268119896,4)
8671	101	(18.320508075688775,2.5)
8672	101	(18.320508075688775,2.5)
8673	18	(15.722431864335457,1)
8674	11	(9.6602540378443873,1)
8675	17	(14.856406460551018,1)
8676	17	(14.856406460551018,1)
8677	178	(15.722431864335457,4)
8678	179	(16.588457268119896,4)
8679	18	(15.722431864335457,1)
8680	10	(8.794228634059948,1)
8681	167	(6.196152422706632,4)
8682	6	(5.3301270189221936,1)
8683	6	(5.3301270189221936,1)
8684	45	(4.897114317029974,1.75)
8685	165	(4.4641016151377544,4)
8686	165	(4.4641016151377544,4)
8687	165	(4.4641016151377544,4)
8688	164	(3.598076211353316,4)
8689	201	(1.4330127018922194,4.75)
8690	201	(1.4330127018922194,4.75)
8691	2200	(34.774990747593108,41.5)
8692	1949	(25.248711305964282,37)
8693	1993	(29.145825622994256,37.75)
8694	1612	(10.526279441628825,31)
8695	1989	(25.681724007856502,37.75)
8696	748	(24.382685902179844,14.5)
8697	788	(24.815698604072061,15.25)
8698	788	(24.815698604072061,15.25)
8699	827	(23.516660498395403,16)
8700	734	(12.258330249197702,14.5)
8701	936	(14.423393758658799,18.25)
8702	1051	(9.6602540378443873,20.5)
8703	968	(7.0621778264910704,19)
8704	1245	(4.897114317029974,24.25)
8705	1205	(4.4641016151377544,23.5)
8706	2063	(20.48557158514987,39.25)
8707	2157	(32.609927238132009,40.75)
8708	1955	(30.444863728670914,37)
8709	2040	(34.774990747593108,38.5)
8710	1877	(32.176914536239792,35.5)
8711	1652	(10.959292143521045,31.75)
8712	2146	(23.083647796503186,40.75)
8713	2186	(22.650635094610966,41.5)
8714	209	(8.3612159321677293,4.75)
8715	2186	(22.650635094610966,41.5)
8716	2400	(35.208003449485325,45.25)
8717	2200	(34.774990747593108,41.5)
8718	2399	(34.341978045700891,45.25)
8719	2319	(34.341978045700891,43.75)
8720	2187	(23.516660498395403,41.5)
8721	2337	(14.856406460551018,44.5)
8722	2373	(11.825317547305483,45.25)
8723	2336	(13.99038105676658,44.5)
8724	2374	(12.691342951089922,45.25)
8725	2372	(10.959292143521045,45.25)
8726	1160	(34.774990747593108,22)
8727	1160	(34.774990747593108,22)
8728	1160	(34.774990747593108,22)
8729	1360	(35.208003449485325,25.75)
8730	2317	(32.609927238132009,43.75)
8731	2269	(25.248711305964282,43)
8732	2358	(33.042939940024233,44.5)
8733	1356	(31.743901834347572,25.75)
8734	1240	(34.774990747593108,23.5)
8735	1240	(34.774990747593108,23.5)
8736	1360	(35.208003449485325,25.75)
8737	1597	(32.609927238132009,30.25)
8738	1600	(35.208003449485325,30.25)
8739	1355	(30.877876430563134,25.75)
8740	1872	(27.846787517317598,35.5)
8741	2397	(32.609927238132009,45.25)
8742	2397	(32.609927238132009,45.25)
8743	2396	(31.743901834347572,45.25)
8744	2060	(17.887495373796554,39.25)
8745	1779	(16.588457268119896,34)
8746	1779	(16.588457268119896,34)
8747	1819	(17.021469970012117,34.75)
8748	1695	(13.124355652982141,32.5)
8749	1779	(16.588457268119896,34)
8750	2101	(18.320508075688775,40)
8751	1806	(5.7631397208144124,34.75)
8752	1924	(3.598076211353316,37)
8753	1779	(16.588457268119896,34)
8754	1930	(8.794228634059948,37)
8755	2060	(17.887495373796554,39.25)
8756	1977	(15.289419162443238,37.75)
8757	1892	(10.959292143521045,36.25)
8758	1930	(8.794228634059948,37)
8759	2101	(18.320508075688775,40)
8760	2060	(17.887495373796554,39.25)
8761	1769	(7.9282032302755088,34)
8762	1768	(7.0621778264910704,34)
8763	2060	(17.887495373796554,39.25)
8764	1925	(4.4641016151377544,37)
8765	2206	(5.7631397208144124,42.25)
8766	2092	(10.526279441628825,40)
8767	1924	(3.598076211353316,37)
8768	1768	(7.0621778264910704,34)
8769	1977	(15.289419162443238,37.75)
8770	1977	(15.289419162443238,37.75)
8771	1928	(7.0621778264910704,37)
8772	1925	(4.4641016151377544,37)
8773	1889	(8.3612159321677293,36.25)
8774	2053	(11.825317547305483,39.25)
8775	2092	(10.526279441628825,40)
8776	2174	(12.258330249197702,41.5)
8777	2092	(10.526279441628825,40)
8778	2213	(11.825317547305483,42.25)
8779	2212	(10.959292143521045,42.25)
8780	2004	(3.598076211353316,38.5)
8781	2132	(10.959292143521045,40.75)
8782	1924	(3.598076211353316,37)
8783	2003	(2.7320508075688772,38.5)
8784	1352	(28.279800219209818,25.75)
8785	1352	(28.279800219209818,25.75)
8786	1390	(26.114736709748719,26.5)
8787	1390	(26.114736709748719,26.5)
8788	1470	(26.114736709748719,28)
8789	1427	(23.949673200287624,27.25)
8790	1464	(20.918584287042091,28)
8791	1542	(19.186533479473212,29.5)
8792	1542	(19.186533479473212,29.5)
8793	1312	(27.846787517317598,25)
8794	1470	(26.114736709748719,28)
8795	1233	(28.712812921102035,23.5)
8796	835	(30.444863728670914,16)
8797	794	(30.011851026778693,15.25)
8798	792	(28.279800219209818,15.25)
8799	834	(29.578838324886476,16)
8800	834	(29.578838324886476,16)
8801	423	(20.05255888325765,8.5)
8802	461	(18.753520777580992,9.25)
8803	505	(21.784609690826528,10)
8804	505	(21.784609690826528,10)
8805	425	(21.784609690826528,8.5)
8806	632	(28.279800219209818,12.25)
8807	231	(27.413774815425377,4.75)
8808	33	(28.712812921102035,1)
8809	33	(28.712812921102035,1)
8810	33	(28.712812921102035,1)
8811	33	(28.712812921102035,1)
8812	33	(28.712812921102035,1)
8813	33	(28.712812921102035,1)
8814	33	(28.712812921102035,1)
8815	33	(28.712812921102035,1)
8816	33	(28.712812921102035,1)
8817	33	(28.712812921102035,1)
8818	189	(25.248711305964282,4)
8819	589	(25.248711305964282,11.5)
8820	589	(25.248711305964282,11.5)
8821	589	(25.248711305964282,11.5)
8822	589	(25.248711305964282,11.5)
8823	589	(25.248711305964282,11.5)
8824	589	(25.248711305964282,11.5)
8825	1187	(23.949673200287624,22.75)
8826	1225	(21.784609690826528,23.5)
8827	1197	(32.609927238132009,22.75)
8828	1197	(32.609927238132009,22.75)
8829	1237	(32.176914536239792,23.5)
8830	1197	(32.609927238132009,22.75)
8831	1318	(33.042939940024233,25)
8832	1318	(33.042939940024233,25)
8833	1318	(33.042939940024233,25)
8834	840	(34.774990747593108,16)
8835	840	(34.774990747593108,16)
8836	37	(32.176914536239792,1)
8837	37	(32.176914536239792,1)
8838	37	(32.176914536239792,1)
8839	240	(35.208003449485325,4.75)
8840	240	(35.208003449485325,4.75)
8841	1537	(14.856406460551018,29.5)
8842	1577	(15.289419162443238,30.25)
8843	1618	(15.722431864335457,31)
8844	438	(33.042939940024233,8.5)
8845	439	(33.908965343808667,8.5)
8846	439	(33.908965343808667,8.5)
8847	398	(33.47595264191645,7.75)
8848	439	(33.908965343808667,8.5)
8849	439	(33.908965343808667,8.5)
8850	555	(30.877876430563134,10.75)
8851	514	(29.578838324886476,10)
8852	397	(32.609927238132009,7.75)
8853	397	(32.609927238132009,7.75)
8854	1501	(18.753520777580992,28.75)
8855	1464	(20.918584287042091,28)
8856	1504	(21.351596988934308,28.75)
8857	1544	(20.918584287042091,29.5)
8858	1623	(20.05255888325765,31)
8859	1592	(28.279800219209818,30.25)
8860	1591	(27.413774815425377,30.25)
8861	1591	(27.413774815425377,30.25)
8862	941	(18.753520777580992,18.25)
8863	490	(8.794228634059948,10)
8864	1454	(12.258330249197702,28)
8865	1407	(6.6291651245988508,27.25)
8866	1333	(11.825317547305483,25.75)
8867	1333	(11.825317547305483,25.75)
8868	1366	(5.3301270189221936,26.5)
8869	766	(5.7631397208144124,15.25)
8870	766	(5.7631397208144124,15.25)
8871	766	(5.7631397208144124,15.25)
8872	806	(5.3301270189221936,16)
8873	806	(5.3301270189221936,16)
8874	1669	(25.681724007856502,31.75)
8875	1669	(25.681724007856502,31.75)
8876	1670	(26.54774941164094,31.75)
8877	1669	(25.681724007856502,31.75)
8878	1277	(32.609927238132009,24.25)
8879	1277	(32.609927238132009,24.25)
8880	1476	(31.310889132455351,28)
8881	1753	(29.145825622994256,33.25)
8882	1715	(30.444863728670914,32.5)
8883	1676	(31.743901834347572,31.75)
8884	1717	(32.176914536239792,32.5)
8885	1718	(33.042939940024233,32.5)
8886	1759	(34.341978045700891,33.25)
8887	1760	(35.208003449485325,33.25)
8888	1680	(35.208003449485325,31.75)
8889	2057	(15.289419162443238,39.25)
8890	2098	(15.722431864335457,40)
8891	2055	(13.55736835487436,39.25)
8892	1934	(12.258330249197702,37)
8893	2315	(30.877876430563134,43.75)
8894	2274	(29.578838324886476,43)
8895	2352	(27.846787517317598,44.5)
8896	819	(16.588457268119896,16)
8897	738	(15.722431864335457,14.5)
8898	737	(14.856406460551018,14.5)
8899	1152	(27.846787517317598,22)
8900	1152	(27.846787517317598,22)
8901	1222	(19.186533479473212,23.5)
8902	1152	(27.846787517317598,22)
8903	1885	(4.897114317029974,36.25)
8904	1885	(4.897114317029974,36.25)
8905	1885	(4.897114317029974,36.25)
8906	336	(13.99038105676658,7)
8907	295	(13.55736835487436,6.25)
8908	254	(12.258330249197702,5.5)
8909	214	(12.691342951089922,4.75)
8910	36	(31.310889132455351,1)
8911	36	(31.310889132455351,1)
8912	37	(32.176914536239792,1)
8913	33	(28.712812921102035,1)
8914	36	(31.310889132455351,1)
8915	919	(33.908965343808667,17.5)
8916	880	(35.208003449485325,16.75)
8917	880	(35.208003449485325,16.75)
8918	398	(33.47595264191645,7.75)
8919	360	(34.774990747593108,7)
8920	2312	(28.279800219209818,43.75)
8921	2154	(30.011851026778693,40.75)
8922	2156	(31.743901834347572,40.75)
8923	2233	(29.145825622994256,42.25)
8924	2156	(31.743901834347572,40.75)
8925	2157	(32.609927238132009,40.75)
8926	2200	(34.774990747593108,41.5)
8927	1240	(34.774990747593108,23.5)
8928	1399	(33.908965343808667,26.5)
8929	1597	(32.609927238132009,30.25)
8930	1600	(35.208003449485325,30.25)
8931	13	(11.392304845413264,1)
8932	2310	(26.54774941164094,43.75)
8933	954	(30.011851026778693,18.25)
8934	954	(30.011851026778693,18.25)
8935	992	(27.846787517317598,19)
8936	1029	(25.681724007856502,19.75)
8937	989	(25.248711305964282,19)
8938	947	(23.949673200287624,18.25)
8939	1960	(34.774990747593108,37)
8940	2196	(31.310889132455351,41.5)
8941	2359	(33.908965343808667,44.5)
8942	2279	(33.908965343808667,43)
8943	2060	(17.887495373796554,39.25)
8944	2060	(17.887495373796554,39.25)
8945	2101	(18.320508075688775,40)
8946	2060	(17.887495373796554,39.25)
8947	1930	(8.794228634059948,37)
8948	2215	(13.55736835487436,42.25)
8949	2255	(13.124355652982141,43)
8950	2060	(17.887495373796554,39.25)
8951	2101	(18.320508075688775,40)
8952	2134	(12.691342951089922,40.75)
8953	2212	(10.959292143521045,42.25)
8954	2212	(10.959292143521045,42.25)
8955	554	(30.011851026778693,10.75)
8956	231	(27.413774815425377,4.75)
8957	391	(27.413774815425377,7.75)
8958	34	(29.578838324886476,1)
8959	391	(27.413774815425377,7.75)
8960	34	(29.578838324886476,1)
8961	391	(27.413774815425377,7.75)
8962	34	(29.578838324886476,1)
8963	34	(29.578838324886476,1)
8964	34	(29.578838324886476,1)
8965	391	(27.413774815425377,7.75)
8966	391	(27.413774815425377,7.75)
8967	1158	(33.042939940024233,22)
8968	1158	(33.042939940024233,22)
8969	1197	(32.609927238132009,22.75)
8970	1197	(32.609927238132009,22.75)
8971	1359	(34.341978045700891,25.75)
8972	879	(34.341978045700891,16.75)
8973	840	(34.774990747593108,16)
8974	840	(34.774990747593108,16)
8975	1480	(34.774990747593108,28)
8976	1647	(6.6291651245988508,31.75)
8977	1687	(6.196152422706632,32.5)
8978	1686	(5.3301270189221936,32.5)
8979	2279	(33.908965343808667,43)
8980	1333	(11.825317547305483,25.75)
8981	1333	(11.825317547305483,25.75)
8982	1132	(10.526279441628825,22)
8983	1801	(1.4330127018922194,34.75)
8984	441	(1.4330127018922194,9.25)
8985	443	(3.1650635094610968,9.25)
8986	442	(2.299038105676658,9.25)
8987	603	(3.1650635094610968,12.25)
8988	603	(3.1650635094610968,12.25)
8989	603	(3.1650635094610968,12.25)
8990	601	(1.4330127018922194,12.25)
8991	1287	(6.196152422706632,25)
8992	1287	(6.196152422706632,25)
8993	1287	(6.196152422706632,25)
8994	563	(2.7320508075688772,11.5)
8995	921	(1.4330127018922194,18.25)
8996	921	(1.4330127018922194,18.25)
8997	2320	(35.208003449485325,43.75)
8998	969	(7.9282032302755088,19)
8999	1748	(24.815698604072061,33.25)
9000	1747	(23.949673200287624,33.25)
9001	1790	(26.114736709748719,34)
9002	1906	(23.083647796503186,36.25)
9003	1905	(22.217622392718749,36.25)
9004	1905	(22.217622392718749,36.25)
9005	1905	(22.217622392718749,36.25)
9006	2111	(26.98076211353316,40)
9007	2111	(26.98076211353316,40)
9008	2072	(28.279800219209818,39.25)
9009	1608	(7.0621778264910704,31)
9010	2072	(28.279800219209818,39.25)
9011	2112	(27.846787517317598,40)
9012	2034	(29.578838324886476,38.5)
9013	2034	(29.578838324886476,38.5)
9014	1610	(8.794228634059948,31)
9015	1608	(7.0621778264910704,31)
9016	1606	(5.3301270189221936,31)
9017	2156	(31.743901834347572,40.75)
9018	1841	(1,35.5)
9019	1841	(1,35.5)
9020	1349	(25.681724007856502,25.75)
9021	1347	(23.949673200287624,25.75)
9022	1308	(24.382685902179844,25)
9023	1351	(27.413774815425377,25.75)
9024	418	(15.722431864335457,8.5)
9025	457	(15.289419162443238,9.25)
9026	659	(16.588457268119896,13)
9027	945	(22.217622392718749,18.25)
9028	911	(26.98076211353316,17.5)
9029	911	(26.98076211353316,17.5)
9030	870	(26.54774941164094,16.75)
9031	1191	(27.413774815425377,22.75)
9032	1152	(27.846787517317598,22)
9033	1140	(17.454482671904334,22)
9034	1140	(17.454482671904334,22)
9035	1182	(19.619546181365433,22.75)
9036	1187	(23.949673200287624,22.75)
9037	1064	(20.918584287042091,20.5)
9038	1062	(19.186533479473212,20.5)
9039	1023	(20.48557158514987,19.75)
9040	1023	(20.48557158514987,19.75)
9041	1098	(16.155444566227676,21.25)
9042	1843	(2.7320508075688772,35.5)
9043	1802	(2.299038105676658,34.75)
9044	1802	(2.299038105676658,34.75)
9045	2286	(5.7631397208144124,43.75)
9046	2347	(23.516660498395403,44.5)
9047	2262	(19.186533479473212,43)
9048	2262	(19.186533479473212,43)
9049	2342	(19.186533479473212,44.5)
9050	2285	(4.897114317029974,43.75)
9051	2302	(19.619546181365433,43.75)
9052	2362	(2.299038105676658,45.25)
9053	2362	(2.299038105676658,45.25)
9054	2299	(17.021469970012117,43.75)
9055	2299	(17.021469970012117,43.75)
9056	1772	(10.526279441628825,34)
9057	2101	(18.320508075688775,40)
9058	1822	(19.619546181365433,34.75)
9059	1822	(19.619546181365433,34.75)
9060	1821	(18.753520777580992,34.75)
9061	1889	(8.3612159321677293,36.25)
9062	1772	(10.526279441628825,34)
9063	1977	(15.289419162443238,37.75)
9064	1769	(7.9282032302755088,34)
9065	1769	(7.9282032302755088,34)
9066	2011	(9.6602540378443873,38.5)
9067	2207	(6.6291651245988508,42.25)
9068	1822	(19.619546181365433,34.75)
9069	1822	(19.619546181365433,34.75)
9070	1740	(17.887495373796554,33.25)
9071	1889	(8.3612159321677293,36.25)
9072	1929	(7.9282032302755088,37)
9073	1779	(16.588457268119896,34)
9074	2060	(17.887495373796554,39.25)
9075	1769	(7.9282032302755088,34)
9076	1807	(6.6291651245988508,34.75)
9077	2213	(11.825317547305483,42.25)
9078	2011	(9.6602540378443873,38.5)
9079	1768	(7.0621778264910704,34)
9080	1977	(15.289419162443238,37.75)
9081	784	(21.351596988934308,15.25)
9082	744	(20.918584287042091,14.5)
9083	744	(20.918584287042091,14.5)
9084	784	(21.351596988934308,15.25)
9085	17	(14.856406460551018,1)
9086	17	(14.856406460551018,1)
9087	784	(21.351596988934308,15.25)
9088	10	(8.794228634059948,1)
9089	17	(14.856406460551018,1)
9090	784	(21.351596988934308,15.25)
9091	1355	(30.877876430563134,25.75)
9092	7	(6.196152422706632,1)
9093	7	(6.196152422706632,1)
9094	7	(6.196152422706632,1)
9095	7	(6.196152422706632,1)
9096	85	(4.4641016151377544,2.5)
9097	165	(4.4641016151377544,4)
9098	281	(1.4330127018922194,6.25)
9099	203	(3.1650635094610968,4.75)
9100	282	(2.299038105676658,6.25)
9101	281	(1.4330127018922194,6.25)
9102	281	(1.4330127018922194,6.25)
9103	201	(1.4330127018922194,4.75)
9104	1	(1,1)
9105	1	(1,1)
9106	1	(1,1)
9107	165	(4.4641016151377544,4)
9108	124	(4.0310889132455356,3.25)
9109	223	(20.48557158514987,4.75)
9110	223	(20.48557158514987,4.75)
9111	1277	(32.609927238132009,24.25)
9112	1476	(31.310889132455351,28)
9113	1753	(29.145825622994256,33.25)
9114	1715	(30.444863728670914,32.5)
9115	1716	(31.310889132455351,32.5)
9116	1757	(32.609927238132009,33.25)
9117	1758	(33.47595264191645,33.25)
9118	1759	(34.341978045700891,33.25)
9119	1760	(35.208003449485325,33.25)
9120	1680	(35.208003449485325,31.75)
9121	1277	(32.609927238132009,24.25)
9122	2159	(34.341978045700891,40.75)
9123	2156	(31.743901834347572,40.75)
9124	2194	(29.578838324886476,41.5)
9125	2153	(29.145825622994256,40.75)
9126	2400	(35.208003449485325,45.25)
9127	2200	(34.774990747593108,41.5)
9128	1869	(25.248711305964282,35.5)
9129	2399	(34.341978045700891,45.25)
9130	2187	(23.516660498395403,41.5)
9131	1240	(34.774990747593108,23.5)
9132	1240	(34.774990747593108,23.5)
9133	1360	(35.208003449485325,25.75)
9134	1440	(35.208003449485325,27.25)
9135	1947	(23.516660498395403,37)
9136	443	(3.1650635094610968,9.25)
9137	1834	(30.011851026778693,34.75)
9138	1160	(34.774990747593108,22)
9139	1160	(34.774990747593108,22)
9140	1160	(34.774990747593108,22)
9141	2317	(32.609927238132009,43.75)
9142	2269	(25.248711305964282,43)
9143	2358	(33.042939940024233,44.5)
9144	1356	(31.743901834347572,25.75)
9145	1399	(33.908965343808667,26.5)
9146	1440	(35.208003449485325,27.25)
9147	1520	(35.208003449485325,28.75)
9148	522	(2.299038105676658,10.75)
9149	601	(1.4330127018922194,12.25)
9150	524	(4.0310889132455356,10.75)
9151	601	(1.4330127018922194,12.25)
9152	1057	(14.856406460551018,20.5)
9153	1829	(25.681724007856502,34.75)
9154	979	(16.588457268119896,19)
9155	980	(17.454482671904334,19)
9156	1057	(14.856406460551018,20.5)
9157	938	(16.155444566227676,18.25)
9158	1019	(17.021469970012117,19.75)
9159	1020	(17.887495373796554,19.75)
9160	1018	(16.155444566227676,19.75)
9161	77	(32.609927238132009,1.75)
9162	1427	(23.949673200287624,27.25)
9163	1427	(23.949673200287624,27.25)
9164	1501	(18.753520777580992,28.75)
9165	1424	(21.351596988934308,27.25)
9166	1504	(21.351596988934308,28.75)
9167	1537	(14.856406460551018,29.5)
9168	1577	(15.289419162443238,30.25)
9169	554	(30.011851026778693,10.75)
9170	632	(28.279800219209818,12.25)
9171	230	(26.54774941164094,4.75)
9172	151	(27.413774815425377,3.25)
9173	113	(28.712812921102035,2.5)
9174	113	(28.712812921102035,2.5)
9175	347	(23.516660498395403,7)
9176	230	(26.54774941164094,4.75)
9177	191	(26.98076211353316,4)
9178	33	(28.712812921102035,1)
9179	33	(28.712812921102035,1)
9180	391	(27.413774815425377,7.75)
9181	1237	(32.176914536239792,23.5)
9182	1197	(32.609927238132009,22.75)
9183	1237	(32.176914536239792,23.5)
9184	1197	(32.609927238132009,22.75)
9185	719	(34.341978045700891,13.75)
9186	600	(34.774990747593108,11.5)
9187	560	(35.208003449485325,10.75)
9188	80	(35.208003449485325,1.75)
9189	39	(33.908965343808667,1)
9190	956	(31.743901834347572,18.25)
9191	596	(31.310889132455351,11.5)
9192	997	(32.176914536239792,19)
9193	555	(30.877876430563134,10.75)
9194	554	(30.011851026778693,10.75)
9195	712	(28.279800219209818,13.75)
9196	712	(28.279800219209818,13.75)
9197	712	(28.279800219209818,13.75)
9198	712	(28.279800219209818,13.75)
9199	676	(31.310889132455351,13)
9200	676	(31.310889132455351,13)
9201	192	(27.846787517317598,4)
9202	73	(29.145825622994256,1.75)
9203	73	(29.145825622994256,1.75)
9204	108	(24.382685902179844,2.5)
9205	38	(33.042939940024233,1)
9206	28	(24.382685902179844,1)
9207	108	(24.382685902179844,2.5)
9208	38	(33.042939940024233,1)
9209	28	(24.382685902179844,1)
9210	1758	(33.47595264191645,33.25)
9211	1759	(34.341978045700891,33.25)
9212	1760	(35.208003449485325,33.25)
9213	1680	(35.208003449485325,31.75)
9214	676	(31.310889132455351,13)
9215	676	(31.310889132455351,13)
9216	676	(31.310889132455351,13)
9217	676	(31.310889132455351,13)
9218	676	(31.310889132455351,13)
9219	676	(31.310889132455351,13)
9220	878	(33.47595264191645,16.75)
9221	879	(34.341978045700891,16.75)
9222	424	(20.918584287042091,8.5)
9223	424	(20.918584287042091,8.5)
9224	461	(18.753520777580992,9.25)
9225	501	(18.320508075688775,10)
9226	461	(18.753520777580992,9.25)
9227	424	(20.918584287042091,8.5)
9228	424	(20.918584287042091,8.5)
9229	461	(18.753520777580992,9.25)
9230	501	(18.320508075688775,10)
9231	461	(18.753520777580992,9.25)
9232	506	(22.650635094610966,10)
9233	506	(22.650635094610966,10)
9234	506	(22.650635094610966,10)
9235	506	(22.650635094610966,10)
9236	506	(22.650635094610966,10)
9237	1460	(17.454482671904334,28)
9238	1501	(18.753520777580992,28.75)
9239	1427	(23.949673200287624,27.25)
9240	1427	(23.949673200287624,27.25)
9241	511	(26.98076211353316,10)
9242	511	(26.98076211353316,10)
9243	511	(26.98076211353316,10)
9244	511	(26.98076211353316,10)
9245	511	(26.98076211353316,10)
9246	712	(28.279800219209818,13.75)
9247	712	(28.279800219209818,13.75)
9248	719	(34.341978045700891,13.75)
9249	719	(34.341978045700891,13.75)
9250	1240	(34.774990747593108,23.5)
9251	1360	(35.208003449485325,25.75)
9252	1440	(35.208003449485325,27.25)
9253	1480	(34.774990747593108,28)
9254	1520	(35.208003449485325,28.75)
9255	1598	(33.47595264191645,30.25)
9256	1416	(14.423393758658799,27.25)
9257	1252	(10.959292143521045,24.25)
9258	1451	(9.6602540378443873,28)
9259	1021	(18.753520777580992,19.75)
9260	1060	(17.454482671904334,20.5)
9261	1342	(19.619546181365433,25.75)
9262	1298	(15.722431864335457,25)
9263	1298	(15.722431864335457,25)
9264	1417	(15.289419162443238,27.25)
9265	1336	(14.423393758658799,25.75)
9266	1297	(14.856406460551018,25)
9267	1379	(16.588457268119896,26.5)
9268	1336	(14.423393758658799,25.75)
9269	1911	(27.413774815425377,36.25)
9270	1954	(29.578838324886476,37)
9271	1647	(6.6291651245988508,31.75)
9272	1954	(29.578838324886476,37)
9273	1647	(6.6291651245988508,31.75)
9274	1690	(8.794228634059948,32.5)
9275	782	(19.619546181365433,15.25)
9276	822	(19.186533479473212,16)
9277	819	(16.588457268119896,16)
9278	821	(18.320508075688775,16)
9279	819	(16.588457268119896,16)
9280	296	(14.423393758658799,6.25)
9281	336	(13.99038105676658,7)
9282	335	(13.124355652982141,7)
9283	336	(13.99038105676658,7)
9284	295	(13.55736835487436,6.25)
9285	256	(13.99038105676658,5.5)
9286	2384	(21.351596988934308,45.25)
9287	2275	(30.444863728670914,43)
9288	2392	(28.279800219209818,45.25)
9289	2237	(32.609927238132009,42.25)
9290	2274	(29.578838324886476,43)
9291	2280	(34.774990747593108,43)
9292	2396	(31.743901834347572,45.25)
9293	2396	(31.743901834347572,45.25)
9294	2098	(15.722431864335457,40)
9295	2016	(13.99038105676658,38.5)
9296	1227	(23.516660498395403,23.5)
9297	1227	(23.516660498395403,23.5)
9298	1033	(29.145825622994256,19.75)
9299	1032	(28.279800219209818,19.75)
9300	1070	(26.114736709748719,20.5)
9301	1028	(24.815698604072061,19.75)
9302	2310	(26.54774941164094,43.75)
9303	2187	(23.516660498395403,41.5)
9304	250	(8.794228634059948,5.5)
9305	249	(7.9282032302755088,5.5)
9306	2186	(22.650635094610966,41.5)
9307	2225	(22.217622392718749,42.25)
9308	2186	(22.650635094610966,41.5)
9309	171	(9.6602540378443873,4)
9310	130	(9.2272413359521668,3.25)
9311	130	(9.2272413359521668,3.25)
9312	1960	(34.774990747593108,37)
9313	2196	(31.310889132455351,41.5)
9314	2359	(33.908965343808667,44.5)
9315	2279	(33.908965343808667,43)
9316	2374	(12.691342951089922,45.25)
9317	2374	(12.691342951089922,45.25)
9318	965	(4.4641016151377544,19)
9319	605	(4.897114317029974,12.25)
9320	645	(4.4641016151377544,13)
9321	1333	(11.825317547305483,25.75)
9322	1333	(11.825317547305483,25.75)
9323	1132	(10.526279441628825,22)
9324	768	(7.49519052838329,15.25)
9325	326	(5.3301270189221936,7)
9326	326	(5.3301270189221936,7)
9327	364	(4.0310889132455356,7.75)
9328	363	(3.1650635094610968,7.75)
9329	993	(28.712812921102035,19)
9330	954	(30.011851026778693,18.25)
9331	954	(30.011851026778693,18.25)
9332	954	(30.011851026778693,18.25)
9333	1116	(31.743901834347572,21.25)
9334	757	(32.176914536239792,14.5)
9335	757	(32.176914536239792,14.5)
9336	757	(32.176914536239792,14.5)
9337	757	(32.176914536239792,14.5)
9338	1117	(32.609927238132009,21.25)
9339	1117	(32.609927238132009,21.25)
9340	2279	(33.908965343808667,43)
9341	2289	(8.3612159321677293,43.75)
9342	2289	(8.3612159321677293,43.75)
9343	1215	(13.124355652982141,23.5)
9344	563	(2.7320508075688772,11.5)
9345	1019	(17.021469970012117,19.75)
9346	1018	(16.155444566227676,19.75)
9347	1670	(26.54774941164094,31.75)
9348	738	(15.722431864335457,14.5)
9349	17	(14.856406460551018,1)
9350	15	(13.124355652982141,1)
9351	18	(15.722431864335457,1)
9352	15	(13.124355652982141,1)
9353	10	(8.794228634059948,1)
9354	784	(21.351596988934308,15.25)
9355	938	(16.155444566227676,18.25)
9356	831	(26.98076211353316,16)
9357	1152	(27.846787517317598,22)
9358	2228	(24.815698604072061,42.25)
9359	1100	(17.887495373796554,21.25)
9360	866	(23.083647796503186,16.75)
9361	1023	(20.48557158514987,19.75)
9362	179	(16.588457268119896,4)
9363	784	(21.351596988934308,15.25)
9364	784	(21.351596988934308,15.25)
9365	17	(14.856406460551018,1)
9366	436	(31.310889132455351,8.5)
9367	1377	(14.856406460551018,26.5)
9368	1920	(35.208003449485325,36.25)
9369	1076	(31.310889132455351,20.5)
9370	1117	(32.609927238132009,21.25)
9371	1076	(31.310889132455351,20.5)
9372	1715	(30.444863728670914,32.5)
9373	1716	(31.310889132455351,32.5)
9374	1757	(32.609927238132009,33.25)
9375	1758	(33.47595264191645,33.25)
9376	1759	(34.341978045700891,33.25)
9377	1760	(35.208003449485325,33.25)
9378	1680	(35.208003449485325,31.75)
9379	223	(20.48557158514987,4.75)
9380	2233	(29.145825622994256,42.25)
9381	2190	(26.114736709748719,41.5)
9382	2279	(33.908965343808667,43)
9383	2279	(33.908965343808667,43)
9384	531	(10.093266739736606,10.75)
9385	1171	(10.093266739736606,22.75)
9386	566	(5.3301270189221936,11.5)
9387	723	(2.7320508075688772,14.5)
9388	763	(3.1650635094610968,15.25)
9389	723	(2.7320508075688772,14.5)
9390	723	(2.7320508075688772,14.5)
9391	682	(2.299038105676658,13.75)
9392	763	(3.1650635094610968,15.25)
9393	1128	(7.0621778264910704,22)
9394	1128	(7.0621778264910704,22)
9395	761	(1.4330127018922194,15.25)
9396	762	(2.299038105676658,15.25)
9397	762	(2.299038105676658,15.25)
9398	1128	(7.0621778264910704,22)
9399	762	(2.299038105676658,15.25)
9400	1041	(1,20.5)
9401	1041	(1,20.5)
9402	1041	(1,20.5)
9403	1041	(1,20.5)
9404	964	(3.598076211353316,19)
9405	964	(3.598076211353316,19)
9406	964	(3.598076211353316,19)
9407	492	(10.526279441628825,10)
9408	494	(12.258330249197702,10)
9409	856	(14.423393758658799,16.75)
9410	921	(1.4330127018922194,18.25)
9411	934	(12.691342951089922,18.25)
9412	933	(11.825317547305483,18.25)
9413	893	(11.392304845413264,17.5)
9414	938	(16.155444566227676,18.25)
9415	936	(14.423393758658799,18.25)
9416	936	(14.423393758658799,18.25)
9417	1054	(12.258330249197702,20.5)
9418	1054	(12.258330249197702,20.5)
9419	938	(16.155444566227676,18.25)
9420	938	(16.155444566227676,18.25)
9421	1054	(12.258330249197702,20.5)
9422	1831	(27.413774815425377,34.75)
9423	1534	(12.258330249197702,29.5)
9424	1534	(12.258330249197702,29.5)
9425	2250	(8.794228634059948,43)
9426	2250	(8.794228634059948,43)
9427	2250	(8.794228634059948,43)
9428	1792	(27.846787517317598,34)
9429	2035	(30.444863728670914,38.5)
9430	2071	(27.413774815425377,39.25)
9431	2184	(20.918584287042091,41.5)
9432	2106	(22.650635094610966,40)
9433	2106	(22.650635094610966,40)
9434	765	(4.897114317029974,15.25)
9435	765	(4.897114317029974,15.25)
9436	845	(4.897114317029974,16.75)
9437	845	(4.897114317029974,16.75)
9438	1441	(1,28)
9439	1611	(9.6602540378443873,31)
9440	1606	(5.3301270189221936,31)
9441	1312	(27.846787517317598,25)
9442	1312	(27.846787517317598,25)
9443	1470	(26.114736709748719,28)
9444	1032	(28.279800219209818,19.75)
9445	1032	(28.279800219209818,19.75)
9446	586	(22.650635094610966,11.5)
9447	586	(22.650635094610966,11.5)
9448	664	(20.918584287042091,13)
9449	662	(19.186533479473212,13)
9450	577	(14.856406460551018,11.5)
9451	1106	(23.083647796503186,21.25)
9452	1104	(21.351596988934308,21.25)
9453	866	(23.083647796503186,16.75)
9454	866	(23.083647796503186,16.75)
9455	1137	(14.856406460551018,22)
9456	2388	(24.815698604072061,45.25)
9457	2388	(24.815698604072061,45.25)
9458	2299	(17.021469970012117,43.75)
9459	2386	(23.083647796503186,45.25)
9460	2262	(19.186533479473212,43)
9461	2301	(18.753520777580992,43.75)
9462	2341	(18.320508075688775,44.5)
9463	2345	(21.784609690826528,44.5)
9464	2302	(19.619546181365433,43.75)
9465	2380	(17.887495373796554,45.25)
9466	2380	(17.887495373796554,45.25)
9467	2380	(17.887495373796554,45.25)
9468	2285	(4.897114317029974,43.75)
9469	2368	(7.49519052838329,45.25)
9470	2368	(7.49519052838329,45.25)
9471	2244	(3.598076211353316,43)
9472	2281	(1.4330127018922194,43.75)
9473	2281	(1.4330127018922194,43.75)
9474	2243	(2.7320508075688772,43)
9475	2241	(1,43)
9476	2241	(1,43)
9477	1776	(13.99038105676658,34)
9478	1942	(19.186533479473212,37)
9479	1900	(17.887495373796554,36.25)
9480	1776	(13.99038105676658,34)
9481	1776	(13.99038105676658,34)
9482	1897	(15.289419162443238,36.25)
9483	1981	(18.753520777580992,37.75)
9484	1776	(13.99038105676658,34)
9485	1897	(15.289419162443238,36.25)
9486	2141	(18.753520777580992,40.75)
9487	1981	(18.753520777580992,37.75)
9488	2053	(11.825317547305483,39.25)
9489	2053	(11.825317547305483,39.25)
9490	1961	(1.4330127018922194,37.75)
9491	1924	(3.598076211353316,37)
9492	2081	(1,40)
9493	1929	(7.9282032302755088,37)
9494	2053	(11.825317547305483,39.25)
9495	1889	(8.3612159321677293,36.25)
9496	1961	(1.4330127018922194,37.75)
9497	1961	(1.4330127018922194,37.75)
9498	1924	(3.598076211353316,37)
9499	1961	(1.4330127018922194,37.75)
9500	2170	(8.794228634059948,41.5)
9501	60	(17.887495373796554,1.75)
9502	18	(15.722431864335457,1)
9503	2121	(1.4330127018922194,40.75)
9504	138	(16.155444566227676,3.25)
9505	10	(8.794228634059948,1)
9506	178	(15.722431864335457,4)
9507	178	(15.722431864335457,4)
9508	178	(15.722431864335457,4)
9509	51	(10.093266739736606,1.75)
9510	242	(1.8660254037844386,5.5)
9511	281	(1.4330127018922194,6.25)
9512	281	(1.4330127018922194,6.25)
9513	7	(6.196152422706632,1)
9514	7	(6.196152422706632,1)
9515	44	(4.0310889132455356,1.75)
9516	85	(4.4641016151377544,2.5)
9517	44	(4.0310889132455356,1.75)
9518	283	(3.1650635094610968,6.25)
9519	201	(1.4330127018922194,4.75)
9520	201	(1.4330127018922194,4.75)
9521	201	(1.4330127018922194,4.75)
9522	2041	(1.4330127018922194,39.25)
9523	2041	(1.4330127018922194,39.25)
9524	2150	(26.54774941164094,40.75)
9525	371	(10.093266739736606,7.75)
9526	2148	(24.815698604072061,40.75)
9527	2225	(22.217622392718749,42.25)
9528	249	(7.9282032302755088,5.5)
9529	250	(8.794228634059948,5.5)
9530	2186	(22.650635094610966,41.5)
9531	2225	(22.217622392718749,42.25)
9532	2320	(35.208003449485325,43.75)
9533	851	(10.093266739736606,16.75)
9534	2063	(20.48557158514987,39.25)
9535	1008	(7.49519052838329,19.75)
9536	1051	(9.6602540378443873,20.5)
9537	1008	(7.49519052838329,19.75)
9538	1041	(1,20.5)
9539	1041	(1,20.5)
9540	1041	(1,20.5)
9541	1834	(30.011851026778693,34.75)
9542	1869	(25.248711305964282,35.5)
9543	1684	(3.598076211353316,32.5)
9544	1685	(4.4641016151377544,32.5)
9545	1764	(3.598076211353316,34)
9546	871	(27.413774815425377,16.75)
9547	1152	(27.846787517317598,22)
9548	1220	(17.454482671904334,23.5)
9549	143	(20.48557158514987,3.25)
9550	814	(12.258330249197702,16)
9551	854	(12.691342951089922,16.75)
9552	892	(10.526279441628825,17.5)
9553	892	(10.526279441628825,17.5)
9554	1476	(31.310889132455351,28)
9555	1753	(29.145825622994256,33.25)
9556	1715	(30.444863728670914,32.5)
9557	1716	(31.310889132455351,32.5)
9558	1757	(32.609927238132009,33.25)
9559	1758	(33.47595264191645,33.25)
9560	1759	(34.341978045700891,33.25)
9561	1760	(35.208003449485325,33.25)
9562	1680	(35.208003449485325,31.75)
9563	2400	(35.208003449485325,45.25)
9564	2200	(34.774990747593108,41.5)
9565	2399	(34.341978045700891,45.25)
9566	1911	(27.413774815425377,36.25)
9567	1869	(25.248711305964282,35.5)
9568	2279	(33.908965343808667,43)
9569	1240	(34.774990747593108,23.5)
9570	1240	(34.774990747593108,23.5)
9571	1240	(34.774990747593108,23.5)
9572	1596	(31.743901834347572,30.25)
9573	1597	(32.609927238132009,30.25)
9574	1600	(35.208003449485325,30.25)
9575	1160	(34.774990747593108,22)
9576	1160	(34.774990747593108,22)
9577	1160	(34.774990747593108,22)
9578	1360	(35.208003449485325,25.75)
9579	2317	(32.609927238132009,43.75)
9580	2269	(25.248711305964282,43)
9581	2358	(33.042939940024233,44.5)
9582	1356	(31.743901834347572,25.75)
9583	835	(30.444863728670914,16)
9584	835	(30.444863728670914,16)
9585	792	(28.279800219209818,15.25)
9586	792	(28.279800219209818,15.25)
9587	425	(21.784609690826528,8.5)
9588	465	(22.217622392718749,9.25)
9589	461	(18.753520777580992,9.25)
9590	461	(18.753520777580992,9.25)
9591	425	(21.784609690826528,8.5)
9592	465	(22.217622392718749,9.25)
9593	461	(18.753520777580992,9.25)
9594	461	(18.753520777580992,9.25)
9595	719	(34.341978045700891,13.75)
9596	719	(34.341978045700891,13.75)
9597	760	(34.774990747593108,14.5)
9598	760	(34.774990747593108,14.5)
9599	632	(28.279800219209818,12.25)
9600	435	(30.444863728670914,8.5)
9601	234	(30.011851026778693,4.75)
9602	234	(30.011851026778693,4.75)
9603	187	(23.516660498395403,4)
9604	187	(23.516660498395403,4)
9605	234	(30.011851026778693,4.75)
9606	234	(30.011851026778693,4.75)
9607	80	(35.208003449485325,1.75)
9608	38	(33.042939940024233,1)
9609	80	(35.208003449485325,1.75)
9610	39	(33.908965343808667,1)
9611	80	(35.208003449485325,1.75)
9612	39	(33.908965343808667,1)
9613	632	(28.279800219209818,12.25)
9614	435	(30.444863728670914,8.5)
9615	435	(30.444863728670914,8.5)
9616	435	(30.444863728670914,8.5)
9617	2154	(30.011851026778693,40.75)
9618	2233	(29.145825622994256,42.25)
9619	266	(22.650635094610966,5.5)
9620	514	(29.578838324886476,10)
9621	186	(22.650635094610966,4)
9622	396	(31.743901834347572,7.75)
9623	398	(33.47595264191645,7.75)
9624	306	(23.083647796503186,6.25)
9625	435	(30.444863728670914,8.5)
9626	234	(30.011851026778693,4.75)
9627	186	(22.650635094610966,4)
9628	26	(22.650635094610966,1)
9629	317	(32.609927238132009,6.25)
9630	357	(32.176914536239792,7)
9631	80	(35.208003449485325,1.75)
9632	599	(33.908965343808667,11.5)
9633	80	(35.208003449485325,1.75)
9634	599	(33.908965343808667,11.5)
9635	80	(35.208003449485325,1.75)
9636	39	(33.908965343808667,1)
9637	716	(31.743901834347572,13.75)
9638	716	(31.743901834347572,13.75)
9639	672	(27.846787517317598,13)
9640	1476	(31.310889132455351,28)
9641	1753	(29.145825622994256,33.25)
9642	1715	(30.444863728670914,32.5)
9643	1716	(31.310889132455351,32.5)
9644	1757	(32.609927238132009,33.25)
9645	1758	(33.47595264191645,33.25)
9646	1759	(34.341978045700891,33.25)
9647	1760	(35.208003449485325,33.25)
9648	1519	(34.341978045700891,28.75)
9649	1844	(3.598076211353316,35.5)
9650	1253	(11.825317547305483,24.25)
9651	1253	(11.825317547305483,24.25)
9652	1253	(11.825317547305483,24.25)
9653	1253	(11.825317547305483,24.25)
9654	1253	(11.825317547305483,24.25)
9655	1214	(12.258330249197702,23.5)
9656	2394	(30.011851026778693,45.25)
9657	2394	(30.011851026778693,45.25)
9658	2352	(27.846787517317598,44.5)
9659	2352	(27.846787517317598,44.5)
9660	1591	(27.413774815425377,30.25)
9661	1591	(27.413774815425377,30.25)
9662	1591	(27.413774815425377,30.25)
9663	1040	(35.208003449485325,19.75)
9664	1040	(35.208003449485325,19.75)
9665	1040	(35.208003449485325,19.75)
9666	1614	(12.258330249197702,31)
9667	613	(11.825317547305483,12.25)
9668	647	(6.196152422706632,13)
9669	1669	(25.681724007856502,31.75)
9670	1669	(25.681724007856502,31.75)
9671	1669	(25.681724007856502,31.75)
9672	1743	(20.48557158514987,33.25)
9673	1743	(20.48557158514987,33.25)
9674	1743	(20.48557158514987,33.25)
9675	1545	(21.784609690826528,29.5)
9676	1584	(21.351596988934308,30.25)
9677	1584	(21.351596988934308,30.25)
9678	1544	(20.918584287042091,29.5)
9679	1352	(28.279800219209818,25.75)
9680	1390	(26.114736709748719,26.5)
9681	1471	(26.98076211353316,28)
9682	1508	(24.815698604072061,28.75)
9683	1508	(24.815698604072061,28.75)
9684	1877	(32.176914536239792,35.5)
9685	763	(3.1650635094610968,15.25)
9686	1779	(16.588457268119896,34)
9687	1779	(16.588457268119896,34)
9688	1885	(4.897114317029974,36.25)
9689	1885	(4.897114317029974,36.25)
9690	2081	(1,40)
9691	1885	(4.897114317029974,36.25)
9692	2041	(1.4330127018922194,39.25)
9693	334	(12.258330249197702,7)
9694	214	(12.691342951089922,4.75)
9695	787	(23.949673200287624,15.25)
9696	1340	(17.887495373796554,25.75)
9697	1538	(15.722431864335457,29.5)
9698	1620	(17.454482671904334,31)
9699	1618	(15.722431864335457,31)
9700	1580	(17.887495373796554,30.25)
9701	2279	(33.908965343808667,43)
9702	2279	(33.908965343808667,43)
9703	1766	(5.3301270189221936,34)
9704	2159	(34.341978045700891,40.75)
9705	2376	(14.423393758658799,45.25)
9706	2376	(14.423393758658799,45.25)
9707	2376	(14.423393758658799,45.25)
9708	2040	(34.774990747593108,38.5)
9709	2156	(31.743901834347572,40.75)
9710	2194	(29.578838324886476,41.5)
9711	1960	(34.774990747593108,37)
9712	2196	(31.310889132455351,41.5)
9713	2359	(33.908965343808667,44.5)
9714	287	(6.6291651245988508,6.25)
9715	365	(4.897114317029974,7.75)
9716	326	(5.3301270189221936,7)
9717	1	(1,1)
9718	1	(1,1)
9719	1	(1,1)
9720	2051	(10.093266739736606,39.25)
9721	2051	(10.093266739736606,39.25)
9722	2050	(9.2272413359521668,39.25)
9723	2050	(9.2272413359521668,39.25)
9724	2090	(8.794228634059948,40)
9725	2279	(33.908965343808667,43)
9726	730	(8.794228634059948,14.5)
9727	531	(10.093266739736606,10.75)
9728	1171	(10.093266739736606,22.75)
9729	1171	(10.093266739736606,22.75)
9730	885	(4.4641016151377544,17.5)
9731	885	(4.4641016151377544,17.5)
9732	566	(5.3301270189221936,11.5)
9733	723	(2.7320508075688772,14.5)
9734	723	(2.7320508075688772,14.5)
9735	723	(2.7320508075688772,14.5)
9736	682	(2.299038105676658,13.75)
9737	763	(3.1650635094610968,15.25)
9738	763	(3.1650635094610968,15.25)
9739	1128	(7.0621778264910704,22)
9740	1128	(7.0621778264910704,22)
9741	1128	(7.0621778264910704,22)
9742	761	(1.4330127018922194,15.25)
9743	761	(1.4330127018922194,15.25)
9744	1241	(1.4330127018922194,24.25)
9745	1241	(1.4330127018922194,24.25)
9746	1241	(1.4330127018922194,24.25)
9747	1241	(1.4330127018922194,24.25)
9748	1041	(1,20.5)
9749	533	(11.825317547305483,10.75)
9750	492	(10.526279441628825,10)
9751	494	(12.258330249197702,10)
9752	856	(14.423393758658799,16.75)
9753	934	(12.691342951089922,18.25)
9754	933	(11.825317547305483,18.25)
9755	893	(11.392304845413264,17.5)
9756	938	(16.155444566227676,18.25)
9757	936	(14.423393758658799,18.25)
9758	936	(14.423393758658799,18.25)
9759	1055	(13.124355652982141,20.5)
9760	1094	(12.691342951089922,21.25)
9761	938	(16.155444566227676,18.25)
9762	1831	(27.413774815425377,34.75)
9763	1534	(12.258330249197702,29.5)
9764	1534	(12.258330249197702,29.5)
9765	2250	(8.794228634059948,43)
9766	1521	(1,29.5)
9767	1825	(22.217622392718749,34.75)
9768	1660	(17.887495373796554,31.75)
9769	2035	(30.444863728670914,38.5)
9770	2071	(27.413774815425377,39.25)
9771	653	(11.392304845413264,13)
9772	1610	(8.794228634059948,31)
9773	2027	(23.516660498395403,38.5)
9774	2026	(22.650635094610966,38.5)
9775	1312	(27.846787517317598,25)
9776	1312	(27.846787517317598,25)
9777	1470	(26.114736709748719,28)
9778	1032	(28.279800219209818,19.75)
9779	1032	(28.279800219209818,19.75)
9780	1068	(24.382685902179844,20.5)
9781	586	(22.650635094610966,11.5)
9782	586	(22.650635094610966,11.5)
9783	664	(20.918584287042091,13)
9784	662	(19.186533479473212,13)
9785	577	(14.856406460551018,11.5)
9786	1106	(23.083647796503186,21.25)
9787	1106	(23.083647796503186,21.25)
9788	866	(23.083647796503186,16.75)
9789	866	(23.083647796503186,16.75)
9790	866	(23.083647796503186,16.75)
9791	1098	(16.155444566227676,21.25)
9792	2347	(23.516660498395403,44.5)
9793	2388	(24.815698604072061,45.25)
9794	2301	(18.753520777580992,43.75)
9795	2342	(19.186533479473212,44.5)
9796	2380	(17.887495373796554,45.25)
9797	2380	(17.887495373796554,45.25)
9798	2380	(17.887495373796554,45.25)
9799	2284	(4.0310889132455356,43.75)
9800	2366	(5.7631397208144124,45.25)
9801	2365	(4.897114317029974,45.25)
9802	2327	(6.196152422706632,44.5)
9803	2368	(7.49519052838329,45.25)
9804	2368	(7.49519052838329,45.25)
9805	2281	(1.4330127018922194,43.75)
9806	2281	(1.4330127018922194,43.75)
9807	1814	(12.691342951089922,34.75)
9808	1776	(13.99038105676658,34)
9809	1942	(19.186533479473212,37)
9810	1855	(13.124355652982141,35.5)
9811	1694	(12.258330249197702,32.5)
9812	1733	(11.825317547305483,33.25)
9813	1776	(13.99038105676658,34)
9814	1980	(17.887495373796554,37.75)
9815	1981	(18.753520777580992,37.75)
9816	1776	(13.99038105676658,34)
9817	1897	(15.289419162443238,36.25)
9818	2141	(18.753520777580992,40.75)
9819	1889	(8.3612159321677293,36.25)
9820	1977	(15.289419162443238,37.75)
9821	1852	(10.526279441628825,35.5)
9822	2053	(11.825317547305483,39.25)
9823	2134	(12.691342951089922,40.75)
9824	2008	(7.0621778264910704,38.5)
9825	2167	(6.196152422706632,41.5)
9826	2092	(10.526279441628825,40)
9827	2174	(12.258330249197702,41.5)
9828	2126	(5.7631397208144124,40.75)
9829	2003	(2.7320508075688772,38.5)
9830	2003	(2.7320508075688772,38.5)
9831	2292	(10.959292143521045,43.75)
9832	2292	(10.959292143521045,43.75)
9833	60	(17.887495373796554,1.75)
9834	138	(16.155444566227676,3.25)
9835	10	(8.794228634059948,1)
9836	178	(15.722431864335457,4)
9837	11	(9.6602540378443873,1)
9838	11	(9.6602540378443873,1)
9839	178	(15.722431864335457,4)
9840	13	(11.392304845413264,1)
9841	7	(6.196152422706632,1)
9842	7	(6.196152422706632,1)
9843	44	(4.0310889132455356,1.75)
9844	85	(4.4641016151377544,2.5)
9845	44	(4.0310889132455356,1.75)
9846	283	(3.1650635094610968,6.25)
9847	85	(4.4641016151377544,2.5)
9848	124	(4.0310889132455356,3.25)
9849	124	(4.0310889132455356,3.25)
9850	161	(1,4)
9851	161	(1,4)
9852	2150	(26.54774941164094,40.75)
9853	371	(10.093266739736606,7.75)
9854	2148	(24.815698604072061,40.75)
9855	2267	(23.516660498395403,43)
9856	249	(7.9282032302755088,5.5)
9857	250	(8.794228634059948,5.5)
9858	2186	(22.650635094610966,41.5)
9859	130	(9.2272413359521668,3.25)
9860	2186	(22.650635094610966,41.5)
9861	2320	(35.208003449485325,43.75)
9862	851	(10.093266739736606,16.75)
9863	1008	(7.49519052838329,19.75)
9864	2063	(20.48557158514987,39.25)
9865	761	(1.4330127018922194,15.25)
9866	851	(10.093266739736606,16.75)
9867	1008	(7.49519052838329,19.75)
9868	1008	(7.49519052838329,19.75)
9869	1245	(4.897114317029974,24.25)
9870	2200	(34.774990747593108,41.5)
9871	1869	(25.248711305964282,35.5)
9872	871	(27.413774815425377,16.75)
9873	1152	(27.846787517317598,22)
9874	1222	(19.186533479473212,23.5)
9875	822	(19.186533479473212,16)
9876	143	(20.48557158514987,3.25)
9877	814	(12.258330249197702,16)
9878	854	(12.691342951089922,16.75)
9879	814	(12.258330249197702,16)
9880	734	(12.258330249197702,14.5)
9881	1476	(31.310889132455351,28)
9882	1753	(29.145825622994256,33.25)
9883	1715	(30.444863728670914,32.5)
9884	1716	(31.310889132455351,32.5)
9885	1757	(32.609927238132009,33.25)
9886	1758	(33.47595264191645,33.25)
9887	1759	(34.341978045700891,33.25)
9888	1760	(35.208003449485325,33.25)
9889	1680	(35.208003449485325,31.75)
9890	2400	(35.208003449485325,45.25)
9891	2200	(34.774990747593108,41.5)
9892	2399	(34.341978045700891,45.25)
9893	1240	(34.774990747593108,23.5)
9894	1240	(34.774990747593108,23.5)
9895	1240	(34.774990747593108,23.5)
9896	1596	(31.743901834347572,30.25)
9897	1597	(32.609927238132009,30.25)
9898	1600	(35.208003449485325,30.25)
9899	1160	(34.774990747593108,22)
9900	1160	(34.774990747593108,22)
9901	1320	(34.774990747593108,25)
9902	1400	(34.774990747593108,26.5)
9903	2317	(32.609927238132009,43.75)
9904	2269	(25.248711305964282,43)
9905	2358	(33.042939940024233,44.5)
9906	1356	(31.743901834347572,25.75)
9907	835	(30.444863728670914,16)
9908	835	(30.444863728670914,16)
9909	792	(28.279800219209818,15.25)
9910	792	(28.279800219209818,15.25)
9911	835	(30.444863728670914,16)
9912	835	(30.444863728670914,16)
9913	792	(28.279800219209818,15.25)
9914	792	(28.279800219209818,15.25)
9915	425	(21.784609690826528,8.5)
9916	465	(22.217622392718749,9.25)
9917	461	(18.753520777580992,9.25)
9918	461	(18.753520777580992,9.25)
9919	1230	(26.114736709748719,23.5)
9920	719	(34.341978045700891,13.75)
9921	719	(34.341978045700891,13.75)
9922	719	(34.341978045700891,13.75)
9923	719	(34.341978045700891,13.75)
9924	1480	(34.774990747593108,28)
9925	720	(35.208003449485325,13.75)
9926	720	(35.208003449485325,13.75)
9927	720	(35.208003449485325,13.75)
9928	720	(35.208003449485325,13.75)
9929	1480	(34.774990747593108,28)
9930	954	(30.011851026778693,18.25)
9931	954	(30.011851026778693,18.25)
9932	1031	(27.413774815425377,19.75)
9933	990	(26.114736709748719,19)
9934	948	(24.815698604072061,18.25)
9935	632	(28.279800219209818,12.25)
9936	435	(30.444863728670914,8.5)
9937	234	(30.011851026778693,4.75)
9938	234	(30.011851026778693,4.75)
9939	234	(30.011851026778693,4.75)
9940	187	(23.516660498395403,4)
9941	187	(23.516660498395403,4)
9942	234	(30.011851026778693,4.75)
9943	234	(30.011851026778693,4.75)
9944	234	(30.011851026778693,4.75)
9945	353	(28.712812921102035,7)
9946	353	(28.712812921102035,7)
9947	353	(28.712812921102035,7)
9948	80	(35.208003449485325,1.75)
9949	38	(33.042939940024233,1)
9950	80	(35.208003449485325,1.75)
9951	39	(33.908965343808667,1)
9952	80	(35.208003449485325,1.75)
9953	39	(33.908965343808667,1)
9954	632	(28.279800219209818,12.25)
9955	268	(24.382685902179844,5.5)
9956	435	(30.444863728670914,8.5)
9957	435	(30.444863728670914,8.5)
9958	760	(34.774990747593108,14.5)
9959	760	(34.774990747593108,14.5)
9960	760	(34.774990747593108,14.5)
9961	760	(34.774990747593108,14.5)
9962	760	(34.774990747593108,14.5)
9963	234	(30.011851026778693,4.75)
9964	64	(21.351596988934308,1.75)
9965	240	(35.208003449485325,4.75)
9966	1508	(24.815698604072061,28.75)
9967	1508	(24.815698604072061,28.75)
9968	1760	(35.208003449485325,33.25)
9969	1680	(35.208003449485325,31.75)
9970	37	(32.176914536239792,1)
9971	26	(22.650635094610966,1)
9972	393	(29.145825622994256,7.75)
9973	393	(29.145825622994256,7.75)
9974	760	(34.774990747593108,14.5)
9975	760	(34.774990747593108,14.5)
9976	64	(21.351596988934308,1.75)
9977	234	(30.011851026778693,4.75)
9978	240	(35.208003449485325,4.75)
9979	1471	(26.98076211353316,28)
9980	1470	(26.114736709748719,28)
9981	1760	(35.208003449485325,33.25)
9982	1680	(35.208003449485325,31.75)
9983	24	(20.918584287042091,1)
9984	353	(28.712812921102035,7)
9985	37	(32.176914536239792,1)
9986	26	(22.650635094610966,1)
9987	393	(29.145825622994256,7.75)
9988	925	(4.897114317029974,18.25)
9989	925	(4.897114317029974,18.25)
9990	762	(2.299038105676658,15.25)
9991	762	(2.299038105676658,15.25)
9992	1891	(10.093266739736606,36.25)
9993	1929	(7.9282032302755088,37)
9994	1937	(14.856406460551018,37)
9995	1811	(10.093266739736606,34.75)
9996	1891	(10.093266739736606,36.25)
9997	2167	(6.196152422706632,41.5)
9998	1961	(1.4330127018922194,37.75)
9999	1924	(3.598076211353316,37)
10000	2212	(10.959292143521045,42.25)
10001	1924	(3.598076211353316,37)
10002	1961	(1.4330127018922194,37.75)
10003	2170	(8.794228634059948,41.5)
10004	2091	(9.6602540378443873,40)
10005	2212	(10.959292143521045,42.25)
10006	2081	(1,40)
10007	2098	(15.722431864335457,40)
10008	2016	(13.99038105676658,38.5)
10009	2016	(13.99038105676658,38.5)
10010	2178	(15.722431864335457,41.5)
10011	2098	(15.722431864335457,40)
10012	1253	(11.825317547305483,24.25)
10013	1253	(11.825317547305483,24.25)
10014	1253	(11.825317547305483,24.25)
10015	1253	(11.825317547305483,24.25)
10016	2394	(30.011851026778693,45.25)
10017	2352	(27.846787517317598,44.5)
10018	2352	(27.846787517317598,44.5)
10019	2392	(28.279800219209818,45.25)
10020	1592	(28.279800219209818,30.25)
10021	1591	(27.413774815425377,30.25)
10022	1591	(27.413774815425377,30.25)
10023	1491	(10.093266739736606,28.75)
10024	1491	(10.093266739736606,28.75)
10025	1491	(10.093266739736606,28.75)
10026	1591	(27.413774815425377,30.25)
10027	1614	(12.258330249197702,31)
10028	613	(11.825317547305483,12.25)
10029	1669	(25.681724007856502,31.75)
10030	1669	(25.681724007856502,31.75)
10031	1743	(20.48557158514987,33.25)
10032	1743	(20.48557158514987,33.25)
10033	1545	(21.784609690826528,29.5)
10034	1584	(21.351596988934308,30.25)
10035	1584	(21.351596988934308,30.25)
10036	1623	(20.05255888325765,31)
10037	1352	(28.279800219209818,25.75)
10038	1390	(26.114736709748719,26.5)
10039	1471	(26.98076211353316,28)
10040	1470	(26.114736709748719,28)
10041	1547	(23.516660498395403,29.5)
10042	1877	(32.176914536239792,35.5)
10043	1645	(4.897114317029974,31.75)
10044	1879	(33.908965343808667,35.5)
10045	1879	(33.908965343808667,35.5)
10046	2037	(32.176914536239792,38.5)
10047	1651	(10.093266739736606,31.75)
10048	1569	(8.3612159321677293,30.25)
10049	1600	(35.208003449485325,30.25)
10050	2233	(29.145825622994256,42.25)
10051	820	(17.454482671904334,16)
10052	819	(16.588457268119896,16)
10053	297	(15.289419162443238,6.25)
10054	296	(14.423393758658799,6.25)
10055	336	(13.99038105676658,7)
10056	256	(13.99038105676658,5.5)
10057	255	(13.124355652982141,5.5)
10058	214	(12.691342951089922,4.75)
10059	13	(11.392304845413264,1)
10060	1241	(1.4330127018922194,24.25)
10061	1241	(1.4330127018922194,24.25)
10062	827	(23.516660498395403,16)
10063	1340	(17.887495373796554,25.75)
10064	1309	(25.248711305964282,25)
10065	1347	(23.949673200287624,25.75)
10066	1538	(15.722431864335457,29.5)
10067	1618	(15.722431864335457,31)
10068	2279	(33.908965343808667,43)
10069	2040	(34.774990747593108,38.5)
10070	2376	(14.423393758658799,45.25)
10071	2376	(14.423393758658799,45.25)
10072	2376	(14.423393758658799,45.25)
10073	2376	(14.423393758658799,45.25)
10074	2040	(34.774990747593108,38.5)
10075	2156	(31.743901834347572,40.75)
10076	2194	(29.578838324886476,41.5)
10077	246	(5.3301270189221936,5.5)
10078	287	(6.6291651245988508,6.25)
10079	326	(5.3301270189221936,7)
10080	326	(5.3301270189221936,7)
10081	1	(1,1)
10082	1	(1,1)
10083	1	(1,1)
10084	1960	(34.774990747593108,37)
10085	2196	(31.310889132455351,41.5)
10086	2359	(33.908965343808667,44.5)
10087	2279	(33.908965343808667,43)
10088	1869	(25.248711305964282,35.5)
10089	441	(1.4330127018922194,9.25)
10090	442	(2.299038105676658,9.25)
10091	1333	(11.825317547305483,25.75)
10092	1333	(11.825317547305483,25.75)
10093	1333	(11.825317547305483,25.75)
10094	1333	(11.825317547305483,25.75)
10095	644	(3.598076211353316,13)
10096	644	(3.598076211353316,13)
10097	1290	(8.794228634059948,25)
10098	1290	(8.794228634059948,25)
10099	1167	(6.6291651245988508,22.75)
10100	1166	(5.7631397208144124,22.75)
10101	1328	(7.49519052838329,25.75)
10102	1329	(8.3612159321677293,25.75)
10103	1287	(6.196152422706632,25)
10104	1287	(6.196152422706632,25)
10105	1287	(6.196152422706632,25)
10106	1287	(6.196152422706632,25)
10107	965	(4.4641016151377544,19)
10108	926	(5.7631397208144124,18.25)
10109	941	(18.753520777580992,18.25)
10110	442	(2.299038105676658,9.25)
10111	442	(2.299038105676658,9.25)
10112	1333	(11.825317547305483,25.75)
10113	1333	(11.825317547305483,25.75)
10114	644	(3.598076211353316,13)
10115	1290	(8.794228634059948,25)
10116	1329	(8.3612159321677293,25.75)
10117	1288	(7.0621778264910704,25)
10118	2118	(33.042939940024233,40)
10119	1608	(7.0621778264910704,31)
10120	1647	(6.6291651245988508,31.75)
10121	1608	(7.0621778264910704,31)
10122	1647	(6.6291651245988508,31.75)
10123	1841	(1,35.5)
10124	1529	(7.9282032302755088,29.5)
10125	1227	(23.516660498395403,23.5)
10126	1225	(21.784609690826528,23.5)
10127	1033	(29.145825622994256,19.75)
10128	1070	(26.114736709748719,20.5)
10129	1033	(29.145825622994256,19.75)
10130	1186	(23.083647796503186,22.75)
10131	986	(22.650635094610966,19)
10132	1062	(19.186533479473212,20.5)
10133	1023	(20.48557158514987,19.75)
10134	546	(23.083647796503186,10.75)
10135	1232	(27.846787517317598,23.5)
10136	1229	(25.248711305964282,23.5)
10137	992	(27.846787517317598,19)
10138	990	(26.114736709748719,19)
10139	948	(24.815698604072061,18.25)
10140	947	(23.949673200287624,18.25)
10141	947	(23.949673200287624,18.25)
10142	945	(22.217622392718749,18.25)
10143	423	(20.05255888325765,8.5)
10144	424	(20.918584287042091,8.5)
10145	425	(21.784609690826528,8.5)
10146	466	(23.083647796503186,9.25)
10147	465	(22.217622392718749,9.25)
10148	460	(17.887495373796554,9.25)
10149	460	(17.887495373796554,9.25)
10150	500	(17.454482671904334,10)
10151	460	(17.887495373796554,9.25)
10152	754	(29.578838324886476,14.5)
10153	794	(30.011851026778693,15.25)
10154	835	(30.444863728670914,16)
10155	795	(30.877876430563134,15.25)
10156	834	(29.578838324886476,16)
10157	832	(27.846787517317598,16)
10158	832	(27.846787517317598,16)
10159	831	(26.98076211353316,16)
10160	832	(27.846787517317598,16)
10161	832	(27.846787517317598,16)
10162	2346	(22.650635094610966,44.5)
10163	2347	(23.516660498395403,44.5)
10164	2345	(21.784609690826528,44.5)
10165	2382	(19.619546181365433,45.25)
10166	2362	(2.299038105676658,45.25)
10167	1937	(14.856406460551018,37)
10168	1768	(7.0621778264910704,34)
10169	1592	(28.279800219209818,30.25)
10170	1633	(28.712812921102035,31)
10171	1633	(28.712812921102035,31)
10172	1592	(28.279800219209818,30.25)
10173	1592	(28.279800219209818,30.25)
10174	1592	(28.279800219209818,30.25)
10175	942	(19.619546181365433,18.25)
10176	1226	(22.650635094610966,23.5)
10177	1298	(15.722431864335457,25)
10178	2200	(34.774990747593108,41.5)
10179	1670	(26.54774941164094,31.75)
10180	1670	(26.54774941164094,31.75)
10181	1669	(25.681724007856502,31.75)
10182	856	(14.423393758658799,16.75)
10183	1537	(14.856406460551018,29.5)
10184	1577	(15.289419162443238,30.25)
10185	1538	(15.722431864335457,29.5)
10186	1538	(15.722431864335457,29.5)
10187	1618	(15.722431864335457,31)
10188	1577	(15.289419162443238,30.25)
10189	1470	(26.114736709748719,28)
10190	1342	(19.619546181365433,25.75)
10191	1353	(29.145825622994256,25.75)
10192	1427	(23.949673200287624,27.25)
10193	1352	(28.279800219209818,25.75)
10194	1390	(26.114736709748719,26.5)
10195	1312	(27.846787517317598,25)
10196	1470	(26.114736709748719,28)
10197	1312	(27.846787517317598,25)
10198	1349	(25.681724007856502,25.75)
10199	1470	(26.114736709748719,28)
10200	1470	(26.114736709748719,28)
10201	1471	(26.98076211353316,28)
10202	1510	(26.54774941164094,28.75)
10203	1430	(26.54774941164094,27.25)
10204	1460	(17.454482671904334,28)
10205	1460	(17.454482671904334,28)
10206	1460	(17.454482671904334,28)
10207	1509	(25.681724007856502,28.75)
10208	88	(7.0621778264910704,2.5)
10209	127	(6.6291651245988508,3.25)
10210	7	(6.196152422706632,1)
10211	88	(7.0621778264910704,2.5)
10212	123	(3.1650635094610968,3.25)
10213	123	(3.1650635094610968,3.25)
10214	123	(3.1650635094610968,3.25)
10215	123	(3.1650635094610968,3.25)
10216	123	(3.1650635094610968,3.25)
10217	124	(4.0310889132455356,3.25)
10218	124	(4.0310889132455356,3.25)
10219	124	(4.0310889132455356,3.25)
10220	163	(2.7320508075688772,4)
10221	163	(2.7320508075688772,4)
10222	81	(1,2.5)
10223	205	(4.897114317029974,4.75)
10224	124	(4.0310889132455356,3.25)
10225	82	(1.8660254037844386,2.5)
10226	82	(1.8660254037844386,2.5)
10227	82	(1.8660254037844386,2.5)
10228	223	(20.48557158514987,4.75)
10229	223	(20.48557158514987,4.75)
10230	222	(19.619546181365433,4.75)
10231	2320	(35.208003449485325,43.75)
10232	1009	(8.3612159321677293,19.75)
10233	1834	(30.011851026778693,34.75)
10234	1834	(30.011851026778693,34.75)
10235	1834	(30.011851026778693,34.75)
10236	2400	(35.208003449485325,45.25)
10237	2399	(34.341978045700891,45.25)
10238	2319	(34.341978045700891,43.75)
10239	2279	(33.908965343808667,43)
10240	2200	(34.774990747593108,41.5)
10241	1355	(30.877876430563134,25.75)
10242	1960	(34.774990747593108,37)
10243	2196	(31.310889132455351,41.5)
10244	2359	(33.908965343808667,44.5)
10245	1160	(34.774990747593108,22)
10246	1160	(34.774990747593108,22)
10247	1160	(34.774990747593108,22)
10248	2317	(32.609927238132009,43.75)
10249	2269	(25.248711305964282,43)
10250	2358	(33.042939940024233,44.5)
10251	1356	(31.743901834347572,25.75)
10252	1342	(19.619546181365433,25.75)
10253	1298	(15.722431864335457,25)
10254	1417	(15.289419162443238,27.25)
10255	1298	(15.722431864335457,25)
10256	1417	(15.289419162443238,27.25)
10257	1417	(15.289419162443238,27.25)
10258	1296	(13.99038105676658,25)
10259	1376	(13.99038105676658,26.5)
10260	1336	(14.423393758658799,25.75)
10261	1256	(14.423393758658799,24.25)
10262	1306	(22.650635094610966,25)
10263	1112	(28.279800219209818,21.25)
10264	911	(26.98076211353316,17.5)
10265	911	(26.98076211353316,17.5)
10266	911	(26.98076211353316,17.5)
10267	1190	(26.54774941164094,22.75)
10268	1140	(17.454482671904334,22)
10269	2394	(30.011851026778693,45.25)
10270	2392	(28.279800219209818,45.25)
10271	2280	(34.774990747593108,43)
10272	1877	(32.176914536239792,35.5)
10273	1917	(32.609927238132009,36.25)
10274	1877	(32.176914536239792,35.5)
10275	1919	(34.341978045700891,36.25)
10276	1953	(28.712812921102035,37)
10277	1920	(35.208003449485325,36.25)
10278	1920	(35.208003449485325,36.25)
10279	1416	(14.423393758658799,27.25)
10280	1610	(8.794228634059948,31)
10281	1647	(6.6291651245988508,31.75)
10282	2194	(29.578838324886476,41.5)
10283	2156	(31.743901834347572,40.75)
10284	2157	(32.609927238132009,40.75)
10285	2080	(35.208003449485325,39.25)
10286	2080	(35.208003449485325,39.25)
10287	2080	(35.208003449485325,39.25)
10288	2156	(31.743901834347572,40.75)
10289	2157	(32.609927238132009,40.75)
10290	1877	(32.176914536239792,35.5)
10291	1917	(32.609927238132009,36.25)
10292	1877	(32.176914536239792,35.5)
10293	1790	(26.114736709748719,34)
10294	1945	(21.784609690826528,37)
10295	676	(31.310889132455351,13)
10296	310	(26.54774941164094,6.25)
10297	596	(31.310889132455351,11.5)
10298	154	(30.011851026778693,3.25)
10299	878	(33.47595264191645,16.75)
10300	879	(34.341978045700891,16.75)
10301	632	(28.279800219209818,12.25)
10302	152	(28.279800219209818,3.25)
10303	878	(33.47595264191645,16.75)
10304	879	(34.341978045700891,16.75)
10305	153	(29.145825622994256,3.25)
10306	153	(29.145825622994256,3.25)
10307	64	(21.351596988934308,1.75)
10308	68	(24.815698604072061,1.75)
10309	70	(26.54774941164094,1.75)
10310	30	(26.114736709748719,1)
10311	30	(26.114736709748719,1)
10312	676	(31.310889132455351,13)
10313	596	(31.310889132455351,11.5)
10314	597	(32.176914536239792,11.5)
10315	226	(23.083647796503186,4.75)
10316	154	(30.011851026778693,3.25)
10317	226	(23.083647796503186,4.75)
10318	154	(30.011851026778693,3.25)
10319	226	(23.083647796503186,4.75)
10320	154	(30.011851026778693,3.25)
10321	226	(23.083647796503186,4.75)
10322	114	(29.578838324886476,2.5)
10323	153	(29.145825622994256,3.25)
10324	1277	(32.609927238132009,24.25)
10325	1277	(32.609927238132009,24.25)
10326	1476	(31.310889132455351,28)
10327	1753	(29.145825622994256,33.25)
10328	1715	(30.444863728670914,32.5)
10329	1676	(31.743901834347572,31.75)
10330	1717	(32.176914536239792,32.5)
10331	1718	(33.042939940024233,32.5)
10332	1759	(34.341978045700891,33.25)
10333	1197	(32.609927238132009,22.75)
10334	1197	(32.609927238132009,22.75)
10335	1158	(33.042939940024233,22)
10336	1158	(33.042939940024233,22)
10337	154	(30.011851026778693,3.25)
10338	155	(30.877876430563134,3.25)
10339	719	(34.341978045700891,13.75)
10340	115	(30.444863728670914,2.5)
10341	155	(30.877876430563134,3.25)
10342	917	(32.176914536239792,17.5)
10343	917	(32.176914536239792,17.5)
10344	676	(31.310889132455351,13)
10345	676	(31.310889132455351,13)
10346	798	(33.47595264191645,15.25)
10347	311	(27.413774815425377,6.25)
10348	155	(30.877876430563134,3.25)
10349	155	(30.877876430563134,3.25)
10350	1240	(34.774990747593108,23.5)
10351	1240	(34.774990747593108,23.5)
10352	1240	(34.774990747593108,23.5)
10353	676	(31.310889132455351,13)
10354	676	(31.310889132455351,13)
10355	757	(32.176914536239792,14.5)
10356	757	(32.176914536239792,14.5)
10357	596	(31.310889132455351,11.5)
10358	225	(22.217622392718749,4.75)
10359	114	(29.578838324886476,2.5)
10360	64	(21.351596988934308,1.75)
10361	145	(22.217622392718749,3.25)
10362	70	(26.54774941164094,1.75)
10363	37	(32.176914536239792,1)
10364	30	(26.114736709748719,1)
10365	426	(22.650635094610966,8.5)
10366	466	(23.083647796503186,9.25)
10367	466	(23.083647796503186,9.25)
10368	466	(23.083647796503186,9.25)
10369	426	(22.650635094610966,8.5)
10370	386	(23.083647796503186,7.75)
10371	555	(30.877876430563134,10.75)
10372	494	(12.258330249197702,10)
10373	158	(33.47595264191645,3.25)
10374	271	(26.98076211353316,5.5)
10375	200	(34.774990747593108,4)
10376	200	(34.774990747593108,4)
10377	240	(35.208003449485325,4.75)
10378	158	(33.47595264191645,3.25)
10379	158	(33.47595264191645,3.25)
10380	37	(32.176914536239792,1)
10381	200	(34.774990747593108,4)
10382	159	(34.341978045700891,3.25)
10383	197	(32.176914536239792,4)
10384	158	(33.47595264191645,3.25)
10385	1080	(34.774990747593108,20.5)
10386	441	(1.4330127018922194,9.25)
10387	442	(2.299038105676658,9.25)
10388	943	(20.48557158514987,18.25)
10389	822	(19.186533479473212,16)
10390	856	(14.423393758658799,16.75)
10391	821	(18.320508075688775,16)
10392	819	(16.588457268119896,16)
10393	2374	(12.691342951089922,45.25)
10394	2374	(12.691342951089922,45.25)
10395	254	(12.258330249197702,5.5)
10396	1	(1,1)
10397	1	(1,1)
10398	1	(1,1)
10399	326	(5.3301270189221936,7)
10400	327	(6.196152422706632,7)
10401	326	(5.3301270189221936,7)
10402	365	(4.897114317029974,7.75)
10403	1	(1,1)
10404	153	(29.145825622994256,3.25)
10405	153	(29.145825622994256,3.25)
10406	70	(26.54774941164094,1.75)
10407	155	(30.877876430563134,3.25)
10408	494	(12.258330249197702,10)
10409	511	(26.98076211353316,10)
10410	114	(29.578838324886476,2.5)
10411	109	(25.248711305964282,2.5)
10412	391	(27.413774815425377,7.75)
10413	549	(25.681724007856502,10.75)
10414	997	(32.176914536239792,19)
10415	262	(19.186533479473212,5.5)
10416	223	(20.48557158514987,4.75)
10417	223	(20.48557158514987,4.75)
10418	223	(20.48557158514987,4.75)
10419	300	(17.887495373796554,6.25)
10420	341	(18.320508075688775,7)
10421	339	(16.588457268119896,7)
10422	339	(16.588457268119896,7)
10423	339	(16.588457268119896,7)
10424	44	(4.0310889132455356,1.75)
10425	83	(2.7320508075688772,2.5)
10426	43	(3.1650635094610968,1.75)
10427	1234	(29.578838324886476,23.5)
10428	2399	(34.341978045700891,45.25)
10429	2399	(34.341978045700891,45.25)
10430	1333	(11.825317547305483,25.75)
10431	1333	(11.825317547305483,25.75)
10432	1333	(11.825317547305483,25.75)
10433	1132	(10.526279441628825,22)
10434	730	(8.794228634059948,14.5)
10435	565	(4.4641016151377544,11.5)
10436	1171	(10.093266739736606,22.75)
10437	441	(1.4330127018922194,9.25)
10438	401	(1,8.5)
10439	603	(3.1650635094610968,12.25)
10440	603	(3.1650635094610968,12.25)
10441	603	(3.1650635094610968,12.25)
10442	681	(1.4330127018922194,13.75)
10443	681	(1.4330127018922194,13.75)
10444	721	(1,14.5)
10445	601	(1.4330127018922194,12.25)
10446	601	(1.4330127018922194,12.25)
10447	1167	(6.6291651245988508,22.75)
10448	1167	(6.6291651245988508,22.75)
10449	1126	(5.3301270189221936,22)
10450	1126	(5.3301270189221936,22)
10451	1287	(6.196152422706632,25)
10452	1287	(6.196152422706632,25)
10453	563	(2.7320508075688772,11.5)
10454	644	(3.598076211353316,13)
10455	1209	(7.9282032302755088,23.5)
10456	601	(1.4330127018922194,12.25)
10457	1249	(8.3612159321677293,24.25)
10458	1084	(4.0310889132455356,21.25)
10459	1057	(14.856406460551018,20.5)
10460	1750	(26.54774941164094,33.25)
10461	941	(18.753520777580992,18.25)
10462	1135	(13.124355652982141,22)
10463	938	(16.155444566227676,18.25)
10464	893	(11.392304845413264,17.5)
10465	2373	(11.825317547305483,45.25)
10466	1786	(22.650635094610966,34)
10467	2029	(25.248711305964282,38.5)
10468	1952	(27.846787517317598,37)
10469	1610	(8.794228634059948,31)
10470	1647	(6.6291651245988508,31.75)
10471	1954	(29.578838324886476,37)
10472	411	(9.6602540378443873,8.5)
10473	2033	(28.712812921102035,38.5)
10474	2034	(29.578838324886476,38.5)
10475	1650	(9.2272413359521668,31.75)
10476	1608	(7.0621778264910704,31)
10477	1647	(6.6291651245988508,31.75)
10478	1277	(32.609927238132009,24.25)
10479	1277	(32.609927238132009,24.25)
10480	1277	(32.609927238132009,24.25)
10481	586	(22.650635094610966,11.5)
10482	586	(22.650635094610966,11.5)
10483	586	(22.650635094610966,11.5)
10484	586	(22.650635094610966,11.5)
10485	665	(21.784609690826528,13)
10486	623	(20.48557158514987,12.25)
10487	624	(21.351596988934308,12.25)
10488	659	(16.588457268119896,13)
10489	945	(22.217622392718749,18.25)
10490	1227	(23.516660498395403,23.5)
10491	1148	(24.382685902179844,22)
10492	1147	(23.516660498395403,22)
10493	1145	(21.784609690826528,22)
10494	1227	(23.516660498395403,23.5)
10495	1065	(21.784609690826528,20.5)
10496	1062	(19.186533479473212,20.5)
10497	1063	(20.05255888325765,20.5)
10498	1023	(20.48557158514987,19.75)
10499	1098	(16.155444566227676,21.25)
10500	905	(21.784609690826528,17.5)
10501	794	(30.011851026778693,15.25)
10502	794	(30.011851026778693,15.25)
10503	834	(29.578838324886476,16)
10504	792	(28.279800219209818,15.25)
10505	831	(26.98076211353316,16)
10506	469	(25.681724007856502,9.25)
10507	511	(26.98076211353316,10)
10508	511	(26.98076211353316,10)
10509	511	(26.98076211353316,10)
10510	437	(32.176914536239792,8.5)
10511	398	(33.47595264191645,7.75)
10512	439	(33.908965343808667,8.5)
10513	511	(26.98076211353316,10)
10514	560	(35.208003449485325,10.75)
10515	158	(33.47595264191645,3.25)
10516	200	(34.774990747593108,4)
10517	80	(35.208003449485325,1.75)
10518	200	(34.774990747593108,4)
10519	200	(34.774990747593108,4)
10520	1476	(31.310889132455351,28)
10521	1753	(29.145825622994256,33.25)
10522	1715	(30.444863728670914,32.5)
10523	1717	(32.176914536239792,32.5)
10524	231	(27.413774815425377,4.75)
10525	231	(27.413774815425377,4.75)
10526	152	(28.279800219209818,3.25)
10527	511	(26.98076211353316,10)
10528	511	(26.98076211353316,10)
10529	554	(30.011851026778693,10.75)
10530	554	(30.011851026778693,10.75)
10531	1378	(15.722431864335457,26.5)
10532	1339	(17.021469970012117,25.75)
10533	1417	(15.289419162443238,27.25)
10534	1297	(14.856406460551018,25)
10535	1216	(13.99038105676658,23.5)
10536	1306	(22.650635094610966,25)
10537	1821	(18.753520777580992,34.75)
10538	1889	(8.3612159321677293,36.25)
10539	1772	(10.526279441628825,34)
10540	1977	(15.289419162443238,37.75)
10541	1769	(7.9282032302755088,34)
10542	2060	(17.887495373796554,39.25)
10543	1769	(7.9282032302755088,34)
10544	1768	(7.0621778264910704,34)
10545	2060	(17.887495373796554,39.25)
10546	2060	(17.887495373796554,39.25)
10547	1963	(3.1650635094610968,37.75)
10548	1807	(6.6291651245988508,34.75)
10549	2053	(11.825317547305483,39.25)
10550	1973	(11.825317547305483,37.75)
10551	1932	(10.526279441628825,37)
10552	2206	(5.7631397208144124,42.25)
10553	1973	(11.825317547305483,37.75)
10554	1973	(11.825317547305483,37.75)
10555	2205	(4.897114317029974,42.25)
10556	2128	(7.49519052838329,40.75)
10557	1893	(11.825317547305483,36.25)
10558	1772	(10.526279441628825,34)
10559	1779	(16.588457268119896,34)
10560	2053	(11.825317547305483,39.25)
10561	1807	(6.6291651245988508,34.75)
10562	1822	(19.619546181365433,34.75)
10563	2094	(12.258330249197702,40)
10564	1981	(18.753520777580992,37.75)
10565	1897	(15.289419162443238,36.25)
10566	1891	(10.093266739736606,36.25)
10567	2053	(11.825317547305483,39.25)
10568	1886	(5.7631397208144124,36.25)
10569	2003	(2.7320508075688772,38.5)
10570	1902	(19.619546181365433,36.25)
10571	1902	(19.619546181365433,36.25)
10572	60	(17.887495373796554,1.75)
10573	94	(12.258330249197702,2.5)
10574	95	(13.124355652982141,2.5)
10575	101	(18.320508075688775,2.5)
10576	101	(18.320508075688775,2.5)
10577	58	(16.155444566227676,1.75)
10578	17	(14.856406460551018,1)
10579	17	(14.856406460551018,1)
10580	17	(14.856406460551018,1)
10581	10	(8.794228634059948,1)
10582	179	(16.588457268119896,4)
10583	141	(18.753520777580992,3.25)
10584	954	(30.011851026778693,18.25)
10585	954	(30.011851026778693,18.25)
10586	993	(28.712812921102035,19)
10587	993	(28.712812921102035,19)
10588	992	(27.846787517317598,19)
10589	990	(26.114736709748719,19)
10590	1031	(27.413774815425377,19.75)
10591	947	(23.949673200287624,18.25)
10592	418	(15.722431864335457,8.5)
10593	418	(15.722431864335457,8.5)
10594	418	(15.722431864335457,8.5)
10595	418	(15.722431864335457,8.5)
10596	457	(15.289419162443238,9.25)
10597	457	(15.289419162443238,9.25)
10598	457	(15.289419162443238,9.25)
10599	1537	(14.856406460551018,29.5)
10600	1620	(17.454482671904334,31)
10601	1460	(17.454482671904334,28)
10602	1501	(18.753520777580992,28.75)
10603	2071	(27.413774815425377,39.25)
10604	2072	(28.279800219209818,39.25)
10605	1841	(1,35.5)
10606	2111	(26.98076211353316,40)
10607	1529	(7.9282032302755088,29.5)
10608	2346	(22.650635094610966,44.5)
10609	2384	(21.351596988934308,45.25)
10610	2345	(21.784609690826528,44.5)
10611	2382	(19.619546181365433,45.25)
10612	2347	(23.516660498395403,44.5)
10613	2262	(19.186533479473212,43)
10614	2262	(19.186533479473212,43)
10615	2302	(19.619546181365433,43.75)
10616	2384	(21.351596988934308,45.25)
10617	2259	(16.588457268119896,43)
10618	2362	(2.299038105676658,45.25)
10619	2362	(2.299038105676658,45.25)
10620	2285	(4.897114317029974,43.75)
10621	2261	(18.320508075688775,43)
10622	2399	(34.341978045700891,45.25)
10623	1355	(30.877876430563134,25.75)
10624	2400	(35.208003449485325,45.25)
10625	2158	(33.47595264191645,40.75)
10626	1869	(25.248711305964282,35.5)
10627	2399	(34.341978045700891,45.25)
10628	2194	(29.578838324886476,41.5)
10629	2237	(32.609927238132009,42.25)
10630	2156	(31.743901834347572,40.75)
10631	2157	(32.609927238132009,40.75)
10632	1960	(34.774990747593108,37)
10633	2118	(33.042939940024233,40)
10634	1877	(32.176914536239792,35.5)
10635	2118	(33.042939940024233,40)
10636	2040	(34.774990747593108,38.5)
10637	1160	(34.774990747593108,22)
10638	1160	(34.774990747593108,22)
10639	1160	(34.774990747593108,22)
10640	1360	(35.208003449485325,25.75)
10641	2317	(32.609927238132009,43.75)
10642	2269	(25.248711305964282,43)
10643	2358	(33.042939940024233,44.5)
10644	1356	(31.743901834347572,25.75)
10645	2186	(22.650635094610966,41.5)
10646	249	(7.9282032302755088,5.5)
10647	249	(7.9282032302755088,5.5)
10648	250	(8.794228634059948,5.5)
10649	2186	(22.650635094610966,41.5)
10650	969	(7.9282032302755088,19)
10651	469	(25.681724007856502,9.25)
10652	170	(8.794228634059948,4)
10653	997	(32.176914536239792,19)
10654	36	(31.310889132455351,1)
10655	554	(30.011851026778693,10.75)
10656	997	(32.176914536239792,19)
10657	511	(26.98076211353316,10)
10658	511	(26.98076211353316,10)
10659	347	(23.516660498395403,7)
10660	511	(26.98076211353316,10)
10661	511	(26.98076211353316,10)
10662	511	(26.98076211353316,10)
10663	347	(23.516660498395403,7)
10664	347	(23.516660498395403,7)
10665	149	(25.681724007856502,3.25)
10666	549	(25.681724007856502,10.75)
10667	560	(35.208003449485325,10.75)
10668	398	(33.47595264191645,7.75)
10669	437	(32.176914536239792,8.5)
10670	398	(33.47595264191645,7.75)
10671	145	(22.217622392718749,3.25)
10672	145	(22.217622392718749,3.25)
10673	398	(33.47595264191645,7.75)
10674	439	(33.908965343808667,8.5)
10675	463	(20.48557158514987,9.25)
10676	462	(19.619546181365433,9.25)
10677	424	(20.918584287042091,8.5)
10678	424	(20.918584287042091,8.5)
10679	464	(21.351596988934308,9.25)
10680	501	(18.320508075688775,10)
10681	501	(18.320508075688775,10)
10682	792	(28.279800219209818,15.25)
10683	1219	(16.588457268119896,23.5)
10684	1219	(16.588457268119896,23.5)
10685	871	(27.413774815425377,16.75)
10686	911	(26.98076211353316,17.5)
10687	911	(26.98076211353316,17.5)
10688	1192	(28.279800219209818,22.75)
10689	1140	(17.454482671904334,22)
10690	1182	(19.619546181365433,22.75)
10691	1240	(34.774990747593108,23.5)
10692	1240	(34.774990747593108,23.5)
10693	1240	(34.774990747593108,23.5)
10694	1360	(35.208003449485325,25.75)
10695	1440	(35.208003449485325,27.25)
10696	1237	(32.176914536239792,23.5)
10697	1197	(32.609927238132009,22.75)
10698	1197	(32.609927238132009,22.75)
10699	1079	(33.908965343808667,20.5)
10700	1040	(35.208003449485325,19.75)
10701	1079	(33.908965343808667,20.5)
10702	439	(33.908965343808667,8.5)
10703	360	(34.774990747593108,7)
10704	792	(28.279800219209818,15.25)
10705	560	(35.208003449485325,10.75)
10706	560	(35.208003449485325,10.75)
10707	1718	(33.042939940024233,32.5)
10708	1680	(35.208003449485325,31.75)
10709	1119	(34.341978045700891,21.25)
10710	1398	(33.042939940024233,26.5)
10711	145	(22.217622392718749,3.25)
10712	145	(22.217622392718749,3.25)
10713	439	(33.908965343808667,8.5)
10714	396	(31.743901834347572,7.75)
10715	396	(31.743901834347572,7.75)
10716	439	(33.908965343808667,8.5)
10717	398	(33.47595264191645,7.75)
10718	360	(34.774990747593108,7)
10719	2388	(24.815698604072061,45.25)
10720	2346	(22.650635094610966,44.5)
10721	2388	(24.815698604072061,45.25)
10722	2346	(22.650635094610966,44.5)
10723	436	(31.310889132455351,8.5)
10724	436	(31.310889132455351,8.5)
10725	543	(20.48557158514987,10.75)
10726	543	(20.48557158514987,10.75)
10727	336	(13.99038105676658,7)
10728	822	(19.186533479473212,16)
10729	782	(19.619546181365433,15.25)
10730	819	(16.588457268119896,16)
10731	2154	(30.011851026778693,40.75)
10732	2112	(27.846787517317598,40)
10733	2233	(29.145825622994256,42.25)
10734	522	(2.299038105676658,10.75)
10735	601	(1.4330127018922194,12.25)
10736	856	(14.423393758658799,16.75)
10737	1416	(14.423393758658799,27.25)
10738	1411	(10.093266739736606,27.25)
10739	1632	(27.846787517317598,31)
10740	1256	(14.423393758658799,24.25)
10741	1415	(13.55736835487436,27.25)
10742	2396	(31.743901834347572,45.25)
10743	2396	(31.743901834347572,45.25)
10744	2396	(31.743901834347572,45.25)
10745	1415	(13.55736835487436,27.25)
10746	1411	(10.093266739736606,27.25)
10747	1291	(9.6602540378443873,25)
10748	1416	(14.423393758658799,27.25)
10749	1451	(9.6602540378443873,28)
10750	1410	(9.2272413359521668,27.25)
10751	1291	(9.6602540378443873,25)
10752	1592	(28.279800219209818,30.25)
10753	2150	(26.54774941164094,40.75)
10754	2150	(26.54774941164094,40.75)
10755	1790	(26.114736709748719,34)
10756	1790	(26.114736709748719,34)
10757	1790	(26.114736709748719,34)
10758	1864	(20.918584287042091,35.5)
10759	453	(11.825317547305483,9.25)
10760	1905	(22.217622392718749,36.25)
10761	2289	(8.3612159321677293,43.75)
10762	1834	(30.011851026778693,34.75)
10763	1872	(27.846787517317598,35.5)
10764	1907	(23.949673200287624,36.25)
10765	1869	(25.248711305964282,35.5)
10766	1312	(27.846787517317598,25)
10767	1312	(27.846787517317598,25)
10768	1470	(26.114736709748719,28)
10769	1312	(27.846787517317598,25)
10770	1312	(27.846787517317598,25)
10771	1312	(27.846787517317598,25)
10772	1350	(26.54774941164094,25.75)
10773	1352	(28.279800219209818,25.75)
10774	1392	(27.846787517317598,26.5)
10775	1432	(28.279800219209818,27.25)
10776	1471	(26.98076211353316,28)
10777	1432	(28.279800219209818,27.25)
10778	1427	(23.949673200287624,27.25)
10779	1216	(13.99038105676658,23.5)
10780	1216	(13.99038105676658,23.5)
10781	2154	(30.011851026778693,40.75)
10782	1957	(32.176914536239792,37)
10783	436	(31.310889132455351,8.5)
10784	262	(19.186533479473212,5.5)
10785	223	(20.48557158514987,4.75)
10786	223	(20.48557158514987,4.75)
10787	301	(18.753520777580992,6.25)
10788	339	(16.588457268119896,7)
10789	339	(16.588457268119896,7)
10790	127	(6.6291651245988508,3.25)
10791	47	(6.6291651245988508,1.75)
10792	7	(6.196152422706632,1)
10793	5	(4.4641016151377544,1)
10794	85	(4.4641016151377544,2.5)
10795	244	(3.598076211353316,5.5)
10796	203	(3.1650635094610968,4.75)
10797	281	(1.4330127018922194,6.25)
10798	327	(6.196152422706632,7)
10799	364	(4.0310889132455356,7.75)
10800	41	(1.4330127018922194,1.75)
10801	247	(6.196152422706632,5.5)
10802	3	(2.7320508075688772,1)
10803	1	(1,1)
10804	1	(1,1)
10805	1	(1,1)
10806	364	(4.0310889132455356,7.75)
10807	601	(1.4330127018922194,12.25)
10808	2098	(15.722431864335457,40)
10809	2098	(15.722431864335457,40)
10810	2394	(30.011851026778693,45.25)
10811	2394	(30.011851026778693,45.25)
10812	2353	(28.712812921102035,44.5)
10813	2392	(28.279800219209818,45.25)
10814	2392	(28.279800219209818,45.25)
10815	2352	(27.846787517317598,44.5)
10816	693	(11.825317547305483,13.75)
10817	2374	(12.691342951089922,45.25)
10818	2374	(12.691342951089922,45.25)
10819	2372	(10.959292143521045,45.25)
10820	2150	(26.54774941164094,40.75)
10821	2310	(26.54774941164094,43.75)
10822	2003	(2.7320508075688772,38.5)
10823	2041	(1.4330127018922194,39.25)
10824	330	(8.794228634059948,7)
10825	369	(8.3612159321677293,7.75)
10826	369	(8.3612159321677293,7.75)
10827	331	(9.6602540378443873,7)
10828	748	(24.382685902179844,14.5)
10829	787	(23.949673200287624,15.25)
10830	2196	(31.310889132455351,41.5)
10831	2359	(33.908965343808667,44.5)
10832	2279	(33.908965343808667,43)
10833	605	(4.897114317029974,12.25)
10834	681	(1.4330127018922194,13.75)
10835	481	(1,10)
10836	563	(2.7320508075688772,11.5)
10837	601	(1.4330127018922194,12.25)
10838	1249	(8.3612159321677293,24.25)
10839	1126	(5.3301270189221936,22)
10840	2279	(33.908965343808667,43)
10841	490	(8.794228634059948,10)
10842	1533	(11.392304845413264,29.5)
10843	490	(8.794228634059948,10)
10844	609	(8.3612159321677293,12.25)
10845	609	(8.3612159321677293,12.25)
10846	1171	(10.093266739736606,22.75)
10847	1171	(10.093266739736606,22.75)
10848	1128	(7.0621778264910704,22)
10849	1128	(7.0621778264910704,22)
10850	1171	(10.093266739736606,22.75)
10851	940	(17.887495373796554,18.25)
10852	894	(12.258330249197702,17.5)
10853	895	(13.124355652982141,17.5)
10854	980	(17.454482671904334,19)
10855	856	(14.423393758658799,16.75)
10856	893	(11.392304845413264,17.5)
10857	1957	(32.176914536239792,37)
10858	2154	(30.011851026778693,40.75)
10859	2320	(35.208003449485325,43.75)
10860	2063	(20.48557158514987,39.25)
10861	1068	(24.382685902179844,20.5)
10862	1066	(22.650635094610966,20.5)
10863	905	(21.784609690826528,17.5)
10864	60	(17.887495373796554,1.75)
10865	60	(17.887495373796554,1.75)
10866	178	(15.722431864335457,4)
10867	139	(17.021469970012117,3.25)
10868	514	(29.578838324886476,10)
10869	514	(29.578838324886476,10)
10870	673	(28.712812921102035,13)
10871	473	(29.145825622994256,9.25)
10872	473	(29.145825622994256,9.25)
10873	110	(26.114736709748719,2.5)
10874	554	(30.011851026778693,10.75)
10875	186	(22.650635094610966,4)
10876	227	(23.949673200287624,4.75)
10877	474	(30.011851026778693,9.25)
10878	555	(30.877876430563134,10.75)
10879	473	(29.145825622994256,9.25)
10880	554	(30.011851026778693,10.75)
10881	473	(29.145825622994256,9.25)
10882	513	(28.712812921102035,10)
10883	70	(26.54774941164094,1.75)
10884	473	(29.145825622994256,9.25)
10885	64	(21.351596988934308,1.75)
10886	70	(26.54774941164094,1.75)
10887	425	(21.784609690826528,8.5)
10888	426	(22.650635094610966,8.5)
10889	461	(18.753520777580992,9.25)
10890	1312	(27.846787517317598,25)
10891	1430	(26.54774941164094,27.25)
10892	1236	(31.310889132455351,23.5)
10893	267	(23.516660498395403,5.5)
10894	429	(25.248711305964282,8.5)
10895	1393	(28.712812921102035,26.5)
10896	1471	(26.98076211353316,28)
10897	555	(30.877876430563134,10.75)
10898	555	(30.877876430563134,10.75)
10899	555	(30.877876430563134,10.75)
10900	2388	(24.815698604072061,45.25)
10901	2347	(23.516660498395403,44.5)
10902	2306	(23.083647796503186,43.75)
10903	2301	(18.753520777580992,43.75)
10904	2341	(18.320508075688775,44.5)
10905	2345	(21.784609690826528,44.5)
10906	2382	(19.619546181365433,45.25)
10907	2285	(4.897114317029974,43.75)
10908	2285	(4.897114317029974,43.75)
10909	2186	(22.650635094610966,41.5)
10910	250	(8.794228634059948,5.5)
10911	249	(7.9282032302755088,5.5)
10912	250	(8.794228634059948,5.5)
10913	2227	(23.949673200287624,42.25)
10914	170	(8.794228634059948,4)
10915	371	(10.093266739736606,7.75)
10916	2150	(26.54774941164094,40.75)
10917	330	(8.794228634059948,7)
10918	330	(8.794228634059948,7)
10919	130	(9.2272413359521668,3.25)
10920	330	(8.794228634059948,7)
10921	369	(8.3612159321677293,7.75)
10922	369	(8.3612159321677293,7.75)
10923	330	(8.794228634059948,7)
10924	330	(8.794228634059948,7)
10925	251	(9.6602540378443873,5.5)
10926	251	(9.6602540378443873,5.5)
10927	251	(9.6602540378443873,5.5)
10928	2035	(30.444863728670914,38.5)
10929	251	(9.6602540378443873,5.5)
10930	2150	(26.54774941164094,40.75)
10931	2150	(26.54774941164094,40.75)
10932	330	(8.794228634059948,7)
10933	2035	(30.444863728670914,38.5)
10934	2071	(27.413774815425377,39.25)
10935	2071	(27.413774815425377,39.25)
10936	1651	(10.093266739736606,31.75)
10937	170	(8.794228634059948,4)
10938	210	(9.2272413359521668,4.75)
10939	289	(8.3612159321677293,6.25)
10940	871	(27.413774815425377,16.75)
10941	1152	(27.846787517317598,22)
10942	2376	(14.423393758658799,45.25)
10943	1831	(27.413774815425377,34.75)
10944	1534	(12.258330249197702,29.5)
10945	1916	(31.743901834347572,36.25)
10946	1955	(30.444863728670914,37)
10947	1917	(32.609927238132009,36.25)
10948	1955	(30.444863728670914,37)
10949	2035	(30.444863728670914,38.5)
10950	411	(9.6602540378443873,8.5)
10951	411	(9.6602540378443873,8.5)
10952	411	(9.6602540378443873,8.5)
10953	2029	(25.248711305964282,38.5)
10954	1490	(9.2272413359521668,28.75)
10955	2029	(25.248711305964282,38.5)
10956	1633	(28.712812921102035,31)
10957	1591	(27.413774815425377,30.25)
10958	1489	(8.3612159321677293,28.75)
10959	1633	(28.712812921102035,31)
10960	1591	(27.413774815425377,30.25)
10961	126	(5.7631397208144124,3.25)
10962	45	(4.897114317029974,1.75)
10963	85	(4.4641016151377544,2.5)
10964	85	(4.4641016151377544,2.5)
10965	85	(4.4641016151377544,2.5)
10966	44	(4.0310889132455356,1.75)
10967	44	(4.0310889132455356,1.75)
10968	1	(1,1)
10969	1	(1,1)
10970	287	(6.6291651245988508,6.25)
10971	327	(6.196152422706632,7)
10972	285	(4.897114317029974,6.25)
10973	954	(30.011851026778693,18.25)
10974	1031	(27.413774815425377,19.75)
10975	948	(24.815698604072061,18.25)
10976	586	(22.650635094610966,11.5)
10977	586	(22.650635094610966,11.5)
10978	665	(21.784609690826528,13)
10979	664	(20.918584287042091,13)
10980	577	(14.856406460551018,11.5)
10981	1393	(28.712812921102035,26.5)
10982	37	(32.176914536239792,1)
10983	555	(30.877876430563134,10.75)
10984	555	(30.877876430563134,10.75)
10985	473	(29.145825622994256,9.25)
10986	473	(29.145825622994256,9.25)
10987	1357	(32.609927238132009,25.75)
10988	1197	(32.609927238132009,22.75)
10989	1197	(32.609927238132009,22.75)
10990	1197	(32.609927238132009,22.75)
10991	1158	(33.042939940024233,22)
10992	186	(22.650635094610966,4)
10993	473	(29.145825622994256,9.25)
10994	64	(21.351596988934308,1.75)
10995	1240	(34.774990747593108,23.5)
10996	1240	(34.774990747593108,23.5)
10997	1240	(34.774990747593108,23.5)
10998	251	(9.6602540378443873,5.5)
10999	2200	(34.774990747593108,41.5)
11000	1869	(25.248711305964282,35.5)
11001	1869	(25.248711305964282,35.5)
11002	2356	(31.310889132455351,44.5)
11003	369	(8.3612159321677293,7.75)
11004	2200	(34.774990747593108,41.5)
11005	1869	(25.248711305964282,35.5)
11006	2399	(34.341978045700891,45.25)
11007	2144	(21.351596988934308,40.75)
11008	2400	(35.208003449485325,45.25)
11009	854	(12.691342951089922,16.75)
11010	814	(12.258330249197702,16)
11011	814	(12.258330249197702,16)
11012	1160	(34.774990747593108,22)
11013	1160	(34.774990747593108,22)
11014	1160	(34.774990747593108,22)
11015	1160	(34.774990747593108,22)
11016	1160	(34.774990747593108,22)
11017	2317	(32.609927238132009,43.75)
11018	2188	(24.382685902179844,41.5)
11019	2358	(33.042939940024233,44.5)
11020	1356	(31.743901834347572,25.75)
11021	1119	(34.341978045700891,21.25)
11022	1277	(32.609927238132009,24.25)
11023	1277	(32.609927238132009,24.25)
11024	1476	(31.310889132455351,28)
11025	1753	(29.145825622994256,33.25)
11026	1715	(30.444863728670914,32.5)
11027	1717	(32.176914536239792,32.5)
11028	1494	(12.691342951089922,28.75)
11029	613	(11.825317547305483,12.25)
11030	1743	(20.48557158514987,33.25)
11031	547	(23.949673200287624,10.75)
11032	147	(23.949673200287624,3.25)
11033	80	(35.208003449485325,1.75)
11034	80	(35.208003449485325,1.75)
11035	78	(33.47595264191645,1.75)
11036	511	(26.98076211353316,10)
11037	511	(26.98076211353316,10)
11038	672	(27.846787517317598,13)
11039	672	(27.846787517317598,13)
11040	672	(27.846787517317598,13)
11041	672	(27.846787517317598,13)
11042	672	(27.846787517317598,13)
11043	2237	(32.609927238132009,42.25)
11044	2392	(28.279800219209818,45.25)
11045	2394	(30.011851026778693,45.25)
11046	2392	(28.279800219209818,45.25)
11047	2392	(28.279800219209818,45.25)
11048	2358	(33.042939940024233,44.5)
11049	2279	(33.908965343808667,43)
11050	2279	(33.908965343808667,43)
11051	1978	(16.155444566227676,37.75)
11052	1822	(19.619546181365433,34.75)
11053	1857	(14.856406460551018,35.5)
11054	1858	(15.722431864335457,35.5)
11055	1935	(13.124355652982141,37)
11056	1932	(10.526279441628825,37)
11057	1891	(10.093266739736606,36.25)
11058	2215	(13.55736835487436,42.25)
11059	2053	(11.825317547305483,39.25)
11060	1928	(7.0621778264910704,37)
11061	2137	(15.289419162443238,40.75)
11062	1898	(16.155444566227676,36.25)
11063	1897	(15.289419162443238,36.25)
11064	1895	(13.55736835487436,36.25)
11065	1925	(4.4641016151377544,37)
11066	2255	(13.124355652982141,43)
11067	1814	(12.691342951089922,34.75)
11068	1814	(12.691342951089922,34.75)
11069	1897	(15.289419162443238,36.25)
11070	2098	(15.722431864335457,40)
11071	1934	(12.258330249197702,37)
11072	1814	(12.691342951089922,34.75)
11073	1854	(12.258330249197702,35.5)
11074	514	(29.578838324886476,10)
11075	554	(30.011851026778693,10.75)
11076	111	(26.98076211353316,2.5)
11077	514	(29.578838324886476,10)
11078	555	(30.877876430563134,10.75)
11079	514	(29.578838324886476,10)
11080	555	(30.877876430563134,10.75)
11081	673	(28.712812921102035,13)
11082	673	(28.712812921102035,13)
11083	113	(28.712812921102035,2.5)
11084	473	(29.145825622994256,9.25)
11085	1275	(30.877876430563134,24.25)
11086	1235	(30.444863728670914,23.5)
11087	676	(31.310889132455351,13)
11088	1035	(30.877876430563134,19.75)
11089	693	(11.825317547305483,13.75)
11090	492	(10.526279441628825,10)
11091	1733	(11.825317547305483,33.25)
11092	262	(19.186533479473212,5.5)
11093	262	(19.186533479473212,5.5)
11094	262	(19.186533479473212,5.5)
11095	301	(18.753520777580992,6.25)
11096	341	(18.320508075688775,7)
11097	341	(18.320508075688775,7)
11098	339	(16.588457268119896,7)
11099	2154	(30.011851026778693,40.75)
11100	2233	(29.145825622994256,42.25)
11101	290	(9.2272413359521668,6.25)
11102	290	(9.2272413359521668,6.25)
11103	290	(9.2272413359521668,6.25)
11104	469	(25.681724007856502,9.25)
11105	469	(25.681724007856502,9.25)
11106	469	(25.681724007856502,9.25)
11107	2356	(31.310889132455351,44.5)
11108	1869	(25.248711305964282,35.5)
11109	1960	(34.774990747593108,37)
11110	2196	(31.310889132455351,41.5)
11111	2359	(33.908965343808667,44.5)
11112	2279	(33.908965343808667,43)
11113	347	(23.516660498395403,7)
11114	347	(23.516660498395403,7)
11115	1119	(34.341978045700891,21.25)
11116	511	(26.98076211353316,10)
11117	511	(26.98076211353316,10)
11118	511	(26.98076211353316,10)
11119	347	(23.516660498395403,7)
11120	632	(28.279800219209818,12.25)
11121	632	(28.279800219209818,12.25)
11122	632	(28.279800219209818,12.25)
11123	632	(28.279800219209818,12.25)
11124	511	(26.98076211353316,10)
11125	514	(29.578838324886476,10)
11126	514	(29.578838324886476,10)
11127	514	(29.578838324886476,10)
11128	676	(31.310889132455351,13)
11129	676	(31.310889132455351,13)
11130	836	(31.310889132455351,16)
11131	835	(30.444863728670914,16)
11132	676	(31.310889132455351,13)
11133	914	(29.578838324886476,17.5)
11134	952	(28.279800219209818,18.25)
11135	554	(30.011851026778693,10.75)
11136	554	(30.011851026778693,10.75)
11137	554	(30.011851026778693,10.75)
11138	596	(31.310889132455351,11.5)
11139	348	(24.382685902179844,7)
11140	347	(23.516660498395403,7)
11141	511	(26.98076211353316,10)
11142	553	(29.145825622994256,10.75)
11143	560	(35.208003449485325,10.75)
11144	1119	(34.341978045700891,21.25)
11145	1715	(30.444863728670914,32.5)
11146	469	(25.681724007856502,9.25)
11147	1277	(32.609927238132009,24.25)
11148	1036	(31.743901834347572,19.75)
11149	1036	(31.743901834347572,19.75)
11150	1036	(31.743901834347572,19.75)
11151	1036	(31.743901834347572,19.75)
11152	631	(27.413774815425377,12.25)
11153	553	(29.145825622994256,10.75)
11154	514	(29.578838324886476,10)
11155	672	(27.846787517317598,13)
11156	715	(30.877876430563134,13.75)
11157	672	(27.846787517317598,13)
11158	1157	(32.176914536239792,22)
11159	511	(26.98076211353316,10)
11160	553	(29.145825622994256,10.75)
11161	554	(30.011851026778693,10.75)
11162	1476	(31.310889132455351,28)
11163	1753	(29.145825622994256,33.25)
11164	1715	(30.444863728670914,32.5)
11165	511	(26.98076211353316,10)
11166	514	(29.578838324886476,10)
11167	1399	(33.908965343808667,26.5)
11168	676	(31.310889132455351,13)
11169	676	(31.310889132455351,13)
11170	631	(27.413774815425377,12.25)
11171	631	(27.413774815425377,12.25)
11172	38	(33.042939940024233,1)
11173	38	(33.042939940024233,1)
11174	2075	(30.877876430563134,39.25)
11175	1996	(31.743901834347572,37.75)
11176	2237	(32.609927238132009,42.25)
11177	2237	(32.609927238132009,42.25)
11178	549	(25.681724007856502,10.75)
11179	516	(31.310889132455351,10)
11180	228	(24.815698604072061,4.75)
11181	186	(22.650635094610966,4)
11182	1384	(20.918584287042091,26.5)
11183	1302	(19.186533479473212,25)
11184	748	(24.382685902179844,14.5)
11185	2158	(33.47595264191645,40.75)
11186	2194	(29.578838324886476,41.5)
11187	2157	(32.609927238132009,40.75)
11188	2071	(27.413774815425377,39.25)
11189	2181	(18.320508075688775,41.5)
11190	2388	(24.815698604072061,45.25)
11191	2279	(33.908965343808667,43)
11192	490	(8.794228634059948,10)
11193	531	(10.093266739736606,10.75)
11194	1132	(10.526279441628825,22)
11195	1324	(4.0310889132455356,25.75)
11196	566	(5.3301270189221936,11.5)
11197	566	(5.3301270189221936,11.5)
11198	682	(2.299038105676658,13.75)
11199	1128	(7.0621778264910704,22)
11200	1128	(7.0621778264910704,22)
11201	1128	(7.0621778264910704,22)
11202	1128	(7.0621778264910704,22)
11203	1363	(2.7320508075688772,26.5)
11204	1363	(2.7320508075688772,26.5)
11205	563	(2.7320508075688772,11.5)
11206	721	(1,14.5)
11207	761	(1.4330127018922194,15.25)
11208	721	(1,14.5)
11209	721	(1,14.5)
11210	761	(1.4330127018922194,15.25)
11211	603	(3.1650635094610968,12.25)
11212	644	(3.598076211353316,13)
11213	644	(3.598076211353316,13)
11214	921	(1.4330127018922194,18.25)
11215	921	(1.4330127018922194,18.25)
11216	921	(1.4330127018922194,18.25)
11217	1084	(4.0310889132455356,21.25)
11218	1084	(4.0310889132455356,21.25)
11219	964	(3.598076211353316,19)
11220	964	(3.598076211353316,19)
11221	964	(3.598076211353316,19)
11222	814	(12.258330249197702,16)
11223	2071	(27.413774815425377,39.25)
11224	2071	(27.413774815425377,39.25)
11225	2070	(26.54774941164094,39.25)
11226	1949	(25.248711305964282,37)
11227	570	(8.794228634059948,11.5)
11228	1955	(30.444863728670914,37)
11229	1877	(32.176914536239792,35.5)
11230	2040	(34.774990747593108,38.5)
11231	1955	(30.444863728670914,37)
11232	2157	(32.609927238132009,40.75)
11233	2156	(31.743901834347572,40.75)
11234	2157	(32.609927238132009,40.75)
11235	2194	(29.578838324886476,41.5)
11236	1306	(22.650635094610966,25)
11237	1306	(22.650635094610966,25)
11238	1306	(22.650635094610966,25)
11239	1298	(15.722431864335457,25)
11240	1298	(15.722431864335457,25)
11241	665	(21.784609690826528,13)
11242	537	(15.289419162443238,10.75)
11243	665	(21.784609690826528,13)
11244	664	(20.918584287042091,13)
11245	662	(19.186533479473212,13)
11246	624	(21.351596988934308,12.25)
11247	577	(14.856406460551018,11.5)
11248	617	(15.289419162443238,12.25)
11249	577	(14.856406460551018,11.5)
11250	1187	(23.949673200287624,22.75)
11251	1147	(23.516660498395403,22)
11252	1106	(23.083647796503186,21.25)
11253	1022	(19.619546181365433,19.75)
11254	1026	(23.083647796503186,19.75)
11255	1026	(23.083647796503186,19.75)
11256	1064	(20.918584287042091,20.5)
11257	866	(23.083647796503186,16.75)
11258	905	(21.784609690826528,17.5)
11259	905	(21.784609690826528,17.5)
11260	36	(31.310889132455351,1)
11261	37	(32.176914536239792,1)
11262	37	(32.176914536239792,1)
11263	37	(32.176914536239792,1)
11264	37	(32.176914536239792,1)
11265	1821	(18.753520777580992,34.75)
11266	1779	(16.588457268119896,34)
11267	2101	(18.320508075688775,40)
11268	1779	(16.588457268119896,34)
11269	1892	(10.959292143521045,36.25)
11270	2060	(17.887495373796554,39.25)
11271	1980	(17.887495373796554,37.75)
11272	1980	(17.887495373796554,37.75)
11273	2021	(18.320508075688775,38.5)
11274	1776	(13.99038105676658,34)
11275	1980	(17.887495373796554,37.75)
11276	2021	(18.320508075688775,38.5)
11277	1899	(17.021469970012117,36.25)
11278	2008	(7.0621778264910704,38.5)
11279	2052	(10.959292143521045,39.25)
11280	2093	(11.392304845413264,40)
11281	1969	(8.3612159321677293,37.75)
11282	1977	(15.289419162443238,37.75)
11283	1891	(10.093266739736606,36.25)
11284	1968	(7.49519052838329,37.75)
11285	2093	(11.392304845413264,40)
11286	2051	(10.093266739736606,39.25)
11287	1968	(7.49519052838329,37.75)
11288	2213	(11.825317547305483,42.25)
11289	2092	(10.526279441628825,40)
11290	1769	(7.9282032302755088,34)
11291	2060	(17.887495373796554,39.25)
11292	2101	(18.320508075688775,40)
11293	1768	(7.0621778264910704,34)
11294	2053	(11.825317547305483,39.25)
11295	1807	(6.6291651245988508,34.75)
11296	2134	(12.691342951089922,40.75)
11297	2214	(12.691342951089922,42.25)
11298	784	(21.351596988934308,15.25)
11299	60	(17.887495373796554,1.75)
11300	138	(16.155444566227676,3.25)
11301	21	(18.320508075688775,1)
11302	15	(13.124355652982141,1)
11303	17	(14.856406460551018,1)
11304	58	(16.155444566227676,1.75)
11305	10	(8.794228634059948,1)
11306	178	(15.722431864335457,4)
11307	179	(16.588457268119896,4)
11308	15	(13.124355652982141,1)
11309	18	(15.722431864335457,1)
11310	2050	(9.2272413359521668,39.25)
11311	2127	(6.6291651245988508,40.75)
11312	2212	(10.959292143521045,42.25)
11313	167	(6.196152422706632,4)
11314	7	(6.196152422706632,1)
11315	45	(4.897114317029974,1.75)
11316	45	(4.897114317029974,1.75)
11317	123	(3.1650635094610968,3.25)
11318	123	(3.1650635094610968,3.25)
11319	123	(3.1650635094610968,3.25)
11320	123	(3.1650635094610968,3.25)
11321	2004	(3.598076211353316,38.5)
11322	1051	(9.6602540378443873,20.5)
11323	928	(7.49519052838329,18.25)
11324	1046	(5.3301270189221936,20.5)
11325	1670	(26.54774941164094,31.75)
11326	1626	(22.650635094610966,31)
11327	1669	(25.681724007856502,31.75)
11328	1669	(25.681724007856502,31.75)
11329	1669	(25.681724007856502,31.75)
11330	1703	(20.05255888325765,32.5)
11331	1315	(30.444863728670914,25)
11332	941	(18.753520777580992,18.25)
11333	1633	(28.712812921102035,31)
11334	1592	(28.279800219209818,30.25)
11335	1591	(27.413774815425377,30.25)
11336	1591	(27.413774815425377,30.25)
11337	1842	(1.8660254037844386,35.5)
11338	1253	(11.825317547305483,24.25)
11339	444	(4.0310889132455356,9.25)
11340	934	(12.691342951089922,18.25)
11341	1054	(12.258330249197702,20.5)
11342	1057	(14.856406460551018,20.5)
11343	1616	(13.99038105676658,31)
11344	1825	(22.217622392718749,34.75)
11345	1656	(14.423393758658799,31.75)
11346	2371	(10.093266739736606,45.25)
11347	1869	(25.248711305964282,35.5)
11348	2400	(35.208003449485325,45.25)
11349	2319	(34.341978045700891,43.75)
11350	2200	(34.774990747593108,41.5)
11351	2399	(34.341978045700891,45.25)
11352	1834	(30.011851026778693,34.75)
11353	1869	(25.248711305964282,35.5)
11354	1872	(27.846787517317598,35.5)
11355	1833	(29.145825622994256,34.75)
11356	1790	(26.114736709748719,34)
11357	1790	(26.114736709748719,34)
11358	1843	(2.7320508075688772,35.5)
11359	1724	(4.0310889132455356,33.25)
11360	1160	(34.774990747593108,22)
11361	1160	(34.774990747593108,22)
11362	1360	(35.208003449485325,25.75)
11363	2317	(32.609927238132009,43.75)
11364	2269	(25.248711305964282,43)
11365	2358	(33.042939940024233,44.5)
11366	1356	(31.743901834347572,25.75)
11367	1240	(34.774990747593108,23.5)
11368	1240	(34.774990747593108,23.5)
11369	1360	(35.208003449485325,25.75)
11370	1440	(35.208003449485325,27.25)
11371	1597	(32.609927238132009,30.25)
11372	1600	(35.208003449485325,30.25)
11373	1359	(34.341978045700891,25.75)
11374	1158	(33.042939940024233,22)
11375	1158	(33.042939940024233,22)
11376	1197	(32.609927238132009,22.75)
11377	1359	(34.341978045700891,25.75)
11378	1197	(32.609927238132009,22.75)
11379	1197	(32.609927238132009,22.75)
11380	1359	(34.341978045700891,25.75)
11381	511	(26.98076211353316,10)
11382	231	(27.413774815425377,4.75)
11383	34	(29.578838324886476,1)
11384	34	(29.578838324886476,1)
11385	74	(30.011851026778693,1.75)
11386	73	(29.145825622994256,1.75)
11387	73	(29.145825622994256,1.75)
11388	34	(29.578838324886476,1)
11389	1355	(30.877876430563134,25.75)
11390	2233	(29.145825622994256,42.25)
11391	423	(20.05255888325765,8.5)
11392	461	(18.753520777580992,9.25)
11393	461	(18.753520777580992,9.25)
11394	461	(18.753520777580992,9.25)
11395	461	(18.753520777580992,9.25)
11396	505	(21.784609690826528,10)
11397	505	(21.784609690826528,10)
11398	586	(22.650635094610966,11.5)
11399	1312	(27.846787517317598,25)
11400	1312	(27.846787517317598,25)
11401	1312	(27.846787517317598,25)
11402	1545	(21.784609690826528,29.5)
11403	1424	(21.351596988934308,27.25)
11404	1462	(19.186533479473212,28)
11405	1502	(19.619546181365433,28.75)
11406	1542	(19.186533479473212,29.5)
11407	145	(22.217622392718749,3.25)
11408	186	(22.650635094610966,4)
11409	186	(22.650635094610966,4)
11410	186	(22.650635094610966,4)
11411	28	(24.382685902179844,1)
11412	145	(22.217622392718749,3.25)
11413	1277	(32.609927238132009,24.25)
11414	1277	(32.609927238132009,24.25)
11415	1476	(31.310889132455351,28)
11416	1753	(29.145825622994256,33.25)
11417	1715	(30.444863728670914,32.5)
11418	1676	(31.743901834347572,31.75)
11419	1717	(32.176914536239792,32.5)
11420	1718	(33.042939940024233,32.5)
11421	1760	(35.208003449485325,33.25)
11422	1680	(35.208003449485325,31.75)
11423	1577	(15.289419162443238,30.25)
11424	1618	(15.722431864335457,31)
11425	1620	(17.454482671904334,31)
11426	1617	(14.856406460551018,31)
11427	1617	(14.856406460551018,31)
11428	2374	(12.691342951089922,45.25)
11429	2376	(14.423393758658799,45.25)
11430	2376	(14.423393758658799,45.25)
11431	2377	(15.289419162443238,45.25)
11432	1152	(27.846787517317598,22)
11433	1191	(27.413774815425377,22.75)
11434	792	(28.279800219209818,15.25)
11435	871	(27.413774815425377,16.75)
11436	871	(27.413774815425377,16.75)
11437	911	(26.98076211353316,17.5)
11438	911	(26.98076211353316,17.5)
11439	1219	(16.588457268119896,23.5)
11440	1140	(17.454482671904334,22)
11441	1182	(19.619546181365433,22.75)
11442	1191	(27.413774815425377,22.75)
11443	2150	(26.54774941164094,40.75)
11444	2279	(33.908965343808667,43)
11445	2240	(35.208003449485325,42.25)
11446	1822	(19.619546181365433,34.75)
11447	1766	(5.3301270189221936,34)
11448	2016	(13.99038105676658,38.5)
11449	2098	(15.722431864335457,40)
11450	2347	(23.516660498395403,44.5)
11451	2181	(18.320508075688775,41.5)
11452	2348	(24.382685902179844,44.5)
11453	2299	(17.021469970012117,43.75)
11454	2260	(17.454482671904334,43)
11455	2346	(22.650635094610966,44.5)
11456	2346	(22.650635094610966,44.5)
11457	2347	(23.516660498395403,44.5)
11458	2342	(19.186533479473212,44.5)
11459	2382	(19.619546181365433,45.25)
11460	2306	(23.083647796503186,43.75)
11461	2382	(19.619546181365433,45.25)
11462	2380	(17.887495373796554,45.25)
11463	2384	(21.351596988934308,45.25)
11464	2345	(21.784609690826528,44.5)
11465	2383	(20.48557158514987,45.25)
11466	2306	(23.083647796503186,43.75)
11467	2383	(20.48557158514987,45.25)
11468	2342	(19.186533479473212,44.5)
11469	2382	(19.619546181365433,45.25)
11470	2282	(2.299038105676658,43.75)
11471	2282	(2.299038105676658,43.75)
11472	1352	(28.279800219209818,25.75)
11473	1352	(28.279800219209818,25.75)
11474	1390	(26.114736709748719,26.5)
11475	1350	(26.54774941164094,25.75)
11476	1427	(23.949673200287624,27.25)
11477	1427	(23.949673200287624,27.25)
11478	1427	(23.949673200287624,27.25)
11479	827	(23.516660498395403,16)
11480	827	(23.516660498395403,16)
11481	788	(24.815698604072061,15.25)
11482	787	(23.949673200287624,15.25)
11483	748	(24.382685902179844,14.5)
11484	145	(22.217622392718749,3.25)
11485	145	(22.217622392718749,3.25)
11486	145	(22.217622392718749,3.25)
11487	186	(22.650635094610966,4)
11488	26	(22.650635094610966,1)
11489	511	(26.98076211353316,10)
11490	231	(27.413774815425377,4.75)
11491	33	(28.712812921102035,1)
11492	33	(28.712812921102035,1)
11493	33	(28.712812921102035,1)
11494	70	(26.54774941164094,1.75)
11495	560	(35.208003449485325,10.75)
11496	560	(35.208003449485325,10.75)
11497	560	(35.208003449485325,10.75)
11498	560	(35.208003449485325,10.75)
11499	1715	(30.444863728670914,32.5)
11500	1758	(33.47595264191645,33.25)
11501	1680	(35.208003449485325,31.75)
11502	512	(27.846787517317598,10)
11503	512	(27.846787517317598,10)
11504	512	(27.846787517317598,10)
11505	152	(28.279800219209818,3.25)
11506	512	(27.846787517317598,10)
11507	113	(28.712812921102035,2.5)
11508	2312	(28.279800219209818,43.75)
11509	2154	(30.011851026778693,40.75)
11510	2156	(31.743901834347572,40.75)
11511	1960	(34.774990747593108,37)
11512	2196	(31.310889132455351,41.5)
11513	2359	(33.908965343808667,44.5)
11514	2279	(33.908965343808667,43)
11515	954	(30.011851026778693,18.25)
11516	992	(27.846787517317598,19)
11517	992	(27.846787517317598,19)
11518	1031	(27.413774815425377,19.75)
11519	1031	(27.413774815425377,19.75)
11520	990	(26.114736709748719,19)
11521	948	(24.815698604072061,18.25)
11522	948	(24.815698604072061,18.25)
11523	946	(23.083647796503186,18.25)
11524	794	(30.011851026778693,15.25)
11525	792	(28.279800219209818,15.25)
11526	792	(28.279800219209818,15.25)
11527	792	(28.279800219209818,15.25)
11528	792	(28.279800219209818,15.25)
11529	874	(30.011851026778693,16.75)
11530	834	(29.578838324886476,16)
11531	223	(20.48557158514987,4.75)
11532	223	(20.48557158514987,4.75)
11533	223	(20.48557158514987,4.75)
11534	300	(17.887495373796554,6.25)
11535	339	(16.588457268119896,7)
11536	339	(16.588457268119896,7)
11537	2279	(33.908965343808667,43)
11538	44	(4.0310889132455356,1.75)
11539	83	(2.7320508075688772,2.5)
11540	339	(16.588457268119896,7)
11541	2050	(9.2272413359521668,39.25)
11542	2050	(9.2272413359521668,39.25)
11543	2011	(9.6602540378443873,38.5)
11544	1968	(7.49519052838329,37.75)
11545	2093	(11.392304845413264,40)
11546	2051	(10.093266739736606,39.25)
11547	2279	(33.908965343808667,43)
11548	441	(1.4330127018922194,9.25)
11549	441	(1.4330127018922194,9.25)
11550	1333	(11.825317547305483,25.75)
11551	1333	(11.825317547305483,25.75)
11552	603	(3.1650635094610968,12.25)
11553	603	(3.1650635094610968,12.25)
11554	644	(3.598076211353316,13)
11555	1370	(8.794228634059948,26.5)
11556	1370	(8.794228634059948,26.5)
11557	1290	(8.794228634059948,25)
11558	1167	(6.6291651245988508,22.75)
11559	1328	(7.49519052838329,25.75)
11560	1287	(6.196152422706632,25)
11561	1205	(4.4641016151377544,23.5)
11562	965	(4.4641016151377544,19)
11563	941	(18.753520777580992,18.25)
11564	442	(2.299038105676658,9.25)
11565	1333	(11.825317547305483,25.75)
11566	1333	(11.825317547305483,25.75)
11567	644	(3.598076211353316,13)
11568	1290	(8.794228634059948,25)
11569	1206	(5.3301270189221936,23.5)
11570	2156	(31.743901834347572,40.75)
11571	2118	(33.042939940024233,40)
11572	2033	(28.712812921102035,38.5)
11573	2033	(28.712812921102035,38.5)
11574	1609	(7.9282032302755088,31)
11575	2111	(26.98076211353316,40)
11576	2071	(27.413774815425377,39.25)
11577	1608	(7.0621778264910704,31)
11578	1647	(6.6291651245988508,31.75)
11579	1186	(23.083647796503186,22.75)
11580	1033	(29.145825622994256,19.75)
11581	1070	(26.114736709748719,20.5)
11582	1033	(29.145825622994256,19.75)
11583	1028	(24.815698604072061,19.75)
11584	1147	(23.516660498395403,22)
11585	986	(22.650635094610966,19)
11586	1062	(19.186533479473212,20.5)
11587	1023	(20.48557158514987,19.75)
11588	1098	(16.155444566227676,21.25)
11589	546	(23.083647796503186,10.75)
11590	1229	(25.248711305964282,23.5)
11591	992	(27.846787517317598,19)
11592	665	(21.784609690826528,13)
11593	990	(26.114736709748719,19)
11594	663	(20.05255888325765,13)
11595	947	(23.949673200287624,18.25)
11596	659	(16.588457268119896,13)
11597	947	(23.949673200287624,18.25)
11598	618	(16.155444566227676,12.25)
11599	945	(22.217622392718749,18.25)
11600	1019	(17.021469970012117,19.75)
11601	423	(20.05255888325765,8.5)
11602	424	(20.918584287042091,8.5)
11603	425	(21.784609690826528,8.5)
11604	465	(22.217622392718749,9.25)
11605	460	(17.887495373796554,9.25)
11606	500	(17.454482671904334,10)
11607	460	(17.887495373796554,9.25)
11608	794	(30.011851026778693,15.25)
11609	794	(30.011851026778693,15.25)
11610	835	(30.444863728670914,16)
11611	834	(29.578838324886476,16)
11612	832	(27.846787517317598,16)
11613	831	(26.98076211353316,16)
11614	832	(27.846787517317598,16)
11615	2347	(23.516660498395403,44.5)
11616	2261	(18.320508075688775,43)
11617	2182	(19.186533479473212,41.5)
11618	2386	(23.083647796503186,45.25)
11619	2264	(20.918584287042091,43)
11620	2342	(19.186533479473212,44.5)
11621	2342	(19.186533479473212,44.5)
11622	2385	(22.217622392718749,45.25)
11623	2380	(17.887495373796554,45.25)
11624	2362	(2.299038105676658,45.25)
11625	2362	(2.299038105676658,45.25)
11626	2286	(5.7631397208144124,43.75)
11627	2327	(6.196152422706632,44.5)
11628	2366	(5.7631397208144124,45.25)
11629	1592	(28.279800219209818,30.25)
11630	1633	(28.712812921102035,31)
11631	1633	(28.712812921102035,31)
11632	1592	(28.279800219209818,30.25)
11633	1591	(27.413774815425377,30.25)
11634	1592	(28.279800219209818,30.25)
11635	942	(19.619546181365433,18.25)
11636	1226	(22.650635094610966,23.5)
11637	1457	(14.856406460551018,28)
11638	2200	(34.774990747593108,41.5)
11639	1670	(26.54774941164094,31.75)
11640	1670	(26.54774941164094,31.75)
11641	1669	(25.681724007856502,31.75)
11642	1708	(24.382685902179844,32.5)
11643	1748	(24.815698604072061,33.25)
11644	856	(14.423393758658799,16.75)
11645	1537	(14.856406460551018,29.5)
11646	1577	(15.289419162443238,30.25)
11647	1618	(15.722431864335457,31)
11648	1577	(15.289419162443238,30.25)
11649	1342	(19.619546181365433,25.75)
11650	1353	(29.145825622994256,25.75)
11651	1427	(23.949673200287624,27.25)
11652	1352	(28.279800219209818,25.75)
11653	1390	(26.114736709748719,26.5)
11654	1470	(26.114736709748719,28)
11655	1350	(26.54774941164094,25.75)
11656	1470	(26.114736709748719,28)
11657	1471	(26.98076211353316,28)
11658	1509	(25.681724007856502,28.75)
11659	1470	(26.114736709748719,28)
11660	1471	(26.98076211353316,28)
11661	1460	(17.454482671904334,28)
11662	1424	(21.351596988934308,27.25)
11663	1464	(20.918584287042091,28)
11664	88	(7.0621778264910704,2.5)
11665	127	(6.6291651245988508,3.25)
11666	7	(6.196152422706632,1)
11667	88	(7.0621778264910704,2.5)
11668	88	(7.0621778264910704,2.5)
11669	88	(7.0621778264910704,2.5)
11670	123	(3.1650635094610968,3.25)
11671	123	(3.1650635094610968,3.25)
11672	123	(3.1650635094610968,3.25)
11673	124	(4.0310889132455356,3.25)
11674	123	(3.1650635094610968,3.25)
11675	123	(3.1650635094610968,3.25)
11676	163	(2.7320508075688772,4)
11677	163	(2.7320508075688772,4)
11678	205	(4.897114317029974,4.75)
11679	124	(4.0310889132455356,3.25)
11680	82	(1.8660254037844386,2.5)
11681	82	(1.8660254037844386,2.5)
11682	82	(1.8660254037844386,2.5)
11683	129	(8.3612159321677293,3.25)
11684	2320	(35.208003449485325,43.75)
11685	1009	(8.3612159321677293,19.75)
11686	1834	(30.011851026778693,34.75)
11687	1834	(30.011851026778693,34.75)
11688	1834	(30.011851026778693,34.75)
11689	2400	(35.208003449485325,45.25)
11690	2399	(34.341978045700891,45.25)
11691	2319	(34.341978045700891,43.75)
11692	2279	(33.908965343808667,43)
11693	2200	(34.774990747593108,41.5)
11694	1355	(30.877876430563134,25.75)
11695	1960	(34.774990747593108,37)
11696	2196	(31.310889132455351,41.5)
11697	2359	(33.908965343808667,44.5)
11698	1160	(34.774990747593108,22)
11699	1160	(34.774990747593108,22)
11700	1160	(34.774990747593108,22)
11701	2317	(32.609927238132009,43.75)
11702	2269	(25.248711305964282,43)
11703	2358	(33.042939940024233,44.5)
11704	1356	(31.743901834347572,25.75)
11705	1302	(19.186533479473212,25)
11706	1298	(15.722431864335457,25)
11707	1417	(15.289419162443238,27.25)
11708	1298	(15.722431864335457,25)
11709	1337	(15.289419162443238,25.75)
11710	1336	(14.423393758658799,25.75)
11711	1336	(14.423393758658799,25.75)
11712	1296	(13.99038105676658,25)
11713	1216	(13.99038105676658,23.5)
11714	1306	(22.650635094610966,25)
11715	1112	(28.279800219209818,21.25)
11716	911	(26.98076211353316,17.5)
11717	911	(26.98076211353316,17.5)
11718	911	(26.98076211353316,17.5)
11719	1191	(27.413774815425377,22.75)
11720	1140	(17.454482671904334,22)
11721	2394	(30.011851026778693,45.25)
11722	2392	(28.279800219209818,45.25)
11723	2392	(28.279800219209818,45.25)
11724	2392	(28.279800219209818,45.25)
11725	2280	(34.774990747593108,43)
11726	2280	(34.774990747593108,43)
11727	1877	(32.176914536239792,35.5)
11728	1917	(32.609927238132009,36.25)
11729	1877	(32.176914536239792,35.5)
11730	1919	(34.341978045700891,36.25)
11731	1953	(28.712812921102035,37)
11732	1610	(8.794228634059948,31)
11733	1647	(6.6291651245988508,31.75)
11734	2194	(29.578838324886476,41.5)
11735	2156	(31.743901834347572,40.75)
11736	2154	(30.011851026778693,40.75)
11737	2157	(32.609927238132009,40.75)
11738	2159	(34.341978045700891,40.75)
11739	2118	(33.042939940024233,40)
11740	2159	(34.341978045700891,40.75)
11741	2156	(31.743901834347572,40.75)
11742	2154	(30.011851026778693,40.75)
11743	1877	(32.176914536239792,35.5)
11744	1917	(32.609927238132009,36.25)
11745	1877	(32.176914536239792,35.5)
11746	1920	(35.208003449485325,36.25)
11747	1412	(10.959292143521045,27.25)
11748	1451	(9.6602540378443873,28)
11749	1451	(9.6602540378443873,28)
11750	1291	(9.6602540378443873,25)
11751	1945	(21.784609690826528,37)
11752	2289	(8.3612159321677293,43.75)
11753	1864	(20.918584287042091,35.5)
11754	1905	(22.217622392718749,36.25)
11755	2289	(8.3612159321677293,43.75)
11756	1952	(27.846787517317598,37)
11757	1036	(31.743901834347572,19.75)
11758	997	(32.176914536239792,19)
11759	838	(33.042939940024233,16)
11760	839	(33.908965343808667,16)
11761	632	(28.279800219209818,12.25)
11762	152	(28.279800219209818,3.25)
11763	879	(34.341978045700891,16.75)
11764	478	(33.47595264191645,9.25)
11765	153	(29.145825622994256,3.25)
11766	64	(21.351596988934308,1.75)
11767	28	(24.382685902179844,1)
11768	70	(26.54774941164094,1.75)
11769	30	(26.114736709748719,1)
11770	1945	(21.784609690826528,37)
11771	1945	(21.784609690826528,37)
11772	1683	(2.7320508075688772,32.5)
11773	676	(31.310889132455351,13)
11774	596	(31.310889132455351,11.5)
11775	597	(32.176914536239792,11.5)
11776	226	(23.083647796503186,4.75)
11777	155	(30.877876430563134,3.25)
11778	226	(23.083647796503186,4.75)
11779	155	(30.877876430563134,3.25)
11780	226	(23.083647796503186,4.75)
11781	155	(30.877876430563134,3.25)
11782	226	(23.083647796503186,4.75)
11783	114	(29.578838324886476,2.5)
11784	153	(29.145825622994256,3.25)
11785	1277	(32.609927238132009,24.25)
11786	1476	(31.310889132455351,28)
11787	1753	(29.145825622994256,33.25)
11788	1715	(30.444863728670914,32.5)
11789	1676	(31.743901834347572,31.75)
11790	1717	(32.176914536239792,32.5)
11791	1718	(33.042939940024233,32.5)
11792	1759	(34.341978045700891,33.25)
11793	1197	(32.609927238132009,22.75)
11794	1158	(33.042939940024233,22)
11795	1197	(32.609927238132009,22.75)
11796	957	(32.609927238132009,18.25)
11797	840	(34.774990747593108,16)
11798	917	(32.176914536239792,17.5)
11799	676	(31.310889132455351,13)
11800	676	(31.310889132455351,13)
11801	638	(33.47595264191645,12.25)
11802	596	(31.310889132455351,11.5)
11803	155	(30.877876430563134,3.25)
11804	1240	(34.774990747593108,23.5)
11805	1240	(34.774990747593108,23.5)
11806	1240	(34.774990747593108,23.5)
11807	676	(31.310889132455351,13)
11808	676	(31.310889132455351,13)
11809	757	(32.176914536239792,14.5)
11810	757	(32.176914536239792,14.5)
11811	596	(31.310889132455351,11.5)
11812	225	(22.217622392718749,4.75)
11813	114	(29.578838324886476,2.5)
11814	64	(21.351596988934308,1.75)
11815	145	(22.217622392718749,3.25)
11816	70	(26.54774941164094,1.75)
11817	37	(32.176914536239792,1)
11818	30	(26.114736709748719,1)
11819	386	(23.083647796503186,7.75)
11820	467	(23.949673200287624,9.25)
11821	426	(22.650635094610966,8.5)
11822	427	(23.516660498395403,8.5)
11823	146	(23.083647796503186,3.25)
11824	146	(23.083647796503186,3.25)
11825	28	(24.382685902179844,1)
11826	28	(24.382685902179844,1)
11827	158	(33.47595264191645,3.25)
11828	271	(26.98076211353316,5.5)
11829	200	(34.774990747593108,4)
11830	200	(34.774990747593108,4)
11831	158	(33.47595264191645,3.25)
11832	158	(33.47595264191645,3.25)
11833	37	(32.176914536239792,1)
11834	200	(34.774990747593108,4)
11835	159	(34.341978045700891,3.25)
11836	197	(32.176914536239792,4)
11837	672	(27.846787517317598,13)
11838	672	(27.846787517317598,13)
11839	152	(28.279800219209818,3.25)
11840	152	(28.279800219209818,3.25)
11841	152	(28.279800219209818,3.25)
11842	113	(28.712812921102035,2.5)
11843	113	(28.712812921102035,2.5)
11844	111	(26.98076211353316,2.5)
11845	34	(29.578838324886476,1)
11846	111	(26.98076211353316,2.5)
11847	262	(19.186533479473212,5.5)
11848	223	(20.48557158514987,4.75)
11849	223	(20.48557158514987,4.75)
11850	223	(20.48557158514987,4.75)
11851	341	(18.320508075688775,7)
11852	300	(17.887495373796554,6.25)
11853	339	(16.588457268119896,7)
11854	339	(16.588457268119896,7)
11855	339	(16.588457268119896,7)
11856	943	(20.48557158514987,18.25)
11857	822	(19.186533479473212,16)
11858	856	(14.423393758658799,16.75)
11859	821	(18.320508075688775,16)
11860	819	(16.588457268119896,16)
11861	254	(12.258330249197702,5.5)
11862	2374	(12.691342951089922,45.25)
11863	2374	(12.691342951089922,45.25)
11864	2376	(14.423393758658799,45.25)
11865	1786	(22.650635094610966,34)
11866	1786	(22.650635094610966,34)
11867	1	(1,1)
11868	1	(1,1)
11869	1	(1,1)
11870	326	(5.3301270189221936,7)
11871	327	(6.196152422706632,7)
11872	326	(5.3301270189221936,7)
11873	365	(4.897114317029974,7.75)
11874	1	(1,1)
11875	1608	(7.0621778264910704,31)
11876	1647	(6.6291651245988508,31.75)
11877	1841	(1,35.5)
11878	1761	(1,34)
11879	1529	(7.9282032302755088,29.5)
11880	1603	(2.7320508075688772,31)
11881	101	(18.320508075688775,2.5)
11882	21	(18.320508075688775,1)
11883	17	(14.856406460551018,1)
11884	17	(14.856406460551018,1)
11885	10	(8.794228634059948,1)
11886	1740	(17.887495373796554,33.25)
11887	2141	(18.753520777580992,40.75)
11888	1769	(7.9282032302755088,34)
11889	1978	(16.155444566227676,37.75)
11890	1977	(15.289419162443238,37.75)
11891	1768	(7.0621778264910704,34)
11892	1977	(15.289419162443238,37.75)
11893	2215	(13.55736835487436,42.25)
11894	1768	(7.0621778264910704,34)
11895	2255	(13.124355652982141,43)
11896	2053	(11.825317547305483,39.25)
11897	2053	(11.825317547305483,39.25)
11898	1807	(6.6291651245988508,34.75)
11899	2255	(13.124355652982141,43)
11900	2016	(13.99038105676658,38.5)
11901	2216	(14.423393758658799,42.25)
11902	442	(2.299038105676658,9.25)
11903	1333	(11.825317547305483,25.75)
11904	603	(3.1650635094610968,12.25)
11905	1370	(8.794228634059948,26.5)
11906	1329	(8.3612159321677293,25.75)
11907	1205	(4.4641016151377544,23.5)
11908	2312	(28.279800219209818,43.75)
11909	2154	(30.011851026778693,40.75)
11910	1398	(33.042939940024233,26.5)
11911	1080	(34.774990747593108,20.5)
11912	1080	(34.774990747593108,20.5)
11913	1040	(35.208003449485325,19.75)
11914	720	(35.208003449485325,13.75)
11915	1398	(33.042939940024233,26.5)
11916	153	(29.145825622994256,3.25)
11917	153	(29.145825622994256,3.25)
11918	70	(26.54774941164094,1.75)
11919	155	(30.877876430563134,3.25)
11920	494	(12.258330249197702,10)
11921	511	(26.98076211353316,10)
11922	114	(29.578838324886476,2.5)
11923	109	(25.248711305964282,2.5)
11924	391	(27.413774815425377,7.75)
11925	549	(25.681724007856502,10.75)
11926	997	(32.176914536239792,19)
11927	70	(26.54774941164094,1.75)
11928	30	(26.114736709748719,1)
11929	234	(30.011851026778693,4.75)
11930	1035	(30.877876430563134,19.75)
11931	490	(8.794228634059948,10)
11932	531	(10.093266739736606,10.75)
11933	1171	(10.093266739736606,22.75)
11934	1487	(6.6291651245988508,28.75)
11935	1602	(1.8660254037844386,31)
11936	1601	(1,31)
11937	490	(8.794228634059948,10)
11938	566	(5.3301270189221936,11.5)
11939	566	(5.3301270189221936,11.5)
11940	1172	(10.959292143521045,22.75)
11941	1172	(10.959292143521045,22.75)
11942	492	(10.526279441628825,10)
11943	682	(2.299038105676658,13.75)
11944	682	(2.299038105676658,13.75)
11945	722	(1.8660254037844386,14.5)
11946	1363	(2.7320508075688772,26.5)
11947	1321	(1.4330127018922194,25.75)
11948	1321	(1.4330127018922194,25.75)
11949	1321	(1.4330127018922194,25.75)
11950	1281	(1,25)
11951	1281	(1,25)
11952	1281	(1,25)
11953	1670	(26.54774941164094,31.75)
11954	1783	(20.05255888325765,34)
11955	1743	(20.48557158514987,33.25)
11956	1703	(20.05255888325765,32.5)
11957	814	(12.258330249197702,16)
11958	895	(13.124355652982141,17.5)
11959	814	(12.258330249197702,16)
11960	934	(12.691342951089922,18.25)
11961	893	(11.392304845413264,17.5)
11962	938	(16.155444566227676,18.25)
11963	936	(14.423393758658799,18.25)
11964	1055	(13.124355652982141,20.5)
11965	1054	(12.258330249197702,20.5)
11966	936	(14.423393758658799,18.25)
11967	938	(16.155444566227676,18.25)
11968	792	(28.279800219209818,15.25)
11969	1620	(17.454482671904334,31)
11970	1574	(12.691342951089922,30.25)
11971	2250	(8.794228634059948,43)
11972	1534	(12.258330249197702,29.5)
11973	1153	(28.712812921102035,22)
11974	2376	(14.423393758658799,45.25)
11975	2376	(14.423393758658799,45.25)
11976	2035	(30.444863728670914,38.5)
11977	613	(11.825317547305483,12.25)
11978	1614	(12.258330249197702,31)
11979	2035	(30.444863728670914,38.5)
11980	2035	(30.444863728670914,38.5)
11981	2035	(30.444863728670914,38.5)
11982	2071	(27.413774815425377,39.25)
11983	1869	(25.248711305964282,35.5)
11984	1988	(24.815698604072061,37.75)
11985	1992	(28.279800219209818,37.75)
11986	1603	(2.7320508075688772,31)
11987	1989	(25.681724007856502,37.75)
11988	1877	(32.176914536239792,35.5)
11989	1113	(29.145825622994256,21.25)
11990	1222	(19.186533479473212,23.5)
11991	2156	(31.743901834347572,40.75)
11992	1390	(26.114736709748719,26.5)
11993	1390	(26.114736709748719,26.5)
11994	1464	(20.918584287042091,28)
11995	1603	(2.7320508075688772,31)
11996	1603	(2.7320508075688772,31)
11997	1350	(26.54774941164094,25.75)
11998	1464	(20.918584287042091,28)
11999	1623	(20.05255888325765,31)
12000	665	(21.784609690826528,13)
12001	586	(22.650635094610966,11.5)
12002	664	(20.918584287042091,13)
12003	662	(19.186533479473212,13)
12004	577	(14.856406460551018,11.5)
12005	577	(14.856406460551018,11.5)
12006	617	(15.289419162443238,12.25)
12007	659	(16.588457268119896,13)
12008	835	(30.444863728670914,16)
12009	875	(30.877876430563134,16.75)
12010	752	(27.846787517317598,14.5)
12011	792	(28.279800219209818,15.25)
12012	791	(27.413774815425377,15.25)
12013	190	(26.114736709748719,4)
12014	187	(23.516660498395403,4)
12015	187	(23.516660498395403,4)
12016	187	(23.516660498395403,4)
12017	33	(28.712812921102035,1)
12018	234	(30.011851026778693,4.75)
12019	68	(24.815698604072061,1.75)
12020	478	(33.47595264191645,9.25)
12021	880	(35.208003449485325,16.75)
12022	920	(34.774990747593108,17.5)
12023	1117	(32.609927238132009,21.25)
12024	840	(34.774990747593108,16)
12025	840	(34.774990747593108,16)
12026	839	(33.908965343808667,16)
12027	1476	(31.310889132455351,28)
12028	1753	(29.145825622994256,33.25)
12029	1715	(30.444863728670914,32.5)
12030	1718	(33.042939940024233,32.5)
12031	1760	(35.208003449485325,33.25)
12032	1680	(35.208003449485325,31.75)
12033	600	(34.774990747593108,11.5)
12034	80	(35.208003449485325,1.75)
12035	117	(32.176914536239792,2.5)
12036	959	(34.341978045700891,18.25)
12037	80	(35.208003449485325,1.75)
12038	38	(33.042939940024233,1)
12039	1942	(19.186533479473212,37)
12040	1858	(15.722431864335457,35.5)
12041	1776	(13.99038105676658,34)
12042	1695	(13.124355652982141,32.5)
12043	1978	(16.155444566227676,37.75)
12044	1978	(16.155444566227676,37.75)
12045	1779	(16.588457268119896,34)
12046	1980	(17.887495373796554,37.75)
12047	1776	(13.99038105676658,34)
12048	1889	(8.3612159321677293,36.25)
12049	1980	(17.887495373796554,37.75)
12050	1854	(12.258330249197702,35.5)
12051	1854	(12.258330249197702,35.5)
12052	1897	(15.289419162443238,36.25)
12053	1968	(7.49519052838329,37.75)
12054	2052	(10.959292143521045,39.25)
12055	2214	(12.691342951089922,42.25)
12056	2004	(3.598076211353316,38.5)
12057	2170	(8.794228634059948,41.5)
12058	2091	(9.6602540378443873,40)
12059	2093	(11.392304845413264,40)
12060	2214	(12.691342951089922,42.25)
12061	1968	(7.49519052838329,37.75)
12062	21	(18.320508075688775,1)
12063	60	(17.887495373796554,1.75)
12064	18	(15.722431864335457,1)
12065	138	(16.155444566227676,3.25)
12066	178	(15.722431864335457,4)
12067	215	(13.55736835487436,4.75)
12068	1	(1,1)
12069	1	(1,1)
12070	7	(6.196152422706632,1)
12071	45	(4.897114317029974,1.75)
12072	45	(4.897114317029974,1.75)
12073	85	(4.4641016151377544,2.5)
12074	85	(4.4641016151377544,2.5)
12075	124	(4.0310889132455356,3.25)
12076	1487	(6.6291651245988508,28.75)
12077	1602	(1.8660254037844386,31)
12078	1601	(1,31)
12079	1989	(25.681724007856502,37.75)
12080	2071	(27.413774815425377,39.25)
12081	947	(23.949673200287624,18.25)
12082	2320	(35.208003449485325,43.75)
12083	1051	(9.6602540378443873,20.5)
12084	1245	(4.897114317029974,24.25)
12085	2063	(20.48557158514987,39.25)
12086	2380	(17.887495373796554,45.25)
12087	2344	(20.918584287042091,44.5)
12088	2388	(24.815698604072061,45.25)
12089	2347	(23.516660498395403,44.5)
12090	2388	(24.815698604072061,45.25)
12091	2388	(24.815698604072061,45.25)
12092	2367	(6.6291651245988508,45.25)
12093	2368	(7.49519052838329,45.25)
12094	2386	(23.083647796503186,45.25)
12095	2386	(23.083647796503186,45.25)
12096	2367	(6.6291651245988508,45.25)
12097	2306	(23.083647796503186,43.75)
12098	2397	(32.609927238132009,45.25)
12099	1240	(34.774990747593108,23.5)
12100	1597	(32.609927238132009,30.25)
12101	1597	(32.609927238132009,30.25)
12102	1356	(31.743901834347572,25.75)
12103	2279	(33.908965343808667,43)
12104	1869	(25.248711305964282,35.5)
12105	2200	(34.774990747593108,41.5)
12106	1911	(27.413774815425377,36.25)
12107	1725	(4.897114317029974,33.25)
12108	1986	(23.083647796503186,37.75)
12109	1724	(4.0310889132455356,33.25)
12110	2040	(34.774990747593108,38.5)
12111	2400	(35.208003449485325,45.25)
12112	2200	(34.774990747593108,41.5)
12113	2399	(34.341978045700891,45.25)
12114	1869	(25.248711305964282,35.5)
12115	2186	(22.650635094610966,41.5)
12116	1160	(34.774990747593108,22)
12117	1160	(34.774990747593108,22)
12118	1160	(34.774990747593108,22)
12119	1360	(35.208003449485325,25.75)
12120	2317	(32.609927238132009,43.75)
12121	2269	(25.248711305964282,43)
12122	2358	(33.042939940024233,44.5)
12123	1356	(31.743901834347572,25.75)
12124	2040	(34.774990747593108,38.5)
12125	2194	(29.578838324886476,41.5)
12126	2039	(33.908965343808667,38.5)
12127	2312	(28.279800219209818,43.75)
12128	2359	(33.908965343808667,44.5)
12129	2279	(33.908965343808667,43)
12130	2286	(5.7631397208144124,43.75)
12131	2286	(5.7631397208144124,43.75)
12132	2365	(4.897114317029974,45.25)
12133	1644	(4.0310889132455356,31.75)
12134	1644	(4.0310889132455356,31.75)
12135	1644	(4.0310889132455356,31.75)
12136	1565	(4.897114317029974,30.25)
12137	1565	(4.897114317029974,30.25)
12138	1565	(4.897114317029974,30.25)
12139	1108	(24.815698604072061,21.25)
12140	1106	(23.083647796503186,21.25)
12141	1104	(21.351596988934308,21.25)
12142	866	(23.083647796503186,16.75)
12143	866	(23.083647796503186,16.75)
12144	2233	(29.145825622994256,42.25)
12145	1407	(6.6291651245988508,27.25)
12146	1367	(6.196152422706632,26.5)
12147	1374	(12.258330249197702,26.5)
12148	1253	(11.825317547305483,24.25)
12149	1253	(11.825317547305483,24.25)
12150	1493	(11.825317547305483,28.75)
12151	1615	(13.124355652982141,31)
12152	1955	(30.444863728670914,37)
12153	485	(4.4641016151377544,10)
12154	1494	(12.691342951089922,28.75)
12155	423	(20.05255888325765,8.5)
12156	423	(20.05255888325765,8.5)
12157	1298	(15.722431864335457,25)
12158	1298	(15.722431864335457,25)
12159	632	(28.279800219209818,12.25)
12160	718	(33.47595264191645,13.75)
12161	1032	(28.279800219209818,19.75)
12162	1068	(24.382685902179844,20.5)
12163	1026	(23.083647796503186,19.75)
12164	514	(29.578838324886476,10)
12165	308	(24.815698604072061,6.25)
12166	463	(20.48557158514987,9.25)
12167	665	(21.784609690826528,13)
12168	423	(20.05255888325765,8.5)
12169	639	(34.341978045700891,12.25)
12170	2197	(32.176914536239792,41.5)
12171	2039	(33.908965343808667,38.5)
12172	1960	(34.774990747593108,37)
12173	1197	(32.609927238132009,22.75)
12174	7	(6.196152422706632,1)
12175	87	(6.196152422706632,2.5)
12176	1240	(34.774990747593108,23.5)
12177	2237	(32.609927238132009,42.25)
12178	2394	(30.011851026778693,45.25)
12179	2352	(27.846787517317598,44.5)
12180	2392	(28.279800219209818,45.25)
12181	956	(31.743901834347572,18.25)
12182	1652	(10.959292143521045,31.75)
12183	230	(26.54774941164094,4.75)
12184	919	(33.908965343808667,17.5)
12185	308	(24.815698604072061,6.25)
12186	37	(32.176914536239792,1)
12187	200	(34.774990747593108,4)
12188	1080	(34.774990747593108,20.5)
12189	878	(33.47595264191645,16.75)
12190	38	(33.042939940024233,1)
12191	1715	(30.444863728670914,32.5)
12192	751	(26.98076211353316,14.5)
12193	1274	(30.011851026778693,24.25)
12194	230	(26.54774941164094,4.75)
12195	919	(33.908965343808667,17.5)
12196	308	(24.815698604072061,6.25)
12197	37	(32.176914536239792,1)
12198	200	(34.774990747593108,4)
12199	878	(33.47595264191645,16.75)
12200	37	(32.176914536239792,1)
12201	77	(32.609927238132009,1.75)
12202	77	(32.609927238132009,1.75)
12203	77	(32.609927238132009,1.75)
12204	832	(27.846787517317598,16)
12205	752	(27.846787517317598,14.5)
12206	37	(32.176914536239792,1)
12207	26	(22.650635094610966,1)
12208	956	(31.743901834347572,18.25)
12209	956	(31.743901834347572,18.25)
12210	1080	(34.774990747593108,20.5)
12211	1390	(26.114736709748719,26.5)
12212	1350	(26.54774941164094,25.75)
12213	1464	(20.918584287042091,28)
12214	1623	(20.05255888325765,31)
12215	110	(26.114736709748719,2.5)
12216	1715	(30.444863728670914,32.5)
12217	1717	(32.176914536239792,32.5)
12218	1715	(30.444863728670914,32.5)
12219	38	(33.042939940024233,1)
12220	39	(33.908965343808667,1)
12221	960	(35.208003449485325,18.25)
12222	622	(19.619546181365433,12.25)
12223	536	(14.423393758658799,10.75)
12224	622	(19.619546181365433,12.25)
12225	536	(14.423393758658799,10.75)
12226	879	(34.341978045700891,16.75)
12227	1079	(33.908965343808667,20.5)
12228	2279	(33.908965343808667,43)
12229	1140	(17.454482671904334,22)
12230	1792	(27.846787517317598,34)
12231	2279	(33.908965343808667,43)
12232	531	(10.093266739736606,10.75)
12233	1454	(12.258330249197702,28)
12234	1407	(6.6291651245988508,27.25)
12235	1448	(7.0621778264910704,28)
12236	1841	(1,35.5)
12237	487	(6.196152422706632,10)
12238	448	(7.49519052838329,9.25)
12239	487	(6.196152422706632,10)
12240	448	(7.49519052838329,9.25)
12241	1172	(10.959292143521045,22.75)
12242	1172	(10.959292143521045,22.75)
12243	492	(10.526279441628825,10)
12244	1090	(9.2272413359521668,21.25)
12245	1089	(8.3612159321677293,21.25)
12246	1323	(3.1650635094610968,25.75)
12247	1282	(1.8660254037844386,25)
12248	1321	(1.4330127018922194,25.75)
12249	1321	(1.4330127018922194,25.75)
12250	1321	(1.4330127018922194,25.75)
12251	1321	(1.4330127018922194,25.75)
12252	1161	(1.4330127018922194,22.75)
12253	1121	(1,22)
12254	1121	(1,22)
12255	1121	(1,22)
12256	1121	(1,22)
12257	1121	(1,22)
12258	1911	(27.413774815425377,36.25)
12259	1494	(12.691342951089922,28.75)
12260	570	(8.794228634059948,11.5)
12261	1611	(9.6602540378443873,31)
12262	1603	(2.7320508075688772,31)
12263	1601	(1,31)
12264	2026	(22.650635094610966,38.5)
12265	2026	(22.650635094610966,38.5)
12266	1783	(20.05255888325765,34)
12267	1783	(20.05255888325765,34)
12268	1702	(19.186533479473212,32.5)
12269	1783	(20.05255888325765,34)
12270	1743	(20.48557158514987,33.25)
12271	1743	(20.48557158514987,33.25)
12272	1603	(2.7320508075688772,31)
12273	1592	(28.279800219209818,30.25)
12274	1591	(27.413774815425377,30.25)
12275	1669	(25.681724007856502,31.75)
12276	1627	(23.516660498395403,31)
12277	1626	(22.650635094610966,31)
12278	1626	(22.650635094610966,31)
12279	734	(12.258330249197702,14.5)
12280	734	(12.258330249197702,14.5)
12281	856	(14.423393758658799,16.75)
12282	934	(12.691342951089922,18.25)
12283	934	(12.691342951089922,18.25)
12284	938	(16.155444566227676,18.25)
12285	938	(16.155444566227676,18.25)
12286	975	(13.124355652982141,19)
12287	1054	(12.258330249197702,20.5)
12288	1054	(12.258330249197702,20.5)
12289	938	(16.155444566227676,18.25)
12290	1057	(14.856406460551018,20.5)
12291	1054	(12.258330249197702,20.5)
12292	1877	(32.176914536239792,35.5)
12293	1831	(27.413774815425377,34.75)
12294	1534	(12.258330249197702,29.5)
12295	2289	(8.3612159321677293,43.75)
12296	2289	(8.3612159321677293,43.75)
12297	2289	(8.3612159321677293,43.75)
12298	2320	(35.208003449485325,43.75)
12299	1051	(9.6602540378443873,20.5)
12300	889	(7.9282032302755088,17.5)
12301	1204	(3.598076211353316,23.5)
12302	2104	(20.918584287042091,40)
12303	1644	(4.0310889132455356,31.75)
12304	2035	(30.444863728670914,38.5)
12305	1992	(28.279800219209818,37.75)
12306	1992	(28.279800219209818,37.75)
12307	2071	(27.413774815425377,39.25)
12308	1643	(3.1650635094610968,31.75)
12309	1571	(10.093266739736606,30.25)
12310	1603	(2.7320508075688772,31)
12311	1521	(1,29.5)
12312	1992	(28.279800219209818,37.75)
12313	2069	(25.681724007856502,39.25)
12314	1483	(3.1650635094610968,28.75)
12315	1185	(22.217622392718749,22.75)
12316	1104	(21.351596988934308,21.25)
12317	21	(18.320508075688775,1)
12318	60	(17.887495373796554,1.75)
12319	18	(15.722431864335457,1)
12320	179	(16.588457268119896,4)
12321	178	(15.722431864335457,4)
12322	138	(16.155444566227676,3.25)
12323	11	(9.6602540378443873,1)
12324	178	(15.722431864335457,4)
12325	178	(15.722431864335457,4)
12326	11	(9.6602540378443873,1)
12327	214	(12.691342951089922,4.75)
12328	13	(11.392304845413264,1)
12329	13	(11.392304845413264,1)
12330	737	(14.856406460551018,14.5)
12331	748	(24.382685902179844,14.5)
12332	748	(24.382685902179844,14.5)
12333	787	(23.949673200287624,15.25)
12334	948	(24.815698604072061,18.25)
12335	456	(14.423393758658799,9.25)
12336	947	(23.949673200287624,18.25)
12337	618	(16.155444566227676,12.25)
12338	577	(14.856406460551018,11.5)
12339	2376	(14.423393758658799,45.25)
12340	2376	(14.423393758658799,45.25)
12341	2376	(14.423393758658799,45.25)
12342	2377	(15.289419162443238,45.25)
12343	1112	(28.279800219209818,21.25)
12344	1220	(17.454482671904334,23.5)
12345	792	(28.279800219209818,15.25)
12346	1618	(15.722431864335457,31)
12347	1620	(17.454482671904334,31)
12348	1476	(31.310889132455351,28)
12349	1753	(29.145825622994256,33.25)
12350	1715	(30.444863728670914,32.5)
12351	1393	(28.712812921102035,26.5)
12352	1352	(28.279800219209818,25.75)
12353	1390	(26.114736709748719,26.5)
12354	1470	(26.114736709748719,28)
12355	1508	(24.815698604072061,28.75)
12356	1508	(24.815698604072061,28.75)
12357	1424	(21.351596988934308,27.25)
12358	1584	(21.351596988934308,30.25)
12359	1584	(21.351596988934308,30.25)
12360	1544	(20.918584287042091,29.5)
12361	1623	(20.05255888325765,31)
12362	1623	(20.05255888325765,31)
12363	1582	(19.619546181365433,30.25)
12364	1623	(20.05255888325765,31)
12365	835	(30.444863728670914,16)
12366	875	(30.877876430563134,16.75)
12367	875	(30.877876430563134,16.75)
12368	1508	(24.815698604072061,28.75)
12369	794	(30.011851026778693,15.25)
12370	792	(28.279800219209818,15.25)
12371	792	(28.279800219209818,15.25)
12372	1197	(32.609927238132009,22.75)
12373	1197	(32.609927238132009,22.75)
12374	840	(34.774990747593108,16)
12375	840	(34.774990747593108,16)
12376	878	(33.47595264191645,16.75)
12377	553	(29.145825622994256,10.75)
12378	553	(29.145825622994256,10.75)
12379	106	(22.650635094610966,2.5)
12380	395	(30.877876430563134,7.75)
12381	398	(33.47595264191645,7.75)
12382	399	(34.341978045700891,7.75)
12383	317	(32.609927238132009,6.25)
12384	231	(27.413774815425377,4.75)
12385	517	(32.176914536239792,10)
12386	478	(33.47595264191645,9.25)
12387	360	(34.774990747593108,7)
12388	278	(33.042939940024233,5.5)
12389	106	(22.650635094610966,2.5)
12390	395	(30.877876430563134,7.75)
12391	398	(33.47595264191645,7.75)
12392	360	(34.774990747593108,7)
12393	317	(32.609927238132009,6.25)
12394	80	(35.208003449485325,1.75)
12395	80	(35.208003449485325,1.75)
12396	80	(35.208003449485325,1.75)
12397	278	(33.042939940024233,5.5)
12398	278	(33.042939940024233,5.5)
12399	398	(33.47595264191645,7.75)
12400	360	(34.774990747593108,7)
12401	317	(32.609927238132009,6.25)
12402	317	(32.609927238132009,6.25)
12403	478	(33.47595264191645,9.25)
12404	360	(34.774990747593108,7)
12405	278	(33.042939940024233,5.5)
12406	278	(33.042939940024233,5.5)
12407	676	(31.310889132455351,13)
12408	676	(31.310889132455351,13)
12409	719	(34.341978045700891,13.75)
12410	272	(27.846787517317598,5.5)
12411	1869	(25.248711305964282,35.5)
12412	2144	(21.351596988934308,40.75)
12413	2400	(35.208003449485325,45.25)
12414	2399	(34.341978045700891,45.25)
12415	2200	(34.774990747593108,41.5)
12416	1834	(30.011851026778693,34.75)
12417	2186	(22.650635094610966,41.5)
12418	1356	(31.743901834347572,25.75)
12419	2187	(23.516660498395403,41.5)
12420	2186	(22.650635094610966,41.5)
12421	2186	(22.650635094610966,41.5)
12422	2317	(32.609927238132009,43.75)
12423	1160	(34.774990747593108,22)
12424	1160	(34.774990747593108,22)
12425	1360	(35.208003449485325,25.75)
12426	2317	(32.609927238132009,43.75)
12427	2269	(25.248711305964282,43)
12428	2358	(33.042939940024233,44.5)
12429	1356	(31.743901834347572,25.75)
12430	1240	(34.774990747593108,23.5)
12431	1360	(35.208003449485325,25.75)
12432	1597	(32.609927238132009,30.25)
12433	1834	(30.011851026778693,34.75)
12434	1907	(23.949673200287624,36.25)
12435	1600	(35.208003449485325,30.25)
12436	1907	(23.949673200287624,36.25)
12437	1685	(4.4641016151377544,32.5)
12438	1911	(27.413774815425377,36.25)
12439	1955	(30.444863728670914,37)
12440	2159	(34.341978045700891,40.75)
12441	2159	(34.341978045700891,40.75)
12442	1724	(4.0310889132455356,33.25)
12443	1877	(32.176914536239792,35.5)
12444	1879	(33.908965343808667,35.5)
12445	1572	(10.959292143521045,30.25)
12446	1563	(3.1650635094610968,30.25)
12447	1601	(1,31)
12448	2194	(29.578838324886476,41.5)
12449	2040	(34.774990747593108,38.5)
12450	2156	(31.743901834347572,40.75)
12451	2156	(31.743901834347572,40.75)
12452	2196	(31.310889132455351,41.5)
12453	1960	(34.774990747593108,37)
12454	1356	(31.743901834347572,25.75)
12455	1757	(32.609927238132009,33.25)
12456	1759	(34.341978045700891,33.25)
12457	1680	(35.208003449485325,31.75)
12458	398	(33.47595264191645,7.75)
12459	398	(33.47595264191645,7.75)
12460	360	(34.774990747593108,7)
12461	1759	(34.341978045700891,33.25)
12462	317	(32.609927238132009,6.25)
12463	560	(35.208003449485325,10.75)
12464	560	(35.208003449485325,10.75)
12465	560	(35.208003449485325,10.75)
12466	600	(34.774990747593108,11.5)
12467	560	(35.208003449485325,10.75)
12468	145	(22.217622392718749,3.25)
12469	147	(23.949673200287624,3.25)
12470	147	(23.949673200287624,3.25)
12471	146	(23.083647796503186,3.25)
12472	146	(23.083647796503186,3.25)
12473	106	(22.650635094610966,2.5)
12474	26	(22.650635094610966,1)
12475	1603	(2.7320508075688772,31)
12476	1680	(35.208003449485325,31.75)
12477	1715	(30.444863728670914,32.5)
12478	41	(1.4330127018922194,1.75)
12479	1600	(35.208003449485325,30.25)
12480	7	(6.196152422706632,1)
12481	5	(4.4641016151377544,1)
12482	45	(4.897114317029974,1.75)
12483	82	(1.8660254037844386,2.5)
12484	241	(1,5.5)
12485	201	(1.4330127018922194,4.75)
12486	201	(1.4330127018922194,4.75)
12487	1	(1,1)
12488	1	(1,1)
12489	1	(1,1)
12490	146	(23.083647796503186,3.25)
12491	146	(23.083647796503186,3.25)
12492	146	(23.083647796503186,3.25)
12493	145	(22.217622392718749,3.25)
12494	105	(21.784609690826528,2.5)
12495	26	(22.650635094610966,1)
12496	2150	(26.54774941164094,40.75)
12497	1957	(32.176914536239792,37)
12498	2236	(31.743901834347572,42.25)
12499	2104	(20.918584287042091,40)
12500	289	(8.3612159321677293,6.25)
12501	1717	(32.176914536239792,32.5)
12502	1759	(34.341978045700891,33.25)
12503	1760	(35.208003449485325,33.25)
12504	1680	(35.208003449485325,31.75)
12505	993	(28.712812921102035,19)
12506	954	(30.011851026778693,18.25)
12507	418	(15.722431864335457,8.5)
12508	418	(15.722431864335457,8.5)
12509	948	(24.815698604072061,18.25)
12510	577	(14.856406460551018,11.5)
12511	456	(14.423393758658799,9.25)
12512	947	(23.949673200287624,18.25)
12513	618	(16.155444566227676,12.25)
12514	1312	(27.846787517317598,25)
12515	1312	(27.846787517317598,25)
12516	1298	(15.722431864335457,25)
12517	1308	(24.382685902179844,25)
12518	1306	(22.650635094610966,25)
12519	1306	(22.650635094610966,25)
12520	2233	(29.145825622994256,42.25)
12521	2026	(22.650635094610966,38.5)
12522	1685	(4.4641016151377544,32.5)
12523	1725	(4.897114317029974,33.25)
12524	1684	(3.598076211353316,32.5)
12525	981	(18.320508075688775,19)
12526	1984	(21.351596988934308,37.75)
12527	1984	(21.351596988934308,37.75)
12528	1984	(21.351596988934308,37.75)
12529	158	(33.47595264191645,3.25)
12530	158	(33.47595264191645,3.25)
12531	158	(33.47595264191645,3.25)
12532	200	(34.774990747593108,4)
12533	2318	(33.47595264191645,43.75)
12534	2318	(33.47595264191645,43.75)
12535	2359	(33.908965343808667,44.5)
12536	2279	(33.908965343808667,43)
12537	511	(26.98076211353316,10)
12538	145	(22.217622392718749,3.25)
12539	230	(26.54774941164094,4.75)
12540	553	(29.145825622994256,10.75)
12541	553	(29.145825622994256,10.75)
12542	272	(27.846787517317598,5.5)
12543	26	(22.650635094610966,1)
12544	517	(32.176914536239792,10)
12545	478	(33.47595264191645,9.25)
12546	360	(34.774990747593108,7)
12547	278	(33.042939940024233,5.5)
12548	278	(33.042939940024233,5.5)
12549	278	(33.042939940024233,5.5)
12550	1571	(10.093266739736606,30.25)
12551	1424	(21.351596988934308,27.25)
12552	1584	(21.351596988934308,30.25)
12553	1584	(21.351596988934308,30.25)
12554	1623	(20.05255888325765,31)
12555	600	(34.774990747593108,11.5)
12556	1934	(12.258330249197702,37)
12557	1822	(19.619546181365433,34.75)
12558	1821	(18.753520777580992,34.75)
12559	1934	(12.258330249197702,37)
12560	1934	(12.258330249197702,37)
12561	317	(32.609927238132009,6.25)
12562	317	(32.609927238132009,6.25)
12563	2065	(22.217622392718749,39.25)
12564	1952	(27.846787517317598,37)
12565	2388	(24.815698604072061,45.25)
12566	2348	(24.382685902179844,44.5)
12567	2261	(18.320508075688775,43)
12568	2386	(23.083647796503186,45.25)
12569	2388	(24.815698604072061,45.25)
12570	2261	(18.320508075688775,43)
12571	2301	(18.753520777580992,43.75)
12572	2264	(20.918584287042091,43)
12573	2262	(19.186533479473212,43)
12574	2382	(19.619546181365433,45.25)
12575	2304	(21.351596988934308,43.75)
12576	2384	(21.351596988934308,45.25)
12577	2365	(4.897114317029974,45.25)
12578	2367	(6.6291651245988508,45.25)
12579	2285	(4.897114317029974,43.75)
12580	2365	(4.897114317029974,45.25)
12581	2365	(4.897114317029974,45.25)
12582	2365	(4.897114317029974,45.25)
12583	2364	(4.0310889132455356,45.25)
12584	2281	(1.4330127018922194,43.75)
12585	2241	(1,43)
12586	2241	(1,43)
12587	2242	(1.8660254037844386,43)
12588	1695	(13.124355652982141,32.5)
12589	1897	(15.289419162443238,36.25)
12590	1776	(13.99038105676658,34)
12591	1776	(13.99038105676658,34)
12592	1980	(17.887495373796554,37.75)
12593	1899	(17.021469970012117,36.25)
12594	1779	(16.588457268119896,34)
12595	1822	(19.619546181365433,34.75)
12596	1779	(16.588457268119896,34)
12597	1977	(15.289419162443238,37.75)
12598	1892	(10.959292143521045,36.25)
12599	1889	(8.3612159321677293,36.25)
12600	2141	(18.753520777580992,40.75)
12601	1980	(17.887495373796554,37.75)
12602	1776	(13.99038105676658,34)
12603	1814	(12.691342951089922,34.75)
12604	1900	(17.887495373796554,36.25)
12605	1776	(13.99038105676658,34)
12606	1969	(8.3612159321677293,37.75)
12607	2060	(17.887495373796554,39.25)
12608	2255	(13.124355652982141,43)
12609	2255	(13.124355652982141,43)
12610	1968	(7.49519052838329,37.75)
12611	2175	(13.124355652982141,41.5)
12612	2175	(13.124355652982141,41.5)
12613	2134	(12.691342951089922,40.75)
12614	2212	(10.959292143521045,42.25)
12615	2086	(5.3301270189221936,40)
12616	1961	(1.4330127018922194,37.75)
12617	1924	(3.598076211353316,37)
12618	2004	(3.598076211353316,38.5)
12619	2358	(33.042939940024233,44.5)
12620	2279	(33.908965343808667,43)
12621	2279	(33.908965343808667,43)
12622	2397	(32.609927238132009,45.25)
12623	2154	(30.011851026778693,40.75)
12624	2159	(34.341978045700891,40.75)
12625	2394	(30.011851026778693,45.25)
12626	2352	(27.846787517317598,44.5)
12627	2392	(28.279800219209818,45.25)
12628	2392	(28.279800219209818,45.25)
12629	2050	(9.2272413359521668,39.25)
12630	2050	(9.2272413359521668,39.25)
12631	2279	(33.908965343808667,43)
12632	446	(5.7631397208144124,9.25)
12633	446	(5.7631397208144124,9.25)
12634	481	(1,10)
12635	531	(10.093266739736606,10.75)
12636	730	(8.794228634059948,14.5)
12637	1128	(7.0621778264910704,22)
12638	1363	(2.7320508075688772,26.5)
12639	1128	(7.0621778264910704,22)
12640	1321	(1.4330127018922194,25.75)
12641	1321	(1.4330127018922194,25.75)
12642	1281	(1,25)
12643	1241	(1.4330127018922194,24.25)
12644	1121	(1,22)
12645	1869	(25.248711305964282,35.5)
12646	2071	(27.413774815425377,39.25)
12647	2071	(27.413774815425377,39.25)
12648	1607	(6.196152422706632,31)
12649	1521	(1,29.5)
12650	1704	(20.918584287042091,32.5)
12651	934	(12.691342951089922,18.25)
12652	936	(14.423393758658799,18.25)
12653	1055	(13.124355652982141,20.5)
12654	1911	(27.413774815425377,36.25)
12655	1494	(12.691342951089922,28.75)
12656	854	(12.691342951089922,16.75)
12657	814	(12.258330249197702,16)
12658	1871	(26.98076211353316,35.5)
12659	1955	(30.444863728670914,37)
12660	1614	(12.258330249197702,31)
12661	613	(11.825317547305483,12.25)
12662	1954	(29.578838324886476,37)
12663	2038	(33.042939940024233,38.5)
12664	900	(17.454482671904334,17.5)
12665	1592	(28.279800219209818,30.25)
12666	1705	(21.784609690826528,32.5)
12667	1709	(25.248711305964282,32.5)
12668	2376	(14.423393758658799,45.25)
12669	1659	(17.021469970012117,31.75)
12670	2376	(14.423393758658799,45.25)
12671	2377	(15.289419162443238,45.25)
12672	1659	(17.021469970012117,31.75)
12673	1393	(28.712812921102035,26.5)
12674	1393	(28.712812921102035,26.5)
12675	1432	(28.279800219209818,27.25)
12676	1432	(28.279800219209818,27.25)
12677	1471	(26.98076211353316,28)
12678	1312	(27.846787517317598,25)
12679	1312	(27.846787517317598,25)
12680	1312	(27.846787517317598,25)
12681	1470	(26.114736709748719,28)
12682	1471	(26.98076211353316,28)
12683	1545	(21.784609690826528,29.5)
12684	1623	(20.05255888325765,31)
12685	1669	(25.681724007856502,31.75)
12686	1944	(20.918584287042091,37)
12687	2237	(32.609927238132009,42.25)
12688	2236	(31.743901834347572,42.25)
12689	2237	(32.609927238132009,42.25)
12690	1984	(21.351596988934308,37.75)
12691	1725	(4.897114317029974,33.25)
12692	2069	(25.681724007856502,39.25)
12693	2069	(25.681724007856502,39.25)
12694	1724	(4.0310889132455356,33.25)
12695	954	(30.011851026778693,18.25)
12696	665	(21.784609690826528,13)
12697	624	(21.351596988934308,12.25)
12698	665	(21.784609690826528,13)
12699	665	(21.784609690826528,13)
12700	661	(18.320508075688775,13)
12701	701	(18.753520777580992,13.75)
12702	536	(14.423393758658799,10.75)
12703	577	(14.856406460551018,11.5)
12704	1145	(21.784609690826528,22)
12705	1106	(23.083647796503186,21.25)
12706	1106	(23.083647796503186,21.25)
12707	1106	(23.083647796503186,21.25)
12708	905	(21.784609690826528,17.5)
12709	1108	(24.815698604072061,21.25)
12710	1187	(23.949673200287624,22.75)
12711	905	(21.784609690826528,17.5)
12712	1106	(23.083647796503186,21.25)
12713	905	(21.784609690826528,17.5)
12714	737	(14.856406460551018,14.5)
12715	214	(12.691342951089922,4.75)
12716	60	(17.887495373796554,1.75)
12717	138	(16.155444566227676,3.25)
12718	179	(16.588457268119896,4)
12719	94	(12.258330249197702,2.5)
12720	94	(12.258330249197702,2.5)
12721	94	(12.258330249197702,2.5)
12722	94	(12.258330249197702,2.5)
12723	175	(13.124355652982141,4)
12724	21	(18.320508075688775,1)
12725	1623	(20.05255888325765,31)
12726	1306	(22.650635094610966,25)
12727	1298	(15.722431864335457,25)
12728	1340	(17.887495373796554,25.75)
12729	1302	(19.186533479473212,25)
12730	1339	(17.021469970012117,25.75)
12731	1302	(19.186533479473212,25)
12732	1298	(15.722431864335457,25)
12733	1464	(20.918584287042091,28)
12734	1623	(20.05255888325765,31)
12735	423	(20.05255888325765,8.5)
12736	423	(20.05255888325765,8.5)
12737	425	(21.784609690826528,8.5)
12738	792	(28.279800219209818,15.25)
12739	791	(27.413774815425377,15.25)
12740	344	(20.918584287042091,7)
12741	752	(27.846787517317598,14.5)
12742	791	(27.413774815425377,15.25)
12743	792	(28.279800219209818,15.25)
12744	511	(26.98076211353316,10)
12745	511	(26.98076211353316,10)
12746	511	(26.98076211353316,10)
12747	480	(35.208003449485325,9.25)
12748	480	(35.208003449485325,9.25)
12749	480	(35.208003449485325,9.25)
12750	480	(35.208003449485325,9.25)
12751	113	(28.712812921102035,2.5)
12752	113	(28.712812921102035,2.5)
12753	234	(30.011851026778693,4.75)
12754	234	(30.011851026778693,4.75)
12755	234	(30.011851026778693,4.75)
12756	231	(27.413774815425377,4.75)
12757	480	(35.208003449485325,9.25)
12758	113	(28.712812921102035,2.5)
12759	113	(28.712812921102035,2.5)
12760	277	(32.176914536239792,5.5)
12761	277	(32.176914536239792,5.5)
12762	840	(34.774990747593108,16)
12763	149	(25.681724007856502,3.25)
12764	109	(25.248711305964282,2.5)
12765	511	(26.98076211353316,10)
12766	480	(35.208003449485325,9.25)
12767	919	(33.908965343808667,17.5)
12768	919	(33.908965343808667,17.5)
12769	673	(28.712812921102035,13)
12770	674	(29.578838324886476,13)
12771	673	(28.712812921102035,13)
12772	674	(29.578838324886476,13)
12773	672	(27.846787517317598,13)
12774	511	(26.98076211353316,10)
12775	511	(26.98076211353316,10)
12776	480	(35.208003449485325,9.25)
12777	480	(35.208003449485325,9.25)
12778	480	(35.208003449485325,9.25)
12779	480	(35.208003449485325,9.25)
12780	152	(28.279800219209818,3.25)
12781	153	(29.145825622994256,3.25)
12782	153	(29.145825622994256,3.25)
12783	511	(26.98076211353316,10)
12784	511	(26.98076211353316,10)
12785	511	(26.98076211353316,10)
12786	511	(26.98076211353316,10)
12787	511	(26.98076211353316,10)
12788	511	(26.98076211353316,10)
12789	113	(28.712812921102035,2.5)
12790	234	(30.011851026778693,4.75)
12791	1036	(31.743901834347572,19.75)
12792	1036	(31.743901834347572,19.75)
12793	508	(24.382685902179844,10)
12794	508	(24.382685902179844,10)
12795	665	(21.784609690826528,13)
12796	665	(21.784609690826528,13)
12797	661	(18.320508075688775,13)
12798	624	(21.351596988934308,12.25)
12799	624	(21.351596988934308,12.25)
12800	665	(21.784609690826528,13)
12801	423	(20.05255888325765,8.5)
12802	423	(20.05255888325765,8.5)
12803	464	(21.351596988934308,9.25)
12804	997	(32.176914536239792,19)
12805	661	(18.320508075688775,13)
12806	1113	(29.145825622994256,21.25)
12807	1113	(29.145825622994256,21.25)
12808	1113	(29.145825622994256,21.25)
12809	1219	(16.588457268119896,23.5)
12810	1153	(28.712812921102035,22)
12811	1112	(28.279800219209818,21.25)
12812	1112	(28.279800219209818,21.25)
12813	1222	(19.186533479473212,23.5)
12814	1219	(16.588457268119896,23.5)
12815	2196	(31.310889132455351,41.5)
12816	1960	(34.774990747593108,37)
12817	2359	(33.908965343808667,44.5)
12818	2279	(33.908965343808667,43)
12819	234	(30.011851026778693,4.75)
12820	74	(30.011851026778693,1.75)
12821	234	(30.011851026778693,4.75)
12822	234	(30.011851026778693,4.75)
12823	1240	(34.774990747593108,23.5)
12824	1240	(34.774990747593108,23.5)
12825	1360	(35.208003449485325,25.75)
12826	1596	(31.743901834347572,30.25)
12827	480	(35.208003449485325,9.25)
12828	480	(35.208003449485325,9.25)
12829	113	(28.712812921102035,2.5)
12830	113	(28.712812921102035,2.5)
12831	234	(30.011851026778693,4.75)
12832	234	(30.011851026778693,4.75)
12833	508	(24.382685902179844,10)
12834	508	(24.382685902179844,10)
12835	508	(24.382685902179844,10)
12836	508	(24.382685902179844,10)
12837	508	(24.382685902179844,10)
12838	1036	(31.743901834347572,19.75)
12839	508	(24.382685902179844,10)
12840	508	(24.382685902179844,10)
12841	1600	(35.208003449485325,30.25)
12842	549	(25.681724007856502,10.75)
12843	549	(25.681724007856502,10.75)
12844	511	(26.98076211353316,10)
12845	511	(26.98076211353316,10)
12846	672	(27.846787517317598,13)
12847	672	(27.846787517317598,13)
12848	511	(26.98076211353316,10)
12849	511	(26.98076211353316,10)
12850	511	(26.98076211353316,10)
12851	1160	(34.774990747593108,22)
12852	1160	(34.774990747593108,22)
12853	1360	(35.208003449485325,25.75)
12854	1960	(34.774990747593108,37)
12855	1360	(35.208003449485325,25.75)
12856	2317	(32.609927238132009,43.75)
12857	2269	(25.248711305964282,43)
12858	2358	(33.042939940024233,44.5)
12859	1356	(31.743901834347572,25.75)
12860	2279	(33.908965343808667,43)
12861	2279	(33.908965343808667,43)
12862	2388	(24.815698604072061,45.25)
12863	2221	(18.753520777580992,42.25)
12864	2221	(18.753520777580992,42.25)
12865	2347	(23.516660498395403,44.5)
12866	2345	(21.784609690826528,44.5)
12867	2380	(17.887495373796554,45.25)
12868	2101	(18.320508075688775,40)
12869	1739	(17.021469970012117,33.25)
12870	2101	(18.320508075688775,40)
12871	1779	(16.588457268119896,34)
12872	1814	(12.691342951089922,34.75)
12873	1776	(13.99038105676658,34)
12874	1981	(18.753520777580992,37.75)
12875	2134	(12.691342951089922,40.75)
12876	2213	(11.825317547305483,42.25)
12877	2008	(7.0621778264910704,38.5)
12878	1929	(7.9282032302755088,37)
12879	2060	(17.887495373796554,39.25)
12880	2392	(28.279800219209818,45.25)
12881	2126	(5.7631397208144124,40.75)
12882	2007	(6.196152422706632,38.5)
12883	2165	(4.4641016151377544,41.5)
12884	2124	(4.0310889132455356,40.75)
12885	2121	(1.4330127018922194,40.75)
12886	371	(10.093266739736606,7.75)
12887	170	(8.794228634059948,4)
12888	2186	(22.650635094610966,41.5)
12889	194	(29.578838324886476,4)
12890	1623	(20.05255888325765,31)
12891	370	(9.2272413359521668,7.75)
12892	369	(8.3612159321677293,7.75)
12893	291	(10.093266739736606,6.25)
12894	331	(9.6602540378443873,7)
12895	369	(8.3612159321677293,7.75)
12896	369	(8.3612159321677293,7.75)
12897	369	(8.3612159321677293,7.75)
12898	369	(8.3612159321677293,7.75)
12899	369	(8.3612159321677293,7.75)
12900	369	(8.3612159321677293,7.75)
12901	2150	(26.54774941164094,40.75)
12902	787	(23.949673200287624,15.25)
12903	787	(23.949673200287624,15.25)
12904	788	(24.815698604072061,15.25)
12905	748	(24.382685902179844,14.5)
12906	748	(24.382685902179844,14.5)
12907	748	(24.382685902179844,14.5)
12908	748	(24.382685902179844,14.5)
12909	719	(34.341978045700891,13.75)
12910	719	(34.341978045700891,13.75)
12911	719	(34.341978045700891,13.75)
12912	840	(34.774990747593108,16)
12913	880	(35.208003449485325,16.75)
12914	920	(34.774990747593108,17.5)
12915	920	(34.774990747593108,17.5)
12916	277	(32.176914536239792,5.5)
12917	234	(30.011851026778693,4.75)
12918	920	(34.774990747593108,17.5)
12919	246	(5.3301270189221936,5.5)
12920	246	(5.3301270189221936,5.5)
12921	41	(1.4330127018922194,1.75)
12922	246	(5.3301270189221936,5.5)
12923	246	(5.3301270189221936,5.5)
12924	41	(1.4330127018922194,1.75)
12925	41	(1.4330127018922194,1.75)
12926	41	(1.4330127018922194,1.75)
12927	246	(5.3301270189221936,5.5)
12928	246	(5.3301270189221936,5.5)
12929	7	(6.196152422706632,1)
12930	7	(6.196152422706632,1)
12931	88	(7.0621778264910704,2.5)
12932	45	(4.897114317029974,1.75)
12933	45	(4.897114317029974,1.75)
12934	82	(1.8660254037844386,2.5)
12935	285	(4.897114317029974,6.25)
12936	324	(3.598076211353316,7)
12937	201	(1.4330127018922194,4.75)
12938	1919	(34.341978045700891,36.25)
12939	2075	(30.877876430563134,39.25)
12940	1234	(29.578838324886476,23.5)
12941	2159	(34.341978045700891,40.75)
12942	2040	(34.774990747593108,38.5)
12943	2040	(34.774990747593108,38.5)
12944	2159	(34.341978045700891,40.75)
12945	2400	(35.208003449485325,45.25)
12946	1869	(25.248711305964282,35.5)
12947	2200	(34.774990747593108,41.5)
12948	2399	(34.341978045700891,45.25)
12949	2156	(31.743901834347572,40.75)
12950	2156	(31.743901834347572,40.75)
12951	2194	(29.578838324886476,41.5)
12952	2040	(34.774990747593108,38.5)
12953	2040	(34.774990747593108,38.5)
12954	2156	(31.743901834347572,40.75)
12955	531	(10.093266739736606,10.75)
12956	770	(9.2272413359521668,15.25)
12957	1168	(7.49519052838329,22.75)
12958	1245	(4.897114317029974,24.25)
12959	1245	(4.897114317029974,24.25)
12960	531	(10.093266739736606,10.75)
12961	1340	(17.887495373796554,25.75)
12962	1302	(19.186533479473212,25)
12963	1298	(15.722431864335457,25)
12964	1339	(17.021469970012117,25.75)
12965	1302	(19.186533479473212,25)
12966	1298	(15.722431864335457,25)
12967	1306	(22.650635094610966,25)
12968	1464	(20.918584287042091,28)
12969	1623	(20.05255888325765,31)
12970	1623	(20.05255888325765,31)
12971	1277	(32.609927238132009,24.25)
12972	1476	(31.310889132455351,28)
12973	1753	(29.145825622994256,33.25)
12974	1715	(30.444863728670914,32.5)
12975	1676	(31.743901834347572,31.75)
12976	1717	(32.176914536239792,32.5)
12977	1718	(33.042939940024233,32.5)
12978	1759	(34.341978045700891,33.25)
12979	1760	(35.208003449485325,33.25)
12980	1680	(35.208003449485325,31.75)
12981	1759	(34.341978045700891,33.25)
12982	2233	(29.145825622994256,42.25)
12983	2071	(27.413774815425377,39.25)
12984	1521	(1,29.5)
12985	113	(28.712812921102035,2.5)
12986	113	(28.712812921102035,2.5)
12987	234	(30.011851026778693,4.75)
12988	234	(30.011851026778693,4.75)
12989	113	(28.712812921102035,2.5)
12990	113	(28.712812921102035,2.5)
12991	234	(30.011851026778693,4.75)
12992	234	(30.011851026778693,4.75)
12993	231	(27.413774815425377,4.75)
12994	231	(27.413774815425377,4.75)
12995	231	(27.413774815425377,4.75)
12996	231	(27.413774815425377,4.75)
12997	511	(26.98076211353316,10)
12998	231	(27.413774815425377,4.75)
12999	113	(28.712812921102035,2.5)
13000	423	(20.05255888325765,8.5)
13001	423	(20.05255888325765,8.5)
13002	423	(20.05255888325765,8.5)
13003	344	(20.918584287042091,7)
13004	344	(20.918584287042091,7)
13005	1393	(28.712812921102035,26.5)
13006	1432	(28.279800219209818,27.25)
13007	1393	(28.712812921102035,26.5)
13008	1393	(28.712812921102035,26.5)
13009	1432	(28.279800219209818,27.25)
13010	1313	(28.712812921102035,25)
13011	1511	(27.413774815425377,28.75)
13012	1313	(28.712812921102035,25)
13013	1313	(28.712812921102035,25)
13014	1471	(26.98076211353316,28)
13015	1511	(27.413774815425377,28.75)
13016	266	(22.650635094610966,5.5)
13017	668	(24.382685902179844,13)
13018	393	(29.145825622994256,7.75)
13019	369	(8.3612159321677293,7.75)
13020	370	(9.2272413359521668,7.75)
13021	266	(22.650635094610966,5.5)
13022	266	(22.650635094610966,5.5)
13023	1117	(32.609927238132009,21.25)
13024	511	(26.98076211353316,10)
13025	511	(26.98076211353316,10)
13026	480	(35.208003449485325,9.25)
13027	72	(28.279800219209818,1.75)
13028	111	(26.98076211353316,2.5)
13029	194	(29.578838324886476,4)
13030	234	(30.011851026778693,4.75)
13031	234	(30.011851026778693,4.75)
13032	560	(35.208003449485325,10.75)
13033	560	(35.208003449485325,10.75)
13034	560	(35.208003449485325,10.75)
13035	560	(35.208003449485325,10.75)
13036	960	(35.208003449485325,18.25)
13037	197	(32.176914536239792,4)
13038	197	(32.176914536239792,4)
13039	197	(32.176914536239792,4)
13040	197	(32.176914536239792,4)
13041	1374	(12.258330249197702,26.5)
13042	2320	(35.208003449485325,43.75)
13043	2347	(23.516660498395403,44.5)
13044	2345	(21.784609690826528,44.5)
13045	2306	(23.083647796503186,43.75)
13046	2306	(23.083647796503186,43.75)
13047	2306	(23.083647796503186,43.75)
13048	1470	(26.114736709748719,28)
13049	1623	(20.05255888325765,31)
13050	791	(27.413774815425377,15.25)
13051	344	(20.918584287042091,7)
13052	277	(32.176914536239792,5.5)
13053	109	(25.248711305964282,2.5)
13054	234	(30.011851026778693,4.75)
13055	508	(24.382685902179844,10)
13056	194	(29.578838324886476,4)
13057	1623	(20.05255888325765,31)
13058	277	(32.176914536239792,5.5)
13059	234	(30.011851026778693,4.75)
13060	920	(34.774990747593108,17.5)
13061	82	(1.8660254037844386,2.5)
13062	88	(7.0621778264910704,2.5)
13063	344	(20.918584287042091,7)
13064	2279	(33.908965343808667,43)
13065	568	(7.0621778264910704,11.5)
13066	1172	(10.959292143521045,22.75)
13067	607	(6.6291651245988508,12.25)
13068	1090	(9.2272413359521668,21.25)
13069	1089	(8.3612159321677293,21.25)
13070	1241	(1.4330127018922194,24.25)
13071	1322	(2.299038105676658,25.75)
13072	1282	(1.8660254037844386,25)
13073	1281	(1,25)
13074	1281	(1,25)
13075	1281	(1,25)
13076	1241	(1.4330127018922194,24.25)
13077	1161	(1.4330127018922194,22.75)
13078	412	(10.526279441628825,8.5)
13079	2029	(25.248711305964282,38.5)
13080	2071	(27.413774815425377,39.25)
13081	1572	(10.959292143521045,30.25)
13082	1572	(10.959292143521045,30.25)
13083	1984	(21.351596988934308,37.75)
13084	2065	(22.217622392718749,39.25)
13085	2064	(21.351596988934308,39.25)
13086	2104	(20.918584287042091,40)
13087	2104	(20.918584287042091,40)
13088	2028	(24.382685902179844,38.5)
13089	1571	(10.093266739736606,30.25)
13090	1572	(10.959292143521045,30.25)
13091	1641	(1.4330127018922194,31.75)
13092	1571	(10.093266739736606,30.25)
13093	2065	(22.217622392718749,39.25)
13094	1121	(1,22)
13095	1121	(1,22)
13096	1121	(1,22)
13097	734	(12.258330249197702,14.5)
13098	734	(12.258330249197702,14.5)
13099	1743	(20.48557158514987,33.25)
13100	1704	(20.918584287042091,32.5)
13101	1743	(20.48557158514987,33.25)
13102	1743	(20.48557158514987,33.25)
13103	1444	(3.598076211353316,28)
13104	768	(7.49519052838329,15.25)
13105	1591	(27.413774815425377,30.25)
13106	1669	(25.681724007856502,31.75)
13107	1669	(25.681724007856502,31.75)
13108	1626	(22.650635094610966,31)
13109	1626	(22.650635094610966,31)
13110	396	(31.743901834347572,7.75)
13111	396	(31.743901834347572,7.75)
13112	398	(33.47595264191645,7.75)
13113	398	(33.47595264191645,7.75)
13114	398	(33.47595264191645,7.75)
13115	439	(33.908965343808667,8.5)
13116	360	(34.774990747593108,7)
13117	320	(35.208003449485325,6.25)
13118	360	(34.774990747593108,7)
13119	398	(33.47595264191645,7.75)
13120	511	(26.98076211353316,10)
13121	190	(26.114736709748719,4)
13122	269	(25.248711305964282,5.5)
13123	478	(33.47595264191645,9.25)
13124	438	(33.042939940024233,8.5)
13125	438	(33.042939940024233,8.5)
13126	360	(34.774990747593108,7)
13127	145	(22.217622392718749,3.25)
13128	145	(22.217622392718749,3.25)
13129	145	(22.217622392718749,3.25)
13130	394	(30.011851026778693,7.75)
13131	558	(33.47595264191645,10.75)
13132	920	(34.774990747593108,17.5)
13133	920	(34.774990747593108,17.5)
13134	560	(35.208003449485325,10.75)
13135	28	(24.382685902179844,1)
13136	438	(33.042939940024233,8.5)
13137	360	(34.774990747593108,7)
13138	360	(34.774990747593108,7)
13139	318	(33.47595264191645,6.25)
13140	439	(33.908965343808667,8.5)
13141	360	(34.774990747593108,7)
13142	360	(34.774990747593108,7)
13143	318	(33.47595264191645,6.25)
13144	439	(33.908965343808667,8.5)
13145	360	(34.774990747593108,7)
13146	320	(35.208003449485325,6.25)
13147	105	(21.784609690826528,2.5)
13148	116	(31.310889132455351,2.5)
13149	960	(35.208003449485325,18.25)
13150	560	(35.208003449485325,10.75)
13151	560	(35.208003449485325,10.75)
13152	960	(35.208003449485325,18.25)
13153	156	(31.743901834347572,3.25)
13154	960	(35.208003449485325,18.25)
13155	560	(35.208003449485325,10.75)
13156	560	(35.208003449485325,10.75)
13157	960	(35.208003449485325,18.25)
13158	960	(35.208003449485325,18.25)
13159	501	(18.320508075688775,10)
13160	501	(18.320508075688775,10)
13161	423	(20.05255888325765,8.5)
13162	425	(21.784609690826528,8.5)
13163	505	(21.784609690826528,10)
13164	505	(21.784609690826528,10)
13165	344	(20.918584287042091,7)
13166	960	(35.208003449485325,18.25)
13167	116	(31.310889132455351,2.5)
13168	960	(35.208003449485325,18.25)
13169	1393	(28.712812921102035,26.5)
13170	1352	(28.279800219209818,25.75)
13171	1390	(26.114736709748719,26.5)
13172	1470	(26.114736709748719,28)
13173	1470	(26.114736709748719,28)
13174	1508	(24.815698604072061,28.75)
13175	1545	(21.784609690826528,29.5)
13176	1508	(24.815698604072061,28.75)
13177	1508	(24.815698604072061,28.75)
13178	1623	(20.05255888325765,31)
13179	1158	(33.042939940024233,22)
13180	1158	(33.042939940024233,22)
13181	840	(34.774990747593108,16)
13182	840	(34.774990747593108,16)
13183	840	(34.774990747593108,16)
13184	840	(34.774990747593108,16)
13185	1480	(34.774990747593108,28)
13186	772	(10.959292143521045,15.25)
13187	973	(11.392304845413264,19)
13188	975	(13.124355652982141,19)
13189	1054	(12.258330249197702,20.5)
13190	1949	(25.248711305964282,37)
13191	1494	(12.691342951089922,28.75)
13192	570	(8.794228634059948,11.5)
13193	612	(10.959292143521045,12.25)
13194	1572	(10.959292143521045,30.25)
13195	1641	(1.4330127018922194,31.75)
13196	1487	(6.6291651245988508,28.75)
13197	1487	(6.6291651245988508,28.75)
13198	1487	(6.6291651245988508,28.75)
13199	2200	(34.774990747593108,41.5)
13200	1947	(23.516660498395403,37)
13201	1641	(1.4330127018922194,31.75)
13202	1949	(25.248711305964282,37)
13203	1765	(4.4641016151377544,34)
13204	412	(10.526279441628825,8.5)
13205	2193	(28.712812921102035,41.5)
13206	2154	(30.011851026778693,40.75)
13207	2117	(32.176914536239792,40)
13208	2370	(9.2272413359521668,45.25)
13209	2370	(9.2272413359521668,45.25)
13210	2104	(20.918584287042091,40)
13211	1051	(9.6602540378443873,20.5)
13212	1050	(8.794228634059948,20.5)
13213	1245	(4.897114317029974,24.25)
13214	1204	(3.598076211353316,23.5)
13215	1204	(3.598076211353316,23.5)
13216	1122	(1.8660254037844386,22)
13217	1204	(3.598076211353316,23.5)
13218	2159	(34.341978045700891,40.75)
13219	2028	(24.382685902179844,38.5)
13220	1122	(1.8660254037844386,22)
13221	1952	(27.846787517317598,37)
13222	1152	(27.846787517317598,22)
13223	1222	(19.186533479473212,23.5)
13224	1220	(17.454482671904334,23.5)
13225	1220	(17.454482671904334,23.5)
13226	1579	(17.021469970012117,30.25)
13227	1619	(16.588457268119896,31)
13228	1579	(17.021469970012117,30.25)
13229	1614	(12.258330249197702,31)
13230	1614	(12.258330249197702,31)
13231	1957	(32.176914536239792,37)
13232	1476	(31.310889132455351,28)
13233	1753	(29.145825622994256,33.25)
13234	1715	(30.444863728670914,32.5)
13235	1718	(33.042939940024233,32.5)
13236	1760	(35.208003449485325,33.25)
13237	1680	(35.208003449485325,31.75)
13238	1476	(31.310889132455351,28)
13239	1753	(29.145825622994256,33.25)
13240	1715	(30.444863728670914,32.5)
13241	1718	(33.042939940024233,32.5)
13242	1760	(35.208003449485325,33.25)
13243	1680	(35.208003449485325,31.75)
13244	1476	(31.310889132455351,28)
13245	1753	(29.145825622994256,33.25)
13246	1715	(30.444863728670914,32.5)
13247	1718	(33.042939940024233,32.5)
13248	1760	(35.208003449485325,33.25)
13249	1680	(35.208003449485325,31.75)
13250	1680	(35.208003449485325,31.75)
13251	1160	(34.774990747593108,22)
13252	1160	(34.774990747593108,22)
13253	1360	(35.208003449485325,25.75)
13254	2317	(32.609927238132009,43.75)
13255	2269	(25.248711305964282,43)
13256	2358	(33.042939940024233,44.5)
13257	1356	(31.743901834347572,25.75)
13258	1240	(34.774990747593108,23.5)
13259	1240	(34.774990747593108,23.5)
13260	1598	(33.47595264191645,30.25)
13261	1600	(35.208003449485325,30.25)
13262	2150	(26.54774941164094,40.75)
13263	1572	(10.959292143521045,30.25)
13264	2071	(27.413774815425377,39.25)
13265	2400	(35.208003449485325,45.25)
13266	1355	(30.877876430563134,25.75)
13267	1949	(25.248711305964282,37)
13268	2399	(34.341978045700891,45.25)
13269	2279	(33.908965343808667,43)
13270	412	(10.526279441628825,8.5)
13271	1147	(23.516660498395403,22)
13272	1026	(23.083647796503186,19.75)
13273	1062	(19.186533479473212,20.5)
13274	1062	(19.186533479473212,20.5)
13275	1234	(29.578838324886476,23.5)
13276	1234	(29.578838324886476,23.5)
13277	1234	(29.578838324886476,23.5)
13278	1234	(29.578838324886476,23.5)
13279	586	(22.650635094610966,11.5)
13280	586	(22.650635094610966,11.5)
13281	586	(22.650635094610966,11.5)
13282	586	(22.650635094610966,11.5)
13283	665	(21.784609690826528,13)
13284	662	(19.186533479473212,13)
13285	661	(18.320508075688775,13)
13286	661	(18.320508075688775,13)
13287	701	(18.753520777580992,13.75)
13288	662	(19.186533479473212,13)
13289	1465	(21.784609690826528,28)
13290	1424	(21.351596988934308,27.25)
13291	1622	(19.186533479473212,31)
13292	1622	(19.186533479473212,31)
13293	1623	(20.05255888325765,31)
13294	2098	(15.722431864335457,40)
13295	2098	(15.722431864335457,40)
13296	1934	(12.258330249197702,37)
13297	2178	(15.722431864335457,41.5)
13298	2178	(15.722431864335457,41.5)
13299	2136	(14.423393758658799,40.75)
13300	2136	(14.423393758658799,40.75)
13301	2257	(14.856406460551018,43)
13302	2257	(14.856406460551018,43)
13303	1779	(16.588457268119896,34)
13304	2394	(30.011851026778693,45.25)
13305	2353	(28.712812921102035,44.5)
13306	2352	(27.846787517317598,44.5)
13307	2392	(28.279800219209818,45.25)
13308	2392	(28.279800219209818,45.25)
13309	2392	(28.279800219209818,45.25)
13310	2392	(28.279800219209818,45.25)
13311	2395	(30.877876430563134,45.25)
13312	2396	(31.743901834347572,45.25)
13313	2279	(33.908965343808667,43)
13314	2279	(33.908965343808667,43)
13315	2279	(33.908965343808667,43)
13316	2279	(33.908965343808667,43)
13317	2279	(33.908965343808667,43)
13318	2397	(32.609927238132009,45.25)
13319	2396	(31.743901834347572,45.25)
13320	1779	(16.588457268119896,34)
13321	1822	(19.619546181365433,34.75)
13322	1897	(15.289419162443238,36.25)
13323	1776	(13.99038105676658,34)
13324	1889	(8.3612159321677293,36.25)
13325	1779	(16.588457268119896,34)
13326	1889	(8.3612159321677293,36.25)
13327	1977	(15.289419162443238,37.75)
13328	1858	(15.722431864335457,35.5)
13329	2055	(13.55736835487436,39.25)
13330	1980	(17.887495373796554,37.75)
13331	1899	(17.021469970012117,36.25)
13332	2214	(12.691342951089922,42.25)
13333	1968	(7.49519052838329,37.75)
13334	2134	(12.691342951089922,40.75)
13335	1977	(15.289419162443238,37.75)
13336	1929	(7.9282032302755088,37)
13337	1776	(13.99038105676658,34)
13338	2170	(8.794228634059948,41.5)
13339	2086	(5.3301270189221936,40)
13340	1924	(3.598076211353316,37)
13341	2121	(1.4330127018922194,40.75)
13342	2170	(8.794228634059948,41.5)
13343	2086	(5.3301270189221936,40)
13344	1924	(3.598076211353316,37)
13345	2121	(1.4330127018922194,40.75)
13346	2044	(4.0310889132455356,39.25)
13347	2044	(4.0310889132455356,39.25)
13348	2060	(17.887495373796554,39.25)
13349	21	(18.320508075688775,1)
13350	99	(16.588457268119896,2.5)
13351	17	(14.856406460551018,1)
13352	178	(15.722431864335457,4)
13353	10	(8.794228634059948,1)
13354	1137	(14.856406460551018,22)
13355	1137	(14.856406460551018,22)
13356	10	(8.794228634059948,1)
13357	11	(9.6602540378443873,1)
13358	10	(8.794228634059948,1)
13359	11	(9.6602540378443873,1)
13360	2299	(17.021469970012117,43.75)
13361	2388	(24.815698604072061,45.25)
13362	2181	(18.320508075688775,41.5)
13363	2388	(24.815698604072061,45.25)
13364	2385	(22.217622392718749,45.25)
13365	2347	(23.516660498395403,44.5)
13366	2347	(23.516660498395403,44.5)
13367	2347	(23.516660498395403,44.5)
13368	2306	(23.083647796503186,43.75)
13369	2385	(22.217622392718749,45.25)
13370	2264	(20.918584287042091,43)
13371	2264	(20.918584287042091,43)
13372	2345	(21.784609690826528,44.5)
13373	2306	(23.083647796503186,43.75)
13374	2303	(20.48557158514987,43.75)
13375	2305	(22.217622392718749,43.75)
13376	2384	(21.351596988934308,45.25)
13377	2304	(21.351596988934308,43.75)
13378	1258	(16.155444566227676,24.25)
13379	1298	(15.722431864335457,25)
13380	1306	(22.650635094610966,25)
13381	632	(28.279800219209818,12.25)
13382	632	(28.279800219209818,12.25)
13383	672	(27.846787517317598,13)
13384	672	(27.846787517317598,13)
13385	396	(31.743901834347572,7.75)
13386	396	(31.743901834347572,7.75)
13387	398	(33.47595264191645,7.75)
13388	398	(33.47595264191645,7.75)
13389	439	(33.908965343808667,8.5)
13390	439	(33.908965343808667,8.5)
13391	360	(34.774990747593108,7)
13392	320	(35.208003449485325,6.25)
13393	105	(21.784609690826528,2.5)
13394	632	(28.279800219209818,12.25)
13395	269	(25.248711305964282,5.5)
13396	229	(25.681724007856502,4.75)
13397	438	(33.042939940024233,8.5)
13398	438	(33.042939940024233,8.5)
13399	438	(33.042939940024233,8.5)
13400	360	(34.774990747593108,7)
13401	1393	(28.712812921102035,26.5)
13402	1352	(28.279800219209818,25.75)
13403	1390	(26.114736709748719,26.5)
13404	1470	(26.114736709748719,28)
13405	1508	(24.815698604072061,28.75)
13406	1545	(21.784609690826528,29.5)
13407	1508	(24.815698604072061,28.75)
13408	1158	(33.042939940024233,22)
13409	1158	(33.042939940024233,22)
13410	840	(34.774990747593108,16)
13411	840	(34.774990747593108,16)
13412	1623	(20.05255888325765,31)
13413	396	(31.743901834347572,7.75)
13414	396	(31.743901834347572,7.75)
13415	398	(33.47595264191645,7.75)
13416	398	(33.47595264191645,7.75)
13417	398	(33.47595264191645,7.75)
13418	439	(33.908965343808667,8.5)
13419	360	(34.774990747593108,7)
13420	320	(35.208003449485325,6.25)
13421	105	(21.784609690826528,2.5)
13422	511	(26.98076211353316,10)
13423	269	(25.248711305964282,5.5)
13424	269	(25.248711305964282,5.5)
13425	438	(33.042939940024233,8.5)
13426	438	(33.042939940024233,8.5)
13427	438	(33.042939940024233,8.5)
13428	360	(34.774990747593108,7)
13429	560	(35.208003449485325,10.75)
13430	958	(33.47595264191645,18.25)
13431	560	(35.208003449485325,10.75)
13432	960	(35.208003449485325,18.25)
13433	960	(35.208003449485325,18.25)
13434	1158	(33.042939940024233,22)
13435	1158	(33.042939940024233,22)
13436	840	(34.774990747593108,16)
13437	840	(34.774990747593108,16)
13438	1480	(34.774990747593108,28)
13439	1157	(32.176914536239792,22)
13440	1157	(32.176914536239792,22)
13441	1157	(32.176914536239792,22)
13442	1157	(32.176914536239792,22)
13443	1359	(34.341978045700891,25.75)
13444	629	(25.681724007856502,12.25)
13445	629	(25.681724007856502,12.25)
13446	629	(25.681724007856502,12.25)
13447	629	(25.681724007856502,12.25)
13448	629	(25.681724007856502,12.25)
13449	1393	(28.712812921102035,26.5)
13450	1352	(28.279800219209818,25.75)
13451	1390	(26.114736709748719,26.5)
13452	1470	(26.114736709748719,28)
13453	1508	(24.815698604072061,28.75)
13454	1545	(21.784609690826528,29.5)
13455	1508	(24.815698604072061,28.75)
13456	1623	(20.05255888325765,31)
13457	39	(33.908965343808667,1)
13458	959	(34.341978045700891,18.25)
13459	959	(34.341978045700891,18.25)
13460	200	(34.774990747593108,4)
13461	39	(33.908965343808667,1)
13462	160	(35.208003449485325,3.25)
13463	240	(35.208003449485325,4.75)
13464	240	(35.208003449485325,4.75)
13465	423	(20.05255888325765,8.5)
13466	425	(21.784609690826528,8.5)
13467	505	(21.784609690826528,10)
13468	505	(21.784609690826528,10)
13469	344	(20.918584287042091,7)
13470	794	(30.011851026778693,15.25)
13471	835	(30.444863728670914,16)
13472	875	(30.877876430563134,16.75)
13473	834	(29.578838324886476,16)
13474	834	(29.578838324886476,16)
13475	2233	(29.145825622994256,42.25)
13476	127	(6.6291651245988508,3.25)
13477	7	(6.196152422706632,1)
13478	7	(6.196152422706632,1)
13479	88	(7.0621778264910704,2.5)
13480	7	(6.196152422706632,1)
13481	82	(1.8660254037844386,2.5)
13482	356	(31.310889132455351,7)
13483	358	(33.042939940024233,7)
13484	358	(33.042939940024233,7)
13485	358	(33.042939940024233,7)
13486	320	(35.208003449485325,6.25)
13487	358	(33.042939940024233,7)
13488	788	(24.815698604072061,15.25)
13489	785	(22.217622392718749,15.25)
13490	787	(23.949673200287624,15.25)
13491	1641	(1.4330127018922194,31.75)
13492	1021	(18.753520777580992,19.75)
13493	2157	(32.609927238132009,40.75)
13494	1960	(34.774990747593108,37)
13495	1365	(4.4641016151377544,26.5)
13496	1401	(1.4330127018922194,27.25)
13497	1641	(1.4330127018922194,31.75)
13498	1641	(1.4330127018922194,31.75)
13499	2026	(22.650635094610966,38.5)
13500	2025	(21.784609690826528,38.5)
13501	1481	(1.4330127018922194,28.75)
13502	834	(29.578838324886476,16)
13503	752	(27.846787517317598,14.5)
13504	794	(30.011851026778693,15.25)
13505	835	(30.444863728670914,16)
13506	875	(30.877876430563134,16.75)
13507	834	(29.578838324886476,16)
13508	752	(27.846787517317598,14.5)
13509	792	(28.279800219209818,15.25)
13510	792	(28.279800219209818,15.25)
13511	792	(28.279800219209818,15.25)
13512	752	(27.846787517317598,14.5)
13513	1041	(1,20.5)
13514	1163	(3.1650635094610968,22.75)
13515	1122	(1.8660254037844386,22)
13516	1122	(1.8660254037844386,22)
13517	1163	(3.1650635094610968,22.75)
13518	1240	(34.774990747593108,23.5)
13519	1240	(34.774990747593108,23.5)
13520	1360	(35.208003449485325,25.75)
13521	1440	(35.208003449485325,27.25)
13522	1598	(33.47595264191645,30.25)
13523	1600	(35.208003449485325,30.25)
13524	1641	(1.4330127018922194,31.75)
13525	2279	(33.908965343808667,43)
13526	490	(8.794228634059948,10)
13527	531	(10.093266739736606,10.75)
13528	531	(10.093266739736606,10.75)
13529	2225	(22.217622392718749,42.25)
13530	485	(4.4641016151377544,10)
13531	682	(2.299038105676658,13.75)
13532	1128	(7.0621778264910704,22)
13533	1128	(7.0621778264910704,22)
13534	1169	(8.3612159321677293,22.75)
13535	1128	(7.0621778264910704,22)
13536	1363	(2.7320508075688772,26.5)
13537	1281	(1,25)
13538	1283	(2.7320508075688772,25)
13539	1283	(2.7320508075688772,25)
13540	1241	(1.4330127018922194,24.25)
13541	1241	(1.4330127018922194,24.25)
13542	1241	(1.4330127018922194,24.25)
13543	849	(8.3612159321677293,16.75)
13544	1362	(1.8660254037844386,26.5)
13545	1321	(1.4330127018922194,25.75)
13546	1241	(1.4330127018922194,24.25)
13547	1241	(1.4330127018922194,24.25)
13548	1241	(1.4330127018922194,24.25)
13549	1121	(1,22)
13550	1241	(1.4330127018922194,24.25)
13551	1121	(1,22)
13552	1281	(1,25)
13553	1281	(1,25)
13554	1241	(1.4330127018922194,24.25)
13555	613	(11.825317547305483,12.25)
13556	1610	(8.794228634059948,31)
13557	1591	(27.413774815425377,30.25)
13558	1626	(22.650635094610966,31)
13559	1626	(22.650635094610966,31)
13560	1669	(25.681724007856502,31.75)
13561	1670	(26.54774941164094,31.75)
13562	1670	(26.54774941164094,31.75)
13563	1669	(25.681724007856502,31.75)
13564	1669	(25.681724007856502,31.75)
13565	1669	(25.681724007856502,31.75)
13566	1703	(20.05255888325765,32.5)
13567	1592	(28.279800219209818,30.25)
13568	1591	(27.413774815425377,30.25)
13569	1704	(20.918584287042091,32.5)
13570	1704	(20.918584287042091,32.5)
13571	1704	(20.918584287042091,32.5)
13572	1704	(20.918584287042091,32.5)
13573	1833	(29.145825622994256,34.75)
13574	1534	(12.258330249197702,29.5)
13575	1660	(17.887495373796554,31.75)
13576	2371	(10.093266739736606,45.25)
13577	2371	(10.093266739736606,45.25)
13578	816	(13.99038105676658,16)
13579	814	(12.258330249197702,16)
13580	734	(12.258330249197702,14.5)
13581	814	(12.258330249197702,16)
13582	854	(12.691342951089922,16.75)
13583	980	(17.454482671904334,19)
13584	936	(14.423393758658799,18.25)
13585	936	(14.423393758658799,18.25)
13586	1054	(12.258330249197702,20.5)
13587	1054	(12.258330249197702,20.5)
13588	1054	(12.258330249197702,20.5)
13589	938	(16.155444566227676,18.25)
13590	1057	(14.856406460551018,20.5)
13591	938	(16.155444566227676,18.25)
13592	1054	(12.258330249197702,20.5)
13593	782	(19.619546181365433,15.25)
13594	256	(13.99038105676658,5.5)
13595	336	(13.99038105676658,7)
13596	819	(16.588457268119896,16)
13597	1652	(10.959292143521045,31.75)
13598	2035	(30.444863728670914,38.5)
13599	2071	(27.413774815425377,39.25)
13600	2071	(27.413774815425377,39.25)
13601	2071	(27.413774815425377,39.25)
13602	1604	(3.598076211353316,31)
13603	1561	(1.4330127018922194,30.25)
13604	1988	(24.815698604072061,37.75)
13605	1572	(10.959292143521045,30.25)
13606	1488	(7.49519052838329,28.75)
13607	690	(9.2272413359521668,13.75)
13608	1877	(32.176914536239792,35.5)
13609	1879	(33.908965343808667,35.5)
13610	1955	(30.444863728670914,37)
13611	2040	(34.774990747593108,38.5)
13612	2159	(34.341978045700891,40.75)
13613	2194	(29.578838324886476,41.5)
13614	2154	(30.011851026778693,40.75)
13615	2157	(32.609927238132009,40.75)
13616	1960	(34.774990747593108,37)
13617	2196	(31.310889132455351,41.5)
13618	586	(22.650635094610966,11.5)
13619	586	(22.650635094610966,11.5)
13620	586	(22.650635094610966,11.5)
13621	624	(21.351596988934308,12.25)
13622	624	(21.351596988934308,12.25)
13623	622	(19.619546181365433,12.25)
13624	536	(14.423393758658799,10.75)
13625	536	(14.423393758658799,10.75)
13626	617	(15.289419162443238,12.25)
13627	1147	(23.516660498395403,22)
13628	866	(23.083647796503186,16.75)
13629	1106	(23.083647796503186,21.25)
13630	905	(21.784609690826528,17.5)
13631	1225	(21.784609690826528,23.5)
13632	1068	(24.382685902179844,20.5)
13633	21	(18.320508075688775,1)
13634	60	(17.887495373796554,1.75)
13635	101	(18.320508075688775,2.5)
13636	60	(17.887495373796554,1.75)
13637	179	(16.588457268119896,4)
13638	138	(16.155444566227676,3.25)
13639	10	(8.794228634059948,1)
13640	784	(21.351596988934308,15.25)
13641	11	(9.6602540378443873,1)
13642	784	(21.351596988934308,15.25)
13643	51	(10.093266739736606,1.75)
13644	748	(24.382685902179844,14.5)
13645	787	(23.949673200287624,15.25)
13646	827	(23.516660498395403,16)
13647	12	(10.526279441628825,1)
13648	1113	(29.145825622994256,21.25)
13649	1219	(16.588457268119896,23.5)
13650	1191	(27.413774815425377,22.75)
13651	1152	(27.846787517317598,22)
13652	1220	(17.454482671904334,23.5)
13653	1220	(17.454482671904334,23.5)
13654	1220	(17.454482671904334,23.5)
13655	2376	(14.423393758658799,45.25)
13656	2376	(14.423393758658799,45.25)
13657	2376	(14.423393758658799,45.25)
13658	2370	(9.2272413359521668,45.25)
13659	2377	(15.289419162443238,45.25)
13660	2376	(14.423393758658799,45.25)
13661	1844	(3.598076211353316,35.5)
13662	2372	(10.959292143521045,45.25)
13663	2376	(14.423393758658799,45.25)
13664	425	(21.784609690826528,8.5)
13665	505	(21.784609690826528,10)
13666	344	(20.918584287042091,7)
13667	461	(18.753520777580992,9.25)
13668	461	(18.753520777580992,9.25)
13669	1342	(19.619546181365433,25.75)
13670	1352	(28.279800219209818,25.75)
13671	1352	(28.279800219209818,25.75)
13672	1390	(26.114736709748719,26.5)
13673	1470	(26.114736709748719,28)
13674	1313	(28.712812921102035,25)
13675	1312	(27.846787517317598,25)
13676	1470	(26.114736709748719,28)
13677	1470	(26.114736709748719,28)
13678	1544	(20.918584287042091,29.5)
13679	1623	(20.05255888325765,31)
13680	1470	(26.114736709748719,28)
13681	1470	(26.114736709748719,28)
13682	1277	(32.609927238132009,24.25)
13683	1476	(31.310889132455351,28)
13684	1753	(29.145825622994256,33.25)
13685	1715	(30.444863728670914,32.5)
13686	1717	(32.176914536239792,32.5)
13687	1759	(34.341978045700891,33.25)
13688	1680	(35.208003449485325,31.75)
13689	1715	(30.444863728670914,32.5)
13690	1197	(32.609927238132009,22.75)
13691	957	(32.609927238132009,18.25)
13692	1398	(33.042939940024233,26.5)
13693	1439	(34.341978045700891,27.25)
13694	190	(26.114736709748719,4)
13695	596	(31.310889132455351,11.5)
13696	553	(29.145825622994256,10.75)
13697	70	(26.54774941164094,1.75)
13698	231	(27.413774815425377,4.75)
13699	70	(26.54774941164094,1.75)
13700	231	(27.413774815425377,4.75)
13701	231	(27.413774815425377,4.75)
13702	70	(26.54774941164094,1.75)
13703	70	(26.54774941164094,1.75)
13704	275	(30.444863728670914,5.5)
13705	514	(29.578838324886476,10)
13706	514	(29.578838324886476,10)
13707	473	(29.145825622994256,9.25)
13708	271	(26.98076211353316,5.5)
13709	1356	(31.743901834347572,25.75)
13710	1160	(34.774990747593108,22)
13711	1160	(34.774990747593108,22)
13712	1360	(35.208003449485325,25.75)
13713	2317	(32.609927238132009,43.75)
13714	2269	(25.248711305964282,43)
13715	2358	(33.042939940024233,44.5)
13716	1356	(31.743901834347572,25.75)
13717	2269	(25.248711305964282,43)
13718	2188	(24.382685902179844,41.5)
13719	2227	(23.949673200287624,42.25)
13720	2225	(22.217622392718749,42.25)
13721	2200	(34.774990747593108,41.5)
13722	2187	(23.516660498395403,41.5)
13723	2400	(35.208003449485325,45.25)
13724	2319	(34.341978045700891,43.75)
13725	2187	(23.516660498395403,41.5)
13726	160	(35.208003449485325,3.25)
13727	38	(33.042939940024233,1)
13728	80	(35.208003449485325,1.75)
13729	160	(35.208003449485325,3.25)
13730	80	(35.208003449485325,1.75)
13731	160	(35.208003449485325,3.25)
13732	1869	(25.248711305964282,35.5)
13733	2359	(33.908965343808667,44.5)
13734	2279	(33.908965343808667,43)
13735	70	(26.54774941164094,1.75)
13736	70	(26.54774941164094,1.75)
13737	792	(28.279800219209818,15.25)
13738	1538	(15.722431864335457,29.5)
13739	1619	(16.588457268119896,31)
13740	1240	(34.774990747593108,23.5)
13741	1360	(35.208003449485325,25.75)
13742	1597	(32.609927238132009,30.25)
13743	1600	(35.208003449485325,30.25)
13744	1355	(30.877876430563134,25.75)
13745	1725	(4.897114317029974,33.25)
13746	1684	(3.598076211353316,32.5)
13747	1724	(4.0310889132455356,33.25)
13748	2320	(35.208003449485325,43.75)
13749	682	(2.299038105676658,13.75)
13750	2104	(20.918584287042091,40)
13751	2104	(20.918584287042091,40)
13752	1008	(7.49519052838329,19.75)
13753	1204	(3.598076211353316,23.5)
13754	1204	(3.598076211353316,23.5)
13755	2104	(20.918584287042091,40)
13756	1342	(19.619546181365433,25.75)
13757	1298	(15.722431864335457,25)
13758	1343	(20.48557158514987,25.75)
13759	1342	(19.619546181365433,25.75)
13760	1306	(22.650635094610966,25)
13761	1306	(22.650635094610966,25)
13762	1306	(22.650635094610966,25)
13763	514	(29.578838324886476,10)
13764	230	(26.54774941164094,4.75)
13765	271	(26.98076211353316,5.5)
13766	1237	(32.176914536239792,23.5)
13767	957	(32.609927238132009,18.25)
13768	917	(32.176914536239792,17.5)
13769	38	(33.042939940024233,1)
13770	39	(33.908965343808667,1)
13771	39	(33.908965343808667,1)
13772	425	(21.784609690826528,8.5)
13773	505	(21.784609690826528,10)
13774	344	(20.918584287042091,7)
13775	669	(25.248711305964282,13)
13776	669	(25.248711305964282,13)
13777	669	(25.248711305964282,13)
13778	36	(31.310889132455351,1)
13779	36	(31.310889132455351,1)
13780	37	(32.176914536239792,1)
13781	240	(35.208003449485325,4.75)
13782	1237	(32.176914536239792,23.5)
13783	957	(32.609927238132009,18.25)
13784	878	(33.47595264191645,16.75)
13785	39	(33.908965343808667,1)
13786	240	(35.208003449485325,4.75)
13787	24	(20.918584287042091,1)
13788	1680	(35.208003449485325,31.75)
13789	1680	(35.208003449485325,31.75)
13790	1480	(34.774990747593108,28)
13791	954	(30.011851026778693,18.25)
13792	954	(30.011851026778693,18.25)
13793	954	(30.011851026778693,18.25)
13794	991	(26.98076211353316,19)
13795	991	(26.98076211353316,19)
13796	990	(26.114736709748719,19)
13797	948	(24.815698604072061,18.25)
13798	948	(24.815698604072061,18.25)
13799	943	(20.48557158514987,18.25)
13800	835	(30.444863728670914,16)
13801	875	(30.877876430563134,16.75)
13802	752	(27.846787517317598,14.5)
13803	792	(28.279800219209818,15.25)
13804	792	(28.279800219209818,15.25)
13805	2037	(32.176914536239792,38.5)
13806	1230	(26.114736709748719,23.5)
13807	845	(4.897114317029974,16.75)
13808	806	(5.3301270189221936,16)
13809	2233	(29.145825622994256,42.25)
13810	70	(26.54774941164094,1.75)
13811	70	(26.54774941164094,1.75)
13812	303	(20.48557158514987,6.25)
13813	303	(20.48557158514987,6.25)
13814	223	(20.48557158514987,4.75)
13815	223	(20.48557158514987,4.75)
13816	341	(18.320508075688775,7)
13817	339	(16.588457268119896,7)
13818	300	(17.887495373796554,6.25)
13819	1	(1,1)
13820	1	(1,1)
13821	1	(1,1)
13822	41	(1.4330127018922194,1.75)
13823	7	(6.196152422706632,1)
13824	44	(4.0310889132455356,1.75)
13825	44	(4.0310889132455356,1.75)
13826	165	(4.4641016151377544,4)
13827	201	(1.4330127018922194,4.75)
13828	201	(1.4330127018922194,4.75)
13829	201	(1.4330127018922194,4.75)
13830	161	(1,4)
13831	161	(1,4)
13832	282	(2.299038105676658,6.25)
13833	162	(1.8660254037844386,4)
13834	201	(1.4330127018922194,4.75)
13835	201	(1.4330127018922194,4.75)
13836	2181	(18.320508075688775,41.5)
13837	2261	(18.320508075688775,43)
13838	2299	(17.021469970012117,43.75)
13839	2301	(18.753520777580992,43.75)
13840	2181	(18.320508075688775,41.5)
13841	2388	(24.815698604072061,45.25)
13842	2243	(2.7320508075688772,43)
13843	2243	(2.7320508075688772,43)
13844	2262	(19.186533479473212,43)
13845	2346	(22.650635094610966,44.5)
13846	2347	(23.516660498395403,44.5)
13847	2367	(6.6291651245988508,45.25)
13848	2304	(21.351596988934308,43.75)
13849	2380	(17.887495373796554,45.25)
13850	2380	(17.887495373796554,45.25)
13851	2281	(1.4330127018922194,43.75)
13852	2281	(1.4330127018922194,43.75)
13853	2241	(1,43)
13854	2281	(1.4330127018922194,43.75)
13855	1899	(17.021469970012117,36.25)
13856	1814	(12.691342951089922,34.75)
13857	1854	(12.258330249197702,35.5)
13858	1980	(17.887495373796554,37.75)
13859	1981	(18.753520777580992,37.75)
13860	1980	(17.887495373796554,37.75)
13861	1980	(17.887495373796554,37.75)
13862	1776	(13.99038105676658,34)
13863	1925	(4.4641016151377544,37)
13864	2060	(17.887495373796554,39.25)
13865	2216	(14.423393758658799,42.25)
13866	2134	(12.691342951089922,40.75)
13867	1923	(2.7320508075688772,37)
13868	1929	(7.9282032302755088,37)
13869	2011	(9.6602540378443873,38.5)
13870	1886	(5.7631397208144124,36.25)
13871	2170	(8.794228634059948,41.5)
13872	2011	(9.6602540378443873,38.5)
13873	1961	(1.4330127018922194,37.75)
13874	1891	(10.093266739736606,36.25)
13875	1973	(11.825317547305483,37.75)
13876	2051	(10.093266739736606,39.25)
13877	2081	(1,40)
13878	1961	(1.4330127018922194,37.75)
13879	2041	(1.4330127018922194,39.25)
13880	2170	(8.794228634059948,41.5)
13881	2050	(9.2272413359521668,39.25)
13882	2041	(1.4330127018922194,39.25)
13883	1961	(1.4330127018922194,37.75)
13884	2041	(1.4330127018922194,39.25)
13885	2121	(1.4330127018922194,40.75)
13886	2044	(4.0310889132455356,39.25)
13887	1822	(19.619546181365433,34.75)
13888	2081	(1,40)
13889	2004	(3.598076211353316,38.5)
13890	2004	(3.598076211353316,38.5)
13891	1885	(4.897114317029974,36.25)
13892	1844	(3.598076211353316,35.5)
13893	2279	(33.908965343808667,43)
13894	2279	(33.908965343808667,43)
13895	1902	(19.619546181365433,36.25)
13896	2397	(32.609927238132009,45.25)
13897	2342	(19.186533479473212,44.5)
13898	2394	(30.011851026778693,45.25)
13899	2392	(28.279800219209818,45.25)
13900	2392	(28.279800219209818,45.25)
13901	2392	(28.279800219209818,45.25)
13902	2392	(28.279800219209818,45.25)
13903	2392	(28.279800219209818,45.25)
13904	2279	(33.908965343808667,43)
13905	1253	(11.825317547305483,24.25)
13906	2395	(30.877876430563134,45.25)
13907	1872	(27.846787517317598,35.5)
13908	1494	(12.691342951089922,28.75)
13909	570	(8.794228634059948,11.5)
13910	1911	(27.413774815425377,36.25)
13911	612	(10.959292143521045,12.25)
13912	1830	(26.54774941164094,34.75)
13913	1600	(35.208003449485325,30.25)
13914	1981	(18.753520777580992,37.75)
13915	874	(30.011851026778693,16.75)
13916	505	(21.784609690826528,10)
13917	285	(4.897114317029974,6.25)
13918	210	(9.2272413359521668,4.75)
13919	251	(9.6602540378443873,5.5)
13920	251	(9.6602540378443873,5.5)
13921	251	(9.6602540378443873,5.5)
13922	330	(8.794228634059948,7)
13923	251	(9.6602540378443873,5.5)
13924	2157	(32.609927238132009,40.75)
13925	2156	(31.743901834347572,40.75)
13926	2194	(29.578838324886476,41.5)
13927	2154	(30.011851026778693,40.75)
13928	2200	(34.774990747593108,41.5)
13929	2154	(30.011851026778693,40.75)
13930	1968	(7.49519052838329,37.75)
13931	2279	(33.908965343808667,43)
13932	490	(8.794228634059948,10)
13933	609	(8.3612159321677293,12.25)
13934	568	(7.0621778264910704,11.5)
13935	607	(6.6291651245988508,12.25)
13936	1453	(11.392304845413264,28)
13937	723	(2.7320508075688772,14.5)
13938	723	(2.7320508075688772,14.5)
13939	682	(2.299038105676658,13.75)
13940	568	(7.0621778264910704,11.5)
13941	607	(6.6291651245988508,12.25)
13942	682	(2.299038105676658,13.75)
13943	682	(2.299038105676658,13.75)
13944	1169	(8.3612159321677293,22.75)
13945	1169	(8.3612159321677293,22.75)
13946	1169	(8.3612159321677293,22.75)
13947	1088	(7.49519052838329,21.25)
13948	1088	(7.49519052838329,21.25)
13949	1088	(7.49519052838329,21.25)
13950	762	(2.299038105676658,15.25)
13951	762	(2.299038105676658,15.25)
13952	762	(2.299038105676658,15.25)
13953	803	(2.7320508075688772,16)
13954	762	(2.299038105676658,15.25)
13955	762	(2.299038105676658,15.25)
13956	963	(2.7320508075688772,19)
13957	1048	(7.0621778264910704,20.5)
13958	963	(2.7320508075688772,19)
13959	1321	(1.4330127018922194,25.75)
13960	1321	(1.4330127018922194,25.75)
13961	1281	(1,25)
13962	1241	(1.4330127018922194,24.25)
13963	1241	(1.4330127018922194,24.25)
13964	1121	(1,22)
13965	485	(4.4641016151377544,10)
13966	1413	(11.825317547305483,27.25)
13967	485	(4.4641016151377544,10)
13968	1494	(12.691342951089922,28.75)
13969	448	(7.49519052838329,9.25)
13970	613	(11.825317547305483,12.25)
13971	1564	(4.0310889132455356,30.25)
13972	1681	(1,32.5)
13973	1564	(4.0310889132455356,30.25)
13974	1743	(20.48557158514987,33.25)
13975	1704	(20.918584287042091,32.5)
13976	1704	(20.918584287042091,32.5)
13977	1704	(20.918584287042091,32.5)
13978	1592	(28.279800219209818,30.25)
13979	1591	(27.413774815425377,30.25)
13980	1591	(27.413774815425377,30.25)
13981	1669	(25.681724007856502,31.75)
13982	1670	(26.54774941164094,31.75)
13983	1627	(23.516660498395403,31)
13984	1626	(22.650635094610966,31)
13985	1626	(22.650635094610966,31)
13986	1666	(23.083647796503186,31.75)
13987	814	(12.258330249197702,16)
13988	734	(12.258330249197702,14.5)
13989	734	(12.258330249197702,14.5)
13990	734	(12.258330249197702,14.5)
13991	892	(10.526279441628825,17.5)
13992	734	(12.258330249197702,14.5)
13993	934	(12.691342951089922,18.25)
13994	893	(11.392304845413264,17.5)
13995	734	(12.258330249197702,14.5)
13996	936	(14.423393758658799,18.25)
13997	1055	(13.124355652982141,20.5)
13998	773	(11.825317547305483,15.25)
13999	975	(13.124355652982141,19)
14000	936	(14.423393758658799,18.25)
14001	1055	(13.124355652982141,20.5)
14002	975	(13.124355652982141,19)
14003	1054	(12.258330249197702,20.5)
14004	1054	(12.258330249197702,20.5)
14005	938	(16.155444566227676,18.25)
14006	1057	(14.856406460551018,20.5)
14007	1833	(29.145825622994256,34.75)
14008	1154	(29.578838324886476,22)
14009	1140	(17.454482671904334,22)
14010	1831	(27.413774815425377,34.75)
14011	1534	(12.258330249197702,29.5)
14012	1573	(11.825317547305483,30.25)
14013	2331	(9.6602540378443873,44.5)
14014	1701	(18.320508075688775,32.5)
14015	1660	(17.887495373796554,31.75)
14016	586	(22.650635094610966,11.5)
14017	622	(19.619546181365433,12.25)
14018	701	(18.753520777580992,13.75)
14019	536	(14.423393758658799,10.75)
14020	536	(14.423393758658799,10.75)
14021	659	(16.588457268119896,13)
14022	617	(15.289419162443238,12.25)
14023	1185	(22.217622392718749,22.75)
14024	1104	(21.351596988934308,21.25)
14025	905	(21.784609690826528,17.5)
14026	1098	(16.155444566227676,21.25)
14027	1098	(16.155444566227676,21.25)
14028	94	(12.258330249197702,2.5)
14029	133	(11.825317547305483,3.25)
14030	175	(13.124355652982141,4)
14031	13	(11.392304845413264,1)
14032	175	(13.124355652982141,4)
14033	215	(13.55736835487436,4.75)
14034	13	(11.392304845413264,1)
14035	13	(11.392304845413264,1)
14036	336	(13.99038105676658,7)
14037	214	(12.691342951089922,4.75)
14038	13	(11.392304845413264,1)
14039	13	(11.392304845413264,1)
14040	737	(14.856406460551018,14.5)
14041	786	(23.083647796503186,15.25)
14042	827	(23.516660498395403,16)
14043	787	(23.949673200287624,15.25)
14044	787	(23.949673200287624,15.25)
14045	788	(24.815698604072061,15.25)
14046	748	(24.382685902179844,14.5)
14047	871	(27.413774815425377,16.75)
14048	1112	(28.279800219209818,21.25)
14049	1140	(17.454482671904334,22)
14050	1152	(27.846787517317598,22)
14051	1220	(17.454482671904334,23.5)
14052	1219	(16.588457268119896,23.5)
14053	1220	(17.454482671904334,23.5)
14054	1220	(17.454482671904334,23.5)
14055	2376	(14.423393758658799,45.25)
14056	2377	(15.289419162443238,45.25)
14057	2376	(14.423393758658799,45.25)
14058	2376	(14.423393758658799,45.25)
14059	2337	(14.856406460551018,44.5)
14060	2035	(30.444863728670914,38.5)
14061	2035	(30.444863728670914,38.5)
14062	2071	(27.413774815425377,39.25)
14063	2071	(27.413774815425377,39.25)
14064	2071	(27.413774815425377,39.25)
14065	2066	(23.083647796503186,39.25)
14066	1523	(2.7320508075688772,29.5)
14067	1608	(7.0621778264910704,31)
14068	1605	(4.4641016151377544,31)
14069	2026	(22.650635094610966,38.5)
14070	1604	(3.598076211353316,31)
14071	1949	(25.248711305964282,37)
14072	1948	(24.382685902179844,37)
14073	1277	(32.609927238132009,24.25)
14074	2040	(34.774990747593108,38.5)
14075	2040	(34.774990747593108,38.5)
14076	1877	(32.176914536239792,35.5)
14077	2028	(24.382685902179844,38.5)
14078	2026	(22.650635094610966,38.5)
14079	2111	(26.98076211353316,40)
14080	2194	(29.578838324886476,41.5)
14081	2071	(27.413774815425377,39.25)
14082	2154	(30.011851026778693,40.75)
14083	2196	(31.310889132455351,41.5)
14084	1957	(32.176914536239792,37)
14085	2233	(29.145825622994256,42.25)
14086	2237	(32.609927238132009,42.25)
14087	1960	(34.774990747593108,37)
14088	2400	(35.208003449485325,45.25)
14089	2200	(34.774990747593108,41.5)
14090	1869	(25.248711305964282,35.5)
14091	2157	(32.609927238132009,40.75)
14092	2399	(34.341978045700891,45.25)
14093	2144	(21.351596988934308,40.75)
14094	2320	(35.208003449485325,43.75)
14095	1051	(9.6602540378443873,20.5)
14096	2104	(20.918584287042091,40)
14097	2024	(20.918584287042091,38.5)
14098	1051	(9.6602540378443873,20.5)
14099	1008	(7.49519052838329,19.75)
14100	1204	(3.598076211353316,23.5)
14101	2025	(21.784609690826528,38.5)
14102	1834	(30.011851026778693,34.75)
14103	1613	(11.392304845413264,31)
14104	1948	(24.382685902179844,37)
14105	1724	(4.0310889132455356,33.25)
14106	1684	(3.598076211353316,32.5)
14107	1240	(34.774990747593108,23.5)
14108	1240	(34.774990747593108,23.5)
14109	1360	(35.208003449485325,25.75)
14110	1597	(32.609927238132009,30.25)
14111	1476	(31.310889132455351,28)
14112	1753	(29.145825622994256,33.25)
14113	1715	(30.444863728670914,32.5)
14114	1717	(32.176914536239792,32.5)
14115	1715	(30.444863728670914,32.5)
14116	1758	(33.47595264191645,33.25)
14117	1680	(35.208003449485325,31.75)
14118	1715	(30.444863728670914,32.5)
14119	1718	(33.042939940024233,32.5)
14120	1680	(35.208003449485325,31.75)
14121	1718	(33.042939940024233,32.5)
14122	913	(28.712812921102035,17.5)
14123	913	(28.712812921102035,17.5)
14124	1538	(15.722431864335457,29.5)
14125	1579	(17.021469970012117,30.25)
14126	1620	(17.454482671904334,31)
14127	1600	(35.208003449485325,30.25)
14128	1160	(34.774990747593108,22)
14129	1160	(34.774990747593108,22)
14130	1160	(34.774990747593108,22)
14131	1400	(34.774990747593108,26.5)
14132	2317	(32.609927238132009,43.75)
14133	2269	(25.248711305964282,43)
14134	2358	(33.042939940024233,44.5)
14135	1356	(31.743901834347572,25.75)
14136	2276	(31.310889132455351,43)
14137	2187	(23.516660498395403,41.5)
14138	2187	(23.516660498395403,41.5)
14139	209	(8.3612159321677293,4.75)
14140	2186	(22.650635094610966,41.5)
14141	170	(8.794228634059948,4)
14142	251	(9.6602540378443873,5.5)
14143	251	(9.6602540378443873,5.5)
14144	1197	(32.609927238132009,22.75)
14145	1197	(32.609927238132009,22.75)
14146	1197	(32.609927238132009,22.75)
14147	1119	(34.341978045700891,21.25)
14148	1398	(33.042939940024233,26.5)
14149	1480	(34.774990747593108,28)
14150	190	(26.114736709748719,4)
14151	190	(26.114736709748719,4)
14152	155	(30.877876430563134,3.25)
14153	155	(30.877876430563134,3.25)
14154	154	(30.011851026778693,3.25)
14155	1000	(34.774990747593108,19)
14156	108	(24.382685902179844,2.5)
14157	596	(31.310889132455351,11.5)
14158	553	(29.145825622994256,10.75)
14159	187	(23.516660498395403,4)
14160	186	(22.650635094610966,4)
14161	28	(24.382685902179844,1)
14162	190	(26.114736709748719,4)
14163	190	(26.114736709748719,4)
14164	34	(29.578838324886476,1)
14165	34	(29.578838324886476,1)
14166	70	(26.54774941164094,1.75)
14167	70	(26.54774941164094,1.75)
14168	70	(26.54774941164094,1.75)
14169	160	(35.208003449485325,3.25)
14170	160	(35.208003449485325,3.25)
14171	160	(35.208003449485325,3.25)
14172	160	(35.208003449485325,3.25)
14173	316	(31.743901834347572,6.25)
14174	317	(32.609927238132009,6.25)
14175	277	(32.176914536239792,5.5)
14176	277	(32.176914536239792,5.5)
14177	199	(33.908965343808667,4)
14178	199	(33.908965343808667,4)
14179	199	(33.908965343808667,4)
14180	199	(33.908965343808667,4)
14181	74	(30.011851026778693,1.75)
14182	70	(26.54774941164094,1.75)
14183	30	(26.114736709748719,1)
14184	33	(28.712812921102035,1)
14185	33	(28.712812921102035,1)
14186	33	(28.712812921102035,1)
14187	70	(26.54774941164094,1.75)
14188	30	(26.114736709748719,1)
14189	231	(27.413774815425377,4.75)
14190	231	(27.413774815425377,4.75)
14191	33	(28.712812921102035,1)
14192	70	(26.54774941164094,1.75)
14193	70	(26.54774941164094,1.75)
14194	466	(23.083647796503186,9.25)
14195	466	(23.083647796503186,9.25)
14196	467	(23.949673200287624,9.25)
14197	1431	(27.413774815425377,27.25)
14198	1424	(21.351596988934308,27.25)
14199	1464	(20.918584287042091,28)
14200	1504	(21.351596988934308,28.75)
14201	37	(32.176914536239792,1)
14202	37	(32.176914536239792,1)
14203	37	(32.176914536239792,1)
14204	77	(32.609927238132009,1.75)
14205	600	(34.774990747593108,11.5)
14206	600	(34.774990747593108,11.5)
14207	197	(32.176914536239792,4)
14208	197	(32.176914536239792,4)
14209	1355	(30.877876430563134,25.75)
14210	555	(30.877876430563134,10.75)
14211	555	(30.877876430563134,10.75)
14212	1116	(31.743901834347572,21.25)
14213	1116	(31.743901834347572,21.25)
14214	1116	(31.743901834347572,21.25)
14215	1352	(28.279800219209818,25.75)
14216	1390	(26.114736709748719,26.5)
14217	1430	(26.54774941164094,27.25)
14218	1312	(27.846787517317598,25)
14219	1312	(27.846787517317598,25)
14220	1470	(26.114736709748719,28)
14221	1306	(22.650635094610966,25)
14222	1306	(22.650635094610966,25)
14223	1464	(20.918584287042091,28)
14224	1505	(22.217622392718749,28.75)
14225	1504	(21.351596988934308,28.75)
14226	1623	(20.05255888325765,31)
14227	1623	(20.05255888325765,31)
14228	1544	(20.918584287042091,29.5)
14229	1623	(20.05255888325765,31)
14230	1545	(21.784609690826528,29.5)
14231	1582	(19.619546181365433,30.25)
14232	1271	(27.413774815425377,24.25)
14233	1271	(27.413774815425377,24.25)
14234	1271	(27.413774815425377,24.25)
14235	425	(21.784609690826528,8.5)
14236	505	(21.784609690826528,10)
14237	505	(21.784609690826528,10)
14238	461	(18.753520777580992,9.25)
14239	461	(18.753520777580992,9.25)
14240	461	(18.753520777580992,9.25)
14241	1232	(27.846787517317598,23.5)
14242	1271	(27.413774815425377,24.25)
14243	1306	(22.650635094610966,25)
14244	2376	(14.423393758658799,45.25)
14245	954	(30.011851026778693,18.25)
14246	990	(26.114736709748719,19)
14247	1029	(25.681724007856502,19.75)
14248	948	(24.815698604072061,18.25)
14249	948	(24.815698604072061,18.25)
14250	987	(23.516660498395403,19)
14251	986	(22.650635094610966,19)
14252	835	(30.444863728670914,16)
14253	874	(30.011851026778693,16.75)
14254	875	(30.877876430563134,16.75)
14255	792	(28.279800219209818,15.25)
14256	792	(28.279800219209818,15.25)
14257	792	(28.279800219209818,15.25)
14258	158	(33.47595264191645,3.25)
14259	158	(33.47595264191645,3.25)
14260	158	(33.47595264191645,3.25)
14261	158	(33.47595264191645,3.25)
14262	158	(33.47595264191645,3.25)
14263	303	(20.48557158514987,6.25)
14264	303	(20.48557158514987,6.25)
14265	223	(20.48557158514987,4.75)
14266	223	(20.48557158514987,4.75)
14267	223	(20.48557158514987,4.75)
14268	1	(1,1)
14269	1	(1,1)
14270	1	(1,1)
14271	41	(1.4330127018922194,1.75)
14272	1309	(25.248711305964282,25)
14273	1308	(24.382685902179844,25)
14274	1662	(19.619546181365433,31.75)
14275	1662	(19.619546181365433,31.75)
14276	1662	(19.619546181365433,31.75)
14277	339	(16.588457268119896,7)
14278	339	(16.588457268119896,7)
14279	300	(17.887495373796554,6.25)
14280	1662	(19.619546181365433,31.75)
14281	287	(6.6291651245988508,6.25)
14282	324	(3.598076211353316,7)
14283	363	(3.1650635094610968,7.75)
14284	1329	(8.3612159321677293,25.75)
14285	246	(5.3301270189221936,5.5)
14286	246	(5.3301270189221936,5.5)
14287	246	(5.3301270189221936,5.5)
14288	167	(6.196152422706632,4)
14289	167	(6.196152422706632,4)
14290	166	(5.3301270189221936,4)
14291	165	(4.4641016151377544,4)
14292	201	(1.4330127018922194,4.75)
14293	201	(1.4330127018922194,4.75)
14294	164	(3.598076211353316,4)
14295	164	(3.598076211353316,4)
14296	164	(3.598076211353316,4)
14297	243	(2.7320508075688772,5.5)
14298	201	(1.4330127018922194,4.75)
14299	201	(1.4330127018922194,4.75)
14300	201	(1.4330127018922194,4.75)
14301	2364	(4.0310889132455356,45.25)
14302	2367	(6.6291651245988508,45.25)
14303	2285	(4.897114317029974,43.75)
14304	2244	(3.598076211353316,43)
14305	2323	(2.7320508075688772,44.5)
14306	2281	(1.4330127018922194,43.75)
14307	2283	(3.1650635094610968,43.75)
14308	2324	(3.598076211353316,44.5)
14309	2281	(1.4330127018922194,43.75)
14310	2281	(1.4330127018922194,43.75)
14311	2241	(1,43)
14312	2281	(1.4330127018922194,43.75)
14313	2241	(1,43)
14314	2243	(2.7320508075688772,43)
14315	2181	(18.320508075688775,41.5)
14316	2181	(18.320508075688775,41.5)
14317	2388	(24.815698604072061,45.25)
14318	2181	(18.320508075688775,41.5)
14319	2388	(24.815698604072061,45.25)
14320	2301	(18.753520777580992,43.75)
14321	2262	(19.186533479473212,43)
14322	2380	(17.887495373796554,45.25)
14323	2364	(4.0310889132455356,45.25)
14324	2364	(4.0310889132455356,45.25)
14325	2380	(17.887495373796554,45.25)
14326	2380	(17.887495373796554,45.25)
14327	2306	(23.083647796503186,43.75)
14328	2383	(20.48557158514987,45.25)
14329	2382	(19.619546181365433,45.25)
14330	2262	(19.186533479473212,43)
14331	1855	(13.124355652982141,35.5)
14332	1695	(13.124355652982141,32.5)
14333	1694	(12.258330249197702,32.5)
14334	1893	(11.825317547305483,36.25)
14335	1776	(13.99038105676658,34)
14336	1981	(18.753520777580992,37.75)
14337	1813	(11.825317547305483,34.75)
14338	1814	(12.691342951089922,34.75)
14339	1859	(16.588457268119896,35.5)
14340	1736	(14.423393758658799,33.25)
14341	1981	(18.753520777580992,37.75)
14342	1776	(13.99038105676658,34)
14343	1981	(18.753520777580992,37.75)
14344	1980	(17.887495373796554,37.75)
14345	1776	(13.99038105676658,34)
14346	1776	(13.99038105676658,34)
14347	1929	(7.9282032302755088,37)
14348	1779	(16.588457268119896,34)
14349	2216	(14.423393758658799,42.25)
14350	2256	(13.99038105676658,43)
14351	2255	(13.124355652982141,43)
14352	1928	(7.0621778264910704,37)
14353	2011	(9.6602540378443873,38.5)
14354	2255	(13.124355652982141,43)
14355	2175	(13.124355652982141,41.5)
14356	1925	(4.4641016151377544,37)
14357	1924	(3.598076211353316,37)
14358	1929	(7.9282032302755088,37)
14359	1978	(16.155444566227676,37.75)
14360	2141	(18.753520777580992,40.75)
14361	2084	(3.598076211353316,40)
14362	1973	(11.825317547305483,37.75)
14363	2171	(9.6602540378443873,41.5)
14364	2170	(8.794228634059948,41.5)
14365	2091	(9.6602540378443873,40)
14366	2083	(2.7320508075688772,40)
14367	2170	(8.794228634059948,41.5)
14368	1924	(3.598076211353316,37)
14369	1961	(1.4330127018922194,37.75)
14370	2170	(8.794228634059948,41.5)
14371	2007	(6.196152422706632,38.5)
14372	1924	(3.598076211353316,37)
14373	2041	(1.4330127018922194,39.25)
14374	1886	(5.7631397208144124,36.25)
14375	2081	(1,40)
14376	2163	(2.7320508075688772,41.5)
14377	2004	(3.598076211353316,38.5)
14378	2057	(15.289419162443238,39.25)
14379	2057	(15.289419162443238,39.25)
14380	1934	(12.258330249197702,37)
14381	2098	(15.722431864335457,40)
14382	2137	(15.289419162443238,40.75)
14383	2055	(13.55736835487436,39.25)
14384	2137	(15.289419162443238,40.75)
14385	2055	(13.55736835487436,39.25)
14386	2041	(1.4330127018922194,39.25)
14387	1735	(13.55736835487436,33.25)
14388	2342	(19.186533479473212,44.5)
14389	2279	(33.908965343808667,43)
14390	2279	(33.908965343808667,43)
14391	2279	(33.908965343808667,43)
14392	2397	(32.609927238132009,45.25)
14393	2397	(32.609927238132009,45.25)
14394	2394	(30.011851026778693,45.25)
14395	2392	(28.279800219209818,45.25)
14396	2392	(28.279800219209818,45.25)
14397	2392	(28.279800219209818,45.25)
14398	2279	(33.908965343808667,43)
14399	762	(2.299038105676658,15.25)
14400	762	(2.299038105676658,15.25)
14401	762	(2.299038105676658,15.25)
14402	921	(1.4330127018922194,18.25)
14403	921	(1.4330127018922194,18.25)
14404	964	(3.598076211353316,19)
14405	1041	(1,20.5)
14406	1869	(25.248711305964282,35.5)
14407	2359	(33.908965343808667,44.5)
14408	2279	(33.908965343808667,43)
14409	2279	(33.908965343808667,43)
14410	693	(11.825317547305483,13.75)
14411	2392	(28.279800219209818,45.25)
14412	2352	(27.846787517317598,44.5)
14413	859	(17.021469970012117,16.75)
14414	822	(19.186533479473212,16)
14415	822	(19.186533479473212,16)
14416	257	(14.856406460551018,5.5)
14417	740	(17.454482671904334,14.5)
14418	336	(13.99038105676658,7)
14419	255	(13.124355652982141,5.5)
14420	2279	(33.908965343808667,43)
14421	453	(11.825317547305483,9.25)
14422	1949	(25.248711305964282,37)
14423	1904	(21.351596988934308,36.25)
14424	531	(10.093266739736606,10.75)
14425	1132	(10.526279441628825,22)
14426	1487	(6.6291651245988508,28.75)
14427	1326	(5.7631397208144124,25.75)
14428	803	(2.7320508075688772,16)
14429	686	(5.7631397208144124,13.75)
14430	844	(4.0310889132455356,16.75)
14431	574	(12.258330249197702,11.5)
14432	723	(2.7320508075688772,14.5)
14433	723	(2.7320508075688772,14.5)
14434	723	(2.7320508075688772,14.5)
14435	1129	(7.9282032302755088,22)
14436	1129	(7.9282032302755088,22)
14437	1363	(2.7320508075688772,26.5)
14438	1128	(7.0621778264910704,22)
14439	1088	(7.49519052838329,21.25)
14440	1088	(7.49519052838329,21.25)
14441	1088	(7.49519052838329,21.25)
14442	723	(2.7320508075688772,14.5)
14443	1281	(1,25)
14444	1241	(1.4330127018922194,24.25)
14445	1241	(1.4330127018922194,24.25)
14446	849	(8.3612159321677293,16.75)
14447	1361	(1,26.5)
14448	1362	(1.8660254037844386,26.5)
14449	1121	(1,22)
14450	1121	(1,22)
14451	1121	(1,22)
14452	1414	(12.691342951089922,27.25)
14453	412	(10.526279441628825,8.5)
14454	448	(7.49519052838329,9.25)
14455	1614	(12.258330249197702,31)
14456	613	(11.825317547305483,12.25)
14457	731	(9.6602540378443873,14.5)
14458	1487	(6.6291651245988508,28.75)
14459	2033	(28.712812921102035,38.5)
14460	1448	(7.0621778264910704,28)
14461	1641	(1.4330127018922194,31.75)
14462	2178	(15.722431864335457,41.5)
14463	1592	(28.279800219209818,30.25)
14464	1591	(27.413774815425377,30.25)
14465	1591	(27.413774815425377,30.25)
14466	1670	(26.54774941164094,31.75)
14467	1627	(23.516660498395403,31)
14468	1626	(22.650635094610966,31)
14469	1626	(22.650635094610966,31)
14470	1626	(22.650635094610966,31)
14471	1626	(22.650635094610966,31)
14472	1626	(22.650635094610966,31)
14473	1626	(22.650635094610966,31)
14474	1704	(20.918584287042091,32.5)
14475	1704	(20.918584287042091,32.5)
14476	1704	(20.918584287042091,32.5)
14477	814	(12.258330249197702,16)
14478	854	(12.691342951089922,16.75)
14479	814	(12.258330249197702,16)
14480	734	(12.258330249197702,14.5)
14481	734	(12.258330249197702,14.5)
14482	893	(11.392304845413264,17.5)
14483	936	(14.423393758658799,18.25)
14484	893	(11.392304845413264,17.5)
14485	936	(14.423393758658799,18.25)
14486	1054	(12.258330249197702,20.5)
14487	1135	(13.124355652982141,22)
14488	938	(16.155444566227676,18.25)
14489	1057	(14.856406460551018,20.5)
14490	1054	(12.258330249197702,20.5)
14491	255	(13.124355652982141,5.5)
14492	254	(12.258330249197702,5.5)
14493	255	(13.124355652982141,5.5)
14494	296	(14.423393758658799,6.25)
14495	214	(12.691342951089922,4.75)
14496	737	(14.856406460551018,14.5)
14497	13	(11.392304845413264,1)
14498	13	(11.392304845413264,1)
14499	623	(20.48557158514987,12.25)
14500	623	(20.48557158514987,12.25)
14501	623	(20.48557158514987,12.25)
14502	661	(18.320508075688775,13)
14503	661	(18.320508075688775,13)
14504	577	(14.856406460551018,11.5)
14505	536	(14.423393758658799,10.75)
14506	659	(16.588457268119896,13)
14507	617	(15.289419162443238,12.25)
14508	1227	(23.516660498395403,23.5)
14509	1225	(21.784609690826528,23.5)
14510	1148	(24.382685902179844,22)
14511	1067	(23.516660498395403,20.5)
14512	1067	(23.516660498395403,20.5)
14513	1022	(19.619546181365433,19.75)
14514	1024	(21.351596988934308,19.75)
14515	905	(21.784609690826528,17.5)
14516	866	(23.083647796503186,16.75)
14517	140	(17.887495373796554,3.25)
14518	140	(17.887495373796554,3.25)
14519	18	(15.722431864335457,1)
14520	58	(16.155444566227676,1.75)
14521	179	(16.588457268119896,4)
14522	178	(15.722431864335457,4)
14523	138	(16.155444566227676,3.25)
14524	179	(16.588457268119896,4)
14525	17	(14.856406460551018,1)
14526	748	(24.382685902179844,14.5)
14527	787	(23.949673200287624,15.25)
14528	787	(23.949673200287624,15.25)
14529	786	(23.083647796503186,15.25)
14530	1877	(32.176914536239792,35.5)
14531	1831	(27.413774815425377,34.75)
14532	1574	(12.691342951089922,30.25)
14533	2370	(9.2272413359521668,45.25)
14534	2370	(9.2272413359521668,45.25)
14535	1113	(29.145825622994256,21.25)
14536	1152	(27.846787517317598,22)
14537	1220	(17.454482671904334,23.5)
14538	1219	(16.588457268119896,23.5)
14539	1220	(17.454482671904334,23.5)
14540	1296	(13.99038105676658,25)
14541	1256	(14.423393758658799,24.25)
14542	2376	(14.423393758658799,45.25)
14543	2376	(14.423393758658799,45.25)
14544	2376	(14.423393758658799,45.25)
14545	2376	(14.423393758658799,45.25)
14546	2377	(15.289419162443238,45.25)
14547	2377	(15.289419162443238,45.25)
14548	2376	(14.423393758658799,45.25)
14549	2035	(30.444863728670914,38.5)
14550	2035	(30.444863728670914,38.5)
14551	2071	(27.413774815425377,39.25)
14552	1989	(25.681724007856502,37.75)
14553	1681	(1,32.5)
14554	1481	(1.4330127018922194,28.75)
14555	2028	(24.382685902179844,38.5)
14556	2028	(24.382685902179844,38.5)
14557	2026	(22.650635094610966,38.5)
14558	2025	(21.784609690826528,38.5)
14559	2026	(22.650635094610966,38.5)
14560	1644	(4.0310889132455356,31.75)
14561	2225	(22.217622392718749,42.25)
14562	2150	(26.54774941164094,40.75)
14563	2225	(22.217622392718749,42.25)
14564	2148	(24.815698604072061,40.75)
14565	2148	(24.815698604072061,40.75)
14566	2157	(32.609927238132009,40.75)
14567	2159	(34.341978045700891,40.75)
14568	1877	(32.176914536239792,35.5)
14569	1877	(32.176914536239792,35.5)
14570	1877	(32.176914536239792,35.5)
14571	1840	(35.208003449485325,34.75)
14572	2159	(34.341978045700891,40.75)
14573	2159	(34.341978045700891,40.75)
14574	2390	(26.54774941164094,45.25)
14575	2154	(30.011851026778693,40.75)
14576	2154	(30.011851026778693,40.75)
14577	2157	(32.609927238132009,40.75)
14578	2194	(29.578838324886476,41.5)
14579	2154	(30.011851026778693,40.75)
14580	2197	(32.176914536239792,41.5)
14581	1960	(34.774990747593108,37)
14582	2196	(31.310889132455351,41.5)
14583	2359	(33.908965343808667,44.5)
14584	1277	(32.609927238132009,24.25)
14585	1476	(31.310889132455351,28)
14586	1753	(29.145825622994256,33.25)
14587	1715	(30.444863728670914,32.5)
14588	1718	(33.042939940024233,32.5)
14589	1759	(34.341978045700891,33.25)
14590	1760	(35.208003449485325,33.25)
14591	1680	(35.208003449485325,31.75)
14592	1715	(30.444863728670914,32.5)
14593	1008	(7.49519052838329,19.75)
14594	1008	(7.49519052838329,19.75)
14595	1205	(4.4641016151377544,23.5)
14596	2320	(35.208003449485325,43.75)
14597	2104	(20.918584287042091,40)
14598	2104	(20.918584287042091,40)
14599	130	(9.2272413359521668,3.25)
14600	409	(7.9282032302755088,8.5)
14601	292	(10.959292143521045,6.25)
14602	2187	(23.516660498395403,41.5)
14603	2269	(25.248711305964282,43)
14604	2187	(23.516660498395403,41.5)
14605	2400	(35.208003449485325,45.25)
14606	2399	(34.341978045700891,45.25)
14607	2279	(33.908965343808667,43)
14608	2200	(34.774990747593108,41.5)
14609	1869	(25.248711305964282,35.5)
14610	2071	(27.413774815425377,39.25)
14611	1160	(34.774990747593108,22)
14612	1160	(34.774990747593108,22)
14613	1360	(35.208003449485325,25.75)
14614	1360	(35.208003449485325,25.75)
14615	1360	(35.208003449485325,25.75)
14616	2317	(32.609927238132009,43.75)
14617	2269	(25.248711305964282,43)
14618	2358	(33.042939940024233,44.5)
14619	1356	(31.743901834347572,25.75)
14620	2276	(31.310889132455351,43)
14621	197	(32.176914536239792,4)
14622	1197	(32.609927238132009,22.75)
14623	1197	(32.609927238132009,22.75)
14624	1197	(32.609927238132009,22.75)
14625	1359	(34.341978045700891,25.75)
14626	1400	(34.774990747593108,26.5)
14627	1240	(34.774990747593108,23.5)
14628	1240	(34.774990747593108,23.5)
14629	1360	(35.208003449485325,25.75)
14630	1597	(32.609927238132009,30.25)
14631	1600	(35.208003449485325,30.25)
14632	1600	(35.208003449485325,30.25)
14633	2157	(32.609927238132009,40.75)
14634	632	(28.279800219209818,12.25)
14635	514	(29.578838324886476,10)
14636	514	(29.578838324886476,10)
14637	514	(29.578838324886476,10)
14638	514	(29.578838324886476,10)
14639	231	(27.413774815425377,4.75)
14640	33	(28.712812921102035,1)
14641	33	(28.712812921102035,1)
14642	33	(28.712812921102035,1)
14643	31	(26.98076211353316,1)
14644	231	(27.413774815425377,4.75)
14645	33	(28.712812921102035,1)
14646	33	(28.712812921102035,1)
14647	33	(28.712812921102035,1)
14648	31	(26.98076211353316,1)
14649	36	(31.310889132455351,1)
14650	36	(31.310889132455351,1)
14651	36	(31.310889132455351,1)
14652	33	(28.712812921102035,1)
14653	31	(26.98076211353316,1)
14654	231	(27.413774815425377,4.75)
14655	33	(28.712812921102035,1)
14656	33	(28.712812921102035,1)
14657	33	(28.712812921102035,1)
14658	33	(28.712812921102035,1)
14659	639	(34.341978045700891,12.25)
14660	160	(35.208003449485325,3.25)
14661	160	(35.208003449485325,3.25)
14662	160	(35.208003449485325,3.25)
14663	160	(35.208003449485325,3.25)
14664	1834	(30.011851026778693,34.75)
14665	1949	(25.248711305964282,37)
14666	1947	(23.516660498395403,37)
14667	2025	(21.784609690826528,38.5)
14668	1723	(3.1650635094610968,33.25)
14669	1724	(4.0310889132455356,33.25)
14670	991	(26.98076211353316,19)
14671	991	(26.98076211353316,19)
14672	991	(26.98076211353316,19)
14673	1029	(25.681724007856502,19.75)
14674	1029	(25.681724007856502,19.75)
14675	948	(24.815698604072061,18.25)
14676	948	(24.815698604072061,18.25)
14677	947	(23.949673200287624,18.25)
14678	946	(23.083647796503186,18.25)
14679	834	(29.578838324886476,16)
14680	834	(29.578838324886476,16)
14681	874	(30.011851026778693,16.75)
14682	792	(28.279800219209818,15.25)
14683	792	(28.279800219209818,15.25)
14684	1342	(19.619546181365433,25.75)
14685	1339	(17.021469970012117,25.75)
14686	1340	(17.887495373796554,25.75)
14687	1303	(20.05255888325765,25)
14688	1339	(17.021469970012117,25.75)
14689	2233	(29.145825622994256,42.25)
14690	231	(27.413774815425377,4.75)
14691	33	(28.712812921102035,1)
14692	33	(28.712812921102035,1)
14693	33	(28.712812921102035,1)
14694	31	(26.98076211353316,1)
14695	1119	(34.341978045700891,21.25)
14696	1119	(34.341978045700891,21.25)
14697	1119	(34.341978045700891,21.25)
14698	1398	(33.042939940024233,26.5)
14699	1439	(34.341978045700891,27.25)
14700	1480	(34.774990747593108,28)
14701	1	(1,1)
14702	1	(1,1)
14703	1	(1,1)
14704	167	(6.196152422706632,4)
14705	167	(6.196152422706632,4)
14706	207	(6.6291651245988508,4.75)
14707	283	(3.1650635094610968,6.25)
14708	201	(1.4330127018922194,4.75)
14709	1618	(15.722431864335457,31)
14710	1580	(17.887495373796554,30.25)
14711	792	(28.279800219209818,15.25)
14712	792	(28.279800219209818,15.25)
14713	1352	(28.279800219209818,25.75)
14714	1390	(26.114736709748719,26.5)
14715	1471	(26.98076211353316,28)
14716	1509	(25.681724007856502,28.75)
14717	1509	(25.681724007856502,28.75)
14718	1505	(22.217622392718749,28.75)
14719	1584	(21.351596988934308,30.25)
14720	1544	(20.918584287042091,29.5)
14721	1623	(20.05255888325765,31)
14722	1623	(20.05255888325765,31)
14723	1623	(20.05255888325765,31)
14724	1623	(20.05255888325765,31)
14725	1623	(20.05255888325765,31)
14726	464	(21.351596988934308,9.25)
14727	464	(21.351596988934308,9.25)
14728	505	(21.784609690826528,10)
14729	461	(18.753520777580992,9.25)
14730	461	(18.753520777580992,9.25)
14731	1232	(27.846787517317598,23.5)
14732	1271	(27.413774815425377,24.25)
14733	2347	(23.516660498395403,44.5)
14734	2388	(24.815698604072061,45.25)
14735	2299	(17.021469970012117,43.75)
14736	2262	(19.186533479473212,43)
14737	2262	(19.186533479473212,43)
14738	2306	(23.083647796503186,43.75)
14739	2306	(23.083647796503186,43.75)
14740	2382	(19.619546181365433,45.25)
14741	2345	(21.784609690826528,44.5)
14742	2382	(19.619546181365433,45.25)
14743	2285	(4.897114317029974,43.75)
14744	2244	(3.598076211353316,43)
14745	2324	(3.598076211353316,44.5)
14746	2367	(6.6291651245988508,45.25)
14747	2324	(3.598076211353316,44.5)
14748	2321	(1,44.5)
14749	2368	(7.49519052838329,45.25)
14750	2368	(7.49519052838329,45.25)
14751	2201	(1.4330127018922194,42.25)
14752	2242	(1.8660254037844386,43)
14753	2201	(1.4330127018922194,42.25)
14754	2201	(1.4330127018922194,42.25)
14755	1739	(17.021469970012117,33.25)
14756	1889	(8.3612159321677293,36.25)
14757	2141	(18.753520777580992,40.75)
14758	1848	(7.0621778264910704,35.5)
14759	2215	(13.55736835487436,42.25)
14760	2060	(17.887495373796554,39.25)
14761	1969	(8.3612159321677293,37.75)
14762	1968	(7.49519052838329,37.75)
14763	1969	(8.3612159321677293,37.75)
14764	2060	(17.887495373796554,39.25)
14765	2053	(11.825317547305483,39.25)
14766	2060	(17.887495373796554,39.25)
14767	2134	(12.691342951089922,40.75)
14768	2133	(11.825317547305483,40.75)
14769	2126	(5.7631397208144124,40.75)
14770	2215	(13.55736835487436,42.25)
14771	2134	(12.691342951089922,40.75)
14772	2121	(1.4330127018922194,40.75)
14773	1973	(11.825317547305483,37.75)
14774	1808	(7.49519052838329,34.75)
14775	2041	(1.4330127018922194,39.25)
14776	2049	(8.3612159321677293,39.25)
14777	2121	(1.4330127018922194,40.75)
14778	1808	(7.49519052838329,34.75)
14779	2121	(1.4330127018922194,40.75)
14780	1924	(3.598076211353316,37)
14781	2293	(11.825317547305483,43.75)
14782	2002	(1.8660254037844386,38.5)
14783	2084	(3.598076211353316,40)
14784	1821	(18.753520777580992,34.75)
14785	2016	(13.99038105676658,38.5)
14786	2016	(13.99038105676658,38.5)
14787	1821	(18.753520777580992,34.75)
14788	2137	(15.289419162443238,40.75)
14789	2055	(13.55736835487436,39.25)
14790	2178	(15.722431864335457,41.5)
14791	2178	(15.722431864335457,41.5)
14792	2041	(1.4330127018922194,39.25)
14793	2279	(33.908965343808667,43)
14794	2380	(17.887495373796554,45.25)
14795	2385	(22.217622392718749,45.25)
14796	2365	(4.897114317029974,45.25)
14797	2326	(5.3301270189221936,44.5)
14798	2220	(17.887495373796554,42.25)
14799	2388	(24.815698604072061,45.25)
14800	2154	(30.011851026778693,40.75)
14801	2394	(30.011851026778693,45.25)
14802	2394	(30.011851026778693,45.25)
14803	2392	(28.279800219209818,45.25)
14804	2352	(27.846787517317598,44.5)
14805	2392	(28.279800219209818,45.25)
14806	2392	(28.279800219209818,45.25)
14807	2390	(26.54774941164094,45.25)
14808	2075	(30.877876430563134,39.25)
14809	1666	(23.083647796503186,31.75)
14810	2279	(33.908965343808667,43)
14811	1929	(7.9282032302755088,37)
14812	2124	(4.0310889132455356,40.75)
14813	2279	(33.908965343808667,43)
14814	1253	(11.825317547305483,24.25)
14815	490	(8.794228634059948,10)
14816	531	(10.093266739736606,10.75)
14817	1132	(10.526279441628825,22)
14818	568	(7.0621778264910704,11.5)
14819	1051	(9.6602540378443873,20.5)
14820	607	(6.6291651245988508,12.25)
14821	607	(6.6291651245988508,12.25)
14822	649	(7.9282032302755088,13)
14823	723	(2.7320508075688772,14.5)
14824	723	(2.7320508075688772,14.5)
14825	723	(2.7320508075688772,14.5)
14826	723	(2.7320508075688772,14.5)
14827	1129	(7.9282032302755088,22)
14828	1363	(2.7320508075688772,26.5)
14829	1283	(2.7320508075688772,25)
14830	1242	(2.299038105676658,24.25)
14831	925	(4.897114317029974,18.25)
14832	1321	(1.4330127018922194,25.75)
14833	1321	(1.4330127018922194,25.75)
14834	1201	(1,23.5)
14835	1121	(1,22)
14836	1121	(1,22)
14837	1121	(1,22)
14838	1121	(1,22)
14839	1326	(5.7631397208144124,25.75)
14840	803	(2.7320508075688772,16)
14841	844	(4.0310889132455356,16.75)
14842	844	(4.0310889132455356,16.75)
14843	1491	(10.093266739736606,28.75)
14844	1253	(11.825317547305483,24.25)
14845	1213	(11.392304845413264,23.5)
14846	649	(7.9282032302755088,13)
14847	570	(8.794228634059948,11.5)
14848	612	(10.959292143521045,12.25)
14849	1643	(3.1650635094610968,31.75)
14850	2025	(21.784609690826528,38.5)
14851	727	(6.196152422706632,14.5)
14852	1592	(28.279800219209818,30.25)
14853	1592	(28.279800219209818,30.25)
14854	1669	(25.681724007856502,31.75)
14855	1669	(25.681724007856502,31.75)
14856	1669	(25.681724007856502,31.75)
14857	1669	(25.681724007856502,31.75)
14858	1783	(20.05255888325765,34)
14859	1743	(20.48557158514987,33.25)
14860	1743	(20.48557158514987,33.25)
14861	1743	(20.48557158514987,33.25)
14862	1704	(20.918584287042091,32.5)
14863	767	(6.6291651245988508,15.25)
14864	1743	(20.48557158514987,33.25)
14865	1704	(20.918584287042091,32.5)
14866	895	(13.124355652982141,17.5)
14867	895	(13.124355652982141,17.5)
14868	734	(12.258330249197702,14.5)
14869	734	(12.258330249197702,14.5)
14870	734	(12.258330249197702,14.5)
14871	1645	(4.897114317029974,31.75)
14872	734	(12.258330249197702,14.5)
14873	734	(12.258330249197702,14.5)
14874	772	(10.959292143521045,15.25)
14875	934	(12.691342951089922,18.25)
14876	974	(12.258330249197702,19)
14877	734	(12.258330249197702,14.5)
14878	974	(12.258330249197702,19)
14879	974	(12.258330249197702,19)
14880	938	(16.155444566227676,18.25)
14881	974	(12.258330249197702,19)
14882	1135	(13.124355652982141,22)
14883	1054	(12.258330249197702,20.5)
14884	1877	(32.176914536239792,35.5)
14885	1831	(27.413774815425377,34.75)
14886	1864	(20.918584287042091,35.5)
14887	1534	(12.258330249197702,29.5)
14888	1573	(11.825317547305483,30.25)
14889	2289	(8.3612159321677293,43.75)
14890	2289	(8.3612159321677293,43.75)
14891	2320	(35.208003449485325,43.75)
14892	2320	(35.208003449485325,43.75)
14893	2103	(20.05255888325765,40)
14894	2104	(20.918584287042091,40)
14895	851	(10.093266739736606,16.75)
14896	1008	(7.49519052838329,19.75)
14897	1243	(3.1650635094610968,24.25)
14898	1121	(1,22)
14899	627	(23.949673200287624,12.25)
14900	954	(30.011851026778693,18.25)
14901	993	(28.712812921102035,19)
14902	1031	(27.413774815425377,19.75)
14903	1029	(25.681724007856502,19.75)
14904	1029	(25.681724007856502,19.75)
14905	1029	(25.681724007856502,19.75)
14906	948	(24.815698604072061,18.25)
14907	947	(23.949673200287624,18.25)
14908	947	(23.949673200287624,18.25)
14909	947	(23.949673200287624,18.25)
14910	1304	(20.918584287042091,25)
14911	1258	(16.155444566227676,24.25)
14912	1226	(22.650635094610966,23.5)
14913	1226	(22.650635094610966,23.5)
14914	1306	(22.650635094610966,25)
14915	1306	(22.650635094610966,25)
14916	1306	(22.650635094610966,25)
14917	1148	(24.382685902179844,22)
14918	1145	(21.784609690826528,22)
14919	1145	(21.784609690826528,22)
14920	1145	(21.784609690826528,22)
14921	1062	(19.186533479473212,20.5)
14922	1137	(14.856406460551018,22)
14923	1187	(23.949673200287624,22.75)
14924	1267	(23.949673200287624,24.25)
14925	1267	(23.949673200287624,24.25)
14926	1145	(21.784609690826528,22)
14927	1145	(21.784609690826528,22)
14928	21	(18.320508075688775,1)
14929	178	(15.722431864335457,4)
14930	17	(14.856406460551018,1)
14931	99	(16.588457268119896,2.5)
14932	60	(17.887495373796554,1.75)
14933	60	(17.887495373796554,1.75)
14934	17	(14.856406460551018,1)
14935	17	(14.856406460551018,1)
14936	17	(14.856406460551018,1)
14937	11	(9.6602540378443873,1)
14938	11	(9.6602540378443873,1)
14939	11	(9.6602540378443873,1)
14940	178	(15.722431864335457,4)
14941	737	(14.856406460551018,14.5)
14942	296	(14.423393758658799,6.25)
14943	254	(12.258330249197702,5.5)
14944	214	(12.691342951089922,4.75)
14945	13	(11.392304845413264,1)
14946	13	(11.392304845413264,1)
14947	13	(11.392304845413264,1)
14948	748	(24.382685902179844,14.5)
14949	748	(24.382685902179844,14.5)
14950	787	(23.949673200287624,15.25)
14951	787	(23.949673200287624,15.25)
14952	787	(23.949673200287624,15.25)
14953	827	(23.516660498395403,16)
14954	827	(23.516660498395403,16)
14955	786	(23.083647796503186,15.25)
14956	1296	(13.99038105676658,25)
14957	1113	(29.145825622994256,21.25)
14958	1112	(28.279800219209818,21.25)
14959	871	(27.413774815425377,16.75)
14960	1220	(17.454482671904334,23.5)
14961	1223	(20.05255888325765,23.5)
14962	1220	(17.454482671904334,23.5)
14963	1222	(19.186533479473212,23.5)
14964	2376	(14.423393758658799,45.25)
14965	2375	(13.55736835487436,45.25)
14966	2376	(14.423393758658799,45.25)
14967	2376	(14.423393758658799,45.25)
14968	2377	(15.289419162443238,45.25)
14969	2376	(14.423393758658799,45.25)
14970	2375	(13.55736835487436,45.25)
14971	1652	(10.959292143521045,31.75)
14972	2035	(30.444863728670914,38.5)
14973	2035	(30.444863728670914,38.5)
14974	1992	(28.279800219209818,37.75)
14975	2071	(27.413774815425377,39.25)
14976	2029	(25.248711305964282,38.5)
14977	2028	(24.382685902179844,38.5)
14978	1988	(24.815698604072061,37.75)
14979	2105	(21.784609690826528,40)
14980	1521	(1,29.5)
14981	767	(6.6291651245988508,15.25)
14982	1611	(9.6602540378443873,31)
14983	2026	(22.650635094610966,38.5)
14984	2026	(22.650635094610966,38.5)
14985	2026	(22.650635094610966,38.5)
14986	1681	(1,32.5)
14987	1326	(5.7631397208144124,25.75)
14988	2150	(26.54774941164094,40.75)
14989	2029	(25.248711305964282,38.5)
14990	1611	(9.6602540378443873,31)
14991	2106	(22.650635094610966,40)
14992	2106	(22.650635094610966,40)
14993	2106	(22.650635094610966,40)
14994	846	(5.7631397208144124,16.75)
14995	1953	(28.712812921102035,37)
14996	1955	(30.444863728670914,37)
14997	1988	(24.815698604072061,37.75)
14998	2157	(32.609927238132009,40.75)
14999	1877	(32.176914536239792,35.5)
15000	1877	(32.176914536239792,35.5)
15001	1877	(32.176914536239792,35.5)
15002	1877	(32.176914536239792,35.5)
15003	1877	(32.176914536239792,35.5)
15004	2026	(22.650635094610966,38.5)
15005	2040	(34.774990747593108,38.5)
15006	1917	(32.609927238132009,36.25)
15007	1879	(33.908965343808667,35.5)
15008	2197	(32.176914536239792,41.5)
15009	1960	(34.774990747593108,37)
15010	1277	(32.609927238132009,24.25)
15011	2154	(30.011851026778693,40.75)
15012	2196	(31.310889132455351,41.5)
15013	2194	(29.578838324886476,41.5)
15014	2194	(29.578838324886476,41.5)
15015	2156	(31.743901834347572,40.75)
15016	2156	(31.743901834347572,40.75)
15017	2233	(29.145825622994256,42.25)
15018	2187	(23.516660498395403,41.5)
15019	2186	(22.650635094610966,41.5)
15020	2225	(22.217622392718749,42.25)
15021	2399	(34.341978045700891,45.25)
15022	2240	(35.208003449485325,42.25)
15023	2200	(34.774990747593108,41.5)
15024	1869	(25.248711305964282,35.5)
15025	1160	(34.774990747593108,22)
15026	1160	(34.774990747593108,22)
15027	1439	(34.341978045700891,27.25)
15028	1440	(35.208003449485325,27.25)
15029	2317	(32.609927238132009,43.75)
15030	2269	(25.248711305964282,43)
15031	2358	(33.042939940024233,44.5)
15032	1356	(31.743901834347572,25.75)
15033	2276	(31.310889132455351,43)
15034	2225	(22.217622392718749,42.25)
15035	1293	(11.392304845413264,25)
15036	251	(9.6602540378443873,5.5)
15037	211	(10.093266739736606,4.75)
15038	1476	(31.310889132455351,28)
15039	1753	(29.145825622994256,33.25)
15040	1715	(30.444863728670914,32.5)
15041	1717	(32.176914536239792,32.5)
15042	1759	(34.341978045700891,33.25)
15043	1715	(30.444863728670914,32.5)
15044	1715	(30.444863728670914,32.5)
15045	1757	(32.609927238132009,33.25)
15046	1680	(35.208003449485325,31.75)
15047	1715	(30.444863728670914,32.5)
15048	1717	(32.176914536239792,32.5)
15049	1680	(35.208003449485325,31.75)
15050	1240	(34.774990747593108,23.5)
15051	1440	(35.208003449485325,27.25)
15052	1600	(35.208003449485325,30.25)
15053	77	(32.609927238132009,1.75)
15054	197	(32.176914536239792,4)
15055	1197	(32.609927238132009,22.75)
15056	1197	(32.609927238132009,22.75)
15057	1197	(32.609927238132009,22.75)
15058	1197	(32.609927238132009,22.75)
15059	1318	(33.042939940024233,25)
15060	1119	(34.341978045700891,21.25)
15061	1119	(34.341978045700891,21.25)
15062	1119	(34.341978045700891,21.25)
15063	1398	(33.042939940024233,26.5)
15064	997	(32.176914536239792,19)
15065	1119	(34.341978045700891,21.25)
15066	1119	(34.341978045700891,21.25)
15067	1119	(34.341978045700891,21.25)
15068	677	(32.176914536239792,13)
15069	677	(32.176914536239792,13)
15070	916	(31.310889132455351,17.5)
15071	916	(31.310889132455351,17.5)
15072	1680	(35.208003449485325,31.75)
15073	1833	(29.145825622994256,34.75)
15074	1833	(29.145825622994256,34.75)
15075	1195	(30.877876430563134,22.75)
15076	1156	(31.310889132455351,22)
15077	1156	(31.310889132455351,22)
15078	77	(32.609927238132009,1.75)
15079	186	(22.650635094610966,4)
15080	186	(22.650635094610966,4)
15081	186	(22.650635094610966,4)
15082	145	(22.217622392718749,3.25)
15083	145	(22.217622392718749,3.25)
15084	145	(22.217622392718749,3.25)
15085	186	(22.650635094610966,4)
15086	107	(23.516660498395403,2.5)
15087	107	(23.516660498395403,2.5)
15088	26	(22.650635094610966,1)
15089	1597	(32.609927238132009,30.25)
15090	553	(29.145825622994256,10.75)
15091	73	(29.145825622994256,1.75)
15092	73	(29.145825622994256,1.75)
15093	70	(26.54774941164094,1.75)
15094	111	(26.98076211353316,2.5)
15095	30	(26.114736709748719,1)
15096	31	(26.98076211353316,1)
15097	271	(26.98076211353316,5.5)
15098	33	(28.712812921102035,1)
15099	33	(28.712812921102035,1)
15100	70	(26.54774941164094,1.75)
15101	70	(26.54774941164094,1.75)
15102	186	(22.650635094610966,4)
15103	186	(22.650635094610966,4)
15104	186	(22.650635094610966,4)
15105	64	(21.351596988934308,1.75)
15106	230	(26.54774941164094,4.75)
15107	398	(33.47595264191645,7.75)
15108	398	(33.47595264191645,7.75)
15109	398	(33.47595264191645,7.75)
15110	360	(34.774990747593108,7)
15111	33	(28.712812921102035,1)
15112	33	(28.712812921102035,1)
15113	33	(28.712812921102035,1)
15114	30	(26.114736709748719,1)
15115	269	(25.248711305964282,5.5)
15116	269	(25.248711305964282,5.5)
15117	33	(28.712812921102035,1)
15118	30	(26.114736709748719,1)
15119	514	(29.578838324886476,10)
15120	33	(28.712812921102035,1)
15121	33	(28.712812921102035,1)
15122	276	(31.310889132455351,5.5)
15123	30	(26.114736709748719,1)
15124	33	(28.712812921102035,1)
15125	33	(28.712812921102035,1)
15126	276	(31.310889132455351,5.5)
15127	276	(31.310889132455351,5.5)
15128	200	(34.774990747593108,4)
15129	200	(34.774990747593108,4)
15130	200	(34.774990747593108,4)
15131	200	(34.774990747593108,4)
15132	77	(32.609927238132009,1.75)
15133	77	(32.609927238132009,1.75)
15134	77	(32.609927238132009,1.75)
15135	77	(32.609927238132009,1.75)
15136	77	(32.609927238132009,1.75)
15137	240	(35.208003449485325,4.75)
15138	240	(35.208003449485325,4.75)
15139	240	(35.208003449485325,4.75)
15140	240	(35.208003449485325,4.75)
15141	240	(35.208003449485325,4.75)
15142	200	(34.774990747593108,4)
15143	160	(35.208003449485325,3.25)
15144	200	(34.774990747593108,4)
15145	200	(34.774990747593108,4)
15146	200	(34.774990747593108,4)
15147	38	(33.042939940024233,1)
15148	160	(35.208003449485325,3.25)
15149	158	(33.47595264191645,3.25)
15150	158	(33.47595264191645,3.25)
15151	158	(33.47595264191645,3.25)
15152	200	(34.774990747593108,4)
15153	200	(34.774990747593108,4)
15154	200	(34.774990747593108,4)
15155	200	(34.774990747593108,4)
15156	200	(34.774990747593108,4)
15157	158	(33.47595264191645,3.25)
15158	200	(34.774990747593108,4)
15159	200	(34.774990747593108,4)
15160	200	(34.774990747593108,4)
15161	200	(34.774990747593108,4)
15162	2299	(17.021469970012117,43.75)
15163	2365	(4.897114317029974,45.25)
15164	2359	(33.908965343808667,44.5)
15165	2279	(33.908965343808667,43)
15166	1158	(33.042939940024233,22)
15167	1158	(33.042939940024233,22)
15168	1158	(33.042939940024233,22)
15169	1318	(33.042939940024233,25)
15170	1834	(30.011851026778693,34.75)
15171	1614	(12.258330249197702,31)
15172	1949	(25.248711305964282,37)
15173	1949	(25.248711305964282,37)
15174	2025	(21.784609690826528,38.5)
15175	1724	(4.0310889132455356,33.25)
15176	1000	(34.774990747593108,19)
15177	63	(20.48557158514987,1.75)
15178	1000	(34.774990747593108,19)
15179	1000	(34.774990747593108,19)
15180	1000	(34.774990747593108,19)
15181	1000	(34.774990747593108,19)
15182	1000	(34.774990747593108,19)
15183	664	(20.918584287042091,13)
15184	702	(19.619546181365433,13.75)
15185	700	(17.887495373796554,13.75)
15186	664	(20.918584287042091,13)
15187	702	(19.619546181365433,13.75)
15188	701	(18.753520777580992,13.75)
15189	796	(31.743901834347572,15.25)
15190	796	(31.743901834347572,15.25)
15191	836	(31.310889132455351,16)
15192	836	(31.310889132455351,16)
15193	543	(20.48557158514987,10.75)
15194	543	(20.48557158514987,10.75)
15195	543	(20.48557158514987,10.75)
15196	1390	(26.114736709748719,26.5)
15197	1424	(21.351596988934308,27.25)
15198	1544	(20.918584287042091,29.5)
15199	1623	(20.05255888325765,31)
15200	754	(29.578838324886476,14.5)
15201	836	(31.310889132455351,16)
15202	836	(31.310889132455351,16)
15203	874	(30.011851026778693,16.75)
15204	874	(30.011851026778693,16.75)
15205	874	(30.011851026778693,16.75)
15206	874	(30.011851026778693,16.75)
15207	792	(28.279800219209818,15.25)
15208	792	(28.279800219209818,15.25)
15209	792	(28.279800219209818,15.25)
15210	1312	(27.846787517317598,25)
15211	1312	(27.846787517317598,25)
15212	1470	(26.114736709748719,28)
15213	1470	(26.114736709748719,28)
15214	1390	(26.114736709748719,26.5)
15215	1471	(26.98076211353316,28)
15216	1509	(25.681724007856502,28.75)
15217	1510	(26.54774941164094,28.75)
15218	1464	(20.918584287042091,28)
15219	1464	(20.918584287042091,28)
15220	1623	(20.05255888325765,31)
15221	1623	(20.05255888325765,31)
15222	1623	(20.05255888325765,31)
15223	1424	(21.351596988934308,27.25)
15224	1424	(21.351596988934308,27.25)
15225	1544	(20.918584287042091,29.5)
15226	1623	(20.05255888325765,31)
15227	792	(28.279800219209818,15.25)
15228	1618	(15.722431864335457,31)
15229	1620	(17.454482671904334,31)
15230	1620	(17.454482671904334,31)
15231	41	(1.4330127018922194,1.75)
15232	323	(2.7320508075688772,7)
15233	166	(5.3301270189221936,4)
15234	166	(5.3301270189221936,4)
15235	322	(1.8660254037844386,7)
15236	482	(1.8660254037844386,10)
15237	1702	(19.186533479473212,32.5)
15238	282	(2.299038105676658,6.25)
15239	201	(1.4330127018922194,4.75)
15240	201	(1.4330127018922194,4.75)
15241	302	(19.619546181365433,6.25)
15242	302	(19.619546181365433,6.25)
15243	2400	(35.208003449485325,45.25)
15244	2388	(24.815698604072061,45.25)
15245	2388	(24.815698604072061,45.25)
15246	2388	(24.815698604072061,45.25)
15247	2388	(24.815698604072061,45.25)
15248	2286	(5.7631397208144124,43.75)
15249	2286	(5.7631397208144124,43.75)
15250	2347	(23.516660498395403,44.5)
15251	2347	(23.516660498395403,44.5)
15252	2262	(19.186533479473212,43)
15253	2262	(19.186533479473212,43)
15254	2380	(17.887495373796554,45.25)
15255	2380	(17.887495373796554,45.25)
15256	2307	(23.949673200287624,43.75)
15257	2345	(21.784609690826528,44.5)
15258	2345	(21.784609690826528,44.5)
15259	2380	(17.887495373796554,45.25)
15260	2324	(3.598076211353316,44.5)
15261	2324	(3.598076211353316,44.5)
15262	2364	(4.0310889132455356,45.25)
15263	2245	(4.4641016151377544,43)
15264	2367	(6.6291651245988508,45.25)
15265	2245	(4.4641016151377544,43)
15266	2246	(5.3301270189221936,43)
15267	2367	(6.6291651245988508,45.25)
15268	2204	(4.0310889132455356,42.25)
15269	2367	(6.6291651245988508,45.25)
15270	2204	(4.0310889132455356,42.25)
15271	2367	(6.6291651245988508,45.25)
15272	2281	(1.4330127018922194,43.75)
15273	2281	(1.4330127018922194,43.75)
15274	2281	(1.4330127018922194,43.75)
15275	2281	(1.4330127018922194,43.75)
15276	1852	(10.526279441628825,35.5)
15277	1899	(17.021469970012117,36.25)
15278	1739	(17.021469970012117,33.25)
15279	1899	(17.021469970012117,36.25)
15280	1859	(16.588457268119896,35.5)
15281	1854	(12.258330249197702,35.5)
15282	1978	(16.155444566227676,37.75)
15283	1779	(16.588457268119896,34)
15284	1776	(13.99038105676658,34)
15285	1929	(7.9282032302755088,37)
15286	2060	(17.887495373796554,39.25)
15287	1977	(15.289419162443238,37.75)
15288	1852	(10.526279441628825,35.5)
15289	1977	(15.289419162443238,37.75)
15290	1776	(13.99038105676658,34)
15291	1981	(18.753520777580992,37.75)
15292	1969	(8.3612159321677293,37.75)
15293	1851	(9.6602540378443873,35.5)
15294	1776	(13.99038105676658,34)
15295	1889	(8.3612159321677293,36.25)
15296	1818	(16.155444566227676,34.75)
15297	2170	(8.794228634059948,41.5)
15298	2060	(17.887495373796554,39.25)
15299	2216	(14.423393758658799,42.25)
15300	2011	(9.6602540378443873,38.5)
15301	2134	(12.691342951089922,40.75)
15302	2213	(11.825317547305483,42.25)
15303	2050	(9.2272413359521668,39.25)
15304	1923	(2.7320508075688772,37)
15305	2207	(6.6291651245988508,42.25)
15306	2050	(9.2272413359521668,39.25)
15307	1961	(1.4330127018922194,37.75)
15308	1924	(3.598076211353316,37)
15309	2213	(11.825317547305483,42.25)
15310	2170	(8.794228634059948,41.5)
15311	2091	(9.6602540378443873,40)
15312	2170	(8.794228634059948,41.5)
15313	1924	(3.598076211353316,37)
15314	1924	(3.598076211353316,37)
15315	2041	(1.4330127018922194,39.25)
15316	2212	(10.959292143521045,42.25)
15317	2212	(10.959292143521045,42.25)
15318	1924	(3.598076211353316,37)
15319	2121	(1.4330127018922194,40.75)
15320	2121	(1.4330127018922194,40.75)
15321	1961	(1.4330127018922194,37.75)
15322	2170	(8.794228634059948,41.5)
15323	1973	(11.825317547305483,37.75)
15324	2091	(9.6602540378443873,40)
15325	2121	(1.4330127018922194,40.75)
15326	2041	(1.4330127018922194,39.25)
15327	1885	(4.897114317029974,36.25)
15328	2004	(3.598076211353316,38.5)
15329	2004	(3.598076211353316,38.5)
15330	2004	(3.598076211353316,38.5)
15331	2178	(15.722431864335457,41.5)
15332	2178	(15.722431864335457,41.5)
15333	2257	(14.856406460551018,43)
15334	2137	(15.289419162443238,40.75)
15335	2168	(7.0621778264910704,41.5)
15336	2055	(13.55736835487436,39.25)
15337	2055	(13.55736835487436,39.25)
15338	2216	(14.423393758658799,42.25)
15339	1902	(19.619546181365433,36.25)
15340	2279	(33.908965343808667,43)
15341	2279	(33.908965343808667,43)
15342	2397	(32.609927238132009,45.25)
15343	2057	(15.289419162443238,39.25)
15344	2388	(24.815698604072061,45.25)
15345	2384	(21.351596988934308,45.25)
15346	2397	(32.609927238132009,45.25)
15347	2397	(32.609927238132009,45.25)
15348	2397	(32.609927238132009,45.25)
15349	2397	(32.609927238132009,45.25)
15350	2397	(32.609927238132009,45.25)
15351	2394	(30.011851026778693,45.25)
15352	2352	(27.846787517317598,44.5)
15353	2392	(28.279800219209818,45.25)
15354	2392	(28.279800219209818,45.25)
15355	2392	(28.279800219209818,45.25)
15356	1715	(30.444863728670914,32.5)
15357	1717	(32.176914536239792,32.5)
15358	1321	(1.4330127018922194,25.75)
15359	1121	(1,22)
15360	1121	(1,22)
15361	1121	(1,22)
15362	1121	(1,22)
15363	1121	(1,22)
15364	1121	(1,22)
15365	1240	(34.774990747593108,23.5)
15366	1240	(34.774990747593108,23.5)
15367	1360	(35.208003449485325,25.75)
15368	1597	(32.609927238132009,30.25)
15369	1600	(35.208003449485325,30.25)
15370	70	(26.54774941164094,1.75)
15371	624	(21.351596988934308,12.25)
15372	661	(18.320508075688775,13)
15373	661	(18.320508075688775,13)
15374	701	(18.753520777580992,13.75)
15375	577	(14.856406460551018,11.5)
15376	618	(16.155444566227676,12.25)
15377	617	(15.289419162443238,12.25)
15378	617	(15.289419162443238,12.25)
15379	2380	(17.887495373796554,45.25)
15380	2380	(17.887495373796554,45.25)
15381	2380	(17.887495373796554,45.25)
15382	2285	(4.897114317029974,43.75)
15383	2285	(4.897114317029974,43.75)
15384	2245	(4.4641016151377544,43)
15385	2204	(4.0310889132455356,42.25)
15386	1768	(7.0621778264910704,34)
15387	1769	(7.9282032302755088,34)
15388	2207	(6.6291651245988508,42.25)
15389	2279	(33.908965343808667,43)
15390	531	(10.093266739736606,10.75)
15391	1171	(10.093266739736606,22.75)
15392	1364	(3.598076211353316,26.5)
15393	1253	(11.825317547305483,24.25)
15394	1089	(8.3612159321677293,21.25)
15395	566	(5.3301270189221936,11.5)
15396	1911	(27.413774815425377,36.25)
15397	1494	(12.691342951089922,28.75)
15398	1493	(11.825317547305483,28.75)
15399	1051	(9.6602540378443873,20.5)
15400	1050	(8.794228634059948,20.5)
15401	1089	(8.3612159321677293,21.25)
15402	1089	(8.3612159321677293,21.25)
15403	1323	(3.1650635094610968,25.75)
15404	1282	(1.8660254037844386,25)
15405	1281	(1,25)
15406	1281	(1,25)
15407	1241	(1.4330127018922194,24.25)
15408	1241	(1.4330127018922194,24.25)
15409	1121	(1,22)
15410	1121	(1,22)
15411	1121	(1,22)
15412	816	(13.99038105676658,16)
15413	815	(13.124355652982141,16)
15414	814	(12.258330249197702,16)
15415	1670	(26.54774941164094,31.75)
15416	1669	(25.681724007856502,31.75)
15417	1669	(25.681724007856502,31.75)
15418	1669	(25.681724007856502,31.75)
15419	1669	(25.681724007856502,31.75)
15420	936	(14.423393758658799,18.25)
15421	1054	(12.258330249197702,20.5)
15422	1626	(22.650635094610966,31)
15423	1743	(20.48557158514987,33.25)
15424	1704	(20.918584287042091,32.5)
15425	1704	(20.918584287042091,32.5)
15426	2376	(14.423393758658799,45.25)
15427	2376	(14.423393758658799,45.25)
15428	2035	(30.444863728670914,38.5)
15429	2035	(30.444863728670914,38.5)
15430	2076	(31.743901834347572,39.25)
15431	2071	(27.413774815425377,39.25)
15432	2071	(27.413774815425377,39.25)
15433	2071	(27.413774815425377,39.25)
15434	1521	(1,29.5)
15435	1112	(28.279800219209818,21.25)
15436	1112	(28.279800219209818,21.25)
15437	871	(27.413774815425377,16.75)
15438	1641	(1.4330127018922194,31.75)
15439	1521	(1,29.5)
15440	1521	(1,29.5)
15441	2071	(27.413774815425377,39.25)
15442	2071	(27.413774815425377,39.25)
15443	2071	(27.413774815425377,39.25)
15444	2026	(22.650635094610966,38.5)
15445	1986	(23.083647796503186,37.75)
15446	1538	(15.722431864335457,29.5)
15447	1618	(15.722431864335457,31)
15448	1147	(23.516660498395403,22)
15449	1145	(21.784609690826528,22)
15450	866	(23.083647796503186,16.75)
15451	866	(23.083647796503186,16.75)
15452	586	(22.650635094610966,11.5)
15453	586	(22.650635094610966,11.5)
15454	586	(22.650635094610966,11.5)
15455	994	(29.578838324886476,19)
15456	994	(29.578838324886476,19)
15457	994	(29.578838324886476,19)
15458	418	(15.722431864335457,8.5)
15459	457	(15.289419162443238,9.25)
15460	457	(15.289419162443238,9.25)
15461	457	(15.289419162443238,9.25)
15462	537	(15.289419162443238,10.75)
15463	618	(16.155444566227676,12.25)
15464	618	(16.155444566227676,12.25)
15465	618	(16.155444566227676,12.25)
15466	2388	(24.815698604072061,45.25)
15467	2388	(24.815698604072061,45.25)
15468	2260	(17.454482671904334,43)
15469	2181	(18.320508075688775,41.5)
15470	2388	(24.815698604072061,45.25)
15471	2345	(21.784609690826528,44.5)
15472	2368	(7.49519052838329,45.25)
15473	1694	(12.258330249197702,32.5)
15474	1821	(18.753520777580992,34.75)
15475	1779	(16.588457268119896,34)
15476	1821	(18.753520777580992,34.75)
15477	1929	(7.9282032302755088,37)
15478	1892	(10.959292143521045,36.25)
15479	1889	(8.3612159321677293,36.25)
15480	1929	(7.9282032302755088,37)
15481	1977	(15.289419162443238,37.75)
15482	1977	(15.289419162443238,37.75)
15483	1929	(7.9282032302755088,37)
15484	1928	(7.0621778264910704,37)
15485	2053	(11.825317547305483,39.25)
15486	2167	(6.196152422706632,41.5)
15487	1968	(7.49519052838329,37.75)
15488	2134	(12.691342951089922,40.75)
15489	2212	(10.959292143521045,42.25)
15490	1961	(1.4330127018922194,37.75)
15491	21	(18.320508075688775,1)
15492	60	(17.887495373796554,1.75)
15493	178	(15.722431864335457,4)
15494	178	(15.722431864335457,4)
15495	179	(16.588457268119896,4)
15496	178	(15.722431864335457,4)
15497	737	(14.856406460551018,14.5)
15498	214	(12.691342951089922,4.75)
15499	789	(25.681724007856502,15.25)
15500	788	(24.815698604072061,15.25)
15501	787	(23.949673200287624,15.25)
15502	787	(23.949673200287624,15.25)
15503	7	(6.196152422706632,1)
15504	7	(6.196152422706632,1)
15505	7	(6.196152422706632,1)
15506	7	(6.196152422706632,1)
15507	7	(6.196152422706632,1)
15508	1701	(18.320508075688775,32.5)
15509	300	(17.887495373796554,6.25)
15510	341	(18.320508075688775,7)
15511	339	(16.588457268119896,7)
15512	223	(20.48557158514987,4.75)
15513	223	(20.48557158514987,4.75)
15514	223	(20.48557158514987,4.75)
15515	223	(20.48557158514987,4.75)
15516	560	(35.208003449485325,10.75)
15517	599	(33.908965343808667,11.5)
15518	560	(35.208003449485325,10.75)
15519	437	(32.176914536239792,8.5)
15520	398	(33.47595264191645,7.75)
15521	276	(31.310889132455351,5.5)
15522	33	(28.712812921102035,1)
15523	31	(26.98076211353316,1)
15524	2063	(20.48557158514987,39.25)
15525	1911	(27.413774815425377,36.25)
15526	1355	(30.877876430563134,25.75)
15527	1907	(23.949673200287624,36.25)
15528	2157	(32.609927238132009,40.75)
15529	2154	(30.011851026778693,40.75)
15530	2194	(29.578838324886476,41.5)
15531	1725	(4.897114317029974,33.25)
15532	1724	(4.0310889132455356,33.25)
15533	1955	(30.444863728670914,37)
15534	2035	(30.444863728670914,38.5)
15535	2154	(30.011851026778693,40.75)
15536	2400	(35.208003449485325,45.25)
15537	2200	(34.774990747593108,41.5)
15538	2399	(34.341978045700891,45.25)
15539	2144	(21.351596988934308,40.75)
15540	2279	(33.908965343808667,43)
15541	1869	(25.248711305964282,35.5)
15542	2159	(34.341978045700891,40.75)
15543	2159	(34.341978045700891,40.75)
15544	2159	(34.341978045700891,40.75)
15545	1356	(31.743901834347572,25.75)
15546	1160	(34.774990747593108,22)
15547	1160	(34.774990747593108,22)
15548	1160	(34.774990747593108,22)
15549	1360	(35.208003449485325,25.75)
15550	2317	(32.609927238132009,43.75)
15551	2269	(25.248711305964282,43)
15552	2358	(33.042939940024233,44.5)
15553	1356	(31.743901834347572,25.75)
15554	170	(8.794228634059948,4)
15555	209	(8.3612159321677293,4.75)
15556	209	(8.3612159321677293,4.75)
15557	472	(28.279800219209818,9.25)
15558	152	(28.279800219209818,3.25)
15559	33	(28.712812921102035,1)
15560	33	(28.712812921102035,1)
15561	152	(28.279800219209818,3.25)
15562	33	(28.712812921102035,1)
15563	33	(28.712812921102035,1)
15564	33	(28.712812921102035,1)
15565	511	(26.98076211353316,10)
15566	231	(27.413774815425377,4.75)
15567	511	(26.98076211353316,10)
15568	33	(28.712812921102035,1)
15569	1309	(25.248711305964282,25)
15570	1341	(18.753520777580992,25.75)
15571	1298	(15.722431864335457,25)
15572	1298	(15.722431864335457,25)
15573	1258	(16.155444566227676,24.25)
15574	1258	(16.155444566227676,24.25)
15575	1306	(22.650635094610966,25)
15576	1306	(22.650635094610966,25)
15577	1464	(20.918584287042091,28)
15578	1623	(20.05255888325765,31)
15579	1623	(20.05255888325765,31)
15580	1623	(20.05255888325765,31)
15581	1424	(21.351596988934308,27.25)
15582	37	(32.176914536239792,1)
15583	80	(35.208003449485325,1.75)
15584	80	(35.208003449485325,1.75)
15585	37	(32.176914536239792,1)
15586	37	(32.176914536239792,1)
15587	37	(32.176914536239792,1)
15588	37	(32.176914536239792,1)
15589	543	(20.48557158514987,10.75)
15590	543	(20.48557158514987,10.75)
15591	543	(20.48557158514987,10.75)
15592	543	(20.48557158514987,10.75)
15593	543	(20.48557158514987,10.75)
15594	543	(20.48557158514987,10.75)
15595	543	(20.48557158514987,10.75)
15596	543	(20.48557158514987,10.75)
15597	543	(20.48557158514987,10.75)
15598	1393	(28.712812921102035,26.5)
15599	1432	(28.279800219209818,27.25)
15600	1472	(27.846787517317598,28)
15601	1472	(27.846787517317598,28)
15602	1508	(24.815698604072061,28.75)
15603	1548	(24.382685902179844,29.5)
15604	1158	(33.042939940024233,22)
15605	1158	(33.042939940024233,22)
15606	840	(34.774990747593108,16)
15607	840	(34.774990747593108,16)
15608	37	(32.176914536239792,1)
15609	350	(26.114736709748719,7)
15610	352	(27.846787517317598,7)
15611	1633	(28.712812921102035,31)
15612	1592	(28.279800219209818,30.25)
15613	1591	(27.413774815425377,30.25)
15614	1591	(27.413774815425377,30.25)
15615	1877	(32.176914536239792,35.5)
15616	1877	(32.176914536239792,35.5)
15617	1877	(32.176914536239792,35.5)
15618	1986	(23.083647796503186,37.75)
15619	673	(28.712812921102035,13)
15620	190	(26.114736709748719,4)
15621	554	(30.011851026778693,10.75)
15622	152	(28.279800219209818,3.25)
15623	33	(28.712812921102035,1)
15624	74	(30.011851026778693,1.75)
15625	152	(28.279800219209818,3.25)
15626	33	(28.712812921102035,1)
15627	31	(26.98076211353316,1)
15628	31	(26.98076211353316,1)
15629	673	(28.712812921102035,13)
15630	190	(26.114736709748719,4)
15631	554	(30.011851026778693,10.75)
15632	2233	(29.145825622994256,42.25)
15633	1476	(31.310889132455351,28)
15634	1753	(29.145825622994256,33.25)
15635	1715	(30.444863728670914,32.5)
15636	1676	(31.743901834347572,31.75)
15637	1717	(32.176914536239792,32.5)
15638	1718	(33.042939940024233,32.5)
15639	1759	(34.341978045700891,33.25)
15640	1760	(35.208003449485325,33.25)
15641	1680	(35.208003449485325,31.75)
15642	1715	(30.444863728670914,32.5)
15643	1240	(34.774990747593108,23.5)
15644	1240	(34.774990747593108,23.5)
15645	1597	(32.609927238132009,30.25)
15646	1600	(35.208003449485325,30.25)
15647	1240	(34.774990747593108,23.5)
15648	1360	(35.208003449485325,25.75)
15649	1600	(35.208003449485325,30.25)
15650	2394	(30.011851026778693,45.25)
15651	2352	(27.846787517317598,44.5)
15652	330	(8.794228634059948,7)
15653	170	(8.794228634059948,4)
15654	211	(10.093266739736606,4.75)
15655	2150	(26.54774941164094,40.75)
15656	2279	(33.908965343808667,43)
15657	1990	(26.54774941164094,37.75)
15658	531	(10.093266739736606,10.75)
15659	1171	(10.093266739736606,22.75)
15660	1364	(3.598076211353316,26.5)
15661	1245	(4.897114317029974,24.25)
15662	1050	(8.794228634059948,20.5)
15663	1204	(3.598076211353316,23.5)
15664	1204	(3.598076211353316,23.5)
15665	1204	(3.598076211353316,23.5)
15666	2279	(33.908965343808667,43)
15667	1333	(11.825317547305483,25.75)
15668	1333	(11.825317547305483,25.75)
15669	446	(5.7631397208144124,9.25)
15670	441	(1.4330127018922194,9.25)
15671	441	(1.4330127018922194,9.25)
15672	2279	(33.908965343808667,43)
15673	564	(3.598076211353316,11.5)
15674	564	(3.598076211353316,11.5)
15675	603	(3.1650635094610968,12.25)
15676	601	(1.4330127018922194,12.25)
15677	1086	(5.7631397208144124,21.25)
15678	1125	(4.4641016151377544,22)
15679	841	(1.4330127018922194,16.75)
15680	1287	(6.196152422706632,25)
15681	1287	(6.196152422706632,25)
15682	1205	(4.4641016151377544,23.5)
15683	1086	(5.7631397208144124,21.25)
15684	1125	(4.4641016151377544,22)
15685	1084	(4.0310889132455356,21.25)
15686	524	(4.0310889132455356,10.75)
15687	601	(1.4330127018922194,12.25)
15688	1416	(14.423393758658799,27.25)
15689	1252	(10.959292143521045,24.25)
15690	1451	(9.6602540378443873,28)
15691	1291	(9.6602540378443873,25)
15692	563	(2.7320508075688772,11.5)
15693	1248	(7.49519052838329,24.25)
15694	1709	(25.248711305964282,32.5)
15695	1708	(24.382685902179844,32.5)
15696	1708	(24.382685902179844,32.5)
15697	1708	(24.382685902179844,32.5)
15698	1706	(22.650635094610966,32.5)
15699	1708	(24.382685902179844,32.5)
15700	1828	(24.815698604072061,34.75)
15701	1137	(14.856406460551018,22)
15702	1214	(12.258330249197702,23.5)
15703	980	(17.454482671904334,19)
15704	934	(12.691342951089922,18.25)
15705	1790	(26.114736709748719,34)
15706	1790	(26.114736709748719,34)
15707	1905	(22.217622392718749,36.25)
15708	2289	(8.3612159321677293,43.75)
15709	2370	(9.2272413359521668,45.25)
15710	1786	(22.650635094610966,34)
15711	1786	(22.650635094610966,34)
15712	2374	(12.691342951089922,45.25)
15713	2374	(12.691342951089922,45.25)
15714	2374	(12.691342951089922,45.25)
15715	2373	(11.825317547305483,45.25)
15716	1954	(29.578838324886476,37)
15717	1610	(8.794228634059948,31)
15718	1647	(6.6291651245988508,31.75)
15719	2033	(28.712812921102035,38.5)
15720	2033	(28.712812921102035,38.5)
15721	2033	(28.712812921102035,38.5)
15722	1392	(27.846787517317598,26.5)
15723	2109	(25.248711305964282,40)
15724	1608	(7.0621778264910704,31)
15725	1647	(6.6291651245988508,31.75)
15726	1471	(26.98076211353316,28)
15727	2111	(26.98076211353316,40)
15728	1529	(7.9282032302755088,29.5)
15729	1529	(7.9282032302755088,29.5)
15730	1525	(4.4641016151377544,29.5)
15731	1525	(4.4641016151377544,29.5)
15732	2194	(29.578838324886476,41.5)
15733	1350	(26.54774941164094,25.75)
15734	1547	(23.516660498395403,29.5)
15735	1427	(23.949673200287624,27.25)
15736	1427	(23.949673200287624,27.25)
15737	1501	(18.753520777580992,28.75)
15738	1462	(19.186533479473212,28)
15739	1537	(14.856406460551018,29.5)
15740	663	(20.05255888325765,13)
15741	1502	(19.619546181365433,28.75)
15742	1618	(15.722431864335457,31)
15743	659	(16.588457268119896,13)
15744	423	(20.05255888325765,8.5)
15745	1298	(15.722431864335457,25)
15746	1336	(14.423393758658799,25.75)
15747	1256	(14.423393758658799,24.25)
15748	1336	(14.423393758658799,25.75)
15749	1336	(14.423393758658799,25.75)
15750	1216	(13.99038105676658,23.5)
15751	911	(26.98076211353316,17.5)
15752	870	(26.54774941164094,16.75)
15753	1152	(27.846787517317598,22)
15754	1219	(16.588457268119896,23.5)
15755	1187	(23.949673200287624,22.75)
15756	1065	(21.784609690826528,20.5)
15757	1062	(19.186533479473212,20.5)
15758	424	(20.918584287042091,8.5)
15759	424	(20.918584287042091,8.5)
15760	461	(18.753520777580992,9.25)
15761	501	(18.320508075688775,10)
15762	1233	(28.712812921102035,23.5)
15763	152	(28.279800219209818,3.25)
15764	152	(28.279800219209818,3.25)
15765	33	(28.712812921102035,1)
15766	33	(28.712812921102035,1)
15767	30	(26.114736709748719,1)
15768	152	(28.279800219209818,3.25)
15769	152	(28.279800219209818,3.25)
15770	33	(28.712812921102035,1)
15771	33	(28.712812921102035,1)
15772	30	(26.114736709748719,1)
15773	158	(33.47595264191645,3.25)
15774	158	(33.47595264191645,3.25)
15775	80	(35.208003449485325,1.75)
15776	80	(35.208003449485325,1.75)
15777	197	(32.176914536239792,4)
15778	2347	(23.516660498395403,44.5)
15779	2221	(18.753520777580992,42.25)
15780	2302	(19.619546181365433,43.75)
15781	2347	(23.516660498395403,44.5)
15782	2367	(6.6291651245988508,45.25)
15783	2302	(19.619546181365433,43.75)
15784	2362	(2.299038105676658,45.25)
15785	2363	(3.1650635094610968,45.25)
15786	2362	(2.299038105676658,45.25)
15787	2362	(2.299038105676658,45.25)
15788	2361	(1.4330127018922194,45.25)
15789	2361	(1.4330127018922194,45.25)
15790	2361	(1.4330127018922194,45.25)
15791	152	(28.279800219209818,3.25)
15792	1778	(15.722431864335457,34)
15793	1761	(1,34)
15794	1462	(19.186533479473212,28)
15795	1772	(10.526279441628825,34)
15796	1772	(10.526279441628825,34)
15797	1772	(10.526279441628825,34)
15798	1778	(15.722431864335457,34)
15799	1978	(16.155444566227676,37.75)
15800	1978	(16.155444566227676,37.75)
15801	1768	(7.0621778264910704,34)
15802	1911	(27.413774815425377,36.25)
15803	1911	(27.413774815425377,36.25)
15804	1769	(7.9282032302755088,34)
15805	1768	(7.0621778264910704,34)
15806	1738	(16.155444566227676,33.25)
15807	1768	(7.0621778264910704,34)
15808	2060	(17.887495373796554,39.25)
15809	1962	(2.299038105676658,37.75)
15810	1926	(5.3301270189221936,37)
15811	2041	(1.4330127018922194,39.25)
15812	2206	(5.7631397208144124,42.25)
15813	1962	(2.299038105676658,37.75)
15814	2092	(10.526279441628825,40)
15815	2206	(5.7631397208144124,42.25)
15816	1884	(4.0310889132455356,36.25)
15817	2178	(15.722431864335457,41.5)
15818	2098	(15.722431864335457,40)
15819	2098	(15.722431864335457,40)
15820	821	(18.320508075688775,16)
15821	336	(13.99038105676658,7)
15822	782	(19.619546181365433,15.25)
15823	336	(13.99038105676658,7)
15824	256	(13.99038105676658,5.5)
15825	819	(16.588457268119896,16)
15826	819	(16.588457268119896,16)
15827	101	(18.320508075688775,2.5)
15828	58	(16.155444566227676,1.75)
15829	17	(14.856406460551018,1)
15830	17	(14.856406460551018,1)
15831	17	(14.856406460551018,1)
15832	10	(8.794228634059948,1)
15833	15	(13.124355652982141,1)
15834	748	(24.382685902179844,14.5)
15835	787	(23.949673200287624,15.25)
15836	827	(23.516660498395403,16)
15837	2187	(23.516660498395403,41.5)
15838	2187	(23.516660498395403,41.5)
15839	101	(18.320508075688775,2.5)
15840	59	(17.021469970012117,1.75)
15841	18	(15.722431864335457,1)
15842	127	(6.6291651245988508,3.25)
15843	7	(6.196152422706632,1)
15844	7	(6.196152422706632,1)
15845	7	(6.196152422706632,1)
15846	5	(4.4641016151377544,1)
15847	45	(4.897114317029974,1.75)
15848	123	(3.1650635094610968,3.25)
15849	122	(2.299038105676658,3.25)
15850	163	(2.7320508075688772,4)
15851	163	(2.7320508075688772,4)
15852	888	(7.0621778264910704,17.5)
15853	928	(7.49519052838329,18.25)
15854	803	(2.7320508075688772,16)
15855	1046	(5.3301270189221936,20.5)
15856	1046	(5.3301270189221936,20.5)
15857	1046	(5.3301270189221936,20.5)
15858	794	(30.011851026778693,15.25)
15859	969	(7.9282032302755088,19)
15860	794	(30.011851026778693,15.25)
15861	794	(30.011851026778693,15.25)
15862	794	(30.011851026778693,15.25)
15863	792	(28.279800219209818,15.25)
15864	791	(27.413774815425377,15.25)
15865	2069	(25.681724007856502,39.25)
15866	1953	(28.712812921102035,37)
15867	1614	(12.258330249197702,31)
15868	2159	(34.341978045700891,40.75)
15869	1947	(23.516660498395403,37)
15870	2159	(34.341978045700891,40.75)
15871	1269	(25.681724007856502,24.25)
15872	1376	(13.99038105676658,26.5)
15873	1376	(13.99038105676658,26.5)
15874	2400	(35.208003449485325,45.25)
15875	2200	(34.774990747593108,41.5)
15876	2356	(31.310889132455351,44.5)
15877	2399	(34.341978045700891,45.25)
15878	1616	(13.99038105676658,31)
15879	1864	(20.918584287042091,35.5)
15880	1920	(35.208003449485325,36.25)
15881	1158	(33.042939940024233,22)
15882	839	(33.908965343808667,16)
15883	840	(34.774990747593108,16)
15884	1160	(34.774990747593108,22)
15885	1160	(34.774990747593108,22)
15886	1360	(35.208003449485325,25.75)
15887	2317	(32.609927238132009,43.75)
15888	2269	(25.248711305964282,43)
15889	2358	(33.042939940024233,44.5)
15890	1356	(31.743901834347572,25.75)
15891	2310	(26.54774941164094,43.75)
15892	2310	(26.54774941164094,43.75)
15893	2398	(33.47595264191645,45.25)
15894	2111	(26.98076211353316,40)
15895	956	(31.743901834347572,18.25)
15896	956	(31.743901834347572,18.25)
15897	1240	(34.774990747593108,23.5)
15898	1240	(34.774990747593108,23.5)
15899	1360	(35.208003449485325,25.75)
15900	1197	(32.609927238132009,22.75)
15901	839	(33.908965343808667,16)
15902	840	(34.774990747593108,16)
15903	156	(31.743901834347572,3.25)
15904	156	(31.743901834347572,3.25)
15905	1476	(31.310889132455351,28)
15906	1753	(29.145825622994256,33.25)
15907	1715	(30.444863728670914,32.5)
15908	1676	(31.743901834347572,31.75)
15909	1717	(32.176914536239792,32.5)
15910	1718	(33.042939940024233,32.5)
15911	2033	(28.712812921102035,38.5)
15912	2033	(28.712812921102035,38.5)
15913	2033	(28.712812921102035,38.5)
15914	2111	(26.98076211353316,40)
15915	2157	(32.609927238132009,40.75)
15916	2156	(31.743901834347572,40.75)
15917	2237	(32.609927238132009,42.25)
15918	2394	(30.011851026778693,45.25)
15919	2098	(15.722431864335457,40)
15920	2098	(15.722431864335457,40)
15921	1822	(19.619546181365433,34.75)
15922	2094	(12.258330249197702,40)
15923	1809	(8.3612159321677293,34.75)
15924	1216	(13.99038105676658,23.5)
15925	1306	(22.650635094610966,25)
15926	441	(1.4330127018922194,9.25)
15927	441	(1.4330127018922194,9.25)
15928	644	(3.598076211353316,13)
15929	644	(3.598076211353316,13)
15930	1249	(8.3612159321677293,24.25)
15931	1249	(8.3612159321677293,24.25)
15932	1287	(6.196152422706632,25)
15933	1125	(4.4641016151377544,22)
15934	1240	(34.774990747593108,23.5)
15935	1399	(33.908965343808667,26.5)
15936	439	(33.908965343808667,8.5)
15937	560	(35.208003449485325,10.75)
15938	388	(24.815698604072061,7.75)
15939	560	(35.208003449485325,10.75)
15940	156	(31.743901834347572,3.25)
15941	156	(31.743901834347572,3.25)
15942	1715	(30.444863728670914,32.5)
15943	1717	(32.176914536239792,32.5)
15944	481	(1,10)
15945	481	(1,10)
15946	481	(1,10)
15947	481	(1,10)
15948	644	(3.598076211353316,13)
15949	644	(3.598076211353316,13)
15950	1249	(8.3612159321677293,24.25)
15951	1249	(8.3612159321677293,24.25)
15952	1140	(17.454482671904334,22)
15953	1182	(19.619546181365433,22.75)
15954	152	(28.279800219209818,3.25)
15955	152	(28.279800219209818,3.25)
15956	300	(17.887495373796554,6.25)
15957	300	(17.887495373796554,6.25)
15958	339	(16.588457268119896,7)
15959	339	(16.588457268119896,7)
15960	303	(20.48557158514987,6.25)
15961	303	(20.48557158514987,6.25)
15962	32	(27.846787517317598,1)
15963	32	(27.846787517317598,1)
15964	152	(28.279800219209818,3.25)
15965	152	(28.279800219209818,3.25)
15966	153	(29.145825622994256,3.25)
15967	153	(29.145825622994256,3.25)
15968	152	(28.279800219209818,3.25)
15969	152	(28.279800219209818,3.25)
15970	153	(29.145825622994256,3.25)
15971	151	(27.413774815425377,3.25)
15972	151	(27.413774815425377,3.25)
15973	33	(28.712812921102035,1)
15974	32	(27.846787517317598,1)
15975	32	(27.846787517317598,1)
15976	32	(27.846787517317598,1)
15977	32	(27.846787517317598,1)
15978	160	(35.208003449485325,3.25)
15979	200	(34.774990747593108,4)
15980	160	(35.208003449485325,3.25)
15981	200	(34.774990747593108,4)
15982	757	(32.176914536239792,14.5)
15983	757	(32.176914536239792,14.5)
15984	597	(32.176914536239792,11.5)
15985	597	(32.176914536239792,11.5)
15986	990	(26.114736709748719,19)
15987	947	(23.949673200287624,18.25)
15988	1063	(20.05255888325765,20.5)
15989	1427	(23.949673200287624,27.25)
15990	1427	(23.949673200287624,27.25)
15991	1427	(23.949673200287624,27.25)
15992	1467	(23.516660498395403,28)
15993	1541	(18.320508075688775,29.5)
15994	1509	(25.681724007856502,28.75)
15995	1960	(34.774990747593108,37)
15996	2196	(31.310889132455351,41.5)
15997	2359	(33.908965343808667,44.5)
15998	2279	(33.908965343808667,43)
15999	1954	(29.578838324886476,37)
16000	1610	(8.794228634059948,31)
16001	1647	(6.6291651245988508,31.75)
16002	2070	(26.54774941164094,39.25)
16003	1488	(7.49519052838329,28.75)
16004	1488	(7.49519052838329,28.75)
16005	2123	(3.1650635094610968,40.75)
16006	1877	(32.176914536239792,35.5)
16007	2070	(26.54774941164094,39.25)
16008	2069	(25.681724007856502,39.25)
16009	2068	(24.815698604072061,39.25)
16010	412	(10.526279441628825,8.5)
16011	2071	(27.413774815425377,39.25)
16012	2233	(29.145825622994256,42.25)
16013	364	(4.0310889132455356,7.75)
16014	364	(4.0310889132455356,7.75)
16015	1	(1,1)
16016	1	(1,1)
16017	1	(1,1)
16018	2136	(14.423393758658799,40.75)
16019	2137	(15.289419162443238,40.75)
16020	2216	(14.423393758658799,42.25)
16021	1355	(30.877876430563134,25.75)
16022	1355	(30.877876430563134,25.75)
16023	1355	(30.877876430563134,25.75)
16024	1355	(30.877876430563134,25.75)
16025	2118	(33.042939940024233,40)
16026	1355	(30.877876430563134,25.75)
16027	2159	(34.341978045700891,40.75)
16028	2159	(34.341978045700891,40.75)
16029	1687	(6.196152422706632,32.5)
16030	1706	(22.650635094610966,32.5)
16031	1135	(13.124355652982141,22)
16032	1570	(9.2272413359521668,30.25)
16033	1520	(35.208003449485325,28.75)
16034	2279	(33.908965343808667,43)
16035	44	(4.0310889132455356,1.75)
16036	83	(2.7320508075688772,2.5)
16037	2127	(6.6291651245988508,40.75)
16038	2124	(4.0310889132455356,40.75)
16039	2321	(1,44.5)
16040	2361	(1.4330127018922194,45.25)
16041	2321	(1,44.5)
16042	2321	(1,44.5)
16043	2323	(2.7320508075688772,44.5)
16044	2324	(3.598076211353316,44.5)
16045	2323	(2.7320508075688772,44.5)
16046	2323	(2.7320508075688772,44.5)
16047	2323	(2.7320508075688772,44.5)
16048	1962	(2.299038105676658,37.75)
16049	2060	(17.887495373796554,39.25)
16050	1738	(16.155444566227676,33.25)
16051	1971	(10.093266739736606,37.75)
16052	2168	(7.0621778264910704,41.5)
16053	2279	(33.908965343808667,43)
16054	444	(4.0310889132455356,9.25)
16055	564	(3.598076211353316,11.5)
16056	522	(2.299038105676658,10.75)
16057	521	(1.4330127018922194,10.75)
16058	803	(2.7320508075688772,16)
16059	1370	(8.794228634059948,26.5)
16060	441	(1.4330127018922194,9.25)
16061	601	(1.4330127018922194,12.25)
16062	1249	(8.3612159321677293,24.25)
16063	1125	(4.4641016151377544,22)
16064	603	(3.1650635094610968,12.25)
16065	446	(5.7631397208144124,9.25)
16066	601	(1.4330127018922194,12.25)
16067	1205	(4.4641016151377544,23.5)
16068	1126	(5.3301270189221936,22)
16069	1085	(4.897114317029974,21.25)
16070	1084	(4.0310889132455356,21.25)
16071	964	(3.598076211353316,19)
16072	402	(1.8660254037844386,8.5)
16073	601	(1.4330127018922194,12.25)
16074	1416	(14.423393758658799,27.25)
16075	1252	(10.959292143521045,24.25)
16076	1412	(10.959292143521045,27.25)
16077	1451	(9.6602540378443873,28)
16078	1451	(9.6602540378443873,28)
16079	1410	(9.2272413359521668,27.25)
16080	1411	(10.093266739736606,27.25)
16081	1708	(24.382685902179844,32.5)
16082	1708	(24.382685902179844,32.5)
16083	1708	(24.382685902179844,32.5)
16084	1708	(24.382685902179844,32.5)
16085	1708	(24.382685902179844,32.5)
16086	855	(13.55736835487436,16.75)
16087	1706	(22.650635094610966,32.5)
16088	1750	(26.54774941164094,33.25)
16089	938	(16.155444566227676,18.25)
16090	934	(12.691342951089922,18.25)
16091	1790	(26.114736709748719,34)
16092	1248	(7.49519052838329,24.25)
16093	1085	(4.897114317029974,21.25)
16094	2372	(10.959292143521045,45.25)
16095	1786	(22.650635094610966,34)
16096	1786	(22.650635094610966,34)
16097	2374	(12.691342951089922,45.25)
16098	2374	(12.691342951089922,45.25)
16099	2374	(12.691342951089922,45.25)
16100	2372	(10.959292143521045,45.25)
16101	1954	(29.578838324886476,37)
16102	1610	(8.794228634059948,31)
16103	1647	(6.6291651245988508,31.75)
16104	2111	(26.98076211353316,40)
16105	1608	(7.0621778264910704,31)
16106	1530	(8.794228634059948,29.5)
16107	2111	(26.98076211353316,40)
16108	2069	(25.681724007856502,39.25)
16109	2372	(10.959292143521045,45.25)
16110	2371	(10.093266739736606,45.25)
16111	2371	(10.093266739736606,45.25)
16112	2111	(26.98076211353316,40)
16113	2071	(27.413774815425377,39.25)
16114	1525	(4.4641016151377544,29.5)
16115	1524	(3.598076211353316,29.5)
16116	1645	(4.897114317029974,31.75)
16117	2156	(31.743901834347572,40.75)
16118	2156	(31.743901834347572,40.75)
16119	1786	(22.650635094610966,34)
16120	1786	(22.650635094610966,34)
16121	1427	(23.949673200287624,27.25)
16122	1460	(17.454482671904334,28)
16123	1460	(17.454482671904334,28)
16124	1537	(14.856406460551018,29.5)
16125	1623	(20.05255888325765,31)
16126	2194	(29.578838324886476,41.5)
16127	2157	(32.609927238132009,40.75)
16128	1339	(17.021469970012117,25.75)
16129	1219	(16.588457268119896,23.5)
16130	1340	(17.887495373796554,25.75)
16131	1336	(14.423393758658799,25.75)
16132	1336	(14.423393758658799,25.75)
16133	1379	(16.588457268119896,26.5)
16134	1376	(13.99038105676658,26.5)
16135	911	(26.98076211353316,17.5)
16136	911	(26.98076211353316,17.5)
16137	1152	(27.846787517317598,22)
16138	1140	(17.454482671904334,22)
16139	1187	(23.949673200287624,22.75)
16140	1065	(21.784609690826528,20.5)
16141	1062	(19.186533479473212,20.5)
16142	424	(20.918584287042091,8.5)
16143	424	(20.918584287042091,8.5)
16144	2373	(11.825317547305483,45.25)
16145	1063	(20.05255888325765,20.5)
16146	1232	(27.846787517317598,23.5)
16147	111	(26.98076211353316,2.5)
16148	34	(29.578838324886476,1)
16149	34	(29.578838324886476,1)
16150	33	(28.712812921102035,1)
16151	32	(27.846787517317598,1)
16152	151	(27.413774815425377,3.25)
16153	1715	(30.444863728670914,32.5)
16154	1718	(33.042939940024233,32.5)
16155	275	(30.444863728670914,5.5)
16156	390	(26.54774941164094,7.75)
16157	38	(33.042939940024233,1)
16158	80	(35.208003449485325,1.75)
16159	80	(35.208003449485325,1.75)
16160	79	(34.341978045700891,1.75)
16161	1715	(30.444863728670914,32.5)
16162	1718	(33.042939940024233,32.5)
16163	2262	(19.186533479473212,43)
16164	2259	(16.588457268119896,43)
16165	1647	(6.6291651245988508,31.75)
16166	2264	(20.918584287042091,43)
16167	2302	(19.619546181365433,43.75)
16168	2362	(2.299038105676658,45.25)
16169	2342	(19.186533479473212,44.5)
16170	2364	(4.0310889132455356,45.25)
16171	2347	(23.516660498395403,44.5)
16172	2306	(23.083647796503186,43.75)
16173	2361	(1.4330127018922194,45.25)
16174	2361	(1.4330127018922194,45.25)
16175	2361	(1.4330127018922194,45.25)
16176	1858	(15.722431864335457,35.5)
16177	1978	(16.155444566227676,37.75)
16178	1739	(17.021469970012117,33.25)
16179	2060	(17.887495373796554,39.25)
16180	1893	(11.825317547305483,36.25)
16181	1772	(10.526279441628825,34)
16182	1893	(11.825317547305483,36.25)
16183	1929	(7.9282032302755088,37)
16184	1977	(15.289419162443238,37.75)
16185	1814	(12.691342951089922,34.75)
16186	1977	(15.289419162443238,37.75)
16187	1822	(19.619546181365433,34.75)
16188	1977	(15.289419162443238,37.75)
16189	1769	(7.9282032302755088,34)
16190	2292	(10.959292143521045,43.75)
16191	1977	(15.289419162443238,37.75)
16192	1977	(15.289419162443238,37.75)
16193	1902	(19.619546181365433,36.25)
16194	1822	(19.619546181365433,34.75)
16195	2207	(6.6291651245988508,42.25)
16196	1822	(19.619546181365433,34.75)
16197	1851	(9.6602540378443873,35.5)
16198	1977	(15.289419162443238,37.75)
16199	2255	(13.124355652982141,43)
16200	2170	(8.794228634059948,41.5)
16201	1807	(6.6291651245988508,34.75)
16202	2091	(9.6602540378443873,40)
16203	2205	(4.897114317029974,42.25)
16204	1924	(3.598076211353316,37)
16205	2212	(10.959292143521045,42.25)
16206	2098	(15.722431864335457,40)
16207	1814	(12.691342951089922,34.75)
16208	1814	(12.691342951089922,34.75)
16209	336	(13.99038105676658,7)
16210	819	(16.588457268119896,16)
16211	821	(18.320508075688775,16)
16212	819	(16.588457268119896,16)
16213	2003	(2.7320508075688772,38.5)
16214	2170	(8.794228634059948,41.5)
16215	2127	(6.6291651245988508,40.75)
16216	1893	(11.825317547305483,36.25)
16217	1769	(7.9282032302755088,34)
16218	101	(18.320508075688775,2.5)
16219	101	(18.320508075688775,2.5)
16220	98	(15.722431864335457,2.5)
16221	17	(14.856406460551018,1)
16222	17	(14.856406460551018,1)
16223	58	(16.155444566227676,1.75)
16224	10	(8.794228634059948,1)
16225	178	(15.722431864335457,4)
16226	140	(17.887495373796554,3.25)
16227	15	(13.124355652982141,1)
16228	1768	(7.0621778264910704,34)
16229	2292	(10.959292143521045,43.75)
16230	1971	(10.093266739736606,37.75)
16231	2094	(12.258330249197702,40)
16232	2157	(32.609927238132009,40.75)
16233	1807	(6.6291651245988508,34.75)
16234	1925	(4.4641016151377544,37)
16235	178	(15.722431864335457,4)
16236	2170	(8.794228634059948,41.5)
16237	7	(6.196152422706632,1)
16238	7	(6.196152422706632,1)
16239	7	(6.196152422706632,1)
16240	7	(6.196152422706632,1)
16241	5	(4.4641016151377544,1)
16242	45	(4.897114317029974,1.75)
16243	283	(3.1650635094610968,6.25)
16244	281	(1.4330127018922194,6.25)
16245	281	(1.4330127018922194,6.25)
16246	321	(1,7)
16247	1920	(35.208003449485325,36.25)
16248	917	(32.176914536239792,17.5)
16249	840	(34.774990747593108,16)
16250	840	(34.774990747593108,16)
16251	1229	(25.248711305964282,23.5)
16252	2374	(12.691342951089922,45.25)
16253	2374	(12.691342951089922,45.25)
16254	2374	(12.691342951089922,45.25)
16255	2337	(14.856406460551018,44.5)
16256	969	(7.9282032302755088,19)
16257	1467	(23.516660498395403,28)
16258	344	(20.918584287042091,7)
16259	791	(27.413774815425377,15.25)
16260	888	(7.0621778264910704,17.5)
16261	888	(7.0621778264910704,17.5)
16262	928	(7.49519052838329,18.25)
16263	1046	(5.3301270189221936,20.5)
16264	1046	(5.3301270189221936,20.5)
16265	1046	(5.3301270189221936,20.5)
16266	1005	(4.897114317029974,19.75)
16267	1427	(23.949673200287624,27.25)
16268	928	(7.49519052838329,18.25)
16269	928	(7.49519052838329,18.25)
16270	1047	(6.196152422706632,20.5)
16271	2400	(35.208003449485325,45.25)
16272	2200	(34.774990747593108,41.5)
16273	2356	(31.310889132455351,44.5)
16274	1355	(30.877876430563134,25.75)
16275	2398	(33.47595264191645,45.25)
16276	1160	(34.774990747593108,22)
16277	1160	(34.774990747593108,22)
16278	1439	(34.341978045700891,27.25)
16279	2317	(32.609927238132009,43.75)
16280	2269	(25.248711305964282,43)
16281	2358	(33.042939940024233,44.5)
16282	1356	(31.743901834347572,25.75)
16283	2310	(26.54774941164094,43.75)
16284	2310	(26.54774941164094,43.75)
16285	765	(4.897114317029974,15.25)
16286	2068	(24.815698604072061,39.25)
16287	448	(7.49519052838329,9.25)
16288	490	(8.794228634059948,10)
16289	487	(6.196152422706632,10)
16290	1414	(12.691342951089922,27.25)
16291	483	(2.7320508075688772,10)
16292	490	(8.794228634059948,10)
16293	487	(6.196152422706632,10)
16294	1213	(11.392304845413264,23.5)
16295	483	(2.7320508075688772,10)
16296	1879	(33.908965343808667,35.5)
16297	1612	(10.526279441628825,31)
16298	1572	(10.959292143521045,30.25)
16299	152	(28.279800219209818,3.25)
16300	229	(25.681724007856502,4.75)
16301	229	(25.681724007856502,4.75)
16302	917	(32.176914536239792,17.5)
16303	997	(32.176914536239792,19)
16304	395	(30.877876430563134,7.75)
16305	391	(27.413774815425377,7.75)
16306	152	(28.279800219209818,3.25)
16307	189	(25.248711305964282,4)
16308	840	(34.774990747593108,16)
16309	75	(30.877876430563134,1.75)
16310	189	(25.248711305964282,4)
16311	840	(34.774990747593108,16)
16312	75	(30.877876430563134,1.75)
16313	34	(29.578838324886476,1)
16314	75	(30.877876430563134,1.75)
16315	75	(30.877876430563134,1.75)
16316	840	(34.774990747593108,16)
16317	33	(28.712812921102035,1)
16318	73	(29.145825622994256,1.75)
16319	33	(28.712812921102035,1)
16320	33	(28.712812921102035,1)
16321	33	(28.712812921102035,1)
16322	840	(34.774990747593108,16)
16323	390	(26.54774941164094,7.75)
16324	31	(26.98076211353316,1)
16325	151	(27.413774815425377,3.25)
16326	73	(29.145825622994256,1.75)
16327	73	(29.145825622994256,1.75)
16328	840	(34.774990747593108,16)
16329	431	(26.98076211353316,8.5)
16330	390	(26.54774941164094,7.75)
16331	31	(26.98076211353316,1)
16332	151	(27.413774815425377,3.25)
16333	73	(29.145825622994256,1.75)
16334	153	(29.145825622994256,3.25)
16335	840	(34.774990747593108,16)
16336	1480	(34.774990747593108,28)
16337	431	(26.98076211353316,8.5)
16338	151	(27.413774815425377,3.25)
16339	31	(26.98076211353316,1)
16340	73	(29.145825622994256,1.75)
16341	1753	(29.145825622994256,33.25)
16342	1476	(31.310889132455351,28)
16343	431	(26.98076211353316,8.5)
16344	391	(27.413774815425377,7.75)
16345	153	(29.145825622994256,3.25)
16346	423	(20.05255888325765,8.5)
16347	423	(20.05255888325765,8.5)
16348	423	(20.05255888325765,8.5)
16349	461	(18.753520777580992,9.25)
16350	792	(28.279800219209818,15.25)
16351	391	(27.413774815425377,7.75)
16352	391	(27.413774815425377,7.75)
16353	391	(27.413774815425377,7.75)
16354	391	(27.413774815425377,7.75)
16355	391	(27.413774815425377,7.75)
16356	350	(26.114736709748719,7)
16357	350	(26.114736709748719,7)
16358	350	(26.114736709748719,7)
16359	350	(26.114736709748719,7)
16360	350	(26.114736709748719,7)
16361	1350	(26.54774941164094,25.75)
16362	350	(26.114736709748719,7)
16363	1186	(23.083647796503186,22.75)
16364	141	(18.753520777580992,3.25)
16365	1342	(19.619546181365433,25.75)
16366	1392	(27.846787517317598,26.5)
16367	1427	(23.949673200287624,27.25)
16368	1432	(28.279800219209818,27.25)
16369	1350	(26.54774941164094,25.75)
16370	1032	(28.279800219209818,19.75)
16371	1069	(25.248711305964282,20.5)
16372	1387	(23.516660498395403,26.5)
16373	1427	(23.949673200287624,27.25)
16374	1182	(19.619546181365433,22.75)
16375	2279	(33.908965343808667,43)
16376	839	(33.908965343808667,16)
16377	840	(34.774990747593108,16)
16378	840	(34.774990747593108,16)
16379	840	(34.774990747593108,16)
16380	840	(34.774990747593108,16)
16381	840	(34.774990747593108,16)
16382	1480	(34.774990747593108,28)
16383	574	(12.258330249197702,11.5)
16384	1911	(27.413774815425377,36.25)
16385	2035	(30.444863728670914,38.5)
16386	1253	(11.825317547305483,24.25)
16387	1525	(4.4641016151377544,29.5)
16388	856	(14.423393758658799,16.75)
16389	856	(14.423393758658799,16.75)
16390	1529	(7.9282032302755088,29.5)
16391	1947	(23.516660498395403,37)
16392	1954	(29.578838324886476,37)
16393	1610	(8.794228634059948,31)
16394	1647	(6.6291651245988508,31.75)
16395	1414	(12.691342951089922,27.25)
16396	524	(4.0310889132455356,10.75)
16397	1792	(27.846787517317598,34)
16398	1864	(20.918584287042091,35.5)
16399	936	(14.423393758658799,18.25)
16400	815	(13.124355652982141,16)
16401	485	(4.4641016151377544,10)
16402	815	(13.124355652982141,16)
16403	813	(11.392304845413264,16)
16404	1864	(20.918584287042091,35.5)
16405	2392	(28.279800219209818,45.25)
16406	2159	(34.341978045700891,40.75)
16407	2394	(30.011851026778693,45.25)
16408	2274	(29.578838324886476,43)
16409	2274	(29.578838324886476,43)
16410	1765	(4.4641016151377544,34)
16411	1873	(28.712812921102035,35.5)
16412	1872	(27.846787517317598,35.5)
16413	1907	(23.949673200287624,36.25)
16414	2159	(34.341978045700891,40.75)
16415	1709	(25.248711305964282,32.5)
16416	1709	(25.248711305964282,32.5)
16417	229	(25.681724007856502,4.75)
16418	190	(26.114736709748719,4)
16419	190	(26.114736709748719,4)
16420	75	(30.877876430563134,1.75)
16421	75	(30.877876430563134,1.75)
16422	112	(27.846787517317598,2.5)
16423	2392	(28.279800219209818,45.25)
16424	1947	(23.516660498395403,37)
16425	1715	(30.444863728670914,32.5)
16426	1718	(33.042939940024233,32.5)
16427	839	(33.908965343808667,16)
16428	840	(34.774990747593108,16)
16429	840	(34.774990747593108,16)
16430	840	(34.774990747593108,16)
16431	840	(34.774990747593108,16)
16432	840	(34.774990747593108,16)
16433	190	(26.114736709748719,4)
16434	190	(26.114736709748719,4)
16435	75	(30.877876430563134,1.75)
16436	33	(28.712812921102035,1)
16437	73	(29.145825622994256,1.75)
16438	38	(33.042939940024233,1)
16439	200	(34.774990747593108,4)
16440	200	(34.774990747593108,4)
16441	79	(34.341978045700891,1.75)
16442	423	(20.05255888325765,8.5)
16443	423	(20.05255888325765,8.5)
16444	424	(20.918584287042091,8.5)
16445	344	(20.918584287042091,7)
16446	1501	(18.753520777580992,28.75)
16447	1501	(18.753520777580992,28.75)
16448	1542	(19.186533479473212,29.5)
16449	1350	(26.54774941164094,25.75)
16450	1350	(26.54774941164094,25.75)
16451	1427	(23.949673200287624,27.25)
16452	1633	(28.712812921102035,31)
16453	173	(11.392304845413264,4)
16454	95	(13.124355652982141,2.5)
16455	134	(12.691342951089922,3.25)
16456	173	(11.392304845413264,4)
16457	133	(11.825317547305483,3.25)
16458	175	(13.124355652982141,4)
16459	17	(14.856406460551018,1)
16460	10	(8.794228634059948,1)
16461	784	(21.351596988934308,15.25)
16462	627	(23.949673200287624,12.25)
16463	457	(15.289419162443238,9.25)
16464	457	(15.289419162443238,9.25)
16465	457	(15.289419162443238,9.25)
16466	457	(15.289419162443238,9.25)
16467	659	(16.588457268119896,13)
16468	659	(16.588457268119896,13)
16469	659	(16.588457268119896,13)
16470	945	(22.217622392718749,18.25)
16471	945	(22.217622392718749,18.25)
16472	1240	(34.774990747593108,23.5)
16473	1399	(33.908965343808667,26.5)
16474	1480	(34.774990747593108,28)
16475	1598	(33.47595264191645,30.25)
16476	1600	(35.208003449485325,30.25)
16477	1240	(34.774990747593108,23.5)
16478	1240	(34.774990747593108,23.5)
16479	1240	(34.774990747593108,23.5)
16480	1360	(35.208003449485325,25.75)
16481	1597	(32.609927238132009,30.25)
16482	1600	(35.208003449485325,30.25)
16483	1148	(24.382685902179844,22)
16484	1135	(13.124355652982141,22)
16485	2156	(31.743901834347572,40.75)
16486	2154	(30.011851026778693,40.75)
16487	2233	(29.145825622994256,42.25)
16488	2347	(23.516660498395403,44.5)
16489	2348	(24.382685902179844,44.5)
16490	2347	(23.516660498395403,44.5)
16491	2279	(33.908965343808667,43)
16492	2397	(32.609927238132009,45.25)
16493	2397	(32.609927238132009,45.25)
16494	1885	(4.897114317029974,36.25)
16495	1925	(4.4641016151377544,37)
16496	326	(5.3301270189221936,7)
16497	1	(1,1)
16498	1	(1,1)
16499	1	(1,1)
16500	1960	(34.774990747593108,37)
16501	2196	(31.310889132455351,41.5)
16502	2359	(33.908965343808667,44.5)
16503	2279	(33.908965343808667,43)
16504	2273	(28.712812921102035,43)
16505	2324	(3.598076211353316,44.5)
16506	2323	(2.7320508075688772,44.5)
16507	2323	(2.7320508075688772,44.5)
16508	2323	(2.7320508075688772,44.5)
16509	2323	(2.7320508075688772,44.5)
16510	2323	(2.7320508075688772,44.5)
16511	2323	(2.7320508075688772,44.5)
16512	2284	(4.0310889132455356,43.75)
16513	2323	(2.7320508075688772,44.5)
16514	2201	(1.4330127018922194,42.25)
16515	2006	(5.3301270189221936,38.5)
16516	2049	(8.3612159321677293,39.25)
16517	2008	(7.0621778264910704,38.5)
16518	2047	(6.6291651245988508,39.25)
16519	2206	(5.7631397208144124,42.25)
16520	2006	(5.3301270189221936,38.5)
16521	1768	(7.0621778264910704,34)
16522	2279	(33.908965343808667,43)
16523	441	(1.4330127018922194,9.25)
16524	441	(1.4330127018922194,9.25)
16525	603	(3.1650635094610968,12.25)
16526	644	(3.598076211353316,13)
16527	644	(3.598076211353316,13)
16528	1370	(8.794228634059948,26.5)
16529	1249	(8.3612159321677293,24.25)
16530	1087	(6.6291651245988508,21.25)
16531	1087	(6.6291651245988508,21.25)
16532	1087	(6.6291651245988508,21.25)
16533	1125	(4.4641016151377544,22)
16534	1125	(4.4641016151377544,22)
16535	1084	(4.0310889132455356,21.25)
16536	964	(3.598076211353316,19)
16537	964	(3.598076211353316,19)
16538	1121	(1,22)
16539	978	(15.722431864335457,19)
16540	1451	(9.6602540378443873,28)
16541	1416	(14.423393758658799,27.25)
16542	1415	(13.55736835487436,27.25)
16543	1374	(12.258330249197702,26.5)
16544	1416	(14.423393758658799,27.25)
16545	1708	(24.382685902179844,32.5)
16546	1525	(4.4641016151377544,29.5)
16547	1708	(24.382685902179844,32.5)
16548	1786	(22.650635094610966,34)
16549	855	(13.55736835487436,16.75)
16550	1750	(26.54774941164094,33.25)
16551	1706	(22.650635094610966,32.5)
16552	934	(12.691342951089922,18.25)
16553	2034	(29.578838324886476,38.5)
16554	2034	(29.578838324886476,38.5)
16555	1905	(22.217622392718749,36.25)
16556	2289	(8.3612159321677293,43.75)
16557	2370	(9.2272413359521668,45.25)
16558	1786	(22.650635094610966,34)
16559	1578	(16.155444566227676,30.25)
16560	2374	(12.691342951089922,45.25)
16561	2374	(12.691342951089922,45.25)
16562	2374	(12.691342951089922,45.25)
16563	2373	(11.825317547305483,45.25)
16564	1954	(29.578838324886476,37)
16565	1610	(8.794228634059948,31)
16566	1647	(6.6291651245988508,31.75)
16567	1911	(27.413774815425377,36.25)
16568	2113	(28.712812921102035,40)
16569	2034	(29.578838324886476,38.5)
16570	2111	(26.98076211353316,40)
16571	2069	(25.681724007856502,39.25)
16572	2034	(29.578838324886476,38.5)
16573	2068	(24.815698604072061,39.25)
16574	1606	(5.3301270189221936,31)
16575	2111	(26.98076211353316,40)
16576	2071	(27.413774815425377,39.25)
16577	1525	(4.4641016151377544,29.5)
16578	1525	(4.4641016151377544,29.5)
16579	1609	(7.9282032302755088,31)
16580	2194	(29.578838324886476,41.5)
16581	1350	(26.54774941164094,25.75)
16582	1306	(22.650635094610966,25)
16583	1547	(23.516660498395403,29.5)
16584	1471	(26.98076211353316,28)
16585	1501	(18.753520777580992,28.75)
16586	1424	(21.351596988934308,27.25)
16587	1537	(14.856406460551018,29.5)
16588	1378	(15.722431864335457,26.5)
16589	1417	(15.289419162443238,27.25)
16590	1140	(17.454482671904334,22)
16591	1220	(17.454482671904334,23.5)
16592	1112	(28.279800219209818,21.25)
16593	1340	(17.887495373796554,25.75)
16594	1417	(15.289419162443238,27.25)
16595	1296	(13.99038105676658,25)
16596	1302	(19.186533479473212,25)
16597	1216	(13.99038105676658,23.5)
16598	911	(26.98076211353316,17.5)
16599	1647	(6.6291651245988508,31.75)
16600	1112	(28.279800219209818,21.25)
16601	1140	(17.454482671904334,22)
16602	1108	(24.815698604072061,21.25)
16603	1025	(22.217622392718749,19.75)
16604	1062	(19.186533479473212,20.5)
16605	424	(20.918584287042091,8.5)
16606	424	(20.918584287042091,8.5)
16607	1187	(23.949673200287624,22.75)
16608	1068	(24.382685902179844,20.5)
16609	1501	(18.753520777580992,28.75)
16610	1417	(15.289419162443238,27.25)
16611	33	(28.712812921102035,1)
16612	33	(28.712812921102035,1)
16613	31	(26.98076211353316,1)
16614	152	(28.279800219209818,3.25)
16615	1715	(30.444863728670914,32.5)
16616	1718	(33.042939940024233,32.5)
16617	39	(33.908965343808667,1)
16618	39	(33.908965343808667,1)
16619	80	(35.208003449485325,1.75)
16620	80	(35.208003449485325,1.75)
16621	80	(35.208003449485325,1.75)
16622	80	(35.208003449485325,1.75)
16623	1715	(30.444863728670914,32.5)
16624	1718	(33.042939940024233,32.5)
16625	2347	(23.516660498395403,44.5)
16626	2347	(23.516660498395403,44.5)
16627	2262	(19.186533479473212,43)
16628	2342	(19.186533479473212,44.5)
16629	2342	(19.186533479473212,44.5)
16630	2301	(18.753520777580992,43.75)
16631	2364	(4.0310889132455356,45.25)
16632	2362	(2.299038105676658,45.25)
16633	2361	(1.4330127018922194,45.25)
16634	2361	(1.4330127018922194,45.25)
16635	2321	(1,44.5)
16636	1739	(17.021469970012117,33.25)
16637	1739	(17.021469970012117,33.25)
16638	1822	(19.619546181365433,34.75)
16639	2362	(2.299038105676658,45.25)
16640	1772	(10.526279441628825,34)
16641	1772	(10.526279441628825,34)
16642	1929	(7.9282032302755088,37)
16643	1927	(6.196152422706632,37)
16644	2060	(17.887495373796554,39.25)
16645	1851	(9.6602540378443873,35.5)
16646	1891	(10.093266739736606,36.25)
16647	2060	(17.887495373796554,39.25)
16648	1769	(7.9282032302755088,34)
16649	1769	(7.9282032302755088,34)
16650	2060	(17.887495373796554,39.25)
16651	2255	(13.124355652982141,43)
16652	1807	(6.6291651245988508,34.75)
16653	2060	(17.887495373796554,39.25)
16654	2052	(10.959292143521045,39.25)
16655	2044	(4.0310889132455356,39.25)
16656	2052	(10.959292143521045,39.25)
16657	1925	(4.4641016151377544,37)
16658	2213	(11.825317547305483,42.25)
16659	2213	(11.825317547305483,42.25)
16660	2098	(15.722431864335457,40)
16661	1894	(12.691342951089922,36.25)
16662	2098	(15.722431864335457,40)
16663	2097	(14.856406460551018,40)
16664	390	(26.54774941164094,7.75)
16665	431	(26.98076211353316,8.5)
16666	392	(28.279800219209818,7.75)
16667	336	(13.99038105676658,7)
16668	782	(19.619546181365433,15.25)
16669	821	(18.320508075688775,16)
16670	819	(16.588457268119896,16)
16671	101	(18.320508075688775,2.5)
16672	101	(18.320508075688775,2.5)
16673	98	(15.722431864335457,2.5)
16674	17	(14.856406460551018,1)
16675	98	(15.722431864335457,2.5)
16676	17	(14.856406460551018,1)
16677	10	(8.794228634059948,1)
16678	58	(16.155444566227676,1.75)
16679	15	(13.124355652982141,1)
16680	2189	(25.248711305964282,41.5)
16681	2111	(26.98076211353316,40)
16682	44	(4.0310889132455356,1.75)
16683	7	(6.196152422706632,1)
16684	7	(6.196152422706632,1)
16685	6	(5.3301270189221936,1)
16686	5	(4.4641016151377544,1)
16687	45	(4.897114317029974,1.75)
16688	321	(1,7)
16689	243	(2.7320508075688772,5.5)
16690	281	(1.4330127018922194,6.25)
16691	321	(1,7)
16692	366	(5.7631397208144124,7.75)
16693	1229	(25.248711305964282,23.5)
16694	969	(7.9282032302755088,19)
16695	1508	(24.815698604072061,28.75)
16696	344	(20.918584287042091,7)
16697	791	(27.413774815425377,15.25)
16698	1464	(20.918584287042091,28)
16699	888	(7.0621778264910704,17.5)
16700	1007	(6.6291651245988508,19.75)
16701	1047	(6.196152422706632,20.5)
16702	1046	(5.3301270189221936,20.5)
16703	1005	(4.897114317029974,19.75)
16704	1005	(4.897114317029974,19.75)
16705	1508	(24.815698604072061,28.75)
16706	928	(7.49519052838329,18.25)
16707	1047	(6.196152422706632,20.5)
16708	2400	(35.208003449485325,45.25)
16709	2200	(34.774990747593108,41.5)
16710	2356	(31.310889132455351,44.5)
16711	1355	(30.877876430563134,25.75)
16712	2398	(33.47595264191645,45.25)
16713	2310	(26.54774941164094,43.75)
16714	2150	(26.54774941164094,40.75)
16715	2310	(26.54774941164094,43.75)
16716	1647	(6.6291651245988508,31.75)
16717	1606	(5.3301270189221936,31)
16718	1160	(34.774990747593108,22)
16719	1160	(34.774990747593108,22)
16720	1360	(35.208003449485325,25.75)
16721	2317	(32.609927238132009,43.75)
16722	2269	(25.248711305964282,43)
16723	2358	(33.042939940024233,44.5)
16724	1356	(31.743901834347572,25.75)
16725	1360	(35.208003449485325,25.75)
16726	1961	(1.4330127018922194,37.75)
16727	2170	(8.794228634059948,41.5)
16728	1333	(11.825317547305483,25.75)
16729	1333	(11.825317547305483,25.75)
16730	229	(25.681724007856502,4.75)
16731	632	(28.279800219209818,12.25)
16732	997	(32.176914536239792,19)
16733	917	(32.176914536239792,17.5)
16734	676	(31.310889132455351,13)
16735	395	(30.877876430563134,7.75)
16736	229	(25.681724007856502,4.75)
16737	189	(25.248711305964282,4)
16738	917	(32.176914536239792,17.5)
16739	192	(27.846787517317598,4)
16740	151	(27.413774815425377,3.25)
16741	152	(28.279800219209818,3.25)
16742	189	(25.248711305964282,4)
16743	917	(32.176914536239792,17.5)
16744	431	(26.98076211353316,8.5)
16745	33	(28.712812921102035,1)
16746	73	(29.145825622994256,1.75)
16747	33	(28.712812921102035,1)
16748	190	(26.114736709748719,4)
16749	33	(28.712812921102035,1)
16750	33	(28.712812921102035,1)
16751	917	(32.176914536239792,17.5)
16752	431	(26.98076211353316,8.5)
16753	31	(26.98076211353316,1)
16754	190	(26.114736709748719,4)
16755	33	(28.712812921102035,1)
16756	33	(28.712812921102035,1)
16757	917	(32.176914536239792,17.5)
16758	431	(26.98076211353316,8.5)
16759	431	(26.98076211353316,8.5)
16760	31	(26.98076211353316,1)
16761	155	(30.877876430563134,3.25)
16762	33	(28.712812921102035,1)
16763	194	(29.578838324886476,4)
16764	880	(35.208003449485325,16.75)
16765	999	(33.908965343808667,19)
16766	431	(26.98076211353316,8.5)
16767	1436	(31.743901834347572,27.25)
16768	1753	(29.145825622994256,33.25)
16769	1476	(31.310889132455351,28)
16770	1753	(29.145825622994256,33.25)
16771	505	(21.784609690826528,10)
16772	424	(20.918584287042091,8.5)
16773	424	(20.918584287042091,8.5)
16774	461	(18.753520777580992,9.25)
16775	792	(28.279800219209818,15.25)
16776	792	(28.279800219209818,15.25)
16777	791	(27.413774815425377,15.25)
16778	423	(20.05255888325765,8.5)
16779	631	(27.413774815425377,12.25)
16780	391	(27.413774815425377,7.75)
16781	391	(27.413774815425377,7.75)
16782	391	(27.413774815425377,7.75)
16783	999	(33.908965343808667,19)
16784	391	(27.413774815425377,7.75)
16785	391	(27.413774815425377,7.75)
16786	391	(27.413774815425377,7.75)
16787	393	(29.145825622994256,7.75)
16788	1342	(19.619546181365433,25.75)
16789	1394	(29.578838324886476,26.5)
16790	1388	(24.382685902179844,26.5)
16791	1388	(24.382685902179844,26.5)
16792	1507	(23.949673200287624,28.75)
16793	1030	(26.54774941164094,19.75)
16794	1028	(24.815698604072061,19.75)
16795	1033	(29.145825622994256,19.75)
16796	1033	(29.145825622994256,19.75)
16797	1725	(4.897114317029974,33.25)
16798	1765	(4.4641016151377544,34)
16799	2396	(31.743901834347572,45.25)
16800	2279	(33.908965343808667,43)
16801	2279	(33.908965343808667,43)
16802	840	(34.774990747593108,16)
16803	840	(34.774990747593108,16)
16804	920	(34.774990747593108,17.5)
16805	1917	(32.609927238132009,36.25)
16806	2040	(34.774990747593108,38.5)
16807	2159	(34.341978045700891,40.75)
16808	2159	(34.341978045700891,40.75)
16809	1529	(7.9282032302755088,29.5)
16810	1529	(7.9282032302755088,29.5)
16811	856	(14.423393758658799,16.75)
16812	813	(11.392304845413264,16)
16813	1608	(7.0621778264910704,31)
16814	1650	(9.2272413359521668,31.75)
16815	1954	(29.578838324886476,37)
16816	1610	(8.794228634059948,31)
16817	1647	(6.6291651245988508,31.75)
16818	524	(4.0310889132455356,10.75)
16819	1792	(27.846787517317598,34)
16820	1706	(22.650635094610966,32.5)
16821	1641	(1.4330127018922194,31.75)
16822	1660	(17.887495373796554,31.75)
16823	1660	(17.887495373796554,31.75)
16824	1578	(16.155444566227676,30.25)
16825	2040	(34.774990747593108,38.5)
16826	1873	(28.712812921102035,35.5)
16827	1872	(27.846787517317598,35.5)
16828	2159	(34.341978045700891,40.75)
16829	2159	(34.341978045700891,40.75)
16830	1709	(25.248711305964282,32.5)
16831	1709	(25.248711305964282,32.5)
16832	632	(28.279800219209818,12.25)
16833	632	(28.279800219209818,12.25)
16834	230	(26.54774941164094,4.75)
16835	230	(26.54774941164094,4.75)
16836	1715	(30.444863728670914,32.5)
16837	1718	(33.042939940024233,32.5)
16838	917	(32.176914536239792,17.5)
16839	839	(33.908965343808667,16)
16840	840	(34.774990747593108,16)
16841	840	(34.774990747593108,16)
16842	920	(34.774990747593108,17.5)
16843	190	(26.114736709748719,4)
16844	152	(28.279800219209818,3.25)
16845	33	(28.712812921102035,1)
16846	33	(28.712812921102035,1)
16847	33	(28.712812921102035,1)
16848	275	(30.444863728670914,5.5)
16849	80	(35.208003449485325,1.75)
16850	80	(35.208003449485325,1.75)
16851	424	(20.918584287042091,8.5)
16852	344	(20.918584287042091,7)
16853	1501	(18.753520777580992,28.75)
16854	1462	(19.186533479473212,28)
16855	1462	(19.186533479473212,28)
16856	1501	(18.753520777580992,28.75)
16857	1547	(23.516660498395403,29.5)
16858	1547	(23.516660498395403,29.5)
16859	95	(13.124355652982141,2.5)
16860	134	(12.691342951089922,3.25)
16861	133	(11.825317547305483,3.25)
16862	173	(11.392304845413264,4)
16863	623	(20.48557158514987,12.25)
16864	623	(20.48557158514987,12.25)
16865	623	(20.48557158514987,12.25)
16866	623	(20.48557158514987,12.25)
16867	659	(16.588457268119896,13)
16868	659	(16.588457268119896,13)
16869	659	(16.588457268119896,13)
16870	579	(16.588457268119896,11.5)
16871	659	(16.588457268119896,13)
16872	945	(22.217622392718749,18.25)
16873	945	(22.217622392718749,18.25)
16874	945	(22.217622392718749,18.25)
16875	905	(21.784609690826528,17.5)
16876	1600	(35.208003449485325,30.25)
16877	1240	(34.774990747593108,23.5)
16878	1240	(34.774990747593108,23.5)
16879	1240	(34.774990747593108,23.5)
16880	1360	(35.208003449485325,25.75)
16881	1560	(34.774990747593108,29.5)
16882	1597	(32.609927238132009,30.25)
16883	1069	(25.248711305964282,20.5)
16884	2197	(32.176914536239792,41.5)
16885	2154	(30.011851026778693,40.75)
16886	2233	(29.145825622994256,42.25)
16887	1215	(13.124355652982141,23.5)
16888	1	(1,1)
16889	1	(1,1)
16890	1	(1,1)
16891	2157	(32.609927238132009,40.75)
16892	2157	(32.609927238132009,40.75)
16893	2156	(31.743901834347572,40.75)
16894	2394	(30.011851026778693,45.25)
16895	2237	(32.609927238132009,42.25)
16896	2397	(32.609927238132009,45.25)
16897	448	(7.49519052838329,9.25)
16898	448	(7.49519052838329,9.25)
16899	448	(7.49519052838329,9.25)
16900	444	(4.0310889132455356,9.25)
16901	447	(6.6291651245988508,9.25)
16902	487	(6.196152422706632,10)
16903	485	(4.4641016151377544,10)
16904	485	(4.4641016151377544,10)
16905	1960	(34.774990747593108,37)
16906	2196	(31.310889132455351,41.5)
16907	2359	(33.908965343808667,44.5)
16908	2279	(33.908965343808667,43)
16909	275	(30.444863728670914,5.5)
16910	1562	(2.299038105676658,30.25)
16911	1562	(2.299038105676658,30.25)
16912	1971	(10.093266739736606,37.75)
16913	1932	(10.526279441628825,37)
16914	2042	(2.299038105676658,39.25)
16915	2047	(6.6291651245988508,39.25)
16916	2361	(1.4330127018922194,45.25)
16917	2361	(1.4330127018922194,45.25)
16918	2323	(2.7320508075688772,44.5)
16919	2162	(1.8660254037844386,41.5)
16920	2284	(4.0310889132455356,43.75)
16921	2324	(3.598076211353316,44.5)
16922	2279	(33.908965343808667,43)
16923	485	(4.4641016151377544,10)
16924	485	(4.4641016151377544,10)
16925	441	(1.4330127018922194,9.25)
16926	441	(1.4330127018922194,9.25)
16927	603	(3.1650635094610968,12.25)
16928	644	(3.598076211353316,13)
16929	1370	(8.794228634059948,26.5)
16930	601	(1.4330127018922194,12.25)
16931	1249	(8.3612159321677293,24.25)
16932	1127	(6.196152422706632,22)
16933	1127	(6.196152422706632,22)
16934	1087	(6.6291651245988508,21.25)
16935	1086	(5.7631397208144124,21.25)
16936	1086	(5.7631397208144124,21.25)
16937	1084	(4.0310889132455356,21.25)
16938	1083	(3.1650635094610968,21.25)
16939	1203	(2.7320508075688772,23.5)
16940	1203	(2.7320508075688772,23.5)
16941	1122	(1.8660254037844386,22)
16942	1684	(3.598076211353316,32.5)
16943	1374	(12.258330249197702,26.5)
16944	1451	(9.6602540378443873,28)
16945	1410	(9.2272413359521668,27.25)
16946	1411	(10.093266739736606,27.25)
16947	2200	(34.774990747593108,41.5)
16948	1411	(10.093266739736606,27.25)
16949	1708	(24.382685902179844,32.5)
16950	1708	(24.382685902179844,32.5)
16951	1708	(24.382685902179844,32.5)
16952	1708	(24.382685902179844,32.5)
16953	1565	(4.897114317029974,30.25)
16954	979	(16.588457268119896,19)
16955	1867	(23.516660498395403,35.5)
16956	1724	(4.0310889132455356,33.25)
16957	1019	(17.021469970012117,19.75)
16958	1905	(22.217622392718749,36.25)
16959	2289	(8.3612159321677293,43.75)
16960	1786	(22.650635094610966,34)
16961	2370	(9.2272413359521668,45.25)
16962	2374	(12.691342951089922,45.25)
16963	2373	(11.825317547305483,45.25)
16964	2370	(9.2272413359521668,45.25)
16965	2376	(14.423393758658799,45.25)
16966	1610	(8.794228634059948,31)
16967	1647	(6.6291651245988508,31.75)
16968	1647	(6.6291651245988508,31.75)
16969	1647	(6.6291651245988508,31.75)
16970	2033	(28.712812921102035,38.5)
16971	2033	(28.712812921102035,38.5)
16972	1606	(5.3301270189221936,31)
16973	1647	(6.6291651245988508,31.75)
16974	1647	(6.6291651245988508,31.75)
16975	1907	(23.949673200287624,36.25)
16976	1603	(2.7320508075688772,31)
16977	688	(7.49519052838329,13.75)
16978	688	(7.49519052838329,13.75)
16979	727	(6.196152422706632,14.5)
16980	727	(6.196152422706632,14.5)
16981	2194	(29.578838324886476,41.5)
16982	2159	(34.341978045700891,40.75)
16983	2040	(34.774990747593108,38.5)
16984	665	(21.784609690826528,13)
16985	2157	(32.609927238132009,40.75)
16986	2156	(31.743901834347572,40.75)
16987	1460	(17.454482671904334,28)
16988	1537	(14.856406460551018,29.5)
16989	623	(20.48557158514987,12.25)
16990	623	(20.48557158514987,12.25)
16991	1537	(14.856406460551018,29.5)
16992	659	(16.588457268119896,13)
16993	659	(16.588457268119896,13)
16994	617	(15.289419162443238,12.25)
16995	1537	(14.856406460551018,29.5)
16996	687	(6.6291651245988508,13.75)
16997	1182	(19.619546181365433,22.75)
16998	1112	(28.279800219209818,21.25)
16999	1112	(28.279800219209818,21.25)
17000	912	(27.846787517317598,17.5)
17001	911	(26.98076211353316,17.5)
17002	1192	(28.279800219209818,22.75)
17003	1140	(17.454482671904334,22)
17004	1219	(16.588457268119896,23.5)
17005	1220	(17.454482671904334,23.5)
17006	464	(21.351596988934308,9.25)
17007	424	(20.918584287042091,8.5)
17008	424	(20.918584287042091,8.5)
17009	461	(18.753520777580992,9.25)
17010	461	(18.753520777580992,9.25)
17011	501	(18.320508075688775,10)
17012	1192	(28.279800219209818,22.75)
17013	1140	(17.454482671904334,22)
17014	80	(35.208003449485325,1.75)
17015	80	(35.208003449485325,1.75)
17016	80	(35.208003449485325,1.75)
17017	80	(35.208003449485325,1.75)
17018	200	(34.774990747593108,4)
17019	200	(34.774990747593108,4)
17020	2347	(23.516660498395403,44.5)
17021	2347	(23.516660498395403,44.5)
17022	2262	(19.186533479473212,43)
17023	2181	(18.320508075688775,41.5)
17024	2302	(19.619546181365433,43.75)
17025	2342	(19.186533479473212,44.5)
17026	2306	(23.083647796503186,43.75)
17027	2345	(21.784609690826528,44.5)
17028	2383	(20.48557158514987,45.25)
17029	1902	(19.619546181365433,36.25)
17030	1695	(13.124355652982141,32.5)
17031	1695	(13.124355652982141,32.5)
17032	1822	(19.619546181365433,34.75)
17033	1694	(12.258330249197702,32.5)
17034	1772	(10.526279441628825,34)
17035	1772	(10.526279441628825,34)
17036	1772	(10.526279441628825,34)
17037	1929	(7.9282032302755088,37)
17038	1812	(10.959292143521045,34.75)
17039	860	(17.887495373796554,16.75)
17040	1807	(6.6291651245988508,34.75)
17041	1977	(15.289419162443238,37.75)
17042	1768	(7.0621778264910704,34)
17043	1769	(7.9282032302755088,34)
17044	1768	(7.0621778264910704,34)
17045	2060	(17.887495373796554,39.25)
17046	2060	(17.887495373796554,39.25)
17047	2052	(10.959292143521045,39.25)
17048	2207	(6.6291651245988508,42.25)
17049	2091	(9.6602540378443873,40)
17050	2053	(11.825317547305483,39.25)
17051	1810	(9.2272413359521668,34.75)
17052	1821	(18.753520777580992,34.75)
17053	1980	(17.887495373796554,37.75)
17054	1925	(4.4641016151377544,37)
17055	1860	(17.454482671904334,35.5)
17056	1807	(6.6291651245988508,34.75)
17057	2213	(11.825317547305483,42.25)
17058	2212	(10.959292143521045,42.25)
17059	2168	(7.0621778264910704,41.5)
17060	2084	(3.598076211353316,40)
17061	2170	(8.794228634059948,41.5)
17062	2178	(15.722431864335457,41.5)
17063	2098	(15.722431864335457,40)
17064	2098	(15.722431864335457,40)
17065	2098	(15.722431864335457,40)
17066	336	(13.99038105676658,7)
17067	335	(13.124355652982141,7)
17068	253	(11.392304845413264,5.5)
17069	819	(16.588457268119896,16)
17070	778	(16.155444566227676,15.25)
17071	777	(15.289419162443238,15.25)
17072	563	(2.7320508075688772,11.5)
17073	1370	(8.794228634059948,26.5)
17074	748	(24.382685902179844,14.5)
17075	2188	(24.382685902179844,41.5)
17076	2187	(23.516660498395403,41.5)
17077	2187	(23.516660498395403,41.5)
17078	1476	(31.310889132455351,28)
17079	1753	(29.145825622994256,33.25)
17080	1715	(30.444863728670914,32.5)
17081	1718	(33.042939940024233,32.5)
17082	1759	(34.341978045700891,33.25)
17083	1680	(35.208003449485325,31.75)
17084	167	(6.196152422706632,4)
17085	167	(6.196152422706632,4)
17086	126	(5.7631397208144124,3.25)
17087	126	(5.7631397208144124,3.25)
17088	1574	(12.691342951089922,30.25)
17089	448	(7.49519052838329,9.25)
17090	448	(7.49519052838329,9.25)
17091	1047	(6.196152422706632,20.5)
17092	969	(7.9282032302755088,19)
17093	1462	(19.186533479473212,28)
17094	2400	(35.208003449485325,45.25)
17095	2200	(34.774990747593108,41.5)
17096	2356	(31.310889132455351,44.5)
17097	2399	(34.341978045700891,45.25)
17098	1240	(34.774990747593108,23.5)
17099	1240	(34.774990747593108,23.5)
17100	1360	(35.208003449485325,25.75)
17101	1440	(35.208003449485325,27.25)
17102	1600	(35.208003449485325,30.25)
17103	1160	(34.774990747593108,22)
17104	1160	(34.774990747593108,22)
17105	1160	(34.774990747593108,22)
17106	1360	(35.208003449485325,25.75)
17107	2317	(32.609927238132009,43.75)
17108	2269	(25.248711305964282,43)
17109	2358	(33.042939940024233,44.5)
17110	1356	(31.743901834347572,25.75)
17111	152	(28.279800219209818,3.25)
17112	152	(28.279800219209818,3.25)
17113	152	(28.279800219209818,3.25)
17114	152	(28.279800219209818,3.25)
17115	152	(28.279800219209818,3.25)
17116	511	(26.98076211353316,10)
17117	511	(26.98076211353316,10)
17118	511	(26.98076211353316,10)
17119	152	(28.279800219209818,3.25)
17120	152	(28.279800219209818,3.25)
17121	153	(29.145825622994256,3.25)
17122	112	(27.846787517317598,2.5)
17123	275	(30.444863728670914,5.5)
17124	33	(28.712812921102035,1)
17125	275	(30.444863728670914,5.5)
17126	549	(25.681724007856502,10.75)
17127	1197	(32.609927238132009,22.75)
17128	1237	(32.176914536239792,23.5)
17129	1237	(32.176914536239792,23.5)
17130	1237	(32.176914536239792,23.5)
17131	1318	(33.042939940024233,25)
17132	1079	(33.908965343808667,20.5)
17133	1391	(26.98076211353316,26.5)
17134	1427	(23.949673200287624,27.25)
17135	1427	(23.949673200287624,27.25)
17136	1350	(26.54774941164094,25.75)
17137	1547	(23.516660498395403,29.5)
17138	1378	(15.722431864335457,26.5)
17139	1340	(17.887495373796554,25.75)
17140	1303	(20.05255888325765,25)
17141	1379	(16.588457268119896,26.5)
17142	1337	(15.289419162443238,25.75)
17143	1340	(17.887495373796554,25.75)
17144	1104	(21.351596988934308,21.25)
17145	1147	(23.516660498395403,22)
17146	1148	(24.382685902179844,22)
17147	1148	(24.382685902179844,22)
17148	1148	(24.382685902179844,22)
17149	1106	(23.083647796503186,21.25)
17150	1106	(23.083647796503186,21.25)
17151	1106	(23.083647796503186,21.25)
17152	1067	(23.516660498395403,20.5)
17153	1106	(23.083647796503186,21.25)
17154	1067	(23.516660498395403,20.5)
17155	1067	(23.516660498395403,20.5)
17156	1185	(22.217622392718749,22.75)
17157	1185	(22.217622392718749,22.75)
17158	1185	(22.217622392718749,22.75)
17159	1185	(22.217622392718749,22.75)
17160	1187	(23.949673200287624,22.75)
17161	95	(13.124355652982141,2.5)
17162	21	(18.320508075688775,1)
17163	95	(13.124355652982141,2.5)
17164	94	(12.258330249197702,2.5)
17165	135	(13.55736835487436,3.25)
17166	94	(12.258330249197702,2.5)
17167	94	(12.258330249197702,2.5)
17168	175	(13.124355652982141,4)
17169	94	(12.258330249197702,2.5)
17170	135	(13.55736835487436,3.25)
17171	95	(13.124355652982141,2.5)
17172	133	(11.825317547305483,3.25)
17173	133	(11.825317547305483,3.25)
17174	657	(14.856406460551018,13)
17175	173	(11.392304845413264,4)
17176	133	(11.825317547305483,3.25)
17177	133	(11.825317547305483,3.25)
17178	1340	(17.887495373796554,25.75)
17179	1417	(15.289419162443238,27.25)
17180	1296	(13.99038105676658,25)
17181	1336	(14.423393758658799,25.75)
17182	1336	(14.423393758658799,25.75)
17183	1216	(13.99038105676658,23.5)
17184	95	(13.124355652982141,2.5)
17185	54	(12.691342951089922,1.75)
17186	133	(11.825317547305483,3.25)
17187	1216	(13.99038105676658,23.5)
17188	1062	(19.186533479473212,20.5)
17189	1064	(20.918584287042091,20.5)
17190	1232	(27.846787517317598,23.5)
17191	152	(28.279800219209818,3.25)
17192	152	(28.279800219209818,3.25)
17193	151	(27.413774815425377,3.25)
17194	33	(28.712812921102035,1)
17195	33	(28.712812921102035,1)
17196	275	(30.444863728670914,5.5)
17197	152	(28.279800219209818,3.25)
17198	33	(28.712812921102035,1)
17199	33	(28.712812921102035,1)
17200	275	(30.444863728670914,5.5)
17201	1058	(15.722431864335457,20.5)
17202	1197	(32.609927238132009,22.75)
17203	1318	(33.042939940024233,25)
17204	1079	(33.908965343808667,20.5)
17205	1980	(17.887495373796554,37.75)
17206	1696	(13.99038105676658,32.5)
17207	1695	(13.124355652982141,32.5)
17208	1695	(13.124355652982141,32.5)
17209	2325	(4.4641016151377544,44.5)
17210	2324	(3.598076211353316,44.5)
17211	2364	(4.0310889132455356,45.25)
17212	2367	(6.6291651245988508,45.25)
17213	2327	(6.196152422706632,44.5)
17214	2321	(1,44.5)
17215	2321	(1,44.5)
17216	2321	(1,44.5)
17217	511	(26.98076211353316,10)
17218	152	(28.279800219209818,3.25)
17219	151	(27.413774815425377,3.25)
17220	33	(28.712812921102035,1)
17221	33	(28.712812921102035,1)
17222	275	(30.444863728670914,5.5)
17223	2154	(30.011851026778693,40.75)
17224	2233	(29.145825622994256,42.25)
17225	1960	(34.774990747593108,37)
17226	2196	(31.310889132455351,41.5)
17227	2359	(33.908965343808667,44.5)
17228	2279	(33.908965343808667,43)
17229	2279	(33.908965343808667,43)
17230	2279	(33.908965343808667,43)
17231	2279	(33.908965343808667,43)
17232	2396	(31.743901834347572,45.25)
17233	2315	(30.877876430563134,43.75)
17234	2237	(32.609927238132009,42.25)
17235	2392	(28.279800219209818,45.25)
17236	2392	(28.279800219209818,45.25)
17237	2392	(28.279800219209818,45.25)
17238	1	(1,1)
17239	1	(1,1)
17240	1	(1,1)
17241	2279	(33.908965343808667,43)
17242	490	(8.794228634059948,10)
17243	1414	(12.691342951089922,27.25)
17244	568	(7.0621778264910704,11.5)
17245	1050	(8.794228634059948,20.5)
17246	1253	(11.825317547305483,24.25)
17247	1407	(6.6291651245988508,27.25)
17248	490	(8.794228634059948,10)
17249	568	(7.0621778264910704,11.5)
17250	1050	(8.794228634059948,20.5)
17251	603	(3.1650635094610968,12.25)
17252	644	(3.598076211353316,13)
17253	601	(1.4330127018922194,12.25)
17254	1249	(8.3612159321677293,24.25)
17255	1287	(6.196152422706632,25)
17256	1287	(6.196152422706632,25)
17257	1287	(6.196152422706632,25)
17258	1287	(6.196152422706632,25)
17259	921	(1.4330127018922194,18.25)
17260	1203	(2.7320508075688772,23.5)
17261	1203	(2.7320508075688772,23.5)
17262	1203	(2.7320508075688772,23.5)
17263	1203	(2.7320508075688772,23.5)
17264	841	(1.4330127018922194,16.75)
17265	841	(1.4330127018922194,16.75)
17266	1162	(2.299038105676658,22.75)
17267	1162	(2.299038105676658,22.75)
17268	1162	(2.299038105676658,22.75)
17269	1612	(10.526279441628825,31)
17270	1841	(1,35.5)
17271	1841	(1,35.5)
17272	1841	(1,35.5)
17273	1611	(9.6602540378443873,31)
17274	522	(2.299038105676658,10.75)
17275	601	(1.4330127018922194,12.25)
17276	1287	(6.196152422706632,25)
17277	1374	(12.258330249197702,26.5)
17278	1410	(9.2272413359521668,27.25)
17279	1291	(9.6602540378443873,25)
17280	2200	(34.774990747593108,41.5)
17281	2156	(31.743901834347572,40.75)
17282	1612	(10.526279441628825,31)
17283	2033	(28.712812921102035,38.5)
17284	2111	(26.98076211353316,40)
17285	1610	(8.794228634059948,31)
17286	2067	(23.949673200287624,39.25)
17287	2311	(27.413774815425377,43.75)
17288	2068	(24.815698604072061,39.25)
17289	1608	(7.0621778264910704,31)
17290	1611	(9.6602540378443873,31)
17291	1955	(30.444863728670914,37)
17292	1994	(30.011851026778693,37.75)
17293	2111	(26.98076211353316,40)
17294	2111	(26.98076211353316,40)
17295	2071	(27.413774815425377,39.25)
17296	1529	(7.9282032302755088,29.5)
17297	1529	(7.9282032302755088,29.5)
17298	665	(21.784609690826528,13)
17299	665	(21.784609690826528,13)
17300	624	(21.351596988934308,12.25)
17301	623	(20.48557158514987,12.25)
17302	537	(15.289419162443238,10.75)
17303	949	(25.681724007856502,18.25)
17304	617	(15.289419162443238,12.25)
17305	947	(23.949673200287624,18.25)
17306	945	(22.217622392718749,18.25)
17307	905	(21.784609690826528,17.5)
17308	1068	(24.382685902179844,20.5)
17309	1227	(23.516660498395403,23.5)
17310	1225	(21.784609690826528,23.5)
17311	1033	(29.145825622994256,19.75)
17312	1028	(24.815698604072061,19.75)
17313	1147	(23.516660498395403,22)
17314	1145	(21.784609690826528,22)
17315	1064	(20.918584287042091,20.5)
17316	1103	(20.48557158514987,21.25)
17317	1063	(20.05255888325765,20.5)
17318	1137	(14.856406460551018,22)
17319	905	(21.784609690826528,17.5)
17320	1137	(14.856406460551018,22)
17321	2221	(18.753520777580992,42.25)
17322	2346	(22.650635094610966,44.5)
17323	2181	(18.320508075688775,41.5)
17324	2260	(17.454482671904334,43)
17325	2299	(17.021469970012117,43.75)
17326	2345	(21.784609690826528,44.5)
17327	2384	(21.351596988934308,45.25)
17328	2305	(22.217622392718749,43.75)
17329	2380	(17.887495373796554,45.25)
17330	2381	(18.753520777580992,45.25)
17331	2345	(21.784609690826528,44.5)
17332	2382	(19.619546181365433,45.25)
17333	2364	(4.0310889132455356,45.25)
17334	2364	(4.0310889132455356,45.25)
17335	2362	(2.299038105676658,45.25)
17336	2362	(2.299038105676658,45.25)
17337	2361	(1.4330127018922194,45.25)
17338	2361	(1.4330127018922194,45.25)
17339	2361	(1.4330127018922194,45.25)
17340	2321	(1,44.5)
17341	1858	(15.722431864335457,35.5)
17342	1942	(19.186533479473212,37)
17343	2101	(18.320508075688775,40)
17344	2141	(18.753520777580992,40.75)
17345	1772	(10.526279441628825,34)
17346	2052	(10.959292143521045,39.25)
17347	2053	(11.825317547305483,39.25)
17348	1969	(8.3612159321677293,37.75)
17349	2214	(12.691342951089922,42.25)
17350	1925	(4.4641016151377544,37)
17351	1769	(7.9282032302755088,34)
17352	2053	(11.825317547305483,39.25)
17353	1807	(6.6291651245988508,34.75)
17354	2134	(12.691342951089922,40.75)
17355	2134	(12.691342951089922,40.75)
17356	2213	(11.825317547305483,42.25)
17357	2052	(10.959292143521045,39.25)
17358	1925	(4.4641016151377544,37)
17359	2255	(13.124355652982141,43)
17360	1977	(15.289419162443238,37.75)
17361	1925	(4.4641016151377544,37)
17362	2041	(1.4330127018922194,39.25)
17363	2041	(1.4330127018922194,39.25)
17364	1817	(15.289419162443238,34.75)
17365	1939	(16.588457268119896,37)
17366	1981	(18.753520777580992,37.75)
17367	1776	(13.99038105676658,34)
17368	1736	(14.423393758658799,33.25)
17369	2094	(12.258330249197702,40)
17370	21	(18.320508075688775,1)
17371	60	(17.887495373796554,1.75)
17372	18	(15.722431864335457,1)
17373	58	(16.155444566227676,1.75)
17374	17	(14.856406460551018,1)
17375	17	(14.856406460551018,1)
17376	10	(8.794228634059948,1)
17377	179	(16.588457268119896,4)
17378	11	(9.6602540378443873,1)
17379	2041	(1.4330127018922194,39.25)
17380	2041	(1.4330127018922194,39.25)
17381	505	(21.784609690826528,10)
17382	423	(20.05255888325765,8.5)
17383	384	(21.351596988934308,7.75)
17384	505	(21.784609690826528,10)
17385	423	(20.05255888325765,8.5)
17386	423	(20.05255888325765,8.5)
17387	501	(18.320508075688775,10)
17388	1934	(12.258330249197702,37)
17389	2055	(13.55736835487436,39.25)
17390	688	(7.49519052838329,13.75)
17391	688	(7.49519052838329,13.75)
17392	688	(7.49519052838329,13.75)
17393	1708	(24.382685902179844,32.5)
17394	1708	(24.382685902179844,32.5)
17395	1708	(24.382685902179844,32.5)
17396	1790	(26.114736709748719,34)
17397	1592	(28.279800219209818,30.25)
17398	1591	(27.413774815425377,30.25)
17399	1670	(26.54774941164094,31.75)
17400	1670	(26.54774941164094,31.75)
17401	1669	(25.681724007856502,31.75)
17402	1670	(26.54774941164094,31.75)
17403	1629	(25.248711305964282,31)
17404	1669	(25.681724007856502,31.75)
17405	992	(27.846787517317598,19)
17406	992	(27.846787517317598,19)
17407	991	(26.98076211353316,19)
17408	991	(26.98076211353316,19)
17409	949	(25.681724007856502,18.25)
17410	1985	(22.217622392718749,37.75)
17411	1160	(34.774990747593108,22)
17412	1160	(34.774990747593108,22)
17413	1160	(34.774990747593108,22)
17414	1360	(35.208003449485325,25.75)
17415	2317	(32.609927238132009,43.75)
17416	2269	(25.248711305964282,43)
17417	2358	(33.042939940024233,44.5)
17418	1356	(31.743901834347572,25.75)
17419	2187	(23.516660498395403,41.5)
17420	2186	(22.650635094610966,41.5)
17421	1	(1,1)
17422	1	(1,1)
17423	1	(1,1)
17424	1342	(19.619546181365433,25.75)
17425	1379	(16.588457268119896,26.5)
17426	1302	(19.186533479473212,25)
17427	1339	(17.021469970012117,25.75)
17428	1306	(22.650635094610966,25)
17429	1306	(22.650635094610966,25)
17430	1537	(14.856406460551018,29.5)
17431	1578	(16.155444566227676,30.25)
17432	1407	(6.6291651245988508,27.25)
17433	1407	(6.6291651245988508,27.25)
17434	570	(8.794228634059948,11.5)
17435	1949	(25.248711305964282,37)
17436	1610	(8.794228634059948,31)
17437	1647	(6.6291651245988508,31.75)
17438	1641	(1.4330127018922194,31.75)
17439	1407	(6.6291651245988508,27.25)
17440	1407	(6.6291651245988508,27.25)
17441	1647	(6.6291651245988508,31.75)
17442	1652	(10.959292143521045,31.75)
17443	1954	(29.578838324886476,37)
17444	1917	(32.609927238132009,36.25)
17445	1917	(32.609927238132009,36.25)
17446	1953	(28.712812921102035,37)
17447	2033	(28.712812921102035,38.5)
17448	2029	(25.248711305964282,38.5)
17449	2071	(27.413774815425377,39.25)
17450	2033	(28.712812921102035,38.5)
17451	1647	(6.6291651245988508,31.75)
17452	1591	(27.413774815425377,30.25)
17453	1529	(7.9282032302755088,29.5)
17454	1529	(7.9282032302755088,29.5)
17455	2320	(35.208003449485325,43.75)
17456	969	(7.9282032302755088,19)
17457	1205	(4.4641016151377544,23.5)
17458	2194	(29.578838324886476,41.5)
17459	2279	(33.908965343808667,43)
17460	2279	(33.908965343808667,43)
17461	2397	(32.609927238132009,45.25)
17462	2353	(28.712812921102035,44.5)
17463	2394	(30.011851026778693,45.25)
17464	2392	(28.279800219209818,45.25)
17465	2352	(27.846787517317598,44.5)
17466	2352	(27.846787517317598,44.5)
17467	2400	(35.208003449485325,45.25)
17468	2399	(34.341978045700891,45.25)
17469	2200	(34.774990747593108,41.5)
17470	2111	(26.98076211353316,40)
17471	2040	(34.774990747593108,38.5)
17472	2156	(31.743901834347572,40.75)
17473	2040	(34.774990747593108,38.5)
17474	2156	(31.743901834347572,40.75)
17475	2159	(34.341978045700891,40.75)
17476	2040	(34.774990747593108,38.5)
17477	2040	(34.774990747593108,38.5)
17478	7	(6.196152422706632,1)
17479	6	(5.3301270189221936,1)
17480	45	(4.897114317029974,1.75)
17481	85	(4.4641016151377544,2.5)
17482	123	(3.1650635094610968,3.25)
17483	124	(4.0310889132455356,3.25)
17484	281	(1.4330127018922194,6.25)
17485	201	(1.4330127018922194,4.75)
17486	1831	(27.413774815425377,34.75)
17487	1790	(26.114736709748719,34)
17488	2289	(8.3612159321677293,43.75)
17489	1112	(28.279800219209818,21.25)
17490	1112	(28.279800219209818,21.25)
17491	913	(28.712812921102035,17.5)
17492	1191	(27.413774815425377,22.75)
17493	1182	(19.619546181365433,22.75)
17494	1220	(17.454482671904334,23.5)
17495	1019	(17.021469970012117,19.75)
17496	936	(14.423393758658799,18.25)
17497	934	(12.691342951089922,18.25)
17498	1135	(13.124355652982141,22)
17499	1135	(13.124355652982141,22)
17500	1135	(13.124355652982141,22)
17501	1135	(13.124355652982141,22)
17502	941	(18.753520777580992,18.25)
17503	1036	(31.743901834347572,19.75)
17504	997	(32.176914536239792,19)
17505	632	(28.279800219209818,12.25)
17506	632	(28.279800219209818,12.25)
17507	632	(28.279800219209818,12.25)
17508	632	(28.279800219209818,12.25)
17509	632	(28.279800219209818,12.25)
17510	554	(30.011851026778693,10.75)
17511	554	(30.011851026778693,10.75)
17512	152	(28.279800219209818,3.25)
17513	153	(29.145825622994256,3.25)
17514	153	(29.145825622994256,3.25)
17515	113	(28.712812921102035,2.5)
17516	152	(28.279800219209818,3.25)
17517	153	(29.145825622994256,3.25)
17518	153	(29.145825622994256,3.25)
17519	113	(28.712812921102035,2.5)
17520	31	(26.98076211353316,1)
17521	1237	(32.176914536239792,23.5)
17522	1197	(32.609927238132009,22.75)
17523	1197	(32.609927238132009,22.75)
17524	1237	(32.176914536239792,23.5)
17525	1197	(32.609927238132009,22.75)
17526	1197	(32.609927238132009,22.75)
17527	1036	(31.743901834347572,19.75)
17528	1036	(31.743901834347572,19.75)
17529	997	(32.176914536239792,19)
17530	839	(33.908965343808667,16)
17531	840	(34.774990747593108,16)
17532	37	(32.176914536239792,1)
17533	200	(34.774990747593108,4)
17534	37	(32.176914536239792,1)
17535	80	(35.208003449485325,1.75)
17536	80	(35.208003449485325,1.75)
17537	37	(32.176914536239792,1)
17538	1119	(34.341978045700891,21.25)
17539	1398	(33.042939940024233,26.5)
17540	77	(32.609927238132009,1.75)
17541	153	(29.145825622994256,3.25)
17542	146	(23.083647796503186,3.25)
17543	37	(32.176914536239792,1)
17544	158	(33.47595264191645,3.25)
17545	197	(32.176914536239792,4)
17546	1352	(28.279800219209818,25.75)
17547	1352	(28.279800219209818,25.75)
17548	1390	(26.114736709748719,26.5)
17549	1471	(26.98076211353316,28)
17550	1427	(23.949673200287624,27.25)
17551	632	(28.279800219209818,12.25)
17552	632	(28.279800219209818,12.25)
17553	632	(28.279800219209818,12.25)
17554	396	(31.743901834347572,7.75)
17555	480	(35.208003449485325,9.25)
17556	480	(35.208003449485325,9.25)
17557	480	(35.208003449485325,9.25)
17558	480	(35.208003449485325,9.25)
17559	480	(35.208003449485325,9.25)
17560	1424	(21.351596988934308,27.25)
17561	1460	(17.454482671904334,28)
17562	1460	(17.454482671904334,28)
17563	1460	(17.454482671904334,28)
17564	347	(23.516660498395403,7)
17565	113	(28.712812921102035,2.5)
17566	113	(28.712812921102035,2.5)
17567	236	(31.743901834347572,4.75)
17568	68	(24.815698604072061,1.75)
17569	111	(26.98076211353316,2.5)
17570	596	(31.310889132455351,11.5)
17571	596	(31.310889132455351,11.5)
17572	596	(31.310889132455351,11.5)
17573	596	(31.310889132455351,11.5)
17574	596	(31.310889132455351,11.5)
17575	1277	(32.609927238132009,24.25)
17576	1277	(32.609927238132009,24.25)
17577	1277	(32.609927238132009,24.25)
17578	1476	(31.310889132455351,28)
17579	1753	(29.145825622994256,33.25)
17580	1715	(30.444863728670914,32.5)
17581	1676	(31.743901834347572,31.75)
17582	1717	(32.176914536239792,32.5)
17583	1718	(33.042939940024233,32.5)
17584	1759	(34.341978045700891,33.25)
17585	262	(19.186533479473212,5.5)
17586	223	(20.48557158514987,4.75)
17587	223	(20.48557158514987,4.75)
17588	341	(18.320508075688775,7)
17589	341	(18.320508075688775,7)
17590	339	(16.588457268119896,7)
17591	874	(30.011851026778693,16.75)
17592	596	(31.310889132455351,11.5)
17593	596	(31.310889132455351,11.5)
17594	596	(31.310889132455351,11.5)
17595	596	(31.310889132455351,11.5)
17596	754	(29.578838324886476,14.5)
17597	794	(30.011851026778693,15.25)
17598	875	(30.877876430563134,16.75)
17599	794	(30.011851026778693,15.25)
17600	794	(30.011851026778693,15.25)
17601	831	(26.98076211353316,16)
17602	596	(31.310889132455351,11.5)
17603	554	(30.011851026778693,10.75)
17604	596	(31.310889132455351,11.5)
17605	554	(30.011851026778693,10.75)
17606	1237	(32.176914536239792,23.5)
17607	1197	(32.609927238132009,22.75)
17608	1197	(32.609927238132009,22.75)
17609	1240	(34.774990747593108,23.5)
17610	1240	(34.774990747593108,23.5)
17611	1360	(35.208003449485325,25.75)
17612	1440	(35.208003449485325,27.25)
17613	1480	(34.774990747593108,28)
17614	603	(3.1650635094610968,12.25)
17615	685	(4.897114317029974,13.75)
17616	1249	(8.3612159321677293,24.25)
17617	1249	(8.3612159321677293,24.25)
17618	1287	(6.196152422706632,25)
17619	1203	(2.7320508075688772,23.5)
17620	1203	(2.7320508075688772,23.5)
17621	1786	(22.650635094610966,34)
17622	1786	(22.650635094610966,34)
17623	2371	(10.093266739736606,45.25)
17624	2370	(9.2272413359521668,45.25)
17625	2373	(11.825317547305483,45.25)
17626	1960	(34.774990747593108,37)
17627	2196	(31.310889132455351,41.5)
17628	2359	(33.908965343808667,44.5)
17629	2279	(33.908965343808667,43)
17630	2374	(12.691342951089922,45.25)
17631	2374	(12.691342951089922,45.25)
17632	2372	(10.959292143521045,45.25)
17633	326	(5.3301270189221936,7)
17634	326	(5.3301270189221936,7)
17635	326	(5.3301270189221936,7)
17636	859	(17.021469970012117,16.75)
17637	821	(18.320508075688775,16)
17638	820	(17.454482671904334,16)
17639	819	(16.588457268119896,16)
17640	336	(13.99038105676658,7)
17641	336	(13.99038105676658,7)
17642	335	(13.124355652982141,7)
17643	2150	(26.54774941164094,40.75)
17644	2310	(26.54774941164094,43.75)
17645	2156	(31.743901834347572,40.75)
17646	2312	(28.279800219209818,43.75)
17647	2154	(30.011851026778693,40.75)
17648	2233	(29.145825622994256,42.25)
17649	2279	(33.908965343808667,43)
17650	1333	(11.825317547305483,25.75)
17651	441	(1.4330127018922194,9.25)
17652	607	(6.6291651245988508,12.25)
17653	682	(2.299038105676658,13.75)
17654	603	(3.1650635094610968,12.25)
17655	644	(3.598076211353316,13)
17656	601	(1.4330127018922194,12.25)
17657	1249	(8.3612159321677293,24.25)
17658	1167	(6.6291651245988508,22.75)
17659	1203	(2.7320508075688772,23.5)
17660	1162	(2.299038105676658,22.75)
17661	1162	(2.299038105676658,22.75)
17662	1333	(11.825317547305483,25.75)
17663	601	(1.4330127018922194,12.25)
17664	2279	(33.908965343808667,43)
17665	928	(7.49519052838329,18.25)
17666	2104	(20.918584287042091,40)
17667	1164	(4.0310889132455356,22.75)
17668	2279	(33.908965343808667,43)
17669	1412	(10.959292143521045,27.25)
17670	1451	(9.6602540378443873,28)
17671	1291	(9.6602540378443873,25)
17672	1415	(13.55736835487436,27.25)
17673	1253	(11.825317547305483,24.25)
17674	444	(4.0310889132455356,9.25)
17675	1416	(14.423393758658799,27.25)
17676	2279	(33.908965343808667,43)
17677	490	(8.794228634059948,10)
17678	490	(8.794228634059948,10)
17679	2279	(33.908965343808667,43)
17680	1911	(27.413774815425377,36.25)
17681	613	(11.825317547305483,12.25)
17682	1647	(6.6291651245988508,31.75)
17683	1907	(23.949673200287624,36.25)
17684	1647	(6.6291651245988508,31.75)
17685	2279	(33.908965343808667,43)
17686	1952	(27.846787517317598,37)
17687	1987	(23.949673200287624,37.75)
17688	2279	(33.908965343808667,43)
17689	424	(20.918584287042091,8.5)
17690	424	(20.918584287042091,8.5)
17691	424	(20.918584287042091,8.5)
17692	424	(20.918584287042091,8.5)
17693	424	(20.918584287042091,8.5)
17694	424	(20.918584287042091,8.5)
17695	425	(21.784609690826528,8.5)
17696	424	(20.918584287042091,8.5)
17697	461	(18.753520777580992,9.25)
17698	461	(18.753520777580992,9.25)
17699	501	(18.320508075688775,10)
17700	461	(18.753520777580992,9.25)
17701	461	(18.753520777580992,9.25)
17702	461	(18.753520777580992,9.25)
17703	424	(20.918584287042091,8.5)
17704	424	(20.918584287042091,8.5)
17705	424	(20.918584287042091,8.5)
17706	2279	(33.908965343808667,43)
17707	514	(29.578838324886476,10)
17708	112	(27.846787517317598,2.5)
17709	153	(29.145825622994256,3.25)
17710	114	(29.578838324886476,2.5)
17711	153	(29.145825622994256,3.25)
17712	113	(28.712812921102035,2.5)
17713	111	(26.98076211353316,2.5)
17714	514	(29.578838324886476,10)
17715	111	(26.98076211353316,2.5)
17716	111	(26.98076211353316,2.5)
17717	111	(26.98076211353316,2.5)
17718	111	(26.98076211353316,2.5)
17719	110	(26.114736709748719,2.5)
17720	514	(29.578838324886476,10)
17721	112	(27.846787517317598,2.5)
17722	153	(29.145825622994256,3.25)
17723	112	(27.846787517317598,2.5)
17724	112	(27.846787517317598,2.5)
17725	146	(23.083647796503186,3.25)
17726	1036	(31.743901834347572,19.75)
17727	997	(32.176914536239792,19)
17728	555	(30.877876430563134,10.75)
17729	154	(30.011851026778693,3.25)
17730	154	(30.011851026778693,3.25)
17731	154	(30.011851026778693,3.25)
17732	31	(26.98076211353316,1)
17733	197	(32.176914536239792,4)
17734	716	(31.743901834347572,13.75)
17735	155	(30.877876430563134,3.25)
17736	114	(29.578838324886476,2.5)
17737	1076	(31.310889132455351,20.5)
17738	713	(29.145825622994256,13.75)
17739	596	(31.310889132455351,11.5)
17740	80	(35.208003449485325,1.75)
17741	80	(35.208003449485325,1.75)
17742	80	(35.208003449485325,1.75)
17743	80	(35.208003449485325,1.75)
17744	80	(35.208003449485325,1.75)
17745	80	(35.208003449485325,1.75)
17746	80	(35.208003449485325,1.75)
17747	80	(35.208003449485325,1.75)
17748	80	(35.208003449485325,1.75)
17749	80	(35.208003449485325,1.75)
17750	80	(35.208003449485325,1.75)
17751	80	(35.208003449485325,1.75)
17752	197	(32.176914536239792,4)
17753	197	(32.176914536239792,4)
17754	2279	(33.908965343808667,43)
17755	2181	(18.320508075688775,41.5)
17756	2347	(23.516660498395403,44.5)
17757	2262	(19.186533479473212,43)
17758	2299	(17.021469970012117,43.75)
17759	2302	(19.619546181365433,43.75)
17760	2382	(19.619546181365433,45.25)
17761	2261	(18.320508075688775,43)
17762	2258	(15.722431864335457,43)
17763	2221	(18.753520777580992,42.25)
17764	2301	(18.753520777580992,43.75)
17765	2301	(18.753520777580992,43.75)
17766	2366	(5.7631397208144124,45.25)
17767	2366	(5.7631397208144124,45.25)
17768	2361	(1.4330127018922194,45.25)
17769	2321	(1,44.5)
17770	2279	(33.908965343808667,43)
17771	1814	(12.691342951089922,34.75)
17772	1893	(11.825317547305483,36.25)
17773	1897	(15.289419162443238,36.25)
17774	1897	(15.289419162443238,36.25)
17775	1981	(18.753520777580992,37.75)
17776	1776	(13.99038105676658,34)
17777	1769	(7.9282032302755088,34)
17778	1971	(10.093266739736606,37.75)
17779	1807	(6.6291651245988508,34.75)
17780	2091	(9.6602540378443873,40)
17781	2212	(10.959292143521045,42.25)
17782	2212	(10.959292143521045,42.25)
17783	2004	(3.598076211353316,38.5)
17784	2094	(12.258330249197702,40)
17785	1928	(7.0621778264910704,37)
17786	2094	(12.258330249197702,40)
17787	1928	(7.0621778264910704,37)
17788	1728	(7.49519052838329,33.25)
17789	1851	(9.6602540378443873,35.5)
17790	1851	(9.6602540378443873,35.5)
17791	1768	(7.0621778264910704,34)
17792	1851	(9.6602540378443873,35.5)
17793	1851	(9.6602540378443873,35.5)
17794	2053	(11.825317547305483,39.25)
17795	2060	(17.887495373796554,39.25)
17796	2215	(13.55736835487436,42.25)
17797	2207	(6.6291651245988508,42.25)
17798	1922	(1.8660254037844386,37)
17799	2053	(11.825317547305483,39.25)
17800	2060	(17.887495373796554,39.25)
17801	2215	(13.55736835487436,42.25)
17802	2207	(6.6291651245988508,42.25)
17803	1922	(1.8660254037844386,37)
17804	2279	(33.908965343808667,43)
17805	1119	(34.341978045700891,21.25)
17806	840	(34.774990747593108,16)
17807	840	(34.774990747593108,16)
17808	840	(34.774990747593108,16)
17809	1119	(34.341978045700891,21.25)
17810	155	(30.877876430563134,3.25)
17811	155	(30.877876430563134,3.25)
17812	880	(35.208003449485325,16.75)
17813	1119	(34.341978045700891,21.25)
17814	155	(30.877876430563134,3.25)
17815	155	(30.877876430563134,3.25)
17816	840	(34.774990747593108,16)
17817	800	(35.208003449485325,15.25)
17818	840	(34.774990747593108,16)
17819	155	(30.877876430563134,3.25)
17820	155	(30.877876430563134,3.25)
17821	2279	(33.908965343808667,43)
17822	1430	(26.54774941164094,27.25)
17823	1430	(26.54774941164094,27.25)
17824	1430	(26.54774941164094,27.25)
17825	1430	(26.54774941164094,27.25)
17826	1430	(26.54774941164094,27.25)
17827	1430	(26.54774941164094,27.25)
17828	1430	(26.54774941164094,27.25)
17829	1430	(26.54774941164094,27.25)
17830	1430	(26.54774941164094,27.25)
17831	1470	(26.114736709748719,28)
17832	1470	(26.114736709748719,28)
17833	1470	(26.114736709748719,28)
17834	1509	(25.681724007856502,28.75)
17835	1509	(25.681724007856502,28.75)
17836	1509	(25.681724007856502,28.75)
17837	1432	(28.279800219209818,27.25)
17838	1432	(28.279800219209818,27.25)
17839	1431	(27.413774815425377,27.25)
17840	1432	(28.279800219209818,27.25)
17841	2279	(33.908965343808667,43)
17842	1501	(18.753520777580992,28.75)
17843	1501	(18.753520777580992,28.75)
17844	1464	(20.918584287042091,28)
17845	1544	(20.918584287042091,29.5)
17846	1545	(21.784609690826528,29.5)
17847	1545	(21.784609690826528,29.5)
17848	1545	(21.784609690826528,29.5)
17849	1544	(20.918584287042091,29.5)
17850	1464	(20.918584287042091,28)
17851	2279	(33.908965343808667,43)
17852	1160	(34.774990747593108,22)
17853	1160	(34.774990747593108,22)
17854	1360	(35.208003449485325,25.75)
17855	1360	(35.208003449485325,25.75)
17856	2279	(33.908965343808667,43)
17857	1160	(34.774990747593108,22)
17858	2317	(32.609927238132009,43.75)
17859	2269	(25.248711305964282,43)
17860	2358	(33.042939940024233,44.5)
17861	1356	(31.743901834347572,25.75)
17862	2279	(33.908965343808667,43)
17863	1633	(28.712812921102035,31)
17864	1633	(28.712812921102035,31)
17865	1592	(28.279800219209818,30.25)
17866	1633	(28.712812921102035,31)
17867	1592	(28.279800219209818,30.25)
17868	2279	(33.908965343808667,43)
17869	286	(5.7631397208144124,6.25)
17870	364	(4.0310889132455356,7.75)
17871	1	(1,1)
17872	1	(1,1)
17873	1	(1,1)
17874	88	(7.0621778264910704,2.5)
17875	43	(3.1650635094610968,1.75)
17876	201	(1.4330127018922194,4.75)
17877	121	(1.4330127018922194,3.25)
17878	283	(3.1650635094610968,6.25)
17879	123	(3.1650635094610968,3.25)
17880	281	(1.4330127018922194,6.25)
17881	4	(3.598076211353316,1)
17882	2279	(33.908965343808667,43)
17883	1476	(31.310889132455351,28)
17884	1753	(29.145825622994256,33.25)
17885	1476	(31.310889132455351,28)
17886	1718	(33.042939940024233,32.5)
17887	1476	(31.310889132455351,28)
17888	1718	(33.042939940024233,32.5)
17889	1759	(34.341978045700891,33.25)
17890	1720	(34.774990747593108,32.5)
17891	1715	(30.444863728670914,32.5)
17892	1718	(33.042939940024233,32.5)
17893	2279	(33.908965343808667,43)
17894	587	(23.516660498395403,11.5)
17895	587	(23.516660498395403,11.5)
17896	587	(23.516660498395403,11.5)
17897	627	(23.949673200287624,12.25)
17898	741	(18.320508075688775,14.5)
17899	418	(15.722431864335457,8.5)
17900	418	(15.722431864335457,8.5)
17901	418	(15.722431864335457,8.5)
17902	662	(19.186533479473212,13)
17903	662	(19.186533479473212,13)
17904	621	(18.753520777580992,12.25)
17905	663	(20.05255888325765,13)
17906	663	(20.05255888325765,13)
17907	662	(19.186533479473212,13)
17908	659	(16.588457268119896,13)
17909	659	(16.588457268119896,13)
17910	659	(16.588457268119896,13)
17911	657	(14.856406460551018,13)
17912	657	(14.856406460551018,13)
17913	657	(14.856406460551018,13)
17914	2279	(33.908965343808667,43)
17915	414	(12.258330249197702,8.5)
17916	414	(12.258330249197702,8.5)
17917	734	(12.258330249197702,14.5)
17918	2279	(33.908965343808667,43)
17919	782	(19.619546181365433,15.25)
17920	819	(16.588457268119896,16)
17921	819	(16.588457268119896,16)
17922	737	(14.856406460551018,14.5)
17923	698	(16.155444566227676,13.75)
17924	2279	(33.908965343808667,43)
17925	780	(17.887495373796554,15.25)
17926	2279	(33.908965343808667,43)
17927	336	(13.99038105676658,7)
17928	375	(13.55736835487436,7.75)
17929	214	(12.691342951089922,4.75)
17930	13	(11.392304845413264,1)
17931	255	(13.124355652982141,5.5)
17932	2279	(33.908965343808667,43)
17933	1187	(23.949673200287624,22.75)
17934	1187	(23.949673200287624,22.75)
17935	1187	(23.949673200287624,22.75)
17936	1187	(23.949673200287624,22.75)
17937	1187	(23.949673200287624,22.75)
17938	1187	(23.949673200287624,22.75)
17939	1185	(22.217622392718749,22.75)
17940	1185	(22.217622392718749,22.75)
17941	1185	(22.217622392718749,22.75)
17942	1064	(20.918584287042091,20.5)
17943	1104	(21.351596988934308,21.25)
17944	1062	(19.186533479473212,20.5)
17945	1063	(20.05255888325765,20.5)
17946	1062	(19.186533479473212,20.5)
17947	2279	(33.908965343808667,43)
17948	934	(12.691342951089922,18.25)
17949	934	(12.691342951089922,18.25)
17950	1020	(17.887495373796554,19.75)
17951	2279	(33.908965343808667,43)
17952	1670	(26.54774941164094,31.75)
17953	1783	(20.05255888325765,34)
17954	1706	(22.650635094610966,32.5)
17955	1706	(22.650635094610966,32.5)
17956	1706	(22.650635094610966,32.5)
17957	1706	(22.650635094610966,32.5)
17958	1706	(22.650635094610966,32.5)
17959	1706	(22.650635094610966,32.5)
17960	2279	(33.908965343808667,43)
17961	101	(18.320508075688775,2.5)
17962	60	(17.887495373796554,1.75)
17963	60	(17.887495373796554,1.75)
17964	58	(16.155444566227676,1.75)
17965	17	(14.856406460551018,1)
17966	17	(14.856406460551018,1)
17967	10	(8.794228634059948,1)
17968	17	(14.856406460551018,1)
17969	138	(16.155444566227676,3.25)
17970	178	(15.722431864335457,4)
17971	215	(13.55736835487436,4.75)
17972	2279	(33.908965343808667,43)
17973	1312	(27.846787517317598,25)
17974	1312	(27.846787517317598,25)
17975	1312	(27.846787517317598,25)
17976	1312	(27.846787517317598,25)
17977	1312	(27.846787517317598,25)
17978	1350	(26.54774941164094,25.75)
17979	1350	(26.54774941164094,25.75)
17980	1350	(26.54774941164094,25.75)
17981	1350	(26.54774941164094,25.75)
17982	1470	(26.114736709748719,28)
17983	1470	(26.114736709748719,28)
17984	1470	(26.114736709748719,28)
17985	2279	(33.908965343808667,43)
17986	1227	(23.516660498395403,23.5)
17987	1227	(23.516660498395403,23.5)
17988	1227	(23.516660498395403,23.5)
17989	1227	(23.516660498395403,23.5)
17990	2279	(33.908965343808667,43)
17991	1380	(17.454482671904334,26.5)
17992	1337	(15.289419162443238,25.75)
17993	1380	(17.454482671904334,26.5)
17994	1417	(15.289419162443238,27.25)
17995	1417	(15.289419162443238,27.25)
17996	1379	(16.588457268119896,26.5)
17997	1417	(15.289419162443238,27.25)
17998	1417	(15.289419162443238,27.25)
17999	1256	(14.423393758658799,24.25)
18000	1216	(13.99038105676658,23.5)
18001	1216	(13.99038105676658,23.5)
18002	1216	(13.99038105676658,23.5)
18003	2279	(33.908965343808667,43)
18004	546	(23.083647796503186,10.75)
18005	2279	(33.908965343808667,43)
18006	1537	(14.856406460551018,29.5)
18007	1578	(16.155444566227676,30.25)
18008	1618	(15.722431864335457,31)
18009	1618	(15.722431864335457,31)
18010	1620	(17.454482671904334,31)
18011	1537	(14.856406460551018,29.5)
18012	1577	(15.289419162443238,30.25)
18013	1537	(14.856406460551018,29.5)
18014	1577	(15.289419162443238,30.25)
18015	2279	(33.908965343808667,43)
18016	2374	(12.691342951089922,45.25)
18017	2374	(12.691342951089922,45.25)
18018	2373	(11.825317547305483,45.25)
18019	2279	(33.908965343808667,43)
18020	2373	(11.825317547305483,45.25)
18021	2370	(9.2272413359521668,45.25)
18022	1786	(22.650635094610966,34)
18023	2333	(11.392304845413264,44.5)
18024	1786	(22.650635094610966,34)
18025	2371	(10.093266739736606,45.25)
18026	2279	(33.908965343808667,43)
18027	792	(28.279800219209818,15.25)
18028	911	(26.98076211353316,17.5)
18029	911	(26.98076211353316,17.5)
18030	911	(26.98076211353316,17.5)
18031	911	(26.98076211353316,17.5)
18032	911	(26.98076211353316,17.5)
18033	1112	(28.279800219209818,21.25)
18034	1112	(28.279800219209818,21.25)
18035	1193	(29.145825622994256,22.75)
18036	1193	(29.145825622994256,22.75)
18037	1192	(28.279800219209818,22.75)
18038	1192	(28.279800219209818,22.75)
18039	1152	(27.846787517317598,22)
18040	1152	(27.846787517317598,22)
18041	1222	(19.186533479473212,23.5)
18042	1140	(17.454482671904334,22)
18043	1140	(17.454482671904334,22)
18044	1140	(17.454482671904334,22)
18045	2279	(33.908965343808667,43)
18046	1790	(26.114736709748719,34)
18047	1864	(20.918584287042091,35.5)
18048	1905	(22.217622392718749,36.25)
18049	1905	(22.217622392718749,36.25)
18050	1945	(21.784609690826528,37)
18051	1905	(22.217622392718749,36.25)
18052	2161	(1,41.5)
18053	2279	(33.908965343808667,43)
18054	2000	(35.208003449485325,37.75)
18055	1960	(34.774990747593108,37)
18056	1355	(30.877876430563134,25.75)
18057	2279	(33.908965343808667,43)
18058	2033	(28.712812921102035,38.5)
18059	2109	(25.248711305964282,40)
18060	1608	(7.0621778264910704,31)
18061	1988	(24.815698604072061,37.75)
18062	2076	(31.743901834347572,39.25)
18063	1988	(24.815698604072061,37.75)
18064	2159	(34.341978045700891,40.75)
18065	2159	(34.341978045700891,40.75)
18066	1877	(32.176914536239792,35.5)
18067	2156	(31.743901834347572,40.75)
18068	2156	(31.743901834347572,40.75)
18069	2194	(29.578838324886476,41.5)
18070	2194	(29.578838324886476,41.5)
18071	2279	(33.908965343808667,43)
18072	2035	(30.444863728670914,38.5)
18073	2111	(26.98076211353316,40)
18074	2071	(27.413774815425377,39.25)
18075	412	(10.526279441628825,8.5)
18076	494	(12.258330249197702,10)
18077	412	(10.526279441628825,8.5)
18078	494	(12.258330249197702,10)
18079	1565	(4.897114317029974,30.25)
18080	1565	(4.897114317029974,30.25)
18081	1565	(4.897114317029974,30.25)
18082	1565	(4.897114317029974,30.25)
18083	1524	(3.598076211353316,29.5)
18084	2310	(26.54774941164094,43.75)
18085	2279	(33.908965343808667,43)
18086	2200	(34.774990747593108,41.5)
18087	1911	(27.413774815425377,36.25)
18088	1688	(7.0621778264910704,32.5)
18089	1947	(23.516660498395403,37)
18090	1947	(23.516660498395403,37)
18091	1598	(33.47595264191645,30.25)
18092	1600	(35.208003449485325,30.25)
18093	1240	(34.774990747593108,23.5)
18094	1240	(34.774990747593108,23.5)
18095	1240	(34.774990747593108,23.5)
18096	1360	(35.208003449485325,25.75)
18097	1519	(34.341978045700891,28.75)
18098	1598	(33.47595264191645,30.25)
18099	1600	(35.208003449485325,30.25)
18100	2279	(33.908965343808667,43)
18101	2280	(34.774990747593108,43)
18102	2279	(33.908965343808667,43)
18103	2279	(33.908965343808667,43)
18104	788	(24.815698604072061,15.25)
18105	748	(24.382685902179844,14.5)
18106	2279	(33.908965343808667,43)
18107	2392	(28.279800219209818,45.25)
18108	2392	(28.279800219209818,45.25)
18109	2392	(28.279800219209818,45.25)
18110	2394	(30.011851026778693,45.25)
18111	2394	(30.011851026778693,45.25)
18112	2279	(33.908965343808667,43)
18113	252	(10.526279441628825,5.5)
18114	130	(9.2272413359521668,3.25)
18115	2187	(23.516660498395403,41.5)
18116	2187	(23.516660498395403,41.5)
18117	2279	(33.908965343808667,43)
18118	2144	(21.351596988934308,40.75)
18119	1355	(30.877876430563134,25.75)
18120	2357	(32.176914536239792,44.5)
18121	2399	(34.341978045700891,45.25)
18122	2400	(35.208003449485325,45.25)
18123	2359	(33.908965343808667,44.5)
18124	2279	(33.908965343808667,43)
18125	1229	(25.248711305964282,23.5)
18126	1269	(25.681724007856502,24.25)
18127	1269	(25.681724007856502,24.25)
18128	2156	(31.743901834347572,40.75)
18129	2154	(30.011851026778693,40.75)
18130	2233	(29.145825622994256,42.25)
18131	965	(4.4641016151377544,19)
18132	881	(1,17.5)
18133	2279	(33.908965343808667,43)
18134	490	(8.794228634059948,10)
18135	609	(8.3612159321677293,12.25)
18136	1132	(10.526279441628825,22)
18137	1171	(10.093266739736606,22.75)
18138	1171	(10.093266739736606,22.75)
18139	607	(6.6291651245988508,12.25)
18140	490	(8.794228634059948,10)
18141	1172	(10.959292143521045,22.75)
18142	761	(1.4330127018922194,15.25)
18143	1241	(1.4330127018922194,24.25)
18144	1241	(1.4330127018922194,24.25)
18145	1641	(1.4330127018922194,31.75)
18146	1487	(6.6291651245988508,28.75)
18147	1407	(6.6291651245988508,27.25)
18148	1454	(12.258330249197702,28)
18149	1407	(6.6291651245988508,27.25)
18150	1362	(1.8660254037844386,26.5)
18151	1362	(1.8660254037844386,26.5)
18152	1361	(1,26.5)
18153	644	(3.598076211353316,13)
18154	1249	(8.3612159321677293,24.25)
18155	1126	(5.3301270189221936,22)
18156	1283	(2.7320508075688772,25)
18157	1281	(1,25)
18158	1994	(30.011851026778693,37.75)
18159	2071	(27.413774815425377,39.25)
18160	2071	(27.413774815425377,39.25)
18161	1651	(10.093266739736606,31.75)
18162	1992	(28.279800219209818,37.75)
18163	1161	(1.4330127018922194,22.75)
18164	1609	(7.9282032302755088,31)
18165	1610	(8.794228634059948,31)
18166	2071	(27.413774815425377,39.25)
18167	2068	(24.815698604072061,39.25)
18168	2067	(23.949673200287624,39.25)
18169	2026	(22.650635094610966,38.5)
18170	2067	(23.949673200287624,39.25)
18171	613	(11.825317547305483,12.25)
18172	771	(10.093266739736606,15.25)
18173	453	(11.825317547305483,9.25)
18174	1528	(7.0621778264910704,29.5)
18175	731	(9.6602540378443873,14.5)
18176	1487	(6.6291651245988508,28.75)
18177	1494	(12.691342951089922,28.75)
18178	1408	(7.49519052838329,27.25)
18179	1407	(6.6291651245988508,27.25)
18180	1365	(4.4641016151377544,26.5)
18181	586	(22.650635094610966,11.5)
18182	664	(20.918584287042091,13)
18183	702	(19.619546181365433,13.75)
18184	948	(24.815698604072061,18.25)
18185	947	(23.949673200287624,18.25)
18186	1068	(24.382685902179844,20.5)
18187	1187	(23.949673200287624,22.75)
18188	1028	(24.815698604072061,19.75)
18189	1106	(23.083647796503186,21.25)
18190	905	(21.784609690826528,17.5)
18191	1614	(12.258330249197702,31)
18192	453	(11.825317547305483,9.25)
18193	1592	(28.279800219209818,30.25)
18194	1591	(27.413774815425377,30.25)
18195	1831	(27.413774815425377,34.75)
18196	1534	(12.258330249197702,29.5)
18197	1905	(22.217622392718749,36.25)
18198	835	(30.444863728670914,16)
18199	875	(30.877876430563134,16.75)
18200	794	(30.011851026778693,15.25)
18201	792	(28.279800219209818,15.25)
18202	792	(28.279800219209818,15.25)
18203	1232	(27.846787517317598,23.5)
18204	1353	(29.145825622994256,25.75)
18205	1352	(28.279800219209818,25.75)
18206	1390	(26.114736709748719,26.5)
18207	1312	(27.846787517317598,25)
18208	1312	(27.846787517317598,25)
18209	1470	(26.114736709748719,28)
18210	1430	(26.54774941164094,27.25)
18211	1430	(26.54774941164094,27.25)
18212	1510	(26.54774941164094,28.75)
18213	1470	(26.114736709748719,28)
18214	1537	(14.856406460551018,29.5)
18215	1620	(17.454482671904334,31)
18216	1538	(15.722431864335457,29.5)
18217	1538	(15.722431864335457,29.5)
18218	1578	(16.155444566227676,30.25)
18219	1618	(15.722431864335457,31)
18220	2341	(18.320508075688775,44.5)
18221	2221	(18.753520777580992,42.25)
18222	2380	(17.887495373796554,45.25)
18223	2340	(17.454482671904334,44.5)
18224	2306	(23.083647796503186,43.75)
18225	2340	(17.454482671904334,44.5)
18226	2306	(23.083647796503186,43.75)
18227	1694	(12.258330249197702,32.5)
18228	1942	(19.186533479473212,37)
18229	1852	(10.526279441628825,35.5)
18230	1942	(19.186533479473212,37)
18231	1900	(17.887495373796554,36.25)
18232	1899	(17.021469970012117,36.25)
18233	1812	(10.959292143521045,34.75)
18234	1858	(15.722431864335457,35.5)
18235	1858	(15.722431864335457,35.5)
18236	1981	(18.753520777580992,37.75)
18237	1858	(15.722431864335457,35.5)
18238	1776	(13.99038105676658,34)
18239	1978	(16.155444566227676,37.75)
18240	1929	(7.9282032302755088,37)
18241	1698	(15.722431864335457,32.5)
18242	2060	(17.887495373796554,39.25)
18243	2134	(12.691342951089922,40.75)
18244	1922	(1.8660254037844386,37)
18245	2053	(11.825317547305483,39.25)
18246	2212	(10.959292143521045,42.25)
18247	1981	(18.753520777580992,37.75)
18248	1776	(13.99038105676658,34)
18249	1849	(7.9282032302755088,35.5)
18250	1854	(12.258330249197702,35.5)
18251	1698	(15.722431864335457,32.5)
18252	1736	(14.423393758658799,33.25)
18253	1978	(16.155444566227676,37.75)
18254	2214	(12.691342951089922,42.25)
18255	1923	(2.7320508075688772,37)
18256	2214	(12.691342951089922,42.25)
18257	1961	(1.4330127018922194,37.75)
18258	1961	(1.4330127018922194,37.75)
18259	1961	(1.4330127018922194,37.75)
18260	748	(24.382685902179844,14.5)
18261	787	(23.949673200287624,15.25)
18262	1736	(14.423393758658799,33.25)
18263	1776	(13.99038105676658,34)
18264	1187	(23.949673200287624,22.75)
18265	1145	(21.784609690826528,22)
18266	1032	(28.279800219209818,19.75)
18267	1032	(28.279800219209818,19.75)
18268	95	(13.124355652982141,2.5)
18269	94	(12.258330249197702,2.5)
18270	175	(13.124355652982141,4)
18271	894	(12.258330249197702,17.5)
18272	938	(16.155444566227676,18.25)
18273	819	(16.588457268119896,16)
18274	778	(16.155444566227676,15.25)
18275	1544	(20.918584287042091,29.5)
18276	1505	(22.217622392718749,28.75)
18277	1545	(21.784609690826528,29.5)
18278	1545	(21.784609690826528,29.5)
18279	1541	(18.320508075688775,29.5)
18280	1544	(20.918584287042091,29.5)
18281	1544	(20.918584287042091,29.5)
18282	1623	(20.05255888325765,31)
18283	167	(6.196152422706632,4)
18284	167	(6.196152422706632,4)
18285	166	(5.3301270189221936,4)
18286	166	(5.3301270189221936,4)
18287	44	(4.0310889132455356,1.75)
18288	204	(4.0310889132455356,4.75)
18289	243	(2.7320508075688772,5.5)
18290	201	(1.4330127018922194,4.75)
18291	201	(1.4330127018922194,4.75)
18292	1	(1,1)
18293	1	(1,1)
18294	1	(1,1)
18295	223	(20.48557158514987,4.75)
18296	223	(20.48557158514987,4.75)
18297	223	(20.48557158514987,4.75)
18298	341	(18.320508075688775,7)
18299	339	(16.588457268119896,7)
18300	339	(16.588457268119896,7)
18301	2320	(35.208003449485325,43.75)
18302	851	(10.093266739736606,16.75)
18303	2063	(20.48557158514987,39.25)
18304	1387	(23.516660498395403,26.5)
18305	1342	(19.619546181365433,25.75)
18306	1340	(17.887495373796554,25.75)
18307	1298	(15.722431864335457,25)
18308	1258	(16.155444566227676,24.25)
18309	1306	(22.650635094610966,25)
18310	1669	(25.681724007856502,31.75)
18311	1626	(22.650635094610966,31)
18312	1834	(30.011851026778693,34.75)
18313	1519	(34.341978045700891,28.75)
18314	1949	(25.248711305964282,37)
18315	1949	(25.248711305964282,37)
18316	1868	(24.382685902179844,35.5)
18317	2400	(35.208003449485325,45.25)
18318	2200	(34.774990747593108,41.5)
18319	1869	(25.248711305964282,35.5)
18320	2399	(34.341978045700891,45.25)
18321	2187	(23.516660498395403,41.5)
18322	2150	(26.54774941164094,40.75)
18323	2150	(26.54774941164094,40.75)
18324	2150	(26.54774941164094,40.75)
18325	289	(8.3612159321677293,6.25)
18326	2148	(24.815698604072061,40.75)
18327	2148	(24.815698604072061,40.75)
18328	2225	(22.217622392718749,42.25)
18329	1160	(34.774990747593108,22)
18330	1160	(34.774990747593108,22)
18331	1160	(34.774990747593108,22)
18332	1360	(35.208003449485325,25.75)
18333	2317	(32.609927238132009,43.75)
18334	2269	(25.248711305964282,43)
18335	2358	(33.042939940024233,44.5)
18336	1356	(31.743901834347572,25.75)
18337	250	(8.794228634059948,5.5)
18338	250	(8.794228634059948,5.5)
18339	2185	(21.784609690826528,41.5)
18340	1993	(29.145825622994256,37.75)
18341	1993	(29.145825622994256,37.75)
18342	1993	(29.145825622994256,37.75)
18343	1902	(19.619546181365433,36.25)
18344	2097	(14.856406460551018,40)
18345	1902	(19.619546181365433,36.25)
18346	2178	(15.722431864335457,41.5)
18347	1902	(19.619546181365433,36.25)
18348	2016	(13.99038105676658,38.5)
18349	1821	(18.753520777580992,34.75)
18350	2139	(17.021469970012117,40.75)
18351	2178	(15.722431864335457,41.5)
18352	693	(11.825317547305483,13.75)
18353	1803	(3.1650635094610968,34.75)
18354	2159	(34.341978045700891,40.75)
18355	2159	(34.341978045700891,40.75)
18356	1984	(21.351596988934308,37.75)
18357	1984	(21.351596988934308,37.75)
18358	1984	(21.351596988934308,37.75)
18359	1984	(21.351596988934308,37.75)
18360	2237	(32.609927238132009,42.25)
18361	2352	(27.846787517317598,44.5)
18362	2353	(28.712812921102035,44.5)
18363	2394	(30.011851026778693,45.25)
18364	2352	(27.846787517317598,44.5)
18365	2392	(28.279800219209818,45.25)
18366	2280	(34.774990747593108,43)
18367	2279	(33.908965343808667,43)
18368	2396	(31.743901834347572,45.25)
18369	2392	(28.279800219209818,45.25)
18370	2396	(31.743901834347572,45.25)
18371	1902	(19.619546181365433,36.25)
18372	1917	(32.609927238132009,36.25)
18373	1879	(33.908965343808667,35.5)
18374	2037	(32.176914536239792,38.5)
18375	1955	(30.444863728670914,37)
18376	2067	(23.949673200287624,39.25)
18377	2156	(31.743901834347572,40.75)
18378	2194	(29.578838324886476,41.5)
18379	2040	(34.774990747593108,38.5)
18380	1946	(22.650635094610966,37)
18381	2159	(34.341978045700891,40.75)
18382	1877	(32.176914536239792,35.5)
18383	2118	(33.042939940024233,40)
18384	2159	(34.341978045700891,40.75)
18385	1112	(28.279800219209818,21.25)
18386	1112	(28.279800219209818,21.25)
18387	1112	(28.279800219209818,21.25)
18388	1191	(27.413774815425377,22.75)
18389	1191	(27.413774815425377,22.75)
18390	631	(27.413774815425377,12.25)
18391	631	(27.413774815425377,12.25)
18392	632	(28.279800219209818,12.25)
18393	632	(28.279800219209818,12.25)
18394	514	(29.578838324886476,10)
18395	435	(30.444863728670914,8.5)
18396	395	(30.877876430563134,7.75)
18397	395	(30.877876430563134,7.75)
18398	673	(28.712812921102035,13)
18399	673	(28.712812921102035,13)
18400	514	(29.578838324886476,10)
18401	395	(30.877876430563134,7.75)
18402	477	(32.609927238132009,9.25)
18403	395	(30.877876430563134,7.75)
18404	395	(30.877876430563134,7.75)
18405	395	(30.877876430563134,7.75)
18406	395	(30.877876430563134,7.75)
18407	26	(22.650635094610966,1)
18408	26	(22.650635094610966,1)
18409	317	(32.609927238132009,6.25)
18410	1243	(3.1650635094610968,24.25)
18411	38	(33.042939940024233,1)
18412	39	(33.908965343808667,1)
18413	80	(35.208003449485325,1.75)
18414	200	(34.774990747593108,4)
18415	80	(35.208003449485325,1.75)
18416	39	(33.908965343808667,1)
18417	200	(34.774990747593108,4)
18418	1277	(32.609927238132009,24.25)
18419	1277	(32.609927238132009,24.25)
18420	1277	(32.609927238132009,24.25)
18421	1476	(31.310889132455351,28)
18422	1753	(29.145825622994256,33.25)
18423	1715	(30.444863728670914,32.5)
18424	1717	(32.176914536239792,32.5)
18425	1759	(34.341978045700891,33.25)
18426	1760	(35.208003449485325,33.25)
18427	1680	(35.208003449485325,31.75)
18428	436	(31.310889132455351,8.5)
18429	440	(34.774990747593108,8.5)
18430	440	(34.774990747593108,8.5)
18431	317	(32.609927238132009,6.25)
18432	317	(32.609927238132009,6.25)
18433	317	(32.609927238132009,6.25)
18434	317	(32.609927238132009,6.25)
18435	1197	(32.609927238132009,22.75)
18436	1158	(33.042939940024233,22)
18437	1197	(32.609927238132009,22.75)
18438	1197	(32.609927238132009,22.75)
18439	957	(32.609927238132009,18.25)
18440	1398	(33.042939940024233,26.5)
18441	720	(35.208003449485325,13.75)
18442	720	(35.208003449485325,13.75)
18443	1240	(34.774990747593108,23.5)
18444	1240	(34.774990747593108,23.5)
18445	1240	(34.774990747593108,23.5)
18446	1360	(35.208003449485325,25.75)
18447	1480	(34.774990747593108,28)
18448	554	(30.011851026778693,10.75)
18449	554	(30.011851026778693,10.75)
18450	268	(24.382685902179844,5.5)
18451	395	(30.877876430563134,7.75)
18452	317	(32.609927238132009,6.25)
18453	360	(34.774990747593108,7)
18454	1155	(30.444863728670914,22)
18455	1155	(30.444863728670914,22)
18456	2233	(29.145825622994256,42.25)
18457	1960	(34.774990747593108,37)
18458	2000	(35.208003449485325,37.75)
18459	1355	(30.877876430563134,25.75)
18460	2359	(33.908965343808667,44.5)
18461	676	(31.310889132455351,13)
18462	676	(31.310889132455351,13)
18463	632	(28.279800219209818,12.25)
18464	632	(28.279800219209818,12.25)
18465	673	(28.712812921102035,13)
18466	153	(29.145825622994256,3.25)
18467	113	(28.712812921102035,2.5)
18468	676	(31.310889132455351,13)
18469	676	(31.310889132455351,13)
18470	632	(28.279800219209818,12.25)
18471	632	(28.279800219209818,12.25)
18472	673	(28.712812921102035,13)
18473	153	(29.145825622994256,3.25)
18474	113	(28.712812921102035,2.5)
18475	676	(31.310889132455351,13)
18476	676	(31.310889132455351,13)
18477	632	(28.279800219209818,12.25)
18478	673	(28.712812921102035,13)
18479	632	(28.279800219209818,12.25)
18480	673	(28.712812921102035,13)
18481	954	(30.011851026778693,18.25)
18482	1031	(27.413774815425377,19.75)
18483	1030	(26.54774941164094,19.75)
18484	425	(21.784609690826528,8.5)
18485	505	(21.784609690826528,10)
18486	423	(20.05255888325765,8.5)
18487	461	(18.753520777580992,9.25)
18488	461	(18.753520777580992,9.25)
18489	67	(23.949673200287624,1.75)
18490	68	(24.815698604072061,1.75)
18491	28	(24.382685902179844,1)
18492	28	(24.382685902179844,1)
18493	28	(24.382685902179844,1)
18494	28	(24.382685902179844,1)
18495	28	(24.382685902179844,1)
18496	28	(24.382685902179844,1)
18497	309	(25.681724007856502,6.25)
18498	596	(31.310889132455351,11.5)
18499	309	(25.681724007856502,6.25)
18500	311	(27.413774815425377,6.25)
18501	200	(34.774990747593108,4)
18502	120	(34.774990747593108,2.5)
18503	270	(26.114736709748719,5.5)
18504	120	(34.774990747593108,2.5)
18505	158	(33.47595264191645,3.25)
18506	307	(23.949673200287624,6.25)
18507	549	(25.681724007856502,10.75)
18508	347	(23.516660498395403,7)
18509	554	(30.011851026778693,10.75)
18510	347	(23.516660498395403,7)
18511	589	(25.248711305964282,11.5)
18512	347	(23.516660498395403,7)
18513	596	(31.310889132455351,11.5)
18514	153	(29.145825622994256,3.25)
18515	112	(27.846787517317598,2.5)
18516	266	(22.650635094610966,5.5)
18517	266	(22.650635094610966,5.5)
18518	347	(23.516660498395403,7)
18519	306	(23.083647796503186,6.25)
18520	347	(23.516660498395403,7)
18521	189	(25.248711305964282,4)
18522	149	(25.681724007856502,3.25)
18523	34	(29.578838324886476,1)
18524	74	(30.011851026778693,1.75)
18525	31	(26.98076211353316,1)
18526	307	(23.949673200287624,6.25)
18527	186	(22.650635094610966,4)
18528	30	(26.114736709748719,1)
18529	37	(32.176914536239792,1)
18530	275	(30.444863728670914,5.5)
18531	353	(28.712812921102035,7)
18532	30	(26.114736709748719,1)
18533	1790	(26.114736709748719,34)
18534	896	(13.99038105676658,17.5)
18535	734	(12.258330249197702,14.5)
18536	1854	(12.258330249197702,35.5)
18537	1929	(7.9282032302755088,37)
18538	1886	(5.7631397208144124,36.25)
18539	1885	(4.897114317029974,36.25)
18540	1441	(1,28)
18541	2388	(24.815698604072061,45.25)
18542	2388	(24.815698604072061,45.25)
18543	2388	(24.815698604072061,45.25)
18544	2300	(17.887495373796554,43.75)
18545	2300	(17.887495373796554,43.75)
18546	2221	(18.753520777580992,42.25)
18547	2299	(17.021469970012117,43.75)
18548	2385	(22.217622392718749,45.25)
18549	2385	(22.217622392718749,45.25)
18550	1253	(11.825317547305483,24.25)
18551	1253	(11.825317547305483,24.25)
18552	1366	(5.3301270189221936,26.5)
18553	1448	(7.0621778264910704,28)
18554	1445	(4.4641016151377544,28)
18555	2374	(12.691342951089922,45.25)
18556	2371	(10.093266739736606,45.25)
18557	2340	(17.454482671904334,44.5)
18558	2345	(21.784609690826528,44.5)
18559	2382	(19.619546181365433,45.25)
18560	2381	(18.753520777580992,45.25)
18561	2342	(19.186533479473212,44.5)
18562	2342	(19.186533479473212,44.5)
18563	2285	(4.897114317029974,43.75)
18564	2365	(4.897114317029974,45.25)
18565	2285	(4.897114317029974,43.75)
18566	2361	(1.4330127018922194,45.25)
18567	2361	(1.4330127018922194,45.25)
18568	553	(29.145825622994256,10.75)
18569	33	(28.712812921102035,1)
18570	395	(30.877876430563134,7.75)
18571	395	(30.877876430563134,7.75)
18572	317	(32.609927238132009,6.25)
18573	317	(32.609927238132009,6.25)
18574	317	(32.609927238132009,6.25)
18575	1474	(29.578838324886476,28)
18576	1514	(30.011851026778693,28.75)
18577	1514	(30.011851026778693,28.75)
18578	1514	(30.011851026778693,28.75)
18579	1514	(30.011851026778693,28.75)
18580	130	(9.2272413359521668,3.25)
18581	331	(9.6602540378443873,7)
18582	2159	(34.341978045700891,40.75)
18583	2159	(34.341978045700891,40.75)
18584	2159	(34.341978045700891,40.75)
18585	2195	(30.444863728670914,41.5)
18586	2195	(30.444863728670914,41.5)
18587	2315	(30.877876430563134,43.75)
18588	2198	(33.042939940024233,41.5)
18589	2232	(28.279800219209818,42.25)
18590	2232	(28.279800219209818,42.25)
18591	2280	(34.774990747593108,43)
18592	2279	(33.908965343808667,43)
18593	2279	(33.908965343808667,43)
18594	2347	(23.516660498395403,44.5)
18595	2156	(31.743901834347572,40.75)
18596	2118	(33.042939940024233,40)
18597	2118	(33.042939940024233,40)
18598	2118	(33.042939940024233,40)
18599	2279	(33.908965343808667,43)
18600	1911	(27.413774815425377,36.25)
18601	1869	(25.248711305964282,35.5)
18602	1094	(12.691342951089922,21.25)
18603	1900	(17.887495373796554,36.25)
18604	2279	(33.908965343808667,43)
18605	347	(23.516660498395403,7)
18606	517	(32.176914536239792,10)
18607	477	(32.609927238132009,9.25)
18608	477	(32.609927238132009,9.25)
18609	517	(32.176914536239792,10)
18610	478	(33.47595264191645,9.25)
18611	478	(33.47595264191645,9.25)
18612	478	(33.47595264191645,9.25)
18613	478	(33.47595264191645,9.25)
18614	440	(34.774990747593108,8.5)
18615	440	(34.774990747593108,8.5)
18616	478	(33.47595264191645,9.25)
18617	478	(33.47595264191645,9.25)
18618	479	(34.341978045700891,9.25)
18619	360	(34.774990747593108,7)
18620	80	(35.208003449485325,1.75)
18621	1391	(26.98076211353316,26.5)
18622	39	(33.908965343808667,1)
18623	1430	(26.54774941164094,27.25)
18624	120	(34.774990747593108,2.5)
18625	120	(34.774990747593108,2.5)
18626	1510	(26.54774941164094,28.75)
18627	1237	(32.176914536239792,23.5)
18628	1040	(35.208003449485325,19.75)
18629	1000	(34.774990747593108,19)
18630	1000	(34.774990747593108,19)
18631	1509	(25.681724007856502,28.75)
18632	418	(15.722431864335457,8.5)
18633	663	(20.05255888325765,13)
18634	659	(16.588457268119896,13)
18635	618	(16.155444566227676,12.25)
18636	993	(28.712812921102035,19)
18637	990	(26.114736709748719,19)
18638	1031	(27.413774815425377,19.75)
18639	947	(23.949673200287624,18.25)
18640	947	(23.949673200287624,18.25)
18641	1618	(15.722431864335457,31)
18642	1537	(14.856406460551018,29.5)
18643	1578	(16.155444566227676,30.25)
18644	1618	(15.722431864335457,31)
18645	1620	(17.454482671904334,31)
18646	1618	(15.722431864335457,31)
18647	1313	(28.712812921102035,25)
18648	1342	(19.619546181365433,25.75)
18649	1501	(18.753520777580992,28.75)
18650	1501	(18.753520777580992,28.75)
18651	1424	(21.351596988934308,27.25)
18652	1544	(20.918584287042091,29.5)
18653	1623	(20.05255888325765,31)
18654	1623	(20.05255888325765,31)
18655	1582	(19.619546181365433,30.25)
18656	880	(35.208003449485325,16.75)
18657	920	(34.774990747593108,17.5)
18658	560	(35.208003449485325,10.75)
18659	560	(35.208003449485325,10.75)
18660	560	(35.208003449485325,10.75)
18661	560	(35.208003449485325,10.75)
18662	1509	(25.681724007856502,28.75)
18663	1509	(25.681724007856502,28.75)
18664	1509	(25.681724007856502,28.75)
18665	2159	(34.341978045700891,40.75)
18666	2159	(34.341978045700891,40.75)
18667	2118	(33.042939940024233,40)
18668	1952	(27.846787517317598,37)
18669	911	(26.98076211353316,17.5)
18670	911	(26.98076211353316,17.5)
18671	1192	(28.279800219209818,22.75)
18672	821	(18.320508075688775,16)
18673	819	(16.588457268119896,16)
18674	336	(13.99038105676658,7)
18675	256	(13.99038105676658,5.5)
18676	311	(27.413774815425377,6.25)
18677	311	(27.413774815425377,6.25)
18678	311	(27.413774815425377,6.25)
18679	153	(29.145825622994256,3.25)
18680	153	(29.145825622994256,3.25)
18681	153	(29.145825622994256,3.25)
18682	1277	(32.609927238132009,24.25)
18683	1277	(32.609927238132009,24.25)
18684	1476	(31.310889132455351,28)
18685	1753	(29.145825622994256,33.25)
18686	1715	(30.444863728670914,32.5)
18687	1717	(32.176914536239792,32.5)
18688	1759	(34.341978045700891,33.25)
18689	1760	(35.208003449485325,33.25)
18690	1680	(35.208003449485325,31.75)
18691	2035	(30.444863728670914,38.5)
18692	855	(13.55736835487436,16.75)
18693	895	(13.124355652982141,17.5)
18694	2156	(31.743901834347572,40.75)
18695	2194	(29.578838324886476,41.5)
18696	1877	(32.176914536239792,35.5)
18697	1877	(32.176914536239792,35.5)
18698	1911	(27.413774815425377,36.25)
18699	1952	(27.846787517317598,37)
18700	1610	(8.794228634059948,31)
18701	1647	(6.6291651245988508,31.75)
18702	1487	(6.6291651245988508,28.75)
18703	1529	(7.9282032302755088,29.5)
18704	1529	(7.9282032302755088,29.5)
18705	1529	(7.9282032302755088,29.5)
18706	794	(30.011851026778693,15.25)
18707	794	(30.011851026778693,15.25)
18708	794	(30.011851026778693,15.25)
18709	792	(28.279800219209818,15.25)
18710	831	(26.98076211353316,16)
18711	794	(30.011851026778693,15.25)
18712	1647	(6.6291651245988508,31.75)
18713	1233	(28.712812921102035,23.5)
18714	446	(5.7631397208144124,9.25)
18715	1333	(11.825317547305483,25.75)
18716	1454	(12.258330249197702,28)
18717	1333	(11.825317547305483,25.75)
18718	1407	(6.6291651245988508,27.25)
18719	1407	(6.6291651245988508,27.25)
18720	1529	(7.9282032302755088,29.5)
18721	1529	(7.9282032302755088,29.5)
18722	1529	(7.9282032302755088,29.5)
18723	1761	(1,34)
18724	1522	(1.8660254037844386,29.5)
18725	1156	(31.310889132455351,22)
18726	1156	(31.310889132455351,22)
18727	1156	(31.310889132455351,22)
18728	719	(34.341978045700891,13.75)
18729	719	(34.341978045700891,13.75)
18730	2320	(35.208003449485325,43.75)
18731	969	(7.9282032302755088,19)
18732	1046	(5.3301270189221936,20.5)
18733	223	(20.48557158514987,4.75)
18734	223	(20.48557158514987,4.75)
18735	223	(20.48557158514987,4.75)
18736	339	(16.588457268119896,7)
18737	339	(16.588457268119896,7)
18738	1	(1,1)
18739	2	(1.8660254037844386,1)
18740	46	(5.7631397208144124,1.75)
18741	85	(4.4641016151377544,2.5)
18742	2	(1.8660254037844386,1)
18743	82	(1.8660254037844386,2.5)
18744	4	(3.598076211353316,1)
18745	4	(3.598076211353316,1)
18746	1841	(1,35.5)
18747	326	(5.3301270189221936,7)
18748	261	(18.320508075688775,5.5)
18749	368	(7.49519052838329,7.75)
18750	2033	(28.712812921102035,38.5)
18751	2033	(28.712812921102035,38.5)
18752	1650	(9.2272413359521668,31.75)
18753	2071	(27.413774815425377,39.25)
18754	1608	(7.0621778264910704,31)
18755	1841	(1,35.5)
18756	1841	(1,35.5)
18757	1841	(1,35.5)
18758	1641	(1.4330127018922194,31.75)
18759	1761	(1,34)
18760	766	(5.7631397208144124,15.25)
18761	2070	(26.54774941164094,39.25)
18762	1647	(6.6291651245988508,31.75)
18763	1606	(5.3301270189221936,31)
18764	1606	(5.3301270189221936,31)
18765	412	(10.526279441628825,8.5)
18766	1992	(28.279800219209818,37.75)
18767	1602	(1.8660254037844386,31)
18768	2200	(34.774990747593108,41.5)
18769	2200	(34.774990747593108,41.5)
18770	1911	(27.413774815425377,36.25)
18771	1911	(27.413774815425377,36.25)
18772	1907	(23.949673200287624,36.25)
18773	1229	(25.248711305964282,23.5)
18774	2400	(35.208003449485325,45.25)
18775	2200	(34.774990747593108,41.5)
18776	2399	(34.341978045700891,45.25)
18777	2279	(33.908965343808667,43)
18778	1911	(27.413774815425377,36.25)
18779	1952	(27.846787517317598,37)
18780	2310	(26.54774941164094,43.75)
18781	2310	(26.54774941164094,43.75)
18782	2150	(26.54774941164094,40.75)
18783	1160	(34.774990747593108,22)
18784	1160	(34.774990747593108,22)
18785	1160	(34.774990747593108,22)
18786	1360	(35.208003449485325,25.75)
18787	2317	(32.609927238132009,43.75)
18788	2269	(25.248711305964282,43)
18789	2358	(33.042939940024233,44.5)
18790	1356	(31.743901834347572,25.75)
18791	1147	(23.516660498395403,22)
18792	1104	(21.351596988934308,21.25)
18793	1062	(19.186533479473212,20.5)
18794	1024	(21.351596988934308,19.75)
18795	1063	(20.05255888325765,20.5)
18796	1023	(20.48557158514987,19.75)
18797	1098	(16.155444566227676,21.25)
18798	2374	(12.691342951089922,45.25)
18799	2374	(12.691342951089922,45.25)
18800	2373	(11.825317547305483,45.25)
18801	1641	(1.4330127018922194,31.75)
18802	435	(30.444863728670914,8.5)
18803	437	(32.176914536239792,8.5)
18804	437	(32.176914536239792,8.5)
18805	437	(32.176914536239792,8.5)
18806	437	(32.176914536239792,8.5)
18807	398	(33.47595264191645,7.75)
18808	398	(33.47595264191645,7.75)
18809	439	(33.908965343808667,8.5)
18810	360	(34.774990747593108,7)
18811	320	(35.208003449485325,6.25)
18812	360	(34.774990747593108,7)
18813	360	(34.774990747593108,7)
18814	638	(33.47595264191645,12.25)
18815	596	(31.310889132455351,11.5)
18816	309	(25.681724007856502,6.25)
18817	270	(26.114736709748719,5.5)
18818	200	(34.774990747593108,4)
18819	158	(33.47595264191645,3.25)
18820	311	(27.413774815425377,6.25)
18821	158	(33.47595264191645,3.25)
18822	158	(33.47595264191645,3.25)
18823	307	(23.949673200287624,6.25)
18824	596	(31.310889132455351,11.5)
18825	347	(23.516660498395403,7)
18826	596	(31.310889132455351,11.5)
18827	347	(23.516660498395403,7)
18828	596	(31.310889132455351,11.5)
18829	347	(23.516660498395403,7)
18830	152	(28.279800219209818,3.25)
18831	112	(27.846787517317598,2.5)
18832	112	(27.846787517317598,2.5)
18833	266	(22.650635094610966,5.5)
18834	266	(22.650635094610966,5.5)
18835	306	(23.083647796503186,6.25)
18836	153	(29.145825622994256,3.25)
18837	146	(23.083647796503186,3.25)
18838	108	(24.382685902179844,2.5)
18839	109	(25.248711305964282,2.5)
18840	33	(28.712812921102035,1)
18841	34	(29.578838324886476,1)
18842	30	(26.114736709748719,1)
18843	672	(27.846787517317598,13)
18844	672	(27.846787517317598,13)
18845	477	(32.609927238132009,9.25)
18846	478	(33.47595264191645,9.25)
18847	478	(33.47595264191645,9.25)
18848	478	(33.47595264191645,9.25)
18849	478	(33.47595264191645,9.25)
18850	347	(23.516660498395403,7)
18851	517	(32.176914536239792,10)
18852	517	(32.176914536239792,10)
18853	478	(33.47595264191645,9.25)
18854	478	(33.47595264191645,9.25)
18855	478	(33.47595264191645,9.25)
18856	440	(34.774990747593108,8.5)
18857	440	(34.774990747593108,8.5)
18858	95	(13.124355652982141,2.5)
18859	95	(13.124355652982141,2.5)
18860	133	(11.825317547305483,3.25)
18861	133	(11.825317547305483,3.25)
18862	133	(11.825317547305483,3.25)
18863	17	(14.856406460551018,1)
18864	173	(11.392304845413264,4)
18865	53	(11.825317547305483,1.75)
18866	2237	(32.609927238132009,42.25)
18867	2394	(30.011851026778693,45.25)
18868	2394	(30.011851026778693,45.25)
18869	1821	(18.753520777580992,34.75)
18870	1780	(17.454482671904334,34)
18871	2141	(18.753520777580992,40.75)
18872	1821	(18.753520777580992,34.75)
18873	1814	(12.691342951089922,34.75)
18874	1812	(10.959292143521045,34.75)
18875	1822	(19.619546181365433,34.75)
18876	1736	(14.423393758658799,33.25)
18877	1740	(17.887495373796554,33.25)
18878	1849	(7.9282032302755088,35.5)
18879	1942	(19.186533479473212,37)
18880	1822	(19.619546181365433,34.75)
18881	1694	(12.258330249197702,32.5)
18882	1772	(10.526279441628825,34)
18883	2060	(17.887495373796554,39.25)
18884	2060	(17.887495373796554,39.25)
18885	1768	(7.0621778264910704,34)
18886	1769	(7.9282032302755088,34)
18887	1768	(7.0621778264910704,34)
18888	1852	(10.526279441628825,35.5)
18889	1769	(7.9282032302755088,34)
18890	1768	(7.0621778264910704,34)
18891	1852	(10.526279441628825,35.5)
18892	2060	(17.887495373796554,39.25)
18893	2206	(5.7631397208144124,42.25)
18894	1962	(2.299038105676658,37.75)
18895	2060	(17.887495373796554,39.25)
18896	1807	(6.6291651245988508,34.75)
18897	1926	(5.3301270189221936,37)
18898	2255	(13.124355652982141,43)
18899	2207	(6.6291651245988508,42.25)
18900	860	(17.887495373796554,16.75)
18901	1939	(16.588457268119896,37)
18902	1809	(8.3612159321677293,34.75)
18903	1807	(6.6291651245988508,34.75)
18904	2170	(8.794228634059948,41.5)
18905	1884	(4.0310889132455356,36.25)
18906	2003	(2.7320508075688772,38.5)
18907	2362	(2.299038105676658,45.25)
18908	2361	(1.4330127018922194,45.25)
18909	2361	(1.4330127018922194,45.25)
18910	2361	(1.4330127018922194,45.25)
18911	2361	(1.4330127018922194,45.25)
18912	2262	(19.186533479473212,43)
18913	2347	(23.516660498395403,44.5)
18914	2261	(18.320508075688775,43)
18915	2347	(23.516660498395403,44.5)
18916	2306	(23.083647796503186,43.75)
18917	2340	(17.454482671904334,44.5)
18918	2382	(19.619546181365433,45.25)
18919	2382	(19.619546181365433,45.25)
18920	2341	(18.320508075688775,44.5)
18921	1240	(34.774990747593108,23.5)
18922	1240	(34.774990747593108,23.5)
18923	1360	(35.208003449485325,25.75)
18924	1440	(35.208003449485325,27.25)
18925	1480	(34.774990747593108,28)
18926	1960	(34.774990747593108,37)
18927	2000	(35.208003449485325,37.75)
18928	1355	(30.877876430563134,25.75)
18929	2359	(33.908965343808667,44.5)
18930	1902	(19.619546181365433,36.25)
18931	2396	(31.743901834347572,45.25)
18932	266	(22.650635094610966,5.5)
18933	145	(22.217622392718749,3.25)
18934	226	(23.083647796503186,4.75)
18935	226	(23.083647796503186,4.75)
18936	145	(22.217622392718749,3.25)
18937	30	(26.114736709748719,1)
18938	37	(32.176914536239792,1)
18939	30	(26.114736709748719,1)
18940	36	(31.310889132455351,1)
18941	2231	(27.413774815425377,42.25)
18942	2233	(29.145825622994256,42.25)
18943	1706	(22.650635094610966,32.5)
18944	1706	(22.650635094610966,32.5)
18945	1706	(22.650635094610966,32.5)
18946	1706	(22.650635094610966,32.5)
18947	1158	(33.042939940024233,22)
18948	31	(26.98076211353316,1)
18949	197	(32.176914536239792,4)
18950	1471	(26.98076211353316,28)
18951	1715	(30.444863728670914,32.5)
18952	840	(34.774990747593108,16)
18953	1750	(26.54774941164094,33.25)
18954	1019	(17.021469970012117,19.75)
18955	748	(24.382685902179844,14.5)
18956	788	(24.815698604072061,15.25)
18957	943	(20.48557158514987,18.25)
18958	782	(19.619546181365433,15.25)
18959	822	(19.186533479473212,16)
18960	1417	(15.289419162443238,27.25)
18961	1417	(15.289419162443238,27.25)
18962	1298	(15.722431864335457,25)
18963	1298	(15.722431864335457,25)
18964	1417	(15.289419162443238,27.25)
18965	1376	(13.99038105676658,26.5)
18966	1302	(19.186533479473212,25)
18967	1336	(14.423393758658799,25.75)
18968	1256	(14.423393758658799,24.25)
18969	1670	(26.54774941164094,31.75)
18970	1708	(24.382685902179844,32.5)
18971	1708	(24.382685902179844,32.5)
18972	1748	(24.815698604072061,33.25)
18973	1708	(24.382685902179844,32.5)
18974	1669	(25.681724007856502,31.75)
18975	1708	(24.382685902179844,32.5)
18976	1416	(14.423393758658799,27.25)
18977	1413	(11.825317547305483,27.25)
18978	1412	(10.959292143521045,27.25)
18979	1451	(9.6602540378443873,28)
18980	1451	(9.6602540378443873,28)
18981	978	(15.722431864335457,19)
18982	1592	(28.279800219209818,30.25)
18983	1633	(28.712812921102035,31)
18984	1790	(26.114736709748719,34)
18985	1790	(26.114736709748719,34)
18986	1834	(30.011851026778693,34.75)
18987	1790	(26.114736709748719,34)
18988	1833	(29.145825622994256,34.75)
18989	1905	(22.217622392718749,36.25)
18990	1864	(20.918584287042091,35.5)
18991	2289	(8.3612159321677293,43.75)
18992	2289	(8.3612159321677293,43.75)
18993	1786	(22.650635094610966,34)
18994	2373	(11.825317547305483,45.25)
18995	1786	(22.650635094610966,34)
18996	2370	(9.2272413359521668,45.25)
18997	1786	(22.650635094610966,34)
18998	1786	(22.650635094610966,34)
18999	2370	(9.2272413359521668,45.25)
19000	2373	(11.825317547305483,45.25)
19001	1786	(22.650635094610966,34)
19002	1660	(17.887495373796554,31.75)
19003	490	(8.794228634059948,10)
19004	446	(5.7631397208144124,9.25)
19005	524	(4.0310889132455356,10.75)
19006	601	(1.4330127018922194,12.25)
19007	441	(1.4330127018922194,9.25)
19008	441	(1.4330127018922194,9.25)
19009	524	(4.0310889132455356,10.75)
19010	564	(3.598076211353316,11.5)
19011	603	(3.1650635094610968,12.25)
19012	644	(3.598076211353316,13)
19013	1370	(8.794228634059948,26.5)
19014	601	(1.4330127018922194,12.25)
19015	1249	(8.3612159321677293,24.25)
19016	601	(1.4330127018922194,12.25)
19017	1249	(8.3612159321677293,24.25)
19018	1249	(8.3612159321677293,24.25)
19019	1126	(5.3301270189221936,22)
19020	1126	(5.3301270189221936,22)
19021	1126	(5.3301270189221936,22)
19022	1126	(5.3301270189221936,22)
19023	1362	(1.8660254037844386,26.5)
19024	841	(1.4330127018922194,16.75)
19025	882	(1.8660254037844386,17.5)
19026	1328	(7.49519052838329,25.75)
19027	1287	(6.196152422706632,25)
19028	1287	(6.196152422706632,25)
19029	686	(5.7631397208144124,13.75)
19030	921	(1.4330127018922194,18.25)
19031	1243	(3.1650635094610968,24.25)
19032	1203	(2.7320508075688772,23.5)
19033	1125	(4.4641016151377544,22)
19034	841	(1.4330127018922194,16.75)
19035	921	(1.4330127018922194,18.25)
19036	841	(1.4330127018922194,16.75)
19037	921	(1.4330127018922194,18.25)
19038	921	(1.4330127018922194,18.25)
19039	563	(2.7320508075688772,11.5)
19040	761	(1.4330127018922194,15.25)
19041	721	(1,14.5)
19042	721	(1,14.5)
19043	2159	(34.341978045700891,40.75)
19044	2159	(34.341978045700891,40.75)
19045	2159	(34.341978045700891,40.75)
19046	2195	(30.444863728670914,41.5)
19047	2195	(30.444863728670914,41.5)
19048	2234	(30.011851026778693,42.25)
19049	2399	(34.341978045700891,45.25)
19050	2232	(28.279800219209818,42.25)
19051	2232	(28.279800219209818,42.25)
19052	2280	(34.774990747593108,43)
19053	2279	(33.908965343808667,43)
19054	2279	(33.908965343808667,43)
19055	2347	(23.516660498395403,44.5)
19056	2156	(31.743901834347572,40.75)
19057	2118	(33.042939940024233,40)
19058	2118	(33.042939940024233,40)
19059	2118	(33.042939940024233,40)
19060	1945	(21.784609690826528,37)
19061	1683	(2.7320508075688772,32.5)
19062	1962	(2.299038105676658,37.75)
19063	1416	(14.423393758658799,27.25)
19064	1372	(10.526279441628825,26.5)
19065	1412	(10.959292143521045,27.25)
19066	978	(15.722431864335457,19)
19067	2178	(15.722431864335457,41.5)
19068	2139	(17.021469970012117,40.75)
19069	2178	(15.722431864335457,41.5)
19070	886	(5.3301270189221936,17.5)
19071	485	(4.4641016151377544,10)
19072	485	(4.4641016151377544,10)
19073	1414	(12.691342951089922,27.25)
19074	1374	(12.258330249197702,26.5)
19075	485	(4.4641016151377544,10)
19076	485	(4.4641016151377544,10)
19077	485	(4.4641016151377544,10)
19078	1287	(6.196152422706632,25)
19079	1163	(3.1650635094610968,22.75)
19080	363	(3.1650635094610968,7.75)
19081	1370	(8.794228634059948,26.5)
19082	1411	(10.093266739736606,27.25)
19083	2279	(33.908965343808667,43)
19084	1171	(10.093266739736606,22.75)
19085	566	(5.3301270189221936,11.5)
19086	682	(2.299038105676658,13.75)
19087	1169	(8.3612159321677293,22.75)
19088	1169	(8.3612159321677293,22.75)
19089	1169	(8.3612159321677293,22.75)
19090	1363	(2.7320508075688772,26.5)
19091	1363	(2.7320508075688772,26.5)
19092	1363	(2.7320508075688772,26.5)
19093	1321	(1.4330127018922194,25.75)
19094	1321	(1.4330127018922194,25.75)
19095	1321	(1.4330127018922194,25.75)
19096	1321	(1.4330127018922194,25.75)
19097	1321	(1.4330127018922194,25.75)
19098	1281	(1,25)
19099	1281	(1,25)
19100	1241	(1.4330127018922194,24.25)
19101	1241	(1.4330127018922194,24.25)
19102	1241	(1.4330127018922194,24.25)
19103	1241	(1.4330127018922194,24.25)
19104	1241	(1.4330127018922194,24.25)
19105	1241	(1.4330127018922194,24.25)
19106	1241	(1.4330127018922194,24.25)
19107	1241	(1.4330127018922194,24.25)
19108	1241	(1.4330127018922194,24.25)
19109	1161	(1.4330127018922194,22.75)
19110	1161	(1.4330127018922194,22.75)
19111	1121	(1,22)
19112	1121	(1,22)
19113	1121	(1,22)
19114	1121	(1,22)
19115	1121	(1,22)
19116	1121	(1,22)
19117	1121	(1,22)
19118	2104	(20.918584287042091,40)
19119	1121	(1,22)
19120	1092	(10.959292143521045,21.25)
19121	2071	(27.413774815425377,39.25)
19122	1171	(10.093266739736606,22.75)
19123	2035	(30.444863728670914,38.5)
19124	1955	(30.444863728670914,37)
19125	1604	(3.598076211353316,31)
19126	1841	(1,35.5)
19127	1494	(12.691342951089922,28.75)
19128	2071	(27.413774815425377,39.25)
19129	2071	(27.413774815425377,39.25)
19130	1092	(10.959292143521045,21.25)
19131	1524	(3.598076211353316,29.5)
19132	1523	(2.7320508075688772,29.5)
19133	1563	(3.1650635094610968,30.25)
19134	1441	(1,28)
19135	1441	(1,28)
19136	1521	(1,29.5)
19137	1483	(3.1650635094610968,28.75)
19138	1483	(3.1650635094610968,28.75)
19139	1954	(29.578838324886476,37)
19140	2028	(24.382685902179844,38.5)
19141	1641	(1.4330127018922194,31.75)
19142	1989	(25.681724007856502,37.75)
19143	1944	(20.918584287042091,37)
19144	1706	(22.650635094610966,32.5)
19145	2071	(27.413774815425377,39.25)
19146	1627	(23.516660498395403,31)
19147	1669	(25.681724007856502,31.75)
19148	2068	(24.815698604072061,39.25)
19149	1985	(22.217622392718749,37.75)
19150	1641	(1.4330127018922194,31.75)
19151	1643	(3.1650635094610968,31.75)
19152	1626	(22.650635094610966,31)
19153	1368	(7.0621778264910704,26.5)
19154	1326	(5.7631397208144124,25.75)
19155	1751	(27.413774815425377,33.25)
19156	1704	(20.918584287042091,32.5)
19157	1704	(20.918584287042091,32.5)
19158	1704	(20.918584287042091,32.5)
19159	1704	(20.918584287042091,32.5)
19160	1551	(26.98076211353316,29.5)
19161	1783	(20.05255888325765,34)
19162	1669	(25.681724007856502,31.75)
19163	1591	(27.413774815425377,30.25)
19164	1834	(30.011851026778693,34.75)
19165	1626	(22.650635094610966,31)
19166	1669	(25.681724007856502,31.75)
19167	2035	(30.444863728670914,38.5)
19168	1831	(27.413774815425377,34.75)
19169	1533	(11.392304845413264,29.5)
19170	2250	(8.794228634059948,43)
19171	2289	(8.3612159321677293,43.75)
19172	2331	(9.6602540378443873,44.5)
19173	2330	(8.794228634059948,44.5)
19174	2289	(8.3612159321677293,43.75)
19175	2289	(8.3612159321677293,43.75)
19176	2289	(8.3612159321677293,43.75)
19177	2371	(10.093266739736606,45.25)
19178	1706	(22.650635094610966,32.5)
19179	2026	(22.650635094610966,38.5)
19180	1481	(1.4330127018922194,28.75)
19181	1481	(1.4330127018922194,28.75)
19182	1441	(1,28)
19183	938	(16.155444566227676,18.25)
19184	936	(14.423393758658799,18.25)
19185	1054	(12.258330249197702,20.5)
19186	938	(16.155444566227676,18.25)
19187	1057	(14.856406460551018,20.5)
19188	1054	(12.258330249197702,20.5)
19189	2371	(10.093266739736606,45.25)
19190	939	(17.021469970012117,18.25)
19191	734	(12.258330249197702,14.5)
19192	895	(13.124355652982141,17.5)
19193	734	(12.258330249197702,14.5)
19194	214	(12.691342951089922,4.75)
19195	376	(14.423393758658799,7.75)
19196	934	(12.691342951089922,18.25)
19197	933	(11.825317547305483,18.25)
19198	936	(14.423393758658799,18.25)
19199	936	(14.423393758658799,18.25)
19200	1521	(1,29.5)
19201	1724	(4.0310889132455356,33.25)
19202	1724	(4.0310889132455356,33.25)
19203	1872	(27.846787517317598,35.5)
19204	1949	(25.248711305964282,37)
19205	1684	(3.598076211353316,32.5)
19206	1869	(25.248711305964282,35.5)
19207	1684	(3.598076211353316,32.5)
19208	1724	(4.0310889132455356,33.25)
19209	13	(11.392304845413264,1)
19210	740	(17.454482671904334,14.5)
19211	737	(14.856406460551018,14.5)
19212	1725	(4.897114317029974,33.25)
19213	1724	(4.0310889132455356,33.25)
19214	2400	(35.208003449485325,45.25)
19215	2200	(34.774990747593108,41.5)
19216	2356	(31.310889132455351,44.5)
19217	2399	(34.341978045700891,45.25)
19218	1869	(25.248711305964282,35.5)
19219	2156	(31.743901834347572,40.75)
19220	2194	(29.578838324886476,41.5)
19221	2194	(29.578838324886476,41.5)
19222	2194	(29.578838324886476,41.5)
19223	1957	(32.176914536239792,37)
19224	2194	(29.578838324886476,41.5)
19225	2194	(29.578838324886476,41.5)
19226	2157	(32.609927238132009,40.75)
19227	2200	(34.774990747593108,41.5)
19228	2200	(34.774990747593108,41.5)
19229	11	(9.6602540378443873,1)
19230	60	(17.887495373796554,1.75)
19231	100	(17.454482671904334,2.5)
19232	138	(16.155444566227676,3.25)
19233	11	(9.6602540378443873,1)
19234	178	(15.722431864335457,4)
19235	178	(15.722431864335457,4)
19236	178	(15.722431864335457,4)
19237	138	(16.155444566227676,3.25)
19238	748	(24.382685902179844,14.5)
19239	788	(24.815698604072061,15.25)
19240	787	(23.949673200287624,15.25)
19241	1185	(22.217622392718749,22.75)
19242	1185	(22.217622392718749,22.75)
19243	905	(21.784609690826528,17.5)
19244	1098	(16.155444566227676,21.25)
19245	12	(10.526279441628825,1)
19246	586	(22.650635094610966,11.5)
19247	664	(20.918584287042091,13)
19248	662	(19.186533479473212,13)
19249	662	(19.186533479473212,13)
19250	618	(16.155444566227676,12.25)
19251	618	(16.155444566227676,12.25)
19252	1260	(17.887495373796554,24.25)
19253	1152	(27.846787517317598,22)
19254	2376	(14.423393758658799,45.25)
19255	2376	(14.423393758658799,45.25)
19256	2376	(14.423393758658799,45.25)
19257	1538	(15.722431864335457,29.5)
19258	1618	(15.722431864335457,31)
19259	1619	(16.588457268119896,31)
19260	1352	(28.279800219209818,25.75)
19261	1390	(26.114736709748719,26.5)
19262	1350	(26.54774941164094,25.75)
19263	1470	(26.114736709748719,28)
19264	1508	(24.815698604072061,28.75)
19265	1424	(21.351596988934308,27.25)
19266	1464	(20.918584287042091,28)
19267	1464	(20.918584287042091,28)
19268	1623	(20.05255888325765,31)
19269	1509	(25.681724007856502,28.75)
19270	1548	(24.382685902179844,29.5)
19271	1548	(24.382685902179844,29.5)
19272	74	(30.011851026778693,1.75)
19273	153	(29.145825622994256,3.25)
19274	37	(32.176914536239792,1)
19275	271	(26.98076211353316,5.5)
19276	153	(29.145825622994256,3.25)
19277	154	(30.011851026778693,3.25)
19278	31	(26.98076211353316,1)
19279	271	(26.98076211353316,5.5)
19280	673	(28.712812921102035,13)
19281	31	(26.98076211353316,1)
19282	31	(26.98076211353316,1)
19283	31	(26.98076211353316,1)
19284	673	(28.712812921102035,13)
19285	34	(29.578838324886476,1)
19286	72	(28.279800219209818,1.75)
19287	72	(28.279800219209818,1.75)
19288	31	(26.98076211353316,1)
19289	31	(26.98076211353316,1)
19290	33	(28.712812921102035,1)
19291	34	(29.578838324886476,1)
19292	113	(28.712812921102035,2.5)
19293	113	(28.712812921102035,2.5)
19294	31	(26.98076211353316,1)
19295	116	(31.310889132455351,2.5)
19296	959	(34.341978045700891,18.25)
19297	560	(35.208003449485325,10.75)
19298	197	(32.176914536239792,4)
19299	197	(32.176914536239792,4)
19300	31	(26.98076211353316,1)
19301	31	(26.98076211353316,1)
19302	72	(28.279800219209818,1.75)
19303	1160	(34.774990747593108,22)
19304	1160	(34.774990747593108,22)
19305	1360	(35.208003449485325,25.75)
19306	2317	(32.609927238132009,43.75)
19307	2269	(25.248711305964282,43)
19308	2358	(33.042939940024233,44.5)
19309	1356	(31.743901834347572,25.75)
19310	31	(26.98076211353316,1)
19311	31	(26.98076211353316,1)
19312	73	(29.145825622994256,1.75)
19313	1000	(34.774990747593108,19)
19314	1000	(34.774990747593108,19)
19315	27	(23.516660498395403,1)
19316	1036	(31.743901834347572,19.75)
19317	31	(26.98076211353316,1)
19318	1232	(27.846787517317598,23.5)
19319	1230	(26.114736709748719,23.5)
19320	1000	(34.774990747593108,19)
19321	874	(30.011851026778693,16.75)
19322	1230	(26.114736709748719,23.5)
19323	874	(30.011851026778693,16.75)
19324	752	(27.846787517317598,14.5)
19325	751	(26.98076211353316,14.5)
19326	1121	(1,22)
19327	1121	(1,22)
19328	1121	(1,22)
19329	1121	(1,22)
19330	1121	(1,22)
19331	1121	(1,22)
19332	1121	(1,22)
19333	1121	(1,22)
19334	1121	(1,22)
19335	1121	(1,22)
19336	1860	(17.454482671904334,35.5)
19337	1776	(13.99038105676658,34)
19338	1929	(7.9282032302755088,37)
19339	1977	(15.289419162443238,37.75)
19340	1852	(10.526279441628825,35.5)
19341	2060	(17.887495373796554,39.25)
19342	1889	(8.3612159321677293,36.25)
19343	2134	(12.691342951089922,40.75)
19344	1968	(7.49519052838329,37.75)
19345	2134	(12.691342951089922,40.75)
19346	1968	(7.49519052838329,37.75)
19347	2214	(12.691342951089922,42.25)
19348	2214	(12.691342951089922,42.25)
19349	2052	(10.959292143521045,39.25)
19350	1961	(1.4330127018922194,37.75)
19351	1961	(1.4330127018922194,37.75)
19352	2009	(7.9282032302755088,38.5)
19353	1930	(8.794228634059948,37)
19354	1977	(15.289419162443238,37.75)
19355	2170	(8.794228634059948,41.5)
19356	1924	(3.598076211353316,37)
19357	2091	(9.6602540378443873,40)
19358	2093	(11.392304845413264,40)
19359	2214	(12.691342951089922,42.25)
19360	2121	(1.4330127018922194,40.75)
19361	2041	(1.4330127018922194,39.25)
19362	2044	(4.0310889132455356,39.25)
19363	2392	(28.279800219209818,45.25)
19364	2352	(27.846787517317598,44.5)
19365	2310	(26.54774941164094,43.75)
19366	613	(11.825317547305483,12.25)
19367	1990	(26.54774941164094,37.75)
19368	2347	(23.516660498395403,44.5)
19369	2347	(23.516660498395403,44.5)
19370	2342	(19.186533479473212,44.5)
19371	2387	(23.949673200287624,45.25)
19372	2262	(19.186533479473212,43)
19373	2345	(21.784609690826528,44.5)
19374	2367	(6.6291651245988508,45.25)
19375	2365	(4.897114317029974,45.25)
19376	2368	(7.49519052838329,45.25)
19377	2368	(7.49519052838329,45.25)
19378	2388	(24.815698604072061,45.25)
19379	2368	(7.49519052838329,45.25)
19380	2243	(2.7320508075688772,43)
19381	2202	(2.299038105676658,42.25)
19382	2282	(2.299038105676658,43.75)
19383	2201	(1.4330127018922194,42.25)
19384	2368	(7.49519052838329,45.25)
19385	2385	(22.217622392718749,45.25)
19386	2385	(22.217622392718749,45.25)
19387	2385	(22.217622392718749,45.25)
19388	2187	(23.516660498395403,41.5)
19389	2186	(22.650635094610966,41.5)
19390	88	(7.0621778264910704,2.5)
19391	88	(7.0621778264910704,2.5)
19392	82	(1.8660254037844386,2.5)
19393	82	(1.8660254037844386,2.5)
19394	123	(3.1650635094610968,3.25)
19395	82	(1.8660254037844386,2.5)
19396	123	(3.1650635094610968,3.25)
19397	123	(3.1650635094610968,3.25)
19398	320	(35.208003449485325,6.25)
19399	31	(26.98076211353316,1)
19400	31	(26.98076211353316,1)
19401	1240	(34.774990747593108,23.5)
19402	1240	(34.774990747593108,23.5)
19403	1399	(33.908965343808667,26.5)
19404	1597	(32.609927238132009,30.25)
19405	1600	(35.208003449485325,30.25)
19406	2080	(35.208003449485325,39.25)
19407	2236	(31.743901834347572,42.25)
19408	2159	(34.341978045700891,40.75)
19409	2080	(35.208003449485325,39.25)
19410	2080	(35.208003449485325,39.25)
19411	1197	(32.609927238132009,22.75)
19412	1197	(32.609927238132009,22.75)
19413	1079	(33.908965343808667,20.5)
19414	1479	(33.908965343808667,28)
19415	1479	(33.908965343808667,28)
19416	1519	(34.341978045700891,28.75)
19417	1240	(34.774990747593108,23.5)
19418	1240	(34.774990747593108,23.5)
19419	1598	(33.47595264191645,30.25)
19420	1596	(31.743901834347572,30.25)
19421	31	(26.98076211353316,1)
19422	398	(33.47595264191645,7.75)
19423	34	(29.578838324886476,1)
19424	72	(28.279800219209818,1.75)
19425	32	(27.846787517317598,1)
19426	31	(26.98076211353316,1)
19427	31	(26.98076211353316,1)
19428	37	(32.176914536239792,1)
19429	34	(29.578838324886476,1)
19430	72	(28.279800219209818,1.75)
19431	71	(27.413774815425377,1.75)
19432	31	(26.98076211353316,1)
19433	320	(35.208003449485325,6.25)
19434	560	(35.208003449485325,10.75)
19435	560	(35.208003449485325,10.75)
19436	560	(35.208003449485325,10.75)
19437	560	(35.208003449485325,10.75)
19438	320	(35.208003449485325,6.25)
19439	1753	(29.145825622994256,33.25)
19440	1715	(30.444863728670914,32.5)
19441	1717	(32.176914536239792,32.5)
19442	1759	(34.341978045700891,33.25)
19443	1760	(35.208003449485325,33.25)
19444	1680	(35.208003449485325,31.75)
19445	398	(33.47595264191645,7.75)
19446	33	(28.712812921102035,1)
19447	72	(28.279800219209818,1.75)
19448	72	(28.279800219209818,1.75)
19449	31	(26.98076211353316,1)
19450	320	(35.208003449485325,6.25)
19451	37	(32.176914536239792,1)
19452	33	(28.712812921102035,1)
19453	70	(26.54774941164094,1.75)
19454	70	(26.54774941164094,1.75)
19455	30	(26.114736709748719,1)
19456	31	(26.98076211353316,1)
19457	1753	(29.145825622994256,33.25)
19458	1715	(30.444863728670914,32.5)
19459	1717	(32.176914536239792,32.5)
19460	1759	(34.341978045700891,33.25)
19461	1760	(35.208003449485325,33.25)
19462	1680	(35.208003449485325,31.75)
19463	31	(26.98076211353316,1)
19464	30	(26.114736709748719,1)
19465	1476	(31.310889132455351,28)
19466	1753	(29.145825622994256,33.25)
19467	1715	(30.444863728670914,32.5)
19468	1676	(31.743901834347572,31.75)
19469	1717	(32.176914536239792,32.5)
19470	1718	(33.042939940024233,32.5)
19471	1759	(34.341978045700891,33.25)
19472	1760	(35.208003449485325,33.25)
19473	1680	(35.208003449485325,31.75)
19474	30	(26.114736709748719,1)
19475	1600	(35.208003449485325,30.25)
19476	1760	(35.208003449485325,33.25)
19477	1720	(34.774990747593108,32.5)
19478	1720	(34.774990747593108,32.5)
19479	618	(16.155444566227676,12.25)
19480	618	(16.155444566227676,12.25)
19481	631	(27.413774815425377,12.25)
19482	391	(27.413774815425377,7.75)
19483	391	(27.413774815425377,7.75)
19484	391	(27.413774815425377,7.75)
19485	391	(27.413774815425377,7.75)
19486	954	(30.011851026778693,18.25)
19487	1031	(27.413774815425377,19.75)
19488	990	(26.114736709748719,19)
19489	990	(26.114736709748719,19)
19490	947	(23.949673200287624,18.25)
19491	947	(23.949673200287624,18.25)
19492	947	(23.949673200287624,18.25)
19493	947	(23.949673200287624,18.25)
19494	2123	(3.1650635094610968,40.75)
19495	1119	(34.341978045700891,21.25)
19496	1119	(34.341978045700891,21.25)
19497	957	(32.609927238132009,18.25)
19498	720	(35.208003449485325,13.75)
19499	1398	(33.042939940024233,26.5)
19500	2154	(30.011851026778693,40.75)
19501	2233	(29.145825622994256,42.25)
19502	957	(32.609927238132009,18.25)
19503	1158	(33.042939940024233,22)
19504	1158	(33.042939940024233,22)
19505	1079	(33.908965343808667,20.5)
19506	1479	(33.908965343808667,28)
19507	1479	(33.908965343808667,28)
19508	1519	(34.341978045700891,28.75)
19509	155	(30.877876430563134,3.25)
19510	155	(30.877876430563134,3.25)
19511	195	(30.444863728670914,4)
19512	274	(29.578838324886476,5.5)
19513	274	(29.578838324886476,5.5)
19514	319	(34.341978045700891,6.25)
19515	320	(35.208003449485325,6.25)
19516	600	(34.774990747593108,11.5)
19517	353	(28.712812921102035,7)
19518	319	(34.341978045700891,6.25)
19519	600	(34.774990747593108,11.5)
19520	353	(28.712812921102035,7)
19521	319	(34.341978045700891,6.25)
19522	320	(35.208003449485325,6.25)
19523	319	(34.341978045700891,6.25)
19524	2026	(22.650635094610966,38.5)
19525	1986	(23.083647796503186,37.75)
19526	2025	(21.784609690826528,38.5)
19527	2025	(21.784609690826528,38.5)
19528	1779	(16.588457268119896,34)
19529	2397	(32.609927238132009,45.25)
19530	2397	(32.609927238132009,45.25)
19531	2396	(31.743901834347572,45.25)
19532	2396	(31.743901834347572,45.25)
19533	2279	(33.908965343808667,43)
19534	2359	(33.908965343808667,44.5)
19535	2196	(31.310889132455351,41.5)
19536	1	(1,1)
19537	1	(1,1)
19538	1	(1,1)
19539	1267	(23.949673200287624,24.25)
19540	1267	(23.949673200287624,24.25)
19541	2243	(2.7320508075688772,43)
19542	2279	(33.908965343808667,43)
19543	1911	(27.413774815425377,36.25)
19544	1171	(10.093266739736606,22.75)
19545	1171	(10.093266739736606,22.75)
19546	1407	(6.6291651245988508,27.25)
19547	1448	(7.0621778264910704,28)
19548	730	(8.794228634059948,14.5)
19549	448	(7.49519052838329,9.25)
19550	568	(7.0621778264910704,11.5)
19551	1172	(10.959292143521045,22.75)
19552	1172	(10.959292143521045,22.75)
19553	770	(9.2272413359521668,15.25)
19554	1326	(5.7631397208144124,25.75)
19555	1326	(5.7631397208144124,25.75)
19556	1326	(5.7631397208144124,25.75)
19557	925	(4.897114317029974,18.25)
19558	1366	(5.3301270189221936,26.5)
19559	1366	(5.3301270189221936,26.5)
19560	1366	(5.3301270189221936,26.5)
19561	412	(10.526279441628825,8.5)
19562	2035	(30.444863728670914,38.5)
19563	1992	(28.279800219209818,37.75)
19564	2071	(27.413774815425377,39.25)
19565	1651	(10.093266739736606,31.75)
19566	1609	(7.9282032302755088,31)
19567	1605	(4.4641016151377544,31)
19568	1605	(4.4641016151377544,31)
19569	1524	(3.598076211353316,29.5)
19570	2156	(31.743901834347572,40.75)
19571	2028	(24.382685902179844,38.5)
19572	2028	(24.382685902179844,38.5)
19573	1611	(9.6602540378443873,31)
19574	2068	(24.815698604072061,39.25)
19575	1487	(6.6291651245988508,28.75)
19576	1790	(26.114736709748719,34)
19577	1790	(26.114736709748719,34)
19578	895	(13.124355652982141,17.5)
19579	895	(13.124355652982141,17.5)
19580	734	(12.258330249197702,14.5)
19581	664	(20.918584287042091,13)
19582	703	(20.48557158514987,13.75)
19583	577	(14.856406460551018,11.5)
19584	947	(23.949673200287624,18.25)
19585	1068	(24.382685902179844,20.5)
19586	1068	(24.382685902179844,20.5)
19587	1067	(23.516660498395403,20.5)
19588	1145	(21.784609690826528,22)
19589	1145	(21.784609690826528,22)
19590	905	(21.784609690826528,17.5)
19591	905	(21.784609690826528,17.5)
19592	905	(21.784609690826528,17.5)
19593	1137	(14.856406460551018,22)
19594	1137	(14.856406460551018,22)
19595	940	(17.887495373796554,18.25)
19596	934	(12.691342951089922,18.25)
19597	938	(16.155444566227676,18.25)
19598	976	(13.99038105676658,19)
19599	1135	(13.124355652982141,22)
19600	933	(11.825317547305483,18.25)
19601	935	(13.55736835487436,18.25)
19602	1592	(28.279800219209818,30.25)
19603	1591	(27.413774815425377,30.25)
19604	1831	(27.413774815425377,34.75)
19605	1864	(20.918584287042091,35.5)
19606	1791	(26.98076211353316,34)
19607	1591	(27.413774815425377,30.25)
19608	425	(21.784609690826528,8.5)
19609	426	(22.650635094610966,8.5)
19610	505	(21.784609690826528,10)
19611	423	(20.05255888325765,8.5)
19612	461	(18.753520777580992,9.25)
19613	461	(18.753520777580992,9.25)
19614	1232	(27.846787517317598,23.5)
19615	1352	(28.279800219209818,25.75)
19616	1390	(26.114736709748719,26.5)
19617	1312	(27.846787517317598,25)
19618	1312	(27.846787517317598,25)
19619	1470	(26.114736709748719,28)
19620	1508	(24.815698604072061,28.75)
19621	1430	(26.54774941164094,27.25)
19622	1470	(26.114736709748719,28)
19623	1538	(15.722431864335457,29.5)
19624	1537	(14.856406460551018,29.5)
19625	1578	(16.155444566227676,30.25)
19626	1619	(16.588457268119896,31)
19627	1620	(17.454482671904334,31)
19628	1545	(21.784609690826528,29.5)
19629	1545	(21.784609690826528,29.5)
19630	1544	(20.918584287042091,29.5)
19631	1545	(21.784609690826528,29.5)
19632	1902	(19.619546181365433,36.25)
19633	1942	(19.186533479473212,37)
19634	1897	(15.289419162443238,36.25)
19635	2060	(17.887495373796554,39.25)
19636	1859	(16.588457268119896,35.5)
19637	1780	(17.454482671904334,34)
19638	1821	(18.753520777580992,34.75)
19639	1942	(19.186533479473212,37)
19640	2060	(17.887495373796554,39.25)
19641	1980	(17.887495373796554,37.75)
19642	2141	(18.753520777580992,40.75)
19643	1888	(7.49519052838329,36.25)
19644	1886	(5.7631397208144124,36.25)
19645	2060	(17.887495373796554,39.25)
19646	2126	(5.7631397208144124,40.75)
19647	2174	(12.258330249197702,41.5)
19648	2133	(11.825317547305483,40.75)
19649	1925	(4.4641016151377544,37)
19650	2060	(17.887495373796554,39.25)
19651	2011	(9.6602540378443873,38.5)
19652	2134	(12.691342951089922,40.75)
19653	2213	(11.825317547305483,42.25)
19654	2171	(9.6602540378443873,41.5)
19655	1968	(7.49519052838329,37.75)
19656	2093	(11.392304845413264,40)
19657	2092	(10.526279441628825,40)
19658	1961	(1.4330127018922194,37.75)
19659	2212	(10.959292143521045,42.25)
19660	2130	(9.2272413359521668,40.75)
19661	2134	(12.691342951089922,40.75)
19662	2101	(18.320508075688775,40)
19663	1886	(5.7631397208144124,36.25)
19664	1888	(7.49519052838329,36.25)
19665	2060	(17.887495373796554,39.25)
19666	1772	(10.526279441628825,34)
19667	1928	(7.0621778264910704,37)
19668	1694	(12.258330249197702,32.5)
19669	1772	(10.526279441628825,34)
19670	1772	(10.526279441628825,34)
19671	1739	(17.021469970012117,33.25)
19672	1981	(18.753520777580992,37.75)
19673	1774	(12.258330249197702,34)
19674	1942	(19.186533479473212,37)
19675	1942	(19.186533479473212,37)
19676	95	(13.124355652982141,2.5)
19677	94	(12.258330249197702,2.5)
19678	94	(12.258330249197702,2.5)
19679	1736	(14.423393758658799,33.25)
19680	175	(13.124355652982141,4)
19681	176	(13.99038105676658,4)
19682	175	(13.124355652982141,4)
19683	175	(13.124355652982141,4)
19684	53	(11.825317547305483,1.75)
19685	13	(11.392304845413264,1)
19686	175	(13.124355652982141,4)
19687	13	(11.392304845413264,1)
19688	1227	(23.516660498395403,23.5)
19689	1145	(21.784609690826528,22)
19690	1032	(28.279800219209818,19.75)
19691	1032	(28.279800219209818,19.75)
19692	1027	(23.949673200287624,19.75)
19693	167	(6.196152422706632,4)
19694	167	(6.196152422706632,4)
19695	85	(4.4641016151377544,2.5)
19696	85	(4.4641016151377544,2.5)
19697	44	(4.0310889132455356,1.75)
19698	204	(4.0310889132455356,4.75)
19699	283	(3.1650635094610968,6.25)
19700	201	(1.4330127018922194,4.75)
19701	241	(1,5.5)
19702	1	(1,1)
19703	1	(1,1)
19704	1	(1,1)
19705	326	(5.3301270189221936,7)
19706	365	(4.897114317029974,7.75)
19707	365	(4.897114317029974,7.75)
19708	326	(5.3301270189221936,7)
19709	365	(4.897114317029974,7.75)
19710	364	(4.0310889132455356,7.75)
19711	2320	(35.208003449485325,43.75)
19712	1091	(10.093266739736606,21.25)
19713	2104	(20.918584287042091,40)
19714	1245	(4.897114317029974,24.25)
19715	810	(8.794228634059948,16)
19716	1342	(19.619546181365433,25.75)
19717	1343	(20.48557158514987,25.75)
19718	1340	(17.887495373796554,25.75)
19719	1298	(15.722431864335457,25)
19720	1336	(14.423393758658799,25.75)
19721	1306	(22.650635094610966,25)
19722	932	(10.959292143521045,18.25)
19723	1834	(30.011851026778693,34.75)
19724	1870	(26.114736709748719,35.5)
19725	1947	(23.516660498395403,37)
19726	1684	(3.598076211353316,32.5)
19727	1724	(4.0310889132455356,33.25)
19728	1869	(25.248711305964282,35.5)
19729	2400	(35.208003449485325,45.25)
19730	2200	(34.774990747593108,41.5)
19731	1869	(25.248711305964282,35.5)
19732	2399	(34.341978045700891,45.25)
19733	1947	(23.516660498395403,37)
19734	2150	(26.54774941164094,40.75)
19735	2150	(26.54774941164094,40.75)
19736	289	(8.3612159321677293,6.25)
19737	2148	(24.815698604072061,40.75)
19738	2225	(22.217622392718749,42.25)
19739	2276	(31.310889132455351,43)
19740	2276	(31.310889132455351,43)
19741	1160	(34.774990747593108,22)
19742	1160	(34.774990747593108,22)
19743	1160	(34.774990747593108,22)
19744	1360	(35.208003449485325,25.75)
19745	2317	(32.609927238132009,43.75)
19746	2269	(25.248711305964282,43)
19747	2358	(33.042939940024233,44.5)
19748	1356	(31.743901834347572,25.75)
19749	77	(32.609927238132009,1.75)
19750	77	(32.609927238132009,1.75)
19751	77	(32.609927238132009,1.75)
19752	240	(35.208003449485325,4.75)
19753	1934	(12.258330249197702,37)
19754	1934	(12.258330249197702,37)
19755	1934	(12.258330249197702,37)
19756	2098	(15.722431864335457,40)
19757	1934	(12.258330249197702,37)
19758	1155	(30.444863728670914,22)
19759	1155	(30.444863728670914,22)
19760	412	(10.526279441628825,8.5)
19761	1611	(9.6602540378443873,31)
19762	2026	(22.650635094610966,38.5)
19763	1611	(9.6602540378443873,31)
19764	1571	(10.093266739736606,30.25)
19765	1993	(29.145825622994256,37.75)
19766	2067	(23.949673200287624,39.25)
19767	1611	(9.6602540378443873,31)
19768	2112	(27.846787517317598,40)
19769	2395	(30.877876430563134,45.25)
19770	2394	(30.011851026778693,45.25)
19771	2392	(28.279800219209818,45.25)
19772	2352	(27.846787517317598,44.5)
19773	2394	(30.011851026778693,45.25)
19774	2394	(30.011851026778693,45.25)
19775	2280	(34.774990747593108,43)
19776	2396	(31.743901834347572,45.25)
19777	1766	(5.3301270189221936,34)
19778	2396	(31.743901834347572,45.25)
19779	2396	(31.743901834347572,45.25)
19780	1822	(19.619546181365433,34.75)
19781	2396	(31.743901834347572,45.25)
19782	2279	(33.908965343808667,43)
19783	2397	(32.609927238132009,45.25)
19784	1877	(32.176914536239792,35.5)
19785	1877	(32.176914536239792,35.5)
19786	1955	(30.444863728670914,37)
19787	2037	(32.176914536239792,38.5)
19788	1591	(27.413774815425377,30.25)
19789	2194	(29.578838324886476,41.5)
19790	2156	(31.743901834347572,40.75)
19791	2040	(34.774990747593108,38.5)
19792	2117	(32.176914536239792,40)
19793	2040	(34.774990747593108,38.5)
19794	2040	(34.774990747593108,38.5)
19795	2040	(34.774990747593108,38.5)
19796	1877	(32.176914536239792,35.5)
19797	2040	(34.774990747593108,38.5)
19798	792	(28.279800219209818,15.25)
19799	792	(28.279800219209818,15.25)
19800	1152	(27.846787517317598,22)
19801	1260	(17.887495373796554,24.25)
19802	1152	(27.846787517317598,22)
19803	1112	(28.279800219209818,21.25)
19804	1222	(19.186533479473212,23.5)
19805	1220	(17.454482671904334,23.5)
19806	596	(31.310889132455351,11.5)
19807	596	(31.310889132455351,11.5)
19808	475	(30.877876430563134,9.25)
19809	514	(29.578838324886476,10)
19810	395	(30.877876430563134,7.75)
19811	1036	(31.743901834347572,19.75)
19812	632	(28.279800219209818,12.25)
19813	514	(29.578838324886476,10)
19814	475	(30.877876430563134,9.25)
19815	435	(30.444863728670914,8.5)
19816	73	(29.145825622994256,1.75)
19817	395	(30.877876430563134,7.75)
19818	438	(33.042939940024233,8.5)
19819	438	(33.042939940024233,8.5)
19820	317	(32.609927238132009,6.25)
19821	553	(29.145825622994256,10.75)
19822	395	(30.877876430563134,7.75)
19823	272	(27.846787517317598,5.5)
19824	160	(35.208003449485325,3.25)
19825	39	(33.908965343808667,1)
19826	160	(35.208003449485325,3.25)
19827	199	(33.908965343808667,4)
19828	80	(35.208003449485325,1.75)
19829	240	(35.208003449485325,4.75)
19830	1277	(32.609927238132009,24.25)
19831	1277	(32.609927238132009,24.25)
19832	1277	(32.609927238132009,24.25)
19833	1476	(31.310889132455351,28)
19834	1753	(29.145825622994256,33.25)
19835	1715	(30.444863728670914,32.5)
19836	1717	(32.176914536239792,32.5)
19837	1759	(34.341978045700891,33.25)
19838	1760	(35.208003449485325,33.25)
19839	1680	(35.208003449485325,31.75)
19840	554	(30.011851026778693,10.75)
19841	269	(25.248711305964282,5.5)
19842	398	(33.47595264191645,7.75)
19843	398	(33.47595264191645,7.75)
19844	478	(33.47595264191645,9.25)
19845	1237	(32.176914536239792,23.5)
19846	1237	(32.176914536239792,23.5)
19847	1237	(32.176914536239792,23.5)
19848	917	(32.176914536239792,17.5)
19849	918	(33.042939940024233,17.5)
19850	77	(32.609927238132009,1.75)
19851	77	(32.609927238132009,1.75)
19852	77	(32.609927238132009,1.75)
19853	77	(32.609927238132009,1.75)
19854	77	(32.609927238132009,1.75)
19855	1240	(34.774990747593108,23.5)
19856	1240	(34.774990747593108,23.5)
19857	1240	(34.774990747593108,23.5)
19858	1360	(35.208003449485325,25.75)
19859	1600	(35.208003449485325,30.25)
19860	554	(30.011851026778693,10.75)
19861	436	(31.310889132455351,8.5)
19862	438	(33.042939940024233,8.5)
19863	395	(30.877876430563134,7.75)
19864	395	(30.877876430563134,7.75)
19865	1036	(31.743901834347572,19.75)
19866	632	(28.279800219209818,12.25)
19867	632	(28.279800219209818,12.25)
19868	632	(28.279800219209818,12.25)
19869	555	(30.877876430563134,10.75)
19870	146	(23.083647796503186,3.25)
19871	475	(30.877876430563134,9.25)
19872	145	(22.217622392718749,3.25)
19873	267	(23.516660498395403,5.5)
19874	395	(30.877876430563134,7.75)
19875	105	(21.784609690826528,2.5)
19876	436	(31.310889132455351,8.5)
19877	357	(32.176914536239792,7)
19878	398	(33.47595264191645,7.75)
19879	317	(32.609927238132009,6.25)
19880	676	(31.310889132455351,13)
19881	676	(31.310889132455351,13)
19882	676	(31.310889132455351,13)
19883	676	(31.310889132455351,13)
19884	676	(31.310889132455351,13)
19885	229	(25.681724007856502,4.75)
19886	395	(30.877876430563134,7.75)
19887	36	(31.310889132455351,1)
19888	314	(30.011851026778693,6.25)
19889	720	(35.208003449485325,13.75)
19890	720	(35.208003449485325,13.75)
19891	720	(35.208003449485325,13.75)
19892	720	(35.208003449485325,13.75)
19893	720	(35.208003449485325,13.75)
19894	146	(23.083647796503186,3.25)
19895	554	(30.011851026778693,10.75)
19896	554	(30.011851026778693,10.75)
19897	391	(27.413774815425377,7.75)
19898	554	(30.011851026778693,10.75)
19899	145	(22.217622392718749,3.25)
19900	308	(24.815698604072061,6.25)
19901	1352	(28.279800219209818,25.75)
19902	1390	(26.114736709748719,26.5)
19903	1471	(26.98076211353316,28)
19904	1545	(21.784609690826528,29.5)
19905	385	(22.217622392718749,7.75)
19906	426	(22.650635094610966,8.5)
19907	1471	(26.98076211353316,28)
19908	997	(32.176914536239792,19)
19909	596	(31.310889132455351,11.5)
19910	1119	(34.341978045700891,21.25)
19911	1119	(34.341978045700891,21.25)
19912	1119	(34.341978045700891,21.25)
19913	1398	(33.042939940024233,26.5)
19914	1031	(27.413774815425377,19.75)
19915	990	(26.114736709748719,19)
19916	2279	(33.908965343808667,43)
19917	2359	(33.908965343808667,44.5)
19918	1355	(30.877876430563134,25.75)
19919	1960	(34.774990747593108,37)
19920	2312	(28.279800219209818,43.75)
19921	835	(30.444863728670914,16)
19922	796	(31.743901834347572,15.25)
19923	834	(29.578838324886476,16)
19924	794	(30.011851026778693,15.25)
19925	792	(28.279800219209818,15.25)
19926	792	(28.279800219209818,15.25)
19927	2388	(24.815698604072061,45.25)
19928	2388	(24.815698604072061,45.25)
19929	2262	(19.186533479473212,43)
19930	2299	(17.021469970012117,43.75)
19931	2299	(17.021469970012117,43.75)
19932	2386	(23.083647796503186,45.25)
19933	2388	(24.815698604072061,45.25)
19934	2389	(25.681724007856502,45.25)
19935	2347	(23.516660498395403,44.5)
19936	2342	(19.186533479473212,44.5)
19937	2262	(19.186533479473212,43)
19938	2262	(19.186533479473212,43)
19939	2302	(19.619546181365433,43.75)
19940	2385	(22.217622392718749,45.25)
19941	2388	(24.815698604072061,45.25)
19942	2380	(17.887495373796554,45.25)
19943	2342	(19.186533479473212,44.5)
19944	2264	(20.918584287042091,43)
19945	2285	(4.897114317029974,43.75)
19946	2299	(17.021469970012117,43.75)
19947	2365	(4.897114317029974,45.25)
19948	2299	(17.021469970012117,43.75)
19949	2285	(4.897114317029974,43.75)
19950	2244	(3.598076211353316,43)
19951	2285	(4.897114317029974,43.75)
19952	2367	(6.6291651245988508,45.25)
19953	2281	(1.4330127018922194,43.75)
19954	2281	(1.4330127018922194,43.75)
19955	2365	(4.897114317029974,45.25)
19956	2382	(19.619546181365433,45.25)
19957	2243	(2.7320508075688772,43)
19958	731	(9.6602540378443873,14.5)
19959	730	(8.794228634059948,14.5)
19960	1405	(4.897114317029974,27.25)
19961	748	(24.382685902179844,14.5)
19962	788	(24.815698604072061,15.25)
19963	787	(23.949673200287624,15.25)
19964	787	(23.949673200287624,15.25)
19965	787	(23.949673200287624,15.25)
19966	827	(23.516660498395403,16)
19967	625	(22.217622392718749,12.25)
19968	2377	(15.289419162443238,45.25)
19969	2370	(9.2272413359521668,45.25)
19970	2370	(9.2272413359521668,45.25)
19971	2377	(15.289419162443238,45.25)
19972	1660	(17.887495373796554,31.75)
19973	1660	(17.887495373796554,31.75)
19974	1670	(26.54774941164094,31.75)
19975	1626	(22.650635094610966,31)
19976	335	(13.124355652982141,7)
19977	334	(12.258330249197702,7)
19978	334	(12.258330249197702,7)
19979	251	(9.6602540378443873,5.5)
19980	130	(9.2272413359521668,3.25)
19981	251	(9.6602540378443873,5.5)
19982	251	(9.6602540378443873,5.5)
19983	941	(18.753520777580992,18.25)
19984	941	(18.753520777580992,18.25)
19985	940	(17.887495373796554,18.25)
19986	940	(17.887495373796554,18.25)
19987	2250	(8.794228634059948,43)
19988	1600	(35.208003449485325,30.25)
19989	1598	(33.47595264191645,30.25)
19990	363	(3.1650635094610968,7.75)
19991	2025	(21.784609690826528,38.5)
19992	2026	(22.650635094610966,38.5)
19993	1031	(27.413774815425377,19.75)
19994	1029	(25.681724007856502,19.75)
19995	990	(26.114736709748719,19)
19996	948	(24.815698604072061,18.25)
19997	1352	(28.279800219209818,25.75)
19998	1390	(26.114736709748719,26.5)
19999	1312	(27.846787517317598,25)
20000	1470	(26.114736709748719,28)
20001	1508	(24.815698604072061,28.75)
20002	1465	(21.784609690826528,28)
20003	1544	(20.918584287042091,29.5)
20004	1877	(32.176914536239792,35.5)
20005	1877	(32.176914536239792,35.5)
20006	1920	(35.208003449485325,36.25)
20007	2353	(28.712812921102035,44.5)
20008	2367	(6.6291651245988508,45.25)
20009	2299	(17.021469970012117,43.75)
20010	1911	(27.413774815425377,36.25)
20011	2156	(31.743901834347572,40.75)
20012	2154	(30.011851026778693,40.75)
20013	2233	(29.145825622994256,42.25)
20014	2186	(22.650635094610966,41.5)
20015	250	(8.794228634059948,5.5)
20016	485	(4.4641016151377544,10)
20017	1414	(12.691342951089922,27.25)
20018	861	(18.753520777580992,16.75)
20019	736	(13.99038105676658,14.5)
20020	819	(16.588457268119896,16)
20021	2279	(33.908965343808667,43)
20022	1889	(8.3612159321677293,36.25)
20023	1929	(7.9282032302755088,37)
20024	1889	(8.3612159321677293,36.25)
20025	2279	(33.908965343808667,43)
20026	531	(10.093266739736606,10.75)
20027	1171	(10.093266739736606,22.75)
20028	1454	(12.258330249197702,28)
20029	613	(11.825317547305483,12.25)
20030	1448	(7.0621778264910704,28)
20031	1365	(4.4641016151377544,26.5)
20032	1365	(4.4641016151377544,26.5)
20033	1365	(4.4641016151377544,26.5)
20034	441	(1.4330127018922194,9.25)
20035	1213	(11.392304845413264,23.5)
20036	682	(2.299038105676658,13.75)
20037	2279	(33.908965343808667,43)
20038	1283	(2.7320508075688772,25)
20039	1283	(2.7320508075688772,25)
20040	1241	(1.4330127018922194,24.25)
20041	1241	(1.4330127018922194,24.25)
20042	1121	(1,22)
20043	1121	(1,22)
20044	1591	(27.413774815425377,30.25)
20045	941	(18.753520777580992,18.25)
20046	855	(13.55736835487436,16.75)
20047	734	(12.258330249197702,14.5)
20048	734	(12.258330249197702,14.5)
20049	1988	(24.815698604072061,37.75)
20050	1988	(24.815698604072061,37.75)
20051	1985	(22.217622392718749,37.75)
20052	1945	(21.784609690826528,37)
20053	1561	(1.4330127018922194,30.25)
20054	1988	(24.815698604072061,37.75)
20055	1521	(1,29.5)
20056	934	(12.691342951089922,18.25)
20057	936	(14.423393758658799,18.25)
20058	1055	(13.124355652982141,20.5)
20059	1135	(13.124355652982141,22)
20060	1154	(29.578838324886476,22)
20061	1534	(12.258330249197702,29.5)
20062	1154	(29.578838324886476,22)
20063	792	(28.279800219209818,15.25)
20064	1152	(27.846787517317598,22)
20065	1152	(27.846787517317598,22)
20066	1112	(28.279800219209818,21.25)
20067	1152	(27.846787517317598,22)
20068	1219	(16.588457268119896,23.5)
20069	1219	(16.588457268119896,23.5)
20070	1220	(17.454482671904334,23.5)
20071	1220	(17.454482671904334,23.5)
20072	1561	(1.4330127018922194,30.25)
20073	1620	(17.454482671904334,31)
20074	1585	(22.217622392718749,30.25)
20075	1623	(20.05255888325765,31)
20076	1470	(26.114736709748719,28)
20077	2117	(32.176914536239792,40)
20078	2117	(32.176914536239792,40)
20079	2156	(31.743901834347572,40.75)
20080	2154	(30.011851026778693,40.75)
20081	2159	(34.341978045700891,40.75)
20082	2159	(34.341978045700891,40.75)
20083	2159	(34.341978045700891,40.75)
20084	2156	(31.743901834347572,40.75)
20085	2156	(31.743901834347572,40.75)
20086	1352	(28.279800219209818,25.75)
20087	1390	(26.114736709748719,26.5)
20088	1470	(26.114736709748719,28)
20089	1470	(26.114736709748719,28)
20090	1509	(25.681724007856502,28.75)
20091	1312	(27.846787517317598,25)
20092	1312	(27.846787517317598,25)
20093	1306	(22.650635094610966,25)
20094	1306	(22.650635094610966,25)
20095	1306	(22.650635094610966,25)
20096	586	(22.650635094610966,11.5)
20097	626	(23.083647796503186,12.25)
20098	664	(20.918584287042091,13)
20099	662	(19.186533479473212,13)
20100	701	(18.753520777580992,13.75)
20101	537	(15.289419162443238,10.75)
20102	577	(14.856406460551018,11.5)
20103	618	(16.155444566227676,12.25)
20104	617	(15.289419162443238,12.25)
20105	617	(15.289419162443238,12.25)
20106	834	(29.578838324886476,16)
20107	835	(30.444863728670914,16)
20108	874	(30.011851026778693,16.75)
20109	1509	(25.681724007856502,28.75)
20110	874	(30.011851026778693,16.75)
20111	874	(30.011851026778693,16.75)
20112	231	(27.413774815425377,4.75)
20113	33	(28.712812921102035,1)
20114	33	(28.712812921102035,1)
20115	73	(29.145825622994256,1.75)
20116	73	(29.145825622994256,1.75)
20117	33	(28.712812921102035,1)
20118	33	(28.712812921102035,1)
20119	231	(27.413774815425377,4.75)
20120	33	(28.712812921102035,1)
20121	72	(28.279800219209818,1.75)
20122	33	(28.712812921102035,1)
20123	72	(28.279800219209818,1.75)
20124	33	(28.712812921102035,1)
20125	1197	(32.609927238132009,22.75)
20126	1197	(32.609927238132009,22.75)
20127	1318	(33.042939940024233,25)
20128	1476	(31.310889132455351,28)
20129	1753	(29.145825622994256,33.25)
20130	1715	(30.444863728670914,32.5)
20131	1715	(30.444863728670914,32.5)
20132	1680	(35.208003449485325,31.75)
20133	2301	(18.753520777580992,43.75)
20134	2388	(24.815698604072061,45.25)
20135	2261	(18.320508075688775,43)
20136	2387	(23.949673200287624,45.25)
20137	2300	(17.887495373796554,43.75)
20138	2386	(23.083647796503186,45.25)
20139	2299	(17.021469970012117,43.75)
20140	2381	(18.753520777580992,45.25)
20141	2262	(19.186533479473212,43)
20142	1779	(16.588457268119896,34)
20143	1977	(15.289419162443238,37.75)
20144	1776	(13.99038105676658,34)
20145	1900	(17.887495373796554,36.25)
20146	1930	(8.794228634059948,37)
20147	737	(14.856406460551018,14.5)
20148	2139	(17.021469970012117,40.75)
20149	2101	(18.320508075688775,40)
20150	1928	(7.0621778264910704,37)
20151	792	(28.279800219209818,15.25)
20152	792	(28.279800219209818,15.25)
20153	791	(27.413774815425377,15.25)
20154	1969	(8.3612159321677293,37.75)
20155	1961	(1.4330127018922194,37.75)
20156	2113	(28.712812921102035,40)
20157	2212	(10.959292143521045,42.25)
20158	2121	(1.4330127018922194,40.75)
20159	100	(17.454482671904334,2.5)
20160	60	(17.887495373796554,1.75)
20161	60	(17.887495373796554,1.75)
20162	178	(15.722431864335457,4)
20163	138	(16.155444566227676,3.25)
20164	178	(15.722431864335457,4)
20165	336	(13.99038105676658,7)
20166	336	(13.99038105676658,7)
20167	701	(18.753520777580992,13.75)
20168	818	(15.722431864335457,16)
20169	818	(15.722431864335457,16)
20170	7	(6.196152422706632,1)
20171	46	(5.7631397208144124,1.75)
20172	46	(5.7631397208144124,1.75)
20173	45	(4.897114317029974,1.75)
20174	201	(1.4330127018922194,4.75)
20175	244	(3.598076211353316,5.5)
20176	322	(1.8660254037844386,7)
20177	322	(1.8660254037844386,7)
20178	361	(1.4330127018922194,7.75)
20179	361	(1.4330127018922194,7.75)
20180	361	(1.4330127018922194,7.75)
20181	1328	(7.49519052838329,25.75)
20182	1340	(17.887495373796554,25.75)
20183	1417	(15.289419162443238,27.25)
20184	1337	(15.289419162443238,25.75)
20185	1376	(13.99038105676658,26.5)
20186	158	(33.47595264191645,3.25)
20187	158	(33.47595264191645,3.25)
20188	158	(33.47595264191645,3.25)
20189	1036	(31.743901834347572,19.75)
20190	438	(33.042939940024233,8.5)
20191	438	(33.042939940024233,8.5)
20192	398	(33.47595264191645,7.75)
20193	439	(33.908965343808667,8.5)
20194	73	(29.145825622994256,1.75)
20195	1106	(23.083647796503186,21.25)
20196	1106	(23.083647796503186,21.25)
20197	1106	(23.083647796503186,21.25)
20198	905	(21.784609690826528,17.5)
20199	905	(21.784609690826528,17.5)
20200	905	(21.784609690826528,17.5)
20201	1106	(23.083647796503186,21.25)
20202	2200	(34.774990747593108,41.5)
20203	2396	(31.743901834347572,45.25)
20204	1948	(24.382685902179844,37)
20205	1724	(4.0310889132455356,33.25)
20206	1724	(4.0310889132455356,33.25)
20207	1725	(4.897114317029974,33.25)
20208	2400	(35.208003449485325,45.25)
20209	2200	(34.774990747593108,41.5)
20210	2399	(34.341978045700891,45.25)
20211	1949	(25.248711305964282,37)
20212	1240	(34.774990747593108,23.5)
20213	1240	(34.774990747593108,23.5)
20214	1596	(31.743901834347572,30.25)
20215	1597	(32.609927238132009,30.25)
20216	1600	(35.208003449485325,30.25)
20217	2317	(32.609927238132009,43.75)
20218	1160	(34.774990747593108,22)
20219	1160	(34.774990747593108,22)
20220	1160	(34.774990747593108,22)
20221	2317	(32.609927238132009,43.75)
20222	2269	(25.248711305964282,43)
20223	2358	(33.042939940024233,44.5)
20224	1356	(31.743901834347572,25.75)
20225	2352	(27.846787517317598,44.5)
20226	1704	(20.918584287042091,32.5)
20227	1704	(20.918584287042091,32.5)
20228	1704	(20.918584287042091,32.5)
20229	1359	(34.341978045700891,25.75)
20230	1439	(34.341978045700891,27.25)
20231	1519	(34.341978045700891,28.75)
20232	954	(30.011851026778693,18.25)
20233	993	(28.712812921102035,19)
20234	1031	(27.413774815425377,19.75)
20235	990	(26.114736709748719,19)
20236	1029	(25.681724007856502,19.75)
20237	989	(25.248711305964282,19)
20238	948	(24.815698604072061,18.25)
20239	908	(24.382685902179844,17.5)
20240	947	(23.949673200287624,18.25)
20241	947	(23.949673200287624,18.25)
20242	2279	(33.908965343808667,43)
20243	2122	(2.299038105676658,40.75)
20244	2156	(31.743901834347572,40.75)
20245	2154	(30.011851026778693,40.75)
20246	2233	(29.145825622994256,42.25)
20247	77	(32.609927238132009,1.75)
20248	32	(27.846787517317598,1)
20249	31	(26.98076211353316,1)
20250	77	(32.609927238132009,1.75)
20251	31	(26.98076211353316,1)
20252	77	(32.609927238132009,1.75)
20253	31	(26.98076211353316,1)
20254	31	(26.98076211353316,1)
20255	77	(32.609927238132009,1.75)
20256	1716	(31.310889132455351,32.5)
20257	1758	(33.47595264191645,33.25)
20258	1680	(35.208003449485325,31.75)
20259	2320	(35.208003449485325,43.75)
20260	2279	(33.908965343808667,43)
20261	2359	(33.908965343808667,44.5)
20262	2196	(31.310889132455351,41.5)
20263	2279	(33.908965343808667,43)
20264	441	(1.4330127018922194,9.25)
20265	441	(1.4330127018922194,9.25)
20266	605	(4.897114317029974,12.25)
20267	849	(8.3612159321677293,16.75)
20268	1362	(1.8660254037844386,26.5)
20269	1362	(1.8660254037844386,26.5)
20270	1323	(3.1650635094610968,25.75)
20271	1321	(1.4330127018922194,25.75)
20272	1281	(1,25)
20273	841	(1.4330127018922194,16.75)
20274	921	(1.4330127018922194,18.25)
20275	613	(11.825317547305483,12.25)
20276	612	(10.959292143521045,12.25)
20277	412	(10.526279441628825,8.5)
20278	1365	(4.4641016151377544,26.5)
20279	1365	(4.4641016151377544,26.5)
20280	1706	(22.650635094610966,32.5)
20281	1706	(22.650635094610966,32.5)
20282	1666	(23.083647796503186,31.75)
20283	1592	(28.279800219209818,30.25)
20284	1591	(27.413774815425377,30.25)
20285	1591	(27.413774815425377,30.25)
20286	1954	(29.578838324886476,37)
20287	2029	(25.248711305964282,38.5)
20288	1988	(24.815698604072061,37.75)
20289	1985	(22.217622392718749,37.75)
20290	766	(5.7631397208144124,15.25)
20291	2033	(28.712812921102035,38.5)
20292	2028	(24.382685902179844,38.5)
20293	1603	(2.7320508075688772,31)
20294	2029	(25.248711305964282,38.5)
20295	1917	(32.609927238132009,36.25)
20296	1953	(28.712812921102035,37)
20297	1877	(32.176914536239792,35.5)
20298	1879	(33.908965343808667,35.5)
20299	1949	(25.248711305964282,37)
20300	2194	(29.578838324886476,41.5)
20301	2040	(34.774990747593108,38.5)
20302	2156	(31.743901834347572,40.75)
20303	2320	(35.208003449485325,43.75)
20304	890	(8.794228634059948,17.5)
20305	1298	(15.722431864335457,25)
20306	1417	(15.289419162443238,27.25)
20307	1256	(14.423393758658799,24.25)
20308	1306	(22.650635094610966,25)
20309	1306	(22.650635094610966,25)
20310	734	(12.258330249197702,14.5)
20311	734	(12.258330249197702,14.5)
20312	938	(16.155444566227676,18.25)
20313	1057	(14.856406460551018,20.5)
20314	1055	(13.124355652982141,20.5)
20315	418	(15.722431864335457,8.5)
20316	665	(21.784609690826528,13)
20317	662	(19.186533479473212,13)
20318	661	(18.320508075688775,13)
20319	537	(15.289419162443238,10.75)
20320	577	(14.856406460551018,11.5)
20321	617	(15.289419162443238,12.25)
20322	1068	(24.382685902179844,20.5)
20323	1108	(24.815698604072061,21.25)
20324	1067	(23.516660498395403,20.5)
20325	1145	(21.784609690826528,22)
20326	905	(21.784609690826528,17.5)
20327	1098	(16.155444566227676,21.25)
20328	1098	(16.155444566227676,21.25)
20329	175	(13.124355652982141,4)
20330	95	(13.124355652982141,2.5)
20331	95	(13.124355652982141,2.5)
20332	21	(18.320508075688775,1)
20333	135	(13.55736835487436,3.25)
20334	94	(12.258330249197702,2.5)
20335	175	(13.124355652982141,4)
20336	13	(11.392304845413264,1)
20337	13	(11.392304845413264,1)
20338	336	(13.99038105676658,7)
20339	1152	(27.846787517317598,22)
20340	871	(27.413774815425377,16.75)
20341	1113	(29.145825622994256,21.25)
20342	1222	(19.186533479473212,23.5)
20343	2377	(15.289419162443238,45.25)
20344	2373	(11.825317547305483,45.25)
20345	1616	(13.99038105676658,31)
20346	2371	(10.093266739736606,45.25)
20347	1537	(14.856406460551018,29.5)
20348	1620	(17.454482671904334,31)
20349	1834	(30.011851026778693,34.75)
20350	1907	(23.949673200287624,36.25)
20351	1724	(4.0310889132455356,33.25)
20352	1240	(34.774990747593108,23.5)
20353	1360	(35.208003449485325,25.75)
20354	1480	(34.774990747593108,28)
20355	1600	(35.208003449485325,30.25)
20356	2396	(31.743901834347572,45.25)
20357	2280	(34.774990747593108,43)
20358	2280	(34.774990747593108,43)
20359	792	(28.279800219209818,15.25)
20360	792	(28.279800219209818,15.25)
20361	2367	(6.6291651245988508,45.25)
20362	2367	(6.6291651245988508,45.25)
20363	2299	(17.021469970012117,43.75)
20364	2365	(4.897114317029974,45.25)
20365	2321	(1,44.5)
20366	2321	(1,44.5)
20367	2388	(24.815698604072061,45.25)
20368	2388	(24.815698604072061,45.25)
20369	2386	(23.083647796503186,45.25)
20370	2347	(23.516660498395403,44.5)
20371	2388	(24.815698604072061,45.25)
20372	2345	(21.784609690826528,44.5)
20373	2385	(22.217622392718749,45.25)
20374	2346	(22.650635094610966,44.5)
20375	2346	(22.650635094610966,44.5)
20376	167	(6.196152422706632,4)
20377	167	(6.196152422706632,4)
20378	166	(5.3301270189221936,4)
20379	166	(5.3301270189221936,4)
20380	165	(4.4641016151377544,4)
20381	168	(7.0621778264910704,4)
20382	129	(8.3612159321677293,3.25)
20383	125	(4.897114317029974,3.25)
20384	82	(1.8660254037844386,2.5)
20385	124	(4.0310889132455356,3.25)
20386	121	(1.4330127018922194,3.25)
20387	1277	(32.609927238132009,24.25)
20388	1476	(31.310889132455351,28)
20389	1753	(29.145825622994256,33.25)
20390	1715	(30.444863728670914,32.5)
20391	1717	(32.176914536239792,32.5)
20392	1759	(34.341978045700891,33.25)
20393	1680	(35.208003449485325,31.75)
20394	1476	(31.310889132455351,28)
20395	386	(23.083647796503186,7.75)
20396	476	(31.743901834347572,9.25)
20397	186	(22.650635094610966,4)
20398	396	(31.743901834347572,7.75)
20399	226	(23.083647796503186,4.75)
20400	398	(33.47595264191645,7.75)
20401	439	(33.908965343808667,8.5)
20402	398	(33.47595264191645,7.75)
20403	436	(31.310889132455351,8.5)
20404	478	(33.47595264191645,9.25)
20405	438	(33.042939940024233,8.5)
20406	398	(33.47595264191645,7.75)
20407	194	(29.578838324886476,4)
20408	34	(29.578838324886476,1)
20409	33	(28.712812921102035,1)
20410	31	(26.98076211353316,1)
20411	113	(28.712812921102035,2.5)
20412	31	(26.98076211353316,1)
20413	31	(26.98076211353316,1)
20414	160	(35.208003449485325,3.25)
20415	158	(33.47595264191645,3.25)
20416	158	(33.47595264191645,3.25)
20417	160	(35.208003449485325,3.25)
20418	461	(18.753520777580992,9.25)
20419	501	(18.320508075688775,10)
20420	423	(20.05255888325765,8.5)
20421	505	(21.784609690826528,10)
20422	386	(23.083647796503186,7.75)
20423	386	(23.083647796503186,7.75)
20424	1312	(27.846787517317598,25)
20425	1510	(26.54774941164094,28.75)
20426	1510	(26.54774941164094,28.75)
20427	1388	(24.382685902179844,26.5)
20428	1387	(23.516660498395403,26.5)
20429	1427	(23.949673200287624,27.25)
20430	1427	(23.949673200287624,27.25)
20431	1460	(17.454482671904334,28)
20432	1460	(17.454482671904334,28)
20433	1541	(18.320508075688775,29.5)
20434	1197	(32.609927238132009,22.75)
20435	1197	(32.609927238132009,22.75)
20436	1318	(33.042939940024233,25)
20437	1359	(34.341978045700891,25.75)
20438	1439	(34.341978045700891,27.25)
20439	1519	(34.341978045700891,28.75)
20440	2400	(35.208003449485325,45.25)
20441	2200	(34.774990747593108,41.5)
20442	2399	(34.341978045700891,45.25)
20443	1160	(34.774990747593108,22)
20444	1160	(34.774990747593108,22)
20445	1360	(35.208003449485325,25.75)
20446	2317	(32.609927238132009,43.75)
20447	2269	(25.248711305964282,43)
20448	2358	(33.042939940024233,44.5)
20449	1356	(31.743901834347572,25.75)
20450	2187	(23.516660498395403,41.5)
20451	2186	(22.650635094610966,41.5)
20452	819	(16.588457268119896,16)
20453	1298	(15.722431864335457,25)
20454	1417	(15.289419162443238,27.25)
20455	877	(32.609927238132009,16.75)
20456	1353	(29.145825622994256,25.75)
20457	1389	(25.248711305964282,26.5)
20458	1197	(32.609927238132009,22.75)
20459	2157	(32.609927238132009,40.75)
20460	2159	(34.341978045700891,40.75)
20461	2159	(34.341978045700891,40.75)
20462	954	(30.011851026778693,18.25)
20463	992	(27.846787517317598,19)
20464	990	(26.114736709748719,19)
20465	1029	(25.681724007856502,19.75)
20466	989	(25.248711305964282,19)
20467	948	(24.815698604072061,18.25)
20468	986	(22.650635094610966,19)
20469	794	(30.011851026778693,15.25)
20470	792	(28.279800219209818,15.25)
20471	875	(30.877876430563134,16.75)
20472	831	(26.98076211353316,16)
20473	2380	(17.887495373796554,45.25)
20474	2380	(17.887495373796554,45.25)
20475	2396	(31.743901834347572,45.25)
20476	398	(33.47595264191645,7.75)
20477	439	(33.908965343808667,8.5)
20478	360	(34.774990747593108,7)
20479	145	(22.217622392718749,3.25)
20480	145	(22.217622392718749,3.25)
20481	105	(21.784609690826528,2.5)
20482	1187	(23.949673200287624,22.75)
20483	1147	(23.516660498395403,22)
20484	1067	(23.516660498395403,20.5)
20485	744	(20.918584287042091,14.5)
20486	744	(20.918584287042091,14.5)
20487	744	(20.918584287042091,14.5)
20488	175	(13.124355652982141,4)
20489	129	(8.3612159321677293,3.25)
20490	129	(8.3612159321677293,3.25)
20491	168	(7.0621778264910704,4)
20492	223	(20.48557158514987,4.75)
20493	223	(20.48557158514987,4.75)
20494	223	(20.48557158514987,4.75)
20495	300	(17.887495373796554,6.25)
20496	339	(16.588457268119896,7)
20497	339	(16.588457268119896,7)
20498	1	(1,1)
20499	1	(1,1)
20500	1	(1,1)
20501	1960	(34.774990747593108,37)
20502	2196	(31.310889132455351,41.5)
20503	2359	(33.908965343808667,44.5)
20504	2279	(33.908965343808667,43)
20505	2279	(33.908965343808667,43)
20506	453	(11.825317547305483,9.25)
20507	490	(8.794228634059948,10)
20508	1171	(10.093266739736606,22.75)
20509	1171	(10.093266739736606,22.75)
20510	1364	(3.598076211353316,26.5)
20511	482	(1.8660254037844386,10)
20512	1407	(6.6291651245988508,27.25)
20513	569	(7.9282032302755088,11.5)
20514	568	(7.0621778264910704,11.5)
20515	568	(7.0621778264910704,11.5)
20516	607	(6.6291651245988508,12.25)
20517	1171	(10.093266739736606,22.75)
20518	1171	(10.093266739736606,22.75)
20519	1364	(3.598076211353316,26.5)
20520	1242	(2.299038105676658,24.25)
20521	1241	(1.4330127018922194,24.25)
20522	1241	(1.4330127018922194,24.25)
20523	1321	(1.4330127018922194,25.75)
20524	1281	(1,25)
20525	1241	(1.4330127018922194,24.25)
20526	2035	(30.444863728670914,38.5)
20527	2035	(30.444863728670914,38.5)
20528	2111	(26.98076211353316,40)
20529	2071	(27.413774815425377,39.25)
20530	2071	(27.413774815425377,39.25)
20531	1448	(7.0621778264910704,28)
20532	1326	(5.7631397208144124,25.75)
20533	2156	(31.743901834347572,40.75)
20534	2035	(30.444863728670914,38.5)
20535	2067	(23.949673200287624,39.25)
20536	2025	(21.784609690826528,38.5)
20537	2067	(23.949673200287624,39.25)
20538	2026	(22.650635094610966,38.5)
20539	613	(11.825317547305483,12.25)
20540	613	(11.825317547305483,12.25)
20541	453	(11.825317547305483,9.25)
20542	413	(11.392304845413264,8.5)
20543	453	(11.825317547305483,9.25)
20544	1528	(7.0621778264910704,29.5)
20545	1790	(26.114736709748719,34)
20546	814	(12.258330249197702,16)
20547	734	(12.258330249197702,14.5)
20548	703	(20.48557158514987,13.75)
20549	664	(20.918584287042091,13)
20550	701	(18.753520777580992,13.75)
20551	577	(14.856406460551018,11.5)
20552	947	(23.949673200287624,18.25)
20553	946	(23.083647796503186,18.25)
20554	1068	(24.382685902179844,20.5)
20555	1026	(23.083647796503186,19.75)
20556	1145	(21.784609690826528,22)
20557	1104	(21.351596988934308,21.25)
20558	905	(21.784609690826528,17.5)
20559	905	(21.784609690826528,17.5)
20560	934	(12.691342951089922,18.25)
20561	938	(16.155444566227676,18.25)
20562	893	(11.392304845413264,17.5)
20563	936	(14.423393758658799,18.25)
20564	1592	(28.279800219209818,30.25)
20565	1591	(27.413774815425377,30.25)
20566	1833	(29.145825622994256,34.75)
20567	1831	(27.413774815425377,34.75)
20568	413	(11.392304845413264,8.5)
20569	2289	(8.3612159321677293,43.75)
20570	425	(21.784609690826528,8.5)
20571	505	(21.784609690826528,10)
20572	465	(22.217622392718749,9.25)
20573	461	(18.753520777580992,9.25)
20574	461	(18.753520777580992,9.25)
20575	1230	(26.114736709748719,23.5)
20576	1352	(28.279800219209818,25.75)
20577	1390	(26.114736709748719,26.5)
20578	1312	(27.846787517317598,25)
20579	1312	(27.846787517317598,25)
20580	1471	(26.98076211353316,28)
20581	1470	(26.114736709748719,28)
20582	1470	(26.114736709748719,28)
20583	1577	(15.289419162443238,30.25)
20584	1620	(17.454482671904334,31)
20585	1579	(17.021469970012117,30.25)
20586	2181	(18.320508075688775,41.5)
20587	2386	(23.083647796503186,45.25)
20588	2388	(24.815698604072061,45.25)
20589	2389	(25.681724007856502,45.25)
20590	2259	(16.588457268119896,43)
20591	2367	(6.6291651245988508,45.25)
20592	2301	(18.753520777580992,43.75)
20593	2347	(23.516660498395403,44.5)
20594	2262	(19.186533479473212,43)
20595	2264	(20.918584287042091,43)
20596	2264	(20.918584287042091,43)
20597	2380	(17.887495373796554,45.25)
20598	2380	(17.887495373796554,45.25)
20599	2382	(19.619546181365433,45.25)
20600	2243	(2.7320508075688772,43)
20601	2365	(4.897114317029974,45.25)
20602	1858	(15.722431864335457,35.5)
20603	1858	(15.722431864335457,35.5)
20604	1899	(17.021469970012117,36.25)
20605	1899	(17.021469970012117,36.25)
20606	1981	(18.753520777580992,37.75)
20607	1980	(17.887495373796554,37.75)
20608	1981	(18.753520777580992,37.75)
20609	1776	(13.99038105676658,34)
20610	2101	(18.320508075688775,40)
20611	2141	(18.753520777580992,40.75)
20612	1822	(19.619546181365433,34.75)
20613	1981	(18.753520777580992,37.75)
20614	1900	(17.887495373796554,36.25)
20615	2127	(6.6291651245988508,40.75)
20616	2127	(6.6291651245988508,40.75)
20617	2126	(5.7631397208144124,40.75)
20618	2134	(12.691342951089922,40.75)
20619	2126	(5.7631397208144124,40.75)
20620	2126	(5.7631397208144124,40.75)
20621	1980	(17.887495373796554,37.75)
20622	1968	(7.49519052838329,37.75)
20623	2213	(11.825317547305483,42.25)
20624	1814	(12.691342951089922,34.75)
20625	1942	(19.186533479473212,37)
20626	1901	(18.753520777580992,36.25)
20627	2091	(9.6602540378443873,40)
20628	2086	(5.3301270189221936,40)
20629	748	(24.382685902179844,14.5)
20630	788	(24.815698604072061,15.25)
20631	787	(23.949673200287624,15.25)
20632	827	(23.516660498395403,16)
20633	1032	(28.279800219209818,19.75)
20634	1187	(23.949673200287624,22.75)
20635	1145	(21.784609690826528,22)
20636	95	(13.124355652982141,2.5)
20637	94	(12.258330249197702,2.5)
20638	99	(16.588457268119896,2.5)
20639	99	(16.588457268119896,2.5)
20640	99	(16.588457268119896,2.5)
20641	18	(15.722431864335457,1)
20642	218	(16.155444566227676,4.75)
20643	218	(16.155444566227676,4.75)
20644	178	(15.722431864335457,4)
20645	219	(17.021469970012117,4.75)
20646	336	(13.99038105676658,7)
20647	335	(13.124355652982141,7)
20648	255	(13.124355652982141,5.5)
20649	167	(6.196152422706632,4)
20650	167	(6.196152422706632,4)
20651	126	(5.7631397208144124,3.25)
20652	85	(4.4641016151377544,2.5)
20653	44	(4.0310889132455356,1.75)
20654	204	(4.0310889132455356,4.75)
20655	243	(2.7320508075688772,5.5)
20656	201	(1.4330127018922194,4.75)
20657	201	(1.4330127018922194,4.75)
20658	1934	(12.258330249197702,37)
20659	1934	(12.258330249197702,37)
20660	1821	(18.753520777580992,34.75)
20661	2098	(15.722431864335457,40)
20662	2097	(14.856406460551018,40)
20663	1934	(12.258330249197702,37)
20664	2320	(35.208003449485325,43.75)
20665	851	(10.093266739736606,16.75)
20666	2103	(20.05255888325765,40)
20667	2104	(20.918584287042091,40)
20668	1342	(19.619546181365433,25.75)
20669	1343	(20.48557158514987,25.75)
20670	1340	(17.887495373796554,25.75)
20671	1379	(16.588457268119896,26.5)
20672	1306	(22.650635094610966,25)
20673	1834	(30.011851026778693,34.75)
20674	1834	(30.011851026778693,34.75)
20675	1614	(12.258330249197702,31)
20676	1637	(32.176914536239792,31)
20677	1637	(32.176914536239792,31)
20678	1598	(33.47595264191645,30.25)
20679	2400	(35.208003449485325,45.25)
20680	2200	(34.774990747593108,41.5)
20681	1869	(25.248711305964282,35.5)
20682	1869	(25.248711305964282,35.5)
20683	2399	(34.341978045700891,45.25)
20684	2150	(26.54774941164094,40.75)
20685	2150	(26.54774941164094,40.75)
20686	289	(8.3612159321677293,6.25)
20687	2148	(24.815698604072061,40.75)
20688	2184	(20.918584287042091,41.5)
20689	2189	(25.248711305964282,41.5)
20690	1160	(34.774990747593108,22)
20691	1160	(34.774990747593108,22)
20692	1160	(34.774990747593108,22)
20693	1360	(35.208003449485325,25.75)
20694	2317	(32.609927238132009,43.75)
20695	2269	(25.248711305964282,43)
20696	2358	(33.042939940024233,44.5)
20697	1356	(31.743901834347572,25.75)
20698	2187	(23.516660498395403,41.5)
20699	934	(12.691342951089922,18.25)
20700	893	(11.392304845413264,17.5)
20701	1505	(22.217622392718749,28.75)
20702	1545	(21.784609690826528,29.5)
20703	1545	(21.784609690826528,29.5)
20704	1541	(18.320508075688775,29.5)
20705	1544	(20.918584287042091,29.5)
20706	1545	(21.784609690826528,29.5)
20707	1623	(20.05255888325765,31)
20708	1945	(21.784609690826528,37)
20709	2392	(28.279800219209818,45.25)
20710	2394	(30.011851026778693,45.25)
20711	2394	(30.011851026778693,45.25)
20712	2392	(28.279800219209818,45.25)
20713	2392	(28.279800219209818,45.25)
20714	2352	(27.846787517317598,44.5)
20715	2280	(34.774990747593108,43)
20716	2279	(33.908965343808667,43)
20717	2280	(34.774990747593108,43)
20718	1877	(32.176914536239792,35.5)
20719	1652	(10.959292143521045,31.75)
20720	1614	(12.258330249197702,31)
20721	1877	(32.176914536239792,35.5)
20722	1916	(31.743901834347572,36.25)
20723	412	(10.526279441628825,8.5)
20724	412	(10.526279441628825,8.5)
20725	2040	(34.774990747593108,38.5)
20726	2040	(34.774990747593108,38.5)
20727	2157	(32.609927238132009,40.75)
20728	2040	(34.774990747593108,38.5)
20729	2038	(33.042939940024233,38.5)
20730	871	(27.413774815425377,16.75)
20731	1152	(27.846787517317598,22)
20732	1220	(17.454482671904334,23.5)
20733	1222	(19.186533479473212,23.5)
20734	956	(31.743901834347572,18.25)
20735	1036	(31.743901834347572,19.75)
20736	632	(28.279800219209818,12.25)
20737	475	(30.877876430563134,9.25)
20738	475	(30.877876430563134,9.25)
20739	435	(30.444863728670914,8.5)
20740	438	(33.042939940024233,8.5)
20741	440	(34.774990747593108,8.5)
20742	34	(29.578838324886476,1)
20743	473	(29.145825622994256,9.25)
20744	271	(26.98076211353316,5.5)
20745	64	(21.351596988934308,1.75)
20746	399	(34.341978045700891,7.75)
20747	360	(34.774990747593108,7)
20748	26	(22.650635094610966,1)
20749	200	(34.774990747593108,4)
20750	160	(35.208003449485325,3.25)
20751	200	(34.774990747593108,4)
20752	200	(34.774990747593108,4)
20753	199	(33.908965343808667,4)
20754	80	(35.208003449485325,1.75)
20755	1277	(32.609927238132009,24.25)
20756	1277	(32.609927238132009,24.25)
20757	1277	(32.609927238132009,24.25)
20758	1476	(31.310889132455351,28)
20759	1753	(29.145825622994256,33.25)
20760	1715	(30.444863728670914,32.5)
20761	1717	(32.176914536239792,32.5)
20762	1759	(34.341978045700891,33.25)
20763	1760	(35.208003449485325,33.25)
20764	1680	(35.208003449485325,31.75)
20765	436	(31.310889132455351,8.5)
20766	478	(33.47595264191645,9.25)
20767	440	(34.774990747593108,8.5)
20768	317	(32.609927238132009,6.25)
20769	435	(30.444863728670914,8.5)
20770	358	(33.042939940024233,7)
20771	317	(32.609927238132009,6.25)
20772	1197	(32.609927238132009,22.75)
20773	1197	(32.609927238132009,22.75)
20774	1197	(32.609927238132009,22.75)
20775	1197	(32.609927238132009,22.75)
20776	1398	(33.042939940024233,26.5)
20777	720	(35.208003449485325,13.75)
20778	720	(35.208003449485325,13.75)
20779	720	(35.208003449485325,13.75)
20780	1240	(34.774990747593108,23.5)
20781	1240	(34.774990747593108,23.5)
20782	1240	(34.774990747593108,23.5)
20783	1360	(35.208003449485325,25.75)
20784	1600	(35.208003449485325,30.25)
20785	628	(24.815698604072061,12.25)
20786	435	(30.444863728670914,8.5)
20787	151	(27.413774815425377,3.25)
20788	271	(26.98076211353316,5.5)
20789	271	(26.98076211353316,5.5)
20790	1036	(31.743901834347572,19.75)
20791	631	(27.413774815425377,12.25)
20792	673	(28.712812921102035,13)
20793	632	(28.279800219209818,12.25)
20794	511	(26.98076211353316,10)
20795	391	(27.413774815425377,7.75)
20796	391	(27.413774815425377,7.75)
20797	391	(27.413774815425377,7.75)
20798	391	(27.413774815425377,7.75)
20799	391	(27.413774815425377,7.75)
20800	596	(31.310889132455351,11.5)
20801	230	(26.54774941164094,4.75)
20802	230	(26.54774941164094,4.75)
20803	473	(29.145825622994256,9.25)
20804	271	(26.98076211353316,5.5)
20805	1666	(23.083647796503186,31.75)
20806	1611	(9.6602540378443873,31)
20807	1604	(3.598076211353316,31)
20808	1603	(2.7320508075688772,31)
20809	2111	(26.98076211353316,40)
20810	1494	(12.691342951089922,28.75)
20811	1448	(7.0621778264910704,28)
20812	1407	(6.6291651245988508,27.25)
20813	1365	(4.4641016151377544,26.5)
20814	1365	(4.4641016151377544,26.5)
20815	1365	(4.4641016151377544,26.5)
20816	1445	(4.4641016151377544,28)
20817	997	(32.176914536239792,19)
20818	596	(31.310889132455351,11.5)
20819	596	(31.310889132455351,11.5)
20820	596	(31.310889132455351,11.5)
20821	596	(31.310889132455351,11.5)
20822	1119	(34.341978045700891,21.25)
20823	1119	(34.341978045700891,21.25)
20824	1119	(34.341978045700891,21.25)
20825	130	(9.2272413359521668,3.25)
20826	2279	(33.908965343808667,43)
20827	251	(9.6602540378443873,5.5)
20828	1355	(30.877876430563134,25.75)
20829	1960	(34.774990747593108,37)
20830	2196	(31.310889132455351,41.5)
20831	2359	(33.908965343808667,44.5)
20832	2279	(33.908965343808667,43)
20833	2115	(30.444863728670914,40)
20834	2156	(31.743901834347572,40.75)
20835	2035	(30.444863728670914,38.5)
20836	2154	(30.011851026778693,40.75)
20837	2233	(29.145825622994256,42.25)
20838	2068	(24.815698604072061,39.25)
20839	586	(22.650635094610966,11.5)
20840	586	(22.650635094610966,11.5)
20841	626	(23.083647796503186,12.25)
20842	2331	(9.6602540378443873,44.5)
20843	2376	(14.423393758658799,45.25)
20844	2370	(9.2272413359521668,45.25)
20845	2370	(9.2272413359521668,45.25)
20846	835	(30.444863728670914,16)
20847	875	(30.877876430563134,16.75)
20848	835	(30.444863728670914,16)
20849	993	(28.712812921102035,19)
20850	993	(28.712812921102035,19)
20851	993	(28.712812921102035,19)
20852	1031	(27.413774815425377,19.75)
20853	1029	(25.681724007856502,19.75)
20854	990	(26.114736709748719,19)
20855	993	(28.712812921102035,19)
20856	993	(28.712812921102035,19)
20857	993	(28.712812921102035,19)
20858	1691	(9.6602540378443873,32.5)
20859	1365	(4.4641016151377544,26.5)
20860	1365	(4.4641016151377544,26.5)
20861	1366	(5.3301270189221936,26.5)
20862	2040	(34.774990747593108,38.5)
20863	2156	(31.743901834347572,40.75)
20864	2194	(29.578838324886476,41.5)
20865	1321	(1.4330127018922194,25.75)
20866	1321	(1.4330127018922194,25.75)
20867	1321	(1.4330127018922194,25.75)
20868	1241	(1.4330127018922194,24.25)
20869	1241	(1.4330127018922194,24.25)
20870	1041	(1,20.5)
20871	2244	(3.598076211353316,43)
20872	2321	(1,44.5)
20873	1776	(13.99038105676658,34)
20874	2126	(5.7631397208144124,40.75)
20875	1776	(13.99038105676658,34)
20876	1969	(8.3612159321677293,37.75)
20877	2279	(33.908965343808667,43)
20878	490	(8.794228634059948,10)
20879	448	(7.49519052838329,9.25)
20880	607	(6.6291651245988508,12.25)
20881	485	(4.4641016151377544,10)
20882	441	(1.4330127018922194,9.25)
20883	441	(1.4330127018922194,9.25)
20884	441	(1.4330127018922194,9.25)
20885	1370	(8.794228634059948,26.5)
20886	601	(1.4330127018922194,12.25)
20887	1249	(8.3612159321677293,24.25)
20888	1249	(8.3612159321677293,24.25)
20889	1249	(8.3612159321677293,24.25)
20890	1249	(8.3612159321677293,24.25)
20891	1249	(8.3612159321677293,24.25)
20892	1249	(8.3612159321677293,24.25)
20893	1249	(8.3612159321677293,24.25)
20894	1287	(6.196152422706632,25)
20895	1287	(6.196152422706632,25)
20896	1287	(6.196152422706632,25)
20897	1287	(6.196152422706632,25)
20898	1203	(2.7320508075688772,23.5)
20899	1084	(4.0310889132455356,21.25)
20900	1085	(4.897114317029974,21.25)
20901	601	(1.4330127018922194,12.25)
20902	1451	(9.6602540378443873,28)
20903	1291	(9.6602540378443873,25)
20904	1592	(28.279800219209818,30.25)
20905	1333	(11.825317547305483,25.75)
20906	1333	(11.825317547305483,25.75)
20907	1592	(28.279800219209818,30.25)
20908	2156	(31.743901834347572,40.75)
20909	2033	(28.712812921102035,38.5)
20910	2033	(28.712812921102035,38.5)
20911	1650	(9.2272413359521668,31.75)
20912	1608	(7.0621778264910704,31)
20913	2035	(30.444863728670914,38.5)
20914	2111	(26.98076211353316,40)
20915	1529	(7.9282032302755088,29.5)
20916	1841	(1,35.5)
20917	1841	(1,35.5)
20918	1841	(1,35.5)
20919	586	(22.650635094610966,11.5)
20920	664	(20.918584287042091,13)
20921	663	(20.05255888325765,13)
20922	659	(16.588457268119896,13)
20923	945	(22.217622392718749,18.25)
20924	425	(21.784609690826528,8.5)
20925	461	(18.753520777580992,9.25)
20926	424	(20.918584287042091,8.5)
20927	461	(18.753520777580992,9.25)
20928	1233	(28.712812921102035,23.5)
20929	1187	(23.949673200287624,22.75)
20930	1225	(21.784609690826528,23.5)
20931	1187	(23.949673200287624,22.75)
20932	1068	(24.382685902179844,20.5)
20933	1064	(20.918584287042091,20.5)
20934	1100	(17.887495373796554,21.25)
20935	1023	(20.48557158514987,19.75)
20936	1098	(16.155444566227676,21.25)
20937	1216	(13.99038105676658,23.5)
20938	1670	(26.54774941164094,31.75)
20939	1748	(24.815698604072061,33.25)
20940	1747	(23.949673200287624,33.25)
20941	1708	(24.382685902179844,32.5)
20942	1708	(24.382685902179844,32.5)
20943	1390	(26.114736709748719,26.5)
20944	1427	(23.949673200287624,27.25)
20945	1427	(23.949673200287624,27.25)
20946	1427	(23.949673200287624,27.25)
20947	1460	(17.454482671904334,28)
20948	1460	(17.454482671904334,28)
20949	1460	(17.454482671904334,28)
20950	1537	(14.856406460551018,29.5)
20951	1577	(15.289419162443238,30.25)
20952	1577	(15.289419162443238,30.25)
20953	2388	(24.815698604072061,45.25)
20954	2388	(24.815698604072061,45.25)
20955	2388	(24.815698604072061,45.25)
20956	2346	(22.650635094610966,44.5)
20957	2222	(19.619546181365433,42.25)
20958	2299	(17.021469970012117,43.75)
20959	2345	(21.784609690826528,44.5)
20960	2342	(19.186533479473212,44.5)
20961	2382	(19.619546181365433,45.25)
20962	2381	(18.753520777580992,45.25)
20963	2362	(2.299038105676658,45.25)
20964	2361	(1.4330127018922194,45.25)
20965	1942	(19.186533479473212,37)
20966	1980	(17.887495373796554,37.75)
20967	1776	(13.99038105676658,34)
20968	1980	(17.887495373796554,37.75)
20969	1694	(12.258330249197702,32.5)
20970	1899	(17.021469970012117,36.25)
20971	1893	(11.825317547305483,36.25)
20972	1772	(10.526279441628825,34)
20973	1772	(10.526279441628825,34)
20974	1770	(8.794228634059948,34)
20975	1779	(16.588457268119896,34)
20976	1770	(8.794228634059948,34)
20977	1980	(17.887495373796554,37.75)
20978	1768	(7.0621778264910704,34)
20979	1769	(7.9282032302755088,34)
20980	1807	(6.6291651245988508,34.75)
20981	1814	(12.691342951089922,34.75)
20982	1854	(12.258330249197702,35.5)
20983	2207	(6.6291651245988508,42.25)
20984	1807	(6.6291651245988508,34.75)
20985	2213	(11.825317547305483,42.25)
20986	2213	(11.825317547305483,42.25)
20987	2134	(12.691342951089922,40.75)
20988	2213	(11.825317547305483,42.25)
20989	2003	(2.7320508075688772,38.5)
20990	2005	(4.4641016151377544,38.5)
20991	1885	(4.897114317029974,36.25)
20992	2207	(6.6291651245988508,42.25)
20993	1925	(4.4641016151377544,37)
20994	2207	(6.6291651245988508,42.25)
20995	2085	(4.4641016151377544,40)
20996	2011	(9.6602540378443873,38.5)
20997	1807	(6.6291651245988508,34.75)
20998	2016	(13.99038105676658,38.5)
20999	2016	(13.99038105676658,38.5)
21000	2137	(15.289419162443238,40.75)
21001	2055	(13.55736835487436,39.25)
21002	2016	(13.99038105676658,38.5)
21003	2137	(15.289419162443238,40.75)
21004	2320	(35.208003449485325,43.75)
21005	969	(7.9282032302755088,19)
21006	1205	(4.4641016151377544,23.5)
21007	1019	(17.021469970012117,19.75)
21008	1135	(13.124355652982141,22)
21009	1720	(34.774990747593108,32.5)
21010	1680	(35.208003449485325,31.75)
21011	2394	(30.011851026778693,45.25)
21012	2315	(30.877876430563134,43.75)
21013	2394	(30.011851026778693,45.25)
21014	2394	(30.011851026778693,45.25)
21015	2392	(28.279800219209818,45.25)
21016	1790	(26.114736709748719,34)
21017	1905	(22.217622392718749,36.25)
21018	2289	(8.3612159321677293,43.75)
21019	1786	(22.650635094610966,34)
21020	1786	(22.650635094610966,34)
21021	2370	(9.2272413359521668,45.25)
21022	2334	(12.258330249197702,44.5)
21023	1786	(22.650635094610966,34)
21024	1160	(34.774990747593108,22)
21025	1160	(34.774990747593108,22)
21026	1160	(34.774990747593108,22)
21027	1360	(35.208003449485325,25.75)
21028	2317	(32.609927238132009,43.75)
21029	2269	(25.248711305964282,43)
21030	2358	(33.042939940024233,44.5)
21031	1356	(31.743901834347572,25.75)
21032	2279	(33.908965343808667,43)
21033	2280	(34.774990747593108,43)
21034	2280	(34.774990747593108,43)
21035	2396	(31.743901834347572,45.25)
21036	95	(13.124355652982141,2.5)
21037	135	(13.55736835487436,3.25)
21038	94	(12.258330249197702,2.5)
21039	133	(11.825317547305483,3.25)
21040	54	(12.691342951089922,1.75)
21041	173	(11.392304845413264,4)
21042	53	(11.825317547305483,1.75)
21043	167	(6.196152422706632,4)
21044	7	(6.196152422706632,1)
21045	6	(5.3301270189221936,1)
21046	85	(4.4641016151377544,2.5)
21047	85	(4.4641016151377544,2.5)
21048	44	(4.0310889132455356,1.75)
21049	281	(1.4330127018922194,6.25)
21050	281	(1.4330127018922194,6.25)
21051	281	(1.4330127018922194,6.25)
21052	162	(1.8660254037844386,4)
21053	2194	(29.578838324886476,41.5)
21054	2156	(31.743901834347572,40.75)
21055	2157	(32.609927238132009,40.75)
21056	2035	(30.444863728670914,38.5)
21057	1917	(32.609927238132009,36.25)
21058	1917	(32.609927238132009,36.25)
21059	1916	(31.743901834347572,36.25)
21060	1832	(28.279800219209818,34.75)
21061	1953	(28.712812921102035,37)
21062	613	(11.825317547305483,12.25)
21063	570	(8.794228634059948,11.5)
21064	1610	(8.794228634059948,31)
21065	1647	(6.6291651245988508,31.75)
21066	1647	(6.6291651245988508,31.75)
21067	1293	(11.392304845413264,25)
21068	2157	(32.609927238132009,40.75)
21069	2159	(34.341978045700891,40.75)
21070	2150	(26.54774941164094,40.75)
21071	2310	(26.54774941164094,43.75)
21072	2400	(35.208003449485325,45.25)
21073	2200	(34.774990747593108,41.5)
21074	1828	(24.815698604072061,34.75)
21075	1869	(25.248711305964282,35.5)
21076	2399	(34.341978045700891,45.25)
21077	2279	(33.908965343808667,43)
21078	364	(4.0310889132455356,7.75)
21079	326	(5.3301270189221936,7)
21080	326	(5.3301270189221936,7)
21081	1340	(17.887495373796554,25.75)
21082	1337	(15.289419162443238,25.75)
21083	1256	(14.423393758658799,24.25)
21084	1417	(15.289419162443238,27.25)
21085	1296	(13.99038105676658,25)
21086	1296	(13.99038105676658,25)
21087	1379	(16.588457268119896,26.5)
21088	1297	(14.856406460551018,25)
21089	1306	(22.650635094610966,25)
21090	1547	(23.516660498395403,29.5)
21091	1112	(28.279800219209818,21.25)
21092	911	(26.98076211353316,17.5)
21093	911	(26.98076211353316,17.5)
21094	870	(26.54774941164094,16.75)
21095	1191	(27.413774815425377,22.75)
21096	1112	(28.279800219209818,21.25)
21097	1140	(17.454482671904334,22)
21098	1140	(17.454482671904334,22)
21099	1182	(19.619546181365433,22.75)
21100	835	(30.444863728670914,16)
21101	792	(28.279800219209818,15.25)
21102	835	(30.444863728670914,16)
21103	792	(28.279800219209818,15.25)
21104	1370	(8.794228634059948,26.5)
21105	601	(1.4330127018922194,12.25)
21106	441	(1.4330127018922194,9.25)
21107	441	(1.4330127018922194,9.25)
21108	1210	(8.794228634059948,23.5)
21109	1249	(8.3612159321677293,24.25)
21110	1287	(6.196152422706632,25)
21111	954	(30.011851026778693,18.25)
21112	1031	(27.413774815425377,19.75)
21113	990	(26.114736709748719,19)
21114	947	(23.949673200287624,18.25)
21115	1277	(32.609927238132009,24.25)
21116	1277	(32.609927238132009,24.25)
21117	1277	(32.609927238132009,24.25)
21118	1476	(31.310889132455351,28)
21119	1753	(29.145825622994256,33.25)
21120	1715	(30.444863728670914,32.5)
21121	1676	(31.743901834347572,31.75)
21122	1717	(32.176914536239792,32.5)
21123	1718	(33.042939940024233,32.5)
21124	1759	(34.341978045700891,33.25)
21125	1872	(27.846787517317598,35.5)
21126	1834	(30.011851026778693,34.75)
21127	1834	(30.011851026778693,34.75)
21128	1907	(23.949673200287624,36.25)
21129	1872	(27.846787517317598,35.5)
21130	1688	(7.0621778264910704,32.5)
21131	1947	(23.516660498395403,37)
21132	1724	(4.0310889132455356,33.25)
21133	1036	(31.743901834347572,19.75)
21134	676	(31.310889132455351,13)
21135	632	(28.279800219209818,12.25)
21136	632	(28.279800219209818,12.25)
21137	145	(22.217622392718749,3.25)
21138	432	(27.846787517317598,8.5)
21139	64	(21.351596988934308,1.75)
21140	68	(24.815698604072061,1.75)
21141	317	(32.609927238132009,6.25)
21142	478	(33.47595264191645,9.25)
21143	632	(28.279800219209818,12.25)
21144	145	(22.217622392718749,3.25)
21145	432	(27.846787517317598,8.5)
21146	473	(29.145825622994256,9.25)
21147	72	(28.279800219209818,1.75)
21148	275	(30.444863728670914,5.5)
21149	113	(28.712812921102035,2.5)
21150	480	(35.208003449485325,9.25)
21151	73	(29.145825622994256,1.75)
21152	632	(28.279800219209818,12.25)
21153	145	(22.217622392718749,3.25)
21154	432	(27.846787517317598,8.5)
21155	473	(29.145825622994256,9.25)
21156	73	(29.145825622994256,1.75)
21157	28	(24.382685902179844,1)
21158	275	(30.444863728670914,5.5)
21159	440	(34.774990747593108,8.5)
21160	1036	(31.743901834347572,19.75)
21161	676	(31.310889132455351,13)
21162	632	(28.279800219209818,12.25)
21163	673	(28.712812921102035,13)
21164	673	(28.712812921102035,13)
21165	432	(27.846787517317598,8.5)
21166	37	(32.176914536239792,1)
21167	160	(35.208003449485325,3.25)
21168	37	(32.176914536239792,1)
21169	80	(35.208003449485325,1.75)
21170	80	(35.208003449485325,1.75)
21171	37	(32.176914536239792,1)
21172	160	(35.208003449485325,3.25)
21173	1237	(32.176914536239792,23.5)
21174	1237	(32.176914536239792,23.5)
21175	1197	(32.609927238132009,22.75)
21176	1318	(33.042939940024233,25)
21177	1359	(34.341978045700891,25.75)
21178	64	(21.351596988934308,1.75)
21179	64	(21.351596988934308,1.75)
21180	37	(32.176914536239792,1)
21181	189	(25.248711305964282,4)
21182	28	(24.382685902179844,1)
21183	316	(31.743901834347572,6.25)
21184	240	(35.208003449485325,4.75)
21185	317	(32.609927238132009,6.25)
21186	317	(32.609927238132009,6.25)
21187	1119	(34.341978045700891,21.25)
21188	1398	(33.042939940024233,26.5)
21189	1439	(34.341978045700891,27.25)
21190	1240	(34.774990747593108,23.5)
21191	1240	(34.774990747593108,23.5)
21192	1240	(34.774990747593108,23.5)
21193	1440	(35.208003449485325,27.25)
21194	596	(31.310889132455351,11.5)
21195	596	(31.310889132455351,11.5)
21196	596	(31.310889132455351,11.5)
21197	596	(31.310889132455351,11.5)
21198	596	(31.310889132455351,11.5)
21199	1119	(34.341978045700891,21.25)
21200	1119	(34.341978045700891,21.25)
21201	1119	(34.341978045700891,21.25)
21202	1398	(33.042939940024233,26.5)
21203	1036	(31.743901834347572,19.75)
21204	676	(31.310889132455351,13)
21205	632	(28.279800219209818,12.25)
21206	673	(28.712812921102035,13)
21207	673	(28.712812921102035,13)
21208	916	(31.310889132455351,17.5)
21209	672	(27.846787517317598,13)
21210	672	(27.846787517317598,13)
21211	672	(27.846787517317598,13)
21212	473	(29.145825622994256,9.25)
21213	473	(29.145825622994256,9.25)
21214	193	(28.712812921102035,4)
21215	190	(26.114736709748719,4)
21216	796	(31.743901834347572,15.25)
21217	796	(31.743901834347572,15.25)
21218	796	(31.743901834347572,15.25)
21219	796	(31.743901834347572,15.25)
21220	2154	(30.011851026778693,40.75)
21221	2313	(29.145825622994256,43.75)
21222	2233	(29.145825622994256,42.25)
21223	223	(20.48557158514987,4.75)
21224	223	(20.48557158514987,4.75)
21225	223	(20.48557158514987,4.75)
21226	223	(20.48557158514987,4.75)
21227	2359	(33.908965343808667,44.5)
21228	1960	(34.774990747593108,37)
21229	2196	(31.310889132455351,41.5)
21230	339	(16.588457268119896,7)
21231	339	(16.588457268119896,7)
21232	782	(19.619546181365433,15.25)
21233	821	(18.320508075688775,16)
21234	819	(16.588457268119896,16)
21235	336	(13.99038105676658,7)
21236	2374	(12.691342951089922,45.25)
21237	2374	(12.691342951089922,45.25)
21238	130	(9.2272413359521668,3.25)
21239	170	(8.794228634059948,4)
21240	363	(3.1650635094610968,7.75)
21241	1289	(7.9282032302755088,25)
21242	1329	(8.3612159321677293,25.75)
21243	1290	(8.794228634059948,25)
21244	41	(1.4330127018922194,1.75)
21245	1	(1,1)
21246	1	(1,1)
21247	1	(1,1)
21248	481	(1,10)
21249	1370	(8.794228634059948,26.5)
21250	601	(1.4330127018922194,12.25)
21251	601	(1.4330127018922194,12.25)
21252	601	(1.4330127018922194,12.25)
21253	1287	(6.196152422706632,25)
21254	1287	(6.196152422706632,25)
21255	1046	(5.3301270189221936,20.5)
21256	113	(28.712812921102035,2.5)
21257	480	(35.208003449485325,9.25)
21258	2279	(33.908965343808667,43)
21259	2279	(33.908965343808667,43)
21260	568	(7.0621778264910704,11.5)
21261	612	(10.959292143521045,12.25)
21262	441	(1.4330127018922194,9.25)
21263	603	(3.1650635094610968,12.25)
21264	601	(1.4330127018922194,12.25)
21265	1249	(8.3612159321677293,24.25)
21266	1126	(5.3301270189221936,22)
21267	882	(1.8660254037844386,17.5)
21268	1287	(6.196152422706632,25)
21269	1287	(6.196152422706632,25)
21270	1125	(4.4641016151377544,22)
21271	1203	(2.7320508075688772,23.5)
21272	1163	(3.1650635094610968,22.75)
21273	841	(1.4330127018922194,16.75)
21274	964	(3.598076211353316,19)
21275	921	(1.4330127018922194,18.25)
21276	2156	(31.743901834347572,40.75)
21277	2033	(28.712812921102035,38.5)
21278	2033	(28.712812921102035,38.5)
21279	2033	(28.712812921102035,38.5)
21280	1650	(9.2272413359521668,31.75)
21281	1608	(7.0621778264910704,31)
21282	2311	(27.413774815425377,43.75)
21283	1606	(5.3301270189221936,31)
21284	1641	(1.4330127018922194,31.75)
21285	1605	(4.4641016151377544,31)
21286	2035	(30.444863728670914,38.5)
21287	2035	(30.444863728670914,38.5)
21288	2111	(26.98076211353316,40)
21289	1529	(7.9282032302755088,29.5)
21290	1641	(1.4330127018922194,31.75)
21291	1522	(1.8660254037844386,29.5)
21292	765	(4.897114317029974,15.25)
21293	765	(4.897114317029974,15.25)
21294	1841	(1,35.5)
21295	1761	(1,34)
21296	767	(6.6291651245988508,15.25)
21297	766	(5.7631397208144124,15.25)
21298	1841	(1,35.5)
21299	586	(22.650635094610966,11.5)
21300	586	(22.650635094610966,11.5)
21301	664	(20.918584287042091,13)
21302	663	(20.05255888325765,13)
21303	947	(23.949673200287624,18.25)
21304	659	(16.588457268119896,13)
21305	659	(16.588457268119896,13)
21306	945	(22.217622392718749,18.25)
21307	425	(21.784609690826528,8.5)
21308	461	(18.753520777580992,9.25)
21309	461	(18.753520777580992,9.25)
21310	1232	(27.846787517317598,23.5)
21311	1352	(28.279800219209818,25.75)
21312	1390	(26.114736709748719,26.5)
21313	1388	(24.382685902179844,26.5)
21314	1427	(23.949673200287624,27.25)
21315	1427	(23.949673200287624,27.25)
21316	1542	(19.186533479473212,29.5)
21317	1542	(19.186533479473212,29.5)
21318	1312	(27.846787517317598,25)
21319	1350	(26.54774941164094,25.75)
21320	1070	(26.114736709748719,20.5)
21321	1027	(23.949673200287624,19.75)
21322	1460	(17.454482671904334,28)
21323	1460	(17.454482671904334,28)
21324	1541	(18.320508075688775,29.5)
21325	1541	(18.320508075688775,29.5)
21326	1187	(23.949673200287624,22.75)
21327	1146	(22.650635094610966,22)
21328	1145	(21.784609690826528,22)
21329	1024	(21.351596988934308,19.75)
21330	1064	(20.918584287042091,20.5)
21331	1062	(19.186533479473212,20.5)
21332	1100	(17.887495373796554,21.25)
21333	1063	(20.05255888325765,20.5)
21334	905	(21.784609690826528,17.5)
21335	905	(21.784609690826528,17.5)
21336	101	(18.320508075688775,2.5)
21337	101	(18.320508075688775,2.5)
21338	60	(17.887495373796554,1.75)
21339	58	(16.155444566227676,1.75)
21340	58	(16.155444566227676,1.75)
21341	17	(14.856406460551018,1)
21342	15	(13.124355652982141,1)
21343	17	(14.856406460551018,1)
21344	178	(15.722431864335457,4)
21345	178	(15.722431864335457,4)
21346	1537	(14.856406460551018,29.5)
21347	1618	(15.722431864335457,31)
21348	1152	(27.846787517317598,22)
21349	1191	(27.413774815425377,22.75)
21350	1191	(27.413774815425377,22.75)
21351	1191	(27.413774815425377,22.75)
21352	1140	(17.454482671904334,22)
21353	295	(13.55736835487436,6.25)
21354	336	(13.99038105676658,7)
21355	255	(13.124355652982141,5.5)
21356	214	(12.691342951089922,4.75)
21357	779	(17.021469970012117,15.25)
21358	819	(16.588457268119896,16)
21359	782	(19.619546181365433,15.25)
21360	1342	(19.619546181365433,25.75)
21361	1256	(14.423393758658799,24.25)
21362	1417	(15.289419162443238,27.25)
21363	1377	(14.856406460551018,26.5)
21364	1216	(13.99038105676658,23.5)
21365	1176	(14.423393758658799,22.75)
21366	1176	(14.423393758658799,22.75)
21367	1942	(19.186533479473212,37)
21368	1695	(13.124355652982141,32.5)
21369	1772	(10.526279441628825,34)
21370	1770	(8.794228634059948,34)
21371	2060	(17.887495373796554,39.25)
21372	2020	(17.454482671904334,38.5)
21373	1807	(6.6291651245988508,34.75)
21374	1769	(7.9282032302755088,34)
21375	2060	(17.887495373796554,39.25)
21376	2134	(12.691342951089922,40.75)
21377	2213	(11.825317547305483,42.25)
21378	2213	(11.825317547305483,42.25)
21379	1925	(4.4641016151377544,37)
21380	1924	(3.598076211353316,37)
21381	1962	(2.299038105676658,37.75)
21382	2044	(4.0310889132455356,39.25)
21383	1977	(15.289419162443238,37.75)
21384	1807	(6.6291651245988508,34.75)
21385	1962	(2.299038105676658,37.75)
21386	1925	(4.4641016151377544,37)
21387	1973	(11.825317547305483,37.75)
21388	2127	(6.6291651245988508,40.75)
21389	1776	(13.99038105676658,34)
21390	2133	(11.825317547305483,40.75)
21391	2388	(24.815698604072061,45.25)
21392	2221	(18.753520777580992,42.25)
21393	2181	(18.320508075688775,41.5)
21394	2386	(23.083647796503186,45.25)
21395	2385	(22.217622392718749,45.25)
21396	2388	(24.815698604072061,45.25)
21397	2346	(22.650635094610966,44.5)
21398	2345	(21.784609690826528,44.5)
21399	2341	(18.320508075688775,44.5)
21400	2382	(19.619546181365433,45.25)
21401	2382	(19.619546181365433,45.25)
21402	2362	(2.299038105676658,45.25)
21403	2362	(2.299038105676658,45.25)
21404	2202	(2.299038105676658,42.25)
21405	2362	(2.299038105676658,45.25)
21406	2361	(1.4330127018922194,45.25)
21407	2322	(1.8660254037844386,44.5)
21408	1160	(34.774990747593108,22)
21409	1160	(34.774990747593108,22)
21410	1160	(34.774990747593108,22)
21411	1360	(35.208003449485325,25.75)
21412	1360	(35.208003449485325,25.75)
21413	2317	(32.609927238132009,43.75)
21414	2269	(25.248711305964282,43)
21415	2358	(33.042939940024233,44.5)
21416	1356	(31.743901834347572,25.75)
21417	2227	(23.949673200287624,42.25)
21418	262	(19.186533479473212,5.5)
21419	262	(19.186533479473212,5.5)
21420	262	(19.186533479473212,5.5)
21421	262	(19.186533479473212,5.5)
21422	300	(17.887495373796554,6.25)
21423	339	(16.588457268119896,7)
21424	339	(16.588457268119896,7)
21425	326	(5.3301270189221936,7)
21426	326	(5.3301270189221936,7)
21427	367	(6.6291651245988508,7.75)
21428	326	(5.3301270189221936,7)
21429	364	(4.0310889132455356,7.75)
21430	7	(6.196152422706632,1)
21431	7	(6.196152422706632,1)
21432	85	(4.4641016151377544,2.5)
21433	85	(4.4641016151377544,2.5)
21434	85	(4.4641016151377544,2.5)
21435	204	(4.0310889132455356,4.75)
21436	281	(1.4330127018922194,6.25)
21437	282	(2.299038105676658,6.25)
21438	281	(1.4330127018922194,6.25)
21439	1917	(32.609927238132009,36.25)
21440	1917	(32.609927238132009,36.25)
21441	1877	(32.176914536239792,35.5)
21442	1877	(32.176914536239792,35.5)
21443	1952	(27.846787517317598,37)
21444	2028	(24.382685902179844,38.5)
21445	1988	(24.815698604072061,37.75)
21446	1761	(1,34)
21447	2027	(23.516660498395403,38.5)
21448	2067	(23.949673200287624,39.25)
21449	1614	(12.258330249197702,31)
21450	613	(11.825317547305483,12.25)
21451	1494	(12.691342951089922,28.75)
21452	610	(9.2272413359521668,12.25)
21453	731	(9.6602540378443873,14.5)
21454	1952	(27.846787517317598,37)
21455	2027	(23.516660498395403,38.5)
21456	2384	(21.351596988934308,45.25)
21457	1877	(32.176914536239792,35.5)
21458	2157	(32.609927238132009,40.75)
21459	1877	(32.176914536239792,35.5)
21460	1917	(32.609927238132009,36.25)
21461	1652	(10.959292143521045,31.75)
21462	1952	(27.846787517317598,37)
21463	1529	(7.9282032302755088,29.5)
21464	1614	(12.258330249197702,31)
21465	613	(11.825317547305483,12.25)
21466	610	(9.2272413359521668,12.25)
21467	731	(9.6602540378443873,14.5)
21468	1952	(27.846787517317598,37)
21469	1529	(7.9282032302755088,29.5)
21470	1993	(29.145825622994256,37.75)
21471	1761	(1,34)
21472	1831	(27.413774815425377,34.75)
21473	2289	(8.3612159321677293,43.75)
21474	2289	(8.3612159321677293,43.75)
21475	2158	(33.47595264191645,40.75)
21476	2040	(34.774990747593108,38.5)
21477	2157	(32.609927238132009,40.75)
21478	2040	(34.774990747593108,38.5)
21479	1952	(27.846787517317598,37)
21480	1670	(26.54774941164094,31.75)
21481	1708	(24.382685902179844,32.5)
21482	1708	(24.382685902179844,32.5)
21483	941	(18.753520777580992,18.25)
21484	941	(18.753520777580992,18.25)
21485	1019	(17.021469970012117,19.75)
21486	1135	(13.124355652982141,22)
21487	676	(31.310889132455351,13)
21488	676	(31.310889132455351,13)
21489	676	(31.310889132455351,13)
21490	676	(31.310889132455351,13)
21491	715	(30.877876430563134,13.75)
21492	715	(30.877876430563134,13.75)
21493	389	(25.681724007856502,7.75)
21494	389	(25.681724007856502,7.75)
21495	389	(25.681724007856502,7.75)
21496	391	(27.413774815425377,7.75)
21497	347	(23.516660498395403,7)
21498	347	(23.516660498395403,7)
21499	347	(23.516660498395403,7)
21500	152	(28.279800219209818,3.25)
21501	153	(29.145825622994256,3.25)
21502	113	(28.712812921102035,2.5)
21503	391	(27.413774815425377,7.75)
21504	226	(23.083647796503186,4.75)
21505	68	(24.815698604072061,1.75)
21506	320	(35.208003449485325,6.25)
21507	278	(33.042939940024233,5.5)
21508	153	(29.145825622994256,3.25)
21509	153	(29.145825622994256,3.25)
21510	113	(28.712812921102035,2.5)
21511	473	(29.145825622994256,9.25)
21512	560	(35.208003449485325,10.75)
21513	600	(34.774990747593108,11.5)
21514	315	(30.877876430563134,6.25)
21515	146	(23.083647796503186,3.25)
21516	398	(33.47595264191645,7.75)
21517	353	(28.712812921102035,7)
21518	716	(31.743901834347572,13.75)
21519	716	(31.743901834347572,13.75)
21520	716	(31.743901834347572,13.75)
21521	716	(31.743901834347572,13.75)
21522	716	(31.743901834347572,13.75)
21523	1237	(32.176914536239792,23.5)
21524	1237	(32.176914536239792,23.5)
21525	1237	(32.176914536239792,23.5)
21526	1197	(32.609927238132009,22.75)
21527	1318	(33.042939940024233,25)
21528	1079	(33.908965343808667,20.5)
21529	1040	(35.208003449485325,19.75)
21530	1480	(34.774990747593108,28)
21531	200	(34.774990747593108,4)
21532	160	(35.208003449485325,3.25)
21533	160	(35.208003449485325,3.25)
21534	160	(35.208003449485325,3.25)
21535	200	(34.774990747593108,4)
21536	240	(35.208003449485325,4.75)
21537	1119	(34.341978045700891,21.25)
21538	1079	(33.908965343808667,20.5)
21539	1439	(34.341978045700891,27.25)
21540	1079	(33.908965343808667,20.5)
21541	1715	(30.444863728670914,32.5)
21542	1718	(33.042939940024233,32.5)
21543	1759	(34.341978045700891,33.25)
21544	1680	(35.208003449485325,31.75)
21545	1427	(23.949673200287624,27.25)
21546	1427	(23.949673200287624,27.25)
21547	1537	(14.856406460551018,29.5)
21548	1538	(15.722431864335457,29.5)
21549	1076	(31.310889132455351,20.5)
21550	1076	(31.310889132455351,20.5)
21551	1076	(31.310889132455351,20.5)
21552	1117	(32.609927238132009,21.25)
21553	628	(24.815698604072061,12.25)
21554	1079	(33.908965343808667,20.5)
21555	628	(24.815698604072061,12.25)
21556	960	(35.208003449485325,18.25)
21557	391	(27.413774815425377,7.75)
21558	960	(35.208003449485325,18.25)
21559	1240	(34.774990747593108,23.5)
21560	1240	(34.774990747593108,23.5)
21561	1240	(34.774990747593108,23.5)
21562	1440	(35.208003449485325,27.25)
21563	1520	(35.208003449485325,28.75)
21564	1834	(30.011851026778693,34.75)
21565	1834	(30.011851026778693,34.75)
21566	1834	(30.011851026778693,34.75)
21567	1834	(30.011851026778693,34.75)
21568	1598	(33.47595264191645,30.25)
21569	1872	(27.846787517317598,35.5)
21570	1907	(23.949673200287624,36.25)
21571	1687	(6.196152422706632,32.5)
21572	1907	(23.949673200287624,36.25)
21573	1684	(3.598076211353316,32.5)
21574	1724	(4.0310889132455356,33.25)
21575	2356	(31.310889132455351,44.5)
21576	2400	(35.208003449485325,45.25)
21577	2200	(34.774990747593108,41.5)
21578	2279	(33.908965343808667,43)
21579	2399	(34.341978045700891,45.25)
21580	835	(30.444863728670914,16)
21581	792	(28.279800219209818,15.25)
21582	792	(28.279800219209818,15.25)
21583	954	(30.011851026778693,18.25)
21584	954	(30.011851026778693,18.25)
21585	1031	(27.413774815425377,19.75)
21586	990	(26.114736709748719,19)
21587	947	(23.949673200287624,18.25)
21588	947	(23.949673200287624,18.25)
21589	1277	(32.609927238132009,24.25)
21590	1476	(31.310889132455351,28)
21591	1753	(29.145825622994256,33.25)
21592	1715	(30.444863728670914,32.5)
21593	1676	(31.743901834347572,31.75)
21594	1717	(32.176914536239792,32.5)
21595	1718	(33.042939940024233,32.5)
21596	1759	(34.341978045700891,33.25)
21597	1760	(35.208003449485325,33.25)
21598	1680	(35.208003449485325,31.75)
21599	568	(7.0621778264910704,11.5)
21600	612	(10.959292143521045,12.25)
21601	441	(1.4330127018922194,9.25)
21602	644	(3.598076211353316,13)
21603	1633	(28.712812921102035,31)
21604	1592	(28.279800219209818,30.25)
21605	1591	(27.413774815425377,30.25)
21606	1252	(10.959292143521045,24.25)
21607	1412	(10.959292143521045,27.25)
21608	1291	(9.6602540378443873,25)
21609	719	(34.341978045700891,13.75)
21610	719	(34.341978045700891,13.75)
21611	719	(34.341978045700891,13.75)
21612	719	(34.341978045700891,13.75)
21613	155	(30.877876430563134,3.25)
21614	1291	(9.6602540378443873,25)
21615	1291	(9.6602540378443873,25)
21616	1411	(10.093266739736606,27.25)
21617	851	(10.093266739736606,16.75)
21618	969	(7.9282032302755088,19)
21619	928	(7.49519052838329,18.25)
21620	2055	(13.55736835487436,39.25)
21621	2016	(13.99038105676658,38.5)
21622	2016	(13.99038105676658,38.5)
21623	2137	(15.289419162443238,40.75)
21624	2352	(27.846787517317598,44.5)
21625	2353	(28.712812921102035,44.5)
21626	2392	(28.279800219209818,45.25)
21627	2392	(28.279800219209818,45.25)
21628	2352	(27.846787517317598,44.5)
21629	2392	(28.279800219209818,45.25)
21630	2392	(28.279800219209818,45.25)
21631	2396	(31.743901834347572,45.25)
21632	2396	(31.743901834347572,45.25)
21633	2396	(31.743901834347572,45.25)
21634	2123	(3.1650635094610968,40.75)
21635	2041	(1.4330127018922194,39.25)
21636	2373	(11.825317547305483,45.25)
21637	2370	(9.2272413359521668,45.25)
21638	1786	(22.650635094610966,34)
21639	2161	(1,41.5)
21640	2374	(12.691342951089922,45.25)
21641	2374	(12.691342951089922,45.25)
21642	2372	(10.959292143521045,45.25)
21643	2359	(33.908965343808667,44.5)
21644	2196	(31.310889132455351,41.5)
21645	678	(33.042939940024233,13)
21646	678	(33.042939940024233,13)
21647	1960	(34.774990747593108,37)
21648	130	(9.2272413359521668,3.25)
21649	170	(8.794228634059948,4)
21650	2156	(31.743901834347572,40.75)
21651	2154	(30.011851026778693,40.75)
21652	2233	(29.145825622994256,42.25)
21653	2157	(32.609927238132009,40.75)
21654	2156	(31.743901834347572,40.75)
21655	2154	(30.011851026778693,40.75)
21656	1957	(32.176914536239792,37)
21657	2194	(29.578838324886476,41.5)
21658	2194	(29.578838324886476,41.5)
21659	2279	(33.908965343808667,43)
21660	803	(2.7320508075688772,16)
21661	1163	(3.1650635094610968,22.75)
21662	1047	(6.196152422706632,20.5)
21663	1085	(4.897114317029974,21.25)
21664	803	(2.7320508075688772,16)
21665	1084	(4.0310889132455356,21.25)
21666	1162	(2.299038105676658,22.75)
21667	1121	(1,22)
21668	1163	(3.1650635094610968,22.75)
21669	2069	(25.681724007856502,39.25)
21670	2069	(25.681724007856502,39.25)
21671	1529	(7.9282032302755088,29.5)
21672	1907	(23.949673200287624,36.25)
21673	1868	(24.382685902179844,35.5)
21674	2311	(27.413774815425377,43.75)
21675	2068	(24.815698604072061,39.25)
21676	1608	(7.0621778264910704,31)
21677	2068	(24.815698604072061,39.25)
21678	1841	(1,35.5)
21679	1761	(1,34)
21680	1608	(7.0621778264910704,31)
21681	1761	(1,34)
21682	1163	(3.1650635094610968,22.75)
21683	1708	(24.382685902179844,32.5)
21684	815	(13.124355652982141,16)
21685	1019	(17.021469970012117,19.75)
21686	1135	(13.124355652982141,22)
21687	1095	(13.55736835487436,21.25)
21688	1804	(4.0310889132455356,34.75)
21689	1864	(20.918584287042091,35.5)
21690	1095	(13.55736835487436,21.25)
21691	1062	(19.186533479473212,20.5)
21692	1098	(16.155444566227676,21.25)
21693	133	(11.825317547305483,3.25)
21694	53	(11.825317547305483,1.75)
21695	389	(25.681724007856502,7.75)
21696	389	(25.681724007856502,7.75)
21697	109	(25.248711305964282,2.5)
21698	33	(28.712812921102035,1)
21699	33	(28.712812921102035,1)
21700	109	(25.248711305964282,2.5)
21701	1544	(20.918584287042091,29.5)
21702	1501	(18.753520777580992,28.75)
21703	1424	(21.351596988934308,27.25)
21704	1308	(24.382685902179844,25)
21705	794	(30.011851026778693,15.25)
21706	1618	(15.722431864335457,31)
21707	663	(20.05255888325765,13)
21708	1544	(20.918584287042091,29.5)
21709	660	(17.454482671904334,13)
21710	701	(18.753520777580992,13.75)
21711	1069	(25.248711305964282,20.5)
21712	990	(26.114736709748719,19)
21713	1027	(23.949673200287624,19.75)
21714	720	(35.208003449485325,13.75)
21715	720	(35.208003449485325,13.75)
21716	720	(35.208003449485325,13.75)
21717	1480	(34.774990747593108,28)
21718	720	(35.208003449485325,13.75)
21719	2194	(29.578838324886476,41.5)
21720	2194	(29.578838324886476,41.5)
21721	1359	(34.341978045700891,25.75)
21722	1439	(34.341978045700891,27.25)
21723	1479	(33.908965343808667,28)
21724	1519	(34.341978045700891,28.75)
21725	870	(26.54774941164094,16.75)
21726	1152	(27.846787517317598,22)
21727	1182	(19.619546181365433,22.75)
21728	1182	(19.619546181365433,22.75)
21729	1277	(32.609927238132009,24.25)
21730	1277	(32.609927238132009,24.25)
21731	1476	(31.310889132455351,28)
21732	1753	(29.145825622994256,33.25)
21733	1715	(30.444863728670914,32.5)
21734	1717	(32.176914536239792,32.5)
21735	1718	(33.042939940024233,32.5)
21736	1759	(34.341978045700891,33.25)
21737	1760	(35.208003449485325,33.25)
21738	1680	(35.208003449485325,31.75)
21739	37	(32.176914536239792,1)
21740	1360	(35.208003449485325,25.75)
21741	1440	(35.208003449485325,27.25)
21742	1520	(35.208003449485325,28.75)
21743	45	(4.897114317029974,1.75)
21744	88	(7.0621778264910704,2.5)
21745	82	(1.8660254037844386,2.5)
21746	321	(1,7)
21747	321	(1,7)
21748	2374	(12.691342951089922,45.25)
21749	2374	(12.691342951089922,45.25)
21750	2373	(11.825317547305483,45.25)
21751	2370	(9.2272413359521668,45.25)
21752	336	(13.99038105676658,7)
21753	819	(16.588457268119896,16)
21754	736	(13.99038105676658,14.5)
21755	1968	(7.49519052838329,37.75)
21756	2214	(12.691342951089922,42.25)
21757	1768	(7.0621778264910704,34)
21758	1852	(10.526279441628825,35.5)
21759	2085	(4.4641016151377544,40)
21760	2168	(7.0621778264910704,41.5)
21761	2167	(6.196152422706632,41.5)
21762	2207	(6.6291651245988508,42.25)
21763	2127	(6.6291651245988508,40.75)
21764	2086	(5.3301270189221936,40)
21765	1973	(11.825317547305483,37.75)
21766	2302	(19.619546181365433,43.75)
21767	2382	(19.619546181365433,45.25)
21768	2361	(1.4330127018922194,45.25)
21769	2321	(1,44.5)
21770	2156	(31.743901834347572,40.75)
21771	2159	(34.341978045700891,40.75)
21772	1571	(10.093266739736606,30.25)
21773	2400	(35.208003449485325,45.25)
21774	2200	(34.774990747593108,41.5)
21775	2399	(34.341978045700891,45.25)
21776	2279	(33.908965343808667,43)
21777	2356	(31.310889132455351,44.5)
21778	2274	(29.578838324886476,43)
21779	2392	(28.279800219209818,45.25)
21780	2392	(28.279800219209818,45.25)
21781	1160	(34.774990747593108,22)
21782	1160	(34.774990747593108,22)
21783	1439	(34.341978045700891,27.25)
21784	2317	(32.609927238132009,43.75)
21785	2269	(25.248711305964282,43)
21786	2358	(33.042939940024233,44.5)
21787	1356	(31.743901834347572,25.75)
21788	2233	(29.145825622994256,42.25)
21789	965	(4.4641016151377544,19)
21790	964	(3.598076211353316,19)
21791	2386	(23.083647796503186,45.25)
21792	2181	(18.320508075688775,41.5)
21793	70	(26.54774941164094,1.75)
21794	70	(26.54774941164094,1.75)
21795	38	(33.042939940024233,1)
21796	1718	(33.042939940024233,32.5)
21797	1680	(35.208003449485325,31.75)
21798	1398	(33.042939940024233,26.5)
21799	1439	(34.341978045700891,27.25)
21800	1480	(34.774990747593108,28)
21801	1360	(35.208003449485325,25.75)
21802	1480	(34.774990747593108,28)
21803	1520	(35.208003449485325,28.75)
21804	2320	(35.208003449485325,43.75)
21805	326	(5.3301270189221936,7)
21806	1	(1,1)
21807	1	(1,1)
21808	1	(1,1)
21809	2088	(7.0621778264910704,40)
21810	1968	(7.49519052838329,37.75)
21811	2127	(6.6291651245988508,40.75)
21812	2321	(1,44.5)
21813	2361	(1.4330127018922194,45.25)
21814	2279	(33.908965343808667,43)
21815	1090	(9.2272413359521668,21.25)
21816	1089	(8.3612159321677293,21.25)
21817	1323	(3.1650635094610968,25.75)
21818	1282	(1.8660254037844386,25)
21819	1202	(1.8660254037844386,23.5)
21820	1084	(4.0310889132455356,21.25)
21821	1121	(1,22)
21822	1083	(3.1650635094610968,21.25)
21823	1949	(25.248711305964282,37)
21824	1495	(13.55736835487436,28.75)
21825	1406	(5.7631397208144124,27.25)
21826	731	(9.6602540378443873,14.5)
21827	1365	(4.4641016151377544,26.5)
21828	1365	(4.4641016151377544,26.5)
21829	925	(4.897114317029974,18.25)
21830	1612	(10.526279441628825,31)
21831	1704	(20.918584287042091,32.5)
21832	1406	(5.7631397208144124,27.25)
21833	689	(8.3612159321677293,13.75)
21834	689	(8.3612159321677293,13.75)
21835	1743	(20.48557158514987,33.25)
21836	1985	(22.217622392718749,37.75)
21837	411	(9.6602540378443873,8.5)
21838	649	(7.9282032302755088,13)
21839	1993	(29.145825622994256,37.75)
21840	2033	(28.712812921102035,38.5)
21841	1993	(29.145825622994256,37.75)
21842	2034	(29.578838324886476,38.5)
21843	2065	(22.217622392718749,39.25)
21844	549	(25.681724007856502,10.75)
21845	549	(25.681724007856502,10.75)
21846	549	(25.681724007856502,10.75)
21847	1359	(34.341978045700891,25.75)
21848	1359	(34.341978045700891,25.75)
21849	1359	(34.341978045700891,25.75)
21850	1359	(34.341978045700891,25.75)
21851	270	(26.114736709748719,5.5)
21852	473	(29.145825622994256,9.25)
21853	596	(31.310889132455351,11.5)
21854	554	(30.011851026778693,10.75)
21855	33	(28.712812921102035,1)
21856	275	(30.444863728670914,5.5)
21857	275	(30.444863728670914,5.5)
21858	275	(30.444863728670914,5.5)
21859	275	(30.444863728670914,5.5)
21860	275	(30.444863728670914,5.5)
21861	275	(30.444863728670914,5.5)
21862	275	(30.444863728670914,5.5)
21863	275	(30.444863728670914,5.5)
21864	70	(26.54774941164094,1.75)
21865	1432	(28.279800219209818,27.25)
21866	1432	(28.279800219209818,27.25)
21867	1470	(26.114736709748719,28)
21868	1469	(25.248711305964282,28)
21869	423	(20.05255888325765,8.5)
21870	423	(20.05255888325765,8.5)
21871	461	(18.753520777580992,9.25)
21872	461	(18.753520777580992,9.25)
21873	505	(21.784609690826528,10)
21874	505	(21.784609690826528,10)
21875	1298	(15.722431864335457,25)
21876	1298	(15.722431864335457,25)
21877	1306	(22.650635094610966,25)
21878	1306	(22.650635094610966,25)
21879	1306	(22.650635094610966,25)
21880	1306	(22.650635094610966,25)
21881	1147	(23.516660498395403,22)
21882	905	(21.784609690826528,17.5)
21883	1108	(24.815698604072061,21.25)
21884	1098	(16.155444566227676,21.25)
21885	1098	(16.155444566227676,21.25)
21886	941	(18.753520777580992,18.25)
21887	772	(10.959292143521045,15.25)
21888	974	(12.258330249197702,19)
21889	21	(18.320508075688775,1)
21890	175	(13.124355652982141,4)
21891	175	(13.124355652982141,4)
21892	21	(18.320508075688775,1)
21893	13	(11.392304845413264,1)
21894	13	(11.392304845413264,1)
21895	1591	(27.413774815425377,30.25)
21896	1669	(25.681724007856502,31.75)
21897	1670	(26.54774941164094,31.75)
21898	1627	(23.516660498395403,31)
21899	1544	(20.918584287042091,29.5)
21900	1584	(21.351596988934308,30.25)
21901	1626	(22.650635094610966,31)
21902	1652	(10.959292143521045,31.75)
21903	2033	(28.712812921102035,38.5)
21904	1652	(10.959292143521045,31.75)
21905	1691	(9.6602540378443873,32.5)
21906	1691	(9.6602540378443873,32.5)
21907	1691	(9.6602540378443873,32.5)
21908	1690	(8.794228634059948,32.5)
21909	2033	(28.712812921102035,38.5)
21910	1689	(7.9282032302755088,32.5)
21911	1537	(14.856406460551018,29.5)
21912	1578	(16.155444566227676,30.25)
21913	1618	(15.722431864335457,31)
21914	1192	(28.279800219209818,22.75)
21915	1152	(27.846787517317598,22)
21916	1219	(16.588457268119896,23.5)
21917	1154	(29.578838324886476,22)
21918	1154	(29.578838324886476,22)
21919	1620	(17.454482671904334,31)
21920	1899	(17.021469970012117,36.25)
21921	1695	(13.124355652982141,32.5)
21922	1779	(16.588457268119896,34)
21923	1821	(18.753520777580992,34.75)
21924	2133	(11.825317547305483,40.75)
21925	1924	(3.598076211353316,37)
21926	2008	(7.0621778264910704,38.5)
21927	1924	(3.598076211353316,37)
21928	1968	(7.49519052838329,37.75)
21929	2134	(12.691342951089922,40.75)
21930	2134	(12.691342951089922,40.75)
21931	1889	(8.3612159321677293,36.25)
21932	1981	(18.753520777580992,37.75)
21933	1817	(15.289419162443238,34.75)
21934	1813	(11.825317547305483,34.75)
21935	2007	(6.196152422706632,38.5)
21936	2212	(10.959292143521045,42.25)
21937	2002	(1.8660254037844386,38.5)
21938	2001	(1,38.5)
21939	1968	(7.49519052838329,37.75)
21940	1930	(8.794228634059948,37)
21941	1854	(12.258330249197702,35.5)
21942	2348	(24.382685902179844,44.5)
21943	2388	(24.815698604072061,45.25)
21944	2134	(12.691342951089922,40.75)
21945	2214	(12.691342951089922,42.25)
21946	2126	(5.7631397208144124,40.75)
21947	2388	(24.815698604072061,45.25)
21948	2386	(23.083647796503186,45.25)
21949	2286	(5.7631397208144124,43.75)
21950	2345	(21.784609690826528,44.5)
21951	2306	(23.083647796503186,43.75)
21952	2385	(22.217622392718749,45.25)
21953	2388	(24.815698604072061,45.25)
21954	2300	(17.887495373796554,43.75)
21955	2300	(17.887495373796554,43.75)
21956	2339	(16.588457268119896,44.5)
21957	2244	(3.598076211353316,43)
21958	2281	(1.4330127018922194,43.75)
21959	2281	(1.4330127018922194,43.75)
21960	2281	(1.4330127018922194,43.75)
21961	2241	(1,43)
21962	152	(28.279800219209818,3.25)
21963	271	(26.98076211353316,5.5)
21964	234	(30.011851026778693,4.75)
21965	234	(30.011851026778693,4.75)
21966	234	(30.011851026778693,4.75)
21967	234	(30.011851026778693,4.75)
21968	234	(30.011851026778693,4.75)
21969	275	(30.444863728670914,5.5)
21970	275	(30.444863728670914,5.5)
21971	391	(27.413774815425377,7.75)
21972	393	(29.145825622994256,7.75)
21973	393	(29.145825622994256,7.75)
21974	393	(29.145825622994256,7.75)
21975	440	(34.774990747593108,8.5)
21976	2281	(1.4330127018922194,43.75)
21977	2281	(1.4330127018922194,43.75)
21978	586	(22.650635094610966,11.5)
21979	586	(22.650635094610966,11.5)
21980	625	(22.217622392718749,12.25)
21981	701	(18.753520777580992,13.75)
21982	664	(20.918584287042091,13)
21983	664	(20.918584287042091,13)
21984	663	(20.05255888325765,13)
21985	663	(20.05255888325765,13)
21986	617	(15.289419162443238,12.25)
21987	617	(15.289419162443238,12.25)
21988	617	(15.289419162443238,12.25)
21989	111	(26.98076211353316,2.5)
21990	589	(25.248711305964282,11.5)
21991	275	(30.444863728670914,5.5)
21992	275	(30.444863728670914,5.5)
21993	275	(30.444863728670914,5.5)
21994	155	(30.877876430563134,3.25)
21995	155	(30.877876430563134,3.25)
21996	275	(30.444863728670914,5.5)
21997	275	(30.444863728670914,5.5)
21998	275	(30.444863728670914,5.5)
21999	589	(25.248711305964282,11.5)
22000	669	(25.248711305964282,13)
22001	669	(25.248711305964282,13)
22002	669	(25.248711305964282,13)
22003	461	(18.753520777580992,9.25)
22004	461	(18.753520777580992,9.25)
22005	543	(20.48557158514987,10.75)
22006	505	(21.784609690826528,10)
22007	669	(25.248711305964282,13)
22008	589	(25.248711305964282,11.5)
22009	840	(34.774990747593108,16)
22010	840	(34.774990747593108,16)
22011	800	(35.208003449485325,15.25)
22012	37	(32.176914536239792,1)
22013	37	(32.176914536239792,1)
22014	37	(32.176914536239792,1)
22015	37	(32.176914536239792,1)
22016	2200	(34.774990747593108,41.5)
22017	2399	(34.341978045700891,45.25)
22018	2400	(35.208003449485325,45.25)
22019	2187	(23.516660498395403,41.5)
22020	1480	(34.774990747593108,28)
22021	788	(24.815698604072061,15.25)
22022	748	(24.382685902179844,14.5)
22023	1160	(34.774990747593108,22)
22024	1160	(34.774990747593108,22)
22025	1160	(34.774990747593108,22)
22026	1160	(34.774990747593108,22)
22027	2317	(32.609927238132009,43.75)
22028	2269	(25.248711305964282,43)
22029	2358	(33.042939940024233,44.5)
22030	1356	(31.743901834347572,25.75)
22031	2185	(21.784609690826528,41.5)
22032	2394	(30.011851026778693,45.25)
22033	2392	(28.279800219209818,45.25)
22034	2392	(28.279800219209818,45.25)
22035	2352	(27.846787517317598,44.5)
22036	1902	(19.619546181365433,36.25)
22037	2396	(31.743901834347572,45.25)
22038	2279	(33.908965343808667,43)
22039	2279	(33.908965343808667,43)
22040	2396	(31.743901834347572,45.25)
22041	2194	(29.578838324886476,41.5)
22042	2156	(31.743901834347572,40.75)
22043	2040	(34.774990747593108,38.5)
22044	2157	(32.609927238132009,40.75)
22045	2156	(31.743901834347572,40.75)
22046	2194	(29.578838324886476,41.5)
22047	2159	(34.341978045700891,40.75)
22048	37	(32.176914536239792,1)
22049	37	(32.176914536239792,1)
22050	37	(32.176914536239792,1)
22051	37	(32.176914536239792,1)
22052	37	(32.176914536239792,1)
22053	240	(35.208003449485325,4.75)
22054	240	(35.208003449485325,4.75)
22055	240	(35.208003449485325,4.75)
22056	37	(32.176914536239792,1)
22057	240	(35.208003449485325,4.75)
22058	240	(35.208003449485325,4.75)
22059	240	(35.208003449485325,4.75)
22060	240	(35.208003449485325,4.75)
22061	240	(35.208003449485325,4.75)
22062	240	(35.208003449485325,4.75)
22063	395	(30.877876430563134,7.75)
22064	275	(30.444863728670914,5.5)
22065	275	(30.444863728670914,5.5)
22066	275	(30.444863728670914,5.5)
22067	152	(28.279800219209818,3.25)
22068	152	(28.279800219209818,3.25)
22069	152	(28.279800219209818,3.25)
22070	719	(34.341978045700891,13.75)
22071	719	(34.341978045700891,13.75)
22072	720	(35.208003449485325,13.75)
22073	1051	(9.6602540378443873,20.5)
22074	850	(9.2272413359521668,16.75)
22075	1204	(3.598076211353316,23.5)
22076	1204	(3.598076211353316,23.5)
22077	1046	(5.3301270189221936,20.5)
22078	1869	(25.248711305964282,35.5)
22079	782	(19.619546181365433,15.25)
22080	819	(16.588457268119896,16)
22081	1822	(19.619546181365433,34.75)
22082	2178	(15.722431864335457,41.5)
22083	2098	(15.722431864335457,40)
22084	2178	(15.722431864335457,41.5)
22085	2139	(17.021469970012117,40.75)
22086	1821	(18.753520777580992,34.75)
22087	1821	(18.753520777580992,34.75)
22088	1821	(18.753520777580992,34.75)
22089	2178	(15.722431864335457,41.5)
22090	2292	(10.959292143521045,43.75)
22091	2041	(1.4330127018922194,39.25)
22092	2002	(1.8660254037844386,38.5)
22093	1277	(32.609927238132009,24.25)
22094	1476	(31.310889132455351,28)
22095	1753	(29.145825622994256,33.25)
22096	1715	(30.444863728670914,32.5)
22097	1676	(31.743901834347572,31.75)
22098	1717	(32.176914536239792,32.5)
22099	1718	(33.042939940024233,32.5)
22100	1759	(34.341978045700891,33.25)
22101	1760	(35.208003449485325,33.25)
22102	1680	(35.208003449485325,31.75)
22103	127	(6.6291651245988508,3.25)
22104	88	(7.0621778264910704,2.5)
22105	88	(7.0621778264910704,2.5)
22106	88	(7.0621778264910704,2.5)
22107	88	(7.0621778264910704,2.5)
22108	88	(7.0621778264910704,2.5)
22109	839	(33.908965343808667,16)
22110	839	(33.908965343808667,16)
22111	839	(33.908965343808667,16)
22112	840	(34.774990747593108,16)
22113	800	(35.208003449485325,15.25)
22114	800	(35.208003449485325,15.25)
22115	1480	(34.774990747593108,28)
22116	1480	(34.774990747593108,28)
22117	1240	(34.774990747593108,23.5)
22118	1240	(34.774990747593108,23.5)
22119	1597	(32.609927238132009,30.25)
22120	1600	(35.208003449485325,30.25)
22121	1600	(35.208003449485325,30.25)
22122	1600	(35.208003449485325,30.25)
22123	1834	(30.011851026778693,34.75)
22124	1834	(30.011851026778693,34.75)
22125	1911	(27.413774815425377,36.25)
22126	1725	(4.897114317029974,33.25)
22127	1911	(27.413774815425377,36.25)
22128	1725	(4.897114317029974,33.25)
22129	1724	(4.0310889132455356,33.25)
22130	391	(27.413774815425377,7.75)
22131	391	(27.413774815425377,7.75)
22132	720	(35.208003449485325,13.75)
22133	720	(35.208003449485325,13.75)
22134	275	(30.444863728670914,5.5)
22135	275	(30.444863728670914,5.5)
22136	275	(30.444863728670914,5.5)
22137	275	(30.444863728670914,5.5)
22138	275	(30.444863728670914,5.5)
22139	275	(30.444863728670914,5.5)
22140	275	(30.444863728670914,5.5)
22141	275	(30.444863728670914,5.5)
22142	70	(26.54774941164094,1.75)
22143	1993	(29.145825622994256,37.75)
22144	1993	(29.145825622994256,37.75)
22145	1993	(29.145825622994256,37.75)
22146	1652	(10.959292143521045,31.75)
22147	1920	(35.208003449485325,36.25)
22148	13	(11.392304845413264,1)
22149	13	(11.392304845413264,1)
22150	175	(13.124355652982141,4)
22151	296	(14.423393758658799,6.25)
22152	336	(13.99038105676658,7)
22153	336	(13.99038105676658,7)
22154	954	(30.011851026778693,18.25)
22155	954	(30.011851026778693,18.25)
22156	993	(28.712812921102035,19)
22157	993	(28.712812921102035,19)
22158	954	(30.011851026778693,18.25)
22159	954	(30.011851026778693,18.25)
22160	993	(28.712812921102035,19)
22161	993	(28.712812921102035,19)
22162	1031	(27.413774815425377,19.75)
22163	1031	(27.413774815425377,19.75)
22164	990	(26.114736709748719,19)
22165	990	(26.114736709748719,19)
22166	946	(23.083647796503186,18.25)
22167	946	(23.083647796503186,18.25)
22168	946	(23.083647796503186,18.25)
22169	794	(30.011851026778693,15.25)
22170	794	(30.011851026778693,15.25)
22171	792	(28.279800219209818,15.25)
22172	792	(28.279800219209818,15.25)
22173	874	(30.011851026778693,16.75)
22174	874	(30.011851026778693,16.75)
22175	2382	(19.619546181365433,45.25)
22176	2367	(6.6291651245988508,45.25)
22177	1406	(5.7631397208144124,27.25)
22178	839	(33.908965343808667,16)
22179	839	(33.908965343808667,16)
22180	640	(35.208003449485325,12.25)
22181	640	(35.208003449485325,12.25)
22182	1517	(32.609927238132009,28.75)
22183	917	(32.176914536239792,17.5)
22184	840	(34.774990747593108,16)
22185	917	(32.176914536239792,17.5)
22186	878	(33.47595264191645,16.75)
22187	1517	(32.609927238132009,28.75)
22188	2359	(33.908965343808667,44.5)
22189	1960	(34.774990747593108,37)
22190	2196	(31.310889132455351,41.5)
22191	485	(4.4641016151377544,10)
22192	607	(6.6291651245988508,12.25)
22193	1172	(10.959292143521045,22.75)
22194	492	(10.526279441628825,10)
22195	807	(6.196152422706632,16)
22196	330	(8.794228634059948,7)
22197	211	(10.093266739736606,4.75)
22198	2312	(28.279800219209818,43.75)
22199	2154	(30.011851026778693,40.75)
22200	2194	(29.578838324886476,41.5)
22201	2233	(29.145825622994256,42.25)
22202	2377	(15.289419162443238,45.25)
22203	2111	(26.98076211353316,40)
22204	2371	(10.093266739736606,45.25)
22205	2371	(10.093266739736606,45.25)
22206	1786	(22.650635094610966,34)
22207	1620	(17.454482671904334,31)
22208	2370	(9.2272413359521668,45.25)
22209	1726	(5.7631397208144124,33.25)
22210	2397	(32.609927238132009,45.25)
22211	2397	(32.609927238132009,45.25)
22212	326	(5.3301270189221936,7)
22213	365	(4.897114317029974,7.75)
22214	326	(5.3301270189221936,7)
22215	327	(6.196152422706632,7)
22216	2400	(35.208003449485325,45.25)
22217	2279	(33.908965343808667,43)
22218	1980	(17.887495373796554,37.75)
22219	1776	(13.99038105676658,34)
22220	1981	(18.753520777580992,37.75)
22221	1776	(13.99038105676658,34)
22222	1981	(18.753520777580992,37.75)
22223	1981	(18.753520777580992,37.75)
22224	1818	(16.155444566227676,34.75)
22225	1855	(13.124355652982141,35.5)
22226	1968	(7.49519052838329,37.75)
22227	2281	(1.4330127018922194,43.75)
22228	2281	(1.4330127018922194,43.75)
22229	2241	(1,43)
22230	2283	(3.1650635094610968,43.75)
22231	1779	(16.588457268119896,34)
22232	1776	(13.99038105676658,34)
22233	2279	(33.908965343808667,43)
22234	1454	(12.258330249197702,28)
22235	1050	(8.794228634059948,20.5)
22236	1323	(3.1650635094610968,25.75)
22237	1282	(1.8660254037844386,25)
22238	1282	(1.8660254037844386,25)
22239	1282	(1.8660254037844386,25)
22240	1326	(5.7631397208144124,25.75)
22241	1326	(5.7631397208144124,25.75)
22242	1321	(1.4330127018922194,25.75)
22243	1321	(1.4330127018922194,25.75)
22244	1321	(1.4330127018922194,25.75)
22245	1321	(1.4330127018922194,25.75)
22246	1281	(1,25)
22247	1121	(1,22)
22248	936	(14.423393758658799,18.25)
22249	1055	(13.124355652982141,20.5)
22250	1055	(13.124355652982141,20.5)
22251	1054	(12.258330249197702,20.5)
22252	895	(13.124355652982141,17.5)
22253	1094	(12.691342951089922,21.25)
22254	613	(11.825317547305483,12.25)
22255	1121	(1,22)
22256	1121	(1,22)
22257	1592	(28.279800219209818,30.25)
22258	1591	(27.413774815425377,30.25)
22259	1709	(25.248711305964282,32.5)
22260	1706	(22.650635094610966,32.5)
22261	1955	(30.444863728670914,37)
22262	2071	(27.413774815425377,39.25)
22263	2112	(27.846787517317598,40)
22264	2106	(22.650635094610966,40)
22265	570	(8.794228634059948,11.5)
22266	1521	(1,29.5)
22267	2159	(34.341978045700891,40.75)
22268	1023	(20.48557158514987,19.75)
22269	1023	(20.48557158514987,19.75)
22270	58	(16.155444566227676,1.75)
22271	1306	(22.650635094610966,25)
22272	2159	(34.341978045700891,40.75)
22273	1946	(22.650635094610966,37)
22274	60	(17.887495373796554,1.75)
22275	18	(15.722431864335457,1)
22276	58	(16.155444566227676,1.75)
22277	179	(16.588457268119896,4)
22278	10	(8.794228634059948,1)
22279	11	(9.6602540378443873,1)
22280	2026	(22.650635094610966,38.5)
22281	2040	(34.774990747593108,38.5)
22282	2040	(34.774990747593108,38.5)
22283	2040	(34.774990747593108,38.5)
22284	2116	(31.310889132455351,40)
22285	1342	(19.619546181365433,25.75)
22286	2155	(30.877876430563134,40.75)
22287	2194	(29.578838324886476,41.5)
22288	1390	(26.114736709748719,26.5)
22289	1350	(26.54774941164094,25.75)
22290	1508	(24.815698604072061,28.75)
22291	1508	(24.815698604072061,28.75)
22292	1306	(22.650635094610966,25)
22293	1424	(21.351596988934308,27.25)
22294	1424	(21.351596988934308,27.25)
22295	1584	(21.351596988934308,30.25)
22296	1584	(21.351596988934308,30.25)
22297	586	(22.650635094610966,11.5)
22298	626	(23.083647796503186,12.25)
22299	662	(19.186533479473212,13)
22300	579	(16.588457268119896,11.5)
22301	617	(15.289419162443238,12.25)
22302	617	(15.289419162443238,12.25)
22303	1112	(28.279800219209818,21.25)
22304	1152	(27.846787517317598,22)
22305	1112	(28.279800219209818,21.25)
22306	1111	(27.413774815425377,21.25)
22307	1219	(16.588457268119896,23.5)
22308	1259	(17.021469970012117,24.25)
22309	1220	(17.454482671904334,23.5)
22310	1220	(17.454482671904334,23.5)
22311	1106	(23.083647796503186,21.25)
22312	1103	(20.48557158514987,21.25)
22313	1023	(20.48557158514987,19.75)
22314	466	(23.083647796503186,9.25)
22315	423	(20.05255888325765,8.5)
22316	505	(21.784609690826528,10)
22317	505	(21.784609690826528,10)
22318	511	(26.98076211353316,10)
22319	398	(33.47595264191645,7.75)
22320	306	(23.083647796503186,6.25)
22321	398	(33.47595264191645,7.75)
22322	398	(33.47595264191645,7.75)
22323	397	(32.609927238132009,7.75)
22324	399	(34.341978045700891,7.75)
22325	399	(34.341978045700891,7.75)
22326	360	(34.774990747593108,7)
22327	158	(33.47595264191645,3.25)
22328	158	(33.47595264191645,3.25)
22329	560	(35.208003449485325,10.75)
22330	344	(20.918584287042091,7)
22331	344	(20.918584287042091,7)
22332	1476	(31.310889132455351,28)
22333	1753	(29.145825622994256,33.25)
22334	1715	(30.444863728670914,32.5)
22335	1676	(31.743901834347572,31.75)
22336	1717	(32.176914536239792,32.5)
22337	1718	(33.042939940024233,32.5)
22338	1680	(35.208003449485325,31.75)
22339	511	(26.98076211353316,10)
22340	398	(33.47595264191645,7.75)
22341	398	(33.47595264191645,7.75)
22342	398	(33.47595264191645,7.75)
22343	398	(33.47595264191645,7.75)
22344	360	(34.774990747593108,7)
22345	360	(34.774990747593108,7)
22346	360	(34.774990747593108,7)
22347	360	(34.774990747593108,7)
22348	360	(34.774990747593108,7)
22349	511	(26.98076211353316,10)
22350	398	(33.47595264191645,7.75)
22351	398	(33.47595264191645,7.75)
22352	398	(33.47595264191645,7.75)
22353	398	(33.47595264191645,7.75)
22354	360	(34.774990747593108,7)
22355	360	(34.774990747593108,7)
22356	360	(34.774990747593108,7)
22357	2348	(24.382685902179844,44.5)
22358	2386	(23.083647796503186,45.25)
22359	2306	(23.083647796503186,43.75)
22360	1695	(13.124355652982141,32.5)
22361	1694	(12.258330249197702,32.5)
22362	1776	(13.99038105676658,34)
22363	1779	(16.588457268119896,34)
22364	1779	(16.588457268119896,34)
22365	1820	(17.887495373796554,34.75)
22366	1892	(10.959292143521045,36.25)
22367	1892	(10.959292143521045,36.25)
22368	1968	(7.49519052838329,37.75)
22369	2009	(7.9282032302755088,38.5)
22370	1969	(8.3612159321677293,37.75)
22371	1851	(9.6602540378443873,35.5)
22372	1961	(1.4330127018922194,37.75)
22373	1968	(7.49519052838329,37.75)
22374	2214	(12.691342951089922,42.25)
22375	2170	(8.794228634059948,41.5)
22376	2207	(6.6291651245988508,42.25)
22377	2121	(1.4330127018922194,40.75)
22378	1822	(19.619546181365433,34.75)
22379	1695	(13.124355652982141,32.5)
22380	1925	(4.4641016151377544,37)
22381	792	(28.279800219209818,15.25)
22382	792	(28.279800219209818,15.25)
22383	1584	(21.351596988934308,30.25)
22384	1584	(21.351596988934308,30.25)
22385	2202	(2.299038105676658,42.25)
22386	2202	(2.299038105676658,42.25)
22387	1620	(17.454482671904334,31)
22388	1618	(15.722431864335457,31)
22389	1620	(17.454482671904334,31)
22390	662	(19.186533479473212,13)
22391	617	(15.289419162443238,12.25)
22392	586	(22.650635094610966,11.5)
22393	1302	(19.186533479473212,25)
22394	1266	(23.083647796503186,24.25)
22395	1265	(22.217622392718749,24.25)
22396	1266	(23.083647796503186,24.25)
22397	1265	(22.217622392718749,24.25)
22398	617	(15.289419162443238,12.25)
22399	1237	(32.176914536239792,23.5)
22400	1237	(32.176914536239792,23.5)
22401	1318	(33.042939940024233,25)
22402	1359	(34.341978045700891,25.75)
22403	1439	(34.341978045700891,27.25)
22404	127	(6.6291651245988508,3.25)
22405	126	(5.7631397208144124,3.25)
22406	126	(5.7631397208144124,3.25)
22407	165	(4.4641016151377544,4)
22408	165	(4.4641016151377544,4)
22409	126	(5.7631397208144124,3.25)
22410	244	(3.598076211353316,5.5)
22411	121	(1.4330127018922194,3.25)
22412	121	(1.4330127018922194,3.25)
22413	121	(1.4330127018922194,3.25)
22414	121	(1.4330127018922194,3.25)
22415	363	(3.1650635094610968,7.75)
22416	1329	(8.3612159321677293,25.75)
22417	1328	(7.49519052838329,25.75)
22418	1869	(25.248711305964282,35.5)
22419	1865	(21.784609690826528,35.5)
22420	1683	(2.7320508075688772,32.5)
22421	1724	(4.0310889132455356,33.25)
22422	2366	(5.7631397208144124,45.25)
22423	2385	(22.217622392718749,45.25)
22424	2384	(21.351596988934308,45.25)
22425	2386	(23.083647796503186,45.25)
22426	2385	(22.217622392718749,45.25)
22427	2384	(21.351596988934308,45.25)
22428	2279	(33.908965343808667,43)
22429	2368	(7.49519052838329,45.25)
22430	2368	(7.49519052838329,45.25)
22431	2300	(17.887495373796554,43.75)
22432	2364	(4.0310889132455356,45.25)
22433	655	(13.124355652982141,13)
22434	2063	(20.48557158514987,39.25)
22435	2376	(14.423393758658799,45.25)
22436	2377	(15.289419162443238,45.25)
22437	2400	(35.208003449485325,45.25)
22438	2200	(34.774990747593108,41.5)
22439	1869	(25.248711305964282,35.5)
22440	2399	(34.341978045700891,45.25)
22441	1869	(25.248711305964282,35.5)
22442	628	(24.815698604072061,12.25)
22443	957	(32.609927238132009,18.25)
22444	957	(32.609927238132009,18.25)
22445	2317	(32.609927238132009,43.75)
22446	2269	(25.248711305964282,43)
22447	2358	(33.042939940024233,44.5)
22448	1356	(31.743901834347572,25.75)
22449	1240	(34.774990747593108,23.5)
22450	1240	(34.774990747593108,23.5)
22451	1360	(35.208003449485325,25.75)
22452	1597	(32.609927238132009,30.25)
22453	1600	(35.208003449485325,30.25)
22454	2200	(34.774990747593108,41.5)
22455	1765	(4.4641016151377544,34)
22456	1765	(4.4641016151377544,34)
22457	1946	(22.650635094610966,37)
22458	1946	(22.650635094610966,37)
22459	754	(29.578838324886476,14.5)
22460	18	(15.722431864335457,1)
22461	133	(11.825317547305483,3.25)
22462	1946	(22.650635094610966,37)
22463	2233	(29.145825622994256,42.25)
22464	2370	(9.2272413359521668,45.25)
22465	2370	(9.2272413359521668,45.25)
22466	1267	(23.949673200287624,24.25)
22467	1267	(23.949673200287624,24.25)
22468	320	(35.208003449485325,6.25)
22469	319	(34.341978045700891,6.25)
22470	320	(35.208003449485325,6.25)
22471	320	(35.208003449485325,6.25)
22472	1253	(11.825317547305483,24.25)
22473	398	(33.47595264191645,7.75)
22474	397	(32.609927238132009,7.75)
22475	399	(34.341978045700891,7.75)
22476	399	(34.341978045700891,7.75)
22477	360	(34.774990747593108,7)
22478	360	(34.774990747593108,7)
22479	320	(35.208003449485325,6.25)
22480	2279	(33.908965343808667,43)
22481	230	(26.54774941164094,4.75)
22482	672	(27.846787517317598,13)
22483	437	(32.176914536239792,8.5)
22484	360	(34.774990747593108,7)
22485	671	(26.98076211353316,13)
22486	711	(27.413774815425377,13.75)
22487	360	(34.774990747593108,7)
22488	320	(35.208003449485325,6.25)
22489	320	(35.208003449485325,6.25)
22490	320	(35.208003449485325,6.25)
22491	1237	(32.176914536239792,23.5)
22492	1359	(34.341978045700891,25.75)
22493	