#modname "Endgame Diversity Mod v1.21"
#version 1.21
#description "Adds a range of powerful summons, to increase the diversity of the endgame."
#domversion 3.21
#icon "diversity/diversityBanner.tga"

-- Spell list:

-name "Quest for the Firebird" - F4, Conjuration 6, 20 gems
-name "Summon Zmey" - F4, Conjuration 6, 35 gems
-name "Awaken Ember Lord" - F6, Conjuration 9, 60 gems
-name "Summon Shishis" - A4 - Conjuration 6, 30 gems
-name "Summon Roc" - A4 - Conjuration 6, 18 gems
-name "Awaken Aesir" - A5 - Conjuration 8, 35 gems
-name "Mechanical Giant" - E5 - Construction 7, 16 gems
-name "Awaken Cyclops" - E5 - Conjuration 8, 30 gems
-name "Great Kraken" - W4 - Enchantment 6, 30 gems
-name "Call Grendelkin" - W3E3 - Enchantment 8, 40 gems
-name "Curse of the Wendigo" - W3D3 - Thaumaturgy 6, 24 gems
-name "Wild Ettin"- N3E2 - Enchantment 7, 18 gems
-name "Awaken Treant" - N5 - Enchantment 8, 40 gems

-- Start of mod --

#newweapon 900
#name "Vine whips"
#bonus
#secondaryeffect 137
#nratt 2
#flail
#len 4
#dmg 16
#nostrength
#sound 9
#end

#newweapon 901
#name "Branches"
#bonus
#len 4
#dmg 0
#att -1
#def 0
#end

#newweapon 902
#name "Flaming Whip"
#len 4
#dmg 2
#secondaryeffect 221 -- Fire, damage 12
#att -2
#def 0
#end

#newweapon 903
#name "Flaming Maw" -- For Ember Lord
#bonus
#len 2
#dmg 6
#secondaryeffectalways 171 -- Small Area Fire
#att -1
#def 0
#end

#newweapon 904
#name "Bites" -- For a three headed zmey
#nratt 3
#len 4
#dmg 2
#att 1
#end

#newweapon 905
#name "Bites" -- For a two headed zmey
#nratt 2
#len 4
#dmg 2
#att 1
#end

#newweapon 906
#name "Bite" -- For a one headed zmey
#len 4
#dmg 2
#att 2
#end

#newweapon 907
#name "Fire Breath" -- Area 3, for a 3-headed zmey
#aoe 3
#fire
#dmg 14
#armorpiercing
#nostr
#explspr 10113
#sound 16
#end

#newweapon 908
#name "Fire Breath" -- Area 2, for a 2-headed zmey
#aoe 2
#fire
#dmg 14
#armorpiercing
#nostr
#explspr 10113
#sound 16
#end

#newweapon 909
#name "Fire Breath" -- Area 1, for a 1-headed zmey
#aoe 1
#fire
#dmg 14
#armorpiercing
#nostr
#explspr 10113
#sound 16
#end

#newweapon 913
#name "Smite Evil"
#dt_holy
#nostr
#dmg 10
#armorpiercing
#end

#newweapon 911
#name "Female Shishi Bite"
#magic
#dmg 2
#def 0
#secondaryeffect 913
#end

#newweapon 912
#name "Male Shishi Bite"
#magic
#dmg 2
#def 0
#end

#newweapon 910
#name "Shishi Claws"
#dt_demon
#magic
#nratt 2
#end

#newweapon 915
#name "Tail" -- For Zmey.
#len 5
#att -2
#dmg 0
#def 2
#bonus
#end

#newweapon 916
#name "Roc Beak"
#len 0
#att 0
#dmg 0
#def -1
#armorpiercing
#end

#newweapon 772
#name "Aerial Dive"
#ammo 1 -- Single-use only
#dmg 20
#len 0
#aoe 1
#dt_normal
#armorpiercing
#secondaryeffect 916
#end

#newarmor 266
#name "Weightless Shield" -- for Asynja
#type 4
#prot 18
#def 7
#enc 0
#end

#newmonster 2908
#clearstats
#name "Roc"
#spr1 "./diversity/roc.tga"
#spr2 "./diversity/roc_att.tga"
#descr "The roc is a snow-white bird of extraordinary size and power, with a wingspan large enough to blot out the sun.
Rocs live for thousands of years, and over time their great intelligence allows them to master the magics of the sky. They
are powerful flyers, able to cover vast distances and to fly even in the midst of a storm. The roc attacks enemies by
diving on them from a great height, with all its strength, speed and magic focused in a single killing blow that few enemies
can survive. Such is the size and ferocity of these birds that only the bravest of those surviving the roc's dive are able to
stand to fight against them."
#copystats 421
#name "Roc"
#gcost 0
#coldres 50
#shockres 0 -- Reset shock resistance to zero.
#shockres 100
#size 6
#mor 30
#mr 18
#hp 80
#att 15
#def 15
#enc 2
#ap 10
#mapmove 5
#str 25
#prec 16
#prot 12
#poorleader
#flying
#patrolbonus 60
#siegebonus 40
#magicskill 1 2
#custommagic 256 10 -- 10% chance of an extra pick in air
#fear 0
#itemslots 28800
#weapon "Aerial Dive"
#weapon "Roc Beak"
#weapon "Claw"
#weapon "Claw"
#armor "Nothing"
#startage 1000
#maxage 2000
#nametype 100
#end

#newmonster 2857
#clearstats
#name "Grendelkin"
#spr1 "./diversity/grendelkin.tga"
#spr2 "./diversity/grendelkin_att.tga"
#descr "The grendelkin are ancient and reclusive monsters, all born from the same mother, and descended ultimately from a twisted line of the Avvim. The mightiest of them was Grendel himself, who terrorised the kingdoms of man for many years. Eventually both Grendel and his mother were slain by a great hero, leaving the remaining grendelkin, the last of their kind, to scatter and hide in the dark places of the world. Most live in deep watery caves far from the dangers of the surface. The grendelkin are colossal and immensely powerful creatures, with scaly skin so tough that they are said to be impossible to injure with mundane weapons."
#gcost 0
#size 6
#mor 30
#mr 18
#hp 240
#att 12
#def 12
#enc 2
#ap 14
#mapmove 2
#str 38
#prec 8
#prot 22
#darkvision 75
#startage 1705
#maxage 3000
#noleader
#fear 5
#swampsurvival
#itemslots 15495
#weapon "Claw"
#weapon "Claw"
#armor "None"
#nametype 100
#end

#newmonster 2858
#clearstats
#name "Treant"
#descr "Treants appear at first sight to be nothing more than ancient and large trees. However, when their forests are
threatened they pull their roots from the ground and move to fight intruders, tearing them apart with claw-like branches
and binding and stinging them with whipping vines. While rooted treants are more powerful and can draw nourishment from
the earth. So long as they remain in forests treants are hard to detect, move more quickly and are somewhat stronger.
The origins of treants are unknown, even to
themselves. Some believe that they are simply truly ancient trees that have grown in a region of magical flux and have
gradually gained intelligence over the centuries. Others argue that they were created by the Pantokrator as guardians
and rulers of the forests."
#spr1 "./diversity/treant.tga"
#spr2 "./diversity/treant_att.tga"
#gcost 0
#size 6
#hp 160
#prot 16
#str 25
#fireres -50
#poisonres 100
#entangle
#darkvision 50
#forestsurvival
#animalawe 5
#enc 1
#ap 6
#mapmove 1
#att 14
#def 8
#mr 18
#mor 30
#prec 10
#startage 1200
#maxage 2000
#itemslots 28678
#weapon "Claw"
#weapon "Claw"
#weapon "Branches"
#weapon "Vine whips"
#shapechange 2867
#magicskill 6 2
#custommagic 9728 100 -- WEN
#custommagic 9728 20 -- WEN
#nametype 145 -- Treeman names
#forestshape 2859
#end

#newmonster 2859 -- Treant in a forest
#copystats 2858
#copyspr 2858
#descr "Treants appear at first sight to be nothing more than ancient and large trees. However, when their forests are
threatened they pull their roots from the ground and move to fight intruders, tearing them apart with claw-like branches
and binding and stinging them with whipping vines. While rooted treants are more powerful and can draw nourishment from
the earth. So long as they remain in forests treants are hard to detect, move more quickly and are somewhat stronger.
The origins of treants are unknown, even to
themselves. Some believe that they are simply truly ancient trees that have grown in a region of magical flux and have
gradually gained intelligence over the centuries. Others argue that they were created by the Pantokrator as guardians
and rulers of the forests."
#plainshape 2858
#shapechange 2868
#stealthy 15
#hp 180
#str 28
#mapmove 2
#ap 8
#end

#newmonster 2867
#copystats 2858
#name "Rooted Treant"
#spr1 "./diversity/treant_rooted.tga"
#spr2 "./diversity/treant_rooted_att.tga"
#descr "Treants appear at first sight to be nothing more than ancient and large trees. However, when their forests are
threatened they pull their roots from the ground and move to fight intruders, tearing them apart with claw-like branches
and binding and stinging them with whipping vines. While rooted treants are more powerful and can draw nourishment from
the earth. So long as they remain in forests treants are hard to detect, move more quickly and are somewhat stronger.
The origins of treants are unknown, even to
themselves. Some believe that they are simply truly ancient trees that have grown in a region of magical flux and have
gradually gained intelligence over the centuries. Others argue that they were created by the Pantokrator as guardians
and rulers of the forests."
#hp 200
#prot 20
#str 30
#regeneration 2
#reinvigoration 2
#def 4
#mapmove 0
#ap 4
#shapechange 2858
#forestshape 2868
#magicboost 57 1
#end

#newmonster 2868 -- Rooted treant in a forest
#copystats 2867
#copyspr 2867
#descr "Treants appear at first sight to be nothing more than ancient and large trees. However, when their forests are
threatened they pull their roots from the ground and move to fight intruders, tearing them apart with claw-like branches
and binding and stinging them with whipping vines. While rooted treants are more powerful and can draw nourishment from
the earth. So long as they remain in forests treants are hard to detect, move more quickly and are somewhat stronger.
The origins of treants are unknown, even to
themselves. Some believe that they are simply truly ancient trees that have grown in a region of magical flux and have
gradually gained intelligence over the centuries. Others argue that they were created by the Pantokrator as guardians
and rulers of the forests."
#plainshape 2867
#shapechange 2859
#stealth 25
#hp 220
#str 32
#regeneration 3
#reinvigoration 6
#ap 4
#end

#newmonster 2869
#copystats 1339 -- Lord of Plenty
#restrictedgod 23 -- Set as the god of a nonexistent nation
#clearmagic
#gemprod 3 0
#gemprod 4 0
#name "True Firebird"
#spr1 "./diversity/firebird.tga"
#spr2 "./diversity/firebird_att.tga"
#descr "The True Firebird (as contrasted with the lesser firebirds of Rus) is an elusive and mysterious creature, and countless heroes have set out on quests to find it. Its plumage glows with such extraordinary intensity that a single feather is said to be able to brightly illuminate a large hall. In battle it will glow more brightly still, threatening the eyesight of all present. The Firebird is also a bringer of great good fortune. Many good events will happen in its presence, and misfortune will be very rare. Although it is a creature of little more than animal intelligence, the Firebird has a great affinity for magic, and is able to command the element of fire."
#gcost 0
#hp 18
#prot 3
#mr 18
#mor 30
#enc 2
#str 8
#att 9
#def 14
#prec 15
#fireshield 6
#speciallook 1
#fireres 100
#rejuvenation
#eyeloss
#heal
#flying
#blind
#mapmove 2
#ap 6
#onebattlespell "Solar Brilliance"
#nobadevents 50
#magicskill 0 2
#armor "Nothing"
#size 3
#animal
#magicbeing
#forestsurvival
#mountainsurvival
#stealthy 25
#standard 15
#incunrest -5
#nametype 144 -- Animal?
#noleader
#weapon "Claw"
#weapon "Flame Burst"
#noitem -- 2 misc slots only
#end

#newmonster 2870
#clearstats
#name "Zmey" -- With three heads.
#descr "The Zmey is a huge and terrifying three-headed dragon, one of the most powerful beasts in existence.
Zmeys are now no more than myths to the civilized parts
of the world (although they have lent their names to the lesser drakes of Rus), and those that remain make their homes in
a distant land of volcanic jungles, where they are said to bathe in lava and to prey on even the largest of the jungle
beasts. Each of a Zmey's heads has a powerful fire breath attack as well as a vicious bite, and all three heads must be
cut off in order to kill it. However, the Zmey's heads each value their own lives, and if one is brought near to death the
dragon may choose to flee."
#spr1 "./diversity/zmey_3_0.tga"
#spr2 "./diversity/zmey_3_0_att.tga"
#gcost 0
#size 6
#hp 80
#prot 22
#str 24
#fireres 100
#poisonres 50
#mor 18
#mr 18
#fear 5
#flying
#ap 10
#enc 1
#att 18
#def 14
#noleader
#wastelandsurvival
#weapon 907 -- Triple firebreath
#weapon 904 -- Triple bite
#weapon "Claws"
#weapon 915 -- Tail
-weapon 225 -- Ranged fire breath
#custommagic 128 10 -- Rarely, they may have a little fire magic
#itemslots 29568
#secondshape 2872
#end

#newmonster 2871
#clearstats
#name "Zmey" -- With only two heads, the removed one being dried.
#descr "The Zmey is a huge and terrifying three-headed dragon. Zmeys are now no more than myths to the civilized parts
of the world (although they have lent their names to the lesser drakes of Rus), and those that remain make their homes in
a distant land of volcanic jungles, where they are said to bathe in lava and to prey on even the largest of the jungle
beasts. Each of a Zmey's heads has a powerful fire breath attack as well as a vicious bite, and all three heads must be
cut off in order to kill it. However, the Zmey's heads each value their own lives, and if one is brought near to death the
dragon may choose to flee."
#spr1 "./diversity/zmey_2_1.tga"
#spr2 "./diversity/zmey_2_1_att.tga"
#gcost 0
#size 6
#hp 80
#prot 22
#str 24
#fireres 100
#poisonres 50
#mor 18
#mr 18
#fear 5
#flying
#ap 10
#enc 1
#att 18
#def 14
#noleader
#wastelandsurvival
#weapon 908 -- Double firebreath
#weapon 905 -- Double bite
#weapon "Claws"
#weapon 915 -- Tail
-weapon 225 -- Ranged fire breath
#itemslots 29056
#secondshape 2884
#fear 2 -- Diminished fear with a head missing
#end

#newmonster 2872
#name "Zmey" -- With only two heads, the removed one being bloody.
#descr "The Zmey is a huge and terrifying three-headed dragon. Zmeys are now no more than myths to the civilized parts
of the world (although they have lent their names to the lesser drakes of Rus), and those that remain make their homes in
a distant land of volcanic jungles, where they are said to bathe in lava and to prey on even the largest of the jungle
beasts. Each of a Zmey's heads has a powerful fire breath attack as well as a vicious bite, and all three heads must be
cut off in order to kill it. However, the Zmey's heads each value their own lives, and if one is brought near to death the
dragon may choose to flee."
#spr1 "./diversity/zmey_2_0.tga"
#spr2 "./diversity/zmey_2_0_att.tga"
#copystats 2871
#hp 70
#secondshape 2885
#firstshape 2871
#end

#newmonster 2873
#name "Zmey" -- With only one head, both removed ones being dried.
#descr "The Zmey is a huge and terrifying three-headed dragon. Zmeys are now no more than myths to the civilized parts
of the world (although they have lent their names to the lesser drakes of Rus), and those that remain make their homes in
a distant land of volcanic jungles, where they are said to bathe in lava and to prey on even the largest of the jungle
beasts. Each of a Zmey's heads has a powerful fire breath attack as well as a vicious bite, and all three heads must be
cut off in order to kill it. However, the Zmey's heads each value their own lives, and if one is brought near to death the
dragon may choose to flee."
#clearstats
#spr1 "./diversity/zmey_1_2.tga"
#spr2 "./diversity/zmey_1_2_att.tga"
#gcost 0
#size 6
#hp 120
#prot 22
#str 24
#fireres 100
#poisonres 50
#mor 18
#mr 18
#fear 0 -- Diminished now it only has one head.
#flying
#ap 10
#enc 1
#att 18
#def 14
#noleader
#wastelandsurvival
#weapon 909 -- Single firebreath
#weapon 906 -- Single bite
#weapon "Claws"
#weapon 915 -- Tail
-weapon 225 -- Ranged fire breath
#itemslots 28800
#end

#newmonster 2884
#name "Zmey" -- With only one head, only one removed one being bloody.
#descr "The Zmey is a huge and terrifying three-headed dragon. Zmeys are now no more than myths to the civilized parts
of the world (although they have lent their names to the lesser drakes of Rus), and those that remain make their homes in
a distant land of volcanic jungles, where they are said to bathe in lava and to prey on even the largest of the jungle
beasts. Each of a Zmey's heads has a powerful fire breath attack as well as a vicious bite, and all three heads must be
cut off in order to kill it. However, the Zmey's heads each value their own lives, and if one is brought near to death the
dragon may choose to flee."
#spr1 "./diversity/zmey_1_1.tga"
#spr2 "./diversity/zmey_1_1_att.tga"
#copystats 2873
#hp 110
#firstshape 2873
#end

#newmonster 2885
#name "Zmey" -- With only one head, both removed ones being bloody.
#descr "The Zmey is a huge and terrifying three-headed dragon. Zmeys are now no more than myths to the civilized parts
of the world (although they have lent their names to the lesser drakes of Rus), and those that remain make their homes in
a distant land of volcanic jungles, where they are said to bathe in lava and to prey on even the largest of the jungle
beasts. Each of a Zmey's heads has a powerful fire breath attack as well as a vicious bite, and all three heads must be
cut off in order to kill it. However, the Zmey's heads each value their own lives, and if one is brought near to death the
dragon may choose to flee."
#spr1 "./diversity/zmey_1_0.tga"
#spr2 "./diversity/zmey_1_0_att.tga"
#copystats 2873
#hp 100
#firstshape 2873
#end

#newmonster 2886
#restrictedgod 23 -- Set as the god of a nonexistent nation
#name "Ember Lord"
#descr "The Ember Lords are ancient spirits, thought to be as old as the world itself, with bodies of flame and molten
rock. They live deep within the bowels of the earth, amongst magma flows and the abandoned halls of lost civilizations.
Ember Lords are masters of fire magic, and also have some skill in earth and death magics. In battle they fight with a
magical flaming whip and incinerate their enemies with the flames that pour from their mouths. Although Ember Lords have
wings they are slow flyers. If an Ember Lord's body is destroyed it will gradually reform in the burning depths over the
course of centuries."
#spr1 "./diversity/emberlord.tga"
#spr2 "./diversity/emberlord_att.tga"
#size 6
#gcost 0
#neednoteat
#fireres 100
#poisonres 100
#coldres -50
#magicbeing
#fireshield 7
#darkvision 100
#firepower 1
#heat 3
#fear 5
#startage 3500
#maxage 10000
#hp 160
#prot 10
#mr 18
#mor 30
#str 28
#att 14
#def 14
#prec 12
#enc 1
#mapmove 1
#ap 12
#magicskill 0 4 -- Fire 4
#magicskill 3 1 -- Earth 1
#magicskill 5 1 -- Death 1
#custommagic 5248 10  -- 10% FED random
#speciallook 1
#nametype 101 -- Abysian
#poorleader
#poormagicleader
#poorundeadleader
#itemslots 15494
#ambidextrous 3
#weapon "Flaming whip"
#weapon "Claw"
#weapon "Flaming Maw"
#end

#newmonster 2887
#copystats 973 -- Ancient Kraken
#restrictedgod 23 -- Set as the god of a nonexistent nation
#name "Great Kraken"
#spr1 "./diversity/kraken.tga"
#spr2 "./diversity/kraken_att.tga"
#descr "Krakens never die from old age; they just grow larger, wiser and stronger. This kraken may not yet have reached a size or power where it can
compete with gods, but nonetheless it is a mighty foe. Krakens are potent users of magic."
#hp 180 -- Decrease from the Ancient Kraken (230)
#str 20 -- Another decrease (from 23)
#enc 2 -- He's smaller, right?
#magicskill 2 2 -- W2
#magicskill 7 1 -- B1
#custommagic 512 50 -- 50% W
#custommagic 1024 50 -- 50% E
#custommagic 8192 50 -- 50% N
#startage 1700 -- Only about two thirds as old as an Ancient Kraken pretender
#end

#newmonster 2797
#clearstats
#name "Female Shishi" -- Female
#descr "The shishi is a spirit of the air, taking the form of a stone lion. While they may look ponderous to the
uninitiated, once a shishi is roused its every motion channels the nature of its element. It may run like the wind,
crossing nations in days, leaping mountains and passing through forests like a gale. In battle the shishi is like a
whirlwind, moving and striking faster than the eye can see. The Pantokrator used the shishis as guardians of his palaces,
deadly to encroaching demons, with one male and one female shishi guarding each entrance. The female shishi's responsibility was to the occupants of
the structure it guarded, and as such it is specialised at dealing with the most dangerous of intruders. The bite of the
female shishi is particularly deadly to undead and demons." 
#spr1 "./diversity/shishi_female.tga"
#spr2 "./diversity/shishi_female_att.tga"
#gcost 0
#hp 55
#size 5
#prot 20
#mor 30
#mr 16
#enc 1
#str 18
#att 12
#def 14
#prec 12
#mapmove 4
#ap 15
#poisonres 100
#shockres 100
#magicbeing
#neednoteat
#forestsurvival
#mountainsurvival
#stonebeing
#onebattlespell "Quicken Self"
#clearmagic
#magicskill 1 2 -- Air 2
#custommagic 256 10 -- 10% chance of an extra pick in air
#itemslots 28672
#weapon 911 -- Female shishi bite
#weapon 910 -- Shishi claws
#startage 500
#maxage 900
#nametype 121
#end

#newmonster 2889
#copystats 2797
#name "Male Shishi" -- Male
#descr "The shishi is a spirit of the air, taking the form of a stone lion. While they may look ponderous to the
uninitiated, once a shishi is roused its every motion channels the nature of its element. It may run like the wind,
crossing nations in days, leaping mountains and passing through forests like a gale. In battle the shishi is like a
whirlwind, moving and striking faster than the eye can see. The Pantokrator used the shishis as guardians of his palaces,
deadly to encroaching demons, with one male and one female shishi guarding each entrance. The male shishi's responsibility was the structure it guarded.
As such a fortress guarded by a male shishi will be much harder to tear down, while any who seek to enter undetected will
be quickly hunted down."
#spr1 "./diversity/shishi_male.tga"
#spr2 "./diversity/shishi_male_att.tga"
#castledef 20
#patrolbonus 20
#weapon 912 -- Male shishi bite
#weapon	910 -- Shishi claws
#end

#newmonster 2890 -- Asynja
#copystats 1098 -- Asynja pretender
#restrictedgod 23 -- Set as the god of a nonexistent nation
#spr1 "./diversity/asynja.tga"
#spr2 "./diversity/asynja_att.tga"
#gcost 0
#name "Awakened Asynja"
#descr "The Asynja is a female Aesir who has survived the death of her kin. The Aesir were ancient gods who were defeated aeons ago by the Rimtursar in a cataclysmic battle. Where they were destroyed, the Asynja was driven into torpor and has slumbered ever since. The Asynja is a mighty warrior, skilled in magic and the use of illusions."
#illusion
#stealthy 0
#custommagic 21760 100
#custommagic 21760 50  - The Asynja comes with A2. Additionally, give her 160% AEDB randoms.
#custommagic 21760 10
#spreaddom 0
#weapon "Enchanted Sword"
#armor "Iron Cap"
#armor "Chain Mail of Displacement"
#armor "Weightless Shield"
#end

#newmonster 2798 -- Wild Ettin
#copystats 488
#copyspr 488
#name "Wild Ettin"
#descr "The ancestors of the wild ettins were created through foul magical experiments of crossbreeding and human sacrifice. A lucky few of these unfortunates, the strongest and the quickest, managed to escape their depraved captors and establish themselves in the wilderness. Some were even able to breed, and so the wild ettins came into being. They are huge, stupid giants with two heads and three arms. Despite their stupidity they are surprisingly resistant to magic and elemental damage as a result of their arcane origins. Most make their homes in caves, where they spend much of their time hiding in case the sorcerors who created them should ever come hunting."
#shockres 50
#coldres 50
#poisonres 50
#gcost 0
#noleader
#hp 95 -- Vanilla ettin has 78, which seems too little for his size
#str 28
#mor 20
#mr 16
#enc 2
#prot 8
#att 14
#def 9
#ap 18
#end

#newmonster 2799 -- Mechanical Giant
#copystats 532 -- Mechanical Man
#name "Mechanical Giant"
#spr1 "./diversity/mechanicalgiant.tga"
#spr2 "./diversity/mechanicalgiant_att.tga"
#descr "The mechanical giant is a large construct armored in thick steel plates. Its inner workings are rather fragile given its size, but its thick armor and shield make it almost invulnerable. The mechanical giant is not affected by heat, cold, shock or poison. It is mindless and will never rout, crushing and pursuing its enemies inexorably so long as its gears still turn."
#size 4
#hp 40
#prot 20 - Tougher than mechanical man (18), less than siege golem (24)
#str 18
#att 12
#prec 6
#noleader
#noheal
#ap 10
#end

#newmonster 2893
#copystats 2082 -- Son of the Fallen
#restrictedgod 23 -- Set as the god of a nonexistent nation
#name "Wendigo" -- This is the one that will never get seen.
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2894
#spr1 "./diversity/wendigo1.tga"
#spr2 "./diversity/wendigo1_att.tga"
#fireres -50
#supplybonus 0
#coldres 100
#poisonres 100
#clearmagic
#gcost 0
#size 2
#hp 18
#str 12
#att 14
#def 12
#prot 8
#enc 0
#undead
#mr 14
#mor 30
#prec 10
#ap 14
#noleader
#cold
#weapon "Poisoned Claw"
#weapon "Poisoned Claw"
#magicskill 2 1
#magicskill 5 1
#end

#newmonster 2894
#copystats 2893
#name "Wendigo" -- Turn 0
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2895
#copyspr 2893
#end

#newmonster 2895
#copystats 2894
#copyspr 2894
#name "Wendigo" -- Turn 1
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2896
#hp 24
#str 13
#end

#newmonster 2896
#copystats 2895
#name "Wendigo" -- Turn 2
#spr1 "./diversity/wendigo2.tga"
#spr2 "./diversity/wendigo2_att.tga"
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2897
#magicboost 2 1
#hp 30
#str 14
#end

#newmonster 2897
#copystats 2896
#copyspr 2896
#name "Wendigo" -- Turn 3
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2898
#size 3
#hp 36
#mr 15
#end

#newmonster 2898
#copystats 2897
#spr1 "./diversity/wendigo3.tga"
#spr2 "./diversity/wendigo3_att.tga"
#name "Wendigo" -- Turn 4
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2899
#magicboost 2 1
#magicboost 5 1
#hp 43
#str 15
#end

#newmonster 2899
#copystats 2898
#copyspr 2898
#name "Wendigo" -- Turn 5
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2900
#magicboost 2 2
#magicboost 5 1
#hp 50
#str 16
#end

#newmonster 2900
#copystats 2899
#spr1 "./diversity/wendigo4.tga"
#spr2 "./diversity/wendigo4_att.tga"
#name "Wendigo" -- Turn 6
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2901
#size 4
#hp 57
#mr 16
#end

#newmonster 2901
#copystats 2900
#copyspr 2900
#name "Wendigo" -- Turn 7
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2902
#magicboost 2 2
#magicboost 5 2
#hp 64
#str 17
#end

#newmonster 2902
#copystats 2901
#spr1 "./diversity/wendigo5.tga"
#spr2 "./diversity/wendigo5_att.tga"
#name "Wendigo" -- Turn 8
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2903
#hp 71
#str 18
#end

#newmonster 2903
#copystats 2902
#copyspr 2902
#name "Wendigo" -- Turn 9
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2904
#magicboost 2 3
#magicboost 5 2
#size 5
#hp 79
#str 19
#mr 17
#end

#newmonster 2904
#copystats 2903
#spr1 "./diversity/wendigo6.tga"
#spr2 "./diversity/wendigo6_att.tga"
#name "Wendigo" -- Turn 10
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2905
#hp 98
#str 20
#end

#newmonster 2905
#copystats 2904
#copyspr 2904
#name "Wendigo" -- Turn 11
#descr "The wendigo is a terrible creature of ice and blood, a human afflicted with an endless desire for human flesh. The wendigo is emaciated and uncontrollably hungry, but every time it consumes another human body it merely gains in height and its hunger remains unabated. It will eat large numbers of the local population wherever it is, and grow in size and power over time. If it is involved in battle the wendigo will indulge in an orgy of feasting on the dead in the aftermath, and will grow more quickly. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#firstshape 2906
#hp 108
#str 21
#end

#newmonster 2906
#copystats 2905
#spr1 "./diversity/wendigo7.tga"
#spr2 "./diversity/wendigo7_att.tga"
#name "Wendigo" -- Turn 12, final state
#descr "This wendigo has consumed the flesh of thousands and can finally grow no more, but its hunger remains unabated. The pain it suffers is worse than ever, and it is prone to fall victim to frenzy. While once a human it has become a terrible creature of ice and blood, emaciated and suffering from an uncontrollable and insatiable hunger for human flesh. It will eat large numbers of the local population wherever it is. Wendigos are horrifying and disturbing creatures, and only the bravest of soldiers will hold steady against them. The wendigo is surrounded by a chill wind."
#size 6
#hp 120
#str 22
#magicboost 2 3
#magicboost 5 3
#berserk 3
#mr 18
#end

#newmonster 2907 -- Cyclops
#clearstats
#name "Granite Cyclops"
#spr1 "./diversity/cyclops.tga"
#spr2 "./diversity/cyclops_att.tga"
#descr "The granite cyclops is a one-eyed giant born from deep veins of the hardest rocks.
The body of the cyclops is as hard as the rock from which it was born.
Granite cyclops are somewhat smaller and quicker than the cyclopes of the mountains, but do not possess such powerful magics."
#gcost 0
#size 5
#fireres 100
#mountainsurvival
#hp 80
#prot 24
#mor 30
#mr 18
#enc 2
#str 24
#att 13
#def 14
#prec 8
#mapmove 3
#ap 16
#goodleader
#magicskill 3 3       - Earth 3
#magicskill 0 1
#startage 300
#maxage 1000
#fear 0
#end

#selectnation 91
#era 1
#clearnation
#clearsites
#startfort 4
#name "Endgame Diversity Mod"
#epithet "Testing Nation"
#descr "A nation with all the Endgame Diversity Mod summons available as recruitables."
#summary "May be useful for testing the summons without having to build up powerful magic to summon them."
#brief "Nation able to recruit the Endgame Diversity Mod summons."
#addreccom 2908 -- Roc
#addreccom 2857 -- Grendelkin
#addreccom 2858 -- Treant
#addreccom 2869 -- True Firebird
#addreccom 2870 -- Zmey
#addreccom 2886 -- Ember Lord
#addreccom 2887 -- Great Kraken
#addreccom 2889 -- Shishi (Male)
#addreccom 2797 -- Shishi (Female)
#addreccom 2890 -- Asynja
#addreccom 2798 -- Wild Ettin
#addreccom 2799 -- Mechanical Giant
#addreccom 2893 -- Wendigo
#addreccom 2907 -- Cyclops
#startcom 2893 - Give a wendigo and a grendelkin as starting commanders.
#startscout 2857
#end

- Reminder for llama:
(0) Conjuration
(1) Alteration
(2) Evocation
(3) Construction
(4) Enchantment
(5) Thaumaturgy
(6) Blood


#newspell -- Firebird summoning
#copyspell "King of Banefires"  -- To get uniqueness
#name "Quest for the Firebird"
#descr "By channeling powerful magics, the mage is able to succeed where countless heroes have failed, and locate the True Firebird. This elusive and mysterious creature brings great good fortune wherever it is. Its plumage glows with extraordinary brightness, and in battle the intensity of the light it gives off may blind friend and foe alike, and reduce undead to cinders."
#school 0 -- Conjuration
#researchlevel 6
#path 0 0 -- Fire
#path 1 -1 -- No secondary path
#pathlevel 0 4
#damage 2869 -- True Firebird
#fatiguecost 2000 -- Gem cost
#end

#newspell
#name "Summon Zmey"
#descr "The mage reaches out to the distant jungles where the last of the zmeys make their home, and summons one to his service. The zmey is a mighty
three headed fire-breathing dragon."
#school 0 -- Conjuration
#researchlevel 6
#path 0 0
#path 1 -1
#pathlevel 0 4
#fatiguecost 2500
#effect 10021
#damage 2870
#nreff 1
#end

#newspell
#name "Awaken Ember Lord"
#descr "The mage summons an ancient Ember Lord from the deeps of the world, and binds it to his service. Ember Lords are powerful spirits of flame and death, as old as the world itself."
#school	0 -- Conjuration
#researchlevel 9
#path 0 0
#path 1 -1
#pathlevel 0 6
#fatiguecost 6000
#effect 10021
#damage 2886
#nreff 1
#end

#newspell
#name "Summon Female Shishi"
#researchlevel 0
#school -1
#effect 10021
#damage 2889
#nreff 1
#end

#newspell
#name "Summon Shishis"
#descr "The mage awakens a pair of Shishis, guardian spirits of the air which take the form of stone lions."
#school	0 -- Conjuration
#researchlevel 6
#path 0 1
#path 1 -1
#pathlevel 0 4
#fatiguecost 3000
#effect 10021
#damage 2797
#nreff 1
#nextspell "Summon Female Shishi"
#end

#newspell
#name "Summon Roc"
#descr "The mage cries out in the language of the first birds, and uses his magic to carry the cry on the winds. The call reaches and summons a roc, the mightiest and wisest of all birds."
#school	0 -- Conjuration
#researchlevel 6
#path 0 1
#path 1 -1
#pathlevel 0 4
#fatiguecost 1800
#effect 10021
#damage 2908
#nreff 1
#end

#newspell
#name "Awaken Aesir"
#descr "The mage calls an Asynja, a female survivor of the ancient race of the Aesir. The Aesir were once a race of gods, and the Asynja remains both a powerful warrior and an adept user of air magic."
#school	0 -- Conjuration
#researchlevel 8
#path 0 1
#path 1 -1
#pathlevel 0 5
#pathlevel 1 -1
#fatiguecost 3500
#effect 10021
#damage 2890
#nreff 1
#end

#newspell
#name "Mechanical Giant"
#descr "The mage creates a mechanical giant covered with thick iron plates. The giant stands ten feet tall, is almost invulnerable and is unaffected by heat, cold, shock and poison."
#school	3 -- Construction
#researchlevel 7
#path 0 3
#pathlevel 0 5
#fatiguecost 2000
#effect 10021
#damage 2799
#nreff 1
#end

#newspell
#name "Awaken Cyclops"
#descr "The mage rouses a dormant cyclops from its slumber within the heart of a mountain."
#school 0 -- Conjuration
#researchlevel 8
#path 0 3
#pathlevel 0 5
#fatiguecost 3500
#effect 10021
#damage 2907
#nreff 1
#end

#newspell
#name "Great Kraken"
#descr "The mage calls to the great deeps of the world, and awakens an ancient kraken, most powerful of all the monsters of the sea."
#spec 41943040 -- Only underwater.
#school	4 -- Enchantment
#researchlevel 6
#path 0 2
#pathlevel 0 4
#fatiguecost 2000
#effect 10021
#damage 2887
#nreff 1
#end

#newspell
#name "Call Grendelkin"
#descr "The grendelkin are the brothers and sisters of the mighty Grendel. They are each alone, cowering in fear in the
hidden places of the world. Through the use of this powerful magic the mage locates one of the lost grendelkin and summons
the monster to his service."
#school	4 -- Enchantment
#researchlevel 8
#path 0 2
#path 1 3
#pathlevel 0 3
#pathlevel 1 3
#fatiguecost 3500
#effect 10021
#damage 2857
#nreff 1
#end

#newspell
#name "Curse of the Wendigo"
#descr "The mage afflicts an innocent with a terrible curse. The victim loses his sanity, becoming overwhelmed with a hunger for human flesh. Once he succumbs he descends into a terrible frenzy, killing and eating everyone he can find. The more flesh he heats, the hungrier he becomes. Instead of sating him, the consumed flesh leads him to grow in stature and power. The cursed victim will eventually become a powerful monster, suffused with the magics of ice and death."
#school	5 -- Thaumaturgy
#researchlevel 6
#path 0 2
#path 1 5
#pathlevel 0 3
#pathlevel 1 3
#fatiguecost 2400
#effect 10021
#damage 2893
#nreff 1
#end

#newspell
#name "Wild Ettin"
#descr "The wild ettins are a hunted and fearful breed. Through the use of this spell the mage reaches out to find one of these powerful beasts. Once it is found, he offers it protection and baubles in exchange for its service in battle."
#school	4 -- Enchantment
#researchlevel 5
#path 0 6
#path 1 3
#pathlevel 0 3
#pathlevel 1 3
#fatiguecost 1400
#effect 10021
#damage 2798
#nreff 1
#end

#newspell
#name "Awaken Treant"
#descr "The mage channels powerful nature magic to awaken a sleeping treant and bind it to his service."
#school	4 -- Enchantment
#researchlevel 7
#path 0 6
#path 1 -1
#pathlevel 0 5
#fatiguecost 3000
#effect 10021
#damage 2858
#nreff 1
#end
