#modname "Pythium: The Second Empire"
#description "This is the Pythium: The Second Empire mod, which adds a new MA nation with some Byzantine influences."
#icon "./Byzantine/banner.tga"
#version 0.87

-- Mod by Burnsaber.
-- Extensively modified by llamabeast (26th March 2011) to give compatibility with base-game Pythium as well as Sombre's Mod Catalogue project.

This mod uses slots:

Weaponslots: 730-733
Armorslots: 351
Monsterslots: 2690-2692
Spellslots: 6

-------- BUG FIXES --------

#selectmonster 1367 --Angel of the Host
#size 3
#end

-------- WEAPONS --------

#selectweapon 48
#explspr 10113 -- llama says: Guess I'll leave this in since it's purely cosmetic.
#end

-selectweapon 441 -- Banish to Inferno
-nratt 3         -- Can't really leave this in. Sorry Michael!
-end

#newweapon 692
#name "Pyros"
#range -1
#rcost 9
#bonus
#fire
#armorpiercing
#ammo 3
#att -3
#len 0
#dmg 9
#nostr
#magic
#aoe 2
#flyspr 100 1
#explspr 10113
#end

#newweapon 697
#name "Serpent Slayer"
#rcost 0
#att 7
#def 3
#len 3
#dmg 7
#dt_holy
#armornegating
#secondaryeffectalways 276 -- Small Area Holyfire 
#magic 
#end

#newweapon 698
#name "Pyro Staff"
#rcost 18
#fire
#armorpiercing
#ammo 3
#att 0
#len 3
#def -2
#dmg 10
#nostr
#magic
#aoe 1
#secondaryeffectalways 692
#explspr 10060
#end

#newweapon 699
#name "Warmace"
#rcost 2
#att 1
#len 1
#def 0
#dmg 6
#end

------------Armor-------------

#newarmor 351
#name "Halo"
#type 6
#rcost 0
#def 0
#prot 40
#enc 0
#end


-------- UNITS ----------

#newmonster 2206 -- Theurg Acolyte
#copystats 43
#copyspr 43
#descr "Spokesmen of the Faith of Pythium and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes."
-selectmonster 43 -- Theurg Acolyte
#startage 25
#custommagic 896 10
#nametype 107
#end

#newmonster 2207 -- Theurg
#copystats 42
#copyspr 42
#descr "Spokesmen of the Faith of Pythium and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes."
#clearmagic
#startage 40
#gcost 180
#magicskill 4 2
#magicskill 8 2
#custommagic 896 100
#magicboost 0 1
#magicboost 1 1
#magicboost 2 1
#nametype 107
#end

#newmonster 2208 -- Arch Theurg
#copystats 41
#copyspr 41
#descr "Spokesmen of the Faith of Pythium and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes."
#clearmagic
#startage 60
#maxage 100
#magicskill 4 3
#magicskill 8 3
#custommagic 896 100
#custommagic 896 100
#magicboost 0 2
#magicboost 1 2
#magicboost 2 2
#nametype 107 
#end

-- Battle Vestal
#newmonster 2209
#copystats 51
#copyspr 51
#descr "The Battle Vestals are priestly maidens devoted to war. They carry no armor, relying on their quickness to avoid their enemies' weapons. The Vestals are sacred and can be blessed by priests."
#gcost 20
#mor 13 -- CBM change
#mr 14 -- CBM change
#nametype 108 
#end

-Velite
#newmonster 2210
#copystats 684
#copyspr 684
#descr "These are light troops equipped only with spear, javelin, tower shield and iron cap."
#gcost 9
#end

-Legatus Legionis
#newmonster 2211
#copystats 1385
#copyspr 1385
#descr "The Legatus Legionis is a high commander of an Imperial Legion. Only the most able commanders are chosen for the task and only candidates with political backing, strong personalities and exceptional skills will receive the honor. These able men command great respect from their soldiers and will inspire them to great deeds."
#gcost 50
#end

-Hastatus
#newmonster 2212
#copystats 686
#copyspr 686
#descr "The Hastati are legionnaires trained in the major cities of the Empire. They normally take the second rank, behind the Velites and will deal the first blow against the enemy. The Hastati wield short swords and javelins. They wear the lorica segmentata, a flexible armor of metal bands joined together, and carry a scutata tower shield."
#gcost 11
#end

------------------------------------------------
/////////////////////HEROES//////////////////////
------------------------------------------------

#newmonster 2213 -- Patriarch
#copystats 584
#copyspr 584
#clearmagic
#descr "The Patriarch is the highest ranking priest of the Empire and commands the vast powers of the Theurg. Only the Emperor holds more power within the Empire. He has been elected to the Holy Seat by his peers because of his immense faith and magical prowess, which allows him to form stronger communions than most Theurgs. He rarely involves himself in matters beyond the Sancta Sophia, but a recent vision has made him leave his prayer chamber to serve the Awakening God."
#startage 60
#maxage 100
#magicskill 8 4
#magicskill 0 2
#magicskill 1 2
#magicskill 2 2
#magicskill 4 3
#nametype 107
#end

------------ALCHEMIST GUILDMASTER

#newmonster 2214
#clearstats
#copystats 1880 -- Reveler for Heretic 3
#clearmagic
#spr1 "./Byzantine/Alchemist_Guildmaster_1.tga"
#spr2 "./Byzantine/Alchemist_Guildmaster_2.tga"
#name "The Guildmaster"
#descr "The Guildmaster of the alchemists of Pythium is shrouded in mystery. His genius is not up to debate, but not much else is known about him. He has always worn a golden mask to cover face and rose to his position in a very short amount of time by politicking and his opposers had a bad habit of 'dissappearing' before important debates. Some say that he wears his mask to cover a hideous injury from an alchemical accident and others say that it is a trophy, since that mask was once made from lead. Vilest rumours accuse of him belonging to one of the heretical cults. He has now given himself to the service of the awakening god for reasons only known to him."
#str 10
#prot 3
#weapon 238 --magic staff
#weapon 692 --pyros
#fireres -50
#hp 12
#mor 13
#mr 15
#att 10
#def 10
#ap 12
#prec 11
#enc 3
#researchbonus 7
#magicskill 0 3
#magicskill 2 3
#magicskill 3 2
#gcost 1
#rcost 1
#noleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

-----------------MAN FROM NORTH

#newmonster 2215
#clearstats
#spr1 "./Byzantine/Man_from_North_1.tga"
#spr2 "./Byzantine/Man_from_north_2.tga"
#name "Man from the North"
#descr "This man, simply known as the 'Man from the North' was once the fiercest marauder in the distant Vanheim and not even the Vanir could not prevent his pillages. Once he heard from the riches of Sancta Sophia, he decided to sail to the Glorius City and burn it to the ground. He gathered a great horde of northmen and set sails for the Heart of Pythium. He took the Theurgs by surprise and smashed the gates of the city. But as he gazed upon the beauty of the Glorious City, he fell down to his knees and wept for he had not seen such glory before. He disbanded his men and fled, horrified of the sin he almost committed. After a full century, the Man from the North has returned to pay back his crime although no one knows what sorcery has allowed him to stay alive for so long."
#str 14
#prot 0
#weapon 412 -- Axe of Hate
#secondshape 2216
#ambidextrous 2
#pillagebonus 25
#armor "Chain Mail Hauberk"
#regeneration 5
#forestsurvival
#berserk 3
#fear 0
#sailing
#hp 20
#mor 17
#mr 15
#att 15
#def 13
#ap 14
#prec 11
#enc 2
#gcost 1
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 115 
#startage 120
#maxage 200
#end

#newmonster 2216
#copyspr 633
#name "Man from the North"
#descr "This man, simply known as the 'Man from the North' was once the fiercest marauder in the distant Vanheim and not even the Vanir could not prevent his pillages. Once he heard from the riches of Sancta Sophia, he decided to sail to the Glorius City and burn it to the ground. He gathered a great horde of northmen and set sails for the Heart of Pythium. He took the Theurgs by surprise and smashed the gates of the city. But as he gazed upon the beauty of the Glorius City, he fell down to his knees and wept for he had not seen such glory before. He disbanded his men and fled, horrified of the sin he almost committed. After a full century, the Man from the North has returned to pay back his crime."
#str 15
#prot 7
#firstshape 2215
#weapon 29 --Claw
#weapon 29 --Claw
#weapon 20 --Bite
#fear 0
#forestsurvival
#regeneration 20
#pillagebonus 25
#berserk 3
#hp 25
#mor 17
#mr 14
#att 15
#def 13
#ap 13
#prec 11
#enc 2
#gcost 1
#rcost 1
#okleader
#mapmove 2
#size 3
#nametype 115 
#startage 35
#maxage 75
#end

////////////////////////////////
----------NEW RECRUITS---------
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

----Cultist

#newmonster 2217
#copystats 1872 -- Leo for heretic 1
#clearmagic
#spr1 "./Byzantine/Cultist_1.tga"
#spr2 "./Byzantine/Cultist_2.tga"
#name "Cultist"
#descr "The nobles and the Theurgs of the Empire are in a constant power struggle, as they wrestle for the attention of the Emperor. The Emperors often favour the Theurgs, who traditionally school all future emperors in magic and faith. Thus Theurgs often ger better positions in the court and most nobles have antipathy towards the Theurgs and their faith. Recently, preachers of strange new faiths have charmed the Pythian nobles with their promises of power. These new cults have proven guite popular within the nobility because they no qualms about 'removing' troublesome Theurgs from court politics. Theurgs have outlawed all of these cults, but some cultists could still see themselves serving the Awakening God if they get paid enough for it. Some of them possess some magical might as a gift from their heretical god."
#str 10
#prot 0
#fireres 0
#firepower 0
#weapon "Serpent Kryss"
#armor "Robes"
#armor "Mask"
#stealthy 20
#assassin
#poisonres 50
#custommagic 8704 10
#custommagic 20480 10
#hp 11
#mor 12
#mr 12
#att 12
#def 12
#ap 12
#prec 10
#enc 3
#gcost 75
#rcost 1
#noleader
#mapmove 2
#size 2
#nametype 107
#startage 35
#maxage 55
#end


------------IMPERIAL ALCHEMIST

#newmonster 2218
#clearstats
#spr1 "./Byzantine/Imperial_Alchemist_1.tga"
#spr2 "./Byzantine/Imperial_Alchemist_2.tga"
#name "Imperial Alchemist"
#descr "The Theurgs of Pythium are great supporters of arts and sciences. Throughout centuries, the guild house of the Imperial Alchemists has just grown and grown with more and more wonderful inventions one after another. Unlike most alchemists, the Pythian ones not as obsessed with turning lead into gold, although they occasionally dabble in the matter. As most of the alchemists are funded by the imperial seat, most of their efforts go into the study of fire and water, which has more battlefield applications. The invention of 'Pyros', which is also known as Alchemist's fire, is their greatest advancement thus far. All alchemists are skilled in the use of Pyros and carry some vials of the stuff into combat. However, this branch of alchemy is quite dangerous and many alchemists carry permanent wounds from alchemical accidents."
#str 10
#prot 3
#weapon 9 --dagger
#weapon 692 --pyros
#startaff 10
#fireres -50
#hp 10
#mor 10
#mr 13
#att 9
#def 9
#ap 12
#prec 10
#enc 3
#researchbonus 1
#magicskill 0 1
#magicskill 2 1
#custommagic 1664 100
#custommagic 1664 10
#gcost 110
#rcost 2
#noleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

------------THEURG ARTISAN

#newmonster 2219
#clearstats
#spr1 "./Byzantine/Theurg_Artisan_1.tga"
#spr2 "./Byzantine/Theurg_Artisan_2.tga"
#name "Theurg Artisan"
#descr "The Theurgs of Pythium are great supporters of arts and sciences. The artisans of the Glorious City are often also priests trained in Sancta Sophia. Combining their craftsmanship with their faith allows them to make works art so beautiful that they bring the hearts of men closer to the celestial realm and the Awakening God. The artisans often specialize in single craft and train in magic related to that craft. Glass-blowers are skilled in fire magic, Sculptors in earth magic, Painters in water magic, Singers in air magic and Cantors are skilled in astral magic. Their skills allow them to forge magical items of great wonder more cheaply. However, the Artisans are pampered by the luxury of the Glorious City and lack the patience for magical research. They also demand a heavy price for their services. Rarely a savant emerges from their ranks, a true genius mastering several forms of art."
#str 10
#prot 0
#weapon 7 --quarterstaff
#hp 10
#mor 11
#mr 14
#att 9
#def 9
#ap 12
#prec 11
#enc 3
#holy
#magicskill 8 1
#custommagic 3968 100
#custommagic 128 10
#custommagic 256 10
#custommagic 512 10
#custommagic 1024 10
#custommagic 2048 10
#forgebonus 10
#researchbonus -1
#gcost 125
#rcost 1
#noleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

------------AMBASSADOR

#newmonster 2220
#clearstats
#spr1 "./Byzantine/Ambassador_1.tga"
#spr2 "./Byzantine/Ambassador_2.tga"
#name "Ambassador"
#descr "The Imperial courts of Pythium are full of intrigue and secrets. They are places where the weak-willed and stupid are quite prone to perish in tragic 'accidents' as the nobles race to get closer to the emperor. In this rather dangerous environment, only the cunning, charismatic and sneaky can prosper. The Emperor is not blind to the talents of some of these individuals and often sends them to distant countries as ambassadors so that they can spy on the enemies of the Empire."
#str 10
#prot 0
#weapon 9 --dagger
#spy
#stealthy 20
#hp 10
#mor 10
#mr 10
#att 9
#def 9
#ap 12
#prec 11
#enc 3
#gcost 30
#rcost 1
#poorleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end


-----------VARANGIAN GUARD

#newmonster 2221
#clearstats
#spr1 "./Byzantine/Varangian_Guard_1.tga"
#spr2 "./Byzantine/Varangian_Guard_2.tga"
#name "Varangian Guard"
#descr "A century ago, a great horde of northmen tried to conquer the Glorious City and plunder the riches of Sancta Sophia. Their numbers were many and they surprised the defenders by sailing through rivers and destroyed the gate. However, their leader was so awestruck by the beauty of Sancta Sophia that he disbanded his men and fled in shame. The Theurgs told the northmen of their Awakening God and the Emperor hired them to the imperial army as mercenaries. After seeing them fight against the horsemen of the East, the Emperor was greatly impressed by their loyalty and martial prowess and installed them as imperial bodyguards, who would be immune to politicking of his power hungry courtiers. The skills of the Varagian Guard are know throughout the realm and many skilled northmen travel to the glorious city in order to become one of them."
#str 12
#prot 0
#weapon 18 --Battleaxe
#armor "Half Helmet"
#armor "Chain Mail Hauberk"
#hp 14
#mor 16
#mr 12
#att 12
#def 11
#ap 12
#prec 10
#enc 3
#gcost 20
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 115 
#startage 25
#maxage 50
#end

-----------VARANGIAN CAPTAIN

#newmonster 2222
#clearstats
#spr1 "./Byzantine/Varangian_Captain_1.tga"
#spr2 "./Byzantine/Varangian_Captain_2.tga"
#name "Varangian Captain"
#descr "A century ago, a great horde of northmen tried to conquer the Glorious City and plunder the riches of Sancta Sophia. Their numbers were many and they surprised the defenders by sailing through rivers and destroyed the gate. However, their leader was so awestruck by the beauty of Sancta Sophia that he disbanded his men and fled in shame. The Theurgs told the northmen of their Awakening God and the Emperor hired them to the imperial army as mercenaries. After seeing them fight against the horsemen of the East, the Emperor was greatly impressed by their loyalty and martial prowess and installed them as imperial bodyguards, who would be immune to politicking of his power hungry courtiers. The Varangian Captains are the most fearsome of these warriors and their fame travels before them, filling opposing enemies with fear."
#str 13
#prot 0
#weapon 17 --Axe
#weapon 17 --Axe
#ambidextrous 2
#armor "Chain Mail Hauberk"
#fear 0
#sailing
#hp 16
#mor 17
#mr 13
#att 14
#def 12
#ap 13
#prec 10
#enc 2
#gcost 65
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 115 
#startage 35
#maxage 50
#end

-----------Kataphraktoi

#newmonster 2223
#clearstats
#spr1 "./Byzantine/Latinkoi_1.tga"
#spr2 "./Byzantine/Latinkoi_2.tga"
#name "Kataphraktoi"
#descr "The Kataphraktoi serve as the heavy cavalry of the Empire, like the Equites in the Ermorian legion before the fall. These Pythian counterparts are more heavily armoured and use heavy lances, although they are not as heavily armed as the knights of the western kingdoms. Like most elite soldiers in the legion, they use Pythian Warmaces in combat."
#str 11
#prot 0
#weapon "Lance"
#weapon 710 -- Warhorse Hoof
#weapon 699 -- Warmace
#armor "Legionary Helmet"
#armor "Chain Mail Hauberk"
#armor "Shield"
#hp 12
#mor 12
#mr 11
#att 11
#def 11
#ap 24
#mounted
#prec 10
#enc 4
#gcost 35
#rcost 8
#ressize 2
#okleader
#mapmove 2
#size 3
#nametype 107 
#startage 25
#maxage 50
#end

-----------Verdariotai

#newmonster 2224
#clearstats
#spr1 "./Byzantine/Verdariotai_1.tga"
#spr2 "./Byzantine/Verdariotai_2.tga"
#name "Verdariotai"
#descr "The Verdariotai are barbarian horsemen from the northern wastes. Their people often raided the border provinces of Pythium during the early days of the Empire. However, as they were constantly beaten back, the barbarians noticed that they would gain more riches by working for the Emperor as mercenaries. Now these mercenaries have become integral part of the Pythian legions. They are skilled horsemen and archers, although they are poorly armoured."
#str 10
#prot 0
#weapon 357 --Light Lance
#weapon 264 --Composite Bow
#weapon 710 -- Warhorse Hoof
#wastesurvival
#forestsurvival
#armor "Leather Cap"
#armor "Full Leather Armor"
#armor "Buckler"
#hp 11
#mor 10
#mr 10
#att 10
#def 10
#ap 26
#mounted
#prec 10
#enc 3
#gcost 20
#rcost 1
#okleader
#mapmove 3
#size 3
#nametype 121 
#startage 25
#maxage 50
#end


-----------Pyrote

#newmonster 2225
#clearstats
#spr1 "./Byzantine/Pyrote_1.tga"
#spr2 "./Byzantine/Pyrote_2.tga"
#name "Pyrote"
#descr "The Pyrotes are the secret weapon of the Empire. They armed with strange cylinders that are filled with Alchemist's Fire, a strange flammable substance devised by the Imperial alchemists. Pyrotes can fire these cylinders to engulf all nearby enemies in flames. As deadly as the new weapons are, they are also dangerous to their user as even a small surge of heat could fire up the Pyros inside the cylinder. Thus, only the bravest and most foolhardy soldiers could ever be enlisted as Pyrotes. The Pyro staffs are also very time-consuming to manufacture, which even further limits the amount of these weapons in the battlefield."
#str 11
#prot 0
#weapon 699 -- Warmace
#weapon 698 --Pyro Staff
#armor "Full Helmet"
#armor "Plate Cuirass"
#fireres -100
#hp 12
#mor 12
#mr 11
#att 11
#def 11
#ap 12
#prec 10
#enc 6
#gcost 35
#rcost 5
#okleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

-----------Pricipe

#newmonster 2226
#clearstats
#descr "The Principes are the elite troops of the legion. They take the third rank behind the Hastati and are supposed to crush the enemy if the Hastati are broken. The Principes are armed as the Hastati with javelins and wear the lorica segmentata. However, they wield Pythian Warmaces instead of short swords for greater offensive power."
#spr1 "./Byzantine/Pythian_Principe_1.tga"
#spr2 "./Byzantine/Pythian_Principe_2.tga"
#str 10
#prot 0
#weapon 699 -- Warmace
#weapon "Javelin"
#armor "Lorica Segmentata"
#armor "Legionary Helmet"
#armor "Tower Shield"
#hp 11
#mor 12
#mr 10
#att 11
#def 11
#ap 12
#prec 11
#enc 3
#gcost 14
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 107 
#startage 35
#maxage 50
#end

-----------Akritoi

#newmonster 2227
#clearstats
#name "Akritoi"
#descr "The Akritoi are a new unit for legion, installed after the invasion by the Horsemen from the east. Their attack showed how the Pythium military needed a long range bowmen to combat the quickly moving horseman archers the barbarians used. Akritoi are skilled and heavily armed legionary archers who use composite bows. They are a relatively new unit and there are few soldiers in Pythium who are skilled in the use of composite bow, making recruiting them a rather slow process."
#spr1 "./Byzantine/Akritoi_1.tga"
#spr2 "./Byzantine/Akritoi_2.tga"
#str 10
#prot 0
#weapon 699 -- Warmace
#weapon "Composite Bow"
#armor "Lorica Segmentata"
#armor "Legionary Helmet"
#armor "Buckler"
#hp 10
#mor 11
#mr 10
#att 10
#def 10
#ap 12
#prec 10
#enc 3
#gcost 11
#rcost 3
#okleader
#mapmove 2
#size 2
#nametype 107 
#startage 35
#maxage 50
#end

-----------The Emperor

#newmonster 2228
#clearstats
#spr1 "./Byzantine/The_Divine_Emperor_1.tga"
#spr2 "./Byzantine/The_Divine_Emperor_2.tga"
#name "The Emperor"
#descr "The Emperor of Pythium is the most powerful man in Pythium and not just because of his title. All Emperors are rigorously trained in magic and faith from childhood in the Sancta Sophia, making them mighty wielders of divine and astral forces. Emperors are also often seen leading the divine communions of the Theurgs."
#str 10
#prot 0
#weapon 134 --spectre of authority
#armor "Crown"
#hp 10
#mor 15
#mr 16
#att 10
#def 10
#ap 12
#prec 11
#enc 3
#holy
#magicskill 4 4
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#mapmove 2
#size 2
#nametype 107 
#startage 40
#maxage 65
#end

-- Seems like an unnecessary bit to llamabeast.
----Angel of the Host, altered for hero making purposes.
-selectmonster 543
-descr "Angels are divine beings in human form. They are winged and armed with flaming swords that destroy undead beings. They are surrounded by a radiant aura that intimidates cowardly beings. Angels have partial resistance to lightning and fire. They sometimes act as Guardian Angels for righteous mortals."
-end

-------- The Archangels

#newmonster 2229
#clearstats
#spr1 "./Byzantine/Sealtiel_1.tga"
#spr2 "./Byzantine/Sealtiel_2.tga"
#name "The Prayer of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the prayer of the holiest and guides the followers of light on ways to reach the divine realm through humble prayer. He is the most serene of the Archangels and will not raise his hand from prayer, not even to smite the unholy or to take up arms. If he is present in battle, he will often lead the holy communion of the Theurgs so that they can channel celestial might and bring the kingdom of heaven upon this realm."
#str 7
#prot 7
#weapon 509 --Bane of Heresy
#domsummon20 1367 --Angel of the Celestial Choir
#summon1 1367 --Angel of the Celestial Choir
#researchbonus 20
#itemslots 31872 -- no hand slot, does not take up arms.
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 50
#fireres 50
#unique
#awe 9
#hp 39
#mor 30
#mr 18
#att 0
#def 14
#ap 16
#prec 15
#enc 1
#holy
#magicskill 4 4
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 8 4
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2230
#clearstats
#spr1 "./Byzantine/Raphael_1.tga"
#spr2 "./Byzantine/Raphael_2.tga"
#name "The Healing of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the healing of the holiest and his gift is to bring purity of the body to servants of the Awakening God. He is revered as the protector of science and medicine and especially Imperial Alchemists pray for his guidance. His body is pure and resistant to the ravages of the mortal plane, be they blades of a sinner or elemental sorcery from heretics. He is an angel of thought and serenity, unwilling to take up arms other than his trusty staff and his golden jar of medicine."
#str 13
#prot 17
#weapon 238 --Magic Staff
#researchbonus 10
#itemslots 31872 -- no hand slot, does not take up arms.
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#regeneration 10
#heal
#healer 100
#shockres 50
#fireres 50
#poisonres 50
#coldres 50
#awe 7
#hp 40
#mor 30
#unique
#mr 18
#att 11
#def 14
#ap 16
#prec 15
#enc 1
#holy
#magicskill 4 3
#magicskill 6 3
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end

#newmonster 2231
#clearstats
#spr1 "./Byzantine/Barachiel_1.tga"
#spr2 "./Byzantine/Barachiel_2.tga"
#name "The Blessing of the Lord"
#str 14
#prot 7
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the blessing of the holiest and rules the court of guardian angels in order to protect the followers of the awakening god. He distributes of the blessings granted by the celestial powers and can summon Guardian Angels to guard mortals and prevent bad events by his mere presence. His brother was one of the fallen watchers and upon their imprisonment, he was granted dominance over skies and thunder, which was the domain of his fallen brother Ezekiel. He now uses his brother's powers to smite those who would harm those under his protection. He wields a white rose to remember his brother's fate, so that he would not to repeat his sins."
#weapon 278 --Lightning Spear
#weapon 243 --Lightning (thrown)
#weapon 243 --Lightning (thrown)
#stormimmune
#nobadevents 77
#makemonster2 543 -- Angels of the Host
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 100
#fireres 50
#awe 7
#unique
#hp 49
#mor 30
#mr 18
#att 14
#def 14
#ap 16
#prec 15
#enc 1
#holy
#magicskill 1 4
#magicskill 0 2
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2232
#clearstats
#spr1 "./Byzantine/Jegudiel_1.tga"
#spr2 "./Byzantine/Jegudiel_2.tga"
#name "The Glorifier of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the glorifier of the holiest and knows how to bring the mortals closer to the heavenly realm through works of beauty and wonder. He is the protector of arts and honest labour, for works of art and building bring men closer to the divine realm. The Theurg Artisans of Sancta Sophia hold him as their patron and inspiration. He is able to easily create works of magical wonder and does not tire by any physical effort, as he is constantly filled with divine vigour. He is a serene angel of beauty and wields a shining crown on his right hand to remind mortals of the rewards that will come with spiritual labour in the kingdom of heaven."
#str 13
#prot 7
#weapon 92 --Fist
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 50
#fireres 50
#reinvigoration 4
#forgebonus 25
#unique
#awe 7
#hp 44
#mor 30
#mr 18
#att 13
#def 13
#ap 16
#prec 15
#enc 1
#holy
#magicskill 4 3
#magicskill 3 2
#magicskill 0 1
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2233
#clearstats
#spr1 "./Byzantine/Gabriel_1.tga"
#spr2 "./Byzantine/Gabriel_2.tga"
#name "The Man of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the man of the holiest and acts as an messenger and warrior for the celestial powers, making their will known amongst the mortals. He is a mighty warrior, second only to the Slayer of the Serpent in terms of martial skill. His skills as an divine herald allow him to pass enemy lands swiftly and unseen while spreading the dominion of the awakening god. He wields a mirror of green jasper on his left hand, to represent the mysteries of the divine realm."
#str 16
#prot 8
#weapon 106 --Sword of Swiftness
#stealthy 25
#spreaddom 1
#armor "Halo"
#armor "Silver Hauberk"
#magicbeing
#unique
#holy
#neednoteat
#flying
#shockres 50
#fireres 50
#awe 7
#hp 57
#mor 30
#mr 18
#att 16
#def 16
#ap 16
#prec 15
#enc 1
#holy
#magicskill 1 3
#magicskill 4 3
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 7
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2234
#clearstats
#spr1 "./Byzantine/Uriel_1.tga"
#spr2 "./Byzantine/Uriel_2.tga"
#name "The Light of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the light of the holiest and brings the divine light to cleanse the shadows of sin from the hearts of mortals. He also is the protector of the sun and acts as the eyes of the divine sphere, gazing upon the mortal realm with his celestial eyes as he guards the sun by day. On his right hand, he wields the sacred Orb of Fire, which will smite heathens who would try to strike the enlightener and light his path in darkness."
#str 14
#prot 7
#weapon 275 --Sun Sword
#weapon 229 --Flame Strike
#itemslots 15490 -- Only one hand slot
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 50
#fireres 100
#fireshield 8
#darkvision 100
#unique
#awe 7
#hp 49
#mor 30
#mr 18
#att 14
#def 14
#ap 16
#prec 20
#enc 1
#holy
#magicskill 0 4
#magicskill 1 2
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

----------- Michael

#newmonster 2235
#spr1 "./Byzantine/True_Michael_1.tga"
#spr2 "./Byzantine/True_Michael_2.tga"
#name "Who is like the Lord?"
#descr "This is one of the Seven Archangels from the Celestial Sphere. This angel is the Seventh, the most glorious of all Archangels. He resisted the poisonous lies of Belial, withstood the plague wind of Pazazu, endured the heat of Buer and persisted under the blows of Belphegor to cast them all to inferno at the dawn of time. He is The Warrior from Heaven, whose mere name is a riddle only the righteous can answer. He is the guardian of the Divine Kingdom and his tasks are great, but still he has come to this battle to protect the righteous. Armed with the spear he used to smite the four hellish lords, he will banish sinners to their rightful place."
#str 17
#prot 12
#weapon 697 -- Serpent Slayer
#weapon 441 -- Banish to Inferno
#armor "Halo"
#armor "Silver Hauberk"
#armor "Shield of Valor"
#magicbeing
#holy
#neednoteat
#flying
#stormimmune
#unique
#noitems -- To make him an unattractive wish target
#shockres 75
#fireres 75
#poisonres 75
#awe 8
#hp 77
#mor 30
#mr 18
#att 17
#def 17
#ap 17
#prec 17
#enc 1
#holy
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 7
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 



------- Pretenders

#newmonster 2236
#copystats 472 -- Sacred Statue
#copyspr 472 -- Sacred Statue
#restrictedgod 86
#end

#newmonster 2237
#copystats 215 -- Virtue
#copyspr 215 -- Virtue
#restrictedgod 86
#end

#newmonster 2238
#copystats 600 -- Titan (female)
#copyspr 600 -- Titan (female)
#descr "The Titaness is a giant who claims divine heritage. She is a wise and excellent warrior. She is at all times followed by her owl companion."
#restrictedgod 86
#end

#newmonster 2239
#copystats 603 -- Father of Serpents
#copyspr 603 -- Father of Serpents
#restrictedgod 86
#end

#newmonster 2240
#copystats 964 -- Lord of Fertility
#copyspr 964 -- Lord of Fertility
#restrictedgod 86
#end

#newmonster 2241
#copystats 979 -- Great White Bull
#copyspr 979 -- Great White Bull
#restrictedgod 86
#end

#newmonster 2242
#copystats 1230 -- Forge Lord
#copyspr 1230 -- Forge Lord
#restrictedgod 86
#end

#newmonster 2243
#copystats 1342 -- Mother of Rivers
#copyspr 1342 -- Mother of Rivers
#restrictedgod 86
#end

#newmonster 2244
#copystats 1343 -- Lady of Love
#copyspr 1343 -- Lady of Love
#restrictedgod 86
#end

#newmonster 2245
#copystats 1371 -- Lord of Rebirth
#copyspr 1371 -- Lord of Rebirth
#restrictedgod 86
#end

#newmonster 2246
#copystats 1348 -- Mother of Serpents
#copyspr 1348 -- Mother of Serpents
#restrictedgod 86
#end

#newmonster 2247
#copystats 874 -- Divine Emperor
#copyspr 874 -- Divine Emperor
#restrictedgod 86
#end


-------- SITES -----------

#newsite 853
#name "Sancta Sophia"
#path 8
#level 0
#rarity 5
#gems 4 2
#gems 1 1
#homecom 2219 -- Theurg Artisan
#homemon 2221 -- Varangian Guard
#homecom 2222 -- Varangian Captain
#end

#newsite 854
#name "Alchemy Guildhouse"
#path 0
#level 2
#rarity 5
#gems 0 1
#gems 2 1
#homemon 2225 -- Pyrote
#homecom 2218 -- Imperial Alchemist
#end



-------- Spells

#newspell -- Copy of "Contact Harbinger". We can't copy it directly as that would also give it to Marignon and vanilla Pythium.
#name "Contact Harbinger"
#effect 10021
#damage 464
#nreff 1
#school 0
#path 0 1
#path 1 4
#pathlevel 0 2
#pathlevel 1 3
#fatiguecost 2800
#researchlevel 5
#restricted 86
#end

#newspell -- Copy of "Angelic Host". We can't copy it directly as that would also give it to Marignon and vanilla Pythium.
#name "Angelic Host"
#effect 10037
#damage 543
#nreff 6
#researchlevel 7
#school 0
#path 0 0
#path 1 4
#pathlevel 0 3
#pathlevel 1 4
#fatiguecost 5500
#restricted 86
#end

#selectspell "Heavenly Wrath"
#restricted 86
#end

#selectspell "Heavenly Choir"
#restricted 86
#end

#newspell
#name "Prayer of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Sealtiel,
the Prayer of the Lord, most serene of the Archangels."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 86
#school 0
#effect 10021
#damage 2229
#nreff 1
#end

#newspell
#name "Healing of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Raphael,
the Healing of the Lord, Archangel of thought and serenity and protector of science and medicine."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 86
#school 0
#effect 10021
#damage 2230
#nreff 1
#end

#newspell
#name "Blessing of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Barachiel,
the Blessing of the Lord. Barachiel is responsible for the distribution of the Lord's blessings, and has dominance over the skies and thunder."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 86
#school 0
#effect 10021
#damage 2231
#nreff 1
#end

#newspell
#name "Glory of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Jegudiel,
Glorifier of the Lord, the serene protector of the arts and of honest labour."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 86
#school 0
#effect 10021
#damage 2232
#nreff 1
#end

#newspell
#name "Man of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Gabriel,
the Man of the Lord, a mighty warrior and divine messenger."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 86
#school 0
#effect 10021
#damage 2233
#nreff 1
#end

#newspell
#name "Light of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Uriel,
the Light of the Lord, protector of the sun."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 86
#school 0
#effect 10021
#damage 2234
#nreff 1
#end



-selectspell "Release Lord of Civilization"
-name "Theosis"
-descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned with this spell as the greatest Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. "
-path 0 4
-path 1 8
-pathlevel 0 5
-pathlevel 1 3
-fatiguecost 5000
-researchlevel 7
-restricted 86
-school 0
-end

#newspell
#copyspell "Holy Avenger"
#name "Epicusdom"
#effect 1
#damage 2235
#nextspell "Divine Blessing"
#school -1
#end

#newspell
#copyspell "Holy Avenger"
#name "Calling of the Seventh"
#descr "This spell will summon the seventh and the most glorious of all Archangels. He resisted the poisonous lies of Belial, withstood the plague wind of Pazazu, endured the heat Buer and persisted under the blows of Belphegor to cast them all to inferno at the dawn of time. He is The Warrior from Heaven, whose mere name is a riddle only the righteous can answer. He is the guardian of the Divine Kingdom and his tasks are great, but still he will come if summoned by this spell to fight for one battle to guard the righteous. The mere presence of the Seventh will fill the battlefield with divine judgement, which will make all demons take twice as much damage from attacks."
#researchlevel 7
#school 0
#path 0 8
#pathlevel 0 7
#damage 83
#effect 81
#nextspell "Epicusdom"
#fatiguecost 0
#spec 128
#restricted 86
#end

#newspell
#copyspell "Poison Touch"
#name "Pyros Poison"
#school -1
#researchlevel 0
#aoe 1
#explspr 10140
#end

#newspell
#name "Alchemist's Flame"
#descr "This spell devised by the Imperial guild of alchemists will shoot a great bolt of pure Pyros towards the enemies of the Empire. Pure and undistilled Pyros is highly toxic and opponents who manage to survive the flames will most likely be poisoned."
#researchlevel 2
#school 2
#path 0 0
#path 1 2
#pathlevel 0 1
#pathlevel 1 1
#damage 1012
#effect 2
#aoe 1
#range 25
#prec -1
#spec 96
#flightspr 10097
#explspr 10051
#nextspell "Pyros Poison"
#fatiguecost 25
#restricted 86
#end


#newspell
#copyspell "Holy Avenger"
#name "Divine Protection"
#descr "This spell will allow the caster and his communion to benefit from divine protection. Their bodies will become hard like stone and will strengthen their minds to be impenetrable by heretical sorcery. Their new divine form will also be greatly resistant to fire, lighting and poison. The divine energies released during the casting of this spell will temper the armors of all nearby friendly soldiers, making them more durable."
#school 8
#researchlevel 0
#path 0 8
#pathlevel 0 5
#damage 83958784
#effect 10
#spec 128
#explspr 10217
#nextspell "Legions of Steel"
#fatiguecost 0
#restricted 86
#end


#newspell
#copyspell "Holy Avenger"
#name "Divine Power"
#descr "This spell will fill the caster and his communion with divine might, increasing their potency in water and fire magic. If there is a storm raging on the battlefield, they will also receive more power in air magic. The divine energies released during the casting of this spell will increase the strength of all units nearby the caster."
#school 8
#researchlevel 0
#path 0 8
#pathlevel 0 6
#damage 794624
#nextspell "Strength of Giants"
#effect 23
#spec 128
#fatiguecost 0
#restricted 86
#end


-----Changes to Ark
#selectspell 34 
#descr "A Divine Wrath has struck this battlefield, either by the artifact Ark or by a holy communion of Pythian Theurgs. For the duration of the battle, all non-sacred units will be smitten with blindness and disease."
#end

#newspell
#copyspell "Holy Avenger"
#name "Divine Wrath"
#descr "This spell will call upon the righteous wrath of the Celestial Sphere on the battlefield. All units that are not sacred followers of the Awakening God will be smitten by blindness and disease as they gaze upon the holy brillance brought forth by this spell. Undead are especially prone disintegrate in front of the divine brilliance."
#school 5
#researchlevel 7
#path 0 8
#pathlevel 0 8
#damage 58
#effect 81
#explspr 10243
#fatiguecost 0
#restricted 86
#end

-------- NATIONS ---------

#selectnation 86
#name "Pythium "
#epithet "The Second Empire"
#era 2
#idealcold 0
#brief "Pythium, The Second Empire"
#descr "The Empire of Pythium is a splinter empire of the great Empire of Ermor. As dark arts were practised in the heart of the Empire, the stars warned the Theurgs of Pythia to flee the impending doom. They led Pythia away from the falling Empire and formed a glorious Second Empire under their wise rule. However, as Ermor crumbled, the provinces of Pythium rebelled and became independent. Emperors of Pythium could not reclaim the rebelling lands and the power of the Second Empire diminished over the centuries. The Pythian army is based on the old legionnaire army of Ermor with some modifications. During the rebellions, barbarians from distant lands tried to conquer the glorious capital, but were beaten back by northern mercenaries hired by the Emperor. With time, these mercenaries have become an integral part of the Pythian military. Theurgs are also supporters of sciences and the famous alchemists of Pythium have recently invented new weapons to fight the legions of the Fallen Empire."
#summary "
Race: Humans

Military: Legionnaires, Northern Mercenaries and Alchemist's Fire

Magic: Astral, Air, Fire, Water and some Earth. 

Priests: Powerful"
#flag "./Byzantine/Byzantine_icon.tga"
#templepic 6
#labcost 500
#templecost 400


---- SITES
#startsite "Sancta Sophia"
#startsite "Alchemy Guildhouse"


---- RECRUITS


#addrecunit 50 -- Slingers
#addrecunit 2210 -- Velite
#addrecunit 685 -- Alae Legionnaire
#addrecunit 2212 -- Hastatus
#addrecunit 2226 -- Principe
#addrecunit 2227 -- Triarius
#addrecunit 2209 -- Battle Vestal
#addrecunit 2223 -- Kataphraktoi
#addrecunit 2224 -- Verdariotai


---- LEADERS

#addreccom 2220 -- Ambassador
#addreccom 2217 -- Cultist
#addreccom 683 -- Centurion
#addreccom 2211 -- Legatus Legionis
#addreccom 538 -- Theurg Communicant
#addreccom 2206 -- Theurg Acolyte
#addreccom 2207 -- Theurg 



----- HEROES


#multihero1 2208 -- Arch Theurg
#hero1 2213 -- Patriarch
#hero2 2214 -- Alchemy Guildmaster
#hero3 2215 -- Man from North



------- STARTING UNITS & PD

#startcom 2228 -- Emperor
#startscout 2220 -- Ambassador
#startunittype1 2221 -- Varangian Guard
#startunitnbrs1 5
#startunittype2 2210 -- Levite
#startunitnbrs2 20


#defcom1 683 -- Centurion
#defcom2 2211 -- Legatus Legionis

#defunit1 2210 -- Velite
#defunit1b 685 -- Alae Legionnaire
#defunit2 2212 -- Hastatus

#defmult1 20  -- 2x Velite per level
#defmult1b 10 -- 1x Alae Legionnaire per level
-- These should be swapped, but I can't get the Alae Legionnaires to appear!


------  FORTS

-- Taken from the manual entries for MA Pythium
#startfort 31 -- Great City
#defaultfort 3 -- Fortified City
#mountainfort 37 -- Hill Fortress
#swampfort 11 -- Swamp Fort
#forestfort 34 -- Forest Fortress

#end
