#modname "LA Nation: Vaettiheim"

#description "Creates a nation of exiled Vaetti and Gygjas in the late era. Based on a sample mod by QM."

#icon "./Vaettiheim/vaettibanner.tga"


#version 2.4


--- v 2.4

-- FIX - IDs remapped for MC compliance

-- FIX - Spero Chief gets proper armour


--- V 2.3

-- Problems with banner and flag file locations fixed



--- V 2.2

-- All copystats replaced with actual stats

-- Many changes to ID numbers

-- Changed the role of the Wolf Lord to make him less of a call allies monkey

-- Replaced the werewolf spy with a simple and very cheap Vaetti scout

-- Exile Guard no longer cap only

-- Troll Druid gets +1 nature in a forest

-- Prettied up the flag and banner a bit


----Mod uses ID Numbers --

--Nation 92

--Armor 275

--Weapons 691

--Monsters 2393-2420

--Sites 887-889



---- ITEMS

--ARMOR

#newarmor 275
#name "Dire Wolf Furs"
#type 5
#prot 7
#def 0
#enc 1
#rcost 2
#end

--WEAPONS

#newweapon 691
#name "Vaetti Pickaxe"
#dmg 7
#att -2
#def -2
#len 2
#rcost 6
#end

---- UNITS



-- Vaetti spear

#newmonster 2400

#copyspr 541
#name "Vaetti"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating from 
the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die to protect
a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their wolven friends.
Vaetti are small and stealthy and can hide in enemy territories."
#size 1
#gcost 8
#rcost 1
#hp 8
#mor 9
#mr 12
#enc 3
#str 9
#att 10
#def 10
#prec 9
#ap 10
#mapmove 2
#forestsurvival
#stealthy 0
#weapon "Spear"
#armor "Full Leather Armor"
#armor "Shield"
#armor "Leather Cap"
#end

-- Vaetti Netter

#newmonster 2401
#name "Vaetti Netter"
#spr1 "./Vaettiheim/Vaetti Netter.tga"
#spr2 "./Vaettiheim/Vaetti Netter2.tga"
#descr "Originally employed against the werewolves, dire wolves, forest trolls, speros and numerous other inhabitants of Crescent Woods that initially tried to maim or devour the interloping Vaetti, the netters have become an important part of any wolfkin army. Mixed in with spearmen or more powerful Vaetti allies they use their nets to drag down and overwhelm even the most powerful foes. Netters are generally experienced and canny fighters with a little more fight in them than their spear armed brothers, though they are more vulnerable to missile fire."
#weapon "dagger"
#armor "furs"
#armor "leather cap"
#weapon "net"
#gcost 10
#hp 8
#prec 9
#mor 10
#mr 12
#enc 3
#rcost 1
#str 9
#att 11
#def 11
#mapmove 2
#ap 8
#forestsurvival
#stealthy 0
#size 1
#end

-- Vaetti Archer

#newmonster 2402

#name "Vaetti Archer"
#spr1 "./Vaettiheim/Vaetti Archer.tga"
#spr2 "./Vaettiheim/Vaetti Archer2.tga"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating from 
the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die to protect
a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their wolven friends. 
Vaetti are small and stealthy and can hide in enemy territories."
#weapon "short bow"
#weapon "dagger"
#armor "furs"
#armor "leather cap"
#gcost 9
#hp 8
#prec 9
#mor 9
#mr 12
#enc 3
#rcost 1
#str 9
#att 10
#def 10
#mapmove 2
#ap 8
#forestsurvival
#stealthy 0
#size 1
#end


-- Vaetti Groundbreaker

#newmonster 2403
#name "Vaetti Groundbreaker"
#spr1 "./Vaettiheim/Vaetti Groundbreaker.tga"
#spr2 "./Vaettiheim/Vaetti Groundbreaker2.tga"
#descr "Vaetti groundbreakers are tasked with with hacking into the frozen ground to find rocks saturated with wild magic; the favoured food of the forest trolls. In order that they may keep working tirelessly the Gygja provide them a diet of broth laced with strength potion. They have proven to be hardy and useful infantry, particularly when the Vaetti need to break into enemy fortifications."
#weapon 691
#armor "full leather armor"
#armor "leather cap"
#armor "shield"
#gcost 11
#hp 9
#prec 9
#mor 10
#mr 13
#enc 3
#rcost 1
#str 11
#att 10
#def 10
#coldres 25
#mapmove 2
#ap 8
#siegebonus 2
#size 1
#forestsurvival
#stealthy 0
#end


-- Vaetti Wolf Rider


#newmonster 2404

#copyspr 282
#name "Wolf Rider"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating
from the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die
 to protect a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their
 lupine friends. Vaetti are small and stealthy and can hide in enemy territories."

#size 2
#ressize 1
#gcost 20
#rcost 1
#hp 8
#mor 9
#mr 12
#enc 4
#str 9
#att 10
#def 10
#prec 9
#ap 22
#mapmove 3
#mounted
#stealthy 0
#forestsurvival
#weapon 20
#weapon "Spear"
#armor "Full Leather Armor"
#armor "Shield"
#armor "Leather Cap"
#end



-- Vaetti Moose Riders

#newmonster 2405
#copyspr 1085
#name "Moose Riders"
#descr "After the success of using wolves as mounts in battle, some Vaetti sought to improve that strategy with a larger animal. They settled upon the great moose, one of the largest beasts in the forest, known for its foul temper and impressive strength. With the help of the Gygjas the Vaetti made allies of these huge creatures and now they are used in battle as mounts for a pair of Vaetti archers who can do little more than hold on when the moose starts to kick and gore foes who stray too close."
#size 4
#rcost 1
#gcost 35
#hp 38
#prot 4
#mor 9
#mr 9
#enc 4
#prec 9
#att 10
#def 9
#prec 9
#ap 24
#mapmove 3
#weapon "Moose Kick"
#weapon "Antlers"
#weapon "Short Bow"
#weapon "Short Bow"
#animal
#end

--Werewolf


#newmonster 2406

#copyspr 854
#name "Werewolf"
#descr "Long since exiled from human society, a great pack of werewolves has grown and prospered in the lands of the Vaetti, turning to their wild instincts and casting their human forms aside entirely. With the coming of the awakening God they now stream from the forests alongside the Wolf Kin, seeking new prey and looking to settle old scores. Over long distances they travel on all fours and are thus capable of keeping pace with wolfriders and other fast moving troops."

#size 3
#gcost 30
#rcost 1
#hp 20
#prot 6
#mor 15
#mr 14
#enc 2
#str 14
#att 13
#def 12
#prec 7
#ap 16
#mapmove 3
#weapon 20 -- bite
#weapon 29 -- claw
#weapon 29 -- claw
#regeneration 10

#forestsurvival
#stealthy 0

#maxage 200
#end


--Exile Guard



#newmonster 2407

#copyspr 283

#name "Exile Guard"


#descr "When the Vaetti departed Jotunheim, a major concern was the safety of the 
Gygjas accomanying them. Many of the chiefs and their most respected warriors choose to give up their 
former lives and dedicate themselves to safeguarding the Gygjas. Known as the Exile Guard, 
their heroic actions during the wanderings are know to all Wolf Kin. With the Vaetti thriving in their new homeland and the Gygja safer than ever, the Exile Guard have extended their role to protect their entire race and their ranks have swollen considerably. It is the highest honour 
for a young Vaetti to be accepted into the Guard and they can be relied on to give a good account of themselves in battle."

#size 2
#gcost 32
#rcost 1
#ressize 1
#hp 10
#mor 12
#mr 12
#enc 4
#str 10
#att 11
#def 11
#mounted
#ap 22
#mapmove 3
#prec 10
#holy
#forestsurvival
#stealthy 0
#weapon "Short Sword"
#weapon 20 -- bite
#armor "Full Leather Armor"
#armor "Reinforced Leather Cap"
#armor "Shield"
#secondtmpshape 284 -- wolf
#end




--Spero Warrior


#newmonster 2408
#name "Spero Warrior"
#spr1 "./Vaettiheim/Spero Warrior.tga"
#spr2 "./Vaettiheim/Spero Warrior2.tga"
#descr "The Spero are a reclusive tribe of winged lizardlike humanoids who have long reigned over Crescent Peak and the surrounding mountains. Initially they fought with the newly arrived Vaetti, believing them to small and weak; mere prey to be devoured. However the Spero soon learned to fear the magic of the Gygja and their hags and as the trolls and wolfkind of the woods allied with the Vaetti, the chiefs realised the Spero too could benefit from such a treaty. The Spero are now valuable allies who excel at swift strikes against vulnerable foes such as archers. Though they resemble coldblooded lizards, the Spero are not coldblooded and resist the freezing weather of the peaks due to some innate magic. Their favoured technique is to 'divebomb' their targets, impaling them with their spear."
#hp 15
#size 3
#prot 4
#mor 10
#mr 10
#enc 4
#str 12
#att 10
#def 11
#prec 10
#mapmove 3
#ap 12
#gcost 26
#rcost 1
#weapon "light lance"
#weapon 20
#armor "leather cuirass"
#flying
#coldres 75
#mountainsurvival
#nametype 113
#end


--Forest Troll

#newmonster 2409
#copyspr 518
#name "Forest Troll"
#descr "The Vaetti needed to call on all the allies they could in their exile; while they initially avoided or even fought the native trolls of the forest, the Gygjas soon negotiated a beneficial relationship between goblin and troll. The Vaetti hack into the cold hard ground to find the choicest old rocks for the trolls to eat and in return they receive a powerful ally in battle. Forest trolls are slightly smaller than their mountain cousins. Unlike the Jotun, the trolls have neither the will nor the numbers to impose servitude on the Vaetti."
#size 3
#gcost 60
#rcost 11
#hp 31
#prot 11
#mor 12
#mr 14
#enc 3
#str 20
#att 10
#att 9
#prec 8
#mapmove 2
#ap 14
#neednoteat
#fireres -25
#darkvision 50
#regeneration 15
#mountainsurvival
#forestsurvival
#weapon "Great Club"
#armor "Furs"
#maxage 400
#end


--Wolf Troll

#newmonster 2410
#copyspr 1037
#name "Wolf Troll"
#descr "The Wolf Trolls were the first of their kind to aid the Vaetti, saving an ancient Gygja from a group of human bandits encroaching on the forests. These trolls earned the respect and blessing of the Gygja and were trained to become a sacred elite amongst the Vaetti forces. They are extremely loyal, excellent fighters who have become fully integrated into the religion of the Vaetti. They are armed with heavy stone mauls and draped in blessed Dire Wolf furs. Unlike the Jotun, the trolls have neither the will nor the numbers to impose servitude on the Vaetti."
#size 3
#gcost 100
#rcost 13
#hp 35
#prot 11
#mor 14
#mr 14
#enc 3
#str 22
#att 11
#att 9
#prec 8
#mapmove 2
#ap 14
#neednoteat
#fireres -25
#coldres 25
#darkvision 50
#regeneration 15
#mountainsurvival
#forestsurvival
#weapon "Maul"
#armor "Dire Wolf Furs"
#holy
#standard 4
#maxage 400
#end


---- LEADERS


-- Chief


#newmonster 2411

#copyspr 283
#name "Vaetti Chief"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins
originating from the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a
Vaetti would gladly die to protect a Gygja in danger. The Wolf Kin wear heavy furs, and
some ride into battle mounted on their wolven friends. Vaetti are small and stealthy and can
hide in enemy territories. Chiefs are local tribal leaders, reduced in importance since the
 rise of the Wolf Lords."

#size 2
#gcost 50
#rcost 1
#ressize 1
#hp 10
#mor 10
#mr 12
#enc 4
#str 9
#att 10
#def 10
#prec 10
#ap 22
#mapmove 3
#okleader
#stealthy 0
#forestsurvival
#weapon "Short Sword"
#weapon 20
#armor "Reinforced Leather Cap"
#armor "Full Leather Armor"
#armor "Shield"
#nametype 115

#end




-- Vaetti Scout


#newmonster 2412
#name "Vaetti Scout"
#spr1 "./Vaettiheim/Vaetti Archer.tga"
#spr2 "./Vaettiheim/Vaetti Archer2.tga"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating from 
the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die to protect
a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their wolven friends. 
Vaetti are small and stealthy and can hide in enemy territories."
#weapon "short bow"
#weapon "dagger"
#armor "furs"
#armor "leather cap"
#gcost 15
#hp 8
#prec 9
#mor 9
#mr 12
#enc 3
#rcost 1
#str 9
#att 10
#def 10
#mapmove 2
#ap 8
#forestsurvival
#stealthy 10
#size 1
#end


--Wolf Lord


#newmonster 2413


#copyspr 508
#gcost 90
#rcost 2
#name "Wolf Lord"

#descr "Wolf Lords are Vaetti of great cunning and strength who, out of the shadow of the giants,
have taken rulership as generals and priests of the Vaetti. They are now the highest authoriry of
the tribes, defering only to the Gygjas when they choose to make their wishes known. Wolf Lords 
often ride white wolves decended from the offspring of Angerboda, Mother of Monsters. They are well
 known even among the wolves of the woods and each month a lupine ally will come to their side."
#weapon 1

#weapon 20

#armor "Shield"

#armor "Iron Cap"

#armor "Full Leather Armor"

#forestsurvival
#nametype 115

#mounted

#str 10
#size 2
#hp 11

#mr 11
#att 12

#def 12

#mor 13
#enc 4
#mapmove 3

#ap 24

#magicskill 8 1

#holy

#standard 10
#goodleader

#summon1 "wolf"
#end


--Spero Chief



#newmonster 2414
#spr1 "./Vaettiheim/Spero Chief.tga"
#spr2 "./Vaettiheim/Spero Chief2.tga"
#name "Spero Chief"
#descr "The Spero are a reclusive tribe of winged lizardlike humanoids who have long reigned over Crescent Peak and the surrounding mountains. Initially they fought with the newly arrived Vaetti, believing them to small and weak; mere prey to be devoured. However the Spero soon learned to fear the magic of the Gygja and their hags and as the trolls and wolfkind of the woods allied with the Vaetti, the chiefs realised the Spero too could benefit from such a treaty. The Spero are now valuable allies who excel at swift strikes at weak points in enemy armies. Despite their appearance they are not coldblooded and resist the cold of the peaks due to some innate magical field. The Spero chieftans have a weakness for shiny trinkets and by granting them gilded scale mail obtained during the long journey, the Gygja secured their utmost loyalty."
#hp 16
#size 3
#prot 4
#mor 11
#mr 10
#enc 4
#str 13
#att 11
#def 11
#prec 10
#mapmove 3
#ap 12
#gcost 90
#rcost 1
#weapon "axe"
#weapon 20
#armor "Scale Mail Cuirass"
#armor "Half Helmet"
#flying
#coldres 75
#mountainsurvival
#nametype 113
#end


--Vaetti Hag


#newmonster 2415
#name "Vaetti Hag"
#copyspr 913

#descr "Some Vaettis have learned the secrets of Seith. As long as they do not learn too much, the Gygjas 
allow them to continue their practices. Since the Exile, the remaining Gygjas have been more accepting of
 Vaetti magic and even encouraged it in the case of particularly talented Vaetti females."
#gcost 60
#size 1
#rcost 1
#hp 7
#mor 9
#mr 14
#enc 3
#str 8
#att 8
#def 8
#prec 9
#ap 10
#mapmove 2
#poorleader
#weapon "Dagger"
#armor "Leather Cuirass"
#armor "Leather Cap"
#forestsurvival
#stealthy 0
#custommagic 30720 100
#custommagic 28672 30
#nametype 116
#female
#startage 50
#end

--Vaetti Sorcerer

#newmonster 2416
#spr1 "./Vaettiheim/Vaetti Sorcerer.tga"
#spr2 "./Vaettiheim/Vaetti Sorcerer2.tga"
#name "Vaetti Sorcerer"
#descr "Although the Gygja were slowly passing more knowledge of the Seith down to their Vaetti assistants, some of the magically gifted wolfkin hungered for more knowledge and power. They dared not move directly against the Gygja, but they realised that following the way of Seith was actually limiting their progress, so they formed an order devoted to dark and powerful arts used by humans. The order of sorcerers has expanded rapidly and some predict a clash with the dwindling Gygja over control of the Vaetti nation. For now though, the Gygja are sacred representatives of the awakening God and the sorcerers must obey their edicts."
#gcost 125
#size 1
#rcost 1
#hp 7
#mor 9
#mr 14
#enc 3
#str 8
#att 8
#def 8
#prec 9
#ap 10
#mapmove 2
#poorleader
#weapon "Stick"
#armor "Leather Cuirass"
#armor "Leather Cap"
#forestsurvival
#stealthy 0
#nametype 115
#magicskill 5 1
#magicskill 7 1
#custommagic 22528 100
#custommagic 30720 20
#startage 40
#end


--Troll Druid

#newmonster 2417
#spr1 "./Vaettiheim/Troll Druid.tga"
#spr2 "./Vaettiheim/Troll Druid2.tga"
#name "Forest Troll Druid"
#descr "Before the arrival of the Vaetti the forest trolls were ruled by reclusive druids who communed with the spirits of the wood and its inhabitants. When the Gygjas came these same druids recognised that they were outmatched magically and gathered at their most sacred tree seeking spiritual guidance. The signs were clear; the Gygja clearly carried the favour of the forest and must be supported. Though they do not follow the way of Seith, the shamans have integrated themselves into Vaetti society, upholding the will of the awakening god. Their natural magic is more powerful in the forests."
#gcost 185
#rcost 10
#holy
#weapon "quarterstaff"
#size 3
#hp 30
#prot 11
#mor 13
#enc 3
#str 20
#att 10
#def 9
#prec 9
#ap 14
#mapmove 2
#poorleader
#fireres -25
#researchbonus -1
#rcost 15
#mountainsurvival
#forestsurvival
#regeneration 15
#darkvision 50
#neednoteat
#magicskill 8 1
#magicskill 6 2
#magicskill 3 1
#custommagic 9216 10
#nametype 137
#forestshape 2418
#maxage 400
#older 150
#end


--Troll Druid

#newmonster 2418
#spr1 "./Vaettiheim/Troll Druid.tga"
#spr2 "./Vaettiheim/Troll Druid2.tga"
#name "Forest Troll Druid"
#descr "Before the arrival of the Vaetti the forest trolls were ruled by reclusive druids who communed with the spirits of the wood and its inhabitants. When the Gygjas came these same druids recognised that they were outmatched magically and gathered at their most sacred tree seeking spiritual guidance. The signs were clear; the Gygja clearly carried the favour of the forest and must be supported. Though they do not follow the way of Seith, the shamans have integrated themselves into Vaetti society, upholding the will of the awakening god. Their natural magic is more powerful in the forests."
#gcost 185
#rcost 10
#holy
#weapon "quarterstaff"
#size 3
#hp 30
#prot 11
#mor 13
#enc 3
#str 20
#att 10
#def 9
#prec 9
#ap 14
#mapmove 2
#poorleader
#fireres -25
#researchbonus -1
#rcost 15
#mountainsurvival
#forestsurvival
#regeneration 15
#darkvision 50
#neednoteat
#magicskill 8 1
#magicskill 6 2
#magicskill 3 1
#custommagic 9216 10
#magicboost 6 1
#nametype 137
#plainshape 2417
#maxage 400
#older 250
#end


--Gygja


#newmonster 2419

#name "Gygja"
#copyspr 785

#descr "A Gygja is an ancient Jotun Hag. Over the centuries, they have grown in size and malice.
Gygjas are skilled in the dark witchcraft known as Seith. They are considered sacred by the Vaetti,
and a few have accompanied them in exile. They now reside in a deeply shaded wood on the north face of 
Crescent Mountain."

#gcost 290
#rcost 1
#size 4
#hp 38
#prot 5
#mor 12
#mr 17
#enc 3
#str 18
#att 9
#def 8
#prec 10
#ap 14
#mapmove 2
#okleader
#magicskill 5 1
#magicskill 6 1
#magicskill 7 1
#custommagic 30720 100
#custommagic 30720 100
#custommagic 30720 10
#forestsurvival
#mountainsurvival
#maxage 300
#startage 500
#holy

#weapon "Quarterstaff"
#armor "Furs"
#nametype 116
#female
#end






---- HEROES



--Crescent Hermit

#newmonster 2420
#spr1 "./Vaettiheim/Vaetti Hermit.tga"
#spr2 "./Vaettiheim/Vaetti Hermit2.tga"
#name "Crescent Hermit"

#descr "When the Vaetti scouts found the Crescent Woods and identified them as a suitable final destination of the great journey, they rushed to return to the main body of the people to tell them the good news. At least most of them did. One scout, too tired and weak to return, was left behind and began to climb Crescent Mountain, seeking no more than a place to die in peace. None can say what happened to him as he climbed to the very peak, but when the Vaetti finally arrived they soon learned of a mage feared by the Spero and upon contacting this enigmatic figure, found it was the scout. He is adept in a form of magic alien to the Vaetti; the magic of mountain peaks are fierce storms. It was this reclusive hermit that first arranged negotiations between the spero chiefs and the Gygjas and it is said when the Vaetti face great danger he will descend from the mountain and come to their aid."

#size 1
#rcost 1
#hp 7
#mor 9
#mr 14
#enc 3
#str 8
#att 8
#def 8
#prec 9
#ap 10
#mapmove 2
#poorleader
#weapon "Dagger"
#armor "Leather Cuirass"
#armor "Leather Cap"
#forestsurvival
#mountainsurvival
#stealthy 0
#nametype 116
#magicskill 1 2
#magicskill 4 1
#magicskill 6 2
#gcost 1
#itemslots 31878
#maxage 90
#startage 70
#end




--Werewolf Assassin


#newmonster 2399
#spr1 "./Vaettiheim/Black Werewolf.tga"
#spr2 "./Vaettiheim/Black Werewolf2.tga"
#name "Black Werewolf Assassin"
#descr "This poor soul was once an assassin in the employ of the Marignese inquisition whose skills made
 him the weapon of choice aginst enemies of the church. It was his misfortune, however, to be sent 
against a baron in the bordering lands of Ulm. As the assassin attacked the Baron transformed into a werewolf and a terrible struggle for survival ensued. Though he eventualy managed to impale him on a silver candle stick,
 the assassin recieved many bites in the process and soon discoved he had contracted Lythantropy himself. Not 
being foolish enough to return to the inquisition in such a state, he instead took to wandering, and eventually 
found a place in the halls of the Wolf Kin, renouncing his human form forever."
#size 3
#gcost 1
#rcost 1
#hp 23
#prot 6
#mor 15
#mr 14
#enc 2
#str 14
#att 14
#def 13
#prec 8
#ap 16
#mapmove 3
#weapon 20 -- bite
#weapon 29 -- claw
#weapon 29 -- claw
#regeneration 10

#forestsurvival
#stealthy 20
#nametype 114
#noleader
#itemslots 31878
#maxage 200
#assassin
#end




--Troll Wildrider

#newmonster 2398
#copyspr 1086
#name "Troll Wildrider"
#descr "This famed Wolf Troll displayed incredible determination in a series of battles with a rampaging minotaur berserker. The two clashed again and again; each time the troll was struck down and each time he somehow managed to get to his feet and continue the pursuit, determined to remove the threat to the Gygjas. Unable to catch the enraged creature on foot he desperately clambered onto a particularly large and vicious looking forest moose. The rest is history; the triumphant Wildrider took his foes' massive flail as a trophy and continues to protect Vaetti territory mounted on the strongest of the moose herd that year."
#size 5
#gcost 1
#rcost 1
#hp 60
#prot 11
#mor 16
#mr 14
#enc 3
#str 24
#att 13
#att 12
#prec 8
#mapmove 3
#ap 24
#fireres -25
#darkvision 50
#mountainsurvival
#forestsurvival
#armor "Dire Wolf Furs"
#holy
#standard 10
#regeneration 30
#neednoteat
#coldres 25
#maxage 400
#mounted
#weapon 353
#mounted
#okleader
#holy
#weapon 353
#weapon "flail"
#weapon "antlers"
#end


--White Werewolf

#newmonster 2397
#spr1 "./Vaettiheim/White Werewolf.tga"
#spr2 "./Vaettiheim/White Werewolf2.tga"
#name "White Werewolf"
#descr "The infamous White Werewolf of the Crescent Woods is the leader of a truly massive pack of lycanthropes who have chosen never to revert to human form. He is a ferocious fighter and due to his dedication to protecting the woods, he has become something of a religious symbol to the Vaetti; proof of their blessed nature. The White Werewolf can call his brethren to aid him."
#size 3
#gcost 1
#rcost 1
#hp 34
#prot 8
#mor 20
#mr 14
#enc 2
#str 17
#att 14
#def 13
#prec 8
#ap 16
#mapmove 3
#weapon 20 -- bite
#weapon 29 -- claw
#weapon 29 -- claw
#regeneration 25
#forestsurvival
#stealthy 10
#nametype 114
#goodleader
#itemslots 31878
#maxage 200
#makemonster3 2406
#holy
#end 


---- PRETENDERS


--Crescent Moon Wolf


#newmonster 2396
#copyspr 1229
#name "Wolf of the Crescent Moon"
#descr "This giant wolf-mother of Crescent Woods is as ancient as the moon itself and draws constant power from it. While she is within her own hunting grounds many wolves will follow the powerful lunar pull and form a pack to protect their patron goddess. In addition to her feral understanding of the magic of wood and wild, she can howl in tune with the music of the spheres. Her great size and ferocity brings fear to the hearts of the bravest intruders. She is stronger while in a forest and more wolves will hear her call."
#magicskill 6 1
#magicskill 4 1
#stealthy 20
#goodleader
#forestsurvival
#startdom 3
#coldres 25
#fear 2
#itemslots 12288
#mountainsurvival
#size 6
#gcost 75
#pathcost 80
#weapon 20
#hp 90
#prot 9
#mor 30
#mr 18
#enc 2
#str 23
#att 12
#def 11
#prec 9
#ap 30
#mapmove 3
#restrictedgod 92
#domsummon2 "wolf"
#forestshape 2395
#darkvision 100
#maxage 2000
#end

--Crescent Moon Wolf


#newmonster 2395
#copyspr 1229
#name "Wolf of the Crescent Moon"
#descr "This giant wolf-mother of Crescent Woods is as ancient as the moon itself and draws constant power from it. While she is within her own hunting grounds many wolves will follow the powerful lunar pull and form a pack to protect their patron goddess. In addition to her feral understanding of the magic of wood and wild, she can howl in tune with the music of the spheres. Her great size and ferocity brings fear to the hearts of the bravest intruders. She is stronger while in a forest and more wolves will hear her call."
#magicskill 6 1
#magicskill 4 1
#stealthy 20
#goodleader
#forestsurvival
#coldres 25
#fear 2
#itemslots 12288
#mountainsurvival
#size 6
#gcost 75
#weapon 20
#hp 110
#prot 9
#mor 30
#mr 18
#enc 2
#str 25
#att 13
#def 12
#prec 9
#ap 30
#mapmove 3
#domsummon "wolf"
#plainshape 2396
#darkvision 100
#maxage 2000
#end



--Father of Winters


#newmonster 2393
#copyspr 1561

#copystats 1561

#restrictedgod 92

#end

--Monolith


#newmonster 2394
#copyspr 657

#copystats 657

#restrictedgod 92

#end





---SPELLS


#newspell
#name "Wolfcall"
#descr "Calls some lesser wolves of the Crescent Woods to join your forces. The more powerful the caster the more wolves will be attracted." 
#school 0
#restricted 92
#researchlevel 0
#path 0 6
#pathlevel 0 1
#effect 10001
#fatiguecost 200
#damage 284
#nreff 1007
#end


#newspell
#name "Wolves of the Crescent"
#descr "A pack of the largest and most aggressive wolves of the Crescent Woods surges to protect the caster and hunt down his enemies."
#school 0
#restricted 92
#researchlevel 3
#path 0 6
#pathlevel 0 2
#effect 10001
#fatiguecost 1200
#damage 1224
#nreff 18
#end




---- MAGIC SITES



#newsite 887

#name "Crescent Mountain"


#path 3


#level 0


#rarity 5


#gems 4 1

#homemon 2408
 -- Spero Warrior
#homecom 2414 -- Spero Chief
#end



#newsite 888
#name "Crescent Wood"

#path 6

#level 0

#rarity 5

#gems 6 1
#gems 5 1

#homecom 2419 -- Gygja
#end

#newsite 889
#name "Troll Stomping Grounds"
#path 6
#level 0
#rarity 5
#gems 3 1
#homemon 2410
#homecom 2417
#end







---- NATION

#selectnation 92


#clearnation

#clearsites

#name "Vaettiheim"

#epithet "Exiled Tribes"

#startsite "Crescent Mountain"

#startsite "Troll Stomping Grounds"
#startsite "Crescent Wood"


#templepic 12

#era 3

#flag "./Vaettiheim/vaettiflag.tga"

#descr "The Vaetti, once allies of the Jotun, were in recent times displaced by human settlers.
When starvation finaly forced them to leave the lands of Jotun, a few of the remining, disatisfied
Gygjas were convinced to lead to them into exile. Years of wandering eventually brought them to the lands of the crescent moon, a place occupied by tribes of winged Spero and trolls. 
In the time since the exile, Vaetti elites have risen to take the place of the giants in their society,
and the Gygjas have been more accepting of Vaetti magic."

#summary "Race: Small, stealthy troops, prefers cold scale +1


Military: Light Vaetti infantry, wolf riders, flying Spero
, powerful trolls

Magic: Nature, Death, Astral, Blood

, Earth 	
Priests: Weak"

#brief "Gygjas skilled in sorcery oversee tribes of exiled Vaetti who have become steadily more organized
 and independent."

#color 0.1 0.5 0.3


--Sets what forts they will use.

#startfort 42
#defaultfort 7

#farmfort 7
#mountainfort 9
#swampfort 11
#forestfort 34

--Causes them to prefer cold 1.

#idealcold 1


--Gives them their heroes.

#hero1 2420 -- Crescent Hermit
#hero2 2399 -- Werewolf Assassin
#hero3 2398 -- Troll Wildrider
#hero4 586 -- High Gygja (Angerboda)
#hero5 2397 -- White Werewolf

--Sets all the recruitable units.

#addrecunit 2400 -- Vaetti Spear
#addrecunit 2402 -- Vaetti Archer
#addrecunit 2401 -- Vaetti Netter
#addrecunit 2403 -- Vaetti Groundbreaker
#addrecunit 2404 -- Wolf Rider
#addrecunit 2406 -- Werewolf
#addrecunit 2405 -- Moose Riders
#addrecunit 2409 -- Forest Troll
#addrecunit 2407 -- Exile Guard

#addreccom 2412 -- Vaetti Scout
#addreccom 2411 -- Chief
#addreccom 2415 -- Vaetti Hag
#addreccom 2413 -- Wolf Lord
#addreccom 2416 -- Vaetti Sorcerer


--addreccom 2420 -- Crescent Hermit
--addreccom 2399 -- Werewolf Assassin
--addreccom 2398 -- Troll Wildrider
--addreccom 586 -- High Gygja 
--addreccom 2397 -- White Werewolf



#defcom1 2411

#defcom2 2413

#defunit1 2400

#defunit1b 2409
#defunit2 2402
#defunit2b 2404



#defmult1 20
#defmult1b 4
#defmult2 10
#defmult2b 7


#startcom 2411
#startunitnbrs1 20

#startunitnbrs2 10
#startunittype1 2400

#startunittype2 2402
#startscout 2412
#end


