-- MA Svarogia, The Dark Forests
-- Version 0.92 (Mar. 22, 2011 -- Globu's 2nd markup version, based on llamabeast's MC-compliant version)

-- Author: Executor
-- Special credit to Globu 

------------------------------------------------------------------------------
-- RESOURCES USED
------------------------------------------------------------------------------

-- Nation 72
-- Nametypes 146,147 (Rus)
-- Units 3180-3210
-- Weapons 922-926
-- Armors 380-381
-- Sites 892-894
-- Spell Slots 8


------------------------------------------------------------------------------
-- MOD INFO
------------------------------------------------------------------------------

#modname "MA Nation: Svarogia"
#domversion 3.26
#version 0.90
#description "A new MA nation, Svarogia, based on south Slavic mythology, created by Executor."
#icon "./Svarogia/logo.tga"

Globu
------------------------------------------------------------------------------

------------------------------------------------------------------------------


______________Spells_________________

#newspell
#name "Empower Vampir"
#descr "The caster curses the blood of a suitable human servant, transforming him into a Vampir, an immortal demon with potent skill in the dark arts, able to tranform into a fierce werewolf, and to curse and transform others into ghoulish creatures."
#school 6
#researchlevel 5
#path 0 7
#path 1 5
#pathlevel 0 3
#pathlevel 1 2
#nreff 1
#effect 10021
#fatiguecost 4800
#restricted 72
#damage 3181
#end

#newspell
#name "Bind Drekavacs"
#descr "Trough the use of the dark arts, the caster exhumes the remains of dead children not converted to the new faith and binds their souls to create Drekavac, twisted apparitions capable of terrifying and draining their victims."
#school 0
#researchlevel 2
#path 0 5
#pathlevel 0 1
#effect 10001
#fatiguecost 500
#nreff 1012
#restricted 72
#damage 3180
#end



#newspell
#name "Bind Talason"
#descr "The caster curses the blood of a dozen humans, transforming them into ghoulish creatures enthralled to his will."
#school 6
#researchlevel 2
#path 0 7
#pathlevel 0 2
#damage 3210
#effect 10001
#fatiguecost 1600
#nreff 1010
#restricted 72
#end

#newspell
#name "Bind Todorac"
#descr "The caster summons and binds to his service several Todorac, terrible demonic horse-men capable of trampling lesser beings. While considered sacred in Svarogia, Todorac are grealy feared by the people and will tend to cause panic wherever they go."
#school 0
#researchlevel 4
#path 0 5
#pathlevel 0 3
#damage 3183
#effect 10001
#fatiguecost 700
#nreff 5
#restricted 72
#end

#newspell
#name "Bind Babica"
#descr "The caster sacrifices several blood slaves to contact and bind to service a Babica, a demon of disease and death. Unrest will slowly increase and population slowly die anywhere Babicas appear."
#school 6
#researchlevel 3
#path 0 7
#pathlevel 0 2
#damage 3186
#effect 10021
#fatiguecost 1700
#nreff 1
#restricted 72
#end

#newspell
#name "Summon Karakondzula"
#descr "The mage spills sacrificial blood on the ground to summon a Karakondzula, a terrible demon of the night. Karakondzula are very feared, and unrest will spread in provinces where they are present."
#school 6
#researchlevel 4
#path 0 7
#pathlevel 0 3
#damage 3184
#effect 10021
#fatiguecost 2800
#nreff 1
#restricted 72
#end

#newspell
#name "Summon Moria"
#descr "The caster summons to his service a Moria, a demon of pestilence and disease who walks among the people, spreading her plague in the form of a beautiful woman clad in rags. A province in which a Moria is present will suffer an outbreak of disease and unrest, and military units may likewise become infected."
#school 4
#path 0 6
#pathlevel 0 3
#researchlevel 5
#damage 3185
#effect 10021
#fatiguecost 1600
#nreff 1
#restricted 72
#end

#newspell
#name "Summon Ala"
#descr "The caster calls on the demonic forces of the sky itself and summons an Ala, a dragon-like demon of storms. Ala are skilled in Air magic, and their very presence causes storm clouds to cover the lands over which they travel."
#school 0
#path 0 1
#pathlevel 0 4
#researchlevel 7
#damage 3187
#effect 10021
#fatiguecost 3200
#nreff 1
#restricted 72
#end


#newspell
#name "Bind Navi"
#descr "The caster sacrifices several blood slaves to contact and bind a Navi, a horrific and ravenous bird like-demon that hunts and devours smaller beings."
#school 6
#path 0 7
#pathlevel 0 4
#researchlevel 6
#damage 3188
#effect 10021
#fatiguecost 4500
#nreff 1
#restricted 72
#end

______________Weapons_________________

#newweapon 922
#name "Ancestral Sword"
#dmg 9
#att 1
#def 2
#len 3
#sound 8
#magic
#rcost 3
#end

#newweapon 923
#name "Chains"
#dmg 4
#att 2
#def 1
#len 2
#sound 10
#twohanded
#rcost 3
#end

#newweapon 924
#name "Shield Bash"
#dmg 1
#att 0
#def 0
#len 1
#sound 10
#charge
#ammo 1
#twohanded
#end

#newweapon 925
#name "Axe Charge"
#dmg 7
#att 1
#def 0
#len 1
#sound 10
#ammo 1
#charge
#end

#newweapon 926
#name "Howl"
#ammo 1
#range 10
#armornegating
#mrnegates
#dt_cap
#secondaryeffect 60 -- Fear
#explspr 10060
#sound 22
#end

______________Armor________________

#newarmor 380
#name "Ancestral Chain Mail"
#type 5
#prot 10
#def -1
#enc 1
#rcost 10
#end

#newarmor 381
#name "Golden Cap"
#type 6
#prot 22
#def 0
#enc 0
#rost 3
#end

+++++++++++ Commanders(mages) +++++++++++

#newmonster 3194
#name "Mora"
#spr1 "./Svarogia/Moraa1.tga"
#spr2 "./Svarogia/Moraa2.tga"

#descr "Mora are women who were born tainted by demonic powers. Such women often bear birthmarks, visible upon childbirth, that show their true nature, and a Mora infant will lose her magical powers if her name and the fact that she is a Mora are shouted out immediately after she has been born. However, this rarely happens, as the girls' families choose not to compromise their status in the community. Mora cannot physically kill their victims; they can only torment them and plague them with fear."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 9
#enc 3
#att 9
#demon
#def 9
#prec 10
#maxage 150
#mr 14
#mor 12
#rcost 1
#gcost 80
#demon
#weapon "Fear"
#female
#forestsurvival
#startage 20
#magicskill 5 1
#nametype 147
#custommagic 4096 50
#custommagic 16384 50
#custommagic 2048 25
#poorleader
#okundeadleader
#end

#newmonster 3193
#name "Osenja"
#descr "Osenja are powerful and seductive demons that haunt the wilderness at night. They appear as young and beautiful women, luring men unfortunate enough to be caught outside when the sun sets to their death. When faced with an Osenja, it is enough for the unforunate victim to utter a single word to fall under the will of the Osenja."
#spr1 "./Svarogia/Osenija.tga"
#spr2 "./Svarogia/Osenija2.tga"
#forestsurvival
#ap 12
#female
#mapmove 2
#assassin
#awe 1
#hp 9
#stealthy 10
#prot 0
#size 2
#str 9
#demon
#enc 3
#att 9
#def 9
#prec 10
#mr 14
#mor 12
#gcost 100
#rcost 1
#weapon "Enslave Mind"
#holy
#magicskill 4 1
#poorleader
#nametype 147
#end

#newmonster 3195
#name "Sudjaja"
#female
#descr "Demon-spirits of fate, Sudjaja determine the future of newly born children. Like many Svarogian demons, they either bring good fortune or great strife. The first three nights after the birth of a newborn child, three Sudjajas come to see it. After the third night, they fortell its future. Consequently, the kin of the child often hold feasts and perform strict rituals in order to please the Sudjaja. If satisfied, the Sudjaja will bless a child with good health and a long life. However, if the Sudjaja are displeased and the rituals followed poorly, it is not uncommon that the child dies soon afterward."
#spr1 "./Svarogia/Mora.tga"
#spr2 "./Svarogia/Mora2.tga"
#ap 12
#mapmove 2
#hp 10
#demon
#prot 0
#size 2
#str 9
#enc 3
#att 9
#def 9
#pred 10
#mr 14
#mor 12
#gcost 130
#rcost 1
#holy
#nobadevents 5
#poorleader
#forestsurvival
#magicskill 4 2
#nametype 147
#end

#newmonster 3197
#name "White Vila"
#female
#descr "A Vila is a powerful female spirit of the wild who appears as a young woman of otherworldly beauty, dressed in a thin white dress. She is able to fascinate men, luring them into servitude with her spellsong. She also has the power to heal men as well as harm them. A Vila's magical powers and strength are hidden in her okrilje, the mystical shroud she wears. If a Vila loses her okrilje, she loses her power and is easily slain."
#spr1 "./Svarogia/Vila.tga"
#spr2 "./Svarogia/Vila1.tga"
#ap 12
#mapmove 2
#hp 9
#prot 0
#size 2
#str 9
#demon
#enc 3
#att 9
#def 9
#prec 12
#startage 300
#mr 15
#mor 15
#gcost 280
#rcost 1
#weapon "Vine Bow"
#noleader
#nomagicleader
#demon
#healer 20
#awe 2
#seduce 12
#stealthy 0
#forestsurvival
#mountainsurvival
#magicskill 6 2
#magicskill 4 1
#magicskill 1 2
#custommagic 8448 100
#nametype 147
#end

#newmonster 3196
#name "Vestica"
#spr1 "./Svarogia/Vestica1.tga"
#spr2 "./Svarogia/Vestica2.tga"
#descr "Vesticas are the witches of old, feared by all Svarogians. They live deep inside the dark forest, where they secretly perform dark arts. There are only two ways for a woman to become a Vestica: she must either marry and offer her family for sacrifice, or she must be born a Mora. Vesticas feed on strife and death, using sharp sickles to cut out human hearts and eat them. They sometimes carrying body parts with them. Wherever they go, disease and sadness follows."
#ap 8
#mapmove 2
#hp 9
#prot 0
#size 2
#str 9
#enc 3
#att 9
#def 9
#demon
#prec 10
#mr 16
#mor 15
#gcost 210
#rcost 1
#weapon "Sickle"
#weapon "Fear"
#female
#forestsurvival
#startage 55
#older 5
#maxage 100
#forestsurvival
#poorleader
#expertundeadleader
#magicskill 5 2
#magicskill 7 2
#custommagic 2048 50
#nametype 147
#end

+++++++++++ Commanders(leaders)

#newmonster 3189
#name "Haiduk Commander"
#spr1 "./Svarogia/Runner1.tga"
#spr2 "./Svarogia/Runner2.tga"
#descr "The most prominent Haiduci lead raiding and war parties, and serve equally well as scouts and commanders, able to travel fast and wide. Haiduk Commanders are more disciplined than the raiders and berserkers they often lead."
#ap 16
#mapmove 3
#hp 12
#prot 0
#size 2
#att 14
#def 12
#prec 10
#mor 14
#str 13
#enc 2
#mr 10
#stealthy 5
#gcost 30
#weapon "Dagger"
#weapon "Axe"
#forestsurvival
#nametype 146
#end

#newmonster 3190
#name "Zrek"
#spr1 "./Svarogia/Zrek.tga"
#spr2 "./Svarogia/Zrek2.tga"
#descr "The Zrek are the only priests left of the the old faith of the Svarogian Kingdom. Before the coming of the new god, they tended the forest temples, performing their ancient rituals deep in the forest while their influence among the people diminished. With the coming of the new god, they have found a new cause and have re-emerged from do their work amongst the people again."
#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#att 9
#def 9
#prec 10
#mor 14
#mr 12
#gcost 35
#weapon "Dagger"
#holy
#forestsurvival
#startage 45
#magicskill 8 1
#okleader
#nametype 146
#end

#newmonster 3191
#name "Village Elder"
#spr1 "./Svarogia/Vojvoda1.tga"
#spr2 "./Svarogia/Vojvoda2.tga"
#descr "Village Elders are leaders and guides, wise men who handle all matters concerning their people. In times of war, they often organize and lead man into battle."
#ap 12
#mapmove 2
#hp 11
#startage 55
#prot 0
#size 2
#att 12
#def 12
#prec 10
#mor 14
#mr 10
#str 11
#gcost 25
#enc 3
#weapon "broad Sword"
#armor "Shield"
#armor "full leather armor"
#forestsurvival
#goodleader
#nametype 146
#end

#newmonster 3192
#name "Knez"
#spr1 "./Svarogia/knjaz1.tga"
#spr2 "./Svarogia/knjaz2.tga"
#descr "The Knez is a nobleman. He leads the armies of Svarogia into battle, and his presence insires them to great deeds. Before the coming of the new god, the Knez constantly warred with each other for dominance, but they have now united in common cause under the leadership and advice of the Zrek."
#ap 12
#mapmove 3
#hp 11
#prot 0
#size 3
#att 12
#def 12
#prec 10
#mor 16
#mr 10
#str 11
#gcost 65
#itemslots 13446
#enc 3
#mounted
#weapon "Broad sword"
#armor "Shield"
#armor "scale mail cuirass"
#forestsurvival
#expertleader
#standard 10
#startage 42
#nametype 146
#end


+++++++++++ Units ++++++++++++

#newmonster 3200
#name "Svarogian Spearman"
#spr1 "./Svarogia/Spear1.tga"
#spr2 "./Svarogia/Spear2.tga"
#descr "In Svarogia, armor and weaponry equal to that seen in many other lands is rare, and rank-and-file troops tend to be lightly-armored. Svarogian Spearmen wield spears and javelins, and wear armor of leather and linen."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon "Spear"
#weapon "Javelin"
#armor "Shield"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3201
#name "Svarogian Pikeman"
#spr1 "./Svarogia/Pike1.tga"
#spr2 "./Svarogia/Pike2.tga"
#descr "In Svarogia, armor and weaponry equal to that seen in many other lands is rare, and rank-and-file troops tend to be lightly-armored. Svarogian Pikeman wield long pikes, and are used on occasion to stop cavalry charges. They wear armor of leather and linen."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon "Pike"
#armor "Shield"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3202
#name "Svarogian Axeman"
#spr1 "./Svarogia/Axe1.tga"
#spr2 "./Svarogia/Axe2.tga"
#descr "In Svarogia, armor and weaponry equal to that seen in many other lands is rare, and rank-and-file troops tend to be lightly-armored. Svarogian Axeman fight with axes and javelins, and wear armor of leather and linen."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon "Axe"
#weapon "Javelin"
#armor "Shield"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3204
#name "Svarogian Archer"
#spr1 "./Svarogia/Archer1.tga"
#spr2 "./Svarogia/Archer2.tga"
#descr "In the harsh lands of Svarogia, warfare is familiar to all men. Svarogian archers are known for their skill with the bow, and use higher-quality composite bows. They are trained for close combat as well as ranged, and carry axes for use when their bows are no longer effective."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 11
#mr 10
#mor 11
#gcost 11
#rcost 1
#weapon "Axe"
#weapon "Composite Bow"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3203
#name "Svarogian Swordsman"
#spr1 "./Svarogia/Sword1.tga"
#spr2 "./Svarogia/Sword2.tga"
#descr "The swordsmen of Svarogia are the most experienced warriors in the kingdom, and form the heart of the Svarogian army. They are formidable opponents of great strength and skill, and have the privilege of wearing heavier ring mail armor."
#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#startage 36
#str 12
#enc 3
#att 11
#def 11
#prec 10
#mr 10
#mor 12
#gcost 12
#rcost 1
#weapon "Broad Sword"
#armor "Shield"
#armor "Iron Cap"
#armor "Ring Mail Cuirass"
#forestsurvival
#nametype 146
#end

#newmonster 3207
#name "Svarogian Rider"
#descr "Svarogian cavalry is formidable. Armed with bows and lances, they are versatile units, able to rain arrows upon lighter troops and punch through the armor of more heavily-armed opponents with their lances. Svarogian riders, like the swordsmen, receive the privilege of wearing heavier armor than most Svarogian troops."
#spr1 "./Svarogia/Horse1.tga"
#spr2 "./Svarogia/Horse2.tga"
#ap 24
#mapmove 3
#hp 11
#prot 0
#enc 4
#str 11
#att 11
#def 11
#prec 10
#mor 12
#mr 10
#gcost 20
#rcost 1
#ressize 3
#itemslots 13446
#weapon "Composite Bow"
#weapon "light Lance"
#weapon 56
#armor "Ring Mail Cuirass"
#armor "Shield"
#armor "Iron Cap"
#mounted
#forestsurvival
#nametype 146
#end

#newmonster 3208
#name "Ancestral Warrior"
#spr1 "./Svarogia/Sacred1.tga"
#spr2 "./Svarogia/Sacred2.tga"
#descr "Though heavier armor and weaponry is rare in Svarogia, the most elite soldiers, the Ancestral Warriors, bear ancestral weapons and armor, passed down from generation to generation. Coming from a past age, these ancestral arms are imbued with the magical power of the ancestral spirits, constantly strengthening and reinvigorating the wearer. Ancestral Warriors are sacred and revered by all."
#ap 12
#str 13
#mapmove 2
#hp 13
#prot 0
#gcost 25
#rcost 1
#att 12
#def 12
#enc 3
#prec 10
#mr 12
#mor 15
#weapon "Ancestral Sword"
#armor "Ancestral Chain Mail"
#holy
#armor "Iron cap"
#forestsurvival
#reinvigoration 2
#nametype 146
#end

#newmonster 3205
#name "Haiduk Raider"
#spr1 "./Svarogia/Raider1.tga"
#spr2 "./Svarogia/Raider2.tga"
#descr "While the roving groups of Haiduci count among their number both professional guerrilla veterans and mercenaries, on the one hand, as well as common thieves and bandits, on the other, all have one thing in common: they are hardened, skilled soldiers feared and respected in the lands of Svarogia. Often taking part in rebellions or ravaging the countryside, with the coming of the ascendant god, many Haiduci now flock to the banners of the armies of Svarogia, though they still demand to be well-paid. Haiduk Raiders are skilled at moving undetected through enemy lands and evading patrols, raiding enemy supply routes."
#ap 12
#str 11
#mapmove 2
#hp 11
#prot 0
#gcost 14
#rcost 1
#att 11
#def 10
#enc 3
#prec 10
#mr 10
#ambidextrous 2
#mor 12
#weapon "Axe"
#weapon "Shield Bash"
#armor "half helmet"
#armor "scale mail cuirass"
#armor "shield"
#forestsurvival
#ressize 1
#stealthy 0
#nametype 146
#end

#newmonster 3206
#name "Haiduk Berserker"
#spr1 "./Svarogia/PRR1.tga"
#spr2 "./Svarogia/PRR2.tga"
#descr "While the roving groups of Haiduci count among their number both professional guerrilla veterans and mercenaries, on the one hand, as well as common thieves and bandits, on the other, all have one thing in common: they are hardened, skilled soldiers feared and respected in the lands of Svarogia. Often taking part in rebellions or ravaging the countryside, with the coming of the ascendant god, many Haiduci now flock to the banners of the armies of Svarogia, though they still demand to be well-paid. Haiduk Berserkers are skilled forest warriors who rely on their great strength and ferocity. Though they lack proper discipline and are difficult to control in an open battle, they are swift, can run for miles without rest, and can move unseen through enemy lands. When they strike they do it with great speed and precision, and many formations of seasoned professional warriors have fallen before a berserker charge."
#ap 14
#str 12
#mapmove 3
#hp 11
#prot 0
#gcost 14
#rcost 1
#att 12
#def 10
#enc 2
#prec 10
#mr 10
#mor 12
#weapon "Axe"
#weapon "Axe Charge"
#armor "scale mail cuirass"
#ambidextrous 2
#berserk 2
#forestsurvival
#stealthy 0
#nametype 146
#ressize 1
#end


++++++++++++ Commanders +++++++++++++
              (Summons)

#newmonster 3180
#name "Drekavac"
#spr1 "./Svarogia/Drekavac1.tga"
#spr2 "./Svarogia/Drekavac2.tga"
#descr "With the coming of the awakening god, Drekavac have begun emerging from fresh graves throughout the land. Drekavac are twisted apparitions that coalesce from the souls of dead children not converted to the new faith. They haunt the countryside and emit blood-chilling howls that break the will of even the most courageous warriors. Drekavac kill their victims by draining their strength until only a lifeless husk remains."
#ap 8
#mapmove 3
#hp 8
#prot 7
#ethereal
#size 1
#mr 13
#str 8
#enc 0
#att 10
#def 9
#prec 10
#mor 12
#weapon "Steal Strength"
#weapon "Howl"
#demon
#stealthy 0
#startage 5
#nametype 146
#end


#newmonster 3181
#name "Vampir"
#spr1 "./Svarogia/Vampir.tga"
#spr2 "./Svarogia/Vampir2.tga"
#descr "A Vampir is an immortal demon of great power. A powerful sorcerer, he is able to transform himself into a fierce werewolf. He also tends to curse others around him, transforming them into ghoulish creatures called Talason. A Vampir cannot be killed inside the awakening god's dominion, and the stronger that dominion, the more Talason he gathers about himself."
#ap 12
#mapmove 2
#hp 16
#prot 6
#str 12
#enc 2
#att 12
#def 12
#prec 10
#mr 16
#mor 20
#startage 80
#maxage 60
#weapon 63
#armor "Robes"
#demon
#immortal
#stealthy 0
#animalawe 4
#magicskill 5 2
#magicskill 7 2
#shapechange 3182 -- Vukodlak
#domsummon2 3210
#poorundeadleader
#nametype 146
#end

                  #newmonster 3182
                  #name "Vukodlak"
                  #spr1 "./Svarogia/Vukodlak.tga"
                  #spr2 "./Svarogia/Vukodlak2.tga"
                  #descr "The Vukodlak is a large wolf-man of tremendous strength and regenerative powers. The origins of these beasts is unknown, but an Svarogian Vampir can change shape into a Vukodlak through his use of the dark arts. In this form, he remains a powerful blood mage, but his greater sense of smell and attunement to blood allows him to more-easily find appropriate victims for his dark rituals."
                  #ap 18
                  #mapmove 3
				  #douse 1
                  #prot 9
                  #size 2
                  #hp 33
                  #str 18
                  #enc 2
                  #att 12
                  #def 12
                  #prec 10
                  #shapechange 3181 -- Vampir
                  #mr 16
                  #immortal
                  #mor 18
                  #weapon 33
                  #weapon 20
                  #demon
                  #forstsurvival
                  #stealthy 10
                  #regeneration 10
                  #magicskill 5 2
                  #magicskill 7 2
				  #magicboost 7 1
				  #magicboost 5 -1
                  #nametype 146
                  #end

#newmonster 3210
#name "Talason"
#spr1 "./Svarogia/Talason.tga"
#spr2 "./Svarogia/Talason2.tga"
#descr "The Talason are common villagers turned into flesh eating ghouls, usually by Vampir, to whom they become thralls. They tend to appear and gather around Vampir wherever the awakening god has strong dominion, though it is not unheard of for other Svarogian sorcerers to use the dark arts to create them for their own purposes. The curse changes the hands of Talason into claws that stiffen the muscles of those wounded by them. Talason feed on the dead and the weak."
#ap 12
#mapmove 3
#hp 12
#prot 3
#size 2
#str 13
#att 11
#def 11
#enc 0
#undead
#prec 10
#mr 12
#mor 15
#weapon "poisoned claw"
#coldres 100
#poisonres 100
#nametype 146
#end

#newmonster 3183
#name "Todorac"
#spr1 "./Svarogia/Todorac.tga"
#spr2 "./Svarogia/todorac2.tga"
#descr "The Todorac is a demon that appears as a man growing out of a horse's back. Todoracs are strong, fast and deadly, able to trample anyone who gets in their way. They are most powerful and dangerous during the spring, and it is then that they often appear in villages to punish sinners. Todoracs are considered holy by the people of Svarogia, but they are also feared, and panic will slowly spread in their presence."
#ap 28
#mapmove 3
#hp 18
#prot 8
#size 3
#str 15
#enc 2
#att 13
#def 13
#prec 10
#mr 15
#mor 30
#prec 10
#fear 0
#weapon 56
#weapon 923
#demon
#forestsurvival
#trample
#incunrest 1
#pillagebonus 2
#itemslots 13446
#holy
#springpower 50
#nametype 146
#end

#newmonster 3184
#name "Karakondzula"
#spr1 "./Svarogia/Karakondzula.tga"
#spr2 "./Svarogia/Karakondzula2.tga"
#descr "The Karakondzula is a night demon. She appears as a very old, ugly hag with long claws, sharp iron teeth, horns, and the legs of a horse. Karakondzula terrorize the people of Svarogia. The women they sometimes merely harass, but more often maim or kill them, scratching and mutilating their faces, drowning them or throwing them from the tops of hills. Karakodzulas attack men differently; they ride them, stealing their strength and exhausting them to death. Karakondzula are greatly feared, and unrest will spread in provinces where they are present."
#ap 18
#mapmove 2
#hp 15
#prot 0
#size 3
#str 13
#enc 3
#demon
#female
#fear 0
#att 13
#def 13
#stealthy 25
#prec 9
#incunrest 4
#assassin
#mr 16
#itemslots 13446
#weapon 33
#weapon 306
#armor "Robes"
#noleader
#maxage 500
#startage 550
#nametype 146
#end

#newmonster 3185
#name "Moria"
#spr1 "./Svarogia/M.tga"
#spr2 "./Svarogia/M2.tga"
#descr "The Moria is a demon of pestilence and plague who appears as an attractive young woman dressed in tattered white clothes. A Moria can spread disease, and is so virulent that the slightest touch of a Moria can infect her victim. Disease and despair will spread in any province where Moria are present."
#ap 12
#mapmove 2
#hp 9
#female
#stealthy 0
#prot 0
#size 2
#str 9
#enc 2
#att 9
#def 9
#mr 12
#leper 14
#mor 14
#weapon 143
#demon
#awe 0
#diseasecloud 6
#noleader
#nametype 147
#end

#newmonster 3186
#name "Babica"
#spr1 "./Svarogia/Babica.tga"
#spr2 "./Svarogia/Babica2.tga"
#descr "The Babica is a demon of disease and death who appears as an old woman dressed in black robes and wielding a sharp sickle. Babica attack and inflict diseases on infants during the night, and cause death and sorrow where ever they go. Unrest will slowly increase and infants will die anywhere a Babica is present."
#ap 10
#mapmove 2
#hp 8
#prot 0
#enc 3
#female
#att 9
#def 9
#str 9
#prec 10
#mor 14
#demon
#mr 16
#weapon "Sickle"
#armor "Robes"
#stealthy 25
#fear 0
#incunrest 7
#maxage 250
#startage 300
#popkill 2
#noleader
#nametype 147
#end

#newmonster 3187
#name "Ala"
#spr1 "./Svarogia/Ala2.tga"
#spr2 "./Svarogia/Ala1.tga"
#descr "The Ala are female, dragon-like demons of storm and hail, immensely strong and powerful. Ala live in the clouds, where they can hide and are very difficult to spot. Their presence causes devastating storms and hails wherever they go. Ala have insatiable appetites which can never be satisfied, feasting upon man and livestock alike."
#ap 12
#mapmove 3
#hp 75
#prot 16
#att 14
#def 12
#mr 17
#prec 14
#female
#mor 30
#enc 1
#str 24
#weapon 20
#weapon 33
#illusion
#flying
#demon
#magicskill 1 3
#noleader
#itemslots 28800
#size 5
#shockres 100
#stormpower 2
#stormimmune
#onebattlespell "storm"
#supplybonus -20
#nametype 147
#end

#newmonster 3188
#name "Navi"
#spr1 "./Svarogia/Tica1.tga"
#spr2 "./Svarogia/'Tica2.tga"
#descr "The Navi is an embodiment of death and the Underworld, a horrifying demon brought to life with the souls of stillborn children and those who died in great suffering. Navi appear as large, monstrous birds that fly over villages during dark nights, emitting blood chilling howls. They attack livestock and eat women and children."
#ap 12
#mapmove 3
#hp 95
#prot 14
#size 6
#str 20
#enc 2
#att 14
#def 12
#prec 10
#mor 18
#mr 16
#weapon 505
#weapon 29
#fear 5
#weapon 29
#demon
#flying
#magicskill 7 2
#itemslots 12416
#noleader
#nametype 146
#end

_________________ Heros ____________________


#newmonster 3198
#name "Vila Ravijojla"
#spr1 "./Svarogia/HeroVila1.tga"
#spr2 "./Svarogia/HeroVila2.tga"
#descr "The Ravijojla is the most powerful and beautiful, and the most dangerous, of the White Vila. As treacherous as she is beautiful, she loves to rule over the hearts of men. On occasion she will help a questing hero, but she is unpredictable, and many have met their end seeking the Ravijojla. Human sacrifices, in the form of young virgins buried alive in the walls of bridges or towers, are made to keep the Ravijojla pleased. With the coming of the awakening god, she has found a greater cause."
#ap 8
#mapmove 3
#hp 14
#prot 0
#size 2
#enc 3
#healer 30
#flying
#magicskill 1 3
#magicskill 2 3
#magicskill 6 3
#str 10
#awe 5
#att 10
#seduce 16
#def 10
#prec 14
#mr 16
#mor 18
#female
#weapon "fist"
#startage 500
#mountainsurvival
#forestsurvival
#demon
#stealthy 0
#nametype 147
#end

#newmonster 3199
#name "Balacko"
#spr1 "./Svarogia/Div.tga"
#spr2 "./Svarogia/Div2.tga"
#descr "Balacko is a two-headed giant who breathes fire and cold from his heads. He normally lives in solitude, occasionally pillaging the countryside and taking women to keep him company, and taking livestock and children, for which he has a taste. With promises of treasure and female companions, Balacko has taken up service to the awakening god."
#ap 8
#mapmove 2
#hp 35
#prot 5
#fireres 50
#coldres 50
#size 4
#str 20
#enc 3
#forestsurvival
#att 11
#rcost 1
#coldres 50
#fireres 50
#gcost 1
#def 11
#prec 8
#mor 14
#mr 12
#weapon 93
#weapon 61
#weapon 7
#startage 113
#maxage 200
#armor "leather armor"
#itemslots 15750
#nametype 146
#end

#newmonster 3209
#name "Kingly Knight"
#spr1 "./Svarogia/Knight1.tga"
#spr2 "./Svarogia/Knight2.tga"
#descr "The Kingly Knight is the messenger of gods, traveling between the world of the living and the Underworld. He is a protector of all people, the patron of springs and bringer of fertility. He rides a beaufiful white steed and travels with unsurpassed speed. With the coming of the Awakening, he has offered his services to the new god."
#ap 36
#mapmove 4
#hp 14
#prot 0
#size 3
#str 12
#enc 3
#att 13
#def 13
#prec 12
#mr 14
#mor 18
#weapon "Golden Lance"
#weapon "Javelin"
#weapon "Hoof"
#armor  "scale mail cuirass"
#armor "Shield"
#armor "Golden Cap"
#holy
#mounted
#forestsurvival
#itemslots 13446
#supplybonus 30
#magicskill 2 2
#magicskill 5 2
#magicskill 6 2
#nametype 146
#end

--------------------------------------------

#newsite 893
#name "The Dark Forest"
#path 5
#rarity 5
#level 0
#gems 5 2
#gems 6 1
#homecom 3196 -- Vestica
#end

#newsite 894
#name "The Ancient Grove"
#path 6
#rarity 5
#level 0
#gems 1 1
#gems 6 1
#homecom 3197 -- White Vila
#end

#newsite 892
#name "Svarogia"
#path 6
#rarity 5
#level 0
#homemon 3208 -- Ancestral Warrior
#end

_________________ Nation ___________________

#selectnation 72
#clearnation
#clearsites
#name "Svarogia"
#epithet "Dark Forests"
#era 2
#descr "Svarogia is a shadowed forest realm in which treacherous demonic spirits roam the wild freely, sometimes helping and guiding the people of Svarogia, and sometimes punishing and killing them, according to their whim. In this cold and unforgiving land, the weak and incautious are preyed upon or succumb to the dangers of the wild, leaving only the strongest and most resilient. Armor of quality comparable to that of most other nations is rare. Consequently, the Svarogians are a hardened people, tougher and stronger than most. In the countryside, soldiers skilled in stealth warfare band together as Haiduk mercenaries, rebels or bandits. With the coming of the ascendant god, the people of Svarogia have banded together under the guidance of the demonic spirits to conquer the world."
#summary "Race: Strong humans and demonic spirits.

Military: Light and medium infantry. Archers and light cavalry with composite bows. Stealthy Haiduk raiders and berserkers. Sacred medium infantry with magic greatswords.

Magic: Air, Nature, Death, Blood, and some Astral.

Priests: Weak. Can blood-sacrifice.

Prefer Cold Scale 1."
#brief "A cold, shadowed forest realm of hardened humans and demonic spirits. Its military uses light armor, but features unique troops and summons."
#color 0.9 0.7
#idealcold 1
#flag "./Svarogia/flag.tga"
#labcost 500
#templecost 400

#startsite "The Dark Forest"
#startsite "The Ancient Grove"
#startsite "Svarogia"

#bloodnation
#templepic 10

#hero1 3198 -- Vila Ravijojla
#hero2 3199 -- Balacko
#hero3 3209 -- Kingly Knight

#addreccom 3189 -- Haiduk Commander
#addreccom 3190 -- Zrek
#addreccom 3191 -- Village Elder
#addreccom 3192 -- Knez
#addreccom 3193 -- Osenja
#addreccom 3194 -- Mora
#addreccom 3195 -- Sudjaja

#addrecunit 3200 -- Svarogian Spearman
#addrecunit 3201 -- Svarogian Pikeman
#addrecunit 3202 -- Svarogian Axeman
#addrecunit 3203 -- Svarogian Swordsman
#addrecunit 3204 -- Svarogian Archer
#addrecunit 3205 -- Haiduk Raider
#addrecunit 3206 -- Haiduk Berserker
#addrecunit 3207 -- Svarogian Rider

------------------
--TESTING SECTION-
------------------
-addrecunit 3208 -- Ancestral Warrior (capital-only)
-addreccom 3196 -- Vestica (capital-only)
-addreccom 3197 -- White Vila (capital-only)
-addrecunit 3180 --Drekavac

-addreccom 3181 -- Vampir
-addrecunit 3210 -- Talason
-addrecunit 3183 -- Todorac
-addreccom 3184 -- Karakondzula
-addreccom 3185 -- Moria
-addreccom 3186 -- Babica
-addreccom 3187 -- Ala
-addreccom 3188 -- Navi
-----------------------
-- END TESTING SECTION-
-----------------------

#startcom 3191 -- Village Elder
#startscout 3189 -- Haiduk Commander

#startunittype1 3200 -- Svarogian Spearman
#startunittype2 3201 -- Svarogian Pikeman

#startunitnbrs1 15
#startunitnbrs2 15

#defcom1 3191 -- Village Elder
#defcom2 3192 -- Knez

#defunit1 3201 -- Svarogian Pikeman
#defunit1b 2 3204 -- Svarogian Archer

#defunit2 3201 -- Svarogian Pikeman
#defunit2b 3203 --  -- Svarogian Swordsman

#startfort 3 -- Fortified city (1200g, admin 50)
#defaultfort 36 -- Hillfort (800g, admin 5)
#farmfort 41 -- Castle (1000g, admin 30) -- or River Fortress 20 (800g, admin 20)
#mountainfort 38 -- Hill Castle (1200g, admin 10)
#forestfort 35 -- Forest Castle (1000g, admin 20)
#swampfort 11 -- Swamp Fort (800g, admin 0)


#end
