#modname "Vampire Counts"
#description "Adds a mortal nation ruled by vampires to the Middle Age.
Loosely inspired by Games Workshop's Vampire Counts race for Warhammer Fantasy Battle."

#icon "VampireCounts/VampireBanner.tga"
#version 1.02

-- The following spells are copied and then used by #onebattlespell slots.
-- The only effect this will have is that this mod will clash with any other mods which
   happen to use the same ones (which would be quite unlucky).
- Wizard's Tower
- Crumble
- Will of the Fates
- Disintegrate
- Polymorph

-------------------------------------------------------------------------
-- Weapons
-------------------------------------------------------------------------

#newweapon 834
#name "Runeblade"
#dmg 12
#att 2
#def 1
#len 3
#dt_raise
#magic
#twohanded
#end

#newweapon 835 -- Ghoul claw
#name "Ghoul Claw"
#dmg 0
#att 0
#def 0
#len 0
#secondaryeffect 414 -- MR-resistable disease
#end

#newweapon 836
#name "Blood Drain" -- This is a kind of a dummy attack which is intended to give
#armornegating      -- MR resistability to the weakness which follows.
#dt_cap
#mrnegates
#secondaryeffect 306 -- Weakness (not MR resistable)
#end

#newweapon 837
#name "Bat Bite"
#dmg 0
#att -2
#def 0
#len 1
#secondaryeffect 836
#bonus
#end

#newweapon 838
#name "Fell Bat Bite"
#dmg 2
#att 2
#def 0
#len 2
#secondaryeffect 414 -- MR-resistable disease
#bonus
#end

#newweapon 839
#name "Vampire Bite"
#dmg 2
#att 0
#def 0
#len 1
#secondaryeffect 63 -- Life drain
#bonus
#end

#selectweapon 189 -- This is "Enslavement"
#bonus -- Naughtily changing a base game weapon! I think this is virtually a bug fix though.
#end

--------------- CBM Warhorse hoof, overlap ok

#newweapon 710
#name "Warhorse Hoof"
#dmg 12
#att 2
#def 0
#len 0
#bonus
#nostr
#end

-------------------------------------------------------------------------
-- Recruitables
-------------------------------------------------------------------------

#newmonster 3100 -- Corpse, purely for copystatting.
#name "Corpse"
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#gcost 0
#hp 15
#mor 50
#mr 5
#size 1
#immobile
#ap 2
#mapmove 0
#enc 0
#str 0
#att 0
#def 0
#prec 0
#undead
#inanimate
#poisonres 100
#coldres 100
#neednoteat
#noheal
#end

#newmonster 3101 -- Peasant
#copystats 1565 -- Peasant
#spr1 "./VampireCounts/Peasant_1.tga"
#spr2 "./VampireCounts/Peasant_2.tga"
#descr "The peasants of Sylvania suffered a miserable existence long before the coming of the vampires. The cold weather, poor soil and relentless attacks by bandits, wolves and monsters
have led to many grim and short lives. With the arrival of the dark god many peasants have been rounded up, given simple weapons and told to attack the enemies of Sylvania. Those who refuse
are killed, reanimated and sent into battle regardless. The peasants have been cursed by the Von Carsteins and if slain their corpses will not lie still for long."
#weapon "Spear"
#mapmove 1
#secondshape 3102
#gcost 6
#prec 7
#end

#newmonster 3102 -- Peasant Corpse
#spr1 "./VampireCounts/Peasant_Corpse_1.tga"
#copystats 3100 -- Corpse
#firstshape 3103 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3103
#spr1 "./VampireCounts/Peasant_Soulless_1.tga"
#spr2 "./VampireCounts/Peasant_Soulless_2.tga"
#copystats 197
#weapon "Spear"
#secondshape 3102
#end

#newmonster 3104 -- Peasant bowman
#copystats 3101 -- Peasant
#name "Peasant Bowman"
#spr1 "./VampireCounts/Peasant_Bowman_1.tga"
#spr2 "./VampireCounts/Peasant_Bowman_2.tga"
#descr "The peasants of Sylvania suffered a miserable existence long before the coming of the vampires. The cold weather, poor soil and relentless attacks by bandits, wolves and monsters
have led to many grim and short lives. With the arrival of the dark god many peasants have been rounded up, given simple weapons and told to attack the enemies of Sylvania. Those who refuse
are killed, reanimated and sent into battle regardless. The peasants have been cursed by the Von Carsteins and if slain their corpses will not lie still for long."
#weapon "Short Bow"
#prec 8
#mapmove 1
#nametype 104
#secondshape 3105
#gcost 7
#end

#newmonster 3105 -- Peasant bowman corpse
#spr1 "./VampireCounts/Peasant_Bowman_Corpse_1.tga"
#copystats 3100 -- Corpse
#firstshape 3106 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3106
#spr1 "./VampireCounts/Peasant_Bowman_Soulless_1.tga"
#spr2 "./VampireCounts/Peasant_Bowman_Soulless_2.tga"
#copystats 197
#weapon "Short Bow"
#secondshape 3105
#end

#newmonster 3107 -- Archer
#spr1 "./VampireCounts/Archer_1.tga"
#spr2 "./VampireCounts/Archer_2.tga"
#name "Archer"
#descr "The soldiers of Sylvania have been given a stark choice by their vampiric masters - serve, either living or dead.
Despite their misgivings, the threat to themselves and their families has led many to keep their weapons and fight for Sylvania.
Those who refused now serve as shambling Soulless, as promised. Although they fight for the Von Carsteins, many soldiers still
secretly hope that the armies of Sylvania will be defeated, and they will quickly flee when the tide of battle turns against them.
The majority have been cursed by the Von Carsteins, and if slain their corpses will rise again to fight for
their masters."
#gcost 10
#armor "Ring mail cuirass"
#armor "Iron Cap"
#weapon "Short Bow"
#weapon "Short Sword"
#enc 3
#mor 9
#nametype 104
#secondshape 3108
#end

#newmonster 3108 -- Archer corpse
#spr1 "./VampireCounts/Archer_Corpse_1.tga"
#copystats 3100 -- Corpse
#armor "Ring mail cuirass"
#armor "Iron cap"
#firstshape 3109 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3109
#spr1 "./VampireCounts/Archer_Soulless_1.tga"
#spr2 "./VampireCounts/Archer_Soulless_2.tga"
#copystats 197
#armor "Ring mail cuirass"
#armor "Iron Cap"
#weapon "Short Bow"
#weapon "Short Sword"
#secondshape 3108
#end

#newmonster 3110 -- Spearman
#name "Spearman"
#spr1 "./VampireCounts/Spearman_1.tga"
#spr2 "./VampireCounts/Spearman_2.tga"
#descr "The soldiers of Sylvania have been given a stark choice by their vampiric masters - serve, either living or dead.
Despite their misgivings, the threat to themselves and their families has led many to keep their weapons and fight for Sylvania.
Those who refused now serve as shambling Soulless, as promised. Although they fight for the Von Carsteins, many soldiers still
secretly hope that the armies of Sylvania will be defeated, and they will quickly flee when the tide of battle turns against them.
The majority have been cursed by the Von Carsteins, and if slain their corpses will rise again to fight for
their masters."
#gcost 10
#enc 3
#mor 9
#weapon "Spear"
#armor "Ring mail cuirass"
#armor "Shield"
#armor "Iron cap"
#nametype 104
#secondshape 3111
#end

#newmonster 3111 -- Spearman corpse
#spr1 "./VampireCounts/Spearman_Corpse_1.tga"
#copystats 3100 -- Corpse
#armor "Ring mail cuirass"
#armor "Shield"
#armor "Iron cap"
#firstshape 3112 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3112
#spr1 "./VampireCounts/Spearman_Soulless_1.tga"
#spr2 "./VampireCounts/Spearman_Soulless_2.tga"
#copystats 197
#weapon "Spear"
#armor "Ring mail cuirass"
#armor "Shield"
#armor "Iron cap"
#secondshape 3111
#end

#newmonster 3113 -- Halberdier
#name "Halberdier"
#spr1 "./VampireCounts/Halberdier_1.tga"
#spr2 "./VampireCounts/Halberdier_2.tga"
#descr "The soldiers of Sylvania have been given a stark choice by their vampiric masters - serve, either living or dead.
Despite their misgivings, the threat to themselves and their families has led many to keep their weapons and fight for Sylvania.
Those who refused now serve as shambling Soulless, as promised. Although they fight for the Von Carsteins, many soldiers still
secretly hope that the armies of Sylvania will be defeated, and they will quickly flee when the tide of battle turns against them.
The majority have been cursed by the Von Carsteins, and if slain their corpses will rise again to fight for
their masters."
#gcost 10
#enc 3
#mor 9
#weapon "Halberd"
#armor "Chain mail cuirass"
#armor "Iron cap"
#nametype 104
#secondshape 3114
#end

#newmonster 3114 -- Halberdier corpse
#spr1 "./VampireCounts/Halberdier_Corpse_1.tga"
#copystats 3100 -- Corpse
#armor "Chain mail cuirass"
#armor "Iron cap"
#firstshape 3115 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3115
#spr1 "./VampireCounts/Halberdier_Soulless_1.tga"
#spr2 "./VampireCounts/Halberdier_Soulless_2.tga"
#copystats 197
#weapon "Halberd"
#armor "Chain mail cuirass"
#armor "Iron cap"
#secondshape 3114
#end

#newmonster 3116 -- Crossbowman
#name "Crossbowman"
#spr1 "./VampireCounts/Crossbowman_1.tga"
#spr2 "./VampireCounts/Crossbowman_2.tga"
#descr "Originaly imported from the Empire, crossbows are relatively rare and highly prized weapons in Sylvania. Many have become family heirlooms, brought out only to protect a farm from a
rampaging wolf or monster. Significant effort is required to locate and repair these weapons, not least because their owners may prefer to hide or sabotage them rather than contribute to the
Sylvanian war effort."
#gcost 11
#enc 3
#mor 9
#rcost 10 -- Increased due to rarity of crossbows
#weapon "Crossbow"
#weapon "Dagger"
#armor "Ring Mail Cuirass"
#armor "Iron cap"
#nametype 104
#secondshape 3117
#end

#newmonster 3117 -- Crossbowman corpse
#spr1 "./VampireCounts/Crossbowman_Corpse_1.tga"
#copystats 3100 -- Corpse
#armor "Leather Hauberk"
#armor "Leather cap"
#firstshape 3118 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3118
#spr1 "./VampireCounts/Crossbowman_Soulless_1.tga"
#spr2 "./VampireCounts/Crossbowman_Soulless_2.tga"
#copystats 197
#weapon "Crossbow"
#weapon "Dagger"
#armor "Leather Hauberk"
#armor "Leather cap"
#secondshape 3117
#end

#newmonster 3119 -- Swordsman
#name "Castle Guard"
#spr1 "./VampireCounts/Swordsman_1.tga"
#spr2 "./VampireCounts/Swordsman_2.tga"
#descr "The Castle Guard were traditionally the defenders of the nobility of Sylvania, maintaining the safety of their strongholds amidst the lawlessness
of the province. In recent decades they have seen little of their masters and few outsiders have dared approach the castles, but the Guard have maintained
their vigil nonetheless. They are highly trained and disciplined soldiers. Some even feel some loyalty to their masters after their years of service,
although most are too sickened by the revelation of their vampirism to truly wish to fight."
#gcost 12
#weapon "Broad sword"
#armor "Chain Mail Hauberk"
#armor "Iron Cap"
#armor "Kite Shield"
#enc 3
#mapmove 1
#mor 10
#att 12
#def 11
#nametype 104
#secondshape 3120
#end

#newmonster 3120 -- Swordsman corpse
#spr1 "./VampireCounts/Swordsman_Corpse_1.tga"
#copystats 3100 -- Corpse
#armor "Chain Mail Hauberk"
#armor "Iron Cap"
#armor "Kite Shield"
#firstshape 3121 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3121
#spr1 "./VampireCounts/Swordsman_Soulless_1.tga"
#spr2 "./VampireCounts/Swordsman_Soulless_2.tga"
#copystats 197
#weapon "Broad sword"
#armor "Chain Mail Hauberk"
#armor "Iron Cap"
#armor "Kite Shield"
#secondshape 3120
#end

#newmonster 3122 -- Forester
#name "Sylvanian Forester"
#spr1 "./VampireCounts/Forester_1.tga"
#spr2 "./VampireCounts/Forester_2.tga"
#gcost 14
#descr "Sylvania is a densely forested province which is plagued by all manner of evils. Giant spiders, trolls and wolves make their haven in the woods and threaten the safety of the Sylvanian peasants. Travellers are ambushed by bandits, and far from civilization orcs muster into warbands. The Foresters are an elite organization of soldiers, employed by the counts to protect Sylvania from these threats. They are accustomed to living in the forests for months at a time, tracking monsters or hunting down bandits. They are able to move unseen through enemy territory, and are well enough equipped to strike hard when they show themselves."
#weapon "Axe"
#armor "Chain Mail Cuirass"
#armor "Iron Cap"
#armor "Shield"
#enc 3
#mapmove 2
#mor 11
#forestsurvival
#stealthy 10
#att 12
#def 11
#hp 11
#str 11
#patrolbonus 1
#age 25
#nametype 104
#secondshape 3123
#end

#newmonster 3123 -- Forester corpse
#spr1 "./VampireCounts/Forester_Corpse_1.tga"
#copystats 3100 -- Corpse
#armor "Chain Mail Cuirass"
#armor "Iron Cap"
#armor "Shield"
#firstshape 3124 -- Soulless
#descr "The dead of Sylvania do not rest easy. If it is not destroyed this corpse will rise as a Soulless zombie after the battle."
#end

#newmonster 3124
#spr1 "./VampireCounts/Forester_Soulless_1.tga"
#spr2 "./VampireCounts/Forester_Soulless_2.tga"
#copystats 197
#weapon "Axe"
#armor "Chain Mail Cuirass"
#armor "Iron Cap"
#armor "Shield"
#secondshape 3123
#end

#newmonster 3125
#spr1 "./VampireCounts/Knight_of_the_Rose_1.tga"
#spr2 "./VampireCounts/Knight_of_the_Rose_2.tga"
#name "Knight of the Rose"
#descr "Of all the Knightly Orders of the Empire, only the Knights of the Order of the Rose devoted themselves to Sylvania.
For generations these knights have fought against monsters, bandits and the restless dead, in a ceaseless quest to bring
peace to the cursed province. With the arrival of the new god the majority of the Order fled Sylvania to regroup in Altdorf. However,
some remained behind. These knights have seen so much suffering and misery in Sylvania that they have come to believe that
life is a curse, and death a mercy. They seek to bring relief to the world, and in the dark god they see a hope for the
final annihilation of life. Their purity of purpose makes them sacred to the Sylvanians. Alone among the mortal troops of
Sylvania, the Knights of the Rose will know final rest once slain, protected from the curse of the Von Carsteins by the
blessings of their Warrior Priests."
#gcost 50
#hp 12
#size 3
#mounted
#ressize 2
#prot 0
#mor 12
#mr 11
#enc 5
#str 11
#att 12
#def 11
#prec 10
#mapmove 2
#ap 18
#rcost 5
#armor "Full Chain Mail"
#armor "Full Helmet"
#weapon "Lance"
#weapon "Broad Sword"
#weapon 710 -- Warhorse Hoof
#armor "Kite Shield"
#nametype 104
#holy
#end

-------------------------------------------------------------------------
-- Commanders
-------------------------------------------------------------------------

#newmonster 3126 -- Commander
#spr1 "./VampireCounts/Commander_1.tga"
#spr2 "./VampireCounts/Commander_2.tga"
#descr "Like the soldiers they lead, the commanders of Sylvania's army have little choice but to serve. Resigned to their fates,
they do their best to preserve the lives of their soldiers."
#copystats 3119 -- Swordsman
#gcost 20
#name "Commander"
#str 11
#att 12
#def 12
#gcost 20
#mapmove 2
#end

#newmonster 3127 -- Forester Commander
#copystats 3122
#name "Forester Commander"
#descr "The leaders of the Foresters are drawn from the veterans of the organisation, and are masters of survival in the wilderness.
Although they may have defeated countless bandits and monsters they are sometimes jaded by the number yet remaining. The rise of the
dark god has placed a severe strain on their loyalty, but for the time being their duty for the citizens of Sylvania they have fought
so long to protect keeps them loyal."
#spr1 "./VampireCounts/Forester_Commander_1.tga"
#spr2 "./VampireCounts/Forester_Commander_2.tga"
#gcost 30
#att 12
#def 12
#str 12
#startage 35
#gcost 30
#supplybonus 2
#end

#newmonster 3128
#spr1 "./VampireCounts/Commander_of_the_Rose_1.tga"
#spr2 "./VampireCounts/Commander_of_the_Rose_2.tga"
#name "Commander of the Rose"
#descr "Of all the Knightly Orders of the Empire, only the Knights of the Order of the Rose devoted themselves to Sylvania.
For generations these knights have fought against monsters, bandits and the restless dead, in a ceaseless quest to bring
peace to the cursed province. With the arrival of the new god the majority of the Order fled Sylvania to regroup in Altdorf. However,
some remained behind. These knights have seen so much suffering and misery in Sylvania that they have come to believe that
life is a curse, and death a mercy. They seek to bring relief to the world, and in the dark god they see a hope for the
final annihilation of life. Their purity of purpose makes them sacred to the Sylvanians. The commanders of the Order of the Rose
are experienced and effective generals as well as skilled fighters."
#gcost 60
#hp 11
#size 3
#mounted
#ressize 2
#prot 0
#mor 13
#mr 10
#enc 5
#str 12
#att 13
#def 13
#prec 10
#mapmove 2
#ap 18
#rcost 5
#armor "Full Chain Mail"
#armor "Full Helmet"
#weapon "Broad Sword"
#weapon 710 -- Warhorse Hoof
#armor "Kite Shield"
#goodleader
#nametype 104
#holy
#nametype 100
#end

#newmonster 3129
#spr1 "./VampireCounts/Priest_of_the_Rose_1.tga"
#spr2 "./VampireCounts/Priest_of_the_Rose_2.tga"
#name "Warrior Priest of the Rose"
#descr "So far removed is Sylvania from the civilization of the Empire proper that the Priests of Sigmar rarely reach the province,
and those who do rarely live for long. As a result the Order of the Rose has organised its own priestly order to bring the light of
Sigmar to the wretched peasants of Sylvania. With the coming of the dark god, those priests who remain preach a new, starker message.
They teach that life is suffering and only the purity of death offers escape - just as the prick of a rose's thorn is insignificant
in comparison to its beauty, so is the pain of death meaningless against the peace it brings. Their teachings lend a curious legitimacy
to Sylvania's new vampire overlords to those who will listen.
Stark as their message is, these priests are skilled orators and lend courage to any warriors they fight
alongside. Chosen from among the strongest members of a military order, the Priests of the Rose are effective warriors."
#gcost 70
#hp 14
#size 2
#prot 0
#mor 14
#mr 10
#enc 3
#str 12
#att 12
#def 12
#prec 12
#mapmove 2
#ap 12
#gcost 80
#magicskill 8 2
#holy
#rcost 1
#standard 10
#armor "Plate Hauberk"
#armor "Iron cap"
#weapon "Maul"
#okleader
#nametype 104
#end

#newmonster 3130 -- Cultist
#spr1 "./VampireCounts/Cultist_1.tga"
#spr2 "./VampireCounts/Cultist_2.tga"
#copystats 554 -- Ermorian Cultist
#name "Sylvanian Cultist"
#descr "Some will welcome even the darkest misery. Among the corpses and filth of the mistreated peasantry, some few commoners greet
the arrival of the new god with open arms. Through hope of personal power or sheer madness, these peasants have organised themselves into
cults to worship the dark god and spread the word of his coming."
#gcost 45
#enc 3
#end

#newmonster 3131 -- Necromancer
#copystats 310 -- Necromancer
#name "Necromancer"
#spr1 "./VampireCounts/Necromancer_1.tga"
#spr2 "./VampireCounts/Necromancer_2.tga"
#descr "With the arrival of the dark god and the revealing of the vampires, the province of Sylvania has become an attractive haven for
necromancers. While elsewhere they are reviled and persecuted, in Sylvania their skills are welcomed, while the vampires
offers the promise of greater power or even immortality who show themselves the most skilled. Necromancers sometimes have knowledge of
other paths of magic in addition to Death magic."
#gcost 130
#custommagic 19712 100 -- AESB
#custommagic 19712 10 -- AESB
#end

#newmonster 3172 -- Occultist
#spr1 "./VampireCounts/Occultist_1.tga"
#spr2 "./VampireCounts/Occultist_2.tga"
#copystats 3131 -- Necromancer
#name "Occultist"
#descr "As a result of the abundance of dark magic in Sylvania there have always been those who have dabbled in dark arts. However such Occultists lived
in fear of discovery, for the superstitious peasants who surrounded them would be certain to burn them for witchcraft. Now however, these petty
sorcerors have found protection in the new cults of the dark god, who will enthusiastically center their rituals around such minor cantrips as the
reanimation of dead animals or the summoning of lowly demons. Many of the Occultists have some genuine talent, although some are no more than charlatans."
#gcost 80
#clearmagic
#custommagic 4096 80  -- 80% D
#custommagic 18432 50 -- 50% SB
#end


#newmonster 3132
#name "Necrarch"
#descr "The Necrarchs are ancient vampires who have devoted their unlives to the study of dark magics. While mysterious, secretive
and solitary, the goal of all Necrarchs appears to be the same - the annihilation of all life. Compared to other vampires they are
physically weak, but they are also unique in needing very little blood to survive. Draining a single human may satiate a Necrarch
for as much as a decade. As such they have been able to survive away from the society of humans for hundreds or even thousands of
years, secluded in their dark towers and gradually mastering the studies of necromancy and demonology. In the dark god of Sylvania
the Necrarchs see an opportunity for the subjugation of the living, leading them to emerge from their solitude and offer their services.
For the Necrarchs though, the subjugation of the living will only be the first step."
#spr1 "./VampireCounts/Necrarch_1.tga"
#spr2 "./VampireCounts/Necrarch_2.tga"
#weapon "Dagger"
#hp 18
#regeneration 5
#prot 4
#str 12
#mor 16
#mr 16
#att 11
#def 12
#enc 0
#ap 10
#mapmove 3
#undead
#neednoteat
#coldres 50
#fireres -50
#poisonres 100
#fear 0
#startage 1000
#maxage 2000
#magicskill 5 4 -- 4 Death
#magicskill 7 3 -- 3 Blood
#custommagic 22784 100 -- 100% ADSB
#custommagic 22784 20 -- 20% ADSB
#researchbonus 2
#nametype 111 -- Caelum male, as a test
#okleader
#goodundeadleader
#onebattlespell "Polymorph" -- The Polymorph spell is later overwritten by a battlefield-wide regeneration for undead.
#end

#newmonster 3133 -- Necrarch Acolyte
#copystats 310 -- Necromancer
#spr1 "./VampireCounts/Acolyte_1.tga"
#spr1 "./VampireCounts/Acolyte_2.tga"
#name "Acolyte"
#descr "The Necrarchs, ancient vampires and masters of dark magics, are known on occasion to take in Acolytes and tutor them. They
select these students from the most gifted of the human necromancers and demonologists who seek them out, while those not found worthy
are drained of blood or used in the Necrarchs' twisted experiments. The chosen Acolytes act as the eyes and ears of the Necrarchs,
and do their bidding in exchange for forbidden knowledge and the lure of the immortality that the vampires' blood offers. A number
of Acolytes have been sent from the distant lairs of their Necrarch masters to Drakenhof Castle, to investigate the dark god rising
there. Their instructions are to send back information, and to assist in any work which may lead to the subjugation and death of mankind."
#gcost 200
#att 10 -- Slightly increased skills
#prec 11
#mr 15
#magicskill 5 2 -- 2 Death
#magicskill 7 2 -- 2 Blood
#custommagic 7424 100
#custommagic 7424 10
#nametype 104
#startage 40
#end


-- Von Carstein vampire in his various forms
-- These shape changes work:
- Vampire to bat
- Bat to wolf
- Wolf to bat
However, there is no way of getting back to the vampire. The clumsy workaround will be
bat->vampire by #firstshape. So, if you turn into an animal you'll have to wait a turn to
turn back. Wolves don't turn back in case they're busy being stealthy.

#newmonster 3169 -- Von Carstein, House of Dust
#size 2
#spr1 "./VampireCounts/VC_Dust_1.tga"
#spr2 "./VampireCounts/VC_Dust_2.tga"
#descr "The Von Carsteins are a noble lineage of Sylvania stretching back for hundreds of years. The first
Count of Sylvania ruled effectively if harshly for some decades before revealing himself as a vampire. The colossal war which
followed was the closest the Empire has ever come to destruction. While the Count was destroyed, his vampiric blood was passed on, with
his descendants for the most part keeping their vampirism a secret until the arrival of the dark god. The bloodline of the Von Carsteins
is extraordinarily powerful, and they enjoy great physical might, magical power and the ability to shift forms as well as perhaps the
greatest innate power to raise the living dead of any being in existence. The bloodline has diverged into two mutually suspicious Houses,
with differing traits. Vampires of the House of Dust are known for their ferocity and animalistic traits. They are able to take the form
of wolves, and have great power over the packs that haunt the Sylvanian forests."
#name "Von Carstein, House of Dust"
#gcost 450
#hp 52
#prot 4
#regeneration 10
#str 22
#att 17
#def 16
#mr 16
#mor 18
#enc 0
#prec 11
#mapmove 3
#ap 14
#undead
#popkill 2 -- Vampire !!
#neednoteat
#coldres 50
#poisonres 50
#fireres -50
#startage 500
#maxage 1000
#shapechange 3134 --> Wolf
#magicskill 1 1 -- A1
#magicskill 3 1 -- E1
#magicskill 5 3 -- D3
#custommagic 5376 10
#nametype 104
#goodleader
#expertundeadleader
#berserk 3
#fear 0
#heal
-domsummon2 3144 -- Wolf
#domsummon20 3145 -- Dire Wolf
#makemonster5 3144 -- Wolf
#weapon "Runeblade"
#armor "Full Ring Mail"
#armor "Full Helmet"
#onebattlespell	"Crumble" -- Summons dire wolves then gives battlefield-wide strength boost for undead
#end

#newmonster 3171 -- Newly created House of Dust vampire
#copystats 3169
#copyspr 3169
#startage 50
#firstshape 3169
#end

#newmonster 3134 -- Von Carstein in wolf form
#spr1 "./VampireCounts/vC_Wolf_1.tga"
#spr2 "./VampireCounts/vC_Wolf_2.tga"
#name "Von Carstein, House of Dust"
#descr "In their wolf form the Von Carsteins of the House of Dust can travel are able to travel unseen, although their powers of magic and
leadership are diminished."
#gcost 450
#hp 24
#prot 4
#str 22
#att 16
#prec 10
#ap 20
#mapmove 3
#enc 0
#mor 18
#mr 16
#undead
#neednoteat
#coldres 50
#poisonres 50
#fireres -50
#fear 0
#popkill 2
#stealthy 25
#forstsurvival
#regeneration 20
#magicboost 1 -1 -- Wolves aren't good with their hands - -1 air magic
#magicboost 5 -1 -- Wolves aren't good with their hands - -1 death magic
#maxage 1000
#weapon "Bite"
#weapon "Claw"
#itemslots 12288 -- 2 misc slots only
-domsummon2 3144 -- Wolf
#domsummon20 3145 -- Dire Wolf
#makemonster5 3144 -- Wolf
#okleader
#okundeadleader
#forestsurvival
#mountainsurvival
#shapechange 3169
#onebattlespell	"Crumble" -- Summons dire wolves then gives battlefield-wide strength boost for undead
#end


#newmonster 3170 -- Von Carstein, House of Shadows
#size 2
#spr1 "./VampireCounts/VC_Shadows_1.tga"
#spr2 "./VampireCounts/VC_Shadows_2.tga"
#descr "The Von Carsteins are a noble lineage of Sylvania stretching back for hundreds of years. The first
Count of Sylvania ruled effectively if harshly for some decades before revealing himself as a vampire. The colossal war which
followed was the closest the Empire has ever come to destruction. While the Count was destroyed, his vampiric blood was passed on, with
his descendants for the most part keeping their vampirism a secret until the arrival of the dark god. The bloodline of the Von Carsteins
is extraordinarily powerful, and they enjoy great physical might, magical power and the ability to shift forms as well as perhaps the
greatest innate power to raise the living dead of any being in existence. The bloodline has diverged into two mutually suspicious Houses,
with differing traits. Vampires of the House of Shadows are known for their cunning and magical abilities, and are capable generals. They
are able to transform into vampire bats, and can summon them in large numbers.""
#name "Von Carstein, House of Shadows"
#gcost 450
#hp 48
#prot 2
#regeneration 10
#str 20
#att 16
#def 15
#mr 16
#mor 18
#enc 0
#prec 12
#mapmove 3
#ap 14
#undead
#popkill 2 -- Vampire !!
#neednoteat
#coldres 50
#poisonres 50
#fireres -50
#startage 500
#maxage 1000
#shapechange 3135 -> bat
#magicskill 5 3 -- D3
#magicskill 1 1 -- A1
#custommagic 4352 100 
#custommagic 4352 10
#nametype 104
#expertleader
#superiorundeadleader
#fear 0
#heal
#researchbonus 1
#weapon "Runeblade"
#armor "Full Ring Mail"
#armor "Full Helmet"
-domsummon2 3140 -- Vampire bats
#domsummon20 3143 -- Fell bat
#makemonster5 3140 -- Vampire bats
#onebattlespell	"Disintegrate" -- Summons vampire bats then gives battlefield-wide strength boost for undead
#end

#newmonster 3173 -- Newly created House of Shadows vampire
#copystats 3170
#copyspr 3170
#startage 50
#firstshape 3170
#end

#newmonster 3135 -- Von Carstein in bat form. Very good stats for a bat!
#spr1 "./VampireCounts/vC_Bat_1.tga"
#spr2 "./VampireCounts/vC_Bat_2.tga"
#name "Von Carstein, House of Shadows"
#descr "In their bat form, the Von Carstein of the House of Shadows can travel fly over rough terrain and behind enemy lines, although their powers of magic and
leadership are diminished. The vampires of the House of Shadows lack a natural talent for shapechanging and their grip on their bat form is unsteady and easily disrupted by light. As such they are only able
to travel in the shadows and on moonless nights, and cannot cross terrain as quickly as true bats."
#gcost 450
#hp 8
#str 9
#weapon "Vampire Bite"
#att 14
#def 14
#flying
#mapmove 1 -- Ends up as 2.
#blind
#forestsurvival
#mr 16
#mor 18
#prec 7
#enc 0
#size 1
#ap 4
#undead
#neednoteat
#coldres 50
#poisonres 50
#fireres -50
#popkill 2
#magicboost 5 -1 -- Bats aren't good with their hands - -1 death magic
#itemslots 12288 -- 2 misc slots only
#maxage 1000
#regeneration 20
-domsummon2 3140 -- Vampire bats
#domsummon20 3143 -- Fell bat
#makemonster5 3140 -- Vampire bats
#okleader
#okundeadleader
#shapechange 3170
#onebattlespell	"Disintegrate" -- Summons vampire bats then gives battlefield-wide strength boost for undead
#end

-newmonster 3136 -- Newly created Von Carstein vampire. As normal von Carsteins except in age.
-copystats 2
-copyspr 2
-descr "The Von Carsteins are a noble lineage of Sylvania stretching back for hundreds of years. The first
Count of Sylvania ruled effectively if harshly for some decades before revealing himself as a vampire. The colossal war which
followed was the closest the Empire has ever come to destruction. While the Count was destroyed, his vampiric blood was passed on, with
his descendants for the most part keeping their vampirism a secret until the arrival of the dark god. The bloodline of the Von Carsteins
is extraordinarily powerful, and they enjoy great physical might, magical power and the ability to shift forms as well as perhaps the
greatest innate power to raise the living dead of any being in existence. The Von Carsteins are known for the ability to change their
shape into that of a bat or wolf, although they have less control over the transformation than their terrified subjects imagine. Once
transformed to an animal form a Von Carstein may not change back until a month has passed."
-startage 50
-end

-------------------------------------------------------------------------
-- Summons
-------------------------------------------------------------------------

#newmonster 3137 -- Crypt ghoul
#gcost 0
#name "Crypt Ghoul"
#spr1 "./VampireCounts/Crypt_Ghoul_1.tga"
#spr2 "./VampireCounts/Crypt_Ghoul_2.tga"
#descr "Crypt ghouls are foul, degenerate creatures which feed on the corpses of dead humans. While they have a taste for the
flesh of the newly dead they are too cowardly to kill the living and tend to live in graveyards and crypts. They are easily
dominated by vampires and may overcome their cowardice for long enough to attack with their powerful claws and bite."
#hp 9
#prot 4
#mor 8
#mr 9
#str 13
#att 12
#def 10
#prec 9
#ap 18
#mapmove 3
#enc 3
#poisonres 50
#neednoteat
#darkvision 100
#weapon "Ghoul Claw"
#weapon "Bite"
#nametype 105 -- Undead
#end

#newmonster 3138 -- Sewer ghoul. This shape makes only a brief appearance, to summon 5 non-eating sewer ghouls.
#copystats 3137 -- Crypt ghoul
#name "Sewer Ghoul"
#spr1 "./VampireCounts/Sewer_Ghoul_1.tga"
#spr2 "./VampireCounts/Sewer_Ghoul_2.tga"
#descr "Sewer Ghouls lack the strength of their cousins the Crypt Ghouls, but more than compensate with considerable cunning.
Able to overcome their cowardice, they live amongst human settlements, preying the weak and unwary and dragging them down into
their hiding places in the dark. In the service of a Necrarch, Sewer Ghouls may be used as spies among the populace, watching from the
shadows for those who speak out against their masters and killing them should they ever walk alone. Any province inhabited by Sewer
Ghouls will experience both decreased unrest and a steady decline in population. Sewer Ghouls are also able to enter enemy territory
without being seen, and are just as happy to eat the peasants of the enemy."
#hp 8   -- Generally somewhat feebler
#mor 9 -- Slightly better morale.
#str 11
#att 11
#stealthy 20
#incunrest -1
#popkill 1
#nametype 105 -- Undead
#firstshape 3174
#summon5 3175 -- Non-eating sewer ghoul
#end

#newmonster 3174 -- Normal sewer ghoul.
#copystats 3137 -- Crypt ghoul
#name "Sewer Ghoul"
#spr1 "./VampireCounts/Sewer_Ghoul_1.tga"
#spr2 "./VampireCounts/Sewer_Ghoul_2.tga"
#descr "Sewer Ghouls lack the strength of their cousins the Crypt Ghouls, but more than compensate with considerable cunning.
Able to overcome their cowardice, they live amongst human settlements, preying the weak and unwary and dragging them down into
their hiding places in the dark. In the service of a Necrarch, Sewer Ghouls may be used as spies among the populace, watching from the
shadows for those who speak out against their masters and killing them should they ever walk alone. Any province inhabited by Sewer
Ghouls will experience both decreased unrest and a steady decline in population. Sewer Ghouls are also able to enter enemy territory
without being seen, and are just as happy to eat the peasants of the enemy."
#hp 8   -- Generally somewhat feebler
#mor 9 -- Slightly better morale.
#str 11
#att 11
#stealthy 20
#incunrest -1
-popkill 1
#nametype 105 -- Undead
#end

#newmonster 3175 -- Non-pop-eating sewer ghoul (looks the same).
#copystats 3137 -- Crypt ghoul
#name "Sewer Ghoul"
#spr1 "./VampireCounts/Sewer_Ghoul_1.tga"
#spr2 "./VampireCounts/Sewer_Ghoul_2.tga"
#descr "Sewer Ghouls lack the strength of their cousins the Crypt Ghouls, but more than compensate with considerable cunning.
Able to overcome their cowardice, they live amongst human settlements, preying the weak and unwary and dragging them down into
their hiding places in the dark. In the service of a Necrarch, Sewer Ghouls may be used as spies among the populace, watching from the
shadows for those who speak out against their masters and killing them should they ever walk alone. Any province inhabited by Sewer
Ghouls will experience both decreased unrest and a steady decline in population. Sewer Ghouls are also able to enter enemy territory
without being seen, and are just as happy to eat the peasants of the enemy."
#hp 8   -- Generally somewhat feebler
#mor 9 -- Slightly better morale.
#str 11
#att 11
#stealthy 20
#incunrest -1
#nametype 105 -- Undead
#end

#newmonster 3139 -- Swamp ghoul
#copystats 3137 -- Crypt ghoul
#name "Swamp Ghoul"
#spr1 "./VampireCounts/Swamp_Ghoul_1.tga"
#spr2 "./VampireCounts/Swamp_Ghoul_2.tga"
#descr "Swamp ghouls are foul, cowardly creatures which infest the swamps of Sylvania. They are closely related to sewer ghouls, but lack their cunning. They are rarely able to catch live human prey, and must subsist on the corpses which litter the swamps."
#hp 8   -- Generally somewhat feebler
#str 11
#att 11
#nametype 105 -- Undead
#end

#newmonster 3140 -- 3 vampire bats
#gcost 0
#spr1 "./VampireCounts/Vampire_Bats_3_1.tga"
#spr2 "./VampireCounts/Vampire_Bats_3_2.tga"
#name "Vampire Bats"
#descr "Vampire bats are larger than normal bats, have a vicious bite and crave human blood. They are drawn to the dark magic of the House of Shadows like moths to a flame and when a powerful vampire of the House rides to war the bats swarming overhead may block the light of the sun. In battle the bats will descend in large numbers on their unfortunate targets. While their victims fend off some of the creatures, others will sink their teeth into exposed flesh. The bite of the bats drains the strength of their victims. The dark magic which infuses the beasts prevents the wounds they inflict from healing properly, and their victims will never regain their lost strength."
#hp 3
#str 6
#weapon "Bat Bite"
#weapon "Bat Bite"
#weapon "Bat Bite"
#att 6
#def 9
#ap 4
#flying
#mapmove 2
#animal
#blind
#forestsurvival
#mr 7
#mor 10
#prec 3
#enc 3
#size 2
#startage 1
#maxage 5
#secondshape 3141
#nametype 144 -- Nature beasts
#end

#newmonster 3141 -- 2 vampire bats
#gcost 0
#copystats 3140
#descr "Vampire bats are larger than normal bats, have a vicious bite and crave human blood. They are drawn to the dark magic of the House of Shadows like moths to a flame and when a powerful vampire of the House rides to war the bats swarming overhead may block the light of the sun. In battle the bats will descend in large numbers on their unfortunate targets. While their victims fend off some of the creatures, others will sink their teeth into exposed flesh. The bite of the bats drains the strength of their victims. The dark magic which infuses the beasts prevents the wounds they inflict from healing properly, and their victims will never regain their lost strength."
#spr1 "./VampireCounts/Vampire_Bats_2_1.tga"
#spr2 "./VampireCounts/Vampire_Bats_2_2.tga"
#weapon "Bat Bite"
#weapon "Bat Bite"
#secondshape 3142
#nametype 144 -- Nature beasts
#end

#newmonster 3142 -- 1 vampire bat
#gcost 0
#spr1 "./VampireCounts/Vampire_Bats_1_1.tga"
#spr2 "./VampireCounts/Vampire_Bats_1_2.tga"
#name "Vampire Bat"
#descr "Vampire bats are larger than normal bats, have a vicious bite and crave human blood. They are drawn to the dark magic of the House of Shadows like moths to a flame and when a powerful vampire of the House rides to war the bats swarming overhead may block the light of the sun. In battle the bats will descend in large numbers on their unfortunate targets. While their victims fend off some of the creatures, others will sink their teeth into exposed flesh. The bite of the bats drains the strength of their victims. The dark magic which infuses the beasts prevents the wounds they inflict from healing properly, and their victims will never regain their lost strength."
#hp 3
#str 6
#weapon "Bite"
#att 6
#def 9
#ap 4
#flying
#mapmove 2
#animal
#blind
#forestsurvival
#mr 7
#mor 10
#prec 3
#enc 3
#size 1
#startage 1
#maxage	5
#nametype 144 -- Nature beasts
#end

#newmonster 3143
#gcost 0
#spr1 "./VampireCounts/Fell_Bat_1.tga"
#spr2 "./VampireCounts/Fell_Bat_2.tga"
#name "Fell Bat"
#descr "The fell bats of Sylvania are a rare and horrific monstrosity, formed through the warping influence of dark magic. Although clearly related to the more common vampire bats and sharing their taste for human blood, the fell bats are larger than a man and physically powerful. Their bite is said to carry a foul disease. The few who have claimed to have met such a beast and escaped have died soon after from their infected wounds."
#weapon "Fell Bat Bite"
#hp 24
#prot 8
#str 14
#att 12
#def 9
#ap 6
#flying
#mapmove 3
#animal
#blind
#forestsurvival
#mr 9
#mor 12
#prec 3
#enc 3
#size 3
#startage 10
#maxage 50
#nametype 144 -- Nature beasts
#itemslots 12288 -- 2 misc
#end

#newmonster 3144 -- Giant Wolf
#gcost 0
#copystats 284 -- "Giant Wolf"
#spr1 "./VampireCounts/Wolf_1.tga"
#spr2 "./VampireCounts/Wolf_2.tga"
#name "Giant Wolf"
#descr "The wolves of Sylvania are known for their exceptional size and strength. The packs which roam the forests in the remoter parts of the province are known to have devoured not only
unwary travellers, but whole armies."
#hp 12
#prot 3
#mor 10
#mr 7
#enc 2
#str 12
#att 11
#def 9
#prec 7
#ap 20
#mapmove 3
#startage 5
#maxage 15
#nametype 144 -- Nature beasts
#itemslots 12288 -- 2 misc
#end

#newmonster 3145 -- Dire wolf
#gcost 0
#copystats 3144 -- Giant Wolf (from mod)
#spr1 "./VampireCounts/Dire_Wolf_1.tga"
#spr2 "./VampireCounts/Dire_Wolf_2.tga"
#name "Dire Wolf"
#descr "Dire Wolves are giant wolves which have become affected by the dark magic which lies thickly in the forests of Sylvania. They are exceptionally large and vicious, and appear to possess
a cunning beyond that of any normal wolves."
#hp 18
#prot 4
#mor 12
#mr 10
#enc 2
#str 14
#att 12
#def 10
#prec 8
#ap 20
#mapmove 3
#startage 10
#maxage 30
#weapon "Bite"
#weapon "Claw"
#nametype 144 -- Nature beasts
#itemslots 12288 -- 2 misc
#end

#newmonster 3146 -- Grave Guard
#gcost 0
#spr1 "./VampireCounts/Grave_Guard_1.tga"
#spr2 "./VampireCounts/Grave_Guard_2.tga"
#name "Grave Guard"
#descr "The Grave Guard are the reanimated skeletons of long dead heroes and knights, recovered from the hidden crypts of abandoned castles. They are sacred to the dark god of Sylvania."
#hp 8
#mor 50
#mr 13
#enc 0
#str 11
#att 11
#def 10
#prec 10
#ap 11
#mapmove 3
#pooramphibian
#coldres 100
#poisonres 100
#undead
#inanimate
#neednoteat
#noheal
#holy
#weapon "Broad Sword"
#armor "Chain Mail Hauberk"
#armor "Iron Cap"
#armor "Shield"
#end

#newmonster 3147 -- Grave Guard commander
#spr1 "./VampireCounts/Grave_Guard_Commander_1.tga"
#spr2 "./VampireCounts/Grave_Guard_Commander_2.tga"
#copystats 3146 -- Copy from normal grave guard
#name "Grave Guard Commander"
#descr "The Grave Guard are the reanimated skeletons of long dead heroes and knights, recovered from the hidden crypts of abandoned castles. They are sacred to the dark god of Sylvania."
#att 12
#def 11
#poorleader
#goodundeadleader
#end

#newmonster 3148 -- Skeletal knight
#gcost 0
#spr1 "./VampireCounts/Skeletal_Knight_1.tga"
#spr2 "./VampireCounts/Skeletal_Knight_2.tga"
#name "Skeletal Knight"
#descr "Over the centuries that humans have inhabited Sylvania many brave knights have been buried along with their armor. Well-preserved in deep crypts and reanimated to serve the Von Carsteins, they are fearsome opponents and are sacred to the dark god of Sylvania."
#mounted
#size 3
#hp 8
#mor 50
#mr 13
#enc 0
#str 11
#att 11
#def 10
#prec 10
#ap 22
#mapmove 4
#pooramphibian
#coldres 100
#poisonres 100
#undead
#inanimate
#neednoteat
#noheal
#holy
#weapon "Lance"
#weapon "Broad Sword"
#weapon "Warhorse Hoof"
#armor "Plate Hauberk"
#armor "Iron Cap"
#armor "Shield"
#itemslots 13446 -- No feet
#end

#newmonster 3149 -- Preserved
#gcost 0
#spr1 "./VampireCounts/Preserved_1.tga"
#spr2 "./VampireCounts/Preserved_2.tga"
#name "Preserved"
#descr "The Preserved are what remains of ancient tribes which inhabited the swamps of the land now known as Sylvania. When a member of the tribes died, their bodies were laid to rest in the peat
bogs, where they have been preserved ever since. The magics laid on the corpses by the ancient shamans remain to this day, fusing with the necromancy of those who reanimate the corpses to create
powerful undead. The Preserved are sacred to the dark god of Sylvania."
#hp 20
#prot 5
#mor 50
#mr 14
#enc 0
#str 14
#att 11
#def 10
#prec 10
#mapmove 3
#ap 9
#coldres 100
#poisonres 100
#fireres -50
#undead
#neednoteat
#inanimate
#holy
#weapon "Stone Spear"
#armor "Furs"
#armor "Leather Cap"
#end

#newmonster 3150 -- Preserved chieftain
#spr1 "./VampireCounts/Preserved_Chieftain_1.tga"
#spr2 "./VampireCounts/Preserved_Chieftain_2.tga"
#copystats 3149 -- Copy from normal Preserved.
#name "Preserved Chieftain"
#gcost 0
#descr "The Preserved are what remains of ancient tribes which inhabited the swamps of the land now known as Sylvania. When a member of the tribes died, their bodies were laid to rest in the peat
bogs, where they have been preserved ever since. The chiefs of the tribes wore helmets bearing great antlers to mark their status. The Preserved are sacred to the dark god of Sylvania."
#att 12
#def 11
#prec 11
#poorleader
#goodundeadleader
#end

#newmonster 3152 -- Zombie Dragon
#spr1 "./VampireCounts/Zombie_Dragon_1.tga"
#spr2 "./VampireCounts/Zombie_Dragon_2.tga"
#name "Zombie Dragon"
#descr "The discovery and reanimation of a dragon's corpse is amongst the highest achievements of the necromantic arts. The resulting Zombie Dragon is a mindless but
powerful monster."
#gcost 0
#size 6
#mor 50
#coldres 100
#poisonres 100
#undead
#inanimate
#neednoteat
#noleader
#fear 5
#mr 18
#hp 180
#prot 16
#enc 0
#flying
#str 28
#att 16
#def 12
#ap 12
#prec 9
#mapmove 3
#weapon "Bite"
#weapon "Claws"
#weapon "Bile"
#itemslots 12416 -- Head, 2 misc
#end

#newmonster 3153 -- Draconic Demon
#spr1 "./VampireCounts/Draconic_Demon_1.tga"
#spr2 "./VampireCounts/Draconic_Demon_2.tga"
#name "Draconic Demon"
#descr "This horrific creation is the corpse of a long-dead dragon, possessed by the spirit of a powerful demon from Inferno. The Draconic Demon is a powerful user of Fire, Death and Blood magic."
#gcost 0
#size 6
#mor 30
#poisonres 100
#undead
#demon
#inanimate
#neednoteat
#noleader
#fear 0
#mr 18
#hp 160
#prot 14
#enc 0
#flying
#str 24
#att 17
#def 15
#ap 14
#prec 11
#mapmove 3
#weapon "Bite"
#weapon "Claws"
#magicskill 0 2
#magicskill 5 3
#magicskill 7 3
#itemslots 28800 -- Head, 3 misc
#end

-------------------------------------------------------------------------
-- Pretenders
-------------------------------------------------------------------------

#newmonster 3160
#copystats 388 -- Lord of the Gates
#copyspr 388
#restrictedgod 94
#end

#newmonster 3161
#copystats 395 - Lich Queen
#copyspr 395
#restrictedgod 94
#end

#newmonster 3162
#copystats 120 -- Moloch
#copyspr 120
#restrictedgod 94
#end

#newmonster 3163
#copystats 1230 -- Forge Lord
#copyspr 1230
#restrictedgod 94
#end

#newmonster 3164
#copystats 1561 -- Father of Winters
#copyspr 1561
#restrictedgod 94
#end

#newmonster 3165
#copystats 657 -- Monolith
#copyspr 657
#restrictedgod 94
#end

#newmonster 3166
#copystats 1340 -- Lord of War
#copyspr 1340
#restrictedgod 94
#end

-------------------------------------------------------------------------
-- Heroes
-------------------------------------------------------------------------

#newmonster 3151 -- Corrupted noble.
#gcost 0
#spr1 "./VampireCounts/Corrupted_Noble_1.tga"
#spr2 "./VampireCounts/Corrupted_Noble_2.tga"
#armor "Full chain mail"
#armor "Full helmet"
#weapon "Great sword"
#name "Corrupted Noble"
#descr "With the rise of the Von Carsteins this former baron immediately pledged loyalty to the vampires, betraying any who sought to save Sylvania in his quest for
personal power. He has been handsomely rewarded for his efforts. He is provided with a supply of magically adulterated vampire blood concocted by the Necrarchs.
The potent blood greatly increases his physical prowess and causes any wounds he suffers to heal rapidly. Only after he had drunk of the blood did the vampires reveal
its other property - having drunk the blood once, the baron must drink it every day or die. The Necrarchs see this as a fitting way to ensure his loyalty."
#hp 24
#str 14
#mor 14
#att 14
#def 12
#regeneration 10
#heal
#mr 14
#enc 1
#mapmove 2
#nametype 104
#expertleader
#darvision 50
#end

#newmonster 3167
#gcost 0
#name "Tomb Guard"
#descr "The Tomb Guard were an elite corps of troops assigned to protecting the necropolises of Nehekhara. Along with the rest of Nehekharan civilization they have lain
entombed for thousands of years. Some of their skeletons have been stolen by the vampiresses of Lahmia to be reanimated as their servants."
#spr1 "./VampireCounts/Tomb_Guard_1.tga"
#spr2 "./VampireCounts/Tomb_Guard_2.tga"
#mor 30
#mr 15
#hp 8
#att 11
#def 10
#enc 0
#ap 12
#mapmove 3
#neednoteat
#coldres 100
#poisonres 100
#inanimate
#undead
#nametype 127
#rcost 3
#startage 2705
#maxage 5000
#poorundeadleader
#att 12
#def 12
#str 11
#mor 30
#pooramphibian
#weapon "Falchion"
#armor "Bronze Scale Hauberk"
#armor "Tower Shield"
#end

#newmonster 3168 -- Lahmian vampiress
#gcost 0
#name "Lahmian Vampiress"
#spr1 "./VampireCounts/Lahmian_1.tga"
#spr2 "./VampireCounts/Lahmian_2.tga"
#descr "The vampiresses of Lahmia are known for their powers of seduction and mind control. While not as physically powerful as the Von Carsteins, they more than compensate through
manipulation and guile. This vampiress has brought a large cache of ancient skeletons from her ancestral home of Nehekhara. Given time she can reanimate a new skeletal army to serve
her alongside her mortal thralls."
#weapon "Enslavement"
#weapon "Quarterstaff"
#hp 24
#regeneration 10
#prot 4
#str 14
#mor 18
#mr 16
#awe 3
#att 11
#def 9
#female
#seduce 14
#spy
#stealthy 15
#enc 0
#mapmove 3
#standard 5
#undead
#coldres 100
#poisonres 100
#magicskill 5 3 -- 3 Death
#magicskill 2 2 -- 2 Water
#makemonster2 3167 -- Tomb Guard
#end

#newmonster 3136 -- Konrad Von Carstein
#gcost 0
#size 2
#spr1 "./VampireCounts/Konrad_1.tga"
#spr2 "./VampireCounts/Konrad_2.tga"
#name "Konrad Von Carstein"
#descr "Konrad Von Carstein is a deranged vampire, known for his insane blood rages in which he massacres all those around him and gorges himself on their blood. He lacks the patience
for magic and will not change to an animal form. In battle he will descend immediately into a berserk rage. He is tolerated by his relatives only for his extraordinary competence in battle."
#gcost 0
#hp 72
#prot 8
#str 24
#att 18
#def 16
#mr 18
#regeneration 10
#mor 20
#enc 0
#prec 11
#mapmove 3
#ap 14
#undead
#neednoteat
#coldres 50
#poisonres 50
#fireres -50
#startage 500
#maxage 1000
#nametype 104
#goodleader
#expertundeadleader
#fear 0
#heal
#weapon "Runeblade"
#armor "Full Chain Mail"
#popkill 5 -- Mad vampire !!
#expertleader
#superiorundeadleader
#fear 5
#berserk 5
#onebattlespell "Wizard's Tower"
#end


-Planned hero list:
-(Necrarch)
-Corrupted Noble
-Lahmian Vampiress
-Konrad Von Carstein
-(Blood Dragon)

-------------------------------------------------------------------------
-- Units for spell effects
-------------------------------------------------------------------------

#newmonster 3154 -- Pre-soulless with massive onebattlespell reanimation.
#copystat 915 -- Soulless
#copyspr 915 -- Soulless
#summon1 197 -- Give him a few soulless friends so it doesn't seem so odd that he's on his own after battle.
#summon5 197
#domsummon 197
#domsummon2 197
#firstshape 915 -- Soulless
#onebattlespell "Will of the Fates" -- Later on this spell is modified to be a massive reanimation spell.
#okundeadleader
#end

#newmonster 3155 -- Pre-soulless. Unit that can be summoned to get soulless without using corpses.
#copystat 197 -- Soulless
#copyspr 197 -- Soulless
#firstshape 197 -- Soulless
#end

#newmonster 3156 -- Pre-unit for Army of the Crypts, gives Grave Guard commander.
#copyspr 3147
#copystats 3147
#domsummon 3146 -- Dom summons up to 15 grave guard
#domsummon2 3146
#domsummon20 3148 -- Skeletal knight
#firstshape 3147
#end

#newmonster 3157 -- Pre-unit for Army of the Swamps, gives Preserved Chieftain.
#copyspr 3150
#copystats 3150
#domsummon 3149 -- Dom summons up to 15 Preserved
#domsummon2 3149
#domsummon20 1388 -- Ziz
#firstshape 3150
#end

#newmonster 3158 -- Pre-unit for ghouls which kills population as it's summoned.
#copyspr 198
#copystats 198
#firstshape 198
#popkill 1
#end

#newmonster 3159 -- Pre-unit for villages which kills population and reduces unrest as its summoned.
#copyspr 3103
#copystats 3103
#firstshape 3103
#popkill 1
#incunrest -2
#end

-------------------------------------------------------------------------
-- Nation
-------------------------------------------------------------------------

-- Things to summon:
- Ziz (rarely)
- Undead bear?
- Unfrozen?
- Ghost knight?
- Ghostly warriors?
- Ghosts?
- Longdead
- Longdead soldiers
- Longdead crusaders
- Soulless


-- Start sites
#newsite 797
#name "Drakenhof Castle"
#path 5
#level 2 -- Dramatic picture
#rarity 5
#gems 5 2
#gems 1 1
#homecom 3133 -- Acolyte
#homecom 3169 -- Von Carstein, House of Dust
#homecom 3170 -- Von Carstein, House of Shadows
#end

#newsite 798
#name "Sylvanian Swamps"
#path 5
#level 0 - Grim village picture
#rarity 5
#gems 5	2
#end

#newsite 799
#name "Stronghold of the Rose"
#path 8
#level 0 - Nice stronghold picture.
#rarity 5
#homemon 3125 -- Knight of the Rose
#end

#selectnation 94
#clearnation
#clearsites
#name "Sylvania"
#epithet "Vampire Counts"
#color .1 .1 .1 -- Charcoal

#era 2
#flag "VampireCounts/VampireFlag.tga"
#templepic 7 -- "Foreboding" temple picture

#idealcold 1
-domunrest 1 -- Removed unrest dominion on grounds of annoyance.

#descr "Sylvania is a desolate province of dark forests and deadly swamps. Peasants eke out a miserable existence tilling the
infertile soil, or take up arms to defend themselves from the marauding wolves, bandits and monsters which infest the province.
In decades past the nobility were concerned stewards of their people, ruling and protecting them as best they could. More
recently they have become withdrawn, and dark tales keep the peasants away from their castles.

With the disappearance of the Pantokrator the nobility have revealed themselves as powerful vampires and all who opposed them
have been slain. Now the armies of Sylvania are forced to march side by side with the walking dead to conquer new lands for the
vampires and their dark god."

#summary "Race: Humans and vampires, prefers Cold scale +1

Military: Infantry, archers and sacred knights, many undead summons

Magic: Death and Blood, with some Air, Astral and Earth

Priests: Average"

#brief "Sylvania is a desolate province of forests and swamps inhabited by humans. A powerful bloodline of
vampires has siezed control of the nation,
and force the living soldiers to fight alongside their hordes of undead."

#startfort 41 -- Castle
#defaultfort 40 -- Fortress

#startsite "Drakenhof Castle"
#startsite "Sylvanian Swamps"
#startsite "Stronghold of the Rose"

-- Heroes
#multihero1 3132 -- Necrarch
#multihero2 3151 -- Corrupted Noble
#hero1 3168 -- Lahmian Vampiress
#hero2 3136 -- Konrad Von Carstein


--Set starting troops, commander, and bonus commander.
#startcom 3126
#startunitnbrs1 15
#startunitnbrs2 15
#startunittype1 3110
#startunittype2 3107
#startscout 426

--Set the units to be used in province defense.
#defcom1 3126 -- Commander
#defcom2 3131 -- Necromancer
#defunit1 3110 -- Spearman
#defunit1b 3104 -- Peasant bowman
#defunit2 3119 -- Swordsman
#defunit2b 3107 -- Archer

--Set how many of the units to appear per point.
#defmult1 10
#defmult1b 10
#defmult2 10
#defmult2b 10

#addrecunit 3101 -- Peasant
#addrecunit 3104 -- Peasant Bowman
#addrecunit 3107 -- Archer
#addrecunit 3116 -- Crossbowman
#addrecunit 3110 -- Spearman
#addrecunit 3113 -- Halberdier
#addrecunit 3119 -- Swordsman
#addrecunit 3122 -- Forester
#addreccom 426 -- Scout
#addreccom 3126 -- Commander
#addreccom 3127 -- Forester Commander
#addreccom 3128 -- Commander of the Rose
#addreccom 3129 -- Warrior Priest of the Rose
#addreccom 3130 -- Cultist
#addreccom 3172 -- Occultist
#addreccom 3131 -- Necromancer

-addreccom 3152 -- Zombie Dragon
-addreccom 3153 -- Draconic Demon
-addreccom 3136 -- Konrad
-addreccom 3168 -- Lahmian Vampiress
#end


-------------------------------------------------------------------------
-- SPELLS
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- #onebattlespell spells
-------------------------------------------------------------------------

-- Make a spell just to give the Battlefield Enchantment symbol when a vampire is present.
-- This is a kind of in-game documentation for the non-obvious #onebattlespell effects.
#newspell
#copyspell "Mist" -- Gives the Battlefield Enchantment icon.
#name "Vampiric Power"
#fatiguecost 0
#descr "The presence of one or more vampires serves to augment the powers of undead fighting for Sylvania. Von Carstein vampires increase the physical strength of their undead servants. Necrarchs grant their minions the power of regeneration, their corpses knitting back together in front of their horrified enemies. The more vampires present, the greater the portion of the army that will receive the benefits. Weaker undead are more likely to be affected."
#damage 14 -- This makes the spell do "Eyes of God", which I hope means that it does nothing in battle!
#school -1
#researchlevel 0
#end

-- Strength boost for Von Carsteins
#newspell
#copyspell "Rush of Strength"
#name "Von Carstein Strength Boost"
#school -1
#researchlevel 0
#aoe 663 -- Half of Entire battlefield
#spec 96468992 - MR-negates easily, friendly undead only, works	underwater
#nextspell "Vampiric Power"
#end

-- Regeneration for Necrarchs
-- Going to be a #onebattlespell, so have to use the spell slot	of an existing spell. Choose arbitrarily to use	Polymorph.
#newspell
#copyspell "Polymorph"
#end
#selectspell "Polymorph"
#copyspell "Rush of Strength"
#name "Necrarch Regeneration Boost"
#school -1
#researchlevel 0
#aoe 663 -- Half of entire battlefield
#effect 23
#damage 536870912 -- Regeneration that works on inanimates, for spells with effect 23
#spec 96468992 - MR-negates easily, friendly undead only, works underwater
#nextspell "Vampiric Power"
#end


-- Berserk for Konrad Von Carstein
#newspell
#copyspell "Wizard's Tower"
#end

#selectspell "Wizard's Tower" -- Self-berserk for Konrad Von Carstein
#copyspell "Eagle Eyes"
#effect 10
#damage 256
#school -1
#researchlevel 0
#end

#newspell
#copyspell "Crumble"
#end
#selectspell "Crumble"
#name "Dire Wolves In Battle"
#school -1
#researchlevel 0
#effect 1
#damage 3145
#nreff 3
#range 1
#nextspell "Von Carstein Strength Boost"
#end

#newspell
#copyspell "Disintegrate"
#end
#selectspell "Disintegrate"
#name "Vampire Bats In Battle"
#school -1
#researchlevel 0
#effect 1
#damage 3140
#nreff 4
#range 1
#nextspell "Von Carstein Strength Boost"
#end



-------------------------------------------------------------------------
-- Enchantment
-------------------------------------------------------------------------

#newspell
#name "Unholy Vigor"
#descr "This powerful enchantment infuses the bodies of all undead on the battlefield with an unholy vigor. Both their speed and skill in combat are greatly increased."
#school 4 -- Enchantment
#path 0 5 -- Death
#pathlevel 0 4 -- D4
#researchlevel 3
#effect 23 -- Buff
#damage 33554432 -- Unholy power
#spec 71303168 -- Only affects friendly undead
#aoe 666
#fatiguecost 200 -- Costs 2 death gems
#explspr 10060 -- 10059 is rising lurid green mist. An alternative might be 10060, which is black.
#restricted 94
#end

#newspell -- Vampiric Ward, national MR boost for undead
#copyspell "Protection of the Sepulchre"
#name "Vampiric Ward"
#descr "With this spell all undead on the battlefield are placed under the protection of the powerful will of the vampires of Sylvania. Their resistance to enemy magic is greatly increased." 
#school 4 -- Enchantment
#path 0 5 -- Death
#pathlevel 0 5 -- D5
#researchlevel 5
#spec 71303168 -- Only affects friendly undead, no MR check
#fatiguecost 100 -- Costs 1 death gem
#restricted 94
#end

#newspell -- Longdead of Sylvania
#copyspell "Reanimation"
#name "Longdead of Sylvania"
#descr "The lands of Sylvania are suffused with dark magic, and the dead do not rest easy in their tombs. A skilled necromancer can seek out those graves where the dead are
most restless, and awaken them to serve him without any expenditure of magical gems."
#nreff 5
#researchlevel 1
#fatiguecost 0
#restricted 94
#end

-- Army of the Crypts
#newspell -- Crypt ghouls for "Army of the Crypts"
#copyspell "Reanimation"
#name "Crypt Ghouls from Crypts"
#damage 3137 -- Crypt Ghoul
#nreff 6
#school	-1
#researchlevel 0
#end
#newspell -- Skeleton horsemen for "Army of the Crypts"
#copyspell "Pale Riders"
#name "Horsemen from Crypts"
#nreff 5
#school -1
#researchlevel 0
#nextspell "Crypt Ghouls from Crypts"
#end
#newspell -- Longdead for "Army of the Crypts"
#copyspell "Reanimation"
#name "Skeletons from Crypts"
#nreff 40
#nextspell "Horsemen from Crypts"
#school -1
#researchlevel 0
#end
#newspell -- Army of the Crypts
#name "Army of the Crypts"
#descr "The necromancer scours the crypts and tombs of Sylvania and reanimates an army of longdead warriors led by a skeletal general. In strong friendly dominion sacred undead troops will be reanimated."
#school 4
#researchlevel 2
#path 0 5
#pathlevel 0 3 -- D3
#fatiguecost 1200
#effect 10021
#damage 3156
#nreff 1
#nextspell "Skeletons from Crypts"
#restricted 94
#end
--

-- Army of the Swamps
#newspell -- Sewer ghouls for "Army of the Swamps"
#copyspell "Reanimation"
#name "Swamp Ghouls from Swamps"
#damage 3139 -- Swamp Ghoul
#nreff 10
#school	-1
#researchlevel 0
#end
#newspell -- Ghouls for "Army of the Swamps"
#copyspell "Reanimation"
#name "Ghouls from Swamps"
#damage 198 -- Ghoul
#nreff 14
#nextspell "Swamp Ghouls from Swamps"
#school -1
#researchlevel 0
#end
#newspell -- Soulless for "Army of the Swamps"
#copyspell "Reanimation"
#name "Soulless from Swamps"
#damage 3155 - Pre-soulless
#nreff 40
#nextspell "Ghouls from Swamps"
#school -1
#researchlevel 0
#end
#newspell -- Army of the Swamps
#name "Army of the Swamps"
#descr "The swamps of Sylvania are foul expanses of rotten and dying land coated in a thick miasma of fog and decay. Countless peasants, travellers and wild beasts have died in them while seeking safety, and the mud is thick with corpses. Dark magic twists all that it finds there, and tales tell of villagers trying to subsist on the borders of the swamps gradually transforming into monstrous ghouls, hungering only for human flesh. The necromancer raises a monstrous army from the swamps to serve him. In strong friendly dominion powerful sacred undead troops will be reanimated."
#school 4
#researchlevel 2
#path 0 5
#pathlevel 0 3 -- D3
#fatiguecost 800
#effect 10021
#damage 3157
#nreff 1
#nextspell "Soulless from Swamps"
#restricted 94
#end
--

#newspell -- Army of Distant Graves
#copyspell "Carrion Reanimation"
#name "Army of Distant Graves"
#descr "The necromancer reaches out to a distant friendly province and locates the site of an ancient battle or a crypt in which warriors are entombed. A small army of longdead soldiers is reanimated to serve the necromancer."
#damage -2
#nreff 40
#school 4
#researchlevel 4
#path 0 5
#pathlevel 0 2
#fatiguecost 800
#restricted 94
#end

#newspell -- Grave Guard
#copyspell "Reanimation"
#name "Grave Guard"
#damage 3146 -- Grave Guard
#nreff 12
#school -1
#researchlevel 0
#end
#newspell -- Longdead of Sylvania
#copyspell "Reanimation"
#name "The Sacred Dead"
#descr "Buried in the crypts of Sylvania's abandoned castles lie the tombs of many brave knights of former times. With this spell these long dead knights are awoken, and ride forth once more
on skeletal steeds. They are accompanied by the Grave Guard, elite footsoldiers of centuries past. Composed of powerful undead, the resulting force is sacred to
the dark god of Sylvania."
#nreff 5
#researchlevel 5
#pathlevel 0 4
#fatiguecost 1400
#nreff 10
#damage 3148 -- Skeletal knight
#restricted 94
#nextspell "Grave Guard"
#end

-------------------------------------------------------------------------
-- Thaumaturgy
-------------------------------------------------------------------------

#newspell
#name "Raise Victims"
#descr "Over the course of a month the vampire reanimates the corpses of the strongest of his mortal victims, raising a small army of blood-drained soulless. The number of corpses in the province
is not diminished."
#effect 10001
#damage 3155 -- Pre-soulless, so as not to use up corpses.
#nreff 12
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#researchlevel 0
#fatiguecost 0 -- Free spell
#school 5 -- Thaumaturgy
#restricted 94
#end

#newspell -- Restless dead - cheap 50-strong Carrion Reanimation.
#copyspell "Fires from Afar"
#name "Restless Dead"
#descr "The Von Carstein vampires have an extraordinary innate ability to reanimate the dead. With this spell up to fifty corpses are raised as soulless in a distant province. The spell may be
cast on enemy as well as friendly provinces."
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#researchlevel 2
#fatiguecost 200
#effect 10037
#damage -1
#school 5 -- Thaumaturgy
#nreff 50 -- Up to 50 soulless (dependent on corpses)
#restricted 94
#spec 276824064
#end

-- Call Giant Wolves
#newspell
#copyspell "Reanimation"
#name "Call Dire Wolf"
#damage 3145 -- Dire Wolf
#nreff 2
#school -1
#researchlevel 0
#end
#newspell
#name "Call Giant Wolves"
#descr "Vampires of the House of Dust have a strong affinity with the wolves which prowl the Sylvanian forests. With this spell a vampire calls on a large pack
to come forth and serve him."
#effect 10001
#damage 3144 -- Giant wolf
#nreff 18
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 3 -- Earth
#pathlevel 1 1 -- E1
#researchlevel 1
#fatiguecost 400
#school 5 -- Thaumaturgy
#restricted 94
#nextspell "Call Dire Wolf"
#end
--

-- Call Vampire Bats
#newspell
#copyspell "Reanimation"
#name "Call Fell Bat"
#damage 3143 -- Fell Bat
#nreff 2
#school -1
#researchlevel 0
#end
#newspell
#name "Call Vampire Bats"
#descr "Vampires of the House of Shadows have great powers over bats of all kinds. When this spell is cast all the bats within a mile of the vampire's location will be drawn mindlessly to his location, forming a vast swarm which descends upon him. Once they are summoned the vampire is easily able to dominate the bats and bind them to his service."
#effect 10001
#damage 3140 -- Vampire bats
#nreff 18
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 1 -- Air
#pathlevel 1 2 -- A2
#researchlevel 1
#fatiguecost 400
#school 5 -- Thaumaturgy
#restricted 94
#nextspell "Call Fell Bat"
#end
--


#newspell
#name "Gift of Dust"
#descr "With this ritual the cursed blood of the House of Dust is passed on to a mortal member of the Von Carstein family. The blood itself is so powerful that,
uncontrolled, a single sip would kill a mortal. A lengthy ritual is required to prepare the recipient, culminating in the drinking of the blood and the transformation
of mortal man into immortal vampire."
#school 5 -- Thaumaturgy
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 3 -- Air
#pathlevel 1 1 -- E1
#researchlevel 2
#effect 10021
#damage 3171 -- Newly created House of Dust vampire
#fatiguecost 3000
#nreff 1
#restricted 94
#end

#newspell
#name "Gift of Shadows"
#descr "With this ritual the cursed blood of the House of Shadows is passed on to a mortal member of the Von Carstein family. The blood itself is so powerful that,
uncontrolled, a single sip would kill a mortal. A lengthy ritual is required to prepare the recipient, culminating in the drinking of the blood and the transformation
of mortal man into immortal vampire."
#school 5 -- Thaumaturgy
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 1 -- Air
#pathlevel 1 2 -- A2
#researchlevel 2
#effect 10021
#damage 3173 -- Newly created House of Shadows vampire
#fatiguecost 3000
#nreff 1
#restricted 94
#end

#newspell -- Punishment
#copyspell "Carrion Reanimation"
#name "Punishment"
#descr "The Von Carsteins will brook no disobedience from their human herd. With this spell the inhabitants of an unruly province
are taught a brutal lesson. In a night of slaughter the dead rise from their graves to massacre the population, and any known
troublemakers are certain to amongst those slain. When the killing subsides the dead return to their graves, but the corpses
of those who had stood against the vampires rise in permanent servitude, as a stark lesson to their comrades. Five hundred people
people will be killed in the target province, but unrest will be dramatically reduced and a small army of reanimated peasants will
remain."
#school 5 -- Thaumaturgy
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#damage 3159
#nreff 50
#researchlevel 3
#fatiguecost 600
#restricted 94
#end

#newspell
#copyspell "Raven Feast"
#name "Raven Call"
#descr "The vampire uses his innate power over animals to summon an unkindness of ravens and
send them to a distant province to feast on the newly dead. The ravens consume the rotting
corpses and return to be slaughtered for the raw death essence that they contain. Provinces
struck by plagues or containing recent battlefields can give the caster large amounts of
Death gems. All unburied dead in a province are consumed. Enemy provinces can be targeted."
#school 5 -- Thaumaturgy
#path 0 5 -- Death
#pathlevel 0 3 -- D3
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#researchlevel 3
#fatiguecost 100
#restricted 94
#end

#newspell
#copyspell "Carrion Reanimation"
#name "Shadow Ravens"
#descr "The vampire causes ethereal ravens to manifest from the shadows on a moonlit battlefield. The ravens consume the rotting corpses and fly to the vampire. There they dissipate
back into shadow, leaving behind the raw death essence that they have consumed in the form of Death gems. So fine is the vampire's mastery over shadows that not a single gem is required
for the casting of this spell. However, only friendly provinces can be targeted."
#effect 10075
#damage 100
#school 5 -- Thaumaturgy
#path 0 5 -- Death
#pathlevel 0 4 -- D4
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#researchlevel 6
#fatiguecost 0
#restricted 94
#end



#newspell -- Endless dead - 1000-strong Carrion Reanimation.
#copyspell "Restless Dead"
#name "Endless Dead"
#descr "With this powerful spell a Von Carstein vampire channels all of his innate power to reanimate the dead. All of the corpses in a distant province are raised as soulless to fight for
the vampire. This spell may be cast at enemy as well as friendly provinces."
#researchlevel 4
#fatiguecost 400
#nreff 999 -- Up to 999 soulless (dependent on corpses)
#restricted 94
#end

#newspell
#name "Reanimate Dragon"
#descr "The vampire undergoes a long and challening quest to locate the skeleton of a long dead dragon. When suitable remains have been found, the vampire channels
all of his innate power over the dead to reanimate the mighty beast. The resulting Zombie Dragon has lost much of the power it had in life, but nonetheless remains
a fearsome monster."
#effect 10021
#damage 3152 -- Zombie dragon
#nreff 1
#path 0 5 -- Death
#pathlevel 0 4 -- D4
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#researchlevel 7
#fatiguecost 2000
#school 5 -- Thaumaturgy
#restricted 94
#end

-- The Blackest Curse
#newspell -- Massive version of Raise Dead, for #onebattlespell use by the commander summoned by The Blackest Curse.
#copyspell "Will of the Fates"
#end
#selectspell "Will of the Fates"
#copyspell "Raise Dead"
#nreff 999
#researchlevel 0
#school -1
#end
#newspell -- Remote dead-raising soulless
#copyspell "Call of the Winds"
#name "Remote Soulless Raiser"
#damage 3154
#researchlevel 0
#school -1
#nreff 1
#end
#newspell -- The Blackest Curse
#copyspell "Black Death"
#name "The Blackest Curse"
#descr "With this terrible spell a Von Carstein vampire afflicts a distant province with the blackest of curses. A virulent disease is spread throughout the land, killing no fewer than half
of the population. Some days after their death, the corpses begin to stir once more, and reawaken to slaughter the surviving defenders of the province and claim it for their vampire
master. When the spell has run its course most of the soulless will revert to inanimate corpses, although a few will remain to guard their prize."
#researchlevel 0
#path 0 5 -- Death
#pathlevel 0 4 -- D4
#path 1 1 -- Air
#pathlevel 1 1 -- A1
#researchlevel 8
#fatiguecost 1500
#nextspell "Remote Soulless Raiser"
#spec 0
#restricted 94
#end
--

-------------------------------------------------------------------------
-- Blood
-------------------------------------------------------------------------

#newspell
#name "Contact Necrarch"
#descr "The Acolyte makes contact with a Necrarch, an ancient and powerful vampire, and calls him to serve
the dark god of Sylvania."
#school 6 -- Blood
#path 0 7 -- Blood
#path 1 5 -- Death
#pathlevel 0 2 -- B2
#pathlevel 1 2 -- D2
#researchlevel 0
#effect 10021
#damage 3132 -- Necrarch
#fatiguecost 7000
#nreff 1
#restricted 94
#end


#newspell -- Curse of Hunger, summons a few ghouls for free
#copyspell "Reanimation"
#name "Curse of Hunger"
#descr "With this foul spell the Necrarch curses some of the local human population with the Hunger. The unfortunate victims will suffer a terrible craving for human flesh, and
will gradually degenerate into mindless undead ghouls. The population of the province will be somewhat reduced, with the loss of both the ghouls themselves and some of the humans
they have devoured during their degeneration."
#school 6 -- Blood
#path 0 5 -- Death
#path 1 7 -- Blood
#pathlevel 0 3 -- B3
#pathlevel 1 3 -- D3
#researchlevel 0
#fatiguecost 0 -- Gem-free summon
#nreff 12
#damage 3158 -- Pre-ghoul which kills population
#restricted 94
#end

#newspell
#name "Vanhel's Danse Macabre"
#descr "The Necrarch enchants all friendly undead with the power of the bizarre Danse Macabre. Twitching and lurching, the undead move at an unnatural pace and cross the battlefield at
great speed. This spell complements the effects of Unholy Vigor."
#school 6 -- Blood
#path 0 7 -- Blood
#path 1 5 -- Death
#pathlevel 0 3 -- B3
#pathlevel 1 3 -- D3
#researchlevel 1
#effect 23 -- Buff
#damage 4 -- Haste
#spec 71303168 -- Only affects friendly undead
#aoe 666
#fatiguecost 100 -- Costs 1 blood slave
#explspr 10043 -- Rising red mist.
#restricted 94
#end

#newspell -- Call Crypt Ghouls, summons a few Crypt Ghouls for free
#copyspell "Reanimation"
#name "Call Crypt Ghouls"
#descr "The Necrarch reaches out with his mind and locates some weak-minded Crypt Ghouls to dominate. A small group of these degenerate creatures will come fawning, ready to serve their dark
master."
#school 6 -- Blood
#path 0 5 -- Death
#path 1 7 -- Blood
#pathlevel 0 3 -- D3
#pathlevel 1 3 -- B3
#researchlevel 1
#fatiguecost 0 -- Gem-free summon
#nreff 8
#damage 3137 -- Crypt Ghoul
#restricted 94
#end

-newspell
-name "Dark Secrets"
-descr "The Necrarch passes on the dark secrets of his power to an eager acolyte. Few humans possess the strength to remain sane with this knowledge, let alone utilise it. With the
acolyte inevitably reduced to a gibbering wreck, the Necrarch grants him a feast of his own blood infused with the concentrated power of some death gems. Once the acolyte has recovered
he may count himself among the ranks of the Necrarchs. Transformed into a monstrous and cursed creature, he will also have acquired power beyond the dreams of most mortal necromancers."
-school 6 -- Blood
-path 0 5 -- Death
-path 1 7 -- Blood
-pathlevel 0 3 -- D3
-pathlevel 1 3 -- B3
-researchlevel 2
-effect 10021
-damage 3133
-fatiguecost 3000
-nreff 1
-restricted 94
-end

#newspell -- Send Sewer Ghouls, sends Sewer Ghouls to a distant friendly province
#copyspell "Carrion Reanimation" -- an example of a summon in friendly territory
#name "Send Sewer Ghouls"
#descr "The Necrarch strikes a deal with a group of Sewer Ghouls, buying their service in exchange for the blood and flesh of some virgins. The Ghouls are then dispatched to a distance province.
Sewer Ghouls are stealthy and able to reduce unrest by devouring the unfortunate leaders of any rebellious groups. However the population of any province in which they reside will be reduced
due to their depredations."
#school 6 -- Blood
#path 0 7 -- Blood
#path 1 5 -- Death
#pathlevel 0 3 -- B3
#pathlevel 1 3 -- D3
#researchlevel 2
#fatiguecost 2000 -- Costs blood slaves
#damage 3138 -- Sewer Ghoul
#nreff 15
#restricted 94
#end

#newspell -- Morbid Feast, summons lots of crypt ghouls
#copyspell "Call Crypt Ghouls"
#name "Morbid Feast"
#descr "The Necrarch summons a charnel heap of dead and rotting flesh from the Underworld, infused with dark magic. The lure of the feast will summon large numbers of Crypt Ghouls.
Once they have devoured the flesh, the Ghouls will serve the Necrarch."
#nreff 40
#researchlevel 3
#fatiguecost 800
#restricted 94
#end

#newspell
#name "Create Draconic Demon"
#descr "Channelling his full powers of necromancy and demonology, the Necrarch summons a demon from the abyss and binds it to the remains of a long-dead dragon."
#school 6 -- Blood
#path 0 7 -- Blood
#path 1 5 -- Death
#pathlevel 0 4 -- B4
#pathlevel 1 5 -- D5
#researchlevel 7
#effect 10021
#damage 3153 -- Draconic Demon
#fatiguecost 8000
#nreff 1
#restricted 94
#end
