#modname "Warhammer MA Nation: Dwarfs"
#description "This mod adds a dwarf nation to the Middle Age. The nation is heavily inspired by Warhammmer Fantasy Battle tabletop game. Mod made by Burnsaber. Special thanks to Sombre and kianduatha from the dom3 forums."
#version 0.98
#icon "./Dwarves/Dwarf_Banner.tga"

-- Changes for 0.98 made by llamabeast and Sombre (hope you don't mind Burnsaber!).
-- Simply removed effects on base game, given recent increase in availability
-- of spell slots and nametype slots.
-- Also fixed bug with dwarf ranged weapons lacking nostr tag

-Monsternumbers -> 2650 - 2688
-Weaponnumbers -> 840 - 858 
-Armornumbers -> 340 - 349
-Sitenumbers -> 795
-Nationnumber -> 75
-Nametypes -> 152
-Spell slots taken -> 19
-Spell used for custom #onebattespells -> "Berserkers", "Healing Touch" and "Tune of Dancing Death"

To Do List
----------

Changes from 0.92 to 0.95
------------

--slight dwarf armor prot nerfs
--tweaks to custom armors and weapons
--Description fixes
--small nerf for the "Grudgestone" spell


//////////////////////////////////////////////////
------------ONEBATTLESPELLS-----------------------
//////////////////////////////////////////////////

--Edited for use as an onebattlespell for the Brother of War

#newspell
#copyspell 649 -- "Berserkers"
#end
#selectspell 649
#name "gogoho"
#range 0
#aoe 1
#damage 2 -- luck
#precision 100
#fatiguecost 0
#school -1
#researchlevel 0
#spec 128
#nextspell "Touch of Madness"
#end

---- Runesmith Battleform

#newspell
#copyspell 549 -- Healing Touch
#end
#selectspell 549 -- Healing Touch
#name "Runesmith Battleform"
#descr "changes Runemsmith into his battleform."
#flightspr -1
#explspr 10220
#path 0 3
#school -1
#aoe 1
#range 0
#effect 54
#damage 2
#researchlevel 0
#restricted 75
#pathlevel 0 8
#spec 128
#fatiguecost 0
#end

---- Runelord Battleform

#newspell
#copyspell "Tune of Dancing Death
#end
#selectspell "Tune of Dancing Death"
#name "Runelord Battleform"
#descr "changes Runelord into his battleform."
#flightspr -1
#explspr 10220
#path 0 3
#school -1
#aoe 1
#range 0
#effect 54
#damage 9
#researchlevel 0
#restricted 75
#pathlevel 0 8
#spec 128
#fatiguecost 0
#end

//////////////////////////////////////////////////
------------WEAPONS-------------------------------
//////////////////////////////////////////////////

#newweapon 840
#name "Dwarf Axe"
#dmg 7
#att 0
#def -1
#rcost 4
#len 1
#end

#newweapon 841
#name "Dwarf Warhammer"
#dmg 7
#att 0
#def 0
#rcost 5
#len 1
#end

#newweapon 842
#name "Dwarf Crossbow"
#dmg 12
#armorpiercing
#nratt -2
#att 3
#def 0
#range 35
#ammo 12
#rcost 10
#len 1
#flyspr 109 1
#nostr
#end

#newweapon 843
#name "Dwarf Arbalest"
#dmg 16
#armorpiercing
#nratt -3
#att 3
#def 0
#range 40
#ammo 12
#rcost 15
#flyspr 109 1
#len 1
#nostr
#end

#newweapon 844
#name "Dwarf Throwing Axes"
#dmg 6
#nratt 2
#att -2
#def 0
#range -1
#ammo 3
#rcost 4
#flyspr 411 4
#len 1
#end

#newweapon 845
#name "Oath Hammer"
#twohanded
#dmg 10
#att 1
#def 1
#rcost 8
#magic
#len 3
#end

#newweapon 846
#name "Dwarf Greataxe"
#twohanded
#dmg 10
#att 1
#def -1
#rcost 7
#len 3
#end

#newweapon 847
#name "Dwarf Warpick"
#twohanded
#dmg 12
#att 0
#def -1
#rcost 5
#len 2
#end

#newweapon 848
#name "Runehammer"
#dmg 8
#att 2
#def 2
#rcost 15
#magic
#len 1
#end

#newweapon 849
#name "Dragon Staff"
#dmg 14
#nostr
#armorpiercing
#fire
#att 2
#def -2
#rcost 15
#magic
#len 2
#secondaryeffect 7
#end

#newweapon 850
#name "Dwarf Fire"
#dmg 14
#nostr
#armorpiercing
#aoe 1
#fire
#att 2
#def -2
#range 7
#ammo 5
#rcost 15
#flyspr 421 5
#explspr 10123
#magic
#len 1
#end

#newweapon 851
#name "Slayer Axe"
#dmg 7
#att 1
#def -1
#rcost 5
#len 1
#secondaryeffect 853
#end

#newweapon 852
#name "Slayer Runeaxe"
#dmg 9
#att 3
#def 0
#rcost 10
#magic
#len 2
#secondaryeffect 853
#end

#newweapon 853
#name "Slaying"
#dt_large
#dmg -4
#att 0
#def 0
#rcost 0
#len 1
#bonus
#end

#newweapon 854
#name "Greataxe of Grudges"
#twohanded
#armorpiercing
#magic
#dmg 10
#att 3
#def 1
#rcost 20
#len 3
#secondaryeffectalways 366 --Ancient Grudges, curse luck, no save, aoe 1
#end


#newweapon 855
#name "Book of Grudges"
#bonus
#dmg 1
#nostr
#aoe 1
#att 100
#range 100
#ammo 15
#rcost 0
#flyspr 232 4
#explspr 10020
#secondaryeffectalways 366 -- Curse Luck, no mr
#magic
#end

#newweapon 856
#name "Dwarf Lightning"
#dmg 10
#nostr
#armornegating
#shock
#att 3
#range 30
#ammo 10
#rcost 15
#flyspr 371 8
#explspr 10244
#magic
#len 1
#end

#newweapon 857
#name "Thunder Staff"
#dmg 6
#nostr
#armornegating
#shock
#att 1
#def -1
#rcost 15
#magic
#len 1
#secondaryeffect 252 --club
#end

#newweapon 858
#name "Mechanical Hand"
#dmg 0
#armorpiercing
#att 0
#def 0
#rcost 15
#magic
#len 0
#secondaryeffect 327 --Smasher
#end


#selectweapon 366
#name "Ancient Grudges"
#explspr 10020
#aoe 1
#bonus
#end

//////////////////////////////////////////////////
------------ARMOURS--------------------------------
//////////////////////////////////////////////////

#newarmor 340
#name "Dwarf Chain Cuirass"
#def 0
#type 5
#enc 1
#prot 12
#rcost 11
#end

#newarmor 341
#name "Dwarf Chain Hauberk"
#def -1
#type 5
#enc 2
#prot 14
#rcost 17
#end

#newarmor 342
#name "Dwarf Full Plate"
#def -2
#type 5
#enc 4
#prot 22
#rcost 30
#end

#newarmor 343
#name "Dwarf Ring Mail"
#def 0
#type 5
#enc 1
#prot 10
#rcost 8
#end

#newarmor 344
#name "Dwarf Plate Hauberk"
#def -2
#type 5
#enc 3
#prot 18
#rcost 21
#end

#newarmor 345
#name "Dwarf Helmet"
#def 0
#type 6
#enc 0
#prot 16
#rcost 3
#end

#newarmor 346
#name "Dwarf Full Helmet"
#def -1
#type 6
#enc 0
#prot 21
#rcost 7
#end

#newarmor 347
#name "Dwarf Shield"
#def 3
#type 4
#enc 1
#prot 18
#rcost 4
#end

#newarmor 348
#name "Runic Ward"
#def 5
#type 4
#enc 0
#prot 40
#rcost 7
#end

#newarmor 349
#name "Runic Crown"
#def 0
#type 6
#enc 0
#prot 30
#rcost 9
#end



//////////////////////////////////////////////////
------------TROOPS--------------------------------
//////////////////////////////////////////////////

#newmonster 2650
#spr1 "./Dwarves/Clansdwarf_1.tga"
#spr2 "./Dwarves/Clansdwarf_2.tga"
#name "Clansdwarf Warrior"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Although clandwarfs are artisans instead of professional soldiers, they still make great warriors once adorned with dwarf steel. For there is not a single clansdwarf who wouldnt dream of righting all the wrongs his ancestors had to suffer and train rigorously to achieve that dream one day. Determined, skilled and well-equipped, the dwarf warriors will squash their foes under the wall of steel that is the dwarf advance. However, their training is often focused on defensive tasks, making them slow on offensive tasks."
#str 11
#prot 3
#weapon 840 --dwarf axe
#armor "Dwarf Shield"
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 3
#hp 13
#mor 13
#mr 13
#att 11
#def 10
#ap 8
#prec 10
#enc 2
#gcost 15
#rcost 3
#poorleader
#mapmove 1
#size 2
#nametype 132
#startage 100
#maxage 300
#end

#newmonster 2651
#spr1 "./Dwarves/Clansdwarf_Heavy_1.tga"
#spr2 "./Dwarves/Clansdwarf_Heavy_2.tga"
#name "Clansdwarf Heavy Warrior"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Although clandwarfs are artisans instead of professional soldiers, they still make great warriors once adorned with dwarf steel. For there is not a single clansdwarf who wouldnt dream of righting all the wrongs his ancestors had to suffer and train rigorously to achieve that dream one day. Determined, skilled and well-equipped, the dwarf warriors will squash their foes under the wall of steel that is the dwarf advance. Clansdwarfs who use heavier armor, train more often and are stronger, making them ideal for offensive missions."
#str 12
#prot 3
#weapon 840 --dwarf axe
#armor "Dwarf Shield"
#armor "Dwarf Helmet"
#armor "Dwarf Plate Hauberk"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 3
#hp 13
#mor 13
#mr 13
#att 11
#def 10
#ap 8
#prec 10
#enc 2
#gcost 18
#rcost 3
#poorleader
#mapmove 2
#size 2
#nametype 132
#startage 100
#maxage 300
#end

#newmonster 2652
#spr1 "./Dwarves/Clansdwarf_Crossbow_1.tga"
#spr2 "./Dwarves/Clansdwarf_Crossbow_2.tga"
#name "Clansdwarf Crossbow"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Dwarf race is quite industrious and skilled in engineering. Their design of the crossbow is as intricate as it is genius and other races can only dream of replicating it. Dwarfs take a lot of pride in their crossbows and are often known to rigorously train their aim. Many of them have custom-made improvements to achieve even greater accuracy. Their training is often focused on defensive tasks, making them slow on offensive tasks."
#str 11
#prot 3
#weapon 840 --dwarf axe
#weapon 842 --dwarf crossbow
#armor "Dwarf Helmet"
#armor "Dwarf Ring Mail"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 3
#hp 13
#mor 13
#mr 13
#att 11
#def 10
#ap 8
#prec 10
#enc 2
#gcost 20
#rcost 5
#poorleader
#mapmove 1
#size 2
#nametype 132 
#startage 100
#maxage 300
#end

#newmonster 2653
#spr1 "./Dwarves/Clansdwarf_Heavy_Crossbow_1.tga"
#spr2 "./Dwarves/Clansdwarf_Heavy_Crossbow_2.tga"
#name "Clansdwarf Heavy Crossbow"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Dwarf race is quite industrious and skilled in engineering. The dwarf arbalest is the most feared ranged weapon in the known world, a true masterpiece of dwarf engineering. Although able to easily pierce even plate mail, the arbalests are time-consuming and hard to make, even by dwarf standards. They also are hard to jock and aim without extensive training and only few dwarfs are skilled in the use of this weapon. Arbalests are often targeted by cavalry and flying monsters and are often equipped for melee combat too."
#str 12
#prot 3
#weapon 846 --dwarf greataxe
#weapon 843 --dwarf arbalest
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 3
#hp 13
#mor 13
#mr 13
#att 11
#def 11
#ap 8
#prec 11
#enc 2
#gcost 25
#rcost 2
#poorleader
#mapmove 2
#size 2
#nametype 132
#startage 135
#maxage 300
#end

#newmonster 2654
#spr1 "./Dwarves/Longbeard_1.tga"
#spr2 "./Dwarves/Longbeard_2.tga"
#name "Longbeard"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Longbeards are the oldest, most experienced dwarf warriors and have fought in more wars than any young dwarf could even imagine. This fact is evidenced by the length of their mighty beards and they get complete respect from other dwarfs, who have been rightly taught to respect their elders. Their presence will improve the morale of nearby dwarf units, who want to prove that the might of dwarven blood isn't diluting and that they can restore the dwarf race to its former glory."
#str 13
#prot 4
#weapon 840 --dwarf axe
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#armor "Dwarf Shield"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 3
#standard 3
#hp 14
#mor 14
#mr 14
#att 13
#def 12
#ap 8
#prec 11
#enc 2
#gcost 25
#rcost 6
#okleader
#mapmove 2
#size 2
#nametype 132 
#startage 290
#maxage 300
#end

#newmonster 2655
#spr1 "./Dwarves/Clansdwarf_Ranger_1.tga"
#spr2 "./Dwarves/Clansdwarf_Ranger_2.tga"
#name "Ranger"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Dwarf craftsmanship is valued all over the world and dwarfs have numerous trading outposts on the surface to sell their goods. The outposts are tempting targets for those who want their piece of dwarf wealth. However, these outposts are defended better than it would seem and most would-be-bandits just end up with axe on their skull for their troubles. For dwarf rangers are extraordinary foresters and have a deadly aim with their throwing axes."
#str 11
#prot 3
#weapon 846 --dwarf greataxe
#weapon 844 --dwarf throwing axes
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival
#forestsurvival
#ambidextrous 1
#stealthy 5 
#darkvision 50
#siegebonus 2
#castledef 3
#hp 13
#mor 13
#mr 13
#att 11
#def 11
#ap 8
#prec 11
#enc 2
#gcost 25
#rcost 3
#okleader
#mapmove 2
#size 2
#nametype 132 
#startage 150
#maxage 300
#end

#newmonster 2656
#spr1 "./Dwarves/Hammer_1.tga"
#spr2 "./Dwarves/Hammer_2.tga"
#name "Hammer"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Hammers are the clan thanes and kings personal bodyguards and possess high social status in dwarf society. All of them are highly skilled warriors are personally selected by the Thane himself. Upon initiation, they swear a sacred oath to their liege, to stand by his side no matter what hellish foe may they face. Hammers take this oath very seriously and there is only one known instance where a Hammer had fled from battle."
#str 12
#prot 3
#weapon 845 --oath hammer
#armor "Dwarf Full Helmet"
#armor "Dwarf Chain Hauberk"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 5
#hp 14
#mor 18
#mr 14
#att 13
#def 12
#ap 8
#prec 10
#enc 2
#gcost 35
#rcost 3
#okleader
#mapmove 1
#size 2
#nametype 132
#startage 200
#maxage 300
#end

#newmonster 2657
#spr1 "./Dwarves/Miner_1.tga"
#spr2 "./Dwarves/Miner_2.tga"
#name "Miner"
#descr "Those dwarfs who choose to mine for a living are exceptionally skilled in their profession, able to tunnel down any fortress wall if they so choose. They know the secrets of the Underway and are able stay hidden in hostile provinces, hiding in the underground tunnels and allowing them to ignore harsh terrain. Dwarf miners are strong and skilled in the use of warpick, a weapon especially suited to punch through thick armour. The work effort of miners is integral for the dwarf society, and if one is recruited for war, replacements will have to be recruited, which takes additional resources and time."
#str 12
#prot 4
#weapon 847 --dwarf warpick
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival
#forestsurvival
#swampsurvival
#wastesurvival
#stealthy 10
#darkvision 
#siegebonus 5
#castledef 3
#hp 14
#mor 13
#mr 13
#att 11
#def 10
#ap 8
#prec 10
#enc 2
#gcost 20
#rcost 11
#okleader
#mapmove 3
#size 2
#nametype 132
#startage 110
#maxage 300
#end

#newmonster 2658
#spr1 "./Dwarves/Dwarf_Slayer_1.tga"
#spr2 "./Dwarves/Dwarf_Slayer_2.tga"
#name "Troll Slayer"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. All of them are above all proud individuals and do not cope easily with failure or personal loss. Should a Dwarf suffer some terrible personal tragedy, he will be inconsolable. The loss of his family, failure to uphold an oath or even getting forsaken in love can seriously unhinge the mind of a dwarf. Sometimes these dwarfs decide that the only way they can keep up the honour of their clan is to forsake any ties to his clan and become a slayer. Having forsaken everything he holds dear, the slayer seeks death by finding large monsters to fight, immune to any feelings of terror. Few manage to survive even their first encounter, but those who do are tough, violent and psychopathically dangerous. They can be easily identified by their dyed orange hair and scarred tough skin."
#str 12
#prot 6
#weapon 851 --slayer axe
#weapon 851 --slayer axe
#mountainsurvival
#ambidextrous 2
#darkvision 50
#siegebonus 2
#castledef 1
#berserk 2
#hp 15
#mor 20
#mr 14
#att 12
#def 11
#ap 8
#prec 10
#enc 2
#gcost 40
#rcost 5
#okleader
#mapmove 2
#size 2
#nametype 132
#startage 120
#maxage 300
#end

#newmonster 2659
#spr1 "./Dwarves/Ironbreaker_1.tga"
#spr2 "./Dwarves/Ironbreaker_2.tga"
#name "Ironbreaker"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Ironbreakers are dwarfs who have been tasked with the duty of guarding the clan treasury. They are skilled warriors and are protected by finely crafted dwarf plate mail. Due to their important task, Runesmiths often enchant their armours with minor runes of warding, so that not even a magical assault could penetrate this last line of defence."
#str 12
#prot 4
#weapon 841 --dwarf warhammer
#armor "Dwarf Full Helmet"
#armor "Dwarf Full Plate"
#armor "Dwarf Shield"
#mountainsurvival
#darkvision 50
#shockres 50
#fireres 50
#coldres 50
#poisonres 50
#siegebonus 2
#castledef 4
#hp 15
#mor 14
#mr 15
#att 12
#def 12
#ap 8
#prec 10
#enc 2
#gcost 30
#rcost 4
#okleader
#mapmove 1
#size 2
#nametype 132
#startage 200
#maxage 300
#end

#newmonster 2660
#spr1 "./Dwarves/Dwarf_Runeguard_1.tga"
#spr2 "./Dwarves/Dwarf_Runeguard_2.tga"
#name "Runeguard"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Runeguards are the hardiest dwarfs there are, for they have been tasked with the sacred task of guarding the Runesmiths and their sacred secrets. They possess extraordinary willpower, well-able to resist arcane and mental assaults. They also wield runic warhammers of great power and are runically warded against the heat of the runeforges. Runeguards and their task are sacred to the dwarf race."
#str 12
#prot 4
#weapon 848 --Runehammer
#armor "Dwarf Helmet"
#armor "Dwarf Plate Hauberk"
#armor "Dwarf Shield"
#mountainsurvival
#darkvision 50
#fireres 50
#siegebonus 2
#castledef 3
#holy
#hp 15
#mor 16
#mr 16
#att 13
#def 12
#ap 8
#prec 10
#enc 2
#gcost 1
#rcost 7
#okleader
#mapmove 2
#size 2
#nametype 132 
#startage 200
#maxage 300
#end

//////////////////////////////////////////////////
------------COMMANDERS----------------------------
//////////////////////////////////////////////////

--Thane

#newmonster 2661
#spr1 "./Dwarves/Thane_1.tga"
#spr2 "./Dwarves/Thane_2.tga"
#name "Thane"
#descr "Thanes are dwarf nobility and compose the council of elders for each dwarf clan alongside the Runesmiths. However, unlike human nobles, dwarf thanes are not born into their position, but picked by the council of elders. As a result, only dwarfs who are skilled administrators and warriors act as Thanes, making sure that clan is always lead by the brightest minds and strongest hands within the clan. Some Thanes swear a sacred oath to defend their land and inscribe this oath to a large stone. In battle, the oathsworn Thane will stand upon this stone, gaining great strength and protection from the power of his oath. However, once oath is sworn, it cannot ever be taken back and the Thane will forever stay in the land he has sworn to guard."
#str 12
#prot 4
#weapon 840 --dwarf axe
#armor "Dwarf Helmet"
#armor "Dwarf Chain Hauberk"
#armor "Dwarf Shield"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 4
#shapechange 2664
#hp 15
#mor 16
#mr 15
#att 13
#def 12
#ap 8
#prec 10
#enc 2
#gcost 50
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 132
#startage 200
#maxage 300
#end

--Thane on Oathstone

#newmonster 2664
#spr1 "./Dwarves/Thane_Oathstone_1.tga"
#spr2 "./Dwarves/Thane_Oathstone_2.tga"
#name "Oathsworn Thane"
#descr "Some Thanes swear a sacred oath to defend their land and inscribe this oath to a large stone. In battle, the oathsworn Thane will stand upon this stone, gaining great strength and protection from the power of his oath. However, once oath is sworn, it cannot ever be taken back and the Thane will forever stay in the land he has sworn to guard. His oath also grant the blessing of wisdom, allowing him to tap into the divine might of the awakening god. Oathsworn thane is a glorious sight on he battlefield and will improve the morale of any nearby dwarf units."
#str 13
#prot 5
#weapon 840 --dwarf axe
#armor "Dwarf Helmet"
#armor "Dwarf Chain Hauberk"
#armor "Runic Ward"
#onebattlespell "Sermon of Courage"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 4
#standard 15
#magicskill 8 1
#immobile
#holy
#hp 17
#mor 30
#mr 16
#att 14
#def 13
#ap 8
#prec 10
#enc 1
#gcost 0
#rcost 1
#goodleader
#mapmove 1
#size 3
#nametype 132
#startage 200
#maxage 300
#end


--Dwarf Runebearer

#newmonster 2662
#spr1 "./Dwarves/Dwarf_Runebearer_1.tga"
#spr2 "./Dwarves/Dwarf_Runebearer_2.tga"
#name "Runebearer"
#descr "Dwarfs have many enemies and few friends amongst the other races of this world. It doesn't help that dwarf communities are spread out in order to possess the richest mineral veins the earth can offer. Hence, it's quite common for a dwarf hold to become sieged and find itself in need of assistance from other clans. But dwarfs have their ways to make sure that messages run between the holds, no matter what. Young, agile and brave dwarfs are sometimes trained as 'Runebearers', to become experts of the Underway and untiring runners. Their ability to travel between provinces is unmatched, as they are able to use the ancient dwarf tunnels to short cut and carry magical runes of endurance. They sometimes lead small squads of miners through the dangers of the Underway."
#str 12
#prot 4
#weapon 840 --dwarf axe
#armor "Dwarf Helmet"
#armor "Dwarf Ring Mail"
#mountainsurvival
#forestsurvival
#swampsurvival
#wastesurvival
#stealthy 15
#darkvision 
#siegebonus 2
#castledef 3
#reinvigoration 2
#itemslots 31878
#hp 15
#mor 15
#mr 14
#att 11
#def 12
#ap 12
#prec 10
#enc 2
#gcost 25
#rcost 1
#poorleader
#mapmove 4
#size 2
#nametype 132
#startage 120
#maxage 300
#end

--Ranger Champion

#newmonster 2663
#spr1 "./Dwarves/Clansdwarf_Ranger_Champion_1.tga"
#spr2 "./Dwarves/Clansdwarf_Ranger_Champion_2.tga"
#name "Ranger Champion"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. They once ruled over a vast golden empire, but their power has been dwindled under constant attacks from their numerous foes. Dwarfs have learned a great deal from these battles and as a result, each one of them knows a great deal about stonework and siege warfare. Dwarf craftsmanship is valued all over the world and dwarfs have numerous trading outposts on the surface to sell their goods. The outposts are tempting targets for those who want their piece of dwarf wealth. However, these outposts are defended better than it would seem and most would-be-bandits just end up with axe on their skull for their troubles. Ranger Champions are odd individuals, being more at home in the forests than their home clan. They use crossbows for hunting and are quite skilled foresters. They sometimes lead dwarf rangers into enemy territory."
#str 12
#prot 4
#weapon 846 --dwarf greataxe
#weapon 842 --dwarf crossbow
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival
#forestsurvival
#ambidextrous 2
#stealthy 10 
#darkvision 50
#siegebonus 2
#castledef 3
#hp 14
#mor 14
#mr 14
#att 12
#def 12
#ap 8
#prec 12
#enc 2
#gcost 10
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 132
#startage 150
#maxage 300
#end

--Clan King

#newmonster 2665
#copystats 1997
#clearmagic
#spr1 "./Dwarves/Dwarf_King_1.tga"
#spr2 "./Dwarves/Dwarf_King_2.tga"
#name "Clan King"
#descr "Each major clan has a king. Unlike the position of a Thane, the title of a clan King is hereditary within a specific family inside a clan. This family often has a royal bloodline, linking them to the great dwarrows themselves. The king is advised by the Council of Elders and the combined wisdom and strength of these parts make for a stable government. Clan Kings are not only great warriors and leaders, but also historians, knowing their ancestors by heart. They keep track of the grudges of the clan and constantly plan on ways to make them right. Their knowledge on dwarf history allows them to help the Runesmiths in the rediscovery of ancient runic secrets. They can also channel the power of their ancestors and curse foes for their sins against the dwarf race with their ancient battleaxe. Like Thanes, Kings can swear the Oath of Heart and Hold (note that this change is irreversible)."
#str 13
#prot 5
#weapon 854 --Greataxe of Grudges
#armor "Runic Crown"
#armor "Dwarf Chain Hauberk"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 5
#shapechange 2666
#holy
#hp 17
#mor 17
#mr 17
#att 14
#def 13
#ap 8
#prec 11
#enc 2
#gcost 160
#rcost 1
#expertleader
#mapmove 2
#size 2
#nametype 132
#startage 225
#maxage 300
#end

--Clan King on Oathstone

#newmonster 2666
#copystats 1997
#spr1 "./Dwarves/Dwarf_King_Oathstone_1.tga"
#spr2 "./Dwarves/Dwarf_King_Oathstone_2.tga"
#name "Oathsworn King"
#descr "Each major clan has a king. Clan Kings are not only great warriors and leaders, but also historians, knowing their ancestors by heart. They keep track of the grudges of the clan and constantly plan on ways to make them right. As a result, they can channel the power of their ancestors and curse foes for their sins against the dwarf race. Some Kings swear a sacred oath to defend their land and inscribe this oath to a large stone. In battle, the Oathsworn King will stand upon this stone, gaining great divine strength and protection from the power of his oath. Oathsworn King is a glorious sight on he battlefield and will improve the morale of any nearby dwarf units."
#str 14
#prot 6
#weapon 854 --Greataxe of Grudges
#armor "Runic Crown"
#armor "Dwarf Chain Hauberk"
#armor "Runic Ward"
#onebattlespell "Blessing"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 5
#standard 20
#researchbonus 1
#immobile
#magicskill 8 1
#makemonster1 2650 --Clansdwarf Warrior
#holy
#hp 18
#mor 30
#mr 18
#att 15
#def 14
#ap 8
#prec 10
#enc 1
#gcost 200
#rcost 1
#expertleader
#mapmove 1
#size 3
#nametype 132
#startage 200
#maxage 300
#end

---Engineer

#newmonster 2668
#spr1 "./Dwarves/Master_Engineer_1.tga"
#spr2 "./Dwarves/Master_Engineer_2.tga"
#name "Engineer"
#descr "Dwarfs are industrious people and highly skilled in the ways of engineering. Dwarf engineers are without any doubt best in the known world. Most of their inventions are practical and functional, like pumps to clear water from mine workings and simple engines to draw cages up vertical shafts. However, as the ascension wars grew closer, the engineers devised many frightening inventions for warfare. The guild of engineers the only guild allowed to practice magic outside he jurisdiction of runesmiths, for some of their machines need magical power sources. Engineers do not practice rune magic and are subject to the drain scale, unlike runesmiths. Engineers have been trained to be able to accurately aim intricate siege engines and aiming their arbalest to the eye of an orc is an easy task in comparison. The work effort of engineers is integral for the dwarf society, and if one is recruited for war, replacements will have to be trained, which takes additional resources and time."
#str 12
#prot 4
#weapon 841 --dwarf warhammer
#weapon 843 --dwarf arbalest
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival 
#darkvision 50
#siegebonus 25
#castledef 15
#hp 14
#mor 14
#mr 14
#att 12
#def 12
#ap 8
#prec 12
#enc 2
#gcost 125
#rcost 31
#custommagic 128 100
#custommagic 256 100
#custommagic 1024 100
#custommagic 1408 10
#okleader
#mapmove 2
#size 2
#nametype 132
#startage 150
#maxage 300
#end

--Giant Slayer

#newmonster 2667
#spr1 "./Dwarves/Giant_Slayer_1.tga"
#spr2 "./Dwarves/Giant_Slayer_2.tga"
#name "Giant Slayer"
#descr "Dwarfs are an ancient and hardy race from beneath the mountains. All of them are above all proud individuals and do not cope easily with failure or personal loss. The loss of his family, failure to uphold an oath or even getting forsaken in love can seriously unhinge the mind of a dwarf. Sometimes these dwarfs decide that the only way they can keep up the honour of their clan is to forsake any ties to his clan and become a slayer. Having forsaken everything he holds dear, the slayer seeks death by finding large monsters to fight, immune to any feelings of terror. Few manage to survive even their first encounter, but those who do are tough, violent and psychopathically dangerous. They can be easily identified by their dyed orange hair and scarred tough skin. This Slayer has managed to slay a Giant, a clear sign that this layer has been destined for greatness by Grimnir.  The Giant Slayer and some troops near him will be thrown into a wild battle frenzy at the start of the battle."
#str 13
#prot 7
#weapon 851 --slayer axe
#weapon 851 --slayer axe
#mountainsurvival
#onebattlespell 649
#reinvigoration 2
#itemslots 30854
#ambidextrous 3
#darkvision 50
#siegebonus 2
#berserk 3
#hp 19
#mor 30
#mr 15
#att 13
#def 12
#ap 8
#prec 10
#enc 2
#gcost 70
#rcost 1
#poorleader
#mapmove 2
#size 2
#nametype 132
#startage 120
#maxage 300
#end

--Journeyman Runesmith

#newmonster 2669
#copystats 325
#clearmagic
#spr1 "./Dwarves/Journeyman_Runesmith_1.tga"
#spr2 "./Dwarves/Journeyman_Runesmith_2.tga"
#name "Journeyman Runesmith"
#descr "Dwarf race is very resistant to magic and find it hard to use magic themselves. As a result, they have developed their unique way to channel magic, called Rune Magic. It is based on storing and shaping magic by runes, making it especially suited to rituals and forgings in a magic-drained environment. However, the cumbersome and encumbering foci needed to use runic magic in combat make it unsuitable for the battlefield. Journeyman Runesmiths are a special brand of Runesmiths, travelling the world to uncover old dwarrow ruins and trying to learn forgotten secrets by studying these ruins. They choose to use small rune foci, which limits their power but makes them more suited for combat casting. Journeyman Runesmiths are able to infiltrate enemy provinces and are skilled travellers, knowing the tricks needed in harsh terrain."
#str 12
#prot 4
#weapon 840 --dwarf axe
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#forgebonus 5
#mountainsurvival
#forestsurvival
#wastesurvival
#darkvision 50
#siegebonus 2
#castledef 3
#stealthy 0
#hp 14
#mor 14
#mr 14
#att 12
#def 12
#ap 8
#prec 10
#enc 2
#gcost 130
#rcost 1
#holy
#magicskill 3 2
#custommagic 3200 10 --FES
#magicskill 8 1
#noleader
#mapmove 2
#size 2
#nametype 132
#startage 200
#maxage 300
#end


--Runesmith

#newmonster 2670
#copystats 325
#clearmagic
#spr1 "./Dwarves/Dwarf_Runesmith_1.tga"
#spr2 "./Dwarves/Dwarf_Runesmith_2.tga"
#name "Runesmith"
#descr "Dwarf race is very resistant to magic and find it hard to use magic themselves. As a result, they have developed their unique way to channel magic, called Rune Magic. It is based on storing and shaping magic by runes, making it especially suited to rituals and forgings in a magic-drained environment.  Runesmiths are well-respected individuals amongst dwarfs for their craft is more intricate and demanding than any of them could ever imagine. As mighty as rune magic is for forging and rituals, it is an ill-fit for the battlefield and they need to wield the traditional dwarven hammers to use it at all.  Many of them hold seats in their clans own Council of the Elders and sometimes lead small strike forces to reclaim old dwarf holds."
#str 13
#prot 4
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#forgebonus 30
#researchbonus 1
#mountainsurvival
#onebattlespell 549  -- Healing Touch (Changed)
#darkvision 50
#fireres 25
#siegebonus 2
#castledef 3
#itemslots 15488
#hp 15
#mor 16
#mr 16
#att 12
#def 12
#ap 8
#prec 11
#enc 3
#gcost 215
#rcost 1
#holy
#magicskill 0 1
#magicskill 3 2
#magicskill 8 2
#custommagic 3200 100 --FES
#custommagic 1920 10 -FAWE 
#okleader
#mapmove 2
#size 6 -- To prevent their onebattlespell from affecting other troops
#nametype 132
#startage 275
#maxage 350
#end

--Runesmith Battleshape

#selectmonster 2
#clearstats
#copystats 325
#clearmagic
#spr1 "./Dwarves/Dwarf_Runesmith_1.tga"
#spr2 "./Dwarves/Dwarf_Runesmith_2.tga"
#name "Runesmith"
#descr "Dwarf race is very resistant to magic and find it hard to use magic themselves. As a result, they have developed their unique way to channel magic, called Rune Magic. It is based on storing and shaping magic by runes, making it especially suited to rituals and forgings in a magic-drained environment.  Runesmiths are well-respected individuals amongst dwarfs for their craft is more intricate and demanding than any of them could ever imagine. As mighty as rune magic is for forging and rituals, it is an ill-fit for the battlefield and they need to wield the traditional dwarven hammers to use it at all.  Many of them hold seats in their clans own Council of the Elders and sometimes lead small strike forces to reclaim old dwarf holds."
#str 13
#prot 4
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#forgebonus 30
#researchbonus 1
#mountainsurvival
#darkvision 50
#fireres 25
#firstshape 2670
#siegebonus 2
#castledef 3
#itemslots 15488
#hp 15
#mor 16
#mr 16
#att 12
#def 12
#ap 8
#prec 11
#enc 3
#gcost 215
#rcost 1
#holy
#magicboost 53 -1
#okleader
#mapmove 2
#size 2
#nametype 132
#startage 275
#maxage 350
#end

--Runelord

#newmonster 2671
#copystats 325
#clearmagic
#spr1 "./Dwarves/Dwarf_Runelord_1.tga"
#spr2 "./Dwarves/Dwarf_Runelord_2.tga"
#name "Runelord"
#descr "Dwarfs find it hard to use magic and they have developed their unique way to channel magic, called Rune Magic. It is based on storing and shaping magic by runes, making it especially suited to rituals and forgings in a magic-drained environment. Runesmiths are well-respected individuals amongst dwarfs for their craft is more intricate and demanding than any of them could ever imagine. Runelords are the most skilled and powerful Runesmiths, mostly because they still use the most traditional forms of rune magic, originating from the time when Grungni forged the primal runes. As mighty as rune magic is for forging and rituals, it is an ill-fit for the battlefield and they need to wield the traditional dwarven hammers to use it at all. They hold the wisdom of ancestors and advise the high king on all important matters."
#str 13
#prot 4
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#onebattlespell "Tune of Dancing Death"
#forgebonus 30
#researchbonus 1
#mountainsurvival
#darkvision 50
#fireres 50
#siegebonus 2
#castledef 3
#itemslots 15488
#hp 15
#mor 16
#mr 18
#att 12
#def 12
#ap 8
#prec 11
#enc 3
#gcost 400
#rcost 1
#holy
#magicskill 0 1
#magicskill 3 3
#magicskill 8 3
#custommagic 3200 100 --FES
#custommagic 3968 100 --FAWES
#okleader
#mapmove 1
#size 6 -- To prevent their onebattlespell from affecting other troops
#nametype 132 
#startage 350
#maxage 425
#end


--Runelord Battleform 

#selectmonster 9
#clearstats
#copystats 325
#clearmagic
#spr1 "./Dwarves/Dwarf_Runelord_1.tga"
#spr2 "./Dwarves/Dwarf_Runelord_2.tga"
#name "Runelord"
#descr "Dwarfs find it hard to use magic and they have developed their unique way to channel magic, called Rune Magic. It is based on storing and shaping magic by runes, making it especially suited to rituals and forgings in a magic-drained environment. Runesmiths are well-respected individuals amongst dwarfs for their craft is more intricate and demanding than any of them could ever imagine. Runelords are the most skilled and powerful Runesmiths, mostly because they still use the most traditional forms of rune magic, originating from the time when Grungni forged the primal runes. As mighty as rune magic is for forging and rituals, it is an ill-fit for the battlefield and they need to wield the traditional dwarven hammers to use it at all. They hold the wisdom of ancestors and advise the high king on all important matters."
#str 13
#prot 4
#firstshape 2671
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#forgebonus 30
#researchbonus 1
#mountainsurvival
#darkvision 50
#fireres 50
#siegebonus 2
#castledef 3
#itemslots 15488
#magicboost 53 -1
#hp 15
#mor 16
#mr 18
#att 12
#def 12
#ap 8
#prec 11
#enc 3
#gcost 400
#rcost 1
#holy
#okleader
#mapmove 1
#size 2
#nametype 132 
#startage 350
#maxage 425
#end

/////////////////////////////////////////////////
------------SUMMONS------------------------------
/////////////////////////////////////////////////

--Dragon Slayer

#newmonster 2672
#spr1 "./Dwarves/Dragon_Slayer_1.tga"
#spr2 "./Dwarves/Dragon_Slayer_2.tga"
#name "Dragon Slayer"
#descr "Only very few slayers manage to slay a Troll and survive. Even fewer actually manage to find and slay a Giant without getting squashed. Nearly none survive an encounter with a fierce Dragon. But some psychotic warriors manage to achieve these deeds, having earned the title of an Dragon Slayer. No matter what kind of beast they face in battle, these heroes always seem to come out on top, unable to reach the glorious death they are seeking. This might be due to the blessings of the fickle gods, who have a great destiny in store for this great warrior. Their frightening battlecry will sap strenght from their foes, who will know that only death awaits those who face this chosen warrior in combat. The Dragon Slayer and some troops near him will be thrown into a wild battle frenzy at the start of the battle."
#str 15
#prot 9
#weapon 852 --slayer runeaxe
#weapon 852 --slayer runeaxe
#armor "Runic Ward"
#fear 0
#mountainsurvival
#forestsurvival
#wastesurvival
#swampsurvival
#onebattlespell 649
#reinvigoration 2
#itemslots 63622
#ambidextrous 4
#darkvision 50
#siegebonus 5
#berserk 5
#domsummon20 2658 --Troll Slayer
#hp 24
#mor 30
#mr 16
#att 14
#def 13
#ap 10
#prec 11
#enc 2
#gcost 0
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 132
#startage 180
#maxage 300
#end

---Flamethrower

#newmonster 2674
#spr1 "./Dwarves/Dwarf_Flamethrower_1.tga"
#spr2 "./Dwarves/Dwarf_Flamethrower_2.tga"
#name "Flamethrower"
#descr "This skilled dwarf warrior has been trained in the use of Dragon Staff, an ingenious invention by the dwarf guild of engineers. Dragon staffs are able to fire flame to a large area, hitting several opposing soldiers at once. Their only weakness is the lack of range, but the staffs also make for a dangerous melee weapon, hitting the opponent both with flame and full bludgeoning power of dwarf steel."
#str 12
#prot 4
#weapon 849 --dwarf lighting
#weapon 850 --dwarf fire
#armor "Dwarf Full Helmet"
#armor "Dwarf Chain Hauberk"
#mountainsurvival 
#darkvision 50
#fireres 50
#siegebonus 2
#castledef 3
#hp 14
#mor 14
#mr 14
#att 12
#def 12
#ap 8
#prec 12
#enc 3
#gcost 40
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 132 
#startage 150
#maxage 300
#end

---Thunderer

#newmonster 2675
#spr1 "./Dwarves/Thunderer_1.tga"
#spr2 "./Dwarves/Thunderer_2.tga"
#name "Thunderer"
#descr "This skilled dwarf warrior has been trained in the use of Thunder Staff, an ingenious invention by the dwarf guild of engineers. Thunder staffs are able to fire lighting to accurately and far, ignoring any armour the opponent might be wearing. Thunder Staff also makes for a formidable melee weapons, hitting the opponent both with thunder and full bludgeoning power of dwarf steel."
#str 12
#prot 4
#weapon 856 --dwarf lighting
#weapon 857 --thunderstaff
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival 
#darkvision 50
#shockres 50
#siegebonus 2
#castledef 3
#hp 14
#mor 14
#mr 14
#att 12
#def 12
#ap 8
#prec 12
#enc 3
#gcost 40
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 132 
#startage 150
#maxage 300
#end

--Anvil of Doom

#newmonster 2676
#copystats 325
#clearmagic
#spr1 "./Dwarves/Anvil_of_Doom_1.tga"
#spr2 "./Dwarves/Anvil_of_Doom_2.tga"
#name "Anvil of Doom"
#descr "At the age of the Golden Empire, nearly every Runesmith had a personal Anvil of Doom, grafted with the superior skills of dwarven hands. But dwarves have fallen far and although some Runelords still have some of these artefacts in their possession, they have been rendered powerless by the events of the cataclysm. This Anvil has been somehow recharged by the ancestor spirits and is used by a skilled Runelord, who now has his magical powers multiplied manifold by the Anvil. The Runelord can use his newly found arcane might to travel between provinces and use the mighty primal runes. In battle, the anvil will be fuelled by the grudges of the ancestor spirits, increasing the magical strength of the Runelord even further. The anvil and its user are protected by numerous runic wards. The Anvil of Doom is a tool of vengeance and the ancestor spirits do not like it if the Runelord spends their power on forging or research."
#str 14
#prot 6
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#armor "Runic Ward"
#forgebonus -50
#researchbonus -20
#mountainsurvival
#onebattlespell "Power of the Spheres"
#darkvision 50
#standard 25
#hp 25
#mor 20
#mr 18
#att 13
#def 13
#ap 6
#prec 12
#enc 2
#gcost 600
#rcost 1
#holy
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 3
#magicskill 8 3
#goodleader
#mapmove 2
#size 6
#nametype 132 
#startage 350
#maxage 475
#end

--Ancestor Stone

#newmonster 2677
#spr1 "./Dwarves/Ancestor_Stone_1.tga"
#spr2 "./Dwarves/Ancestor_Stone_2.tga"
#name "Ancestor Stone"
#descr "The ancestor stone is an old artefact from the times of the golden empire. It has been lying in this province for several millennia, hidden by the ancestral dwarfs who once ruled this land. It is enchanted by mighty dwarrow runes and inhibited by numerous dwarf ancestors, who grant the stone its divine might. Sometimes the stone is even powerful enough to evoke some basic elemental combat runes. The ancestor stone is a mighty symbol of ancient glory and will be brought to any battle which might decide the fate of the province."
#str 14
#prot 15
#weapon 118 --Curse
#armor "Runic Ward"
#blind
#shockres 50
#fireres 50
#coldres 50
#poisonres 50
#standard 20
#inanimate
#stonebeing
#immobile
#noitems
#hp 25
#mor 20
#mr 16
#att 13
#def 0
#ap 8
#prec 15
#enc 2
#gcost 0
#rcost 1
#holy
#magicskill 8 1
#custommagic 1920 50 -FAWE
#noleader
#mapmove 1
#size 3
#nametype 132 
#startage 3000
#maxage 10000
#end

--Ancestor Spirit

#newmonster 2687
#spr1 "./Dwarves/Ancestor_Spirit_1.tga"
#spr2 "./Dwarves/Ancestor_Spirit_2.tga"
#name "Ancestor Spirit"
#descr "Dwarfs believe that you cannot travel to the afterlife if you die with a burden of a great grudge on your back. The dwarfs who cannot travel to the Halls of Dwarrows become ancestor spirits, to guide their sons and daughters to do the tasks that were left undone. For a good dwarf always pays his debts and allows no crime to go unpunished. These spirits have some influence upon the mortal realm as they can grant good luck with their approval and curse the enemies of their kin for the crimes they have committed. This dwarf ancestor has been granted a ethereal mortal form through a dwarf invocation. He is the avatar of vengeance, cursed with the knowledge of every wrong done to the dwarf race. Now all enemies of dwarfkin will feel the sins of their fathers as all ancient crimes will be finally paid in full.."
#str 14
#prot 0
#weapon 412 --Axe of Hate
#weapon 366 --Ancient Grudges
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#onebattlespell "Blessing"
#magicboost 52 -1
#mountainsurvival
#poisonres 100
#coldres 50
#darkvision 100
#forgebonus -25
#researchbonus -25
#magicbeing
#fear 0
#ethereal
#berserk 2
#bloodvengeance 2
#hp 25
#mor 30
#mr 16
#att 14
#def 12
#ap 8
#prec 12
#enc 1
#gcost 0
#rcost 1
#holy
#noleader
#mapmove 3
#size 2
#nametype 132 
#startage 1500
#maxage 5000
#end

--Thorek and the Anvil of the Dwarrows

#newmonster 2688
#copystats 325
#clearmagic
#spr1 "./Dwarves/Thorek_1.tga"
#spr2 "./Dwarves/Thorek_2.tga"
#name "Anvil of the Dwarrows"
#descr "This is the legendary Anvil of the Dwarrows, a glorious artefact from times passed. Some say that  Grungni himself forged the primal runes upon its eternal steel. It has been powerless for many millennia, but now holy ritual has charged it with the grudges of the ancestors. Its user was once a mighty prophet of the Awakening god, but he gave his mortal form to the use of the spirit of the legendary Runelord, Thorek Ironbrow, so that this mighty artefact could be used again. His special attunement with the Anvil allows him special favour in the eyes of the ancestors, earning him might beyond the comprehension of any mortal. He is the inventor of the feared 'Rune of Doom', a great spell that will bring the righteous wrath of the dwarf ancestors upon this realm. The Anvil of Dwarrows is a tool of vengeance and Thorek Ironbrow is here to avenge his grudges, not to waste time forging or researching."
#str 14
#prot 7
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#armor "Runic Ward"
#forgebonus -50
#researchbonus -20
#mountainsurvival
#unique
#onebattlespell "Power of the Spheres"
#darkvision 50
#shockres 50
#fireres 50
#coldres 50
#poisonres 50
#standard 25
#hp 25
#mor 20
#mr 18
#att 13
#def 13
#ap 6
#prec 12
#enc 2
#gcost 600
#rcost 1
#holy
#magicskill 0 2
#magicskill 1 2
#magicskill 2 2
#magicskill 3 2
#magicskill 4 4
#magicskill 8 4
#goodleader
#mapmove 2
#size 6
#nametype 132 
#startage 350
#maxage 475
#end

/////////////////////////////////////////////////
------------PRETENDERS---------------------------
/////////////////////////////////////////////////


--Mother of All

#newmonster 2678
#spr1 "./Dwarves/Valaya_1.tga"
#spr2 "./Dwarves/Valaya_2.tga"
#name "Mother of All"
#descr "Valaya is one of three revered dwarrow ancestors. She taught the secrets of society to the young dwarf race, allowing them to build the empire of the golden age. She also told of the importance of respecting your elders and how blood is thicker than stone, bonding all dwarfs together. Now, in this time of need, she has reincarnated to once more lead dwarfs to their former glory. She is a diverse user of magic and able to ward all dwarfs who follow her into battle from opposing magic. She is the incarnation of family and caring, able to heal wounds by touch and prevent bad events in the province where she resides."
#str 13
#prot 6
#weapon 238 --Magic Staff
#armor "Dwarf Chain Cuirass"
#armor "Runic Ward"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 25
#nobadevents 50
#healer 100
#standard 15
#onebattlespell "Antimagic"
#magicskill 4 2
#hp 20
#mor 30
#mr 18
#att 12
#def 14
#ap 8
#prec 11
#enc 2
#pathcost 10
#startdom 3
#restrictedgod 77
#female
#gcost 50
#rcost 1
#expertleader
#mapmove 2
#size 2
#startage 3000
#maxage 7000
#end

--Father of Runes

#newmonster 2679
#spr1 "./Dwarves/Grungni_1.tga"
#spr2 "./Dwarves/Grungni_2.tga"
#name "Father of Runes"
#descr "Grungi is one of three revered dwarrow ancestors. He taught the secrets of steel and runes to the young dwarf race, allowing them to build the empire of the golden age. Now, in this time of need, he has reincarnated to lead the dwarfs to their former glory. He is a master artisan able to build wonders unlike no other at the face of the earth. He is very skilled in earth magic and his mere presence will harden the armor of some soldiers following him. Adorned in the embrace of dwarven steel, he is nigh indestructible."
#str 15
#prot 6
#weapon 848 --runehammer
#armor "Dwarf Full Helmet"
#armor "Dwarf Full Plate"
#armor "Runic Ward"
#onebattlespell "Legions of Steel"
#mountainsurvival
#darkvision 50
#siegebonus 2
#castledef 5
#forgebonus 50
#magicskill 3 2
#hp 25
#mor 30
#mr 18
#att 13
#def 13
#ap 8
#prec 11
#enc 3
#pathcost 40
#startdom 3
#restrictedgod 77
#gcost 50
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 132 
#startage 3000
#maxage 7000
#end


--Grudgebearer

#newmonster 2680
#spr1 "./Dwarves/Grimnir_1.tga"
#spr2 "./Dwarves/Grimnir_2.tga"
#name "Brother of War"
#descr "Grimnir is one of three revered dwarrow ancestors. He taught the secrets of blades and battle to the young dwarf race, allowing them to build the empire of the golden age. He also taught the importance of keeping grudges, for the need for justice is eternal and should not be affected by the ravages of time. Now, in this time of need, he has reincarnated to lead the dwarfs to their former glory. Although he does not possess great magical powers, this reincarnation is quite possibly the deadliest fighter in the known world. At the start of each combat, he and some nearby soldiers following him will be thrown into a great battle fury."
#str 16
#prot 8
#weapon 854 --Greataxe of Grudges
#weapon 854 --Greataxe of Grudges
#weapon 853 --slaying
#armor "Runic Ward"
#mountainsurvival
#onebattlespell 649
#researchbonus -20
#forgebonus -50
#reinvigoration 2
#fear 0
#ambidextrous 4
#darkvision 50
#siegebonus 5
#berserk 5
#standard 20
#magicskill 0 2
#hp 33
#mor 30
#mr 18
#att 14
#def 14
#ap 10
#prec 12
#enc 2
#pathcost 60
#startdom 3
#restrictedgod 77
#gcost 50
#rcost 1
#goodleader
#nametype 132 
#startage 3000
#maxage 7000
#end

--- Master Alchemist as pretender
#newmonster 2681
#copyspr 550
#copystats 550
#gcost 0
#researchbonus 5
#magicskill 0 1
#restrictedgod 77
#end

--- Monolith
#newmonster 2682
#copyspr 657
#copystats 657
#gemprod 6 2
#restrictedgod 77
#descr "The Monolith is a powerful spirit inhabiting a huge standing stone. The spirit cannot leave the Monolith, but it can possess willing targets in order to make its will heard and to perform tasks such as forging items for enchantment. The spirit is tremendously strong in its dominion and it is also magically powerful. In physical battle, the stone would be difficult to destroy, even though it cannot strike back. Each month, priests of the Spirit gather for ceremonies of the seasons, generating nature gems."
#end



/////////////////////////////////////////////////
------------HEROES-------------------------------
/////////////////////////////////////////////////


--Daemon Slayer

#newmonster 2673
#spr1 "./Dwarves/Daemon_Slayer_1.tga"
#spr2 "./Dwarves/Daemon_Slayer_2.tga"
#name "Daemon Slayer"
#descr "Only very few slayers manage to slay a Troll and survive. Even fewer actually manage to find and slay a Giant without getting squashed. Nearly none survive an encounter with a fierce Dragon. But there are some who manage to do these heroic deeds and even more, for slaying a perverted chaos daemon is nigh impossible. Those who manage to do all of these deeds are called Daemon Slayers, mighty dwarf warriors who only seek glorious death on the battlefield. But no matter what foe they face, they always come ahead, chosen for greatness by the ancestral spirits who grant their protection on these great warriors. Their frightening battlecry will sap strenght from their foes, who will know that only death awaits those who face this chosen warrior in combat. Daemon Slayer and some troops near him will be thrown into a wild battle frenzy at the start of the battle."
#str 17
#prot 11
#weapon 852 --slayer runeaxe
#weapon 852 --slayer runeaxe
#weapon 853 --slaying
#weapon 853 --slaying
#armor "Runic Ward"
#mountainsurvival
#forestsurvival
#wastesurvival
#swampsurvival
#onebattlespell 649
#reinvigoration 2
#fear 0
#itemslots 63622
#ambidextrous 5
#darkvision 50
#siegebonus 8
#berserk 4
#domsummon20 2658 --Troll Slayer
#hp 30
#mor 30
#mr 18
#att 15
#def 14
#ap 11
#prec 12
#enc 2
#gcost 1
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 132 
#startage 220
#maxage 300
#end


--Slayer King

#newmonster 2683
#spr1 "./Dwarves/Dwarf_Slayer_King_1.tga"
#spr2 "./Dwarves/Dwarf_Slayer_King_2.tga"
#name "Slayer King"
#descr "It is possible for a Clan King to swear the Slayer Oath, but is extremely rare. So rare indeed, that only one king has done this. Known simply as he Slayer King for most, he is one of the greatest heroes of the dwarf race. He swore his slayer oath because he failed to protect his daughter from an orc attack when she was travelling to marry the son of the High King. However, his oath as a King prevents him from abandoning his clan like most slayers for his duties as king are great and he cannot just leave his people stranded. He rules over the dwarf hold of Karak Kadrin and is known to provide shelter and food to any passing slayers before they leave to continue their quest. Slayers are sometimes known to repay his kindness by following him into battle."
#str 14
#prot 7
#weapon 852 --slayer runeaxe
#weapon 852 --slayer runeaxe
#armor "Runic Ward"
#armor "Dwarf Chain Hauberk"
#armor "Runic Crown"
#standard 25
#mountainsurvival
#onebattlespell "Personal Luck"
#ambidextrous 4
#darkvision 50
#siegebonus 5
#castledef 5
#berserk 4
#domsummon2 2658 --Troll Slayer
#makemonster2 2667 --Giant Slayer
#hp 22
#mor 30
#mr 17
#att 13
#def 13
#ap 9
#prec 11
#enc 2
#gcost 1
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 132 
#startage 180
#maxage 300
#end

--Runesmith Guildmaster

#newmonster 2684
#copystats 325
#clearmagic
#spr1 "./Dwarves/Master_Runelord_1.tga"
#spr2 "./Dwarves/Master_Runelord_2.tga"
#name "Kragg the Grim"
#descr "Kragg is the Master Runelord of the Runesmith's Guild. He is the oldest and by far the greatest living Runesmith - a gnarled old Dwarf, strong and enduring as a weather-beaten oak. His expression is one of eternal disapproval, his beetling brow and granite-like face a withering condemnation of younger, more frivolous Dwarfs. This is quite normal for a Dwarf of his age who has seen many wonders and watched the inevitable decline of craftsmanship and respect. Runesmiths come from all over the Dwarf realms to sit at his feet and listen to his wise words. He knows many secrets of the ancient days, long forgotten by others, and is a living link with near legendary past times. Kragg rarely emerges from the Underhalls, preferring instead to labour secretly on his lore, which he jealously guards. Perhaps one day he will find a worthy successor, but so far no one has proven them self, much to the chagrin of many an aspiring runesmith. He is favoured by the ancestor spirits and does not lose magical might in combat like most runesmiths."Kragg is the Master Runelord of the Runesmith's Guild. He is the oldest and by far the greatest living Runesmith - a gnarled old Dwarf, strong and enduring as a weather-beaten oak. His expression is one of eternal disapproval, his beetling brow and granite-like face a withering condemnation of younger, more frivolous Dwarfs. Runesmiths come from all over the Dwarf realms to sit at his feet and listen to his wise words. He knows many secrets of the ancient days, long forgotten by others, and is a living link with near legendary past times. Kragg rarely emerges from the Underhalls, preferring instead to labour secretly on his lore, which he jealously guards. Perhaps one day he will find a worthy successor, but so far no one has proven them self, much to the chagrin of many an aspiring runesmith. He is favoured by the ancestor spirits and does not lose magical might in combat like most Runesmiths."
#str 13
#prot 4
#weapon 115 --Dwarven Hammer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#forgebonus 25
#mountainsurvival
#researchbonus -8
#darkvision 50
#fireres 50
#siegebonus 2
#castledef 3
#itemslots 15488
#hp 15
#mor 20
#mr 18
#att 13
#def 13
#ap 8
#prec 11
#enc 3
#gcost 1
#rcost 1
#holy
#magicskill 1 1
#magicskill 2 1
#magicskill 3 2
#magicskill 0 3
#magicskill 4 2
#magicskill 8 3
#goodleader
#mapmove 1
#size 2
#nametype 132 
#startage 380
#maxage 450
#end

---Engineer Guildmaster

#newmonster 2685
#spr1 "./Dwarves/Engineer_Guildmaster_1.tga"
#spr2 "./Dwarves/Engineer_Guildmaster_2.tga"
#name "Engineer Guildmaster"
#descr "The current master of the Engineers guild is regarded as one of the greatest engineers of all time. In his youth he made many great discoveries and invented some of the most outlandish and powerful machines ever to grace a Dwarven workshop. However, following some unwise experimentation with pressure vessels, he lost his left arm. But, with some help from the runesmiths guild, he soon replaced his arm with a mechanical version, which he has tinkered with continually over the years. He has taken liking to building mechanical men to task them with the more dangerous jobs in his workshop. However, his accident has left him with a slight mistrust against machines and he has enchanted his arm to easily crush any lifeless being just in case the mechanical men somehow malfunction."
#str 15
#prot 6
#weapon 858 --mechanical hand
#weapon 168 --piercer
#armor "Dwarf Helmet"
#armor "Dwarf Chain Cuirass"
#mountainsurvival 
#darkvision 50
#siegebonus 30
#castledef 30
#summon1 532 --Mechanical Man
#hp 16
#mor 16
#mr 16
#att 13
#def 13
#ap 8
#prec 13
#enc 3
#gcost 1
#rcost 35
#magicskill 3 3
#magicskill 0 2
#magicskill 1 1
#okleader
#mapmove 2
#size 2
#nametype 132 
#startage 200
#maxage 300
#end

---High King

#newmonster 2686
#spr1 "./Dwarves/Dwarf_High_King_1.tga"
#spr2 "./Dwarves/Dwarf_High_King_2.tga"
#name "High King Thorgrim the Grudgebearer."
#descr "The current High King, Thorgrim the Grudgebearer, is the finest ruler that dwarfs have had in ages. Wisdom of Valaya sits upon his brow, Strength of Grungni in his arms and the Courage of Grimnir in his heart. Whereas most clan kings spend their days moaning over past glory and planning vengeance that will never be claimed, Thorgrim has taken action. He holds the Book of Grudges, which contains all of the crimes ever committed against the dwarf kin. He is determined to line over every single one of them and has lead many successful campaigns against the guilty. His actions have earned him the respect of the ancestor spirits, who will curse anyone who dares to stand in the way of his righteous mission."
#str 16
#prot 7
#weapon 854 --Greataxe of Grudges
#weapon 855 --Book of Grudges
#weapon 366 --Ancestral Grudges
#armor "Runic Crown"
#armor "Silver Hauberk"
#armor "Runic Ward"
#onebattlespell "Doom"
#mountainsurvival
#holy
#darkvision 50
#siegebonus 5
#castledef 15
#summon1 2656 --Hammers
#domsummon20 2656 --Hammers
#standard 25
#hp 25
#mor 30
#mr 18
#att 16
#def 15
#ap 4
#prec 13
#enc 1
#gcost 1
#rcost 1
#magicskill 8 3
#superiorleader
#mapmove 2
#size 2
#nametype 132 
#startage 300
#maxage 400
#end

/////////////////////////////////////////////////
------------SPELLS-------------------------------
/////////////////////////////////////////////////


-------THE NEXT TWO SPELLS COMMENTED OUT FOR MODDING SLOT PRESERVATION
--Rune of Valaya

-newspell
-name "Rune of Valaya"
-descr "Valaya is one of three revered dwarror ancestors. She taught the secrets of society to the young dwarf race, allowing them to build the empire of the golden age. She also told of the importance of respecting your elders and how blood is thicker than stone, bonding all dwarfs together. This spell will allow the Runesmith to channel the power of the benevolent Valaya, healing some wounded dwarfs and boosting morale for any friends who manages to witness this miracle. This spell won't affect any soulless beings that might be fighting alongside the Runemsith."
-flightspr -1
-explspr 10190
-path 0 3
-path 1 8
-school 4
-aoe 1
-range 40
-precision 100
-effect 13
-damage 100
-researchlevel 3
-restricted 
-pathlevel 0 2
-pathlevel 1 2
-spec 13246464
-fatiguecost 0
-nextspell "Sermon of Courage"
-end

----------------------------------------------------

-newspell
-copyspell "Summon Earthpower"
-name "Rune of Grungni"
-descr "Grungi is one of three revered dwarror ancestors. He taught the secrets of steel and runes to the young dwarf race, allowing them to build the empire of the golden age. This spell will channel the power of this mighty ancestor, filling the caster with the powers of the runic forges and increasing his potency in earth and fire magic. The caster will also be protected from the heat of the forges and be constantly reinvigorated so that he can work all day."
-flightspr -1
-explspr 10189
-path 0 3
-path 1 8
-school 3
-aoe 0
-range 0
-researchlevel 0
-restricted 
-pathlevel 0 2
-pathlevel 1 2
-nextspell "Phoenix Power"
-fatiguecost 0
-end

--Grudgestone

#newspell
#copyspell "Panic"
#school -1
#name "Grudge Panic"
#descr "Simply Panic with a different explspr."
#explspr 10188
#end

#newspell
#copyspell "Flying Shards"
#name "Grudgestone"
#descr "It is customary for Runesmiths to take some large stones and carve some runic grudges into them before each battle to remind them of their task in battle. This spell invokes the power of the dwarrows and allows for the smith to throw the heavy stone at his foes. The stone will fly across the air and the vengeful dwarf spirits will guide the stone towards the guilty foe. Most enemies perish under the weight of the sins of their fathers, paying the price that has to paid to make things even. Any survivors will be frightened by this show of righteous dwarven might and will make panic spread in the midst of the enemy. Since the Runesmith physically throws the stone, his strenght will add to the damage of this spell."
#school 2
#researchlevel 3
#path 0 3
#path 1 8
#pathlevel 0 2
#pathlevel 1 1
#effect 2
#aoe 1
#restricted 77
#precision 3
#range 20
#fatiguecost 30
#nreff 1
#spec 1
#damage 10
#explspr -1
#nextspell "Panic"
#end

--Rune of Fire

#newspell
#copyspell "Fireball"
#name "Rune of Fire"
#descr "This primal rune was first invoked by the great Grungni himself, to prove the supremacy of the dwarfs over the power of fire. Now that Runesmiths once more know the ways to enchant Anvils of Doom, this rune has been rediscovered. As the Smith invokes the might of this rune, he will strike the ground seven times with his mighty hammer. With each blow, a blazing ball of fire will appear and strike the ranks of the ememy. Casting this rune without the help an the Anvil of Doom is nearly impossible."
#school 4
#researchlevel 7
#path 0 8
#path 1 0
#pathlevel 0 4
#pathlevel 1 2
#precision 7
#range 5010
#fatiguecost 25
#restricted 77
#nreff 1002
#end

--Rune of Thunder

#newspell
#copyspell "Thunder Strike"
#name "Rune of Thunder"
#descr "This primal rune was first invoked by the great Grungni himself, to prove the supremacy of the dwarfs over the power of thunder. Now that Runesmiths once more know the ways to enchant Anvils of Doom, this rune has been rediscovered. As the Smith invokes the might of this rune, he will throw his mighty hammer to the skies. For one calm moment, nothing happens. But then will come the great thunderclap and three powerful strikes of thunder will shower on the enemy. Once this mighty show is over, the hammer will just reappear in the smith's hand. Casting this rune without the help of an Anvil of Doom is nearly impossible."
#school 4
#researchlevel 7
#path 0 8
#path 1 1
#pathlevel 0 4
#pathlevel 1 2
#precision 7
#range 5010
#fatiguecost 30 
#restricted 77
#nreff 3
#end

--Rune of Earth

#newspell
#name "Rune of Earth"
#descr "This primal rune was first invoked by the great Grungni himself, to prove the supremacy of the dwarfs over the power of Earth. Out of all elements, dwarfs are most connected to the everlasting earth and can invoke its mighty power with ease. This spell will make the ground itself heed the need for avenging grudges and curse the wicked foe with the curse of stones. The affected soldiers will feel the sins of their ancestors on their shoulders, fatiguing them at each step and swing of a weapon. This spell is unresistable and won't affect friendly units. Casting this rune without the help of an Anvil of Doom is nearly impossible."
#flightspr -1
#explspr 10189
#path 0 8
#path 1 3
#school 4
#aoe 7
#range 5010
#precision 7
#effect 11
#damage 32
#researchlevel 7
#restricted 77
#pathlevel 0 4
#pathlevel 1 2
#spec 262144
#fatiguecost 20
#end

--Rune of Water

#newspell
#name "Rune of Water"
#descr "This primal rune was first invoked by the great Grungni himself, to prove the supremacy of the dwarfs over the power of Water. As the Runesmith invokes this mighty rune, he will strike his hands to the ground and feel the underwater rivers pulsating under his hands. With a mighty invocation of the rune, one of these will rivers will float up to the battlefield, striking some opposing soldiers. Affected units will get stuck to the now muddy ground and have their armor drenched in wet sludge, causing rusting and encumbering them even further. Casting this rune without the help of an Anvil of Doom is nearly impossible."
#flightspr -1
#explspr 10045
#path 0 8
#path 1 2
#school 4
#aoe 1003
#range 5010
#precision 7
#effect 11
#damage 134236160
#researchlevel 7
#restricted 77
#pathlevel 0 4
#pathlevel 1 2
#spec 262144
#fatiguecost 15
#end

---Dragon Slayer summon

#newspell
#name "Call of Fate"
#descr "Only very few slayers manage to slay a Troll and survive. Even fewer actually manage to find and slay a Giant without getting squashed. Nearly none survive an encounter with a fierce Dragon. But there are some who manage to do these heroic deeds. Those who manage to do all of these deeds are called Dragon Slayers, mighty dwarf warriors who only seek glorious death on the battlefield. But no matter what foe they face, they always come ahead, chosen for greatness by the ancestral spirits who grant their protection on these great warriors. This spell will light up a great rune to the skies, calling the slayer champion to even greater challenges under the guidance of the awakening god."
#path 0 0
#path 1 8
#school 5
#damage 2672
#nreff 1
#effect 10021
#researchlevel 4
#restricted 77 
#pathlevel 0 2
#pathlevel 1 2
#fatiguecost 1400
#end

---Anvil of Doom summon

---Runeguards

#newspell
#name "Runeguards"
#descr "Runeguards"
#path 0 1
#path 1 0
#school -1
#damage 2660
#nreff 12
#effect 10001
#researchlevel 0
#restricted 77
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 100
#nextspell 91 -- Kill Caster
#end


#newspell
#name "Artefact of the Ages"
#descr "At the age of the Golden Empire, nearly every Runesmith had a personal Anvil of Doom, a great runic item of great power, grafted with the superior skills of dwarven hands. But dwarves have fallen far and although many Runelords have some of these artefacts in their possession, they have been rendered powerless by the events of the cataclysm. However, this huge sacrifice of earth gems will attract the attention of many great ancestor spirits. The caster of this spell will become a vessel for the ancestor spirits and recharge the Anvil through their might. The caster will lose much of his personality and all of his magical items when he becomes a vessel for his ancestors, but he will have his magical power multiplied manifold by the Anvils great power and the whispers of his ancestors will allow him to cast the mighty Primal Runes. As the artifact is reawakened, twelve Runeguards will come to guard it."
#path 0 3
#path 1 8
#school 4
#damage 2676
#nreff 1
#effect 10021
#researchlevel 7
#restricted 77
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 4000
#nextspell "Runeguards"
#end

#newspell
#name "Anvil of the Dwarrows"
#descr "The Anvil of the Dwarrows is the greatest Anvil of Doom ever forged. Some say that Grungni himself forged the Primal Runes upon it. It was guarded and used by the legendary clan of Runesmiths, the Ironbrows, but that clan withered away in the cataclysm. The caster of this spell will call upon the spirit of Thorek Ironbrow, the last heir of the Ironbrow clan. The caster will let him take over his body so that Thorek could use his skills to reawaken the Anvil. The spirit of the   caster will travel to the Dwarrow Halls in the afterlife so that the balance between life and death is sustained. Thorek is the most skilled Runesmith ever to grace this realm and with him will fight all of the spirits of the once mighty Ironbrow clan. And so, their fall will be avenged. As the artifact is reawakened, twelve Runeguards will come to guard it."
#path 0 4
#path 1 8
#school 4
#damage 2688
#nreff 1
#effect 10021
#researchlevel 9
#restricted 77
#pathlevel 0 2
#pathlevel 1 4
#fatiguecost 4000
#nextspell "Runeguards"
#end


---Thunderers

#newspell
#name "Distill Thunder"
#descr "This spell marks a great advance on dwarf alchemy, allowing the Engineer to distill few air gems into a light blue fluorescent fluid. This fluid can then be used into making of a magical staff, adorned with elaborate etchings and runes of great power. These staffs are then given to brave and skilled dwarf warriors, who will practice the use of the staffs for one whole month. Once this rigorous training is complete, the warriors will be ready for the battlefield and avenge grudges by dwarf thunder. Thunder staves are able to fire lightning to accurately and far, ignoring any armor the opponent might be wearing. Thunder Staff also makes a for formidable melee weapon, hitting the opponent both with thunder and full bludgeoning power of dwarf steel."
#path 0 1
#path 1 0
#school 1
#damage 2675
#nreff 3
#effect 10001
#researchlevel 3
#restricted 77
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 600
#end

---Flamethrowers

#newspell
#name "Distill Flame"
#descr "This spell marks a great advance on dwarf alchemy, allowing the Engineer to distill few fire gems into a reddish, thick and hot fluid. This fluid can then be used into making of a magical staff, adorned with elaborate etchings and runes of great power. These staffs are then given to brave and skilled dwarf warriors, who will practice the use of the staffs for one whole month. Once this rigorous training is complete, the warriors will be ready for the battlefield and avenge grudges by dwarf fire. Dragon staffs are able to fire flame to a large area, hitting several opposing soldiers at once. Their only weakness is the lack of range, but the staffs also make for a dangerous melee weapon, hitting the opponent both with flame and full bludgeoning power of dwarf steel."
#path 0 0
#path 1 1
#school 1
#damage 2674
#nreff 3
#effect 10001
#researchlevel 3
#restricted 77
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 600
#end

--Miner Ambush

#newspell
#name "Miner Ambush"
#descr "This spell allows the caster to guide some miners through the maze-like underway and to flank the enemy forces. Eight miners will gradually appear from the edges of the battlefield and attack the enemy."
#flightspr -1
#explspr -1
#path 0 3
#school 0
#range 0
#precision 7
#effect 4043
#damage 2657
#nreff 2
#researchlevel 5
#restricted 77
#pathlevel 0 2
#spec 1
#fatiguecost 100
#end

--Debts Unpaid

#newspell
#copyspell "Ritual of Rebirth"
#name "Debts Unpaid"
#descr "Dwarfs believe that you cannot travel to the afterlife if you die with a burden of a great grudge on your back. The dwarfs who cannot travel to the Halls of Dwarrows become ancestor spirits, to guide their sons and daughters to do the tasks that were left undone. For a good dwarf always pays his debts and allows no crime to go unpunished. These spirits have some influence upon the mortal realm as they can grant good luck with their approval and curse the enemies of their kin for the crimes they have committed. This spell will call upon the spirit of a great dwarf hero from the Hall of Fame and grant him an ethereal form so that he may fight again and avenge his Grudges."
#school 4
#researchlevel 6
#damage 2687
#path 0 4
#path 1 8
#pathlevel 0 2
#pathlevel 1 3
#fatiguecost 1500
#restricted 77
#end

--------Rune of Doom

#newspell
#name "Summon Ancestors to the Edges"
#descr "1 Ancestor Spirits to the edges of the battlefield for 6 turns"
#flightspr -1
#explspr 10233
#path 0 3
#school -1
#range 0
#effect 6043
#damage 2687
#nreff 2
#researchlevel 0
#restricted 77 
#pathlevel 0 3
#nextspell "Doom"
#end

#newspell
#copyspell "Darkness"
#name "Rune of Doom"
#descr "This mighty invocation was invented by the legendary Thorek Ironbrow himself. As this rune is evoked, a mighty thunderclap will shake the battlefield as the skies darken and the sun is hidden behind dark clouds, filling the battlefield with darkness as the power of the ancestor spirits is gathered. The opposing soldiers will be affected by the collective will of thousands of ancestor spirits and will be cursed for life. Finally, the Rune will give some of the ancestor spirits an ethereal form so that they can join the battle may avenge their grudges."
#explspr 10118
#flightspr 10119
#school 4
#researchlevel 9
#path 0 4
#path 1 8
#pathlevel 0 4
#pathlevel 1 5
#fatiguecost 200
#restricted 77
#nextspell "Summon Ancestors to the Edges"
#end



//////////////////////////////////////////////
--------Dwarf Nametype-----------------------
/////////////////////////////////////////////


#selectnametype 152
#clear
#addname "Aldrin"
#addname "Aldor"
#addname "Algund"
#addname "Alkrag"
#addname "Algrom"
#addname "Altrok"
#addname "Alrun"
#addname "Albor"
#addname "Athrankin"
#addname "Athrantrok"
#addname "Athrangun"
#addname "Athrangrond"
#addname "Athranskin"
#addname "Barafin"
#addname "Baragul"
#addname "Barakri"
#addname "Baralok"
#addname "Barari"
#addname "Beladok"
#addname "Belalik"
#addname "Belatrek"
#addname "Belazor"
#addname "Belarig"
#addname "Bokfin"
#addname "Bokkin"
#addname "Bokrin"
#addname "Bokki"
#addname "Bokgrim"
#addname "Dagan"
#addname "Dagrum"
#addname "Dagni"
#addname "Dakrag"
#addname "Darig"
#addname "Drokgni"
#addname "Droktin"
#addname "Droktok"
#addname "Droklun"
#addname "Drokgun"
#addname "Dwalgun"
#addname "Dwalrun"
#addname "Dwalki"
#addname "Dwalgon"
#addname "Dwalgni"
#addname "Elgun"
#addname "Elzun"
#addname "Elagund"
#addname "Elgrim"
#addname "Elbor"
#addname "Fadok"
#addname "Farag"
#addname "Fagrum"
#addname "Fadrin"
#addname "Fatrek"
#addname "Farig"
#addname "Fimgun"
#addname "Fimgroth"
#addname "Fimzor"
#addname "Fimdor"
#addname "Fimbur"
#addname "Furagrim"
#addname "Furgund"
#addname "Furtin"
#addname "Furri"
#addname "Furtok"
#addname "Furador"
#addname "Furekin"
#addname "Furetrek"
#addname "Furerin"
#addname "Gabor"
#addname "Gamin"
#addname "Garun"
#addname "Gatzek"
#addname "Gazor"
#addname "Golkin"
#addname "Golrun"
#addname "Goltrok"
#addname "Goldur"
#addname "Golkrin"
#addname "Grimdor"
#addname "Grimkin"
#addname "Grimtok"
#addname "Grimgrond"
#addname "Grimgni"
#addname "Grunnir"
#addname "Gruntin"
#addname "Grunzok"
#addname "Grungun"
#addname "Grungrom"
#addname "Hakadiln"
#addname "Hakagrond"
#addname "Hakafin"
#addname "Hakagon"
#addname "Hakabor"
#addname "Hurnir"
#addname "Hurri"
#addname "Hurkrag"
#addname "Hurtok"
#addname "Hurfin"
#addname "Kadgni"
#addname "Kadlok"
#addname "Kadkrag"
#addname "Kadrig"
#addname "Kadgul"
#addname "Kazbor"
#addname "Kazdil"
#addname "Kazmin"
#addname "Kaznir"
#addname "Kragkrin"
#addname "Kragki"
#addname "Kragzin"
#addname "Kragzor"
#addname "Kraglok"
#addname "Lokgun"
#addname "Loknir"
#addname "Lokdrim"
#addname "Lokkrin"
#addname "Lokri"
#addname "Morkin"
#addname "Morlun"
#addname "Morgri"
#addname "Morrig"
#addname "Mortrek"
#addname "Nugrim"
#addname "Nugund"
#addname "Nurun"
#addname "Nugrom"
#addname "Nukrim"
#addname "Nordor"
#addname "Norgin"
#addname "Nortrek"
#addname "Norkri"
#addname "Norgni"
#addname "Okabin"
#addname "Okafin"
#addname "Okakri"
#addname "Okarag"
#addname "Okatrok"
#addname "Olfkri"
#addname "Olfrin"
#addname "Olfbir"
#addname "Olftrek"
#addname "Olfnir"
#addname "Othgrond"
#addname "Othrin"
#addname "Othrag"
#addname "Othgrim"
#addname "Othkin"
#addname "Rorgul"
#addname "Rorgrum"
#addname "Rorri"
#addname "Rordin"
#addname "Rorrun"
#addname "Skagrun"
#addname "Skarun"
#addname "Skaron"
#addname "Skagni"
#addname "Skakrag"
#addname "Skalf"
#addname "Skalfson"
#addname "Skalfgun"
#addname "Skalkri"
#addname "Skalfgund"
#addname "Snorkri"
#addname "Snorkin"
#addname "Snorrun"
#addname "Snorrig"
#addname "Snormir"
#addname "Svenf"
#addname "Svengar"
#addname "Svenkin"
#addname "Svenkrim"
#addname "Sventrek"
#addname "Thorgrom"
#addname "Thorin"
#addname "Thorbor"
#addname "Thorkrin"
#addname "Thorri"
#addname "Thronbor"
#addname "Thronf"
#addname "Thronki"
#addname "Thronri"
#addname "Thronfin"
#addname "Unbor"
#addname "Unkrim"
#addname "Ungrim"
#addname "Unrig"
#addname "Ungur"
#addname "Uthagor"
#addname "Valabor"
#addname "Valagul"
#addname "Valaf"
#addname "Valagni"
#addname "Valrag"
#addname "Varrin"
#addname "Varskin"
#addname "Varfin"
#addname "Vargrum"
#addname "Varbor"
#addname "Zakki"
#addname "Zakrun"
#addname "Zaknin"
#addname "Zaktok"
#addname "Zakgul"
#addname "Zarabor"
#addname "Zaraf"
#addname "Zaraki"
#addname "Zaragni"
#addname "Zarrun"
#addname "Furagrum"
#addname "Hekagin"
#addname "Elgrom"
#addname "Norgunson"
#addname "Durkarson"
#addname "Norgun"
#addname "Durkar"
#addname "Zambor"
#addname "Harlok"
#addname "Kragdin"
#addname "Molatok"
#addname "Karamir"
#addname "Buurf"
#addname "Balkrag"
#addname "Dwalik"
#addname "Norik"
#addname "Volkin"
#addname "Rorgrim"
#end


-------- New Sites

#newsite 795
#name "Dwarrow Forges"
#path 0
#gems 0 1
#gems 3 4
#level 0
#homecom 2671 --Runelord
#res 50
#rarity 5
#end



-------- New nations


#selectnation 77
#clear
#name "Dwarfs"
#epithet "Grudges of the Ancestors"
#era 2
#brief "Dwarfs"
#descr "Dwarfs are an ancient race, told to having been sculpted from solid stone by Pantokrator in the early days. This seems plausible, for the dwarf body and their spirit is hardy like stone. A long time ago, dwarfs ruled a vast and glorious empire, from great rune-endowed halls full of laughter and song. However, dwarfs had many enemies and the empire slowly eroded in the face of skaven, orc and elf invasions. And so, like a great mountain that had been dwindled by rain, water and wind, the dwarf race is just a shadow of what it used to be. But as the other races squabble amongst themselves and forget the wisdom of their fathers, dwarfs hone their skills and work together to build a second empire. As the the time of the ascension wars draws closer, the power of dwarf determination grows stronger. Dwarfs are few in number, but each one of them is equipped with dwarf steel and draws power from the spirits of his wronged ancestors."
#summary "
RACE: Hardy Dwarfs with superior equipment, morale and skill. No cavalry. Troops have high resource costs, but runic forges produce extra resources to each fort  
MAGIC: Strong Earth with astral/fire combined with minor access to water and air. Mages strong in forging, but make poor battlemages. Mostly drain immune. 
PRIESTS: powerful"
#templepic 4
#flag "./Dwarves/flag3.tga"
#color 0.3 0.3 0.3
#castleprod 10


------- Add Soldiers

#addrecunit 2650 -- Clansdwarf
#addrecunit 2651 -- Clansdwarf Heavy
#addrecunit 2652 -- Clansdwarf Crossbow
#addrecunit 2653 -- Clansdwarf Heavy Crossbow
#addrecunit 2654 -- Longbeard
#addrecunit 2655 -- Clansdwarf Ranger
#addrecunit 2657 -- Miner
#addrecunit 2659 -- Ironbreaker
#addrecunit 2656 -- Hammer
#addrecunit 2658 -- Troll Slayer
-addrecunit 2687 -- Dwarrow Spirit
-addrecunit 2674 -- Flamethrower
-addrecunit 2675 -- Thunderer

------- Add leaders

#addreccom 2663 -- Ranger Champion
#addreccom 2662 -- Runebearer
#addreccom 2661 -- Thane
#addreccom 2665 -- Clan King
#addreccom 2667 -- Giant Slayer
#addreccom 2668 -- Engineer
#addreccom 2669 -- Journeyman Runesmith
#addreccom 2670 -- Runesmith
-addreccom 2687 -- Dwarrow Spirit
-addreccom 2688 -- Thorek and the Anvil of the Dwarrows
-addreccom 2676 -- Anvil of Doom
-addreccom 2677 -- Ancestor Stone
-addreccom 2672 -- Dragon Slayer 
-addreccom 2673 -- Daemon Slayer
-addreccom 2683 -- Slayer King
-addreccom 2684 -- Runesmith Guildmaster
-addreccom 2685 -- Engineer Guildmaster
-addreccom 2686 -- High King Thorgrim




------- Province Defence

--Sets the units to be used in province defense.

#defcom1 2661 -- Thane
#defcom2 2677 -- Ancestor Stone
 
#defunit1 2650 -- Clansdwarf
#defunit1b 2652
#defunit2 2653 -- Arbalest
#defunit2b 2654 -- Longbeard


--Sets how many of the units to appear per 10 points.

#defmult1 10
#defmult1b 5
#defmult2 5
#defmult2b 10

------- Hero Settings

#multihero1 2673 -- Daemon Slayer
#hero1 2683 -- Slayer King
#hero2 2684 -- Runesmith Guildmaster
#hero3 2685 -- Engineer Guildmaster
#hero4 2686 -- High King Thorgrim



#idealcold 0
#startsite "Dwarrow Forges"
#startfort 42 --Mountain City
#swampfort 37 --Hill Fortress
#farmfort 38 --Hill Castle
#forestfort 37 --Hill Fortress
#mountainfort 9 --Mountain Citadel
#defaultfort 38 --Hill Castle


------- Starting units

#startcom 2661 -- Thane
#startunittype1 2650 -- Clansdwarf
#startunitnbrs1 6
#startunittype2 2652 -- Clansdwarf Crossbow
#startunitnbrs2 6
#startscout 2663 -- Ranger Champion
#end