#modname "Expanded Nations Pack 2"
#description "Adds 9 new nations to the game: 1 in the Early Age, 5 in the Middle Age and 3 in the Late Age. Fully compatible with the Conceptual Balance Mod, Holy War Lesser Edition, and all other mods from Sombre's compatible Mod Catalogue (see the dom3mods forum)."
#icon "ENPs/ENP2_banner.tga"
#version 1.02

-- Compiled by llamabeast, 27/03/11.
-- Updated to v1.01 30/03/11.
-- Updated to v1.02 16/05/11.-- SHANGRI-LA, Hidden City of the Secret Masters (MA)
-- Version 2.05 (Feb. 16, 2011)

-- Original and Primary Author: Nounours
-- Current Revising Author and Maintainer: Globu
-- Past Revising Author/Contributor: Pyg





------------------------------------------------------------------------------
-- GLOBU'S NOTES
------------------------------------------------------------------------------

-- Given that this mod was of high quality, but still needed some work, and
-- that Nounours has not been around for a while, I have adopted the mod and
-- revised it extensively with the intent of making it a full-fledged,
-- polished and MP-balanced nation.

-- ID numbers have been overhauled for compatibility with CBM v1.81 and other
-- major mods.

-- This release will not invalidate savegames created using the 2.02 release.
-- Anything before that will be invalidated by this version.

-- See the readme for more information.


------------------------------------------------------------------------------
-- NOUNOURS'S ORIGINAL NOTES
------------------------------------------------------------------------------

-- First a few credits :


-- Thanks to HoneyBadger, Sombre, Aezeal and Edratman for their help and their
-- advices.

-- Thanks to Psientist for his PretenderCalculator and to EricM for his work
-- on standard units' sprites.

------------------------------------------------------------------------------

---- [To avoid confusion, I have removed his statement of the ID number
---- resources used, since these have changed completely and the current IDs
---- used are stated with specificity in the readme. --Globu]


------------------------------------------------------------------------------
-- MOD INFO
------------------------------------------------------------------------------

-modname "Shangri-La, Hidden City of the Secret Masters"
#domversion 3.26

-description "An MA nation loosely based on Tibetan myth, legends about the hidden Himalayan city of Shangri-La, conspiracy theories about the Ascended Masters and hidden leaders of the world, and a few science-fiction B-movies. Oh, and yetis, too. You never can have too much yetis..."
-icon "./Shangri_La/Banner.tga"



------------------------------------------------------------------------------
-- WEAPONS
------------------------------------------------------------------------------


#newweapon 693
#name "Phurba" -- ritual dagger with blade made from human bone
#dmg 2
#att 1
#def 0
#len 0
#nratt 1
#sound 7
#magic
#dt_demon
#rcost 4
#end


#newweapon 694
#name "Ice Cudgel"
#dmg 8
#att 0
#def 0
#len 3
#nratt 1
#twohanded
#sound 10
#magic
#secondaryeffect 222
#explspr 10108
#rcost 5
#end


#newweapon 695
#name "Kukri"
#dmg 3
#att 1
#def 0
#len 0
#nratt 1
#rcost 2
#sound 7
#end


#newweapon 696
#name "Great Kukri" -- Except for supposed Iberian origin, Falcata would be a better term
-- Toned down to be equivalent to Falchion
#dmg 7
#att 0
#def 0
#len 2
#nratt 1
#sound 7
#rcost 5
#end


-newweapon 697 -- Great Magic Kukri of the demon-kings and their kind
-- unused, so commented out in v2.0
-name "Dmu Great Kukri"
-dmg 9
-att 3
-def 0
-len 3
-nratt 1
-sound 8
-armorpiercing
-magic
-rcost 12
-end


-newweapon 698 -- Hook-curved knife
 -- unused, so commented out in v2.0
-name "Hasiya"
-dmg 4
-att 2
-def 0
-len 3
-nratt 1
-sound 8
-flail
-rcost 3
-end


------------------------------------------------------------------------------
-- ARMOR
------------------------------------------------------------------------------

#newarmor 310
#name "Crude Breastplate"
#type 5
#prot 8
#def 0
#enc 1
#rcost 7
#end


#newarmor 311 -- Rta Pa armor renamed to Lamellar Armor in v2.0
#name "Lamellar Armor"
#type 5
#prot 19
#def -3
#enc 3
#rcost 21
#end

#newarmor 312 -- http://www.metmuseum.org/toah/works-of-art/2001.55
#name "Cane Shield"
#type 4
#prot 12
#def 4
#enc 1
#rcost 1
#end


------------------------------------------------------------------------------
-- UNITS
------------------------------------------------------------------------------

-- Bhdpa Spearman
#newmonster 3702
#name "Bhdpa Spearman"
#spr1 "./Shangri_La/Bhodpa_spearman_1.tga"
#spr2 "./Shangri_La/Bhodpa_spearman_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. They are adept hunters and scouts, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 9
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon 1 -- Spear
#weapon 21 -- Javelin
#armor "Leather hauberk"
#armor "Cane Shield"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Bhdpa Archer
#newmonster 3703
#name "Bhdpa Archer"
#spr1 "./Shangri_La/Bhodpa_archer_1.tga"
#spr2 "./Shangri_La/Bhodpa_archer_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. They are adept hunters and scouts, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 10
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon "kukri" -- Changed from stock dagger to Kukri, as per unit description, in v2.0
#weapon 23 -- Short bow
#armor "Leather hauberk"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Bhdpa Warrior
#newmonster 3704
#name "Bhdpa Warrior"
#spr1 "./Shangri_La/Bhodpa_Warrior_1.tga"
#spr2 "./Shangri_La/Bhodpa_Warrior_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. They are adept hunters and scouts, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 9
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#weapon 21
#armor "Leather hauberk"
#armor "Cane Shield"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Bhdpa yak rider
#newmonster 3705
#name "Bhdpa Yak Rider"
#spr1 "./Shangri_La/GL_Yak_Rider_1.tga"
#spr2 "./Shangri_La/GL_Yak_Rider_2.tga"

#descr "Sturdy and strong, yaks are well-suited to the harsh climate of the Hidden Valley, and see use by the Bhdpa use yaks as pack and traction animals. Some Bhdpa tribesmen train these hardy animals for use as mounts, and ride them into battle with lances and shortbows. A yak can kill a lightly-armored man with its gore attack."

#ap 18
#mapmove 3
#hp 12
#prot 0
#size 3
#str 10
#enc 3
#att 11
#def 10
#prec 9
#mr 10
#mor 10
#gcost 27
#rcost 5
#ressize 2
#nametype 161
#itemslots 13446
#weapon 357
#weapon 352
#weapon 23
#armor "Leather hauberk"
#armor "Buckler"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#mounted
#supplybonus 2
#secondtmpshape 3735
#end


-- Bhdpa Horseman
#newmonster 3706
#name "Bhdpa Horseman"
#spr1 "./Shangri_La/GL_Bhodpa_horseman_1.tga"
#spr2 "./Shangri_La/GL_Bhodpa_horseman_2.tga"
-spr1 "./Shangri_La/Bhodpa_horseman_1.tga" -- Replaced with sprite that looks Bhodpa
-spr2 "./Shangri_La/Bhodpa_horseman_2.tga"

#descr "Though horses are not as well-adapted to the cold, mountainous terrain of Bhd as are yaks, some Bhdpa tribesmen nevertheless use them as mounts. Bhdpa Horsemen are armed with lance and shortbow and wear light armor."

#ap 25
#mapmove 3
#hp 12
#prot 0
#size 3
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 10
#mor 11
#gcost 24
#rcost 5
#ressize 2
#nametype 161
#itemslots 13446
#weapon 357
#weapon 56
#weapon 23
#armor "Leather hauberk"
#armor "Buckler"
#armor "Reinforced leather cap"
#coldres 75
#mounted
#end



-- Shangrilan archer -- Renamed from Mda Pa to Shangrilan Bowman in v2.0 for uniformity of naming scheme
#newmonster 3707
#name "Shangrilan Bowman"
#spr1 "./Shangri_La/Shangrilan_archer_1.tga"
#spr2 "./Shangri_La/Shangrilan_archer_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Mda Pa are Shangrilan archers who use composite bows and don leather armor."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 10
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 161
#itemslots 15494
#weapon 6
#weapon 264
#armor "Full Leather Armor"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Crossbowman
#newmonster 3708
#name "Shangrilan Crossbowman"
#spr1 "./Shangri_La/Shangrilan_crossbowman_1.tga"
#spr2 "./Shangri_La/Shangrilan_crossbowman_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Shangrilan crossbowmen don heavy scale and leather armor."


#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 12
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 123
#itemslots 15494
#weapon 6
#weapon 25
#armor "Scale Mail Hauberk"
--armor "Full Leather Armor"
#armor "Shield"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Heavy Infantry (Polearm)
#newmonster 3709
#name "Shangrilan Heavy Infantry"
#spr1 "./Shangri_La/Shangrilan_Heavy_Infantry_1.tga"
#spr2 "./Shangri_La/Shangrilan_Heavy_Infantry_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Shangrilan heavy infantry are armed with polearms or with swords and great shields, and wear heavy suits of scale armor adorned with brass studs."

#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 9
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 161
#itemslots 15494
#weapon 308 -- Glaive
#armor "Full Scale Mail"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Heavy Infantry (Sword and Shield)
#newmonster 3710
#name "Shangrilan Heavy Infantry"
#spr1 "./Shangri_La/Shangrilan_Heavy_Infantry2_1.tga"
#spr2 "./Shangri_La/Shangrilan_Heavy_Infantry2_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Shangrilan heavy infantry are armed with polearms or with swords and great shields, and wear heavy suits of scale armor adorned with brass studs."

#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 9
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Tower Shield"
#startage 22
#mountainsurvival
#coldres 50
#end


Bhdpa Spearman
Bhdpa Archer
Bhdpa Warrior
Bhdpa Yak Rider
Yak
Bhdpa Horseman

Shangrilan Bowman
Shangrilan Crossbowman
Shangrilan Heavy Infantry (Glaive)
Shangrilan Heavy Infantry (Sword/Shield)


-- Shangrilan Banner-Bearer / Standard-Bearer -- renamed from Dmag Dar to Shangrilan Dmag Dar in v2.0
#newmonster 3711
#name "Shangrilan Dmag Dar"
#spr1 "./Shangri_La/Dmag_Dar_1.tga"
#spr2 "./Shangri_La/Dmag_Dar_2.tga"

#descr "In the Shangrilan army, soldiers who show bravery and high morale on the battlefield are sometimes appointed as Dmag Dar, or banner-bearers. In battle, they carry a banner which helps Shangrilan officers coordinate their troops, and which inspire the troops to take fresh heart during battles."

#ap 12
#mapmove 1
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 11
#mor 14
#gcost 20
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#armor "Scale Mail Hauberk"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#standard 5
#end



-- Shangrilan Elite Infantry
#newmonster 3712
#name "Shangrilan Dmag Hrag" -- renamed from Dmag Hrag to Shangrilan Dmag Hrag in v2.0
#spr1 "./Shangri_La/Dmag_Hrag_1.tga"
#spr2 "./Shangri_La/Dmag_Hrag_2.tga"

#descr "Dmag Hrag are veteran soldiers of the Shangrilan army. These seasoned soldiers don heavy chain mail armor and fight with swords and shields. Their morale is excellent, and they are very skilled fighters. Trained to endure great adversity and grueling forced marches, they can move more swiftly than many other heavy infantry troops."

#ap 12
#mapmove 2
#hp 14
#prot 0
#size 2
#str 11
#enc 3
#att 13
#def 13
#prec 9
#mr 11
#mor 14
#gcost 20
#rcost 1
#nametype 161
#itemslots 15494
#weapon 10
#armor "Full Chain Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Heavy Horseman
#newmonster 3713
#name "Shangrilan Rta Pa"
#spr1 "./Shangri_La/Rta_Pa_1.tga"
#spr2 "./Shangri_La/Rta_Pa_2.tga"

#descr "Rta Pa are Shangrilan heavy cavalry, armed with lance and composite bow. They wear a complex, heavy lamellar armor made of leather and steel scales and reinforced with chain mail. Like their riders, the horses of the Rta Pa are clad in heavy armor."

#ap 23
#mapmove 2
#hp 11
#prot 0
#size 3
#str 11
#enc 4
#att 12 -- Increased from 11 to 12 in v2.0
#def 12
#prec 10
#mr 11
#mor 12
#gcost 40
#rcost 10
#ressize 2
#nametype 161
#itemslots 13446
#weapon 4
#weapon 8
#weapon 264
#weapon 56
#armor "Lamellar Armor"
#armor "Shield"
#armor "Half Helmet"
#coldres 50
#mounted
#end



-- Shangrilan Guardian of the Hidden Valley
#newmonster 3714
#name "Guardian of the Hidden Valley"
#spr1 "./Shangri_La/Guardian_of_the_Hidden_Valley_1.tga"
#spr2 "./Shangri_La/Guardian_of_the_Hidden_Valley_2.tga"

#descr "The most loyal among of the servants of the exiled masters of Shangri-La following were charged with keeping the Hidden Valley safe and concealed from outsiders, as well as rooting out resistance among the population. The direct descendants of these first guards have since inherited this task. Rigorously instilled with an extreme devotion to duty, these seasoned warriors specially trained to defend fortresses and perform police duties, and are adept at spotting spies or sneaking enemies. Called Gsang Rong Skyob Pa, or Guardians of the Hidden Valley, they enjoy a special sacred status in Shangrilan society and answer only to the highest authorities."

#ap 12
#mapmove 1
#hp 15
#prot 0
#size 2
#str 11
#enc 2
#att 13
#def 14
#prec 10
#mr 12
#mor 15
#gcost 60
#rcost 2
#nametype 161
#itemslots 15494
#weapon 10 -- Falchion
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 22
#mountainsurvival
#coldres 50
#castledef 1
#patrolbonus 1
#holy
#end



-- Mi G (Basic Ape-Man)
#newmonster 3715
#name "Mi G"
#spr1 "./Shangri_La/Mi_Go_1.tga"
#spr2 "./Shangri_La/Mi_Go_2.tga"

#descr "When the Hidden Masters settled in Shangri-La, they discovered in the icy caverns there the ruins of an advanced, forgotten race they simply call the Ancient Ones. Living in these ruins were the descendents of the Ancient Ones, a peaceful ape-like race called the Mi G, or wild men, by the local Bhdpa tribesmen. Deeply respected by the Bhdpa and Shangrilans, the Mi G now live among them in the Hidden Valley.

Some scholars believe that the Ancient Ones are related to the Bandar ape-men of Kailasa, but many think this unlikely, because, unlike the Bandar, Mi G have a much longer lifespan, tend to prefer cold climates, and have been civilized from time immemorial. Though the Mi G are a calm and peaceful people, their great strength makes them dangerous foes, and some fight in the armies of Shangri-La."

#ap 14
#mapmove 2
#hp 20
#prot 5
#size 3
#str 16
#enc 3
#att 11
#def 10
#prec 9
#mr 11
#mor 13
#gcost 25
#rcost 2
#nametype 161
#itemslots 15494
#weapon 265 -- Spiked Club
#maxage 100
#mountainsurvival
#coldres 100
#coldpower 1
#end



-- Mi G Hunter
#newmonster 3716
#name "Mi G Rngon Pa"
#spr1 "./Shangri_La/Mi_Go_Hunter_1.tga"
#spr2 "./Shangri_La/Mi_Go_Hunter_2.tga"

#descr "When the Hidden Masters settled in Shangri-La, they discovered in the icy caverns there the ruins of an advanced, forgotten race they simply call the Ancient Ones. Living in these ruins were the descendents of the Ancient Ones, a peaceful ape-like race called the Mi G, or wild men, by the local Bhdpa tribesmen. Deeply respected by the Bhdpa and Shangrilans, the Mi G now live among them in the Hidden Valley.

Some scholars believe that the Ancient Ones are related to the Bandar ape-men of Kailasa, but many think this unlikely, because, unlike the Bandar, Mi G have a much longer lifespan, tend to prefer cold climates, and have been civilized from time immemorial. Though the Mi G are a calm and peaceful people, their great strength makes them dangerous foes, and some fight in the armies of Shangri-La.

Rngon Pa are Mi G hunters, able to pass unseen through enemy territories. They often venture into the wooded lowlands."

#ap 14
#mapmove 2
#hp 20
#prot 5
#size 3
#str 16
#enc 3
#att 11
#def 10
#prec 11
#mr 11
#mor 13
#gcost 30
#rcost 2
#nametype 161
#itemslots 15494
#weapon 1 -- Spear
#weapon 21 -- Javelin
#maxage 100
#mountainsurvival
#forestsurvival
#coldres 100
#coldpower 1
#stealthy 5
#end



-- Mi Dred
#newmonster 3717
#name "Mi Dred"
#spr1 "./Shangri_La/Mi_Dred_1.tga"
#spr2 "./Shangri_La/Mi_Dred_2.tga"

#descr "Among the peaceful Mi G, warfare is seen as a task that burdens the soul with anger, fear and regret, and which consequently prevents enlightenment and spiritual elevation. The Mi Dred, which means 'Terribles Ones' or 'Ferocious People', are sacred warriors instructed in the art of making war without tainting the purity of their souls. In combat, they wield magical cudgels made of enchanted ice that resemble huge icicles. Those struck by these cudgels are frozen by the cold of the high mountains. It is said that these weapons were once far more common, but now only the Mi Dred are entrusted with carrying them."

#ap 14
#mapmove 2
#hp 25
#prot 5
#size 3
#str 17
#enc 3
#att 12
#def 11
#prec 10
#mr 12
#mor 15
#gcost 70
#rcost 2
#nametype 161
#itemslots 15494
#weapon "ice cudgel"
#weapon 21  -- Javelin
#armor "Scale Mail Cuirass"
#armor "Bronze Cap"
#maxage 100
#mountainsurvival
#coldres 100
#coldpower 1
#holy
#end


------------------------------------------------------------------------------
-- COMMANDERS
------------------------------------------------------------------------------


-- Bhdpa Scout
#newmonster 3718
#name "Bhdpa Scout"
#spr1 "./Shangri_La/Bhodpa_scout_1.tga"
#spr2 "./Shangri_La/Bhodpa_scout_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. Many of them are adept hunters, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold.

Bhdpa scouts are able to travel far and fast without being noticed, and they are sent to gather informations about distant territories."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 10
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon 1
#weapon 21
#armor "Furs"
#armor "Cane Shield"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#noleader
#stealthy 10
#end



-- Bhdpa Clan Chief
#newmonster 3719
#name "Bhdpa Sde Pa"
#spr1 "./Shangri_La/Bhodpa_Sde_Pa_1.tga"
#spr2 "./Shangri_La/Bhodpa_Sde_Pa_2.tga"

#descr "When the Shangrilan masters exiled themselves to the mountains, they found and conquered the Bhdpa tribesmen from the isolated kingdom of Bhd, slaying the shaman kings of old. Though they have converted the Bhdpa, by force or persuasion, and have stripped the Bhdpa rulers of all religious influence, the Bhdpa still practice the Bn ancestor worship cult of their forefathers. Indeed, the Bhdpa clans still live in their traditional ways, and are divided between semi-nomadic pastoral tribesman and sedentary agricultural peasants.

The Sde Pa is the chief of a clan or territory, ruling over his tribe in war and peace. Sde Pa often serve their masters by leading their tribes in battle."

#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 11
#enc 3
#att 11
#def 11
#prec 10
#mr 10
#mor 10
#gcost 40
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#weapon 21
#armor "Scale Mail Cuirass"
#armor "Shield"
#armor "Reinforced leather cap"
#startage 25
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Shangrilan Officer
#newmonster 3720
#name "Shangrilan Dmag Dpon"
#spr1 "./Shangri_La/Dmag_Dpon_1.tga"
#spr2 "./Shangri_La/Dmag_Dpon_2.tga"

#descr "A Dmag Dpon is a Shangrilan officer who leads the armies of the Hidden Masters. The position of Dmag Dpon is gained through competence and loyalty, not by birthright, contrary to the practice of many other nations. For this reason, Dmag Dpon are very apt leaders and tend to be popular among their troops."

#ap 12
#mapmove 2
#hp 14
#prot 0
#size 2
#str 11
#enc 2
#att 11
#def 13
#prec 10
#mr 11
#mor 12
#gcost 60
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 27
#mountainsurvival
#coldres 50
#standard 5
#end


-- Shangrilan Cavalry Commander
#newmonster 3721
#name "Shangrilan Rta Dmag Go"
#spr1 "./Shangri_La/Rta_Dmag_Go_1.tga"
#spr2 "./Shangri_La/Rta_Dmag_Go_2.tga"

#descr "Rta Dmag Go are Shangrilan mounted commanders armed with lance and falchion. They wear the same lamellar armor as that worn by the Rta Pa, and their horses are likewise clad in heavy armor."

#ap 23
#mapmove 2
#hp 13
#prot 0
#size 3
#str 12
#enc 4
#att 12
#def 13
#prec 10
#mr 11
#mor 13
#gcost 80
#rcost 10
#ressize 2
#nametype 161
#itemslots 13446
#weapon 4
#weapon 10
#weapon 56
#armor "Lamellar Armor"
#armor "Shield"
#armor "Half Helmet"
#coldres 50
#goodleader
#standard 5
#mounted
#end



-- Shangrilan King
#newmonster 3722
#name "Rje"
#spr1 "./Shangri_La/Rje_1.tga"
#spr2 "./Shangri_La/Rje_2.tga"

--GLOBU CHANGE: Gave Rje a level of Holy magic to justify that hefty 140 gcost.

#descr "A Rje is a Shangrilan king invested with great authority over the people of the Hidden Valley, exercising temporal power in the name of the Hidden Masters. His authority is substantial, but, in practice, it is rather limited and extends only to mundane matters; indeed, in matters of interest to the clergy, Rje defer to the Gelug, the spokesmen for the Hidden Masters. Often given command of large forces, Rje are invested with sacred status by the Hidden Masters, and are revered by their troops, their mere presence inspiring soldiers to great deeds of bravery."

#ap 12
#mapmove 2
#hp 16
#prot 0
#size 2
#str 13
#enc 2
#att 13
#def 16
#prec 11
#mr 12
#mor 15
#gcost 140
#rcost 1
#nametype 161
#itemslots 15494
#weapon 10
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 30
#magicskill 8 1
#goodleader
#mountainsurvival
#coldres 50
#standard 15
#holy
#end





-- Shangrilan Monk
#newmonster 3723
#name "Drapa"
#spr1 "./Shangri_La/Drapa_1.tga"
#spr2 "./Shangri_La/Drapa_2.tga"

#descr "Drapas are Shangrilan monks clothed in saffron robes. In the monasteries of the valley of Shangri-La, they study the religious teachings of spiritual masters in old and sacred texts. Drapas usually spend most of their time praying, meditating and chanting mantras, but they are sometimes sent to foreign lands to serve as spies and preach their faith."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 13
#mor 11
#gcost 100
#rcost 1
#nametype 161
#itemslots 15494
#weapon 92 -- Fist
#armor "Robes"
#startage 33
#mountainsurvival
#coldres 50
#magicskill 8 1
#magicskill 4 1
#custommagic 3328 10
#poorleader
#stealthy
#spy
#holy
#end


-- Ngagspa Sorcerer
#newmonster 3724
#name "Ngagspa"
#spr1 "./Shangri_La/Ngagspa_1.tga"
#spr2 "./Shangri_La/Ngagspa_2.tga"

#descr "With the coming of the new religion, Bhdpa people have turned away from the traditional Bn religion. Bn Pos and Dmu Bns have lost their spiritual and religious influence, and have become Ngagspa, reclusive sorcerers who live in the mountains and practice dark magics. Many of them bind demons or malevolent spirits of the mountains to harm those who offend them, and dabble in the devious ways of necromancy. They are very secretive, and do not share their secrets easily, a fact which makes them ill-suited at magical research."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 13
#mor 11
#gcost 180
#rcost 1
#nametype 161
#itemslots 15494
#weapon "kukri"
#armor "Robes"
#magicskill 3 1
#magicskill 5 1
#magicskill 7 1
#custommagic 21760 100
#researchbonus -3
#poorleader
#mountainsurvival
#coldres 50
#end



-- Ragyapa Priests
#newmonster 3725
#name "Ragyapa"
#spr1 "./Shangri_La/Ragyapa_1.tga"
#spr2 "./Shangri_La/Ragyapa_2.tga"

#descr "Bhdpa believe that after death, an evil spirit may possess the corpse of the deceased. Shangrilans, on the other hand, believe in reincarnation and regard corpses as empty vessels, and thus find no need to preserve the body. In the mountains of Shangri-La where the rocky ground and scarcity of timber make burial difficult, the dead are disposed of by cutting them into small pieces and leaving them exposed to birds and the elements, a practice called bya gtor, or sky burial. Ragyapa are priests that perform the duties of disposing of corpses and dismembering them. Their duties give them some insight into death magic, and they often have some knowledge about air magic as well."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 12
#mor 13
#gcost 160
#rcost 1
#nametype 161
#itemslots 15494
#weapon "kukri"
#armor "Robes"
#holy
#magicskill 5 1
#magicskill 8 1
#custommagic 4352 50

#poorleader
#mountainsurvival
#coldres 50
#end


-- Demon Hunter
#newmonster 3726
#name "Demon Hunter"
#spr1 "./Shangri_La/Demon_Hunter_1.tga"
#spr2 "./Shangri_La/Demon_Hunter_2.tga"

#descr "Demon Hunters are mage-priests charged with hunting down the last Dmu demons and Dmu Bns, occasionally performing exorcisms. They wield phurba, magical daggers that destroy demons and evil spirits. Skilled primarily in fire and astral magic, they dabble in a variety of other magics. Some study air magic, and others learn a few tricks of the sorcerers they hunt, thus acquiring a practical knowledge of dark magics."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 10
#mr 12
#mor 15
#gcost 170
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#holy
#magicskill 0 1
#magicskill 4 1
#magicskill 8 1
#custommagic 6528 20
#poorleader
#mountainsurvival
#coldres 50
#end






-- Wise One (Ape-Man Mage)
#newmonster 3727
#name "Wise One"
#spr1 "./Shangri_La/Mi_Go_Wise_One_1.tga"
#spr2 "./Shangri_La/Mi_Go_Wise_One_2.tga"

#descr "The Wise Ones are Mi G who study the ways of their ancestors. Mi G are descended from a ancient and very advanced race, whose civilization was nearly destroyed by a great cataclysm many centuries ago. Though they have lost much of their knowledge, the Wise Ones are skilled mages and have some mastery over nature and the elements of earth and water. Their study of magic, natural laws, and medicine makes them able healers, and they are also skillful ice crafters. It is they who make the cudgels wielded by the Mi Dreds."

#ap 13
#mapmove 2
#hp 20
#prot 0
#size 3
#str 15
#enc 3
#att 11
#def 10
#prec 10
#mr 13
#mor 12
#gcost 240
#rcost 2
#nametype 161
#itemslots 15494
#weapon 124
#magicskill 2 1
#magicskill 3 1
#magicskill 6 1
#custommagic 9728 50
#poorleader
#maxage 100
#mountainsurvival
#coldres 100
#healer 30
#coldpower 1
#end



-- Red-Hat Lama
#newmonster 3728
#name "Nyingmapa"
#spr1 "./Shangri_La/Lama_Nyingmapa_1.tga"
#spr2 "./Shangri_La/Lama_Nyingmapa_2.tga"

#descr "Lamas are the mage-priests who form the majority of Shangri-La's clergy and who administer the city. The Lamas are divided into three different sects, each sect following a different sphere of practice within the religion. The Nyingmapa, or Red-Hat Sect, are the most traditionalist, and are the most learned in magics and occult lore. They are poorly-versed in politics and do not wield much temporal power, but these mystics know many ancient secrets and long lost lore. The Lamas of the Red-Hat Sect have a long tradition of secrecy, and therefore are able to move and act without being noticed if necessary. Lamas practice lung-gom-pa, a kind of psychic training that allows them to run at an extraordinary speed across vast distances for days without stopping."

#ap 14
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 13
#mor 16
#gcost 290
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#magicskill 1 1
#magicskill 3 2
#magicskill 4 2
#magicskill 8 2
#custommagic 3456 100
#custommagic 3456 10
#poorleader
#mountainsurvival
#coldres 50
#stealthy 0
#holy
#end




-- Yellow-Hat Lama
#newmonster 3729
#name "Gelug"
#spr1 "./Shangri_La/Lama_Gelug_1.tga"
#spr2 "./Shangri_La/Lama_Gelug_2.tga"

#descr "Lamas are the mage-priests who form the majority of Shangri-La's clergy and who administer the city. The Lamas are divided into three different sects, each sect following a different sphere of practice within the religion. The Gelug, or Yellow-Hat Sect, follow a strict monastic tradition that emphasizes self-discipline and progression through sequential stages of initiation. Gelugs are not as skilled in magic as the other sects, but they are the true administrators of Shangri-La, and wield much more influence than others Lamas, making the important day-to-day decisions in matters beneath the attention of the Hidden Masters. Lamas practice lung-gom-pa, a kind of psychic training that allows them to run at an extraordinary speed across vast distances for days without stopping."

#ap 14
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 13
#mor 16
#gcost 220
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#magicskill 1 1
#magicskill 3 1
#magicskill 4 1
#magicskill 8 2
#custommagic 3328 100
#custommagic 3328 10
#okleader
#mountainsurvival
#coldres 50
#holy
#end



-- Black-Hat Lama
#newmonster 3730
#name "Karmapa"
#spr1 "./Shangri_La/Lama_Karmapa_1.tga"
#spr2 "./Shangri_La/Lama_Karmapa_2.tga"

#descr "Lamas are the mage-priests who form the majority of Shangri-La's clergy and who administer the city. The Lamas are divided into three different sects, each sect following a different sphere of practice within the religion. The Karmapa, or Black-Hat Sect, follow a very old shamanistic tradition in which they seek enlightenment through ordeals and trance. Karmapa have learned to foretell the future by interpreting oracles. They also study death magic in order to commune with ancestors. Lamas practice lung-gom-pa, a kind of psychic training that allows them to run at an extraordinary speed across vast distances for days without stopping."

#ap 14
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 16
#mor 12
#gcost 280
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#magicskill 1 1
#magicskill 4 2
#magicskill 5 1
#magicskill 8 2
#custommagic 7424 100
#custommagic 7424 20
#poorleader
#mountainsurvival
#coldres 50
#nobadevents 10
#holy
#end




-- Hidden Master
#newmonster 3731
#name "Hidden Master"
#spr1 "./Shangri_La/Hidden_Master_1.tga"
#spr2 "./Shangri_La/Hidden_Master_2.tga"

#descr "Hidden Masters are mage-priests of great power and ability, and the secret rulers of Shangri-La. Forced into exile many centuries ago, they founded their secret city in a secluded valley in the mountain kingdom of Bhd. Here, they use their power to attain enlightenment and spiritual ascension. They are the religious and temporal supreme leaders of the nation, and represent the pinnacle of spiritual enlightenment in Shangrilan religion. As a result of their high state of enlightenment, they have mastered their own metabolisms and have begun to transcend human needs, gaining incredibly long lifespans and needing to eat only once a month. Masters of lung-gom-pa and levitation, they are able to fly. Few mortals outside of Shangri-La know about the Hidden Masters, and they can travel through enemy territories without being noticed. Hidden Masters rarely use weapons, except for the magical drje, a magical weapon of great power that allows them strike their foes with lightning."


#ap 14
#mapmove 3
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 16
#mor 14
#gcost 400
#rcost 1
#nametype 161
#itemslots 15494
#weapon 92 -- Fist
#weapon 243 -- Lightning
#armor "Robes"
#magicskill 1 2
#magicskill 3 2
#magicskill 4 2
#magicskill 8 3
#custommagic 3328 100
#custommagic 3328 10
#mountainsurvival
#coldres 75
#neednoteat
#flying
#stealthy 0
#maxage 200
#startage 180
#holy
#end



------------------------------------------------------------------------------
-- NATIONAL HEROES
------------------------------------------------------------------------------


-- Tlku
#newmonster 3732
#name "Tlku"
#spr1 "./Shangri_La/Tulku_Child_1.tga"
#spr2 "./Shangri_La/Tulku_Child_2A.tga" -- Nice boy Tlku
--spr2 "./Shangri_La/Tulku_Child_2B.tga" -- Tlku with Attitude

--spr1 "./Shangri_La/Tulku_Adult_1.tga" -- Grown-up Tlku
--spr2 "./Shangri_La/Tulku_Adult_2A.tga"
--spr2 "./Shangri_La/Tulku_Adult_2B.tga" -- Grown-up Tlku, but only physically ^_^


#descr "Tlku are the reincarnated spirits of ancient sages and spiritual teachers who chose to reincarnate instead of leaving this world. Usually born the son of a poor peasant or shepherd, a Tlku starts preaching when just a young boy. Over the years, word of his wisdom spreads through the valleys, until some Lamas are sent to investigate. The Lamas quickly find that the young boy is, in fact, the spirit of a very respected Hidden Master who attained spiritual enlightenment, but chose to reincarnate in a mortal body to guide mortals toward spiritual ascension."

#ap 12
#mapmove 3
#hp 9
--hp 12 -- More appropriate if you use adult Tlku sprite
#prot 0
#size 1
--size 2 -- More appropriate if you use adult Tlku sprite
#str 7
--str 10 -- More appropriate if you use adult Tlku sprite
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 14
#gcost 0
#rcost 1
#nametype 161
#itemslots 15494
#weapon 92 -- Fist
#weapon 243 -- Lightning
#armor "Robes"
#magicskill 1 3
#magicskill 3 3
#magicskill 4 4
#magicskill 8 3
#mountainsurvival
#coldres 75
#neednoteat
#stealthy 0
#maxage 200
#startage 8
#holy
#poorleader

#end






-- Ascended One
#newmonster 3733
#name "Ascended One"
#spr1 "./Shangri_La/Ascended_One_1.tga"
#spr2 "./Shangri_La/Ascended_One_2.tga"

#descr "Truly enlightened Hidden Masters do not die, but instead reach a new level of existence and become Ascended Ones. Ascended Ones have completely transcended human needs, and do not eat. They have mastered their own mortality to such an extent that, if killed, they may be reborn by reforming a new body out of their own essence. They can levitate, and recover from injuries that would cripple mere mortals."


#ap 12
#mapmove 3
#hp 16
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 16
#gcost 0
#rcost 1
#nametype 161
#itemslots 13446
#weapon 92 -- Fist
#weapon 243 -- Lightning
#armor "Robes"
#magicskill 1 2
#magicskill 3 2
#magicskill 4 4
#magicskill 8 4
#custommagic 3328 100
#okmagicleader
#mountainsurvival
#coldres 75
#neednoteat
#flying
#stealthy 0
#immortal
#magicbeing
#heal
#maxage 300
#startage 200
#holy
#end



-- Demon Slayer
#newmonster 3734
#name "Demon Slayer"
#spr1 "./Shangri_La/Demon_Slayer_1.tga"
#spr2 "./Shangri_La/Demon_Slayer_2.tga"

#descr "The Demon Slayer is a highly-experienced and skilled Demon Hunter. Well-trained in fire and astral magics, the Demon Slayer also has also learned some of the lore of the Ngagspa sorcerers and heretical mages he hunts down."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 10
#mr 12
#mor 15
#gcost 0
--gcost 170
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#holy
#magicskill 0 2 -- Fire 2
#magicskill 4 2 -- Astral 2
#magicskill 5 1 -- Death 1
#magicskill 7 1 -- Blood 1
#magicskill 8 2 -- Holy 2
#custommagic 20736 30
#custommagic 20736 30
#poorleader
#mountainsurvival
#coldres 50
#end



------------------------------------------------------------------------------
-- TEMPORARY UNITS
------------------------------------------------------------------------------

-- Yak (with rider killed)
#newmonster 3735
#name "Yak"
#spr1 "./Shangri_La/GL_Yak_1.tga"
#spr2 "./Shangri_La/GL_Yak_2.tga"
-- Nounours's original Yak Rider did not have an alternate riderless form.

#descr "Sturdy and strong, yaks are well-suited to the harsh climate of the Hidden Valley, and see use by the Bhdpa use yaks as pack and traction animals. Some Bhdpa tribesmen train these hardy animals for use as mounts, and ride them into battle with lances and shortbows. A yak can kill a lightly-armored man with its gore attack. Bhdpa yak mounts whose riders have been killed during battle may continue fighting, though they are likely to panic, and tend to run off in the aftermath of the battle."

#ap 20
#mapmove 3
#hp 32
#prot 5
#size 3
#str 18
#enc 3
#att 10
#def 8
#prec 5
#mr 5
#mor 7
#gcost 25
#rcost 5
#ressize 2
#nametype 161
#itemslots 13446
#weapon 352
#mountainsurvival
#animal
#coldres 75
#mounted
#startage 8
#maxage 32
#itemslots 12288
#end



------------------------------------------------------------------------------
-- SUMMONS
------------------------------------------------------------------------------

-- Yeti
#newmonster 3736
#name "Yeti"
#spr1 "./Shangri_La/Yeti_1.tga"
#spr2 "./Shangri_La/Yeti_2.tga"

#descr "Yetis are giant, degenerate cousins of the Mi G who live in the mountains of Shangri-La. On occasion, a mage manages to contact a small group of these savage creatures and binds them into service. Strong, tough, fast and fearless, a yeti can dismember a human being with its bare hands and quarter him without effort. Few can withstand the mere sight of an angry yeti without fleeing in terror. Born in the frozen heights of Shangri-La, Yeti have thick hides and fur, and grow stronger and more resilient in the cold. Even where it is warmer, they radiate the cold of their mountains."

#ap 15
#mapmove 2
#hp 36
#prot 7
#size 4
#str 24
#enc 3
#att 13
#def 12
#prec 8
#mr 11
#mor 16
#gcost 0
#rcost 2
#nametype 161
#itemslots 15494
#weapon 29 -- Claw/Claw/Bite
#weapon 29
#weapon 20
#maxage 50
#mountainsurvival
#coldres 100
#coldpower 2
#cold 3
#iceprot 1
#fear 0
#stealthy
#end




-- Btsan
#newmonster 3737
#name "Btsan"
#spr1 "./Shangri_La/Btsan_1.tga"
#spr2 "./Shangri_La/Btsan_2.tga"

#descr "Malevolent spirits from the high mountains of Shangri-La, these black-skinned demons are master archers. Sometimes, a Dmu Bn Ngagspa sorcerer summons Btsan with blood sacrifice and sends them against an enemy. Btsan bring death and spread diseases, and revel in human blood."

#ap 13
#mapmove 2
#hp 25
#prot 8
#size 3
#str 15
#enc 3
#att 13
#def 12
#prec 15
#mr 14
#mor 14
#gcost 0
--gcost 45
#rcost 2
#nametype 161
#itemslots 15494
#weapon 29 -- Claw
#weapon 29 -- Claw
#weapon 438 -- Plague Bow
#armor "Skull Necklace"
--magicskill 5 1
-- Death magic skill removed since it was making them effectively not archers
-- with the Send Btsan spell (under which they cannot be given orders, since
-- it is a farsummon).
#poorundeadleader
#demon
#neednoteat
#poisonres 75
#coldres 50
#end




-- Bdud -- relationship to Lhamayin?

-- Lhamayin lha ma yin (Tibetan) Non-deity, not a deity; equivalent to the Sanskrit asura. A class of elemental beings or nature spirits corresponding to the various elemental sprites of the lower planes, such as the terrestrial. The lhamayins in popular Tibetan folklore are considered demons and devils, but esoterically they are a class of beings one step higher than the terrestrial sphere.

#newmonster 3738
#name "Bdud"
#spr1 "./Shangri_La/Bdud_1.tga"
#spr2 "./Shangri_La/Bdud_2.tga"

#descr "Once benign spirits of the Bhdpa, the Bdud of the lands of Shangri-La are now brutal and ruthless lhamayin, earthly demons of the wooded hills and valleys. These ugly creatures have three eyes, long fangs and thick reddish skin. Though cruel, violent and short-tempered, they are not completely malevolent, and sometimes do not kill or eat humans who cross their path. Bdud use great clubs, hammers or axes in battle, wear ornaments made of human skulls or bones, and some even use crude armor. Fearless in battle, they may become overwhelmed by bloodlust and anger when wounded. Bdud are demons of the land and mountains, and are not summoned by blood sacrifice."

#ap 13
#mapmove 2
#hp 28
#prot 6
#size 3
#str 17
#enc 3
#att 13
#def 9
#prec 9
#mr 13
#mor 16
#gcost 0
--gcost 35
#rcost 2
#nametype 161
#itemslots 15494
#weapon 165 -- Great Club
#demon
#eyes 3
#neednoteat
#mountainsurvival
#coldres 75
#berserk 1
#end


-- Bdud Warrior with battleaxe and armor
#newmonster 3739
#name "Bdud Warrior"
#spr1 "./Shangri_La/Bdud_Warrior_Axe_1.tga"
#spr2 "./Shangri_La/Bdud_Warrior_Axe_2.tga"

--Original broken sprite links
--spr1 "./Shambalha/Bdud_Warrior_Maul_1.tga"
--spr2 "./Shambalha/Bdud_Warrior_Maul_2.tga"

#descr "Once benign spirits of the Bhdpa, the Bdud of the lands of Shangri-La are now brutal and ruthless lhamayin, earthly demons of the wooded hills and valleys. These ugly creatures have three eyes, long fangs and thick reddish skin. Though cruel, violent and short-tempered, they are not completely malevolent, and sometimes do not kill or eat humans who cross their path. Bdud use great clubs, hammers or axes in battle, wear ornaments made of human skulls or bones, and some even use crude armor. Fearless in battle, they may become overwhelmed by bloodlust and anger when wounded. Bdud are demons of the land and mountains, and are not summoned by blood sacrifice."


#ap 13
#mapmove 2
#hp 28
#prot 6
#size 3
#str 17
#enc 3
#att 14
#def 10
#prec 9
#mr 13
#mor 16
#gcost 0
--gcost 40
#rcost 2
#nametype 161
#itemslots 15494
#weapon 18 -- Battleaxe -- Nounours's original description provides for great clubs, hammers and axes. I decided to change this to go with an axe instead of a maul.
--weapon 14 -- Maul
#armor "Skull Necklace"
#armor "Crude Breastplate"
#demon
#eyes 3
#neednoteat
#mountainsurvival
#coldres 75
#berserk 1
#end



-- Srin Po
#newmonster 3740
#name "Srin Po"
#spr1 "./Shangri_La/Srin_Po_1.tga"
#spr2 "./Shangri_La/Srin_Po_2.tga"

#descr "The dreadful Srin Po are cruel and bloodthirsty man-eating demons with three eyes. Ill-tempered and vicious, these demons are among the most cruel of the Dmu. Savage and barbarous, Srin Po have an insatiable lust for human flesh and blood, and sometimes a Ngagspa sorcerer may summon and bind them with blood sacrifice and dark rites. Srin Po often fight with huge, crude bone clubs crudely, and most of them do not wear armor aside from necklaces made of human skulls and bones, often taken from the remains of the poor wretches devoured by the demon. Srin Po are good at destroying things, and have some minor magic power over earth and rocks."

#ap 14
#mapmove 2
#hp 33
#prot 6
#size 3
#str 18
#enc 3
#att 15
#def 11
#prec 9
#mr 14
#mor 15
#gcost 0
--gcost 50
#rcost 3
#nametype 161
#itemslots 15494
#weapon 165 -- Great Club
#weapon 20 -- Bite
#armor "Skull Necklace"
#custommagic 21504 100
#demon
#eyes 3
#neednoteat
#supplybonus -2
#mountainsurvival
#coldres 75
#fear 0
#siegebonus 2
#end




-- Srin Po Swordsman
#newmonster 3741
#name "Srin Po Swordsman"
#spr1 "./Shangri_La/Srin_Po_Swordsman_1.tga"
#spr2 "./Shangri_La/Srin_Po_Swordsman_2.tga"

#descr "The dreadful Srin Po are cruel and bloodthirsty man-eating demons with three eyes. Ill-tempered and vicious, these demons are among the most cruel of the Dmu. Savage and barbarous, Srin Po have an insatiable lust for human flesh and blood, and sometimes a Ngagspa sorcerer may summon and bind them with blood sacrifice and dark rites. Some Srin Po wield large kukri swords instead of bone clubs, and wear chainmail armor forged by human slaves or by Lha craftmen. Srin Po are good at destroying things, and have some minor magic power over earth and rocks."


#ap 14
#mapmove 2
#hp 35
#prot 6
#size 3
#str 18
#enc 3
#att 15
#def 12
#prec 9
#mr 14
#mor 16
#gcost 0
--gcost 60
#rcost 3
#nametype 161
#itemslots 15494
#weapon "great kukri"
#weapon 20 -- Bite
#armor "Skull Necklace"
#armor "Chain Mail Cuirass"
#armor "Shield"
#custommagic 21504 100
#demon
#eyes 3
#neednoteat
#supplybonus -2
#mountainsurvival
#coldres 75
#fear 0
#siegebonus 2
#end



-- Theurang Spirit
#newmonster 3742
#name "Theurang"
#spr1 "./Shangri_La/Theurang_1.tga"
#spr2 "./Shangri_La/Theurang_2.tga"

#descr "Theurang are spirits from the mountains around Shangri-La. Theurang appears as brutish one-footed creatures with webbed fingers and tongues so large they can cover their faces. Being spirits of mountaintops and heights, they have some power over air, but they also are master smiths who, it is said, taught humans to craft metals. Often seen as deities by smiths, they carry huge hammers, and may have some power over fire and earth, as well as knowledge in dark magics. Though Theurang are not generally malevolent, they are mischievous creatures and may attack humans without real reason. Often believed to be demons by superstitious folks, Theurang are actually spirits of the land and belong to the hierarchy of Lha spirits."

#clearmagic
#ap 10 -- changed to 10 to reflect one-leggedness to a degree
#mapmove 2
#hp 22
#prot 8
#size 3
#str 16
#enc 3
#att 12
#def 11
#prec 7
#mr 13
#mor 14
#gcost 0
--gcost 170
#rcost 1
#nametype 161
#weapon 13 -- Hammer
#weapon 29 -- Claw
#magicskill 1 1
#magicskill 3 1
#custommagic 1408 50
#itemslots 13446
#magicbeing
#eyes 1
#maxage 500
#fear 0
#neednoteat
#fireres 25
#coldres 75
#forgebonus 10
#end




-- Lha
#newmonster 3743
#name "Lha"
#spr1 "./Shangri_La/Lha_1.tga"
#spr2 "./Shangri_La/Lha_2.tga"


#descr "Lha are high spirits of the mountains and valleys. Unlike the Dmu demons, Lha tend to consider humans as allies or trusted servants, not slaves or food. Though they are not truly benevolent, they are less ruthless than their Dmu kin, and the people of Shangri-La often ask them protection. Their attitude toward humans has made them sacred to the people of the mountain kingdom. Lha are very skilled smiths, and have sometimes taught humans to work tempered steel. The most powerful Lha are skilled nature mages with some skill in earth magic, and some are skilled in water magic as well."

-- GLOBU CONTENT CHANGE: Nounours's original description referred to "the people of Shambalha" asking for protection. Shambhala is referenced in no other part of this mod, and seems to just bring in an obscure reference with nothing to ground it.  I've changed it to Shangri-La for now, but it would be a good idea to work it in, in general, since it is a proper name that adds both flavor and authenticity.

#ap 12
#mapmove 2
#hp 33
#prot 0
#size 3
#str 15
#enc 3
#att 15
#def 14
#prec 10
#mr 17 -- Improved from 15 in v2.05
#mor 15
#gcost 0
--gcost 150
#rcost 2
#nametype 161
#itemslots 15494
#weapon 202 -- Magic Sword
#armor "Chain Mail Hauberk"
#armor "Half Helmet"
#armor "Enchanted Shield" -- Changed from normal shield as of v2.05
#magicskill 6 2 -- Nature 2
#magicskill 3 1 -- Earth 1
#magicskill 8 1 -- Holy 1
#custommagic 1280 100 -- 100% chance of AE
#custommagic 1792 80 -- 80% chance of AWE
#custommagic 8960 50 -- 50% chance of AWN
-- Magic has been altered as of v2.05 to make Lha more interesting.  As it
-- stands, they now, with the right randoms, can come with up to 3 in N, E
-- and A, and up to 2 in W.
#maxage 500
#magicbeing
#neednoteat
#mountainsurvival
#forestsurvival
#coldres 75
#castledef 2
#holy
#end



-- Lha Dummy Summon (for saving a spell slot using Sombre's firstshape method)
#newmonster 3701
#name "Lha"
#spr1 "./Shangri_La/Lha_1.tga"
#spr2 "./Shangri_La/Lha_2.tga"


#descr "If you see this unit, I have screwed something up.  It should be transparently summoned, produce 6 Dgra Lha as well, and revert to 3743 above."

#ap 12
#mapmove 2
#hp 33
#prot 0
#size 3
#str 15
#enc 3
#att 15
#def 14
#prec 10
#mr 17
#mor 15
#gcost 0
--gcost 150
#rcost 2
#nametype 161
#itemslots 15494
#weapon 202 -- Magic Sword
#armor "Chain Mail Hauberk"
#armor "Half Helmet"
#armor "Enchanted Shield"
#magicskill 6 2 -- Nature 2
#magicskill 3 1 -- Earth 1
#magicskill 8 1 -- Holy 1
#custommagic 1280 100 -- 100% chance of AE
#custommagic 1792 80 -- 80% chance of AWE
#custommagic 8960 50 -- 50% chance of AWN
-- Magic has been altered as of v2.05 to make Lha more interesting.  As it
-- stands, they now, with the right randoms, can come with up to 3 in N, E
-- and A, and up to 2 in W.
#maxage 500
#magicbeing
#neednoteat
#mountainsurvival
#forestsurvival
#coldres 75
#castledef 2
#holy
#summon1 3744 -- Bring 1 Dgra Lha with
#summon5 3744 -- Bring 5 more
#firstshape 3743 -- Revert to normal Lha, never having been seen
#end


-- Dgra Lha (Lha Warrior)
-- The G is silent, sand it's often written as Drala.  "Foe god" or "warrior protective god."  "In many Tibetan houses, a white dgra lha mask is always hung to insure good luck and prosperity for the family. A thangka showing the nine dgra lha is also hung."
#newmonster 3744
#name "Dgra Lha"
#spr1 "./Shangri_La/Dgra_Lha_1.tga"
#spr2 "./Shangri_La/Dgra_Lha_2.tga"

#descr "Lha are spirits of the mountains and valleys. Unlike the Dmu demons, Lha tend to consider humans as allies or trusted servants, not slaves or food. Though they are not truly benevolent, they are less ruthless than their Dmu kin, and the people of the Hidden Valley often ask them for protection. Their attitude toward humans has made them sacred to the people of the mountain kingdom. Dgra Lha (pronounced 'Drala') are Lha warriors, spirits of war and battle who fight with magic swords and armor made of fine crafted steel."

#ap 12
#mapmove 2
#hp 22
#prot 0
#size 3
#str 14
#enc 3
#att 15
#def 13
#prec 10
#mr 15
#mor 14
#gcost 0
--gcost 50
#rcost 2
#itemslots 15494
#weapon 202 -- Magic Sword
#armor "Chain Mail Cuirass"
#armor "Half Helmet"
#armor "Shield"
#maxage 500
#magicbeing
#neednoteat
#mountainsurvival
#forestsurvival
#coldres 75
#castledef 2
#holy
#end




-- Snow Lion
#newmonster 3745
#name "Snow Lion"
#spr1 "./Shangri_La/Snow_Lion_1.tga"
#spr2 "./Shangri_La/Snow_Lion_2.tga"

#descr "Snow Lions, or Gangs Senge, are magnificent and ferocious celestial creatures who look like white lions with turquoise manes. These fearsome beings are symbols of bravery in Shangri-La, and their roar is so powerful that it is said to frighten dragons. The feet of Snow Lions never touch the ground, and they spend their existence leaping from mountain peak to mountain peak."

#ap 20
#mapmove 3
#hp 30
#prot 7
#size 3
#str 18
#enc 1
#att 14
#def 10
#prec 5
#mr 14
#mor 15
#gcost 0
#rcost 1
#nametype 161
#itemslots 12288
#weapon 20 -- Bite
#weapon 29 -- Claw
#magicbeing
#animal
#maxage 300
#flying
#neednoteat
#mountainsurvival
#coldres 100
#fear 2
#holy
#end




-- Klu (Naga/Nagini), serpent shape
#newmonster 3746
#copystats 1322
#name "Klu"
#spr1 "./Shangri_La/Klu_serpent_shape_1.tga"
#spr2 "./Shangri_La/Klu_serpent_shape_2.tga"

-- GLOBU CONTENT CHANGE
-- Nounours's original version used a male naga along the lines of a Patalan
-- Nagaraja with no armor and W3N1 but no Holy magic. However, the
-- stats were pretty generic and incomplete (for example, there was no
-- difference between the stats for human form and naga form).

-- I've taken a slight bit of liberty and changed it to a modified Patalan
-- Nagini (female with seduction ability), with W3N1, a 30% random ESN pick,
-- and a few other minor changes, and used the copystats command instead of
-- building it from scratch.

#descr "Klu are guardian spirits of the waters and rivers who dwell in springs and punish those who pollute the water, and are sometimes summoned into service by Water and Nature mages. Serpent-like in their normal form, they are able to change their shape and wander the lands unnoticed. Klu in their human form are strikingly beautiful, and can often seduce men into abandoning all ties and loyalties. They sometimes travel very far from Shangri-La, and have even had some contacts with the monkeys of Bandar Log, who call them Nagas. Klu are powerful Water mages with some skill in Nature, and occasionally in Earth and Astral magic as well. Their skill in Water magic is stronger when they are in serpent form."

#ap 8
#mapmove 2
#hp 18
#prot 5
#size 3
#str 12
#enc 4
#att 11
#def 13
#prec 12
#mr 17
#mor 15
#gcost 0
#rcost 1
--nametype 161 -- Better perhaps to leave this at the original Indian naming scheme, which occurs by default since we used copystats
#itemslots 13446
--weapon 92 -- Fist (should be applied by default)
--weapon 10 -- Falchion
--weapon 30 -- Venomous Bite (should be applied by default)
#clearmagic
#magicskill 2 2 -- Water 2
#magicskill 6 1 -- Nature 1
#magicboost 2 1 -- Serpent form boosts water by 1, as standard for Nagini
#custommagic 11264 30 -- Earth/Astral/Nature random
--maxage 300
#magicbeing
#coldblood
#shapechange 3747
#pooramphibian
#swampsurvival
#forestsurvival
#darkvision 75
#poisonres 100
#holy
#end




-- Klu, human shape
#newmonster 3747
#copystats 1325
#name "Klu"
#spr1 "./Shangri_La/Klu_human_shape_1.tga"
#spr2 "./Shangri_La/Klu_human_shape_2.tga"
--spr1 "./Shangri_La/Klu_human_shape_Alt2.tga" -- Dark skinned version
--spr2 "./Shangri_La/Klu_human_shape_Alt1.tga"

#descr "Klu are guardian spirits of the waters and rivers who dwell in springs and punish those who pollute the water, and are sometimes summoned into service by Water and Nature mages. Serpent-like in their normal form, they are able to change their shape and wander the lands unnoticed. Klu in their human form are strikingly beautiful, and can often seduce men into abandoning all ties and loyalties. They sometimes travel very far from Shangri-La, and have even had some contacts with the monkeys of Bandar Log, who call them Nagas. Klu are powerful Water mages with some skill in Nature, and occasionally in Earth and Astral magic as well. Their skill in Water magic is stronger when they are in serpent form."


#ap 14
#mapmove 2
#hp 16
#prot 3
#size 3
#str 12
#enc 4
#att 11
#def 12
#prec 12
#mr 17
#mor 15
#gcost 0
#rcost 1
-- nametype 161 -- Default Indian names more thematically appropriate
#itemslots 15494
--weapon 10 -- Falchion
#clearmagic
#magicskill 2 2 -- Water 2
#magicskill 6 1 -- Nature 1
#custommagic 11264 30 -- Earth/Astral/Nature random
--maxage 300
#magicbeing
#shapechange 3746
--firstshape 3746 -- unnecessary?
--watershape 3746 -- removed because of intended consequences with being hidden in underwater provinces
#pooramphibian
#forestsurvival
#swampsurvival
#darkvision 75
#poisonres 100
#stealthy 10
#seduce 12 -- Standard Nagini is 10, but I'm going with CBM style here
#holy
#end




-- Citipati
#newmonster 3748
#name "Citipati"
#spr1 "./Shangri_La/Citipati_1.tga"
#spr2 "./Shangri_La/Citipati_2.tga"

#descr "Citipati, or Lords of the Cemetery, are a peculiar kind of skeletons who dance in graveyards, their mouths parted in a large grin showing all their teeth. According to a Shangrilan legend, in a former existence the Citipatis were ascetics who were murdered, and still wear the tattered robes of a Shangrilan Drapa. They are known to be ferocious enemies of thieves, relentlessly roaming their lands for wrongdoers. Their touch drains the life force of their foes, and they are surrounded by the cold of grave."

#ap 12
#mapmove 2
#hp 18
#prot 0
#size 2
#str 12
#enc 0
#att 12
#def 12
#prec 8
#mr 15
#mor 18
#gcost 0
#rcost 1
#nametype 161
#itemslots 15494
#weapon 63 -- Life Drain
#undead
--demon -- Unprecedented and unnecessary
#inanimate
#neednoteat
#pooramphibian
#cold 3
--darkvision 75 -- Unnecessary and duplicative
#poisonres 100
#coldres 100
#fear 0
#patrolbonus 2
#holy
#end







------------------------------------------------------------------------------
-- NEW PRETENDERS
------------------------------------------------------------------------------




-- Ascended Master
#newmonster 3749
#name "Ascended Master"
#spr1 "./Shangri_La/Ascended_Master_1.tga"
#spr2 "./Shangri_La/Ascended_Master_2.tga"

#descr "After studying for centuries, the Ascended Master has not only mastered his own mortality, but has achieved such an enlightened state that he has almost reached divinity. With the Pantokrator has gone, nothing will stop the Ascended Master on his road to true spiritual ascension. Though he is not as physically powerful as many other pretenders, and is less magically-skilled than archmages and other magicians, he is essentially a spiritual being, near-immortal and difficult to destroy. He has mastered the powers of spirit and mind, and wields the power of the vajra, the force of lightning."

#ap 12
#mapmove 3
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 18
#mor 30
#gcost 60
#rcost 1
#pathcost 30
#startdom 1
#nametype 161
#restrictedgod 79

#itemslots 13446
#weapon 92 -- FIst
#weapon 243 -- Lightning
#magicskill 3 1
#magicskill 4 1
#coldres 75
#neednoteat
#flying
#immortal
#magicbeing
#maxage 500
#startage 300
#end





-- Bodhisattva
#newmonster 3750
#name "Bodhisattva"
#spr1 "./Shangri_La/Bodhisattva_1.tga"
#spr2 "./Shangri_La/Bodhisattva_2.tga"

#descr "The Bodhisattva is a being of semi-divine origin who has achieved such a state of spiritual enlightenment that he has transcended his own mortality and all mortal needs. With the old Pantokrator alive, he could not ascend to true godhood and complete his enlightenment, and had to retire in a secret place to meditate. But now, with the Pantokrator gone, the Bodhisattva is ready to resume his quest for ascension and to bring hope and solace to human kind. Though he is not physically as powerful as other divine beings, the Bodhisattva has a strong dominion and is a powerful Astral mage because of his spiritual perfection. Furthermore, he is so enlightened that few would dare to strike him, and that his mere presence instill serenity in the hearts of mortals."

#ap 12
#mapmove 3
#hp 36
#prot 5
#size 3
#str 14
#enc 1
#att 13
#def 13
#prec 14
#mr 18
#mor 30
#gcost 80
#rcost 1
#pathcost 40
#startdom 3
#nametype 161
#restrictedgod 79

#itemslots 13446
#weapon 92 -- Fist
#magicskill 4 3
#coldres 50
#poisonres 50
#neednoteat
#awe 3
#incunrest 5
#magicbeing
#maxage 500
#end



-- Mother of Mountains
#newmonster 3751
#name "Mother of Mountains"
#copyspr 601

#descr "The Mother of Mountains is a giant of divine heritage who claims dominion over mountains and heights. The powers of earth, air and water are hers to claim, and she is constantly surrounded by the cold of her native mountains. With the Pantokrator gone, the Mother of mountains will soon rule all of creation."



#ap 16
#mapmove 3
#hp 85
#prot 6
#size 6
#str 22
#enc 2
#att 12
#def 12
#prec 12
#mr 18
#mor 30
#gcost 125
#rcost 1
#pathcost 50
#startdom 3
#nametype 161
#restrictedgod 79

#itemslots 15494
#weapon 92
#armor "Crown"
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#expertleader
#coldres 100
#cold 2
#mountainsurvival
#maxage 1000
#end



-- Frozen Lama
#newmonster 3752
#name "Lama of the Frozen Heights"
#spr1 "./Shangri_La/Frozen_Lama_1.tga"
#spr2 "./Shangri_La/Frozen_Lama_2.tga"

#descr "Having attained to spiritual ascension, the Lama of the Frozen Heights has become something of an Ascended Master himself. The Frozen Lama, as he is sometimes reverently called, keeps the former color of his hat a secret, as it is now the ice blue of the element which he has taken into his very nature. With the Pantokrator gone, he now comes to throw that very hat into the ring in his bid for complete divinity. The Lama of the Frozen Heights is a highly-skilled mage, and is nearly immortal. He exudes an aury of icy cold said to aid the spiritual improvement of those around him by sheer ascetic glory."


#ap 12
#mapmove 2
#hp 12
#prot 0
#size 3
#str 11
#enc 3
#att 10
#def 11
#prec 12
#mr 18
#mor 30
#gcost 80
#rcost 1
#pathcost 10
#startdom 1
#nametype 161
#restrictedgod 79

#itemslots 13446
#weapon "phurba"; replace with dagger (9) if you use the pretender without the weapon definition for Phurba
#armor "Robes"
#magicskill 2 2
#magicskill 4 1
#coldres 200
#neednoteat
#mountainsurvival
#flying
#immortal
#magicbeing
#maxage 500
#startage 300
#cold
#end


------------------------------------------------------------------------------
-- EXISTING PRETENDERS
------------------------------------------------------------------------------

#newmonster 3753
#name "Celestial General"
#copystats 1345
#copyspr 1345
#restrictedgod 79

#end


#newmonster 3754
#name "Mother of Rivers"
#copystats 1342
#copyspr 1342
#restrictedgod 79

#end


#newmonster 3755
#name "Lord of Plenty"
#copystats 1339
#copyspr 1339
#restrictedgod 79

#end


#newmonster 3756
#name "Lady of Fortune"
#copystats 1344
#copyspr 1344
#restrictedgod 79

#end


#newmonster 3757
#name "Nataraja"
#copystats 499
#copyspr 499
#restrictedgod 79

#end


#newmonster 3758
#name "Destroyer of Worlds"
#copystats 1096
#copyspr 1096
#restrictedgod 79

#end


#newmonster 3759
#name "Deva"
#copystats 1341
#copyspr 1341
#restrictedgod 79

#end



------------------------------------------------------------------------------
-- SPELLS
------------------------------------------------------------------------------


#newspell
#name "Call Yeti"
#descr "Shangrilan mages have learned to contact the savage yetis from the frozen heights and bind them into service of the ascendant god of Shangri-La. More powerful mages may be able to summon more than one."
#school 0
#researchlevel 4
#path 0 2
#pathlevel 0 2
#path 1 3
#pathlevel 1 1
#effect 10001
#nreff 1001
#fatiguecost 2500
#damage 3736
#restricted 79

#end


#newspell
#name "Contact Klu"
#descr "Klu are serpent-like guardian spirits of springs and water who can be summoned and coaxed into service."
#school 0
#researchlevel 5
#path 0 2
#pathlevel 0 2
#path 1 6
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 2000
#damage 3746
#restricted 79

#end




#newspell
#name "Contact Theurang"
#descr "Theurangs are mischievous spirits of the mountains. By chanting appropriate mantras and making offerings, a mage can attract one and convince it to serve."
#school 0
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 1
#pathlevel 1 1
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 3742
#restricted 79

#end



#newspell
#name "Call Btsan"
#descr "By offering them human blood, a mage can call forth some of the black-skinned demons called Btsan and bind them into service. Btsan are demons of hunting who, it is said, made the first bows. They hunt down humans who venture into the mountains, and spread diseases if angered."
#school 6
#researchlevel 3
#path 0 7
#pathlevel 0 2
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 5
#fatiguecost 3000
#damage 3737
#restricted 79

#end



#newspell
#name "Send Btsan"
#descr "By offering him human blood, a mage can induce a Btsan, a black-skinned demon archer, to hunt down and kill an enemy. Btsan are demons of hunting who, it is said, made the first bows. They hunt down humans who venture into the mountains, and spread diseases if angered."
#school 6
#researchlevel 5
#path 0 7
#pathlevel 0 2
#path 1 5
#pathlevel 1 1
#effect 10050
#nreff 1
#fatiguecost 800
#damage 3737
#restricted 79

#end



#newspell
#name "Summon Bdud"
#descr "Bdud are ruthless and violent demons who haunt the valleys and mountains near Shangri-La. Despite their demonic nature, they are of this world and do not require blood sacrifice to be summoned. Ngagspa sorcerers sometimes summon them to wreak havoc on those who have offended them, or to destroy their enemies."
#school 0
#researchlevel 4
#path 0 3
#pathlevel 0 1
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 4
#fatiguecost 1000
#damage 3738
#restricted 79

#end



#newspell
#name "Summon Bdud Warriors"
#descr "Bdud are ruthless and violent demons who haunt the valleys and mountains near Shangri-La. Despite their demonic nature, they are of this world and do not require blood sacrifice to be summoned. Ngagspa sorcerers sometimes summon them to wreak havoc on those who have offended them, or to destroy their enemies. The better-equipped Bdud warriors are known to use battle axes and crude armor adapted from a foreign style."
#school 0
#researchlevel 6
#path 0 3
#pathlevel 0 1
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 3
#fatiguecost 1200
#damage 3739
#restricted 79

#end



#newspell
#name "Feast of Cannibal Demons"
#descr "By offering them blood and human flesh in a gruesome banquet, a mage can attract the attention of a few Srin Po, or cannibal demons. Then, he can let them satisfy their craving for human flesh in exchange for their service, and convince them to do his bidding. Though Srin Po lack subtlety, they are cruel and fierce warriors."
#school 6
#researchlevel 4
#path 0 7
#pathlevel 0 3
#path 1 5
#pathlevel 1 1
#effect 10001
#nreff 5
#fatiguecost 2800
#damage 3740
#restricted 79

#end


#newspell
#name "Great Banquet of Cannibal Demons"
#descr "By offering them blood and human flesh in a gruesome banquet, a mage can attract the attention of a few Srin Po, or cannibal demons. Then, he can let them satisfy their craving for human flesh in exchange for their service, and convince them to do his bidding and wage war. Though Srin Po lack subtlety, they are cruel and fierce warriors. The better-armed of them will only respond to the most enticing ritual banquets, involving a great many choice human offerings."
#school 6
#researchlevel 6
#path 0 7
#pathlevel 0 4
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 8
#fatiguecost 6600
#damage 3741
#restricted 79

#end



#newspell
#name "Contact the Lords of Cemetery"
#descr "Venturing into a burial ground, the mage chants mantras to call the Citipati, the Lords of the Cemetery, to his aid. Citipati appear as horridly-grinning skeletons who dance upon graves."

#school 0
#researchlevel 3
#path 0 5
#pathlevel 0 2
#path 1 8
#pathlevel 1 1
#effect 10001
#nreff 3
#fatiguecost 600
#damage 3748
#restricted 79

#end


#newspell
#name "Contact Lha"
#descr "Lha are ancient spirits of the land who retired from the Hidden Valley when the new religion spread in the mountain kingdom of Bhd. Once worshipped as gods and protectors, these powerful and sacred beings are skilled warriors and smiths, and are said to be the ones who taught humans to work metal and temper steel. Sometimes, a Shangrilan mage contacts a high Lha spirit and convinces it to return with its retinue of Dgra Lha guardians to serve the masters of Shangri-La."

#school 0
#researchlevel 7
#path 0 6
#pathlevel 0 2
#path 1 3
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 5300
#damage 3701 -- Dummy unit that summons 6 Dgra Lha then reverts to 3743
#restricted 79

#end


--GLOBU CHANGE: Spell merged with Contact Lha as of v2.05.
--newspell
--name "Call Lha Warriors"
--descr "Lha are ancient spirits of the land who retired from the Hidden Valley when the new religion spread in the mountain kingdom of Bhd. Once worshipped as gods and protectors, these powerful beings are skilled warriors and smiths, and are said to be the ones who taught humans to work metal and temper steel. Sometimes, a mage contacts a small group of Lha warriors, or Dgra Lha, and convinces them to return and serve the masters of Shangri-La."

--school 0
--researchlevel 5
--path 0 6
--pathlevel 0 2
--path 1 3
--pathlevel 1 2
--effect 10001
--nreff 5
--fatiguecost 1800
--damage 3744
--restricted 88
--end



#newspell
#name "Call Snow Lions"
#descr "Snow Lions are sacred celestial creatures from the mountains of Shangri-La, resembling white lions with blue manes. These fearsome beings are symbols of bravery in Shangri-La and emit a terrible roar."

#school 0
#researchlevel 6
#path 0 4
#pathlevel 0 4
#path 1 3
#pathlevel 1 2
#effect 10001
#nreff 2
#fatiguecost 1500
#damage 3745
#restricted 79

#end




#newspell
#name "Debt of Karma"
#descr "Normally, in the beliefs of the Shangrilan religion, the suffering and hindrance of spiritual progress brought about by one's bad Karma occurs indirectly. However, a mage-priest of the Shangrilan faith can bring the process around more quickly in battle, making his foes pay the price for their misdeeds in this life or in past lives, hindering them and making them unsure of what to do as a consequence of all their faults."

-- GLOBU CHANGE: Removed explanation of Karma; seemed to be too much.  It is kept here just in case: "According to Shangrilan religion, each person is responsible for his own actions, and for the pain and joy brought to him and others. The Karma is the result of all good and bad deeds that aid or hinder a person's spiritual progression towards enlightenment, forcing people to face the consequences of their actions and thus improve their behavior, or suffer if they do not."

#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 2
#path 1 8
#pathlevel 1 1
#effect 11
#damage 160
#aoe 2
#range 5020
#nreff 1
#precision 0
#fatiguecost 50
#flightspr 149 4
#explspr 10008
#sound 30
#restricted 79

#end




#newspell
#name "Restore the Dharma"
#descr "According to Shangrilan religion, the Dharma is the teachings of the enlightened ones, passed on by spiritual masters. It expresses what must be done to free one's soul from the cycle of reincarnations and attain total spiritual ascension. The Dharma must be experienced directly, not only preached. Through this spell, a Shangrilan priest is able to share his own experience of enlightenment with some persons. Those who do not resist this spiritual experience often leave their former lives to follow the priest and serve in the Shangrilan forces."

#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 3
#path 1 8
#pathlevel 1 2
#effect 29
#aoe 2
#range 25
#nreff 1
#precision 100
#fatiguecost 90
#flightspr 141 8
#explspr 10001
#sound 47
#spec 4096
#restricted 79

#end



------------------------------------------------------------------------------
-- NAMETYPES
------------------------------------------------------------------------------

#selectnametype 161 -- Custom Name List (151-200 open)
#clear
#addname "Lobsang"
#addname "Ngorchen"
#addname "Geshe"
#addname "Khyentse"
#addname "Khandro"
#addname "Pachen"
#addname "Amdo"
#addname "Gendun"
#addname "Nenang"
#addname "Lorsal"
#addname "Dorjepel"
#addname "Thrangu"
#addname "Sangdrol"
#addname "Lhundub"
#addname "Getse"
#addname "Dzongsar"
#addname "Dzogchen"
#addname "Dhardo"
#addname "Dromtn"
#addname "Drodupchen"
#addname "Tsewang"
#addname "Tsugtor"
#addname "Thubten"
#addname "Chetsun"
#addname "Norbu"
#addname "Tsemo"
#addname "Gyantsen"
#addname "Dezhung"
#addname "Dorje"
#addname "Tegchen"
#addname "Choseng"
#addname "Tsering"
#addname "Deden"
#addname "Thutob"
#addname "Kelsang"
#addname "Kwetsang"
#addname "Lhundrup"
#addname "Lotsawa"
#addname "Machig"
#addname "Trinle"
#addname "Dilgo"
#addname "Ponlop"
#addname "Patrul"
#addname "Chatral"
#addname "Chamtrul"
#addname "Gyaltsab"
#addname "Pabongka"
#addname "Gedhun"
#addname "Khugpa"
#addname "Mindrolling"
#addname "Marpa"
#addname "Labdrn"
#addname "Kongtrul"
#addname "Katok"
#addname "Wangchug"
#addname "Tashi"
#addname "Sachen"
#addname "Dudul"
#addname "Dzamling"
#addname "Chegu"
#addname "Dragshul"
#addname "Ngawang"
#addname "Sakyong"
#addname "Mipham "
#addname "Rangdrl"
#addname "Mukpo"
#addname "Sakyong"
#addname "Jamgol"
#addname "sel"
#addname "Jampal"
#addname "Shakabpa"
#addname "Lopon"
#addname "Tsechu"
#addname "Jampa"
#addname "Tempa"
#addname "Samdhong"
#addname "Yatong"
#addname "Takna"
#addname "Jigme"
#addname "Sangpo"
#addname "Tarthang"
#addname "Trijang"
#addname "Khenchen"
#addname "Khensur"
#addname "Khyabje"
#addname "Penor"
#addname "Chagdud"
#addname "Shabdrung"
#addname "Namgyal"
#addname "Shechen"
#addname "Taktser"
#addname "Traleg"
#addname "Trulshik"
#addname "Kyagbon"
#addname "Ngok"
#addname "Loden"
#addname "Namkhai"
#addname "Drenpa"
#addname "Legpa"
#addname "Kushri"
#addname "Palbar"
#addname "Samphel"
#addname "Wanggi"
#addname "Apong"
#addname "Orgyen"
#addname "Thrinley"
#addname "Lingpa"
#addname "Kyabgon"
#addname "Dhagtshul"
#addname "Rinchen"
#addname "Srungwa"
#addname "Yontan"
#addname "Gekyab"
#addname "Getong"
#addname "Balpo"
#addname "Tsultrim"
#addname "Drag"
#addname "Namgyal"
#addname "Chophel"
#addname "Phuntsog"
#addname "Nyidron"
#addname "Rwa-sgreng"
#addname "Rinchen"
#addname "Buton"
#addname "Drub"
#addname "Runggye"
#addname "Sachen"
#addname "Kunga"
#addname "Nyingpo"
#addname "Dakpa"
#addname "Konchog"
#addname "Jekundag"
#addname "Ngaglo"
#addname "Khenpo"
#addname "Dndrup"
#addname "Ensapa"
#addname "Gehlek"
#addname "Kyabje"
#addname "Jamyang"
#addname "Nawang"
#addname "Kechog"
#addname "Dolma Kyab"
#addname "Legqog"
#addname "Lopn"
#addname "Namdak"
#addname "Loten"
#addname "Namling"
#addname "Dakpo"
#addname "Chungdrag"
#addname "Shenphen"
#addname "Trungpa"
#addname "Chogyam"
#addname "Yeshe"
#addname "Nyantsen"
#addname "Tagbu"
#addname "Dgu-gri"
#addname "Nyasig"
#addname "Yumtn"
#addname "'Od-srung"
#addname "Thrikhyiding"
#addname "Kyide Nyign"
#addname "Byang Chub"
#addname "Phagpa"
#addname "Drogn"
#addname "Bzangpo"
#addname "Sherab"
#addname "Jungnay"
#addname "Rigdzing"
#addname "Desi"
#addname "Sangye"
#addname "Choga"
#addname "Drigum"
#addname "Songtsn"
#addname "Gampo"
#addname "Nyatri"
#addname "Drengen"
#addname "Changchop"
#addname "Simpa"
#addname "Khri-lde-srong-brtsan"
#addname "Relpachen"
#addname "Lhasras"
#addname "gTsangma"
#addname "Zhang 'Bro sTag"
#addname "Tride"
#addname "Sadnalegs"
#addname "Trisong Detsen"
#addname "Mune"
#addname "Mutik"
#addname "Namri"
#addname "Songzen"
#addname "Lntsen"
#addname "Thnmi"
#addname "Sambhota"
#addname "Dus-rong"
#addname "Mang-po-rje"
#addname "Tridu"
#addname "Mangsong"
#addname "Mangtsen"
#addname "Trimang"
#addname "Lntsn"
#addname "Myang"
#addname "Gung-srong"
#addname "Gungtsen"
#addname "Mutri"
#addname "Dsum"
#addname "Snam"
#addname "Dudjom"
#addname "Lungshar"
#addname "Lhalu"
#addname "mGar stong-btsan"
#addname "Tsangyang"
#addname "Khedrub Je"
#addname "Deshin Shekpa"
#addname "Gongkar"
#addname "Pelzang"
#addname "Thekchok"
#addname "Chdrag"
#addname "Dnden"
#addname "Goshir Paljor Dndrub"
#addname "Dromtnpa"
#addname "Djang Jup"
#addname "Pema"
#addname "Depa Deyrab"
#addname "Reting"
#addname "Bardor"
#addname "Goshir"
#addname "Ringu"
#addname "Tsem"
#addname "Naro Bonchung"
#end





------------------------------------------------------------------------------
-- MAGIC SITES
------------------------------------------------------------------------------


#newsite 821
#name "Mount Yung-Drung"
#path 1
#level 4
#rarity 5
#gems 1 1
#gems 3 1
#homemon 3717
#homecom 3727
#end


#newsite 822
#name "Hidden City of Shangri-La"
#path 4
#level 4
#rarity 5
#gems 4 2
#gems 3 1
#homemon 3714
#homecom 3722
#homecom 3731
#end




------------------------------------------------------------------------------
-- NATION
------------------------------------------------------------------------------


#selectnation 79

#name "Shangri-La"
#epithet "Hidden City of the Secret Masters"
#era 2
#descr "In a hidden valley in the high mountains of the Bhd kingdom, a secret order of enlightened priest-mages, exiled from their old home, have arrived with their servants, conquering the Bhd tribes and gaining the cooperation of the ape-like Mi G. Having found the ancient records and secret knowledge of a long-dead people, these Hidden Masters rule over the secret city of Shangri-La, where they use manipulation and deceit to control the Bhdpa and to keep outsiders away from their refuge. Meanwhile, they study arcane and mystical secrets to achieve enlightenment and transcend mortality itself. Now, with the rise of the new religion, the Hidden Masters of Shangri-La use their knowledge, power and military might to fight their ascendant god's enemies."

#summary "Race: Humans and ape-like Mi G. Prefers cold 2.


Military: Stealthy Bhdpa light infantry, Shangrilan heavy infantry, heavy horse and light yak cavalry, and Mi G warriors.

Magic: Access to all paths. Very strong in Astral, and strong in Air and Earth as well.  Weakest in Fire, Water, and Nature.  A variety of summonable creatures, demons and spirits of the mountains.

Priests: Very powerful; all priests are also mages."


#brief "Shangri-La is a nation centered around a hidden mountain city ruled by a powerful and secretive order of priest-mages who seek spiritual ascension. The tribesmen of the Bhd mountain kingdom and the Mi G, descendants of a very old race, fight along with the Shangrilans."
#flag "./Shangri_La/Shangri_La_flag.tga"

-- scoregraph color --
#color 1 0.8 0.1

#clearrec
#clearsites


#addrecunit 3702 -- Bhdpa Spearman
#addrecunit 3703 -- Bhdpa Archer
#addrecunit 3704 -- Bhdpa Warrior
#addrecunit 3705 -- Bhdpa Yak Rider
#addrecunit 3706 -- Bhdpa Horseman
#addrecunit 3707 -- Shangrilan Archer
#addrecunit 3708 -- Shangrilan Crossbowmen
#addrecunit 3709 -- Shangrilan Heavy Infantry (Polearm)
#addrecunit 3710 -- Shangrilan Heavy Infantry (Sword/Shield)
#addrecunit 3711 -- Dmag Dar (Shangrilan Banner-Bearer)
#addrecunit 3712 -- Dmag Hrag (Shangrilan Elite Infantry)
#addrecunit 3713 -- Rta Pa (Shangrilan Heavy Cavalry)
#addrecunit 3715 -- Mi G
#addrecunit 3716 -- Mi G Hunter

-- Capital-only
-- 3714 -- Guardian of the Hidden Valley (Shangrilan Sacred)
-- 3717 -- Mi Dred (Mi G Sacred)

#addreccom 3718 -- Bhdpa Scout
#addreccom 3719 -- Bhdpa Sde Pa (Clan Chief)
#addreccom 3720 -- Dmag Dpon (Shangrilan Officer)
#addreccom 3721 -- Rta Dmag Go (Shangrilan Cavalry Commander)
#addreccom 3723 -- Drapa (Shangrilan Monk)
#addreccom 3724 -- Ngagspa (Sorcerer)
#addreccom 3725 -- Ragyapa (Priest)
#addreccom 3728 -- Nyingmapa (Red-Hat Lama)
#addreccom 3729 -- Gelug (Yellow-Hat Lama)
#addreccom 3730 -- Karmapa (Black-Hat Lama)

-- Capital-only
-- 3722 -- Rje (Shangrilan King)
-- 3727 -- Wise One (Mi G Sacred Mage/Healer)
-- 3731 -- Hidden Master (Top-Tier Mage/Priest)


------------------------------------------------------------------------------
TESTING SECTION
------------------------------------------------------------------------------

Heroes

-addreccom 3732 -- Tlku (Boy Mage-Priest Multihero)
-addreccom 3733 -- Ascended One (Multihero)
-addreccom 3734 -- Demon Slayer (Demon Hunter Hero)


Temporary Units

-addrecunit 3735 -- Yak (temporary riderless Yak Rider)


Summons

-addrecunit 3736 -- Yeti

-addreccom 3737 -- Btsan (Demon Archer)

-addrecunit 3738 -- Bdud (Earth Demon Warrior with Great Club)
-addrecunit 3739 -- Bdud Warrior (Earth Demon Warrior with Armor and Battleaxe)

-addreccom 3740 -- Srin Po (Man-Eating Demon Mage)
-addreccom 3741 -- Srin Po Swordsman (Man-Eating Demon Mage with Sword)

-addreccom 3742 -- Theurang (Lesser Lha Spirit Mage -- Sacred)
-addreccom 3743 -- Lha (Lha Spirit Mage -- Sacred)
-addrecunit 3744 -- Dgra Lha (Lha Warrior -- Sacred)

-addrecunit 3745 -- Snow Lion

-addreccom 3746 -- Klu (Naga) in Serpent Form
-addreccom 3747 -- Klu (Naga) in Human Form

-addrecunit 3748 -- Citipati (Undead)


------------------------------------------------------------------------------
END TESTING SECTION
------------------------------------------------------------------------------


#defcom1 3719 -- Bhdpa Sde Pa (Clan Chief)
#defcom2 3723 -- Shangrilan Monk

#defunit1 3702 -- Bhdpa Spearman
#defmult1 20

#defunit1b 3703 -- Bhdpa Archer
#defmult1b 15
-- defmult1b 20 does not work properly (Johan K verified this in the forums)

#defunit2 3705 -- Bhdpa Yak Rider
#defmult2 10

#defunit2b 3715 -- Mi G
#defmult2b 10

#hero1 3732 -- Tlku (Boy Mage-Priest Hero)
#multihero1 3734 -- Demon Slayer (Demon Hunter Multi-Hero)
#multihero2 3733 -- Ascended One Multihero

#idealcold 2

#startcom 3720 -- Shangrilan Dmag Dpon
#startscout 3718 -- Bhdpa Scout

#startsite "Hidden City of Shangri-La"
#startsite "Mount Yung-Drung"

#startunittype1 3707 -- Shangrilan Archer
#startunitnbrs1 12
#startunittype2 3709 -- Shangrilan Heavy Infantry (Polearm)
#startunitnbrs2 12

#templepic 18
#startfort 42 -- Mountain City (1400g, admin 30)
#defaultfort 20 -- River Fortress (800g, admin 20)
#farmfort 3 -- Fortified City (1200g, admin 50)
#mountainfort 9 -- Mountain Citadel (1200g, admin 20)
#forestfort 34 -- Forest Fortress (1000g, admin 15)
#swampfort 11 -- Swamp Fort (800g, admin 0)
-- swampfort 17 -- Wizard's Tower (600g, admin 30)

-- GLOBU'S CHANGE:

-- Wizard's Tower doesn't seem right; these guys have no reason to be better
-- at swamp fortress building than anyone else, and Wizard's Towers are
-- highly advantageous for *any* terrain.

#end


-modname "MC Al-Nadim"
-version 0.9
-description "Adds the arabic-themed nation of Al-Nadim for middle age."
-icon "./al-nadim/banner.tga"

----- Weapons and armor  ------
#newweapon 920
#name "Scimitar"
#dmg 6
#att 1
#def 0
#len 2
#rcost 3
#end

#newweapon 921
#name "Camel Bite"
#dmg 10
#att 1
#def 0
#len 3
#bonus
#nostr
#rcost 0
#end


-------  Troops  ---------
#newmonster 3622
#name "Al-Nadim Light Infantry"
#spr1 "./al-nadim/militia1.tga"
#spr2 "./al-nadim/militia2.tga"
#descr "Light infantry of Al-Nadim is often used as militia, but unlike militia in general, they are trained and disciplined infantry."
#hp 10
#str 10
#att 10
#def 10
#mor 10
#prec 10
#enc 3
#mapmove 2
#gcost 10
#wastesurvival
#weapon "spear"
#armor "shield"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3623
#name "Al-Nadim Archer"
#spr1 "./al-nadim/archer1.tga"
#spr2 "./al-nadim/archer2.tga"
#descr "Archers, Ramat, are the third major part of the emirate's army. Their role is to shower down arrows to the enemies pinned down by infantry."
#hp 10
#str 10
#att 10
#def 10
#mor 10
#prec 10
#enc 3
#mapmove 2
#gcost 10
#wastesurvival
#weapon "short bow"
#weapon "dagger"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3624
#name "Al-Nadim Infantry"
#spr1 "./al-nadim/spearinfantry1.tga"
#spr2 "./al-nadim/spearinfantry2.tga"
#descr "The infantry, Rijal, of Al-Nadim is armored with chain mail and fights with a spear or a scimitar and a shield."
#hp 10
#str 10
#att 10
#def 10
#mor 10
#prec 10
#enc 3
#mapmove 2
#gcost 10
#wastesurvival
#weapon "spear"
#armor "chain mail hauberk"
#armor "iron cap"
#armor "shield"
#end

#newmonster 3625
#name "Al-Nadim Infantry"
#spr1 "./al-nadim/falchioninfantry1.tga"
#spr2 "./al-nadim/falchioninfantry2.tga"
#descr "The infantry, Rijal, of Al-Razid is armored with chain mail and fights with a spear or a scimitar and a shield."
#hp 10
#str 10
#att 10
#def 10
#mor 10
#prec 10
#enc 3
#mapmove 2
#gcost 10
#wastesurvival
#weapon "Scimitar"
#armor "chain mail hauberk"
#armor "iron cap"
#armor "shield"
#end

#newmonster 3626
#name "Mubarizun"
#spr1 "./al-nadim/mubarizun1.tga"
#spr2 "./al-nadim/mubarizun2.tga"
#descr "Mubarizun are the elite infantry of the caliphate. It is considered a great honor to be chosen to the hard training that is required in order to become a Mubarizun, and an even greater honor to survive the training. In battle the Mubarizun are expected to weaken enemy morale by slaying their champions before the final cavalry charge to break the enemy. Mubarizun are very skilled and extremely loyal to their lords."
#hp 11
#str 11
#att 13
#def 13
#mor 14
#prec 11
#enc 3
#mapmove 2
#gcost 18
#wastesurvival
#weapon "Scimitar"
#armor "shield"
#armor "chain mail hauberk"
#armor "iron cap"
#end


#newmonster 3627
#name "Beduin Mounted Archer"
#spr1 "./al-nadim/mountedarcher1.tga"
#spr2 "./al-nadim/mountedarcher2.tga"
#descr "Nomadic beduins are an integral part of the caliphate's cavalry, Farsan. They are skilled in mounted combat, but their discipline is weak. They are generally used as outriders and raiders."
#hp 12
#size 3
#str 11
#att 12
#def 12
#mor 9
#prec 10
#enc 3
#mapmove 3
#mounted
#wastesurvival
#gcost 40
#ap 26
#stealthy 0
#weapon "Scimitar"
#weapon "short bow"
#weapon "hoof"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3628
#name "Beduin Raider"
#spr1 "./al-nadim/raider1.tga"
#spr2 "./al-nadim/raider2.tga"
#descr "Nomadic beduins are an integral part of the caliphate's cavalry, Farsan. They are skilled in mounted combat, but their discipline is weak. They are generally used as outriders and raiders."
#hp 12
#size 3
#str 11
#att 12
#def 12
#mor 9
#prec 10
#enc 3
#mapmove 3
#mounted
#wastesurvival
#gcost 40
#ap 26
#stealthy 0
#weapon "Scimitar"
#weapon "hoof"
#armor "leather hauberk"
#armor "reinforced leather cap"
#armor "shield"
#end


#newmonster 3629
#name "Al-Nadim Lancer"
#spr1 "./al-nadim/lancer1.tga"
#spr2 "./al-nadim/lancer2.tga"
#descr "Cavalry, Farsan, forms the backbone of the caliphate's army. It is usually realtively lightly armored and armed with various weapons."
#hp 10
#size 3
#str 10
#att 11
#def 11
#mor 11
#prec 10
#enc 3
#mapmove 2
#mounted
#wastesurvival
#gcost 40
#ap 24
#weapon "light lance"
#weapon "hoof"
#armor "chain mail hauberk"
#armor "iron cap"
#armor "shield"
#end

#newmonster 3630
#name "Camel Archer"
#spr1 "./al-nadim/camelarcher1.tga"
#spr2 "./al-nadim/camelarcher2.tga"
#descr "Camels are highly respected animals in the Caliphate, partially thanks to the fact that the camel horrifies lesser animals. While camels are slower than horses, they allow their rider a far more stable position, which allows the rider to concentrate on fighting more than with a regular horse. Due to their nearly sacred nature, most of the camel riders are chosen from amongst the best of the best."
#hp 12
#size 3
#str 11
#att 12
#def 12
#mor 11
#prec 11
#enc 3
#mapmove 3
#mounted
#wastesurvival
#gcost 25
#ap 18
#animalawe 1
#weapon "composite bow"
#weapon "camel bite"
#weapon "scimitar"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3631
#name "Camel Cavalry"
#spr1 "./al-nadim/camelcavalry1.tga"
#spr2 "./al-nadim/camelcavalry2.tga"
#descr "Camels are highly respected animals in the Caliphate, partially thanks to the fact that the camel horrifies lesser animals. While camels are slower than horses, they allow their rider a far more stable position, which allows the rider to concentrate on fighting more than with a regular horse. Due to their nearly sacred nature, most of the camel riders are chosen from amongst the best of the best."
#hp 12
#size 3
#str 11
#att 12
#def 12
#mor 11
#prec 11
#enc 3
#mapmove 3
#mounted
#wastesurvival
#gcost 50
#ap 18
#animalawe 1
#weapon "scimitar"
#weapon "camel bite"
#armor "chain mail hauberk"
#armor "iron cap"
#armor "shield"
#end

#newmonster 3632
#name "Dervish"
#spr1 "./al-nadim/dervish1.tga"
#spr2 "./al-nadim/dervish2.tga"
#descr "The coming of the new god awakened a power to enter a sacred state of ecstatic martial trance in some mystics. The trance is achieved by performing a spinning dance. This trance has become a sacred rite of the awakened god, and it's practicioners are sacred to the people of Al-Nadim. Some of these dervishes join Al-Nadim's armies to serve as instruments of god's will. All dervishes train vigorously to be of as much use as possible to their god's plans."
#hp 11
#str 10
#att 12
#def 12
#mor 20
#mr 13
#prec 10
#enc 3
#mapmove 2
#holy
#ambidextrous 2
#berserk 2
#gcost 25
#wastesurvival
#weapon "Scimitar"
#weapon "Scimitar"
#armor "robes"
#end



-- commanders

#newmonster 3633
#name "Al-Nadim Scout"
#spr1 "./al-nadim/scout1.tga"
#spr2 "./al-nadim/scout2.tga"
#descr "Scouts are trained to pass unseen through enemy territory. Their reports on enemy army movements and the resources in enemy lands are invaluable to the prudent warlord."
#hp 10
#str 10
#att 10
#def 10
#mor 10
#prec 10
#enc 3
#mapmove 2
#gcost 20
#stealthy 10
#noleader
#wastesurvival
#weapon "Scimitar"
#weapon "short bow"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3634
#name "Al-Nadim Commander"
#spr1 "./al-nadim/commander1.tga"
#spr2 "./al-nadim/commander2.tga"
#descr "The commanders of Al-Nadim infantry are equipped like their troops."
#hp 12
#str 11
#att 11
#def 11
#mor 12
#prec 10
#enc 3
#mapmove 2
#gcost 30
#wastesurvival
#weapon "Scimitar"
#armor "chain mail hauberk"
#armor "iron cap"
#armor "shield"
#okleader
#end

#newmonster 3635
#name "Mubarizun Commander"
#spr1 "./al-nadim/mubarizuncom1.tga"
#spr2 "./al-nadim/mubarizuncom2.tga"
#descr "Mubarizun are the elite infantry of the caliphate. It is considered a great honor to be chosen to the hard training that is required in order to become a Mubarizun, and an even greater honor to survive the training. In battle the Mubarizun are expected to weaken enemy morale by slaying their champions before the final cavalry charge to break the enemy. Mubarizun are very skilled and extremely loyal to their lords. The best of the best are chosen to the high honour of being a commander of the Mubarizun. Mubarizun Commanders are equipped like their troops."
#hp 13
#str 12
#att 14
#def 14
#mor 14
#prec 12
#enc 3
#mapmove 2
#gcost 45
#wastesurvival
#weapon "Scimitar"
#armor "shield"
#armor "chain mail hauberk"
#armor "iron cap"
#goodleader
#end


#newmonster 3636
#name "Mullah"
#spr1 "./al-nadim/mullah1.tga"
#spr2 "./al-nadim/mullah2.tga"
#descr "Mullahs are the lowliest clerics of Al-Nadim. They have basic knowledge of the divine law that Al-Nadim is governed by and can be found as clerics and attourneys from almost every village."
#hp 9
#str 9
#att 9
#def 9
#mor 11
#mr 12
#prec 10
#enc 3
#mapmove 2
#gcost 40
#wastesurvival
#weapon "dagger"
#okleader
#holy
#magicskill 8 1
#end

#newmonster 3637
#name "Imam"
#spr1 "./al-nadim/imam1.tga"
#spr2 "./al-nadim/imam2.tga"
#descr "Imams are men who have studied in the Great Madrassa of the Bejeweled City, and are a high religious authority. Their knowledge of the divine law is unsurprassed and they often serve as attourneys and judges."
#hp 9
#str 9
#att 9
#def 9
#mor 11
#mr 12
#prec 10
#enc 3
#mapmove 2
#gcost 180
#weapon "dagger"
#okleader
#holy
#magicskill 8 3
#end

#newmonster 3638
#name "Mystic"
#spr1 "./al-nadim/mystic1.tga"
#spr2 "./al-nadim/mystic2.tga"
#descr "Mystics are beduins who have devoted their life to the faith. They have studied astrology instead of the divine law and are rarely seen working as attourneys or judges like mullahs and imams"
#hp 9
#str 9
#att 9
#def 9
#mor 11
#mr 12
#prec 10
#enc 3
#mapmove 2
#gcost 90
#weapon "dagger"
#poorleader
#stealthy 25
#wastesurvival
#spy
#holy
#magicskill 8 1
#magicskill 4 1
#end

#newmonster 3639
#name "Alchemist"
#spr1 "./al-nadim/alchemist1.tga"
#spr2 "./al-nadim/alchemist2.tga"
#descr "Alchemists are wise men who have studied in the Great Madrassa of the Bejeweled City. Their knowledge on elements is unsurprassed in the caliphate, and they're said to be able to transmute cheaper metals to gold. Alchemists are known as great scholars and researchers."
#hp 9
#str 9
#att 9
#def 9
#mor 11
#mr 13
#prec 10
#enc 3
#mapmove 2
#gcost 140
#weapon "dagger"
#poorleader
#magicskill 3 1
#custommagic 1920 100
#custommagic 1920 100
#custommagic 1920 10
#researchbonus 2
#end



#newmonster 3640
#name "Vizier"
#spr1 "./al-nadim/vizier1.tga"
#spr2 "./al-nadim/vizier2.tga"
#descr "Viziers serve as ministers and advisors of the caliphate. Along with their political power they are skilled in a multitude of magic paths, but especially those of fire and water."
#hp 9
#str 9
#att 9
#def 9
#mor 11
#mr 13
#prec 10
#enc 3
#mapmove 2
#gcost 140
#weapon "dagger"
#poorleader
#magicskill 0 2
#magicskill 1 1
#custommagic 2944 100
#custommagic 2944 10
#end


#newmonster 3641
#name "Grand Vizier"
#spr1 "./al-nadim/grandvizier1.tga"
#spr2 "./al-nadim/grandvizier2.tga"
#descr "Viziers serve as ministers and advisors of the caliphate. Along with their political power they are skilled in a multitude of magic paths, but especially those of fire and water. Grand Viziers are the oldest and most skilled of viziers, and usually serve as advisors of the highest ranking politics."
#hp 9
#str 9
#att 9
#def 9
#mor 11
#mr 14
#prec 10
#enc 3
#mapmove 1
#gcost 230
#weapon "dagger"
#magicskill 0 2
#magicskill 1 2
#magicskill 4 1
#custommagic 2944 100
#custommagic 2944 10
#poorleader
#end

#newmonster 3642
#name "Beduin Chieftain"
#spr1 "./al-nadim/beduincom1.tga"
#spr2 "./al-nadim/beduincom2.tga"
#descr "Beduin Chieftains are leaders of their tribes and usually work as military leaders as well as civil leaders."
#hp 13
#size 3
#str 12
#att 13
#def 13
#mor 9
#prec 10
#enc 3
#mapmove 3
#mounted
#wastesurvival
#gcost 60
#ap 26
#stealthy 0
#weapon "Scimitar"
#weapon "hoof"
#armor "leather hauberk"
#armor "reinforced leather cap"
#armor "shield"
#end

#newmonster 3643
#name "Camel Commander"
#spr1 "./al-nadim/camelcavalry1.tga"
#spr2 "./al-nadim/camelcavalry2.tga"
#descr "Camels are highly respected animals in the Caliphate, partially thanks to the fact that the camel horrifies lesser animals. While camels are slower than horses, they allow their rider a far more stable position, which allows the rider to concentrate on fighting more than with a regular horse. Due to their nearly sacred nature, most of the camel riders are chosen from amongst the best of the best. Camel commanders lead camel mounted warriors."
#hp 13
#size 3
#str 12
#att 13
#def 13
#mor 13
#prec 11
#enc 3
#mapmove 3
#mounted
#wastesurvival
#gcost 50
#ap 18
#animalawe 1
#weapon "scimitar"
#weapon "camel bite"
#armor "chain mail hauberk"
#armor "iron cap"
#armor "shield"
#end

#newmonster 3647
#name "Assassin"
#spr1 "./al-nadim/assassin1.tga"
#spr2 "./al-nadim/assassin2.tga"
#descr "Only two kinds of people wear black in the merciless heat of the caliphate: the clerics and the thieves. While any thieves that are caught are punished harshly, assassins are highly respected and considered to work with the mandate of nobility, and usually therefore are safe from the law."
#hp 10
#str 11
#att 13
#def 13
#mor 13
#mr 11
#prec 13
#enc 3
#mapmove 2
#ambidextrous 2
#gcost 60
#wastesurvival
#stealthy 25
#assassin
#weapon "poison dagger"
#weapon "poison dagger"
#armor "leather hauberk"
#noleader
#end


-- Monsters, summons and other stuff

#newmonster 3644
#name "Camel"
#spr1 "./al-nadim/camel1.tga"
#spr2 "./al-nadim/camel2.tga"
#descr "Camels are highly respected animals in the Caliphate, partially thanks to the fact that the camel horrifies lesser animals. While camels are slower than horses, they allow their rider a far more stable position, which allows the rider to concentrate on fighting more than with a regular horse. Due to their nearly sacred nature, most of the camel riders are chosen from amongst the best of the best."
#hp 10
#size 3
#str 12
#att 12
#def 8
#mor 10
#prot 3
#prec 6
#enc 3
#mapmove 3
#animal
#wastesurvival
#ap 18
#animalawe 1
#weapon 20 -- Bite
#end

#newmonster 3645
#name "Ifrit"
#spr1 "./al-nadim/smallifrit1.tga"
#spr2 "./al-nadim/smallifrit2.tga"
#descr "The djinn are elemental beings born of magical, smokeless and heatless fire. Ifrit are beings of elemental fire, and are often noted for their strength and cunning compared to the other djinn. While all djinn possess magical power, the lesser djinn often prefer conventional weapons over magic. The djinn are considered sacred by the people of Al-Nadim."
#hp 18
#size 2
#str 16
#att 14
#def 14
#mor 14
#mr 15
#prot 6
#prec 12
#enc 2
#mapmove 3
#ap 16
#holy
#fireres 75
#flying
#fireshield 3
#magicbeing
#weapon "Scimitar"
#armor "Shield"
#maxage 500
#end

#newmonster 3654
#name "Ifrit Bey"
#spr1 "./al-nadim/ifritbey1.tga"
#spr2 "./al-nadim/ifritbey2.tga"
#descr "The djinn are elemental beings born of magical, smokeless and heatless fire. Ifrit are generally noted for their strength and cunning compared to the other djinn. While all djinn possess magical power, the lesser djinn often prefer conventional weapons over magic. The djinn are considered sacred by the people of Al-Nadim."
#hp 34
#size 3
#str 22
#att 14
#def 14
#mor 14
#mr 14
#prot 6
#prec 12
#enc 2
#mapmove 3
#ap 16
#holy
#fireres 75
#flying
#fireshield 6
#magicbeing
#weapon "Scimitar"
#armor "Shield"
#armor "Half Helmet"
#armor "Chain Mail Hauberk"
#magicskill 0 2
#magicskill 1 1
#magicskill 5 1
#magicskill 3 1
#custommagic 5504 100
#custommagic 5504 10
#maxage 500
#older -150
#end



#newmonster 3646
#name "Djinn"
#spr1 "./al-nadim/smallmarid1.tga"
#spr2 "./al-nadim/smallmarid2.tga"
#descr "The djinn are elemental beings born of magical, smokeless and heatless fire. While all djinn possess magical power, the lesser djinn often prefer conventional weapons over magic. The djinn are considered sacred by the people of Al-Nadim."
#hp 14
#size 2
#str 14
#att 13
#def 13
#mor 14
#mr 15
#prot 4
#prec 12
#enc 2
#mapmove 3
#ap 16
#holy
#fireres 75
#flying
#magicbeing
#weapon "Scimitar"
#armor "Shield"
#maxage 500
#end

#newmonster 3656
#name "Djinn Bey"
#spr1 "./al-nadim/maridbey1.tga"
#spr2 "./al-nadim/maridbey2.tga"
#descr "The djinn are elemental beings born of magical, smokeless and heatless fire. While all djinn possess magical power, the lesser djinn often prefer conventional weapons over magic. The djinn are considered sacred by the people of Al-Nadim."
#hp 28
#size 3
#str 18
#att 13
#def 14
#mor 14
#mr 14
#prot 4
#prec 12
#enc 2
#mapmove 3
#ap 16
#holy
#fireres 75
#flying
#magicbeing
#weapon "Quarterstaff"
#magicskill 0 2
#magicskill 1 2
#magicskill 4 1
#custommagic 3456 100
#custommagic 3456 10
#maxage 500
#older -150
#end


#newmonster 3648
#name "Ghul"
#spr1 "./al-nadim/werehyena1.tga"
#spr2 "./al-nadim/werehyena2.tga"
#descr "The djinn are elemental beings born of magical, smokeless and heatless fire. The ghul is a tainted djinn, living for death. They often take a perverted form of an animal or a beautiful maiden to horrify or seduce unsuspecting travellers. Regardless of their form, the ghul can always be recognized from a pair of dark hooves. Ghul in werehyena form are slightly weaker than werewolves, but has similiar regenerative powers. The djinn are considered sacred by the people of Al-Nadim."
#hp 16
#gcost 80
#size 2
#str 12
#att 13
#def 13
#mor 20
#mr 13
#prot 6
#prec 5
#enc 2
#mapmove 2
#ap 14
#holy
#magicbeing
#wastesurvival
#forestsurvival
#regeneration 10
#magicskill 5 2
#magicskill 0 1
#shapechange 3649
#stealthy 10
#sacred
#weapon 20
#weapon "claw"
#weapon "claw"
#poorleader
#maxage 500
#end

#newmonster 3649
#name "Ghul"
#spr1 "./al-nadim/ghulseduce1.tga"
#spr2 "./al-nadim/ghulseduce2.tga"
#descr "The djinn are elemental beings born of magical, smokeless and heatless fire. The ghul is a tainted djinn, living for death. They often take a perverted form of an animal or a beautiful maiden to horrify or seduce unsuspecting travellers. The djinn are considered sacred by the people of Al-Nadim."
#hp 12
#gcost 80
#size 2
#str 10
#att 12
#def 12
#mor 20
#mr 13
#prec 12
#enc 2
#mapmove 2
#holy
#magicbeing
#magicskill 5 2
#magicskill 0 1
#shapechange 3648
#secondshape 3648
#seduce 10
#stealthy 10
#sacred
#weapon "Fist"
#poorleader
#maxage 500
#end

-- Heroes

#newmonster 3650
#name "Ali Baba"
#spr1 "./al-nadim/alibaba1.tga"
#spr2 "./al-nadim/alibaba2.tga"
#descr "Ali Baba was a son of a merchant, but was outcasted by his elder brother when their father died. One day he stumbled upon a cave with a magic entrance where forty thieves kept their treasure. With wits and cunning, Ali Baba bested the thieves and became their leader."
#hp 16
#str 12
#att 13
#def 13
#mor 16
#prec 11
#enc 3
#mapmove 2
#stealthy 0
#wastesurvival
#armor "leather hauberk"
#armor "reinforced leather cap"
#weapon "scimitar"
#summon1 3651
#makemonster3 3651
#goodleader
#end

#newmonster 3651
#name "Bandit"
#spr1 "./al-nadim/bandit1.tga"
#spr2 "./al-nadim/bandit2.tga"
#descr "Only two kinds of people wear black in the merciless heat of the caliphate: the clerics and the thieves. Any thieves that are caught are usually punished harshly. Due to that most of the alive thieves in caliphate are rather skilled."
#hp 10
#str 11
#att 12
#def 12
#mor 12
#prec 11
#enc 3
#mapmove 2
#stealthy 0
#wastesurvival
#ambidextrous 2
#weapon "Scimitar"
#weapon "Dagger"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3652
#name "Sinbad"
#spr1 "./al-nadim/sinbad1.tga"
#spr2 "./al-nadim/sinbad2.tga"
#descr "Sinbad is a skilled and wealthy sailor. He accumulated his wealth by seven lucky voyages which took him to the edges of the known world. In his voyages Sinbad has learned to control the currents."
#hp 16
#str 12
#att 13
#def 13
#mor 16
#prec 11
#enc 3
#mapmove 2
#wastesurvival
#sailing
#nobadevents 5
#magicskill 2 2
#weapon "Scimitar"
#armor "leather hauberk"
#armor "reinforced leather cap"
#end

#newmonster 3653
#copystats 1570
#name "Abdul Alhazred"
#spr1 "./al-nadim/alhazred1.tga"
#spr2 "./al-nadim/alhazred2.tga"
#descr "Abdul Alhazred was an astrology student at the Great Madrassa. One night he sighted a great star falling from the sky, and became interested about the the fallen star. He travelled to the other side of the world searching the ruins of forgotten civilizations until he reached a cliff that overlooked the sea where the star had fallen. Abdul could not reach the star itself, but he found many fragments of it. The fragments contained the story of an ancient civilization that was not from this world. Alhazred studied the fragments intensively and learned of the starspawns of R'lyeh. Eventually he found a void gate like the one mentioned in the fragments from a strange house in the mist, and began expirementing with it. The fall of the Pantokrator has called Alhazred, who has been driven insane by the void, to aid the pretender god of al-Nadim with his book of ultimate evil, al-Azif."
#hp 10
#str 10
#att 9
#def 9
#mor 16
#prec 10
#mr 15
#enc 3
#mapmove 2
#older -30
#wastesurvival
#magicskill 5 2
#magicskill 4 3
#magicskill 7 2
#noleader
#weapon "Quarterstaff"
#end

-- Spells

#newspell
#name "Summon Lesser Ifrits"
#descr "Summons 3 lesser ifrits. Lesser ifrits are djinns known for their cunning and strength, and fight with scimitars. They are sacred to the people of Al-Nadim."
#school 0
#researchlevel 5
#path 0 0
#path 1 1
#pathlevel 0 2
#pathlevel 1 1
#damage 3645
#nreff 3
#fatiguecost 800
#effect 10001
#restricted 82

#end

#newspell
#name "Summon Ifrit Bey"
#descr "Summons an ifrit bey. Ifrits are djinns known for their cunning and strength. They are powerful fighters and mages with knowledge of fire, astral and death magic."
#school 0
#researchlevel 6
#path 0 0
#path 1 1
#pathlevel 0 4
#pathlevel 1 3
#damage 3654
#nreff 1
#fatiguecost 2800
#effect 10021
#restricted 82

#end


#newspell
#name "Summon Lesser Djinns"
#descr "Summons 3 lesser djinns. Djinns are magical beings of smokeless and heatless fire who fight with scimitar. They are sacred to the people of Al-Nadim."
#school 0
#researchlevel 4
#path 0 0
#path 1 1
#pathlevel 0 1
#pathlevel 1 1
#damage 3646
#nreff 3
#fatiguecost 600
#effect 10001
#restricted 82

#end

#newspell
#name "Summon Djinn Bey"
#descr "Summons a marid bey. Djinn Bey is a powerful mage with experience in paths of fire, air, astral and earth. "
#school 0
#researchlevel 5
#path 0 0
#path 1 1
#pathlevel 0 3
#pathlevel 1 2
#damage 3656
#nreff 1
#fatiguecost 2400
#effect 10021
#restricted 82

#end




#newspell
#name "Call of Camels"
#descr "The caster lures three camels from the vast deserts of the caliphate."
#school 0
#researchlevel 2
#path 0 6
#pathlevel 0 1
#damage 3644
#nreff 3
#fatiguecost 100
#effect 10001
#restricted 82

#end

#newspell
#name "Summon Ghul"
#descr "Summons a ghul. Ghuls are tainted djinn who seduce and kill travelers. They appear in both animal and human shapes and have knowledge of death magic."
#school 0
#researchlevel 5
#path 0 5
#path 1 0
#pathlevel 0 1
#pathlevel 1 2
#damage 3648
#nreff 1
#fatiguecost 1200
#effect 10021
#restricted 82

#end

-- sites
#newsite 787
#name "The Bejeweled City"
#gems 0 2
#path 0
#level 3
#rarity 5
#homemon 3626
#homecom 3635
#end

#newsite 786
#name "The Great Madrassa"
#gems 2 2
#gems 4 1
#path 4
#level 3
#rarity 5
#homecom 3639
#homecom 3637
#homecom 3641
#end

#selectnation 82

#clear
#era 2
#name "Al-Nadim"
#epithet "The Thousand and One Nights"
#descr "Al-Nadim is a nation of desert-dwelling humans. As the djinnis of the earlier ages started leaving the world, humans took more and more control of their empire. Now humans live in the Bejeweled City djinnis once called their home. The Bejewelled City has become a center of art and science. The Great Madrassa teaches humans in many different arts including magic, alchemy and theology. Not all humans have forsaken their nomadic past though. There still are tribes of beduins, which the caliphate uses as outriders and raiders."
#summary "Race: Humans 
Military: Medium infantry, stealthy cavalry, camel cavalry. Prefers Heat scale +1 
Magic: Fire, Air, some Astral, Earth and Water       
Priests: Strong, sacred whirling dervishes, stealthy mystics."
#brief "Al-Nadim is a nation of desert-dwelling humans. Al-Nadim has stealthy beduin cavalry, sacred spinning dervishes, magically skilled viziers and stealthy mystic priests."

#flag "./al-nadim/flag.tga"

#clearrec
#addrecunit 3622 -- Militia
#addrecunit 3623 -- Archer
#addrecunit 3624 -- Spear Infantry
#addrecunit 3625 -- Scimitar Infantry
#addrecunit 3627 -- Mounted archer
#addrecunit 3628 -- Raider
#addrecunit 3630 -- Camel Archer
#addrecunit 3631 -- Camel Cavalry
#addrecunit 3632 -- Dervish

#addreccom 3633  -- Scout
#addreccom 3647  -- Assassin
#addreccom 3634  -- Commander
#addreccom 3642  -- Beduin Chieftain
#addreccom 3643  -- Camel Commander
#addreccom 3636  -- Mullah
#addreccom 3638  -- Mystic
#addreccom 3640  -- Vizier


#defcom1 3636
#defunit1 3622
#defmult1 10
#defunit1b 3623
#defmult1b 10
#defcom2 3640
#defunit2 3624
#defmult2 10
#defunit2b 3625
#defmult2b 10

#hero1 3650
#hero2 3652
#hero3 3653

#idealcold -1
#clearsites
#startsite "The Bejeweled City"
#startsite "The Great Madrassa"
#startcom 3634
#startunittype1 3625
#startunitnbrs1 10
#startunittype2 3624
#startunitnbrs2 10
#startscout 3633
#startfort 31
#defaultfort 3
#farmfort 3
#swampfort 11
#forestfort 34
#mountainfort 37
#end

-- MA Svarogia, The Dark Forests
-- Version 0.92 (Mar. 22, 2011 -- Globu's 2nd markup version, based on llamabeast's MC-compliant version)

-- Author: Executor
-- Special credit to Globu 

------------------------------------------------------------------------------
-- RESOURCES USED
------------------------------------------------------------------------------

-- Nation 72
-- Nametypes 146,147 (Rus)
-- Units 3180-3210
-- Weapons 922-926
-- Armors 380-381
-- Sites 892-894
-- Spell Slots 8


------------------------------------------------------------------------------
-- MOD INFO
------------------------------------------------------------------------------

-modname "MA Nation: Svarogia"
#domversion 3.26
-version 0.90
-description "A new MA nation, Svarogia, based on south Slavic mythology, created by Executor."
-icon "./Svarogia/logo.tga"

Globu
------------------------------------------------------------------------------

------------------------------------------------------------------------------


______________Spells_________________

#newspell
#name "Empower Vampir"
#descr "The caster curses the blood of a suitable human servant, transforming him into a Vampir, an immortal demon with potent skill in the dark arts, able to tranform into a fierce werewolf, and to curse and transform others into ghoulish creatures."
#school 6
#researchlevel 5
#path 0 7
#path 1 5
#pathlevel 0 3
#pathlevel 1 2
#nreff 1
#effect 10021
#fatiguecost 4800
#restricted 83

#damage 3181
#end

#newspell
#name "Bind Drekavacs"
#descr "Trough the use of the dark arts, the caster exhumes the remains of dead children not converted to the new faith and binds their souls to create Drekavac, twisted apparitions capable of terrifying and draining their victims."
#school 0
#researchlevel 2
#path 0 5
#pathlevel 0 1
#effect 10001
#fatiguecost 500
#nreff 1012
#restricted 83

#damage 3180
#end



#newspell
#name "Bind Talason"
#descr "The caster curses the blood of a dozen humans, transforming them into ghoulish creatures enthralled to his will."
#school 6
#researchlevel 2
#path 0 7
#pathlevel 0 2
#damage 3210
#effect 10001
#fatiguecost 1600
#nreff 1010
#restricted 83

#end

#newspell
#name "Bind Todorac"
#descr "The caster summons and binds to his service several Todorac, terrible demonic horse-men capable of trampling lesser beings. While considered sacred in Svarogia, Todorac are grealy feared by the people and will tend to cause panic wherever they go."
#school 0
#researchlevel 4
#path 0 5
#pathlevel 0 3
#damage 3183
#effect 10001
#fatiguecost 700
#nreff 5
#restricted 83

#end

#newspell
#name "Bind Babica"
#descr "The caster sacrifices several blood slaves to contact and bind to service a Babica, a demon of disease and death. Unrest will slowly increase and population slowly die anywhere Babicas appear."
#school 6
#researchlevel 3
#path 0 7
#pathlevel 0 2
#damage 3186
#effect 10021
#fatiguecost 1700
#nreff 1
#restricted 83

#end

#newspell
#name "Summon Karakondzula"
#descr "The mage spills sacrificial blood on the ground to summon a Karakondzula, a terrible demon of the night. Karakondzula are very feared, and unrest will spread in provinces where they are present."
#school 6
#researchlevel 4
#path 0 7
#pathlevel 0 3
#damage 3184
#effect 10021
#fatiguecost 2800
#nreff 1
#restricted 83

#end

#newspell
#name "Summon Moria"
#descr "The caster summons to his service a Moria, a demon of pestilence and disease who walks among the people, spreading her plague in the form of a beautiful woman clad in rags. A province in which a Moria is present will suffer an outbreak of disease and unrest, and military units may likewise become infected."
#school 4
#path 0 6
#pathlevel 0 3
#researchlevel 5
#damage 3185
#effect 10021
#fatiguecost 1600
#nreff 1
#restricted 83

#end

#newspell
#name "Summon Ala"
#descr "The caster calls on the demonic forces of the sky itself and summons an Ala, a dragon-like demon of storms. Ala are skilled in Air magic, and their very presence causes storm clouds to cover the lands over which they travel."
#school 0
#path 0 1
#pathlevel 0 4
#researchlevel 7
#damage 3187
#effect 10021
#fatiguecost 3200
#nreff 1
#restricted 83

#end


#newspell
#name "Bind Navi"
#descr "The caster sacrifices several blood slaves to contact and bind a Navi, a horrific and ravenous bird like-demon that hunts and devours smaller beings."
#school 6
#path 0 7
#pathlevel 0 4
#researchlevel 6
#damage 3188
#effect 10021
#fatiguecost 4500
#nreff 1
#restricted 83

#end

______________Weapons_________________

#newweapon 922
#name "Ancestral Sword"
#dmg 9
#att 1
#def 2
#len 3
#sound 8
#magic
#rcost 3
#end

#newweapon 923
#name "Chains"
#dmg 4
#att 2
#def 1
#len 2
#sound 10
#twohanded
#rcost 3
#end

#newweapon 924
#name "Shield Bash"
#dmg 1
#att 0
#def 0
#len 1
#sound 10
#charge
#ammo 1
#twohanded
#end

#newweapon 925
#name "Axe Charge"
#dmg 7
#att 1
#def 0
#len 1
#sound 10
#ammo 1
#charge
#end

#newweapon 926
#name "Howl"
#ammo 1
#range 10
#armornegating
#mrnegates
#dt_cap
#secondaryeffect 60 -- Fear
#explspr 10060
#sound 22
#end

______________Armor________________

#newarmor 380
#name "Ancestral Chain Mail"
#type 5
#prot 10
#def -1
#enc 1
#rcost 10
#end

#newarmor 381
#name "Golden Cap"
#type 6
#prot 22
#def 0
#enc 0
#rost 3
#end

+++++++++++ Commanders(mages) +++++++++++

#newmonster 3194
#name "Mora"
#spr1 "./Svarogia/Moraa1.tga"
#spr2 "./Svarogia/Moraa2.tga"

#descr "Mora are women who were born tainted by demonic powers. Such women often bear birthmarks, visible upon childbirth, that show their true nature, and a Mora infant will lose her magical powers if her name and the fact that she is a Mora are shouted out immediately after she has been born. However, this rarely happens, as the girls' families choose not to compromise their status in the community. Mora cannot physically kill their victims; they can only torment them and plague them with fear."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 9
#enc 3
#att 9
#demon
#def 9
#prec 10
#maxage 150
#mr 14
#mor 12
#rcost 1
#gcost 80
#demon
#weapon "Fear"
#female
#forestsurvival
#startage 20
#magicskill 5 1
#nametype 147
#custommagic 4096 50
#custommagic 16384 50
#custommagic 2048 25
#poorleader
#okundeadleader
#end

#newmonster 3193
#name "Osenja"
#descr "Osenja are powerful and seductive demons that haunt the wilderness at night. They appear as young and beautiful women, luring men unfortunate enough to be caught outside when the sun sets to their death. When faced with an Osenja, it is enough for the unforunate victim to utter a single word to fall under the will of the Osenja."
#spr1 "./Svarogia/Osenija.tga"
#spr2 "./Svarogia/Osenija2.tga"
#forestsurvival
#ap 12
#female
#mapmove 2
#assassin
#awe 1
#hp 9
#stealthy 10
#prot 0
#size 2
#str 9
#demon
#enc 3
#att 9
#def 9
#prec 10
#mr 14
#mor 12
#gcost 100
#rcost 1
#weapon "Enslave Mind"
#holy
#magicskill 4 1
#poorleader
#nametype 147
#end

#newmonster 3195
#name "Sudjaja"
#female
#descr "Demon-spirits of fate, Sudjaja determine the future of newly born children. Like many Svarogian demons, they either bring good fortune or great strife. The first three nights after the birth of a newborn child, three Sudjajas come to see it. After the third night, they fortell its future. Consequently, the kin of the child often hold feasts and perform strict rituals in order to please the Sudjaja. If satisfied, the Sudjaja will bless a child with good health and a long life. However, if the Sudjaja are displeased and the rituals followed poorly, it is not uncommon that the child dies soon afterward."
#spr1 "./Svarogia/Mora.tga"
#spr2 "./Svarogia/Mora2.tga"
#ap 12
#mapmove 2
#hp 10
#demon
#prot 0
#size 2
#str 9
#enc 3
#att 9
#def 9
#pred 10
#mr 14
#mor 12
#gcost 130
#rcost 1
#holy
#nobadevents 5
#poorleader
#forestsurvival
#magicskill 4 2
#nametype 147
#end

#newmonster 3197
#name "White Vila"
#female
#descr "A Vila is a powerful female spirit of the wild who appears as a young woman of otherworldly beauty, dressed in a thin white dress. She is able to fascinate men, luring them into servitude with her spellsong. She also has the power to heal men as well as harm them. A Vila's magical powers and strength are hidden in her okrilje, the mystical shroud she wears. If a Vila loses her okrilje, she loses her power and is easily slain."
#spr1 "./Svarogia/Vila.tga"
#spr2 "./Svarogia/Vila1.tga"
#ap 12
#mapmove 2
#hp 9
#prot 0
#size 2
#str 9
#demon
#enc 3
#att 9
#def 9
#prec 12
#startage 300
#mr 15
#mor 15
#gcost 280
#rcost 1
#weapon "Vine Bow"
#noleader
#nomagicleader
#demon
#healer 20
#awe 2
#seduce 12
#stealthy 0
#forestsurvival
#mountainsurvival
#magicskill 6 2
#magicskill 4 1
#magicskill 1 2
#custommagic 8448 100
#nametype 147
#end

#newmonster 3196
#name "Vestica"
#spr1 "./Svarogia/Vestica1.tga"
#spr2 "./Svarogia/Vestica2.tga"
#descr "Vesticas are the witches of old, feared by all Svarogians. They live deep inside the dark forest, where they secretly perform dark arts. There are only two ways for a woman to become a Vestica: she must either marry and offer her family for sacrifice, or she must be born a Mora. Vesticas feed on strife and death, using sharp sickles to cut out human hearts and eat them. They sometimes carrying body parts with them. Wherever they go, disease and sadness follows."
#ap 8
#mapmove 2
#hp 9
#prot 0
#size 2
#str 9
#enc 3
#att 9
#def 9
#demon
#prec 10
#mr 16
#mor 15
#gcost 210
#rcost 1
#weapon "Sickle"
#weapon "Fear"
#female
#forestsurvival
#startage 55
#older 5
#maxage 100
#forestsurvival
#poorleader
#expertundeadleader
#magicskill 5 2
#magicskill 7 2
#custommagic 2048 50
#nametype 147
#end

+++++++++++ Commanders(leaders)

#newmonster 3189
#name "Haiduk Commander"
#spr1 "./Svarogia/Runner1.tga"
#spr2 "./Svarogia/Runner2.tga"
#descr "The most prominent Haiduci lead raiding and war parties, and serve equally well as scouts and commanders, able to travel fast and wide. Haiduk Commanders are more disciplined than the raiders and berserkers they often lead."
#ap 16
#mapmove 3
#hp 12
#prot 0
#size 2
#att 14
#def 12
#prec 10
#mor 14
#str 13
#enc 2
#mr 10
#stealthy 5
#gcost 30
#weapon "Dagger"
#weapon "Axe"
#forestsurvival
#nametype 146
#end

#newmonster 3190
#name "Zrek"
#spr1 "./Svarogia/Zrek.tga"
#spr2 "./Svarogia/Zrek2.tga"
#descr "The Zrek are the only priests left of the the old faith of the Svarogian Kingdom. Before the coming of the new god, they tended the forest temples, performing their ancient rituals deep in the forest while their influence among the people diminished. With the coming of the new god, they have found a new cause and have re-emerged from do their work amongst the people again."
#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#att 9
#def 9
#prec 10
#mor 14
#mr 12
#gcost 35
#weapon "Dagger"
#holy
#forestsurvival
#startage 45
#magicskill 8 1
#okleader
#nametype 146
#end

#newmonster 3191
#name "Village Elder"
#spr1 "./Svarogia/Vojvoda1.tga"
#spr2 "./Svarogia/Vojvoda2.tga"
#descr "Village Elders are leaders and guides, wise men who handle all matters concerning their people. In times of war, they often organize and lead man into battle."
#ap 12
#mapmove 2
#hp 11
#startage 55
#prot 0
#size 2
#att 12
#def 12
#prec 10
#mor 14
#mr 10
#str 11
#gcost 25
#enc 3
#weapon "broad Sword"
#armor "Shield"
#armor "full leather armor"
#forestsurvival
#goodleader
#nametype 146
#end

#newmonster 3192
#name "Knez"
#spr1 "./Svarogia/knjaz1.tga"
#spr2 "./Svarogia/knjaz2.tga"
#descr "The Knez is a nobleman. He leads the armies of Svarogia into battle, and his presence insires them to great deeds. Before the coming of the new god, the Knez constantly warred with each other for dominance, but they have now united in common cause under the leadership and advice of the Zrek."
#ap 12
#mapmove 3
#hp 11
#prot 0
#size 3
#att 12
#def 12
#prec 10
#mor 16
#mr 10
#str 11
#gcost 65
#itemslots 13446
#enc 3
#mounted
#weapon "Broad sword"
#armor "Shield"
#armor "scale mail cuirass"
#forestsurvival
#expertleader
#standard 10
#startage 42
#nametype 146
#end


+++++++++++ Units ++++++++++++

#newmonster 3200
#name "Svarogian Spearman"
#spr1 "./Svarogia/Spear1.tga"
#spr2 "./Svarogia/Spear2.tga"
#descr "In Svarogia, armor and weaponry equal to that seen in many other lands is rare, and rank-and-file troops tend to be lightly-armored. Svarogian Spearmen wield spears and javelins, and wear armor of leather and linen."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon "Spear"
#weapon "Javelin"
#armor "Shield"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3201
#name "Svarogian Pikeman"
#spr1 "./Svarogia/Pike1.tga"
#spr2 "./Svarogia/Pike2.tga"
#descr "In Svarogia, armor and weaponry equal to that seen in many other lands is rare, and rank-and-file troops tend to be lightly-armored. Svarogian Pikeman wield long pikes, and are used on occasion to stop cavalry charges. They wear armor of leather and linen."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon "Pike"
#armor "Shield"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3202
#name "Svarogian Axeman"
#spr1 "./Svarogia/Axe1.tga"
#spr2 "./Svarogia/Axe2.tga"
#descr "In Svarogia, armor and weaponry equal to that seen in many other lands is rare, and rank-and-file troops tend to be lightly-armored. Svarogian Axeman fight with axes and javelins, and wear armor of leather and linen."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon "Axe"
#weapon "Javelin"
#armor "Shield"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3204
#name "Svarogian Archer"
#spr1 "./Svarogia/Archer1.tga"
#spr2 "./Svarogia/Archer2.tga"
#descr "In the harsh lands of Svarogia, warfare is familiar to all men. Svarogian archers are known for their skill with the bow, and use higher-quality composite bows. They are trained for close combat as well as ranged, and carry axes for use when their bows are no longer effective."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 11
#mr 10
#mor 11
#gcost 11
#rcost 1
#weapon "Axe"
#weapon "Composite Bow"
#armor "Full Leather Armor"
#forestsurvival
#nametype 146
#end

#newmonster 3203
#name "Svarogian Swordsman"
#spr1 "./Svarogia/Sword1.tga"
#spr2 "./Svarogia/Sword2.tga"
#descr "The swordsmen of Svarogia are the most experienced warriors in the kingdom, and form the heart of the Svarogian army. They are formidable opponents of great strength and skill, and have the privilege of wearing heavier ring mail armor."
#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#startage 36
#str 12
#enc 3
#att 11
#def 11
#prec 10
#mr 10
#mor 12
#gcost 12
#rcost 1
#weapon "Broad Sword"
#armor "Shield"
#armor "Iron Cap"
#armor "Ring Mail Cuirass"
#forestsurvival
#nametype 146
#end

#newmonster 3207
#name "Svarogian Rider"
#descr "Svarogian cavalry is formidable. Armed with bows and lances, they are versatile units, able to rain arrows upon lighter troops and punch through the armor of more heavily-armed opponents with their lances. Svarogian riders, like the swordsmen, receive the privilege of wearing heavier armor than most Svarogian troops."
#spr1 "./Svarogia/Horse1.tga"
#spr2 "./Svarogia/Horse2.tga"
#ap 24
#mapmove 3
#hp 11
#prot 0
#enc 4
#str 11
#att 11
#def 11
#prec 10
#mor 12
#mr 10
#gcost 20
#rcost 1
#ressize 3
#itemslots 13446
#weapon "Composite Bow"
#weapon "light Lance"
#weapon 56
#armor "Ring Mail Cuirass"
#armor "Shield"
#armor "Iron Cap"
#mounted
#forestsurvival
#nametype 146
#end

#newmonster 3208
#name "Ancestral Warrior"
#spr1 "./Svarogia/Sacred1.tga"
#spr2 "./Svarogia/Sacred2.tga"
#descr "Though heavier armor and weaponry is rare in Svarogia, the most elite soldiers, the Ancestral Warriors, bear ancestral weapons and armor, passed down from generation to generation. Coming from a past age, these ancestral arms are imbued with the magical power of the ancestral spirits, constantly strengthening and reinvigorating the wearer. Ancestral Warriors are sacred and revered by all."
#ap 12
#str 13
#mapmove 2
#hp 13
#prot 0
#gcost 25
#rcost 1
#att 12
#def 12
#enc 3
#prec 10
#mr 12
#mor 15
#weapon "Ancestral Sword"
#armor "Ancestral Chain Mail"
#holy
#armor "Iron cap"
#forestsurvival
#reinvigoration 2
#nametype 146
#end

#newmonster 3205
#name "Haiduk Raider"
#spr1 "./Svarogia/Raider1.tga"
#spr2 "./Svarogia/Raider2.tga"
#descr "While the roving groups of Haiduci count among their number both professional guerrilla veterans and mercenaries, on the one hand, as well as common thieves and bandits, on the other, all have one thing in common: they are hardened, skilled soldiers feared and respected in the lands of Svarogia. Often taking part in rebellions or ravaging the countryside, with the coming of the ascendant god, many Haiduci now flock to the banners of the armies of Svarogia, though they still demand to be well-paid. Haiduk Raiders are skilled at moving undetected through enemy lands and evading patrols, raiding enemy supply routes."
#ap 12
#str 11
#mapmove 2
#hp 11
#prot 0
#gcost 14
#rcost 1
#att 11
#def 10
#enc 3
#prec 10
#mr 10
#ambidextrous 2
#mor 12
#weapon "Axe"
#weapon "Shield Bash"
#armor "half helmet"
#armor "scale mail cuirass"
#armor "shield"
#forestsurvival
#ressize 1
#stealthy 0
#nametype 146
#end

#newmonster 3206
#name "Haiduk Berserker"
#spr1 "./Svarogia/PRR1.tga"
#spr2 "./Svarogia/PRR2.tga"
#descr "While the roving groups of Haiduci count among their number both professional guerrilla veterans and mercenaries, on the one hand, as well as common thieves and bandits, on the other, all have one thing in common: they are hardened, skilled soldiers feared and respected in the lands of Svarogia. Often taking part in rebellions or ravaging the countryside, with the coming of the ascendant god, many Haiduci now flock to the banners of the armies of Svarogia, though they still demand to be well-paid. Haiduk Berserkers are skilled forest warriors who rely on their great strength and ferocity. Though they lack proper discipline and are difficult to control in an open battle, they are swift, can run for miles without rest, and can move unseen through enemy lands. When they strike they do it with great speed and precision, and many formations of seasoned professional warriors have fallen before a berserker charge."
#ap 14
#str 12
#mapmove 3
#hp 11
#prot 0
#gcost 14
#rcost 1
#att 12
#def 10
#enc 2
#prec 10
#mr 10
#mor 12
#weapon "Axe"
#weapon "Axe Charge"
#armor "scale mail cuirass"
#ambidextrous 2
#berserk 2
#forestsurvival
#stealthy 0
#nametype 146
#ressize 1
#end


++++++++++++ Commanders +++++++++++++
              (Summons)

#newmonster 3180
#name "Drekavac"
#spr1 "./Svarogia/Drekavac1.tga"
#spr2 "./Svarogia/Drekavac2.tga"
#descr "With the coming of the awakening god, Drekavac have begun emerging from fresh graves throughout the land. Drekavac are twisted apparitions that coalesce from the souls of dead children not converted to the new faith. They haunt the countryside and emit blood-chilling howls that break the will of even the most courageous warriors. Drekavac kill their victims by draining their strength until only a lifeless husk remains."
#ap 8
#mapmove 3
#hp 8
#prot 7
#ethereal
#size 1
#mr 13
#str 8
#enc 0
#att 10
#def 9
#prec 10
#mor 12
#weapon "Steal Strength"
#weapon "Howl"
#demon
#stealthy 0
#startage 5
#nametype 146
#end


#newmonster 3181
#name "Vampir"
#spr1 "./Svarogia/Vampir.tga"
#spr2 "./Svarogia/Vampir2.tga"
#descr "A Vampir is an immortal demon of great power. A powerful sorcerer, he is able to transform himself into a fierce werewolf. He also tends to curse others around him, transforming them into ghoulish creatures called Talason. A Vampir cannot be killed inside the awakening god's dominion, and the stronger that dominion, the more Talason he gathers about himself."
#ap 12
#mapmove 2
#hp 16
#prot 6
#str 12
#enc 2
#att 12
#def 12
#prec 10
#mr 16
#mor 20
#startage 80
#maxage 60
#weapon 63
#armor "Robes"
#demon
#immortal
#stealthy 0
#animalawe 4
#magicskill 5 2
#magicskill 7 2
#shapechange 3182 -- Vukodlak
#domsummon2 3210
#poorundeadleader
#nametype 146
#end

                  #newmonster 3182
                  #name "Vukodlak"
                  #spr1 "./Svarogia/Vukodlak.tga"
                  #spr2 "./Svarogia/Vukodlak2.tga"
                  #descr "The Vukodlak is a large wolf-man of tremendous strength and regenerative powers. The origins of these beasts is unknown, but an Svarogian Vampir can change shape into a Vukodlak through his use of the dark arts. In this form, he remains a powerful blood mage, but his greater sense of smell and attunement to blood allows him to more-easily find appropriate victims for his dark rituals."
                  #ap 18
                  #mapmove 3
				  #douse 1
                  #prot 9
                  #size 2
                  #hp 33
                  #str 18
                  #enc 2
                  #att 12
                  #def 12
                  #prec 10
                  #shapechange 3181 -- Vampir
                  #mr 16
                  #immortal
                  #mor 18
                  #weapon 33
                  #weapon 20
                  #demon
                  #forstsurvival
                  #stealthy 10
                  #regeneration 10
                  #magicskill 5 2
                  #magicskill 7 2
				  #magicboost 7 1
				  #magicboost 5 -1
                  #nametype 146
                  #end

#newmonster 3210
#name "Talason"
#spr1 "./Svarogia/Talason.tga"
#spr2 "./Svarogia/Talason2.tga"
#descr "The Talason are common villagers turned into flesh eating ghouls, usually by Vampir, to whom they become thralls. They tend to appear and gather around Vampir wherever the awakening god has strong dominion, though it is not unheard of for other Svarogian sorcerers to use the dark arts to create them for their own purposes. The curse changes the hands of Talason into claws that stiffen the muscles of those wounded by them. Talason feed on the dead and the weak."
#ap 12
#mapmove 3
#hp 12
#prot 3
#size 2
#str 13
#att 11
#def 11
#enc 0
#undead
#prec 10
#mr 12
#mor 15
#weapon "poisoned claw"
#coldres 100
#poisonres 100
#nametype 146
#end

#newmonster 3183
#name "Todorac"
#spr1 "./Svarogia/Todorac.tga"
#spr2 "./Svarogia/todorac2.tga"
#descr "The Todorac is a demon that appears as a man growing out of a horse's back. Todoracs are strong, fast and deadly, able to trample anyone who gets in their way. They are most powerful and dangerous during the spring, and it is then that they often appear in villages to punish sinners. Todoracs are considered holy by the people of Svarogia, but they are also feared, and panic will slowly spread in their presence."
#ap 28
#mapmove 3
#hp 18
#prot 8
#size 3
#str 15
#enc 2
#att 13
#def 13
#prec 10
#mr 15
#mor 30
#prec 10
#fear 0
#weapon 56
#weapon 923
#demon
#forestsurvival
#trample
#incunrest 1
#pillagebonus 2
#itemslots 13446
#holy
#springpower 50
#nametype 146
#end

#newmonster 3184
#name "Karakondzula"
#spr1 "./Svarogia/Karakondzula.tga"
#spr2 "./Svarogia/Karakondzula2.tga"
#descr "The Karakondzula is a night demon. She appears as a very old, ugly hag with long claws, sharp iron teeth, horns, and the legs of a horse. Karakondzula terrorize the people of Svarogia. The women they sometimes merely harass, but more often maim or kill them, scratching and mutilating their faces, drowning them or throwing them from the tops of hills. Karakodzulas attack men differently; they ride them, stealing their strength and exhausting them to death. Karakondzula are greatly feared, and unrest will spread in provinces where they are present."
#ap 18
#mapmove 2
#hp 15
#prot 0
#size 3
#str 13
#enc 3
#demon
#female
#fear 0
#att 13
#def 13
#stealthy 25
#prec 9
#incunrest 4
#assassin
#mr 16
#itemslots 13446
#weapon 33
#weapon 306
#armor "Robes"
#noleader
#maxage 500
#startage 550
#nametype 146
#end

#newmonster 3185
#name "Moria"
#spr1 "./Svarogia/M.tga"
#spr2 "./Svarogia/M2.tga"
#descr "The Moria is a demon of pestilence and plague who appears as an attractive young woman dressed in tattered white clothes. A Moria can spread disease, and is so virulent that the slightest touch of a Moria can infect her victim. Disease and despair will spread in any province where Moria are present."
#ap 12
#mapmove 2
#hp 9
#female
#stealthy 0
#prot 0
#size 2
#str 9
#enc 2
#att 9
#def 9
#mr 12
#leper 14
#mor 14
#weapon 143
#demon
#awe 0
#diseasecloud 6
#noleader
#nametype 147
#end

#newmonster 3186
#name "Babica"
#spr1 "./Svarogia/Babica.tga"
#spr2 "./Svarogia/Babica2.tga"
#descr "The Babica is a demon of disease and death who appears as an old woman dressed in black robes and wielding a sharp sickle. Babica attack and inflict diseases on infants during the night, and cause death and sorrow where ever they go. Unrest will slowly increase and infants will die anywhere a Babica is present."
#ap 10
#mapmove 2
#hp 8
#prot 0
#enc 3
#female
#att 9
#def 9
#str 9
#prec 10
#mor 14
#demon
#mr 16
#weapon "Sickle"
#armor "Robes"
#stealthy 25
#fear 0
#incunrest 7
#maxage 250
#startage 300
#popkill 2
#noleader
#nametype 147
#end

#newmonster 3187
#name "Ala"
#spr1 "./Svarogia/Ala2.tga"
#spr2 "./Svarogia/Ala1.tga"
#descr "The Ala are female, dragon-like demons of storm and hail, immensely strong and powerful. Ala live in the clouds, where they can hide and are very difficult to spot. Their presence causes devastating storms and hails wherever they go. Ala have insatiable appetites which can never be satisfied, feasting upon man and livestock alike."
#ap 12
#mapmove 3
#hp 75
#prot 16
#att 14
#def 12
#mr 17
#prec 14
#female
#mor 30
#enc 1
#str 24
#weapon 20
#weapon 33
#illusion
#flying
#demon
#magicskill 1 3
#noleader
#itemslots 28800
#size 5
#shockres 100
#stormpower 2
#stormimmune
#onebattlespell "storm"
#supplybonus -20
#nametype 147
#end

#newmonster 3188
#name "Navi"
#spr1 "./Svarogia/Tica1.tga"
#spr2 "./Svarogia/'Tica2.tga"
#descr "The Navi is an embodiment of death and the Underworld, a horrifying demon brought to life with the souls of stillborn children and those who died in great suffering. Navi appear as large, monstrous birds that fly over villages during dark nights, emitting blood chilling howls. They attack livestock and eat women and children."
#ap 12
#mapmove 3
#hp 95
#prot 14
#size 6
#str 20
#enc 2
#att 14
#def 12
#prec 10
#mor 18
#mr 16
#weapon 505
#weapon 29
#fear 5
#weapon 29
#demon
#flying
#magicskill 7 2
#itemslots 12416
#noleader
#nametype 146
#end

_________________ Heros ____________________


#newmonster 3198
#name "Vila Ravijojla"
#spr1 "./Svarogia/HeroVila1.tga"
#spr2 "./Svarogia/HeroVila2.tga"
#descr "The Ravijojla is the most powerful and beautiful, and the most dangerous, of the White Vila. As treacherous as she is beautiful, she loves to rule over the hearts of men. On occasion she will help a questing hero, but she is unpredictable, and many have met their end seeking the Ravijojla. Human sacrifices, in the form of young virgins buried alive in the walls of bridges or towers, are made to keep the Ravijojla pleased. With the coming of the awakening god, she has found a greater cause."
#ap 8
#mapmove 3
#hp 14
#prot 0
#size 2
#enc 3
#healer 30
#flying
#magicskill 1 3
#magicskill 2 3
#magicskill 6 3
#str 10
#awe 5
#att 10
#seduce 16
#def 10
#prec 14
#mr 16
#mor 18
#female
#weapon "fist"
#startage 500
#mountainsurvival
#forestsurvival
#demon
#stealthy 0
#nametype 147
#end

#newmonster 3199
#name "Balacko"
#spr1 "./Svarogia/Div.tga"
#spr2 "./Svarogia/Div2.tga"
#descr "Balacko is a two-headed giant who breathes fire and cold from his heads. He normally lives in solitude, occasionally pillaging the countryside and taking women to keep him company, and taking livestock and children, for which he has a taste. With promises of treasure and female companions, Balacko has taken up service to the awakening god."
#ap 8
#mapmove 2
#hp 35
#prot 5
#fireres 50
#coldres 50
#size 4
#str 20
#enc 3
#forestsurvival
#att 11
#rcost 1
#coldres 50
#fireres 50
#gcost 1
#def 11
#prec 8
#mor 14
#mr 12
#weapon 93
#weapon 61
#weapon 7
#startage 113
#maxage 200
#armor "leather armor"
#itemslots 15750
#nametype 146
#end

#newmonster 3209
#name "Kingly Knight"
#spr1 "./Svarogia/Knight1.tga"
#spr2 "./Svarogia/Knight2.tga"
#descr "The Kingly Knight is the messenger of gods, traveling between the world of the living and the Underworld. He is a protector of all people, the patron of springs and bringer of fertility. He rides a beaufiful white steed and travels with unsurpassed speed. With the coming of the Awakening, he has offered his services to the new god."
#ap 36
#mapmove 4
#hp 14
#prot 0
#size 3
#str 12
#enc 3
#att 13
#def 13
#prec 12
#mr 14
#mor 18
#weapon "Golden Lance"
#weapon "Javelin"
#weapon "Hoof"
#armor  "scale mail cuirass"
#armor "Shield"
#armor "Golden Cap"
#holy
#mounted
#forestsurvival
#itemslots 13446
#supplybonus 30
#magicskill 2 2
#magicskill 5 2
#magicskill 6 2
#nametype 146
#end

--------------------------------------------

#newsite 893
#name "The Dark Forest"
#path 5
#rarity 5
#level 0
#gems 5 2
#gems 6 1
#homecom 3196 -- Vestica
#end

#newsite 894
#name "The Ancient Grove"
#path 6
#rarity 5
#level 0
#gems 1 1
#gems 6 1
#homecom 3197 -- White Vila
#end

#newsite 892
#name "Svarogia"
#path 6
#rarity 5
#level 0
#homemon 3208 -- Ancestral Warrior
#end

_________________ Nation ___________________

#selectnation 83

#clearnation
#clearsites
#name "Svarogia"
#epithet "Dark Forests"
#era 2
#descr "Svarogia is a shadowed forest realm in which treacherous demonic spirits roam the wild freely, sometimes helping and guiding the people of Svarogia, and sometimes punishing and killing them, according to their whim. In this cold and unforgiving land, the weak and incautious are preyed upon or succumb to the dangers of the wild, leaving only the strongest and most resilient. Armor of quality comparable to that of most other nations is rare. Consequently, the Svarogians are a hardened people, tougher and stronger than most. In the countryside, soldiers skilled in stealth warfare band together as Haiduk mercenaries, rebels or bandits. With the coming of the ascendant god, the people of Svarogia have banded together under the guidance of the demonic spirits to conquer the world."
#summary "Race: Strong humans and demonic spirits.

Military: Light and medium infantry. Archers and light cavalry with composite bows. Stealthy Haiduk raiders and berserkers. Sacred medium infantry with magic greatswords.

Magic: Air, Nature, Death, Blood, and some Astral.

Priests: Weak. Can blood-sacrifice.

Prefer Cold Scale 1."
#brief "A cold, shadowed forest realm of hardened humans and demonic spirits. Its military uses light armor, but features unique troops and summons."
#color 0.9 0.7
#idealcold 1
#flag "./Svarogia/flag.tga"
#labcost 500
#templecost 400

#startsite "The Dark Forest"
#startsite "The Ancient Grove"
#startsite "Svarogia"

#bloodnation
#templepic 10

#hero1 3198 -- Vila Ravijojla
#hero2 3199 -- Balacko
#hero3 3209 -- Kingly Knight

#addreccom 3189 -- Haiduk Commander
#addreccom 3190 -- Zrek
#addreccom 3191 -- Village Elder
#addreccom 3192 -- Knez
#addreccom 3193 -- Osenja
#addreccom 3194 -- Mora
#addreccom 3195 -- Sudjaja

#addrecunit 3200 -- Svarogian Spearman
#addrecunit 3201 -- Svarogian Pikeman
#addrecunit 3202 -- Svarogian Axeman
#addrecunit 3203 -- Svarogian Swordsman
#addrecunit 3204 -- Svarogian Archer
#addrecunit 3205 -- Haiduk Raider
#addrecunit 3206 -- Haiduk Berserker
#addrecunit 3207 -- Svarogian Rider

------------------
--TESTING SECTION-
------------------
-addrecunit 3208 -- Ancestral Warrior (capital-only)
-addreccom 3196 -- Vestica (capital-only)
-addreccom 3197 -- White Vila (capital-only)
-addrecunit 3180 --Drekavac

-addreccom 3181 -- Vampir
-addrecunit 3210 -- Talason
-addrecunit 3183 -- Todorac
-addreccom 3184 -- Karakondzula
-addreccom 3185 -- Moria
-addreccom 3186 -- Babica
-addreccom 3187 -- Ala
-addreccom 3188 -- Navi
-----------------------
-- END TESTING SECTION-
-----------------------

#startcom 3191 -- Village Elder
#startscout 3189 -- Haiduk Commander

#startunittype1 3200 -- Svarogian Spearman
#startunittype2 3201 -- Svarogian Pikeman

#startunitnbrs1 15
#startunitnbrs2 15

#defcom1 3191 -- Village Elder
#defcom2 3192 -- Knez

#defunit1 3201 -- Svarogian Pikeman
#defunit1b 2 3204 -- Svarogian Archer

#defunit2 3201 -- Svarogian Pikeman
#defunit2b 3203 --  -- Svarogian Swordsman

#startfort 3 -- Fortified city (1200g, admin 50)
#defaultfort 36 -- Hillfort (800g, admin 5)
#farmfort 41 -- Castle (1000g, admin 30) -- or River Fortress 20 (800g, admin 20)
#mountainfort 38 -- Hill Castle (1200g, admin 10)
#forestfort 35 -- Forest Castle (1000g, admin 20)
#swampfort 11 -- Swamp Fort (800g, admin 0)


#end


-modname "MA Nation: Arga Dis"
-description "Adds the MA nation Arga Dis, Blood and Bronze to the game."
-icon "./Arga Dis/logo.tga"
-version 1.5


--nationslot 79
--unitslots 2357-2391
--weaponslots 647-649
--armourslots 316-317
--siteslots 790-792


-- version 1.5

-- FIX - Made sure the mod is MC compatible, changed the logo a bit too


-- version 1.4

-- FIX - Moved various IDs around to prevent conflicts with warhammer ma mods, cbm, endgame summons


-- version 1.35

-- FIX - Fixed bug with urtyr shaman summon


-- version 1.3

-- CONTENT - Added "Bray of the Urtyr" spell

-- CONTENT - Added Urtyr shaman and troops as blood summons

-- TWEAK - Slightly upped companion protection - leather cuirass to hauberk

-- TWEAK - Recosted some commanders and troops slightly

-- TWEAK - Tweaked Myrmidon description.

-- TWEAK - Helgrot scout brought to stealth 10 in line with other scouts

-- TWEAK - Gilgan fear, berserk and cost reduced slightly.

-- TWEAK - Blackwing riders got scale mail hauberks to make them more useful and accentuate the foreign influence on them

-- TWEAK - Blood Wind pretender removed. I never liked it.


-- Version 1.2

-- FIX - Argan myrmidon captain's move to be the same as his troops

-- FIX - Apparently weapon 57 was sickle, not hoof. Hoof is 56. Fixed.

-- FIX - Hoof attacks on sworn companion and blackwing changed to non str based horse hoof attack id 56

-- TWEAK - No more misborn starting scout. Now they get a nice helgrot scout instead.

-- TWEAK - Misborn are now younger, with lower maxage.


-- Version 1.1 - Sorted out mr problems.


-------- WEAPONS --------


-- Bronze Sickle

#newweapon 648
#name "Bronze Sickle"
#rcost 1
#att -1
#len 4
#def 0
#dmg 9
#twohanded
#sound 8
#secondaryeffect 335 --armloss
#end


-- Shield Bash

#newweapon 649
#name "Shield Bash"
#rcost 0
#bonus
#att -2
#len 0
#dmg -2
#end


-- Slashing Wing

#newweapon 647
#name "Slashing Wing"
#rcost 0
#att -1
#def -1
#len 0
#dmg -2
#secondaryeffect 118 -- curse (nores)
#end


-------- ARMOUR ---------


-- Hoplite Shield

#newarmor 316
#name "Hoplite Shield"
#type 4
#prot 17
#enc 2
#def 4
#rcost 3
#end


-- Fleshcloak

#newarmor 317
#name "Fleshcloak"
#type 5
#prot 9
#enc 0
#rcost 1
#def 0
#end


-------- UNITS ----------


-- Helgrot chaff

#newmonster 2381
#copyspr 201
#copystats 201
#name "Helgrot"
#descr "The Helgrot are a slave caste who take care of the day to day running of Arga. Any Helgrot with a spark of strength or rebellion in his eyes is given a choice; go into battle and die to facilitate the glory of true Argan warriors, or be fed to the Mares, or worse, the Gilgans."
#mor 8
#str 9
#att 9
#prec 9
#hp 8
#gcost 8
#nametype 107
#end


-- ARGANS

-- Argan Hoplite - Template unit

#newmonster 2382
#spr1 "./Arga Dis/Argan Hoplite.tga"
#spr2 "./Arga Dis/Argan Hoplite2.tga"
#name "Argan Hoplite"
#descr "Raised from birth to fight with shield and spear, to know glory, to taste the blood and hear the clamour of battle; the hoplites of Arga are virtually without equal in combat. All Argan warriors are extremely well trained, disciplined and brave. Furthermore, their unique style of fighting makes them almost as dangerous with their shields as with their spears."
#hp 11
#size 2
#prot 0
#mor 14
#mr 10
#enc 3
#str 12
#att 12
#def 12
#prec 10
#mapmove 2
#ap 10
#gcost 15
#rcost 1
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Spear"
#weapon "Shield Bash"
#nametype 107
#end

-- Argan Myrmidon

#newmonster 2383
#name "Argan Myrmidon"
#spr1 "./Arga Dis/Argan Myrmidon.tga"
#spr2 "./Arga Dis/Argan Myrmidon2.tga"
#descr "The Myrmidons of Arga, nicknamed the Blackshields, are a band of fighters who live largely separate lives from the hoplites and Sworn, favouring the upper reaches of mountains. They are not so heavily armoured as the myrmidons that once protected Arcoscephale, but are still regarded with distrust by other Argans who view armour as a form of cowardice or weakness. Nonetheless the Blackshields have decided many battles where their protection was decisive and their training at high altitude certainly lends them impressive endurance. They will never have the gloryof the hoplites, but none can deny they have proven themselves true Argan warriors."
#hp 11
#size 2
#prot 0
#mor 14
#mr 10
#enc 2
#str 12
#att 12
#def 12
#prec 10
#mapmove 2
#ap 12
#gcost 14
#rcost 1
#armor "Bronze Cuirass"
#armor "Hoplite Helmet"
#armor "Shield"
#weapon "Short sword"
#mountainsurvival
#nametype 107
#end

-- Sworn Brother

#newmonster 2384
#spr1 "./Arga Dis/Sworn Brother.tga"
#spr2 "./Arga Dis/Sworn Brother2.tga"
#name "Sworn Brother"
#descr "The Sworn epitomise Argan principles; they are tireless, ruthless, disciplined and possessing of almost inhuman strength. On initiation into this elite band they each swore a battle-oath to the Gilgans and to Arga and saw clearly for the first time the brutal truth of the afterlife, the chaos of Dis. Knowing the endless violent struggle that awaits them beyond the grave the Sworn are driven to prove themselves in life and, when they inevitably fulfill their destiny and die a glorious death, to take as many enemies to Dis with them as possible. This dedication to slaughter makes them extremely hard to stop completely on the battlefield; it is common for Sworn Brothers to fight on after receiving mortal wounds, only to drop dead once the enemy is put to the spear."
#hp 13
#size 2
#prot 0
#mor 16
#mr 11
#enc 3
#str 13
#att 14
#def 13
#prec 11
#mapmove 2
#ap 10
#gcost 26
#rcost 2
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Spear"
#weapon "Shield Bash"
#secondtmpshape 2385
#nametype 107
#end

-- Sworn Brother Slain

#newmonster 2385
#name "Sworn Brother Slain"
#spr1 "./Arga Dis/Sworn Brother Slain.tga"
#spr2 "./Arga Dis/Sworn Brother Slain2.tga"
#descr "It takes a lot to kill an Argan who has seen what awaits him in the afterlife. A sworn brother who has been mortally wounded will fight on until he is well and truly dead, seeking any glory he can before facing the violent turmoil of Dis."
#hp 11
#size 2
#prot 3
#mor 50
#mr 11
#enc 3
#str 16
#att 17
#def 10
#prec 11
#mapmove 2
#ap 10
#gcost 1
#rcost 1
#armor "leather cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#armor "Hoplite Shield"
#weapon "Spear"
#weapon "Shield Bash"
#nametype 107
#end

-- Sworn Companion

#newmonster 2386
#name "Sworn Companion"
#spr1 "./Arga Dis/Sworn Companion.tga"
#spr2 "./Arga Dis/Sworn Companion2.tga"
#descr "The Sworn Companions are not decided by their relation to nobility, but by their ability to control the volatile maneating mares of Dis; semi-wild horses tainted over the centuries by proximity to the imprisoned Gilgans. Having survived Argan childhood and reached age enough to become Sworn, the glory found in conquering a mare of Dis is tempting indeed. Thousands of promising Argans die attempting such a task, torn to pieces by their savage mounts, but those that survive are a devastating and terrifying force on the battlefield. Like the Sworn brothers they are known to fight on with wounds that would drop a normal human."
#secondtmpshape 2387
#hp 13
#size 3
#ressize 2
#prot 0
#mor 16
#mr 11
#enc 5
#str 13
#att 14
#def 13
#prec 11
#mapmove 3
#ap 24
#mounted
#gcost 110
#rcost 13
#weapon "light lance"
#weapon "bite"
#weapon 56
#armor "shield"
#armor "hoplite helmet"
#armor "leather hauberk"
#nametype 107
#fear 0
#end


-- Sworn Companion Slain

#newmonster 2387
#name "Sworn Companion Slain"
#spr1 "./Arga Dis/Sworn Companion Slain.tga"
#spr2 "./Arga Dis/Sworn Companion Slain2.tga"
#descr "Much like the Sworn Brothers, the Sworn Companions are famed for fighting on despite fatal wounds, seeking to earn as much glory as possible before departing for Dis."
#hp 11
#size 3
#ressize 2
#prot 3
#mor 50
#mr 11
#enc 5
#str 16
#att 17
#def 10
#prec 11
#mapmove 3
#ap 24
#mounted
#gcost 1
#rcost 1
#weapon "light lance"
#weapon "bite"
#weapon 56
#armor "shield"
#armor "hoplite helmet"
#armor "leather hauberk"
#nametype 107
#fear 0
#end


-- Orphan

#newmonster 2388
#spr1 "./Arga Dis/Orphan.tga"
#spr2 "./Arga Dis/Orphan2.tga"
#name "Orphan"
#descr "When an Argan boy reaches the age of six he is evaluated by the elders, veterans of countless battles who, for whatever reason, are not destined for glorious death. The majority of children pass muster and begin their training but those that are in some way deficient are severed from their family and given to the Gilgans. Those that are mentally unfit to become soldiers of Arga are raised by the Gilgans as fanatic killers full of rage and bloodlust. They fight with a pair of vicious bronze claws and seem to know no pain or fear, though they lack the discipline and training of true Argans."
#berserk 4
#hp 16
#size 2
#prot 3
#mor 18
#mr 10
#enc 3
#str 12
#att 11
#def 11
#prec 9
#mapmove 2
#ap 12
#gcost 13
#rcost 3
#weapon "claw"
#weapon "claw"
#ambidextrous 2
#ap 12
#mapmove 2
#nametype 107
#end 

-- Oathsworn

#newmonster 2389
#spr1 "./Arga Dis/Oathsworn.tga"
#spr2 "./Arga Dis/Oathsworn2.tga"
#name "Oathsworn"
#descr "The Oathsworn are direct descendants of the Argans who first swore the oath, released the Gilgans and spared Arga, only to leave her cursed and overpowered by the brutal Gilgans. They are paradoxical figures in Argan society, being both sacred and shunned by law; only other members of the Oathsworn families may speak with them, or even acknowledge their presence. Unlike the Sworn, who are driven to frenzied violence by a fleeting vision of the afterlife, the Oathsworn are plagued by constant nightmarish apparitions. In battle they are as well trained and deadly as any Argan hoplite, but they are unable to accept their fate and fear death in a way no other Argan can understand. They use longer spears similar to those of the Achilleans."
#holy
#gcost 22
#hp 11
#size 2
#prot 0
#mor 9
#mr 10
#enc 3
#str 12
#att 12
#def 12
#prec 10
#mapmove 2
#ap 10
#rcost 2
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "long Spear"
#weapon "Shield Bash"
#nametype 107
#end


-- Red Achillean

#newmonster 2390
#spr1 "./Arga Dis/Red Achillan.tga"
#spr2 "./Arga Dis/Red Achillan2.tga"
#name "Red Achillean"
#descr "The battleguard of the Gilgans, the Red Achilleans are drenched in blood from the Gilgan's sacrifical wells. This blood is imbued with dark protective power and can deflect almost any blow as though the skin of the warriors were made of iron. The Achillans are notoriously emotionless and focused; they lack the psychotic will to survive and cause mayhem possessed by the Sworn, but they are elite soldiers nonetheless. The key drawback of their 'armour' is that it acts as a conductor for magical energy, leaving the Achillans vulnerable to enemy spellcasters. They are still armed with the traditional combination of shield and spear, but have no use for the heavy hoplite helm. The need for large cauldrons of blood in which to immerse themselves has resulted in the Achilleans being unable to match the marching speed of the regular army on more than one occasion. Like their masters, they boast frightening appetites."
#hp 11
#size 2
#prot 15
#mor 15
#mr 7
#enc 3
#str 12
#att 13
#def 13
#prec 10
#mapmove 1
#ap 10
#gcost 30
#rcost 8
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#weapon "Long Spear"
#weapon "Shield Bash"
#supplybonus -1
#nametype 107
#end



-- Blackwing Rider

#newmonster 2391
#name "Blackwing Rider"
#spr1 "./Arga Dis/Blackwing.tga"
#spr2 "./Arga Dis/Blackwing2.tga"
#descr "The Blackwing are a group of Argan warriors who have allied with the Black Pegasi, creatures descended from the noble steeds of the Arcoscephalean Golden Age. Black Pegasi inhabit the Ash Cliffs of Arga high above the Charnel Cell and unlike the Mares of Dis have suffered little corruption from the imprisoned Gilgans. As such they are far less fearsome creatures, though still a match for any warhorse. The Blackwing were formerly an autonomous unit which roamed the borders of Arga, becoming influenced by other cultures and even adopting use of foreign weapons and armour. Long seen as a distraction from proper Argan methods of warfare they have recently been reined in and assigned to support infantry formations; as such there are no longer any Blackwing Captains."
#hp 11
#size 4
#ressize 2
#prot 0
#mor 14
#mr 11
#enc 5
#str 12
#att 12
#def 12
#prec 10
#mapmove 3
#ap 22
#flying
#mounted
#gcost 70
#rcost 11
#weapon "glaive"
#weapon 56
#armor "shield"
#armor "hoplite helmet"
#armor "scale mail hauberk"
#nametype 107
#end



-- Harpy of Dis

#newmonster 2376
#name "Harpy of Dis"
#descr "Harpies of Dis are foul, stinking scavengers summoned from the endless battlefields of Dis. They have the body of a vulture but the breasts and head of a shrivelled hag. The wings of these creatures are lined with sharp black feathers that curse any they cut. Harpies are reviled by the Argans, but on occasion the Gilgans make use of them, sending them to curse powerful foes or attack unguarded archers."
#copyspr 430
#hp 12
#size 2
#prot 3
#mor 11
#mr 11
#enc 3
#str 11
#att 11
#def 10
#prec 10
#mapmove 3
#ap 5
#flying
#gcost 1
#rcost 1
#weapon "Claw"
#weapon "Slashing Wing"
#end


-- Urtyr

#newmonster 2367
#spr1 "./Arga Dis/Urtyr.tga"
#spr2 "./Arga Dis/Urtyr2.tga"
#name "Urtyr"
#descr "Urtyr were originally born of satyrs unwittingly tainted by the warping influence of the Gilgan's Charnel Cell. Strong and savage, the Urtyr soon overthrew their satyr cousins and feasted upon their flesh. Urtyr are well known for their raids on human communities, killing the men and dragging the women into the dark forests, for there are no female Urtyr. They invariably cause unrest wherever they prowl. The Urtyr recognise the strength of the Gilgans and will serve them in exchange for a supply of young women. They are given vicious chopping sickles and cloak themselves in the flayed skin of men inscribed with dark runes of regeneration. Such is the savagery of the Urtyr that they are feared by all animals."
#hp 14
#size 2
#prot 5
#mor 11
#mr 10
#enc 3
#str 12
#att 11
#def 11
#prec 10
#mapmove 2
#ap 14
#forestsurvival
#animalawe 4
#gcost 1
#rcost 1
#armor "Fleshcloak"
#weapon "Bronze Sickle"
#weapon "Hoof"
#heal
#berserk 2
#incunrest 1
#stealthy 10
#regeneration 20
#end


------- COMMANDERS


-- Helgrot Scout

#newmonster 2378
#copyspr 201
#copystats 201
#name "Helgrot Scout"
#descr "The Helgrot are a slave caste who take care of the day to day running of Arga. Any Helgrot with a spark of strength or rebellion in his eyes is given a choice; go into battle and die to facilitate the glory of true Argan warriors, or be fed to the Mares, or worse, the Gilgans. Sometimes a particularly cowardly and sneaky Helgrot will be employed as a scout, a profession far below that of a real warrior."
#mor 7
#str 9
#att 9
#prec 9
#hp 8
#gcost 20
#nametype 107
#stealthy 10
#noleader
#end 


-- Argan Captain

#newmonster 2379
#spr1 "./Arga Dis/Argan Captain.tga"
#spr2 "./Arga Dis/Argan Captain2.tga"
#name "Argan Captain"
#descr "Captains of Arga can match any of their men in single combat and their rallying cries inspire great loyalty amongst the hoplites. They are armed identically to their soldiers."
#hp 12
#size 2
#prot 0
#mor 15
#mr 10
#enc 3
#str 12
#att 13
#def 13
#prec 11
#mapmove 2
#ap 10
#gcost 45
#rcost 2
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Spear"
#weapon "Shield Bash"
#goodleader
#nomagicleader
#noundeadleader
#standard 5
#nametype 107
#end

-- Sworn Captain

#newmonster 2380
#spr1 "./Arga Dis/Sworn Captain.tga"
#spr2 "./Arga Dis/Sworn Captain2.tga"
#name "Sworn Captain"
#descr "The Sworn epitomise Argan principles; they are tireless, ruthless, disciplined and possessing of almost inhuman strength. On initiation into this elite band they each swore a battle-oath to the Gilgans and to Arga and saw clearly for the first time the brutal truth of the afterlife, the chaos of Dis. Knowing the endless violent struggle that awaits them beyond the grave the Sworn are driven to prove themselves in life and, when they inevitably fulfill their destiny and die a glorious death, to take as many enemies to Dis with them as possible. Captains of the Sworn are the greatest warriors in each brotherhood and like the warriors under their command will fight on past the point where a normal man would fall and die."
#hp 14
#size 2
#prot 0
#mor 18
#mr 11
#enc 3
#str 14
#att 15
#def 14
#prec 12
#mapmove 2
#ap 10
#gcost 70
#rcost 3
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "short sword"
#weapon "Shield Bash"
#expertleader
#nomagicleader
#noundeadleader
#standard 10
#secondtmpshape 2360
#nametype 107
#end


-- Sworn Captain Slain

#newmonster 2360
#spr1 "./Arga Dis/Sworn Captain Slain.tga"
#spr2 "./Arga Dis/Sworn Captain Slain2.tga"
#name "Sworn Captain Slain"
#descr "A Sworn Captain who has been mortally wounded."
#hp 13
#size 2
#prot 4
#mor 50
#mr 11
#enc 3
#str 18
#att 19
#def 10
#prec 12
#mapmove 2
#ap 10
#gcost 1
#rcost 1
#armor "hoplite shield"
#armor "hoplite helmet"
#armor "leather cuirass"
#weapon "short sword"
#weapon "Shield Bash"
#expertleader
#nomagicleader
#noundeadleader
#standard 4
#nametype 107
#end

-- Sworn Companion Captain

#newmonster 2358
#spr1 "./Arga Dis/Sworn Companion Captain.tga"
#spr2 "./Arga Dis/Sworn Companion Captain2.tga"
#name "Sworn Captain"
#descr "The Sworn Companions are not decided by their relation to nobility, but by their ability to control the volatile maneating mares of Dis; semi-wild horses tainted over the centuries by proximity to the imprisoned Gilgans. Having survived Argan childhood and reached age enough to become Sworn, the glory found in conquering a mare of Dis is tempting indeed. Thousands of promising Argans die attempting such a task, torn to pieces by their savage mounts, but those that survive are a devastating and terrifying force on the battlefield. The Captains of the Companions are every bit as dangerous as the men under their command and as Sworn men will fight on despite mortal wounds."
#hp 14
#size 3
#ressize 2
#prot 0
#mor 18
#mr 11
#enc 3
#str 14
#att 15
#def 14
#prec 12
#mapmove 3
#ap 24
#gcost 130
#rcost 15
#weapon "bite"
#weapon 56
#armor "Leather Hauberk"
#armor "Shield"
#armor "Hoplite Helmet"
#weapon "short sword"
#mounted
#expertleader
#nomagicleader
#noundeadleader
#standard 10
#secondtmpshape 2359
#nametype 107
#fear 0
#end

-- Sworn Companion Captain Slain

#newmonster 2359
#spr1 "./Arga Dis/Sworn Companion Captain.tga"
#spr2 "./Arga Dis/Sworn Companion Captain2.tga"
#name "Sworn Captain Slain"
#descr "A Sworn Captain who has been mortally wounded and is hellbent on taking as many foes to Dis with him as possible."
#size 3
#ressize 2
#hp 13
#prot 4
#mor 50
#mr 11
#enc 3
#str 18
#att 19
#def 10
#prec 12
#mapmove 3
#ap 24
#gcost 1
#rcost 1
#weapon "bite"
#weapon 56
#armor "Leather Hauberk"
#armor "Shield"
#armor "Hoplite Helmet"
#weapon "short sword"
#mounted
#expertleader
#nomagicleader
#noundeadleader
#standard 4
#nametype 107
#fear 0
#end


-- Argan Myrmidon Captain

#newmonster 2357
#spr1 "./Arga Dis/Argan Myrmidon Captain.tga"
#spr2 "./Arga Dis/Argan Myrmidon Captain2.tga"
#name "Argan Captain"
#descr "Myrmidon Captains of Arga can match any of their men in single combat and their rallying cries inspire great loyalty amongst the myrmidons. They are armed identically to their soldiers."
#hp 12
#size 2
#prot 0
#mor 15
#mr 10
#enc 3
#str 12
#att 13
#def 13
#prec 11
#mapmove 2
#ap 12
#gcost 45
#rcost 2
#goodleader
#nomagicleader
#noundeadleader
#standard 5
#armor "Bronze Cuirass"
#armor "Hoplite Helmet"
#armor "Shield"
#weapon "Short sword"
#mountainsurvival
#nametype 107
#end


-- Haimgrot

#newmonster 2361
#copyspr 1640
#name "Haimgrot"
#descr "The Haimgrot are hated servants of the Gilgans whose sole purpose is to collect suitable blood sacrifices and assist in grisly minor rituals. Their ability to track down those with the necessary type of blood is legendary. They are physically weak, cowardly and entirely unfit to lead others into battle."
#hp 9
#size 2
#prot 0
#mor 8
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 2
#ap 12
#gcost 70
#douse 1
#magicskill 7 1
#rcost 1
#noleader
#weapon "dagger"
#nametype 107
#end

-- Gilgan

#newmonster 2362
#spr1 "./Arga Dis/Gilgan.tga"
#spr2 "./Arga Dis/Gilgan2.tga"
#name "Gilgan"
#descr "The Gilgans were a powerful race of mortal blood giants who were imprisoned by a Pretender God of great power countless centuries ago. The city state of Arga was initially established to guard the obliette in which the ageless Gilgans were trapped, but with the swearing of The Oath the blood giants were released and have become, in effect, rulers of all Arga. They are not so powerful as they once were, but are still a match for almost any creature that walks the land. If anything their imprisonment has only increased their appetite for blood, flesh and slaughter. The Gilgans have established themselves as the right hand of the awakening god and act as the head of what passes for religion in Arga."
#hp 54
#prot 6
#mor 16
#mr 16
#enc 4
#str 22
#att 12
#def 11
#prec 10
#ap 14
#goodleader
#magicskill 7 3
#magicskill 8 2
#holy
#fear 0
#size 4
#weapon "flail"
#armor "bronze scale cuirass"
#armor "crown"
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 10
#neednoteat
#supplybonus -8
#rcost 1
#gcost 410
#berserk 5
#maxage 2600
#startage 1370
#nametype 101
#end

-- Misborn

#newmonster 2363
#spr1 "./Arga Dis/Misborn.tga"
#spr2 "./Arga Dis/Misborn2.tga"
#name "Misborn"
#descr "The Misborn are rare Argan children who, being physically deformed and unfit for duty as true Argans, are granted to the Gilgans. Little do the Argans know that such deformities are a result of proximity to the Charnel Cell of the blood giants. These cursed Misborn children are twisted by their masters into creatures that are no longer human; they serve their masters with unwavering loyalty and are granted magical power which varies depending on the extent of their corruption."
#hp 14
#prot 2
#mor 14
#mr 14
#enc 3
#str 12
#att 9
#def 8
#prec 9
#ap 14
#poorleader
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 10
#custommagic 21632 10
#holy
#size 2
#weapon "claws"
#stealthy 0
#rcost 1
#gcost 130
#maxage 40
#startage 18
#nametype 107
#end


-- Augur


#newmonster 2375
#copystats 217
#spr1 "./Arga Dis/Augur.tga"
#spr2 "./Arga Dis/Augur2.tga"
#name "Augur"
#descr "Long before the fall of Arga, a secretive cabal of mystics foretold a time when all would be sacrificed to giants of blood and hatred, when men would be damned to hell and women would give birth to monsters. The Argans had little interest in such fearmongering and drove the cabal to the wild mountains. Yet from time to time nobles would covertly seek them out for their infamous powers. The corrupt Augurs first required gold, then helgrot slaves, then finally demanded virgin girls. With the emergence of the Gilgans, the Augurs have agreed to send members of their corrupt and degenerate cabal down from the mountains in exchange for young females to feed their insatiable lusts. Suffering from generations of inbreeding, disease and failed magical experimentation, the Augurs are deformed creatures little better than the Misborn. Their powers vary wildly, though they all retain the impressive ability to peer into the future via fires and mirrors."
#hp 8
#prot 0
#mor 9
#mr 15
#enc 3
#str 9
#att 8
#def 8
#prec 10
#ap 12
#noleader
#weapon "Club"
#custommagic 2048 55
#custommagic 2176 55
#custommagic 2176 55
#custommagic 12288 55
#custommagic 12288 55
#custommagic 14464 55
#custommagic 14464 55
#researchbonus 2
#mapmove 1
#mountainsurvival
#nobadevents 15
#nametype 107
#holy
#gcost 140
#older 35
#end


-- Urtyr Shaman

#newmonster 2377
#spr1 "./Arga Dis/Urtyr Shaman.tga"
#spr2 "./Arga Dis/Urtyr Shaman2.tga"
#name "Urtyr Shaman"
#descr "Urtyr were originally born of satyrs unwittingly tainted by the warping influence of the Gilgan's Charnel Cell. Strong and savage, the Urtyr soon overthrew their satyr cousins and feasted upon their flesh. Urtyr are well known for their raids on human communities, killing the men and dragging the women into the dark forests, for there are no female Urtyr. They invariably cause unrest wherever they prowl. The Urtyr recognise the strength of the Gilgans and will serve them in exchange for a supply of young women. Urtyr raiding groups are often led by a shaman who wields powerful nature and blood magic. The Urtyr shamans often join the Gilgans in their blood rituals and have a small degree of religious authority."
#hp 16
#size 2
#prot 5
#mor 12
#mr 15
#enc 3
#str 12
#att 10
#def 10
#prec 11
#mapmove 2
#ap 14
#forestsurvival
#animalawe 6
#gcost 1
#rcost 1
#armor "Fleshcloak"
#weapon "Magic Staff"
#weapon "Hoof"
#heal
#berserk 2
#incunrest 1
#stealthy 25
#regeneration 20
#researchbonus -2
#holy
#magicskill 8 1
#magicskill 7 1
#magicskill 6 2
#custommagic 24576 100
#custommagic 8192 10
#okleader
#end



---- HEROES


-- Gilgan Executioner Hero

#newmonster 2364
#spr1 "./Arga Dis/Hero Executioner.tga"
#spr2 "./Arga Dis/Hero Executioner2.tga"
#name "Executioner"
#descr "Executioners are powerful Gilgans who kept order amongst the Gilgans during their long imprisonment. They struck down the weakest of their kind who despaired and the most violent who were consumed by their rage. For an eternity the Executioners remained cold and emotionless for the sake of their race, knowing that when they were finally released, they would unleash their fury on the world."
#hp 68
#prot 7
#mor 20
#mr 17
#enc 4
#str 26
#att 13
#def 12
#prec 11
#ap 14
#expertleader
#magicskill 7 3
#magicskill 8 2
#holy
#fear 3
#size 4
#weapon "battleaxe"
#armor "bronze scale hauberk"
#armor "full helmet"
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 100
#neednoteat
#supplybonus -12
#rcost 1
#gcost 1
#berserk 12
#maxage 4000
#startage 2310
#nametype 101
#itemslots 31878
#end


-- Blind Myrmite

#newmonster 2365
#spr1 "./Arga Dis/Hero Myrmite.tga"
#spr2 "./Arga Dis/Hero Myrmite2.tga"
#name "Blind Myrmite"
#descr "When a rampaging gorgon took control of an ancient temple of Arga, a wandering fighter who had combined the ways of both Hoplites and the Myrmidons stepped forward, seeking the reward of a position in the Argan military. The Gilgans emerged to examine this hero and finding him up to the task, offered him an 'advantage'. He accepted and in moments his eyes were burned from his skull in exchange for unnatural vision beyond the real. Immune to the deadly gaze of the creature, he was able to draw it into single combat and defeat it. His 'advantage' does not end there; any who try to strike him risk having their own eyes blasted from their sockets. He is now a greatly feared commander in the Argan forces."
#hp 15
#size 2
#prot 0
#mor 18
#mr 12
#enc 3
#str 13
#att 14
#def 15
#prec 9
#mapmove 2
#ap 12
#gcost 1
#rcost 4
#eyeloss
#armor "Bronze Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Long Spear"
#weapon "Shield Bash"
#mountainsurvival
#blind
#standard 5
#expertleader
#nomagicleader
#noundeadleader
#nametype 107
#itemslots 31878
#end


-- Immortal King

#newmonster 2366
#spr1 "./Arga Dis/Hero King.tga"
#spr2 "./Arga Dis/Hero King2.tga"
#name "Immortal King"
#descr "The King of all Arga is a warrior to rival the best in the nation and over the years has proven himself entirely unkillable. Should he be struck down in battle his body will simply soak like blood into the earth and mere hours later will run through channels carved into his throne, slowly forming back into the form of the ruler. None can say exactly how this is so, or even whether the King is truly a man, but it has been this way since any can recall. Despite his clear ties with the Gilgans he clashes with them often over matters of state and has time and time again demonstrated that he is as fearless a ruler as a warrior. In battle he favours the equipment of the Sworn Captains, but wears his crown in place of a helmet and hefts a larger sword without any loss of speed or skill."
#hp 20
#size 2
#prot 3
#mor 20
#mr 12
#enc 2
#str 16
#att 15
#def 15
#prec 12
#mapmove 2
#ap 12
#gcost 1
#rcost 6
#immortal
#regeneration 30
#poisonres 100
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Crown"
#weapon "broad sword"
#weapon "Shield Bash"
#superiorleader
#okundeadleader
#standard 15
#nametype 107
#itemslots 31878
#end


----------- PRETENDER COPIES


--- Solar Disc


#newmonster 2368
#copystats 1384
#copyspr 1384
#restrictedgod 84

#end

--- LO Summer Plague


#newmonster 2369
#copystats 1097
#copyspr 1097
#restrictedgod 84

#end


--- Forge Lord


#newmonster 2370
#copystats 1230
#copyspr 1230
#restrictedgod 84

#end



--- Moloch


#newmonster 2371
#copystats 120
#copyspr 120
#restrictedgod 84

#end


--- Baphomet


#newmonster 2372
#copystats 607
#copyspr 607
#restrictedgod 84

#end


--- LO Desert Sun


#newmonster 2373
#copystats 957
#copyspr 957
#restrictedgod 84

#end



--- Scorp King


#newmonster 2374
#copystats 655
#copyspr 655
#restrictedgod 84

#end


--------------------------------------





-------- SPELLS ----------


---- Bribe Augur

#newspell
#name "Bribe Augur"
#descr "By offering the lecherous Augur cabal a selection of young girls, the services of one of their depraved number can be obtained. Suffering from generations of inbreeding, disease and failed magical experimentation, the Augurs are deformed creatures little better than the Misborn. Their powers vary wildly, though they all retain the impressive ability to peer into the future via fires and mirrors."
#restricted 84

#researchlevel 5
#path 0 7
#pathlevel 0 4
#school 6
#effect 10021
#fatiguecost 2500
#damage 2375
#nreff 1
#end


---- Scavengers of Dis

#newspell
#name "Scavengers of Dis"
#descr "Slaughtering a number of female slaves and scattering crow feathers over their bodies, the caster calls upon malign spirits known as the Harpies of Dis. From the corpses erupt foul flying creatures capable of cursing their victims by slashing at them with their feathers."
#restricted 84

#researchlevel 3
#path 0 7
#path 1 5
#pathlevel 0 1
#pathlevel 1 1
#school 6
#effect 10001
#fatiguecost 700
#damage 2376
#nreff 7
#end


---- Call Urtyr

#newspell
#name "Call Urtyr"
#descr "In exchange for young human females the caster forms a blood pact with a group of Urtyr raiders. Urtyr are corrupted Satyrs cloaked in flayed human flesh who wield great bronze sickles capable of lopping off limbs with ease. Few animals would ever dare attack an Urtyr. The reputation of more powerful blood mages will attract greater numbers of Urtyr."
#restricted 84

#researchlevel 4
#path 0 7
#path 1 6
#pathlevel 0 2
#pathlevel 1 1
#school 6
#effect 10001
#fatiguecost 1000
#damage 2367
#nreff 1002
#end

---- Contact Urtyr Shaman

#newspell
#name "Contact Urtyr Shaman"
#descr "By offering a large number of virgin girls the caster secures a blood pact with an Urtyr shaman. Urtyr are corrupted Satyrs cloaked in flayed human flesh and their shamans have considerable magical power in blood and nature. Few animals would ever dare attack an Urtyr."
#restricted 84

#researchlevel 6
#path 0 7
#pathlevel 0 4
#school 6
#effect 10021
#fatiguecost 4000
#damage 2377
#nreff 1
#end


---- Bray of the Urtyr

#newspell
#copyspell "Growing Fury"
#name "Bray of the Urtyr"
#descr "Lifting back his head the caster emits the blood curdling bray of the Urtyr. Across the battlefield blood spills from nostrils, eyes, ears and pores as the terrible sound resonates. The scent of this blood and the power of the terrible sound then drives the caster's forces into a state of frenzy. Those susceptible to fits of rage will lose control first, but eventually even the most disciplined of men and docile of creatures will join the orgy of carnage. The caster himself will actually be greatly strengthened and refreshed by the release of this malign energy, but he too will eventually succumb to the allure of frenzied combat."
#restricted 84

#researchlevel 5
#path 0 6
#path 1 7
#pathlevel 0 3
#pathlevel 1 1
#school 5
#fatiguecost 200
#nextspell "Bloodletting"
#end



-------- SITES -----------



#newsite 790

#name "The Charnel Cell"


#path 7
#level 0


#rarity 5
#gems 7 2
#gems 3 1
#gems 0 1
#homecom 2362 -- Gilgan
#end



#newsite 791
#name "Stable of Dis"


#path 5
#gems 5 1
#level 0


#rarity 5

#homecom 2358 -- Sworn Companion Captain
#homemon 2386 -- Sworn Companion
#end


#newsite 792
#name "Cliffs of Ash"
#path 1
#level 0
#rarity 5
#homemon 2391 -- Blackwing Rider
#end


-------- NAMEPOOLS -------


-------- NATIONS ---------

#selectnation 84

#name "Arga Dis"
#epithet "Blood and Bronze"
#era 2
#idealcold 0
#brief "Arga Dis is a brutal warrior nation which on the brink of annihilation swore an oath to a race of terrible blood giants and ever since has effectively served them."
#descr "A society which venerates war and bloodshed. Their city nation watched over the imprisoned Gilgan blood giants. Following a terrible war it seemed Arga would be razed and forgotten, a terrible fate for a once glorious nation. In their darkest hour the Argans turned to the blood giants and swore an oath in exchange for power that would allow them to save their city and slay their foes. The Gilgan's were freed and not only fought the enemies of Arga but gave a 'gift' to those who swore loyalty to them. This gift was a glimpse of the afterlife, of Dis, a terrible place of brutal conflict where the strong reigned. The newly sworn Argans turned to their foes as changed men and fought like devils, finally defeating them and saving their city. Now Arga is a changed city, more brutal and violent than ever, more focused on slaughter and glory. It is effectively ruled by the Gilgans and with the coming of God they have turned their attentions to the surrounding lands."
#summary "Race: Humans, Misborn and Blood Giants.
Military: Superb medium and heavy infantry, fearsome cavalry, crazed berserkers, slave chaff and flying support.
Magic: Blood, some death, fire and earth.
Priests: Average, can blood sacrifice but not preach."
#flag "./Arga Dis/flag.tga"
#templepic 6
#sacrificedom
#nopreach
#color 0.9 0.5 0.1


---- RECRUITS

#addrecunit 2381 -- Helgrot Chaff
#addrecunit 2382 -- Argan Hoplite
#addrecunit 2383 -- Argan Myrmidon
#addrecunit 2388 -- Sworn Orphan
#addrecunit 2384 -- Sworn Brother
#addrecunit 2390 -- Red Achillan
#addrecunit 2389 -- Oathsworn
--addrecunit 2376 -- Harpy of Dis
--addrecunit 2367 -- Urtyr


---- LEADERS

#addreccom 2378 -- Helgrot Scout
#addreccom 2379 -- Argan Captain
#addreccom 2357 -- Myrmidon Captain
#addreccom 2380 -- Sworn Captain
#addreccom 2361 -- Haimgrot
#addreccom 2363 -- Misborn
--addreccom 2364 -- Gilgan hero
--addreccom 2365 -- Blind hero
--addreccom 2366 -- Immortal King
--addreccom 2375 -- Augur
--addreccom 2377 -- Urtyr Shaman


----- HEROES

#multihero1 2364 -- Gilgan Executioner
#hero1 2365 -- Blind Myrmite
#hero2 2366 -- Immortal King
--hero3 5555 -- Urtyr Lord?
--hero4 5555 -- Winged Augur?


----- STARTSITES

#startsite "Stable of Dis"
#startsite "The Charnel Cell"
#startsite "Cliffs of Ash"

----- FORTS

#startfort 3
#swampfort 11
#farmfort 3
#forestfort 33
#mountainfort 36
#defaultfort 39


------- PROVINCE DEFENCE

--Sets the units to be used in province defense.

#defcom1 2379

#defcom2 2357

#defunit1 2381

#defunit1b 2382
#defunit2 2383


--Sets how many of the units to appear per 10 points.

#defmult1 10
#defmult1b 10
#defmult2 10



------- STARTING UNITS

#startcom 2379 -- Argan Captain
#startscout 2378 -- Helgrot scout
#startunittype1 2382
#startunitnbrs1 8
#startunittype2 2383
#startunitnbrs2 8
#end


-modname "Pythium: The Second Empire"
-description "This is the Pythium: The Second Empire mod, which adds a new MA nation with some Byzantine influences."
-icon "./Byzantine/banner.tga"
-version 0.87

-- Mod by Burnsaber.
-- Extensively modified by llamabeast (26th March 2011) to give compatibility with base-game Pythium as well as Sombre's Mod Catalogue project.

This mod uses slots:

Weaponslots: 730-733
Armorslots: 351
Monsterslots: 2690-2692
Spellslots: 6

-------- BUG FIXES --------

#selectmonster 1367 --Angel of the Host
#size 3
#end

-------- WEAPONS --------

#selectweapon 48
#explspr 10113 -- llama says: Guess I'll leave this in since it's purely cosmetic.
#end

-selectweapon 441 -- Banish to Inferno
-nratt 3         -- Can't really leave this in. Sorry Michael!
-end

#newweapon 692
#name "Pyros"
#range -1
#rcost 9
#bonus
#fire
#armorpiercing
#ammo 3
#att -3
#len 0
#dmg 9
#nostr
#magic
#aoe 2
#flyspr 100 1
#explspr 10113
#end

#newweapon 697
#name "Serpent Slayer"
#rcost 0
#att 7
#def 3
#len 3
#dmg 7
#dt_holy
#armornegating
#secondaryeffectalways 276 -- Small Area Holyfire 
#magic 
#end

#newweapon 698
#name "Pyro Staff"
#rcost 18
#fire
#armorpiercing
#ammo 3
#att 0
#len 3
#def -2
#dmg 10
#nostr
#magic
#aoe 1
#secondaryeffectalways 692
#explspr 10060
#end

#newweapon 699
#name "Warmace"
#rcost 2
#att 1
#len 1
#def 0
#dmg 6
#end

------------Armor-------------

#newarmor 351
#name "Halo"
#type 6
#rcost 0
#def 0
#prot 40
#enc 0
#end


-------- UNITS ----------

#newmonster 2206 -- Theurg Acolyte
#copystats 43
#copyspr 43
#descr "Spokesmen of the Faith of Pythium and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes."
-selectmonster 43 -- Theurg Acolyte
#startage 25
#custommagic 896 10
#nametype 107
#end

#newmonster 2207 -- Theurg
#copystats 42
#copyspr 42
#descr "Spokesmen of the Faith of Pythium and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes."
#clearmagic
#startage 40
#gcost 180
#magicskill 4 2
#magicskill 8 2
#custommagic 896 100
#magicboost 0 1
#magicboost 1 1
#magicboost 2 1
#nametype 107
#end

#newmonster 2208 -- Arch Theurg
#copystats 41
#copyspr 41
#descr "Spokesmen of the Faith of Pythium and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes."
#clearmagic
#startage 60
#maxage 100
#magicskill 4 3
#magicskill 8 3
#custommagic 896 100
#custommagic 896 100
#magicboost 0 2
#magicboost 1 2
#magicboost 2 2
#nametype 107 
#end

-- Battle Vestal
#newmonster 2209
#copystats 51
#copyspr 51
#descr "The Battle Vestals are priestly maidens devoted to war. They carry no armor, relying on their quickness to avoid their enemies' weapons. The Vestals are sacred and can be blessed by priests."
#gcost 20
#mor 13 -- CBM change
#mr 14 -- CBM change
#nametype 108 
#end

-Velite
#newmonster 2210
#copystats 684
#copyspr 684
#descr "These are light troops equipped only with spear, javelin, tower shield and iron cap."
#gcost 9
#end

-Legatus Legionis
#newmonster 2211
#copystats 1385
#copyspr 1385
#descr "The Legatus Legionis is a high commander of an Imperial Legion. Only the most able commanders are chosen for the task and only candidates with political backing, strong personalities and exceptional skills will receive the honor. These able men command great respect from their soldiers and will inspire them to great deeds."
#gcost 50
#end

-Hastatus
#newmonster 2212
#copystats 686
#copyspr 686
#descr "The Hastati are legionnaires trained in the major cities of the Empire. They normally take the second rank, behind the Velites and will deal the first blow against the enemy. The Hastati wield short swords and javelins. They wear the lorica segmentata, a flexible armor of metal bands joined together, and carry a scutata tower shield."
#gcost 11
#end

------------------------------------------------
/////////////////////HEROES//////////////////////
------------------------------------------------

#newmonster 2213 -- Patriarch
#copystats 584
#copyspr 584
#clearmagic
#descr "The Patriarch is the highest ranking priest of the Empire and commands the vast powers of the Theurg. Only the Emperor holds more power within the Empire. He has been elected to the Holy Seat by his peers because of his immense faith and magical prowess, which allows him to form stronger communions than most Theurgs. He rarely involves himself in matters beyond the Sancta Sophia, but a recent vision has made him leave his prayer chamber to serve the Awakening God."
#startage 60
#maxage 100
#magicskill 8 4
#magicskill 0 2
#magicskill 1 2
#magicskill 2 2
#magicskill 4 3
#nametype 107
#end

------------ALCHEMIST GUILDMASTER

#newmonster 2214
#clearstats
#copystats 1880 -- Reveler for Heretic 3
#clearmagic
#spr1 "./Byzantine/Alchemist_Guildmaster_1.tga"
#spr2 "./Byzantine/Alchemist_Guildmaster_2.tga"
#name "The Guildmaster"
#descr "The Guildmaster of the alchemists of Pythium is shrouded in mystery. His genius is not up to debate, but not much else is known about him. He has always worn a golden mask to cover face and rose to his position in a very short amount of time by politicking and his opposers had a bad habit of 'dissappearing' before important debates. Some say that he wears his mask to cover a hideous injury from an alchemical accident and others say that it is a trophy, since that mask was once made from lead. Vilest rumours accuse of him belonging to one of the heretical cults. He has now given himself to the service of the awakening god for reasons only known to him."
#str 10
#prot 3
#weapon 238 --magic staff
#weapon 692 --pyros
#fireres -50
#hp 12
#mor 13
#mr 15
#att 10
#def 10
#ap 12
#prec 11
#enc 3
#researchbonus 7
#magicskill 0 3
#magicskill 2 3
#magicskill 3 2
#gcost 1
#rcost 1
#noleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

-----------------MAN FROM NORTH

#newmonster 2215
#clearstats
#spr1 "./Byzantine/Man_from_North_1.tga"
#spr2 "./Byzantine/Man_from_north_2.tga"
#name "Man from the North"
#descr "This man, simply known as the 'Man from the North' was once the fiercest marauder in the distant Vanheim and not even the Vanir could not prevent his pillages. Once he heard from the riches of Sancta Sophia, he decided to sail to the Glorius City and burn it to the ground. He gathered a great horde of northmen and set sails for the Heart of Pythium. He took the Theurgs by surprise and smashed the gates of the city. But as he gazed upon the beauty of the Glorious City, he fell down to his knees and wept for he had not seen such glory before. He disbanded his men and fled, horrified of the sin he almost committed. After a full century, the Man from the North has returned to pay back his crime although no one knows what sorcery has allowed him to stay alive for so long."
#str 14
#prot 0
#weapon 412 -- Axe of Hate
#secondshape 2216
#ambidextrous 2
#pillagebonus 25
#armor "Chain Mail Hauberk"
#regeneration 5
#forestsurvival
#berserk 3
#fear 0
#sailing
#hp 20
#mor 17
#mr 15
#att 15
#def 13
#ap 14
#prec 11
#enc 2
#gcost 1
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 115 
#startage 120
#maxage 200
#end

#newmonster 2216
#copyspr 633
#name "Man from the North"
#descr "This man, simply known as the 'Man from the North' was once the fiercest marauder in the distant Vanheim and not even the Vanir could not prevent his pillages. Once he heard from the riches of Sancta Sophia, he decided to sail to the Glorius City and burn it to the ground. He gathered a great horde of northmen and set sails for the Heart of Pythium. He took the Theurgs by surprise and smashed the gates of the city. But as he gazed upon the beauty of the Glorius City, he fell down to his knees and wept for he had not seen such glory before. He disbanded his men and fled, horrified of the sin he almost committed. After a full century, the Man from the North has returned to pay back his crime."
#str 15
#prot 7
#firstshape 2215
#weapon 29 --Claw
#weapon 29 --Claw
#weapon 20 --Bite
#fear 0
#forestsurvival
#regeneration 20
#pillagebonus 25
#berserk 3
#hp 25
#mor 17
#mr 14
#att 15
#def 13
#ap 13
#prec 11
#enc 2
#gcost 1
#rcost 1
#okleader
#mapmove 2
#size 3
#nametype 115 
#startage 35
#maxage 75
#end

////////////////////////////////
----------NEW RECRUITS---------
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

----Cultist

#newmonster 2217
#copystats 1872 -- Leo for heretic 1
#clearmagic
#spr1 "./Byzantine/Cultist_1.tga"
#spr2 "./Byzantine/Cultist_2.tga"
#name "Cultist"
#descr "The nobles and the Theurgs of the Empire are in a constant power struggle, as they wrestle for the attention of the Emperor. The Emperors often favour the Theurgs, who traditionally school all future emperors in magic and faith. Thus Theurgs often ger better positions in the court and most nobles have antipathy towards the Theurgs and their faith. Recently, preachers of strange new faiths have charmed the Pythian nobles with their promises of power. These new cults have proven guite popular within the nobility because they no qualms about 'removing' troublesome Theurgs from court politics. Theurgs have outlawed all of these cults, but some cultists could still see themselves serving the Awakening God if they get paid enough for it. Some of them possess some magical might as a gift from their heretical god."
#str 10
#prot 0
#fireres 0
#firepower 0
#weapon "Serpent Kryss"
#armor "Robes"
#armor "Mask"
#stealthy 20
#assassin
#poisonres 50
#custommagic 8704 10
#custommagic 20480 10
#hp 11
#mor 12
#mr 12
#att 12
#def 12
#ap 12
#prec 10
#enc 3
#gcost 75
#rcost 1
#noleader
#mapmove 2
#size 2
#nametype 107
#startage 35
#maxage 55
#end


------------IMPERIAL ALCHEMIST

#newmonster 2218
#clearstats
#spr1 "./Byzantine/Imperial_Alchemist_1.tga"
#spr2 "./Byzantine/Imperial_Alchemist_2.tga"
#name "Imperial Alchemist"
#descr "The Theurgs of Pythium are great supporters of arts and sciences. Throughout centuries, the guild house of the Imperial Alchemists has just grown and grown with more and more wonderful inventions one after another. Unlike most alchemists, the Pythian ones not as obsessed with turning lead into gold, although they occasionally dabble in the matter. As most of the alchemists are funded by the imperial seat, most of their efforts go into the study of fire and water, which has more battlefield applications. The invention of 'Pyros', which is also known as Alchemist's fire, is their greatest advancement thus far. All alchemists are skilled in the use of Pyros and carry some vials of the stuff into combat. However, this branch of alchemy is quite dangerous and many alchemists carry permanent wounds from alchemical accidents."
#str 10
#prot 3
#weapon 9 --dagger
#weapon 692 --pyros
#startaff 10
#fireres -50
#hp 10
#mor 10
#mr 13
#att 9
#def 9
#ap 12
#prec 10
#enc 3
#researchbonus 1
#magicskill 0 1
#magicskill 2 1
#custommagic 1664 100
#custommagic 1664 10
#gcost 110
#rcost 2
#noleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

------------THEURG ARTISAN

#newmonster 2219
#clearstats
#spr1 "./Byzantine/Theurg_Artisan_1.tga"
#spr2 "./Byzantine/Theurg_Artisan_2.tga"
#name "Theurg Artisan"
#descr "The Theurgs of Pythium are great supporters of arts and sciences. The artisans of the Glorious City are often also priests trained in Sancta Sophia. Combining their craftsmanship with their faith allows them to make works art so beautiful that they bring the hearts of men closer to the celestial realm and the Awakening God. The artisans often specialize in single craft and train in magic related to that craft. Glass-blowers are skilled in fire magic, Sculptors in earth magic, Painters in water magic, Singers in air magic and Cantors are skilled in astral magic. Their skills allow them to forge magical items of great wonder more cheaply. However, the Artisans are pampered by the luxury of the Glorious City and lack the patience for magical research. They also demand a heavy price for their services. Rarely a savant emerges from their ranks, a true genius mastering several forms of art."
#str 10
#prot 0
#weapon 7 --quarterstaff
#hp 10
#mor 11
#mr 14
#att 9
#def 9
#ap 12
#prec 11
#enc 3
#holy
#magicskill 8 1
#custommagic 3968 100
#custommagic 128 10
#custommagic 256 10
#custommagic 512 10
#custommagic 1024 10
#custommagic 2048 10
#forgebonus 10
#researchbonus -1
#gcost 125
#rcost 1
#noleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

------------AMBASSADOR

#newmonster 2220
#clearstats
#spr1 "./Byzantine/Ambassador_1.tga"
#spr2 "./Byzantine/Ambassador_2.tga"
#name "Ambassador"
#descr "The Imperial courts of Pythium are full of intrigue and secrets. They are places where the weak-willed and stupid are quite prone to perish in tragic 'accidents' as the nobles race to get closer to the emperor. In this rather dangerous environment, only the cunning, charismatic and sneaky can prosper. The Emperor is not blind to the talents of some of these individuals and often sends them to distant countries as ambassadors so that they can spy on the enemies of the Empire."
#str 10
#prot 0
#weapon 9 --dagger
#spy
#stealthy 20
#hp 10
#mor 10
#mr 10
#att 9
#def 9
#ap 12
#prec 11
#enc 3
#gcost 30
#rcost 1
#poorleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end


-----------VARANGIAN GUARD

#newmonster 2221
#clearstats
#spr1 "./Byzantine/Varangian_Guard_1.tga"
#spr2 "./Byzantine/Varangian_Guard_2.tga"
#name "Varangian Guard"
#descr "A century ago, a great horde of northmen tried to conquer the Glorious City and plunder the riches of Sancta Sophia. Their numbers were many and they surprised the defenders by sailing through rivers and destroyed the gate. However, their leader was so awestruck by the beauty of Sancta Sophia that he disbanded his men and fled in shame. The Theurgs told the northmen of their Awakening God and the Emperor hired them to the imperial army as mercenaries. After seeing them fight against the horsemen of the East, the Emperor was greatly impressed by their loyalty and martial prowess and installed them as imperial bodyguards, who would be immune to politicking of his power hungry courtiers. The skills of the Varagian Guard are know throughout the realm and many skilled northmen travel to the glorious city in order to become one of them."
#str 12
#prot 0
#weapon 18 --Battleaxe
#armor "Half Helmet"
#armor "Chain Mail Hauberk"
#hp 14
#mor 16
#mr 12
#att 12
#def 11
#ap 12
#prec 10
#enc 3
#gcost 20
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 115 
#startage 25
#maxage 50
#end

-----------VARANGIAN CAPTAIN

#newmonster 2222
#clearstats
#spr1 "./Byzantine/Varangian_Captain_1.tga"
#spr2 "./Byzantine/Varangian_Captain_2.tga"
#name "Varangian Captain"
#descr "A century ago, a great horde of northmen tried to conquer the Glorious City and plunder the riches of Sancta Sophia. Their numbers were many and they surprised the defenders by sailing through rivers and destroyed the gate. However, their leader was so awestruck by the beauty of Sancta Sophia that he disbanded his men and fled in shame. The Theurgs told the northmen of their Awakening God and the Emperor hired them to the imperial army as mercenaries. After seeing them fight against the horsemen of the East, the Emperor was greatly impressed by their loyalty and martial prowess and installed them as imperial bodyguards, who would be immune to politicking of his power hungry courtiers. The Varangian Captains are the most fearsome of these warriors and their fame travels before them, filling opposing enemies with fear."
#str 13
#prot 0
#weapon 17 --Axe
#weapon 17 --Axe
#ambidextrous 2
#armor "Chain Mail Hauberk"
#fear 0
#sailing
#hp 16
#mor 17
#mr 13
#att 14
#def 12
#ap 13
#prec 10
#enc 2
#gcost 65
#rcost 1
#goodleader
#mapmove 2
#size 2
#nametype 115 
#startage 35
#maxage 50
#end

-----------Kataphraktoi

#newmonster 2223
#clearstats
#spr1 "./Byzantine/Latinkoi_1.tga"
#spr2 "./Byzantine/Latinkoi_2.tga"
#name "Kataphraktoi"
#descr "The Kataphraktoi serve as the heavy cavalry of the Empire, like the Equites in the Ermorian legion before the fall. These Pythian counterparts are more heavily armoured and use heavy lances, although they are not as heavily armed as the knights of the western kingdoms. Like most elite soldiers in the legion, they use Pythian Warmaces in combat."
#str 11
#prot 0
#weapon "Lance"
#weapon 710 -- Warhorse Hoof
#weapon 699 -- Warmace
#armor "Legionary Helmet"
#armor "Chain Mail Hauberk"
#armor "Shield"
#hp 12
#mor 12
#mr 11
#att 11
#def 11
#ap 24
#mounted
#prec 10
#enc 4
#gcost 35
#rcost 8
#ressize 2
#okleader
#mapmove 2
#size 3
#nametype 107 
#startage 25
#maxage 50
#end

-----------Verdariotai

#newmonster 2224
#clearstats
#spr1 "./Byzantine/Verdariotai_1.tga"
#spr2 "./Byzantine/Verdariotai_2.tga"
#name "Verdariotai"
#descr "The Verdariotai are barbarian horsemen from the northern wastes. Their people often raided the border provinces of Pythium during the early days of the Empire. However, as they were constantly beaten back, the barbarians noticed that they would gain more riches by working for the Emperor as mercenaries. Now these mercenaries have become integral part of the Pythian legions. They are skilled horsemen and archers, although they are poorly armoured."
#str 10
#prot 0
#weapon 357 --Light Lance
#weapon 264 --Composite Bow
#weapon 710 -- Warhorse Hoof
#wastesurvival
#forestsurvival
#armor "Leather Cap"
#armor "Full Leather Armor"
#armor "Buckler"
#hp 11
#mor 10
#mr 10
#att 10
#def 10
#ap 26
#mounted
#prec 10
#enc 3
#gcost 20
#rcost 1
#okleader
#mapmove 3
#size 3
#nametype 121 
#startage 25
#maxage 50
#end


-----------Pyrote

#newmonster 2225
#clearstats
#spr1 "./Byzantine/Pyrote_1.tga"
#spr2 "./Byzantine/Pyrote_2.tga"
#name "Pyrote"
#descr "The Pyrotes are the secret weapon of the Empire. They armed with strange cylinders that are filled with Alchemist's Fire, a strange flammable substance devised by the Imperial alchemists. Pyrotes can fire these cylinders to engulf all nearby enemies in flames. As deadly as the new weapons are, they are also dangerous to their user as even a small surge of heat could fire up the Pyros inside the cylinder. Thus, only the bravest and most foolhardy soldiers could ever be enlisted as Pyrotes. The Pyro staffs are also very time-consuming to manufacture, which even further limits the amount of these weapons in the battlefield."
#str 11
#prot 0
#weapon 699 -- Warmace
#weapon 698 --Pyro Staff
#armor "Full Helmet"
#armor "Plate Cuirass"
#fireres -100
#hp 12
#mor 12
#mr 11
#att 11
#def 11
#ap 12
#prec 10
#enc 6
#gcost 35
#rcost 5
#okleader
#mapmove 2
#size 2
#nametype 107 
#startage 25
#maxage 50
#end

-----------Principe

#newmonster 2226
#clearstats
#descr "The Principes are the elite troops of the legion. They take the third rank behind the Hastati and are supposed to crush the enemy if the Hastati are broken. The Principes are armed as the Hastati with javelins and wear the lorica segmentata. However, they wield Pythian Warmaces instead of short swords for greater offensive power."
#name "Principe"
#spr1 "./Byzantine/Pythian_Principe_1.tga"
#spr2 "./Byzantine/Pythian_Principe_2.tga"
#str 10
#prot 0
#weapon 699 -- Warmace
#weapon "Javelin"
#armor "Lorica Segmentata"
#armor "Legionary Helmet"
#armor "Tower Shield"
#hp 11
#mor 12
#mr 10
#att 11
#def 11
#ap 12
#prec 11
#enc 3
#gcost 14
#rcost 1
#okleader
#mapmove 2
#size 2
#nametype 107 
#startage 35
#maxage 50
#end

-----------Akritoi

#newmonster 2227
#clearstats
#name "Akritoi"
#descr "The Akritoi are a new unit for legion, installed after the invasion by the Horsemen from the east. Their attack showed how the Pythium military needed a long range bowmen to combat the quickly moving horseman archers the barbarians used. Akritoi are skilled and heavily armed legionary archers who use composite bows. They are a relatively new unit and there are few soldiers in Pythium who are skilled in the use of composite bow, making recruiting them a rather slow process."
#spr1 "./Byzantine/Akritoi_1.tga"
#spr2 "./Byzantine/Akritoi_2.tga"
#str 10
#prot 0
#weapon 699 -- Warmace
#weapon "Composite Bow"
#armor "Lorica Segmentata"
#armor "Legionary Helmet"
#armor "Buckler"
#hp 10
#mor 11
#mr 10
#att 10
#def 10
#ap 12
#prec 10
#enc 3
#gcost 11
#rcost 3
#okleader
#mapmove 2
#size 2
#nametype 107 
#startage 35
#maxage 50
#end

-----------The Emperor

#newmonster 2228
#clearstats
#spr1 "./Byzantine/The_Divine_Emperor_1.tga"
#spr2 "./Byzantine/The_Divine_Emperor_2.tga"
#name "The Emperor"
#descr "The Emperor of Pythium is the most powerful man in Pythium and not just because of his title. All Emperors are rigorously trained in magic and faith from childhood in the Sancta Sophia, making them mighty wielders of divine and astral forces. Emperors are also often seen leading the divine communions of the Theurgs."
#str 10
#prot 0
#weapon 134 --spectre of authority
#armor "Crown"
#hp 10
#mor 15
#mr 16
#att 10
#def 10
#ap 12
#prec 11
#enc 3
#holy
#magicskill 4 4
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#mapmove 2
#size 2
#nametype 107 
#startage 40
#maxage 65
#end

-- Seems like an unnecessary bit to llamabeast.
----Angel of the Host, altered for hero making purposes.
-selectmonster 543
-descr "Angels are divine beings in human form. They are winged and armed with flaming swords that destroy undead beings. They are surrounded by a radiant aura that intimidates cowardly beings. Angels have partial resistance to lightning and fire. They sometimes act as Guardian Angels for righteous mortals."
-end

-------- The Archangels

#newmonster 2229
#clearstats
#spr1 "./Byzantine/Sealtiel_1.tga"
#spr2 "./Byzantine/Sealtiel_2.tga"
#name "The Prayer of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the prayer of the holiest and guides the followers of light on ways to reach the divine realm through humble prayer. He is the most serene of the Archangels and will not raise his hand from prayer, not even to smite the unholy or to take up arms. If he is present in battle, he will often lead the holy communion of the Theurgs so that they can channel celestial might and bring the kingdom of heaven upon this realm."
#str 7
#prot 7
#weapon 509 --Bane of Heresy
#domsummon20 1367 --Angel of the Celestial Choir
#summon1 1367 --Angel of the Celestial Choir
#researchbonus 20
#itemslots 31872 -- no hand slot, does not take up arms.
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 50
#fireres 50
#unique
#awe 9
#hp 39
#mor 30
#mr 18
#att 0
#def 14
#ap 16
#prec 15
#enc 1
#holy
#magicskill 4 4
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 8 4
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2230
#clearstats
#spr1 "./Byzantine/Raphael_1.tga"
#spr2 "./Byzantine/Raphael_2.tga"
#name "The Healing of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the healing of the holiest and his gift is to bring purity of the body to servants of the Awakening God. He is revered as the protector of science and medicine and especially Imperial Alchemists pray for his guidance. His body is pure and resistant to the ravages of the mortal plane, be they blades of a sinner or elemental sorcery from heretics. He is an angel of thought and serenity, unwilling to take up arms other than his trusty staff and his golden jar of medicine."
#str 13
#prot 17
#weapon 238 --Magic Staff
#researchbonus 10
#itemslots 31872 -- no hand slot, does not take up arms.
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#regeneration 10
#heal
#healer 100
#shockres 50
#fireres 50
#poisonres 50
#coldres 50
#awe 7
#hp 40
#mor 30
#unique
#mr 18
#att 11
#def 14
#ap 16
#prec 15
#enc 1
#holy
#magicskill 4 3
#magicskill 6 3
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end

#newmonster 2231
#clearstats
#spr1 "./Byzantine/Barachiel_1.tga"
#spr2 "./Byzantine/Barachiel_2.tga"
#name "The Blessing of the Lord"
#str 14
#prot 7
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the blessing of the holiest and rules the court of guardian angels in order to protect the followers of the awakening god. He distributes of the blessings granted by the celestial powers and can summon Guardian Angels to guard mortals and prevent bad events by his mere presence. His brother was one of the fallen watchers and upon their imprisonment, he was granted dominance over skies and thunder, which was the domain of his fallen brother Ezekiel. He now uses his brother's powers to smite those who would harm those under his protection. He wields a white rose to remember his brother's fate, so that he would not to repeat his sins."
#weapon 278 --Lightning Spear
#weapon 243 --Lightning (thrown)
#weapon 243 --Lightning (thrown)
#stormimmune
#nobadevents 77
#makemonster2 543 -- Angels of the Host
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 100
#fireres 50
#awe 7
#unique
#hp 49
#mor 30
#mr 18
#att 14
#def 14
#ap 16
#prec 15
#enc 1
#holy
#magicskill 1 4
#magicskill 0 2
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2232
#clearstats
#spr1 "./Byzantine/Jegudiel_1.tga"
#spr2 "./Byzantine/Jegudiel_2.tga"
#name "The Glorifier of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the glorifier of the holiest and knows how to bring the mortals closer to the heavenly realm through works of beauty and wonder. He is the protector of arts and honest labour, for works of art and building bring men closer to the divine realm. The Theurg Artisans of Sancta Sophia hold him as their patron and inspiration. He is able to easily create works of magical wonder and does not tire by any physical effort, as he is constantly filled with divine vigour. He is a serene angel of beauty and wields a shining crown on his right hand to remind mortals of the rewards that will come with spiritual labour in the kingdom of heaven."
#str 13
#prot 7
#weapon 92 --Fist
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 50
#fireres 50
#reinvigoration 4
#forgebonus 25
#unique
#awe 7
#hp 44
#mor 30
#mr 18
#att 13
#def 13
#ap 16
#prec 15
#enc 1
#holy
#magicskill 4 3
#magicskill 3 2
#magicskill 0 1
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2233
#clearstats
#spr1 "./Byzantine/Gabriel_1.tga"
#spr2 "./Byzantine/Gabriel_2.tga"
#name "The Man of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the man of the holiest and acts as an messenger and warrior for the celestial powers, making their will known amongst the mortals. He is a mighty warrior, second only to the Slayer of the Serpent in terms of martial skill. His skills as an divine herald allow him to pass enemy lands swiftly and unseen while spreading the dominion of the awakening god. He wields a mirror of green jasper on his left hand, to represent the mysteries of the divine realm."
#str 16
#prot 8
#weapon 106 --Sword of Swiftness
#stealthy 25
#spreaddom 1
#armor "Halo"
#armor "Silver Hauberk"
#magicbeing
#unique
#holy
#neednoteat
#flying
#shockres 50
#fireres 50
#awe 7
#hp 57
#mor 30
#mr 18
#att 16
#def 16
#ap 16
#prec 15
#enc 1
#holy
#magicskill 1 3
#magicskill 4 3
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 7
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

#newmonster 2234
#clearstats
#spr1 "./Byzantine/Uriel_1.tga"
#spr2 "./Byzantine/Uriel_2.tga"
#name "The Light of the Lord"
#descr "This is one of the Seven Archangels from the Celestial Sphere. He has now descended down to the mortal realm to guide the Theurgs in these perilous times. He is the light of the holiest and brings the divine light to cleanse the shadows of sin from the hearts of mortals. He also is the protector of the sun and acts as the eyes of the divine sphere, gazing upon the mortal realm with his celestial eyes as he guards the sun by day. On his right hand, he wields the sacred Orb of Fire, which will smite heathens who would try to strike the enlightener and light his path in darkness."
#str 14
#prot 7
#weapon 275 --Sun Sword
#weapon 229 --Flame Strike
#itemslots 15490 -- Only one hand slot
#armor "Halo"
#magicbeing
#holy
#neednoteat
#flying
#shockres 50
#fireres 100
#fireshield 8
#darkvision 100
#unique
#awe 7
#hp 49
#mor 30
#mr 18
#att 14
#def 14
#ap 16
#prec 20
#enc 1
#holy
#magicskill 0 4
#magicskill 1 2
#magicskill 8 3
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 3
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 

----------- Michael

#newmonster 2235
#spr1 "./Byzantine/True_Michael_1.tga"
#spr2 "./Byzantine/True_Michael_2.tga"
#name "Who is like the Lord?"
#descr "This is one of the Seven Archangels from the Celestial Sphere. This angel is the Seventh, the most glorious of all Archangels. He resisted the poisonous lies of Belial, withstood the plague wind of Pazazu, endured the heat of Buer and persisted under the blows of Belphegor to cast them all to inferno at the dawn of time. He is The Warrior from Heaven, whose mere name is a riddle only the righteous can answer. He is the guardian of the Divine Kingdom and his tasks are great, but still he has come to this battle to protect the righteous. Armed with the spear he used to smite the four hellish lords, he will banish sinners to their rightful place."
#str 17
#prot 12
#weapon 697 -- Serpent Slayer
#weapon 441 -- Banish to Inferno
#armor "Halo"
#armor "Silver Hauberk"
#armor "Shield of Valor"
#magicbeing
#holy
#neednoteat
#flying
#stormimmune
#unique
#noitems -- To make him an unattractive wish target
#shockres 75
#fireres 75
#poisonres 75
#awe 8
#hp 77
#mor 30
#mr 18
#att 17
#def 17
#ap 17
#prec 17
#enc 1
#holy
#gcost 0
#rcost 1
#expertleader
#expertmagicleader
#mapmove 7
#size 4
#nametype 139 
#startage 1000
#maxage 4000
#end 



------- Pretenders

#newmonster 2236
#copystats 472 -- Sacred Statue
#copyspr 472 -- Sacred Statue
#restrictedgod 85

#end

#newmonster 2237
#copystats 215 -- Virtue
#copyspr 215 -- Virtue
#restrictedgod 85

#end

#newmonster 2238
#copystats 600 -- Titan (female)
#copyspr 600 -- Titan (female)
#descr "The Titaness is a giant who claims divine heritage. She is a wise and excellent warrior. She is at all times followed by her owl companion."
#restrictedgod 85

#end

#newmonster 2239
#copystats 603 -- Father of Serpents
#copyspr 603 -- Father of Serpents
#restrictedgod 85

#end

#newmonster 2240
#copystats 964 -- Lord of Fertility
#copyspr 964 -- Lord of Fertility
#restrictedgod 85

#end

#newmonster 2241
#copystats 979 -- Great White Bull
#copyspr 979 -- Great White Bull
#restrictedgod 85

#end

#newmonster 2242
#copystats 1230 -- Forge Lord
#copyspr 1230 -- Forge Lord
#restrictedgod 85

#end

#newmonster 2243
#copystats 1342 -- Mother of Rivers
#copyspr 1342 -- Mother of Rivers
#restrictedgod 85

#end

#newmonster 2244
#copystats 1343 -- Lady of Love
#copyspr 1343 -- Lady of Love
#restrictedgod 85

#end

#newmonster 2245
#copystats 1371 -- Lord of Rebirth
#copyspr 1371 -- Lord of Rebirth
#restrictedgod 85

#end

#newmonster 2246
#copystats 1348 -- Mother of Serpents
#copyspr 1348 -- Mother of Serpents
#restrictedgod 85

#end

#newmonster 2247
#copystats 874 -- Divine Emperor
#copyspr 874 -- Divine Emperor
#restrictedgod 85

#end


-------- SITES -----------

#newsite 853
#name "Sancta Sophia"
#path 8
#level 0
#rarity 5
#gems 4 2
#gems 1 1
#homecom 2219 -- Theurg Artisan
#homemon 2221 -- Varangian Guard
#homecom 2222 -- Varangian Captain
#end

#newsite 854
#name "Alchemy Guildhouse"
#path 0
#level 2
#rarity 5
#gems 0 1
#gems 2 1
#homemon 2225 -- Pyrote
#homecom 2218 -- Imperial Alchemist
#end



-------- Spells

#newspell -- Copy of "Contact Harbinger". We can't copy it directly as that would also give it to Marignon and vanilla Pythium.
#name "Contact Harbinger"
#effect 10021
#damage 464
#nreff 1
#school 0
#path 0 1
#path 1 4
#pathlevel 0 2
#pathlevel 1 3
#fatiguecost 2800
#researchlevel 5
#restricted 85

#end

#newspell -- Copy of "Angelic Host". We can't copy it directly as that would also give it to Marignon and vanilla Pythium.
#name "Angelic Host"
#effect 10037
#damage 543
#nreff 6
#researchlevel 7
#school 0
#path 0 0
#path 1 4
#pathlevel 0 3
#pathlevel 1 4
#fatiguecost 5500
#restricted 85

#end

#selectspell "Heavenly Wrath"
#restricted 85

#end

#selectspell "Heavenly Choir"
#restricted 85

#end

#newspell
#name "Prayer of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Sealtiel,
the Prayer of the Lord, most serene of the Archangels."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 85

#school 0
#effect 10021
#damage 2229
#nreff 1
#end

#newspell
#name "Healing of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Raphael,
the Healing of the Lord, Archangel of thought and serenity and protector of science and medicine."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 85

#school 0
#effect 10021
#damage 2230
#nreff 1
#end

#newspell
#name "Blessing of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Barachiel,
the Blessing of the Lord. Barachiel is responsible for the distribution of the Lord's blessings, and has dominance over the skies and thunder."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 85

#school 0
#effect 10021
#damage 2231
#nreff 1
#end

#newspell
#name "Glory of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Jegudiel,
Glorifier of the Lord, the serene protector of the arts and of honest labour."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 85

#school 0
#effect 10021
#damage 2232
#nreff 1
#end

#newspell
#name "Man of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Gabriel,
the Man of the Lord, a mighty warrior and divine messenger."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 85

#school 0
#effect 10021
#damage 2233
#nreff 1
#end

#newspell
#name "Light of the Lord"
#descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names
and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl
for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly
ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned in this manner, as the greatest
Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. This spell will call on Uriel,
the Light of the Lord, protector of the sun."
#path 0 4
#path 1 8
#pathlevel 0 5
#pathlevel 1 3
#fatiguecost 5000
#researchlevel 7
#restricted 85

#school 0
#effect 10021
#damage 2234
#nreff 1
#end



-selectspell "Release Lord of Civilization"
-name "Theosis"
-descr "There are thousands upon thousands of Archangels in the Celestial Sphere, but seven of them are so great that mortals know their names and spheres of influence. With this spell, the caster will enter into a month long fast, only sustained by his faith and one magic pearl for each day. After a month of praying and fasting, the caster will be able to lift his conscience to the Celestial sphere and directly ask for the help of one of the seven great Archangels. However, only six Archangels can be summoned with this spell as the greatest Archangel, the Slayer of the Serpent has to guard the Celestial Sphere and will not abandon his task. "
-path 0 4
-path 1 8
-pathlevel 0 5
-pathlevel 1 3
-fatiguecost 5000
-researchlevel 7
-restricted 86
-school 0
-end

#newspell
#copyspell "Holy Avenger"
#name "Epicusdom"
#effect 1
#damage 2235
#nextspell "Divine Blessing"
#school -1
#end

#newspell
#copyspell "Holy Avenger"
#name "Calling of the Seventh"
#descr "This spell will summon the seventh and the most glorious of all Archangels. He resisted the poisonous lies of Belial, withstood the plague wind of Pazazu, endured the heat Buer and persisted under the blows of Belphegor to cast them all to inferno at the dawn of time. He is The Warrior from Heaven, whose mere name is a riddle only the righteous can answer. He is the guardian of the Divine Kingdom and his tasks are great, but still he will come if summoned by this spell to fight for one battle to guard the righteous. The mere presence of the Seventh will fill the battlefield with divine judgement, which will make all demons take twice as much damage from attacks."
#researchlevel 7
#school 0
#path 0 8
#pathlevel 0 7
#damage 83
#effect 81
#nextspell "Epicusdom"
#fatiguecost 0
#spec 128
#restricted 85

#end

#newspell
#copyspell "Poison Touch"
#name "Pyros Poison"
#school -1
#researchlevel 0
#aoe 1
#explspr 10140
#end

#newspell
#name "Alchemist's Flame"
#descr "This spell devised by the Imperial guild of alchemists will shoot a great bolt of pure Pyros towards the enemies of the Empire. Pure and undistilled Pyros is highly toxic and opponents who manage to survive the flames will most likely be poisoned."
#researchlevel 2
#school 2
#path 0 0
#path 1 2
#pathlevel 0 1
#pathlevel 1 1
#damage 1012
#effect 2
#aoe 1
#range 25
#prec -1
#spec 96
#flightspr 10097
#explspr 10051
#nextspell "Pyros Poison"
#fatiguecost 25
#restricted 85

#end


#newspell
#copyspell "Holy Avenger"
#name "Divine Protection"
#descr "This spell will allow the caster and his communion to benefit from divine protection. Their bodies will become hard like stone and will strengthen their minds to be impenetrable by heretical sorcery. Their new divine form will also be greatly resistant to fire, lighting and poison. The divine energies released during the casting of this spell will temper the armors of all nearby friendly soldiers, making them more durable."
#school 8
#researchlevel 0
#path 0 8
#pathlevel 0 5
#damage 83958784
#effect 10
#spec 128
#explspr 10217
#nextspell "Legions of Steel"
#fatiguecost 0
#restricted 85

#end


#newspell
#copyspell "Holy Avenger"
#name "Divine Power"
#descr "This spell will fill the caster and his communion with divine might, increasing their potency in water and fire magic. If there is a storm raging on the battlefield, they will also receive more power in air magic. The divine energies released during the casting of this spell will increase the strength of all units nearby the caster."
#school 8
#researchlevel 0
#path 0 8
#pathlevel 0 6
#damage 794624
#nextspell "Strength of Giants"
#effect 23
#spec 128
#fatiguecost 0
#restricted 85

#end


-----Changes to Ark
#selectspell 34 
#descr "A Divine Wrath has struck this battlefield, either by the artifact Ark or by a holy communion of Pythian Theurgs. For the duration of the battle, all non-sacred units will be smitten with blindness and disease."
#end

#newspell
#copyspell "Holy Avenger"
#name "Divine Wrath"
#descr "This spell will call upon the righteous wrath of the Celestial Sphere on the battlefield. All units that are not sacred followers of the Awakening God will be smitten by blindness and disease as they gaze upon the holy brillance brought forth by this spell. Undead are especially prone disintegrate in front of the divine brilliance."
#school 5
#researchlevel 7
#path 0 8
#pathlevel 0 8
#damage 58
#effect 81
#explspr 10243
#fatiguecost 0
#restricted 85

#end

-------- NATIONS ---------

#selectnation 85

#name "Pythium "
#epithet "The Second Empire"
#era 2
#idealcold 0
#brief "Pythium, The Second Empire"
#descr "The Empire of Pythium is a splinter empire of the great Empire of Ermor. As dark arts were practised in the heart of the Empire, the stars warned the Theurgs of Pythia to flee the impending doom. They led Pythia away from the falling Empire and formed a glorious Second Empire under their wise rule. However, as Ermor crumbled, the provinces of Pythium rebelled and became independent. Emperors of Pythium could not reclaim the rebelling lands and the power of the Second Empire diminished over the centuries. The Pythian army is based on the old legionnaire army of Ermor with some modifications. During the rebellions, barbarians from distant lands tried to conquer the glorious capital, but were beaten back by northern mercenaries hired by the Emperor. With time, these mercenaries have become an integral part of the Pythian military. Theurgs are also supporters of sciences and the famous alchemists of Pythium have recently invented new weapons to fight the legions of the Fallen Empire."
#summary "
Race: Humans

Military: Legionnaires, Northern Mercenaries and Alchemist's Fire

Magic: Astral, Air, Fire, Water and some Earth. 

Priests: Powerful"
#flag "./Byzantine/Byzantine_icon.tga"
#templepic 6
#labcost 500
#templecost 400


---- SITES
#startsite "Sancta Sophia"
#startsite "Alchemy Guildhouse"


---- RECRUITS


#addrecunit 50 -- Slingers
#addrecunit 2210 -- Velite
#addrecunit 685 -- Alae Legionnaire
#addrecunit 2212 -- Hastatus
#addrecunit 2226 -- Principe
#addrecunit 2227 -- Triarius
#addrecunit 2209 -- Battle Vestal
#addrecunit 2223 -- Kataphraktoi
#addrecunit 2224 -- Verdariotai


---- LEADERS

#addreccom 2220 -- Ambassador
#addreccom 2217 -- Cultist
#addreccom 683 -- Centurion
#addreccom 2211 -- Legatus Legionis
#addreccom 538 -- Theurg Communicant
#addreccom 2206 -- Theurg Acolyte
#addreccom 2207 -- Theurg 



----- HEROES


#multihero1 2208 -- Arch Theurg
#hero1 2213 -- Patriarch
#hero2 2214 -- Alchemy Guildmaster
#hero3 2215 -- Man from North



------- STARTING UNITS & PD

#startcom 2228 -- Emperor
#startscout 2220 -- Ambassador
#startunittype1 2221 -- Varangian Guard
#startunitnbrs1 5
#startunittype2 2210 -- Levite
#startunitnbrs2 20


#defcom1 683 -- Centurion
#defcom2 2211 -- Legatus Legionis

#defunit1 2210 -- Velite
#defunit1b 685 -- Alae Legionnaire
#defunit2 2212 -- Hastatus

#defmult1 20  -- 2x Velite per level
#defmult1b 10 -- 1x Alae Legionnaire per level
-- These should be swapped, but I can't get the Alae Legionnaires to appear!


------  FORTS

-- Taken from the manual entries for MA Pythium
#startfort 31 -- Great City
#defaultfort 3 -- Fortified City
#mountainfort 37 -- Hill Fortress
#swampfort 11 -- Swamp Fort
#forestfort 34 -- Forest Fortress

#end





-------------Mod info-----------------------------------------------------------------------------------------

-modname "Haida Gwaii"

#domversion 3.23

-description "The Haida Gwaii mod adds a new playable nation to the early age of Dominions 3. Haida Gwaii is loosely based on the first nations of the northwest pacific coast of North America. This is not meant to be a historical representation of these people and many fantastic fictional ideas are thrown into the mod to round out the nation."

-icon "./haida/haidabanner.tga"

-version 3.0



-------------------------------------Weapons--------------------------------------------------------------------------


Weapons

Haida Atlatl
#newweapon 750
#name "Haida Atlatl"
#ammo 4
#def 0
#flyspr 110 1
#len 4
#nratt 1
#range 20
#twohanded
#sound 19
#end 




-----------------------------------------Aquatic Transformed units--------------------------------------------------------------



#newmonster 3225
#spr1 "./haida/atlatlwater1.tga"
#spr2 "./haida/atlatlwater2.tga"
#name "Sgaana Atlatl Warrior"
#descr "The Sgaana are of the tribe of the Killer Whale. Sgaana Warriors make up the bulk of the Haida forces. They fight with clubs, shields, harpoons or atlatl spears. Sgaana warriors are usually clad in leather or bronze scale armor with crudely crafted iron helms for protection."
#hp 12
#size 2
#prot 3
#mor 11
#mr 10
#enc 3
#str 12
#att 10
#def 9
#prec 10
#mapmove 1
#ap 22
#gcost 14
#rcost 1
#nametype 123
#weapon "Spear"
#armor "Shield"
#armor "Half Helmet"
#amphibian
#landshape 3232
#end

#newmonster 3226
#spr1 "./haida/harpoonwater1.tga"
#spr2 "./haida/harpoonwater2.tga"
#name "Sgaana Harpoon Warrior"
#descr "The Sgaana are of the tribe of the Killer Whale. Sgaana Warriors make up the bulk of the Haida forces. They fight with clubs, shields, harpoons or atlatl spears. Sgaana warriors are usually clad in leather or bronze scale armor with crudely crafted iron helms for protection."
#hp 11
#size 2
#prot 3
#mor 11
#mr 10
#enc 3
#str 12
#att 10
#def 9
#prec 10
#mapmove 1
#ap 22
#gcost 12
#rcost 1
#nametype 123
#weapon "Spear"
#weapon "Harpoon"
#armor "Buckler"
#armor "Half Helmet"
#amphibian
#landshape 3220
#end

Killer Whale (Sgaana Tyee)
#newmonster 3227
#name "Sgaana Tyee"
#spr1 "./haida/killerwhale1.tga"
#spr2 "./haida/killerwhale2.tga"
#descr "It is believed that the great fish carver carved the first killer whales to carry out revenge on his brothers. From the killer whales sprung forth the Sgaana tribe, the most numerous people in Haida Gwaii. Tyee of the Sgaana is a position of great power in the Sgaana tribes. People from all tribes recognize the Tyee as a great wartime leader and navigator. The Sgaana Tyee's presence on the battlefield inspires courage in his fellow warriors. Sgaana Tyees are able to gather slaves during desperate times in order to fill the ranks of the Haida Gwaii army."
#ap 24
#mapmove 3
#hp 70
#prot 8
#size 6
#str 24
#enc 3
#att 12
#def 14
#prec 5
#mr 12
#mor 18
#nametype 123
#animal
#holy
#fear 5
#magicskill 2 2
#magicskill 8 1
#amphibian
#itemslots 12288
#standard 5
#goodleader
#weapon "Bite"
#landshape 3241
#end

Killer Whale (Sgaana Shaman)
#newmonster 3229
#name "Voice of the Killer Whales"
#spr1 "./haida/killerwhale1.tga"
#spr2 "./haida/killerwhale2.tga"
#descr "It is believed that the great Fish Carver carved the first killer whales out of driftwood to carry out revenge on his brother-in-laws. From the killer whales sprung forth the Sgaana tribe, the most numerous people in Haida Gwaii. A young Sgaana is taken to the waters as part of his transition from childhood to manhood. During such a ceremony the killer whales are called. The whales bring offerings of dead seals to the ceremony if they deem the youth worthy enough to become their voice to the tribes. The boy then takes the offerings to the Eternal Potlatch where he is recognized as a Sgaana Shaman, or Voice of the killer whales."
#ap 24
#mapmove 3
#hp 70
#prot 8
#size 6
#str 24
#enc 3
#att 12
#def 14
#prec 5
#mr 12
#mor 18
#nametype 123
#animal
#magicskill 2 5
#magicskill 8 1
#holy
#fear 5
#amphibian
#itemslots 12288
#weapon "Bite"
#landshape 3240
#end

Killer Whale (Fish Carver)
#newmonster 3228
#name "Fish Carver"
#spr1 "./haida/killerwhale1.tga"
#spr2 "./haida/killerwhale2.tga"
#descr "The Fish Carver was the one who created the great killer whales. He did so by carving them from wood to exact revenge on his brothers after they betrayed him. From the killer whales sprang forth the Sgaana tribe of the Haida. The Fish Carver is gifted with a mastery over the elements of water and is able to refine water from the seas into magical gems."
#ap 24
#mapmove 3
#hp 70
#prot 8
#size 6
#str 24
#enc 3
#att 12
#def 14
#prec 5
#mr 12
#mor 18
#nametype 123
#animal
#holy
#magicskill 8 3
#magicskill 2 3
#magicskill 6 1
#gemprod 2 3
#expertleader
#expertmagicleader
#amphibian
#fear 5
#itemslots 12288
#weapon "Bite"
#landshape 3244
#end




------------------------------------------Units----------------------------------------------------




Sgaana Warrior
#newmonster 3232
#name "Sgaana Atlatl Warrior"
#spr1 "./haida/haidasgaanaatlatl1.tga"
#spr2 "./haida/haidasgaanaatlatl2.tga"

#descr "The Sgaana are of the tribe of the Killer Whale. Sgaana Warriors make up the bulk of the Haida forces. They fight with clubs, shields, harpoons or atlatl spears. Sgaana warriors are usually clad in leather or bronze scale armor with crudely crafted iron helms for protection."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 12
#enc 3
#att 10
#def 9
#prec 10
#mr 10
#mor 11
#gcost 14
#rcost 1
#maxage 75
#nametype 123
#itemslots 15494
#amphibian
#weapon 1
#weapon 750
#armor "Full Leather Armor"
#armor "Half Helmet"
#armor "Shield"
#watershape 3225
#end

Eagle Archer
#newmonster 3233
#name "Eagle Archer"
#spr1 "./haida/eaglearcher1.tga"
#spr2 "./haida/eaglearcher2.tga"
#descr "The people of the Eagle Tribe have always been celebrated for their uncanny vision. Their accuracy is unmatched. Therefore most the hunting for the villages are done by the Eagle Archers."
#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 12
#enc 3
#att 10
#def 9
#prec 12
#mr 10
#mor 11
#gcost 10
#rcost 1
#maxage 75
#nametype 123
#itemslots 15494
#weapon 9
#weapon 23
#armor "Leather Cuirass"
#end


Frenzied Moksgmol
#newmonster 3234
#name "Frenzied Moksgmol"
#spr1 "./haida/haidamoksgmol1.tga"
#spr2 "./haida/haidamoksgmol2.tga"
#descr "The Moksgmols are the sacred spirit bears of the Haida. Offerings are exchanged at the Eternal Potlatch in hopes of luring a spirit creature from the forests. The great bears of Haida are the ancestors of the people of the bear clan. In times of need they return to Haida Gwaii to fight side by side with their human descendents."
#ap 16
#mapmove 2
#hp 35
#prot 6
#size 4
#str 20
#enc 2
#att 12
#def 9
#prec 5
#mr 12
#mor 14
#gcost 0
#rcost 1
#nametype 123
#ethereal
#berserk 4
#animal
#trample
#regeneration 20
#forestsurvival
#holy
#heal
#noitem
#weapon 33
#end

Coyote
#newmonster 3235
#name "Coyote"
#spr1 "./haida/haidacoyote1.tga"
#spr2 "./haida/haidacoyote2.tga"
#descr "The Coyote is a sacred spirit animal of the Haida. Offerings are exchanged at the Eternal Potlatch in hopes of luring a spirit creature from the forests. The cunning coyotes are the ancestors of the people of the Coyote clan. In times of need they return to Haida Gwaii to fight side by side with their human descendents. Coyotes are natural mischief makers who are able to increase turmoil in the provinces they dwell."
#ap 26
#mapmove 3
#hp 8
#prot 2
#size 1
#str 8
#enc 2
#att 12
#def 11
#prec 5
#mr 5
#mor 12
#gcost 25
#rcost 2
#maxage 20
#startage 7
#nametype 123
#incunrest 1
#stealthy 10
#animal
#forestsurvival
#noitem
#holy
#ethereal
#weapon 33
#weapon 20
#end







Raven
#newmonster 3219
#name "Raven"
#copyspr 517
#descr "The Raven is a sacred spirit animal of the Haida. Offerings are exchanged at the Eternal Potlatch in hopes of luring a spirit creature from the forests. Ravens are lured back to Haida Gwaii by ceremonies held at the Eternal Potlatch. They serve as scouts during times of war."
#ap 6
#mapmove 3
#hp 14
#prot 2
#size 1
#str 12
#enc 3
#att 11
#def 10
#prec 14
#mr 5
#mor 12
#gcost 10
#rcost 1
#nametype 123
#okleader
#animal
#stealthy 20
#forestsurvival
#flying
#itemslots 12288
#startage 4
#maxage 50
#weapon "Claws"
#end

Sgaana Warrior
#newmonster 3220
#name "Sgaana Harpoon Warrior"
#spr1 "./haida/haidaharpoon1.tga"
#spr2 "./haida/haidaharpoon2.tga"
#descr "The Sgaana are of the tribe of the Killer Whale. Sgaana Warriors make up the bulk of the Haida forces. They fight with clubs, shields, harpoons or atlatl spears. Sgaana warriors are usually clad in leather or bronze scale armor with crudely crafted iron helms for protection."
#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 12
#enc 3
#att 10
#def 9
#prec 10
#mr 10
#mor 11
#gcost 12
#rcost 4
#maxage 75
#nametype 123
#itemslots 15494
#amphibian
#weapon "Spear"
#weapon "Harpoon"
#armor "Full Leather Armor"
#armor "Half Helmet"
#armor "buckler"
#watershape 3226
#end



Raven Warrior
#newmonster 3222
#name "Raven Warrior"
#spr1 "./haida/ravenwarrior1.tga"
#spr2 "./haida/ravenwarrior2.tga"
#descr "The Raven clan produce the best scouts of Haida Gwaii. Their men grow up to be cunning stealthy warriors that can scout and infiltrate enemy lands. Often they work together with ravens to ambush Haida enemies. Raven archers are not as accurate as Eagle archers, but they can move through the forest unnoticed."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 12
#prec 10
#mr 10
#mor 11
#gcost 12
#rcost 1
#maxage 75
#nametype 123
#itemslots 15494
#weapon "Spear"
#armor "Leather Hauberk"
#armor "Half Helmet"
#stealthy 15
#end

Raven Archer
#newmonster 3223
#name "Raven Archer"
#spr1 "./haida/ravenarcher1.tga"
#spr2 "./haida/ravenarcher2.tga"
#descr "The Raven clan produce the best scouts of Haida Gwaii. Their men grow up to be cunning stealthy warriors that can scout and infiltrate enemy lands. Often they work together with ravens to ambush Haida enemies. Raven archers are not as accurate as Eagle archers, but they can move through the forest unnoticed."
#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 12
#prec 10
#mr 10
#mor 11
#gcost 12
#rcost 1
#maxage 75
#nametype 123
#itemslots 15494
#weapon 9
#weapon 23
#stealthy 15
#armor "Leather Cuirass"
#end


Bear Warrior
#newmonster 3224
#name "Bear Warrior"
#spr1 "./haida/bearwarrior1.tga"
#spr2 "./haida/bearwarrior2.tga"
#descr "The Bear tribe having incredible regenerating powers that allow them to quickly recover from wounds. The are considered the strongest warriors of the Haida people and their exploits on the battlefield are often passed on to the next generation through oral traditions. Bear tribe warriors would rather crush their enemies with blunt weapons instead of skewering them with a thrusting spear. Bear tribe members spend much of their time in the caves with their patron animal, learning to fight bravely and the healing arts the bears are willing to teach."
#ap 12
#mapmove 2
#hp 13
#prot 0
#size 2
#str 13
#enc 3
#att 12
#def 9
#prec 10
#mr 10
#mor 13
#gcost 16
#rcost 1
#maxage 75
#nametype 123
#itemslots 15494
#ambidextrous 3
#heal
#regeneration 20
#darkvision 50
#weapon "Club"
#weapon "Club"
#armor "Full Leather Armor"
#armor "Half Helmet"
#end

---------------------Commanders----------------------------------------------------------------------------


Raven
#newmonster 3236
#name "Raven Scout"
#copyspr 517
#descr "The Raven is a sacred spirit animal of the Haida. Offerings are exchanged at the Eternal Potlatch in hopes of luring a spirit creature from the forests. Ravens are lured back to Haida Gwaii by ceremonies held at the Eternal Potlatch. They serve as scouts during times of war."
#ap 6
#mapmove 3
#hp 16
#prot 2
#size 1
#str 12
#enc 3
#att 11
#def 10
#prec 14
#mr 8
#mor 14
#gcost 60
#rcost 1
#holy
#nametype 123
#poorleader
#animal
#stealthy 20
#magicskill 1 1
#custommagic 4096 10
#forestsurvival
#flying
#itemslots 12288
#startage 8
#maxage 50
#weapon "Claws"
#end

Bear Tyee
#newmonster 3237
#name "Bear Tyee"
#spr1 "./haida/haidabeartyee1.tga"
#spr2 "./haida/haidabeartyee2.tga"
#descr "The Bear Tyee is a leader of the Bear tribes of Haida Gwaii. The bear is a great practicioner of the healing arts, and some of that skill is passed to the Bear Tyee. He is able to regenerate and recover from wounds inflicted during battle. Bear Tyees are considered sacred to the tribes, and they lead the armies of Haida Gwaii into battle. Bear Tyees are able to gather slaves during desperate times in order to fill the ranks of the Haida Gwaii army."
#ap 12
#mapmove 2
#hp 16
#prot 0
#size 2
#str 13
#enc 3
#att 12
#def 10
#prec 11
#mr 10
#mor 14
#gcost 120
#rcost 1
#nametype 123
#itemslots 15494
#magicskill 3 1
#magicskill 6 1
#darkvision 50
#holy
#regeneration 25
#recuperation
#okleader
#heal
#maxage 75 
#weapon "Club"
#armor "Hide Shield"
#armor "Furs"
#end


Coyote Mother
#newmonster 3238
#name "Coyote Mother"
#spr1 "./haida/haidacoyotemother1.tga"
#spr2 "./haida/haidacoyotemother2.tga"
#descr "The most cunning women of the Coyote tribe become Coyote Mothers. They are gifted in the arts of stealth and mischief. The Coyote Mother is able to blend into her surroundings, making her very difficult to find if she does not wish to be seen. Her connection to the sacred coyote places her half in this world, and half in the spirit world."
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 13
#prec 12
#mr 15
#mor 12
#gcost 190
#rcost 1
#nametype 124
#itemslots 15494
#holy
#stealthy 0
#etheral
#illusion
#magicskill 6 2
#magicskill 4 1
#magicskill 8 1
#custommagic 10240 10
#poorleader
#poormagicleader
#female
#maxage 78
#weapon "Fist"
#end

Eagle Talon
#newmonster 3239
#name "Eagle Talon"
#spr1 "./haida/haidaeagleshaman1.tga"
#spr2 "./haida/haidaeagleshaman2.tga"
#descr "The Eagle Talon is one of the great shamans of the Haida tribes. A member of the Eagle tribe becomes a Shaman if he receives spirit visions during his childhood. He is fostered by the Eagle Talons and taught in the ways of magic, particularly dealing with the forces of wind and nature."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 14
#mr 15
#mor 10
#gcost 325
#rcost 1
#nametype 123
#itemslots 15494
#holy
#shockres 50
#magicskill 1 3
#magicskill 6 1
#magicskill 8 1
#custommagic 8960 100
#poorleader
#okmagicleader
#maxage 80
#older -8
#weapon "Club"
#armor "Hide Shield"
#armor "Furs"
#end


Sgaana Shaman
#newmonster 3240
#name "Voice of the Killer Whales"
#spr1 "./haida/haidasgaanashaman1.tga"
#spr2 "./haida/haidasgaanashaman2.tga"
#descr "It is believed that the great Fish Carver carved the first killer whales out of driftwood to carry out revenge on his brother-in-laws. From the killer whales sprung forth the Sgaana tribe, the most numerous people in Haida Gwaii. A young Sgaana is taken to the waters as part of his transition from childhood to manhood. During such a ceremony the killer whales are called. The whales bring offerings of dead seals to the ceremony if they deem the youth worthy enough to become their voice to the tribes. The boy then takes the offerings to the Eternal Potlatch where he is recognized as a Sgaana Shaman, or Voice of the killer whales."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 15
#mor 10
#gcost 275
#rcost 1
#nametype 123
#itemslots 15494
#holy
#amphibian
#magicskill 2 3
#magicskill 6 1
#magicskill 8 1
#custommagic 8960 100
#poorleader
#poormagicleader
#maxage 80
#researchbonus 1
#older -10
#weapon "Club"
#armor "Hide Shield"
#amor "Furs"
#watershape 3229
#end

Sgaana Tyee
#newmonster 3241
#name "Sgaana Tyee"
#spr1 "./haida/haidasgaanatyee1.tga"
#spr2 "./haida/haidasgaanatyee2.tga"
#descr "It is believed that the great fish carver carved the first killer whales to carry out revenge on his brothers. From the killer whales sprung forth the Sgaana tribe, the most numerous people in Haida Gwaii. Tyee of the Sgaana is a position of great power in the Sgaana tribes. People from all tribes recognize the Tyee as a great wartime leader and navigator. The Sgaana Tyee's presence on the battlefield inspires courage in his fellow warriors. Sgaana Tyees are able to gather slaves during desperate times in order to fill the ranks of the Haida Gwaii army."
#ap 12
#mapmove 2
#hp 13
#prot 0
#size 2
#str 10
#enc 3
#att 12
#def 12
#prec 11
#mr 10
#mor 14
#gcost 100
#rcost 1
#nametype 123
#itemslots 15494
#magicskill 8 1
#magicskill 2 1
#sailing
#standard 5
#goodleader
#maxage 75
#startage 45
#amphibian
#holy
#weapon "Sceptre"
#watershape 3227
#end


Kachina
#newmonster 3247
#name "Kachina"
#spr1 "./haida/haidakachina1.tga"
#spr2 "./haida/haidakachina2.tga"
#descr "Kachinas are Haida messengers from the spirit realm. Their innate ability of flight and their devotion to the people of Haida Gwaii has earned them a sacred position in society. Kachinas are said to be born in the clouds and are at home amongst them as a Sgaana is amongst the waves. All Kachinas have an inborn mastery of air magic and therefore are immune to lightning. Some Kachinas are lured by the mysteries of nature and it is not uncommon for them to dabble in nature magic. Kachinas are able to call upon Thunderbirds to serve Haida Gwaii."
#mapmove 3
#hp 9
#prot 0
#size 2
#str 9
#enc 3
#att 9
#def 13
#prec 12
#mr 15
#mor 13
#gcost 215
#rcost 1
#nametype 124
#itemslots 13446
#holy
#magicskill 1 2
#custommagic 8448 100
#magicskill 8 1
#poorleader
#poormagicleader
#shockres 100
#poisonres 100
#ethereal
#female
#flying
#maxage 550
#makemonster1 3249
#stormpower 2
#weapon "Fist"
#end




















----------------------------------------------------------------------Summons--------------------------------



Thunderbird
#newmonster 3249
#name "Thunderbird"
#spr1 "./haida/thunderbird1.tga"
#spr2 "./haida/thunderbird2.tga"
#descr "High above the ground, the thunderbirds reside in the clouds. The beating of their wings causes the thunder during storms. Kachinas can call upon the aid of these magical creatures should the need arise. Thunderbirds attack their foes with their electric talons and are completely immune to lightning. If a thunderbird dies in friendly dominion, it will return to the clouds reformed, to fight another day."
#ap 6
#mapmove 3
#hp 10
#prot 0
#size 2
#str 12
#enc 3
#att 10
#def 10
#prec 5
#mr 12
#mor 12
#nametype 123
#stormpower 1
#animal
#magicbeing
#flying
#noitem
#shockres 100
#immortal
#holy
#weapon "Lightning Swarm"
#end



Wild Turkey
#newmonster 3231
#name "Wild Turkey"
#copyspr 1362
#descr "Wild turkeys are summoned from the forests of Haida Gwaii to feed the armies during times of war. Wild Turkeys summoned in such a manner are blessed with the gift of immortality. Once eaten, they arise again to feed the army the next day."
#ap 6
#mapmove 3
#hp 8
#prot 0
#size 1
#str 6
#enc 3
#att 8
#def 9
#prec 8
#mr 10
#mor 7
#nametype 123
#animal
#flying
#noitem
#supplybonus 10
#immortal
#weapon "Beak"
#end


Salmon Shark
#newmonster 3254
#name "Salmon Shark"
#copyspr 816
#descr "Salmon Sharks are ferocious predators of the seas surrounding Haida Gwaii. During the salmon spawning season, these dangerous creatures roam the shoreline in packs looking to feast on salmon or any other potential prey they can tackle. They have a natural tolerance to the cold waters of the region. The shamans of Haida Gwaii have learned rituals to summon and tame these wild predators for use against enemies."
#ap 22
#mapmove 3
#hp 42
#prot 6
#size 6
#str 18
#enc 3
#att 10
#def 9
#prec 5
#mr 4
#mor 16
#nametype 123
#animal
#stealthy 0
#aquatic
#itemslots 12288
#coldres 50
#weapon "Bite"
#end


Killer Whale
#newmonster 3230
#name "Killer Whale"
#spr1 "./haida/killerwhale1.tga"
#spr2 "./haida/killerwhale2.tga"
#descr "Killer Whales are the ancestors of the Sgaana tribe of Haida Gwaii. They are very large, very quick and very dangerous. Killer Whales are sacred and can be blessed."
#ap 24
#mapmove 3
#hp 70
#prot 8
#size 6
#str 24
#enc 3
#att 12
#def 14
#prec 5
#mr 12
#mor 18
#nametype 123
#animal
#holy
#fear 5
#aquatic
#itemslots 12288
#weapon "Bite"
#end









----National Heroes------------------------------------------------------------------------------------









Lady Hanging Hair
#newmonster 3242
#name "Lady Hanging Hair"
#spr1 "./haida/haidaladyhanginghair1.tga"
#spr2 "./haida/haidaladyhanginghair2.tga"
#descr "Lady Hanging Hair is a guardian of the Haida tribes. Concerned about the evil spirits that inhabit the great whirlpool known as the Upside Down Place, she has come to the Eternal Potlatch from her forest home. She seeks the help of the new god to stop the evil spirits and make her people safe."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 12
#prec 12
#mr 15
#mor 14
#nametype 124
#itemslots 15494
#stealthy 0
#holy
#supplybonus 20
#magicskill 6 2
#magicskill 2 2
#magicskill 4 2
#awe 1
#poorleader
#poormagicleader
#female
#maxage 2000
#weapon "Fist"
#end

Mother Bear
#newmonster 3243
#name "Mother Bear"
#spr1 "./haida/haidamotherbear1.tga"
#spr2 "./haida/haidamotherbear2.tga"
#descr "Mother Bear was once of the Haida tribes. While she was out gathering berries, she was taken by bears and became one of them. While she was prisoner, she learned the arts of healing from the bears of the forest. Liberated by her brothers, Mother Bear has returned to the Sgaana people to help guide them in these uncertain times."
#ap 16
#mapmove 2
#hp 35
#prot 6
#size 3
#str 18
#enc 2
#att 12
#def 10
#prec 10
#mr 15
#mor 14
#nametype 124
#holy
#regeneration 20
#heal
#healer 25
#magicskill 6 5
#poorleader
#poormagicleader
#itemslots 12288
#animal
#female
#maxage 78
#weapon 33
#end

Fish Carver
#newmonster 3244
#name "The Fish Carver"
#spr1 "./haida/haidafishcarver1.tga"
#spr2 "./haida/haidafishcarver2.tga"
#descr "The Fish Carver was the one who created the great killer whales. He did so by carving them from wood to exact revenge on his brothers after they betrayed him. From the killer whales sprang forth the Sgaana tribe of the Haida. The Fish Carver is gifted with a mastery over the elements of water and is able to refine water from the seas into magical gems."
#ap 12
#mapmove 2
#hp 13
#prot 0
#size 2
#str 11
#enc 3
#att 12
#def 12
#prec 10
#mr 10
#mor 14
#nametype 123
#itemslots 15494
#amphibian
#magicskill 8 3
#magicskill 2 2
#magicskill 6 1
#stealthy 0
#holy
#maxage 75
#gemprod 2 2
#expertleader
#expertmagicleader
#amphibian
#weapon "Dagger"
#watershape 3228
#end


#newmonster 3221
#copystats 1194
#copyspr 1194
#name "Voice of the Heavens"
#descr "The Voice of the Heavens is a Couatl of tremendous influence. He is the voice that represents the will of the ascending God. He is sacred to the people of Haida Gwaii and inspires them to great deeds in combat. The Voice of the Heavens is always accompanied by many amphipteres who protect him from harm."
#domsummon20 1412
#awe 3
#end





















-----Pretenders-----------------------------------------------------------------------------------



Raven
#newmonster 3245
#name "Great Raven"
#spr1 "./haida/haidaraven1.tga"
#spr2 "./haida/haidaraven2.tga"
#descr "When the last Pantokrator still ruled the lands, he captured the Sun and the Moon and exercised full control over them. When the Pantokrator had fallen, the Great Raven stole the Sun and the Moon during the chaos, and returned them to the peoples of the world. The Great Raven is a trickster by nature and is able to instill uprisings in enemy territories. Through his great deeds, the Great Raven believes he has earned the right to lead the people and ascend as the one true god."
#ap 8
#mapmove 3
#hp 50
#prot 7
#size 6
#str 18
#enc 3
#att 12
#def 11
#prec 14
#mr 16
#mor 30
#gcost 75
#nametype 123
#restrictedgod 72

#flying
#etheral
#stealthy 20
#startdom 2
#pathcost 50
#magicskill 1 2
#magicskill 6 1
#shockres 100 
#spy
#goodleader
#goodmagicleader
#itemslots 12288
#maxage 5000
#weapon "Beak"
#weapon "Talons"
#end


Crest Pole
#newmonster 3246
#name "Crest Pole"
#spr1 "./haida/haidatotem1.tga"
#spr2 "./haida/haidatotem2.tga"
#descr "The Crest Pole plays a crucial role in Haida Gwaii culture. Inside the Crest Pole resides the spirits of the past. The spirits indirectly influence the people of Haida Gwaii through dreams and sacred visions. The will of the Crest Pole and the residing spirits is carried out by people who receive such a vision or dream. The Crest Pole cannot move or fight, though it would be very difficult to destroy."
#ap 2
#mapmove 0
#hp 180
#prot 25
#size 6
#str 15
#enc 0
#att 5
#def 0
#prec 5
#mr 18
#mor 30
#gcost 75
#nametype 123
#restrictedgod 72

#startdom 4
#pathcost 40
#expertleader
#expertmagicleader
#blind
#lifeless
#magicskill 1 1
#magicskill 6 1
#magicskill 2 1
#neednoteat
#amphibious
#poisonres 100
#itemslots 28672
#immobile
#inanimate
#maxage 5000
#end




-----Existing Pretenders------

#newmonster 3248
#name "Collosal Head"
#copystats 958
#copyspr 958
#restrictedgod 72

#end


#newmonster 3250
#name "Great Mother"
#copystats 606
#copyspr 606
#restrictedgod 72

#end

#newmonster 3251
#name "Divine Serpent"
#copystats 779
#copyspr 779
#restrictedgod 72

#end

#newmonster 3252
#name "Lady of Springs"
#copystats 1370
#copyspr 1370
#restrictedgod 72

#end

#newmonster 3253
#name "Dagon"
#copystats 109
#copyspr 109
#restrictedgod 72

#end













-------Spells---------------------------------------------------------------------------------

#newspell
#name "Call Thunderbirds"
#descr "A great shout is raised to the heavens, calling forth magical thunderbirds to aid Haida Gwaii."
#school 0
#researchlevel 3
#path 0 1 
#pathlevel 0 2
#path 1 6
#pathlevel 1 1
#effect 10001
#nreff 1000
#fatiguecost 1000
#damage 3249
#restricted 72

#end 


#newspell
#name "Great Feast of the Forest"
#descr "A flock of wild turkeys are summoned to feed the army of Haida Gwaii. These turkeys differ from ordinary turkeys, they are enchanted with the gift of immortality, able to be eaten, and arise the next day anew."
#school 0
#researchlevel 0
#path 0 6 
#pathlevel 0 1
#effect 10001
#nreff 5
#fatiguecost 1200
#damage 3231
#restricted 72

#end 

#selectspell "Summon Monster Toad"
#restricted 72

#end

#selectspell "Contact Couatl"
#restricted 72

#end


#newspell
#name "Bear Spirits"
#descr "A group of Spirit Bears are beckoned to the Potlatch with gifts befitting the ancestors."
#school 0
#researchlevel 1
#path 0 6
#pathlevel 0 1
#effect 10001
#nreff 1001
#fatiguecost 1200
#damage 3234
#restricted 72

#end 


#newspell
#name "Frenzy of the Deep"
#descr "A school of Salmon Sharks are lured to the shoreline with offerings of freshly killed fish. The Shamans of Haida Gwaii are able to control these ferocious predators and use them against enemies."
#school 0
#researchlevel 2
#path 0 2
#pathlevel 0 1
#path 1 6
#pathlevel 1 1 
#effect 10001
#nreff 6
#fatiguecost 2000
#damage 3254
#spec 41943040
#restricted 72

#end 

#newspell
#name "Sgaana"
#descr "A killer Whale is called to fight for Haida Gwaii."
#school 0
#researchlevel 4
#path 0 2
#pathlevel 0 3
#effect 10001
#nreff 1
#fatiguecost 800
#damage 3230
#spec 41943040
#restricted 72

#end 

#newspell
#name "Coyotes"
#descr "The shaman gives a great howl towards the moon, beckoning coyotes to come and aid his cause."
#school 0
#researchlevel 0
#path 0 6
#pathlevel 0 1
#effect 10001
#nreff 1002
#fatiguecost 1000
#damage 3235
#restricted 72

#end 

---------------Magic Sites------------------------------------------------------------------

#newsite 803
#name "The Eternal Potlatch"
#path 6
#level 3
#rarity 5
#gems 6 2
#gems 1 2
#gems 2 2
#homecom 3240
#homecom 3239
#end


----------Nation-------------------------------------------------------------------------------

#selectnation 72

#name "Haida Gwaii"
#epithet "Reunified Tribes"
#era 1
#descr "Haida Gwaii was originally an island nation that was scattered and crushed during the reign of the last pantokrator. Since the fall of the old god, the tribes have been reunified under the rule of a new leader that shall ascend to godhood, casting down the pretenders of this world. A tribal hierarchy exists in Haida Gwaii. Each tribe's culture is based upon the animal that gave birth to their people. The Sgaana is by far the most numerous tribe now, but all tribes are equal when it comes to leadership. The Haida worship ancient spirits that represent the elements of air and water. Over the years they have cultivated a strong relationship with nature and the animals that gave birth to their people. At the center of Haida culture is the Eternal Potlatch. At the crest pole daily ceremonies are held where the tribes exchange gifts and offer tribute to their animal ancestors. Sacred animals are lured to the Potlatch to protect their descendents in this great time of need."


#summary "Race: Humans, Prefer cold 1"


#brief "Haida Gwaii is a nation of unified tribes that represent their animal ancestors. They have powerful animal allies and shamans."

#flag "./haida/haidaflag2.tga"

#color 0.1 0.5 0.5

#clearrec
#clearsites


#addrecunit 3219
#addrecunit 3220
#addrecunit 3232
#addrecunit 3233
#addrecunit 3222
#addrecunit 3223
#addrecunit 3224

#addreccom 3236
#addreccom 3241
#addreccom 3237
#addreccom 3238
#addreccom 3247


#defcom1 3237
#defcom2 3238
#defunit1 3220
#defunit1b 3232
#defunit2 3233
#defunit2b 3230
#defmulti1 20
#defmulti1b 10
#defmulti2 10
#defmulti2b 20

#hero1 3242
#hero2 3243
#hero3 3244
#hero4 3221

#idealcold 1

#startcom 3237
#startscout 3236

#startsite "The Eternal Potlatch"

#startunittype1 3220
#startunitnbrs1 15
#startunittype2 3232
#startunitnbrs2 15

#templepic 5
#startfort 3
#defaultfort 20
#farmfort 1
#mountainfort 39
#forestfort 33
#swampfort 39
#uwfort 12

#end



-modname "LA Nation: Ulm Reborn"
-description "Adds the LA nation New Ulm, Iron Faith Reborn. By Sombre."
-icon "./Ulm Reborn/logo.tga"
-version 1.9

-- version 1.9

-- FIX - remapped IDs to be MC compliant

-- TWEAK - host of the aufklarung now requires prophet to cast, like Sturmheld

-- TWEAK - Hoch-hammer cheaper by 20 gold


-- version 1.8

-- FIX - Removed ID conflicts with CBM 1.6

-- TWEAK - added generic scout commander


-- version 1.7

-- TWEAK - Sturmheld and Sternheld now H1 priests

-- TWEAK - White Priests no longer martial leaders

-- FIX - Fixed Host of Aufklarung cost

-- TWEAK - Gave Black Steel Helmet and Black Steel Kite Shield to appropriate commanders

-- TWEAK - Added the CBM Warhorse hoof and used it for cavalry units instead of hoof. I agree with that CBM change and want to unify this vanilla mod and the CBM version

-- TWEAK - Removed armour piercing from spirit Hammers and reduced damage, making them useful almost only against demons and undead, which is fine

-- TWEAK - Removed some of the copystatting



--- version 1.6

-- FIX - Gave Reborn Lord a helment

-- TWEAK - Increased precision for punish the unjust spell



--- Version 1.5 - ready for 3.15 patch

-- Several changes to descriptions and flavour, based on 3.15 update to MA and LA Ulm

-- Checked for conflicts against CBM1.21, LA Jomon Broken

-- White Priests no longer attract penitent

-- Black Priests given more chance of E2, differentiated from regular Ulm Black Priests a bit, no forgebonus here

-- Neugeboren Lord and troops stats tweaked, given new White Halberd weapon, a counterpart to the new Guardians of MA Ulm

-- Forgebonus of white priests up to 15, same as black priests of LA Ulm

-- Hoch-Hammer leadership reduced

-- Production bonus in all forts reduced to 20%

-- Stern/Sturmheld get better mr

-- Sturmheld only summonable by H4, ie prophet

-- An extra gem for 4 gems standard LA starting income

-- Sternkind get plate cuirass armour

-- Added new Host of the Aufklarung mass Sternkind summon

-- Changed White Hammer into more of a holy weapon

-- Reduced black zwei gcost to 14




------ ID slots

--Nation 84

--Weapons 623-7, 710 (hoof from cbm, doesn't matter if it conflicts with cbm)

--Armour 321

--Monsters 3293-3319

--Sites 970-3




-------- New Weapons

-- Borrowed CBM1.3 Warhorse Hoof -- this will cause a conflict with cbm, but that's ok the weapons are identical

#newweapon 710
#name "Warhorse Hoof"
#dmg 12
#att 2
#def 0
#len 0
#bonus
#nostr
#end


-- Sternhammer

#newweapon 627
#name "Sternhammer"
#twohanded
#magic
#dmg 7
#att 1
#def 0
#len 3
#sound 11
#rcost 10
#secondaryeffect 232
#end

-- White Hammer

#newweapon 626
#name "White Hammer"
#magic
#dmg 9
#att 2
#def 1
#len 2
#sound 11
#rcost 8
#secondaryeffectalways 276
#end


-- Spirit Hammers

#newweapon 625
#name "Spirit Hammers"
#ammo 1
#dt_holy
#att 1
#magic
#def 0
#dmg 12
#nostr
#flyspr 411 4
#explspr 10220
#nratt 10
#range 50
#rcost 10
#sound 24
#end

-- Absolver Hammer

#newweapon 624
#name "Absolver Hammer"
#magic
#dmg 9
#att 2
#def 1
#len 2
#sound 11
#rcost 1
#secondaryeffect 171
#end


-- White Halberd

#newweapon 623
#name "White Halberd"
#dt_holy
#dmg 10
#att 0
#def 0
#len 4
#rcost 5
#end


-------- New Armour

#newarmor 321
#name "Whitesteel Plate"
#type 5
#prot 22
#def -3
#enc 4
#rcost 26
#end


-------- Units


--PRETENDERS

--Lord of War

#newmonster 3317

#copyspr 1340

#copystats 1340

#restrictedgod 86

#end

--Forge Lord

#newmonster 3318
#copyspr 1230
#copystats 1230
#restrictedgod 86


#end

--Virtue

#newmonster 3319
#copyspr 215

#copystats 215

#restrictedgod 86


#end

--Sacred Statue

#newmonster 3299
#copyspr 472

#copystats 472

#restrictedgod 86

#end


--UNITS

--Penitent

#newmonster 3293
#copyspr 217
#name "Penitent"
#descr "Since the Aufklarung, the Iron Faith offers all a chance for rebirth and many who have fallen from the path of righteousness flock to receive the blessing of the priests, joining a classless force in society known as the penitent. They make for rabid fighters and their devotion to the Iron Faith grants them impressive strength but they are not well protected or trained and do not have the lasting power of professional soldiers."
#str 11
#weapon "flail"
#hp 11
#holy
#mor 15
#mr 9
#att 9
#def 9
#ap 12
#prec 8
#enc 3
#gcost 10
#rcost 1
#mapmove 2
#size 2
#nametype 104
#end


--Emergent

#newmonster 3313
#copyspr 217
#name "Emergent"
#descr "The Emergent are Penitent newly released from an anchorite struck open in battle. Reborn into chaos and violence they are filled with fanatical devotion to the Iron Faith and are temporarily charged with spiritual energy lending them great strength and resilience."
#str 14
#weapon "flail"
#hp 15
#prot 5
#holy
#mor 99
#mr 9
#att 9
#def 9
#ap 12
#prec 8
#enc 3
#gcost 8
#rcost 1
#mapmove 2
#size 2
#nametype 104
#firstshape 3293
#end


-- Infantry of Ulm

#newmonster 3300
#copyspr 73
#name "Infantry of Ulm"
#descr "Although blacksteel armour has become increasingly harder to manufacture since the Civil War the basic infantry of Ulm are still well armoured with heavy chainmail and are well protected from missile fire by their traditional tower shields. Their favoured weapon is the hammer, symbol of the will of the Awakening God and a reforged Ulm."
#hp 12
#mr 8
#str 11
#gcost 10
#mapmove 1
#weapon "Hammer"
#armor "Full Chain Mail"
#armor "Half Helmet"
#armor "Tower Shield"
#nametype 104
#enc 3
#end


-- Crossbow of Ulm

#newmonster 3301
#copyspr 417
#name "Crossbow of Ulm"
#descr "The old arbalest design fell out of favour during the long years of the civil war as it took too much training and maintenance to be of use. Modern Ulmish missile support comes from rugged and easily repaired crossbows used by well armoured troops."
#str 11
#hp 12
#gcost 10
#mapmove 1
#att 9
#def 9
#mr 8
#enc 3
#weapon "Short Sword"
#weapon "Crossbow"
#armor "Plate Cuirass"
#armor "Iron Cap"
#nametype 104
#end


-- Pike of Ulm

#newmonster 3302
#copyspr 79
#name "Pike of Ulm"
#descr "Pike form defensive blocks in the Ulmish army which grind down the enemy and allow time for the priests and templars to smite their blackhearted foes."
#str 11
#hp 12
#gcost 10
#mapmove 1
#mor 11
#mr 8
#enc 3
#weapon "Pike"
#armor "Full Chain Mail"
#armor "Half Helmet"
#nametype 104
#end


-- Black Zweihander

#newmonster 3303
#spr1 "./Ulm Reborn/Black Zwei.tga"
#spr2 "./Ulm Reborn/Black Zwei2.tga"
#name "Black Zweihander"
#descr "These elite infantry are named after the massive two handed swords they wield in combat. They are the only troops in the regular Ulmish army who are granted the prized blacksteel armour and as such they are very well protected. Their only weakness is that they can tire out if drawn into a long grinding battle. They are therefore best used as heavy shock infantry."
#hp 13
#mor 12
#mr 8
#str 11
#att 11
#def 11
#mapmove 1
#armor "Full Plate of Ulm"
#armor "Full Helmet"
#weapon "Great Sword"
#gcost 14
#enc 3
#nametype 104
#end


-- Anchorite

#newmonster 3304
#copyspr 76
#name "Anchorite"
#descr "Just as the Aufklarung saved Ulm from itself, so shall criminals, madmen and heretics be given the blessing of rebirth. Anchorites are blessed suits of blacksteel armour which have been animated by the Black Priests and into which a fallen individual is sealed. These suits then march to battle armed with great two handed warhammers, smiting the enemies of Ulm left and right. Though extremely resistant to damage, the anchorites are slow and the spells that animate them are easily disrupted; they are inevitably struck down, but when they fall the occupant is released and, thus reborn, battles on with great fervour. As a fusion of cold emotionless steel and raging devotion they epitomise modern Ulm. Anchorites require a member of the new Iron Faith to direct them."
#holy
#inanimate
#magicbeing
#coldres 50
#fireres 50
#poisonres 50
#neednoteat
#hp 5
#ap 10
#mor 50
#mr 10
#enc 0
#str 15
#gcost 22
#secondshape 3313
#nametype 104
#startage 25
#maxage 80
#mapmove 1
#weapon "Maul"
#armor "Full Plate of Ulm"
#armor "Full Helmet"
#end


-- Black Templar

#newmonster 3305
#copyspr 738
#name "Black Templar"
#descr "The elite order of the Black Knights was very nearly wiped out by the Civil War. The few that survived the years of continuous conflict were dispersed and found themselves working for one local lord or another as mercenaries or petty vassals. The glory and honour of their past order seemed lost forever, but all that was changed by the descent of the Aufklarung. The scattered knights felt a power pulling their very souls towards the capital and were unable to resist. They gathered at the Black Temple and as one they vowed to serve the new Iron Faith as the Black Templars."
#holy
#size 3
#ressize 2
#rcost 7
#mor 15
#hp 15
#str 13
#att 12
#def 12
#gcost 80
#mapmove 2
#ap 18
#mr 10
#enc 5
#weapon "hammer"
#weapon "lance"
#weapon 710
#armor "Full Plate of Ulm"
#armor "Full Helmet"
#armor "Kite Shield"
#mounted
#nametype 104
#end


-- Neugeboren Guard

#newmonster 3306
#name "Neugeboren Guard"
#descr "The Neugeboren, or reborn, are an elite force formerly known as the Guardians. During the Civil War they repulsed all attempts to storm the Keep of Ulm, but found themselves trapped and starving. With all hope of relief gone, their legendary morale began to crumble and dark thoughts accompanied the sharp claws of hunger, assaulting their minds. On the edge of mental and physical collapse, they were saved only by the descent of the Aufklarung. The Civil War ended almost immediately and when the Guardians emerged it was clear they had become more than mere men. Their black halberds and armour have been symbolically replaced with blessed whitesteel arms and they are sacred to the people of Ulm."
#spr1 "./Ulm Reborn/Reborn Guard.tga"
#spr2 "./Ulm Reborn/Reborn Guard2.tga"
#hp 14
#prot 0
#size 2
#mor 14
#mr 10
#enc 3
#str 12
#att 12
#def 11
#prec 10
#mapmove 1
#ap 12
#holy
#armor "Whitesteel Plate"
#armor "Full Helmet"
#weapon "White Halberd"
#castledef 1
#mor 15
#gcost 42
#rcost 1
#nametype 104
#end


-------- Commanders


-- Hammer of Ulm

#newmonster 3307
#copyspr 114
#name "Hammer of Ulm"
#descr "The Hammers of Ulm are the most common commanders in the army. They are well respected, capable of leading many men in battle and have been granted coveted blacksteel plate armour."
#gcost 30
#prot 0
#mor 12
#mr 9
#enc 3
#str 11
#rcost 1
#att 11
#def 11
#prec 10
#size 2
#ap 12
#mapmove 2
#goodleader
#armor "Full Plate of Ulm"
#armor "Half Helmet"
#weapon "Hammer"
#armor "Tower Shield"
#standard 5
#nametype 104
#end


-- Neugeboren Lord

#newmonster 3308
#name "Neugeboren Lord"
#descr "Though of crucial import to the new faith, the leaders of the Neugeboren have no priestly powers. However as direct representatives of the Aufklarung and the Awakening God, they are granted physical prowess beyond that of mere mortals and an aura of valour that inspires allies and cows enemies."
#spr1 "./Ulm Reborn/Reborn Lord.tga"
#spr2 "./Ulm Reborn/Reborn Lord2.tga"
#holy
#weapon "White Halberd"
#armor "Whitesteel Plate"
#armor "Black Steel Helmet"
#hp 18
#str 14
#mor 17
#awe 3
#mr 11
#mapmove 2
#ap 12
#standard 15
#gcost 150
#rcost 6 -- to make up for no rcost on the helmet
#expertleader
#maxage 100
#nametype 104
#castledef 2
#enc 3
#end


-- Black Acolyte

#newmonster 3309
#copystats 739
#copyspr 739
#descr "The Iron Cult of Ulm played a dubious role in the Civil War. While they claimed to be protecting the people from sorcery and fighting for justice, their actions resulted in the destruction of the few remaining blacksteel Smiths. The Aufklarung marked a turning point for the cult as they realised their full potential as the official Iron Faith of Ulm. Shepherds and spiritual guardians of Ulm, the Faith has banned all magical practice outside their ranks and expelled numerous unsavory cults and cabals who had infiltrated the nation during the war. Acolytes serve as the rank and file of the Iron Faith; they do not have the authority to gather forces of Penitent, but they are trained to infiltrate enemy lands and spread the truth of the Faith."
#clearmagic
#hp 11
#prot 0
#mor 11
#mr 12
#enc 4
#str 11
#att 9
#def 9
#prec 10
#ap 10
#mapmove 2
#poorleader
#magicskill 8 1
#stealthy 0
#gcost 40
#poorleader
#poormagicleader
#nametype 104
#weapon "Dagger"
#end


-- Black Priest

#newmonster 3310
#copystats 740 -- necessary for the inquisitor ability
#copyspr 740
#name "Black Priest"
#descr "The Iron Cult of Ulm played a dubious role in the Civil War. While they claimed to be protecting the people from sorcery and fighting for justice, their actions resulted in the destruction of the few remaining blacksteel Smiths. The Aufklarung marked a turning point for the cult as they realised their full potential as the official Iron Faith of Ulm. Shepherds and spiritual guardians of Ulm, the Faith has banned all magical practice outside their ranks and expelled numerous unsavory cults and cabals who had infiltrated the nation during the war. Black Priests form the backbone of the Faith, gathering and leading Penitent, while wielding pure, uncorrupted iron or earth magic. The stronger the dominion of the Iron Faith, the more penitent will join the righteous cause of the priesthood."
#clearmagic
#domsummon2 "penitent"
#weapon "Hammer"
#okleader
#okmagicleader
#magicskill 3 1
#magicskill 8 2
#custommagic 1024 40
#gcost 180
#nametype 104
#forgebonus 0
#morale 12
#prot 0
#hp 12
#enc 4
#str 11
#att 9
#def 9
#prec 10
#ap 8
#mapmove 2
#rcost 1
#mr 14
#end


-- Hochmeister

#newmonster 3311
#copyspr 1237
#copystats 1237 -- necessary for the inquisitor ability
#name "Hochmeister"
#descr "Hochmeisters skilled commanders, warriors, priests and inquisitors trained to lead the Black Templars into battle. They are chosen from amongst the Templar primarily for their fanatical devotion to the Iron Faith and they are highly unlikely to retreat from battle."
#mor 18
#gcost 90
#hp 17
#att 12
#def 12
#enc 5
#ap 18
#mapmove 2
#mr 12
#str 14
#ressize 2
#size 3
#rcost 20
#poormagicleader
#goodleader
#mounted
#magicskill 8 1
#weapon "Hammer"
#weapon "Lance"
#weapon 710
#armor "Full Plate of Ulm"
#armor "Black Steel Helmet"
#armor "Black Steel Kite Shield"
#nametype 104
#end


-- White Priest

#newmonster 3294
#copystats 1646 -- this is to allow research in drain dom
#copyspr 477
#clearmagic
#name "White Priest"
#descr "During the Civil War the highest leaders of the Iron Cult shouldered the greatest burden of responsibility. Entire villages were purged, Smiths put to the sword and countless lives lost, all to protect Ulm from encroaching darkness. Yet the weight on their souls was almost too much to bear. When the Aufklarung descended on Ulm many were driven mad and fled into the Black Forest, but those able to overcome their guilt were reborn as pristine symbols of spiritual fortitude. Though they lead the Iron Faith they stand apart from the Black Temple and gather no Penitent. They are powerful priests skilled in both traditional earth magic and a new magic of the heavens, inspired by the Aufklarung. It is only the White Priests that may call the Sternkind and only they who can draw on such strong faith as to be unaffected by realms drained of magic. They have also rediscovered the artisan spirit of the departed Smiths, forging blacksteel and whitesteel for the forces of Ulm."
#hp 9
#mapmove 2
#ap 10
#mr 16
#mor 16
#str 10
#att 8
#def 8
#prec 11
#enc 3
#magicskill 8 3
#magicskill 3 3
#magicskill 4 1
#gcost 290
#holy
#poorleader
#okmagicleader
#maxage 100
#startage 85
#awe 2
#nametype 104
#forgebonus 15
#custommagic 2048 20
#end


-- Hoch-Hammer

#newmonster 3297
#spr1 "./Ulm Reborn/Hoch-Hammer.tga"
#spr2 "./Ulm Reborn/Hoch-Hammer2.tga"
#name "Hoch-Hammer"
#descr "Hoch-Hammers are ordinary Black Templar who chose to take sacred hammers from the White Temple and swear an oath of wrath and judgement upon the dark and corrupted world around them. They lack the training that the Hochmeisters receive at the Black Temple but the sheer power of the White Hammers they hold make them extremely formidable on the battlefield. As they approach their foe they cast forward a swarm of spirit hammers which attract blasts of energy from the mantle of the Aufklarung. Their eyes glowing with sacred energy they strike down the enemies of the Iron Faith from near or far. Hoch-Hammers will never use weapons other than their hammer and shield. Though inspiring to their fellows, Hoch-Hammers are intensely focused on their own divine mission and make poor leaders."
#weapon "White Hammer"
#weapon "Spirit Hammers"
#weapon 710
#armor "Full Plate of Ulm"
#armor "Black Steel Helmet"
#armor "Black Steel Kite Shield"
#mounted
#size 3
#mor 18
#mr 11
#enc 5
#prec 12
#att 14
#def 13
#str 14
#hp 25
#gcost 170
#rcost 1
#holy
#mapmove 2
#ap 18
#poorleader
#standard 10
#nametype 104
#itemslots 13440
#end


-- White Acolyte

#newmonster 3314
#copystats 1646 -- this is necessary to allow research in drain dom
#spr1 "./Ulm Reborn/White Acolyte.tga"
#spr2 "./Ulm Reborn/White Acolyte2.tga"
#clearmagic
#name "White Acolyte"
#descr "The Aufklarung brought about peace, religious fervour and a strong sense of purpose in Ulm. It also instilled a thirst for knowledge amongst many and drew them to the White Temple to be trained as Acolytes. Acolytes spend their time studying tomes of knowledge long thought lost to the Civil War. They make excellent researchers and like the more powerful White Priests they are unaffected by the currents of traditional magic; even in magically drained lands they are entirely effective. However their focus on constant study and catalogue has left them physically weak and they are reluctant to travel long distances. They are skilled in either astral or earth magic, focusing their studies on either the realm of Ulm or the mantle of the Aufklarung."
#hp 8
#mapmove 1
#ap 10
#mr 12
#mor 11
#str 9
#att 7
#def 7
#prec 9
#enc 3
#magicskill 8 1
#researchbonus 1
#gcost 100
#holy
#noleader
#maxage 65
#startage 50
#nametype 104
#custommagic 3072 100
#custommagic 3072 10
#end







--------------------------------------


-------- National Summons


-- Sternkind

#newmonster 3295
#spr1 "./Ulm Reborn/Sternkind.tga"
#spr2 "./Ulm Reborn/Sternkind2.tga"
#name "Sternkind"
#descr "Sternheld are souls granted form by the Aufklarung. Their virtuous actions during the Civil War have not been forgotten and they are revered by the Iron Faith; they alone span the gap between the world of man and iron and the heavenly realm of the Aufklarung. These sacred undead warriors carry hammers which release a blast of electrical energy when they strike their target and wear protective armour under their robes."
#str 11
#att 12
#def 10
#hp 22
#mapmove 3
#enc 3
#prec 11
#ap 12
#flying
#prot 6
#mr 10
#mor 20
#gcost 20
#undead
#holy
#size 3
#shockres 50
#weapon "Sternhammer"
#armor "Plate Cuirass"
#maxage 900
#startage 10
#nametype 139
#end


-- Sternheld

#newmonster 3296
#spr1 "./Ulm Reborn/Sternheld.tga"
#spr2 "./Ulm Reborn/Sternheld2.tga"
#name "Sternheld"
#descr "Sternheld are the hands of the Aufklarung, spirit beings given form and considerable power who are often found commanding forces of lesser Sternkind. Their black and white wings represent the transitional state of their souls between the mire of the Civil War and the glory of the Aufklarung. They are naturally gifted in air and astral magic."
#undead
#holy
#hp 25
#str 12
#att 13
#def 11
#prot 8
#enc 3
#prec 11
#gcost 300
#flying
#mr 14
#magicskill 4 2
#magicskill 1 2
#magicskill 8 1
#mapmove 3
#ap 12
#mor 22
#size 3
#shockres 50
#weapon "sternhammer"
#poorleader
#okundeadleader
#startage 10
#maxage 900
#nametype 139
#end


-- Sturmheld

#newmonster 3312
#spr1 "./Ulm Reborn/Sturmheld.tga"
#spr2 "./Ulm Reborn/Sturmheld2.tga"
#name "Sturmheld"
#descr "The Sturmheld weild a power even greater than the righteous Sternheld. They are undead Ulmic angels of wrath and spite. Like the Sternheld they have one black and one white wing, representing the transitional state of their souls between the earth and the Aufklarung. Unlike the Sternheld they have no gift for astral magic, but are masters of air and lightning. Sternkind have been known to substantiate in areas of great faith purely to follow the Sturmheld into battle."
#undead
#domsummon20 3295
#holy
#hp 25
#str 13
#att 14
#def 12
#prot 9
#enc 3
#prec 12
#gcost 500
#flying
#mr 15
#magicskill 1 3
#magicskill 0 2
#magicskill 8 1
#mapmove 3
#ap 12
#mor 25
#size 3
#shockres 100
#weapon "Sternhammer"
#armor "Crown"
#goodleader
#goodundeadleader
#startage 10
#maxage 900
#nametype 139
#end


-------- New Heroes


-- Grey Shepherd

#newmonster 3298
#spr1 "./Ulm Reborn/Grey Shepherd.tga"
#spr2 "./Ulm Reborn/Grey Shepherd2.tga"
#name "Grey Shepherd"
#descr "The Grey Shepherd is a wandering priest of the Iron Faith who many call the Smith of Souls. It is said he can test the mettle of any man's soul at a glance and, given a few years, cleanse even the darkest native of Ulm from all flaws. The Grey Shepherd has never been heard to speak; he simply appears and with a single gesture calls men to his flock. He attracts far more penitent than any other priest alive."
#str 12
#att 10
#def 12
#hp 16
#mapmove 2
#enc 2
#ap 12
#prec 11
#mr 14
#mor 19
#gcost 1
#rcost 1
#holy
#magicskill 8 3
#weapon "quarterstaff"
#domsummon "penitent"
#summon5 "penitent"
#expertleader
#nametype 139
#itemslots 31878
#end


-- Reborn Noble

#newmonster 3315
#spr1 "./Ulm Reborn/Reborn Noble.tga"
#spr2 "./Ulm Reborn/Reborn Noble2.tga"
#name "Reborn Noble"
#descr "This infamous nobleman was responsible for some of the most terrible atrocities of the Civil War; children slaughtered, women raped, entire towns put to the sword. Yet with the coming of the Aufklarung and the awakening god, the noble was reborn. All could see by the light in his eyes that he had changed, but the noble demanded to be tested, given the chance to prove his righteous rebirth. And so he was given up to the Black Temple to be 'tested', then to the White Temple to be purged, then finally to the Keep of the Reborn, to be trained. He emerged something more than a mere man and has become a leader of great standing, loved by the sons of the Iron Faith but feared and despised by their heathen foes."
#holy
#armor "Whitesteel Plate"
#weapon "Great Sword"
#ap 12
#enc 2
#mapmove 2
#att 14
#def 14
#hp 35
#str 15
#mor 20
#fear 2
#awe 2
#mr 13
#standard 20
#gcost 1
#rcost 1
#expertleader
#maxage 100
#nametype 104
#itemslots 31878
#end


-- Confessor

#newmonster 3316
#spr1 "./Ulm Reborn/Confessor.tga"
#spr2 "./Ulm Reborn/Confessor2.tga"
#name "Confessor"
#descr "The high ranking Black Priest known only as the Confessor was, in a former life, a member of the Marignese clergy. Leading a group of soldiers on a crusade into the tumultuous lands of Ulm during the Civil War, he and his band were struck with the ineffable power of the Aufklarung as strongly as any native of Ulm. He converted immediately to follow the new god and joined the Iron Faith. He has since become a powerful and influential figure in Ulm who has added his doctrine of cleansing fire to the redemption offered by the faith."
#clearmagic
#weapon "Absolver Hammer"
#itemslots 31878
#magicskill 0 3
#magicskill 8 2
#magicskill 3 2
#domsummon2 "penitent"
#goodleader
#okmagicleader
#gcost 1
#nametype 104
#morale 14
#prot 0
#hp 14
#enc 3
#str 12
#att 10
#def 10
#prec 10
#ap 10
#mapmove 2
#rcost 1
#mr 16
#older -10
#end


-------- New Pretender


-------- New Spells


#newspell
#copyspell "Iron Darts"
#restricted 86

#end


#newspell
#copyspell "Iron Blizzard"
#restricted 86

#end


#newspell
#copyspell "Lightning Bolt"
#name "Punish the Unjust"
#descr "A crackling blast of holy lightning tears down from the spreading mantle of the Aufklarung and strikes one enemy of Ulm."
#school 7
#restricted 86

#researchlevel 0
#path 0 8
#fatiguecost 20
#pathlevel 0 2
#damage 10
#range 50
#precision 30
#nreff 1
#end

#newspell
#name "Messengers of the Aufklarung"
#descr "The White Priest performs a holy ritual under the mantle of the Aufklarung allowing eight souls of virtue from the Civil War to reform as Sternkind; representatives of the afterlife and messengers of the new faith. They will only follow a commanding Sternheld." 
#school 0
#restricted 86

#researchlevel 3
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10001
#fatiguecost 1300
#damage 3295
#nreff 8
#end

#newspell
#name "Hand of the Aufklarung"
#descr "The White Priest performs a holy ritual under the mantle of the Aufklarung which gives form to a single Sternheld, a sacred undead being skilled in air and astral magic." 
#school 0
#restricted 86

#researchlevel 4
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10021
#fatiguecost 1400
#damage 3296
#nreff 1
#end


#newspell
#name "Wrath of the Aufklarung"
#descr "The prophet performs a holy ritual under the mantle of the Aufklarung which gives form to a single Sturmheld, a sacred undead being of considerable power highly skilled in air magic with some knowledge of the fiery arts." 
#school 0
#restricted 86

#researchlevel 5
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 4
#effect 10021
#fatiguecost 2000
#damage 3312
#nreff 1
#end


#newspell
#name "Host of the Aufklarung"
#descr "Standing under the mantle of the Aufklarung, the White Priest calls for judgement on the enemies of Ulm. A host of Sternkind descend, fully prepared to smite the forces of darkness. This sacred host requires the leadership of a Sternheld or Sturmheld."
#school 0
#restricted 86

#researchlevel 7
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 4
#effect 10001
#fatiguecost 3000
#damage 3295
#nreff 30
#end



-------- New sites

#newsite 970

#name "Keep of the Reborn"


#path 8
#level 0


#rarity 5
#homemon 3306
#homecom 3308
#end



#newsite 971
#name "White Temple"


#path 8
#gems 4 1
#level 0


#rarity 5

#homecom 3294
#homecom 3297
#end



#newsite 972
#name "Forge of the Faithful"
#path 3
#level 0


#rarity 5
#gems 3 3
#res 30
#end



#newsite 973
#name "Black Temple"
#path 8
#level 0
#rarity 5
#homecom 3311
#homemon 3305
#end


-------- New Namepools


-------- New nations



#selectnation 86

#clear
#name "New Ulm"
#epithet "Iron Faith Reborn"
#era 3
#brief "The malediction never occured. Instead the Civil War was ended by the Aufklarung (enlightenment), a miraculous event heralding the awakening of a new god."
#descr "The malediction never occured. Instead the Civil War was ended by the Aufklarung (enlightenment), a miraculous event heralding the awakening of a new god. The Iron Faith rules all aspects of society both temporal and spirtual under the leadership of those reborn in the Aufklarung. Their White Priests and Acolytes are unaffected by drain dominion. All Ulmish forts have a production bonus to resources."
#summary "Race: Humans. Military: Heavy infantry and cavalry, many sacreds including droves of penitent. Magic: Earth, Astral, access to Air and Fire. Priests: Strong, Black Priests attract penitent."
#flag "./Ulm Reborn/flag.tga"
#templepic 9
#castleprod 20
#color 0.8 0.8 0.8


------- Add Soldiers

#addrecunit 3300 -- Infantry with hammer
#addrecunit 3301 -- Crossbow
#addrecunit 3302 -- Pike
#addrecunit 3304 -- Anchorite
#addrecunit 3303 -- Black Zweihander

------- Add leaders

#addreccom 426 -- Generic Scout
#addreccom 3307 -- Captain Hammer
#addreccom 3309 -- Black Acolyte
#addreccom 3310 -- Black Priest
#addreccom 3314 -- White Acolyte


------- Province Defence

--Sets the units to be used in province defense.

#defcom1 3307 -- Captain Hammer
#defcom2 3309
 -- Black Acolyte
#defunit1 3300 -- Infantry with hammer
#defunit1b 3301 -- Crossbow 
#defunit2 3293 -- Penitent


--Sets how many of the units to appear per point.

#defmult1 10
#defmult1b 10
#defmult2 14

------- Hero Settings

#hero1 3298
#hero2 3315
#hero3 3316
#multihero1 3312

#idealcold 0
#startsite "Forge of the Faithful"
#startsite "Black Temple"
#startsite "Keep of the Reborn"
#startsite "White Temple"
#startfort 3
#swampfort 11
#farmfort 41
#forestfort 35
#mountainfort 9
#defaultfort 7


------- Starting units

#startcom 3307
#startunittype1 3300
#startunitnbrs1 10
#startunittype2 3301
#startunitnbrs2 10
#startscout 3309
#end


-modname "LA Nation: Vaettiheim"

-description "Creates a nation of exiled Vaetti and Gygjas in the late era. Based on a sample mod by QM."

-icon "./Vaettiheim/vaettibanner.tga"


-version 2.4


--- v 2.4

-- FIX - IDs remapped for MC compliance

-- FIX - Spero Chief gets proper armour


--- V 2.3

-- Problems with banner and flag file locations fixed



--- V 2.2

-- All copystats replaced with actual stats

-- Many changes to ID numbers

-- Changed the role of the Wolf Lord to make him less of a call allies monkey

-- Replaced the werewolf spy with a simple and very cheap Vaetti scout

-- Exile Guard no longer cap only

-- Troll Druid gets +1 nature in a forest

-- Prettied up the flag and banner a bit


----Mod uses ID Numbers --

--Nation 92

--Armor 275

--Weapons 691

--Monsters 2393-2420

--Sites 887-889



---- ITEMS

--ARMOR

#newarmor 275
#name "Dire Wolf Furs"
#type 5
#prot 7
#def 0
#enc 1
#rcost 2
#end

--WEAPONS

#newweapon 691
#name "Vaetti Pickaxe"
#dmg 7
#att -2
#def -2
#len 2
#rcost 6
#end

---- UNITS



-- Vaetti spear

#newmonster 2400

#copyspr 541
#name "Vaetti"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating from 
the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die to protect
a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their wolven friends.
Vaetti are small and stealthy and can hide in enemy territories."
#size 1
#gcost 8
#rcost 1
#hp 8
#mor 9
#mr 12
#enc 3
#str 9
#att 10
#def 10
#prec 9
#ap 10
#mapmove 2
#forestsurvival
#stealthy 0
#weapon "Spear"
#armor "Full Leather Armor"
#armor "Shield"
#armor "Leather Cap"
#end

-- Vaetti Netter

#newmonster 2401
#name "Vaetti Netter"
#spr1 "./Vaettiheim/Vaetti Netter.tga"
#spr2 "./Vaettiheim/Vaetti Netter2.tga"
#descr "Originally employed against the werewolves, dire wolves, forest trolls, speros and numerous other inhabitants of Crescent Woods that initially tried to maim or devour the interloping Vaetti, the netters have become an important part of any wolfkin army. Mixed in with spearmen or more powerful Vaetti allies they use their nets to drag down and overwhelm even the most powerful foes. Netters are generally experienced and canny fighters with a little more fight in them than their spear armed brothers, though they are more vulnerable to missile fire."
#weapon "dagger"
#armor "furs"
#armor "leather cap"
#weapon "net"
#gcost 10
#hp 8
#prec 9
#mor 10
#mr 12
#enc 3
#rcost 1
#str 9
#att 11
#def 11
#mapmove 2
#ap 8
#forestsurvival
#stealthy 0
#size 1
#end

-- Vaetti Archer

#newmonster 2402

#name "Vaetti Archer"
#spr1 "./Vaettiheim/Vaetti Archer.tga"
#spr2 "./Vaettiheim/Vaetti Archer2.tga"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating from 
the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die to protect
a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their wolven friends. 
Vaetti are small and stealthy and can hide in enemy territories."
#weapon "short bow"
#weapon "dagger"
#armor "furs"
#armor "leather cap"
#gcost 9
#hp 8
#prec 9
#mor 9
#mr 12
#enc 3
#rcost 1
#str 9
#att 10
#def 10
#mapmove 2
#ap 8
#forestsurvival
#stealthy 0
#size 1
#end


-- Vaetti Groundbreaker

#newmonster 2403
#name "Vaetti Groundbreaker"
#spr1 "./Vaettiheim/Vaetti Groundbreaker.tga"
#spr2 "./Vaettiheim/Vaetti Groundbreaker2.tga"
#descr "Vaetti groundbreakers are tasked with with hacking into the frozen ground to find rocks saturated with wild magic; the favoured food of the forest trolls. In order that they may keep working tirelessly the Gygja provide them a diet of broth laced with strength potion. They have proven to be hardy and useful infantry, particularly when the Vaetti need to break into enemy fortifications."
#weapon 691
#armor "full leather armor"
#armor "leather cap"
#armor "shield"
#gcost 11
#hp 9
#prec 9
#mor 10
#mr 13
#enc 3
#rcost 1
#str 11
#att 10
#def 10
#coldres 25
#mapmove 2
#ap 8
#siegebonus 2
#size 1
#forestsurvival
#stealthy 0
#end


-- Vaetti Wolf Rider


#newmonster 2404

#copyspr 282
#name "Wolf Rider"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating
from the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die
 to protect a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their
 lupine friends. Vaetti are small and stealthy and can hide in enemy territories."

#size 2
#ressize 1
#gcost 20
#rcost 1
#hp 8
#mor 9
#mr 12
#enc 4
#str 9
#att 10
#def 10
#prec 9
#ap 22
#mapmove 3
#mounted
#stealthy 0
#forestsurvival
#weapon 20
#weapon "Spear"
#armor "Full Leather Armor"
#armor "Shield"
#armor "Leather Cap"
#end



-- Vaetti Moose Riders

#newmonster 2405
#copyspr 1085
#name "Moose Riders"
#descr "After the success of using wolves as mounts in battle, some Vaetti sought to improve that strategy with a larger animal. They settled upon the great moose, one of the largest beasts in the forest, known for its foul temper and impressive strength. With the help of the Gygjas the Vaetti made allies of these huge creatures and now they are used in battle as mounts for a pair of Vaetti archers who can do little more than hold on when the moose starts to kick and gore foes who stray too close."
#size 4
#rcost 1
#gcost 35
#hp 38
#prot 4
#mor 9
#mr 9
#enc 4
#prec 9
#att 10
#def 9
#prec 9
#ap 24
#mapmove 3
#weapon "Moose Kick"
#weapon "Antlers"
#weapon "Short Bow"
#weapon "Short Bow"
#animal
#end

--Werewolf


#newmonster 2406

#copyspr 854
#name "Werewolf"
#descr "Long since exiled from human society, a great pack of werewolves has grown and prospered in the lands of the Vaetti, turning to their wild instincts and casting their human forms aside entirely. With the coming of the awakening God they now stream from the forests alongside the Wolf Kin, seeking new prey and looking to settle old scores. Over long distances they travel on all fours and are thus capable of keeping pace with wolfriders and other fast moving troops."

#size 3
#gcost 30
#rcost 1
#hp 20
#prot 6
#mor 15
#mr 14
#enc 2
#str 14
#att 13
#def 12
#prec 7
#ap 16
#mapmove 3
#weapon 20 -- bite
#weapon 29 -- claw
#weapon 29 -- claw
#regeneration 10

#forestsurvival
#stealthy 0

#maxage 200
#end


--Exile Guard



#newmonster 2407

#copyspr 283

#name "Exile Guard"


#descr "When the Vaetti departed Jotunheim, a major concern was the safety of the 
Gygjas accomanying them. Many of the chiefs and their most respected warriors choose to give up their 
former lives and dedicate themselves to safeguarding the Gygjas. Known as the Exile Guard, 
their heroic actions during the wanderings are know to all Wolf Kin. With the Vaetti thriving in their new homeland and the Gygja safer than ever, the Exile Guard have extended their role to protect their entire race and their ranks have swollen considerably. It is the highest honour 
for a young Vaetti to be accepted into the Guard and they can be relied on to give a good account of themselves in battle."

#size 2
#gcost 32
#rcost 1
#ressize 1
#hp 10
#mor 12
#mr 12
#enc 4
#str 10
#att 11
#def 11
#mounted
#ap 22
#mapmove 3
#prec 10
#holy
#forestsurvival
#stealthy 0
#weapon "Short Sword"
#weapon 20 -- bite
#armor "Full Leather Armor"
#armor "Reinforced Leather Cap"
#armor "Shield"
#secondtmpshape 284 -- wolf
#end




--Spero Warrior


#newmonster 2408
#name "Spero Warrior"
#spr1 "./Vaettiheim/Spero Warrior.tga"
#spr2 "./Vaettiheim/Spero Warrior2.tga"
#descr "The Spero are a reclusive tribe of winged lizardlike humanoids who have long reigned over Crescent Peak and the surrounding mountains. Initially they fought with the newly arrived Vaetti, believing them to small and weak; mere prey to be devoured. However the Spero soon learned to fear the magic of the Gygja and their hags and as the trolls and wolfkind of the woods allied with the Vaetti, the chiefs realised the Spero too could benefit from such a treaty. The Spero are now valuable allies who excel at swift strikes against vulnerable foes such as archers. Though they resemble coldblooded lizards, the Spero are not coldblooded and resist the freezing weather of the peaks due to some innate magic. Their favoured technique is to 'divebomb' their targets, impaling them with their spear."
#hp 15
#size 3
#prot 4
#mor 10
#mr 10
#enc 4
#str 12
#att 10
#def 11
#prec 10
#mapmove 3
#ap 12
#gcost 26
#rcost 1
#weapon "light lance"
#weapon 20
#armor "leather cuirass"
#flying
#coldres 75
#mountainsurvival
#nametype 113
#end


--Forest Troll

#newmonster 2409
#copyspr 518
#name "Forest Troll"
#descr "The Vaetti needed to call on all the allies they could in their exile; while they initially avoided or even fought the native trolls of the forest, the Gygjas soon negotiated a beneficial relationship between goblin and troll. The Vaetti hack into the cold hard ground to find the choicest old rocks for the trolls to eat and in return they receive a powerful ally in battle. Forest trolls are slightly smaller than their mountain cousins. Unlike the Jotun, the trolls have neither the will nor the numbers to impose servitude on the Vaetti."
#size 3
#gcost 60
#rcost 11
#hp 31
#prot 11
#mor 12
#mr 14
#enc 3
#str 20
#att 10
#att 9
#prec 8
#mapmove 2
#ap 14
#neednoteat
#fireres -25
#darkvision 50
#regeneration 15
#mountainsurvival
#forestsurvival
#weapon "Great Club"
#armor "Furs"
#maxage 400
#end


--Wolf Troll

#newmonster 2410
#copyspr 1037
#name "Wolf Troll"
#descr "The Wolf Trolls were the first of their kind to aid the Vaetti, saving an ancient Gygja from a group of human bandits encroaching on the forests. These trolls earned the respect and blessing of the Gygja and were trained to become a sacred elite amongst the Vaetti forces. They are extremely loyal, excellent fighters who have become fully integrated into the religion of the Vaetti. They are armed with heavy stone mauls and draped in blessed Dire Wolf furs. Unlike the Jotun, the trolls have neither the will nor the numbers to impose servitude on the Vaetti."
#size 3
#gcost 100
#rcost 13
#hp 35
#prot 11
#mor 14
#mr 14
#enc 3
#str 22
#att 11
#att 9
#prec 8
#mapmove 2
#ap 14
#neednoteat
#fireres -25
#coldres 25
#darkvision 50
#regeneration 15
#mountainsurvival
#forestsurvival
#weapon "Maul"
#armor "Dire Wolf Furs"
#holy
#standard 4
#maxage 400
#end


---- LEADERS


-- Chief


#newmonster 2411

#copyspr 283
#name "Vaetti Chief"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins
originating from the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a
Vaetti would gladly die to protect a Gygja in danger. The Wolf Kin wear heavy furs, and
some ride into battle mounted on their wolven friends. Vaetti are small and stealthy and can
hide in enemy territories. Chiefs are local tribal leaders, reduced in importance since the
 rise of the Wolf Lords."

#size 2
#gcost 50
#rcost 1
#ressize 1
#hp 10
#mor 10
#mr 12
#enc 4
#str 9
#att 10
#def 10
#prec 10
#ap 22
#mapmove 3
#okleader
#stealthy 0
#forestsurvival
#weapon "Short Sword"
#weapon 20
#armor "Reinforced Leather Cap"
#armor "Full Leather Armor"
#armor "Shield"
#nametype 115

#end




-- Vaetti Scout


#newmonster 2412
#name "Vaetti Scout"
#spr1 "./Vaettiheim/Vaetti Archer.tga"
#spr2 "./Vaettiheim/Vaetti Archer2.tga"
#descr "The Wolf Kin, or Vaetti, as they call themselves, are a tribal people of goblins originating from 
the deep forests of Jotunheim. The Hags are sacred to the Wolf Kin, and a Vaetti would gladly die to protect
a Gygja in danger. The Wolf Kin wear heavy furs, and some ride into battle mounted on their wolven friends. 
Vaetti are small and stealthy and can hide in enemy territories."
#weapon "short bow"
#weapon "dagger"
#armor "furs"
#armor "leather cap"
#gcost 15
#hp 8
#prec 9
#mor 9
#mr 12
#enc 3
#rcost 1
#str 9
#att 10
#def 10
#mapmove 2
#ap 8
#forestsurvival
#stealthy 10
#size 1
#end


--Wolf Lord


#newmonster 2413


#copyspr 508
#gcost 90
#rcost 2
#name "Wolf Lord"

#descr "Wolf Lords are Vaetti of great cunning and strength who, out of the shadow of the giants,
have taken rulership as generals and priests of the Vaetti. They are now the highest authoriry of
the tribes, defering only to the Gygjas when they choose to make their wishes known. Wolf Lords 
often ride white wolves decended from the offspring of Angerboda, Mother of Monsters. They are well
 known even among the wolves of the woods and each month a lupine ally will come to their side."
#weapon 1

#weapon 20

#armor "Shield"

#armor "Iron Cap"

#armor "Full Leather Armor"

#forestsurvival
#nametype 115

#mounted

#str 10
#size 2
#hp 11

#mr 11
#att 12

#def 12

#mor 13
#enc 4
#mapmove 3

#ap 24

#magicskill 8 1

#holy

#standard 10
#goodleader

#summon1 "wolf"
#end


--Spero Chief



#newmonster 2414
#spr1 "./Vaettiheim/Spero Chief.tga"
#spr2 "./Vaettiheim/Spero Chief2.tga"
#name "Spero Chief"
#descr "The Spero are a reclusive tribe of winged lizardlike humanoids who have long reigned over Crescent Peak and the surrounding mountains. Initially they fought with the newly arrived Vaetti, believing them to small and weak; mere prey to be devoured. However the Spero soon learned to fear the magic of the Gygja and their hags and as the trolls and wolfkind of the woods allied with the Vaetti, the chiefs realised the Spero too could benefit from such a treaty. The Spero are now valuable allies who excel at swift strikes at weak points in enemy armies. Despite their appearance they are not coldblooded and resist the cold of the peaks due to some innate magical field. The Spero chieftans have a weakness for shiny trinkets and by granting them gilded scale mail obtained during the long journey, the Gygja secured their utmost loyalty."
#hp 16
#size 3
#prot 4
#mor 11
#mr 10
#enc 4
#str 13
#att 11
#def 11
#prec 10
#mapmove 3
#ap 12
#gcost 90
#rcost 1
#weapon "axe"
#weapon 20
#armor "Scale Mail Cuirass"
#armor "Half Helmet"
#flying
#coldres 75
#mountainsurvival
#nametype 113
#end


--Vaetti Hag


#newmonster 2415
#name "Vaetti Hag"
#copyspr 913

#descr "Some Vaettis have learned the secrets of Seith. As long as they do not learn too much, the Gygjas 
allow them to continue their practices. Since the Exile, the remaining Gygjas have been more accepting of
 Vaetti magic and even encouraged it in the case of particularly talented Vaetti females."
#gcost 60
#size 1
#rcost 1
#hp 7
#mor 9
#mr 14
#enc 3
#str 8
#att 8
#def 8
#prec 9
#ap 10
#mapmove 2
#poorleader
#weapon "Dagger"
#armor "Leather Cuirass"
#armor "Leather Cap"
#forestsurvival
#stealthy 0
#custommagic 30720 100
#custommagic 28672 30
#nametype 116
#female
#startage 50
#end

--Vaetti Sorcerer

#newmonster 2416
#spr1 "./Vaettiheim/Vaetti Sorcerer.tga"
#spr2 "./Vaettiheim/Vaetti Sorcerer2.tga"
#name "Vaetti Sorcerer"
#descr "Although the Gygja were slowly passing more knowledge of the Seith down to their Vaetti assistants, some of the magically gifted wolfkin hungered for more knowledge and power. They dared not move directly against the Gygja, but they realised that following the way of Seith was actually limiting their progress, so they formed an order devoted to dark and powerful arts used by humans. The order of sorcerers has expanded rapidly and some predict a clash with the dwindling Gygja over control of the Vaetti nation. For now though, the Gygja are sacred representatives of the awakening God and the sorcerers must obey their edicts."
#gcost 125
#size 1
#rcost 1
#hp 7
#mor 9
#mr 14
#enc 3
#str 8
#att 8
#def 8
#prec 9
#ap 10
#mapmove 2
#poorleader
#weapon "Stick"
#armor "Leather Cuirass"
#armor "Leather Cap"
#forestsurvival
#stealthy 0
#nametype 115
#magicskill 5 1
#magicskill 7 1
#custommagic 22528 100
#custommagic 30720 20
#startage 40
#end


--Troll Druid

#newmonster 2417
#spr1 "./Vaettiheim/Troll Druid.tga"
#spr2 "./Vaettiheim/Troll Druid2.tga"
#name "Forest Troll Druid"
#descr "Before the arrival of the Vaetti the forest trolls were ruled by reclusive druids who communed with the spirits of the wood and its inhabitants. When the Gygjas came these same druids recognised that they were outmatched magically and gathered at their most sacred tree seeking spiritual guidance. The signs were clear; the Gygja clearly carried the favour of the forest and must be supported. Though they do not follow the way of Seith, the shamans have integrated themselves into Vaetti society, upholding the will of the awakening god. Their natural magic is more powerful in the forests."
#gcost 185
#rcost 10
#holy
#weapon "quarterstaff"
#size 3
#hp 30
#prot 11
#mor 13
#enc 3
#str 20
#att 10
#def 9
#prec 9
#ap 14
#mapmove 2
#poorleader
#fireres -25
#researchbonus -1
#rcost 15
#mountainsurvival
#forestsurvival
#regeneration 15
#darkvision 50
#neednoteat
#magicskill 8 1
#magicskill 6 2
#magicskill 3 1
#custommagic 9216 10
#nametype 137
#forestshape 2418
#maxage 400
#older 150
#end


--Troll Druid

#newmonster 2418
#spr1 "./Vaettiheim/Troll Druid.tga"
#spr2 "./Vaettiheim/Troll Druid2.tga"
#name "Forest Troll Druid"
#descr "Before the arrival of the Vaetti the forest trolls were ruled by reclusive druids who communed with the spirits of the wood and its inhabitants. When the Gygjas came these same druids recognised that they were outmatched magically and gathered at their most sacred tree seeking spiritual guidance. The signs were clear; the Gygja clearly carried the favour of the forest and must be supported. Though they do not follow the way of Seith, the shamans have integrated themselves into Vaetti society, upholding the will of the awakening god. Their natural magic is more powerful in the forests."
#gcost 185
#rcost 10
#holy
#weapon "quarterstaff"
#size 3
#hp 30
#prot 11
#mor 13
#enc 3
#str 20
#att 10
#def 9
#prec 9
#ap 14
#mapmove 2
#poorleader
#fireres -25
#researchbonus -1
#rcost 15
#mountainsurvival
#forestsurvival
#regeneration 15
#darkvision 50
#neednoteat
#magicskill 8 1
#magicskill 6 2
#magicskill 3 1
#custommagic 9216 10
#magicboost 6 1
#nametype 137
#plainshape 2417
#maxage 400
#older 250
#end


--Gygja


#newmonster 2419

#name "Gygja"
#copyspr 785

#descr "A Gygja is an ancient Jotun Hag. Over the centuries, they have grown in size and malice.
Gygjas are skilled in the dark witchcraft known as Seith. They are considered sacred by the Vaetti,
and a few have accompanied them in exile. They now reside in a deeply shaded wood on the north face of 
Crescent Mountain."

#gcost 290
#rcost 1
#size 4
#hp 38
#prot 5
#mor 12
#mr 17
#enc 3
#str 18
#att 9
#def 8
#prec 10
#ap 14
#mapmove 2
#okleader
#magicskill 5 1
#magicskill 6 1
#magicskill 7 1
#custommagic 30720 100
#custommagic 30720 100
#custommagic 30720 10
#forestsurvival
#mountainsurvival
#maxage 300
#startage 500
#holy

#weapon "Quarterstaff"
#armor "Furs"
#nametype 116
#female
#end






---- HEROES



--Crescent Hermit

#newmonster 2420
#spr1 "./Vaettiheim/Vaetti Hermit.tga"
#spr2 "./Vaettiheim/Vaetti Hermit2.tga"
#name "Crescent Hermit"

#descr "When the Vaetti scouts found the Crescent Woods and identified them as a suitable final destination of the great journey, they rushed to return to the main body of the people to tell them the good news. At least most of them did. One scout, too tired and weak to return, was left behind and began to climb Crescent Mountain, seeking no more than a place to die in peace. None can say what happened to him as he climbed to the very peak, but when the Vaetti finally arrived they soon learned of a mage feared by the Spero and upon contacting this enigmatic figure, found it was the scout. He is adept in a form of magic alien to the Vaetti; the magic of mountain peaks are fierce storms. It was this reclusive hermit that first arranged negotiations between the spero chiefs and the Gygjas and it is said when the Vaetti face great danger he will descend from the mountain and come to their aid."

#size 1
#rcost 1
#hp 7
#mor 9
#mr 14
#enc 3
#str 8
#att 8
#def 8
#prec 9
#ap 10
#mapmove 2
#poorleader
#weapon "Dagger"
#armor "Leather Cuirass"
#armor "Leather Cap"
#forestsurvival
#mountainsurvival
#stealthy 0
#nametype 116
#magicskill 1 2
#magicskill 4 1
#magicskill 6 2
#gcost 1
#itemslots 31878
#maxage 90
#startage 70
#end




--Werewolf Assassin


#newmonster 2399
#spr1 "./Vaettiheim/Black Werewolf.tga"
#spr2 "./Vaettiheim/Black Werewolf2.tga"
#name "Black Werewolf Assassin"
#descr "This poor soul was once an assassin in the employ of the Marignese inquisition whose skills made
 him the weapon of choice aginst enemies of the church. It was his misfortune, however, to be sent 
against a baron in the bordering lands of Ulm. As the assassin attacked the Baron transformed into a werewolf and a terrible struggle for survival ensued. Though he eventualy managed to impale him on a silver candle stick,
 the assassin recieved many bites in the process and soon discoved he had contracted Lythantropy himself. Not 
being foolish enough to return to the inquisition in such a state, he instead took to wandering, and eventually 
found a place in the halls of the Wolf Kin, renouncing his human form forever."
#size 3
#gcost 1
#rcost 1
#hp 23
#prot 6
#mor 15
#mr 14
#enc 2
#str 14
#att 14
#def 13
#prec 8
#ap 16
#mapmove 3
#weapon 20 -- bite
#weapon 29 -- claw
#weapon 29 -- claw
#regeneration 10

#forestsurvival
#stealthy 20
#nametype 114
#noleader
#itemslots 31878
#maxage 200
#assassin
#end




--Troll Wildrider

#newmonster 2398
#copyspr 1086
#name "Troll Wildrider"
#descr "This famed Wolf Troll displayed incredible determination in a series of battles with a rampaging minotaur berserker. The two clashed again and again; each time the troll was struck down and each time he somehow managed to get to his feet and continue the pursuit, determined to remove the threat to the Gygjas. Unable to catch the enraged creature on foot he desperately clambered onto a particularly large and vicious looking forest moose. The rest is history; the triumphant Wildrider took his foes' massive flail as a trophy and continues to protect Vaetti territory mounted on the strongest of the moose herd that year."
#size 5
#gcost 1
#rcost 1
#hp 60
#prot 11
#mor 16
#mr 14
#enc 3
#str 24
#att 13
#att 12
#prec 8
#mapmove 3
#ap 24
#fireres -25
#darkvision 50
#mountainsurvival
#forestsurvival
#armor "Dire Wolf Furs"
#holy
#standard 10
#regeneration 30
#neednoteat
#coldres 25
#maxage 400
#mounted
#weapon 353
#mounted
#okleader
#holy
#weapon 353
#weapon "flail"
#weapon "antlers"
#end


--White Werewolf

#newmonster 2397
#spr1 "./Vaettiheim/White Werewolf.tga"
#spr2 "./Vaettiheim/White Werewolf2.tga"
#name "White Werewolf"
#descr "The infamous White Werewolf of the Crescent Woods is the leader of a truly massive pack of lycanthropes who have chosen never to revert to human form. He is a ferocious fighter and due to his dedication to protecting the woods, he has become something of a religious symbol to the Vaetti; proof of their blessed nature. The White Werewolf can call his brethren to aid him."
#size 3
#gcost 1
#rcost 1
#hp 34
#prot 8
#mor 20
#mr 14
#enc 2
#str 17
#att 14
#def 13
#prec 8
#ap 16
#mapmove 3
#weapon 20 -- bite
#weapon 29 -- claw
#weapon 29 -- claw
#regeneration 25
#forestsurvival
#stealthy 10
#nametype 114
#goodleader
#itemslots 31878
#maxage 200
#makemonster3 2406
#holy
#end 


---- PRETENDERS


--Crescent Moon Wolf


#newmonster 2396
#copyspr 1229
#name "Wolf of the Crescent Moon"
#descr "This giant wolf-mother of Crescent Woods is as ancient as the moon itself and draws constant power from it. While she is within her own hunting grounds many wolves will follow the powerful lunar pull and form a pack to protect their patron goddess. In addition to her feral understanding of the magic of wood and wild, she can howl in tune with the music of the spheres. Her great size and ferocity brings fear to the hearts of the bravest intruders. She is stronger while in a forest and more wolves will hear her call."
#magicskill 6 1
#magicskill 4 1
#stealthy 20
#goodleader
#forestsurvival
#startdom 3
#coldres 25
#fear 2
#itemslots 12288
#mountainsurvival
#size 6
#gcost 75
#pathcost 80
#weapon 20
#hp 90
#prot 9
#mor 30
#mr 18
#enc 2
#str 23
#att 12
#def 11
#prec 9
#ap 30
#mapmove 3
#restrictedgod 88

#domsummon2 "wolf"
#forestshape 2395
#darkvision 100
#maxage 2000
#end

--Crescent Moon Wolf


#newmonster 2395
#copyspr 1229
#name "Wolf of the Crescent Moon"
#descr "This giant wolf-mother of Crescent Woods is as ancient as the moon itself and draws constant power from it. While she is within her own hunting grounds many wolves will follow the powerful lunar pull and form a pack to protect their patron goddess. In addition to her feral understanding of the magic of wood and wild, she can howl in tune with the music of the spheres. Her great size and ferocity brings fear to the hearts of the bravest intruders. She is stronger while in a forest and more wolves will hear her call."
#magicskill 6 1
#magicskill 4 1
#stealthy 20
#goodleader
#forestsurvival
#coldres 25
#fear 2
#itemslots 12288
#mountainsurvival
#size 6
#gcost 75
#weapon 20
#hp 110
#prot 9
#mor 30
#mr 18
#enc 2
#str 25
#att 13
#def 12
#prec 9
#ap 30
#mapmove 3
#domsummon "wolf"
#plainshape 2396
#darkvision 100
#maxage 2000
#end



--Father of Winters


#newmonster 2393
#copyspr 1561

#copystats 1561

#restrictedgod 88


#end

--Monolith


#newmonster 2394
#copyspr 657

#copystats 657

#restrictedgod 88


#end





---SPELLS


#newspell
#name "Wolfcall"
#descr "Calls some lesser wolves of the Crescent Woods to join your forces. The more powerful the caster the more wolves will be attracted." 
#school 0
#restricted 88

#researchlevel 0
#path 0 6
#pathlevel 0 1
#effect 10001
#fatiguecost 200
#damage 284
#nreff 1007
#end


#newspell
#name "Wolves of the Crescent"
#descr "A pack of the largest and most aggressive wolves of the Crescent Woods surges to protect the caster and hunt down his enemies."
#school 0
#restricted 88

#researchlevel 3
#path 0 6
#pathlevel 0 2
#effect 10001
#fatiguecost 1200
#damage 1224
#nreff 18
#end




---- MAGIC SITES



#newsite 887

#name "Crescent Mountain"


#path 3


#level 0


#rarity 5


#gems 4 1

#homemon 2408
 -- Spero Warrior
#homecom 2414 -- Spero Chief
#end



#newsite 888
#name "Crescent Wood"

#path 6

#level 0

#rarity 5

#gems 6 1
#gems 5 1

#homecom 2419 -- Gygja
#end

#newsite 889
#name "Troll Stomping Grounds"
#path 6
#level 0
#rarity 5
#gems 3 1
#homemon 2410
#homecom 2417
#end







---- NATION

#selectnation 88



#clearnation

#clearsites

#name "Vaettiheim"

#epithet "Exiled Tribes"

#startsite "Crescent Mountain"

#startsite "Troll Stomping Grounds"
#startsite "Crescent Wood"


#templepic 12

#era 3

#flag "./Vaettiheim/vaettiflag.tga"

#descr "The Vaetti, once allies of the Jotun, were in recent times displaced by human settlers.
When starvation finaly forced them to leave the lands of Jotun, a few of the remining, disatisfied
Gygjas were convinced to lead to them into exile. Years of wandering eventually brought them to the lands of the crescent moon, a place occupied by tribes of winged Spero and trolls. 
In the time since the exile, Vaetti elites have risen to take the place of the giants in their society,
and the Gygjas have been more accepting of Vaetti magic."

#summary "Race: Small, stealthy troops, prefers cold scale +1


Military: Light Vaetti infantry, wolf riders, flying Spero
, powerful trolls

Magic: Nature, Death, Astral, Blood

, Earth 	
Priests: Weak"

#brief "Gygjas skilled in sorcery oversee tribes of exiled Vaetti who have become steadily more organized
 and independent."

#color 0.1 0.5 0.3


--Sets what forts they will use.

#startfort 42
#defaultfort 7

#farmfort 7
#mountainfort 9
#swampfort 11
#forestfort 34

--Causes them to prefer cold 1.

#idealcold 1


--Gives them their heroes.

#hero1 2420 -- Crescent Hermit
#hero2 2399 -- Werewolf Assassin
#hero3 2398 -- Troll Wildrider
#hero4 586 -- High Gygja (Angerboda)
#hero5 2397 -- White Werewolf

--Sets all the recruitable units.

#addrecunit 2400 -- Vaetti Spear
#addrecunit 2402 -- Vaetti Archer
#addrecunit 2401 -- Vaetti Netter
#addrecunit 2403 -- Vaetti Groundbreaker
#addrecunit 2404 -- Wolf Rider
#addrecunit 2406 -- Werewolf
#addrecunit 2405 -- Moose Riders
#addrecunit 2409 -- Forest Troll
#addrecunit 2407 -- Exile Guard

#addreccom 2412 -- Vaetti Scout
#addreccom 2411 -- Chief
#addreccom 2415 -- Vaetti Hag
#addreccom 2413 -- Wolf Lord
#addreccom 2416 -- Vaetti Sorcerer


--addreccom 2420 -- Crescent Hermit
--addreccom 2399 -- Werewolf Assassin
--addreccom 2398 -- Troll Wildrider
--addreccom 586 -- High Gygja 
--addreccom 2397 -- White Werewolf



#defcom1 2411

#defcom2 2413

#defunit1 2400

#defunit1b 2409
#defunit2 2402
#defunit2b 2404



#defmult1 20
#defmult1b 4
#defmult2 10
#defmult2b 7


#startcom 2411
#startunitnbrs1 20

#startunitnbrs2 10
#startunittype1 2400

#startunittype2 2402
#startscout 2412
#end




-modname "LA Nation: Jomon, Broken Swords"
-description "LA Nation: Jomon, Broken Swords. A thematic alternative to LA Jomon."
-icon "./Jomon Broken/logo.tga"
-version 1.4

-- version 1.4

-- FIX - Akurojin summon works properly

-- FIX - Akurojin no longer gets stupid short sword

-- TWEAK - Akurojin cheaper

-- FIX - IDs remapped to meet MC standards


-- version 1.3

-- CONTENT - Added Rukurokubi summon

-- CONTENT - Added Akurojin summon

-- CONTENT - Added Jikininki Ashigaru summon

-- TWEAK - O-Toyo goldcost decreased by 20

-- TWEAK - Better sound effects for the crimson twins

-- TWEAK - Kyuuketsuki more expensive

-- TWEAK - Fox Kunoichi cheaper

-- TWEAK - Sheathless new sprite, more expensive, more hp

-- TWEAK - Handmaidens cheaper

-- TWEAK - Nekoni attack sprite improved

-- FIX - Ronin of Hooves now has Katana

-- TWEAK - Sickle Toss has net effect

-- FIX - Bunshichi and Bunraku puppets no longer consume supplies


-- version 1.2

-- CONTENT - Added more pretender selection choices

-- TWEAK - Twisted Daimyo mr +1

-- TWEAK - improved fox chunin


-- version 1.1

-- TWEAK - Cost of daimyo and red musume lowered

-- TWEAK - Kyuuketsuki and O-Toyo magic boosted considerably

-- TWEAK - mr value of every unit in the nation checked and improved to suitable levels

-- TWEAK - Dog Samurai goldcost reduced

-- TWEAK - Various undead and demons got extra resistance to fire, cold, poison

-- TWEAK - Various demons and halfbreeds reduced to enc 2


-- version 1.0

-- TWEAK - Thrall cavalry now cheaper



-- Version 0.9

-- Checked IDs against CBM1.21, LA Zepath nations (for future reference)

-- CONTENT - New Cur Scout commander

-- CONTENT - New Kyuuketsuki graphic (well, sort of)

-- TWEAK - Gave crimson twins hero a onebattlespell of astral shield

-- TWEAK - hero ronin of hooves gets far less autosummons, added hoof attack

-- TWEAK - added incunrest to Krasue

-- FIX - Gaki Tongue weapon now armor piercing

-- FIX - updated starting commander and scout

-- FIX - sorted itemslots for ronin of hooves and crimson twins




-- Sites - 980, 981

-- nation - 83

-- weapons - 798-647

-- monsters - 2250-2287

-------- WEAPONS --------

---- NEW


-- Gaki Blade

#newweapon 798
#name "Gaki Blade"
#rcost 1
#dmg 6
#secondaryeffect 54 -- paralyzing poison
#att 1
#def 0
#len 1
#end


-- The Horror

#newweapon 799
#name "The Horror"
#rcost 1
#dmg 0
#nostr
#dt_stun
#armornegating
#nratt 2
#ammo 40
#secondaryeffectalways 139
#range 100
#sound 22
#bonus
#end


-- The Unspeakable

#newweapon 800
#name "The Unspeakable"
#rcost 1
#dmg 0
#nostr
#dt_stun
#armornegating
#nratt 2
#ammo 40
#secondaryeffectalways 396
#range 100
#sound 22
#bonus
#end


-- The Ineffable

#newweapon 801
#name "The Ineffable"
#rcost 1
#dmg 0
#nostr
#dt_stun
#armornegating
#nratt 2
#ammo 40
#secondaryeffectalways 196
#range 100
#sound 22
#bonus
#end


-- Sickle Toss

#newweapon 802
#name "Sickle Toss"
#rcost 2
#dmg 4
#att 3
#ammo 1
#flyspr 304 4
#flail
#range 6
#secondaryeffect 263
#end


-- Kusarigama

#newweapon 803
#name "Kusarigama"
#rcost 5
#dmg 5
#att 1
#def 1
#len 4
#nratt 3
#twohanded
#flail
#end


-- Tetsubo
#newweapon 804
#name "Tetsubo"
#rcost 4
#dmg 9
#att 0
#def 0
#len 3
#twohanded
#sound 10
#end


-- Snarling Nodachi
#newweapon 805
#name "Snarling Nodachi"
#rcost 7
#dmg 11
#att 2
#def 1
#len 3
#twohanded
#sound 78 -- lion sound
#secondaryeffect 51 -- strong poison
#magic
#end


-- Gaki Tongue
#newweapon 806
#name "Gaki Tongue"
#rcost 0
#bonus
#len 4
#nostr
#dmg 6
#armorpiercing
#secondaryeffect 333 -- eyeloss
#sound 9 -- whip
#end


-- Cry of Anguish

#newweapon 807
#name "Cry of Anguish"
#rcost 1
#dmg 0
#nostr
#dt_cap
#nratt 1
#ammo 40
#secondaryeffectalways 255 -- Area Fear aoe 10
#range 10
#sound 23
#explspr 10060 -- rising black mist
#bonus
#end

-- Hitodama (unearthly fire)

#newweapon 808
#name "Hitodama Fire"
#armorpiercing
#rcost 1
#fire
#dmg 0
#nratt 2
#secondaryeffect 64 -- Decay
#bonus
#end



-- 


-------- ARMOUR ---------


---- NEW



-------- UNITS ----------


-- UNDEAD


-- Bunshichi Puppet

#newmonster 2274
#spr1 "./Jomon Broken/Bunshichi Puppet.tga"
#spr2 "./Jomon Broken/Bunshichi Puppet2.tga"
#name "Bunshichi Puppet"
#descr "With the coming of the awakening God and the rule of the Nekoni, many spirits and fiends have returned to Jomon. The Bunshichi are a sect of Bunraku Kami obsessed with the complex dance of swordsmanship and warfare. Like the Bunraku they are able to remove the soul from a hapless peasant and manipulate the body as a bizarre puppet. While Bunraku Kami are master puppeteers and their puppets come very close to emulating the movements of a human, they tend to focus on minor details such as facial expressions and gestures. Thus their puppets are not particularly skilled fighters, though they are unnaturally resilient. The Bunshichi have little interest in such minor details and instead focus on decisive, sweeping movements of the body and limbs. As a result Bunshichi puppets are far more dangerous than their Bunraku counterparts. Though well armed and armoured, the puppet is still a peasant and may be easily replaced by the Kami should it be struck down in battle."
#weapon "No-Dashi"
#weapon "Steal Strength" 
#armor "Kabuto"
#armor "Heavy Samurai Armor"
#mor 24
#hp 16
#prot 3
#coldres 100
#poisonres 100
#ap 14
#att 13
#def 13
#str 11
#enc 0
#mr 13
#rcost 1
#gcost 1
#nametype 134
#undead
#immortal
#ambidextrous 4
#neednoteat
#end



-- Bunraku Puppet

#newmonster 2271
#spr1 "./Jomon Broken/Bunraku Puppet.tga"
#spr2 "./Jomon Broken/Bunraku Puppet2.tga"
#name "Bunraku Puppet"
#descr "With the coming of the awakening God and the rule of the Nekoni, many spirits and fiends have returned to Jomon. Bunraku Kami, spirits with the power to sever a body from its soul and control it like a puppet, have struck a bargain with the female rulers of Jomon. In return for freedom to prey upon the peasant population, they have agreed to supplement the forces of Jomon. Bunraku puppets are effectively peasant bodies with no soul, their every movement controlled by a trio of ghostly Bunraku Kami. Should the puppet be struck down within the dominion of Jomon, the Bunraku Kami will simply return to the capital to claim a new body. Though masterfully controlled, Bunraku Puppets are rather unresponsive combatants. Their utility stems from the Kami's total disregard for the puppet's wellbeing; they are unlikely to retreat and can sustain quite some damage before dropping. In addition to using the puppet to strike, the Kami may also drain the strength of their foes."
#weapon "Yari"
#weapon "Steal Strength" 
#armor "Jingasa"
#armor "Ashigaru Armor"
#mor 24
#hp 16
#prot 3
#coldres 100
#poisonres 100
#ap 12
#att 9
#def 9
#str 11
#enc 0
#mr 13
#rcost 1
#gcost 1
#nametype 134
#undead
#immortal
#ambidextrous 4
#neednoteat
#end



-- Handmaiden


#newmonster 2250
#spr1 "./Jomon Broken/Handmaiden.tga"
#spr2 "./Jomon Broken/Handmaiden2.tga"
#name "Handmaiden"
#descr "These ghoulish creatures were initially raised from the decimated female population to act as hidden servants of the new female nobility of Nekoni and Kyuuketsuki. Now in full control of Jomon, the demons and vampires have replaced their rather unsightly undead handmaidens with girls taken from the largely unscathed peasant population; servants fit for the light of day. The Handmaidens are now animated for use in battle, gifted long slashing claws and unnatural strength by dark rituals. These same rituals cause the teeth of the Handmaidens to grind and clack together incessantly; a problem resolved by the removal of their lower jaw."
#weapon "Claw"
#weapon "Claw"
#mor 24
#hp 11
#poisonres 100
#coldres 100
#ap 12
#att 11
#def 10
#str 13
#enc 0
#prot 6
#mr 10
#rcost 1
#gcost 1
#undead
#female
#nametype 133
#berserk 1
#end


-- Krasue

#newmonster 2251
#spr1 "./Jomon Broken/Krasue.tga"
#spr2 "./Jomon Broken/Krasue2.tga"
#name "Krasue"
#descr "Krasue are foul undead creatures that have plagued Jomon ever since the women of the capital were beheaded. They appear as partially decomposed heads which trail entrails from the severed neck as they fly around seeking soft flesh to sink their teeth into. They are called from the deep forests of Jomon by either Kyuuketsuki or occasionally Black Nekoni, then sent out against intruders. Their presence in a province increases unrest, as the Krasue terrorise the locals at night."
#weapon "Bite"
#hp 5
#size 1
#prot 0
#mor 50
#mr 12
#enc 1
#str 8
#att 9
#def 14
#prec 7
#mapmove 3
#ap 4
#gcost 1
#rcost 1
#undead
#coldres 100
#poisonres 100
#forestsurvival
#neednoteat
#incunrest 1
#swampsurvival
#stealthy 0
#flying
#maxage 700
#startage 28
#female
#nametype 133
#end


-- Gaki

#newmonster 2252
#spr1 "./Jomon Broken/Gaki.tga"
#spr2 "./Jomon Broken/Gaki2.tga"
#name "Gaki"
#descr "Gaki are minor fiends born when a person of perverse or otherwise abnormal appetites dies. In times past they were regarded with equal amounts pity and scorn, chased from civilisation by more powerful forces such as Bakemono and Oni. With the coming of the Nekoni and Kyuuketsuki to power the Gaki have emerged from hiding and directed their anger and hunger at the enemies of the awakening god. Their tongues can be as much as six feet long and end in a vicious barb. These lash out with frightening accuracy at the faces of those who strike against them and can cause serious damage to their opponent's eyes. They are not known for their bravery."
#weapon "Gaki Blade"
#weapon "Gaki Tongue"
#mor 9
#hp 13
#poisonres 100
#coldres 50
#ap 14
#stealthy 0
#att 10
#def 11
#str 11
#enc 2
#prot 5
#mr 10
#rcost 1
#gcost 1
#demon
#nametype 134
#end


-- Sheathless

#newmonster 2253
#spr1 "./Jomon Broken/Sheathless.tga"
#spr2 "./Jomon Broken/Sheathless2.tga"
#name "Sheathless One"
#descr "A samurai without a wife is a sword without a sheath, or so goes the Jomonese proverb. The Sheathless were the elite guard of the Taiko who at his command murdered every woman in the palace, including their own wives. As the nation descended into anarchy, every last one of these loyal retainers gave their lives covering the escape of the Taiko. The demonic female leaders of Jomon, in an act of cruel irony, reanimated them as a sacred elite. The nodachi they used to execute the women of the capital are now possessed with snarling minor oni which give the blades lethal extra bite and wrap them in unearthly burning venom."
#weapon "Snarling Nodachi"
#armor "heavy samurai armor"
#armor "kabuto"
#undead
#mr 12
#rcost 1
#prec 9
#enc 0
#hp 15
#str 11
#att 12
#def 12
#holy
#mor 30
#gcost 35
#coldres 100
#poisonres 100
#neednoteat
#nametype 134
#mapmove 2
#ap 12
#end


-- Jikininki Ashigaru

#newmonster 2285
#spr1 "./Jomon Broken/Jikininki.tga"
#spr2 "./Jomon Broken/Jikininki2.tga"
#name "Jikininki Ashigaru"
#descr "During the worst of times following the Taiko's sudden descent into madness, many men became monsters through their greed, pride and bloodlust. Jikininki Ashigaru were originally peasant soldiers who dug in the mass graves of Jomonese women, looking for loot. Night after night the soldiers would return to dig through the thousands of corpses, occasionally finding a trinket gleaming in the mire. Soon they became consumed with their grisly work, sleeping in the day and digging all night. Unable to leave the graves, many starved and those remaining began to feast on the dead. Finally, wracked with exhaustion, disease and consuming guilt, they lay down and died. Now the wretched Jikininki are mere puppets of the Buried, pulled from their graves to take vengeance on a cruel world. Dirt, roots and muck hold their decaying bodies together and grant them incredible resilience, though they are highly vulnerable to fire."
#weapon "Spear"
#armor "Ashigaru Armor"
#armor "Jingasa"
#undead
#mr 12
#prot 5
#rcost 0
#prec 5
#enc 0
#hp 23
#str 14
#att 8
#def 8
#mor 50
#gcost 0
#coldres 100
#poisonres 100
#neednoteat
#nametype 134
#mapmove 1
#ap 8
#regeneration 50
#fireres -50
#end


-- Akurojin

#newmonster 2287
#copystats 1441 -- flame corpse (for explosion on death)
#spr1 "./Jomon Broken/Akurojin.tga"
#spr2 "./Jomon Broken/Akurojin2.tga"
#name "Akurojin"
#descr "As the capital ran with the blood of slaughtered women, those who managed to flee faced an equal horror as they crossed the checkpoints surrounding the capital. Manned by bandits, ronin and criminals seeking a reward for following the Taiko's decree, they preyed on the refugees, butchering the men and making a show of burning the women and children alive. For these acts they were cursed, hunted down by the Burned and raised to suffer in perpetual agony, roasted from within by unearthly flames. Akurojin, as these charred wretches are known, are physically fragile but terrifyingly destructive. They are accompanied by Hitodama, ghost flames that burn and decay all before them. When they are finally struck down their accumulated torment is unleashed in a fiery blast."
#weapon "None"
#weapon "Fist"
#weapon "None"
#weapon "Hitodama Fire"
#undead
#mr 16
#prot 0
#rcost 0
#prec 5
#enc 0
#hp 9
#str 9
#att 12
#def 11
#mor 50
#gcost 0
#coldres 100
#poisonres 100
#neednoteat
#nametype 134
#mapmove 2
#ap 8
#fireres 100
#fear 0
#firepower 1
#heat 4
#banefireshield 8
#end


-- THRALLS

-- Samurai Thrall (Naginata)

#newmonster 2254
#copystats 1240
#copyspr 1240
#name "Samurai Thrall"
#descr "The once proud samurai are now shadows of their former selves. The katana, symbol of Samurai status and representation of their souls, has been forbidden. Furthermore the thralls have lost much of their bravado and are weakened by nightly rituals of the women who drain their strength. Though they still fight with skill, they are regarded as expendable and expected to do little more than hold the enemy off with polearms. Stronger thralls generally take possession of the more respected Naginata by force."
#mor 9
#str 10
#hp 9
#gcost 9
#nametype 134
#end

-- Samurai Thrall (Yari)

#newmonster 2255
#copystats 2254
#spr1 "./Jomon Broken/Yari Thrall.tga"
#spr2 "./Jomon Broken/Yari Thrall2.tga"
#name "Samurai Thrall"
#descr "The once proud samurai are now shadows of their former selves. The katana, symbol of Samurai status and representation of their souls, has been forbidden. Furthermore the thralls have lost much of their bravado and are weakened by nightly rituals of the women who drain their strength. Though they still fight with skill, they are regarded as expendable and expected to do little more than hold the enemy off with polearms. The weaker thralls are usually left with the simple Yari."
#weapon "Yari"
#mor 9
#str 9
#hp 9
#gcost 8
#nametype 134
#end


-- Samurai Thrall Cavalry

#newmonster 2256
#copystats 1246
#spr1 "./Jomon Broken/Thrall Cavalry.tga"
#spr2 "./Jomon Broken/Thrall Cavalry2.tga"
#name "Samurai Thrall Cavalry"
#descr "The once proud samurai are now shadows of their former selves. The katana, symbol of Samurai status and representation of their souls, has been forbidden. Furthermore the thralls have lost much of their bravado and are weakened by nightly rituals of the women who drain their strength. Thrall cavalry are sometimes used; they are still heavily armoured and well trained, though they lack both the katana and warrior spirit of their grandfathers."
#weapon "Mace"
#weapon "Lance"
#weapon 56 -- hoof
#mor 9
#str 9
#att 11
#def 11
#mapmove 3
#ap 24
#mounted
#size 3
#ressize 2
#hp 10
#gcost 28
#enc 5
#nametype 134
#end


-- Bandit Cur

#newmonster 2257
#copystats 1238
#spr1 "./Jomon Broken/Bandit Cur.tga"
#spr2 "./Jomon Broken/Bandit Cur2.tga"
#name "Bandit Cur"
#descr "In breaking the spirit of the Samurai the women of Jomon ensured their grip on power, but they soon realised that broken men make for poor soldiers. In the process of creating the Dog Samurai the new masters of Jomon emptied the prisons with various cruel experiments. Bandit Curs are effectively forerunners of Dog Samurai, a mix of lessor dog demon and convicted criminal. They are capable of infiltrating enemy provinces and have some degree of canine loyalty, but they are not particularly adept soldiers and are extremely vulnerable to magic. All halfbreeds can cover long distances without tiring."
#mor 11
#ap 14
#mapmove 3
#stealthy
#weapon "short bow"
#weapon "mace"
#armor "ashigaru armor"
#armor "jingasa"
#demon
#gcost 9
#mr 8
#enc 2
#nametype 134
#end


-- Dog Samurai

#newmonster 2258
#copystats 1241
#spr1 "./Jomon Broken/Dog Samurai.tga"
#spr2 "./Jomon Broken/Dog Samurai2.tga"
#name "Dog Samurai"
#descr "In breaking the spirit of the Samurai the women of Jomon ensured their grip on power, but they soon realised that broken men make poor soldiers. Seeking a loyal rather than servile soldier they created the Dog Samurai; a hybrid of a vicious dog demon and a human warrior. Though they are not heavily built Dog Samurai have excellent morale and make fierce fighters with impressive appetites. They are armed with great iron Tetsubo capable of doing considerable damage. All halfbreeds can cover long distances without tiring."
#weapon "tetsubo"
#armor "heavy samurai armor"
#mor 14
#hp 11
#gcost 12
#ap 14
#mapmove 3
#att 11
#def 11
#supplybonus -1
#demon
#nametype 134
#mr 10
#enc 2
#end


-- DEMONS

-- Fox Chunin

#newmonster 2275
#spr1 "./Jomon Broken/Fox Chunin.tga"
#spr2 "./Jomon Broken/Fox Chunin2.tga"
#name "Fox Chunin"
#descr "Having created a loyal guard in the form of the Dog Samurai, the Nekoni pushed yet further in their arts, drawing essence from the four Fox Demons in order to create a new breed; an elite covert force as deadly as the Dogs were loyal. A hybrid of complex female form and capricious Demon Fox essence, the Fox Chunin are stealthy, cunning and skilled. They are commonly dispatched to strike deep in enemy territory under the command of a Kunoichi."
#weapon "Ninjato" 
#armor "Chain Mail Cuirass"
#armor "Reinforced Leather Cap"
#mor 13
#hp 10
#prot 0
#ap 15
#att 13
#def 14
#str 10
#enc 2
#mr 13
#rcost 1
#gcost 18
#nametype 133
#female
#demon
#stealthy 15
#ambidextrous 3
#mapmove 3
#end


-- Nekoni

#newmonster 2259
#clear
#spr1 "./Jomon Broken/Nekoni.tga"
#spr2 "./Jomon Broken/Nekoni2.tga"
#name "Nekoni"
#descr "Nekoni are giant female cat demons of great strength and cunning who were forced into exile an age ago by male Oni and their numerous Bakemono servants. They played a major role in engineering the disasters which befell the natural female population of Jomon. Most of their time is spent in the guise of a beautiful and innocent young maiden; they take many samurai males as their husbands and completely dominate them, feeding off their life energy to remain strong. When time comes for battle they transform into their true selves and tear through the ranks of the enemy. The common blood red Nekoni lack the sophistication and magical prowess of their leaders, the elusive Black Nekoni, but are equally hard to finish off; when gravely wounded they adopt their stunning maiden-guise. Their shapeshifting talent also allows them to travel undetected in enemy lands."
#secondshape 2260
#hp 22
#ap 16
#mapmove 3
#forestsurvival
#stealthy 10
#demon
#prot 3
#att 13
#def 12
#str 20
#size 3
#weapon "Bite"
#weapon "Claw"
#armor "leather cuirass"
#ambidextrous 4
#mor 15
#mr 11
#gcost 70
#enc 2
#rcost 5
#regeneration 10
#nametype 133
#end

-- Neko Maiden

#newmonster 2260
#copystats 1242
#clear
#spr1 "./Jomon Broken/Nekoni Maiden.tga"
#spr2 "./Jomon Broken/Nekoni Maiden.tga"
#name "Neko Maiden"
#descr "A gravely wounded Nekoni trying to survive in the guise of an innocent maiden. The red tail and ears of the Nekoni may still be spotted by those with strong willpower."
#awe 3
#mor 0
#ap 8
#hp 5
#att 5
#def 5
#str 5
#mr 10
#demon
#str 6
#firstshape 2259
#nametype 133
#end






------- COMMANDERS


-- THRALLS


-- Thrall Vassal

#newmonster 2261
#copystats 1249
#spr1 "./Jomon Broken/Samurai Vassal.tga"
#spr2 "./Jomon Broken/Samurai Vassal2.tga"
#name "Thrall Vassal"
#descr "These minor Samurai leaders lack the power to claim the position of Daimyo. They are rarely entrusted with tasks of great import and usually only lead small groups of Samurai into battle. They are numerous enough, but with the rise of the loyal Dog Samurai, their days may be numbered. The female rulers of Jomon generally take several such vassals as husbands and it is rare that their 'favourites' are actually sent to the frontlines; those given such duties are considered expendable."
#weapon "tetsubo"
#armor "Samurai armor"
#mor 10
#hp 10
#str 10
#att 11
#gcost 20
#okleader
#nametype 134
#end


-- Cur Scout


#newmonster 2279
#copystats 1238
#spr1 "./Jomon Broken/Bandit Cur.tga"
#spr2 "./Jomon Broken/Bandit Cur2.tga"
#name "Cur Scout"
#descr "In breaking the spirit of the Samurai the women of Jomon ensured their grip on power, but they soon realised that broken men make for poor soldiers. In the process of creating the Dog Samurai the new masters of Jomon emptied the prisons with various cruel experiments. Bandit Curs are effectively forerunners of Dog Samurai, a mix of lessor dog demon and convicted criminal. Those with slightly above average intelligence are employed as scouts, travelling ahead of the Jomonese forces alone to discover enemy troop movements."
#mor 11
#ap 14
#mapmove 3
#stealthy 10
#weapon "short bow"
#weapon "mace"
#armor "ashigaru armor"
#armor "jingasa"
#demon
#gcost 1
#mr 8
#nametype 134
#enc 2
#end


-- Dog Vassal

#newmonster 2262
#copystats 2261
#spr1 "./Jomon Broken/Dog Vassal.tga"
#spr2 "./Jomon Broken/Dog Vassal2.tga"
#name "Dog Vassal"
#descr "In breaking the spirit of the Samurai the women of Jomon ensured their grip on power, but they soon realised that broken men make poor soldiers. Seeking a loyal rather than servile soldier they created the Dog Samurai; a hybrid of a vicious dog demon and a human warrior. Though they are not heavily built Dog Samurai have excellent morale and make fierce fighters with impressive appetites. They are armed with great iron Tetsubo capable of doing considerable damage. Dog Vassals are selected by ability rather than bloodline; they make trusted and valuable commanders, though humans are reluctant to follow them. All halfbreeds can cover long distances without tiring."
#mor 15
#hp 12
#ap 14
#mapmove 3
#poorleader
#okundeadleader
#demon
#supplybonus -2
#gcost 30
#nametype 134
#enc 2
#armor "Heavy Samurai Armor"
#end


-- Twisted Daimyo

#newmonster 2263
#spr1 "./Jomon Broken/Twisted Daimyo.tga"
#spr2 "./Jomon Broken/Twisted Daimyo2.tga"
#name "Twisted Daimyo"
#descr "Unlike most men, the Daimyo of Jomon were not drained of strength and made servile by their new wives. Instead they were seduced with promises of eternal life and absolute power, corrupted and twisted into a mixture of man and Oni. Their faces remain entirely human but the rest of their body now resembles that of the ancient Oni and they are physically very powerful. Even the red Nekoni respect and fear these warlords, masters of large numbers of both Samurai thralls and loyal halfbreeds. Their appetite is legendary and they are notorious for flying into a drunken rage in battle, fuelled by rice wine and blood."
#att 14
#def 13
#str 18
#prec 9
#mor 16
#mr 13
#hp 30
#ap 14
#mapmove 2
#weapon "no-dashi"
#armor "heavy samurai armor"
#armor "kabuto"
#goodleader
#goodundeadleader
#berserk 4
#demon
#gcost 70
#rcost 1
#enc 2
#size 3
#supplybonus -3
#nametype 134
#end



-- FEMALES



-- Fox Kunoichi

#newmonster 2276
#spr1 "./Jomon Broken/Fox Kunoichi.tga"
#spr2 "./Jomon Broken/Fox Kunoichi2.tga"
#name "Fox Kunoichi"
#descr "Having created a loyal guard in the form of the Dog Samurai, the Nekoni pushed yet further in their arts, drawing essence from the four Fox Demons in order to create a new breed; an elite covert force as deadly as the Dogs were loyal. A hybrid of complex female form and capricious Demon Fox essence, the Fox Chunin are stealthy, cunning and skilled. They are commonly dispatched to strike deep in enemy territory under the command of a Kunoichi. Fox Kunoichi are marked by their second tail, showing their strong connection to the four Fox Demons. They have perfected the use of the Kusarigama, a lethal weapon consisting of a sickle and blade joined by a chain. All Kunoichi are trained in the art of assassination and when not leading the Chunin, operate as solitary hunters of men."
#weapon "Kusarigama" 
#weapon "Sickle Toss"
#armor "Chain Mail Cuirass"
#armor "Reinforced Leather Cap"
#mor 14
#hp 12
#prot 0
#ap 15
#att 14
#def 15
#str 10
#enc 2
#mr 14
#rcost 1
#gcost 60
#nametype 133
#female
#demon
#stealthy 20
#ambidextrous 3
#assassin
#okundeadleader
#poorleader
#mapmove 3
#end



-- Kyuuketsuki

#newmonster 2264
#spr1 "./Jomon Broken/Kyuuketsuki.tga"
#spr2 "./Jomon Broken/Kyuuketsuki2.tga"
#name "Kyuuketsuki"
#descr "These flying female vampires drain blood through their long fingernails and are able to mimic the voice of any human being. They are able to travel by night as shadows and strike at enemy commanders. Their immortality has so far prevented the Black Nekoni from striking against them and attempting to seize power entirely for themselves. The Kyuuketsuki are as adept at dark magic as they are at assassination and slaughter."
#flying
#undead
#stealthy 20
#assassin
#weapon "claw"
#weapon "life drain"
#magicskill 5 2
#magicskill 7 3
#custommagic 1664 100
#gcost 1
#enc 1
#att 13
#str 15
#def 12
#hp 18
#mapmove 3
#ap 12
#poorleader
#goodundeadleader
#immortal
#mr 14
#female
#nametype 133
#darkpower 1
#poisonres 100
#coldres 100
#end

-- Rokurokubi

#newmonster 2286
#spr1 "./Jomon Broken/Rokurokubi.tga"
#spr2 "./Jomon Broken/Rokurokubi2.tga"
#name "Rokurokubi"
#descr "Rokurokubi are nightmarish corporeal spirits that have long preyed on the unwary of Jomon. With the coming of the Women from the East they have become far more active, gripping entire villages with fear and roaming the land at night seeking victims. Rokurokubi appear to be attractive young women from a distance, though if approached they will be unable to restrain themselves and will reveal their true form. They have obscenely long necks and their faces are frozen in masks of screaming horror. To come close to the face of a Rokurokubi is to know pure terror and even at range they are capable of whipping their heads forward to produce reverberating, unsettling screams and cries of anguish. Like the Buried, Drowned and Burned the Rokurokubi have thusfar shown no interest in the growing power struggle between the Nekoni and Kyuuketsuki."
#att 11
#def 11
#str 15
#hp 14
#ap 12
#mor 15
#mapmove 3
#weapon "Venomous Bite"
#weapon "Cry of Anguish"
#female
#undead
#neednoteat
#forestsurvival
#darkvision 100
#enc 1
#stealthy 20
#gcost 0
#fear 8
#maxage 2500
#startage 450
#noleader
#nametype 133
#mr 14
#end

-- O-Toyo

#newmonster 2265
#copyspr 1436
#name "O-Toyo"
#descr "The Black Nekoni spend the majority of their time in the guise of a noblewoman of startling beauty and poise. Their beauty and charisma is such that even enemy officials will literally fight for the chance to pass them crucial information and few men can resist the offer of being brought back to the capital for a night of pleasure. The cost, of course, is their souls. If in mortal danger she will change to her true shape, that of a monstrous cat demon, and fight ferociously. The Black Nekoni are powerful sorceresses and have mastered a form of limited immortality; they will heal any wounds dealt to them over time."
#att 8
#def 8
#str 8
#hp 9
#ap 12
#mor 15
#mapmove 3
#weapon "dagger"
#female
#demon
#enc 2
#flying
#succubus 15
#spy
#stealthy 20
#magicskill 7 2
#magicskill 5 1
#custommagic 1664 100
#custommagic 1664 100
#custommagic 1664 20
#custommagic 20480 100
#custommagic 20480 20
#awe 4
#gcost 300
#heal
#shapechange 2266
#secondshape 2266
#maxage 2500
#startage 450
#goodleader
#nametype 133
#mr 15
#end

-- Black Nekoni

#newmonster 2266
#spr1 "./Jomon Broken/Black Nekoni.tga"
#spr2 "./Jomon Broken/Black Nekoni2.tga"
#name "Black Nekoni"
#descr "The true form of the O-Toyo. Black Nekoni are the true rulers of Jomon, although they are not powerful enough to cast off entirely either their husbands the Daimyos or their allies, the bloodthirsty Kyuuketsuki."
#att 13
#def 13
#str 23
#mr 16
#mor 19
#hp 30
#ap 16
#mapmove 2
#weapon "claw"
#weapon "bite"
#stealthy 25
#demon
#size 3
#enc 2
#female
#assassin
#magicskill 7 2
#magicskill 5 1
#custommagic 1664 100
#custommagic 1664 100
#custommagic 1664 20
#custommagic 20480 100
#custommagic 20480 20
#gcost 320
#heal
#shapechange 2265
#maxage 2500
#startage 450
#poorleader
#goodundeadleader
#nametype 133
#itemslots 12288
#end

-- Buried

#newmonster 2267
#name "Buried"
#spr1 "./Jomon Broken/Buried.tga"
#spr2 "./Jomon Broken/Buried2.tga"
#descr "The spirit of an innocent girl who was buried alive in the capital under the orders of the Taiko. Unlike their sister spirits the Buried take a solid form; indeed their skin and flesh are as hard as rock. Because of their unique composition the bodies of the Buried are unaffected by lightning."
#magicskill 5 2
#magicskill 3 2
#prot 18
#undead
#female
#enc 0
#shockres 100
#poisonres 100
#coldres 100
#gcost 170
#size 1
#noleader
#startage 13
#nametype 133
#att 8
#def 8
#hp 7
#mr 14
#mor 30
#end

-- Drowned

#newmonster 2268
#clear
#name "Drowned"
#spr1 "./Jomon Broken/Drowned.tga"
#spr2 "./Jomon Broken/Drowned2.tga"
#descr "The spirit of an innocent girl who was drowned in the great well of the capital under the orders of the Taiko. The drowned are equally at home above or below water. In addition those trying to harm the spirit may find themselves bound by strong strands of kelp."
#magicskill 5 2
#magicskill 2 2
#poisonres 100
#coldres 100
#ethereal
#amphibian
#entangle
#undead
#female
#enc 0
#gcost 170
#size 1
#noleader
#startage 13
#nametype 133
#att 8
#def 8
#hp 7
#mr 14
#mor 30
#end

-- Burned

#newmonster 2269
#name "Burned"
#spr1 "./Jomon Broken/Burned.tga"
#spr2 "./Jomon Broken/Burned2.tga"
#descr "The spirit of an innocent girl who was burned to death in the capital under the orders of the Taiko. Any who try to strike the Burned will be blasted with a gout of fire."
#magicskill 5 2
#magicskill 0 2
#ethereal
#undead
#fireshield 12
#female
#enc 0
#fireres 100
#poisonres 100
#gcost 170
#size 1
#noleader
#startage 13
#nametype 133
#att 8
#def 8
#hp 7
#mr 14
#mor 30
#end

-- Shrinemaiden

#newmonster 2270
#clear
#copyspr 1433
#name "Shrine Maiden"
#descr "Pure maidens who are respected by the Nekoni. They consider themselves widowed to the sheathless and will not take any husbands. They are sacred to Jomon and are responsible for both the upkeep of the shrines and the gathering of willing sacrifices seduced in their dreams by purring feline spirits."
#magicskill 8 2
#magicskill 7 1
#holy
#female
#enc 3
#gcost 100
#poorleader
#poorundeadleader
#att 8
#def 8
#hp 9
#mr 12
#mor 12
#startage 18
#nametype 133
#end


-- Red Musume

#newmonster 2272
#spr1 "./Jomon Broken/Nekoni Maiden.tga"
#spr1 "./Jomon Broken/Nekoni Maiden2.tga"
#name "Red Musume"
#descr "Some common Red Nekoni have seductive powers which almost rival those of the ruling O-Toyo, or Black Nekoni. As long as they are not considered a threat to the status or power of their matron, they are permitted to put their skills to use seducing and enslaving the weak-willed men of other nations. Unlike O-Toyo, the Musume are unable to fly and so can only effectively ensnare those who come too close to Jomonese territory. The reverse of their more violent brethren, Red Musume will transform to their demonic feline form when injured."
#weapon "Poison Dagger"
#awe 3
#stealthy 15
#female
#enc 2
#gcost 150
#poorleader
#poorundeadleader
#att 8
#def 8
#hp 9
#mr 12
#mor 12
#startage 18
#nametype 133
#secondshape 2273
#seduce 12
#noleader
#demon
#end

-- Nekoni (Mesume)

#newmonster 2273
#spr1 "./Jomon Broken/Nekoni.tga"
#spr2 "./Jomon Broken/Nekoni2.tga"
#name "Nekoni"
#descr "A wounded Musume who has thrown off her guise to reveal her true form; that of an angry feline demon."
#hp 22
#ap 16
#mapmove 3
#forestsurvival
#stealthy 10
#demon
#prot 3
#att 13
#def 12
#str 20
#size 3
#weapon "Bite"
#weapon "Claw"
#armor "leather cuirass"
#ambidextrous 4
#mor 15
#mr 11
#gcost 200
#enc 2
#rcost 5
#regeneration 10
#nametype 133
#firstshape 2272
#itemslots 12288
#end



----- PRETENDER SELECTIONS

-- Lady of Love

#newmonster 2280
#copystats 1343
#copyspr 1343
#restrictedgod 92
#end

-- Celestial General

#newmonster 2281
#copystats 1345
#copyspr 1345
#restrictedgod 92
#end

-- Lord of Plenty

#newmonster 2282
#copystats 1339
#copyspr 1339
#restrictedgod 92
#end

-- Mother of Monsters

#newmonster 2283
#copystats 157
#copyspr 157
#restrictedgod 92
#end

-- Drakaina

#newmonster 2284
#copystats 1231
#copyspr 1231
#restrictedgod 92
#end

----- HEROES


-- Crimson Twins

#newmonster 2277
#name "Crimson Twins"
#spr1 "./Jomon Broken/Hero Twins.tga"
#spr2 "./Jomon Broken/Hero Twins2.tga"
#descr "Twins born to a farmer family, these girls gained fame for their ability to  hear the thoughts of those around them. Ever suspicious of those surrounding him, the Taiko purchased them to identify those vassals considering treachery. Yet from the moment they set foot in the capital, the twins would only speak of a great ruin coming from the East. Deeming the girls frauds the Taiko locked them up, ordered their family tortured to death and promptly forgot about them. Hovering between life and death in the bowels of the Taiko's dungeon, the girls experienced the combined suffering of the thousands of women executed in the capital and finally passed away. When the capital fell, their spirits emerged at the head of a legion of vengeful ghosts; the Burned, Drowned and Buried. In battle the twins act as a conduit for the ineffable horrors of the void, assaulting the minds of their foes with an endless barrage of unspeakable wrongs."
#ethereal
#undead
#female
#enc 0
#gcost 1
#size 1
#noleader
#startage 13
#nametype 133
#att 8
#def 8
#hp 7
#mr 22
#mor 50
#weapon "The Ineffable"
#weapon "The Unspeakable"
#weapon 269
#weapon "The Horror"
#onebattlespell "Astral Shield"
#itemslots 30720
#end


-- Ronin of Hooves


#newmonster 2278
#copystats 1253
#spr1 "./Jomon Broken/Hero Ronin.tga"
#spr2 "./Jomon Broken/Hero Ronin2.tga"
#name "Ronin of Hooves"
#descr "The Ronin of Hooves was once a cavalry commander in service of the Taiko. Unable to obey the command to slay his beloved wife, the commander fled with her and a group of men loyal only to him. The band roamed across the chaotic nation earning a reputation for both prowess in battle and fairness toward women. When his wife fell ill to the mysterious plague ravaging the female population, the now famous Ronin of Hooves turned to the powerful Eastern women for help. His wife was cured and the Ronin agreed to serve the Nekoni, leading the Thrall Cavalry into battle. Despite his name, the Ronin of Hooves offers perhaps the only chance for the lowly Thrall Samurai to restore their honour. Though he is a rather portly old man rather than a demonic Daimyo, the Ronin has kept his Katana and is respected by the female ruling class. As such, he attracts a steady stream of Thrall Cavalry to his banner."
#mor 13
#str 11
#att 12
#def 12
#expertleader
#hp 14
#standard 15
#gcost 1
#enc 5
#nametype 134
#mr 11
#summon1 2256 -- thrall cav
#makemonster2 2256 -- thrall cav
#older 20
#itemslots 29830
#weapon "Katana"
#end


--------------------------------------




-------- SPELLS ----------


-- New Spells


#newspell
#name "Call Kyuuketsuki"
#descr "Calls a Kyuuketsuki, a female vampire able to drain blood through its fingernails, to serve Jomon." 
#school 6
#restricted 92
#researchlevel 4
#path 0 7
#path 1 5
#pathlevel 0 2
#pathlevel 1 1
#effect 10021
#fatiguecost 4000
#damage 2264
#nreff 1
#end


#newspell
#name "Call Krasue"
#descr "Calls a score of Krasue, severed flying heads, to serve the will of the caster." 
#school 0
#restricted 92
#researchlevel 1
#path 0 5
#pathlevel 0 2
#effect 10001
#fatiguecost 600
#damage 2251
#nreff 20
#end


#newspell
#name "Gather Gaki"
#descr "Gathers together a small group of Gaki, ghoul-like undead born of those with unnatural appetites." 
#school 0
#restricted 92
#researchlevel 3
#path 0 5
#pathlevel 0 2
#effect 10001
#fatiguecost 700
#damage 2252
#nreff 12
#end


#newspell
#name "Gather Handmaidens"
#descr "Gathers a score of Handmaidens to the caster, ready to be unleashed upon the unsuspecting foe. Handmaidens are jawless female ghouls initially reanimated as nocturnal servants, but now granted surprising strength and slashing claws by dark enchantments."
#school 0
#restricted 92
#researchlevel 1
#path 0 5
#pathlevel 0 2
#effect 10001
#fatiguecost 800
#damage 2250
#nreff 20
#end


#newspell
#name "Bunraku Pact"
#descr "Entering a pact with a tribe of Bunraku Kami, the caster gives them free reign to prey on the peasant population. In return a number of Bunraku will take their puppets to war. Should the puppets be struck down, the Bunraku will return to the capital and take new hosts."
#school 0
#restricted 92
#researchlevel 4
#path 0 5
#pathlevel 0 2
#effect 10001
#fatiguecost 1000
#damage 2271
#nreff 10
#end


#newspell
#name "Bunshichi Pact"
#descr "By offering a small sect of Bunshichi Kami an endless supply of expendable puppets, the caster secures their services. Though Bunshichi puppets are frighteningly skilled warriors, without the Kami they are mere peasants and criminals, as easily replaced as the puppets of the less warlike Bunraku."
#school 0
#restricted 92
#researchlevel 5
#path 0 5
#pathlevel 0 3
#effect 10001
#fatiguecost 1200
#damage 2274
#nreff 6
#end


#newspell
#name "Raise Jikininki"
#descr "Raises six wretched Jikininki Ashigaru as puppets of the caster. The Jikininki were once peasant soldiers who looted and ate the corpses of Jomonese women who succumbed to the mysterious illness. They are slow and mindless creatures, but are granted incredible resilience by their connection to the grave."
#school 4
#restricted 92
#researchlevel 3
#path 0 5
#path 1 3
#pathlevel 0 2
#pathlevel 1 2
#effect 10001
#fatiguecost 400
#damage 2285
#nreff 6
#end

#newspell
#name "Call Rokurokubi"
#descr "Calls a Rokurokubi from its home forest or hunting ground to serve the caster. Rokurokubi are nightmarish corporeal spirits that resemble young maidens, but have terrifying faces and necks which can stretch several metres. Their primary weapon is fear, though like most corporeal spirits they are physically stronger than any human."
#school 0
#restricted 92
#researchlevel 4
#path 0 5
#pathlevel 0 3
#effect 10021
#fatiguecost 600
#damage 2286
#nreff 1
#end

#newspell
#name "Raise Akurojin"
#descr "Raises the remains of bandits who manned checkpoints around the capital, capturing and burning any women who tried to flee the slaughter. Charred beyond recognition and in constant torment as unearthly fire burns them from within, they are accompanied by floating fire known as Hitodama, which channel their rage. Though rather fragile physically, they can unleash powerful blasts of unearthly fire."
#school 4
#restricted 92
#researchlevel 4
#path 0 5
#path 1 0
#pathlevel 0 2
#pathlevel 1 2
#effect 10001
#fatiguecost 500
#damage 2287
#nreff 4
#end



-------- SITES -----------


#newsite 980

#name "Halls of the Capital"


#path 8
#level 0

#gems 0 1
#gems 2 1
#gems 3 1
#rarity 5
#homemon 2253
#end



#newsite 981
#name "The Bloodied Throne"


#path 7
#gems 5 1
#gems 7 1
#level 0


#rarity 5

#homecom 2265
#end




-------- NAMEPOOLS -------


-------- NATIONS ---------

#selectnation 92
#name "New Jomon"
#epithet "Broken Swords"
#era 3
#idealcold 0
#brief "Jomon has suffered a catastrophe and is now controlled by malevolent female demons and undead."
#descr "The feudal reign of the samurai began as normal, but then a great catastrophe struck. The Taiko, ruler of all Jomon became quite mad; raving about demons and vampires he murdered his wives, had his personal guard slay all the women in the capital and put out an order for all females above the status of serf to be dealt with in similar fashion. Worsening the situation, as the country descended into frenzied bloodshed and factional disputes a mysterious plague swept the land, devastating solely the remaining female population. Exactly one year after the chaos strange and alluring women appeared from the East and within a generation dominated society completely, bending the minds of the once proud samurai and symbolically breaking their swords."
#summary "Race: Humans, Half-Demons, Demons, Vampires.	
Military: Samurai Thralls, Crossbreeds, Demons and Undead. Varied covert units.	
Magic: Blood, Death, Fire, Water, Earth.	
Priests: Average."
#flag "./Jomon Broken/flag.tga"
#color 0.6 0.0 0.0


---- RECRUITS

#addrecunit 2257 -- Bandit Cur
#addrecunit 2255 -- Yari Thrall
#addrecunit 2254 -- Naginata Thrall
#addrecunit 2256 -- Samurai Thrall Cavalry
#addrecunit 2258 -- Dog Samurai
#addrecunit 2275 -- Fox Chunin
#addrecunit 2259 -- Red Nekoni
--addrecunit 2285 -- Jikininki
--addrecunit 2287 -- Akurojin
-addrecunit "woodsman blowpipe"


---- LEADERS

#addreccom 2279 -- Cur Scout
#addreccom 2261 -- Thrall Vassal
#addreccom 2262 -- Dog Vassal
#addreccom 2263 -- Twisted Daimyo
#addreccom 2270 -- Shrine Maiden
#addreccom 2272 -- Red Musume
#addreccom 2276 -- Fox Kunoichi
#addreccom 2269 -- Burned
#addreccom 2267 -- Buried
#addreccom 2268 -- Drowned
--addreccom 2264 -- Kyuuketsuki
--addreccom 2277 -- Crimson Twins
--addreccom 2278 -- Ronin of Hooves




----- HEROES

#multihero1 2264
#hero1 2277
#hero2 2278

----- STARTSITES

#startsite "Halls of the capital"
#startsite "The Bloodied Throne"


#startfort 3
#defaultfort 41
#farmfort 3
#mountainfort 38
#swampfort 11
#forestfort 35

------- PROVINCE DEFENCE

--Sets the units to be used in province defense.

#defcom1 2261
#defcom2 2262
#defunit1 2255

#defunit1b 2254
#defunit2 2257

#defunit2b 2258


--Sets how many of the units to appear per point.

#defmult1 10
#defmult1b 10
#defmult2 10
#defunit2b 10



------- STARTING UNITS

#startcom 2263 -- Twisted Daimyo
#startunittype1 2254
#startunitnbrs1 10
#startunittype2 2255
#startunitnbrs2 10
#startscout 2279 -- Cur Scout
#end


