################################################################################
##   Mod Overview and Description
################################################################################
#modname "MYTHEOLOGY 3.11"
#version 3.11
#domversion 3.27
#icon "./mytheology/mytheology3.tga"

#description "Update for Mytheology 3.08. Provides some fixes. Some balance issues. Removed spells that where not working. See changelog.txt for specifics. This mod contains various new pretenders, some new units, spells and items. Based on Luckmanns 3.07r which is based on Psientist's Original 3.06."

--- Soyweiser, readme:
--- I updated where Luckmann left of. I was bold so I named the new version 3.08 it is an update of 3.07r. It should be compatible with CBM 1.6. But it is not compatible with the improved endgame summons mod.
--- I redistribute this with the consent of the original creator, Psientist. As long as it remains clear that he started the mod, and the original remains available. But without the consent or input of Luckmann.

--- Luckmann, readme:
--- This stellar mod is originally created by Psientist, mod-modded by me (Luckmann) as a personal project, which I just felt like sharing.
--- I have no intention to regularly update, maintain or otherwise keep this mod up to date on a regular basis.
--- My additions are minor and I redistribute this without the consent or input of the original creator, Psientist.
--- Should this not sit well with someone, please contact me on the Shrapnel Games Dominions 3 forums and I will cease any form of distribution.
--- Any version I make will be marked as 'r' in case Psientist comes back and continues the original version(s).

################################################################################
##   Custom Armor
################################################################################

--------------------------------------------------------------------------------
#newarmor 370  -- for monkey king
#name "Red Feather Cap"
#type 6
#prot 14
#def 0
#enc 0
#rcost 6
#end

#newarmor 371 -- for monkey king
#name "Golden Chain Mail"
#type 5
#prot 14
#def 0
#enc 0
#rcost 6
#end

#newarmor 372
#name "Skin of Brass"
#prot 10
#type 5
#def 0
#enc 0
#rcost 1
#end

#newarmor 373
#name "Skin of Mithril"
#prot 15
#type 5
#def 0
#enc 0
#rcost 1
#end

#newarmor 374
#name "Skin of Pewter"
#prot 5
#type 5
#def 0
#enc 0
#rcost 1
#end

#newarmor 375 -- for ecclesiarch
#name "Papal Mitre"
#type 6
#prot 2
#def 2
#enc 0
#rcost 6
#end

################################################################################
##   Custom Weapons
################################################################################

--------------------------------------------------------------------------------
#newweapon 660
#name "Scimitar"
#len 30
#att 1
#def 1
#dmg 7
#magic
#nratt 1
#dt_normal
#end

--------------------------------------------------------------------------------
--For the orb of azathoth item
#newweapon 677
#name "Black Vortex"
#len 1
#att -4
#def 0
#dmg 5
#magic
#nratt 6
#dt_magic
#flyspr 297
#explspr 10141
#aoe 3
#secondaryeffect 63 --  life drain -- always?
--mrnegates 
#armornegating
#range 60
#ammo 12
-- NO nostr?!?
#end

--------------------------------------------------------------------------------
--For the Skull of Ophoix
#newweapon 678
#name "Venom of Ophiox"
#len 1
#att -100
#def 0
#dmg 3
#magic
#nratt -2
#dt_poison
#explspr 10125
#aoe 999
#armornegating
#secondaryeffect 306
#range 100
#ammo 12
#nostr
#end

################################################################################
##   Custom Weapons for Pretenders 
################################################################################

-- T-bird's weapon
#newweapon 673
#name "Lightning Snake"
#att 4
#armornegating
#aoe 1
#def 0
#dmg 10
#explspr 10219
#flyspr 210
#magic
#sound 24
#range 40
#shock
#nostr
#end

--------------------------------------------------------------------------------
-- T-bird's weapon
#newweapon 672
#name "Thunderclap"
#att 4
#def 4
#dmg 8
#dt_stun
#sound 22
#range 30
#ammo 100
#armorpiercing
#nostr
#bonus
#end

--------------------------------------------------------------------------------
-- Monkey King's Bamboo Staff
#newweapon 671
#name "Gold Band Staff"
#twohanded
#att 4
#def 4
#dmg 10
#len 5
#magic
#nratt 2
#sound 10
#magic
#end

--------------------------------------------------------------------------------
-- Grim Reaper's piece
#newweapon 670
#name "Soul Scythe"
#aoe 1
#att 6
#armornegating
#def 0
#dmg 999
#len 4
#magic
#nratt 1
#twohanded
#sound 20
#end

--------------------------------------------------------------------------------
-- For T-Rex
#newweapon 669
#name "Crushbite"
#aoe 0
#att 10
#armorpiercing
#bonus
#dmg 20
#nratt 1
#sound 38
#secondaryeffect 53
#end


--------------------------------------------------------------------------------
-- for black dragon.  If only we could make this MR negating, it would be great.
#newweapon 668
--copyweapon 504 -- gaze of death
#name "Disintegration Breath"
#aoe 5
#len 0
#dmg 15
#nratt 1
#sound 38
#range 20
#prec 50
#ammo 15
#att 100
#dt_normal
--magic
--explspr 10206
#flyspr 39 5 -- 339 evil death thingy
#explspr 10202 5
#sound 16
#nostr
#armornegating
#bonus
#end

--------------------------------------------------------------------------------
-- for shadowcat
#newweapon 667
#name "Bite"
#def -1
#att 0
#armorpiercing
#dmg 2
#nratt 1
#sound 38
#magic
#len 0
#end

--------------------------------------------------------------------------------
-- for shadowcat
#newweapon 666
#name "Claws"
#att 0
#dmg 0
#nratt 2
#sound 38
#def 1
#magic
#end

--------------------------------------------------------------------------------
-- for gold dragon.  
#newweapon 665
#name "Word of Might"
#aoe 5
#dmg 10
#nratt 1
#sound 38
#range 30
#prec 100
#ammo 20
#magic
#explspr 10010
#flyspr 141
#sound 24
#nostr
#secondaryeffect 114
#bonus
#end

--------------------------------------------------------------------------------
-- for scarab
#newweapon 664
#name "Tiny Bite"
#def 0
#att 0
#armornegating
#dmg 1
#nratt 1
#sound 38
#len 0
#secondaryeffect 306
#end

--------------------------------------------------------------------------------
-- for clearing copied weapons
#newweapon 663
#name " "
#def 0
#att 0
#dmg 0
#twohands
#nratt 1
#len 0
#dt_cap
#nostr
#ammo 0
#end

--------------------------------------------------------------------------------
-- for Ubbo-Sathla
#newweapon 662
#name "Acidspray"
#descr "A large, sticky stream of vile and corrosive liquid."
#def 0
#att 0
#nratt 1
#len 0
#dmg 10
#secondaryeffect 137 -- entanglement
#secondaryeffectalways 54 -- paralyzing poison
#flyspr 404
#nostr
#sound 83
#range 20
#armornegating
#aoe 2
#end

--------------------------------------------------------------------------------
-- for ShadowJack
#newweapon 661
#name "Edge of Darkness"
#descr "A large blade crafted from darkness itself."
#def 1
#att 1
#nratt 1
#len 0
#dmg 5
#magic
#range 0
#armorpiercing
#secondaryeffect 333
#end

------------------------------------------------------------------------------
#newweapon 674 -- for kraken
#name "Harpoon Tentacle"
#dmg -2
#att 1
#def 1
#len 5
#armorpiercing
#secondaryeffect 453 -- harpooning
#dt_normal
#end 

#selectweapon 85 --tentacle
#def 1
#len 1
#end 

#newweapon 675
#name "Krakensbeak"
#bonus
#dmg 0
#att 1
#def -1
#len 0
#armorpiercing
#dt_normal
#end 

------------------------------------------------------------------------------
#newweapon 676 -- for catapults & trebuchet
#name "Siege Stone"
#dmg 20
#att 0
#def 0
#len 0
#armorpiercing
#nostr
#range 120
#ammo 5
#nratt -3
#aoe 3 -- should it be 1 or 2?
#flyspr 101
#sound 40
#dt_normal
#twohanded
#end 


################################################################################
##   Custom Magic Items 
################################################################################

##   1-handed Weapons

--------------------------------------------------------------------------------
#newitem
#weapon "Cold Breath"
#name "Horn of Frost" 
#copyspr "Horn of Valor" .
#descr "A horn of a great Blue Dragon, magically enchanted to call forth gouts of freezing cold."
#constlevel 4
#mainpath 2
#mainlevel 4
#type 1 -- 1hd, not matter
#end

--------------------------------------------------------------------------------
#newitem
#name "Wand of Stellar Bolts" 
#copyspr "Enchanted Spear" 
#weapon "Stellar Bolt"
#descr "This small wand will cast astral bolts of energy at enemy targets."
#constlevel 6 --6
#mainpath 4 -- 0
#mainlevel 4 --5
#type 1 -- 1 handed
#end

--------------------------------------------------------------------------------
#newitem
#name "Silk Spinner" 
#copyspr "The Oath Rod of Kurgi" 
#weapon "Web Spit"
#descr "This strange scepter casts nets of sticky, woven spider silk upon enemy targets."
#constlevel 4
#mainpath 1 -- air
#mainlevel 1
#secondarypath 6 -- nature
#secondarylevel 1
#type 1 -- 1 handed
#end


--------------------------------------------------------------------------------
#newitem
#weapon 677 -- Black Vortex
#name "The Orb of Azathoth"
#descr "A mysterious and pulsating sphere, or possibly egg, whose origins are tied to Azathoth the Daemon Sulton who sleeps in the center of the cosmos.  Azathoth is purportedly the greatest of all the ancient Outer Gods, but the few living beings who speak of him with certainty are all crippled with shrieking insanity.  When clutched in the fist, it gives the wielder powerful life drain attacks and other abilities."
#copyspr 272 -- eye of the void
#constlevel 8 -- makes it unique
#mainpath 5 -- death
#mainlevel 5 
#secondarypath 1 -- air
#secondarylevel 1
#type 1
#end

##   2-handed Weapons

--------------------------------------------------------------------------------
#newitem
#name "Cobra Staff" 
#copyspr "Astral Serpent" 
#weapon "Spray Poison"
#descr "The head of this staff is carved in the fashion of a striking cobra, which will spray deadly poison at enemy targets."
#constlevel 4 --6
#mainpath 5 -- 0 --death
#mainlevel 2
#type 2 --2h
#end

--------------------------------------------------------------------------------
#newitem
#name "Phantom Scimitar" 
#copyspr "Enchanted Sword" 
#weapon 660
#descr "This enchanted scimitar forms a phantom duplicate several feet away that is as deadly and sharp as the original and mirrors every move made by the wielder.  Favored by assassins and mages, it allows those weak in melee combat to maintain a safe distance from their foes."
#constlevel 2 --6
#mainpath 1 -- air
#mainlevel 3
#type 2
#end

--------------------------------------------------------------------------------
#newitem 
#weapon 678 -- Venom Of Ophiox
#name "Skull of Ophiox"
#descr "In the time of the previous Pantokrator, a mighty snake-god reigned over much of the world through brute force and terror.  He could take the form of a giant cobra the size of a dragon, and his venom was strong enough to slay even the mightiest of pretenders and heroes.  Although he was defeated and killed, this talisman was formed from his dying skull and retains the power to cast vast gouts of deadly poison over the battlefield.  However, the owner of the Skull is not immune to its deadly venom."
#copyspr "Astral Serpent" -- better idea?
#constlevel 8
#mainpath 4 -- death
#mainlevel 5 
#secondarypath 2 -- Water
#secondarylevel 4
#type 2 
#end

##   Missile Weapons

##   Shields

##   Body Armor

##   Helmets

--------------------------------------------------------------------------------
#newitem
#armor "Skin of Pewter"
#name "Pewter Circlet" 
#copyspr "Slave Collar" 
#descr "Dwarven smiths have imbued this crown so that the wearer's skin hardens, and takes on a silvery hue."
#constlevel 2
#mainpath 3
#mainlevel 1
#type 6 -- hat
#end

--------------------------------------------------------------------------------
#newitem
#armor "Skin of Brass"
#name "Brass Circlet" 
#copyspr "Ring of Fire" 
#descr "Dwarven smiths have imbued this crown so that the wearer's skin becomes hard as brass, and shines like polished gold."
#constlevel 4
#mainpath 3
#mainlevel 2
#type 6 -- hat
#end

--------------------------------------------------------------------------------
#newitem
#armor "Skin of Mithril"
#name "Mithril Circlet" 
#copyspr "Ring of Tamed Lightning" 
#descr "Dwarven smiths have imbued this crown so that the wearer's skin becomes as hard, silvery, and lustrous as true mithral."
#constlevel 6
#mainpath 3
#mainlevel 3
#type 6 -- hat
#end

--------------------------------------------------------------------------------
#newitem
#weapon "slay magic"
#name "Horrorsbane" 
#copyspr "Spirit Helmet" 
#descr "The eldritch Mi-Go were the only race to not fear attacks by Horrors.  This helmet contains a rare Mi-Go gem, which grants its wearer a powerful psychic attack against magic creatures."
#constlevel 6
#mainpath 4
#mainlevel 5
#type 6 -- hat
#end

##   Boots

##   Misc

--------------------------------------------------------------------------------
#newitem
#weapon "Minor Life Drain"
#name "Psychic Leech" 
#copyspr "Astral Serpent" 
#descr "This enchanted necklace can attack and drain the lifeforce of enemies, adding it to the health of the wearer."
#constlevel 6
#mainpath 7
#mainlevel 4
#type 8 -- misc
#end

################################################################################
##   Custom Summons Units for Pretenders / Spells
################################################################################


--------------------------------------------------------------------------------
#newmonster 2294
#name "Menhir of Peace"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.
The presence of a Menhir of Peace soothes the local population. Making them docile and decreasing their will to resist the coming of the new god."
#spr1 "./mytheology/menhir_peace.tga"
#spr2 "./mytheology/menhir_peace.tga"
#incunrest -20
#ap 2
#hp 40
#mapmove 0
#size 6
#prot 22
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#mindless
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#stonebeing
#end

--------------------------------------------------------------------------------
#newmonster 2295
#name "Menhir of Faith"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.
The presence of a Menhir of Faith increases faith in the region.  The towering construction is a constant reminder of the will of god."
#spr1 "./mytheology/menhir_faith.tga"
#spr2 "./mytheology/menhir_faith.tga"
#spreaddom 1
#awe 0
#sacred
#ap 2
#hp 40
#mapmove 0
#size 6
#prot 22
#enc 0
#str 1
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#mindless
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#stonebeing
#end


#newmonster 2292
#name "Menhir of Courage"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.
On the battlefield, warriors next to one of these huge constructions never retreat. Anyone fighting the Menhir gets confused by the majestic construction, either being overwhelmed and forgetting to attack, or attacking themselves."
#spr1 "./mytheology/menhir_courage.tga"
#spr2 "./mytheology/menhir_courage.tga"
#standard 50
#awe 2
#ap 2
#hp 40
#mapmove 0
#size 6
#prot 22
#enc 0
#str 1
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#mindless
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#stonebeing
#bloodvengeance 1
#end

#newmonster 2291
#name "Menhir of Growth"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.
A Menhir of Growth constantly creates food in the province in which it is created."
#spr1 "./mytheology/menhir_growth.tga"
#spr2 "./mytheology/menhir_growth.tga"
#gcost 0
#pathcost 10
#restrictedgod 3

#supplybonus 200

#ap 2
#hp 40
#mapmove 0
#size 6
#prot 22
#enc 0
#str 1
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#mindless
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#stonebeing
#end

--------------------------------------------------------------------------------
#newmonster 2293
#name "Menhir of Fortune"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.
The arcane powers infused in this Menhir greatly decrease the amount of accidents in the region.  Absorbing all the bad karma in a region makes the Menhir brittle and easy to damage."
#spr1 "./mytheology/menhir_fortune.tga"
#spr2 "./mytheology/menhir_fortune.tga"
#nobadevents 50
#ap 2
#hp 20
#mapmove 0
#size 6
#prot 12
#enc 0
#str 1
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#stonebeing
#end

#newmonster 2351
#name "Menhir of Death"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.  The Menhir of Death radiates a terrifying aura, and shadows appear when it is disturbed."
#spr1 "./mytheology/menhir_death.tga"
#spr2 "./mytheology/menhir_death.tga"
#clearmagic

#restrictedgod 1 -- EA Ermor
#startdom 4
#gcost 0
#pathcost 10

#ap 2
#hp 40
#mapmove 0
#size 6
#prot 22
#enc 0
#str 1
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#onebattlespell 426 -- Summons 3 shades each turn.
#poorleader
#poorundeadleader
#nomagicleader
#inanimate
#undead
#magicbeing
#amphibian
#neednoteat
#mindless
#immobile
#noheal
#fear 5
#poisonres 100
#fireres 100
#coldres 100
#weapon 663
#nametype 15
#stonebeing
#itemslots 1
#end




--------------------------------------------------------------------------------
#newmonster 2312
#name "Carrion Mage"
#descr "The Carrion Mage is an undead sorcerer proficient in air and death magic.  It hungers to feed on dying flesh and has an undying hatred of living things."

#gcost 110
#startdom 2
#pathcost 20

#copyspr 299
#ap 8
#hp 20
#mapmove 3
#size 2
#prot 5
#enc 0
#str 15
#att 13
#def 13
#prec 12
#mr 16
#mor 30
#magicskill 1 1
#magicskill 5 1
#poorleader
#expertundeadleader
#weapon "Quarterstaff"
#undead
#neednoteat
#poisonres 100
#coldres 100
#end


--------------------------------------------------------------------------------
#newmonster 2299
#name "Taoist Master"
#descr "The Taoist Master is an ancient alchemist and priest of considerable power and venerable wisdom."

#gcost 50
#startdom 1
#pathcost 80

#copyspr 940
#ap 10
#hp 8
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 12
#mr 16
#mor 30
#itemslots 15494 
#magicskill 3 2
#weapon "Dagger"
#end

#newmonster 2549
#name "Taoist Master"
#descr "The Taoist Master is an ancient alchemist and priest of considerable power and venerable wisdom."

#gcost 50
#startdom 1
#pathcost 80

#copyspr 940
#ap 10
#hp 8
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 12
#mr 16
#mor 30
#itemslots 15494 
#magicskill 3 2
#weapon "Dagger"
#end

#newmonster 2550
#name "Taoist Master"
#descr "The Taoist Master is an ancient alchemist and priest of considerable power and venerable wisdom."

#gcost 50
#startdom 1
#pathcost 80

#copyspr 940
#ap 10
#hp 8
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 12
#mr 16
#mor 30
#itemslots 15494 
#magicskill 3 2
#weapon "Dagger"
#end


--------------------------------------------------------------------------------
#newmonster 2308
#name "Chaos Mage"
#descr "The Chaos Mage is an ancient and evil sorcerer that excels in dark and destructive magics."

#startdom 1
#pathcost 80
#gcost 70

#copyspr 339
#ap 10
#hp 10
#mapmove 2
#size 2
#prot 0
#enc 3
#str 10
#att 10
#def 8
#prec 12
#mr 16
#mor 30
#itemslots 15494 
#shapechange 2304 --change into black dragon
#magicskill 4 1
#magicskill 5 1
#poorleader
#weapon "Dagger"
#end


--------------------------------------------------------------------------------
#newmonster 2307
#name "Cytherean Priestess"
#descr "Once in a long while, an exceptionally beautiful maiden is selected to serve the Goddess of Desire.  She becomes a Priestess of Cytherea that can channel the otherworldly beauty of her Goddess.  Enemies find it difficult to strike her physically, and she can stop men in their tracks with merely a seductive glance.  Like her Goddess, a Priestess can occasionally entice enemies to abandon their allegiances to pursue their desire for the Goddess.  The Priestess gives her bodies to the worship of the Goddess, and can be Blessed.  However, she is not a warrior; she cannot wear armor or wield weapons and may flee at the first sign of bloodshed."
#spr1 "./mytheology/cythera.tga"
#spr2 "./mytheology/cythera2.tga"
#ap 8
#hp 4
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 8
#mr 10
#mor 2
#female
#nametype 103
#awe 2
#holy
#itemslots 6146
#maxage 50
#poorleader
#nomagicleader
#noundeadleader
--  weapon "Stun" -- too much, really
#weapon "Enslave Mind"
#seduce 16
#stealthy
#end


--------------------------------------------------------------------------------
#newmonster 2290
#name "Another Monkey King"
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"
#descr "A mischievious and magical copy of the Monkey King pretender."
#ap 16
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 18
#def 20
#prec 16
#mr 15
#mor 30
#ambidextrous 4
#eyes 2
#forestsurvival
#mountainsurvival
#itemslots 15494
#nametype 129
#reinvigoration 1
#magicskill 1 2
#researchbonus -2
#onebattlespell "Personal Luck"
#holy
#spy
#stealthy
#weapon 7
#armor "Golden Chain Mail"
#armor "Red Feather Cap"
#okleader
#poormagicleader
#poorundeadleader
#magicbeing
#end

--------------------------------------------------------------------------------
#newmonster 2305
#name "Toad Demon"
#descr "Resembling a toad of monstrous proportions, this demon is a strong mage and a resilient combatant.  While it is at home both above and below the water, it is a glutton for food and supplies."
#spr1 "./mytheology/toaddemon.tga"
#spr2 "./mytheology/toaddemon2.tga"

#pathcost 50
#restrictedgod 19 -- EA Yomi
#startdom 1
#gcost 40

#ap 10
#mapmove 1
#hp 50
#prot 15
#size 5
#enc 4
#str 20
#att 14
#def 12
#prec 12
#mr 16
#mor 30
#supplybonus -30
#neednoteat
#amphibian
#regeneration 4
#poisonres 100
#fireres 50
#eyes 2
#itemslots 15494
#okleader
#okmagicleader
#poorundeadleader
#magicskill 3 1
#magicskill 2 1
#magicskill 7 1
#nametype 140
#demon
#weapon "Swallow"
#end


--------------------------------------------------------------------------------
#newmonster 2320
#copystats 591
#name "Small Fish"
#descr "A small predatory fish."
#spr1 "./mytheology/minnow1.tga"
#spr2 "./mytheology/minnow2.tga"
#hp 1
#str 1
#prot 0
#att 6
#mor 10
#def 10
#mr 3
#prec 10
#enc 5
#aquatic
#animal
#neednoteat
#stealthy
#flying
#itemslots 1
#weapon "Tiny Bite"
#end


--------------------------------------------------------------------------------
#newmonster 2319
#name "Portuguese Man O' War"
#descr "A giant and dangerous jellyfish."
#spr1 "./mytheology/manowar.tga"
#spr2 "./mytheology/manowar.tga"
#hp 15
#str 8
#prot 8
#att 15
#mor 50
#def 10
#mr 8
#prec 10
#enc 5
#ap 9
#mapmove 2
#aquatic
#neednoteat
#entangle
#blind
#mindless
#shockres 50
#poisonres 50
#poisonarmor
#damage 2546
#itemslots 4096
#weapon 282
#size 3
#end


--------------------------------------------------------------------------------
#newmonster 2301
#name "Scarab"
#descr "A large armored beetle."
#spr1 "./mytheology/scarab1.tga"
#spr2 "./mytheology/scarab2.tga"
#hp 1
#ap 8
#mapmove 1
#str 1
#prot 2
#att 10
#mor 40
#def 5
#size 0
#mr 5
#prec 10
#enc 1
#animal
#fireres -50
#coldres -50
#itemslots 1
#weapon 664
#end

--------------------------------------------------------------------------------
#newmonster 2335
#copystats 181
#name "Wraith King"
#descr "A wraith-king is a supremely powerful wraith, riding atop a corrupted wyrm of unknown origin. After building his strength for centuries, he is now making his bid for true godhood."
#spr1 "./mytheology/nazgul1.tga"
#spr2 "./mytheology/nazgul2.tga"

#restrictedgod 28
#gcost 170
#pathcost 80
#startdom 1

#ap 16
#hp 60
#mapmove 4
#size 4
#prot 8
#str 16
#enc 0
#att 16
#def 16
#prec 10
#mr 16
#mor 30
#fear 1
#immortal
#ethereal
#flying
#blind
#secondshape 2336
#end


-- when he becomes dismounted
#newmonster 2336
#copystats 181
#name "Wraith King"
#copyspr 181
#descr "A wraith-king is a supremely powerful wraith. After building his strength for centuries, he is now making his bid for true godhood."

#hp 33
#prot 8
#mor 30
#mr 17
#str 15
#att 16
#def 16
#prec 10
#mapmove 3
#ap 13

#blind
#firstshape 2335
#end

--------------------------------------------------------------------------------
#newmonster 2332
#copystats 782 -- giant spider
#name "Assassin Spider"
#descr "The size of a large dog, these giant spiders are astonishingly swift and hunt in packs to bring down their prey."
#spr1 "./mytheology/wolfspider1.tga"
#spr2 "./mytheology/wolfspider2.tga"
#size 1
#hp 6
#ap 18
#mapmove 1
#prot 3
#str 6
#att 10
#def 14
#prec 12
#mr 10
#mor 20
#assassin
#weapon 239 -- venomous fangs, strong poison
#stealthy
#eyes 4
#poisonres 50
#itemslots 4096
#mountainsurvival
#forestsurvival
#noleader
#noundeadleader
#nomagicleader
#nametype 125
#end

--------------------------------------------------------------------------------
#newmonster 2333
#name "Assassin Mother"
#descr "Driven by hatred, this fearsome and monstrous spider craves victims to slake her hunger and feed her children."
#domsummon 2332
#spr1 "./mytheology/spider1.tga"
#spr2 "./mytheology/spider2.tga"
#ap 16
#mapmove 1
#prot 12
#str 13
#enc 2
#att 13
#def 14
#prec 14
#mr 10
#mor 10
#hp 18
#size 3
#holy
#stealthy
#eyes 4
#poisonres 100
#okleader
#noundeadleader
#nomagicleader
#assassin
#mountainsurvival
#forestsurvival
#weapon 65 -- venomous fangs, death poison
#weapon 262 -- web spit
#itemslots 12288
#nametype 125
#end


--------------------------------------------------------------------------------
#newmonster 2329
#name "Protoplasmic Spawn"
#descr "A formless, amoeba-like spawn of Ubbo-Sathla. Devouring everything that moves. The presense of even one of these creatures is very disturbing. A potent reminder of the end that is Ubbo-Sathla."
#spr1 "./mytheology/amoeba1.tga"
#spr2 "./mytheology/amoeba2.tga"
#ap 10
#hp 15
#mapmove 1
#size 3
#prot 9
#str 10
#enc 4
#att 10
#def 12
#prec 8
#mr 15
#mor 50
#noitems
#mindless
#poorleader
#nomagicleader
#noundeadleader
#poisonres 50
#weapon 85
#weapon 85
#trample
#nametype 132
#blind
#holy
#heal
#amphibian
#regeneration 10
#pillagebonus 5
#supplybonus -9
#incunrest 2
#end

--------------------------------------------------------------------------------
#newmonster 2340
#name "Elder Sign"
#spr1 "./mytheology/eldersign1.tga"
#spr2 "./mytheology/eldersign2.tga"
#descr "This small greenish-grey stone in the shape of a five-pointed star is a powerful protection against astral attackers and horrors.  An Elder Sign makes an unparallelled bodyguard against magic attackers, but cannot easily leave the province to which it has been summoned.  The true potent Elder Signs are few in number and incredibly ancient, having been made by the elder gods. The Elder Sign was used by the elder gods to seal off those places where the Great Old Ones were imprisoned."
#ap 20
#hp 20
#mapmove 0
#prot 30
#size 1
#str 10
#enc 0
#att 20
#def 0
#prec 30
#mr 30
#mor 50
#blind
#neednoteat
#itemslots 1
#nametype 132
#flying
#amphibious
#reinvigoration 1
#mindless
#noleader
#nomagicleader
#noundeadleader
#magicbeing
#poisonres 150
#fireres 75
#coldres 100
#shockres 75
#bloodvengeance 2
#inanimate
--weapon "Unconsciousness" -- 247 -- tesseract
#weapon 416 -- astral fetters
#weapon 247 -- slay magic, if it works
#onebattlespell "Antimagic" -- --"Opposition"?
#stonebeing
#end


--------------------------------------------------------------------------------
-- krakens are wimps, and look like octopi.  I've buffed them up, made them look
-- scary!
#selectmonster 438
#name "Giant Octopus"
#descr "A huge octopus. This beast is created when a master of Water magic magically enlarges a normal octopus.  This mighty Octopus is aquatic and cannot leave the sea."
#end

#newmonster 2288
#copystats 438
#name "Kraken"
#descr "On the safety of dry land, sailors whisper fearfully of terrible predators from the black depths.  These monsters rise from below to drag ships and men under with their many suckered arms, crushing anything in their awful snapping beaks.  Krakens are among the fastest assassins in the sea, and hunt in the coldest and darkest chasms."
#spr1 "./Mytheology/kraken1.tga"
#spr2 "./Mytheology/kraken2.tga"
#gcost 0
#rcost 0
#hp 45
#str 19
#att 14
#def 12
#ap 20
#size 6
#mapmove 3
#darkvision 100
#coldres 50
#ambidextrous
#weapon 674
#weapon 674
#weapon 85
#weapon 85
#weapon 675 --beak
#eyes 2
#aquatic
#animal
#stealthy
#assassin
#end

#selectmonster 639
#name "Giant Octopus King"
#desc "A huge octopus. This beast is created when a master of Water magic magically enlarges a normal octopus. Additional enchantments have made this Giant Octopus King even stronger than his normal Giant kin. This mighty Octopus King is aquatic and cannot leave the sea."
#end

#newmonster 2289
#copystats 639
#name "Kraken King"
#descr "On the safety of dry land, sailors whisper fearfully of terrible predators from the black depths.  These monsters rise from below to drag ships and men under with their many suckered arms, crushing anything in their awful snapping beaks.  Krakens are among the fastest assassins in the sea, and hunt in the coldest and darkest chasms.  The Kraken King is the strongest of all kraken, and even hunter whales and other kraken flee before him."
#spr1 "./Mytheology/krakenking1.tga"
#spr2 "./Mytheology/krakenking2.tga"
#gcost 0
#rcost 0
#hp 80
#str 21
#att 14
#def 14
#ap 20
#size 6
#mapmove 3
#darkvision 100
#coldres 50
#ambidextrous
#weapon 674
#weapon 674
#weapon 85
#weapon 85
#weapon 675 --beak
#eyes 2
#poorleader
#nomagicleader
#noundeadleader
#aquatic
#stealthy
#assassin
#animal
#end


--------------------------------------------------------------------------------
#newmonster 2318
#name "Crab"
#descr "A angry and armored crab."
#spr1 "./mytheology/crab1.tga"
#spr2 "./mytheology/crab2.tga"
#hp 1
#ap 8
#mapmove 1
#str 1
#prot 2
#att 9
#mor 40
#def 5
#size 0
#mr 5
#prec 10
#enc 1
#animal
#aquatic
#coldres -50
#itemslots 1
#weapon 664
#end


--------------------------------------------------------------------------------
#newmonster 2342
#name "Siege Catapult"
#descr "A huge siege weapon capable of launching giant boulders that can devastate enemy ranks and the walls of great fortresses."
#spr1 "./mytheology/catapult1.tga"
#spr2 "./mytheology/catapult2.tga"
#hp 20
#ap 6
#mapmove 1
#str 18
#prot 10
#att 12
#mor 50
#def 0
#size 5
#mr 10
#prec 9
#enc 0
#fireres -100
#poisonres 100
#neednoteat
#itemslots 28672
#siegebonus 20
#inanimate
#noitem
#weapon 676 --siege stone
#weapon 663
#end

--------------------------------------------------------------------------------
#newmonster 2344
#name "Siege Trebuchet"
#descr "A huge siege weapon capable of launching giant boulders that can devastate enemy ranks and the walls of great fortresses.  Trebuchets are more accurate than catapults, and are the most powerful of all siege engines."
#spr1 "./mytheology/trebuchet1.tga"
#spr2 "./mytheology/trebuchet2.tga"
#hp 30
#ap 6
#mapmove 1
#str 22
#prot 10
#att 16
#mor 50
#def 0
#size 5
#mr 10
#prec 15
#enc 0
#fireres -100
#poisonres 100
#neednoteat
#itemslots 28672
#siegebonus 50
#inanimate
#noitem
#weapon 663
#weapon 676 --siege stone
#end

################################################################################
##   Custom Pretenders 
################################################################################
#newmonster 2309
#name "Thunderbird"
#descr "The Thunderbird is master of the air and storms.  It appears as a giant bird, and the beating of its enormous wings causes thunder and stirs the storm winds and lightning flashes from its eyes. Once the servant and messenger of the previous Pantokrator, the Thunderbird now rises to claim its place as foremost among the gods.  When the Thunderbird's dominion is high, its lesser cousins will come to do its bidding."
#spr1 "./mytheology/thunderbird.tga"
#spr2 "./mytheology/thunderbird2.tga"

#restrictedgod 9
#gcost 170
#startdom 3
#pathcost 50

#hp 60
#prot 10
#mor 30
#mr 18
#encumbrance 0
#fatigue 0
#str 16
#att 12
#def 15
#prec 20
#mapmove 3
#ap 28
#size 4
#magicskill 1 2
#magicskill 2 1
#nametype 111
#siegebonus 20
#reinvigoration 4
#goodleader
#goodmagicleader
#poorundeadleader
#weapon 404
#weapon 673
#weapon 672
#weapon 672
#itemslots 28672
#neednoteat
#shockres 100
#stormimmune
#flying
#mountainsurvival
#onebattlespell 288 --"Storm"
#domsummon2 513
#end


#newmonster 2310
#name "Thunderbird"
#descr "The Thunderbird is master of the air and storms.  It appears as a giant bird, and the beating of its enormous wings causes thunder and stirs the storm winds and lightning flashes from its eyes. Once the servant and messenger of the previous Pantokrator, the Thunderbird now rises to claim its place as foremost among the gods.  When the Thunderbird's dominion is high, its lesser cousins will come to do its bidding."
#spr1 "./mytheology/thunderbird.tga"
#spr2 "./mytheology/thunderbird2.tga"

#restrictedgod 38
#gcost 170
#startdom 3
#pathcost 50

#hp 60
#prot 10
#mor 30
#mr 18
#encumbrance 0
#fatigue 0
#str 16
#att 12
#def 15
#prec 20
#mapmove 3
#ap 28
#size 4
#magicskill 1 2
#magicskill 2 1
#nametype 111
#siegebonus 20
#reinvigoration 4
#stormimmune
#goodleader
#goodmagicleader
#poorundeadleader
#weapon 404
#weapon 673
#weapon 672
#weapon 672
#itemslots 28672
#neednoteat
#shockres 100
#flying
#mountainsurvival
#onebattlespell 288 --"Storm"
#domsummon2 513
#end


#newmonster 2311
#name "Thunderbird"
#descr "The Thunderbird is master of the air and storms.  It appears as a giant bird, and the beating of its enormous wings causes thunder and stirs the storm winds and lightning flashes from its eyes. Once the servant and messenger of the previous Pantokrator, the Thunderbird now rises to claim its place as foremost among the gods.  When the Thunderbird's dominion is high, its lesser cousins will come to do its bidding."
#spr1 "./mytheology/thunderbird.tga"
#spr2 "./mytheology/thunderbird2.tga"

#restrictedgod 59
#gcost 170
#startdom 3
#pathcost 50

#hp 60
#prot 10
#mor 30
#mr 18
#encumbrance 0
#fatigue 0
#str 16
#att 12
#def 15
#prec 20
#mapmove 3
#ap 28
#size 4
#magicskill 1 2
#magicskill 2 1
#nametype 111
#siegebonus 20
#reinvigoration 4
#goodleader
#goodmagicleader
#poorundeadleader
#weapon 404
#weapon 673
#weapon 672
#weapon 672
#itemslots 28672
#onebattlespell 288 --"Storm"
#neednoteat
#shockres 100
#flying
#mountainsurvival
#stormimmune
#domsummon2 513
#end


--------------------------------------------------------------------------------
#newmonster 2313
#name "Great Egg"
#descr "This Pretender manifests as an enormous, rock-hard egg warm with the unknown life inside.  It represents beginnings, youth, potential, mystery and new life.  It speaks with the voices of the thousands of birds which always are found in its presence.  While it is immobile, it would be difficult to destroy."
#spr1 "./mytheology/greategg.tga"
#spr2 "./mytheology/greategg.tga"

#restrictedgod 9
#gcost 0
#startdom 2
#pathcost 20

#hp 30
#prot 20
#mor 30
#mr 18
#enc 0
#str 0
#att 12
#def 0
#prec 10
#mapmove 0
#ap 14
#size 3
#magicskill 3 1
#magicskill 6 1
#nametype 112
#healer 20
#heal
#reinvigoration 2
#poorleader
#poormagicleader
#poorundeadleader
#noeyes
#researchbonus -2
#shockres 50
#poisonres 50
#itemslots 1
#neednoteat
#immobile
#end


#newmonster 2314
#name "Great Egg"
#descr "This Pretender manifests as an enormous, rock-hard egg warm with the unknown life inside.  It represents beginnings, youth, potential, mystery and new life.  It speaks with the voices of the thousands of birds which always are found in its presence.  While it is immobile, it would be difficult to destroy."
#spr1 "./mytheology/greategg.tga"
#spr2 "./mytheology/greategg.tga"

#restrictedgod 38
#gcost 0
#startdom 2
#pathcost 20

#hp 30
#prot 20
#mor 30
#mr 18
#enc 0
#str 0
#att 12
#def 0
#prec 10
#mapmove 0
#ap 14
#size 3
#magicskill 3 1
#magicskill 6 1
#nametype 112
#healer 20
#heal
#reinvigoration 2
#poorleader
#poormagicleader
#poorundeadleader
#noeyes
#researchbonus -2
#shockres 50
#poisonres 50
#itemslots 1
#neednoteat
#immobile
#end


#newmonster 2315
#name "Great Egg"
#descr "This Pretender manifests as an enormous, rock-hard egg warm with the unknown life inside.  It represents beginnings, youth, potential, mystery and new life.  It speaks with the voices of the thousands of birds which always are found in its presence.  While it is immobile, it would be difficult to destroy."
#spr1 "./mytheology/greategg.tga"
#spr2 "./mytheology/greategg.tga"

#restrictedgod 59
#gcost 0
#startdom 2
#pathcost 20

#hp 30
#prot 20
#mor 30
#mr 18
#enc 0
#str 0
#att 12
#def 0
#prec 10
#mapmove 0
#ap 14
#size 3
#magicskill 3 1
#magicskill 6 1
#nametype 112
#healer 20
#heal
#reinvigoration 2
#poorleader
#poormagicleader
#poorundeadleader
#noeyes
#researchbonus -2
#shockres 50
#poisonres 50
#itemslots 1
#neednoteat
#immobile
#end


--------------------------------------------------------------------------------
#newmonster 2300
#name "Carrion Lord"
#descr "The Carrion Lord is the living carcass of an ancient and giant vulture that learned to feed on death itself.  It hungers to feed on dying flesh and has an undying hatred of living things.  The Carrion Lord is able to adopt the shape of a wight mage for spellcasting.  It is a master of death magics, and can extract two death gems each month from the decaying corpses it feeds upon."
#copyspr 1388

#restrictedgod 59 -- LA Caelum
#gcost 70
#startdom 2
#pathcost 20

#hp 90
#prot 12
#mor 30
#mr 14
#encumbrance 0
#fatigue 0
#str 20
#att 12
#def 12
#prec 10
#enc 0
#mapmove 3
#ap 10
#size 3
#shapechange 2312
#nametype 111
#flying
#undead
#poorleader
#poormagicleader
#goodundeadleader
#noeyes
#shockres 50
#poisonres 50
#heal
#weapon 404
#weapon 408
#gemprod 5 2
#itemslots 15494
#neednoteat
#end



--------------------------------------------------------------------------------
#newmonster 2303
#name "Morpheus"
#descr "Morpheus is the personification of the Dreaming.  As one of the Endless - the embodiments of Desire, Death, Destiny, Delerium, Destruction, and Dream - he is something both more and less than a true god.  This incarnation of the Dream has chosen to walk the path of a pretender god, and extend the realm of the Dreaming over waking lands.  He appears as a tall man with pale skin, black hair, and eyes that burn like stars.  He is the master of illusions and dreams, and his realm touches all planes and times."
#spr1 "./mytheology/morpheus.tga"
#spr2 "./mytheology/morpheus2.tga"

#restrictedgod 49
#gcost 270
#pathcost 30
#startdom 4

#ap 10
#hp 10
#mapmove 3
#size 2
#prot 0
#enc 3
#str 9
#att 10
#def 10
#prec 16
#mr 20
#mor 30
#awe 1
#illusion
#itemslots 15494
#gemprod 4 3
#magicbeing
#magicskill 4 3
#magicskill 1 3
#nametype 100
#researchbonus 5
#poorleader
#expertmagicleader
#noundeadleader
#end


--------------------------------------------------------------------------------
#newmonster 2323
#name "Teratos Rex"
#descr "When the world was young, he was the most vicious and feared of the Firstborn.  The king of all monsters, he dominated the land through his bloodthirst, cruelty and strength.  None could stand against his terrible bite; his teeth were the size of a man's arm and coated with the festering flesh of his countless victims.  Through the blood of his innumerable murdered prey, he achieved a form of immortality.  He has broken free of his bonds beneath the earth, and has risen again to become the true god through the death of all other pretenders."
#spr1 "./mytheology/trex1.tga"
#spr2 "./mytheology/trex2.tga"

#restrictedgod 10
#gcost 40
#pathcost 70
#startdom 2

#ap 20
#mapmove 1
#hp 190
#prot 18
#size 6
#enc 1
#str 25
#att 18
#def 12
#prec 12
#mr 14
#mor 30
#berserk 4
#douse 3
#fear 4
#forestsurvival
#wastesurvival
#swampsurvival
#trample
#heal
#noitem
#eyes 2
#itemslots 28672
#siegebonus 20
#poorleader
#poormagicleader
#poorundeadleader
#magicskill 7 1
#nametype 113
#weapon "Crushbite"
#end


--------------------------------------------------------------------------------
#newmonster 2321
#name "Pantokrator"
#descr "The Pantokrator is a metadimensional being that acted as caretaker and overseer of this dimension, guarding it against incursions and threats.  Little is known about the original Pantokrator, but it is surmised that it left this universe for several millenia to join battle with other Pantokrators in the Far Beyond.  Now it has returned to find this plane in disarray with various Pretenders arising to wrest control.  Having lost much of its might to upstart Pretenders, it is still exceptionally powerful and has chosen a nation to help re-establish its strength and eliminate all Pretenders."
#spr1 "./mytheology/pantokrator.tga"
#spr2 "./mytheology/pantokrator2.tga"

#gcost 350
#pathcost 20
#startdom 3

#ap 18
#hp 80
#mapmove 4
#size 3
#prot 10
#enc 1
#str 16
#att 12
#def 12
#prec 18
#mr 20
#mor 30
#awe 1
#itemslots 15494
#nametype 131
#immortal
#neednoteat
#amphibian
#flying
#poisonres 20
#darkvision 20
#fireshield 1
#weapon 92 
-- "Fist"
#weapon 416 
-- "Astral Fetters"
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 3
#researchbonus 5
#poorleader
#expertmagicleader
#noundeadleader
#maxage 99999
#end


--------------------------------------------------------------------------------
#newmonster 2316
#name "Desire"
#descr "The Goddess of Desire is the manifestation of love, lust, and beauty.  Few mortals are capable of attacking her physically because of her overwhelming physical perfection.  Although she cannot wield weapons or wear armor, enemies may desert their armies to pursue her beauty and she can stun men with merely a lascivious glance.  She can summon suitors to serve her at will, and as her dominion grows her Priestesses will come to her to tend her and help her in battle.  She is a mistress of nature, blood, and water magics, those elements which fuel the surges of desire in mortals.  Her subjects are very loyal, and will fight to the death to protect her."
#spr1 "./mytheology/parvati.tga"
#spr2 "./mytheology/parvati2.tga"

#restrictedgod 51 --LA Man
#gcost 180
#pathcost 70
#startdom 6

#ap 8
#hp 18
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 10
#mr 16
#morale 24
#female
#awe 8
#weapon "Small Area Stun"
#weapon "Enslave Mind"
#itemslots 30848
#heal
#magicskill 7 1
#nametype 108
#domsummon2 2906
#makemonster1 "Knight"
#seduce 22
#stealthy
#standard 20
#superiorleader
#goodmagicleader
#noundeadleader
#end

#newmonster 2317
#name "Desire"
#descr "The Goddess of Desire is the manifestation of love, lust, and beauty.  Few mortals are capable of attacking her physically because of her overwhelming physical perfection.  Although she cannot wield weapons or wear armor, enemies may desert their armies to pursue her beauty and she can stun men with merely a lascivious glance.  She can summon suitors to serve her at will, and as her dominion grows her Priestesses will come to her to tend her and help her in battle.  She is a mistress of nature, blood, and water magics, those elements which fuel the surges of desire in mortals.  Her subjects are very loyal, and will fight to the death to protect her."
#spr1 "./mytheology/parvati.tga"
#spr2 "./mytheology/parvati2.tga"

#restrictedgod 30 --ME Man
#gcost 180
#pathcost 70
#startdom 6

#ap 8
#hp 18
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 10
#mr 16
#morale 24
#female
#gcost 180
#pathcost 70
#startdom 6
#awe 8
#weapon "Small Area Stun"
#weapon "Enslave Mind"
#itemslots 30848
#heal
#magicskill 7 1
#nametype 108
#domsummon2 2307
#makemonster1 "Knight"
#seduce 22
#stealthy
#standard 20
#superiorleader
#goodmagicleader
#noundeadleader
#end



--------------------------------------------------------------------------------
#newmonster 2540
#name "Grim Reaper"
#descr "The angel of death is the manifestation of the end of all things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings. With the previous pankrator dead, the Grim Reaper have been released from his bonds of servitude and now seek to claim the mantle of godhood from his former master."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#restrictedgod 1
#ap 15
#hp 60
#mapmove 4
#size 6
#prot 10
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 30
#gcost 310
#pathcost 80
#startdom 1
#fear 1
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#researchbonus 0
#okleader
#okmagicleader
#expertundeadleader
#weapon 670
#end


#newmonster 2356
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#restrictedgod 28
#ap 15
#hp 60
#mapmove 4
#size 6
#prot 10
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 30
#gcost 310
#pathcost 80
#startdom 1
#fear 1
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#researchbonus 0
#okleader
#okmagicleader
#expertundeadleader
#weapon 670
#end


#newmonster 2355
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#restrictedgod 50
#ap 15
#hp 60
#mapmove 4
#size 6
#prot 10
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 30
#gcost 310
#pathcost 80
#startdom 1
#fear 1
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#researchbonus 0
#okleader
#okmagicleader
#expertundeadleader
#weapon 670
#end



--------------------------------------------------------------------------------
--Special manifestation for summoning, not pretender
#newmonster 2541
#copystats 392
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#ap 15
#hp 60
#mapmove 4
#size 6
#prot 14
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 50
#fear 1
#weapon 670
#poorleader
#end

--------------------------------------------------------------------------------

--If you want to know what this is prenteder is based on, watch the The Forbidden Kingdom movie.
#newmonster 2352
#name "Monkey King"
#descr "In primordial times, a monkey left the mountains to seek a way to immortality. He sought tutelege under a great Taoist sage who was impressed by his determination and intelligence and taught him the arts of 72 earthly transformations.  Although he learned immortality, he became famous for fighting, being a nuisance, and making trouble in the Heavens and Hells.  He was able to trick the East Sea Dragon King into giving him several magic gifts, including his magic armor and his staff which can be made to grow to any size.  He was sealed under a mountain by the Buddha for 500 years, and now has emerged to unleash his mischief.  He is a master warrior, but his mischievous nature makes him a poor leader.  His magical abilities include making copies of himself, and performing a 'cloud summersault' that can cover great distances."
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"

#restrictedgod 18
#gcost 50
#pathcost 30
#startdom 1

#ap 16
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 18
#def 20
#prec 16
#mr 15
#mor 30
#ambidextrous 4
#forestsurvival
#mountainsurvival
#nametype 129
#reinvigoration 1
#heal
#spy
#stealthy
#magicskill 1 2
#researchbonus -2
#weapon 671
#armor "Golden Chain Mail"
#armor "Red Feather Cap"
#okleader
#okmagicleader
#poorundeadleader
#makemonster1 2290
#onebattlespell "Personal Luck"
#end


#newmonster 2353
#name "Monkey King"
#descr "In primordial times, a monkey left the mountains to seek a way to immortality. He sought tutelege under a great Taoist sage who was impressed by his determination and intelligence and taught him the arts of 72 earthly transformations.  Although he learned immortality, he became famous for fighting, being a nuisance, and making trouble in the Heavens and Hells.  He was able to trick the East Sea Dragon King into giving him several magic gifts, including his magic armor and his staff which can be made to grow to any size.  He was sealed under a mountain by the Buddha for 500 years, and now has emerged to unleash his mischief.  His magical abilities include making copies of himself, and performing a 'cloud summersault' that can cover great distances."
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"

#restrictedgod 43
#gcost 50
#pathcost 30
#startdom 1

#ap 16
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 18
#def 20
#prec 16
#mr 15
#mor 30
#ambidextrous 4
#forestsurvival
#mountainsurvival
#nametype 129
#reinvigoration 1
#heal
#spy
#stealthy
#magicskill 1 2
#researchbonus -2
#weapon 671
#armor "Golden Chain Mail"
#armor "Red Feather Cap"
#okleader
#okmagicleader
#poorundeadleader
#makemonster1 2290
#onebattlespell "Personal Luck"
#end


#newmonster 2354
#name "Monkey King"
#descr "In primordial times, a monkey left the mountains to seek a way to immortality. He sought tutelege under a great Taoist sage who was impressed by his determination and intelligence and taught him the arts of 72 earthly transformations.  Although he learned immortality, he became famous for fighting, being a nuisance, and making trouble in the Heavens and Hells.  He was able to trick the East Sea Dragon King into giving him several magic gifts, including his magic armor and his staff which can be made to grow to any size.  He was sealed under a mountain by the Buddha for 500 years, and now has emerged to unleash his mischief.  His magical abilities include making copies of himself, and performing a 'cloud summersault' that can cover great distances."
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"

#restrictedgod 64
#gcost 50
#pathcost 30
#startdom 1

#ap 16
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 18
#def 20
#prec 16
#mr 15
#mor 30
#ambidextrous 4
#forestsurvival
#mountainsurvival
#nametype 129
#reinvigoration 1
#heal
#spy
#stealthy
#magicskill 1 2
#researchbonus -2
#weapon 671
#armor "Golden Chain Mail"
#armor "Red Feather Cap"
#okleader
#okmagicleader
#poorundeadleader
#makemonster1 2290
#onebattlespell "Personal Luck"
#end


--------------------------------------------------------------------------------
#newmonster 2304
#name "Black Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The Black Dragon is among the most feared of all dragons because of its terrible disintegration breath weapon.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from."
#spr1 "./mytheology/blackdragon1.tga"
#spr2 "./mytheology/blackdragon2.tga"
#itemslots 15494

#startdom 1
#pathcost 80
#gcost 70

#hp 125
#prot 18
#mor 30
#mr 22
#enc 3
#str 25
#att 15
#def 11
#prec 12
#mapmove 3
#ap 10
#size 6
#shapechange 2308 -- change into chaos mage
#fear 5
#flying 
#darkvision 50
#poisonres 50
#fireres 50
#coldres 50
#okleader
#poormagicleader
#poorundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 668
#itemslots 12416
#end



--------------------------------------------------------------------------------
-- This is my tribute to David Trampier's "Solomoriah".  If you arent familiar
-- with Trampier's early work in Dragon magazine, be sure to visit an archive
-- at http://www.angelfire.com/wa2/haroog/archive/Archive.htm
-- Also interesting how Jeff Smith's "RockJaw" character also has a passing
-- similarity.
#newmonster 2306
#name "Shadowcat"
#descr "The Shadowcat comes from the time of the dragons, and is known to war with them at every opportunity.  It appears as a winged panther of monstrous size, black as night yet glowing with strange internal lights. The Shadowcat is an ancient master of planar travel and astral magic."
#spr1 "./mytheology/solomoriah1.tga"
#spr2 "./mytheology/solomoriah2.tga"

#gcost 50
#startdom 1
#pathcost 70

#hp 140
#prot 8
#mor 30
#mr 20
#enc 2
#str 25
#att 15
#def 18
#prec 14
#mapmove 4
#ap 14
#size 5
#flying 
#darkvision 50
#itemslots 28800
#okleader
#poormagicleader
#poorundeadleader
#magicskill 4 2
#weapon 667
#weapon 666
#stealthy
#ethereal
#end


--------------------------------------------------------------------------------
#newmonster 2296
#name "Gold Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from.  The Gold Dragon is among the most powerful of dragons, and has an increased ability to cast elemental magic."
#spr1 "./mytheology/lung1.tga"
#spr2 "./mytheology/lung2.tga"

#restrictedgod 5 -- EA T'ien Ch'i
#gcost 50
#startdom 1
#pathcost 80

#itemslots 15494
#hp 110
#prot 18
#mor 30
#mr 20
#enc 3
#str 25
#att 16
#def 13
#prec 12
#mapmove 3
#ap 10
#size 6
#shapechange 2299
#awe 5
#flying 
#nametype 121
#poisonres 50
#fireres 50
#coldres 50
#expertleader
#expertmagicleader
#magicskill 3 2
#magicboost 3 -2
#noundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 665
#itemslots 12416
#end


#newmonster 2297
#name "Gold Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from.  The Gold Dragon is among the most powerful of dragons, and has an increased ability to cast elemental magic."
#spr1 "./mytheology/lung1.tga"
#spr2 "./mytheology/lung2.tga"

#restrictedgod 34  -- MA T'ien Ch'i
#gcost 50
#startdom 1
#pathcost 80


#itemslots 15494
#hp 110
#prot 18
#mor 30
#mr 20
#enc 3
#str 25
#att 16
#def 13
#prec 12
#mapmove 3
#ap 10
#size 6
#shapechange 2299
#awe 5
#flying 
#nametype 121
#poisonres 50
#fireres 50
#coldres 50
#expertleader
#expertmagicleader
#magicskill 3 2
#magicboost 3 -2
#noundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 665
#end

#newmonster 2298
#name "Gold Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from.  The Gold Dragon is among the most powerful of dragons, and has an increased ability to cast elemental magic."
#spr1 "./mytheology/lung1.tga"
#spr2 "./mytheology/lung2.tga"

#restrictedgod 55 -- LA T'ien Ch'i
#gcost 50
#startdom 1
#pathcost 80

#itemslots 15494
#hp 110
#prot 18
#mor 30
#mr 20
#enc 3
#str 25
#att 16
#def 13
#prec 12
#mapmove 3
#ap 10
#size 6
#shapechange 2299
#awe 5
#flying 
#nametype 121
#poisonres 50
#fireres 50
#coldres 50
#expertleader
#expertmagicleader
#magicskill 3 2
#magicboost 3 -2
#noundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 665
#end


--------------------------------------------------------------------------------
#newmonster 2350
#name "Father of Medicine"
#descr "The Father of Medicine was a mortal whose knowledge of healing, herbs, and medicine was so great that it was said he could cure death itself.  He has the ability to heal his followers with amazing skill, and to heal himself almost completely after every attack.  He carries a staff, around which is coiled a snake which protects him at all times out of gratitude for being brought back from the dead."
#spr1 "./mytheology/asclepios1.tga"
#spr2 "./mytheology/asclepios2.tga"

#gcost 40
#startdom 1
#pathcost 10

#hp 10
#prot 0
#mor 30
#mr 18
#enc 3
#str 10
#att 8
#def 12
#prec 16
#mapmove 3
#ap 12
#size 2
#nametype 107
#poisonres 50
#magicskill 6 1
#regeneration 75
#heal
#healer 50
#goodleader
#okmagicleader
#noundeadleader
#researchbonus 5
#weapon 89
#end


--------------------------------------------------------------------------------
#newmonster 2346
#name "The Earthen Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Earthen Eye can shapeshift to enhance it's magical powers and abilities in the earth and air elements respectively.  Although a master of earth magic, the Earthen Eye has no weapons but it's spells."
#spr1 "./mytheology/greateye_earth1.tga"
#spr2 "./mytheology/greateye_earth2.tga"

#gcost 60
#startdom 2
#pathcost 30

#hp 20
#prot 10
#mor 30
#mr 18
#enc 0
#str 10
#att 10
#def 10
#prec 20
#mapmove 0
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 663
#itemslots 61440
#flying
#trample
#magicboost 3 1
#magicboost 6 1
#magicskill 1 1
#magicskill 3 1
#patrolbonus 100
#pooramphibian
#poisonres 100
#shapechange 2347
#maxage 4000
#end


--------------------------------------------------------------------------------
#newmonster 2347
#name "The Aether Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Aether Eye can shapeshift to enhance it's magical powers and abilities in the air and earth elements respectively.  Although a master of air magic, the Aether Eye has no weapons but its spells."
#spr1 "./mytheology/greateye_air1.tga"
#spr2 "./mytheology/greateye_air2.tga"
#hp 20
#prot 10
#mor 30
#mr 18
#enc 0
#str 10
#att 10
#def 10
#prec 20
#mapmove 4
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 663
#itemslots 61440
#flying
#magicboost 1 1
#magicboost 6 1
#magicskill 3 1
#magicskill 1 1
#patrolbonus 100
#shockres 100
#illusion
#airshield
#shapechange 2346
#maxage 4000
#end


--------------------------------------------------------------------------------
#newmonster 2348
#name "The Celestial Eye"
#descr "This Pretender manifests as a great, benevolent, unblinking eye that always watches over its entire dominion. An adept of celestial magics, the Celestial Eye has no weapons but its spells, and can travel vast distances over land, air and water"
#spr1 "./mytheology/greateye_water1.tga"
#spr2 "./mytheology/greateye_water2.tga"

#gcost 70
#startdom 2
#pathcost 30

#hp 18
#prot 8
#mor 30
#mr 18
#enc 0
#str 10
#att 10
#def 10
#prec 20
#mapmove 4
#ap 16
#size 3
#poorleader
#poormagicleader
#noundeadleader
#eyes 1
#neednoteat
#weapon 663
#itemslots 61440
#flying
#amphibian
#magicskill 1 1
#magicskill 2 1
#magicskill 4 1
#patrolbonus 100
#coldres 100
#iceprot 2
#nobadevents 20
#maxage 4000
#end


--------------------------------------------------------------------------------
#newmonster 2343
#name "The Infernal Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Great Eye can take different shapes to enhance its magical powers and abilities in the elements of fire and air.  Although a master of fire magic, the Great Eye has no weapons but its spells."
#spr1 "./mytheology/greateye_fire1.tga"
#spr2 "./mytheology/greateye_fire2.tga"

#gcost 60
#startdom 2
#pathcost 30

#prot 10
#mor 30
#mr 18
#enc 0
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 663
#itemslots 61440
#flying
#magicskill 0 2
#magicskill 7 1
#patrolbonus 100
#fireres 100
#fireshield 8
#maxage 4000
#pillagebonus 40
#end


--------------------------------------------------------------------------------
#newmonster 2322
#name "The Astral Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  Although the Astral Eye is a powerful user of astral magic, it has no weapons but its spells.  Once in each battle the Astral Eye can completely recuperate its wounds and become ethereal, but at the cost of much of its magic strength. The Astral Eye is covered by an Astral Shield when danger threatens."
#spr1 "./mytheology/greateye_astral1.tga"
#spr2 "./mytheology/greateye_astral2.tga"

#gcost 70
#startdom 2
#pathcost 30

#hp 20
#prot 10
#mor 30
#mr 18
#enc 0
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#goodmagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 663
#itemslots 61440
#flying
#pooramphibian
#astralshield
#onebattlespell 556
#secondshape 2341
-- I'd just rather give a +2 astral magicboost here
#magicskill 4 3
#patrolbonus 100
#researchbonus 3
#maxage 4000
#end


--------------------------------------------------------------------------------
#newmonster 2341
#name "The Ethereal Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  Although the Astral Eye is a powerful user of astral magic, it has no weapons but its spells.  After recovering from battle, the Astral Eye loses its ability to become ethereal but regains its magical strength."
#spr1 "./mytheology/greateye_ethereal1.tga"
#spr2 "./mytheology/greateye_ethereal2.tga"
#hp 40
#prot 14
#mor 30
#mr 20
#enc 0
#str 10
#att 8
#def 12
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 663
#itemslots 61440
#flying
#pooramphibian
#astralshield
#onebattlespell 556
#ethereal
#firstshape 2322
-- I'd rather just take away the +2 astral magicboost, but that doesn't work
-- so this does just the opposite - steals 1 level in everything but astral
#magicboost 0 -1
#magicboost 1 -1
#magicboost 2 -1
#magicboost 3 -1
#magicboost 5 -1
#magicboost 6 -1
#magicboost 7 -1
#maxage 4000
#end


--------------------------------------------------------------------------------
#newmonster 2337
#name "Cthulhu"
#descr "Cthulhu was the strongest and most feared of the Great Old Ones, the monstrous godlike spawn of entities beyond this plane.  In the time of the previous Pantokrator, Cthulhu built R'lyeh and together with his starspawn he struggled with the Pantokrator for this universe.  Although Cthulhu was narrowly defeated by the previous Pantokrator, he was too powerful to be killed and was instead imprisoned.  Now, Cthulhu again awakens from his ancient dreaming beneath the ocean, and reaches out to twist the world to his insane lust."
#spr1 "./mytheology/cthulhu1_small.tga"
#spr2 "./mytheology/cthulhu2_small.tga"
#restrictedgod 22 --early rlyeh
#ap 14
#hp 101
#mapmove 2
#size 5
#prot 14
#enc 2
#str 24
#att 14
#def 10
#prec 12
#mr 22
#mor 30
#gcost 270
#pathcost 60
#startdom 3
#fear 2
#itemslots 28806 -- head, 2 hands, 3 misc
#nametype 117
#immortal
#flying
#amphibian
#poisonres 50
#darkvision 50
#magicskill 4 4 -- astral
#okleader
#expertmagicleader
#poorundeadleader
#weapon "Claw"
#weapon "Claw"
#weapon "Mind Blast"
#end

#newmonster 2338
#name "Cthulhu"
#descr "Cthulhu was the strongest and most feared of the Great Old Ones, the monstrous godlike spawn of entities beyond this plane.  In the time of the previous Pantokrator, Cthulhu built R'lyeh and together with his starspawn he struggled with the Pantokrator for this universe.  Although Cthulhu was narrowly defeated by the previous Pantokrator, he was too powerful to be killed and was instead imprisoned.  Now, Cthulhu again awakens from his ancient dreaming beneath the ocean, and reaches out to twist the world to his insane lust."
#spr1 "./mytheology/cthulhu1_small.tga"
#spr2 "./mytheology/cthulhu2_small.tga"
#restrictedgod 47 -- middle
#ap 14
#hp 101
#mapmove 2
#size 5
#prot 14
#enc 2
#str 24
#att 14
#def 10
#prec 12
#mr 22
#mor 30
#gcost 270
#pathcost 60
#startdom 3
#fear 2
#itemslots 28806 -- head, 2 hands, 3 misc
#nametype 117 
#immortal
#flying
#amphibian
#poisonres 50
#darkvision 50
#magicskill 4 4 -- astral
#okleader
#expertmagicleader
#poorundeadleader
#weapon "Claw"
#weapon "Claw"
#weapon "Mind Blast"
#end


#newmonster 2339
#name "Cthulhu"
#descr "Cthulhu was the strongest and most feared of the Great Old Ones, the monstrous godlike spawn of entities beyond this plane.  In the time of the previous Pantokrator, Cthulhu built R'lyeh and together with his starspawn he struggled with the Pantokrator for this universe.  Although Cthulhu was narrowly defeated by the previous Pantokrator, he was too powerful to be killed and was instead imprisoned.  Now, Cthulhu again awakens from his ancient dreaming beneath the ocean, and reaches out to twist the world to his insane lust."
#spr1 "./mytheology/cthulhu1_small.tga"
#spr2 "./mytheology/cthulhu2_small.tga"
#restrictedgod 67 --late
#ap 14
#hp 101
#mapmove 2
#size 5
#prot 14
#enc 2
#str 24
#att 14
#def 10
#prec 12
#mr 22
#mor 30
#gcost 270
#pathcost 60
#startdom 3
#fear 2
#itemslots 28806 -- head, 2 hands, 3 misc
#nametype 117 
#immortal
#flying
#amphibian
#poisonres 50
#darkvision 50
#magicskill 4 4 -- astral
#okleader
#expertmagicleader
#poorundeadleader
#weapon "Claw"
#weapon "Claw"
#weapon "Mind Blast"
#end


--------------------------------------------------------------------------------
#newmonster 2334
#name "Empress of Assassins"
#descr "In hidden and dark places, the Empress has grown huge and powerful over the course of millennia.  Now, her seething hunger and hatred have driven her to assume dominion, and she craves to have her children overrun the lands of light.  Her presence drives increases the number of spiders in a region, frightening impressionable peasants."

#startdom 2 
#gcost 50
#pathcost 70
#restrictedgod 35 -- MA Machaka

#spr1 "./mytheology/lolth1.tga"
#spr2 "./mytheology/lolth2.tga"
#hp 55
#ap 14
#hp 60
#mapmove 1
#size 4
#prot 12
#str 16
#enc 2
#att 16
#def 12
#prec 20
#mr 12
#mor 30
#female
#fear 0
#itemslots 61446
#magicskill 5 1
#domsummon2 2333
#stealthy 10
#okleader
#poormagicleader
#okundeadleader
#mountainsurvival
#forestsurvival
#poisonres 100
#eyes 6
#assassin
#weapon 262 -- web spit
#weapon 262 -- web spit
#weapon 65 -- venomous fangs, death poison
#incunrest 2
#pillage 5
#nametype 125
#darkvision 100
#end

--------------------------------------------------------------------------------
#newmonster 2330
#name "Ubbo-Sathla"
#descr "In the grey beginning of Earth, the formless mass that was the Ubbo-Sathla reposed amid the slime and the vapors. Headless, without organs or members, it sloughed from its oozy sides, in a slow, ceaseless wave, the amoebic forms that were the archetypes of earthly life.  The Ubbo-Sathla was created as an experiment by the Elder Things to create a servant more powerful and intelligent than their shoggoths, but the Ubbo-Sathla proved too strong and dangerous so its aquatic and inscrutible creators sealed it away in an arcane prison beneath a great ancient continent.  The Ubbo-Sathla's prison weakened over the millenia, and it has escaped to insinuate its malevolence upon the universe.  Ubbo-Sathla appears as a giant protoplasmic, shapeless, amoeba-like entity that forms tentacles and pseudopods at will, devouring everything it touches."
#spr1 "./mytheology/shoggoth_small1.tga"
#spr2 "./mytheology/shoggoth_small2.tga"

#gcost 130
#pathcost 50
#startdom 1
#restrictedgod 22 --early rlyeh

#ap 10
#hp 200
#mapmove 1
#size 6
#prot 8
#str 18
#enc 4
#att 14
#def 8
#prec 12
#mr 18
#mor 30
#fear 1
#itemslots 61440 -- 4 items
#domsummon2 2329 -- protoplasms
#makemonster2 2329 -- grunt!  produce a protoplasmic spawn.
#okleader
#okmagicleader
#okundeadleader
#poisonres 100
#shockres -50
#weapon 662 -- acid stream
#weapon 85 -- tentacle
#weapon 85 -- tentacle
#nametype 117
#blind
#heal
#amphibian
#poisonarmor
#regeneration 10
#trample
#entangle
#pillagebonus 25
#popkill 10
#incunrest 10
#leper 10
#supplybonus -20
#end

--------------------------------------------------------------------------------
#newmonster 2326
#name "Kong"
#descr "Incarnated as a gorilla of staggering size, strength, and ferocity, the Great Kong is unequalled in combat and a veteran of battles against the most terrifying of dragons and monsters.  He is most fierce in the defense of his followers and those under his protection."
#spr1 "./mytheology/kong1.tga"
#spr2 "./mytheology/kong2.tga"
#restrictedgod 18
#gcost 35
#pathcost 50
#startdom 2
#ap 14
#hp 180
#mapmove 1
#size 5
#prot 18
#str 40
#enc 1
#att 18
#def 16
#prec 14
#mr 12
#mor 30
#itemslots 28806 -- head, hands, 3 items
#goodleader
#okmagicleader
#noundeadleader
#weapon "Fist"
#weapon "Fist"
#weapon "Bite" 
#weapon 360 -- sticks and stones
#fear 0
#nametype 129
#siegebonus 20
#end

#newmonster 2325
#name "Kong"
#descr "Incarnated as a gorilla of staggering size, strength, and ferocity, the Great Kong is unequalled in combat and a veteran of battles against the most terrifying of dragons and monsters.  He is most fierce in the defense of his followers and those under his protection."
#spr1 "./mytheology/kong1.tga"
#spr2 "./mytheology/kong2.tga"
#restrictedgod 43
#gcost 35
#pathcost 50
#startdom 2
#ap 14
#hp 180
#mapmove 1
#size 5
#prot 18
#str 40
#enc 1
#att 18
#def 16
#prec 14
#mr 12
#mor 30
#itemslots 28806 -- head, hands, 3 items
#goodleader
#okmagicleader
#noundeadleader
#weapon "Fist"
#weapon "Fist"
#weapon "Bite" 
#weapon 360 -- sticks and stones
#fear 0
#nametype 129
#siegebonus 20
#end


#newmonster 2324
#name "Kong"
#descr "Incarnated as a gorilla of staggering size, strength, and ferocity, the Great Kong is unequalled in combat and a veteran of battles against the most terrifying of dragons and monsters.  He is most fierce in the defense of his followers and those under his protection."
#spr1 "./mytheology/kong1.tga"
#spr2 "./mytheology/kong2.tga"
#restrictedgod 64
#gcost 50
#pathcost 35
#startdom 2
#ap 14
#hp 180
#mapmove 1
#size 5
#prot 18
#str 40
#enc 1
#att 18
#def 16
#prec 14
#mr 12
#mor 30
#itemslots 28806 -- head, hands, 3 items
#goodleader
#okmagicleader
#noundeadleader
#weapon "Fist"
#weapon "Fist"
#weapon "Bite" 
#weapon 360 -- sticks and stones
#fear 0
#nametype 129
#siegebonus 20
#end

--------------------------------------------------------------------------------
#newmonster 2327
#name "Jack of Shadows"
#descr "There is a reason to fear the dark.  Jack is the lord of the realm of shadows, and he can shape and become the substance of shadows at will.  Being made of shadow, it is very difficult to harm him, and if he is destroyed he has the ability to reform his body from the darkest shadows in his kingdom.  Although it was stolen from him, he created the Sun Slayer Sword in his obsession to drive light from the world of the living.  He is a master of death magics and his powers are greatest in the absence of light."
#spr1 "./mytheology/shadowjack1.tga"
#spr2 "./mytheology/shadowjack2.tga"
#gcost 150
#pathcost 40
#startdom 2
#ap 14
#hp 20
#mapmove 3
#size 2
#prot 0
#str 12
#enc 1
#att 12
#def 16
#prec 14
#mr 14
#mor 30
#okleader
#goodmagicleader
#expertundeadleader
#weapon 661
#spy
#stealthy 100
#blind
#darkpower 5
#darkvision 100
#assassin
#amphibian
#immortal
#ethereal
#clearmagic
#magicskill 5 1 -- death
#end


--------------------------------------------------------------------------------
#newmonster 2302
#name "Prodigal King"
#descr "Foretold by prophesy and guided by destiny, the King was born the greatest of all men.  Prodigious deeds as a child marked him as special, and he became the mightiest of heroes.  No beast, monster, or man could stand before him, and he inspired love and loyalty in all who followed his banner.  He built a golden age by uniting all the kingdoms under a rule of peace, law, and prosperity.  In the end, all his works were brought low by treachery and love. His saga is told by every campfire, and it is said he will return when his people need him most.  He wields a magical sword of divine and mystical origin.  His presence on the battlefield is a sure sign that his side is destined to win."
#spr1 "./mytheology/prodigalking1.tga"
#spr2 "./mytheology/prodigalking2.tga"

#gcost 50
#startdom 1
#pathcost 60

#hp 80
#mor 30
#str 18
#mr 14
#att 22
#def 18
#prot 0
#prec 17
#ap 16
#mapmove 2
#enc 2
#size 2

#standard 100
--onebattlespell 344 -- "Quicken Self" -- really?
#onebattlespell "Will of the Fates"
#okmagicleader
#expertleader
#maxage 9000
#weapon 74 -- plain ol' sword of sharpnss
#heal
#armor "Weightless Scale"
#armor "Crown"
#itemslots 64646
#end

--------------------------------------------------------------------------------
#newmonster 2542
#name "Aku" -- Normal shape
#descr "Aku is the shapeshifting master of darkness.  He is consumed by his lust to control the world and reshape it after his own image.  Although his magic is powerful and versatile, he often delights in destroying his enemies by taking the shape of a giant dragon or other monster.  Aku was born at the creation of the universe, and cannot be slain by any mortal weapon."
#spr1 "./mytheology/aku1.tga"
#spr2 "./mytheology/aku2.tga"

#gcost 210
#startdom 3
#pathcost 30

#hp 50
#mor 30
#str 20
#mr 16
#att 12
#def 12
#prot 12
#prec 14
#ap 10
#mapmove 1
#enc 0
#size 5 -- titanic
#magicskill 4 1
#magicskill 5 1
#resfire 50
#respoison 50
#rescold 50

#immortal
#goodmagicleader
#okleader
#goodundeadleader
#darkvision 50
#amphibian
#weapon 92 -- fist
#itemslots 12422 -- head, hands, 2 miscs only
#shapechange 2543 -- dragon aku
#watershape 2544 -- octo aku
#maxage 9999
#end

----------------
#newmonster 2543 
#name "Aku" -- dragon shape
#descr "Aku is the shapeshifting master of darkness.  He is consumed by his lust to control the world and reshape it after his own image.  Although his magic is powerful and versatile, he often delights in destroying his enemies by taking the shape of a giant dragon or other monster.  Aku was born at the creation of the universe, and cannot be slain by any mortal weapon.  Aku's dragon shape is fearsome in combat, and has a terrifying fire breath weapon, but is not suited for casting magic."
#spr1 "./mytheology/akudragon1.tga"
#spr2 "./mytheology/akudragon2.tga"
#startdom 1
#pathcost 30
#hp 50
#mor 30
#str 20
#mr 16
#att 12
#def 12
#prot 16
#prec 16
#ap 16
#mapmove 2
#enc 1
#size 6 -- titanic to dragonic!
#magicboost 53 -2
#resfire 50
#respoison 50
#rescold 50
#immortal
#goodmagicleader
#okleader
#goodundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 225
#darkvision 50
#fear 3
#flying 
#amphibian
#itemslots 12416 -- head,  miscs only
#shapechange 2542 -- Normal aku
#watershape 2544 -- octo aku
#maxage 9999
#end

----------------
#newmonster 2544 
#name "Aku" -- octo shape
#descr "Aku is the shapeshifting master of darkness.  He is consumed by his lust to control the world and reshape it after his own image.  Although his magic is powerful and versatile, he often delights in destroying his enemies by taking the shape of a giant dragon or other monster.  Aku was born at the creation of the universe, and cannot be slain by any mortal weapon. Aku's octopoid shape is versatile in combat on both land and underwater, but is not very suitable for manipulating magic."
#spr1 "./mytheology/akuoctopoid1.tga"
#spr2 "./mytheology/akuoctopoid2.tga"

#hp 50
#mor 30
#str 20
#mr 16
#att 12
#def 12
#prot 14
#prec 14
#ap 14
#mapmove 1
#enc 1
#size 6 -- titanic
#magicboost 53 -1
#resfire 50
#respoison 50
#rescold 50

#weapon 85
#weapon 85
#weapon 85
#weapon 85
#weapon 85
#weapon 85

#immortal
#goodmagicleader
#okleader
#goodundeadleader
#darkvision 50
#maxage 9999
#amphibian
#itemslots 12318 -- 4 hands,   miscs only
#landshape 2542 -- normal aku
#end

----------------
#newmonster 2545
#copystats 0222
#clearspec
#clearmagic
#name "The Ecclesiarch"
#descr "The Ecclesiarch is the leader of a theocratic state church. A figurehead of an entire nation, granted his position by divine intervention. Through rituals, scrying and research, the inquisitors, bishops and cardinals of the church seek out and gather fitting individuals from within the church to carry out the will of God. The Ecclesiarch travels with a civilian retinue at all times and because of this, more supplies are consumed. The Ecclesiarch commands dread and awe, guided by epiphany and revelation. Should he be killed in combat within his own dominion, he will immediatly be replaced by a new Ecclesiarch appointed by the capitol church."
#spr1 "./mytheology/the_ecclesiarch_1.tga"
#spr2 "./mytheology/the_ecclesiarch_2.tga"

#startdom 4
#pathcost 40
#gcost 80
#rcost 0

#hp 16
#size 2
#ressize 2
#prot 12
#mor 30
#mr 18
#enc 2
#str 8
#att 10
#def 12
#prec 14
#mapmove 1
#ap 10
#armor "Papal Mitre"
#weapon "Sceptre of Authority"
#expertleader
#nomagicleader
#noundeadleader
#itemslots 63494 -- two hands, one feet, four misc
#magicskill 4 2
#magicskill 8 2
#immortal
#supplybonus -20
#eyes 20
#awe 3
#fear 2
#nobadevents 20
#pillagebonus 20
#patrolbonus 20
#maxage 100
#startage 73
#inquisitor
#end

----------------
#newmonster 2546
#spr1 "./mytheology/god-king_1.tga"
#spr2 "./mytheology/god-king_2.tga"
#name "God-King"
#descr "The God-King is the undisputed despot of a nation. He deified the previous king upon claiming the throne, declaring himself Son of God and God-King. As the Son of God he holds great sway over his people, regularly demanding blood sacrifices. With great power comes great arrogance and now the Son of God claims true godhood himself. The God-King is a poor warrior and only travels mounted on a levitating dais."

#gcost 45
#rcost 0
#startdom 2
#pathcost 10

#hp 16
#size 2
#ressize 2
#prot 2
#mor 30
#mr 18
#enc 2
#str 8
#att 8
#def 17
#prec 14
#mapmove 2
#ap 8
#weapon 63
#goodleader
#goodmagicleader
#noundeadleader
#itemslots 62592 -- one head, one body, four misc
#magicskill 7 1
#gemprod 7 1
#flying
#mounted
#eyes 8
#end

----------------
#newmonster 2547
#spr1 "./mytheology/the_sunwell_1.tga"
#spr2 "./mytheology/the_sunwell_2.tga"
#name "Sunwell"
#descr "The Sunwell is an ancient spirit that inhabits a springwell of arcane energy. The spirit possesses a man to serve as it's instrument. The chosen man is blinded and rendered unable to do anything but speak the will of the spirit. At the age of sixty, he is sacrificed and replaced with a new young man of arcane education. The Sunwell is immobile and cannot leave the well it inhabits. It can possess willing targets to perform tasks such as forging items for enchantment. The Sunwell is tremendously powerful in arcane magic. Anyone wishing to harm the well will be mesmerised by the golden waters and it's awe. The wellspring can be destroyed, but not easily."

#gcost 40
#rcost 0
#startdom 4
#pathcost 20

#hp 10
#size 6
#ressize 6
#prot 24
#mor 30
#mr 22
#enc 0
#str 14
#att 4
#def 2
#prec 8
#mapmove 0
#ap 2
#poorleader
#superiormagicleader
#poorundeadleader
#itemslots 61440 -- four misc
#magicskill 0 2
#magicskill 4 2
#gemprod 4 4
#researchbonus 4
#inanimate
#neednoteat
#immobile
#blind
#awe 3
#end

----------------
#newmonster 2548
#spr1 "./mytheology/spider_king_1.tga"
#spr2 "./mytheology/spider_king_2.tga"
#name "Spider King"
#descr "The Spider King is a hideous and twisted being with the body of a huge spider and the upper torso of a muscular human. The Spider King is a mighty beast capable of spitting webbings over distance and deliver devestating poisonous bites."

#startdom 2
#pathcost 40
#gcost 60
#rcost 0

#hp 62
#size 5
#prot 16
#mor 30
#mr 18
#enc 2
#str 14
#att 16
#def 7
#prec 8
#mapmove 3
#ap 12
#weapon 92
#weapon 314
#weapon 262
#fireres 0
#itemslots 61574
#magicskill 5 1
#magicskill 6 1
#forestsurvival
#mountainsurvival
#okleader
#poormagicleader
#poorundeadleader
#poisonres 100
#darkvision 100
#ambidextrous 4
#eyeloss
#mounted
#fear 1
#supplybonus -30
#eyes 8
#maxage 1600
#startage 460
#end

################################################################################
##   Summons as Pretenders
################################################################################
#newmonster 2345
#copystats 621
#name "Yggdrasil"
#descr "Yggdrasil is the great World Tree, whose trunk pierces the world, upon whose branches rests the heavens, and amongst whose roots lie the underworlds.  Yggdrasil has grown a small branch of itself and invested it with its will and magic, and sent it into the world to destroy all irresponsible Pretenders who may threaten the woods and trees.  Yggdrasil can reawaken Vine Men in great numbers."
#spr1 "./mytheology/treelord1.tga"
#spr2 "./mytheology/treelord2.tga"

#restrictedgod 3 -- EA Manverni
#mor 30
#gcost 70
#startdom 1
#pathcost 50

#str 30
#size 5
#itemslots 61440
#goodleader
#goodmagicleader
#weapon "Branch"
#weapon "Branch"
#weapon "Vine Bow"
#trample
#heal
#maxage 99999
#startage 10000
#end


--------------------------------------------------------------------------------
#newmonster 2349
#copystats 925
#name "Tarrasque"
#descr "The Tarrasque is an ancient, poison-breathing dragon of tremendous size.  It has awakened to claim its place as the One True God, destroying all other Pretenders and threats to his earth and nature kingdom. The Tarrasque regenerates wounds, has an incredibly thick hide, and is constantly surrounded by noxious vapors."
#copyspr 925

#restrictedgod 11 -- EA Pangea
#gcost 50
#mor 30
#startdom 1
#pathcost 70

#goodleader
#poormagicleader
#poorundeadleader
#end



--------------------------------------------------------------------------------
#selectmonster "Heliophagus"
#name "Heliophagus"
#descr "The Heliophagii -- the 'Sun Eaters' -- are the Lords of the Abyss.  They are composed of solid darkness except for their golden claws and horns.  They have the ability to become invisible in shadows, and they are horrible to behold.  They are only four known Heliophagii, and they are all skilled in Blood magic.  He has the ability to summon Fiends of Darkness, and his knowledge of Blood magic is extraordinary."

#restrictedgod 58 - LA Abysia
#mor 30
#gcost 110
#startdom 2
#pathcost 60

#goodleader
#goodmagicleader
#goodundeadleader
#end



--------------------------------------------------------------------------------
#selectmonster "King of Deeper Earth"
#name "King of Deeper Earth"
#descr "The King of Elemental Earth is a physical manifestation of the wild magic of the Earth.  He has a body of stone and soil and appears as a huge, crowned humanoid.  He is innately skilled in Earth magic and can summon Earth Elementals from the deeper reaches of the world to serve him.  From his body seeps Earth blood that crystallizes into gems of Earth power.  The King draws power from the ground and regenerates his woulds.  Only three Kings of Elemental Earth are known to exist, and one of them has been tainted by Blood magic."

#restrictedgod 12 EA Agartha
#mor 30
#gcost 100
#startdom 2
#pathcost 50

#goodleader
#goodmagicleader
#poorundeadleader
#end

--------------------------------------------------------------------------------
#selectmonster "Queen of the Sea"
#name "Queen of the Sea"
#descr "The Queen of Elemental Water is a physical manifestation of the wild magic of the water. She resembles a huge, crowned female being composed of water.  She is innately skilled in Water magic and can summon Undines to serve her.  The Queen's body is composed of water and is very difficult to harm when she is underwater.  Unless she is completely killed during one combat round, she will heal all her wounds.  She cannot leave the sea.  Only three Queens of Elemental Water are known to exist."

#restrictedgod 26 - EA Oceania
#gcost 70
#mor 30
#startdom 2
#pathcost 50

#goodleader
#goodmagicleader
#poorundeadleader
#end


--------------------------------------------------------------------------------
#selectmonster "Queen of Thunder"
#name "Queen of Thunder"
#descr "The Queen of Elemental Air is a physical manifestation of the wild magic of the air.  She has a body composed of billowing clouds and appears as a huge, crowned female being.  She is innately skilled in Air magic.  She is the Queen of Thunder, and her powers are increased during storms.  Her body is composed of clouds and mist and is difficult to harm.  Only three Queens of Elemental Air are known to exist."

#restrictedgod 9 - EA Caelum
#gcost 70
#mor 30
#startdom 2
#pathcost 50

#goodleader
#goodmagicleader
#poorundeadleader
#end


--------------------------------------------------------------------------------
#selectmonster "King of Banefires"
#name "King of Banefires"
#descr "The King of Elemental Fire is a physical manifestation of the wild magic of Fire.  Once there were three such kings, but one of them was corrupted with blood magic and the taint of the underworld.  He has broken free of his subservience to the Lord of the Underworld, and seeks to establish himself as the True God.  He has a body of blazing Banefire and appears as a huge, crowned King.  He is innately skilled in Fire and Death magic and is constantly surrounded by a shield of blazing Banefire."

#restrictedgod 19 - EA Yomi
#gcost 170
#mor 30
#startdom 2
#pathcost 50

#goodleader
#goodmagicleader
#expertundeadleader
#end


--------------------------------------------------------------------------------
#selectmonster "Vastness"
#name "Vastness"
#descr "The Vastness is an otherworldly being of almost godlike power.  It is composed of spheres of stellar lights and shades.  Originating from Beyond, the Vastness has entered this plane in order to make the universe its playground.  The Vastness can blast the minds of lesser beings, and its touch steals the strength of living beings.  Anyone striking at the Vastness is likely to be punished for their arrogance, taking damage themselves instead of harming the Vastness."

#restrictedgod 47- MA R'lyeh
#gcost 180
#mor 30
#startdom 1
#pathcost 60

#goodleader
#goodmagicleader
#poorundeadleader
#itemslots 12288
#end


--------------------------------------------------------------------------------
#newmonster 2331
#name "Shah of Djinn and Ifreet"
#descr "An ancient and powerful lord of Air and Fire, the Shah of all Djinn and Ifreet is a mighty spirit whose subjects were exiled from the world to make room for Man and the Younger Races.  Now that the old Pantokrator has gone, he has finally broken the seals preventing his return.  He is malicious and resentful of the world of Man, and has come to claim the throne of Ruler of the World and become God of both the Old Races and the Young Races alike."
#spr1 "./mytheology/djinn.tga"
#spr2 "./mytheology/djinn2.tga"

#restrictedgod 53 -- LA Marignon
#gcost 340
#startdom 3
#pathcost 50

#itemslots 62598

#mor 30
#hp 50
#prot 3
#morale 30
#mr 20
#enc 0
#str 30
#att 24
#def 19
#prec 19
#mapmove 5
#ap 12
#magicskill 0 2
#magicskill 1 2
#magicskill 4 2
#expertleader
#expertmagicleader
#poorundeadleader
#armor "Crown"
#flying
#neednoteat
#shockres 100
#fireres 100
#amphibian
#trample
#size 4
#ethereal
#maxage 2000
#end




--------------------------------------------------------------------------------
#newmonster 2328
#name "Fallen Archangel"
#descr "The Fallen Archangel was an angelic being that revolted aginst the divine order and was imprisoned in Inferno.  Released from its prison by blood magic, it has seen its chance to become the new One True God.  The Fallen Angel is a powerful user of Fire, Death and Blood magic."
#spr1 "./mytheology/fallen.tga"
#spr2 "./mytheology/fallen2.tga"

#restrictedgod 32 - MA Marignon
#gcost 250
#startdom 3
#pathcost 60

#mor 30
#size 4
#magicskill 0 2
#magicskill 7 2
#magicskill 4 2
#hp 47
#prot 7
#mr 18
#enc 1
#str 14
#att 17
#def 16
#prec 15
#mapmove 3
#ap 16
#immortal
#fear 3
#fireres 100
#weapon "Wraith Sword"
#magicbeing
#neednoteat
#demon
#flying
#goodleader
#goodmagicleader
#goodundeadleader
#end


################################################################################
##   Custom Spells 
################################################################################

--------------------------------------------------------------------------------
#newspell
#name "Diabolic Brigade"
#descr "The caster sacrifices many blood slaves, and receives the service of a brigade of lesser demons. These imps, while being the lowest caste in hell, can claw through normal men with ease."
#school 6
#researchlevel 5
#path 0 7
#pathlevel 0 3
#effect 10001
#nreff 30
#fatiguecost 2000
#damage 303
#end 


--------------------------------------------------------------------------------
#newspell
#name "Feeding Frenzy"
#descr "The caster summons a school of small but voracious fish to harass an enemy target."
#school 1
#researchlevel 4
#path 0 2
#pathlevel 0 1
#effect 1
#nreff 1008
#spec 41943040
#damage 2320
#flightspr -1
#end 


--------------------------------------------------------------------------------
#newspell
#name "Summon Man O' War"
#descr "The caster summons a giant, poisonous jellyfish to the battlefield.  The jellyfish is slow and mindless, but can deliver paralyzing and poisonous attacks."
#school 1
#researchlevel 2
#path 0 2
#pathlevel 0 1
#effect 1
#nreff 1
#fatiguecost 10
#damage 2319
#spec 41943040
#flightspr 10005
#end 

---------------------------------------------------------------------------------
--These spells are made to reflect the new Krakens that have been created. The normal Kraken are now called Giant Octopus. (Octopi, plural).
#selectspell 436
#name "Summon Giant Octopus"
#descr "Summons a huge octopoid beast to serve its caller.  The beast is aquatic and cannot leave the sea."
#researchlevel 3
#end 

#newspell
#copyspell 436
#name "Call Kraken"
#descr "From the cold black depths of the sea the caster calls one of the legendary Kraken.  This gargantuan being spells doom for any who stand against it. The tentacles of one of these legendary creatures can sink ships, and crush men to a fleshy pulp."
#school 0
#researchlevel 4
#nreff 1
#path 0 6
#pathlevel 0 4
#fatiguecost 400
#damage 2288
#end

#newspell
#copyspell 436
#name "Call multiple Kraken"
#descr "This space was intentionally left blank."
#school -1
#researchlevel 0
#nreff 4
#path 0 6
#pathlevel 0 1
#fatiguecost 0
#damage 2288
#end

#newspell
#copyspell 436
#name "Call Kraken King"
#descr "Using vast amounts of magical power,  the caster contacts one of the secret kings of the deep, a Kraken King.  From the cold black depths of the sea the king comes swimming up, bringing with it a small retinue."
#school 0
#researchlevel 6
#nreff 1
#path 0 6
#pathlevel 0 5
#fatiguecost 2500
#effect 10021
#nextspell "Call multiple Kraken"
#damage 2289
#end

--------------------------------------------------------------------------------
#newspell
#copyspell 659
#name "Shards of Hastur"
#descr "The caster unleashes the raw forces of the infinite beyond upon enemy units across the battlefield.  Unprepared minds are temporarily blasted from their bodies, leaving their bodies unable to attack, defend, or even move until the mind can find its way back to its mortal shell.  The number of targets affected increases with the strength of the caster."
#school 5
#researchlevel 6
#path 0 4
#pathlevel 0 5
#aoe 663
#effect 66
#range 100
#precision 100
#fatiguecost 200
#explspr 10206
#damage 2000
#flightspr -1
#spec 8671360
#end 


--------------------------------------------------------------------------------
#newspell
#name "Bind Toad Demon"
#descr "The caster sacrifices several slaves and binds a monstrous toad demon to the service of their Pretender.  The toad demon is amphibious, a versatile mage of blood, water, and earth magics and a resilient fighter."
#school 6
#researchlevel 5
#path 0 7
#pathlevel 0 4
#path 1 2
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 8800
#damage 2305
#end 


--------------------------------------------------------------------------------
-- This makes the normal "Manifestation" spell a little cheaper and easier to
-- research.  I mean really, Research level 8 Thaumaturgy / Death 5 to cast a 
-- single assassin against an opponent, with risk of backfire?  Rescoping this 
-- spell also helps "ashkent" to be attainable too.
#selectspell 512
#researchlevel 6
#pathlevel 0 4
#end 


------------------------------------------------------------------------------
#newspell  -- All hail Terry Pratchett
#copyspell 512
#name "The Rite of AshkEnte"
#descr "Through this dark and forbidden ritual, the caster summons Azrael, the Grim Reaper, and sends him to prematurely claim the life of an enemy commander in a distant province. This ritual should only be undertaken with great care and precaution, as the Angel of Death will claim the caster's life if no suitable target can be found."
#damage 2992
#researchlevel 8
#pathlevel 0 5
#fatiguecost 3500
#spec 8388608
#end 


------------------------------------------------------------------------------
#newspell
#copyspell 521
#name "Soul Harvest"
#descr "Four manifestations of Azrael, the Grim Reaper, attempt to collect all enemy souls in a distant province."
#damage 2992
#nreff 4
#school 0
#researchlevel 9
#path 0 5
#pathlevel 0 6
#fatiguecost 8800
#end 



--------------------------------------------------------------------------------
-- Warning!  This spell is takes advantage of hardcoded actions in the "Dome of
-- Flaming Death" ritual.  The messages the attacker receives will be 
-- "Commander was hit by a powerful fire blast shortly after casting the spell
-- but Commander survived."  
-- It would have been my preference to make the damage do disease afflictions,
-- but this ritual is too hardcoded to allow that apparently.
#newspell
#copyspell 603
#name "Banefire Veil"
#descr "A magical veil is placed over the caster's provice. Enemy spells that attack the protected province will rend the veil and expose the attacker to fiery energies from the realm of Death. While the veil will not stop incoming spells, it may remove the attacker as a threat through injury or death. The Veil fades if the caster dies."
#path 0 5
#spec 8388608
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 534
#name "Soulblades"
#descr "The souls of a group of friendly soldiers infuse their weapons, causing them to shine with a visible aura.  These charged weapons are capable of hitting ethereal creatures and cutting through any armor."
#school 1
#path 0 4
#pathlevel 0 4
#path 1 8
#pathlevel 1 1
#damage 1048576
#fatiguecost 100
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 534
#name "Aurora Warriors"
#descr "A group of friendly soldiers become ethereal and impervious to normal attacks."
#school 1
#researchlevel 7
#aoe 666
#path 0 4
#pathlevel 0 5
#damage 134217728
#fatiguecost 400
#explspr 10002
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 677
#name "Eclipse"
#descr "The caster temporarily traps all the sunlight in an enemy province, shrouding it in darkness.  When the sunlight is released, the piercing, brilliant rays can permanently blind up to half the soldiers in that province. (Note: Messages will indicate a 'cloud of disease' instead of the 'blind' affliction.)"
#path 0 0
#path 1 5
#pathlevel 0 5
#pathlevel 1 1
#damage 4096
#nreff 2
#fatigue 3600
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 677
#name "Storm of Acid"
#descr "The caster summons a tremendous alchemical storm in an enemy province that rots metal and armor. (Note: Messages will indicate a 'cloud of disease' instead of the 'Rusty Armor' attribute.)"
#path 0 2
#path 1 0
#pathlevel 0 4
#pathlevel 1 1
#damage 2048
#nreff 4
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 677
#name "Foreboding"
#descr "The caster calls upon dark magics to reveal omens and visions of horrible, looming death for each and every soldier in an enemy province.  Many affected soldiers will lose their courage permenantly, fearing their next battle will be their last. (Note: Messages will indicate a 'cloud of disease' instead of the 'battle fright' affliction.)"
#path 0 1
#path 1 7
#pathlevel 0 4
#pathlevel 1 1
#damage 2097152
#nreff 4
#fatiguecost 800
#end

--------------------------------------------------------------------------------
-- So, I was watching "the Mummy Returns" with my wife the other night, and
-- was thought "Imhotep has a really useful combat spell with all those nasty
-- scarab beetles.."
-- Gametesting had this work out OK - it kills most independent prov armies 
-- without mages, but I have concerns that a super nature mage may turn out
-- too many beetles.
#newspell
#name "Sea of Scarabs"
#descr "The caster summons hundreds of giant armored beetles to swarm against the enemy.  While slow and easily killed, these insects can overwhelm unprepared armies through their sheer numbers."
#school 0
#researchlevel 7
#path 0 6
#pathlevel 0 4
#path 1 3
#pathlevel 1 1
#effect 1
#fatiguecost 100
#nreff 4084
#damage 2301
#explspr 10141
#flightspr -1
#end 

#newspell
#name "Swarm of Crabs"
#descr "The caster summons hundreds of giant armored crabs to swarm against the enemy.  While slow and easily killed, these arthropods can overwhelm unprepared armies through their sheer numbers."
#school 0
#researchlevel 7
#path 0 6
#pathlevel 0 4
#path 1 2
#pathlevel 1 1
#effect 1
#fatiguecost 100
#nreff 4084
#damage 2318
#explspr 10141
#spec 41943040
#flightspr -1
#end 

--------------------------------------------------------------------------------
#newspell
#name "Menhir of Fortune"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring fortune the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 4
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 2000
#damage 2293
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Peace"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring peace to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 2
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 2294
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Faith"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to spread faith and belief from the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 8
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 2295
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Growth"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring fertility and growth to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 6
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 3000
#damage 2291
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Courage"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring courage and bravery to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 7
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 2292
#end  


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Death"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to summon shades in defense of the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 5
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1000
#damage 2351
#end 


--------------------------------------------------------------------------------
#newspell
#name "Call Wraith King"
#descr "The caster summons a Nazgul, a dread Wraith King."
#school 0
#researchlevel 8
#path 0 5
#pathlevel 0 5
#path 1 1
#pathlevel 1 2
#fatiguecost 6600
#effect 10021
#nreff 1
#damage 2335
#end 


--------------------------------------------------------------------------------
#newspell
#copyspell 343
#name "Loki's Mirrors"
#descr "The caster blesses the entire army with a deceptive glamour from the trickster god of and deceptions, which creates illusionary images around all friendly troops. The more powerful the caster, the more images will appear.  The images will surround each unit and make it harder for enemies to figure out which one to strike.  The spell ends as soon as the unit is wounded."
#school 1
#researchlevel 9
#aoe 666
#pathlevel 0 5
#path 1 4
#pathlevel 1 1
#fatiguecost 500
--damage 16777216
--spec 4194304
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 665
#name "Aria Discordia"
#descr "The caster sings the forbidden words of Eris, the goddess of entropy, to sow chaos and confusion amongst all enemies.  Those affected by the aria often attack their own comrades, mistaking them for enemies."
#researchlevel 9
#aoe 666
#pathlevel 0 6
#spec 262144
#fatiguecost 400
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 652
#name "Dirge of the Drowned Gods"
#descr "As the caster sings the terrible funeral song of the Drowned Gods, unprotected enemies across the battlefield will be compelled to raise their own voices in sympathy, their own throats filling with water.  Weak targets may be killed outright, but any enemy that cannot breathe water will take severe damage.  The stronger the caster, the greater number of targets are affected."
#researchlevel 8
#aoe 666
#pathlevel 0 5
#fatiguecost 200
#spec 545853568
#end

--------------------------------------------------------------------------------
#newspell
#name "Elder Sign"
#descr "The caster invests an Elder Sign, an eldritch thing of power and protection against things from beyond."
#school 5
#researchlevel 7
#path 0 4
#pathlevel 0 5
#effect 10001
#nreff 1
#fatiguecost 1500
#damage 2340
#end 

--------------------------------------------------------------------------------
#newspell
#name "Destiny2"
#descr " "
#school 1
#researchlevel 10
#path 0 4
#pathlevel 0 1
#precision 100
#effect 599
#nreff 1
#range 60
#aoe 1
#damage 199
#spec 12582912
#fatiguecost 10
#end

#newspell
#name "Destiny"
#descr " "
#school 1
#researchlevel 10
#path 0 4
#pathlevel 0 1
#precision 100
#effect 599
#nreff 1
#range 60
#aoe 1
#damage 200
#spec 12582912
#fatiguecost 10
#nextspell "Destiny2"
#flightspr 10219
#explspr 10219
#end

#newspell
#name "Hand of Destiny"
#descr "A small group of friendly soldiers is invested with legendary toughness, courage, strength and resistances.  At the right time and place, a single soldier can turn the tide of an entire battle."
#school 1
#researchlevel 8
#path 0 4
#pathlevel 0 5
#precision 100
#effect 10
#nreff 1
#range 60
#aoe 1
#damage 353148343
#spec 12582912
#fatiguecost 100
#flightspr 10041
#explspr 10219
#sound 31
#nextspell "Destiny"
#end



------------------------------------------------------------------------------
#newspell
#copyspell "Send Bukavac"
#name "Krakensong"
#descr "By sending deep, throbbing vibrations through the sea, a powerful water mage can summon and control a mighty kraken of the deep, causing it to attack a commander in a faraway undersea province."
#school 0
#damage 438 -- kraken
#researchlevel 6
#path 0 2
#pathlevel 0 4
#effect 10050
#nreff 1
#spec 310378496
#fatiguecost 200 --400
#end 


------------------------------------------------------------------------------
#newspell
#name "Siege Catapult"
#descr "The crafter constructs a mighty catapult.  The catapult can launch giant stones at enemy ranks and fortress walls, but is very ponderous and slow to move."
#school 3
#damage 2342 -- Siege Catapult
#researchlevel 3
#path 0 3
#pathlevel 0 3
#effect 10001
#nreff 1
#fatiguecost 500 
#end 


------------------------------------------------------------------------------
#newspell
#name "Siege Trebuchet"
#descr "The crafter constructs a mighty trebuchet.  The trebuchet can launch giant stones at enemy ranks and fortress walls, but is very ponderous and slow to move."
#school 3
#damage 2344 -- Siege trebuchet
#researchlevel 5
#path 0 3
#pathlevel 0 5
#effect 10001
#nreff 1
#fatiguecost 1000 
#end 


################################################################################
##   Custom Names for Indys and Misc 
################################################################################
#selectnametype 100
-- 100 misc male
#addname "Osbane the Adequate"
#addname "Golinar"
#addname "Zomayne the Unfriendly"
#addname "Grabbatis Underfeller"
#addname "Shunan"
#addname "Remaker"
#addname "Greeban Corpseflinger"
#addname "Shumash"
#addname "Leppo the Underwhelming"
#addname "Kombasto"
#addname "Uro Brasshands"
#addname "Uphaston"
#addname "Redondo"
#addname "Uter the Unpleasant"
#addname "Itchy Pete"
#addname "Ogomir"
#addname "Pygoromayne"
#addname "Zinnestal"
#addname "Bezzandyl"
#addname "Rellegar"
#addname "Jorn Deerfalcon"
#addname "Fnerk"
#addname "Dunderblug"
#addname "Grimmer"
#addname "Meldok the Unfortunate"
#addname "Yagor"
#addname "Darkrender"
#addname "Neenark the Somewhat Unbalanced"
#addname "Sundarun"
#addname "Zazu the Magnificent"
#addname "Cheesewart"
#addname "Rolend Oddsmell"
#addname "Eidelorn"
#addname "Akjak the Maniac"
#addname "Sofarr Kneebiter"
#addname "Unlucky Comar"
#addname "Oolburt"
#addname "Kardessas"
#addname "Soros the Suspicious"
#addname "Malek Swordbender"
#addname "Mighty Martok"
#addname "Gorlem"
#addname "Meegak"
#addname "Torgorash"
#addname "Nork the Pesky"
#addname "Gorobon"
#addname "Rendyr Blackmask"
#addname "Deleticus"
#addname "Arvish"
#addname "Tygon Sixspell"
#addname "Effron"
#addname "Yltos"
#addname "Rorkor"
#addname "Voffel"
#addname "Voffel"
#addname "Stinchpizzle"
#addname "Moygleffer"
#addname "Nodgrobber"
#addname "Lulldor"
#addname "Uudberg"
#addname "Cudruncher"
#addname "Mandarg"
#addname "Horoggo the Enlarged"
#addname "Uldabar"
#addname "Lupho"
#addname "Haypelkar"
#addname "Oyvar"
#addname "Mohomo"
#addname "Tuweir"
#addname "Rabinoss"
#addname "Eldomar"
#addname "Kreemash"
#addname "Peshonto"
#addname "Korgor Hellhand"
#addname "Xaren Utek"
#addname "Oren Talero"
#addname "Gomorr"
#addname "Corobon"
#addname "Plooksanji"
#addname "Wilden the Well-Endowed"
#addname "Reethos Bondbreaker"
#addname "Dannis"
#addname "Sateven"
#addname "Arric"
#addname "Barrus"
#addname "Jamis"
#addname "Anderro"
#addname "Marek"
#addname "Keiss the Nightwarden"
#addname "Jennas"
#addname "Robier"
#addname "Jonnas"
#addname "Rikkar"
#addname "Corman"
#addname "Kennet"
#addname "Danal"
#addname "Albren"
#addname "Jimmen"
#addname "Jacick"
#addname "Frannick"
#addname "Lawrent"
#addname "Jurge"
#addname "Sammal"
#addname "Krevin"
#addname "Jorn"
#addname "Aurochson"
#addname "Sando Thunderclub"
#addname "Uden Orkhammer"
#addname "Eldomar"
#addname "Plemish"
#addname "Klardesto"
#addname "Tordor Goblinstomper"
#addname "Lorgon"
#addname "Udwudlan"
#addname "Morto of Tundelor"
#addname "Rollawazzer"
#addname "Foothlimner"
#addname "Gaspoot"
#addname "Coswain Blensmarg"
#addname "Yulno Eelkeeper"
#addname "Blanderfask"
#addname "Arnast the Flenser"
#addname "Stegnor"
#addname "Rotog the Stubborn"
#addname "Larzo Lanzanda"
#addname "Malphus"
#addname "Moomgool"
#addname "Meewarl"
#addname "Rexar Blueblade"
#addname "Kungunder"
#addname "Beckander the Rash"
#addname "Pondor the Ultimator"
#addname "Ickvile"
#addname "Targon Meatshield"
#addname "Arkontratos"
#addname "Mogan the Afflicted"
#addname "the Geeper"
#addname "Macrailus"
#addname "Raffer Tendragons"
#addname "Noobler"
#addname "Foffler the Flammable"
#addname "Bandlagore"
#addname "Bleemer"
#addname "Blestinder"
#addname "Arexandro"
#addname "Glart"
#addname "Gorbo Lootfinder"
#addname "Smandel the Whiner"
#addname "Drock the Unwashed"
#addname "Osmir the Unpopular"
#addname "Elmar Slackbladder"
#addname "Nobody"
#addname "The new guy"
#addname "Grond the Unsanitary"
#addname "Blarg the Unwell"
#addname "Farfesto"
#addname "The mighty Skla"
#addname "Jaspalasper"
#addname "Sneakyfeets"
#addname "Sneet the Worthless"
#addname "Tinmonger"
#addname "Raymor"
#addname "Jayfer"
#addname "Aren"
#addname "Niwar Shadebaiter"
#addname "Splod the Lonely"
#addname "Eldo Swordmocker"
#addname "Silden"
#addname "Kronen"
#addname "Hoyett Arrowfodder"
#addname "Tondar"
#addname "Shender"
#addname "Grunknar"
#addname "Vutu Talenra"
#addname "Zartrax"
#addname "Arxon"
#addname "Gasprod"
#addname "Ravener"
#addname "Jollack"
#addname "Jessores"
#addname "Pharpus"
#addname "Donning"
#addname "Tebo"
#addname "Brunan"
#addname "Bardinas"
#addname "Valares"
#addname "Harkendon"
#addname "Mender"
#addname "Firbire"
#addname "Skon"
#addname "Fulgar"
#addname "Spinnity"
#addname "Niver"
#addname "Lanvero"
#addname "Janger"
#addname "Valock"
#addname "Grekkin"
#addname "Temozgo"
#addname "Droder"
#addname "Danrod"
#addname "Jomur"
#addname "Skelbrek the Inscrutable"
#addname "Raymer the Unscriptable"
#addname "Zigbat Bartleskart"
#addname "Squindrit"
#addname "Blaspon Spugetto"
#addname "Troffmeiter"
#addname "Leddyarg"
#addname "Undar Runspukken"
#addname "Grellbain"
#addname "Ranzuul"
#addname "Seshizal"
#addname "Kennikalder"
#addname "Phelestro"
#addname "Telmott Berserkermage"
#addname "Gnatsmasher"
#addname "Pengar Spiderbiter"
#addname "Leroy Jenkins"
#addname "Tunstuffle"
#addname "Zannch"
#addname "Jagner"
#addname "Count Lyonerge"
#addname "Chak"
#addname "Baielor the Bastard"
#addname "Fishmizzen"
#addname "Whisperer"
#addname "Soulbreaker"
#addname "Breacher"
#addname "Orlendor"
#addname "Spellbinder"
#addname "Mazebreaker"
#addname "Shamer"
#addname "Corruptor"
#addname "Hellgore"
#addname "Stormwarden"
#addname "Redolant"
#addname "Iceblood"
#addname "the Thriceborn Prince"
#addname "Shadowfly"
#addname "Sangoz Smarmidon"
#addname "Seerstalker"
#addname "Oathbender"
#addname "Blacksoul"
#addname "Raider"
#addname "Jarret Halfsoul"
#addname "Choker"
#addname "Twitcher"
#addname "Malcon"
#addname "Klushmaal"
#addname "Slinder"
#addname "The Opener"
#addname "The Broken Man"
#addname "Craver"
#addname "Flayer"
#addname "Finnan the Heartless"
#addname "The Scrivener"
#addname "Sungazer"
#addname "Bleakstinger"
#addname "Drakeslaver"
#addname "Bulldagger"
#addname "Slicer"
#addname "Captor"
#addname "Spyfinder"
#addname "Drinky"
#addname "Greedneedle"
#addname "Smokewrangler"
#addname "Jaxel Spellbait"
#addname "Reblar Routesquick"
#addname "Gligjimbler"
#addname "Warinder"
#addname "Krident"
#addname "Illslinger"
#addname "Arlax Demonsniffer"
#addname "Blackwrender"
#addname "Astendor"
#addname "Vilegrinder"
#addname "Gyero Sintwister"
#addname "Rozo Mudlugger"
#addname "Banned User"
#end


#selectnametype 119
-- 119 misc female
#addname "Spamela"
#addname "Reesha Manmangler"
#addname "Olla Axegrinder"
#addname "Lyrandella"
#addname "Faeraven"
#addname "Natessa"
#addname "The Windwidow"
#addname "Spiral"
#addname "Glasmila"
#addname "The Fallstorm Maiden"
#addname "Faribel"
#addname "Faithless"
#addname "Zarza"
#addname "Tangler"
#addname "Brackenwench"
#addname "The Spiritkeeper"
#addname "Vinissa Prophetslayer"
#addname "The Mistmaiden"
#addname "Rhayne the Lovely"
#addname "the Ashen Crone"
#addname "Firefallen"
#addname "Whitefire"
#addname "Patriska"
#addname "Eyeblinder"
#addname "JInnifer"
#addname "Yrstine"
#addname "Eldyramaine"
#addname "Tamyr Fellsong"
#addname "Pellandra"
#addname "Tulia"
#addname "The Grey Lady"
#addname "Hulla"
#addname "Maraylla"
#addname "Jaestra the Unforgiving"
#addname "Elliana"
#addname "Karanga"
#addname "Tisserene"
#addname "Shurussa"
#addname "Dayena Whiteshadow"
#addname "Rena Banedagger"
#addname "Belledera"
#addname "Issassa"
#addname "Lascivia"
#addname "Nara Quickfire"
#addname "Mohra"
#addname "The Dreamreaper"
#addname "Lelledoralai"
#addname "Munda Redmace"
#addname "Panzora"
#addname "Kemma"
#addname "Stabby"
#addname "Fern"
#addname "Beska"
#addname "Obsidia"
#addname "Cerulea"
#addname "Tunnerunda"
#addname "Tuuma the Willing"
#addname "Meisha"
#addname "Ulma Weirwalker"
#addname "Lullador"
#addname "Bema the Wiley"
#addname "Briarfox"
#addname "Leega"
#addname "Enmaelle"
#addname "Patriska"
#addname "Xaven the Untamed"
#addname "Tinabula"
#addname "Thelespe"
#addname "Nyrryn"
#addname "Emprima"
#addname "Zeltima"
#addname "Quinxxe"
#addname "Pella the Unsober"
#addname "Caranda Blackhammer"
#addname "Undurunga"
#addname "Tulna Springhawks"
#addname "Meena the Unwary"
#addname "Demini"
#addname "Alensa Hexbinder"
#addname "Durma Shadowcandle"
#addname "Emsha Trollsmacker"
#addname "Morna"
#addname "Nacine"
#addname "Memsha"
#addname "Selara Edgebender"
#addname "Chorissa"
#addname "Darni"
#addname "Annisty"
#addname "Melisse"
#addname "Natalle"
#addname "Jewelly"
#addname "Chelsa Redberry"
#addname "Jasra Suncutter"
#addname "Karena the Cruel"
#addname "Jetta"
#addname "Tatella"
#addname "Vultenna"
#addname "Ishpenda"
#addname "Zinga"
#addname "Abelsa"
#addname "Falesse"
#addname "Mordette"
#addname "Xarendella"
#addname "Katreti"
#addname "Sheuli the Sly"
#addname "Shaneste"
#addname "Liganthe"
#addname "Valares Stormfire"
#addname "Malibel"
#addname "Starfinder"
#addname "Mintre"
#addname "Mimmidi"
#addname "The Lady of the Red Rings"
#addname "Pentra"
#addname "Druuza"
#addname "Selmine"
#addname "Testra"
#addname "Jennimere"
#addname "Duruuna"
#addname "Draea"
#addname "Orella the Impatient"
#addname "Rubineska"
#addname "Callipygia"
#addname "Tawdria"
#addname "Osculatrix"
#addname "Luscious"
#addname "Oroa Sunderfire"
#addname "Xazra Gorefrost"
#addname "Tana Darkshard"
#end
--------------------------------------------------------------------------------
#end



################################################################################
##   To Do List
################################################################################

-- future spell experiments - casting permabuffs on friendly provinces, just
-- the way leprosy and the above spells cast permanent mallus on enemy provs

-- scatter - #effect 20 spell that sends your units all over the field.  Probably useful for some strategy, like Howl only with your buffed troops.
-- 
-- ,maybe something that uses the "sorcery" or "elemental" paths as path
-- requirements just to be interesting

-- A SAFE version of the vengeance spell that can be cast on several units (explode on death)... I made one that was on all friendlies, but it was a chain reaction disaster!

-- Future pretender Ideas?
-- Merchant god... low on powers but increased growth/ $ and spread dominion?

-- someday when custom magic items are implemented...
	-- a conjuration, thaum, enchantment version of Dwarven hammer
	-- maybe a fire version of Dwarven hammer, less powerful - True Fire?
	-- another earth magic booster?
