/*
 * Decompiled with CFR 0.152.
 */
package org.larz.dom3.dm.converter;

import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class DmValueConverter
extends DefaultTerminalConverters {
    public IValueConverter<String> STRING() {
        return new STRINGValueConverter(){

            protected String toEscapedString(String value) {
                return String.valueOf('\"') + value.toString().replaceAll("\r\n", "\n") + '\"';
            }

            public String toValue(String string, INode node) {
                if (string == null) {
                    return null;
                }
                try {
                    return string.substring(1, string.length() - 1);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }
        };
    }

    public IValueConverter<Integer> INT() {
        return new AbstractValueConverter<Integer>(){

            public String toString(Integer value) {
                if (value == null) {
                    throw new ValueConverterException("INT-value may not be null. (null indeed, zero is ok)", null, null);
                }
                return value.toString();
            }

            public Integer toValue(String string, INode node) throws ValueConverterException {
                if (Strings.isEmpty((String)string)) {
                    throw new ValueConverterException("Couldn't convert empty string to int.", node, null);
                }
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException e) {
                    throw new ValueConverterException("Couldn't convert '" + string + "' to int.", node, (Exception)e);
                }
            }
        };
    }
}

