/* LICENSED UNDER THE TERMS OF THE LGPL
 * http://www.gnu.org/copyleft/lesser.html
 */

/*
 * Field.java
 * A field in a Malfador data file, consisting of a key followed by ":="
 * followed by a value. Also serves as a class used for defining functions.
 * Created on February 19, 2005, 4:26 PM
 */

package templatizer;

/**
 *
 * @author koliset
 */
public class Field {
	
	private String key;
	private String value;
	
	/** Creates a new instance of Field */
	public Field(String line) throws Exception {
		if (line == "" || line == null || !line.contains(":="))
			throw new Exception("\"" + line +  "\" is not a valid field; it does not contain the string \":=\"");
		int separatorPos = line.indexOf(":=");
		this.setKey(line.substring(0, separatorPos - 1).trim());
		this.setValue(line.substring(separatorPos + 2, line.length()).trim());
	}
	
	/** Creates a new instance of Field */
	public Field(String key, String value){
		this.setKey(key);
		this.setValue(value);
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	
	public String toString() {
		return key + " := " + value;
	}	
}
