//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Transfer.h"
#include "WW2Map1.h"
#include "ReadShp.h"
#include "Index.h"
#include <stdio.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TTransferForm *TransferForm;

int total_transfer_icons;
struct ICON transfer_icons[MAX_TILES];


//---------------------------------------------------------------------------
__fastcall TTransferForm::TTransferForm(TComponent* Owner)
        : TForm(Owner)
{
}
//----------------------------------------------------------------
void __fastcall TTransferForm::ClearImage(Graphics :: TBitmap *bmp)
{
  TRect rect;

  rect.Top=0; rect.Left=0;
  rect.Bottom=bmp->Height;
  rect.Right=bmp->Width;
  bmp->Canvas->Brush->Color=BK_COLOR;
  bmp->Canvas->FillRect(rect);
}
//---------------------------------------------------------------------------
void __fastcall TTransferForm::LoadBtnClick(TObject *Sender)
{
  Graphics :: TBitmap *tiles_bmp;
  char fname[32],msg[128],fullname[150];
  FILE *inf;
  int i;

  Screen->Cursor=crHourGlass;

  tiles_bmp= new Graphics :: TBitmap;
  tiles_bmp->Height=100;
  strcpy(fullname,tilespath);
  sprintf(fname,"Ter%02dz4.shp",FileNumberUD->Position);
  strcat(fullname,fname);
  inf=fopen(fullname,"rb");
  if (!inf)
  {
    sprintf(msg,"Could not open %s.",fname);
    Application->MessageBox(msg,"File Error",MB_OK);
    return;
  }
  fread(&total_transfer_icons,4,1,inf); //id
  fread(&total_transfer_icons,4,1,inf); //icons
  fclose(inf);
  //delete the old icons
  for (i=0; i<MAX_TILES; ++i)
  {
   delete transfer_icons[i].tbmp;
   transfer_icons[i].tbmp=NULL;
  }

  //read in the tiles
  for (i=0; i<total_transfer_icons; ++i)
  {
     int error;
     transfer_function=true;
     error=LoadShp->LoadTile(i,fullname,&transfer_icons[i]);
     transfer_function=false;
     if (error) continue;
     if (i==0) transfer_startx[i]=3;
     else transfer_startx[i]=transfer_startx[i-1]
                              +transfer_icons[i-1].tbmp->Width + 3;
  }

  tiles_bmp->Width=transfer_startx[total_transfer_icons-1]+
     transfer_icons[total_transfer_icons-1].tbmp->Width+3;
  //--------------------------------------------------------
  ClearImage(tiles_bmp);

  //display the tiles
  for (i=0; i<total_transfer_icons; ++i)
  {
   tiles_bmp->Canvas->Draw(transfer_startx[i],3,transfer_icons[i].tbmp);
  }
  TransferImg->Width=tiles_bmp->Width;
  TransferImg->Height=tiles_bmp->Height;
  TransferImg->Picture->Bitmap=tiles_bmp;
  Screen->Cursor=crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TTransferForm:: Unmark(int n)
{
  int x,y;

  y=TransferImg->Picture->Bitmap->Width;
  x=transfer_startx[n]-1;
  TransferImg->Picture->Bitmap->Canvas->Pen->Color=BK_COLOR;
  TransferImg->Picture->Bitmap->Canvas->MoveTo(x,0);
  TransferImg->Picture->Bitmap->Canvas->LineTo(x,y);
  x=transfer_startx[n]+transfer_icons[n].tbmp->Width+1;
  TransferImg->Picture->Bitmap->Canvas->MoveTo(x,0);
  TransferImg->Picture->Bitmap->Canvas->LineTo(x,y);
}

void __fastcall TTransferForm:: Mark(int n)
{
  int x,y;

  y=TransferImg->Picture->Bitmap->Width;
  x=transfer_startx[n]-1;
  TransferImg->Picture->Bitmap->Canvas->Pen->Color=clBlack;
  TransferImg->Picture->Bitmap->Canvas->MoveTo(x,0);
  TransferImg->Picture->Bitmap->Canvas->LineTo(x,y);

  x=transfer_startx[n]+transfer_icons[n].tbmp->Width+1;
  TransferImg->Picture->Bitmap->Canvas->MoveTo(x,0);
  TransferImg->Picture->Bitmap->Canvas->LineTo(x,y);
}

//-------------------------------------------------------------
void __fastcall TTransferForm::TransferImgMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   Unmark(transfer_inum);
   transfer_inum=0;
   while (transfer_startx[transfer_inum]<X
          && transfer_inum<total_transfer_icons)
     ++transfer_inum;
  --transfer_inum;
  Mark(transfer_inum);
}
//---------------------------------------------------------------------------

void __fastcall TTransferForm::TransferImgClick(TObject *Sender)
{
   IconNumberLbl->Caption="#"+IntToStr(transfer_inum)+"   ";
}
//---------------------------------------------------------------------------



void __fastcall TTransferForm::IndexBtnClick(TObject *Sender)
{
   IndexForm->Show();
}
//---------------------------------------------------------------------------

void __fastcall TTransferForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
   if (MainForm->TileTransfer1->Checked)
     MainForm->TileTransfer1->Checked=false; 
}
//---------------------------------------------------------------------------

