//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include <stdlib.h>
//#include <clipbrd.hpp>

#include "Import.h"
#include "WW2Map1.h"
#include "HexEdit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#define WATER 40
#define LVL0 100
#define LVL1 140
#define LVL2 180
#define LVL3 220

  //water and 0 thru 16 alt
#define Water  0xFF0000
#define huea0  0x000080
#define huea1  0x0000A0
#define huea2  0x0000C0
#define huea3  0x0000FF
#define huea4  0x006060
#define huea5  0x008080
#define huea6  0x00A080
#define huea7  0x00C080
#define huea8  0x00FF80

#define huea9  0x806060
#define huea10 0x808080
#define huea11 0x8080A0
#define huea12 0x8080C0
#define huea13 0x8080FF
#define huea14 0x80A080
#define huea15 0x80c080
#define huea16 0x80FF80

/*
Water Hexes: 0 0 255
Level 0 Hexes 100 100 100
Level 1 Hexes 109 109 109
Level 2 Hexes 118 118 118
Level 3 Hexes 127 127 127
Level 4 Hexes 136 136 136
Level 5 Hexes 145 145 145
Level 6 Hexes 154 154 154
Level 7 Hexes 163 163 163
Level 8 Hexes 172 172 172
Level 9 Hexes 181 181 181
Level 10 Hexes 190 190 190
Level 11 Hexes 199 199 199
Level 12 Hexes 208 208 208
Level 13 Hexes 217 217 217
Level 14 Hexes 226 226 226
Level 15 Hexes 235 235 235
Level 16 Hexes 244 244 244
 */

TImportForm *ImportForm;

int ImgOgX,ImgOgY; //coordinates of top left pixel of image
//---------------------------------------------------------------------------
__fastcall TImportForm::TImportForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TImportForm::LoadBtnClick(TObject *Sender)
{
  // Graphics :: TBitmap *Bitmap;

   if (!OpenPictureDialog1->Execute()) return;
   BmpImg->Picture->LoadFromFile(OpenPictureDialog1->FileName);

   /*  this will make jpg work but the result is not
       so good because color is not preserved in compression
   Clipboard()->Assign(BmpImg->Picture);
   BmpImg->Picture->Bitmap->Assign(Clipboard());
   Canvas->Draw(0,0,Bitmap);
   */
   ImgSizeLbl->Caption=IntToStr(BmpImg->Width)+","+IntToStr(BmpImg->Height)+
              " Bitmap    ";

   ImgOgX=0; ImgOgY=0;
   OriginLbl->Caption=IntToStr(ImgOgX)+","+IntToStr(ImgOgY)+"    ";




}
//--------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TImportForm::AltBtnClick(TObject *Sender)
{
  int x,y,avg;
  int xscale,yscale;
  int clr,r,g,b,alt;
  int addr,code;
  int file,icon,gr;
  int neighbor_alt,gnum;

  xscale=XScaleUD->Position;
  yscale=YScaleUD->Position;

  //int hx=MapSizeX;
  //int hy=MapSizeY;
  file=StrToInt(FirstEdit->Text);
  for(y=0; y<MapSizeY; ++y)  //MapSizeY
    for (x=0; x<MapSizeX; ++x)
    {
      //need to get the average of all the pix in the block!!!!!!!!!!
      clr=BmpImg->Picture->Bitmap->Canvas->
         Pixels[ImgOgX+xscale*x+xscale/2][ImgOgY+yscale*y+yscale/2];
      r=clr&255;
      g=(clr>>8)&255;
      b=(clr>>16)&255;
      avg=(r+g+b)/3;

      if (avg>= LVL3) alt=30;
      else if (avg>=LVL2) alt=20;
      else if (avg>=LVL1) alt=10;
      else if (avg>=LVL0) alt=0;
      else
      {
        if (b>0) alt=-3;
        else if (g>0) alt=-1;
      }
      //altitude=4 for altitude for WAW
      addr=MainForm->S8Addr(x,y);
      //mb[moff[8]+addr+4]=(byte)alt;
      mb[moff[8]+addr]=(byte)alt;
      if (alt<0)
      {
        mb[moff[8]+addr+1]=255;
        if (alt==-3)//lake ...
        {
          mb[moff[29]+MainForm->S29Addr(x,y)]=40;
          gnum=250*22+31+(x+y)%5;
          set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
          //mb[MainForm->S2Addr(x,y)+moff[2]+1]=(byte)(gnum/256);
        }
        else if (alt==-1) //swamp
        {
          mb[moff[29]+MainForm->S29Addr(x,y)]=10;
          gnum=250*5+31+(x+y)%5;
          set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
          addr=MainForm->S8Addr(x,y);
          //mb[moff[8]+addr+1]=4;    //terrain
          mb[moff[8]+addr+6]=2;   //spotting/defense

          //mb[MainForm->S2Addr(x,y)+moff[2]+1]=(byte)(gnum/256);
        }

      }
      if (alt>=0)
      {
          gnum=250*file+31+random(15);
          set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
         // addr=MainForm->S8Addr(x,y);
          //mb[moff[8]+addr+1]=4;    //terrain
         // mb[moff[8]+addr+6]=2;   //spotting/defense
      }
    }
    //actually as soon as a map is edited in SP these slopes
    //are recalculated.... S29 controls the redraw

    //now we put in the slopes graphics
  file=StrToInt(SlopeEdit->Text);
  for(y=0; y<MapSizeY; ++y)
    for (x=0; x<MapSizeX; ++x)
    {
      code=HexEditForm->altitude_code(x,y,0);

      if (code>0 && x>0 && x<(MapSizeX-1)
              && y>0 && y<(MapSizeY-1)) //don't do edges
      {
        addr=MainForm->S28Addr(x,y);

        //need to accomodate multi graphics  and differnt sets
        mb[moff[28]+addr]=1;
        //file=1;
        icon=stiles[code].s1;
        gr=250*file+icon;
        set_gnum(&(mb[moff[28]+addr+1]),gr);
        //mb[moff[28]+addr+2+offs]=(byte)(gr/256);

        icon=stiles[code].s2;
        if(icon>=0)
        {
          mb[moff[28]+addr]=2;
          gr=250*file+icon;
          set_gnum(&(mb[moff[28]+addr+3]),gr);
          //mb[moff[28]+addr+4+offs]=(byte)(gr/256);
        }

        icon=stiles[code].s3;
        if(icon>=0)
        {
          mb[moff[28]+addr]=3;
          gr=250*file+icon;
          set_gnum(&(mb[moff[28]+addr+5]),gr);
          //mb[moff[28]+addr+6]=(byte)(gr/256);
        }
      }
    }


    //now adjust altitudes and put in slope terrain
    for(y=1; y<MapSizeY-1; ++y)
     for (x=1; x<MapSizeX-1; ++x)
     {
       alt=10*(HexEditForm->altitude(x,y,0)/10);
       neighbor_alt=10*(HexEditForm->altitude_max(x,y,0)/10);
       if (neighbor_alt>alt && alt>=0 && neighbor_alt>0) //add a slope
       {
         alt+=5;
         mb[MainForm->S8Addr(x,y)+0+moff[8]]=(byte)alt;
         //this needs different offset for sp3 xxxxxxxxxxxxx
         mb[MainForm->S8Addr(x,y)+7+moff[8]]=2; //slope code
        }

        //adjust s29 ... this for clear terrain only
        alt=mb[MainForm->S8Addr(x,y)+0+moff[8]];
        if (alt>=0 && alt<100) mb[moff[29]+MainForm->S29Addr(x,y)]=(byte)((alt/10)+1);

     }
     gnum=250*28+31;
    y=0;
    for (x=0; x<MapSizeX; ++x)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
    y=MapSizeY-1;
    for (x=0; x<MapSizeX; ++x)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
    x=0;
    for (y=0; y<MapSizeY; ++y)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
    x=MapSizeX-1;
    for (y=0; y<MapSizeY; ++y)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);

}
//---------------------------------------------------------------------------

void __fastcall TImportForm::BmpImgClick(TObject *Sender)
{
  OriginLbl->Caption=IntToStr(BmpSB->HorzScrollBar->Position);
}
//---------------------------------------------------------------------------
void __fastcall TImportForm::BmpSBClick(TObject *Sender)
{
  OriginLbl->Caption=IntToStr(BmpSB->HorzScrollBar->Position);
}


void __fastcall TImportForm::Timer1Timer(TObject *Sender)
{
   if (ImgOgX!=BmpSB->HorzScrollBar->Position ||
       ImgOgY!=BmpSB->VertScrollBar->Position )
   ImgOgX=BmpSB->HorzScrollBar->Position;
   ImgOgY=BmpSB->VertScrollBar->Position;
   OriginLbl->Caption=IntToStr(ImgOgX)+","+IntToStr(ImgOgY)+"    ";
}
//---------------------------------------------------------------------------

void __fastcall TImportForm::FormActivate(TObject *Sender)
{
  Timer1->Enabled=true;
}
//---------------------------------------------------------------------------

void __fastcall TImportForm::FormDeactivate(TObject *Sender)
{
 Timer1->Enabled=false;
}
//---------------------------------------------------------------------------

void __fastcall TImportForm::TerBtnClick(TObject *Sender)
{
  int xscale,yscale,x,y;
  int clr,r,g,b;
  int rn,lvl,addr,gnum,alt_lvl;

  xscale=XScaleUD->Position;
  yscale=YScaleUD->Position;


  for(y=0; y<MapSizeY; ++y)
    for (x=0; x<MapSizeX; ++x)
    {
       clr=BmpImg->Picture->Bitmap->Canvas->
         Pixels[ImgOgX+xscale*x+xscale/2][ImgOgY+yscale*y+yscale/2];
       r=clr&255;
       g=(clr>>8)&255;
       b=(clr>>16)&255;

       //ignore gray
       if (!(r==g && r==b))
       {
         //trees ... the amt above 155 is the % coverage
         lvl=g-155;
         rn=random(100)+1;
         if (rn<=lvl) //put a tree in
         {
           addr=MainForm->S8Addr(x,y);
           mb[moff[8]+addr]|=4;    //terrain
           mb[moff[8]+addr+6]=8;   //spotting/defense
           mb[moff[8]+addr+8]=30;  //spotting/defense

           addr=MainForm->S2Addr(x,y);
           gnum=250*9+random(18);
           set_gnum(&(mb[moff[6]+addr]),gnum);
           //mb[moff[6]+addr+1]=(byte)(gnum/256);

         }

         lvl=r-155;
         rn=random(100)+1;
         if (rn<=lvl) //put a rough hex in
         {
           //alt_lvl=HexEditForm->altitude(x,y,SP2)/10;
           addr=moff[8]+MainForm->S8Addr(x,y);
           alt_lvl=mb[addr+4];
           alt_lvl=alt_lvl/10;
           if (alt_lvl<0) alt_lvl=0;
           mb[moff[29]+MainForm->S29Addr(x,y)]=(byte)(alt_lvl+5);

           addr=MainForm->S8Addr(x,y);
           mb[moff[8]+addr+1]|=16;    //terrain
           mb[moff[8]+addr+6]=2;   //spotting/defense
           mb[moff[8]+addr+8]=20;  //spotting/defense


           addr=MainForm->S2Addr(x,y);
           gnum=250*3+random(4)+31;
           set_gnum(&(mb[moff[2]+addr]),gnum);
           //mb[moff[2]+addr+1]=(byte)(gnum/256);
         }
       }
     }
}
//---------------------------------------------------------------------------


void __fastcall TImportForm::FormCreate(TObject *Sender)
{
  //int h;
  //draw the map colors for altitude
 // hbmp=new Graphics :: TBitmap;
 // hbmp->Width=650;
 // hbmp->Height=75;


  int w=30;
  for (int x=0; x<w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=Water;

  for (int x=1*w; x<2*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea0;

   for (int x=2*w; x<3*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea1;

   for (int x=3*w; x<4*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea2;

   for (int x=4*w; x<5*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea3;

   for (int x=5*w; x<6*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea4;

   for (int x=6*w; x<7*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea5;

   for (int x=7*w; x<8*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea6;

   for (int x=8*w; x<9*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea7;

   for (int x=9*w; x<10*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea8;

   for (int x=10*w; x<11*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea9;

   for (int x=11*w; x<12*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea10;

   for (int x=12*w; x<13*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea11;

   for (int x=13*w; x<14*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea12;

   for (int x=14*w; x<15*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea13;

   for (int x=15*w; x<16*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea14;

   for (int x=16*w; x<17*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea15;

   for (int x=17*w; x<18*w; ++x)
    for (int y=0; y<70; ++y)
      MCImg->Canvas->Pixels[x][y]=huea16;
      
  //MCImg->Picture->Graphic=hbmp;
  MCImg->Show();
}
//---------------------------------------------------------------------------

void __fastcall TImportForm::Alt16BtnClick(TObject *Sender)
{
  //water and 0 thru 16 alt

  int x,y;
  int xscale,yscale;
  int clr,alt;
  int addr,code;
  int file,icon,gr;
  int neighbor_alt,gnum;

  xscale=XScaleUD->Position;
  yscale=YScaleUD->Position;
  randomize();

  for(y=0; y<MapSizeY; ++y)  //MapSizeY
    for (x=0; x<MapSizeX; ++x)
    {
      //need to get the average of all the pix in the block!!!!!!!!!!
      clr=BmpImg->Picture->Bitmap->Canvas->
         Pixels[ImgOgX+xscale*x+xscale/2][ImgOgY+yscale*y+yscale/2];
     // r=clr&255;
      //g=(clr>>8)&255;
     // b=(clr>>16)&255;
      //avg=(r+g+b)/3;

      if (clr== huea16) alt=160;
      if (clr== huea15) alt=150;
      if (clr== huea14) alt=140;
      if (clr== huea13) alt=130;
      if (clr== huea12) alt=120;
      if (clr== huea11) alt=110;
      if (clr== huea10) alt=100;
      if (clr== huea9 ) alt= 90;
      if (clr== huea8 ) alt= 80;
      if (clr== huea7 ) alt= 70;
      if (clr== huea6 ) alt= 60;
      if (clr== huea5 ) alt= 50;
      if (clr== huea4 ) alt= 40;
      if (clr== huea3 ) alt= 30;
      if (clr== huea2 ) alt= 20;
      if (clr== huea1 ) alt= 10;
      if (clr== huea0 ) alt=  0;
      if (clr==Water) alt=-3;

      //altitude=4 for altitude for WAW
      addr=MainForm->S8Addr(x,y);
      //mb[moff[8]+addr+4]=(byte)alt;
      mb[moff[8]+addr]=(byte)alt;
      if (alt<0)
      {

        mb[moff[8]+addr+1]=255;
        if (alt==-3)//lake ...
        {
          mb[moff[29]+MainForm->S29Addr(x,y)]=40;
          gnum=250*22+31+(x+y)%5;


          set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
          //mb[MainForm->S2Addr(x,y)+moff[2]+1]=(byte)(gnum/256);
        }

      }
      //gnum=250*file+31+(x+y)%5;
      boolean secfile;
      if (random(100)<StrToInt(Per1Edit->Text))
      {
        file=StrToInt(FirstEdit->Text);
        secfile=false;
      }
      else
      {
        file=StrToInt(SecEdit->Text);
        secfile=true;
      }
      gnum=250*file+31+random(15);
      if (alt>=0) //altitude is 0 and above
      {

          mb[moff[29]+MainForm->S29Addr(x,y)]=10;


          mb[MainForm->S2Addr(x,y)+moff[2]+0]=(byte)(gnum&255);
          mb[MainForm->S2Addr(x,y)+moff[2]+1]=(byte)(gnum/256);
         if ((secfile==true) && (RingsEdit->Text=="Y"))
          {
            addr=MainForm->S28Addr(x,y);
            mb[moff[28]+addr]=1;

            icon=30;
            gr=250*file+icon;
            set_gnum(&(mb[moff[28]+addr+1]),gr);

          }
          //set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
      }

      /*  else  //swamp
        {
          mb[moff[29]+MainForm->S29Addr(x,y)]=10;
          gnum=250*5+31+(x+y)%5;
          set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
          addr=MainForm->S8Addr(x,y);
          //mb[moff[8]+addr+1]=4;    //terrain
          mb[moff[8]+addr+6]=2;   //spotting/defense

          //mb[MainForm->S2Addr(x,y)+moff[2]+1]=(byte)(gnum/256);
        } */


    }
    //actually as soon as a map is edited in SP these slopes
    //are recalculated.... S29 controls the redraw


 //now we put in the slopes graphics
  file=StrToInt(SlopeEdit->Text);
  for(y=0; y<MapSizeY; ++y)
    for (x=0; x<MapSizeX; ++x)
    {
      code=HexEditForm->altitude_code(x,y,0);

      if (code>0 && x>0 && x<(MapSizeX-1)
              && y>0 && y<(MapSizeY-1)) //don't do edges
      {
        addr=MainForm->S28Addr(x,y);

        //need to accomodate multi graphics  and differnt sets
        mb[moff[28]+addr]=1;
        //file=1;
        icon=stiles[code].s1;
        gr=250*file+icon;
        set_gnum(&(mb[moff[28]+addr+1]),gr);
        //mb[moff[28]+addr+2+offs]=(byte)(gr/256);

        icon=stiles[code].s2;
        if(icon>=0)
        {
          mb[moff[28]+addr]=2;
          gr=250*file+icon;
          set_gnum(&(mb[moff[28]+addr+3]),gr);
          //mb[moff[28]+addr+4+offs]=(byte)(gr/256);
        }

        icon=stiles[code].s3;
        if(icon>=0)
        {
          mb[moff[28]+addr]=3;
          gr=250*file+icon;
          set_gnum(&(mb[moff[28]+addr+5]),gr);
          //mb[moff[28]+addr+6]=(byte)(gr/256);
        }
      }
    }


    //now adjust altitudes and put in slope terrain
    for(y=1; y<MapSizeY-1; ++y)
     for (x=1; x<MapSizeX-1; ++x)
     {
       alt=10*(HexEditForm->altitude(x,y,0)/10);
       neighbor_alt=10*(HexEditForm->altitude_max(x,y,0)/10);
       if (neighbor_alt>alt && alt>=0 && neighbor_alt>0) //add a slope
       {
         alt+=5;
         mb[MainForm->S8Addr(x,y)+0+moff[8]]=(byte)alt;
         //this needs different offset for sp3 xxxxxxxxxxxxx
         mb[MainForm->S8Addr(x,y)+7+moff[8]]=2; //slope code
        }

        //adjust s29 ... this for clear terrain only
        alt=mb[MainForm->S8Addr(x,y)+0+moff[8]];
        if (alt>=0 && alt<161) mb[moff[29]+MainForm->S29Addr(x,y)]=(byte)((alt/10)+1);

     }
    gnum=250*28+31;
    y=0;
    for (x=0; x<MapSizeX; ++x)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
    y=MapSizeY-1;
    for (x=0; x<MapSizeX; ++x)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
    x=0;
    for (y=0; y<MapSizeY; ++y)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);
    x=MapSizeX-1;
    for (y=0; y<MapSizeY; ++y)
      set_gnum(&(mb[MainForm->S2Addr(x,y)+moff[2]]),gnum);


}
//---------------------------------------------------------------------------

