//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <stdlib.h>
#include <stdio.h>
#include "ReadShp.h"
#include "WW2Map1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TLoadShp *LoadShp;


//---- shp related stuff -------
#define MAX_COLORS 256
#define SHP_HEADER_SIZE 24
#define BKG_COLOR 1000     //this is the paletted image to show transparent
#define MAX_WIDTH 215
#define MAX_HEIGHT 200
#define MAX_ICONS 250


int size_images;
int num_images;



short int bmp[MAX_WIDTH][MAX_HEIGHT];

struct color bkcolor={255,225,225};

int addr[MAX_ICONS];  //addresses of icons
int total_icons; //icons in the file

// default palette
struct color pal[MAX_COLORS]=
   {
      {0, 0, 0},{23, 23, 23},{43, 43, 43},{67, 67, 67},{91, 91, 91},
      {115, 115, 115},{139, 139, 139},{159, 159, 159},{183 ,183 ,183},
      {207 ,207 ,207},{231 ,231 ,231},{255 ,255 ,255},{75 ,75 ,151},
      {43 ,207 ,51},{255 ,255 ,87},{227 ,0 ,0},{227 ,203 ,147},{231 ,191 ,147},
      {219 ,195 ,135},{211 ,183 ,127},{219 ,175 ,131},{207 ,171 ,119},
      {211 ,163 ,115},{211 ,159 ,111},{195 ,155 ,107},{179 ,159 ,103},
      {187 ,171 ,115},{195 ,183 ,131},{183 ,139 ,95},{191 ,135 ,87},
      {195 ,139 ,91},{171 ,147 ,87},{159 ,135 ,75},{151 ,123 ,63},{159 ,103 ,71},
      {171 ,111 ,67},{167 ,99 ,59},{143 ,87 ,55},{135 ,87 ,51},{131 ,103 ,51},
      {239 ,235 ,187},{115 ,79 ,39},{111 ,83 ,39},{91 ,67 ,35},{91 ,67 ,35},
      {91 ,67 ,31},{75 ,55 ,27},{71 ,51 ,23},{63 ,39 ,23},{47 ,31 ,15},
      {35 ,27 ,15},{39 ,35 ,27},{23 ,15 ,7},{0 ,31 ,0},{7 ,63 ,0},
      {11 ,87 ,0},{7 ,111 ,0},{7 ,135 ,0},{7 ,163 ,0},{87 ,107 ,23},
      {99 ,103 ,15},{107 ,103 ,0},{123 ,119 ,0},{139 ,139 ,0},{143 ,143 ,0},
      {159 ,159 ,0},{183 ,175 ,0},{207 ,199 ,0},{183 ,119 ,79},{175 ,123 ,83},
      {115 ,127 ,23},{99 ,119 ,35},{75 ,91 ,27},{71 ,83 ,0},{67 ,67 ,0},
      {91 ,87 ,0},{55 ,11 ,0},{231 ,227 ,219},{199 ,195 ,191},{167 ,163 ,159},
      {135 ,131 ,127},{99 ,99 ,95},{67 ,67 ,63},{35 ,35 ,31},{255 ,255 ,255},
      {227 ,223 ,231},{199 ,191 ,207},{171 ,155 ,179},{143 ,123 ,155},{115 ,87 ,131},
      {15 ,59 ,11},{27 ,71 ,11},{35 ,79 ,11},{43 ,91 ,7},{51 ,103 ,7},
      {59 ,115 ,7},{71 ,127 ,7},{79 ,135 ,7},{87 ,147 ,7},{95 ,159 ,7},
      {151 ,163 ,199},{139 ,155 ,187},{131 ,143 ,171},{119 ,131 ,159},{107 ,119 ,143},
      {99 ,107 ,131},{87 ,99 ,115},{75 ,87 ,99},{67 ,75 ,87},{55 ,63 ,71},
      {43 ,51 ,59},{35 ,43 ,43},{99 ,119 ,35},{111 ,115 ,131},{131 ,131 ,167},
      {99 ,107 ,131},{111 ,115 ,131},{51 ,87 ,175},{7 ,123 ,211},{43 ,79 ,151},
      {47 ,87 ,159},{47 ,87 ,159},{47 ,87 ,159},{47 ,91 ,167},{47 ,95 ,175},
      {51 ,103 ,187},{47 ,95 ,175},{47 ,91 ,167},{151 ,135 ,99},{151 ,127 ,99},
      {143 ,127 ,91},{139 ,119 ,83},{143 ,115 ,87},{135 ,111 ,79},{139 ,107 ,75},
      {139 ,103 ,75},{127 ,103 ,71},{119 ,103 ,67},{123 ,111 ,75},{127 ,119 ,87},
      {119 ,91 ,63},{127 ,91 ,59},{127 ,91 ,59},{111 ,99 ,59},{103 ,91 ,51},
      {99 ,83 ,43},{103 ,67 ,47},{111 ,75 ,47},{111 ,67 ,39},{95 ,59 ,39},
      {91 ,59 ,35},{87 ,67 ,35},{107 ,87 ,67},{75 ,51 ,27},{75 ,55 ,27},
      {59 ,47 ,23},{59 ,47 ,23},{59 ,47 ,23},{51 ,39 ,19},{47 ,35 ,15},
      {43 ,27 ,15},{31 ,23 ,11},{23 ,19 ,11},{27 ,23 ,19},{15 ,11 ,7},
      {0 ,23 ,0},{7 ,43 ,0},{7 ,59 ,0},{7 ,75 ,0},{7 ,91 ,0},{7 ,107 ,0},
      {59 ,71 ,15},{67 ,67 ,11},{71 ,67 ,0},{83 ,79 ,0},{91 ,91 ,0},
      {95 ,95 ,0},{103 ,103 ,0},{119 ,115 ,0},{135 ,131 ,0},{119 ,79 ,51},
      {115 ,83 ,55},{75 ,83 ,15},{67 ,79 ,23},{51 ,59 ,19},{47 ,55 ,0},
      {47 ,47 ,0},{59 ,59 ,0},{39 ,7 ,0},{131 ,127 ,123},{111 ,111 ,107},
      {95 ,95 ,91},{75 ,75 ,71},{59 ,59 ,55},{39 ,39 ,39},{23 ,23 ,23},
      {151 ,147 ,151},{135 ,127 ,139},{119 ,111 ,123},{107 ,95 ,111},{91 ,75 ,99},
      {75 ,59 ,83},{11 ,39 ,7},{19 ,47 ,7},{23 ,51 ,7},{27 ,59 ,7},
      {35 ,67 ,7},{39 ,75 ,7},{47 ,83 ,7},{51 ,91 ,7},{59 ,99 ,0},
      {63 ,103 ,0},{99 ,107 ,131},{91 ,99 ,123},{83 ,95 ,111},{79 ,87 ,103},
      {71 ,79 ,95},{63 ,71 ,83},{55 ,63 ,75},{51 ,55 ,67},{43 ,51 ,55},
      {35 ,43 ,47},{31 ,35 ,39},{23 ,27 ,31},{67 ,79 ,23},{75 ,75 ,87},
      {87 ,87 ,111},{67 ,71 ,87},{75 ,75 ,87},{23 ,47 ,131},{35 ,71 ,155},
      {0 ,11 ,95},{7 ,23 ,103},{7 ,23 ,111},{15 ,35 ,119},{23 ,47 ,131},
      {27 ,59 ,143},{35 ,71 ,155},{27 ,59 ,143},{23 ,47 ,131},{239 ,171 ,35},
      {255 ,219 ,39},{231 ,155 ,35},{223 ,131 ,35},{79 ,71 ,63},{0 ,0 ,0},
      {35 ,35 ,35},{91 ,87 ,83},{55 ,51 ,51},{91 ,87 ,83},{175 ,167 ,159},
      {103 ,99 ,95},{91 ,87 ,75},{107 ,103 ,91},{127 ,127 ,127},
      {175 ,167 ,159} };

//--------------------------------
struct shp_header
{
  int lines;     // last starting at 0 ie lines-1
  int width;
  int centerx;
  int centery;
  long xstart;
  long ystart;
  long xend;
  long yend;
} shpheader;

int pix_pos,max_pix_x,max_pix_y;

//---------------------------------------------------------------------------
__fastcall TLoadShp::TLoadShp(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//--- stuff for reading shps -----

// place the color number in the pseudo image and bump pix_pos
void put_pix(int y, short int clr)
{
  if (pix_pos>=max_pix_x) max_pix_x=pix_pos+1;  //some SP info
  if (y>=max_pix_y) max_pix_y=y+1;
    bmp[pix_pos][y]=clr;
  ++pix_pos;
}

// read the shp data (for icon n) into the pseudo image
void read_shp(int n, FILE *inf)
{
   int l; // first line the counter
   int lf; // last line
   int ch,b,r,i;


   //we added this Version 0.62 when going to cropped images
   //to make sure there arent pieces left from before
   for (int y=0; y<MAX_HEIGHT; ++y)
     for (int x=0; x<MAX_WIDTH; ++x)
       bmp[x][y]=BKG_COLOR;

   fseek(inf,addr[n]+SHP_HEADER_SIZE,0);
  // if (shpheader.ystart<0)
 //  {
 //   l=0; lf=shpheader.yend+abs(shpheader.ystart);   //SP...
 //  }
 //  else
 //  {
  //   l=shpheader.ystart;
  l=0;
     lf=shpheader.yend-shpheader.ystart;
//   }
   //invalid or no image
   if (shpheader.xstart>641 || shpheader.xstart<-100||
               shpheader.ystart>481 || shpheader.ystart<-100) return;

   if (shpheader.xstart<0)      //SP....
      pix_pos=0;
   else
      pix_pos=0;
  //  pix_pos=shpheader.xstart;
   do
   {
     // read data  and decode
     ch=fgetc(inf);
     r=ch%2;
     b=ch/2;
     if (b==0 && r==1) // a skip over
     {
        ch=fgetc(inf);
        for (i=0; i<ch; ++i)
          put_pix(l,BKG_COLOR);
     }
     else if (b==0)   // end of line
     {
       ++l;
       if (shpheader.xstart<0)
       {
         pix_pos=0;
       }
       else pix_pos=0;//pix_pos=shpheader.xstart;
     }
     else if (r==0) // a run of bytes
     {
       ch=fgetc(inf); // the color #
       for (i=0; i<b; ++i)
        put_pix(l,(short)ch);
     }
     else // b!0 and r==1 ... read the next b bytes as color #'s
     {
       for (i=0; i<b; ++i)
       {
         ch=fgetc(inf);
         put_pix(l,(short)ch);
       }
     }
   } while (l<=lf);
}

void read_header(int n, FILE *shp)
{
   fseek(shp,addr[n],0);
   fread(&(shpheader.lines),2,1,shp);
   fread(&(shpheader.width),2,1,shp);
   fread(&(shpheader.centerx),2,1,shp);
   fread(&(shpheader.centery),2,1,shp);
   fread(&(shpheader.xstart),4,1,shp);
   fread(&(shpheader.ystart),4,1,shp);
   fread(&(shpheader.xend),4,1,shp);
   fread(&(shpheader.yend),4,1,shp);
}

void clear_buffer()
{
   int x,y;

   for (y=0; y<MAX_HEIGHT; ++y)
    for (x=0; x<MAX_WIDTH; ++x)
      bmp[x][y]=BKG_COLOR;
}

//-----------------------------------------------------
void read_addresses(FILE *inf)
{
  int i;

  fseek(inf,4,SEEK_SET);
  fread(&total_icons,4,1,inf);

  // read the addresses from the shp file
  for (i=0; i<total_icons; ++i)
  {
     fseek(inf,8+8*i,SEEK_SET);
     fread(&(addr[i]),4,1,inf);
  }
}

//--------------------------------------------------------------
// Read number n shp format icon from file fname
// return an integer on error... 0 OK
int __fastcall TLoadShp::LoadTile(int n, char *fname, struct ICON *an_icon)
{
  FILE *inf;
  int x,y;

  if (MainForm->TileIL->Height<TILE_LIST_HEIGHT)
     MainForm->TileIL->Height=TILE_LIST_HEIGHT;
  if (MainForm->TileIL->Width<TILE_LIST_WIDTH)
     MainForm->TileIL->Width=TILE_LIST_WIDTH;

  inf=fopen(fname,"rb");
  if (!inf) return 1;

  read_addresses(inf);
  if (total_icons>MAX_ICONS)
  {
    fclose(inf);
    return 2;
  }
  if (n>=total_icons)
  {
     fclose(inf);
     return 100;      //this is an error but may be used by WAW
  }
  //bmp is a temporary array of color numbers
  if (!bmp)
  {
    fclose(inf);
    return 3;
  }
  clear_buffer();
  read_header(n,inf);
  if (shpheader.lines==0)
  {
     fclose(inf);
     return 102; //empty
  }
  read_shp(n,inf); //transfer color numbers to buffer

  an_icon->ogx=shpheader.xstart;
  an_icon->ogy=shpheader.ystart;

  // new way cropping transparent on right and bottom
  //does not reduce resource usage
  //an_icon->tbmp->Width=GetWidth();
  //an_icon->tbmp->Height=GetHeight();

   int iwidth=shpheader.xend-shpheader.xstart+1;
   int iheight=shpheader.yend-shpheader.ystart+1;
   //set up a bitmap to write into
   Graphics :: TBitmap *abmp= new Graphics :: TBitmap;
   //if the image is within the range for the item list make it that size
   //when we call this from the transfer function we should always add
   //a new image not to the list
   if (iheight<=TILE_LIST_HEIGHT && iwidth<=TILE_LIST_WIDTH &&
          !transfer_function)
   {
      iheight=TILE_LIST_HEIGHT;
      iwidth=TILE_LIST_WIDTH;
   }
   abmp->Height=iheight;
   abmp->Width=iwidth;
   //put the colors into the bitmap
   for (y=0; y<abmp->Height; ++y)
     for (x=0; x<abmp->Width; ++x)
     {
       if (bmp[x][y]==BKG_COLOR)
       {
         abmp->Canvas->Pixels[x][y]=
         (TColor)(bkcolor.R+256*bkcolor.G+256*256*bkcolor.B);
       }
       else
       {
         abmp->Canvas->Pixels[x][y]=
         (TColor)(pal[bmp[x][y]].R+
                  256*pal[bmp[x][y]].G+
                  256*256*pal[bmp[x][y]].B);
       }
     }
  fclose(inf);
  //if to go in TileIL we have set this up to width/height already
  if (iheight==TILE_LIST_HEIGHT && iwidth==TILE_LIST_WIDTH &&
    !transfer_function)
   {
      //add the image to the list
      an_icon->inum=MainForm->TileIL->Count;
      int err=MainForm->TileIL->AddMasked(abmp,
        (TColor)(bkcolor.R+256*bkcolor.G+256*256*bkcolor.B));
      if (err<0)
        Application->MessageBox("Image list error","Error",MB_OK);
      delete abmp;  //its in the list destroy it
   }
   else
   {
     //this creates and sets up our bitmap plus offsets
     //an_icon->tbmp= new Graphics :: TBitmap;

     // ------------ old way using the whole icon including pink
     //an_icon->tbmp->Width=iwidth;
     //an_icon->tbmp->Height=iheight;
     an_icon->tbmp=abmp;
     an_icon->tbmp->Width=iwidth;
     an_icon->tbmp->Height=iheight;
     an_icon->inum=-1;
     an_icon->tbmp->Transparent=true;
     an_icon->tbmp->TransparentColor=
       (TColor)(bkcolor.R+256*bkcolor.G+256*256*bkcolor.B);
     //test data
     size_images+=(an_icon->tbmp->Width*an_icon->tbmp->Height);
     MainForm->SizeLbl->Caption=IntToStr(size_images/1024);
     ++num_images;
     MainForm->ImgNumLbl->Caption=IntToStr(num_images);
   }


  return 0;
}

void __fastcall TLoadShp::FormActivate(TObject *Sender)
{
   struct ICON icon1;
   char fname[32]="Shp\\Ter01z4.shp";
   int error;


   error=LoadTile(0,fname, &icon1);
   Image1->Picture->Bitmap=icon1.tbmp;
   if (error)
   {
     Application->MessageBox("Error","Error",MB_OK);

   }
   IncBtn->Caption="Tile 0";
   IncBtn->Tag=0;
}
//---------------------------------------------------------------------------

void __fastcall TLoadShp::IncBtnClick(TObject *Sender)
{

   struct ICON icon1;
   char fname[32]="Shp\\Ter01z4.shp";
   int error;

   ++IncBtn->Tag;
   error=LoadTile(IncBtn->Tag,fname, &icon1);
   Image1->Picture->Bitmap=icon1.tbmp;
   if (error)
   {
     Application->MessageBox("Error","Error",MB_OK);

   }
   IncBtn->Caption="Tile "+IntToStr(IncBtn->Tag);
}
//---------------------------------------------------------------------------
// these get the height and width of the non-transparent part of the image
int __fastcall TLoadShp::GetHeight()
{
   for (int y=MAX_HEIGHT-1; y>=0; --y)
     for (int x=0; x<MAX_WIDTH; ++x)
       if (bmp[x][y]!=BKG_COLOR) return y;
    return 0;

}
int __fastcall TLoadShp::GetWidth()
{
   for (int x=MAX_WIDTH-1; x>=0; --x)
     for (int y=0; y<MAX_HEIGHT; ++y)
       if (bmp[x][y]!=BKG_COLOR) return x;
}

