//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Contour.h"
#include "WW2Map1.h"
#include "HexEdit.h"
#include "Jpeg.h"
#include <Jpeg.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TContourForm *ContourForm;

//---------------------------------------------------------------------------
__fastcall TContourForm::TContourForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------
int __fastcall TContourForm:: MaxAltitude()
{
   int maxalt=-100;

   for (int y=0; y<MapSizeY; ++y)
     for (int x=0; x<MapSizeX; ++x)
     {
       if (HexEditForm->altitude(x,y,0)>maxalt)
         maxalt=HexEditForm->altitude(x,y,0);

     }
     return maxalt;
}
//---------------------------------------------------------------------------
void __fastcall TContourForm::ShowBtnClick(TObject *Sender)
{
   TPicture *GridPic;
   Graphics :: TBitmap *bmp;
   int ico_sz=9; //we may change this later to scale to grid size
   int aoff,x,y,s8addr,addr,toff;
   int alt,square,ttype,tbit,mask;
   TRect srect,drect;

   Screen->Cursor=crHourGlass;
   bmp= new Graphics :: TBitmap;
   bmp->Width=MapSizeX*ico_sz+ico_sz/2+20;  //20 is room for ticks
   bmp->Height=MapSizeY*ico_sz+20;
   drect.Top=0; drect.Left=0;
   drect.Bottom=bmp->Height;
   drect.Right=bmp->Width;
   bmp->Canvas->Brush->Color=clWhite;
   bmp->Canvas->FillRect(drect);
   //place tick mark
   bmp->Canvas->Pen->Color=clBlack;
   bmp->Canvas->Pen->Width=3;
   for (x=0; x<(MapSizeX+1); x+=10)
   {
     bmp->Canvas->MoveTo(x*(ico_sz)+10,0);
     bmp->Canvas->LineTo(x*(ico_sz)+10,9);
     bmp->Canvas->MoveTo(x*(ico_sz)+10,bmp->Height);
     bmp->Canvas->LineTo(x*(ico_sz)+10,bmp->Height-9);
   }
   for (y=0; y<(MapSizeY+1); y+=10)
   {
     bmp->Canvas->MoveTo(0,y*(ico_sz)+10);
     bmp->Canvas->LineTo(10,y*(ico_sz)+10);
     bmp->Canvas->MoveTo(bmp->Width,y*(ico_sz)+10);
     bmp->Canvas->LineTo(bmp->Width-9,y*(ico_sz)+10);
   }

   GridPic= new TPicture;
   GridPic->Bitmap->Width=16*(ico_sz+1);
   GridPic->Bitmap->Height=12*(ico_sz+1);
   GridPic->LoadFromFile(StartPath+"\\grid.bmp");

   //set up a rectangel to copy the icon into
   //so we can Draw it transparently on the map
   Graphics :: TBitmap *tbmp = new Graphics :: TBitmap;
   tbmp->Width=ico_sz;
   tbmp->Height=ico_sz;
   tbmp->Transparent=true;
   tbmp->TransparentMode=tmAuto;


   ContourImg->Width=bmp->Width;
   ContourImg->Height=bmp->Height;

   aoff=0;  //altit offset into section 8 record
   toff=7;  //terrain

   int maxalt=MaxAltitude();
   if (maxalt<35) maxalt=35;
   for (y=0; y<MapSizeY; ++y)
     for (x=0; x<MapSizeX; ++x)
     {
        s8addr=MainForm->S8Addr(x,y);
        addr=s8addr+aoff+moff[8];
        alt=HexEditForm->altitude(x,y,0);
        if (alt>0) alt=((alt*3400)/maxalt)/100;

        if (alt>35) alt=35; // need to scale!
        if (alt<-5) alt=-5;

        //get the source bitmap rectangle from grid
        square=alt+5; //ie first square in grid is alt -5
        srect.Top=(square/20)*(ico_sz+1)+1;    //grid is 20 units wide
        srect.Left=(square%20)*(ico_sz+1)+1;
        srect.Right=srect.Left+ico_sz;
        srect.Bottom=srect.Top+ico_sz;

        //get the destination rectangle
        drect.Top=ico_sz*y;
        drect.Left=ico_sz*x;
        if ((y%2)) drect.Left+=ico_sz/2;
        drect.Top+=10; drect.Left+=10; //room for ticks
        drect.Bottom=drect.Top+ico_sz;
        drect.Right=drect.Left+ico_sz;

        //put altitude graphic on the image
        bmp->Canvas->CopyRect(drect,GridPic->Bitmap->Canvas,srect);

        //show the terrain
        if (TerrainCB->Checked)
        {

          //tbmp->Brush->Color=clBlack;
          //srect.Top=0; srect.Left=0;
          //srect.Bottom=srect.Top+ico_sz;
          //srect.Right=srect.Left+ico_sz;
          //tbmp->FillRect(srect);

          addr=s8addr+toff+moff[8];
          ttype=(int) mb[addr]+256*mb[addr+1];
          //terrain is stored as a bitfield and each bit needs to be checked
          mask=1;
          for (int t=0; t<15; ++t)
          {
            tbit=ttype&mask;
            mask+=mask;
            if (tbit>0)
            {
              srect.Top=3*(ico_sz+1)+1;  //terrain icons on 4th row
              srect.Left=t*(ico_sz+1)+1;
              srect.Bottom=srect.Top+ico_sz;
              srect.Right=srect.Left+ico_sz;

              drect.Top=0; drect.Left=0;   //drect of tbmp
              drect.Bottom=drect.Top+ico_sz;
              drect.Right=drect.Left+ico_sz;

              tbmp->Canvas->CopyRect(drect,GridPic->Bitmap->Canvas,srect);
              if (y%2) bmp->Canvas->Draw(10+x*ico_sz+ico_sz/2,10+y*ico_sz,tbmp);
              else bmp->Canvas->Draw(10+x*ico_sz,10+y*ico_sz,tbmp);
            }
          }

        } //done with terrain

     }  // end of for x,y loop

   ContourImg->Picture->Bitmap=bmp;
   delete tbmp;
   delete GridPic;
   delete bmp;
   Screen->Cursor=crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TContourForm::SaveBtnClick(TObject *Sender)
{
    SaveDialog1->Filter=
      "Windows Bitmap (*.bmp)|*.bmp|JPEG compressed (*.jpg)|*.jpg|All (*.*)|*.*";
    SaveDialog1->DefaultExt="jpg";
    if (!SaveDialog1->Execute())return;

    if (ExtractFileExt(SaveDialog1->FileName)==".bmp")
     ContourImg->Picture->SaveToFile(SaveDialog1->FileName);
    else
    {
      ChangeFileExt(SaveDialog1->FileName,".jpg");
      TJPEGImage *jpeg =new TJPEGImage;
      jpeg->Assign(ContourImg->Picture->Graphic);
      jpeg->SaveToFile(SaveDialog1->FileName);
      delete jpeg;
    }
}
//---------------------------------------------------------------------------
void __fastcall TContourForm::FormCreate(TObject *Sender)
{
    SaveDialog1->InitialDir=StartPath;    
}
//---------------------------------------------------------------------------

