//---------------------------------------------------------------------------
#ifndef SPMap1H
#define SPMap1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Dialogs.hpp>
#include <Menus.hpp>
#include <ExtCtrls.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <Buttons.hpp>
#include <ImgList.hpp>

//different types of files that could be edited
#define NONE 0
#define SP2 1
#define SP3 2
#define SPWW2 3
#define SPWAW 4


//terrain types stored in s8 at 0 for SP3 and 7 for SP2
#define TT_NONE 0
#define TT_FIELD 1
#define TT_SLOPE 2
#define TT_TREE 4
#define TT_RIVER 8
#define TT_STONE_BUILD 16
#define TT_WOOD_BUILD 32
#define TT_DIRT_ROAD 64
#define TT_PAVED_ROAD 128
#define TT_WOOD_BRIDGE 256
#define TT_STONE_BRIDGE 512
#define TT_SWAMP 1024
#define TT_LAKE 2048
#define TT_ROUGH 4096
#define TT_HOLE 8192
#define TT_TRENCH_I 16384
#define TT_TRENCH_G 32768
#define TT_ALL 65535
//end of type defines

//#define MAX_MAP 1250000 //For version 1.03 map is 1242510 bytes!
#define MAX_MAP 2200000
#define MAX_SECTIONS 57

#define MAX_TILES 204         //in file 25 most are less
#define MAX_TERRAIN_FILES 99  //We make this the most the name will accomodate
#define BK_COLOR (TColor)0xE1E1FF

// these are the sections and sizes for spww2 version 2 maps
#define V2_S2_SIZE   16000
#define V2_S8_SIZE   96000
#define V2_S16_SIZE  1
#define V2_S17_SIZE  213199
#define V2_S20_SIZE  1
#define V2_S28_SIZE  104000
#define V2_S29_SIZE  8000
#define V2_S38_SIZE  4
#define V2_S39_SIZE  4
#define V2_S48_SIZE  72
#define V2_S2_ADDR    0x14
#define V2_S8_ADDR    0x17714
#define V2_S16_ADDR   0x2EE14
#define V2_S17_ADDR   0x2EE15
#define V2_S20_ADDR   0x62EE4
#define V2_S28_ADDR   0x62EE5
#define V2_S29_ADDR   0x7C525
#define V2_S38_ADDR   0x7E465
#define V2_S39_ADDR   0x7E469
#define V2_S48_ADDR   0x7E46D

#define WW2_S8_RECORD_SIZE 15
#define WW2_S28_RECORD_SIZE 13
struct SLOPE_TILES
{
   char s1,s2,s3;
};

extern int mapsize;     //small maps are 200 high
extern int MapSizeX;    //map X size
extern int MapSizeY;
//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
        TMainMenu *MainMenu1;
        TMenuItem *Files1;
        TOpenDialog *OpenDialog1;
        TImage *MapImg;
        TLabel *WhereLbl;
        TScrollBar *HMapSB;
        TMenuItem *Options1;
        TMenuItem *ShowHexes1;
        TScrollBar *VMapSB;
        TCheckBox *CB3;
        TCheckBox *CB4;
        TCheckBox *CB5;
        TCheckBox *CB6;
        TCheckBox *CB7;
        TSaveDialog *SaveDialog1;
        TMenuItem *InspectionMode1;
        TMenuItem *N1;
        TMenuItem *SetShpDirectory1;
        TMenuItem *Help1;
        TMenuItem *About1;
        TMenuItem *N2;
        TMenuItem *SaveMapFile1;
        TMenuItem *Tools;
        TMenuItem *Tools1;
        TMenuItem *N3;
        TMenuItem *CopyToFile1;
        TMenuItem *PasteFromFile1;
        TMenuItem *N4;
        TMenuItem *CopyToClopboard1;
        TMenuItem *PasteFromClipboard1;
        TMenuItem *StratMap1;
        TMenuItem *TileTransfer1;
        TSpeedButton *SpeedButton1;
        TSpeedButton *RedrawBtn;
        TSpeedButton *ShowHexesBtn;
        TMenuItem *SaveMapImage1;
        TMenuItem *ImageQuality1;
        TMenuItem *N6;
        TMenuItem *Exit1;
        TMenuItem *N7;
        TMenuItem *ContourMap1;
        TMenuItem *LoadSPWW2v3Map1;
        TMenuItem *ImportSDTSDEM1;
        TMenuItem *Roads1;
        TMenuItem *ShowRoadConnections1;
        TMenuItem *ToggleRoadConnection1;
        TMenuItem *ToggleRoad1;
        TMenuItem *N8;
        TMenuItem *PavedRoad1;
        TMenuItem *SecondaryRoad1;
        TMenuItem *Railroad1;
        TMenuItem *N9;
        TMenuItem *ShowAllRoadConnections1;
        TMenuItem *Convert1;
        TMenuItem *ConvertWW22toWW23;
        TMenuItem *RetainMines;
        TLabel *ImgNumLbl;
        TLabel *SizeLbl;
        TImageList *TileIL;
        TSpeedButton *UndoBtn;
        TMenuItem *N5;
        TMenuItem *SP3Map1;
        TMenuItem *SaveCompleteImage1;
        TStaticText *MaxXST;
        TStaticText *MaxYST;
        TMenuItem *Savebmp1;
        TMenuItem *SaveTopHalf1;
        TMenuItem *N10;
        TMenuItem *SaveBottomHalf1;
        TColorDialog *ColorDialog1;
        TMenuItem *ChangeHexColor1;
        void __fastcall LoadMapFile1Click(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall MapImgMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
        void __fastcall TestBtnClick(TObject *Sender);
        void __fastcall HMapSBChange(TObject *Sender);
        void __fastcall ShowHexes1Click(TObject *Sender);
        void __fastcall VMapSBChange(TObject *Sender);
        void __fastcall MapImgClick(TObject *Sender);
        void __fastcall InspectionMode1Click(TObject *Sender);
        void __fastcall LoadSP3Map1Click(TObject *Sender);
        void __fastcall SetShpDirectory1Click(TObject *Sender);
        void __fastcall About1Click(TObject *Sender);
        void __fastcall SaveMapFile1Click(TObject *Sender);
        void __fastcall Tools1Click(TObject *Sender);
        void __fastcall CopyToFile1Click(TObject *Sender);
        void __fastcall PasteFromFile1Click(TObject *Sender);
        void __fastcall CopyToClipboard1Click(TObject *Sender);
        void __fastcall PasteFromClipboard1Click(TObject *Sender);
        void __fastcall StratMap1Click(TObject *Sender);
        void __fastcall TileTransfer1Click(TObject *Sender);
        void __fastcall SpeedButton1Click(TObject *Sender);
        void __fastcall RedrawBtnClick(TObject *Sender);
        void __fastcall MapImgMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall ShowHexesBtnClick(TObject *Sender);
        void __fastcall SaveMapImage1Click(TObject *Sender);
        void __fastcall Exit1Click(TObject *Sender);
        void __fastcall ImageQuality1Click(TObject *Sender);
        void __fastcall ContourMap1Click(TObject *Sender);
        void __fastcall LoadSPWW2v3Map1Click(TObject *Sender);
        void __fastcall ImportSDTSDEM1Click(TObject *Sender);
        void __fastcall ShowRoadConnections1Click(TObject *Sender);
        void __fastcall ToggleRoadConnection1Click(TObject *Sender);
        void __fastcall ToggleRoad1Click(TObject *Sender);
        void __fastcall PavedRoad1Click(TObject *Sender);
        void __fastcall SecondaryRoad1Click(TObject *Sender);
        void __fastcall Railroad1Click(TObject *Sender);
        void __fastcall ShowAllRoadConnections1Click(TObject *Sender);
        void __fastcall ConvertWW2toWAW1xClick(TObject *Sender);
        void __fastcall RetainMinesClick(TObject *Sender);
        void __fastcall UndoBtnClick(TObject *Sender);
        void __fastcall SP3Map1Click(TObject *Sender);
        void __fastcall SaveCompleteImage1Click(TObject *Sender);
        void __fastcall Savebmp1Click(TObject *Sender);
        void __fastcall SaveTopHalf1Click(TObject *Sender);
        void __fastcall SaveBottomHalf1Click(TObject *Sender);
        void __fastcall ChangeHexColor1Click(TObject *Sender);
       
private:	// User declarations
public:		// User declarations
        __fastcall TMainForm(TComponent* Owner);
        int  __fastcall load_section(FILE *inf, int sec, unsigned char *b);
        int  __fastcall load_ww2_section(FILE *inf, int sec, unsigned char *b);
        void __fastcall MouseHex();
        int __fastcall S2Addr(int, int);
        int __fastcall TMainForm :: V2S2Addr(int x,int y);
        int __fastcall S8Addr(int x, int y);
        int __fastcall TMainForm :: V2S8Addr(int x, int y);
        int __fastcall S28Addr(int x, int y);
        int __fastcall TMainForm ::V2S28Addr(int x,int y);
        int __fastcall S29Addr(int x, int y);
        int __fastcall TMainForm :: V2S29Addr(int x, int y);
        void __fastcall TileAt(int x, int  y, int file, int ico);
        void __fastcall QTileAt(int x, int  y, int file, int ico);
        void __fastcall DrawMap();
        void __fastcall SaveMapImg();
        void __fastcall DrawHexes();
        void __fastcall QDrawHexes();
        void __fastcall SaveSection(int section,FILE *outf);
        void __fastcall SaveSection8sp3(FILE *outf);
        int __fastcall  RoadConnection(int x, int y, int t);
        int __fastcall  NewRoadConnection(int x, int y, int t);
        void __fastcall copy_to_file(int x0, int y0, int x1, int y1);
        void __fastcall paste_from_file(int x0, int y0);
        void __fastcall copy_to_clipboard(int x0,int y0,int x1,int y1);
        void __fastcall DrawRoads(int to, int x, int y,int x0,int y0);
        void __fastcall CopyHex(int destx,int desty,int srcx,int srcy);
        void __fastcall SaveUndo(int,int);
        void __fastcall RestoreUndo();
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
extern unsigned char mb[MAX_MAP];   //this hold all the map data
extern int moff[MAX_SECTIONS],ssz[MAX_SECTIONS];       //offset in mb and size of each section
extern int WhereX,WhereY;
extern int edit_type;
extern struct SLOPE_TILES stiles[64];
extern boolean strat_change;         //when map has changed..for strat map
extern int tiles_high,tiles_wide;

void _fastcall set_gnum(byte *m, int gnum); //global function to write a
                                            //2-byte word to mb buffer
extern boolean tile_transfer;
extern int transfer_file,transfer_inum;

extern int transfer_startx[MAX_TILES]; //the start x coordinate in the
                                //transfer image bitmap of each icon

extern char tilespath[128];
extern AnsiString StartPath;
extern int jpeg_quality;

extern boolean transfer_function;
//---------------------------------------------------------------------------
#endif
