#modname "Conceptual Balance Complete 1.01"
#domversion 2.16
#description "This is a Conceptual Balance for Dominions II.  These are balance changes to (and ONLY to) the stock game, not independantly modded games.  It is intended to create a greater sense of balance in each section of the Conceptual Balance series.  This particular Mod Balances the Pretender Choices and Statistics to give each it's own particular niche use.  Consult the ReadMe for more information."
#version 2.51
#icon "cbcomplete.tga"
#end

-- CREDITS

-- Convoluted history of the mods, rough timeline:

-- Zen releases and polishes conceptual pretenders, spells, scales

-- Zen releases an early version of conceptual items, and a teaser of conceptual nations

-- Turin creates his worth hero mod

-- Boron starts troop balance mod

-- quantum_mechani joins troop balance project, eventually taking it over and creating the moderation mod

-- quantum_mechani polishes pretenders, spells, scales, and items mods

-- quantum_mechani merges Turin's heroes, moderation, and Zen's nation mod teaser into a single conceptual nation mod

-- All 5 mods further polished from input from dominions players on the #dominions IRC channel (In particular from Turin)

-- Edi produces new, updated readme files for the CB Pretender, Spell and Scale mods.
-- He makes error and syntax corrections for all of the CB mods and recompiles the CB Complete mod from the corrected components mods.

------------------------------------------------------------------------------------


------------------
--**************--
--* SCALES 1.3 *--
--**************--
------------------

#supplymult 125
#poppergold 190

#deathincome 4
#deathdeath 3

#slothincome 4
#slothresources 15

#misfortune 13

#eventisrare 20

#coldincome 6

------------------------------------------------------------------------------------

--------------------------
-- WEAPON MODIFICATIONS --
--------------------------

-- Axe
#selectweapon 17
#att 0
#def -1
#end

-- Battleaxe
#selectweapon 18
#att 1
#end

-- Throwing Axe
#selectweapon 260
#dmg 6
#att -3
#end

-- Jotun Axe
#selectweapon 66
#att 0
#def -1
#end

-- Arbalest
#selectweapon 26
#dmg 17
#end

-- Mace
#selectweapon 12
#dmg 5
#end

-- Frost Breath
#selectweapon 226
#dmg 10
#aoe 3
#end

-- Cold Breath
#selectweapon 93
#dmg 16
#end

-- Branch
#selectweapon 240
#dmg -5
#len 5
#armorpiercing
#end

-- Darkfire Sword
#selectweapon 244
#len 4
#dmg 17
#end

-- Flambeau
#selectweapon 95
#len 4
#dmg 15
#end

-- Fire Breath
#selectweapon 61
#aoe 2
#end

-- Bile
#selectweapon 62
#aoe 5
#end

-- Icicle Fist
#selectweapon 69
#armorpiercing
#end

-- Frost Blast
#selectweapon 449
#dmg 15
#end

-- Plague Breath
#selectweapon 254
#ammo 3
#end


-----------------
-- NEW WEAPONS --
-----------------

-- Wing Buffet
#newweapon 999
#name "Wing Buffet"
#dmg -5
#att 0
#def 1
#len 5
#aoe 1
#flail
#bonus
#sound 38
#end

-- Roar
#newweapon 998
#name "Roar"
#dmg -5
#att 0
#def 0
#len 5
#aoe 1
#flail
#bonus
#sound 78
#end

-- Demonic Laughter
#newweapon 997
#name "Demonic Laughter"
#dmg 3
#nostr
#sound 20
#flail
#len 4
#magic
#armornegating
#bonus
#end

---------------------------------------


-------------------------
-- ARMOR MODIFICATIONS --
-------------------------

-- Mictlan Armor
#selectarmor 104
#prot 8
#end

-- Spider Armor
#selectarmor 111
#def -4
#end

-- Full Scale Mail
#selectarmor 17
#def -1
#end


-----------------
-- NEW ARMORS --
-----------------

-- Divine Garb
#newarmor 399
#name "Divine Garb"
#def 0
#prot 9
#enc 0
#type 5
#end

-- Ice Robe
#newarmor 280
#prot 11
#def 0
#enc 4
#type 5
#name "Ice Robe"
#end

-- Shield of the Pyre
#newarmor 273
#prot 4
#def 4
#enc 2
#type 4
#name "Shield of the Pyre"
#end
---------------------------------------


-------------------------
-------------------------
--*********************--
--*                   *--
--*  PRETENDERS 2.51  *--
--*                   *--
--*********************--
-------------------------
-------------------------

-------------
-- Monster --
-------------

-- Ancient Kraken
#selectmonster 973
#poisonres 100
#coldres 100
#end

-- Divine Serpent
#selectmonster 779
#pathcost 30
#end

-- Blue Dragon
#selectmonster 265
#prot 19
#prec 12
#weapon 20
#weapon 29
#weapon 999
#weapon 93
#end

-- Blue Dragon (Frost Father)
#selectmonster 267
#name "Rime Mariner"
#descr "The Rime Mariner is a mage of such great power that he has mastered his own mortality.  Donning a godly mantle, he has taken the role of a Pretender God.  The Rime Mariner is a master of magic and can be adept in serveral of the Magic Paths."
#hp 18
#enc 1
#mountainsurvival
#sailing
#end

-- Green Dragon
#selectmonster 266
#prot 19
#prec 12
#weapon 20
#weapon 29
#weapon 999
#weapon 62
#end

-- Green Dragon (Master Druid)
#selectmonster 268
#hp 18
#swampsurvival
#enc 1
#end

-- Red Dragon
#selectmonster 216
#prot 19
#prec 12
#weapon 20
#weapon 29
#weapon 999
#weapon 61
#end

-- Red Dragon (Great Sage)
#selectmonster 226
#hp 18
#mountainsurvival
#wastesurvival
#enc 1
#end

-- Dracolich
#selectmonster 644
#immortal
#gcost 135
#weapon 20
#weapon 29
#weapon 999
#weapon 254
#prec 12
#end

-- Dracolich (Bog Mummy)
#selectmonster 645
#fireres -25
#immortal
#end

-- Manticore
#selectmonster 462
#prot 15
#att 14
#def 13
#weapon 144
#weapon 29
#weapon 999
#end

-- Phoenix
#selectmonster 608
#magicskill 0 2
#end

-- Nerid
#selectmonster 294
#gcost 75
#mounted
#magicskill 2 2
#magicskill 6 1
#end

-- Naga
#selectmonster 157
#mounted
#gcost 90
#itemslots 13574
#startdom 2
#enc 2
#stealthy
#end

-- Golden Naga
#selectmonster 334
#mounted
#gcost 90
#itemslots 13574
#startdom 2
#enc 2
#end

-- Scorpion King
#selectmonster 655
#mounted
#itemslots 13574
#end

-- Shedu
#selectmonster 661
#magicskill 3 2
#def 14
#enc 2
#weapon 55
#weapon 999
#end

-- Great Black Bull
#selectmonster 978
#pathcost 60
#gcost 80
#mr 20
#enc 1
#end

-- Great White Bull
#selectmonster 979
#pathcost 60
#gcost 80
#enc 1
#mr 20
#end

-- Wyrm
#selectmonster 269
#prot 14
#def 14
#end

-- Medusa
#selectmonster 138
#hp 29
#end

-- Prince of Death
#selectmonster 383
#coldres 100
#poisonres 100
#end

-- Virtue
#selectmonster 215
#magicskill 1 1
#magicskill 4 1
#end


-----------
-- Giant --
-----------

-- All-Father
#selectmonster 501
#pathcost 50
#end

-- Asynja
#selectmonster 955
#descr "The Asynja is a female Aesir who has survived the death of her kin.  The Aesir were ancient gods who were defeated aeons ago by the Rimtursar in a cataclysmic battle.  The Asynja is a mighty warrior skilled in Nature and Astral magic."
#stealthy
#illusion
#startdom 2
#gcost 100
#clearmagic
#magicskill 6 1
#magicskill 4 1
#end

-- Cyclops
#selectmonster 156
#forgebonus 20
#descr "The Cyclops is a one-eyed giant sprung from the root of a great mountain.  The body of the Cyclops is huge and as hard as the rock from which it was born.  The Cyclops is a master of Earth magic and the secrets of the forge."
#end

-- Dagon
#selectmonster 109
#magicskill 2 3
#def 13
#end

-- Daughter of the Land
#selectmonster 385
#gcost 75
#magicskill 3 1
#end

-- Father of Serpents
#selectmonster 603
#def 15
#prec 14
#gcost 110
#weapon 89
#weapon 65
#end

-- Father of Serpents (Horned Serpents)
#selectmonster 403
#mor 30
#end

-- Great Mother
#selectmonster 606
#enc 3
#end

-- Jade Emperor
#selectmonster 905
#prot 10
#enc 3
#prec 13
#end

-- Lord of Fertility
#selectmonster 964
#magicskill 6 3
#poisonres 100
#awe 3
#end

-- Lord of the Desert Sun
#selectmonster 957
#def 15
#prec 14
#weapon 315
#weapon 998
#gcost 110
#end

-- Lord of the Desert Sun (Great Lions)
#selectmonster 628
#mor 30
#end

-- Lord of the Gates
#selectmonster 388
#magicskill 4 1
#coldres 100
#end

-- Lord of the Night
#selectmonster 604
#gcost 125
#end

-- Lord of the Wild
#selectmonster 812
#gcost 125
#end

-- Mother of Lions
#selectmonster 387
#weapon 16
#weapon 998
#end

-- Son of the Sea
#selectmonster 961
#mapmove 3
#magicskill 2 2
#magicskill 5 1
#gcost 100
#end

-- Son of the Sun (Astral)
#selectmonster 384
#gcost 75
#magicskill 0 1
#end

-- Son of the Sun (Fire)
#selectmonster 386
#gemprod 0 2
#descr "The Son of the Sun is a demigod of immense size claiming the divine heir of the sun.  Possessing considerable magical and physical might, the Son of the Sun is surrounded by an aura of splendor that strikes mortals with awe.  The sun has gifted its heir with such heat that once per season he receives two Fire gems."
#end

-- Titan (Female)
#selectmonster 600
#magicskill 6 2
#end

-- Titan (Male)
#selectmonster 602
#mapmove 3
#att 13
#def 13
#prec 13
#mountainsurvival
#gcost 110
#end

-- Void Lord
#selectmonster 652
#itemslots 15366
#startdom 3
#end


--------------
-- Immobile --
--------------

-- Colossal Head
#selectmonster 958
#magicskill 3 1
#reinvigoration 4
#end

-- Divine Glyph
#selectmonster 1025
#immortal
#gcost 60
#end

-- Fountain of Blood
#selectmonster 656
#hp 20
#clearspec
#startdom 4
#pathcost 30
#gcost 0
#fear 15
#inanimate
#immobile
#neednoteat
#douse 8
#gemprod 7 3
#itemslots 61440
#reinvigoration 4
#end

-- Oracle
#selectmonster 158
#hp 20
#clearspec
#gemprod 4 2
#startdom 4
#pathcost 30
#gcost 0
#inanimate
#immobile
#neednoteat
#itemslots 61440
#descr "The Oracle is a powerful spirit inhabiting a sacred spring.  The spirit possesses a girl to serve as the instrument of its will.  The chosen one is blinded and rendered unable to do anything but speak the will of the Oracle.  At the age of thirteen, she is sacrificed and replaced with a new girl, born the day the previous girl was made the voice of the spirit.  The Oracle is immobile and cannot leave the spring it inhabits.  It can possess willing targets to perform tasks such as forging items for enchantment.  The Oracle is tremendously strong in its Dominion and magically powerful.  Within its sacred waters heavenly light gathers to form two Astral pearls each season.  The spring can be destroyed, but not easily."
#reinvigoration 4
#end

-- Sacred Statue
#selectmonster 472
#gcost 40
#magicskill 4 2
#magicskill 2 1
#pathcost 20
#reinvigoration 4
#end

-- Monolith
#selectmonster 657
#clearspec
#gemprod 6 1
#startdom 4
#pathcost 40
#amphibian
#gcost 40
#poisonres 100
#inanimate
#immobile
#neednoteat
#itemslots 4096
#descr "The Monolith is a powerful spirit inhabiting a huge, standing stone.  The spirit cannot leave the Monolith, but it can possess willing targets in order to make its will heard and to perform tasks such as forging items for enchantment.  The spirit is tremendously strong in its Dominion, and it is also magically powerful.  In a physical battle, the stone would be difficult to destroy, even though it cannot strike back.  Druids perform monthly rituals of harvest and nature at the Monolith, focusing the energy into the form of one Nature gem during seasonal festivals."
#reinvigoration 4
#end

-- Void Lurker
#selectmonster 546
#clearspec
#gemprod 6 1
#startdom 4
#pathcost 15
#aquatic
#gcost 0
#poisonres 100
#neednoteat
#immobile
#magicbeing
#ethereal
#itemslots 28672
#descr "In the physical world, this being is just a large underwater fungus, but in the world of magic, the Void Lurker is one of the most powerful and ancient beings.  The Void Lurker can control the minds of willing targets to perform physical tasks such as forging and enchanting items.  The Void Lurker is immobile and saturated with the raw substance of magic.  Once per cycle crystals bud upon its surface and an Astral Pearl can be gathered from them."
#reinvigoration 4
#end

-- Sphinx
#selectmonster 159
#restrictedgod 1
#reinvigoration 4
#end


---------------------
-- Human (rainbow) --
---------------------

-- Bitch Queen
#selectmonster 401
#stealthy
#hp 34
#prec 10
#startdom 2
#end

-- Bitch Queen (Crone)
#selectmonster 402
#name "Hag"
#descr "The Hag is an old crone of such great power that she has taken the role of a Pretender God.  The Hag is a master of herbs and of magic and can be adept in several of the magic Paths. She posseses knowledge of a powerful vision hex."
#prec 13
#weapon 326
#weapon 332
#enc 2
#end

-- Freak Lord
#selectmonster 246
#enc 2
#hp 21
#magicskill 6 1
#magicskill 7 1
#gcost 25
#reinvigoration 3
#descr "The Freak Lord is a mage who has attained such power that he has mastered his own mortality. Donning a godly mantle, he has taken the role of Pretender God. The Freak Lord is a master of herbs and of magic and can be adept in several of the magic Paths. The Freak Lord rides and draws power from a horrifying Freak created with vile magic."
#end

-- Arch Druid
#selectmonster 245
#hp 21
#enc 2
#gcost 20
#researchbonus 5
#end

-- Arch Mage (Mounted)
#selectmonster 244
#hp 19
#enc 2
#gcost 150
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 1
#magicskill 5 1
#magicskill 6 1
#magicskill 7 1
#descr "The Arch mage is a mage who has attained such power that he has mastered his own mortality. Donning a godly mantle, he has taken the role of Pretender God. The Arch Mage is the highest master of magic, and is adept in all paths of magic."
#end

-- Arch Mage (Lobster)
#selectmonster 248
#hp 19
#enc 2
#startdom 2
#gcost 0
#researchbonus 5
#end

-- Arch Seraph
#selectmonster 509
#enc 2
#hp 17
#gcost 20
#armor "Ice Robe"
#researchbonus 5
#end

-- Crone
#selectmonster 249
#gcost 0
#name "Hag"
#descr "The Hag is an old crone of such great power that she has taken the role of a Pretender God.  The Hag is a master of herbs, allowing her to remedy disease and afflictions by administering potent unguents.  The Hag is also a master of magic and dabbles in many magic Paths."
#hp 12
#prec 13
#weapon 326
#enc 2
#healer 75
#researchbonus 5
#end

-- Divine Emperor
#selectmonster 874
#hp 18
#enc 1
#startdom 3
#gcost 35
#magicskill 1 1
#researchbonus 5
#end

-- Frost Father
#selectmonster 250
#name "Rime Mariner"
#descr "The Rime Mariner is a mage of such great power that he has mastered his own mortality.  Donning a godly mantle, he has taken the role of a Pretender God.  The Rime Mariner is a master of magic and can be adept in serveral of the Magic Paths."
#hp 18
#enc 1
#sailing
#gcost 10
#weapon 7
#weapon 131
#researchbonus 5
#end

-- Master Druid
#selectmonster 270
#gcost 15
#hp 18
#swampsurvival
#enc 1
#researchbonus 5
#descr "The Master Druid is a mage of such great power that he has mastered his own mortality. Donning a godly mantle, he has taken the role of a Pretender God. The Master Druid is a master of magic and can be adept in several magic paths. The Master Druid knows how to awaken the magic inhabitants of the forests and summons two extra Vine Men or Vine Ogres when casting the approptiate ritual spell."
#end

-- Great Sage
#selectmonster 251
#gcost 20
#hp 18
#enc 1
#researchbonus 25
#end

-- Great Enchantress
#selectmonster 485
#gcost 30
#hp 16
#ethereal
#enc 1
#researchbonus 5
#end

-- Great Seer of the Deeps
#selectmonster 873
#hp 18
#enc 1
#gcost 40
#magicskill 2 1
#startdom 2
#researchbonus 15
#descr "This Seer has such great power of magic and divination that he has mastered his own mortality.  Donning a godly mantle, he has taken the role of a Pretender God. He can use his divinatory visions to his advantage, and the province in which he dwells will have a reduced chance of bad events. The Great Seer of the Deeps is a master of magic research and can be adept in serveral of the magic Paths."
#end

-- Great Warlock
#selectmonster 486
#enc 1
#hp 23
#magicskill 0 1
#descr "The Great Warlock is a mage of such great power that he has mastered his own mortality.  Donning a godly mantle, he has taken the role of a Pretender God.  The Great Warlock is a master of magic and can be adept in several of the Magic Paths. The Great Warlock is a master at finding blood slaves for his rituals."
#weapon 7
#startdom 2
#gcost 40
#douse 5
#end

-- Master Alchemist
#selectmonster 550
#magicskill 3 1
#enc 1
#prec 12
#hp 19
#forgebonus 20
#gcost 60
#researchbonus 5
#end

-- Smoking Mirror
#selectmonster 857
#hp 19
#enc 1
#gcost 45
#end

-- Smoking Mirror (Jaguar)
#selectmonster 858
#hp 41
#enc 2
#mr 18
#prec 12
#end

-- Serpent King (Serpent)
#selectmonster 654
#hp 41
#enc 2
#def 10
#prec 12
#end

-- Serpent King
#selectmonster 653
#startdom 3
#enc 1
#hp 20
#gcost 40
#end

-- Skratti
#selectmonster 500
#magicskill 7 1
#name "Elder Skratti"
#descr "The Elder Skratti is a user of dark magics.  In ancient times, the Jotuns sacrificed blood to their ancestors, the Rimtursar.  The Elder Skratti still practices the old ways and has grown in power so that only Godhood bars his way to the Rimtursar.  The Skratti Elder is a master of magic and is very tough, but is not as strong as dragons or demi-gods."
#hp 42
#att 11
#def 11
#enc 2
#gcost 45
#end

-- Ghost King
#selectmonster 872
#gcost 110
#pathcost 30
#end

-- Master Lich
#selectmonster 180
#name "Arch Lich"
#descr "The Arch Lich is the dried husk of an Arch Mage adept in Death magic.  Through dark rituals, the mage succeeded in mastering one of mankind's oldest and most urgent goals: to defeat death.  By removing his viscera and hiding it outside his body, the Arch Lich is virtually impossible to slay.  Should the body be physically destroyed, a new one is formed from the dust of dead humans.  Being immortal, there is nothing left to acquire but godhood.  The Arch Lich lacks the Arch Mage's broad base of magical knowledge but his focus on Death has enabled him to distill two Death Gems per season from the recently deceased.  The Arch Lich's body is dry, brittle, and easily destroyed."
#gemprod 5 2
#gcost 110
#end

-- Saurolich
#selectmonster 320
#magicskill 5 2
#magicskill 0 1
#end

-- Lich
#selectmonster 179
#fireres -50
#gcost 90
#end

-- Lich Queen
#selectmonster 395
#gcost 100
#fireres -50
#end

-- Bog Mummy
#selectmonster 643
#fireres -25
#end

------------------------------------------------------------------------------------


---------------------
---------------------
--*****************--
--*               *--
--*  SPELLS 2.01  *--
--*               *--
--*****************--
---------------------
---------------------

-- SPELL MODIFICATIONS

---------------------
-- NATIONAL SPELLS --
---------------------

-- ERMOR

-- Acolyte of Eldregate
#selectspell "Revive Acolyte"
#fatiguecost 400
#end

-- Bishop of Eldregate
#selectspell "Revive Bishop"
#fatiguecost 1400
#end

-- Archbishop of Eldregate
#selectspell "Revive Arch Bishop"
#fatiguecost 2000
#end

-- Wailing Lady
#selectspell "Revive Wailing Lady"
#fatiguecost 800
#end

-- Censor
#selectspell "Revive Censor"
#fatiguecost 300
#end

-- Lictor
#selectspell "Revive Lictor"
#fatiguecost 600
#end


--ERMOR SOUL GATE

-- Shadow Tribune
#selectspell "Revive Shadow Tribune"
#fatiguecost 500
#end

-- Wraith Senator
#selectspell "Revive Wraith Senator"
#fatiguecost 1100
#end

-- Wraith Consul
#selectspell "Revive Wraith Consul"
#fatiguecost 2400
#end


-- TIEN CHI

#selectspell "Celestial Soldiers"
#pathlevel 0 1
#end

#selectspell "Celestial Servant"
#fatiguecost 200
#end

-- TIEN CHI SPRING & AUTUMN

#selectspell "Demon of Heavenly Rivers"
#end

#selectspell "Demon of Heavenly Fires"
#fatiguecost 200
#end


-- C'TIS DESERT TOMBS

-- Grave Consort
#selectspell "Revive Grave Consort"
#fatiguecost 500
#end 

-- Tomb Priest
#selectspell "Revive Tomb Priest"
#fatiguecost 1400
#end

-- Tomb King
#selectspell "Revive Tomb King"
#fatiguecost 2100
#end
---------------------------------------


-----------------
-- CONJURATION --
-----------------

-- LEVEL 2
----------

#selectspell "Summon Ice Drake"
#fatiguecost 800
#end

#selectspell "Summon Fire Drake"
#fatiguecost 800
#end

#selectspell "Summon Sea Serpent"
#fatiguecost 800
#end

#selectspell "Summon Cave Drake"
#fatiguecost 800
#end

#selectspell "Summon Animals"
#fatiguecost 500
#end

#selectspell "Summon Shades"
#fatiguecost 400
#end


-- LEVEL 4
----------

#selectspell "Summon Shade Beasts"
#fatiguecost 600
#end


-- LEVEL 5
----------

#selectspell "Will o' the Wisp"
#researchlevel 1
#end

#selectspell "Summon Fire Elemental"
#fatiguecost 100
#end

#selectspell "Summon Air Elemental"
#fatiguecost 100
#end

#selectspell "Summon Earth Elemental"
#fatiguecost 100
#end

#selectspell "Summon Water Elemental"
#fatiguecost 100
#end

#selectspell "Corpse Candle"
#fatiguecost 99
#pathlevel 0 2
#pathlevel 5 2
#end

#selectspell "Revive Bane Lord"
#fatiguecost 1500
#end

#selectspell "Raven Feast"
#fatiguecost 100
#end


-- LEVEL 6
----------

#selectspell "Summon Fire Snakes"
#fatiguecost 600
#end

#selectspell "Contact Harbinger"
#fatiguecost 2000
#end

#selectspell "Ether Gate"
#fatiguecost 8000
#end

#selectspell "Locust Swarms"
#fatiguecost 500
#end


-- LEVEL 7
----------

#selectspell "King of Elemental Fire"
#pathlevel 0 7
#end

#selectspell "King of Elemental Earth"
#pathlevel 0 7
#end

#selectspell "Queen of Elemental Air"
#pathlevel 0 7
#end

#selectspell "Queen of Elemental Water"
#pathlevel 0 7
#end

#selectspell "Angelic Host"
#fatiguecost 4500
#end

#selectspell "Call Wraith Lord"
#pathlevel 0 6
#end


-- LEVEL 8
----------

#selectspell "Living Fire"
#fatiguecost 100
#end

#selectspell "Living Clouds"
#fatiguecost 100
#end

#selectspell "Living Water"
#fatiguecost 100
#end

#selectspell "Living Earth"
#fatiguecost 100
#end


-- LEVEL 9
----------

#selectspell "Wild Hunt"
#fatiguecost 4000
#researchlevel 7
#end

#selectspell "Ghost Riders"
#pathlevel 0 6
#end

#selectspell "Enchanted Forest"
#fatiguecost 5000
#end

#selectspell "Tartarian Gate"
#fatiguecost 2500
#end
---------------------------------------


----------------
-- ALTERATION --
----------------


-- LEVEL 1
----------

#selectspell "Aim"
#precision 100
#end


-- LEVEL 4
----------

#selectspell "Blight"
#fatiguecost 400
#end


-- LEVEL 5
----------

#selectspell "Baleful Star"
#fatiguecost 200
#end


-- LEVEL 6
----------

#selectspell "Boil"
#pathlevel 0 2
#end

#selectspell "False Horror"
#fatiguecost 30
#end

#selectspell "Iron Pigs"
#fatiguecost 500
#end

#selectspell "Control"
#fatiguecost 80
#pathlevel 0 4
#end

#selectspell "Soul Vortex"
#pathlevel 0 5
#fatiguecost 20
#end


-- LEVEL 7
----------

#selectspell "Sea of Ice"
#fatiguecost 3200
#end

#selectspell "Bone Grinding"
#fatiguecost 99
#end

#selectspell "Transformation"
#fatiguecost 200
#end


-- LEVEL 8
----------

#selectspell "Crumble"
#fatiguecost 1000
#end

#selectspell "Quickening"
#fatiguecost 80
#end

#selectspell "Polymorph"
#fatiguecost 100
#pathlevel 0 4
#end


-- LEVEL 9
----------

#selectspell "Army of Gold"
#pathlevel 0 4
#researchlevel 7
#fatiguecost 400
#end

#selectspell "Army of Lead"
#pathlevel 0 5
#fatiguecost 500
#researchlevel 7
#end

#selectspell "Wish"
#fatiguecost 15000
#end
---------------------------------------


---------------
-- EVOCATION --
---------------


-- LEVEL 1
----------

#selectspell "Cold Bolt"
#precision 4
#end

#selectspell "Flame Bolt"
#precision 3
#end


-- LEVEL 3
----------

#selectspell "Acid Bolt"
#fatiguecost 20
#end

#selectspell "Freezing Mist"
#pathlevel 0 2
#end

#selectspell "Magic Duel"
#pathlevel 0 2
#fatiguecost 80
#end


-- LEVEL 4
----------

#selectspell "Fate of Oedipus"
#researchlevel 9
#end

#selectspell "Acid Rain"
#fatiguecost 20
#end

#selectspell "Breath of the Dragon"
#precision 3
#end


-- LEVEL 6
----------

#selectspell "Wrathful Skies"
#pathlevel 0 6
#fatiguecost 400
#end

#selectspell "Bane Fire"
#precision 3
#end

#selectspell "Stream of Life"
#precision 100
#end


-- LEVEL 7
----------

#selectspell "Fire Storm"
#pathlevel 0 6
#end

#selectspell "Cloud of Death"
#pathlevel 0 3
#end


-- LEVEL 8
----------

#selectspell "Second Sun"
#fatiguecost 35000
#end


-- LEVEL 9
----------

#selectspell "Tidal Wave"
#fatiguecost 1000
#end

#selectspell "Volcanic Eruption"
#fatiguecost 1000
#end
---------------------------------------


------------------
-- CONSTRUCTION --
------------------

-- LEVEL 3
----------

#selectspell "Legions of Steel"
#pathlevel 0 2
#end


-- LEVEL 7
----------

#selectspell "Weapons of Sharpness"
#pathlevel 0 4
#end

#selectspell "Forge of the Ancients"
#researchlevel 9
#pathlevel 0 6
#end


-- LEVEL 9
----------

#selectspell "Mechanical Militia"
#researchlevel 7
#end
---------------------------------------


-----------------
-- ENCHANTMENT --
-----------------

-- LEVEL 3
----------

#selectspell "Fire Ward"
#fatiguecost 80
#end

#selectspell "Heal"
#fatiguecost 10
#end

-- LEVEL 4
----------

#selectspell "Haste"
#fatiguecost 99
#end

#selectspell "Poison Ward"
#fatiguecost 80
#end

-- LEVEL 5
----------

#selectspell "Fire Fend"
#fatiguecost 80
#end

#selectspell "Thunder Ward"
#fatiguecost 80
#end

#selectspell "Watcher"
#fatiguecost 500
#end

#selectspell "Winter Ward"
#fatiguecost 80
#end

#selectspell "Undead Horde"
#pathlevel 0 3
#end

#selectspell "Faery Trod"
#pathlevel 0 4
#researchlevel 6
#fatiguecost 1500
#end

-- LEVEL 6
----------

#selectspell "Arrow Fend"
#researchlevel 7
#end

#selectspell "Riches from Beneath"
#fatiguecost 3000
#researchlevel 5
#end

#selectspell "Relief"
#fatiguecost 10
#end

-- LEVEL 7
----------

#selectspell "Ghost Ship Armada"
#fatiguecost 3500
#end

#selectspell "Awaken Treelord"
#pathlevel 0 7
#end

#selectspell "Serpent's Blessing"
#researchlevel 6
#end


-- LEVEL 8
----------

#selectspell "Warriors of Muspelheim"
#researchlevel 7
#end

#selectspell "Storm Warriors"
#researchlevel 7
#end

#selectspell "Warriors of Niefelheim"
#researchlevel 7
#end

#selectspell "Wrath of the Sea"
#fatiguecost 3000
#researchlevel 5
#end

#selectspell "Haunted Forest"
#researchlevel 8
#fatiguecost 8000
#pathlevel 1 2
#end

-- LEVEL 9
----------

#selectspell "Gaia's Blessing"
#researchlevel 8
#pathlevel 0 4
#fatiguecost 400
#end

#selectspell "Gift of Nature's Bounty"
#researchlevel 7
#fatiguecost 6000
#end

---------------------------------------

-----------------
-- THAUMATURGY --
-----------------

-- LEVEL 3
----------

#selectspell "Sailors' Death"
#precision 100
#end

-- LEVEL 4
----------

#selectspell "Touch of Madness"
#fatiguecost 80
#end


-- LEVEL 6
----------

#selectspell "Melancholia"
#fatiguecost 1000
#end

#selectspell "Foul Air"
#fatiguecost 3500
#end


-- LEVEL 7
----------

#selectspell "Dark Skies"
#path 0 0
#path 1 1
#pathlevel 0 4
#pathlevel 1 2
#fatiguecost 3000
#researchlevel 5
#end

#selectspell "Lure of the Deep"
#fatiguecost 4000
#end

#selectspell "Plague"
#researchlevel 5
#end


-- LEVEL 8
----------

#selectspell "Black Death"
#fatiguecost 1000
#end

---------------------------------------

-----------
-- BLOOD --
-----------

-- LEVEL 1
----------

#selectspell "Sabbath Master"
#fatiguecost 80
#end

#selectspell "Sabbath Slave"
#fatiguecost 40
#end

#selectspell "Blood Boil"
#fatiguecost 30
#end


-- LEVEL 2
----------

#selectspell "Agony"
#pathlevel 0 1
#end

#selectspell "Banish Demon"
#fatiguecost 99
#pathlevel 0 3
#end


-- LEVEL 3
----------

#selectspell "Bind Devil"
#fatiguecost 800
#end


-- LEVEL 4
----------

#selectspell "Hellfire"
#pathlevel 0 2
#fatiguecost 40
#end


-- LEVEL 5
----------

#selectspell "Bind Ice Devil"
#fatiguecost 7700
#researchlevel 6
#end


-- LEVEL 7
----------

#selectspell "Blood Rain"
#researchlevel 4
#end

#selectspell "Curse of Blood"
#fatiguecost 7700
#end


-- LEVEL 8
----------

#selectspell "Rush of Strength"
#researchlevel 3
#end

#selectspell "The Looming Hell"
#researchlevel 5
#end


-- LEVEL 9
----------

#selectspell "Infernal Crusade"
#fatiguecost 4000
#end


---------------------------------------


---------------------------
-- MONSTER MODIFICATIONS --
---------------------------

-- NATIONAL SUMMONS

-- Celestial Soldier
#selectmonster 902
#prot 8
#end

-- Celestial Servant
#selectmonster 903
#att 11
#def 11
#end

-- Demon Jester
#selectmonster 1000
#prot 8
#weapon 33
#weapon 997
#end

--------------------------

-- Fire Drake
#selectmonster 523
#att 13
#prec 10
#ap 14
#mapmove 2
#end

-- Ice Drake
#selectmonster 579
#att 13
#prec 10
#ap 14
#mountainsurvival
#mapmove 2
#end

-- Cave Drake
#selectmonster 522
#att 13
#ap 14
#mapmove 2
#end

-- Horned Serpent
#selectmonster 403
#hp 34
#ap 12
#prot 13
#mapmove 2
#end

-- Great Lion
#selectmonster 628
#hp 28
#def 13
#end

-- Iron Pig
#selectmonster 924
#mr 14
#att 10
#def 10
#end

-- Kraken
#selectmonster 438
#att 13
#poisonres 100
#heal
#end

-- Troll
#selectmonster 518
#att 13
#gcost 15
#end

-- Sea Troll
#selectmonster 564
#att 13
#weapon 29
#gcost 15
#end

-- Troll King
#selectmonster 519
#att 15
#end

-- Sea King
#selectmonster 580
#att 14
#end

-- Hama Dryad
#selectmonster 932
#prot 10
#fireres -25
#weapon 284
#mapmove 0
#end

-- Firbolg
#selectmonster 559
#reinvigoration 4
#end

-- Dracaconian Chief
#selectmonster 620
#magicskill 6 2
#end

-- Bog Beast
#selectmonster 578
#mapmove 2
#end

-- Harvester of Sorrows
#selectmonster 491
#stealthy +15
#end

-- Tarrasque
#selectmonster 925
#mapmove 2
#prot 23
#prec 12
#weapon 29
#weapon 998
#weapon 62
#end

--------------------------

-- VINE CREATURES

-- Vine Man
#selectmonster 361
#prot 10
#fireres -25
#end

-- Vine Ogre
#selectmonster 362
#prot 10
#fireres -25
#end

-- Ivy King
#selectmonster 931
#prot 10
#def 10
#prec 5
#end

--------------------------

-- SEASONAL SPIRITS

-- Winter Wolf
#selectmonster 511
#prot 5
#hp 20
#str 13
#stealthy
#end

-- Fall Bear
#selectmonster 512
#prot 5
#att 13
#weapon 29
#weapon 29
#end

-- Spring Hawk
#selectmonster 513
#hp 10
#prot 5
#end

-- Summer Lion
#selectmonster 515
#prot 5
#fireshield 3
#end

--------------------------

-- CONSTRUCTS

-- Corpse Construct
#selectmonster 534
#shockres 100
#hp 30
#prot 5
#mr 14
#att 12
#def 10
#weapon 231
#weapon 92
#end

-- Lumber Construct
#selectmonster 476
#att 12
#weapon 90
#end

-- Mandragora
#selectmonster 314
#entangle
#end

--------------------------

-- ICE DEVILS

-- Nycafor
#selectmonster 306
#fireres -50
#end

-- Oriax
#selectmonster 821
#fireres -50
#end

-- Gaap
#selectmonster 822
#fireres 50
#end

-- Bifrons
#selectmonster 823
#fireres -50
#end

-- Cimejes
#selectmonster 824
#fireres -50
#end

-- Bune
#selectmonster 825
#fireres -50
#end

--------------------------

-- HELIOPHAGI

-- Mastema
#selectmonster 492
#hp 76
#ethereal
#fireres 100
#prot 15
#end

-- Amaimon
#selectmonster 818
#descr "The Heliophagii are the Lords of the Abyss.  They are composed of solid darkness except for their golden claws and horns.  They have the ability to become invisible in shadows, and they are all skilled in Blood Magic.  Amaimon is a formidable general and a mighty Fire mage.  His realm is a dark and hot place.  Amaimon wields a flaming whip and is resistant to heat and flames."
#hp 76
#ethereal
#fireres 100
#prot 15
#heat
#end

-- Gorilon
#selectmonster 819
#hp 76
#ethereal
#fireres 100
#prot 15
#end

-- Mabakiel
#selectmonster 820
#hp 76
#ethereal
#fireres 100
#prot 15
#end


-- Pazuzu, Lord of the Plague Wind
#selectmonster 446
#hp 108
#end

--------------------------

-- EARTH ELEMENTALS

#selectmonster 493
#prot 15
#end

#selectmonster 495
#prot 15
#end

#selectmonster 496
#prot 15
#end

#selectmonster 498
#prot 15
#end

#selectmonster 497
#prot 15
#end

#selectmonster 494
#prot 15
#end

--------------------------

-- WATER ELEMENTALS

#selectmonster 408
#def 17
#end

#selectmonster 409
#def 16
#end

#selectmonster 410
#def 15
#end

#selectmonster 411
#def 14
#end

#selectmonster 412
#def 13
#end

#selectmonster 413
#def 12
#end

--------------------------

-- ICE ELEMENTALS

#selectmonster 831
#clearspec
#cold
#iceprot
#fireres -50
#coldres 100
#amphibian
#magicbeing
#neednoteat
#poisonres 100
#weapon 69
#weapon 69
#secondshape 832
#end

#selectmonster 832
#clearspec
#cold
#iceprot
#fireres -50
#coldres 100
#amphibian
#magicbeing
#neednoteat
#poisonres 100
#weapon 69
#weapon 69
#secondshape 833
#end

#selectmonster 833
#clearspec
#cold
#iceprot
#fireres -50
#coldres 100
#amphibian
#magicbeing
#neednoteat
#poisonres 100
#weapon 69
#secondshape 834
#end

#selectmonster 834
#clearspec
#cold
#iceprot
#fireres -50
#coldres 100
#amphibian
#magicbeing
#neednoteat
#poisonres 100
#weapon 69
#secondshape 835
#end

#selectmonster 835
#clearspec
#cold
#iceprot
#fireres -50
#coldres 100
#amphibian
#magicbeing
#neednoteat
#poisonres 100
#weapon 69
#secondshape 836
#end

#selectmonster 836
#clearspec
#cold
#iceprot
#fireres -50
#coldres 100
#amphibian
#magicbeing
#neednoteat
#poisonres 100
#weapon 69
#end

--------------------------

-- KINGS OF ELEMENTAL EARTH

-- Oreigenes, King of Mountains
#selectmonster 469
#enc 0
#regeneration 10
#end

-- Barathrus, King of Deeper Earth
#selectmonster 906
#enc 0
#end

-- Pedoseion, Father IllEarth
#selectmonster 470
#enc 0
#end

--------------------------

-- KINGS OF ELEMENTAL FIRE

-- Pyriphlogos, King of Flames
#selectmonster 631
#hp 76
#att 15
#def 14
#end

-- Rhuax, King of Magma
#selectmonster 910
#att 15
#def 14
#end

-- Anthrax, King of Banefires
#selectmonster 909
#hp 76
#att 15
#def 14
#end

--------------------------

-- TREELORD(S)

#selectmonster 621
#clearspec
#name "Ageless Treelord"
#descr "The Treelords are ancient sentient trees that were once vibrant and powerful. Now they are dormant, getting slower of mind and body with each passing year. These decaying Treelords can be reawakened by the use of nature magic, though all but a handful have passed this point. The Ageless Treelord has avoided the fate of many of his kin by his close ties to the ageless earth. His great roots draw both nutrients and power from the earth, creating two nature and three earth gems each season. Treelords are sacred to vine men, and as a result, they can awaken vine men in greater numbers than can other mages. There are only three Treelords remaining to be awakened." 
#str 25
#att 15
#prec 10
#expertleader
#expertmagicleader
#fireres -25
#poisonres 100
#magicskill 6 4
#magicskill 3 2
#gemprod 6 3
#gemprod 3 2
#heal
#entangle
#itemslots 12288
#forestsurvival
#neednoteat
#reinvigoration 5
#end

#selectmonster 980
#clearspec
#name "Vengeful Treelord"
#descr "The Treelords are ancient sentient trees that were once vibrant and powerful. Now they are dormant, getting slower of mind and body with each passing year. These decaying Treelords can be reawakened by the use of nature magic, though all but a handful have passed this point. The Vengeful Treelord's great anger at those who have disturbed the ancient forests has slowed his passage toward the long decay of his kin. He leeches power in the form of four nature gems a season from the land in which he resides. He also draws to him those unfortunate enough to tresspass in his forest, to be used in his dark rituals. Treelords are sacred to vine men, and as a result, they can awaken vine men in greater numbers than can other mages. There are only three Treelords remaining to be awakened."
#str 25
#att 15
#prec 10
#expertleader
#expertmagicleader
#fireres -25
#poisonres 100
#magicskill 6 4
#magicskill 7 2
#gemprod 6 3
#gemprod 7 4
#heal
#entangle
#itemslots 12288
#forestsurvival
#neednoteat
#reinvigoration 5
#end

-- Dying Treelord
#selectmonster 981
#clearspec
#descr "The Treelords are ancient sentient trees that were once vibrant and powerful. Now they are dormant, getting slower of mind and body with each passing year. These decaying Treelords can be reawakened by the use of nature magic, though all but a handful have passed this point. The Dying Treelord is the oldest, purest Treelord, now finally reaching the end of his lifespan. He acts as the voice of all trees and is rewarded with the gift of six nature gems each season. Treelords are sacred to vine men, and as a result, they can awaken vine men in greater numbers than can other mages. There are only three Treelords remaining to be awakened."
#str 25
#att 15
#prec 10
#prot 20
#expertleader
#expertmagicleader
#fireres -25
#poisonres 100
#magicskill 6 6
#gemprod 6 6
#entangle
#itemslots 12288
#forestsurvival
#neednoteat
#reinvigoration 5
#end

--------------------------

-- ANGELIC BEINGS

-- Harbinger
#selectmonster 464
#att 15
#weapon 202
#weapon 145
#armor "Divine Garb"
#end

-- Arch Angel
#selectmonster 465
#att 14
#armor "Divine Garb"
#end

-- Angel of the Host
#selectmonster 543
#att 14
#armor "Divine Garb"
#end

-- Fallen Angel
#selectmonster 626
#att 14
#armor "Divine Garb"
#end

-- Lammashta
#selectmonster 393
#end

--------------------------

-- TARTARIAN BEINGS

-- Tartarian Monstrum
#selectmonster 776
#itemslots 12544
#weapon 144
#weapon 29
#weapon 999
#end

-- Tartarian Monstra
#selectmonster 777
#mounted
#itemslots 13574
#end

--------------------------


-- Eater of the Dead
#selectmonster 994
#mr 20
#hp 120
#prot 8
#end

#selectmonster 995
#regen 20
#mr 20
#hp 160
#prot 10
#end

#selectmonster 996
#regen 30
#mr 20
#hp 200
#prot 12
#end

#selectmonster 997
#regen 50
#mr 20
#hp 240
#prot 14
#end
--------------------------


-- Demons

-- Devil
#selectmonster 304
#mor 18
#end

-- Serpent Fiend-
#selectmonster 526
#prot 10
#hp 24
#end

-- Storm Demon
#selectmonster 632
#mor 18
#end

-- Spine Devil
#selectmonster 638
#mor 18
#end

-- Demon Knight
#selectmonster 489
#mor 18
#end

-- Frost Fiend
#selectmonster 449
#mor 18
#end

-- Fiend of Darkness
#selectmonster 88
#mor 18
#end

------------------------------------------------------------------------------------


----------------------
----------------------
--******************--
--*                *--
--*  nations 1.11  *--
--*                *--
--******************--
----------------------
----------------------


------------
-- ABYSIA --
------------

-- Humanbred - spear & shield
#selectmonster 372
#gcost 8
#mountainsurvival
#enc 2
#end

-- Humanbred - axe & shield
#selectmonster 983
#gcost 8
#mountainsurvival
#enc 2
#end

-- Abysian Infantry - battleaxe
#selectmonster 81
#gcost 18
#end

-- Abysian Infantry - flail
#selectmonster 82
#gcost 18
#end

-- Salamander
#selectmonster 213
#gcost 55
#end

-- Lava Warrior
#selectmonster 90
#gcost 45
#end

-- Beast Trainer
#selectmonster 214
#gcost 45
#end

-- Anathemant Salamander
#selectmonster 85
#gcost 190
#end

-- Warlord
#selectmonster 119
#mountainsurvival
#end


-- Abysia Blood of Humans
-------------------------

-- Axe Thrower
#selectmonster 1090
#enc 2
#gcost 10
#end

-- Abysian Light Infantry - spear & shield
#selectmonster 984
#gcost 7
#mountainsurvival
#enc 2
#end

-- Abysian Light Infantry - axe & shield
#selectmonster 985
#gcost 7
#mountainsurvival
#enc 2
#end

-- Abysian Heavy Infantry - axe & shield
#selectmonster 986
#enc 2
#gcost 11
#end

-- Abysian Heavy Infantry - morningstar & shield
#selectmonster 987
#enc 2
#gcost 11
#end

-- Abysian Heavy Infantry - battleaxe
#selectmonster 988
#enc 2
#gcost 10
#end

-- Abysian Heavy Infantry - flail
#selectmonster 989
#enc 2
#gcost 10
#end

-- Guardian of the Pyre
#selectmonster 990
#descr "With the dilution of the blood, pureblooded Abysians have become exceedingly rare. The remaining Abysians are highly respected and considered holy to the Humanbreed Abysians. They are trained as priests or scared warriors. Guardians of the Pyre are pureblooded Abysians and radiate heat. The innovation of Humanbreed mage-priests has resulted in the forgeing of new shields endowed with enough fire magic to damage nearby enemies"
#fireshield 5
#armor 14 --Plate Hauberk
#armor 20 --Helmet
#armor 273 --Shield of the Pyre
#end

-- Newt
#selectmonster 991
#name "Anathemant Newt"
#researchbonus 2
#end

-- Commander
#selectmonster 992
#mountainsurvival
#end

-- Sanguine Anathemant
#selectmonster 1092
#magicskill 51 1
#descr "With the magic heat of the Smouldercone seeping from the land, the anathemants are looking for other sources of power. The ancient practice of blood sacrifice was renewed and a new order of anathemants was formed. Only pure blood abysians are allowed to gain full priestly status in the order. The Sanguine Anathemants have the priestly powers of the regular anathements and are in charge of the growing blood cult. They are are more magicaly versatile than the the old priestly orders."
#end
-------------------------------------------------------


------------------
-- ARCOSCEPHALE --
------------------

-- Slinger, militias, light cavalries, heavy cavalry: see Independents


-- Peltast
#selectmonster 201
#gcost 6
#def 11
#swampsurvival
#forestsurvival
#mountainsurvival
#descr "The Peltasts are the light infantry of Arcoscephale. They have almost no armour and are mainly used as javelin throwers and for foraging in rough lands."
#end

-- Cardaces
#selectmonster 199
#gcost 5
#def 11
#swampsurvival
#forestsurvival
#mountainsurvival
#descr "The Cardaces are essentially light infantry without javelins. They are somewhat better armed than the Peltasts but serve mostly the same role."
#end

-- Hoplite

-- Elephant
#selectmonster 150
#end

-- Hypaspist
#selectmonster 16
#gcost 13
#end

-- Chariot
#selectmonster 200
#gcost 20
#end

-- Heartcompanion


-- GOLDEN AGE
-------------

-- Chariot
#selectmonster 1078
#gcost 20
#rcost 26
#end

-- Chariot Archer
#selectmonster 1079
#gcost 25
#rcost 16
#end

-- Icarid
#selectmonster 1082
#gcost 11
#rcost 20
#end

-- Myrmidon
#selectmonster 1077
#gcost 13
#mor 18
#end

-- Wind Rider
#selectmonster 1074
#awe 1
#mountainsurvival
#end

-- Myrmidon Champion
#selectmonster 1076
#end

-- Chariot Commander
#selectmonster 1081
#gcost 50
#rcost 26
#end

-- Wind Lord
#selectmonster 1075
#awe 1
#magicskill 8 2
#mountainsurvival
#end

-- Icarid Champion
#selectmonster 1083
#gcost 45
#rcost 20
#end

-- Sceptic
#selectmonster 1071
#gcost 25
#spy
#end
-------------------------------------------------------


-------------
-- ATLANTIS-- 
-------------

-- Shambler
#selectmonster 206
#mor 18
#gcost 20
#end

-- War Shambler
#selectmonster 208
#mor 18
#end

-- Atlantian Spearman
#selectmonster 110
#gcost 4
#end

-- Atlantian Spearman w/shield
#selectmonster 111
#gcost 5
#end
-------------------------------------------------------


-----------
-- R'LYEH-- 
-----------

-- Slave Trooper
#selectmonster 335
#gcost 4
#end

-- Hybrid Trooper
#selectmonster 970
#gcost 9
#end

-- Hybrid Soldier
#selectmonster 971
#gcost 11
#end

-- Illithid Soldier
#selectmonster 407
#def 8
#att 12
#hp 30
#mor 12
#end

-- Illithid Lord
#selectmonster 445
#def 8
#att 12
#hp 32
#mor 13
#end
-------------------------------------------------------


------------
-- CAELUM --
------------

-- Spire Horn Warrior
#selectmonster 129
#gcost 8
#mountainsurvival
#end

-- Spire Horn Warrior (better Armor)
#selectmonster 131
#gcost 9
#mountainsurvival
#end

-- Caelian Archer
#selectmonster 128
#end

-- Blizzard Warrior
#selectmonster 127
#end

-- Caelian Light Infantry
#selectmonster 130
#mountainsurvival
#end

-- Caelian Infantry
#selectmonster 420
#gcost 11
#end

-- Storm Guard
#selectmonster 421
#end

-- Iceclad
#selectmonster 132
#end

-- Temple Guard
#selectmonster 358
#gcost 15
#end

-- Mammoth
#selectmonster 419
#end

-- Wingless
#selectmonster 414
#end

-- Storm General
#selectmonster 418
#mountainsurvival
#end

-- Seraph
#selectmonster 202
#gcost 110
#descr "The Seraphs are the ruling mages of Caelum. They craft the ice armour and ice weapons of Caelum, and settle judicial affairs of the populace. They wear robes of ice, which while unrestictive and offering good protection are tireing to wear. The Seraphs are skilled Air mages and know some water magic. They disdain leading ordinary troops."
#clearmagic
#magicskill 1 2
#magicskill 2 1
#enc 5
#armor "Ice Robe"
#rcost 10
#end

-- High Seraph
#selectmonster 203
#descr "The Seraphs are the ruling mages of Caelum. They craft the ice armour and ice weapons of Caelum, and settle judicial affairs of the populace. They wear robes of ice, which while unrestrictve and offering good protection are tiring to wear. The Seraphs are skilled Air mages and know some water magic. They disdain leading ordinary troops."
#clearmagic
#gcost 200
#magicskill 2 2
#magicskill 1 2
#magicskill 51 1
#enc 7
#rcost 10
#armor "Ice Robe"
#end


-- RETURN OF THE RAPTORS
------------------------

-- Raptor
#selectmonster 205
#gcost 8
#end

-- Raven Guard
#selectmonster 949
#gcost 11
#def 12
#mor 14
#mr 12
#end

-- Seraph
#selectmonster 1004
#descr "The Seraphs are the ruling mages of Caelum. They craft the ice armour and ice weapons of Caelum, and settle judicial affairs of the populace. They wear robes of ice, which while unrestrictive and offering good protection, are tiring to wear. The Seraphs are skilled Air mages and know some water magic. They disdain leading ordinary troops."
#clearmagic
#magicskill 1 2
#magicskill 2 1
#enc 5
#rcost 10
#gcost 130
#armor "Ice Robe"
#end

-- Harab Seraph
#selectmonster 951
#enc 5
#end

-- Harab Elder
#selectmonster 1003
#enc 10
#end
-------------------------------------------------------


-----------
-- C'TIS --
-----------

-- Militia
#selectmonster 168
#gcost 3
#end

-- Light Infantry
#selectmonster 167
#mountainsurvival
#forestsurvival
#descr "The Light Infantry of C'tis are armed with spears and javelins. For protection, they rely on their scaly skin and round shields. They fill the role of foragers when the armies of C'tis are forced to leave their swampy homeland. They have partial resistance to poison."
#gcost 6
#def 11
#end

-- City Guard
#selectmonster 166
#end

-- Heavy Infantry
#selectmonster 165
#gcost 9
#end

-- Falchioneer
#selectmonster 504
#gcost 10
#end

-- Slave Warrior
#selectmonster 171
#gcost 6
#str 12
#att 12
#end

-- Elite Warrior
#selectmonster 172
#gcost 10
#str 12
#att 12
#end

-- Runner
#selectmonster 173
#gcost 8-
#ap 18
#end

-- Sacred Serpent
#selectmonster 295
#gcost 32
#poisonres 100
#end

-- Swamp Guard
#selectmonster 164
#end

-- Poison Slinger
#selectmonster 503
#gcost 18
#end

-- Lizard King
#selectmonster 177
#end

-- Commander of C'tis
#selectmonster 163
#mountainsurvival
#forestsurvival
#def 11
#descr "Since the Lizard Lords consider it beneath them to engange in daily logistics and management, it falls to the commanders of C'tis to conduct troop deployment and supply."
#end

-- MIASMA
---------

-- DESERT TOMBS
---------------

-- Desert Ranger
#selectmonster 1094
#gcost 11
#end

-- Tomb Guard
#selectmonster 1096
#gcost 12
#end

-- Keeper of the Tombs
#selectmonster 1095
#holy
#end
-------------------------------------------------------


-------------------------
-- ERMOR BROKEN EMPIRE --
-------------------------

-- Velite
#selectmonster 662
#gcost 8
#end

-- Alae Legionaire
#selectmonster 663
#end

-- Hastatus
#selectmonster 664
#gcost 11
#end

-- Principe
#selectmonster 665
#end

-- Triari
#selectmonster 666
#end

-- Praetorian
#selectmonster 667
#end

-- Standard
#selectmonster 668
#gcost 15
#end

-- Thaumaturg
#selectmonster 669
#gcost 110
#end

-- Grand Thaumaturg
#selectmonster 670
#magicskill 5 3
#end

-- Shadow Vestals
#selectmonster 809
#descr "Shadow Vestals are the result of a dark rite known as shadow merging. Young girls are trained in the Temple of the Dead to prepare them for the merging. When ready, a girl surrenders her self and is merged with the ghost of an ancient Vestal Virgin. Should the body die, both will be reborn in their ethereal, part living, part dead state. They are sacred and can be blessed."
#immortal
#mr 11
#end


-- ERMOR ASHEN EMPIRE
---------------------


-------------------------------------------------------


---------------
-- JOTUNHEIM --
---------------

-- IRON WOODS
-------------

-- Jotun Militia
#selectmonster 277
#cost 16
#end

-- Jotun  Javelinist
#selectmonster 276
#gcost 20
#end

-- Jotun Axemen
#selectmonster 279
#end

-- Jotun Spearmen
#selectmonster 278
#end

-- Jotun Hurler
#selectmonster 300
#gcost 22
#end

-- Jotun Huskarl - jotun axe
#selectmonster 840
#gcost 30
#end

-- Jotun Huskarl - jotun axe
#selectmonster 841
#gcost 30
#end

-- Jotun Hirdman
#selectmonster 842
#gcost 34
#end

-- Vaetti
#selectmonster 541
#end

-- Wolf Rider
#selectmonster 282
#gcost 18
#end

-- Moose Rider
#selectmonster 1085
#gcost 30
#end

-- Jotun Woodsman
#selectmonster 784
#end


-- UTGARD
---------

-- Huskarl - axe
#selectmonster 837
#gcost 8
#end

-- Huskarl - spear
#selectmonster 838
#gcost 8
#end


-- NIEFELHEIM
-------------

-- Niefel Giant
#selectmonster 845
#end
-------------------------------------------------------


-------------
-- MACHAKA --
-------------

-- Militia
#selectmonster 878
#gcost 3
#end

-- Archer
#selectmonster 879
#end

-- Warrior
#selectmonster 880
#gcost 5
#descr "Light infantry are armed with spear and javelin and trained for survival."
#mountainsurvival
#swampsurvival
#wastesurvival
#def 11
#end

-- Machaka Hoplite
#selectmonster 882
#end

-- Spider Rider
#selectmonster 885
#gcost 26
#end

-- Spider Knight
#selectmonster 886
#gcost 45
#weapon 313
#weapon "Light Lance"
#weapon 262
#end

-- Hunter Spider
#selectmonster 889
#end

-- Spider Warrior
#selectmonster 876
#gcost 15
#end

-- Spider Lord
#selectmonster 887
#gcost 60
#end

-- Hunter Lord
#selectmonster 890
#gcost 160
#end

-- Bane Spider
#selectmonster 877
#gcost 80
#end

-- Chief
#selectmonster 881
#mountainsurvival
#swampsurvival
#wastesurvival
#end
-------------------------------------------------------


---------
-- MAN --
---------

-- Militias & slinger: see Independents

-- Spearman
#selectmonster 61
#gcost 5
#end

-- Longspear
#selectmonster 62
#gcost 9
#end

-- Axeman
#selectmonster 53
#gcost 9
#end

-- Tower Guard
#selectmonster 63
#gcost 12
#end

-- Longbowman
#selectmonster 59
#end

-- Light cavalry
#selectmonster 26
#gcost 14
#def 11
#end

-- Warden of Avalon
#selectmonster 65
#end

-- Knight
#selectmonster 57
#gcost 55
#end

-- Knight of Avalon
#selectmonster 64
#end

-- Lord Warden
#selectmonster 212
#gcost 100
#end

-- LAST OF TUATHA
-----------------

-- Cu Sidhe
#selectmonster 851
#gcost 12
#end

-- Daoine Sidhe
#selectmonster 849
#end
-----------------------------------------


--------------
-- MARIGNON --
--------------

-- Crossbowman
#selectmonster 218
#end

-- Swordsman
#selectmonster 219
#gcost 9
#end

-- Halberdier
#selectmonster 220
#gcost 9
#end

-- Pikeneer
#selectmonster 221
#gcost 8
#end

-- Man at Arms
#selectmonster 133
#gcost 13
#end

-- Flagellant
#selectmonster 217
#end

-- Royal Guard
#selectmonster 134
#gcost 45
#rcost 45
#end

-- Knight of the Chalice
#selectmonster 135
#end 

-- Paladin
#selectmonster 440
#gcost 110
#end

-- FIRES OF THE FAITH
---------------------

-- same as base Marignon


-- DIABOLICAL FAITH
-------------------


-- CONQUERORS OF THE SEA
------------------------

-- Captain
#selectmonster 1029
#gcost 50
#end

-- Admiral
#selectmonster 1030
#gcost 75
#end

-- Missionary
#selectmonster 1033
#gcost 45
#stealthy +0
#end

-- Chartmaker
#selectmonster 1031
#gcost 80
#end 

-- Royal Navigator
#selectmonster 1032
#gcost 190
#end
-----------------------------------------


-------------
-- MICTLAN --
-------------

-- Slave
#selectmonster 720
#gcost 0
#end

-- Warrior with sling
#selectmonster 721
#gcost 4
#forestsurvival
#swampsurvival
#end

-- Warrior with armor + sling
#selectmonster 722
#gcost 5
#forestsurvival
#swampsurvival
#end

-- Warrior with spear + javelin
#selectmonster 723
#gcost 6
#forestsurvival
#swampsurvival
#end

-- Warrior with mace + javelin
#selectmonster 724
#gcost 8
#forestsurvival
#swampsurvival
#end

-- Feathered Warrior
#selectmonster 860
#gcost 11
#forestsurvival
#swampsurvival
#end

-- Jaguar Warrior
#selectmonster 727
#forestsurvival
#swampsurvival
#end

-- Eagle Warrior
#selectmonster 726
#forestsurvival
#swampsurvival
#end

-- Sun Warrior
#selectmonster 725
#forestsurvival
#swampsurvival
#end

-- Tribal King
#selectmonster 730
#forestsurvival
#swampsurvival
#end

-- Priest King
#selectmonster 732
#swampsurvival
#end
-----------------------------------------


-------------
-- PANGAEA --
-------------

-- STANDARD
-----------

-- Harpy
#selectmonster 239
#gcost 5
#end

-- Satyr
#selectmonster 227
#gcost 5
#end

-- Satyr with javelin
#selectmonster 228
#gcost 7
#end

-- Satyr with Spear + buckler
#selectmonster 229
#gcost 6
#end

-- Satyr Hoplite
#selectmonster 230
#end

-- Reveler
#selectmonster 708
#gcost 12
#end

-- Minotaur
#selectmonster 234
#gcost 18
 #att 10
#end

-- War Minotaur
#selectmonster 235
#gcost 30
#att 10
#end

-- Centaur
#selectmonster 27
#gcost 21
#end

-- Centaur Warrior
#selectmonster 707
#end

-- Centaur Cataphract
#selectmonster 233
#gcost 35
#end

-- White Centaur
#selectmonster 769
#end

-- Maenad
#selectmonster 435
#end


-- NEW ERA
--------------

-- Dryad
#selectmonster 705
#gcost 90
#end

-- Hoplite
#selectmonster 697
#end

-- Centaur Cataphract
#selectmonster 698
#end

-- Minotaur Soldier
#selectmonster 700
#gcost 20
#att 10
#end

-- Grove Guard
#selectmonster 702
#gcost 35
#end

-- Keeper of Traditions
#selectmonster 703
#magicskill 8 3
#end

-- Minotaur Commander
#selectmonster 701
#gcost 50
#end

-Cataphract Commander-
#selectmonster 699
#gcost 60
#end


-- CARRION WOODS
----------------

-- Black Centaur
#selectmonster 787
#end-- 

-- Minotaur Lord
#selectmonster 236
#gcost 50
#end

-- Centaur Commander
#selectmonster 232
#gcost 60
#end

-- Carrion Centaur
#selectspell "Carrion Centaur"
#fatiguecost 800
#end

-- Carrion Lady
#selectspell "Carrion Lady"
#fatiguecost 1500
#end

-- Carrion Lord
#selectspell "Carrion Lord"
#end
-----------------------------------------


-------------
-- VANHEIM --
-------------

-- Huskarl - axe
#selectmonster 142
#gcost 8
#end

-- Huskarl - spear
#selectmonster 143
#gcost 8
#end

-- Hirdman - spear
#selectmonster 144
#gcost 11
#end

-- Hirdman - broadsword
#selectmonster 145
#gcost 11
#end

-- Skinshifter
#selectmonster 400
#gcost 23
#end

-- Einhere
#selectmonster 146
#gcost 19
#end

-- Van
#selectmonster 262
#end

-- Fay Boar
#selectmonster 463
#gcost 60
#end

-- Valkyrie
#selectmonster 261
#end

-- HELHEIM
----------

-- Valkyrie
#selectmonster 855
#fear -1
#end

-- Svartalf
#selectmonster 1010
#gcost 165
#end

-- Hangadrott
#selectmonster 847
#fear -1
#end


-- MIDGARD
----------

-- Skinshifter
#selectmonster 853
#gcost 19
#end
-----------------------------------------


-------------
-- PYTHIUM --
-------------

-- Velite
#selectmonster 684
#gcost 8
#end

-- Alae Legionaire
#selectmonster 685
#end

-- Hastatus
#selectmonster 686
#gcost 11
#end

-- Principe
#selectmonster 687
#end

-- Triarius
#selectmonster 688
#end

-- Emerald Lord
#selectmonster 6
#gcost 80
#end

-- Standard
#selectmonster 689
#gcost 15
#end

-- Serpent Cataphract
#selectmonster 3
#gcost 50
#end

-- Gladiator - trident
#selectmonster 11
#gcost 5
#end

-- Gladiator - flail
#selectmonster 12
#gcost 5
#end

-- Battle Vestal
#selectmonster 51
#end

-- Hydra Hatchling
#selectmonster 719
#gcost 35
#end

-- Hydra
#selectmonster 91
#gcost 175
#end

-- Hydra Tamer
#selectmonster 296
#gcost 30
#end

-- Serpent Lord
#selectmonster 5
#gcost 80
#end


-- SERPENT CULT
---------------

-- Hydra Hatchling
#selectmonster 767
#gcost 50
#end

-- Hydra
#selectmonster 766
#gcost 250
#end

-- Serpent Cataphract
#selectmonster 763
#gcost 55
#end

-- Serpent Acolyte
#selectmonster 830
#gcost 70
#end

-- Serpent Priest
#selectmonster 761
#gcost 175
#end

-- Serpent Lord
#selectmonster 765
#gcost 90
#end
-----------------------------------------


---------
-- ULM --
---------

-- Crossbowman
#selectmonster 417
#end

-- Infantry of Ulm - battleaxe
#selectmonster 67
#gcost 8
#end

-- Black Plate Infantry - battleaxe
#selectmonster 68
#gcost 9
#end

-- Infantry of Ulm - flail
#selectmonster 71
#gcost 8
#end

-- Black Plate Infantry - flail
#selectmonster 72
#gcost 9
#end

-- Infantry of Ulm - hammer & shield
#selectmonster 73
#gcost 9
#end-- 

-- Black Plate Infantry - hammer & shield
#selectmonster 74
#end

-- Infantry of Ulm - maul
#selectmonster 75
#gcost 8
#end

-- Black Plate Infantry - maul
#selectmonster 76
#gcost 9
#end

-- Infantry of Ulm - morningstar & shield
#selectmonster 77
#gcost 9
#end

 -- Black Plate Infantry - morningstar & shield
#selectmonster 78
#end

-- Pikeneer 
#selectmonster 79
#gcost 8
#end

-- Black Plate Pikeneer
#selectmonster 80
#gcost 9
#end

-- Black Knight
#selectmonster 69
#gcost 55
#end

-- Sapper
#selectmonster 749
#end

-- Guardians
#selectmonster 66
#mr 12
#descr "The Guardians are entrusted with the security of the mighty keep of Ulm. They are armed with halberds and are awesome fighters who will almost never rout. They are trained in the Keep of Ulm to both resist magic, and excel in the defense of fortresses."
#end

-- Black Lord
#selectmonster 70
#gcost 90
#end

-- Lord Guardian
#selectmonster 113
#gcost 55
#descr "The Guardians are entrusted with the security of the mighty keep of Ulm. They are armed with halberds and are awesome fighters who will almost never rout. They are trained in the Keep of Ulm to both resist magic, and excel in the defense of fortresses."
#mr 12
#end


-- IRON FAITH
-------------

-- Black Templar
#selectmonster 738
#gcost 65
#descr "The Black Templars are black knights of great devotion who have received mental and priestly training in the Black Temple. They are sacred and can be blessed by Black Priests."
#end

-- Black Priest
#selectmonster 740
#gcost 125
#end

-- Black Acolyte
#selectmonster 739
#magicskill 3 1
#forgebonus 15
#descr "The Black Priests have organized the Iron Cult of Ulm. They alone are allowed to practice magic, for magic outside religion is sacrilegious. The Black Priests have installed an inquisition to find heretics and witches and receive a bonus when preaching againt enemy Dominions. The Black Acolytes have learned the skills of the Master Smiths and craft magic items at a reduced cost."
#end


-- BLACK FOREST
---------------

-- Ghoul Guardian
#selectmonster 1020
#mr 12
#armor "Full Plate of Ulm"
#armor "Full Helmet"
#rcost 35
#end

-- Villain
#selectmonster 482
#gcost 8
#end

-- Zweihander
#selectmonster 1034
#end

-- Ranger of Ulm
#selectmonster 1017
#end

-- Infantry of Ulm
#selectmonster 1015
#gcost 9
#end

-- Halberdier
#selectmonster 1014
#gcost 9
#end

-- Pikeneer
#selectmonster 1013
#gcost 8
#end

-- Wolfherd
#selectmonster 1028
#end-- 

-- Thrall
#selectmonster 1022
#end
-----------------------------------------


----------------
-- T'IEN CH'I --
----------------

-- Archer
#selectmonster 797
#gcost 9
#end

-- Footman
#selectmonster 794
#gcost 5
#end

-- Footman
#selectmonster 795
#gcost 6
#end

-- Footman
#selectmonster 796
#gcost 7
#end

-- Imperial Archer
#selectmonster 801
#gcost 10
#end

-- Imperial Crossbowman
#selectmonster 802
#gcost 11
#end

-- Imperial Footman
#selectmonster 799
#gcost 9
#end

-- Imperial Footman
#selectmonster 800
#gcost 10
#end

-- Imperial Guard
#selectmonster 798
#gcost 13
#def 11
#mor 14
#att 12
#end

-- Imperial Horseman
#selectmonster 788
#gcost 14
#def 11
#end

-- Heavy Horseman
#selectmonster 789
#gcost 20
#def 11
#end

-- Imperial Horsemen
#selectmonster 790
#gcost 24
#end

-- Red Guard
#selectmonster 791
#gcost 50
#end

-- Prince General
#selectmonster 793
#gcost 110
#end

-- General
#selectmonster 792
#gcost 70
#end

-- Ceremonial Master
#selectmonster 807
#gcost 40
#end

-- Celestial Master
#selectmonster 803
#magicskill 4 2
#end


-- SPRING AND AUTUMN
--------------------

-- Heavy Footman
#selectmonster 928
#gcost 9
#end

-- Heavy Footman
#selectmonster 929
#gcost 10
#end

-- Noble
#selectmonster 927
#gcost 65
#end

-- Celestial Master - flying
#selectmonster 941
#magicskill 4 2
#end


-- BARBARIAN KINGS
------------------

-- Barbarian Horseman - full leather armor
#selectmonster 938
#gcost 12
#def 12
#mountainsurvival
#wastesurvival
#end

-- Barbarian Horseman - full scale mail
#selectmonster 939
#gcost 16
#def 12
#mountainsurvival
#wastesurvival
#end

-- Khan
#selectmonster 930
#str 14
#att 15
#def 15
#hp 15
#gcost 90
#fear -1
#mountainsurvival
#wastesurvival
#end
-----------------------------------------


------------------
-- INDEPENDENTS --
------------------

-- BASIC

-- Slinger
#selectmonster 50
#end

-- Militia - leather hauberk & shield
#selectmonster 18
#gcost 4
#armor "Leather Cuirass"
#end

-- Militia - leather cuirass
#selectmonster 30
#gcost 3
#end

-- Militia - ring mail cuirass & shield
#selectmonster 31
#gcost 4
#end

-- Crossbowman - dagger & ring mail
#selectmonster 47
#end

-- Crossbowman - short sword & scale mail cuirass
#selectmonster 48
#end

-- Crossbowman - short sword & plate cuirass
#selectmonster 49
#end

-- Archer - dagger & leather cuirass
#selectmonster 17
#end

-- Archer - short sword & plate cuirass
#selectmonster 32
#end

-- Archer - short sword & ring mail cuirass
#selectmonster 33
#end

-- Light Infanty - spear
#selectmonster 28
#gcost 5
#descr "Equipped with light armour, shields, spears, these soldiers are quick and trained in survival. They sometimes carry javelins."
#mountainsurvival
#swampsurvival
#forestsurvival
#def 11
#armor "Leather Hauberk"
#armor "Helmet"
#end

-- Light Infanty - spear & javelin
#selectmonster 29
#gcost 6
#descr "Equipped with light armour, shields, spears, these soldiers are quick and trained in survival. They sometimes carry javelins."
#mountainsurvival
#swampsurvival
#forestsurvival
#def 11
#end

-- Heavy Infantry - spear & ring mail
#selectmonster 38
#gcost 9
#end

-- Heavy Infantry - broadsword & scale mail
#selectmonster 39
#gcost 9
#end

-- Heavy Infantry - broadsword & chain mail
#selectmonster 40
#end

-- Light Cavalry - javelin
#selectmonster 24
#gcost 10
#def 11
#end

-- Light Cavalry - short bow & leather hauberk
#selectmonster 25
#gcost 11
#def 11
#end

-- Light Cavalry - short bow & ring mail
#selectmonster 26
#gcost 10
#def 11
#end

-- Heavy Cavalry - light lance & ring mail
#selectmonster 20
#gcost 28
#end

-- Heavy Cavalry - morningstar & plate
#selectmonster 21
#gcost 40
#end

-- Mounted Commander - leather hauberk (Arco)
#selectmonster 46
#end


-- FEUDAL

-- Knight
#selectmonster 22
#gcost 55
#end 

-- Longbowman
#selectmonster 55
#end

 
 
-- BARBARIANS

-- Tribal Cavalry
#selectmonster 137
#gcost 11
#def 12
#mountainsurvival
#wastesurvival
#end

-- Tribal Chief
#selectmonster 136
#gcost 45
#def 12
#mountainsurvival
#wastesurvival
#end

-- Lizard Warrior
#selectmonster 423
#gcost 6
#att 12
#str 12
#end

-- Barbarian - maul
#selectmonster 140
#gcost 7
#end

-- Barbarian - great sword
#selectmonster 139
#gcost 7
#end

-- Tribal Archer
#selectmonster 123
#gcost 8
#end

-- Tribal Warrior
#selectmonster 124
#gcost 7
#att 12
#mor 11
#end

-- Horse Brother
#selectmonster 450
#gcost 11
#def 13
#mountainsurvival
#wastesurvival
#mapmove 4
#end

-- Horse Brother - commander
#selectmonster 451
#gcost 45
#def 13
#mountainsurvival
#wastesurvival
#mapmove 4
#end

-- Woodsman Blowpipe
#selectmonster 125
#gcost 7
#end

-- Woodsman
#selectmonster 126
#gcost 8
#end


-- AMAZONS

-- Amazon - Jade
#selectmonster 354
#gcost 10
#end

-- Jade Maiden
#selectmonster 370
#gcost 25
#end

-- Amazon - Garnet
#selectmonster 351
#gcost 11
#end

-- Gryphon Rider
#selectmonster 612
#gcost 125
#clearspec
#fly
#mountainsurvival
#wastesurvival
#secondshape 368
#end

-- Amazon - Onyx
#selectmonster 357
#gcost 10
#end

-- Nightmare
#selectmonster 369
#gcost 40
#end


-- HOBURGS

-- Hoburg Militia
#selectmonster 483
#gcost 3
#end

-- Burgmeister Guard
#selectmonster 271
#gcost 7
#end


-- TRITONS

-- Triton
#selectmonster 176
#gcost 5
#end

-- Triton
#selectmonster 174
#gcost 6
#end

-- Triton Gaurd
#selectmonster 175
#gcost 7
#end

-- Triton Trooper
#selectmonster 577
#end

-- Shark Knight
#selectmonster 545
#gcost 60
#secondtmpshape 816
#end


-- ICHTYIDS

-- Ichtyid Warrior
#selectmonster 975
#end

-- Ichtyid
#selectmonster 974
#gcost 7
#end



-------------------
-- MISCELLANEOUS --
-------------------

-- Sage
#selectmonster 478
#researchbonus 3
#end

-- Witch
#selectmonster 478
#healer 2
#end

-- Shambler
#selectmonster 206
#gcost 25
#mor 18
#end

-- Troglodyte
#selectmonster 447
#end

-- Illithid
#selectmonster 331
#end

-- Merman
#selectmonster 1046
#gcost 8
#end

-- Centaur Chariot
#selectmonster 365
#gcost 20
#end

-- Grey Knight
#selectmonster 390
#gcost 60
#end

-- Grey Lord
#selectmonster 391
#gcost 100
#end

-- Troll
#selectmonster 518
#end





------------------
------------------
-- HERO MODDING --
------------------
------------------


------------
-- ABYSIA --
------------

-- Name: Slayer - Chuzrael
-- Weapon(s): Poison Dagger
-- Armor: Chain Mail Cuirass
#selectmonster 867
#hp 27
#mor 15
#str 15
#att 15
#def 13
#ap 16
#itemslots 32006
#end

-- Name: Rage Lord - Rago
-- Weapon(s): Morningstar, Morningstar
-- Armor: Plate Hauberk, Helmet
#selectmonster 539
#hp 28
#mor 15
#str 18
#att 14
#def 12
#prec 7
#ap 14
#weapon 304
#weapon 304
#itemslots 32006
#enc 2
#end

-- Name: Anathemant Warlock - Ba'al Chozron
-- Weapon(s): Dagger
-- Armor: None
#selectmonster 581
#hp 17
#prec 11
#enc 4
#itemslots 32006
#end
-----------------------------------------


--------------
-- ATLANTIS --
--------------

-- Name: Seer King - Chuddar Kadul
-- Weapon(s): Quarterstaff
-- Armor: None
#selectmonster 558
#hp 29
#mor 13
#prec 9
#mapmove 2
#ap 12
#itemslots 32006
#magicskill 2 5
#researchbonus 5
#enc 2
#end

-- Name: Coral Prince - Shudul Cthuda
-- Weapon(s): Coral Glaive
-- Armor: Coral Hauberk, Coral Cap, Turtle Shell Shield
#selectmonster 373
#hp 39
#prot 11
#mor 16
#str 18
#att 14
#def 13
#ap 14
#magicskill 2 2
#itemslots 32006
#standard 5
#enc 2
#end
-----------------------------------------


-------------
-- PYTHIUM --
-------------

-- Name: Hero - Marius Lorca
-- Weapon(s): Broad Sword
-- Armor: Plate Hauberk, Helmet, Tower Shield
#selectmonster 505
#hp 22
#mor 18
#mr 15
#str 15
#att 17
#def 16
#ap 16
#enc 1 
#reinvigoration 3
#standard 10
#superiorleader
#weapon 106
#itemslots 32006
#end

-- Name: Master of the Games
-- Weapon(s): Broad Sword, Short Sword
-- Armor: Scale Mail Cuirass, Helmet
#selectmonster 37
#clear
#name "Master of the Games"
#gcost 1
#rcost 1
#weapon 128
#hp 18
#mor 13
#mr 13
#str 14
#att 15
#def 15
#ap 13
#enc 1
#reinvigoration 1
#itemslots 32006
#poorleader
#descr "The Master of the Games is an old Gladiator, who has remained with the legion after he was granted freedom. He is almost unequalled in combat, but is a rather poor leader. "
#end

-- Name: Patriarch - Bartholomeus
-- Weapon(s): Mace
-- Armor: None
#selectmonster 584
#hp 10
#prot 0
#mor 14
#def 14
#prec 12
#goodleader
#enc 6
#itemslots 32006
#descr "The Patriarch is the highest ranking priest of the Empire. Bartholomeus was trained as a Theurg in the Cathedral of the Spheres, and after years of manipulating and assassinating his chief rivals, has he been elected by the Emerald Council to take the Holy Seat. Now he commands the vast powers of the Theurg communion. Even though he is old now, he is still an able assassin."
#end

-- Name: Hero - Hierogallus (Basic Pythium)
-- Weapon(s): Light Lance, Bite
-- Armor: Plate Hauberk, Helmet, Round Shield
#selectmonster 506
#hp 23
#mor 17
#mr 13
#str 16
#att 16
#def 16
#ap 16
#poisonres 100
#enc 2
#reinvigoration 2
#itemslots 29958
#expertleader
#armor 20 -- helmet
#armor 19 -- full plate mail
#armor 2 --round shield
#end

-- Name: Hero - Hierogallus (Serpent Cult)
-- Weapon(s): Light Lance, Bite
-- Armor: Plate Hauberk, Helmet, Round Shield
#selectmonster 866
#hp 23
#mor 17
#mr 13
#str 16
#att 16
#def 16
#ap 16
#poisonres 100
#enc 2
#reinvigoration 2
#itemslots 29958
#expertleader
#armor 20 -- helmet
#armor 19 -- full plate mail
#armor 2 --round shield
#end

-- Name: Pontifex Serpentus - Gallus
-- Weapon(s): Quarterstaff
-- Armor: Helmet
#selectmonster 865
#hp 14
#mor 12
#mr 16
#prec 12
#magicskill 6 4
#awe 1
#itemslots 32006
#end
-----------------------------------------


---------
-- MAN --
---------

-- Name: Knight of the Stone
-- Weapon(s): Broad Sword, Lance, Hoof
-- Armor: Full Plate Mail, Full Helmet, Kite Shield
#selectmonster 58
#hp 22
#mor 16
#mr 14
#str 14
#att 17
#def 15
#reinvigoration 2
#weapon 74
#weapon 4
#weapon 56
#itemslots 29958
#end

-- Name: Blind One - Brangwen
-- Weapon(s): Dagger
-- Armor: None
#selectmonster 582
#mor 12
#mr 17
#prec 9
#magicskill 4 3
#ap 7
#researchbonus 5
#itemslots 32006
#end

-- Name: Green Knight - Bernlad
-- Weapon(s): Broad Sword, Alicorn, Lance
-- Armor: Full Chain Mail, Full Helmet, Kite Shield
#selectmonster 376
#hp 21
#mor 16
#itemslots 29958
#reinvigoration 3
#holy
#regeneration 30
#end

-- Name: Heroine - Rhianne
-- Weapon(s): Light Lance, Alicorn
-- Armor: Leather Cuirass, Round Shield
#selectmonster 381
#hp 16
#mor 13
#mr 13
#holy
#reinvigoration 2
#itemslots 29958
#end
-----------------------------------------


---------
-- ULM --
---------

-- Name: Member of the Third Tier - Hanif
-- Weapon(s): Fist
-- Armor: None
#selectmonster 1024
#hp 13
#mor 10
#mr 16
#prec 12
#magicskill 4 3
#magicskill 7 3
#assassin
#weapon 126
#itemslots 32006
#descr "The members of the Third Tier are few and powerful. Kings are but mere puppets in their hands. By poisonous words and domination of the mind, they can send a kingdom into turmoil. Carsten was accepted in the Third Tier after successfully infiltrating the Grand Masters of Marignon. He has since improved his skills in fire magic and the art of assassination and is expected to mastermind the fall of Marignon."
#end

-- Name: Ghoul Baron
-- Weapon(s): Flail
-- Armor: Full Plate of Ulm, Helmet
#selectmonster 1021
#hp 27
#mor 18
#mr 14
#str 15
#att 14
#def 13
#ap 12
#berserk 3
#armor 40 -- black steel helmet
#armor 38 -- black steel full plate
#itemslots 32006
#superiorundeadleader
#end

-- Name: Blood Marshal - Burkhard Nachtzehrer
-- Weapon(s): Great Sword
-- Armor: Full Plate Mail
#selectmonster 1035
#hp 33
#ap 17
#magicskill 7 3
#pillagebonus 10
#fear 4
#weapon 11
#weapon 63
#end

-- Name: Hero - Raterik
-- Weapon(s): Morningstar, Alicorn
-- Armor: Full Plate of Ulm, Full Helmet, Kite Shield
#selectmonster 378
#hp 21
#mor 16
#mr 14
#str 16
#att 15
#def 16
#itemslots 29958
#enc 3
#weapon 173
#weapon 4
#weapon 330
#reinvigoration 2
#armor 40 -- black steel helmet
#armor 38 -- black steel full plate
#armor 69 -- black steel kite shield
#end

-- Name: Heroine - Hildegard
-- Weapon(s): Spear, Alicorn
-- Armor: Leather Cuirass, Round Shield
#selectmonster 507
#hp 19
#mor 14
#mr 14
#str 14
#att 16
#def 17
#itemslots 29958
#reinvigoration 2
#enc 3
#weapon 120
#weapon 330
#armor 40 -- black steel helmet
#armor 15 -- full leather armor
#armor 92 -- enchanted shield
#end

-- Name: Hero - Barthulf
-- Weapon(s): Morningstar, Hoof
-- Armor: Full Plate of Ulm, Full Helmet, Kite Shield
#selectmonster 377
#hp 25
#mor 17
#mr 12
#att 15
#def 14
#prec 10
#itemslots 29958
#standard 10
#weapon 173
#weapon 4
#weapon 56
#armor 40 -- black steel helmet
#armor 38 -- black steel full plate
#armor 69 -- black steel kite shield
#end
-----------------------------------------


-----------
-- C'TIS --
-----------

-- Name: First King - Ekishnugal
-- Weapon(s): Snake Staff
-- Armor: Jade Mask
#selectmonster 864
#itemslots 32006
#end

-- Name: Lizard Hero - Niklatu
-- Weapon(s): Falchion
-- Armor: Rainbow Armor, Round Shield
#selectmonster 379
#hp 18
#mor 15
#str 13
#att 13
#def 15
#prec 10
#itemslots 32006
#enc 2
#reinvigoration 3
#expertleader
#ap 12
#end

-- Name: Lizard Hero - Urugallu
-- Weapon(s): Morningstar
-- Armor: Scale Mail Hauberk, Helmet, Round Shield
#selectmonster 380
#hp 21
#prot 13
#mor 14
#mr 14
#str 16
#att 15
#def 13
#enc 3
#weapon 173
#weapon 20
#itemslots 32006
#end

-- Name: Ancient Shaman - Kabti'ili
-- Weapon(s): Mace, Bite
-- Armor: None
#selectmonster 635
#hp 16
#mor 13
#mr 14
#def 12
#prec 10
#itemslots 32006
#magicskill 4 3
#magicskill 8 3
#end

-- Name: Guild Master - Murmur
-- Weapon(s): Claw
-- Armor: None
#selectmonster 585
#hp 14
#mor 13
#mr 18
#def 14
#itemslots 32006
#weapon 126
#weapon 167
#stealthy 10
#end
-----------------------------------------


------------------
-- ARCOSCEPHALE --
------------------

-- Name: Maker of the Maze - Daidalos
-- Weapon(s): Dagger
-- Armor: None
#selectmonster 1073
#itemslots 32006
#forgebonus 20
#end

-- Name: Monster in the Maze - Asterios
-- Weapon(s): Fist, Gore
-- Armor: None
#selectmonster 1089
#hp 45
#prot 20
#mor 13
#mr 12
#str 23
#att 10
#def 8
#mapmove 2
#ap 17
#heal
#itemslots 32006
#end

-- Name: Hero - Anthromachus
-- Weapon(s): Long Spear
-- Armor: Plate Hauberk, Full Helmet, Round Shield
#selectmonster 371
#hp 14
#mor 15
#ap 14
#immortal
#itemslots 32006
#end

-- Name: Hierophant - Orokestes
-- Weapon(s): Dagger
-- Armor: None
#selectmonster 587
#hp 12
#mor 12
#prec 12
#researchbonus 5
#itemslots 32006
#end

-- Name: Son of Titans - Pathos
-- Weapon(s): Short Sword
-- Armor: Plate Hauberk, Full Helmet
#selectmonster 954
#hp 25
#prot 15
#mor 18
#mr 15
#str 16
#ap 14
#itemslots 32006
#weapon 74
#awe 3
#enc 2
#end
-----------------------------------------


------------
-- CAELUM --
------------

-- Name: Sacred One - Caelos
-- Weapon(s): Ice Blade
-- Armor: Ice Hauberk, Ice Helmet, Ice Aegis
#selectmonster 556
#hp 15
#mor 16
#mr 15
#str 12
#att 13
#def 13
#prec 11
#ap 14
#itemslots 32006
#magicskill 8 4
#standard 5
#enc 2
#end

-- Name: Harab Seraphine - Zaelinys
-- Weapon(s): Ice Rod
-- Armor: None
#selectmonster 557
#hp 12
#mor 13
#mr 16
#magicskill 5 3
#itemslots 32006
#stealthy 5
#end
-----------------------------------------


-----------
-- ERMOR --
-----------

-- Name: Grand Thaumaturg - Zirru
-- Weapon(s): Quarterstaff
-- Armor: None
#selectmonster 977
#mor 7
#magicskill 5 5
#itemslots 32006
#end

-- Name: Scythe Wielder - Mortius
-- Weapon(s): Scythe of Slaying
-- Armor: None
#selectmonster 868
#hp 13
#prot 0
#mor 14
#att 14
#ap 12
#gemprod 5 1
#magicskill 4 3
#magicskill 9 4
#descr "The Scythe Wielder is a prominent Thaumaturg in charge of official executions. The ceremonial scythe was given to Mortius several years ago, and he has reputedly executed more than one thousand criminals and dissidents. Occasionally he can harvest a death gem from their dead bodies."
#itemslots 32006
#end

-- Name: Wraith Lord - Etimmu
-- Weapon(s): Bane Blade, Hoof
-- Armor: Plate Hauberk, Full Helmet
#selectmonster 183
#end

-- Name: Arch Censor - Caractor
-- Weapon(s): Battleaxe
-- Armor: Rusty Plate Hauberk
#selectmonster 555
#hp 40
#prot 12
#mor 18
#mr 17
#str 22
#att 15
#def 15
#ap 14
#weapon 181
#pillagebonus 25
#itemslots 32006
#superiorundeadleader
#end

-- Name: Shade King - Tenebrus
-- Weapon(s): Bane Blade
-- Armor: None
#selectmonster 945
#hp 25
#mor 15
#stealthy 25
#immortal
#expertundeadleader
#end

-- Name: Forgotten King - Alcastos
-- Weapon(s): Falchion
-- Armor: Scale Mail Hauberk, Helmet
#selectmonster 537
#hp 27
#def 11
#magicskill 9 5
#itemslots 32006
#goodundeadleader
#end
-----------------------------------------


--------------
-- MARIGNON --
--------------

-- Name: Heroine - Angelique d'Armand
-- Weapon(s): Light Lance, Hoof
-- Armor: Plate Cuirass, Gold Shield

#selectmonster 588
#hp 18
#mor 13
#mr 13
#str 13
#def 16
#weapon 109
#itemslots 29958
#holy
#berserk 1
#armor "plate cuirass"
#armor "helmet"
#armor "gold shield"
#end

-- Name: Witch Hunter General - Tomaso del Monferrada
-- Weapon(s): Broad Sword
-- Armor: None
#selectmonster 589
#hp 15
#mor 16
#str 8
#att 14
#def 14
#prec 12
#magicskill 0 4
#magicskill 8 4
#itemslots 29958
#enc 4
#weapon 8
#weapon 56
#end

-- Name: Cardinal - Carmont
-- Weapon(s): Dagger
-- Armor: None
#selectmonster 583
#hp 11
#mor 16
#mr 16
#magicskill 0 2
#magicskill 4 2
#itemslots 32006
#fear 0
#end
-------------------------------------------------------


-------------
-- PANGAEA --
-------------

-- Name: Ettin Mandragora - Ambicephalos
-- Weapon(s): Sleep Vines, Fist
-- Armor: None
#selectmonster 861
#prot 6
#mor 18
#att 13
#def 7
#prec 7
#end

-- Name: White Minotaur - Menopathos
-- Weapon(s): Battleaxe
-- Armor: Bronze Cuirass, Helmet
#selectmonster 540
#hp 37
#prot 5
#mr 14
#str 18
#att 12
#prec 9
#enc 2
#berserk 6
#itemslots 32006
#end

-- Name: Harpy Queen - Arcopytera
-- Weapon(s): Claw
-- Armor: None
#selectmonster 614
#hp 22
#prot 4
#mor 12
#prec 13
#ap 15
#magicskill 1 3
#stealthy 5
#itemslots 28928
#end

-- Name: White Satyr - Ramshead
-- Weapon(s): Spear, Hoof
-- Armor: Bronze Cuirass, Helmet, Round Shield
#selectmonster 770
#hp 22
#prot 3
#mor 14
#att 13
#def 15
#prec 12
#berserk 4
#weapon 120
#itemslots 32006
#stealthy 5
#end

-- Name: Black Bull - Taurotyrannos
-- Weapon(s): Quarterstaff
-- Armor: None
#selectmonster 611
#hp 35
#prot 6
#mor 16
#att 12
#magicskill 7 4 
#itemslots 32006
#stealthy 5
#end

-- Name: Apostatic Warrior - Panicratos
-- Weapon(s): Spear, Club
-- Armor: None
#selectmonster 863
#hp 33
#prot 6
#prec 11
#magicskill 5 2
#magicskill 8 2
#stealthy 5
#weapon 120
#enc 2
#end
-------------------------------------------------------


-------------
-- VANHEIM --
-------------

--  Name: Einhere - Farbaute
--  Weapon(s): Axe, Broad Sword
--  Armor: Chain Mail Cuirass, Helmet
#selectmonster 544
#hp 22
#mor 14
#mr 13
#str 14
#att 14
#ap 15
#enc 2
#itemslots 32006
#weapon 8
#weapon 245
#end

-- Name: Hero - Vanlade
-- Weapon(s): broad sword, hoof ,javelin
#selectmonster 590
#hp 21
#mor 15
#mr 18
#str 13
#def 19
#prec 14
#mapmove 3
#ap 26
#enc 3
#magicskill 5 2
#itemslots 29958
#end
-------------------------------------------------------


---------------
-- JOTUNHEIM --
---------------


-- Name: Wolf Lord - Sporsnjall
-- Weapon(s): Short Sword, Bite
-- Armor: Full Leather Armor, Helmet, Round Shield
#selectmonster 508
#hp 16
#prot 3
#mor 15
#enc 2
#heal
#spy
#stealthy 25
#att 14
#def 16
#ap 26
#stealth 25
#weapon 120
#weapon 20
#itemslots 29958
#end

-- Name: Great Hag - Angerboda
-- Weapon(s): Stick
-- Armor: Furs
#selectmonster 586
#mor 15
#mr 18
#prec 12
#magicskill 6 3
#end
-------------------------------------------------------


------------
-- R'LYEH --
------------

-- Name: Aboleth - Auluudh
-- Weapon(s): Soul Leech, Enslave Mind
-- Armor: None
#selectmonster 660
#prot 5
#mor 15
#att 11
#def 11
#prec 12
#ap 6
#enc 3
#fear 4
#horrormark
#itemslots 28672
#end

-- Name: Stargazer - Cthugul
-- Weapon(s): Life Drain, Mind Blast
-- Armor: None
#selectmonster 560
#hp 33
#mor 13
#prec 14
#magicskill 4 5
#itemslots 29958
#researchbonus 4
#okleader
#holy
#end

-- Name: Traitor King - Shadul Ummush
-- Weapon(s): Quarterstaff
-- Armor: None
#selectmonster 622
#hp 27
#itemslots 32006
#enc 2
#researchbonus 4
#end
-------------------------------------------------------


-------------
-- MICTLAN --
-------------

-- Name: Eagle Priest - Tepeyocatl
-- Weapon(s): Spear, Dagger
-- Armor: Furs
#selectmonster 936
#hp 18
#mor 15
#str 13
#att 14
#def 14
#prec 12
#ap 15
#magicskill 1 3
#itemslots 32006
#enc 1
#end

-- Name: Feathered Serpent - Quetzalcoatl
-- Weapon(s): Venomous Fangs
-- Armor: None
#selectmonster 934
#hp 27
#prot 8
#mor 14
#def 13
#prec 12
#ap 16
#itemslots 28928
#expertleader
#end

-- Name: Priest King - Quetzalcoatl
-- Weapon(s): Mictlan Obsidian Sword
-- Armor: Helmet
#selectmonster 935
#hp 18
#mor 14
#prec 12
#itemslots 32006
#expertleader
#end

-- Name: King of Legends - Mistlipotli
-- Weapon(s): Dagger
-- Armor: None
#selectmonster 933
#hp 40
#prec 10
#magicskill 9 4
#itemslots 32006
#end
-------------------------------------------------------


--------------
-- TIEN CHI --
--------------

-- Name: Immortal - Lu Tung-Pin
-- Weapon(s): Demon Slayer, Fly Whisk
-- Armor: None
#selectmonster 943
#hp 15
#mor 13
#str 11
#att 14
#prec 13
#ap 14
#enc 2
#magicskill 0 2
#magicskill 1 2
#itemslots 32006
#end

-- Name: Master with the Iron Crutch - Li T'ieh-Kuai
-- Weapon(s): Iron Crutch
-- Armor: None
#selectmonster 944
#mor 15
#def 9
#magicskill 6 2
#itemslots 32006
#end

-- Name: Immortal - Ho Hsien Ku
-- Weapon(s): Fist
-- Armor: None
#selectmonster 942
#hp 12
#mor 10
#magicskill 1 2
#magicskill 6 3
#gemprod 6 1
#itemslots 32006
#end
-------------------------------------------------------


-------------
-- MACHAKA --
-------------


-- Name: Lady of Spiders - Ainra
-- Weapon(s): Quarterstaff
-- Armor: None
#selectmonster 946
#hp 13
#prot 3
#mor 12
#prec 13
#magicskill 0 3
#itemslots 32006
#end

-- Name: Great Spider - Ainra
-- Weapon(s): Venomous Fangs, Web, Web Spit
-- Armor: None
#selectmonster 947
#hp 35
#prot 18
#mor 14
#str 13
#att 13
#def 14
#itemslots 28672
#end

-- Name: Hero - Abasi
-- Weapon(s): Great Club
-- Armor: Plate Hauberk, Helmet, Great Hide Shield
#selectmonster 952
#hp 21
#mor 16
#mr 13
#str 18
#att 13
#def 13
#ap 14
#berserk 3
#stealthy 5
#assassin
#itemslots 32006
#descr "Abasi is a strong man. At the age of ten, he strangled a lion. At the age of twelve, he strangled his father, which was harder by far. At the age of fifteen, he was discovered by the Eyes of the Lord and given an army to lead. He immediately attacked a small kingdom and was almost killed. His army was dispersed and Abasi himself had to flee. When he crossed a river, he was attacked by a crocodile. The beast was difficult to strangle, so he grabbed a log and bashed in its skull. He quickly flayed the animal and used the skin to swim unseen past his enemies. When he had passed the guards, he found himself in the camp of the enemy king. He took his log and thrashed the camp before the enemies could react. Now Abasi has returned with his log to assassinate and bash the enemies of the Lord."
#end

-- Name: King Triumphant - Yasini
-- Weapon(s): Falchion
-- Armor: Plate Hauberk, Helmet
#selectmonster 953
#hp 16
#mor 15
#mr 13
#str 12
#att 13
#def 13
#ap 14
#holy
#superiorleader
#awe 4
#itemslots 32006
#end


------------------------------------------------------------------------------------


--------------------------
--------------------------
--**********************--
--*                    *--
--*  MAGIC ITEMS 1.31  *--
--*                    *--
--**********************--
--------------------------
--------------------------


-- COSTS AND CONSTRUCTION LEVELS


-- TRINKETS

-- Boots of the Behemoth
#selectitem "Boots of the Behemoth"
#constlevel 0
#end

-- Bear Claw Talisman
#selectitem "Bear Claw Talisman"
#mainpath 6
#mainlevel 1
#secondarypath 3
#secondarylevel 0
#end

-- Implementor Axe
#selectitem "Implementor Axe"
#constlevel 0
#end

--------------------------


-- LESSER MAGIC ITEMS

-- Soul Contract
#selectitem "Soul Contract"
#secondarypath 0
#secondarylevel 3
#end

-- Crystal Heart
#selectitem "Crystal Heart"
#mainlevel 1
#secondarylevel 1
#constlevel 2
#end

-- Serpent Kryss
#selectitem "Serpent Kryss"
#mainlevel 2
#end

-- Horned Helmet
#selectitem "Horned Helmet"
#end

-- Skull Standard
#selectitem "Skull Standard"
#constlevel 2 
#end

-- Shambler Skin Armor
#selectitem "Shambler Skin Armor"
#end

-- Vine Bow
#selectitem "Vine Bow"
#constlevel 2 
#end

-- Evening Star
#selectitem "Evening Star"
#constlevel 2 
#end

-- Whip of Command
#selectitem "Whip of Command"
#constlevel 2 
#end

-- Crystal Shield
#selectitem "Crystal Shield"
#mainlevel 2
#end

-- Flesh Ward
#selectitem "Flesh Ward"
#mainlevel 1
#constlevel 2
#end

-- Horn of Valour
#selectitem "Horn of Valour"
#constlevel 2
#end

-- Ice Pebble Staff
#selectitem "Ice Pebble Staff"
#mainlevel 2
#end

-- Star of Thraldom
#selectitem "Star of Thraldom"
#constlevel 2
#end

-- Champion's Skull
#selectitem "Champion's Skull
#mainlevel 1
#constlevel 2
#end

-- Endless Bag of Wine
#selectitem "Endless Bag of Wine"
#constlevel 2
#end

-- Stone Sphere
#selectitem "Stone Sphere"
#mainlevel 1
#constlevel 2
#end

-- Crown of Command
#selectitem "Crown of Command"
#mainlevel 1
#end

--------------------------


-- GREATER ITEMS

-- Silver Hauberk
#selectitem "Silver Hauberk"
#mainlevel 1
#end

-- Cat Charm
#selectitem "Cat Charm"
#mainlevel 1
#constlevel 4
#end

-- Thunder Whip
#selectitem "Thunder Whip"
#mainlevel 2
#constlevel 4
#end

-- Lychantropos' Amulet
#selectitem "Lychantropos' Amulet"
#mainlevel 1
#end

-- Wraith Sword
#selectitem "Wraith Sword"
#mainlevel 4
#end

-- Snake Bladder Stick
#selectitem "Snake Bladder Stick"
#end

-- Clam of Pearls
#selectitem "Clam of Pearls"
#secondarypath 4
#secondarylevel 2
#end

-- Lightning Spear
#selectitem "Lightning Spear"
#secondaypath 3
#secondarylevel 1
#end

-- Fever Fetish
#selectitem "Fever Fetish"
#mainlevel 2
#secondarylevel 2
#end

-- Midget Masher
#selectitem "Midget Masher"
#mainlevel 1
#end

-- Frost Brand
#selectitem "Frost Brand"
#end

-- Winged Shoes
#selectitem "Winged Shoes"
#end

-- Blood Stone
#selectitem "Blood Stone"
#mainlevel 4
#end

--------------------------


-- VERY POWERFUL ITEMS

-- Sandals of the Crane
#selectitem "Sandals of the Crane"
#constlevel 6
#end

--Enormous Cauldron of Broth
#selectitem "Enourmus Cauldron of Broth"
#constlevel 6
#mainlevel 2
#end

-- Elixir of Life
#selectitem "Elixir of Life"
#mainlevel 1
#secondarylevel 1
#end

-- Lantern Shield
#selectitem "Lantern Shield"
#mainlevel 1
#end

-- Staff of Storms
#selectitem "Staff of Storms"
#constlevel 6
#mainlevel 4
#end

-- Hydra Skin Armor
#selectitem "Hydra Skin Armor"
#mainlevel 3
#end

-- Water Bracelet
#selectitem "Water Bracelet"
#end

-Pocket Ship-
#selectitem "Pocket Ship"
#mainlevel 2
#secondarylevel 1
#end

-- Spell Focus
#selectitem "Spell Focus"
#end

-- Lucky Coin
#selectitem "Lucky Coin"
#mainlevel 2
#end

-- Star of Heroes
#selectitem "Star of Heroes"
#mainlevel 2
#constlevel 6
#end

-- Rat Tail Whip
#selectitem "Rat Tail Whip"
#constlevel 6
#end

-- Vine Whip
#selectitem "Vine Whip"
#constlevel 6
#end

-- Demon Whip
#selectitem "Demon Whip"
#end

-- Standard of the Damned
#selectitem "Standard of the Damned"
#secondarypath 4
#secondarylevel 2
#end

-- Bow of War
#selectitem "Bow of War"
#secondarypath 0
#secondarylevel 1
#end

--Sword of Swiftness
#selectitem "Sword of Swiftness"
#constlevel 6
#mainlevel 1
#end

-- Hell Sword
#selectitem "Hell Sword"
#mainlevel 3
#secondarypath 0
#secondarylevel 3
#end

--------------------------


-- ARTIFACTS

-- Tartarian Chains
#selectitem "Tartarian Chains"
#mainlevel 2
#secondarylevel 1 
#end

-- Orb of Atlantis-
#selectitem "Orb of Atlantis"
#mainlevel 3
#end

-- Crown of Overmight-
#selectitem "Crown of Overmight"
#mainlevel 3
#secondarylevel 2
#end

-- Woundflame
#selectitem "Woundflame"
#mainlevel 3
#end

----------------------------------------------------


-- WEAPON & ARMOR MODIFICATIONS 

-- TRINKETS

-- Raw Hide Shield
#selectarmor 70
#def 3
#end

-- Enchanted Shield
#selectarmor 92
#def 4
#end

-- Water Sword
#selectweapon 77
#def 5
#end

-- Fire Sword
#selectweapon 76
#att 5
#end

-- Sword of Sharpness
#selectweapon 74
#def 2
#att 2
#end

-- Axe of Sharpness
#selectweapon 245
#att 2
#dmg 11
#end

-- Enchanted Sword
#selectweapon 75
#def 4
#att 3
#end

-- Hunter's Knife
#selectweapon 242
#dmg 5
#att 4
#end

-- Thorn Spear
#selectweapon 79
#def 3
#end

-- Implementor Axe
#selectweapon 181
#end

-- Shield of Valour
#selectarmor 80
#end

--------------------------


--LESSER ITEMS

-- Horned Helmet
#selectweapon 331
#att 2
#end

-- Serpent Kryss
#selectweapon 297
#att 4
#def 2
#nratt 2
#dmg 5
#end

-- Vine Bow
#selectweapon 303
#nratt 2
#ammo 24
#end

-- Whip of Command
#selectweapon 140
#nratt 2
#end

-- Evening Star
#selectweapon 304
#end

-- Hammer of the Mountains
#selectweapon 130
#def -3
#dmg 30
#end

-- Halberd of Might
#selectweapon 107
#def 2
#att 2
#dmg 18
#end

-- Just Man's Cross
#selectweapon 161
#att 8
#ammo 18
#end

-- Longbow of Accuracy
#selectweapon 152
#ammo 24
#end

-- Piercer
#selectweapon 168
#att 15
#ammo 18
#end

-- Black Bow of Botulf
#selectweapon 155
#ammo 24
#end

-- Vision's Foe
#selectweapon 332
#att 15
#end

-- Knife of the Damned
#selectweapon 117
#nratt 2
#armorpiercing 
#end

-- Gloves of the Gladiator
#selectweapon 128
#dmg 6
#att 2
#def 8
#end

-- Eye Shield
#selectarmor 61
#def 4
#end

-- Star of Thraldom
#selectweapon 218
#end

--------------------------


-- GREATER ITEMS

-- Astral Serpent
#selectweapon 177
#end

-- Thunder Whip
#selectweapon 208
#nratt 2
#att 3
#end

-- Fire Brand
#selectweapon 80
#def 2
#dmg 16
#end

-- Frost Brand
#selectweapon 82
#def 3
#end

-- Lightning Spear
#selectweapon 278
#dmg 8
#att 2
#def 2
#end

-- Snake Bladder Stick
#selectweapon 183
#end

-- Fire Bola
#selectweapon 301
#nratt 3
#att 5
#end

-- Shield of the Accursed
#selectarmour 62
#prot 5
#def 9
#end

-- Wraith Sword
#selectweapon 110
#nostr
#att 1
#def 2
#armornegating
#end

-- Blood Thorn
#selectweapon 101
#nostr
#end

-- Vine Shield
#selectarmor 63
#def 3
#prot 2
#end

-- Heart Finder Sword
#selectweapon 111
#def 4
#att 4
#end

-- Midget Masher
#selectweapon 133
#dmg 18
#att 3
#end

-- Chi Kick
#selectweapon 175
#def 4
#end

--------------------------

-- VERY POWERFUL ITEMS

-- Hydra Skin Hauberk
#selectarmour 43
#prot 7
#enc 2
#end

-- Lucky Coin
#selectarmour 67
#enc 1
#def 2
#end

-- Hell sword
#selectweapon 241
#def -7
#att 1
#end

-- Sword of Swiftness
#selectweapon 106
#def 5
#end

-- Demon Whip
#selectweapon 277
#aoe 1
#end

-- Gold Shield
#selectarmour 71
#prot 5
#def 6
#end

-- Vine Whip
#selectweapon 136
#aoe 1
#end

-- Star of Heroes
#selectweapon 173
#aoe 1
#end

-- Rat Tail Whip
#selectweapon 138
#aoe 1
#end

-- Thunder Bow
#selectweapon 243
#ammo 15
#end

-- Wave Breaker
#selectweapon 83
#dmg 15
#att 6
#def 6
#end

-- Bow of War
#selectweapon 154
#ammo 14
#att 4
#end

-- Ethereal Crossbow
#selectweapon 180
#att 10
#end

-- Dragon Armour
#selectarmor 36
#prot 18
#end

--------------------------


-- ARTIFACTS

-- Unquenched Sword
#selectweapon 84
#att 6
#dmg 26
#end
