document.getElementById('exportSHPButton').addEventListener('click', function () {
  const zip = new JSZip();
  const csvContent = [];
  const canvasContainer = document.getElementById('canvasContainer');
  const canvases = canvasContainer.getElementsByTagName('canvas');
  const palette = document.getElementById('paletteSelect').value;

  let originalFilename = 'unknown';
  const fileInput = document.getElementById('shpFileInput');
  if (fileInput.files.length > 0) {
    originalFilename = fileInput.files[0].name.replace('.shp', '').replace('.SHP', '');
  }

  Array.from(canvases).forEach((canvas, index) => {
    const ctx = canvas.getContext('2d');
    const dataURL = canvas.toDataURL('image/png');
    const imageFilename = `${originalFilename}-${String(index + 1).padStart(4, '0')}.png`;

    // Save the canvas as an image in the ZIP
    zip.file(imageFilename, dataURL.split(',')[1], { base64: true });

    // Extract header data from global arrays
    const csvRow = [
      index + 1, // SHP_Slot
      imageFilename,
      palette,
      imageHeights[index],
      imageWidths[index],
      imageVar1s[index],
      imageXStarts[index],
      imageYStarts[index],
      imageXEnds[index],
      imageYEnds[index],
    ].join(',');

    csvContent.push(csvRow);
  });

  // Create CSV content with header
  const csvHeader = 'SHP_Slot,imagefilename,palette,height,width,var1,xStart,yStart,xEnd,yEnd\n';
  const csvBlob = new Blob([csvHeader + csvContent.join('\n')], { type: 'text/csv' });
  zip.file(`${originalFilename}_metadata.csv`, csvBlob);

  // Generate the ZIP and trigger download
  zip.generateAsync({ type: 'blob' }).then(function (content) {
    const link = document.createElement('a');
    link.href = URL.createObjectURL(content);
    link.download = `${originalFilename}.zip`;
    link.click();
  });
});
