//============================================================================
//============================================================================

document.getElementById('reloadButton').addEventListener('click', function() 
{
	
  const shpFileInput = document.getElementById('shpFileInput');
  const file = shpFileInput.files[0];
  
  if (file) {
	  
	const FName = file.name; // Correctly recover the filename from the file object
	
    const reader = new FileReader();
    reader.onload = function(e) {
      const arrayBuffer = e.target.result;
      const dataView = new DataView(arrayBuffer);
      processSHPFile(dataView, arrayBuffer.byteLength, FName, true); // Clears previous content 
    };
    reader.readAsArrayBuffer(file);
  } else {
    alert("Please upload a SHP file before reloading!");
  }
});

//============================================================================

let originalSHPFileArrayBuffer = null; // to store a copy of the original SHP file for direct header editing for when we just want to change SP Headers

//============================================================================

    document.getElementById('shpFileInput').addEventListener('change', handleFileSelect);
	
	let originalFileName = '';  // Store the original file name

    function handleFileSelect(event) 
	{
      const file = event.target.files[0];
      if (file) {
        const reader = new FileReader();
		
		// Capture the file name without the extension for use later in program
		//originalFileName = file.name.replace(/\.[^/.]+$/, "");  // Strip the extension (e.g., ".shp")
		filename = file.name;

        reader.onload = function(e) {
          const arrayBuffer = e.target.result;
		  
		  // Save a copy of the original data
		  originalSHPFileArrayBuffer = arrayBuffer.slice(0); // Copy the original buffer

          const dataView = new DataView(arrayBuffer);
          processSHPFile(dataView, arrayBuffer.byteLength, filename, clearPrevious = true)
        };
        reader.readAsArrayBuffer(file);
      }
    }

//============================================================================
//============================================================================

function processSHPFile(dataView, fileSize, filename, clearPrevious = true)
{

	if (clearPrevious) 
	{
	  // Clear the canvas container to remove any previous images
	  document.getElementById('canvasContainer').innerHTML = '';
	  
	  // Clear the Console Window Log to remove previous file loadings
	  document.getElementById('logContainer').innerHTML = '';
	}

  // Insert the file name as a header in Canvas Container....
  const canvasContainer = document.getElementById('canvasContainer');
  const fileHeader = document.createElement('h2');
  fileHeader.textContent = filename;
  canvasContainer.appendChild(fileHeader);
	
  // Check if the "Turreted SHPs" checkbox is checked
  const turretedSHPs = document.getElementById('turretedSHPs').checked;

  // Handle palette selection directly within processSHPFile
  const selectedPalette = document.getElementById('paletteSelect').value;

  //Switch Palette files as necessary
  if (selectedPalette === 'spcamo_full_2021'){PALETTE = PALETTE_SPCAMO_FULL_2021;} 
  else if (selectedPalette === 'spcamo_icon_2021'){PALETTE = PALETTE_SPCAMO_ICON_2021;} 
 
  else if (selectedPalette === 'ageofrifles'){PALETTE = PALETTE_AOR;}
  else if (selectedPalette === 'steelpanthers1'){PALETTE = PALETTE_STEEL1;}
  else if (selectedPalette === 'steelpanthers2'){PALETTE = PALETTE_STEEL2;}
  else if (selectedPalette === 'steelpanthers3'){PALETTE = PALETTE_STEEL3;}
  
  else if (selectedPalette === 'fantasygeneral'){PALETTE = PALETTE_FANTGEN;}
  else if (selectedPalette === 'stargeneral'){PALETTE = PALETTE_STARGEN;}
  
  else if (selectedPalette === 'panzergeneral1main'){PALETTE = PALETTE_PANZERGEN;}
  else if (selectedPalette === 'panzergeneral1background'){PALETTE = PALETTE_PANZERGEN_BACK;}
  else if (selectedPalette === 'panzergeneral1new'){PALETTE = PALETTE_PANZERGEN_NEW;}
  
  else if (selectedPalette === 'panzergeneral2main'){PALETTE = PALETTE_PG2;}
  else if (selectedPalette === 'panzergeneral2map'){PALETTE = PALETTE_PG2MAP;}

  else if (selectedPalette === 'pacgeneral'){PALETTE = PALETTE_PACGEN;}
  else if (selectedPalette === 'pacgeneral_day'){PALETTE = PALETTE_PACGEN_DAY;}
  else if (selectedPalette === 'pacgeneral_main'){PALETTE = PALETTE_PACGEN_MAIN;}
  else if (selectedPalette === 'pacgeneral_menu'){PALETTE = PALETTE_PACGEN_MNU2;}
  else if (selectedPalette === 'pacgeneral_TN1J'){PALETTE = PALETTE_PACGEN_TN1J;}
  else if (selectedPalette === 'pacgeneral_TN1U'){PALETTE = PALETTE_PACGEN_TN1U;}
  else if (selectedPalette === 'pacgeneral_TN2J'){PALETTE = PALETTE_PACGEN_TN2J;}
  else if (selectedPalette === 'pacgeneral_TN2U'){PALETTE = PALETTE_PACGEN_TN2U;}
  else if (selectedPalette === 'pacgeneral_TN3J'){PALETTE = PALETTE_PACGEN_TN3J;}
  else if (selectedPalette === 'pacgeneral_TN3U'){PALETTE = PALETTE_PACGEN_TN3U;}
  else if (selectedPalette === 'pacgeneral_TN4J'){PALETTE = PALETTE_PACGEN_TN4J;}
  else if (selectedPalette === 'pacgeneral_TN4U'){PALETTE = PALETTE_PACGEN_TN4U;}
  else if (selectedPalette === 'pacgeneral_TN5J'){PALETTE = PALETTE_PACGEN_TN5J;}
  else if (selectedPalette === 'pacgeneral_TN5U'){PALETTE = PALETTE_PACGEN_TN5U;}
  else if (selectedPalette === 'pacgeneral_TN6J'){PALETTE = PALETTE_PACGEN_TN6J;}
  else if (selectedPalette === 'pacgeneral_TN6U'){PALETTE = PALETTE_PACGEN_TN6U;}

  else if (selectedPalette === 'silenthunter_status'){PALETTE = PALETTE_SH_STATUS_SCREEN;}
  else if (selectedPalette === 'silenthunter_scope_white'){PALETTE = PALETTE_SH_PERISCOPE_WHITE;}
  
  else if (selectedPalette === 'GNB_DamageControl'){PALETTE = PALETTE_GNB_DAMAGECONTROL;}
  else if (selectedPalette === 'GNB_FireControl'){PALETTE = PALETTE_GNB_FIRECONTROL;}

  //Log the selected palette to the console window
  logMessage(`SHP Palette switched to: ${selectedPalette}`, type = 'log', alignment = 'center');
  
  //Print the Filename We're running...
  logMessage(`SHP File: ${filename}`, type = 'log', alignment = 'center');

  // 1. Check the SHP header at the start to find out what SHP version it is...
  const version = String.fromCharCode(dataView.getUint8(0), dataView.getUint8(1), dataView.getUint8(2), dataView.getUint8(3));
  
  //now print
  logMessage(`SHP version: ${version}`, type = 'log', alignment = 'center');
  
  // 2. Number of SHP images (Offset 4)
  const imageCount = dataView.getUint32(4, true);
  logMessage(`Number of SHP images: ${imageCount}`, type = 'log', alignment = 'center');
  
  // 3. Read the SHP Offset Table (Starting at Offset 8)
  let offsets = [];
  for (let i = 0; i < imageCount; i++) {
    const imageOffset = dataView.getUint32(8 + i * 8, true);  // SHP Offset (Palette Offset is ignored)
    offsets.push(imageOffset);
  }
  conditionalLog(`Image Offsets: ${offsets}`); // only if verbose logs enabled.
  
  
  // Track if all images are processed successfully
  let allImagesProcessed = true;

  // 4. Copy SHP image data to arrays
  for (let i = 0; i < offsets.length; i++) 
  
  {
    const startOffset = offsets[i];
	
	
    // Skip invalid offsets (0)
    if (startOffset === 0) {
        logMessage(`Image ${i + 1} has an invalid offset (0) and will be skipped.`, 'warn');
        continue; // Skip this iteration
    }
	
    //const endOffset = (i + 1 < offsets.length) ? offsets[i + 1] : dataView.byteLength; // Adjust to use the length of the data
	
	const endOffset = (i + 1 < offsets.length && offsets[i + 1] > startOffset) ? offsets[i + 1] : dataView.byteLength; // modified to be better?
	
	    // Validate offsets
    if (startOffset >= dataView.byteLength || endOffset > dataView.byteLength) {
        conditionalLog(`Invalid offset: startOffset ${startOffset}, endOffset ${endOffset}`);
        continue; // Skip this iteration to avoid reading out of bounds
    }
	
    // Log the current offset being processed
    conditionalLog(`Processing image ${i + 1}: Start Offset = ${startOffset}, End Offset = ${endOffset}`);
	
	//const endOffset = i + 1 < offsets.length ? offsets[i + 1] : fileSize;  // If last image, go to end of file //(original Data)

    const imageDataArray = new Uint8Array(dataView.buffer.slice(startOffset, endOffset));
	
    // Check the length of the extracted image data
    conditionalLog(`Extracted image data length: ${imageDataArray.length}`);
	
    SHP_Images[`SHP_Image${i + 1}`] = imageDataArray;  // Store each image in SHP_Images object

    conditionalLog(`Stored SHP_Image${i + 1} from offset ${startOffset} to ${endOffset - 1}`);
	// only if verbose logs enabled.
	conditionalLog(`File size: ${fileSize} bytes`);; // only if verbose logs enabled.
	
  }

  // 5. Decode and render each stored SHP image
  for (let i = 1; i <= imageCount; i++) {
    const imageDataArray = SHP_Images[`SHP_Image${i}`];
    if (imageDataArray) {
      const imageDataView = new DataView(imageDataArray.buffer);

      // Pass the image number (i) to readImageHeader to include it in the log
      const header = readImageHeader(imageDataView, 0, i);  // The first 24 bytes is the header
      
      //logMessage(`Rendering Image ${i} - Width: ${header.width}, Height: ${header.height}`);
      
	  //Make Index
	  ImageIndex = (i);
	  
	  //================================
	  //try decoding/drawing image onto canvas
	  try
	  {
	  //draw image onto canvas.
	  decodeSHPImageCorrect(imageDataView, 24, header.width, header.height, imageDataArray.length, filename, ImageIndex, header.var1, header.xStart, header.yStart, header.xEnd, header.yEnd);
	   
	  // Store the original filename and index as dataset attributes on the canvas.
	  canvasContainer.dataset.filename = filename;

	  //Log a notice of successful completion.
	  conditionalLog(`Image ${i} Processed Successfully`); //log successful image count.
	  } 
	  
	  //If we fail we log a error report
	  catch (error) 
	  {
            logMessage(`Error processing Image ${i}: ${error.message}`, 'warn');
            allImagesProcessed = false; // Mark as abnormal if any image has issues
	  }
	  //================================
	  
      //Add a line break after every two images if "Turreted SHPs" is checked
      if (turretedSHPs && (i + 1) % 2 === 0) 
	  {
      const br = document.createElement('br');
      document.getElementById('canvasContainer').appendChild(br);
      }
	   
    } else {
      logMessage(`Image ${i} data is missing.`, 'warn');
	  allImagesProcessed = false; // Mark as abnormal if any image is missing
    }
  }
  
    // Check if all images were processed successfully or not
    if (allImagesProcessed) 
	{
        logMessage(`COMPLETE - All ${imageCount} Images Processed Successfully`, type = 'log', alignment = 'center');
        logMessage(`----------------------------------------------------------`, type = 'log', alignment = 'center');
		
    } else 
	{
        logMessage(`ABNORMAL - Not all images processed successfully.`, type = 'error');
        logMessage(`----------------------------------------------------------`);
    }

}

//============================================================================
//============================================================================

function decodeSHPImageCorrect(dataView, offset, width, height, imageDataLength, filename, index, var1, xStart, yStart, xEnd, yEnd)

{
	
	// Log the dimensions and available data size for debugging
    //console.log(`Decoding Image ${index}: Width=${width}, Height=${height}, Data Length=${imageDataLength}`);
	
  //=============================================================
  //Get the selected image scale value
  const scale = getSelectedScale();
  //=============================================================

  const canvas = document.createElement('canvas');
  const ctx = canvas.getContext('2d');
  
  height = height + 0; //increase height by one globally.
  width = width + 0; //increase width by one globally.
  
  //=============================================================
  //SCALING STUFF BELOW
  canvas.width = width * scale; // original data
  canvas.height = height * scale;
  //=============================================================

  const imageData = ctx.createImageData(width, height);
  const pixels = imageData.data;
  
  //=============================================================
  // Store the filename and index + other shit in the canvas dataset
  
  canvas.dataset.filename = filename;
  canvas.dataset.index = index;
  
  //SP Header Data
  canvas.dataset.width = width;
  canvas.dataset.height = height;
  canvas.dataset.var1 = var1;
  canvas.dataset.xStart = xStart;
  canvas.dataset.yStart = yStart;
  canvas.dataset.xEnd = xEnd;
  canvas.dataset.yEnd = yEnd;
  
  //=============================================================

  conditionalLog(`FNAME: ${filename}`, 'warn'); // verbose logging only
  conditionalLog(`IMGINDX: ${index}`, 'warn'); // verbose logging only
  
	  // Fill the entire image data array with the background color (BACK_COLOR)
	  for (let y = 0; y < height; y++) {
		for (let x = 0; x < width; x++) {
		  putPixel(pixels, x, y, BACK_COLOR, width);
		}
	  }
	//====================================================================================
    // Initialize line and pixel position based off SHP header data
    let l; // first line (also counter)
	let lf; // Last line
	
    if (yStart < 0) 
		{
			l = 0;
			lf = yEnd + Math.abs(yStart);
		} else {
			l = yStart;
			lf = yEnd;
		}

    let pixPos;
    if (xStart < 0) 
		{
			pixPos = 0;
		} else {
			pixPos = xStart;
		}

	let currentOffset = offset;
	//====================================================================================
	
	//Begin RLE Decoding Loop
	
	//while (l < lf && currentOffset < imageDataLength) {	
	while (l <= lf && currentOffset < imageDataLength) {
        if (currentOffset >= imageDataLength) {
		logMessage(`Error: Reached end of image data prematurely at line ${l} in Image ${index}, pixel position: ${pixPos}`, type = 'error', alignment = 'left');
            break;
        }

        const ch = dataView.getUint8(currentOffset++);
        const r = ch % 2; // Determine run type
		const b = ch >> 1; // Use bitwise right shift for integer division by 2
		
		conditionalLog(`RLE command at line ${l}, currentOffset: ${currentOffset}, command: ${ch}`); //data logging for debugging the RLE process.

        if (b === 0 && r === 1) {
            // A skip over
            if (currentOffset >= imageDataLength) {
                logMessage(`Error: Skip length read exceeds image data length at line ${l} in Image ${index}, pixel position: ${pixPos}.`, type = 'error', alignment = 'left');
                break;
            }

            const skipLength = dataView.getUint8(currentOffset++);
			conditionalLog(`Skipped ${skipLength} pixels at line ${l}, new pixPos: ${pixPos}`); //logging
            pixPos += skipLength; // Increment pixel position

        // Ensure we don't exceed width
        if (pixPos >= width) {
            logMessage(`Error: Pixel position exceeded width at line ${l} in Image ${index}, pixel position: ${pixPos}. Correcting to last pixel.`, type = 'error', alignment = 'left');
            pixPos = width - 1; // Set to last pixel
        }
		
        } else if (b === 0) {
			
			//=====================================================================
            // End of line code

			//if (pixPos >= width) 
			//{
			//	logMessage(`Warning: PixPos exceeded width at line ${l}. Capping to width.`);
			//	pixPos = width - 1; // cap it to the last pixel
			//}
			
            l++; //move to next line

			//we now set the pixel start location for the new line... it's dependent on
			//what type of SHP is being used...
			
			if (xStart < 0) {pixPos = 0;} // Steel Panthers Negative Numbers
			else {pixPos = xStart;} // All other SSI games using Positive Numbers
			//=====================================================================

        } else if (r === 0) {
            // A run of the same color
			// Check if currentOffset is within bounds before reading color index
            if (currentOffset >= imageDataLength) {
                logMessage(`Error: Color index read exceeds image data length at line ${l} in Image ${index}, pixel position: ${pixPos}`, type = 'error', alignment = 'left');
                break; // Exit the loop
            }
			
			// Ensure bounds checking before drawing
			if (pixPos >= width) {
				logMessage(`Error: PixPos exceeded width before filling at line ${l}. Current: ${pixPos}, Width: ${width}`);
				break;
			}
			

        const colorIndex = dataView.getUint8(currentOffset++); // Read color index
		
		// Ensure bounds checking before drawing
        if (pixPos + b > width) 
		{
            logMessage(`Warning: Attempting to fill past width at line ${l}. Adjusting fill count.`);
            b = width - pixPos; // Limit the fill to the width
        }
		
        for (let i = 0; i < b; i++) {
            if (pixPos < width) {
                putPixel(pixels, pixPos++, l, PALETTE[colorIndex], width); // Fill with the color
            } else {
				logMessage(`Error: Attempted to fill past width at line ${l} in Image ${index}, pixel position: ${pixPos}`, type = 'error', alignment = 'left');
                break; // Exit the loop if we're out of bounds
            }
        }
		//logMessage(`Image ${index}, filled ${b} pixels with color index ${colorIndex} at line ${l}, new pixel position: ${pixPos}`, type = 'warn', alignment = 'left');

        } else {
            // A run of different colors
            for (let i = 0; i < b; i++) {
                if (pixPos >= width) {
                    logMessage(`Error: Pixel position exceeded width while reading different colors at line ${l} in Image ${index}, pixel position: ${pixPos}`, type = 'error', alignment = 'left');
                    break; // Exit the loop if we're out of bounds
                }

				// Check if currentOffset is within bounds before reading color index
                if (currentOffset >= imageDataLength) {
                    logMessage(`Error: Color index read exceeds image data length at line ${l} in Image ${index}, pixel position: ${pixPos}`, type = 'error', alignment = 'left');
                    break; // Safety check
                }

                const colorIndex = dataView.getUint8(currentOffset++);
                putPixel(pixels, pixPos++, l, PALETTE[colorIndex], width); // Fill with the color
            }
        }
    }

  // Draw the image data (pixels) on top of the background
  ctx.putImageData(imageData, 0, 0);
  
  // Check if the "Draw SP Header Cross" checkbox is selected
  const drawCross = document.getElementById('drawSPHeaderCross').checked;
  
  if (drawCross) 
  {
    drawSPHeaderCross(ctx, canvas.dataset.index, width, height, xStart, yStart, xEnd, yEnd);
  }
  
  //=============================================================
  //We now check to see if the draw index number is checked...
  //=============================================================
   
	const drawIndexCounter = document.getElementById('drawSHP_IndexNumber').checked;
   
  if (drawIndexCounter) 
  {
	ctx.font = '15px Arial';
	ctx.fillStyle = 'rgb(0, 0, 0)'; // Black color
	ctx.textAlign = 'right';
	ctx.textBaseline = 'bottom';
	
	// Ensure pixel alignment for sharp rendering
	const x = Math.floor(width - 2);  // 2px padding from the edges
	const y = Math.floor(height - 2); // 2px padding from the edges
	
	ctx.fillText(index, x, y);
  }
   
  //=============================================================
  // Apply margins from the saved margin constant value
  
  canvas.style.marginLeft = `${marginValue}px`;
  canvas.style.marginRight = `${marginValue}px`;
  canvas.style.marginTop = `${marginValue}px`;
  canvas.style.marginBottom = `${marginValue}px`;
  
  //==============================================================
  //Scale the image to fit the canvas
  
  ctx.imageSmoothingEnabled = false; // Disable image smoothing
  ctx.scale(scale, scale);
  ctx.drawImage(canvas, 0, 0);
  
  //==============================================================
  // Append the canvas to the document
  
  document.getElementById('canvasContainer').appendChild(canvas);
}

//============================================================================
//============================================================================

    // Helper function to set a pixel in the ImageData object
    function putPixel(pixels, x, y, color, width) {
      const index = (y * width + x) * 4;

      if (Array.isArray(color)) {
        // If color is an RGB tuple (e.g., from the palette)
        pixels[index] = color[0];  // R
        pixels[index + 1] = color[1];  // G
        pixels[index + 2] = color[2];  // B
      }

      pixels[index + 3] = 255;  // A (opaque)
    }

//============================================================================

// Function to draw a cyan blob (2x2 pixels) based on SHP header data
function drawSPHeaderCross(ctx, index, width, height, xStart, yStart, xEnd, yEnd)
{
  // Log the cross data for debugging
  conditionalLog(`CROSS DATA: xStart=${xStart}, yStart=${yStart}, xEnd=${xEnd}, yEnd=${yEnd}`);

  // Translate negative coordinates to positive by adding width and height
	const translatedX = Math.abs(xStart);
	const translatedY = Math.abs(yStart);

  // Log the translated coordinates for debugging
  conditionalLog(`Drawing blob at: x=${translatedX}, y=${translatedY}`);

  // Set the fill color to Cyan (0, 255, 255)
  ctx.fillStyle = 'rgb(0, 255, 255)';

  // Draw the horizontal line of the cross (3 pixels long, centered on translatedX)
  ctx.fillRect(translatedX - 1, translatedY, 3, 1); // Centered horizontally

  // Draw the vertical line of the cross (3 pixels long, centered on translatedY)
  ctx.fillRect(translatedX, translatedY - 1, 1, 3); // Centered vertically

  // Draw a 2x2 pixel square (blob) at the translated coordinates
  //ctx.fillRect(translatedX, translatedY, 2, 2);
}

//=============================================================
