// Event Listener for "Icon" SHP files folder button
document.getElementById('loadFolderIconsButton').addEventListener('click', async () => {
  try {
    const directoryHandle = await window.showDirectoryPicker();

    // Clear everything only once at the beginning
    clearPreviousContent();

    for await (const [name, handle] of directoryHandle) {
      if (handle.kind === 'file' && /^Icon\d{4}\.shp$/i.test(name)) {
        const file = await handle.getFile();
        await loadSHP_Folder(file, name); // Pass the filename to the loading function
      }
    }
  } catch (err) {
    console.error('Error reading folder:', err);
  }
});

// Event Listener for generic SHP files folder button
document.getElementById('loadFolderButton').addEventListener('click', async () => {
  try {
    const directoryHandle = await window.showDirectoryPicker();

    // Clear everything only once at the beginning
    clearPreviousContent();

    for await (const [name, handle] of directoryHandle.entries()) {
      if (handle.kind === 'file' && /\.shp$/i.test(name)) {
        const file = await handle.getFile();
        await loadSHP_Folder(file, name); // Pass the filename to the loading function
      }
    }
  } catch (err) {
    console.error('Error reading folder:', err);
  }
});

// Function to clear previous content only once
function clearPreviousContent() {
  imageHeights = [];
  imageWidths = [];
  imageVar1s = [];
  imageXStarts = [];
  imageYStarts = [];
  imageXEnds = [];
  imageYEnds = [];

  document.getElementById('canvasContainer').innerHTML = '';
  document.getElementById('logContainer').innerHTML = '';
}

// Function to load an individual SHP file from a folder
async function loadSHP_Folder(file, filename) {
  const reader = new FileReader();
  reader.onload = function (e) {
    const arrayBuffer = e.target.result;
    const dataView = new DataView(arrayBuffer);

    // Append this SHP file to the canvas with the filename header
    processSHPFile(dataView, arrayBuffer.byteLength, filename, false);
  };
  reader.readAsArrayBuffer(file);
}
