// Reference to the hidden file input
const zipFileInput = document.getElementById('zipFileInput');

// Event Listener for the ZIP button (Load all SHP files)
document.getElementById('loadZIPButton').addEventListener('click', () => {
  // Set a flag to load all SHP files
  zipFileInput.dataset.loadIconsOnly = 'false';
  zipFileInput.click(); // Trigger the hidden file input
});

// Event Listener for the ZIP Icons Only button (Load only iconXXX SHP files)
document.getElementById('loadZIPIconsButton').addEventListener('click', () => {
  // Set a flag to load only iconXXX SHP files
  zipFileInput.dataset.loadIconsOnly = 'true';
  zipFileInput.click(); // Trigger the hidden file input
});

// Event Listener for the hidden file input (when a ZIP file is selected)
zipFileInput.addEventListener('change', async (event) => {
  const file = event.target.files[0]; // Get the selected ZIP file
  if (file) {
    try {
      const arrayBuffer = await file.arrayBuffer();
      const zip = await JSZip.loadAsync(arrayBuffer); // Load ZIP content

      // Clear everything only once before loading new files
      clearPreviousContent();

      const loadIconsOnly = zipFileInput.dataset.loadIconsOnly === 'true';
      if (loadIconsOnly) {
        await loadAllSHPIcon_FromZip(zip); // Load only iconXXX SHP files
      } else {
        await loadAllSHP_FromZip(zip); // Load all SHP files
      }
    } catch (err) {
      console.error('Error reading ZIP file:', err);
    }
  }
});

// Function to clear previous content only once
function clearPreviousContent() {
  imageHeights = [];
  imageWidths = [];
  imageVar1s = [];
  imageXStarts = [];
  imageYStarts = [];
  imageXEnds = [];
  imageYEnds = [];

  document.getElementById('canvasContainer').innerHTML = '';
  document.getElementById('logContainer').innerHTML = '';
}

// Function to load all SHP files from ZIP sequentially
async function loadAllSHP_FromZip(zip) {
  for (const [filename, file] of Object.entries(zip.files)) {
    if (/\.shp$/i.test(filename)) { // Match any SHP file pattern (case-insensitive)
      try {
        const content = await file.async('arraybuffer'); // Extract file content
        const dataView = new DataView(content);

        // Append SHP file content with filename header
        await processSHPFile(dataView, content.byteLength, filename, false);
      } catch (err) {
        console.error(`Error extracting ${filename}:`, err);
      }
    }
  }
}

// Function to load only iconXXX SHP files from ZIP sequentially
async function loadAllSHPIcon_FromZip(zip) {
  for (const [filename, file] of Object.entries(zip.files)) {
    if (/icon.*\.shp$/i.test(filename)) { // Match SHP files with 'icon' in the name (case-insensitive)
      try {
        const content = await file.async('arraybuffer'); // Extract file content
        const dataView = new DataView(content);

        // Append SHP file content with filename header
        await processSHPFile(dataView, content.byteLength, filename, false);
      } catch (err) {
        console.error(`Error extracting ${filename}:`, err);
      }
    }
  }
}
