#!/bin/sh

# This isn't the same as a configuration file, but it works as well
# as one.

# Change the values as you see fit here, and run this script.  For
# more info on each value, check the README file.


#
# GENERAL OPTIONS
#

# Map size (height and width in pixels)
HEIGHT=550
WIDTH=750

# Map name
NAME="random"

# Random seed (specify 0 for completely random)
SEED=0


#
# TERRAIN GENERATION
#

# Terrain ruggedness (between 1 and 2 are good)
RUGGED=1.5

# Terrain dithering (between 0 and 1)
DITHER=0.08

# Water line (0-100)
WATER=35

# Tree line (0-100)
TREES=60

# Mountain line (0-100)
MOUNTAIN=80

# Poverty line (0-100)
POVERTY=20

# Rich line (0-100)
RICH=80


#
# PROVINCE OPTIONS
#

# Number of sea provinces
NUM_SEA=10

# Number of land provinces
NUM_LAND=90

# Percentage of special-shaped provinces
SPECIAL=20

# Distance of sea capitals from shore
SEA_AVOID=30

# Distance of land capitals from shore
LAND_AVOID=8

# Distance between sea capitals
SEA_SPREAD=60

# Distance between land capitals
LAND_SPREAD=25

# Cost of province crossing shore
SEA_COST=1000000

# Cost of province crossing terrain types
TERRAIN_COST=10

# Amount of border smoothing
SMOOTH=1



#
# MAP FILE GENERATION OPTIONS
#

# Minimum number of neighbors a starting sea province needs
MIN_NEIGHBOR_SEA=2

# Minimum number of neighbors a starting land province needs
MIN_NEIGHBOR_LAND=4



# Run the program with the given values above (no need to change this)
dommap \
	-h $HEIGHT \
	-w $WIDTH \
	-n $NAME \
	-s $SEED \
	-r $RUGGED \
	-d $DITHER \
	-wl $WATER \
	-tl $TREES \
	-ml $MOUNTAIN \
	-pl $POVERTY \
	-rl $RICH \
	-ns $NUM_SEA \
	-nl $NUM_LAND \
	-ps $SPECIAL \
	-sa $SEA_AVOID \
	-la $LAND_AVOID \
	-ss $SEA_SPREAD \
	-ls $LAND_SPREAD \
	-sc $SEA_COST \
	-tc $TERRAIN_COST \
	-sm $SMOOTH \
	-ms $MIN_NEIGHBOR_SEA \
	-mn $MIN_NEIGHBOR_LAND
