import java.io.*;

//This class takes a file and copies it elsewhere.
//Mostly this was hacked from the Java in a Nutshell book...

public class FileCopier
{

  public static void copy(String from_name, String to_name) throws IOException {

	File from_file = new File(from_name);
	File to_file = new File (to_name);

	if (!from_file.exists())
	  abort("FileCopy:no such source file " + from_name);
	if (!from_file.isFile())
	  abort("FileCopy:can't copy directory " + from_name);
	if (!from_file.canRead()) 
	  abort("FileCopy:can't read source " + from_name);

	if (to_file.isDirectory())
	  to_file = new File(to_file,from_file.getName());

	if (!to_file.exists())
	{
	  String parent = to_file.getParent();
	  if (parent == null) parent=System.getProperty("user.dir");

	  File dir = new File(parent);

	  if (!dir.exists())
	    abort("FileCopy: destination directory does not exist " + to_name);

	  if (dir.isFile())
	    abort("FileCopy: destination directory is a file " + to_name);

	  if (!dir.canWrite())
	    abort("FileCopy: destination directory is not writeable" + to_name);
	}

	FileInputStream from = null;
	FileOutputStream to = null;

	try
	{
	  from = new FileInputStream(from_file);
	  to = new FileOutputStream(to_file);
	  byte[] buffer = new byte[4096];

	  int bytes_read;

	  while ((bytes_read = from.read(buffer)) != -1)
	    to.write(buffer,0,bytes_read);
	}
	finally
	{
	  if (from != null) try { from.close(); } catch (IOException e) { ; }
	  if (to != null) try { to.close(); } catch (IOException e) { ; }
	}
	
  }
  
  private static void abort(String msg) throws IOException
  {
    throw new IOException(msg);
  }
}