import java.io.*;
import java.util.*;

//This class takes a Dominions savegame and backs it up.

public class RunTimerBackup
{

public static void main(String[] args)
{
  BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
  String GamePath = "";
  String SavePath = "";
  long milliDelay = 0;
  int NumberOfSaveSlots = 10;

  try
  {
    System.out.println("Enter current gamepath to backup (include final \\ char):");
    GamePath = in.readLine();

    System.out.println("Enter backup location to save to (include final \\ char):");
    SavePath = in.readLine();

    System.out.println("Enter second delay for save schedule:");
    milliDelay = Long.parseLong(in.readLine());

    System.out.println("Enter number of save slots:");
    NumberOfSaveSlots = (int) Long.parseLong(in.readLine());
  }
  catch (Throwable e)
  {
    System.err.println ("Abort:" + e.getMessage());
    System.exit(1);
  }

  milliDelay = milliDelay * 1000;
  if (milliDelay <= 0)
  {
    System.err.println ("Delay must be positive integer");
    System.exit(1);
  }

  File TestDir = new File(GamePath);
  if (!TestDir.exists() || !TestDir.isDirectory())
  {
    System.err.println ("Must enter a valid gamepath to backup");
    System.exit(1);
  }

  TestDir = new File(SavePath);
  if (!TestDir.exists() || !TestDir.isDirectory())
  {
    if (!TestDir.mkdir())
    {
      System.err.println ("Failed to create Savepath");
      System.exit(1);
    }
  }

  Timer t1 = new Timer();
  BackupDomTurn budt1 = new BackupDomTurn();

  budt1.InitializeSavePath(GamePath, SavePath, NumberOfSaveSlots);

  t1.schedule(budt1, 0, milliDelay);

  System.out.println("Hit Enter to stop backups.");
  try
  {
    GamePath = in.readLine();
  }
  catch (IOException e)
  {
    System.err.println (e.getMessage());
  }

  budt1.cancel();

  System.exit(0);

}
}
  