<?xml version="1.0"?>
<!-- The Templatizer XSLT Stylesheet v1.0.0!!! 
     Created by Ed Kolis (ekolis@cinci.rr.com)
     Link to this stylesheet as done in sample.xml and view
	 the xml in a browser to get your SE4 data file! -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- output as HTML -->
	<xsl:output method="html"/>
	
	<!-- processes the root node (the file as a whole) -->
	<xsl:template match="/">
		<html>
		<head/>
		<body>
		<!-- the begin tag, as needed by SE4 -->
		*BEGIN*
		<br/><br/><br/>
		<!-- select all the families and process them -->
		<xsl:apply-templates select="dataset/family"/>
		</body>
		</html>
	</xsl:template>
	
	<!-- processes a family (of components, facilities, etc.) -->
	<xsl:template match="family">
		<!-- select whatever's there, either a grid or a list of fields -->
		<xsl:apply-templates select="*">
			<xsl:with-param name="levels">
				<xsl:value-of select="grid/@min"/>
				<xsl:text>;</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="minlvls">
				<xsl:value-of select="grid/@min"/>
				<xsl:text>;</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="maxlvls">
				<xsl:value-of select="grid/@max"/>
				<xsl:text>;</xsl:text>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	
	<!-- processes a grid -->
	<xsl:template match="grid">
		<xsl:param name="levels"/>
		<xsl:param name="minlvls"/>
		<xsl:param name="maxlvls"/>
		<xsl:variable name="level">
			<xsl:call-template name="level-value">
				<xsl:with-param name="count">
					<xsl:value-of select="count(ancestor-or-self::grid)"/>
				</xsl:with-param>
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="maxlvl">
			<xsl:call-template name="level-value">
				<xsl:with-param name="count">
					<xsl:value-of select="count(ancestor-or-self::grid)"/>
				</xsl:with-param>
				<xsl:with-param name="levels">
					<xsl:value-of select="$maxlvls"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="id">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:variable name="index">
			<xsl:for-each select="ancestor-or-self::grid">
				<xsl:if test="@id = $id">
					<xsl:value-of select="position()"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:if test="$level &lt;= $maxlvl">
			<!-- select whatever's there (grids/fields) -->
			<xsl:apply-templates select="grid">
				<!-- put the grid level into the levels list -->
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
					<xsl:value-of select="grid/@min"/>
					<xsl:text>;</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="minlvls">
					<xsl:value-of select="$minlvls"/>
					<xsl:value-of select="grid/@min"/>
					<xsl:text>;</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="maxlvls">
					<xsl:value-of select="$maxlvls"/>
					<xsl:value-of select="grid/@max"/>
					<xsl:text>;</xsl:text>
				</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="field | damage-field">
				<!-- put the grid level into the levels list -->
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
				</xsl:with-param>
				<xsl:with-param name="range" select="1">
				</xsl:with-param>
				<xsl:with-param name="first" select="1"/>
			</xsl:apply-templates>
			
			<!-- if it contained fields, put a newline to separate the records -->
			<xsl:if test="(count(field) &gt; 0) or (count(damage-field) &gt; 0)">
				<br/>
			</xsl:if>
			
			<!-- do next iteration -->
			<xsl:apply-templates select="../*">
				<xsl:with-param name="levels">
					<xsl:for-each select="ancestor-or-self::family/descendant::grid">
						<xsl:choose>
							<xsl:when test="position() = $index">
								<xsl:value-of select="$level + 1"/>
								<!-- dunno why the if is necessary but it prevents double semicolons -->
								<xsl:if test="position() &lt; count(*)">
									<xsl:text>;</xsl:text>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="level-value">
									<xsl:with-param name="count">
										<xsl:value-of select="position()"/>
									</xsl:with-param>
									<xsl:with-param name="levels">
										<xsl:value-of select="$levels"/>
									</xsl:with-param>
								</xsl:call-template>
								<xsl:text>;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:with-param>
				<xsl:with-param name="minlvls">
					<xsl:value-of select="$minlvls"/>
				</xsl:with-param>
				<xsl:with-param name="maxlvls">
					<xsl:value-of select="$maxlvls"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
		
	<!-- processes a regular field -->
	<xsl:template match="field">
		<xsl:param name="levels"/>
		<xsl:value-of select="@name"/>
		<xsl:text> := </xsl:text>
		<xsl:call-template name="field-data">
			<xsl:with-param name="levels">
				<xsl:value-of select="$levels"/>
			</xsl:with-param>
		</xsl:call-template>
		<!-- newline -->
		<br/>
	</xsl:template>
	
	<!-- processes a damage field -->
	<xsl:template match="damage-field">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="first"/>
		<xsl:variable name="minrng">
			<xsl:apply-templates select="min-range">
				<xsl:with-param name="levels" select="$levels"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="maxrng">
			<xsl:apply-templates select="max-range">
				<xsl:with-param name="levels" select="$levels"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:if test="$first">
			<xsl:value-of select="@name"/>
			<xsl:text> := </xsl:text>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="$range &gt;= $minrng">
				<xsl:apply-templates select="damage">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
					</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>	
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<!-- put a space between each damage value -->
		<xsl:text> </xsl:text>
		<xsl:choose>
			<!-- move on to the next damage value -->
			<xsl:when test="$range &lt; $maxrng">
				<xsl:apply-templates select=".">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
					</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range + 1"/>
					</xsl:with-param>
					<xsl:with-param name="first" select="0"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<!-- newline -->
				<br/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- processes field data - http://www.xslt.com/html/xsl-list/2002-02/msg00494.html -->
	<xsl:template name="field-data">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:choose>
			<!-- if there are no child nodes and it's an actual field (not a subelement), just put the text -->
			<xsl:when test="count(*) = 0 and (local-name(.) = 'field' or local-name(.) = 'damage-field')">
				<xsl:value-of select="."/>
			</xsl:when>
			<!-- there are child nodes, or it's a subelement of a field -->
			<xsl:otherwise>
				<xsl:apply-templates select="node()">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
					</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- processes a grid reference (inside a field) -->
	<xsl:template match="value">
		<xsl:param name="levels"/>
		<xsl:variable name="id">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:for-each select="ancestor::grid">
			<!-- is the ID right? -->
			<xsl:if test="@id = $id">
				<!-- extract the level value from the levels string -->
				<xsl:call-template name="level-value">
					<xsl:with-param name="count">
						<xsl:value-of select="position()"/>
					</xsl:with-param>
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!-- extracts level value from the levels string -->
	<xsl:template name="level-value">
		<xsl:param name="count"/>
		<xsl:param name="levels"/>
		<xsl:choose>
			<xsl:when test="$count &lt;= 1">
				<xsl:value-of select="substring-before($levels, ';')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="level-value">
					<xsl:with-param name="count">
						<xsl:value-of select="$count - 1"/>
					</xsl:with-param>
					<xsl:with-param name="levels">
						<xsl:value-of select="substring-after($levels, ';')"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- deals with elements that contain formulas -->
	<xsl:template match="min-range | max-range | damage">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:for-each select="*">
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
				</xsl:with-param>
				<xsl:with-param name="range">
					<xsl:value-of select="$range"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>
	
	<!-- adds numbers -->
	<xsl:template match="add">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="start" select="1"/>
		<xsl:param name="accumulator" select="0"/>
		<xsl:if test="$start &lt;= count(*)">
			<xsl:variable name="value">
				<xsl:apply-templates select="*[$start]">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
						</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels" select="$levels"/>
				<xsl:with-param name="range" select="$range"/>
				<xsl:with-param name="start" select="$start + 1"/>
				<xsl:with-param name="accumulator" select="$accumulator + $value"/>
			</xsl:apply-templates>
		</xsl:if>
		<!-- print only if we've done all the numbers -->
		<xsl:if test="$start = count(*) + 1">
			<xsl:value-of select="$accumulator"/>
		</xsl:if>
	</xsl:template>
	
	<!-- multiplies numbers -->
	<xsl:template match="multiply">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="start" select="1"/>
		<xsl:param name="accumulator" select="1"/>
		<xsl:if test="$start &lt;= count(*)">
			<xsl:variable name="value">
				<xsl:apply-templates select="*[$start]">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
						</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels" select="$levels"/>
				<xsl:with-param name="range" select="$range"/>
				<xsl:with-param name="start" select="$start + 1"/>
				<xsl:with-param name="accumulator" select="$accumulator * $value"/>
			</xsl:apply-templates>
		</xsl:if>
		<!-- print only if we've done all the numbers -->
		<xsl:if test="$start = count(*) + 1">
			<xsl:value-of select="$accumulator"/>
		</xsl:if>
	</xsl:template>
	
	<!-- subtracts numbers -->
	<xsl:template match="subtract">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="start" select="2"/>
		<xsl:param name="accumulator">
			<xsl:apply-templates select="*[1]">
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
					</xsl:with-param>
				<xsl:with-param name="range">
					<xsl:value-of select="$range"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:param>
		<xsl:if test="$start &lt;= count(*)">
			<xsl:variable name="value">
				<xsl:apply-templates select="*[$start]">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
						</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels" select="$levels"/>
				<xsl:with-param name="range" select="$range"/>
				<xsl:with-param name="start" select="$start + 1"/>
				<xsl:with-param name="accumulator" select="$accumulator - $value"/>
			</xsl:apply-templates>
		</xsl:if>
		<!-- print only if we've done all the numbers -->
		<xsl:if test="$start = count(*) + 1">
			<xsl:value-of select="$accumulator"/>
		</xsl:if>
	</xsl:template>
	
	<!-- divides numbers -->
	<xsl:template match="divide">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="start" select="2"/>
		<xsl:param name="accumulator">
			<xsl:apply-templates select="*[1]">
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
					</xsl:with-param>
				<xsl:with-param name="range">
					<xsl:value-of select="$range"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:param>
		<xsl:if test="$start &lt;= count(*)">
			<xsl:variable name="value">
				<xsl:apply-templates select="*[$start]">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
						</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels" select="$levels"/>
				<xsl:with-param name="range" select="$range"/>
				<xsl:with-param name="start" select="$start + 1"/>
				<xsl:with-param name="accumulator" select="$accumulator div $value"/>
			</xsl:apply-templates>
		</xsl:if>
		<!-- print only if we've done all the numbers -->
		<xsl:if test="$start = count(*) + 1">
			<xsl:value-of select="$accumulator"/>
		</xsl:if>
	</xsl:template>
	
	<!-- calculates roman numerals -->
	<xsl:template name="roman" match="roman">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="left">
			<xsl:apply-templates select="node()">
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
				</xsl:with-param>
				<xsl:with-param name="range">
					<xsl:value-of select="$range"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$left &gt;= 1000">
				<xsl:text>M</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 1000"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 900">
				<xsl:text>CM</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 900"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 500">
				<xsl:text>D</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 500"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 400">
				<xsl:text>CD</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 400"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 100">
				<xsl:text>C</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 100"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 90">
				<xsl:text>XC</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 90"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 50">
				<xsl:text>L</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 50"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 40">
				<xsl:text>XL</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 40"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 10">
				<xsl:text>X</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 10"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 9">
				<xsl:text>IX</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 9"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 5">
				<xsl:text>V</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 5"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 4">
				<xsl:text>IV</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 4"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$left &gt;= 1">
				<xsl:text>I</xsl:text>
				<xsl:call-template name="roman">
					<xsl:with-param name="left" select="$left - 1"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- calculates maximum of numbers -->
	<xsl:template match="max">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="start" select="2"/>
		<xsl:param name="accumulator">
			<xsl:apply-templates select="*[1]">
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
					</xsl:with-param>
				<xsl:with-param name="range">
					<xsl:value-of select="$range"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:param>
		<xsl:if test="$start &lt;= count(*)">
			<xsl:variable name="value">
				<xsl:apply-templates select="*[$start]">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
						</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:variable name="next">
				<xsl:choose>
					<xsl:when test="$value &gt; $accumulator">
						<xsl:value-of select="$value"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$accumulator"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels" select="$levels"/>
				<xsl:with-param name="range" select="$range"/>
				<xsl:with-param name="start" select="$start + 1"/>
				<xsl:with-param name="accumulator" select="$next"/>
			</xsl:apply-templates>
		</xsl:if>
		<!-- print only if we've done all the numbers -->
		<xsl:if test="$start = count(*) + 1">
			<xsl:value-of select="$accumulator"/>
		</xsl:if>
	</xsl:template>
	
	<!-- calculates minimum of numbers -->
	<xsl:template match="min">
		<xsl:param name="levels"/>
		<xsl:param name="range"/>
		<xsl:param name="start" select="2"/>
		<xsl:param name="accumulator">
			<xsl:apply-templates select="*[1]">
				<xsl:with-param name="levels">
					<xsl:value-of select="$levels"/>
					</xsl:with-param>
				<xsl:with-param name="range">
					<xsl:value-of select="$range"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:param>
		<xsl:if test="$start &lt;= count(*)">
			<xsl:variable name="value">
				<xsl:apply-templates select="*[$start]">
					<xsl:with-param name="levels">
						<xsl:value-of select="$levels"/>
						</xsl:with-param>
					<xsl:with-param name="range">
						<xsl:value-of select="$range"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:variable name="next">
				<xsl:choose>
					<xsl:when test="$value &lt; $accumulator">
						<xsl:value-of select="$value"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$accumulator"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:apply-templates select=".">
				<xsl:with-param name="levels" select="$levels"/>
				<xsl:with-param name="range" select="$range"/>
				<xsl:with-param name="start" select="$start + 1"/>
				<xsl:with-param name="accumulator" select="$next"/>
			</xsl:apply-templates>
		</xsl:if>
		<!-- print only if we've done all the numbers -->
		<xsl:if test="$start = count(*) + 1">
			<xsl:value-of select="$accumulator"/>
		</xsl:if>
	</xsl:template>
	
	<!-- range template -->
	<xsl:template match="range">
		<xsl:param name="range"/>
		<xsl:value-of select="$range"/>
	</xsl:template>
	
	<!-- default template - fixes whitespace issues - only necessary/useful when outputting as text (not HTML)
	<xsl:template match="* | text()">
		<xsl:variable name="newline">
			<br/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="starts-with(.,$newline) and (substring(., string-length(.) - 1) = $newline)">
				<xsl:value-of select="concat(' ', normalize-space(.), ' ')"/>
			</xsl:when>
			<xsl:when test="starts-with(.,$newline) or starts-with(., ' ')">
				<xsl:value-of select="concat(' ', normalize-space(.))"/>
			</xsl:when>
			<xsl:when test="(substring(., string-length(.) - 1) = $newline) or (substring(., string-length(.)) = ' ')">
				<xsl:value-of select="concat(normalize-space(.), ' ')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="normalize-space(.)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template> -->
</xsl:stylesheet>
