/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DomIIBackup
extends Thread {
    static final int BUFFSZ = 131072;
    static final byte[] fbuf = new byte[131072];
    File domDir;
    HashMap trackers = new HashMap();
    HashSet excludeDirs = new HashSet();
    long sleep;
    int backups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void copy(File var0, File var1_1) {
        var2_2 = null;
        var3_3 = null;
        try {
            var2_2 = new FileInputStream(var0);
            var3_3 = new FileOutputStream(var1_1);
            while (true) {
                var4_4 = DomIIBackup.fbuf;
                // MONITORENTER : DomIIBackup.fbuf
                var5_7 = var2_2.read(DomIIBackup.fbuf);
                if (var5_7 < 0) {
                    // MONITOREXIT : var4_4
                    var8_8 = null;
                    break;
                }
                var3_3.write(DomIIBackup.fbuf, 0, var5_7);
                // MONITOREXIT : var4_4
            }
            try {
                if (var2_2 != null) {
                    var2_2.close();
                }
                if (var3_3 == null) return;
                var3_3.close();
                return;
            }
            catch (IOException var9_12) {
                var9_12.printStackTrace();
                return;
            }
            catch (FileNotFoundException var4_5) {
                var4_5.printStackTrace();
                var8_9 = null;
                try {}
                catch (IOException var9_13) {
                    var9_13.printStackTrace();
                    return;
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                if (var3_3 == null) return;
                var3_3.close();
                return;
            }
            catch (IOException var4_6) {
                var4_6.printStackTrace();
                var8_10 = null;
                try {}
                catch (IOException var9_14) {
                    var9_14.printStackTrace();
                    return;
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                if (var3_3 == null) return;
                var3_3.close();
                return;
            }
        }
        catch (Throwable var7_16) {
            var8_11 = null;
            ** try [egrp 3[TRYBLOCK] [9 : 115->134)] { 
lbl57:
            // 1 sources

            if (var2_2 != null) {
                var2_2.close();
            }
            if (var3_3 == null) throw var7_16;
            var3_3.close();
            throw var7_16;
lbl62:
            // 1 sources

            catch (IOException var9_15) {
                var9_15.printStackTrace();
            }
            throw var7_16;
        }
    }

    public DomIIBackup(Properties properties) {
        this.domDir = new File(properties.getProperty("d2backup.d2home"));
        this.backups = Integer.parseInt(properties.getProperty("d2backup.backups"));
        this.sleep = Integer.parseInt(properties.getProperty("d2backup.sleep")) * 1000;
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("d2backup.exclude"), ":");
        while (stringTokenizer.hasMoreElements()) {
            this.excludeDirs.add(stringTokenizer.nextToken());
        }
    }

    void addSaveFolderTracker(String string) {
        if (this.trackers.containsKey(string)) {
            return;
        }
        SaveFolderTracker saveFolderTracker = new SaveFolderTracker(string);
        this.trackers.put(string, saveFolderTracker);
        saveFolderTracker.start();
    }

    public void run() {
        while (true) {
            File[] fileArray = this.domDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (!file.isDirectory()) {
                        return false;
                    }
                    if (DomIIBackup.this.excludeDirs.contains(file.getName())) {
                        return false;
                    }
                    File[] fileArray = file.listFiles(new FilenameFilter(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean accept(File file, String string) {
                            return string.endsWith(".trn");
                        }
                    });
                    return fileArray.length > 0;
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                this.addSaveFolderTracker(fileArray[i].getName());
            }
            try {
                DomIIBackup.sleep(this.sleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        properties.setProperty("d2backup.d2home", System.getProperty("user.dir"));
        properties.setProperty("d2backup.sleep", "2");
        properties.setProperty("d2backup.backups", "10");
        properties.setProperty("d2backup.exclude", "doc:maps:mods:newlords:rawsound");
        try {
            properties.load(new FileInputStream("domIIbackup.props"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        properties.list(System.out);
        new DomIIBackup(properties).start();
    }

    class SaveFolderTracker
    extends Thread {
        File tracker;
        TreeSet saveFolders;
        long mostRecentTRN = 0L;
        long mostRecent2H = 0L;
        boolean enabled = true;

        SaveFolderTracker(String string) {
            this.tracker = new File(DomIIBackup.this.domDir, string);
            System.out.println("tracking: " + this.tracker.getName());
            this.saveFolders = new TreeSet();
            for (int i = 0; i < DomIIBackup.this.backups; ++i) {
                StringBuffer stringBuffer = new StringBuffer(Integer.toString(i));
                while (stringBuffer.length() < 3) {
                    stringBuffer.insert(0, '0');
                }
                this.saveFolders.add(new SaveFolder(this.tracker, stringBuffer.toString()));
            }
        }

        public void run() {
            while (true) {
                long l = this.mostRecentTRN;
                long l2 = this.mostRecent2H;
                File[] fileArray = this.tracker.listFiles(new FilenameFilter(this){
                    private final /* synthetic */ SaveFolderTracker this$1;
                    {
                        this.this$1 = saveFolderTracker;
                    }

                    public boolean accept(File file, String string) {
                        return string.endsWith(".2h") || string.endsWith(".trn");
                    }
                });
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].getName().endsWith(".2h")) {
                        l2 = Math.max(l2, fileArray[i].lastModified());
                        continue;
                    }
                    l = Math.max(l, fileArray[i].lastModified());
                }
                if (l > this.mostRecentTRN) {
                    ((SaveFolder)this.saveFolders.first()).save();
                } else if (l2 > this.mostRecent2H) {
                    ((SaveFolder)this.saveFolders.last()).update();
                }
                this.mostRecentTRN = l;
                this.mostRecent2H = l2;
                try {
                    SaveFolderTracker.sleep(DomIIBackup.this.sleep);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        class SaveFolder
        extends File
        implements Comparable {
            public SaveFolder(File file, String string) {
                super(file, string);
                if (this.exists()) {
                    File[] fileArray = this.listFiles(new FilenameFilter(this){
                        private final /* synthetic */ SaveFolder this$2;
                        {
                            this.this$2 = saveFolder;
                        }

                        public boolean accept(File file, String string) {
                            return string.endsWith(".2h") || string.endsWith(".trn");
                        }
                    });
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file2 = fileArray[i];
                        if (file2.getName().endsWith(".2h")) {
                            SaveFolderTracker.this.mostRecent2H = Math.max(SaveFolderTracker.this.mostRecent2H, file2.lastModified());
                            continue;
                        }
                        SaveFolderTracker.this.mostRecentTRN = Math.max(SaveFolderTracker.this.mostRecentTRN, file2.lastModified());
                    }
                }
            }

            long timeStamp() {
                long l = 0L;
                File[] fileArray = this.listFiles(new FilenameFilter(this){
                    private final /* synthetic */ SaveFolder this$2;
                    {
                        this.this$2 = saveFolder;
                    }

                    public boolean accept(File file, String string) {
                        return string.endsWith(".trn");
                    }
                });
                for (int i = 0; i < fileArray.length; ++i) {
                    l = Math.max(l, fileArray[i].lastModified());
                }
                return l;
            }

            public int compareTo(Object object) {
                if (object == null) {
                    return 1;
                }
                SaveFolder saveFolder = (SaveFolder)object;
                boolean bl = this.exists();
                boolean bl2 = saveFolder.exists();
                if (bl && bl2) {
                    return (int)(this.timeStamp() - saveFolder.timeStamp());
                }
                return bl ? 1 : (bl2 ? -1 : this.getName().compareTo(saveFolder.getName()));
            }

            void copyFiles() {
                File[] fileArray = this.getParentFile().listFiles(new FileFilter(this){
                    private final /* synthetic */ SaveFolder this$2;
                    {
                        this.this$2 = saveFolder;
                    }

                    public boolean accept(File file) {
                        return !file.isDirectory();
                    }
                });
                for (int i = 0; i < fileArray.length; ++i) {
                    DomIIBackup.copy(fileArray[i], new File(this, fileArray[i].getName()));
                }
            }

            void save() {
                SaveFolderTracker.this.saveFolders.remove(this);
                System.out.println(SaveFolderTracker.this.tracker.getName() + ": saving new turn to " + this.getName());
                if (!this.exists()) {
                    this.mkdir();
                }
                this.copyFiles();
                SaveFolderTracker.this.saveFolders.add(this);
            }

            void update() {
                System.out.println(SaveFolderTracker.this.tracker.getName() + ": updating " + this.getName());
                this.copyFiles();
            }
        }
    }
}

