Attribute VB_Name = "Module1"
Const PIERCE_NONE = 100
Const PIERCE_BLUNT = 40
Const PIERCE_BULLET = 10
Const PIERCE_SNIPER = 2
Const PIERCE_SKIPARMOR = 0.1 ' or less

Const MAX_ARMOR_LAYERS = 10

Type damage
    Amount As Double
    Piercing As Double
End Type
Type armorlayer
    Thickness As Double
    MaxThickness As Double
    Coverage As Double
    Resistance As Double
End Type
Type armorplate
    NumUsedLayers As Integer
    armorarea As Double
    layer(1 To MAX_ARMOR_LAYERS) As armorlayer
End Type

Sub ApplyDamageToArmor(ByRef dmg As damage, ByRef armor As armorplate)
Dim z As Integer
Dim damagehere As damage
Dim areahit As Double
Dim impactpoint As Double

If dmg.Piercing <= PIERCE_SKIPARMOR Then Exit Sub


If dmg.Piercing >= PIERCE_NONE Or dmg.Piercing > armor.armorarea Then
    areahit = armor.armorarea
Else
    areahit = dmg.Piercing
End If
impactpoint = Rnd * (1 - areahit / armor.armorarea)
            
    For z = 1 To armor.NumUsedLayers
        With armor.layer(z) ' current layer
        If .Coverage > 0.005 Then
            If impactpoint >= .Coverage Then
            'all damage falls to next layer
                'do nothing to this layer
            ElseIf impactpoint + (areahit / armor.armorarea) <= .Coverage Then
            'all damage hits this layer
                Call ApplyDamageToArmorLayer(dmg, areahit, armor.layer(z), armor.armorarea)
                'remaining damage moves on to the next layer
            Else
            ' damage applied to ragged edge of armor layer.  some leaks, some hits
                'areahithere = .Coverage - impactpoint
                'damagehere = dmg.Amount * areahithere / areahit
                damagehere.Amount = dmg.Amount * (.Coverage - impactpoint) / (areahit / armor.armorarea)
                'subtract the part of the damage applied here from the total.
                dmg.Amount = dmg.Amount - damagehere.Amount
                'apply the damage subtracted to this layer
                Call ApplyDamageToArmorLayer(damagehere, (.Coverage - impactpoint) * armor.armorarea, armor.layer(z), armor.armorarea)
                If damagehere.Amount > 0 Then
                    'add back any leftover damage that breached this layer.
                    dmg.Amount = dmg.Amount + damagehere.Amount
                Else
                    'areahit decreases for next layer
                    'impactpoint move = hit area blocked by this layer
                    ' % of shot blocked = (.Coverage - impactpoint) / (areahit / armor.armorarea)
                    ' area portion blocked = (areahit/armor.armorarea) * %blocked
                    'impactpoint = impactpoint + (.Coverage - impactpoint) *(a/at)/(a/at)
                    'impactpoint = .Coverage
                    '...before changing impact point...
                    ' areahit goes down by the difference in coverage to impact point, times the total armor area
                    'note: coverage didn't change since armor was ablated, not holed.
                    areahit = areahit - (.Coverage - impactpoint) * armor.armorarea
                    If areahit <= 0 Then
                        'coverage was enough to block the whole blast
                        Exit Sub
                    End If
                    impactpoint = .Coverage
                    
                End If
                'remaining damage moves on down to the next armor layer
            End If
            
        End If ' some coverage remains on this armor layer
        End With
    Next z

End Sub

Sub ApplyDamageToArmorLayer(ByRef dmg As damage, areahit As Double, ByRef layer As armorlayer, armorarea As Double)
    With layer
        'reduce damage by armor's resistance amount
        dmg.Amount = dmg.Amount - .Resistance * areahit
        If dmg.Amount <= 0 Then
            dmg.Amount = 0
            Exit Sub ' all damage accounted for
        End If
        'remaining damage points deplete armor strength:
        If dmg.Amount >= .Thickness * areahit Then
            'add a hole the width of the projectile
            dmg.Amount = dmg.Amount - .Thickness * areahit
            .Coverage = .Coverage - (areahit / armorarea)
            If .Coverage < 0 Then
                'boom
                .Coverage = 0
            End If
        Else
            'ablate even thickness over entire area remaining
            .Thickness = .Thickness - dmg.Amount / (.Coverage * armorarea)
            dmg.Amount = 0
            Exit Sub ' all damage accounted for
        End If
    End With
End Sub
