#!/usr/bin/python

# Dominions II map file parser.

# Licence (MIT):

# Copyright (c) 2004 Christer J. Nyfalt

#Permission is hereby granted, free of charge, to any person obtaining
#a copy of this software and associated documentation files (the
#"Software"), to deal in the Software without restriction, including
#without limitation the rights to use, copy, modify, merge, publish,
#distribute, sublicense, and/or sell copies of the Software, and to
#permit persons to whom the Software is furnished to do so, subject to
#the following conditions:

#The above copyright notice and this permission notice shall be
#included in all copies or substantial portions of the Software.

#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
#MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
#BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
#ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
#CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

VERSION = '0.6.0'

# Info:

# Recognizes the following commands
# 4.1 #dom2title
# 4.2 #imagefile
# 5.1 #scenario
# 5.2 #description
# 5.3 #neighbour
# 5.4 #nostart
# 5.5 #terrain
# 6.1 #landplayers
# 6.2 #seaplayers
# 6.3 #features
# 6.4 #start
# 6.5 #specstart
# 6.6 #nohomelandnames
# 6.7 #computerplayer
# 6.8 #cannotwin
# 6.9 #victorycondition
# 6.10 #victorypoints
# 6.11 #god
# 6.12 #specdom
# 6.13 #compspecdom
# 6.14 #scale_xxx - drain or unmagic?
# 6.15 #dominionstr - problems in arcoeye
# 6.16 #landname
# 6.17 #nonamefilter
# 6.18 #allies
# 6.19 #startspell
# 7.1 #land
# 7.2 #setland
# 7.3 #commander 
# 7.4 #comname
# 7.5 #bodyguards
# 7.6 #units
# 7.7 #clearmagic
# 7.8 #xp
# 7.9 #mag_xxx
# 7.10 #randomequip
# 7.11 #additem
# 7.12 #killfeatures
# 7.13 #feature
# 7.14 #knownfeature
# 7.15 #fort
# 7.16 #temple
# 7.17 #lab
# 7.18 #owner
# 7.19 #unrest
# 7.20 #population
# 7.21 #poptype
# 7.22 #defence
# undocumented:
# #wraparound
# #domversion
# #defaultmapzoom
# #independents

# Assumes that all lines either are empty, start with #<command>, use
#  -- for comment or are part of description and inside "".
# Reports error in all other cases

import string, sys, re

class Prov:
      def __init__(self):
		self.wipe = 'N'
		self.name = ''  
		self.nostart = 'N'
		self.start = 'N'
		self.vps = ''
		self.specstart = ''
		self.terrain = 0
		self.commanders = []
		self.features = []
		self.knownfeatures = []
		self.lab = 'N'
		self.temple = 'N'
		self.owner = ''
		self.fort = ''
		self.defence = ''
		self.neighbours = []
		self.population = ''
		self.killfeat = 'N'
		self.poptype = ''
		self.unrest = ''
		self.manysites = 'N'
		self.size = 'M'
		self.rivers = 'N'
		self.sea = 'N'
		self.swamp = 'N'
		self.mountains = 'N'
		self.waste = 'N'
		self.forest = 'N'
		self.farm = 'N'
		self.landn = 0
		self.sean = 0

class Side:
      def __init__(self):
		self.CPU = ''
		self.specstart = ''
		self.specdom = ''
		self.compspecdom = ''
		self.cannotwin = 'N'
		self.allies = []
		self.owned = []
		self.god = ''
		self.scale_chaos = ''
		self.scale_lazy = ''
		self.scale_cold = ''
		self.scale_death = ''
		self.scale_unluck = ''
		self.scale_drain = ''
		self.startspells = []
		self.dominionstr = ''

class Commander:
      def __init__(self, tp):
		self.type = tp
		self.name = ''
		self.randomequip = ''
		self.items = []
		self.mag_fire = ''
		self.mag_air = ''
		self.mag_water = ''
		self.mag_earth = ''
		self.mag_astral = ''
		self.mag_nature = ''
		self.mag_death = ''
		self.mag_blood = ''
		self.mag_priest = ''
		self.mag_unpriest = ''
		self.clearmagic = 'N'
		self.xp = ''
		self.units = []
		self.bodyguards = []


fname = ""
ofname = ""

# Handle command line arguments
i = 0
while i < len(sys.argv):
	if i == 0: #skip command name
		i += 1
	        continue
	if sys.argv[i] == "-o":
		ofname = sys.argv[i + 1]
		print "OFname:", ofname
		i += 2
	elif sys.argv[i] == "-V":
		print VERSION
		i += 1
	else:
		fname = sys.argv[i]
		i += 1

# No input file name given
if fname == "":
	fname = raw_input("Enter .map file name: ")
	print
	q = ""
	while (q != 'Y' and q != 'N' and q != 'y' and q != 'n'):
		q = raw_input("Redirect output to file? (Y/N)? ")
	if (q == 'Y' or q == 'y'):
		ofname = raw_input("Enter output file name: ")
		print

if ofname != "":
	sys.stdout = open(ofname, "w")

f = open(fname, "r")

nations = {'0':"Abysia", '1':"Atlantis", '2':"Pythium", '3':"Man", '4':"Ulm",
	'5':"C'tis", '6':"Acroscephale", '7':"Caelum", '8':"Ermor",
	'9':"Marignon", '10':"Pangaea", '11':"Vanheim", '12':"Jotunheim",
	'13':"R'lyeh", '14':"Mictlan", '15':"T'ien Ch'i", '16':"Machaka"}
victoryconds = {'0':"Standard", '1':"Victory Points", '2':"Dominion",
	'4':"Provinces", '5':"Research"}
forts = {'1':"Mausoleum", '2':"Watch Tower", '3':"Wizard's Tower",
	'4':"Fortress", '5':"Hill Castle", '6':"Castle", '7':"Fortified City",
	'8':"Citadel", '9':"Dark Citadel", '10':"River Fortress",
	'11':"Jervellan Wall", '12':"Archaic Fortress", '13':"Firbolg Fortress",
	'14':"Ermorian Citadel", '15':"Ermorian Fortress",
	'16':"Kelp Fortress", '17':"Kelp Citadel", '18':"Dark Citadel",
	'19':"Crystal Citadel", '20':"Living Castle", '21':"Obsidian Citadel",
	'22':"Ermorian Castle", '23':"Ermorian Citadel",
	'24':"Mountain Citadel"}
poptypes = {'25':"Barbarian", '26':"Tribal Cavalry", 
	'27':"Militia, Archers, Heavy Infantry",
	'28':"Militia, Archers, Heavy Infantry",
	'29':"Militia, Archers, Heavy Infantry", '30':"Feudal", 
	'31':"Tritons", '32':"Heavy Infantry, Crossbows",
	'33':"Heavy Infantry, Crossbows", '34':"Raptors",
	'35':"Slingers", '36':"Lizards", '37':"Woodsmen",
	'38':"Hoburg", '39':"Militia, Archers", '40':"Amazons (crystal)",
	'41':"Amazons (garnet)", '42':"Amazons (jade)", '43':"Amazons (onyx)",
	'44':"Troglodytes", '45':"Tritons, Shark Knights", 
	'46':"Amber Clan Tritons", '47':"Crossbow, Heavy Cavalry",
	'48':"Militia, Infantry", '49':"Militia, Infantry",
	'50':"Militia, Infantry", '51':"Militia, Infantry, Cavalry",
	'52':"Militia, Infantry, Cavalry", '53':"Militia, Infantry, Cavalry",
	'54':"Heavy Infantry, Heavy Cavalry",
	'55':"Heavy Infantry, Heavy Cavalry",
	'56':"Heavy Infantry, Heavy Cavalry",
	'57':"Deep Ones, Shamblers", 
	'58':"Infantry, Crossbow", '59':"Militia, Light Infantry, Archers",
	'60':"Militia, Light Infantry, Archers",
	'61':"Trolls, Vaettir", '62':"Tribesmen", '63':"Tritons",
	'64':"Tritons", '65':"Ichtyids", '66':"Vaettir", '67':"Vaettir",
	'68':"Militia, Elephants", '69':"Asmeg", '70':"Vaettir",
	'71':"Trolls", '72':"Mermen", '73':"Tritons"}

# current province & commander
curprov = 'NA'
curcom = Commander(0)

# global info. Make a class?
scenname = ''
wrap = 'N'
scenario = 'N'
imagefile = ''
viccon = ''
features = ''
landplayers = ''
seaplayers = ''
nohomelandnames = 'N'
description = ""
domversion = ''
mapzoom = ''
nonamefilter = 'N'
independents = ''

# Province & side info
provlist = {}
sidelist = {}

#Create sides
for i in range(0,17):
	sidelist[str(i)] = Side()


#Input most of the data
line = f.readline()
while line:
	elem = string.split(line)

	# Ignore empty lines
	if not elem:
		line = f.readline()
		continue

	# Ignore comments
	elif re.search('^--', line):
		line = f.readline()
		continue

	# description
	elif elem[0] == "#description":
		# one line
		if re.search('\".*\"', line):
			description = re.search('\"(.*)\"', line).group(1)
		# multiline
		elif re.search("\".*", line):
			description = re.search('\"(.*)', line).group(1)
			fin = 0
			while fin == 0:
				line = f.readline()
				if re.search('\"', line):
					description += re.search('(.*)\"', line).group(1)
					fin = 1
				else:
					description += line

	# Sets current province
	elif elem[0] == "#setland":
		curprov = elem[1]

	# and wipes it
	elif elem[0] == "#land":
		curprov = elem[1]
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		provlist[elem[1]].wipe = 'Y'

	# Province commander
	elif elem[0] == "#commander":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
			       provlist[curprov] = Prov()
			curcom = Commander(string.join(elem[1:]))
			provlist[curprov].commanders.append(curcom)
		else:
			print "ERROR: #commander without province"

	# God
	elif elem[0] == "#god":
		curcom = Commander(string.join(elem[2:]))
		sidelist[elem[1]].god = curcom		

	# Province commander name
	elif elem[0] == "#comname":
		curcom.name = string.join(elem[1:])

	# Commander items
	elif elem[0] == "#additem":
		curcom.items.append(string.join(elem[1:]))

	# Commander random equipment
	elif elem[0] == "#randomequip":
		curcom.randomequip = elem[1]

	# Commander magic
	elif elem[0] == "#mag_fire":
		curcom.mag_fire = elem[1]

	elif elem[0] == "#mag_water":
		curcom.mag_water = elem[1]

	elif elem[0] == "#mag_air":
		curcom.mag_air = elem[1]

	elif elem[0] == "#mag_earth":
		curcom.mag_earth = elem[1]

	elif elem[0] == "#mag_astral":
		curcom.mag_astral = elem[1]

	elif elem[0] == "#mag_nature":
		curcom.mag_nature = elem[1]

	elif elem[0] == "#mag_death":
		curcom.mag_death = elem[1]

	elif elem[0] == "#mag_blood":
		curcom.mag_blood = elem[1]

	elif elem[0] == "#mag_priest":
		curcom.mag_priest = elem[1]

	elif elem[0] == "#mag_unpriest":
		curcom.mag_unpriest = elem[1]

	elif elem[0] == "#clearmagic":
		curcom.clearmagic = 'Y'
		
	elif elem[0] == "#xp":
		curcom.xp = elem[1]
		
	elif elem[0] == "#units":
		curcom.units.append((elem[1], string.join(elem[2:])))

	elif elem[0] == "#bodyguards":
		curcom.bodyguards.append((elem[1], string.join(elem[2:])))

	# Check for title
	elif elem[0] == "#dom2title":
		scenname = string.join(elem[1:])

	# Check for victory points
	elif elem[0] == "#victorypoints":
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		provlist[elem[1]].vps = elem[2]

	# Check for specfic start location
	elif elem[0] == "#specstart":
		if not provlist.has_key(elem[2]):
			provlist[elem[2]] = Prov()
		provlist[elem[2]].specstart = elem[1]
		sidelist[elem[1]].specstart = elem[2]

	# Check for nostart
	elif elem[0] == "#nostart":
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		provlist[elem[1]].nostart = 'Y'

	# Check for start
	elif elem[0] == "#start":
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		provlist[elem[1]].start = 'Y'

	# Read terrain names
	elif elem[0] == "#landname":
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		provlist[elem[1]].name = string.join(elem[2:])

	# Wraparound
	elif elem[0] == "#wraparound":
		wrap = 'Y'

	# Scenario
	elif elem[0] == "#scenario":
		scenario = 'Y'

	elif elem[0] == "#imagefile":
		imagefile = string.join(elem[1:])

	elif elem[0] == "#victorycondition":
		viccon = elem[1]
		vicarg = elem[2]

	elif elem[0] == "#features":
		features = elem[1]

	elif elem[0] == "#specdom":
		sidelist[elem[1]].specdom = string.join(elem[2:])

	elif elem[0] == "#compspecdom":
		sidelist[elem[1]].compspecdom = string.join(elem[2:])

	elif elem[0] == "#scale_chaos":
		sidelist[elem[1]].scale_chaos = elem[2]
	elif elem[0] == "#scale_lazy":
		sidelist[elem[1]].scale_lazy = elem[2]
	elif elem[0] == "#scale_cold":
		sidelist[elem[1]].scale_cold = elem[2]
	elif elem[0] == "#scale_death":
		sidelist[elem[1]].scale_death = elem[2]
	elif elem[0] == "#scale_unluck":
		sidelist[elem[1]].scale_unluck = elem[2]
	elif elem[0] == "#scale_drain":
		sidelist[elem[1]].scale_drain = elem[2]

	elif elem[0] == "#dominionstr":
		sidelist[elem[1]].dominionstr = elem[2]

	elif elem[0] == "#startspell":
		sidelist[elem[1]].startspells.append(string.join(elem[2:]))

	elif elem[0] == "#seaplayers":
		seaplayers = elem[1]

	elif elem[0] == "#landplayers":
		landplayers = elem[1]

	elif elem[0] == "#domversion":
		domversion = elem[1]

	elif elem[0] == "#defaultmapzoom":
		mapzoom = elem[1]

	elif elem[0] == "#nonamefilter":
		nonamefilter = 'Y'

	elif elem[0] == "#independents":
		independents = elem[1]

	elif elem[0] == "#cannotwin":
		sidelist[elem[1]].cannotwin = 'Y'

	elif elem[0] == "#computerplayer":
		sidelist[elem[1]].CPU = elem[2]

	elif elem[0] == "#allies":
		sidelist[elem[1]].allies.append(elem[2])
		sidelist[elem[2]].allies.append(elem[1])

	elif elem[0] == "#nohomelandnames":
		nohomelandnames = 'Y'

	elif elem[0] == "#terrain":
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		provlist[elem[1]].terrain = int(elem[2])
		# Terrain
		ter = int(elem[2])
		if ter >= 1024:
			#deducted from mapeditor
			ter = ter - 1024
			provlist[elem[1]].manysites = 'Y' 
		if ter >= 512:
			#deducted from mapeditor
			ter = ter - 512
			provlist[elem[1]].nostart = 'Y'
		if ter >= 256:
			ter = ter - 256
			provlist[elem[1]].farm = 'Y'
		if ter >= 128:
			ter = ter - 128
			provlist[elem[1]].forest = 'Y'
		if ter >= 64:
			ter = ter - 64
			provlist[elem[1]].waste = 'Y'
		if ter >= 32:
			ter = ter - 32
			provlist[elem[1]].swamp = 'Y'
		if ter >= 16:
			ter = ter - 16
			provlist[elem[1]].mountains = 'Y'
		if ter >= 8:
			ter = ter - 8
			provlist[elem[1]].rivers = 'Y'
		if ter >= 4:
			ter = ter - 4
			provlist[elem[1]].sea = 'Y'
		if ter == 3:
			print "WARNING: Province", elem[1], "both large and small!"
		if ter >= 2:
			# Large
			ter = ter - 2
			provlist[elem[1]].size = 'L'
		if ter >= 1:
			# Small
			ter = ter - 1
			# Use size medium in case of both large and small,
			# which is an error.
			if provlist[elem[1]].size == 'L':
				provlist[elem[1]].size = 'M'
			else:
				provlist[elem[1]].size = 'S'
		if ter != 0:
			print "Province", elem[1], "terrain ERROR!"

	elif elem[0] == "#neighbour":
		if not provlist.has_key(elem[1]):
			provlist[elem[1]] = Prov()
		if not provlist.has_key(elem[2]):
			provlist[elem[2]] = Prov()
		provlist[elem[1]].neighbours.append(elem[2])
		provlist[elem[2]].neighbours.append(elem[1])

	elif elem[0] == "#feature":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].features.append(string.join(elem[1:]))
		else:
			print "ERROR: #feature without province"

	elif elem[0] == "#knownfeature":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].knownfeatures.append(string.join(elem[1:]))
		else:
			print "ERROR: #knownfeature without province"

	elif elem[0] == "#lab":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].lab = 'Y'
		else:
			print "ERROR: #lab without province"

	elif elem[0] == "#temple":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].temple = 'Y'
		else:
			print "ERROR: #temple without province"

	elif elem[0] == "#owner":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].owner = elem[1]
			sidelist[elem[1]].owned.append(curprov)
		else:
			print "ERROR: #owner without province"

	elif elem[0] == "#fort":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].fort = elem[1]
		else:
			print "ERROR: #fort without province"

	elif elem[0] == "#defence":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].defence = elem[1]
		else:
			print "ERROR: #defence without province"

	elif elem[0] == "#population":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].population = elem[1]
		else:
			print "ERROR: #population without province"

	elif elem[0] == "#killfeatures":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].killfeat = 'Y'
		else:
			print "ERROR: #killfeatures without province"

	elif elem[0] == "#poptype":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].poptype = elem[1]
		else:
			print "ERROR: #poptype without province"

	elif elem[0] == "#unrest":
		if curprov != 'NA':
			if not provlist.has_key(curprov):
				provlist[curprov] = Prov()
			provlist[curprov].unrest = elem[1]
		else:
			print "ERROR: #unrest without province"

	else:
		print "WARNING: unknown command: ", line


	line = f.readline()

f.close()

# print out genral info
if (scenname == '' or imagefile == ''):
	print "ERROR: Required field #dom2title or #imagefile missing!"
print '\t', "***", scenname, "***"
print "Imagefile:", imagefile
print "Domversion:", domversion, "\tDefault mapzoom:", mapzoom
print description
print
if wrap == 'Y':
	print "Wraparound"
if scenario == 'Y':
	print "Scenario"
if nohomelandnames == 'Y':
	print "No homelandnames"
if nonamefilter == 'Y':
	print "No namefilter"
if viccon != '':
	print "Victory Condition:", victoryconds[viccon], vicarg
if features != '':
	print "Feature frequency:", features, "%"
if landplayers != '':
	print "Number of land players:", landplayers
if seaplayers != '':
	print "Number of sea players:", seaplayers
if independents != '':
	print "Independent strength:", independents
print

# print out side info
for i in range(0,17):
	print nations[str(i)]
	tmp = sidelist.get(str(i))
	if (i != 1 or i != 13) and landplayers == '0':
		print "\tDISABLED: No land players allowed"
	if (i == 1 or i == 13) and seaplayers == '0':
		print "\tDISABLED: No sea players allowed"
	if tmp.CPU != '':
		print "\tComputer player, difficulty", tmp.CPU
	if tmp.specstart != '':
		print "\tStart province:", tmp.specstart
	if tmp.specdom != '':
		print "\tSpecial domain:", tmp.specdom
	if tmp.compspecdom != '':
		print "\tComputer player special domain:", tmp.compspecdom
	if tmp.cannotwin == 'Y':
		print "\tCan not win"
	stri = ""
	if tmp.scale_chaos != '':
		stri += "chaos: " + tmp.scale_chaos + " "
	if tmp.scale_lazy != '':
		stri += "lazy: " + tmp.scale_lazy + " "
	if tmp.scale_cold != '':
		stri += "cold: " + tmp.scale_cold + " "
	if tmp.scale_death != '':
		stri += "death: " + tmp.scale_death + " "
	if tmp.scale_unluck != '':
		stri += "unluck: " + tmp.scale_unluck + " "
	if tmp.scale_drain != '':
		stri += "drain: " + tmp.scale_drain + " "
	if stri != "":
		print "\tScales " + stri
	if tmp.dominionstr != '':
		print "\tDominion strength:", tmp.dominionstr

	if tmp.god:
		stri = "\tGod:" + tmp.god.type
		if tmp.god.name != '':
			stri += " named " + tmp.god.name
		print stri
		if tmp.god.items != []:
			print "\t\tHas the following items: ", tmp.god.items
		if tmp.god.randomequip != '':
			print "\t\tHas random equipment, strength: " + tmp.god.randomequip
		if tmp.god.xp != '':
			print "\t\tExperience:", tmp.god.xp
		if tmp.god.clearmagic == 'Y':
			print "\t\tMagic cleared"
		stri = ""
		if tmp.god.mag_fire != '':
			stri += "fire: " + tmp.god.mag_fire + " "
		if tmp.god.mag_air != '':
			stri += "air: " + tmp.god.mag_air + " "
		if tmp.god.mag_water != '':
			stri += "water: " + tmp.god.mag_water + " "
		if tmp.god.mag_earth != '':
			stri += "earth: " + tmp.god.mag_earth + " "
		if tmp.god.mag_astral != '':
			stri += "astral: " + tmp.god.mag_astral + " "
		if tmp.god.mag_death != '':
			stri += "death: " + tmp.god.mag_death + " "
		if tmp.god.mag_nature != '':
			stri += "nature: " + tmp.god.mag_nature + " "
		if tmp.god.mag_blood != '':
			stri += "blood: " + tmp.god.mag_blood + " "
		if tmp.god.mag_priest != '':
			stri += "priest: " + tmp.god.mag_priest + " "
		if tmp.god.mag_unpriest != '':
			stri += "unpriest: " + tmp.god.mag_unpriest + " "
		if stri != "":
			print "\t\tMagic " + stri
		for u in tmp.god.bodyguards:
			print "\t\tBodyguards: " + u[0] + "x " + u[1]
		for u in tmp.god.units:
			print "\t\tUnits: " + u[0] + "x " + u[1]



	for j in range (0,17):
		if tmp.allies.count(str(j)) > 0:
			print "\tAlly:", nations[str(j)]
	if tmp.owned != []:
		print "\tOwned provinces:", tmp.owned
	for sp in tmp.startspells:
		print "\tStart spell:", sp

print


def key_sort(a, b):
	return int(a) - int(b)


keys = provlist.keys()
keys.sort(key_sort)

# calculate more province data
for prov in keys:
	tmp = provlist.get(prov)
	s = 0
	l = 0
	for n in tmp.neighbours:
		t2 = provlist.get(n)
		if t2.sea == 'Y':
			s += 1
		else:
			l += 1
	tmp.sean = s
	tmp.landn = l

# print out province info
for prov in keys:
    	tmp = provlist.get(prov)

	# Name, index
	stri = "(" + prov + ") "
	if tmp.name != '':
		stri = stri + tmp.name + ": "
	else:
		stri = stri + "<random>: "
	print stri

	# Terrain
	stri = "\t"
	if tmp.farm == 'Y':
		stri += "farm "
	if tmp.forest == 'Y':
		stri += "forest "
	if tmp.waste == 'Y':
		stri += "waste "
	if tmp.swamp == 'Y':
		stri += "swamp "
	if tmp.mountains == 'Y':
		stri += "mountain "
	if tmp.rivers == 'Y':
		stri += "rivers "
	if tmp.sea == 'Y':
		stri += "sea "
	if stri == "\t":
		stri += "plains "
	if tmp.size == 'L':
		stri += "large "
	if tmp.size == 'S':
		stri += "small "
	stri += "| "
	if tmp.sean == 0 and tmp.landn > 0 and tmp.sea == 'Y':
		stri += "lake"
	elif tmp.sean > 0 and tmp.sea == 'Y':
		stri += "sea"
	elif tmp.sea == 'N' and tmp.landn == 0 and tmp.sean > 0:
		stri += "distant island"
	elif tmp.sea == 'N' and tmp.sean == 0 and tmp.landn > 0:
		stri += "inland"
	elif tmp.sea == 'N' and tmp.sean > 0 and tmp.landn > 0:
		stri += "coastal"
	elif tmp.sean == 0 and tmp.landn == 0:
		stri += "isolated"
	else:
		stri += "unknown"
	print stri

	# Neighbours
	print "\tneighbours:", tmp.neighbours

	print "\tland neighbours:", tmp.landn, "sea neighbours:", tmp.sean

	# Owner, VPs
	stri = "\t"
	# No start set by nostart command
	if tmp.nostart == 'Y':
		stri = stri + "NOSTART "
	if tmp.start == 'Y':
		stri = stri + "START "
	if tmp.specstart != '':
		stri = stri + "START:" + nations[tmp.specstart] + " "
	if tmp.owner != '':
		stri = stri + "OWNER:" + nations[tmp.owner] + " "
	if tmp.vps != '':
		stri = stri + "VPs:" + tmp.vps + " "
	print stri

	# Rest of Info
	if tmp.wipe == 'Y':
		print "\tinhabitants wiped"
	for com in tmp.commanders:
		stri = "\tcommander: " + com.type
		if com.name != '':
			stri += " named " + com.name
		print stri
		if com.items != []:
			print "\t\tHas the following items: ", com.items
		if com.randomequip != '':
			print "\t\tHas random equipment, strength: " + com.randomequip
		if com.xp != '':
			print "\t\tExperience:", com.xp
		if com.clearmagic == 'Y':
			print "\t\tMagic cleared"
		stri = ""
		if com.mag_fire != '':
			stri += "fire: " + com.mag_fire + " "
		if com.mag_air != '':
			stri += "air: " + com.mag_air + " "
		if com.mag_water != '':
			stri += "water: " + com.mag_water + " "
		if com.mag_earth != '':
			stri += "earth: " + com.mag_earth + " "
		if com.mag_astral != '':
			stri += "astral: " + com.mag_astral + " "
		if com.mag_death != '':
			stri += "death: " + com.mag_death + " "
		if com.mag_nature != '':
			stri += "nature: " + com.mag_nature + " "
		if com.mag_blood != '':
			stri += "blood: " + com.mag_blood + " "
		if com.mag_priest != '':
			stri += "priest: " + com.mag_priest + " "
		if com.mag_unpriest != '':
			stri += "unpriest: " + com.mag_unpriest + " "
		if stri != "":
			print "\t\tMagic " + stri
		for u in com.bodyguards:
			print "\t\tBodyguards: " + u[0] + "x " + u[1]
		for u in com.units:
			print "\t\tUnits: " + u[0] + "x " + u[1]

	if tmp.manysites == 'Y':
		print "\tmany sites " #deducted from mapeditor
	if tmp.killfeat == 'Y':
		print "\tfeatures wiped"
	for feat in tmp.features:
		print "\tfeature: " + feat
	for feat in tmp.knownfeatures:
		print "\tknownfeature: " + feat
	if tmp.lab == 'Y':
		print "\tlaboratory"
	if tmp.temple == 'Y':
		print "\ttemple"
	if tmp.fort != '':
		print "\tfort: ", forts[tmp.fort]
	if tmp.defence != '':
		print "\tdefence: " + tmp.defence
	if tmp.population != '':
		print "\tpopulation: " + tmp.population
	if tmp.poptype != '':
		print "\tpoptype: " + poptypes[tmp.poptype] + "(" + tmp.poptype + ")"
	if tmp.unrest != '':
		print "\tunrest: " + tmp.unrest

if ofname != "":
	sys.stdout.close()
