#!/usr/bin/python

################################################################################
# Add Ability to Weapons
# by Nolan Kelly, 2006
#
# This script adds an ability to all Weapon components.
################################################################################


################################################################################
# Globals
################################################################################

# Set this to the exact foldername used by the mod containing the 
# SystemTypes.txt file you wish to scale. To use the stock file, set it to '..'
#modname = '..'
modname = 'Limited Weapons'

# Set this to the ability you wish to add to weapon components.
ability = 'AI Tag 01'

################################################################################
# don't muck about below this line!
################################################################################
import string
import re
import sys
import os

num_abilities = 0

# Looks for Number Of Abilities line. Sets num_abilities to the value of this 
# line.
def ability_re (match):
  global num_abilities
  
  num_abilities = int(match.group(1))

  return '1'

# Looks for Weapon Type line. When it is found, we should return a new ability
# entry.
def new_ability ():
  global num_abilities

  toReturn = 'Ability ' + str(num_abilities+1) + ' Type                                  := AI Tag 01\n'
  toReturn += 'Ability ' + str(num_abilities+1) + ' Description                           :=\n'
  toReturn += 'Ability ' + str(num_abilities+1) + ' Scope                                 := Space Object\n'
  toReturn += 'Ability ' + str(num_abilities+1) + ' Range Formula                         := 0\n'
  toReturn += 'Ability ' + str(num_abilities+1) + ' Amount 1 Formula                      := 0\n'
  toReturn += 'Ability ' + str(num_abilities+1) + ' Amount 2 Formula                      := 0\n'

  return toReturn


################################################################################
# End Functions
################################################################################

sysfile = open('../../' + modname + '/Data/Components.txt', 'r')
#sysfile = open('../../' + modname + '/Data/SComponents.txt', 'r')

if os.getcwd().split('\\')[-2] == modname:
  print 'WARNING: Target mod same as source mod. Output file will be ComponentsTemp.txt.'
  outfile = open('./ComponentsTemp.txt', 'w')
else:
  outfile = open('./.txt', 'w')

# Get the first line in the file, in case it is empty.
line = sysfile.readline()

ability_match = re.compile('Number Of Abilities \s+ := (\d{1,4})')
weapon_match = re.compile('Weapon Type \s+ := (?!None)')
nonweapon_match = re.compile('Weapon Type \s+ := (\w+)')

# Skip the file header.
while line.strip() != "*BEGIN*":
  outfile.write(line)
  
  # Get the next line.
  line = sysfile.readline()

ability_buffer = ''
new_comp = 0

# Parse the input file.
while line != "":
  # When num abilities line is found, start buffering data so that the correct
  # ability amount can be printed after weapon matching is performed.
  if ability_match.search(line) != None:
    new_comp = 1

    ability_buffer = ''
    ability_match.sub(ability_re, line, count=1)
  # If we have found a weapon, increment and print Number of Abilities, print
  # out the buffered abilities, then print the new ability.
  elif (weapon_match.search(line) != None):
    outfile.write('Number Of Abilities                             := ' + str(num_abilities+1) + '\n')

    outfile.write(ability_buffer)

    outfile.write(new_ability())

    new_comp = 0
  # If a nonweapon is found, print out the buffered abilities.
  elif (nonweapon_match.search(line) != None):
    outfile.write('Number Of Abilities                             := ' + str(num_abilities) + '\n')

    outfile.write(ability_buffer)

    new_comp = 0
  # When we have a new component, buffer the data.
  elif new_comp == 1:
    ability_buffer += line

  # When we are not working on a new component, simply print out the line.
  if new_comp == 0:
    outfile.write(line)

  # Get the next line.
  line = sysfile.readline()

sysfile.close()
outfile.close()
