#!/usr/bin/env python
import shutil
import glob, sys
from zipfile import *
from optparse import OptionParser
from os import *
from os.path import *

def findstring (line,start,end):
    s = line.find (start)
    if s == -1:
        return None
    s = s + len(start)
    e = line.find (end)
    if e == -1:
        return None
    return line[s:e]
    
class ScorefileParser:
    def __init__ (self,name):
        self.scoreFile = join(name,"scores.html")
        
    def doesExist(self):
        return access(self.scoreFile,F_OK)
    
    def parseTurnnum (self,line):
        if not line.startswith("<title>Dominions 3 Scores"):
            return False
        substr = findstring(line,"turn ","</title>")
        if substr == None:
            return False
        self.turnNumber = substr
        return True
    
    def parse(self, turnOnly = True):
        self.turnNumber = ""
        f = file(self.scoreFile,"r")
        for line in f.readlines():
            if self.parseTurnnum(line):
                break
        f.close()
        return self.turnNumber
            

class Backup:
    
    def __init__(self):
        self.parse_Options()
        if not self.options.verbose:
            self.logfile = file("dom3backup.log","w")
        chdir("savedgames")
        self.game = self.findGame()

    def log(self,line):
        if not self.options.verbose:
            self.logfile.write(line)
        else:
            print line

    def closelog(self):
        if not self.options.verbose:
            self.logfile.close()

    def checkDate(self,name):
        turnFile = join(name,"ftherlnd")
        if access (turnFile,F_OK):
            return getmtime(turnFile)
        return 0

    def substitute(self,line):
        result = line.replace("#name",self.game)
        return result.replace("#turn",self.turnnum)
    
    def findGame(self):
        if self.options.game <> None:
            lastName = self.options.game
        else:
            lastTime = 0
            lastName = ""
            for f in listdir("."):
                if isdir(f):
                    (name,ext) = splitext(f)
                    if len(ext) > 0 or name == "newlords":
                        continue
                    time = self.checkDate(f)
                    if time > lastTime:
                        lastTime = time
                        lastName = f
        if len(lastName) > 0:
            self.log ("processing game: " + lastName)
        else:
            self.log("no game found")
        return lastName

    def parse_Options(self):
        p = OptionParser()
        p.add_option("-a","--archive",
            help="create archive <name> now. Use from the commandline")
        p.add_option("-b","--backupdir",default="./#name.backup",
            help="create backup in backupdir. Default: <dom3>/savedgames/#name.backup")
        p.add_option("-d","--archdir",default="../archivedgames",
            help="create Zipfiles in archdir. archdir must exists. Default: <dom3>/archivedgames. See -b option for absolute/relative paths")
        p.add_option("-f","--freq",type="int",default = 0,
            help = "create a Zipfile every <n> turn(s). Default: 0 (no zipfile)")
        p.add_option("-g","--game",
            help="backup game <name>. Otherwise backup latest game")
        p.add_option("-m","--maxfiles",type="int",default = 0,
            help = "keep max. <n> Zipfiles. Delete oldest. Default: 0 (keep all)")
        p.add_option("-q","--quiet",action="store_false",dest="verbose",default=True,
            help="output messages are written to <dom3>/dom3backup.log. Use when running from dom3")
        p.add_option ("-r","--restore",action="store_true", dest="restore", default=False,
            help="restore files form backup-dir. If you used -b while writing, it must be given here also")
        p.add_option("-t","--turn",type="int",default = 0,
            help = "assume turn <n>. Most useful with -r. Use from commandline only")


        p.add_option ("--nocopy",action="store_true", dest="nocopy", default=False,
            help="don't copy files to backup-dir. Default: False")
        p.add_option ("--clean",action="store_true", default=False,
            help="remove all zipfiles and the backup-dir")

        (self.options,args) = p.parse_args()
    
    def doCopy (self,source,target):
        for f in listdir(source):
            okay = False
            (name,ext) = splitext(f)
            (head,tail) = split(f)
            #print f,ext
            if ext == ".2h" or ext == ".trn":
                okay = True
            elif tail == "ftherlnd" or tail == "scores.html":
                okay = True
            if okay:
                shutil.copy(join(source,f),target)


    def backupFiles (self):
        print self.backupdir
        #target = join (self.backupdir,self.game + ".backup")
        target = self.backupdir
        self.log ("backing up " + self.game + " to: " + target)
        shutil.rmtree(target,True)
        if not access(target,F_OK):
            makedirs (target)
        self.doCopy(self.game,target)

    def restoreFiles (self):
        backup = self.backupdir
        self.log ("restoring " + self.game + " from: " + backup)
        if not access(backup,F_OK):
            self.log ("problem with backup file: " + backup)
            return
        shutil.rmtree(self.game,True)
        mkdir (self.game)
        self.doCopy(backup,self.game)
    

    def getTurnNum(self):
        if self.options.turn > 0:
            self.turnnum = str(self.options.turn)
            return True
        scoreFile = ScorefileParser(self.game)
        if not scoreFile.doesExist():
            return False
        self.turnnum = scoreFile.parse()
        self.log ("processing turn: " + self.turnnum)
        return True
        
    def createArchive(self,zipName = None):
        if zipName == None:
            zipName = self.game + "-Turn" + self.turnnum + ".zip"
        elif zipName[-4:] <> ".zip":
            zipName = zipName + ".zip"
        self.log ("creating archive: " + zipName)
        zipFile = ZipFile(zipName,'w',ZIP_DEFLATED)
        for f in listdir (self.game):
            if not isdir(f):
                zipFile.write(join(self.game,f))
        zipFile.close()
        shutil.move (zipName,self.archdir)
        return True

    def checkZipWrite(self):
        last = count = 0
        first = None
        current = int(self.turnnum)
        patstart = self.game + "-Turn"
        pattern = patstart + "*.zip"
        path = join (self.archdir,pattern)
        for f in glob.glob(path):
            numstr = findstring (f,patstart,".zip")
            if numstr == None:
                continue
            num = int(numstr)
            if num > last:
                last = num
            if first == None or num < first:
                first = num
            count = count + 1
        if last == 0:   #new file
            return True
        if last > current:
            self.log("Problem: zip file with higher turn number found\n")
            return False
        if last + self.options.freq > current:
            return False
      
        maxF = self.options.maxfiles
        count = count + 1
        if maxF > 0 and count > maxF and first <> None:
            oldest = self.game + "-Turn" + str(first) + ".zip"
            oldest = join(self.archdir,oldest)
            self.log ("removing oldest file: " + oldest)
            remove (oldest)
        return True
    
    def doIt(self):
        opts = self.options
        if not self.getTurnNum():
            self.log ("Problem: no scorefile found. turn 1?\n")
            self.turnnum = "1"
        self.archdir = self.substitute(opts.archdir)
        self.backupdir = self.substitute(opts.backupdir)
        if opts.restore:
            print self.backupdir
            self.restoreFiles()
            sys.exit(0)
        if opts.archive <> None:
            self.createArchive (opts.archive)
            sys.exit(0)
        if not opts.nocopy:
            self.backupFiles()
        freq = opts.freq
        if freq <= 0:
            return
        if freq == 1 or self.checkZipWrite():
            self.createArchive()


b = Backup()
b.doIt()
b.closelog()