/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class JavaMineGame
extends JFrame {
    private int mines = 10;
    private int rows = 10;
    private int cols = 10;
    private int countMines;
    private int countFlags;
    MineButton[][] mine = new MineButton[this.rows][this.cols];
    MouseListener mouseListener = new MouseClickedListener();
    private JLabel counter = new JLabel(" 000 ");
    private JLabel result = new JLabel();
    private JButton iconButton = new JButton();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem newGameItem = new JMenuItem("New Game");
    private JMenuItem saveGameItem = new JMenuItem("Save Game");
    private JMenuItem loadGameItem = new JMenuItem("Load Game");
    private JMenuItem exitGameItem = new JMenuItem("Exit Game");
    private JMenu optionsMenu = new JMenu("Options");
    private JCheckBoxMenuItem beginnerItem = new JCheckBoxMenuItem("Beginner");
    private JCheckBoxMenuItem intermediateItem = new JCheckBoxMenuItem("Intermediate");
    private JCheckBoxMenuItem advancedItem = new JCheckBoxMenuItem("Advanced");
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem directionsItem = new JMenuItem("Directions");
    private JMenuItem aboutItem = new JMenuItem("About");
    private JPanel scoreBarPanel = new JPanel();
    private JPanel innerScorePanelLeft = new JPanel();
    private JPanel innerScorePanelCenter = new JPanel();
    private JPanel innerScorePanelRight = new JPanel();
    private JPanel gameFieldPanel = new JPanel();
    private JPanel resultPanel = new JPanel();
    TimerListener tListener = new TimerListener();
    Timer clock = new Timer(1000, this.tListener);
    private int timeClock = 0;
    private String timerString = " 000 ";
    private JLabel timer = new JLabel(this.timerString);
    private JavaMineGame jmg;
    private boolean gameOver;

    public JavaMineGame() {
        super("Java Mine Sweeper Game");
        this.menuBar.add(this.fileMenu);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.add(this.newGameItem);
        this.newGameItem.setMnemonic('N');
        this.newGameItem.addActionListener(new newGameListener());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveGameItem);
        this.saveGameItem.setMnemonic('S');
        this.saveGameItem.addActionListener(new saveListener());
        this.fileMenu.add(this.loadGameItem);
        this.loadGameItem.setMnemonic('L');
        this.loadGameItem.addActionListener(new loadListener());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitGameItem);
        this.exitGameItem.setMnemonic('x');
        this.exitGameItem.addActionListener(new exitListener());
        this.menuBar.add(this.optionsMenu);
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.add(this.beginnerItem);
        this.beginnerItem.setMnemonic('B');
        this.beginnerItem.addActionListener(new BeginnerListener());
        this.beginnerItem.setSelected(true);
        this.optionsMenu.add(this.intermediateItem);
        this.intermediateItem.setMnemonic('I');
        this.intermediateItem.addActionListener(new IntermediateListener());
        this.intermediateItem.setSelected(false);
        this.optionsMenu.add(this.advancedItem);
        this.advancedItem.setMnemonic('A');
        this.advancedItem.addActionListener(new AdvancedListener());
        this.advancedItem.setSelected(false);
        this.menuBar.add(this.helpMenu);
        this.helpMenu.add(this.directionsItem);
        this.directionsItem.setMnemonic('D');
        this.directionsItem.addActionListener(new directionsListener());
        this.helpMenu.add(this.aboutItem);
        this.aboutItem.setMnemonic('A');
        this.aboutItem.addActionListener(new aboutListener());
        this.helpMenu.setMnemonic('H');
        this.setJMenuBar(this.menuBar);
        this.createScoreBarPanel();
        this.createGameFieldPanel(this.rows, this.cols, this.mines);
        this.countFlags = 0;
    }

    private void createScoreBarPanel() {
        this.scoreBarPanel.setLayout(new GridLayout(1, 3));
        this.scoreBarPanel.add((Component)this.innerScorePanelLeft, "West");
        this.scoreBarPanel.add((Component)this.innerScorePanelCenter, "Center");
        this.scoreBarPanel.add((Component)this.innerScorePanelRight, "East");
        Border border = BorderFactory.createLoweredBevelBorder();
        this.innerScorePanelLeft.add(this.counter);
        this.counter.setBorder(border);
        this.iconButton.setIcon(new ImageIcon("img/smiley1.jpg"));
        this.iconButton.setPreferredSize(new Dimension(20, 20));
        this.iconButton.addActionListener(new newGameListener());
        this.innerScorePanelCenter.add(this.iconButton);
        this.innerScorePanelRight.add(this.timer);
        this.timer.setBorder(border);
        Border border2 = BorderFactory.createRaisedBevelBorder();
        this.scoreBarPanel.setBorder(border2);
        this.getContentPane().add((Component)this.scoreBarPanel, "North");
    }

    public void createGameFieldPanel(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        this.countFlags = 0;
        this.gameFieldPanel.setLayout(new GridLayout(n7, n8));
        for (n6 = 0; n6 < n7; ++n6) {
            for (int i = 0; i < n8; ++i) {
                this.mine[n6][i] = new MineButton(n6, i);
                this.gameFieldPanel.add(this.mine[n6][i]);
                this.mine[n6][i].addMouseListener(this.mouseListener);
            }
            this.changeCounter(" 0" + Integer.toString(n9) + " ");
        }
        n6 = 0;
        Random random = new Random();
        do {
            if (this.mine[n5 = random.nextInt(n7)][n4 = random.nextInt(n8)].getIsMine()) continue;
            this.mine[n5][n4].setMineTrue();
            ++n6;
        } while (n6 < n9);
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < n8; ++n4) {
                int n10 = 0;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        try {
                            if (i == 0 && j == 0 || !this.mine[n5 + i][n4 + j].getIsMine()) continue;
                            ++n10;
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
                this.mine[n5][n4].setNumAdjMines(n10);
            }
        }
        this.getContentPane().add((Component)this.gameFieldPanel, "Center");
        this.pack();
        this.gameOver = false;
    }

    public void changeCounter(String string) {
        this.counter.setText(string);
    }

    public void displayResult(String string) {
        this.result.setText(string);
        this.resultPanel.add(this.result);
        this.getContentPane().add((Component)this.resultPanel, "South");
        this.pack();
    }

    public void checkForWin() {
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (!this.mine[i][j].getIsMine() || !this.mine[i][j].getIsFlagged()) continue;
                ++n;
            }
        }
        if (n == this.mines) {
            this.displayResult("You Win!!!");
            this.iconButton.setIcon(new ImageIcon("img/smiley3.jpg"));
            if (this.clock.isRunning()) {
                this.clock.stop();
            }
            this.gameOver = true;
        }
    }

    public void checkForBlanks() {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    MineButton mineButton = this.mine[i][j];
                    if (mineButton.getIsCovered() || mineButton.getNumAdjMines() != 0) continue;
                    for (int k = -1; k < 2; ++k) {
                        for (int i2 = -1; i2 < 2; ++i2) {
                            try {
                                if (k == 0 && i2 == 0) continue;
                                if (this.mine[i + k][j + i2].getIsCovered() && this.mine[i + k][j + i2].getNumAdjMines() == 0 && !this.mine[i + k][j + i2].getIsFlagged()) {
                                    this.mine[i + k][j + i2].setIcon(new ImageIcon("img/blank.jpg"));
                                    this.mine[i + k][j + i2].removeMouseListener(this.mouseListener);
                                    this.mine[i + k][j + i2].setCover(false);
                                    bl = true;
                                    continue;
                                }
                                if (!this.mine[i + k][j + i2].getIsCovered() || this.mine[i + k][j + i2].getNumAdjMines() <= 0 || this.mine[i + k][j + i2].getIsFlagged()) continue;
                                String string = "img/" + Integer.toString(this.mine[i + k][j + i2].getNumAdjMines()) + "mine.jpg";
                                this.mine[i + k][j + i2].setIcon(new ImageIcon(string));
                                this.mine[i + k][j + i2].setCover(false);
                                this.mine[i + k][j + i2].removeMouseListener(this.mouseListener);
                                bl = true;
                                continue;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        } while (bl);
    }

    public void uncoverAllMines() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                String string;
                MineButton mineButton = this.mine[i][j];
                if ((mineButton.getIsCovered() || mineButton.getIsFlagged()) && mineButton.getNumAdjMines() == 0 && !mineButton.getIsMine()) {
                    mineButton.setIcon(new ImageIcon("img/blank.jpg"));
                    mineButton.setCover(false);
                    continue;
                }
                if ((mineButton.getIsCovered() || mineButton.getIsFlagged()) && mineButton.getNumAdjMines() > 0 && !mineButton.getIsMine()) {
                    string = "img/" + Integer.toString(mineButton.getNumAdjMines()) + "mine.jpg";
                    mineButton.setIcon(new ImageIcon(string));
                    mineButton.setCover(false);
                    continue;
                }
                if (!mineButton.getIsCovered() && !mineButton.getIsFlagged() || !mineButton.getIsMine()) continue;
                string = "img/" + Integer.toString(mineButton.getNumAdjMines()) + "mine.jpg";
                mineButton.setIcon(new ImageIcon("img/mine.jpg"));
                mineButton.setCover(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        JavaMineGame javaMineGame = new JavaMineGame();
        javaMineGame.setDefaultCloseOperation(3);
        javaMineGame.setVisible(true);
        javaMineGame.pack();
        javaMineGame.setResizable(false);
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JavaMineGame.this.timeClock++;
            if (JavaMineGame.this.timeClock < 10) {
                JavaMineGame.this.timerString = " 00" + Integer.toString(JavaMineGame.this.timeClock) + " ";
            } else if (JavaMineGame.this.timeClock < 100) {
                JavaMineGame.this.timerString = " 0" + Integer.toString(JavaMineGame.this.timeClock) + " ";
            } else if (JavaMineGame.this.timeClock < 1000) {
                JavaMineGame.this.timerString = " " + Integer.toString(JavaMineGame.this.timeClock) + " ";
            } else {
                JavaMineGame.this.timerString = " 999 ";
                JavaMineGame.this.clock.stop();
            }
            JavaMineGame.this.timer.setText(JavaMineGame.this.timerString);
        }
    }

    private class saveListener
    implements ActionListener {
        private saveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SaveGame saveGame = new SaveGame(JavaMineGame.this.mine, JavaMineGame.this.mines, JavaMineGame.this.rows, JavaMineGame.this.cols, JavaMineGame.this.countFlags, JavaMineGame.this.timeClock);
                File file = new File("savegame.dat");
                JFileChooser jFileChooser = new JFileChooser("./savegame/");
                int n = jFileChooser.showSaveDialog(JavaMineGame.this.jmg);
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(saveGame);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class loadListener
    implements ActionListener {
        private loadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n;
                File file = new File("savegame.dat");
                JFileChooser jFileChooser = new JFileChooser("./savegame/");
                int n2 = jFileChooser.showOpenDialog(JavaMineGame.this.jmg);
                if (n2 == 0) {
                    file = jFileChooser.getSelectedFile();
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                SaveGame saveGame = (SaveGame)objectInputStream.readObject();
                objectInputStream.close();
                if (JavaMineGame.this.clock.isRunning()) {
                    JavaMineGame.this.clock.stop();
                }
                for (int i = 0; i < JavaMineGame.this.rows; ++i) {
                    for (n = 0; n < JavaMineGame.this.cols; ++n) {
                        JavaMineGame.this.gameFieldPanel.remove(JavaMineGame.this.mine[i][n]);
                    }
                }
                JavaMineGame.this.mine = saveGame.getMineArray();
                JavaMineGame.this.mines = saveGame.getNumMines();
                JavaMineGame.this.rows = saveGame.getRows();
                JavaMineGame.this.cols = saveGame.getCols();
                JavaMineGame.this.timeClock = saveGame.getTimeClock();
                JavaMineGame.this.countFlags = saveGame.getCountFlags();
                if (JavaMineGame.this.timeClock < 10) {
                    JavaMineGame.this.timerString = " 00" + Integer.toString(JavaMineGame.this.timeClock) + " ";
                } else if (JavaMineGame.this.timeClock < 100) {
                    JavaMineGame.this.timerString = " 0" + Integer.toString(JavaMineGame.this.timeClock) + " ";
                } else if (JavaMineGame.this.timeClock < 1000) {
                    JavaMineGame.this.timerString = " " + Integer.toString(JavaMineGame.this.timeClock) + " ";
                } else {
                    JavaMineGame.this.timerString = " 999 ";
                }
                JavaMineGame.this.timer.setText(JavaMineGame.this.timerString);
                n = JavaMineGame.this.mines - JavaMineGame.this.countFlags;
                String string = n < 10 ? " 00" + Integer.toString(n) + " " : (n < 100 ? " 0" + Integer.toString(n) + " " : " " + Integer.toString(n) + " ");
                JavaMineGame.this.changeCounter(string);
                JavaMineGame.this.gameFieldPanel.setLayout(new GridLayout(JavaMineGame.this.rows, JavaMineGame.this.cols));
                for (int i = 0; i < JavaMineGame.this.rows; ++i) {
                    for (int j = 0; j < JavaMineGame.this.cols; ++j) {
                        JavaMineGame.this.gameFieldPanel.add(JavaMineGame.this.mine[i][j]);
                        JavaMineGame.this.mine[i][j].addMouseListener(JavaMineGame.this.mouseListener);
                    }
                }
                JavaMineGame.this.getContentPane().remove(JavaMineGame.this.resultPanel);
                JavaMineGame.this.iconButton.setIcon(new ImageIcon("img/smiley1.jpg"));
                if (JavaMineGame.this.rows == 10) {
                    JavaMineGame.this.beginnerItem.setSelected(true);
                    JavaMineGame.this.intermediateItem.setSelected(false);
                    JavaMineGame.this.advancedItem.setSelected(false);
                } else if (JavaMineGame.this.rows == 16) {
                    JavaMineGame.this.beginnerItem.setSelected(false);
                    JavaMineGame.this.intermediateItem.setSelected(true);
                    JavaMineGame.this.advancedItem.setSelected(false);
                } else {
                    JavaMineGame.this.beginnerItem.setSelected(false);
                    JavaMineGame.this.intermediateItem.setSelected(false);
                    JavaMineGame.this.advancedItem.setSelected(true);
                }
                JavaMineGame.this.repaint();
                JavaMineGame.this.pack();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class exitListener
    implements ActionListener {
        private exitListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JavaMineGame.this.setVisible(false);
            JavaMineGame.this.dispose();
            System.exit(0);
        }
    }

    private class directionsListener
    implements ActionListener {
        private directionsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "Rules for Java Mine Game:\n\n";
            String string2 = "Uncover squares by left clicking on them.\n";
            String string3 = "Clicking on a mine will end the game.\n";
            String string4 = "Clicking on an empty square will show you a number \n";
            String string5 = "corresponding to the number of mines adjacent to that square.\n";
            String string6 = "If there are no adjacent mines the square will be blank and \n";
            String string7 = "the game will uncover all adjacent mines automatically.\n\n";
            String string8 = "Right click a square that you believe contains a mine to flag it.\n";
            String string9 = "Right click again to remove a flag.\n\n";
            String string10 = "The game will be won when all mines are correctly flagged.";
            String string11 = string + string2 + string3 + string4 + string5 + string6 + string7 + string8 + string9 + string10;
            JOptionPane.showMessageDialog(null, string11, "Directions", -1);
        }
    }

    private class aboutListener
    implements ActionListener {
        private aboutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(null, "Java Mine Game V1.0.\nWritten by George Perley\nNovember 9, 2006", "About Java Mine Game", -1);
        }
    }

    private class AdvancedListener
    implements ActionListener {
        private AdvancedListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JavaMineGame.this.clock.isRunning()) {
                JavaMineGame.this.clock.stop();
            }
            JavaMineGame.this.beginnerItem.setSelected(false);
            JavaMineGame.this.intermediateItem.setSelected(false);
            JavaMineGame.this.advancedItem.setSelected(true);
            JavaMineGame.this.gameFieldPanel.setVisible(false);
            for (int i = 0; i < JavaMineGame.this.rows; ++i) {
                for (int j = 0; j < JavaMineGame.this.cols; ++j) {
                    JavaMineGame.this.gameFieldPanel.remove(JavaMineGame.this.mine[i][j]);
                }
            }
            JavaMineGame.this.rows = 22;
            JavaMineGame.this.cols = 22;
            JavaMineGame.this.mines = 99;
            JavaMineGame.this.mine = new MineButton[JavaMineGame.this.rows][JavaMineGame.this.cols];
            JavaMineGame.this.createGameFieldPanel(JavaMineGame.this.rows, JavaMineGame.this.cols, JavaMineGame.this.mines);
            JavaMineGame.this.gameFieldPanel.setVisible(true);
            JavaMineGame.this.getContentPane().remove(JavaMineGame.this.resultPanel);
            JavaMineGame.this.iconButton.setIcon(new ImageIcon("img/smiley1.jpg"));
            JavaMineGame.this.timeClock = 0;
            JavaMineGame.this.timer.setText(" 000 ");
            JavaMineGame.this.repaint();
            JavaMineGame.this.pack();
        }
    }

    private class IntermediateListener
    implements ActionListener {
        private IntermediateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JavaMineGame.this.clock.isRunning()) {
                JavaMineGame.this.clock.stop();
            }
            JavaMineGame.this.beginnerItem.setSelected(false);
            JavaMineGame.this.intermediateItem.setSelected(true);
            JavaMineGame.this.advancedItem.setSelected(false);
            for (int i = 0; i < JavaMineGame.this.rows; ++i) {
                for (int j = 0; j < JavaMineGame.this.cols; ++j) {
                    JavaMineGame.this.gameFieldPanel.remove(JavaMineGame.this.mine[i][j]);
                }
            }
            JavaMineGame.this.rows = 16;
            JavaMineGame.this.cols = 16;
            JavaMineGame.this.mines = 40;
            JavaMineGame.this.mine = new MineButton[JavaMineGame.this.rows][JavaMineGame.this.cols];
            JavaMineGame.this.createGameFieldPanel(JavaMineGame.this.rows, JavaMineGame.this.cols, JavaMineGame.this.mines);
            JavaMineGame.this.getContentPane().remove(JavaMineGame.this.resultPanel);
            JavaMineGame.this.iconButton.setIcon(new ImageIcon("img/smiley1.jpg"));
            if (JavaMineGame.this.clock.isRunning()) {
                JavaMineGame.this.clock.stop();
            }
            JavaMineGame.this.timeClock = 0;
            JavaMineGame.this.timer.setText(" 000 ");
            JavaMineGame.this.repaint();
            JavaMineGame.this.pack();
        }
    }

    private class BeginnerListener
    implements ActionListener {
        private BeginnerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JavaMineGame.this.clock.isRunning()) {
                JavaMineGame.this.clock.stop();
            }
            JavaMineGame.this.beginnerItem.setSelected(true);
            JavaMineGame.this.intermediateItem.setSelected(false);
            JavaMineGame.this.advancedItem.setSelected(false);
            for (int i = 0; i < JavaMineGame.this.rows; ++i) {
                for (int j = 0; j < JavaMineGame.this.cols; ++j) {
                    JavaMineGame.this.gameFieldPanel.remove(JavaMineGame.this.mine[i][j]);
                }
            }
            JavaMineGame.this.rows = 10;
            JavaMineGame.this.cols = 10;
            JavaMineGame.this.mines = 10;
            JavaMineGame.this.mine = new MineButton[JavaMineGame.this.rows][JavaMineGame.this.cols];
            JavaMineGame.this.createGameFieldPanel(JavaMineGame.this.rows, JavaMineGame.this.cols, JavaMineGame.this.mines);
            JavaMineGame.this.getContentPane().remove(JavaMineGame.this.resultPanel);
            JavaMineGame.this.iconButton.setIcon(new ImageIcon("img/smiley1.jpg"));
            if (JavaMineGame.this.clock.isRunning()) {
                JavaMineGame.this.clock.stop();
            }
            JavaMineGame.this.timeClock = 0;
            JavaMineGame.this.timer.setText(" 000 ");
            JavaMineGame.this.repaint();
            JavaMineGame.this.pack();
        }
    }

    private class newGameListener
    implements ActionListener {
        private newGameListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JavaMineGame.this.clock.isRunning()) {
                JavaMineGame.this.clock.stop();
            }
            for (int i = 0; i < JavaMineGame.this.rows; ++i) {
                for (int j = 0; j < JavaMineGame.this.cols; ++j) {
                    JavaMineGame.this.gameFieldPanel.remove(JavaMineGame.this.mine[i][j]);
                }
            }
            JavaMineGame.this.repaint();
            JavaMineGame.this.createGameFieldPanel(JavaMineGame.this.rows, JavaMineGame.this.cols, JavaMineGame.this.mines);
            JavaMineGame.this.getContentPane().remove(JavaMineGame.this.resultPanel);
            JavaMineGame.this.iconButton.setIcon(new ImageIcon("img/smiley1.jpg"));
            JavaMineGame.this.timeClock = 0;
            JavaMineGame.this.timer.setText(" 000 ");
            JavaMineGame.this.pack();
        }
    }

    public class MouseClickedListener
    implements MouseListener {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                MineButton mineButton;
                if (!JavaMineGame.this.clock.isRunning()) {
                    JavaMineGame.this.clock.start();
                }
                if ((mineButton = (MineButton)mouseEvent.getSource()).getIsMine() && !mineButton.getIsFlagged() && !JavaMineGame.this.gameOver) {
                    mineButton.setIcon(new ImageIcon("img/mine.jpg"));
                    mineButton.removeMouseListener(JavaMineGame.this.mouseListener);
                    JavaMineGame.this.displayResult("Sorry, You lose!");
                    if (JavaMineGame.this.clock.isRunning()) {
                        JavaMineGame.this.clock.stop();
                    }
                    JavaMineGame.this.iconButton.setIcon(new ImageIcon("img/smiley2.jpg"));
                    JavaMineGame.this.gameOver = true;
                    Date date = new Date();
                    System.out.println(date);
                    for (int i = 0; i < 500000; ++i) {
                    }
                    Date date2 = new Date();
                    System.out.println(date2);
                    System.out.println(date);
                    System.out.println(date2);
                    date2 = date;
                    System.out.println(date2);
                    JavaMineGame.this.uncoverAllMines();
                } else if (mineButton.getNumAdjMines() == 0 && mineButton.getIsCovered() && !mineButton.getIsFlagged() && !JavaMineGame.this.gameOver) {
                    mineButton.setIcon(new ImageIcon("img/blank.jpg"));
                    mineButton.setCover(false);
                    mineButton.removeMouseListener(JavaMineGame.this.mouseListener);
                    JavaMineGame.this.checkForBlanks();
                } else if (mineButton.getNumAdjMines() > 0 && mineButton.getIsCovered() && !mineButton.getIsFlagged() && !JavaMineGame.this.gameOver) {
                    String string = "img/" + Integer.toString(mineButton.getNumAdjMines()) + "mine.jpg";
                    mineButton.setIcon(new ImageIcon(string));
                    mineButton.removeMouseListener(JavaMineGame.this.mouseListener);
                    mineButton.setCover(false);
                }
            } else if (mouseEvent.getButton() == 3) {
                MineButton mineButton;
                if (!JavaMineGame.this.clock.isRunning()) {
                    JavaMineGame.this.clock.start();
                }
                if (!(mineButton = (MineButton)mouseEvent.getSource()).getIsFlagged() && mineButton.getIsCovered() && !JavaMineGame.this.gameOver && JavaMineGame.this.countFlags != JavaMineGame.this.mines) {
                    mineButton.setFlag(true);
                    mineButton.setIcon(new ImageIcon("img/flagged.jpg"));
                    JavaMineGame.this.countFlags++;
                    int n = JavaMineGame.this.mines - JavaMineGame.this.countFlags;
                    String string = n < 10 ? " 00" + Integer.toString(n) + " " : (n < 99 ? " 0" + Integer.toString(n) + " " : " " + Integer.toString(n) + " ");
                    JavaMineGame.this.changeCounter(string);
                    if (JavaMineGame.this.countFlags == JavaMineGame.this.mines) {
                        JavaMineGame.this.checkForWin();
                    }
                } else if (mineButton.getIsFlagged() && mineButton.getIsCovered() && !JavaMineGame.this.gameOver) {
                    mineButton.setFlag(false);
                    mineButton.setIcon(new ImageIcon("img/unclicked.jpg"));
                    JavaMineGame.this.countFlags--;
                    int n = JavaMineGame.this.mines - JavaMineGame.this.countFlags;
                    String string = n < 10 ? " 00" + Integer.toString(n) + " " : (n < 99 ? " 0" + Integer.toString(n) + " " : " " + Integer.toString(n) + " ");
                    JavaMineGame.this.changeCounter(string);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

