#!/bin/sh
exec wish -f "$0" ${1+$@"}

# Arralens Dominions2 Map Randomizer
#
#    for use with Illwinter.com 's
#    DOMINIONS 2 computer game
#    from version 2.14 up
#  VERSION 0.1 build 002

##################################################
#
# Variables
#
# global ...
#
#global vMapFileTypes
#global vMap
#global vMapNew

# Variables Init
set vRandFolk 0
set vRandCastle 0
set vChokeCheck 0
set vFortLab 0
set vThemedProv 0
set vSourcePath ""

# set paths / packages
set vProgPath [pwd]

# Main window style
set vWinWidth 550
set vWinHeight 430

font create fheadline -family Arial\
     -size 8 -weight bold -slant roman


# Randomization Options Variables
# set vRandOption 1; only with radiobuttons


set vMapFileTypes {
    {"Dominions2 Map Files" { .map .MAP .Map}}
    {"Text Files" { .txt .TXT }}
    {"All Files" *}
    }

# debug version variables
set vDebugVersion 0
set vDebugBorder [expr $vDebugVersion+1]
if {$vDebugVersion != 1} then {
    set vDebugRelief "flat"
    } else {
    set vDebugRelief "groove"
    }


##################################################
#
# Packages
#

lappend auto_path $vProgPath/Lib
package require csv


##################################################
#
# Procedures
#
# proc {} {
# }
#

        # file handling procedures

proc pUserOpenMapFileOld {} {
    global vMapFileTypes
    global vMapPath
    global vMap
    #Dateitypen festlegen
    set vMapPath [tk_getOpenFile\
        -initialdir [pwd]\
        -filetypes $vMapFileTypes\
        -parent .\
        -title "Datei ffnen..."]
    #In die proc ReadMapFile gehen
    pReadMapFile
    }

proc pUserSaveMapFileNew {} {
    global vMapFileTypes
    global vMapPath
    global vMapNewPath
    global vMapNew
    #Dateitypen festlegen
    set vMapNewPath [tk_getSaveFile\
        -initialdir $vMapPath\
        -filetypes $vMapFileTypes\
        -defaultextension .map\
        -parent .\
        -title "Datei speichern..."]
    #In die proc WriteMapFile gehen
    pWriteMapFile
    }



        # map creation procedures

proc pCreateMapFileNew {} {
    }





##################################################
#
# Main Programm Window

# Creation #


wm title . "Arralens Dominions2 Map Randomizer v0.1.002"
set x [expr ([winfo screenwidth .] - $vWinWidth)/2]
set y [expr ([winfo screenheight .] - $vWinHeight)/2]
wm geometry . ${vWinWidth}x${vWinHeight}+$x+$y
wm resizable . 0 0

        # file reading section #
# -width 450
frame .fr1 -bd 2 -relief groove -height 50
    pack .fr1 -anchor nw -fill x -padx 20 -pady 20 -ipadx 0 -ipady 5
label .fr1.lb1 -text "1. Choose Map File for Randomization" -font fheadline\
    -textvariable "" -state normal -relief $vDebugRelief -bd $vDebugBorder
    pack .fr1.lb1 -side left -anchor w -fill none -expand 0\
    -padx 2 -pady 0 -ipadx 0 -ipady 0
button .fr1.bt1 -text "Open Old Map File" -underline 0 -textvariable ""\
    -state normal -relief groove -overrelief raised -bd 2\
    -fg SystemButtonText -bg SystemButtonFace -compound none \
    -command {pUserOpenMapFileOld}
    pack .fr1.bt1 -side right -anchor e -fill y -expand 0\
    -padx 1 -pady 1 -ipadx 0 -ipady 0

        # randominzing options section #

frame .fr2 -bd 2 -relief groove
    pack .fr2 -anchor nw -fill x -padx 20 -pady 0 -ipadx 0 -ipady 0
label .fr2.lb1 -text "2. Randomizing Options - please choose from of the following:"\
    -font fheadline -relief $vDebugRelief -bd $vDebugBorder
    pack .fr2.lb1 -side top -anchor nw -fill none -expand 0\
    -padx 2 -pady 0 -ipadx 0 -ipady 0

# radiobutton .fr2.rbt1 -text "randomize folks only (default)" -variable "vRandOption"\
#    -value 1 -state active -command {}
#     pack .fr2.rbt1 -side top -anchor w -fill none -padx 20
# radiobutton .fr2.rbt2 -text "randomize folk and castles" -variable "vRandOption"\
#    -value 2 -state disabled -command {}
#    pack .fr2.rbt2  -side top -anchor w -fill none -padx 20
# radiobutton .fr2.rbt3 -text "randomize folk, place castles at special places" -variable "vRandOption"\
#    -value 3 -state disabled -command {}
#    pack .fr2.rbt3  -side top -anchor w -fill none -padx 20

checkbutton .fr2.chkbtn1 -text "randomize poptypes (default)"\
    -textvariable "" -variable vRandFolk\
    -indicatoron true -onvalue "1" -offvalue "0"\
    -fg SystemButtonText -bg SystemButtonFace\
    -state normal\
    -command {}
    pack .fr2.chkbtn1 -side top -anchor w -fill none -expand 0\
    -padx 20 -pady 0 -ipadx 0 -ipady 0
    .fr2.chkbtn1 select

checkbutton .fr2.chkbtn2 -text "place castles"\
    -textvariable "" -variable vRandCastle\
    -indicatoron true -onvalue "1" -offvalue "0"\
    -fg SystemButtonText -bg SystemButtonFace\
     -state disabled\
    -command {}
    pack .fr2.chkbtn2 -side top -anchor w -fill none -expand 0\
    -padx 20 -pady 0 -ipadx 0 -ipady 0
 radiobutton .fr2.rbt1 -text "completely random (default)" -variable "vChokeCheck"\
    -value 0 -state disabled -command {}
     pack .fr2.rbt1 -side top -anchor w -fill none -padx 40
 radiobutton .fr2.rbt2 -text "check for chokepoints" -variable "vChokeCheck"\
    -value 1 -state disabled -command {}
    pack .fr2.rbt2  -side top -anchor w -fill none -padx 40

checkbutton .fr2.chkbtn3 -text "place random labs"\
    -textvariable "" -variable vRandLabs\
    -indicatoron true -onvalue "1" -offvalue "0"\
    -fg SystemButtonText -bg SystemButtonFace\
     -state disabled\
    -command {}
    pack .fr2.chkbtn3 -side top -anchor w -fill none -expand 0\
    -padx 20 -pady 0 -ipadx 0 -ipady 0
 radiobutton .fr2.rbt3 -text "completely random (default)" -variable "vFortLab"\
    -value 0 -state disabled -command {}
     pack .fr2.rbt3 -side top -anchor w -fill none -padx 40
 radiobutton .fr2.rbt4 -text "prefer castled provinces" -variable "vFortLab"\
    -value 1 -state disabled -command {}
    pack .fr2.rbt4  -side top -anchor w -fill none -padx 40

checkbutton .fr2.chkbtn4 -text "place special themed provinces"\
    -textvariable ""    -variable vThemedProv\
    -indicatoron true -onvalue "1" -offvalue "0"\
    -fg SystemButtonText -bg SystemButtonFace\
     -state disabled\
    -command {}
    pack .fr2.chkbtn4 -side top -anchor w -fill none -expand 0\
    -padx 20 -pady 0 -ipadx 0 -ipady 0

button .fr2.bt1 -text "Randomize Now !" -underline 0 -textvariable ""\
    -state normal -width 50 -relief groove -overrelief raised -bd 2\
    -fg SpringGreen4 -bg SystemButtonFace -compound none \
    -command {}
    pack .fr2.bt1 -side top -anchor n -padx 10 -pady 10

        # file saving section #

frame .fr3 -bd 2 -relief groove -height 50
    pack .fr3 -anchor nw -fill x -padx 20 -pady 20 -ipadx 0 -ipady 5
label .fr3.lb1 -text "3. Save new Map File" -textvariable ""\
    -font fheadline -state normal -relief flat -bd $vDebugBorder
    pack .fr3.lb1 -side left -anchor w -fill none -expand 0\
    -padx 2 -pady 0 -ipadx 0 -ipady 0
button .fr3.bt1 -text "Save New Map File" -underline 0 -textvariable ""\
    -state normal -relief groove -overrelief raised -bd 2\
    -fg SystemButtonText -bg SystemButtonFace -compound none \
    -command {pUserSaveMapFileNew}
    pack .fr3.bt1 -side right -anchor e -expand 0\
    -fill y -padx 1 -pady 1 -ipadx 0 -ipady 0

        # programm end button #

button .bt1 -text "End !" -underline 0 -textvariable ""\
    -state normal -width 50 -relief groove -overrelief raised -bd 2\
    -fg SystemButtonText -bg SystemButtonFace -compound none -command {exit}
    pack .bt1 -side top -anchor center -expand 0 -fill y -padx 20 -pady 0

# Main Programm Code
# reading monster lists etc.



# vRandFolk 1
# vRandCastle 0
# vChokeCheck 0
# vFortLab 0
# vThemedProv 0




focus -force .