#modname "Urdheim, The Infinite Horde"
#description "EA nation of Kobolds called Urdheim."
#icon "./kobold/koboldbanner.tga"
#version 0.50
#domversion 3.14

-- Weapon 	880-898
-- Armor 	380-381
-- Monsters 	2865-2899
-- Sites 	880-881
-- Nation 	78


-- Spells

-- Rituals

#newspell
#name "Call Reinforcements"
#descr "The caster summons a group of Kobolds from one of the underground colonies."
#school 0
#researchlevel 0
#path 0 3
#pathlevel 0 1
#damage 2880
#effect 10001
#fatiguecost 500
#nreff 30
#restricted 78
#end

#newspell
#name "Guide Kobold Band"
#descr "Given enough time and guidance a kobold can travel across vast distances through underground tunnels to any location. A small strike force is sent out, and the caster keeps track of where the kobolds are in relation to the target, and sends updates once a night on which tunnels to take through dream messages to the lead kobold. (The caster summons a group of Kobolds Skirmishers. The summoning can occur in a distant province, usually for the purpose of ambushing.)"
#school 0
#researchlevel 2
#path 0 3
#path 1 0
#pathlevel 0 2
#pathlevel 1 1
#damage 2884
#effect 10037
#fatiguecost 1200
#nreff 1028
#restricted 78
#end

#newspell
#name "Guide Kobold Horde"
#descr "Given enough time and guidance a kobold can travel across vast distances through underground tunnels to any location. A sizable strike force is sent out, and the caster keeps track of where the kobolds are in relation to the target, and sends updates once a night on which tunnels to take through dream messages to the lead kobold. (The caster summons a large group of armed Kobolds Raiders. The summoning can occur in a distant province, usually for the purpose of ambushing or raiding.)"
#school 0
#researchlevel 4
#path 0 3
#path 1 0
#pathlevel 0 3
#pathlevel 1 2
#damage 2885
#effect 10037
#fatiguecost 1800
#nreff 2034
#restricted 78
#end

#newspell
#name "Create Warrior Ascendants"
#descr "Through the use of dragon's blood, the caster creates a group of powerful Glaurung Ascendants out of lesser creatures."
#school 0
#researchlevel 0
#path 0 0
#path 1 8
#pathlevel 0 4
#pathlevel 1 1
#damage 2888
#effect 10001
#fatiguecost 1600
#nreff 1000
#restricted 78
#end

#newspell
#name "Gather Cursed"
#descr "The caster gathers a few of the Cursed Ones."
#school 0
#researchlevel 6
#path 0 5
#pathlevel 0 2
#damage 2874
#effect 10001
#fatiguecost 200
#nreff 2
#restricted 78
#end

#newspell
#name "Return Ancestor"
#descr "The caster summons back the spirit of a dead dragon into a prepared statue."
#school 0
#researchlevel 5
#path 0 5
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#damage 2872
#effect 10021
#fatiguecost 1200
#nreff 1
#restricted 78
#end

#newspell
#name "Call Dracolich"
#descr "The caster performs a ritual which calls forth the spirit of an undead dragon. The mighty Draconic Demilich possesses an unusual form."
#school 4
#researchlevel 8
#path 0 5
#pathlevel 0 5
#damage 2871
#effect 10021
#fatiguecost 8000
#nreff 1
#restricted 78
#end

#newspell
#name "Enliven Ancient Gargoyle"
#descr "The caster breathes false life into an exceptionally large and well crafted ancient gargoyle statue."
#school 4
#researchlevel 7
#path 0 3
#path 1 1
#pathlevel 0 3
#pathlevel 1 1
#damage 2873
#effect 10001
#fatiguecost 2000
#nreff 1
#restricted 78
#end



-- Combat


#newspell
#copyspell "Fireball"
#name "Flamecast"
#descr "Creates a short-lived bonfire over a sizeable area. This is the archetypal spell of all descendants of Glaurung."
#school 2
#researchlevel 3
#path 0 0
#path 1 8
#pathlevel 0 3
#pathlevel 1 1
#aoe 1001
#damage 2003
#fatiguecost 30
#flightspr -1
#nreff 1
#range 45
#precision 2
#sound 16
#spec 96
#restricted 78
#end

#newspell
#copyspell "Bonds of Fire"
#name "Trigger Fire Trap"
#descr "The caster magically activates from a long distance a trap already laid out on the battlefield. The trap functions similarly to Bonds of Fire."
#researchlevel 0
#path 0 0
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 30
#aoe 1000
#range 45
#restricted 78
#end

#newspell
#copyspell "Curse of Stones"
#name "Castigation of Sirrush"
#descr "Sirrush was as subtle as she was devious. To this end, she did not just destroy those who opposed her, she wanted them to know the futility of their actions. Then she saw fit to punish them for even considering attacking her. This is her trademark spell. It makes every step and movement difficult and tiring, as well as clouding the mind."
#researchlevel 0
#pathlevel 0 3
#aoe 1002
#fatiguecost 50
#range 45
#precision 1
#nreff 1
#nextspell "Confusion"
#spec 8650752
#restricted 78
#end

#newspell
#name "Ambush"
#descr "Unleash the hidden ambuscade." 
#fatiguecost 80
#school 0
#researchlevel 3
#path 0 3
#path 1 0
#pathlevel 0 2
#pathlevel 1 1
#effect 43
#damage 2884
#nreff 1014
#restricted 78
#end

#newspell
-- Strength
#name "Draconic Might"
#descr "Summons up the ancient and unyielding strength of dragons and bestows it upon your units."
#effect 10
#damage 128
#aoe 666
#range 10
#precision 100
#spec 4194304
- Friendly units only
#school 4
#researchlevel 5
#fatiguecost 50
#path 0 3
#path 1 5
#pathlevel 0 2
#pathlevel 1 1
#restricted 78
#end

#newspell
-- Magic resist
#name "Draconic Spirit"
#descr "Summons up the ancient and unyielding spirit of dragons and bestows their resistance to magical arts upon your units."
#effect 10
#damage 67108864
#aoe 666
#range 10
#precision 100
#spec 4194304
#school 4
#researchlevel 6
#fatiguecost 60
#path 0 0
#path 1 5
#pathlevel 0 2
#pathlevel 1 2
#restricted 78
#end

#newspell
#name "Summon Cursed"
#descr "The caster calls up several Cursed Ones to rise up from beneath the earth. They remain for but the battle."
#school 0
#researchlevel 6
#path 0 5
#pathlevel 0 2
#effect 43
#damage 2874
#fatiguecost 100
#nreff 4
#flightspr -1
#restricted 78
#end


-- Weapons


#newweapon 880
#name "Poison Shortspear"
#att 0
#def 0
#dmg 4
#len 3
#nratt 1
#rcost 1
#secondaryeffect 50
#sound 12
#end

#newweapon 881
#name "Poison Throwing Dagger"
#att 0
#def 0
#dmg 4
#ammo 1
#flyspr 304 1
#nostr
#nratt 1
#range 8
#rcost 1
#secondaryeffect 50
#sound 7
#end

#newweapon 882
#name "Poison Doubleshot"
#att 2
#def 0
#dmg 7
#ammo 1
#armorpiercing
#flyspr 109 1
#nostr
#nratt 2
#range 25
#rcost 5
#secondaryeffect 50
#sound 13
#end

#newweapon 883
#name "Wicked Polearm"
#att 0
#def -1
#dmg 7
#len 4
#nratt 1
#rcost 3
#secondaryeffect 50
#sound 12
#charge
#end

#newweapon 884
#name "Strider Claws"
#att 0
#def 0
#dmg 12
#nostr
#len 1
#nratt 2
#rcost 0
#sound 38
#bonus
#end

#newweapon 885
#name "Kobold Pick"
#att 0
#def 0
#dmg 2
#len 1
#nratt 1
#armorpiercing
#rcost 1
#sound 10
#end

#newweapon 886
#name "Staff of Withering"
#att 1
#def 3
#dmg 3
#len 4
#nratt 1
#magic
#rcost 10
#twohanded
#secondaryeffectalways 60
#secondaryeffect 349
#sound 22
#end

#newweapon 887
#name "Fireblast"
#att 3
#def 0
#dmg 0
#len 1
#nratt 1
#rcost 0
#explspr 10113
#bonus
#armorpiercing
#fire
#magic
#secondaryeffect 171
#sound 16
#end

#newweapon 888
#name "Fire Spikes"
#att 0
#def 0
#dmg 4
#len 0
#aoe 0
#nratt 2
#rcost 0
#sound 16
#bonus
#armorpiercing
#charge
#fire
#magic
#end

#newweapon 889
#name "Trap the Soul"
#att 100
#def 0
#dmg 1
#armornegating
#dt_cap
#nostr
#ammo 1
#flyspr -1
#explspr 10141
#nratt 10
#range 30
#aoe 0
#rcost 0
#secondaryeffect 194
#secondaryeffectalways 64
#sound 18
#bonus
#magic
#end

#newweapon 890
#name "Spiked Shield Bash"
#att 0
#def -1
#dmg -2
#len 1
#nratt 1
#rcost 0
#secondaryeffect 91
#sound 10
#end

#newweapon 891
#name "Mithril Longsword"
#att 2
#def 2
#dmg 7
#len 3
#nratt 1
#rcost 0
#magic
#sound 8
#end

#newweapon 892
#name "Torch"
#att 0
#def 0
#dmg 2
#len 1
#aoe 0
#nratt 1
#rcost 0
#sound 16
#armorpiercing
#fire
#end

#newweapon 893
#name "Summoned Flame"
#att 100
#def 0
#dmg 6
#len 0
#aoe 0
#nratt 1
#rcost 0
#explspr 10101
#flyspr -1
#bonus
#ammo 12
#range 35
#armorpiercing
#fire
#magic
#secondaryeffect 171
#sound 16
#end

#newweapon 894
#name "Net Trap"
#att 25
#def 0
#dmg 20
#ammo 3
#aoe 1
#armornegating
#nostr
#dt_stun
#range 30
#rcost 0
#bonus
#secondaryeffectalways 263
#sound 87
#end

#newweapon 895
#name "Vicious Blades Trap"
#att 25
#def 0
#dmg 1
#ammo 3
#aoe 1
#armornegating
#nostr
#dt_cap
#range 30
#rcost 0
#bonus
#secondaryeffectalways 125
#sound 19
#end

#newweapon 896
#name "Partial Displacement"
#att 100
#def 0
#dmg 6
#len 0
#aoe 0
#nratt 2
#rcost 0
#explspr 10200
#bonus
#armornegating
#magic
#secondaryeffect 156
#sound 20
#end

#newweapon 897
#name "Partial Displacement"
#att 100
#def 0
#dmg 4
#len 0
#aoe 0
#nratt 1
#rcost 0
#explspr 10200
#flyspr -1
#bonus
#ammo 20
#range 30
#armornegating
#magic
#secondaryeffect 125
#sound 20
#end

#newweapon 898
#name "Partial Displacement"
#att 100
#def 0
#dmg 2
#len 0
#aoe 0
#nratt 2
#rcost 0
#explspr 10200
#flyspr -1
#bonus
#ammo 20
#range 100
#armornegating
#magic
#secondaryeffect 335
#sound 20
#end


-- Armor

#newarmor 380
#name "Plate of the Firelords"
#type 5
#prot 12
#def -1
#enc 2
#rcost 25
#end

#newarmor 381
#name "Gem of Protection"
#type 6
#prot 8
#def 1
#enc 0
#rcost 5
#end


-- Creatures and some summons

#newmonster 2880
#name "Kobold"
#spr1 "./kobold/kobold1a.tga"
#spr2 "./kobold/kobold1b.tga"
#descr "Young Kobolds are weak, tiny, and die so easily they often do not become old kobolds. Because of this, they are cowardly, and only attack in great numbers and usually with the advantage of stealth and surprise. They like to use spears to keep their opponents at a distance."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 6
#enc 4
#att 10
#def 10
#prec 10
#mr 12
#mor 8
#gcost 5
#rcost 2
#weapon "Poison Shortspear"
#darkvision 50
#coldblood
#fireres 25
#older -45
#maxage 100
#mountainsurvival
#nametype 113
#stealthy
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2881
#name "Kobold Light Infantry"
#spr1 "./kobold/kobold2a.tga"
#spr2 "./kobold/kobold2b.tga"
#descr "Young Kobolds are weak, tiny, and die so easily they often do not become old kobolds. Because of this, they are cowardly, and only attack in great numbers and usually with the advantage of stealth and surprise. They like to use spears to keep their opponents at a distance. They sometimes throw poisoned daggers to sow confusion."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 6
#enc 4
#att 11
#def 11
#prec 10
#mr 12
#mor 9
#gcost 8
#rcost 3
#weapon "Poison Shortspear"
#weapon "Poison Throwing Dagger"
#armor "Shield"
#darkvision 50
#coldblood
#fireres 25
#older -40
#maxage 100
#mountainsurvival
#nametype 113
#stealthy
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2882
#name "Kobold Medium Infantry"
#spr1 "./kobold/kobold3a.tga"
#spr2 "./kobold/kobold3b.tga"
#descr "Older and experienced kobolds which survive past ten years have by this point scavenged, stolen, or otherwise acquired good equipment and are able to form a medium infantry. They are equipped with a device of Kobold origin, a small double crossbow, which fires two poisoned bolts. Unfortunately, despite the ingeniousness of the device, it is impossible for a single weak kobold to reload, and so is only reloaded between battles."
#ap 14
#mapmove 2
#hp 6
#prot 4
#size 1
#str 7
#enc 4
#att 12
#def 12
#prec 11
#mr 13
#mor 10
#gcost 15
#rcost 6
#weapon "Poison Shortspear"
#weapon "Poison Doubleshot"
#armor "Iron Cap"
#armor "Scale Mail Cuirass"
#armor "Shield"
#darkvision 50
#coldblood
#fireres 25
#older -35
#maxage 100
#mountainsurvival
#nametype 113
#stealthy
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2883
#name "Kobold Miner"
#spr1 "./kobold/kobold5a.tga"
#spr2 "./kobold/kobold5b.tga"
#descr "The Kobold war machine is driven by mining various ores from the earth. The lowest ranking Kobolds are given the task of tunneling and mining, and they are adept at such work, even with their tiny arms. The miners are sometimes tasked with building or destroying fortresses and other defensive constructs."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 7
#enc 3
#att 10
#def 10
#prec 10
#mr 12
#mor 8
#gcost 12
#rcost 3
#weapon "Kobold Pick"
#weapon "Kobold Pick"
#darkvision 75
#coldblood
#fireres 25
#older -45
#maxage 100
#mountainsurvival
#siegebonus 5
#castledef 2
#ambidextrous 1
#nametype 113
#stealthy
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2884
#name "Kobold Skirmisher"
#spr1 "./kobold/kobold6a.tga"
#spr2 "./kobold/kobold6b.tga"
#descr "Young Kobolds are weak, tiny, and die so easily they often do not become old kobolds. Because of this, they are cowardly, and only attack in great numbers and usually with the advantage of stealth and surprise. They like to use spears to keep their opponents at a distance. They sometimes use nets for hunting, enslaving, or war."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 6
#enc 4
#att 11
#def 11
#prec 10
#mr 12
#mor 9
#gcost 6
#rcost 2
#weapon "Poison Shortspear"
#weapon "Net"
#darkvision 50
#coldblood
#fireres 25
#older -45
#maxage 100
#mountainsurvival
#nametype 113
#stealthy
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2885
#name "Kobold Raider"
#spr1 "./kobold/kobold7a.tga"
#spr2 "./kobold/kobold7b.tga"
#descr "Young Kobolds are weak, tiny, and die so easily they often do not become old kobolds. Because of this, they are cowardly, and only attack in great numbers and usually with the advantage of stealth and surprise. Raiders use hammers and torches to smash and burn, along with natural Kobold stealth and speed to effectively pillage enemy lands. Animals tend to be wary of them."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 6
#enc 4
#att 11
#def 11
#prec 10
#mr 12
#mor 9
#gcost 9
#rcost 2
#weapon "Hammer"
#weapon "Torch"
#darkvision 50
#coldblood
#fireres 25
#older -45
#maxage 100
#mountainsurvival
#nametype 113
#ambidextrous 1
#animalawe 1
#pillagebonus 1
#stealthy
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2886
#name "Firebrand"
#spr1 "./kobold/firebrand1a.tga"
#spr2 "./kobold/firebrand1b.tga"
#descr "Some Kobolds are born with a natural talent for firebreathing just like their distant ancestors. This talent is cultivated and trained for years, supervised by reclusive and reticent Fire Lords. Though physically fragile, Firebrands are known for their ego, pride, and arrogance along with their talents for firestarting. Unlike other Kobolds, they do not care for sneaking about. They eat their own body weight in food every day. Usually not working together, when they do occasionally join forces others should be most careful. They are known as lesser Fireborn amongst Kobolds."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 6
#enc 6
#att 10
#def 10
#prec 11
#mr 12
#mor 16
#gcost 36
#rcost 1
#weapon "Fireblast"
#weapon 225
#darkvision 50
#coldblood
#fireres 100
#older -35
#maxage 100
#mountainsurvival
#nametype 113
#supplybonus -2
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2887
#name "Winged Hellion"
#spr1 "./kobold/firereaver1a.tga"
#spr2 "./kobold/firereaver1b.tga"
#descr "A successful combination and transmutation of a firebat and giant wasp, into a much larger, fiercer, and deadlier creature. They dive upon their targets from on high, usually surprising their foes. Originally created by Red Dragons of long ago to guard their lairs, they are now used by the forces of Urdheim in their quest for domination."
#ap 18
#mapmove 3
#hp 16
#prot 6
#size 2
#str 8
#enc 2
#att 12
#def 12
#prec 10
#mr 10
#mor 13
#gcost 28
#rcost 1
#weapon "Fire Spikes"
#weapon 203
#blind
#fireres 100
#flying
#heat
#older -20
#magicbeing
#maxage 100
#nametype 113
#okleader
#okmagicleader
#noundeadleader
#end

#newmonster 2874
#copystats 667
#name "Cursed One"
#spr1 "./kobold/cursed1a.tga"
#spr2 "./kobold/cursed1b.tga"
#descr "These were small amphibious reptiles distantly related to C'tissian lizardmen known as waterborn. They have taken up the task of the Ancestors, and have failed. As such, they were transformed but not for the better, and are fragments of their former selves, physically and mentally. Such is the price of failure. They wander aimlessly around inside the caverns and are sometimes gathered up by Kobold Sorcerors, and forced into battle, where they spread a part of their curse."
#ap 14
#mapmove 3
#hp 11
#prot 3
#size 2
#str 8
#enc 3
#att 15
#def 12
#prec 12
#mr 15
#mor 99
#gcost 0
#rcost 0
#weapon 284
#weapon 369
#weapon 294
#weapon 294
#armor "Nothing"
#armor "Nothing"
#armor "Nothing"
#amphibian
#blind
#darkpower 1
#ethereal
#coldres 100
#inanimate
#poisonres 100
#magicbeing
#maxage 200
#neednoteat
#nametype 113
#stealthy 20
#poorleader
#poormagicleader
#noundeadleader
#end

#newmonster 2888
#name "Glaurung Ascendant"
#spr1 "./kobold/scion2a.tga"
#spr2 "./kobold/scion2b.tga"
#descr "An Ascendant is an experienced kobold who has been transformed when the residual draconic blood is fully awakened through the proper ritual. The secret rituals of Ascension are performed by the Scions. This is the apex of kobold evolution, and every kobold seeks to be worthy enough to one day receive the ritual. This one is an Ascendant of Glaurung, and possesses related traits. Instead of wearing helmets, which would prevent them from accurately breathing fire, they have a fire gem embedded into their skull which hardens the surrounding scales. Given the best arms and armor forged in Urdheim, they are the holy shock troops of the Infinite Horde."
#ap 14
#mapmove 2
#hp 30
#prot 10
#size 3
#str 16
#enc 2
#att 13
#def 11
#prec 12
#mr 14
#mor 16
#gcost 0
#rcost 0
#weapon "Mithril Longsword"
#weapon "Spiked Shield Bash"
#weapon "Fire Breath"
#armor "Gem of Protection"
#armor "Plate Hauberk"
#armor "Tower Shield"
#darkvision 50
#ambidextrous 4
#fireres 100
#holy
#magicskill 0 1
#maxage 500
#neednoteat
#mountainsurvival
#wastesurvival
#itemslots 31878
#nametype 113
#okleader
#poormagicleader
#noundeadleader
#end

-- Commanders

#newmonster 2890
#name "Kobold Ranger"
#spr1 "./kobold/kobold1a.tga"
#spr2 "./kobold/kobold1b.tga"
#descr "Kobolds are tiny and weak lizardlike creatures possessing great speed. They are aggressive, xenophobic, yet quite industrious. Kobolds are noted for their skill at using poison, building traps, preparing ambushes, and mining. While having longer lifespans than humans, they reach adulthood in a matter of months, and breed frequently and in great numbers. They claim to be distantly related to dragons, which they worship as deities. Those who have a knack for stealth are trained as rangers. Their speed and stealth make them excellent spies. Rangers are the only kobolds who wear leather made out of old or dead Ash Wyverns, as a sign of distinction. They sometimes lead small groups of raiders."
#ap 14
#mapmove 3
#hp 5
#prot 4
#size 1
#str 6
#enc 4
#att 11
#def 11
#prec 10
#mr 12
#mor 8
#gcost 70
#rcost 3
#weapon "Poison Shortspear"
#weapon "Net Trap"
#armor "Leather Cuirass"
#armor "Leather Cap"
#darkvision 50
#coldblood
#patrolbonus 15
#fireres 25
#older -35
#maxage 100
#mountainsurvival
#wastesurvival
#nametype 113
#stealthy 10
#spy
#okleader
#nomagicleader
#noundeadleader
#end

#newmonster 2891
#name "Kobold Warchief"
#spr1 "./kobold/kobold4a.tga"
#spr2 "./kobold/kobold4b.tga"
#descr "Warchiefs are the commanders of Kobold Warbands, and are equipped like medium infantry. They are competent warriors and fine leaders. They excel at using traps in warfare. They constantly train new infantry."
#ap 14
#mapmove 2
#hp 7
#prot 5
#size 1
#str 7
#enc 4
#att 12
#def 12
#prec 10
#mr 14
#mor 12
#gcost 140
#rcost 10
#weapon "Poison Shortspear"
#weapon "Poison Doubleshot"
#weapon "Vicious Blades Trap"
#armor "Iron Cap"
#armor "Scale Mail Cuirass"
#armor "Shield"
#darkvision 50
#coldblood
#patrolbonus 8
#fireres 25
#older -25
#maxage 100
#mountainsurvival
#nametype 113
#stealthy
#summon1 2882
#goodleader
#nomagicleader
#noundeadleader
#end

#newmonster 2892
#name "Kobold Firelord"
#spr1 "./kobold/firelord1a.tga"
#spr2 "./kobold/firelord1b.tga"
#descr "Firelords are everything that a Kobold aspires to. Physically powerful not just for a Kobold, but most races, Firelords are known for their ego, pride, and arrogance along with their prodigous talents for firestarting. Unlike other Kobolds, they do not care for sneaking about. They eat their own body weight in food every day, and thus they are disliked wherever they reside. Fortunately they are quite rare. Usually not working together, when they do occasionally join forces others should be most careful. They are known as greater Fireborn amongst Kobolds. They always wear magical plate armor forged by their own hand, and enchanted by the Sorcerors to resist cold and destroy the eyes of those brave enough to strike it. Sometimes they train and lead groups of Firebrands. Few Firelords possess knowledge of fire magic, but those that do are skilled in it."
#ap 16
#mapmove 3
#hp 22
#prot 6
#size 3
#str 14
#enc 3
#att 12
#def 12
#prec 13
#mr 15
#mor 18
#gcost 220
#rcost 23
#weapon "Fireblast"
#weapon 225
#armor "Plate of the Firelords"
#custommagic 128 10
#magicboost 0 1
#darkvision 50
#coldblood
#coldres 50
#awe 1
#eyeloss
#fireres 100
#incunrest 3
#maxage 120
#mountainsurvival
#nametype 113
#makemonster1 2886
#supplybonus -10
#itemslots 14470
#expertleader
#nomagicleader
#noundeadleader
#end

#newmonster 2893
#name "Kobold Sorceror"
#spr1 "./kobold/dragonblood1a.tga"
#spr2 "./kobold/dragonblood1b.tga"
#descr "Every few generations a magicborn hatches amongst the kobolds. These magicborn are larger, stronger, and contain the spark of sorcery as their ancestors once did. They study the magical arts inside the caverns and sometimes help organize and support Kobold war bands, though they are not as spry as they once were. They generally speak for the Scions and oversee areas where no Scion resides."
#ap 12
#mapmove 2
#hp 7
#prot 4
#size 2
#str 6
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 14
#gcost 210
#rcost 3
#weapon "Staff of Withering"
#magicskill 0 2
#magicskill 3 1
#magicskill 5 1
#custommagic 5120 100
#custommagic 5248 10
#darkvision 50
#coldblood
#fireres 25
#older -17
#maxage 120
#mountainsurvival
#nametype 113
#stealthy
#okleader
#nomagicleader
#noundeadleader
#end

#newmonster 2894
#name "Scion of Glaurung"
#spr1 "./kobold/scion1a.tga"
#spr2 "./kobold/scion1b.tga"
#descr "These are descendants of dragons which have bred with other creatures. Like dragons they are powerful beings with both physical and magical might. The Scions are sacred to the Kobolds and are followed without question. This one is a descendant of Glaurung, a particularly mighty red dragon of long ago. His descendants now mostly breed amongst themselves to maintain the bloodline's purity, and some possess the ability to awaken the draconic blood in lesser creatures such as kobolds, and create Ascendants."
#ap 14
#mapmove 3
#hp 55
#prot 10
#size 4
#str 21
#enc 2
#att 13
#def 11
#prec 12
#mr 17
#mor 18
#gcost 400
#rcost 1
#weapon 29
#weapon "Fireblast"
#weapon 61
#darkvision 100
#fireres 100
#flying
#heat
#holy
#magicskill 0 3
#magicskill 8 1
#custommagic 1152 20
#custommagic 128 20
#maxage 500
#neednoteat
#mountainsurvival
#wastesurvival
#itemslots 28806
#researchbonus -2
#nametype 113
#goodleader
#poormagicleader
#noundeadleader
#end

#newmonster 2895
#name "Kobold Summoner"
#spr1 "./kobold/summoner1a.tga"
#spr2 "./kobold/summoner1b.tga"
#descr "Every few generations a magicborn hatches amongst the kobolds. These magicborn are larger, stronger, and contain the spark of sorcery as their ancestors once did. Instead of studying magic in the usual sense, they focus it inward, and learn the summoner's art inside the caverns. Sometimes they and their summons support Kobold war bands. The summoners tend and breed Ash Wyverns inside the cave. As a result, other animals greatly fear them. Though they can summon a variety of animals, their connection with the Ash Wyverns make them the best result. They can channel their summoning efforts to create flames at a distance, usually inside opponents. As a last effort, they can summon an Ash Wyvern instantly, though this means death."
#ap 14
#mapmove 3
#hp 7
#prot 4
#size 2
#str 6
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 14
#gcost 300
#rcost 3
#weapon 29
#weapon 893
#animalawe 3
#makemonster1 2875 
#secondtmpshape 2875
#supplybonus 20
#darkvision 50
#coldblood
#fireres 25
#older -25
#maxage 120
#mountainsurvival
#nametype 113
#stealthy
#okleader
#poormagicleader
#noundeadleader
#end

#newmonster 2872
#name "Dragon Ancestor"
#spr1 "./kobold/dragonstatue1a.tga"
#spr2 "./kobold/dragonstatue1b.tga"
#descr "Spirits of dragons of long ago, summoned back into a statue to sway the outcomes of war. They wield priestly powers and slowly improve faith and the land around them for dragonkind. Though they cannot fight back they are quite hard to destroy. Close proximity to the statue can lead to empowering the dragon spirit inside at the expense of your own health."
#ap 2
#mapmove 0
#hp 100
#prot 25
#size 6
#str 20
#enc 0
#att 10
#def 0
#prec 12
#mr 16
#mor 30
#gcost 30
#rcost 1
#weapon "Life Drain"
#spreaddom 1
#incunrest -2
#nobadevents 5
#fear 5
#fireres 100
#heat
#holy
#magicskill 8 3
#maxage 500
#neednoteat
#noitem
#poisonres 100
#blind
#immobile
#inanimate
#noheal
#nametype 113
#noleader
#nomagicleader
#noundeadleader
#end

#newmonster 2896
#name "Scion of Sirrush"
#spr1 "./kobold/sirrush1a.tga"
#spr2 "./kobold/sirrush1b.tga"
#descr "These are descendants of dragons which have bred with other creatures. Like dragons they are powerful beings with both physical and magical might. The Scions are sacred to the Kobolds and are followed without question. This one is a descendant of Sirrush, a particularly devious black dragon of long ago. Sirrush was able to create a bloodline of earth elementals with draconic minds and inherent magic. Her descendants don't breed like dragonkind, but replicate like earth elementals, once a century in sites of great earth magic. In this way, they maintain the purity of the bloodline, but are unable to create Ascendants."
#ap 16
#mapmove 3
#hp 72
#prot 14
#size 4
#str 24
#enc 2
#att 13
#def 10
#prec 12
#mr 17
#mor 18
#gcost 500
#rcost 1
#weapon 29
#weapon "Fireblast"
#weapon 61
#fireres 100
#poisonres 100
#holy
#regeneration 10
#magicskill 3 3
#magicskill 8 1
#custommagic 1024 20
#custommagic 4096 10
#darkvision 100
#maxage 500
#neednoteat
#mountainsurvival
#siegebonus 20
#wastesurvival
#itemslots 61446
#researchbonus -2
#nametype 113
#goodleader
#poormagicleader
#noundeadleader
#end

#newmonster 2897
#name "Waterborn"
#spr1 "./kobold/waterborn1a.tga"
#spr2 "./kobold/waterborn1b.tga"
#descr "These are small amphibious reptiles distantly related to C'tissian lizardmen. They study basic magical arts inside the caverns and sometimes help support Kobold war bands. They keep to themselves most of the time, and tend to the temples. Their status as seperate and apart from Kobold society, allows them to maintain limited independence in Kobold lands. Some of them take up the task."
#ap 10
#mapmove 2
#hp 7
#prot 0
#size 2
#str 6
#enc 3
#att 10
#def 10
#prec 12
#mr 13
#mor 12
#gcost 60
#rcost 3
#weapon "Quarterstaff"
#custommagic 8704 100
#amphibian
#coldblood
#poisonres 50
#maxage 50
#nametype 113
#poorleader
#nomagicleader
#noundeadleader
#end

#newmonster 2898
#name "Blessed One"
#spr1 "./kobold/blessed1a.tga"
#spr2 "./kobold/blessed1b.tga"
#descr "These were small amphibious reptiles distantly related to C'tissian lizardmen known as waterborn. They have taken up the task of the Ancestors, and through success have been found worthy of transformation. Blessed through the power of dragon blood, and possessing limited priestly authority, they spread the message of draconic might. They sometimes feed the faithful."
#ap 12
#mapmove 2
#hp 11
#prot 3
#size 2
#str 9
#enc 3
#att 10
#def 10
#prec 12
#mr 14
#mor 14
#gcost 140
#rcost 5
#weapon "Magic Staff"
#magicskill 8 1
#custommagic 8704 100
#custommagic 8704 20
#amphibian
#darkvision 50
#coldblood
#holy
#fireres 50
#poisonres 50
#maxage 120
#mountainsurvival
#onebattlespell "Holy Avenger"
#nametype 113
#supplybonus 20
#incunrest -1
#poorleader
#nomagicleader
#noundeadleader
#end




-- Summons

#newmonster 2875
#copystats 520
#name "Ash Wyvern"
#spr1 "./kobold/greywyvern1a.tga"
#spr2 "./kobold/greywyvern2b.tga"
#descr "Ash Wyverns are distantly related to the common wyvern. Though they are smaller and weaker, they are still just as tough. They are resistant to fire, and are sometimes found in Urdheim armies."
#size 3
#str 13
#fireres 50
#end


#newmonster 2866
#copystats 1543
#name "Magma Drake"
#spr1 "./kobold/magmadrake3a.tga"
#spr2 "./kobold/magmadrake3b.tga"
#descr "Magma Drakes are huge, rocky creatures that dwell deep underground. They can breath fire like dragons and move at a rather slothly pace until their anger is roused. They hate the cold and need to be fed some metal every once in a while." 
#ap 8
#mapmove 1
#hp 58
#prot 20
#size 5
#str 22
#enc 5
#att 10
#def 9
#prec 9
#mr 9
#mor 14
#gcost 75
#rcost 1
#weapon 20
#weapon 61
#armor "Nothing"
#maxage 90
#neednoteat
#magicbeing
#animal
#animalawe 1
#coldblood
#coldres -50
#heal
#end


#newmonster 2873
#name "Ancient Gargoyle"
#spr1 "./kobold/gargoyle1a.tga"
#spr2 "./kobold/gargoyle1b.tga"
#descr "A finely crafted winged stone monster given false life by a powerful enchantment, the Ancient Gargoyle is very difficult to destroy but will revert to an inanimate state if left on the battlefield without magical leadership."
#ap 10
#mapmove 3
#hp 120
#prot 26
#size 5
#str 25
#enc 0
#att 14
#def 10
#prec 5
#mr 16
#mor 50
#gcost 0
#rcost 1
#weapon 29
#weapon 29
#blind
#flying
#inanimate
#magicbeing
#fireres 50
#coldres 50
#shockres 50
#poisonres 100
#pooramphibian
#maxage 3200
#neednoteat
#noheal
#startage 1180
#nametype 113
#okleader
#okmagicleader
#noundeadleader
#end

#newmonster 2871
#clear
#name "Draconic Demilich"
#spr1 "./kobold/ddemilich1a.tga"
#spr2 "./kobold/ddemilich1a.tga"
#descr "A massive ancient dracolich, which has survived for aeons, and upon death, through the use of foul magics, refused to die like most dragons. Achieving immortality, it now seeks to impose its will upon the land. The malignant entity now resides solely inside the giant skull that serves as the anchor for its mind. Its animated form strikes with speed and drains life from its prey. Its highly magical and untiring body can fly across vast distances and can endure almost any hardship. It possesses some physical might, is almost impossible to slay, and is highly skilled in death magic. Over the centuries the dracolich has developed a peculiar taste, and it now possesses an otherwordly hunger. To this end it steals souls, which are consumed to power spells."
#ap 8
#mapmove 4
#hp 50
#prot 13
#size 2
#str 12
#enc 0
#att 14
#def 18
#prec 14
#mr 18
#mor 30
#gcost 0
#rcost 0
#weapon 63
#weapon 283
#weapon 889
#itemslots 28800
#coldres 100
#eyeloss
#fear 5
#flying
#gemprod 5 1
#immortal
#inanimate
#poisonres 100
#magicskill 5 6
#maxage 4000
#neednoteat
#researchbonus 3
#undead
#okleader
#goodmagicleader
#expertundeadleader
#end

-- Heroes

#newmonster 2865
#name "Master Summoner"
#spr1 "./kobold/summoner2a.tga"
#spr2 "./kobold/summoner2b.tga"
#descr "The Master Summoner is the oldest summoner alive in all Urdheim. Her powers are vast, and have been refined over several centuries. She does not bother with wyverns or lesser creatures but has mastered the ability to summon a rare form of drake from deep beneath the earth. Though she does not possess magical talents in the usual sense, she is just as dangerous as any mage. She is known as 'The Butcher' amongst kobolds, and is greatly feared for her prodigious and viciously used summoning powers. Her title comes from an ability she perfected, Partial Displacement. She summons creatures to or from great distances, but precisely stops the summon in mid-stream. Only parts of the creatures are transported. Limbs, vital organs, and various other important parts."
#ap 12
#mapmove 2
#hp 14
#prot 4
#size 2
#str 6
#enc 3
#att 12
#def 12
#prec 12
#mr 18
#mor 20
#gcost 600
#rcost 3
#weapon 896
#weapon 897
#weapon 898
#animalawe 5
#makemonster1 2866 
#darkvision 50
#coldblood
#female
#fear 5
#fireres 100
#holy
#older 200
#maxage 320
#mountainsurvival
#nametype 113
#neednoteat
#stealthy
#okleader
#okmagicleader
#noundeadleader
#end

#newmonster 2877
#name "Scion of Abraxas"
#spr1 "./kobold/scion3a.tga"
#spr2 "./kobold/scion3b.tga"
#descr "These are descendants of dragons which have bred with other creatures. Like dragons they are powerful beings with both physical and magical might. The Scions are sacred to the Kobolds and are followed without question. This one is a descendant of Abraxas, a particularly vicious white dragon of long ago. His descendants are incredibly rare, and those that remain have lost most of the bloodlines' purity and are no longer able to create ascendants from their blood."
#ap 14
#mapmove 2
#hp 30
#prot 7
#size 3
#str 16
#enc 2
#att 14
#def 13
#prec 12
#mr 15
#mor 16
#gcost 0
#rcost 0
#weapon "Enchanted Sword"
#weapon "Lightning"
#armor "Plate Cuirass"
#magicskill 1 2
#magicskill 8 1
#darkvision 100
#fireres 50
#shockres 100
#holy
#maxage 500
#neednoteat
#mountainsurvival
#wastesurvival
#onebattlespell "Air Shield"
#nametype 113
#okleader
#poormagicleader
#noundeadleader
#end

#newmonster 2878
#name "Kobold Evoker"
#spr1 "./kobold/dragonblood2a.tga"
#spr2 "./kobold/dragonblood2b.tga"
#descr "Every few generations a magicborn hatches amongst the kobolds. These magicborn are larger, stronger, and contain the spark of sorcery as their ancestors once did. They study the magical arts inside the caverns and sometimes help organize and support Kobold war bands. They generally speak for the Scions and oversee areas where no Scion resides. Evokers are incredibly rare, hardy, and elder sorcerors blessed with long life. They wield powerful destructive arts and wear golden robes of fire protection. They're constantly surrounded by a small aura of fear. They also don't much care for travelling."
#ap 8
#mapmove 1
#hp 7
#prot 4
#size 1
#str 6
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 14
#gcost 420
#rcost 3
#weapon "Staff of Withering"
#magicskill 0 2
#magicskill 3 2
#magicskill 5 2
#custommagic 5248 100
#custommagic 5248 100
#custommagic 1920 100
#darkvision 50
#coldblood
#fear 0
#fireres 100
#heal
#maxage 170
#mountainsurvival
#onebattlespell "Summon Earthpower"
#nametype 113
#older -45
#okleader
#nomagicleader
#noundeadleader
#end

#newmonster 2879
#name "Kobold Strider"
#spr1 "./kobold/koboldrider1a.tga"
#spr2 "./kobold/koboldrider1b.tga"
#descr "Every once in a great while, a kobold is hatched who is stronger and braver than the rest, but possesses none of the trademark gifts of the various higher castes. Once they are ready, these seek out to capture and tame one of the striders that occasionally roam inside the caverns. The Striders make for an excellent mount, and their riders inspire all kobolds around to acts of bravery. Experienced kobolds tend to follow the strider, ready to replace the rider if he should perish or be critically wounded, as it is much easier to ride the tamed strider, than to capture one unridden."
#ap 20
#mapmove 3
#hp 16
#prot 5
#size 3
#str 7
#enc 4
#att 12
#def 12
#prec 10
#mr 15
#mor 20
#gcost 200
#rcost 0
#weapon "Wicked Polearm"
#weapon "Strider Claws"
#armor "Iron Cap"
#armor "Full Scale Mail"
#armor "Kite Shield"
#secondshape 2867
#darkvision 50
#coldblood
#fireres 25
#heal
#older -25
#maxage 100
#mounted
#mountainsurvival
#nametype 113
#standard 20
#summon1 2882
#makemonster2 2882
#onebattlespell "Twist Fate"
#expertleader
#nomagicleader
#noundeadleader
#end

#newmonster 2867
#name "Strider"
#spr1 "./kobold/strider1a.tga"
#spr2 "./kobold/strider1b.tga"
#descr "Every once in a great while, a kobold is hatched who is stronger and braver than the rest, but possesses none of the trademark gifts of the various higher castes. Once they are ready, these seek out to capture and tame one of the striders that occasionally roam inside the caverns. The Striders make for an excellent mount, and their riders inspire all kobolds around to acts of bravery. Experienced kobolds tend to follow the strider, ready to replace the rider if he should perish, as it is much easier to ride the tamed strider."
#ap 20
#mapmove 3
#hp 27
#prot 10
#size 3
#str 14
#enc 3
#att 12
#def 12
#prec 10
#mr 15
#mor 16
#gcost 0
#rcost 0
#weapon "Strider Claws"
#firstshape 2879
#darkvision 50
#heal
#mountainsurvival
#nametype 113
#expertleader
#nomagicleader
#noundeadleader
#end

-- Pretenders

#newmonster 2870
#clear
#name "Ancient Dracolich"
#spr1 "./kobold/dracolich1a.tga"
#spr2 "./kobold/dracolich1b.tga"
#descr "A massive ancient dracolich, which has survived for aeons, and upon death, through the use of foul magics, refused to die like most dragons. Achieving immortality, it now is powerful enough to take on the mantle of a deity. It's untiring body can fly across vast distances. It possesses incredible strength, is skilled in death magic, and is almost impossible to slay. The undead being is full of hatred and malevolence, and loves warfare on a massive scale. It is why the Urdheim forces have left the relative safety of the underground to wage holy war."
#ap 14
#mapmove 4
#hp 125
#prot 13
#size 6
#str 28
#enc 0
#att 18
#def 10
#prec 12
#mr 18
#mor 30
#gcost 150
#rcost 0
#weapon 319
#weapon 33
#itemslots 28800
#coldres 100
#fear 5
#flying
#immortal
#inanimate
#siegebonus 25
#poisonres 100
#pooramphibian
#magicskill 5 3
#maxage 4000
#neednoteat
#undead
#startdom 2
#pathcost 80
#restrictedgod 78
#expertleader
#goodmagicleader
#goodundeadleader
#end

#newmonster 2876
#clear
#name "Arcane Dragonstone"
#spr1 "./kobold/dragonstatue2a.tga"
#spr2 "./kobold/dragonstatue2b.tga"
#descr "A massive dragonstone containing the spirit of an elder dragon, which has survived for aeons. Though imprisoned inside the red granite statue, after several centuries of practice, controlling the dragonspawn and lesser beings has become an easy task, and it now is powerful enough to take on the mantle of a deity. The spirit is full of hatred and malevolence, and loves warfare on a massive scale. It is why the Urdheim forces have left the relative safety of the underground to wage holy war. Though it cannot fight back it is quite hard to destroy both physically and magically. Close proximity to the sacred flames can lead to empowering the dragon spirit inside at the expense of your own health."
#ap 2
#mapmove 0
#hp 150
#prot 20
#size 6
#str 30
#enc 0
#att 10
#def 0
#prec 12
#mr 18
#mor 30
#gcost 80
#rcost 0
#weapon "Life Drain"
#itemslots 61440
#blind
#fireshield 12
#heat
#immobile
#inanimate
#fireres 100
#poisonres 100
#shockres 100
#magicskill 0 1
#magicskill 3 1
#maxage 4000
#neednoteat
#nobadevents 25
#startdom 3
#pathcost 40
#restrictedgod 78
#okleader
#goodmagicleader
#okundeadleader
#end

#newsite 880
#name "Kobold Caves"
#path 3
#level 0
#rarity 5
#gems 3 2
#gold 100
#res 25
#homecom 2896
#end

#newsite 881
#name "Drakengard"
#path 0
#level 0
#rarity 5
#gems 0 2
#gems 5 1
#homemon 2887
#homecom 2894
#end

#selectnation 78
#name "Urdheim"
#epithet "Infinite Horde"
#era 1
#descr "A nation of Kobolds. Kobolds are tiny and weak lizardlike creatures possessing great speed. They are aggressive, xenophobic, yet quite industrious. Kobolds are noted for their skill at using poison, building traps, preparing ambushes, and mining. While having longer lifespans than humans, they reach adulthood in a matter of months, and breed frequently and in great numbers. They claim to be distantly related to dragons, which they worship as deities."
#summary "Race: Kobolds.  Military: Small and stealthy light infantry with good leaders.  Magic: Fire, Earth, Death.  Priests: Weak."
#brief "A nation of kobolds driven from their underground homelands have become invaders, attacking the kingdoms of men.  Urdheim has strong Fire and Earth mages and priests with limited nature and water magic."
#flag "./kobold/koboldflag.tga"
#color 0.99 0.29 0.29

#clearrec
#addrecunit 2880 -- Kobold
#addrecunit 2884 -- Kobold Skirmisher
#addrecunit 2885 -- Kobold Raider
#addrecunit 2881 -- Kobold Lt. Infantry
#addrecunit 2882 -- Kobold Med. Infantry
#addrecunit 2883 -- Kobold Miner
#addrecunit 2886 -- Kobold Firebrand


#addreccom 2890 -- Kobold Ranger
#addreccom 2891 -- Kobold Warchief
#addreccom 2892 -- Kobold Firelord
#addreccom 2897 -- Waterborn
#addreccom 2898 -- Blessed
#addreccom 2895 -- Kobold Summoner
#addreccom 2893 -- Kobold Sorceror



#defcom1 2891
#defcom2 2893
#defunit1 2880
#defunit1b 2881
#defunit2 2882
#defunit2b 2886
#defmult1 20
#defmult1b 15
#defmult2 10
#defmult2b 5

#multihero1 2879
#multihero2 2878
#hero1 2877
#hero2 2865

#startcom 2891
#startunittype1 2880
#startunittype2 2881
#startunitnbrs1 40
#startunitnbrs2 20
#startscout 2890

#castleprod 10

#idealcold -1

#templepic 4

#startfort 15        -- Cave City
#defaultfort 30      -- Cave Fort
#farmfort 7          -- Motte-and-bailey
#mountainfort 16     -- Cave Castle
#forestfort 34       -- Forest Fortress
#swampfort 11        -- Swamp Fort

#startsite "Drakengard"
#startsite "Kobold Caves"
#startsite "The Obsidian Sphere"

#end

