#!/usr/bin/awk -f
# lists ID ranges of monsters, armors, weapons in a mod file

function show(arr)
{
  n = asort(arr);
  if (n < 1) return;

  mark = 1;
  printf("%d", arr[mark]);

  for (i = 2; i <= n; i++) {
    if (arr[i] != arr[mark]+i-mark) {
      if (i-mark > 1)
        printf("-%d", arr[i-1]);

      mark = i;
      printf(",%d", arr[mark]);
    }
  }

  if (mark != n) printf("-%d", arr[n]);
}

/^[ \t]*#newmonster[ \t]+[0-9]+/ { monsters[++m] = $2 }
/^[ \t]*#newweapon[ \t]+[0-9]+/ { weapons[++w] = $2 }
/^[ \t]*#newarmor[ \t]+[0-9]+/ { armors[++a] = $2 }
/^[ \t]*#newsite[ \t]+[0-9]+/ { sites[++s] = $2 }
END {
  printf("Monster IDs: "); show(monsters); printf("\n");
  printf("Weapon IDs: "); show(weapons); printf("\n");
  printf("Armor IDs: "); show(armors); printf("\n");
  printf("Site IDs: "); show(sites); printf("\n");
}