<?php

# Dominions 3 stats script v1.01 (2007-05-05)
#
#
# QUICK INSTALLATION INSTRUCTIONS
# ===============================
#
# 1. Put this php file into your web folder.
# 2. Open up a terminal / command line and navigate to that folder.
# 3. Run "php [script-filename] [savegame-dir of dom3 game]" to generate a configuration file;
#      e.g.: "php stats.php ~/dominions3/savegames/MyGame" will create "dom3_MyGame.inc.php"
#    [If you are using PHP4 you need to have php4-cli installed for this and use it, PHP5 is fine]
# 4. Edit the configuration file. (add names of the players, specify hosting interval etc.)
# 5. You're done! Navigate to the php file on the server with your web browser. Voil!
#

function DisplayPageHeader($title="") {
  // making the W3C happy... (http://validator.w3.org/docs/help.html#faq-charset)
  header('content-type: text/html; charset=ISO-8859-1');
  // making the Validome (http://www.validome.org/) happy...
  header('Content-Script-Type: text/javascript');
  // turning off the php parser to have better text highlighting in the text editor...
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
   "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">

<link rel="stylesheet" type="text/css" href="revolucao_tabela.css" title="Revolucao etc">

<!-- style fixes -->
<style type="text/css" title="(fix) Matrix?">
  input#address {color: #fff;} /* fix invisible input text (black on black) */
</style>

<!-- Stylesheet switcher by Mark Wilton-Jones (http://www.howtocreate.co.uk/jslibs/script-swapstyle) -->
<!-- script type="text/javascript" src="http://www.howtocreate.co.uk/jslibs/swapstyle.js"></script> -->
<script type="text/javascript" src="jslibs/swapstyle.js"></script>

<!-- Using the BoxOver script by Oliver Bryant (http://boxover.swazz.org/) for tooltip effects since -->
<!-- lixlpixel's javascript tooltips (http://lixlpixel.org/javascript-tooltips/) are copy+paste only -->
<!-- script type="text/javascript" src="http://boxover.swazz.org/boxover.js"></script> -->
<script type="text/javascript" src="jslibs/boxover.js"></script>

<!-- custom javascript functions -->
<script type="text/javascript" src="mystyleswitcher.js"></script>
<script type="text/javascript">
/* <![CDATA[ */

/*      CSS themes from CSS Table Gallery (http://icant.co.uk/csstablegallery/)      */
/* removed inaccessible stylesheets and commented out some who don't like hotlinking */
CSSCollection = new Object();
CSSCollection["chives' tables"] = "http://www.chives.de/style/chives-tables.css";
CSSCollection["table red-white"] = "http://www.4wdmedia.de/stuff/table_red_white.css";
CSSCollection["Candy"] = "http://www.webdesign-sh.de/csstable/table.css";
CSSCollection["Simple and Clean"] = "http://www.leandropessoa.com.br/table/css/table.css";
CSSCollection["Blue"] = "http://www.nghorta.com/csstg/blue/table.css";
CSSCollection["Infected"] = "http://infectedfx.net/css/tables/inphecthyuz.css";
// CSSCollection["Azulon"] = "http://www.csslab.cl/csstablegallery/azulon.css";
CSSCollection["Casablanca"] = "http://www.rodcast.com.br/csstablegallery/screen.css";
CSSCollection["Salmon"] = "http://www.tecnostart.cl/publico/table-gallery.css";
CSSCollection["Clear Blue"] = "http://blog.suchmaschinen-optimierungen.info/codes/css-tables-gallery.css";
CSSCollection["Blix Theme"] = "http://www.nghorta.com/csstg/table.css";
CSSCollection["iCubed"] = "http://www.iqcontent.com/icant/iqcontent.css";
// CSSCollection["Jacob"] = "http://www.portinfo.com.br/jacob.css";
CSSCollection["Go Jamaica"] = "http://hernand.f2o.org/diseno_tablas/jamaican_style.css";
CSSCollection["Poetry For Browser"] = "http://www.webdesign-in.de/barrierefrei/poetryforbrowser.css";
CSSCollection["Like Adwords"] = "http://www.cleiton.net/csstablegalery/like-adw.css";
CSSCollection["Pretty In Pink"] = "http://www.arcsin.se/external/csstablegallery/prettyinpink.css";
CSSCollection["Two times table"] = "http://www.cssplay.co.uk/csstablegallery/two-times-table.css";
CSSCollection["bluish"] = "http://neukoellnstyle.de/tablegallery/nksTablegallery.css";
CSSCollection["Second Revolution"] = "http://www.revolucao.etc.br/css_tablegallery2/estilos.css";
CSSCollection["BluInBlock"] = "http://test.enithost.com/table-style/argstyle.css";
CSSCollection["pop.pop.star"] = "http://www.javajim.de/csstablegallery/poppopstar.css";
CSSCollection["Tabular tables"] = "http://www.cssplay.co.uk/csstablegallery/tabular-table.css";
CSSCollection["Sea Glass"] = "http://sillybean.net/css/seaglass.css";
// CSSCollection["Orange Brownie"] = "http://codylindley.com/orangebrownie.css";
CSSCollection["Blaugrana"] = "http://dizque.lacalabaza.net/ext/css-tables/css-tables.css";
CSSCollection["Innocent Flowers"] = "http://www.zeta-software.de/projekte/tabledesign/flowers.css";
CSSCollection["Shades of Blue"] = "http://www.vhg-design.com/icant/vhg.css";
CSSCollection["Gmail scrolling"] = "http://www.maujor.com/temp/chris/gmail.css";
CSSCollection["Shades of Purple"] = "http://drafdesigns.com/shadesofpurple.css";
CSSCollection["Turkish Delight"] = "http://www.fuzzyoutline.com/style/tablegallery/tablestyle.css";
CSSCollection["Grayed Out"] = "http://www.imaputz.com/cssStuff/datatable.css";
CSSCollection["Nimbupani"] = "http://nimbupani.com/csstables/csstables.css";
CSSCollection["Trekkish Violets"] = "http://wirusy.room-303.com/csstablegallery/violet.css";
CSSCollection["Golden style"] = "http://www.australien-panorama.de/several/golden.css";
CSSCollection["Oranges In The Sky"] = "http://www.makaveev.com/lab/css_table_gallery/oranges-in-the-sky.css";
CSSCollection["Rockstar"] = "http://jedisthlm.com/testarea/rockstar.css";
CSSCollection["Greyscale"] = "http://concreteandclay.dreamhosters.com/csstablegallery/greyscale.css";
CSSCollection["Coffee with milk"] = "http://www.456bereastreet.com/lab/css-table-gallery/coffee-with-milk.css";
CSSCollection["Clean and crisp"] = "http://blogs.su.se/~matlin/cnc.css";
CSSCollection["Winter Blues"] = "http://www.klavina.com/csstablegallery/winterblues.css";
CSSCollection["Green Life"] = "http://www.alvit.de/vf/csstablegallery/tables.css";
CSSCollection["Breathing Space"] = "http://www.kevinleitch.co.uk/zentables/tables.css";
CSSCollection["Warm Fall"] = "http://files.myaleigh.com/table-designs/warmfall.css";
CSSCollection["iTunes"] = "http://www.johnlawrence.net/itable/itunes.css";
CSSCollection["MintGreen"] = "http://taimar.pri.ee/examples/table-design/mintgreen.css";
CSSCollection["Heaven is Closer"] = "http://nikoport.com/xperiments/css/table_gallery/niko.css";
// CSSCollection["Table on a Table"] = "http://www.rdpdesign.com/table_design/tables.css";
// CSSCollection["Cygenta"] = "http://bon.gs/projects/csstablegallery/cga.css";
CSSCollection["Spread Firefox!"] = "http://www.tjkdesign.com/zen/table/table.css";
CSSCollection["Table Sprite"] = "http://webdesign.parkertorrence.com/sandbox/csstable/froglace.css";
CSSCollection["Muted"] = "http://www.clacksweb.org.uk/css/cwtable.css";
CSSCollection["Chocolate"] = "http://www.doubleonegative.com/css/choc-table.css";
CSSCollection["Inset cells"] = "http://www.maujor.com/temp/chris/inset.css";
// CSSCollection["Revolucao etc"] = "http://www.revolucao.etc.br/revolucao_tabela.css";
CSSCollection["Revolucao etc"] = "revolucao_tabela.css";
// CSSCollection["Lab Report"] = "http://www.classical-webdesigns.co.uk/cssexps/labreport.css";
CSSCollection["MSIE hover"] = "http://xy.wz.cz/ie-hover.css";
CSSCollection["Orange You Glad"] = "http://randypeterman.com/CSSTableGallery/OrangeYouGlad.css";
CSSCollection["Matrix?"] = "http://elrok.com/matrix.css";
CSSCollection["10 minutes"] = "http://www.dramatic.co.nz/tablegallery/dramatic.css";
CSSCollection["Spearmint tints"] = "http://inspire.server101.com/bttdb/html/tables/spearmint-tints.css";
CSSCollection["Table structure"] = "http://inspire.server101.com/bttdb/html/tables/structure.css";
CSSCollection["City Mouse"] = "http://www.hadsel-design.com/tableshow/citymouse.css";
CSSCollection["Alpha transparency"] = "http://www.maujor.com/temp/chris/alpha.css";
CSSCollection["Grey suits you sir"] = "http://www.muffinresearch.co.uk/lab/tableshow/muffin.css";
CSSCollection["Cusco Sky"] = "http://test.buayacorp.com/cuscosky.css";
CSSCollection["Blue On Blue"] = "http://blog.slaven.net.au/wp-content/csstables/blueonblue.css";
CSSCollection["Chrome de la chrome"] = "http://icant.co.uk/csstablegallery/chrome.css";
CSSCollection["Minimalist"] = "http://icant.co.uk/csstablegallery/minimal.css";
CSSCollection["Plain old table"] = "http://icant.co.uk/csstablegallery/plainold.css";

// use a default stylesheet in case there is no cookie set yet
defaultStyle = 'Revolucao etc';
currentStyle = defaultStyle;

// reuse stylesheet from cookie
for (var x = 0, c = document.cookie.split( "; " ); x < c.length; ++x) {
  oneCookie = c[x].split( "=" );
  if (oneCookie[0] != 'Dom3Stats-Style') continue;
  currentStyle = unescape(unescape(oneCookie[1]));
}

myChangeStyle(0);

function initDom3Stats() {
  updateTooltips();

  // show different tooltip for MSIE (which supports accessing the clipboard)
  if(document.all && document.getElementById("address"))
  {
    var l = "header=[] body=[", r = "] cssbody=[tooltip]";
    document.getElementById("address").title=l+"Text copied to Clipboard"+r;
  }
}


/* "Copy formular text to the clipboard" script by Christian Felken (http://www.webmaster-resource.de/tricks/javascript/text-aus-formularfeld-in-die-zwischenablage-kopieren.php) */
function copyText(FeldID)
{
  document.getElementById(FeldID).focus();
  document.getElementById(FeldID).select();
  if(document.all)
  {
    var Range=document.getElementById(FeldID).createTextRange();
    Range.execCommand("Copy");
  }
}

/* ]]> */
</script>

<!-- additional custom CSS style settings -->
<style type="text/css">

table {width: 90%; max-width:700px;}
input#address {border: 0; background-color: transparent; width: 100%; text-align:center; cursor:pointer;}

.tooltip {padding: 5px; z-index: 100; color: #d0a010; background: #ffffce; border:1px solid #f0d070; font: 12px "Gill Sans", sans-serif; text-align: center;}
#loading {position: absolute; top: 100px; left: 40%; padding: 25px; display: none;}

/* player activity tab */
span.pending  {color: #800;}
span.complete {color: #080;}
span.inactive {color: #880;}

/* style switcher buttons */
#styleswitches {position: absolute; top: 5px; left: 7px;}
.button {width:25px; text-align: center; vertical-align: middle; font: bold 22px Arial; border: 0; margin: 0;  padding: 0; margin-top:5px;}
.button a, .button a:hover {text-decoration: none; color: #fff;}

/* back link and address field without weird symbols */
tbody tr th a:visited:after, tbody tr td a.tooltip:visited:after {content: "";}

/* cross-browser table centering solution by Rijk van Geijtenbeek (from http://theodorakis.net/tablecentertest.html) */
div.centered {text-align: center;}
div.centered table, div.centered caption {margin: 0 auto; text-align: left;}

</style>

<!--[if IE]>
<style type="text/css">
/* max-width workaround for MSIE by Svend Tofte (http://www.svendtofte.com/code/max_width_in_ie/) */
table {width:expression(document.body.clientWidth > 700 ? "700px": "90%");}
</style>
<![endif]-->

<title><?php echo $title ?></title>
</head>

<body onload="initDom3Stats();" onunload="myRememberStyle('Dom3Stats-Style', 14);">
<?php
}


function timetostr($duration = 0) {
  // calculate days, hours, minutes, seconds
  $d = (int)($duration/(60*60*24));
  $h = (int)(($duration % (60*60*24))/(60*60));
  $m = (int)(($duration % (60*60))/60);
  $s = (int)($duration % 60);

  // generate output
  $r = array();
  $acronyms = array('d' => "day", 'h' => "hour", 'm' => "minute", 's' => "second");
  foreach($acronyms as $a => $n)
    if ($$a)
      $r[] = $$a." ".$n.($$a == 1 ? "" : "s");

  return count($r) ? implode(', ', $r) : "0 seconds";
}


function DisplayGameStats($game = "") {
  // read config file
  global $scriptdir;
  if (!is_readable("$scriptdir/dom3_$game.inc.php"))
    die("Configuration for game '$game' not found, please run 'php ".basename($_SERVER['PHP_SELF'])." [path to savegame]'\n");
  require_once("$scriptdir/dom3_$game.inc.php");

  $lastturn = filemtime("$dir/ftherlnd") or print("You do not seem to be hosting a game at directory '$dir'\n");

  // read file modification times
  $ftimes = array();
  foreach (glob("$dir/*.2h") as $filename)
    $ftimes[substr(basename($filename), 0, -3)] = filemtime($filename);

  // read file sizes
  $fsizes = array();
  if (is_readable("$dir/chkfile.txt"))
    foreach (file("$dir/chkfile.txt") as $v) {
      list($filename, $size) = explode(";", $v);
      $fsizes[$filename] = $size;
    }

  // look for defeated nations
  $turncount = "";
  $defeated = array();
  if (is_readable("$dir/scores.html"))
    for ($s = file("$dir/scores.html"), $i = 0, $pTable = false; $i < count($s); ++$i) {
      if ($pTable and strpos($s[$i], "</table>") !== false) break;

      if (preg_match('|<title>.* (turn [0-9]+)</title>|i', $s[$i], $match)) {
        $turncount = " - ".ucwords(strtolower($match[1]));
      }

      if (!preg_match('|<td>([^<]+)</td>|i', $s[$i], $match)) continue;
      if (!$pTable) {
        $pTable = ($match[1] === "Dominion");
        continue;
      }

      $nation = $match[1];
      if (preg_match("|<td>([0-9]+)</td>|i", $s[++$i], $match))
        $defeated[$nation] = !$match[1];
    }

  DisplayPageHeader("'".basename(realpath($dir))."' Dominions Multiplayer Game");

  // alternate stylesheet buttons
?>
  <script type="text/javascript">
    document.write('<div id="styleswitches">');
    document.write('<div class="button" style="background-color:#f5b348;">');
    document.write('<a href="#" id="Prev" onclick="myChangeStyle(-1);" ');
    document.write('title="header=[] body=[previous style] cssbody=[tooltip]">&and;<\/a>');
    document.write('<\/div>');
    document.write('<div class="button" style="background-color:#adbbca;">');
    document.write('<a href="#" id="Reset" onclick="currentStyle=defaultStyle; myChangeStyle(0);" ');
    document.write('title="header=[] body=[reset to default style<br>\''+defaultStyle+'\'] cssbody=[tooltip]">&times;<\/a>');
    document.write('<\/div>');
    document.write('<div class="button" style="background-color:#3a4856;">');
    document.write('<a href="#" id="Next" onclick="myChangeStyle(1);" ');
    document.write('title="header=[] body=[next style] cssbody=[tooltip]">&or;<\/a>');
    document.write('<\/div>');
    document.write('<\/div>');
  </script>
<?php

  print "\n<div class='tooltip' id='loading'>Loading new stylesheet, please wait...</div>\n";
  print "<div class='centered'>\n";

  // print game info
  print "<table>\n<caption>Dominions Multiplayer Game \"";
  print basename(realpath($dir));
  print "\"</caption>\n<tbody>\n";

  print "<tr>\n<th scope='row'>Game Era</th>\n<td>";
  switch (substr(key($ftimes), 0, 1)):
  case 'e':
    print "Early"; break;
  case 'm':
    print "Middle"; break;
  case 'l':
    print "Late"; break;
  default:
    print "Unknown(?)";
  endswitch;
  print " Age</td>\n</tr>\n";

  if ($hostinterval != "")
    print "<tr>\n<th scope='row'>Host Interval</th>\n<td>$hostinterval</td>\n</tr>\n";

  print "<tr>\n<th scope='row'>Last change</th>\n<td>";
  print timetostr(time()-max($lastturn, max($ftimes)));
  print " ago</td>\n</tr>\n";

  if ($hostinterval != "") {
    print "<tr>\n<th scope='row'>Time remaining</th>\n<td>";
    $remain = strtotime("+$hostinterval", $lastturn)-time();
    print timetostr($remain);
    print " until next hosting</td>\n</tr>\n";
  }

  if ($serveraddress != "") {
    list($host, $port) = explode(":", $serveraddress);

    print "<tr>\n<th scope='row'>Server address</th>\n<td>";
    print '<input type="text" id="address" value="'.$serveraddress.'" readonly="readonly" ';
    print 'onmouseout="this.value=\''.$serveraddress.'\'" ';
    print 'onmouseover="this.value=\' -C -nocred --ipadr '.$host.($port ? ' --port '.$port : '').'\'; ';
    print 'copyText(\'address\');" title="header=[] body=[Press CTRL+C to copy] cssbody=[tooltip]">';
    print "</td>\n</tr>\n";
  }

  print "</tbody>\n</table>\n<p></p>\n";

  // print turn info
  print "<table>\n<caption>Player status$turncount</caption>\n";
  print "<thead>\n<tr>\n";
  print "<th scope='col'>Player</th>\n<th scope='col'>Nation</th>\n<th scope='col'>Status</th>\n";
  print "</tr>\n</thead>\n<tbody>\n";

  global $nations;
  $replacechars = array("" => "a", "" => "'i", "" => "'O");
  foreach ($players as $id => $player) {
    $nation = $nations[$id];
    $aiplayer = !file_exists("$dir/$id.trn");
    if (($aiplayer and !$showaiplayers) or (@$defeated[$nation] and !$showdefeated)) continue;

    print "<tr>\n";
    print "<td>".$player."</td>\n";
    print '<td><a href="http://strategywiki.org/wiki/Dominions_3:_The_Awakening/Nations/';
    print strtr($nation, $replacechars).'" style="font-weight:normal;">'.$nation."</a></td>\n";

    print '<td><a name="'.$nation.'"></a>';
    if (@$defeated[$nation])
      print "lost the game";
    elseif ($aiplayer)
      print "controlled by AI";
    elseif ($ftimes[$id] < strtotime("-$hostinterval", $lastturn))
      print "<span class='inactive'>Missed a turn</span>";
    elseif (@$fsizes["$id.2h"] ? $fsizes["$id.2h"] != filesize("$dir/$id.2h") : $ftimes[$id] > $lastturn)
      print "<span class='complete'>Turn Complete</span>";
    else
      print "<span class='pending'>Turn Pending</span>";
    print "</td>\n</tr>\n";
  }

  print "<tr>\n<th colspan='3' style='text-align: left;'>\n";
  print "<a href='".basename($_SERVER['PHP_SELF'])."'>&lt; back</a>\n";
  print "</th>\n</tr>\n</tbody>\n</table>\n";
  print "</div>\n</body>\n</html>\n";

}


function DisplayGames() {
  DisplayPageHeader("Dominions Multiplayer Games", false);
  print "\n<div class='centered'>\n";

  // print game info
  print "<table>\n";
  print "<thead>\n<tr>\n";
  print "<th scope='col'>Game</th>\n<th scope='col'>Human Players</th>\n";
  print "<th scope='col'>Last Turn</th>\n<th scope='col'>Next Turn</th>\n";
  print "</tr>\n</thead>\n<tbody>\n";

  global $scriptdir;
  foreach (glob("$scriptdir/dom3_*.inc.php") as $settings) {
    if (!is_readable($settings)) continue;
    include($settings);
    $lastturn = filemtime("$dir/ftherlnd");

    print "<tr>\n<th>";
    print "<a href='".$_SERVER['PHP_SELF']."?game=".substr(basename($settings), 5, -8)."'>";
    print basename(realpath($dir));
    print "</a>";
    print "</th>\n<td>";
    print count(glob("$dir/*.trn"))."/".count(glob("$dir/*.2h"));
    print "</td>\n<td>";
    print preg_replace("/ ([a-z])[a-z]*,?/", "\${1}", timetostr(time()-$lastturn))." since last hosting";
    print "</td>\n<td>";
    if ($hostinterval != "")
      print preg_replace("/ ([a-z])[a-z]*,?/", "\${1}", timetostr(strtotime("+$hostinterval", $lastturn)-time()))." until forced hosting";
    print "</td>\n</tr>\n";

  }

  print "</tbody>\n</table>\n";
  print "</div>\n</body>\n</html>\n";

}


function CreateIncludeFile($dir = ".") {
  global $scriptdir;
  $dir  = realpath($dir);
  $game = basename($dir);
  $file = "$scriptdir/dom3_".preg_replace("/[^a-zA-Z0-9]/", "", $game).".inc.php";

  if (file_exists($file))
    die("File '$file' already exists, delete it by hand before you continue\n");

  // check sanity
  if (!is_file("$dir/ftherlnd"))
    die("You do not seem to be hosting a game at directory '$dir'\n");

  // read list of playing nations
  $players = array();
  foreach (glob("$dir/*.trn") as $filename)
    $players[substr(basename($filename), 0, -4)] = true;
  foreach (glob("$dir/*.2h") as $filename)
    $players[substr(basename($filename), 0, -3)] = true;
  $players = array_keys($players);

  // access output file
  $handle = fopen($file, "w") or die("Could not open file '$file' for writing\n");

  // generate output
  $m  = "<?php\n\n";
  $m .= "# path to the savegame directory\n#\n";
  $m .= '$dir = "'.realpath($dir).'";'."\n\n";
  $m .= "# quickhost interval (e.g.: 15 minutes / 1 hour / 2 days), empty disables\n#\n";
  $m .= '$hostinterval = "";'."\n\n";
  $m .= "# show nations played by the AI in list? 1 enables, 0 disables\n#\n";
  $m .= '$showaiplayers = 1;'."\n\n";
  $m .= "# show defeated players in list? 1 enables, 0 disables\n#\n";
  $m .= '$showdefeated = 0;'."\n\n";
  $m .= "# server address in the format 'host:port' (e.g.: my.server.com:1337), empty disables\n#\n";
  $m .= '$serveraddress = "";'."\n\n";
  $m .= "# names of the players, they're being shown in the order given below\n#\n";
  $m .= '$players = array('."\n";
  for ($i = 0; $i < count($players); ++$i)
    $m .= '  "'.$players[$i].'" => "Player '.($i+1).'",'."\n";
  $m .= ");\n\n?>\n";

  fwrite($handle, $m) or die("Could not write to file '$file'\n");
  fclose($handle) or die("Could not close file '$file'\n");
}


function CreateCheckFile($game = "") {
  // read config file
  global $scriptdir;
  if (!is_readable("$scriptdir/dom3_$game.inc.php"))
    die("Configuration for game '$game' not found, please run 'php ".basename($_SERVER['PHP_SELF'])." [path to savegame]'\n");
  require_once("$scriptdir/dom3_$game.inc.php");

  // access output file
  $file = "$dir/chkfile.txt";
  $handle = fopen($file, "w") or die("Could not open file '$file' for writing\n");

  // determine *.2h file sizes
  $m = basename("$dir/ftherlnd").";".filesize("$dir/ftherlnd")."\n";
  foreach (glob("$dir/*.2h") as $filename)
    $m .= basename($filename).";".filesize($filename)."\n";

  fwrite($handle, $m) or die("Could not write to file '$file'\n");
  fclose($handle) or die("Could not close file '$file'\n");
}

// names for the nations
$nations = array(
  "early_abysia" => "Abysia",
  "early_agartha" => "Agartha",
  "early_arcoscephale" => "Arcoscephale",
  "early_atlantis" => "Atlantis",
  "early_caelum" => "Caelum",
  "early_ctis" => "C'tis",
  "early_ermor" => "Ermor",
  "early_helheim" => "Helheim",
  "early_kailasa" => "Kailasa",
  "early_lanka" => "Lanka",
  "early_marverni" => "Marverni",
  "early_mictlan" => "Mictlan",
  "early_niefelheim" => "Niefelheim",
  "early_oceania" => "Oceania",
  "early_pangaea" => "Pangaea",
  "early_rlyeh" => "R'lyeh",
  "early_sauromatia" => "Sauromatia",
  "early_tienchi" => "Ten Ch",
  "early_tirnanog" => "Tr na ng",
  "early_ulm" => "Ulm",
  "early_vanheim" => "Vanheim",
  "early_yomi" => "Yomi",
  "mid_abysia" => "Abysia",
  "mid_agartha" => "Agartha",
  "mid_arcoscephale" => "Arcoscephale",
  "mid_atlantis" => "Atlantis",
  "mid_bakemono" => "Shinuyama",
  "mid_bandarlog" => "Bandar Log",
  "mid_caelum" => "Caelum",
  "mid_ctis" => "C'tis",
  "mid_eriu" => "Eriu",
  "mid_ermor" => "Ermor",
  "mid_jotunheim" => "Jotunheim",
  "mid_machaka" => "Machaka",
  "mid_man" => "Man",
  "mid_marignon" => "Marignon",
  "mid_mictlan" => "Mictlan",
  "mid_oceania" => "Oceania",
  "mid_pangaea" => "Pangaea",
  "mid_pythium" => "Pythium",
  "mid_rlyeh" => "R'lyeh",
  "mid_tienchi" => "Ten Ch",
  "mid_ulm" => "Ulm",
  "mid_vanheim" => "Vanheim",
  "late_abysia" => "Abysia",
  "late_agartha" => "Agartha",
  "late_arcoscephale" => "Arcoscephale",
  "late_atlantis" => "Atlantis",
  "late_caelum" => "Caelum",
  "late_ctis" => "C'tis",
  "late_ermor" => "Ermor",
  "late_jomon" => "Jomon",
  "late_chelms" => "Man",
  "late_marignon" => "Marignon",
  "late_mictlan" => "Mictlan",
  "late_midgard" => "Midgrd",
  "late_pangaea" => "Pangaea",
  "late_patala" => "Patala",
  "late_rlyeh" => "R'lyeh",
  "late_tienchi" => "Ten Ch",
  "late_ulm" => "Ulm",
  "late_utgard" => "Utgrd",
);

$scriptdir = dirname($_SERVER["SCRIPT_FILENAME"]);
if (!is_dir($scriptdir))
  $scriptdir = dirname($_SERVER["argv"][0]);

// if called from the commando line: generate configuration or *.2h file info
switch (@$GLOBALS['argc']-1) {
case 1:
   print $scriptdir."\n";
   CreateIncludeFile($GLOBALS['argv'][1]);
   exit;
   break;
case 2:
   if ($GLOBALS['argv'][1] === "-makecheck") {
     CreateCheckFile($GLOBALS['argv'][2]);
     exit;
   } else {
     die("You're supposed to run 'php ".basename($_SERVER['PHP_SELF'])." -makecheck <GameName>'");
   }
   break;
}

// if called from webserver with "game" parameter: show game statistics
if (array_key_exists('game', $_REQUEST)) {
  DisplayGameStats(end(explode("/", strtr($_REQUEST['game'], "\\", "/"))));
  exit;
}

// show list of available game statistics
DisplayGames();

?>
