#!/bin/sh
echo "Weird Worlds Patcher"
cd ~/Desktop/ww-osx-patch-122/
if [ -d /Applications/Weird\ Worlds/Weird\ Worlds.app ]; then
	app_dir=/Applications/Weird\ Worlds/Weird\ Worlds.app
else
	if [ -d ../Weird\ Worlds/Weird\ Worlds.app ]; then
		app_dir=../Weird\ Worlds/Weird\ Worlds.app
	else
		echo "Can't find the application to patch."
		echo "Put the Weird Worlds Folder on the"
		echo "desktop or it won't be patched."
		exit 1;
	fi
fi
if [ ! -d ./Contents ]; then
    echo "Can't find the patch data. Put the ww-osx-patch-122"
    echo "folder on the desktop and try again."
    exit 1;
fi
echo "Found Weird Worlds.app in $app_dir"
echo "Patching Weird Worlds v1.11 -> v1.22, please wait..."

chmod -v -R +w "$app_dir"
cp -v -r Contents "$app_dir/"

chmod -R +w "$app_dir/../superpirate"
cp -r superpirate/gamedata "$app_dir/../superpirate/"

echo "=========================================="
echo "Weird Worlds Successfully patched to v1.22"
echo "=========================================="
exit 0;
