#modname "Marmoset mod"

#description "A mod compilation adding Tomb Kings, Skaven, Arga Dis and Ulm Reborn to the Middle Age. Requires the installation of the individual mods to provide graphics."

#icon "MarmosetBanner.tga"

#version 0.82

#newweapon 700
#name "Cobra Staff"
#dmg 4
#att 1
#def 3
#len 4
#rcost 1
#secondaryeffectalways 171
#explspr 10113
#twohanded
#end

#newweapon 701
#name "Ritual Blade"
#nratt 2
#dmg 12
#att 1
#def 2
#len 4
#rcost 10
#twohanded
#end

#newweapon 702
#name "Strong Paralyzing Poison"
#dt_stun
#poison
#dmg 75
#mr
#end

#newweapon 703
#name "Dart Crossbow"
#range 10
#nostr
#dmg 1
#dt_cap
#armornegating
#att 0
#ammo 2
#secondaryeffect 672
-secondaryeffect 54
#rcost 1
#flyspr 109 1
#end

#newweapon 704
#name "Spear of Horus"
#dmg 3
#dt_holy
#att 0
#def 0
#len 5
#secondaryeffect 221
#end

#newweapon 705
#name "Mental Attack"
#dmg 8
#dt_paralyze
#range 100
#att 50
#ammo 1
#secondaryeffect 293 -- Additional damage (1 AN +MR)
#explspr 10206
#end

#newweapon 706
#name "Blade of Horus"
#nratt 2
#dmg 12
#att 1
#def 2
#len 4
#rcost 10
#dt_holy
#secondaryeffect 221
#twohanded
#end

#newarmor 326
#name "Shoulder Guard"
#type 5
#prot 4
#enc 0
#def 0
#rcost 2
#end

#newarmor 327
#name "Nehekharan Shield"
#type 4
#prot 12
#def 4
#enc 2
#rcost 3
#end

#newarmor 328
#name "Bronze Armor"
#type 5
#prot 10
#def -1
#enc 2
#rcost 4
#end

#newarmor 329
#name "Circlet"
#type 6
#prot 4
#def 0
#enc 0
#rcost 0
#end

#newarmor 330
#name "Gilded Armor"
#type 5
#prot 14
#def -3
#enc 2
#rcost 12
#end

#newarmor 331
#name "Royal Headdress"
#type 6
#prot 8
#def -1
#enc 0
#rcost 1
#end

#newarmor 332
#name "Headdress"
#type 6
#prot 6
#def 0
#enc 0
#rcost 1
#end

#newarmor 333
#name "Thousands of Bodies"
#type 4
#prot 30
#def 8
#end 0
#rcost 0
#end

#newarmor 334
#name "Bone Greaves"
#type 5
#prot 4
#def 0
#enc 0
#end

#newarmor 335
#name "Rags"
#type 5
#prot 2
#def 0
#enc 0
#end

#newarmor 336
#name "Ushabti Avatar Armor"
#type 5
#prot 8
#def 0
#enc 0
#end

#newmonster 2600
#name "Tomb skeleton"
#mor 30
#mr 15
#hp 8
#att 11
#def 10
#enc 0
#ap 12
#mapmove 3
#neednoteat
#coldres 100
#poisonres 100
#inanimate
#undead
#nametype 127
#rcost 3
#gcost 10
#startage 2705#maxage 5000
#poorundeadleader
#end

#newmonster 2601
#name "Tomb mummy"
#mor 30
#mr 16
#hp 10
#att 10
#def 9
#enc 0
#ap 12
#mapmove 3
#neednoteat
#coldres 50
#poisonres 100
#fireres -25
#inanimate
#nametype 127
#rcost 3
#prot 6
#startage 2705#maxage 5000
#poorundeadleader
#end

#newmonster 2602
#copystats 2600
#name "Spearman"
#descr "The undead spearmen of Nehekhara were once loyal and disciplined soldiers of the Tomb Kings, buried in desert tombs and now awakened by the Tomb Priests to rebuild their ancient empire. The Nehekharans wear little or no armor and take cover behind large shields, as bows were the dominant weapon of war in old Nehekhara. Although vast legions of soldiers lie waiting in countless tombs, the rituals of reawakening are time consuming and require expensive incenses and balms. The enchantments animating the spearmen are extremely powerful however, having originally been set in place by months-long incantations by the the Tomb Priests and their acolytes. As such the undead soldiers can be banished by enemy priests only with great difficulty."
#spr1 "./TombKings/Infantry.tga"
#spr2 "./TombKings/InfAttack.tga"
#pooramphibian
#weapon "Spear"
#armor "Nehekharan Shield"
#end

#newmonster 2603
#copystats 2600
#name "Spearman"
#descr "The undead spearmen of Nehekhara were once loyal and disciplined soldiers of the Tomb Kings, buried in desert tombs and now awakened by the Tomb Priests to rebuild their ancient empire. The Nehekharans wear little or no armor and take cover behind large shields, as bows were the dominant weapon of war in old Nehekhara. Although vast legions of soldiers lie waiting in countless tombs, the rituals of reawakening are time consuming and require expensive incenses and balms. The enchantments animating the spearmen are extremely powerful however, having originally been set in place by months-long incantations by the Tomb Priests and their acolytes. As such the undead soldiers can be banished by enemy priests only with great difficulty."
#spr1 "./TombKings/HInfantry.tga"
#spr2 "./TombKings/HInfAttack.tga"
#pooramphibian
#weapon "Spear"
#armor "Shoulder Guard"
#armor "Nehekharan Shield"
#end

#newmonster 2604
#copystats 2600
#name "Archer"
#descr "The undead archers of Nehekhara were once loyal and disciplined soldiers of the Tomb Kings, buried in desert tombs and now awakened by the Tomb Priests to rebuild their ancient empire. Archers played a crucial role in the armies of Nehekhara, and their bows are unusually sophisticated and powerful given that they were developed thousands of years ago. Although vast legions of soldiers lie waiting in countless tombs, the rituals of reawakening are time consuming and require expensive incenses and balms. The enchantments animating the archers are extremely powerful however, having originally been set in place by months-long incantations by the Tomb Priests and their acolytes. As such the undead soldiers can be banished by enemy priests only with great difficulty."
#spr1 "./TombKings/Archer.tga"
#spr2 "./TombKings/ArcherAttack.tga"
#pooramphibian
#weapon "Dagger"
#weapon "Composite Bow"
#armor "Shoulder Guard"
#armor "Circlet"
#end

#newmonster 2605
#copystats 2600
#name "Asp Archer"
#gcost 17
#descr "The ancient Nehekharans worshipped a pantheon of uneasily coexisting Gods. One of these was known as the Asp Goddess. She was a Goddess of war, and gave her blessing particularly to those using the bow and arrow. The bravest and most skilled archers in the Kingdoms would be summoned to the Temple of the Goddess, and there they would be trained in the skills of archery and granted a sacred bow, enchanted by the Goddess herself so that any arrow fired from it would carry a serpent's venom. The so-called Asp Archers would normally remain as guardians of the temple, but in times of war they would march to assist a Tomb King the Goddess found worthy, where their great skills would often turn the tide of a war."
#spr1 "./TombKings/AspArcher.tga"
#spr2 "./TombKings/AspAttack.tga"
#prec 11
#mor 30
#pooramphibian
#weapon "Dagger"
#weapon "Poison Bow"
#armor "Bronze Armor"
#armor "Circlet"
#holy
#end

#newmonster 2606
#copystats 2600
#name "Nehekharan Cavalry"
#gcost 18
#descr "The light cavalry of Nehekhara carry bows and spears, raining arrows down on their enemies before flanking them on their swift skeletal steeds. The Nehekharans placed great value on horses, and the highly trained animals were buried with almost as much ceremony as their masters. Like all the troops of Nehekhara the cavalry are highly resistant to enemy magic because of the powerful and ancient enchantments animating them."
#spr1 "./TombKings/Cavalry.tga"
#spr2 "./TombKings/CavAttack.tga"
#size 3
#att 12
#def 10
#prec 8
#mounted
#ap 24
#mapmove 4
#pooramphibian
#weapon "Spear"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Shoulder Guard"
#armor "Circlet"
#armor "Buckler"
#end

#newmonster 2607
#copystats 2600
#name "Chariot"
#gcost 45
#descr "Chariots were a highly valued weapon in ancient Nehekhara. They were expensive and hard to construct, and so were carefully maintained and damaged chariots were recovered and repaired after battle. It was a great show of wealth and status for a Tomb King to be buried along with a cohort of chariots. In battle these war machines often hold while the crew fire arrows at the enemy, before charging into combat. The chariots are heavy and have scythed wheels, and can cause horrendous casualties."
#spr1 "./TombKings/Chariot.tga"
#spr2 "./TombKings/ChariotAttack.tga"
#size 4
#trample
#mounted
#ap 22
#mapmove 4
#prec 9
#def 11
#prot 5
#weapon "Spear"
#weapon "Composite Bow"
#weapon "Composite Bow"
#armor "Shoulder Guard"
#armor "Circlet"
#armor "Buckler"
#end

#newmonster 2608
#copystats 2601
#name "Watcher"
#descr "In the dying days of old Nehekhara, the Tomb Priests saw they alone
would not be able to protect the vast tombs once the last vestiges of their
civilization had fallen. And so to the peasants and criminals, the priests
offered a terrible choice: watch over the tombs for the millennia to come, and
in return live to see the coming of paradise. Some came forward, and the
priests chose the strongest to serve as Watchers. Through powerful rituals
they were gifted with the same immortality as the priests themselves - while
their bodies withered and dried to husks they would never die of natural
causes. The watchers stood guard over the tombs, spotting any treasure hunters
far off, moving stealthily through the necropoli, and killing without warning.
They wear no armor but wield halberds salvaged from treasure hunters, and
miniature crossbows firing darts which paralyze their opponents. Their bodies
are no longer as strong as they once were, but they remain strong and deadly
opponents."
#spr1 "./TombKings/Watcher.tga"
#spr2 "./TombKings/WatcherAttack.tga"
#gcost 16
#hp 14
#prot 8
#att 12
#def 12
#str 13
#mr 15
#maxage 2500
#weapon "Halberd"
#weapon "Dart Crossbow"
#end

#newmonster 2609
#copystats 2600
#name "Tomb Guard"
#gcost 14
#descr "The Tomb Guard were originally an elite corps of troops assigned to protecting a necropolis containing the tombs of past kings. Over time the order grew and began to act as a part of the main army, and was imitated in the other kingdoms of Nehekhara. They were found to be very effective in war due to their superior equipment and training. The Tomb Guard are much more heavily armored than most Nehekharan soldiers, and wield deadly falchions."
#spr1 "./TombKings/TombGuard.tga"
#spr2 "./TombKings/TombGuardAttack.tga"
#att 12
#def 12
#str 11
#mr 16
#mor 30
#pooramphibian
#weapon "Falchion"
#armor "Bronze Armor"
#armor "Circlet"
#armor "Nehekharan Shield"
#end

#newmonster 2610
#copystats 2600
#name "Buried"
#gcost 18
#descr "Most of the legions of soldiers filling the necropoli of Nehekhara are those slain in battle, or old veterans buried on their eventual deaths, or those soldiers unlucky enough to be most highly valued by their king, and hence buried with him by force. But on the entombment of a Tomb King, a call would go out - those bravest of soldiers willing to sacrifice their lives to stay with their king could, by choice, be buried alive when the tomb was closed. These troops would line up in ranks in full disciplined order, and then stand unflinching as the chamber was filled with sand. As a result of their incredible self sacrifice these reawakened soldiers are sacred to the Nehekharans."
#spr1 "./TombKings/Buried.tga"
#spr2 "./TombKings/BuriedAttack.tga"
#att 12
#def 11
#str 11
#mr 16
#mor 30
#holy
#pooramphibian
#weapon "Spear"
#armor "Shoulder Guard"
#armor "Circlet"
#armor "Nehekharan Shield"
#end

#newmonster 2611
#copystats 2601
#name "Immortal"
#gcost 40
#descr "Many of the Tomb Kings were filled with paranoia on their burial - who knew what lay ahead? Most of all they feared being left stranded and alone, their guardian troops lost to them. The kings themselves were protected by awesome enchantments, almost impossible to permanently destroy, but they knew that their guards were far more vulnerable. And so the most powerful of the Tomb Kings set about, with the aid of their priests, to create a personal bodyguard of their most trusted troops that could themselves never be destroyed. No matter what befell them, their bodies would always reform in their tombs. These bodyguards, known as Immortals, are highly disciplined and effective troops, and as the closest guardians of the sacred Tomb Kings, they are sacred to the Nehekharans. However, powerful magic is needed to revive the Immortals, and their enchantment requires frequent renewal with costly incenses and balms."
#spr1 "./TombKings/Immortal.tga"
#spr2 "./TombKings/ImmortalAttack.tga"
#hp 10
#att 13
#def 12
#str 11
#prot 2
#mr 16
#mor 30
#holy
#immortal
#undead
#weapon "Falchion"
#armor "Bronze Armor"
#armor "Circlet"
#armor "Nehekharan Shield"
#end

#newmonster 2612
#copystats 2600
#name "Scout"
#descr "The scouts of Nehekhara are awakened soldiers clad in black cloth and trained to move in shadow and pass unseen through enemy territory."
#spr1 "./TombKings/Agent.tga"
#spr2 "./TombKings/AgentAttack.tga"
#stealthy 0
#mor 30
#gcost 20
#noleader
#end

#newmonster 2613
#copystats 2600
#name "Ancient Champion"
#spr1 "./TombKings/AncientChampion.tga"
#spr2 "./TombKings/AncientChampionAttack.tga"
#descr "The ancient Nehekharans placed great value on martial skills, and the finest of their warriors were
highly respected. When they died these warriors would be buried with great ceremony, and their bodies would be
protected by especially powerful enchantments. The undead kingdoms of Nehekhara can now draw from the finest
warriors from millennia of the old kingdoms. They are fighters of exceptional skill, their physical abilities
enchanced further by the powerful magic animating them. They are also competent leaders."
#gcost 40
#mor 30
#pooramphibian
#att 15
#def 14
#str 14
#hp 16
#mr 16
#ambidextrous 2
#okleader
#okundeadleader
#weapon "Falchion"
#weapon "Short Sword"
#armor "Bronze Armor"
#armor "Circlet"
#end

#newmonster 2627
#copystats 2601
#name "Tomb Prince"
#gcost 140
#descr "The Tomb Kings of Nehekhara frequently took many concubines, and so a single king might produce tens of sons. These sons were treated as high nobility, but would be expected by their fathers to live up to their position. It was traditional for the princes to enter the priesthood, but they would also train in military affairs and many became generals. The more gifted would study the mysterious arts of magic - if they were to have any hope of following in their father's footsteps they would have to reach the highest levels of achievement in sword, sorcery and the priesthood. The princes enter battle on ornate, jewel-studded chariots and wearing the finest of armors."
#spr1 "./TombKings/TombPrince.tga"
#spr2 "./TombKings/TombPrinceAttack.tga"
#hp 18
#str 12
#att 14
#def 13
#mr 16
#size 4
#trample
#mounted
#ap 22
#mapmove 4
#prot 10
#magicskill 8 1
#custommagic 4224 50
#custommagic 4224 50
#custommagic 7552 10
#weapon "Spear"
#armor "Gilded Armor"
#armor "Circlet"
#armor "Buckler"
#goodleader
#goodundeadleader
#nomagicleader
#holy
#end

#newmonster 2614
#copystats 2600
#name "Buried Sorceror"
#gcost 180
#descr "In ancient Nehekhara there existed mysterious men of great power, magicians and sorcerors with miraculous powers. These men wielded power over the sscorching winds and heat of the desert, and dabbled too in darker arts. Often they were trusted advisors and confidants of the Tomb Kings, since they were learned, and among the very few who shared the kings' knowledge of magic. Unfortunately for those closest to the kings, their lavish lifestyles in the palaces would come to a dire end with the passing of the king - for what king would want to pass into the afterlife without his advisors? Willingly or not, they were buried alive in the royal tombs. Now they are reawakened to wield their powerful magics once more in the service of their masters."
#spr1 "./TombKings/Sorceror.tga"
#spr2 "./TombKings/SorcerorAttack.tga"
#clearmagic
#magicskill 0 2
#magicskill 1 1
#magicskill 5 1
#mor 30
#pooramphibian
#mr 16
#noleader
#poorleader
#noundeadleader
#nomagicleader
#end

#newmonster 2615
#copystats 2601
#descr "The acolytes are low ranking Tomb Priests, lacking the power of their seniors, but still possessing sufficient knowledge of the order's wisdom that they have succeeded in preserving themselves since the fall of Nehkehara. In battle, the acolytes specialise in casting incantations to mend and repair the bodies of Nehekhara's undead legions. Many an army will be accompanied by a large number of acolytes, so that their enemies will find the effects of their blows undone before their very eyes."
#spr1 "./TombKings/Acolyte.tga"
#spr2 "./TombKings/AcolyteAttack.tga"
#name "Acolyte"
#gcost 35
#mor 30
#poorleader
#poorundeadleader
#magicskill 8 1
#holy
#end

#newmonster 2616
#copystats 2601
#name "Tomb Priest"
#gcost 100
#descr "In the society of Nehekhara the priesthood were the ruling class. The traditions of the priesthood stretched back for millennia even before the fall of the nation, and was an order of great learning. They foresaw the fall, and, thousands of years in advance, set about preparing for it. They developed powerful magics of self preservation, so that even as their bodies withered they would never die - a miserable but effective form of immortality. They coordinated the burial of the Tomb Kings and their legions, the nobility and their women, and performed powerful incantations to preserve them and prepare them for reawakening in paradise. And during the long darkness since the fall they have kept watch and protected the tombs. Now all their plans have come to naught, and instead they fight with the undead legions of awakened Nehekhara. The priests have considerable power over the dead, and can cast potent enchantments to protect and fortify them in battle."
#spr1 "./TombKings/Priest.tga"
#spr2 "./TombKings/PriestAttack.tga"
#mor 30
#poorleader
#poorundeadleader
#magicskill 5 1
#magicskill 8 2
#researchbonus 1
#holy
#makemonster1 2602
#end

#newmonster 2617
#copystats 2601
#name "High Priest"
#gcost 210
#descr "The High Priests are the highest ranking of the Tomb Priests, and wield considerable divine and magical power over the dead. They have access to a powerful array of enchantments to assist the soldiers of Nehekhara in battle, and also often act as generals for the Nehekharan legions. The High Priests are unimaginably ancient and learned, and excel at magical research. They also have the power to awaken the sleeping Nehekharan legions without the use of the expensive materials normally required, although the process is extremely slow. Nehekharan armies are often accompanied by caravans containing sarcophagi of unawakened troops, so that the High Priests can awaken them given the opportunity. Tomb Priests of lesser rank can also awaken troops in the same way, but far more slowly."
#spr1 "./TombKings/HighPriest.tga"
#spr2 "./TombKings/HighPriestAttack.tga"
#mor 30
#okleader
#okundeadleader
#poormagicleader
#magicskill 5 2
#magicskill 8 3
#researchbonus 3
#holy
#makemonster2 2602
#end

#newmonster 2618
#copystats 2601
#name "Tomb King"
#gcost 420
#descr "The Tomb Kings of Nehehkhara were individuals of extraordinary power. With the passing of the previous king, the new ruler would be chosen on the basis of his wisdom and strength, and the contendors were always exceptional. Invariably drawn from the senior ranks of the priesthood these individuals had been able to extend their lives indefinitely, and they did not fail to make use of their time, learning mysterious magic and travelling foreign lands. Once chosen, his acolytes would endlessly perform incantations to further strengthen the physical and magical powers of their near-divine ruler. A Tomb Kings would often rule for several centuries, before deciding that his time in this life had come to an end, and would retreat to his tomb to await paradise. Such are the strength of the enchantments on the reawakened king that he is almost impossible to destroy, although if he is very badly injured the release of magical energies needed to keep him alive will leave him severely weakened."
#spr1 "./TombKings/TombKing.tga"
#spr2 "./TombKings/TombKingAttack.tga"
#goodleader
#goodundeadleader
#poormagicleader
#clearmagic
#magicskill 0 2
#magicskill 5 3
#magicskill 8 3
#custommagic 6144 100
#custommagic 1408 100
#custommagic 7552 50
#custommagic 7552 10
#mor 30
#hp 25
#str 14
#att 14
#def 14
#mr 18
#holy
#weapon "Cobra Staff"
#armor "Gilded Armor"
#armor "Royal Headdress"
#researchbonus 1
#secondshape 2619
#makemonster2 2602
#end

-- Second form
#newmonster 2619
#copystats 2601
#name "Tomb King"
#descr "The Tomb Kings of Nehehkhara were individuals of extraordinary power. With the passing of the previous king, the new ruler would be chosen on the basis of his wisdom and strength, and the contendors were always exceptional. Invariably drawn from the senior ranks of the priesthood these individuals had been able to extend their lives indefinitely, and they did not fail to make use of their time, learning mysterious magic and travelling foreign lands. Once chosen, his acolytes would endlessly perform incantations to further strengthen the physical and magical powers of their near-divine ruler. A Tomb King would often ruled for several centuries, before deciding that his time in this life had come to an end, and would retreat to his tomb to await paradise. This Tomb King has been physically destroyed in battle, and his body has been reformed by the powerful enchantments animating him. Although physically and magically weakened his now skeletal form remains almost impossible to destroy."
#gcost 420
#spr1 "./TombKings/TombKingSkel.tga"
#spr2 "./TombKings/TombKingSkelAttack.tga"
#mor 30
#hp 20
#str 14
#att 14
#def 14
#mr 17
#fireres 0
#coldres 100
#holy
#goodleader
#goodundeadleader
#poormagicleader
#weapon "Cobra Staff"
#armor "Gilded Armor"
#armor "Royal Headdress"
#researchbonus 1
#immortal
#maxage 2000
#magicboost 57 -1
#makemonster1 2602
#end

#newmonster 2620
#name "Tomb Swarm"
#descr "Tomb Swarms consist of thousands upon thousands of long-dead insects, spiders and scorpions. Over the millenia these creatures have died in and around the Nehekharan Tombs, before being awakened by the same release of twisted necromantic magic that awoke the Nehekharans themselves. Some powerful Nehekharan mages are able to summon these swarms to the battlefield where they overwhelm enemy troops, consuming their flesh and reducing them to skeletons in seconds. Since they consist of huge numbers of tiny creatures Tomb Swarms are almost immune to arrows and are difficult to destroy with normal weapons. However, they are extremely vulnerable to fire and banishment."
#spr1 "./TombKings/TombSwarm.tga"
#spr2 "./TombKings/TombSwarmAttack.tga"
#nametype 127
#mapmove 2
#ap 6
#neednoteat
#poisonres 100
#coldres 50
#inanimate
#undead
#size 1
#gcost 0
#rcost 1
#att 18
#def 6
#str 1
#mr 12
#mor 50
#enc 0
#weapon "Tiny Bite"
#weapon "Tiny Bite"
#armor "Thousands of Bodies"
#fireres -100
#hp 1
#end

#newmonster 2621
#name "Anubite"
#spr1 "./TombKings/Anubite.tga"
#spr2 "./TombKings/AnubiteAttack.tga"
#descr "Anubis was a jackal-headed gods of the ancient Nehekharan pantheon. The Anubites were his servants, jackal-men made of black granite. When Anubis was vanquished the Anubites fell silent, appearing to be no more than statues. Now they are awakened to serve the new god. The Anubites run and jump very quickly on animal-like legs, and are very skilled fighters."
#nametype 127
#mapmove 3
#ap 16
#neednoteat
#poisonres 100
#inanimate
#noheal
#size 2
#gcost 0
#rcost 1
#att 12
#def 11
#str 12
#mr 12
#hp 12
#mor 30
#prot 18
#enc 0
#ambidextrous 3
#magicbeing
#weapon "Falchion"
#weapon "Falchion"
#armor "Shoulder Guard"
#end

#newmonster 2622
#name "Servant of Horus"
#spr1 "./TombKings/HorusServant.tga"
#spr2 "./TombKings/HorusServantAttack.tga"
#descr "Horus was an eagle-headed god of the ancient Nehekharan pantheon. He was the god of the sun and moon, and fought endlessly against the evil god Set and his undead and demonic minions. His servants are magical beings made in his image, and they wield powerful magical spears which burn with a holy fire. When Horus disappeared from the world, his servants vanished too, banished to an unknown plane. Now they are summoned back to serve the new god of Nehekhara."
#nametype 127
#mapmove 2
#ap 12
#size 2
#gcost 0
#rcost 1
#att 11
#def 13
#str 10
#mr 14
#hp 12
#mor 30
#prot 4
#enc 1
#magicbeing
#neednoteat
#fireres 50
#weapon "Spear of Horus"
#armor "Bronze Hauberk"
#armor "Shield"
#armor "Headdress"
#end

#newmonster 2623
#name "Servant of Set"
#spr1 "./TombKings/SetServant.tga"
#spr2 "./TombKings/SetServantAttack.tga"
#descr "Set was a dark and mysterious animal-headed god of the ancient Nehekharan pantheon, a god of chaos and destruction. His armies of demons and undead battled endlessly against the legions of Horus. The Servants of Set are sinister creatures created in his image. Clad in rags, they move unseen through enemy territory. They are assassins and spies, and can use their potent mental powers to sow the seeds of unrest in the lands they move through and to erase the memories of any who see them. When Set was destroyed his servants were banished, but now they are called back to serve the new god of Nehekhara."
#nametype 127
#mapmove 2
#ap 8
#size 2
#gcost 0
#rcost 1
#att 12
#def 12
#str 8
#mr 14
#hp 8
#mor 30
#prot 4
#enc 0
#fear 0
#undead
#neednoteat
#poisonres 100
#inanimate
#stealthy 25
#assassin
#spy
#weapon 63 -- Life drain
#weapon 700 -- Mental attack
#custommagic 20480 10 -- 10% death/blood
#armor "Rags"
#end

#newmonster 2624
#name "Bone Scorpion"
#spr1 "./TombKings/BoneScorpion.tga"
#spr2 "./TombKings/BoneScorpionAttack.tga"
#descr "Although the Tomb Priests of Nehekhara are almost immortal and never die of natural causes, the oldest among them seem gradually to lose awareness of the world around them, and pass into torpor. The Bone Scorpion is a huge, macabre construction built around a sarcophagus containing such an ancient priest. Although the priest is unconscious his magic permeates the scorpion, giving it false life and a degree of awareness of its own. The vast Bone Scorpions are immensely fearsome opponents on the battlefield, trampling and crushing their opponents without ever tiring."
#nametype 127
#mapmove 3
#neednoteat
#coldres 100
#poisonres 100
#inanimate
#undead
#pooramphibian
#ap 12
#size 6
#gcost 0
#rcost 1
#att 12
#def 8
#str 18
#mr 14
#hp 90
#mor 30
#prot 18
#enc 0
#trample
#fear 0
#itemslots 12288
#weapon "Pincer"
#weapon "Pincer"
#weapon 144 --Stinger
-- Give it the properties of a high priest in case it's GoRed.
#okleader
#okundeadleader
#poormagicleader
#magicskill 5 2
#magicskill 8 3
#researchbonus 1
#holy
#end

#newmonster 2625
#copyspr 491
#name "Ushabti"
#spr1 "./TombKings/Ushabti.tga"
#spr2 "./TombKings/UshabtiAttack.tga"
#descr "The Ushabti are statues built in the image of the ancient gods of Nehekhara, and animated by powerful magics. They were created to stand guard over the temples of the Tomb Priests. In times of war they would march alongside the Nehkekharan armies, inspiring them to great feats of battle. The Ushabti are carved from black granite and bone, and are extremely hard to destroy."
#nametype 127
#mapmove 3
#ap 12
#size 6
#gcost 0
#rcost 1
#att 12
#def 10
#str 20
#mr 16
#hp 80
#mor 50
#prot 20
#enc 0
#magicbeing
#neednoteat
#poisonres 100
#inanimate
#noheal
#holy
#weapon "Ritual Blade"
#armor "Bone Greaves"
#end

#newmonster 2626
#name "Ushabti Avatar"
#spr1 "./TombKings/UshabtiAvatar.tga"
#spr2 "./TombKings/UshabtiAvatarAttack.tga"
#descr "The greatest and most perfectly carved of the Ushabti would sometimes be chosen by a Nehekharan god to be an avatar. The god would give it the spark of consciousness and access to powerful magic, and would see the world through its eyes. Although the gods themselves are long since destroyed or banished, the avatars may still be awoken, and still bear the spark of power they were granted millennia ago."
#nametype 127
#mapmove 3
#ap 12
#size 6
#gcost 0
#rcost 1
#att 14
#def 12
#str 22
#mr 18
#hp 120
#prot 20
#enc 0
#magicbeing
#neednoteat
#poisonres 100
#inanimate
#noheal
#holy
#goodleader
#goodundeadleader
#poormagicleader
#custommagic 7552 100
#custommagic 7552 100
#custommagic 7552 100
#custommagic 7552 50
#custommagic 7552 50
#custommagic 7552 50
#custommagic 7552 50
-magicskill 8 3
#weapon "Ritual Blade"
#armor "Ushabti Avatar Armor"
#end

-- Heroes

#newmonster 2628
#copystats 2621
#name "Anubite Captain"
#spr1 "./TombKings/AnubiteCaptain.tga"
#spr2 "./TombKings/AnubiteCaptainAttack.tga"
#descr "The Anubite Captains are the leaders of the Anubites, once servants of the banished god Anubis.
Like the lesser anubites they are jackal-men of black granite, and run swiftly on animal-like legs.
They are exceptionally skilled fighters and leaders."
#att 15
#def 14
#str 14
#mr 14
#hp 18
#prot 18
#goodleader
#okundeadleader
#goodmagicleader
#end

#newmonster 2629
#copystats 2624
#name "Awakened Scorpion"
#spr1 "./TombKings/ScorpionHero.tga"
#spr2 "./TombKings/ScorpionHeroAttack.tga"
#descr "The Awakened Scorpion is a legendary being - for it contains the body of the only High Priest ever to awaken
from the torpor known as the Death Sleep. After the priest fell into torpor and was encased in the Scorpion, it fought
as expected for many years, showing only the animal intelligence granted it by the enchantments animating it. But then,
gradually, signs of intelligence began to appear. Finally it became apparent that the High Priest inside had awoken.
However, having grown used to the powerful body of the Scorpion, he chose to remain inside it. He has regained his
magical powers and is now one of the mightiest generals of Nehekhara. In recognition of his astonishing feat, his
Tomb King had the stinger and pincers of his Scorpion gilded."
#att 14
#def 10
#str 20
#mr 17
#prot 20
#magicskill 5 3
#expertleader
#superiorundeadleader
#goodmagicleader
#end

#newmonster 2631
#copystats 2601
#name "Warrior King"
#descr "The Warrior King is a Tomb King who focussed his life on the study of martial prowess. In battle a Warrior King
would ride with his warriors in a mighty chariot, striking down enemies in their dozens. While magically less skilled
than other Tomb Kings, a Warrior King is unparallelled in battle. This Warrior King has been physically destroyed countless
times, and each time his body has been reformed by the powerful enchantments animating him. Although physically and magically weakened his skeletal form remains almost impossible to destroy."
#gcost 420
#spr1 "./TombKings/WarriorKingSkel.tga"
#spr2 "./TombKings/WarriorKingSkelAttack.tga"
#mor 30
#hp 22
#str 15
#att 16
#def 15
#mr 17
#fireres 0
#coldres 100
#holy
#size 4
#trample
#mounted
#ap 22
#mapmove 4
#prot 10
#goodleader
#goodundeadleader
#poormagicleader
#weapon "Cobra Staff"
#armor "Gilded Armor"
#armor "Royal Headdress"
#researchbonus 1
#immortal
#maxage 2000
#magicskill 0 1
#magicskill 5 2
#magicskill 8 3
#custommagic 6144 100
#custommagic 1408 100
#custommagic 7552 50
#custommagic 7552 10
#magicboost 57 -1
#makemonster1 2602
#end

#newmonster 2632
#name "Avatar of Horus"
#spr1 "./TombKings/HorusAvatar.tga"
#spr2 "./TombKings/HorusAvatarAttack.tga"
#descr "The Avatar of Horus is a mighty living statue that was granted the spark of intelligence by Horus, a god of the ancien\
t
Nehekharans. Horus was the god of the sun and the moon, and a protector of Nehekhara. Although Horus himself was vanquished,
his Avatar retains some measure of the power granted it. It can wield the magics of the sun and moon, and is also a potent
warrior. It bears a flaming blade given it by Horus, which is deadly to undead and demons. Unfortunately the catastrophe in
which Horus was banished greatly weakened the Avatar, and it is left relatively vulnerable to enemy magics."
#nametype 127
#mapmove 3
#ap 12
#size 6
#gcost 0
#rcost 1
#att 14
#def 12
#str 22
#mr 14
#hp 120
#prot 20
#enc 0
#magicbeing
#neednoteat
#poisonres 100
#inanimate
#noheal
#holy
#goodleader
#goodundeadleader
#poormagicleader
#magicskill 0 3
#magicskill 4 2
#weapon "Blade of Horus"
#armor "Ushabti Avatar Armor"
#end

-- Pretender
#newmonster 2646
#copystats 2601
#name "First King"
#gcost 100
#spr1 "./TombKings/FirstKing.tga"
#spr2 "./TombKings/FirstKingAttack.tga"
#descr "The First King was the founder of the earliest of the great kingdoms of Nehekhara. He is a powerful mage,
and used his magics to empower his body and lengthen his life, eventually attaining immortality itself. After ruling
over his kingdom for hundreds of years, the First King finally entered torpor. Now he has reawakened to rule
his tragic kingdom once more."
#nametype 127
#mor 30
#hp 25
#str 15
#att 15
#def 15
#mr 18
#weapon "Cobra Staff"
#armor "Gilded Armor"
#armor "Royal Headdress"
#goodleader
#superiorundeadleader
#poormagicleader
#magicskill 0 1
#magicskill 5 2
#researchbonus 1
#immortal
#restrictedgod 76
#pathcost 20
#startdom 3
#end

-- Start sites
#newsite 890
#name "Tombs of Nehekhara"
#path 5
#level 0
#rarity 5
#gems 5 3
#homemon 2610
#homecom 2618
#end

#newsite 891
#name "Nehekharan Deserts"
#path 0
#level 0
#rarity 5
#gems 0 1
#gems 3 1
#end

-- Now for the nation itself! --

#selectnation 76
#clearnation
#clearsites
#name "Nehekhara"
#epithet "Tomb Kings"
#startsite "Tombs of Nehekhara"
#startsite "Nehekharan Deserts"
#color .71 .60 .05

--Gives them pyramid temple graphics.
#templepic 0
#era 2
#flag "TombKings/TombKingsFlag.tga"
#descr "The lands of Nehekhara were once vast and fertile, and its many kingdoms
were powerful for thousands of years. However, long ago a dire prophecy was
made - slowly the rivers would dry up and the land would die, and its people
with it. It was foreseen that this great drought would finally be ended by the
rising of a new god, when a great wave of
benevolent magic would sweep the land; Nehekhara would become a paradise, and
the dead, if properly preserved, would arise to live anew. So the
priests of Nehekhara set about preparing. Nobles and soldiers,
kings and wizards were buried
carefully with powerful magics, so they might reawaken in the distant future.
Gradually the great drought overtook Nehekhara, until eventually nothing
moved in the vast desert. Then, catastrophe struck - the fall of Ermor released
dark energies
that flowed around the world; in Nehekhara the great enchantments of the priests
were perverted, and its people doomed to awaken not to a new life, but
to undeath."
#summary "Race: Undead humans, prefers Heat scale +2

Military: Light infantry, cavalry and chariots, powerful summons

Magic: Death and Fire, with weak Air, Astral and Earth

Priests: Strong"

#brief "The Nehekharans are the undead soldiers of a doomed desert civilization,
emerging from their tombs to rebuild their lost kingdoms."

--Set what forts they will use.
#startfort 4
#defaultfort 4
#farmfort 3
#mountainfort 36
#swampfort 11
#forestfort 33

--Cause them to prefer heat 2.
#idealcold -2

--Give them their heroes.
#hero1 2629
#hero2 2632
#multihero1 2628
#multihero2 2631

--Set all the recruitable units.
#addrecunit 2602 -- Infantry
#addrecunit 2603 -- Heavy Infantry
#addrecunit 2604 -- Archer
#addrecunit 2605 -- Asp Archer
#addrecunit 2606 -- Cavalry
#addrecunit 2607 -- Chariot
#addrecunit 2608 -- Watcher
#addrecunit 2609 -- Tomb Guard
-addrecunit 2621 -- Anubite
-addrecunit 2622 -- Servant of Horus
-addrecunit 2624 -- Bone scorpion
-addrecunit 2625 -- Ushabti

--Set all the recruitable commanders.

#addreccom 2612 -- Agent
#addreccom 2613 -- Ancient Champion
#addreccom 2627 -- Tomb Prince
#addreccom 2614 -- Buried Sorceror
#addreccom 2615 -- Acolyte
#addreccom 2616 -- Tomb Priest
#addreccom 2617 -- High Priest
-addreccom 2623 -- Servant of Set
-addreccom 2626 -- Ushabti Avatar
-addreccom 2628 -- Anubite Captain
-addreccom 2629 -- Awakened Scorpion
-addreccom 2630 -- Warrior King
-addreccom 2632 -- Avatar of Horus

--Set the units to be used in province defense.
#defcom1 2615
#defcom2 2616
#defunit1 2602
#defunit1b 2604
#defunit2 2606
#defunit2b 2609

--Set how many of the units to appear per point.
#defmult1 15
#defmult1b 10
#defmult2 10
#defmult2b 10

--Set starting troops, commander, and bonus commander.
#startcom 2616
#startunitnbrs1 15
#startunitnbrs2 15
#startunittype1 2602
#startunittype2 2604
#startscout 2612
#end

--New spells

#newspell
#copyspell "Frighten"  -- To get sound
#name "Heal the Dead"
#descr "With this spell the priests of Nehekhara are able to repair the bodies of
undead soldiers on the battlefield, broken bones knitting back together before the
very eyes of their opponents."
#restricted 76
#path 0 8
#researchlevel 0
#school 7
#pathlevel 0 1
#researchlevel 0
#aoe 2003
#effect 13
#damage 1
#fatiguecost 0
#nreff 1
#range 50
#precision 100
#explspr 10054
#spec 75513984
#end

#newspell
#copyspell "Frighten"
#name "Resilience"
#descr "This spell allows a priest of Nehekhara to briefly reinforce the enchantments
holding undead soldiers together and gift them with the strength of the desert. They
become much harder to destroy in combat and also gain a degree of fire resistance."
#restricted 76
#path 0 8
#researchlevel 0
#school 7
#pathlevel 0 2
#aoe 2001
#effect 10
#damage 1040
#fatiguecost 0
#nreff 1
#range 30
#precision 100
#explspr 10053
#spec 75518080
#end

#newspell
#copyspell "Frighten"
#name "The Undying"
#descr "This mighty enchantment confers regenerative abilities onto undead soldiers,
so that the skeletal bodies of the dead may repair themselves in seconds."
#restricted 76
#path 0 8
#researchlevel 0
#school 7
#pathlevel 0 3
#aoe 2000
#effect 23
#damage 536870912
#fatiguecost 0
#nreff 1
#range 30
#precision 5
#explspr 10047
-spec 75518080
#spec 75513984
#end

#newspell
#copyspell "Frighten"
#name "Strength of the Tomb"
#descr "With this spell a Nehekharan priest is able to grant enormous strength to
undead soldiers on the battlefield, giving them the ability to rip through the armour
of enemy soldiers with ease."
#restricted 76
#path 0 8
#researchlevel 0
#school 7
#pathlevel 0 2
#aoe 2001
#effect 10
#damage 128
#fatiguecost 0
#nreff 1
#range 30
#precision 100
#explspr 10057
#spec 75518080
#end

#newspell
#copyspell "Raise Dead"  -- To get sound
#name "Summon Tomb Swarms"
#descr "This spell summons a huge swarm of undead insects, scorpions and spiders from the depths of the Nehekharan tombs. The mindless swarm will crawl under armor and reduce enemy soldiers to skeletons within seconds."
#school 0
#restricted 76
#researchlevel 3
#range 25
#path 0 5
#fatiguecost 100
#pathlevel 0 4
#effect 1
#flightspr -1
#damage 2620
#spec 5060
#explspr 10057
#precision 0
#nreff 8000
#end

#newspell
#name "Awaken Immortal"
#descr "This spell awakens one of the elite members of a Tomb King's bodyguard. Such
is the strength of the enchantments on these soldiers that they are almost impossible
to permanently destroy."
#school 4
#restricted 76
#researchlevel 0
#path 0 5
#path 1 0
#pathlevel 0 3
#pathlevel 1 2
#fatiguecost 200
#effect 10001
#damage 2611
#nreff 1
#end

#newspell
#name "Awaken Anubites"
#descr "The Anubites are the sleeping granite servants of the ancient Nehekharan
god Anubis. They are powerful fighters and can run and jump rapidly across the 
battlefield."
#school 4
#restricted 76
#researchlevel 4
#path 0 5
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 800
#effect 10001
#damage 2621
#nreff 3
#end

#newspell
#name "Summon Servants of Horus"
#descr "The Servants of Horus were mighty defenders of the light, wielding their holy flaming spears to fight off hordes of demons and undead. They were banished when Horus was vanquished, but may now be summoned back to fight for Nehekhara. The Servants of Horus are disciplined and well equipped and are very good at holding a defensive line."
#school 0
#restricted 76
#researchlevel 4
#path 0 0
#path 1 4
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 1000
#effect 10001
#damage 2622
#nreff 4
#end

#newspell
#name "Summon Servant of Set"
#descr "This spell summons one of the malign servants of the vanquished god Set. The creature is a potent spy and assassin."
#school 0
#restricted 76
#researchlevel 4
#path 0 5
#pathlevel 0 3
#fatiguecost 1000
#effect 10021
#damage 2623
#nreff 1
#end

#newspell
#name "Construct Bone Scorpion"
#descr "This huge scorpion is built from bone and used to carry the casket of a
ancient and dormant Tomb Priest. The priest cannot cast any spells, but his latent
magic powers the huge construct. A bone scorpion is a fearsome opponent in battle,
capable of trampling large numbers of enemy troops."
#school 3
#restricted 76
#researchlevel 5
#path 0 5
#pathlevel 0 4
#fatiguecost 2000
#effect 10001
#damage 2624
#nreff 1
#end

#newspell
#name "Awaken Ushabti"
#descr "The Ushabtis are huge statues of granite and bone that stand guard over the temples of Nehkehara. This spell awakens one of the Ushabti, enabling it to march to war. In battle the Ushabti are powerful and very hard to destroy."
#school 4
#restricted 76
#researchlevel 3
#path 0 3
#path 1 5
#pathlevel 0 2
#pathlevel 1 2
#fatiguecost 1600
#effect 10001
#damage 2625
#nreff 1
#end

#newspell
#name "Awaken Ushabti Avatar"
#descr "The ancient gods of Nehekhara granted intelligence and magical power to a small number of Ushabti to act as their avatars. While the Gods have gone, the Ushabti remain. They are somewhat more powerful then lesser Ushabti, and possess magical powers."
#school 4
#restricted 76
#researchlevel 8
#path 0 3
#path 1 5
#pathlevel 0 4
#pathlevel 1 4
#fatiguecost 3000
#effect 10021
#damage 2626
#nreff 1
#end

 -- Arabic/Egyptian names
#selectnametype 127
#clear
#addname "Adjo"
#addname "Akhom"
#addname "Ako"
#addname "Akori"
#addname "Alu"
#addname "Amahté"
#addname "Amenemhêt"
#addname "Amenhotep"
#addname "Anemro"
#addname "Anhuri"
#addname "Anok Fero"
#addname "Anok Sabé"
#addname "Ashai"
#addname "Awan"
#addname "Awi"
#addname "Baba"
#addname "Bai"
#addname "Baki"
#addname "Baraka"
#addname "Bari"
#addname "Benipé"
#addname "Biti"
#addname "Bubu"
#addname "Buikhu"
#addname "Djadao"
#addname "Fanté"
#addname "Hêtshepsu"
#addname "Iabi"
#addname "Ialu"
#addname "Ibenré"
#addname "Itafé"
#addname "Itennu"
#addname "Djal"
#addname "Kahotep"
#addname "Kamenwati"
#addname "Kemnebi"
#addname "Kemosiri"
#addname "Kemsa"
#addname "Khai"
#addname "Khenti"
#addname "Kufu"
#addname "Manu"
#addname "Mdjai"
#addname "Menetnashté"
#addname "Meti"
#addname "Mhotep"
#addname "Mkhai"
#addname "Mkalbuti"
#addname "Mshai"
#addname "Mtidja"
#addname "Mumé"
#addname "Muntuhotep"
#addname "Nebi"
#addname "Nebibi"
#addname "Nebtawi"
#addname "Nifé-en-Ankh"
#addname "Nomti"
#addname "Nsu"
#addname "Nubi"
#addname "Oba"
#addname "Odji"
#addname "Panahasi"
#addname "Rami"
#addname "Rasui"
#addname "Remmao"
#addname "Sadji"
#addname "Saini"
#addname "Sebi"
#addname "Seini"
#addname "Semni"
#addname "Shai"
#addname "Shalam"
#addname "Shenti"
#addname "Shushu"
#addname "Sinuhé"
#addname "Sokkwi"
#addname "Suten Anu"
#addname "Suten Hamu"
#addname "Top Betuké"
#addname "Udjai"
#addname "Uro"
#addname "Urshé"
#addname "Wakhakwi"
#addname "Wakhashem"
#addname "Wati"
#end

-- SKAVEN --

----Uses ID numbers

--weapons 668-689 

--monsters 2140-2158, 2160-2178

--sites 993-5

--nation 73

--nametype 148



-------- New Weapons


#newweapon 668
#name "Mechanical Claw"
#dmg 4
#att 0
#def 0
#bonus
#end


#newweapon 669
#name "Warplightning strike"
#dmg 8
#armornegating
#att 0
#def 0
#nostr
#shock
#explspr 10219 -- lightning
#end


#newweapon 670
#name "Plague Bite"
#dmg 0
#att 0
#def -1
#len 0
#rcost 0
#bonus
#secondaryeffect 98
#end


#newweapon 671
#name "Creature Killer"
#dmg 12
#armorpiercing
#att 0
#def 0
#len 4
#twohanded
#rcost 4
#end


#newweapon 672
#name "Improved Bite"
#dmg 4
#att 0
#def 0
#len 0
#rcost 0
#bonus
#end


#newweapon 673
#name "Improved Claw"
#dmg 2
#att 0
#def 0
#len 1
#rcost 0
#end


#newweapon 674
#name "Weeping Blade"
#dmg 6
#att 1
#def 1
#len 3
#sound 8
#secondaryeffect 51
#rcost 0
#end



#newweapon 675
#name "Plague Censer"
#dmg 7
#att 1
#twohanded
#def -1
#len 4
#rcost 5
#flail
#secondaryeffectalways 687
#end


#newweapon 676
#name "Plague Scepter"
#dmg 7
#att 1
#def 0
#len 3
#rcost 4
#secondaryeffectalways 687
#end


#newweapon 677
#name "Eshin Shuriken"
#dmg -1
#att 1
#def 0
#len 0
#range 10
#ammo 2
#nratt 2
#sound 19
#flyspr 111 1
#secondaryeffect 50
#rcost 0
#end

#newweapon 678
#name "Gutter Blade"
#dmg 5
#att 1
#def 1
#len 1
#rcost 1
#secondaryeffect 50
#sound 8
#rcost 0
#end

#newweapon 679
#name "Pestilent Bite"
#dmg 0
#att -1
#def -1
#len 0
#rcost 0
#secondaryeffect 143
#bonus
#end

#newweapon 680
#name "Warp Blade"
#dmg 5
#att 1
#def 1
#len 2
#rcost 3
#secondaryeffect 232
#sound 24 
#explspr 10219 -- lightning
#end

#newweapon 681
#name "Warp Halberd"
#dmg 7
#att 0
#def 1
#len 4
#rcost 6
#secondaryeffect 232
#sound 24
#explspr 10219 -- lightning
#end


#newweapon 682
#name "Warplightning Thrower"
#shock
#armornegating
#range 15
#sound 24
#dmg 4
#nostr
#ammo 5
#nratt 7
#magic
#flyspr 210 4
#att -3
#secondaryeffectalways 669
#end



#newweapon 683
#name "Doomwheel Warplightning"
#shock
#armornegating
#range 32
#sound 24
#dmg 4
#nostr
#ammo 1
#nratt 8
#magic
#flyspr 210 4
#secondaryeffectalways 669
#att -3
#end


#newweapon 684
#name "Doomwheel Warplightning"
#shock
#armornegating
#range 16
#sound 24
#dmg 4
#nostr
#ammo 1
#nratt 16
#magic
#flyspr 210 4
#secondaryeffectalways 669
#att -3
#end

#newweapon 685
#name "Doomwheel Warplightning"
#shock
#armornegating
#range 8
#sound 24
#dmg 4
#nostr
#ammo 1
#nratt 24
#magic
#flyspr 210 4
#secondaryeffectalways 669
#att -3
#end


#newweapon 686
#name "Fly Swarm"
#dmg 2
#att 0
#def 0
#len 5
#rcost 0
#armornegating
#poison
#dt_poison
#nostr
#bonus
#end


#newweapon 687
#name "Incense Cloud"
#dmg 2
#armornegating
#att 0
#def 0
#len 0
#aoe 3
#poison
#dt_poison
#nostr
#explspr 10059
#end


#newweapon 688
#name "Poison Wind Globe"
#dmg -2
#att -3
#def 0
#ammo 5
#range 14
#secondaryeffectalways 689
#flyspr 111 1
#end


#newweapon 689
#name "Poison Wind"
#dmg 6
#dt_poison
#armornegating
#poison
#nostr
#explspr 10139
#aoe 2
#end




----------------- MONSTERS


-------- Recruits


----Clanrat (sword)

#newmonster 2140
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Clanrat Sword.tga"
#spr2 "./Skaven/Clanrat Sword2.tga"
#name "Clanrat"
#descr "Clanrat warriors form the bulk of every Skaven army. On their own, Clanrats are not exceptional fighters, lacking the discipline, determination and physical strength of other races, however with numbers on their side their superior agility and infamous natural ferocity make them fearsome opponents. These Clanrats are of higher status and are better equipped than their spear carrying brethren."
#hp 9
#size 2
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 10
#def 11
#prec 8
#mapmove 2
#ap 15
#gcost 8
#rcost 1
#armor "Ring Mail Hauberk"
#armor "Iron cap"
#weapon "falchion"
#armor "shield"
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#nametype 148
#end


----Clanrat (spear)

#newmonster 2141
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Clanrat Spear.tga"
#spr2 "./Skaven/Clanrat Spear2.tga"
#name "Clanrat"
#descr "Clanrat warriors form the bulk of every Skaven army. On their own, Clanrats are not exceptional fighters, lacking the discipline, determination and physical strength of other races, however with numbers on their side their superior agility and infamous natural ferocity make them fearsome opponents. These Clanrats are of lower status and have worse equipment than their sword armed brethren."
#hp 9
#size 2
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 10
#def 11
#prec 8
#mapmove 2
#ap 15
#gcost 7
#rcost 1
#armor "Ring Mail Cuirass"
#armor "Iron cap"
#weapon "spear"
#armor "shield"
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#nametype 148
#end

----Skavenslave

#newmonster 2142
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Skavenslave.tga"
#spr2 "./Skaven/Skavenslave2.tga"
#name "Skavenslave"
#descr "Masses of slaves are often pushed at the head of Skaven armies as a screen against missile fire or to test the strength of the enemy. Skaven generals send them to be butchered without the slighest hesitation and other Skaven care little for their fate. Often malnourished and weakened, they are still capable of tiring and overwhelming some enemies."
#hp 8
#size 2
#prot 0
#mor 6
#mr 10
#enc 3
#str 8
#att 8
#def 9
#prec 8
#mapmove 2
#ap 15
#gcost 5
#rcost 1
#armor "leather cuirass"
#weapon "club"
#poisonres 35
#stealthy 0
#maxage 30
#fireres -25
#coldres -25
#nametype 148
#end


----Stormvermin

#newmonster 2143
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Stormvermin.tga"
#spr2 "./Skaven/Stormvermin2.tga"
#name "Stormvermin"
#descr "The fur of larger Skaven tends to be darker than normal and for this reason black-furred Skaven are respected and feared by their brethren. These stronger, more vicious warriors are normally hand-picked by Warlords or powerful Chiefs to create elite units of Stormvermin. Better equipped than their comrades, Stormvermin on the battlefield are inevitably either safeguarding an important Skaven leader or have been given the task of eliminating their elite opposites amongst enemy ranks, once they have been suitably weakened by slaves, clanrats and various support troops. They are armed with lethal glaives, perfect for cutting down fatigued armoured troops or finishing off larger enemies. They are a little more courageous than Clanrats, but retain the naturally cautious nature of their race."
#hp 11
#size 2
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 11
#def 12
#prec 9
#mapmove 2
#ap 15
#gcost 11
#rcost 1
#armor "Scale Mail Hauberk"
#armor "Half Helmet"
#weapon "glaive"
#poisonres 40
#stealthy 0
#maxage 30
#siegebonus 1
#nametype 148
#end

----Night Runner


#newmonster 2144
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Night Runner.tga"
#spr2 "./Skaven/Night Runner2.tga"
#name "Eshin Night Runner"
#descr "Night Runners are the lowest ranking troops in Clan Eshin and have a notoriously low survival rate, compounded by their lack of armour and role as skirmishers whose task is to neutralise more dangerous enemies. They are armed with nets and short blades and are given basic training in stealth warfare and martial arts by their masters, but only the luckiest, most determined or sneakiest are expected to survive battle; perfect candidates for the ranks of the Gutter Runners."
#hp 9
#size 2
#prot 0
#mor 9
#mr 10
#enc 3
#str 9
#att 10
#def 12
#prec 10
#mapmove 2
#ap 16
#gcost 8
#rcost 1
#armor "Leather Cuirass"
#weapon "short sword"
#weapon "net"
#poisonres 35
#stealthy 5
#maxage 30
#siegebonus 1
#nametype 148
#end


----Gutter Runner


#newmonster 2145
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Gutter Runner.tga"
#spr2 "./Skaven/Gutter Runner2.tga"
#name "Eshin Gutter Runner"
#descr "Gutter Runners are feared Eshin troops, well trained in the art of infiltration, ambush and sabotage. They are highly proficient at digging tunnels and are often used when sieging enemy fortifications. They wear light but effective armour under their black robes and have a surprisingly high survival rate for Skaven, due mainly to their ability to pick and choose where and when they will fight. They are armed with both poisoned blades for close combat and also venomous thrown shuriken, making them versatile troops. Their skills, however, come at rather a high price."
#hp 9
#size 2
#prot 0
#mor 10
#mr 10
#enc 3
#str 9
#att 12
#def 13
#prec 11
#mapmove 2
#ap 16
#gcost 20
#rcost 1
#armor "Scale mail cuirass"
#weapon "Gutter Blade"
#weapon "Gutter Blade"
#weapon "Eshin Shuriken"
#ambidextrous 2
#poisonres 50
#stealthy 10
#maxage 30
#siegebonus 3
#nametype 148
#end


----Plague Monk

#newmonster 2146
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Plague Monk.tga"
#spr2 "./Skaven/Plague Monk2.tga"
#name "Pestilens Plague Monk"
#descr "Plague Monks form the bulk of Clan Pestilens' troops. They wear tattered robes and bandages to cover their disease ridden, sore-covered and horribly scarred bodies. So used are they to constant pain and disease that it appears to affect them not at all, indeed it is taken as a sign of their God's blessing and they must be hacked to pieces before they will cease fighting, such is their fanatical zeal. Plague Monks have been exposed to so many toxins and poisons that they have become nearly immune to them."
#hp 12
#size 2
#prot 3
#mor 9
#mr 10
#enc 3
#str 9
#att 10
#def 11
#prec 8
#mapmove 2
#ap 15
#gcost 8
#rcost 1
#weapon "short sword"
#weapon 679
#poisonres 80
#stealthy 0
#maxage 30
#berserk 1
#siegebonus 1
#swampsurvival
#nametype 148
#end


----Plague Censer Bearer

#newmonster 2147
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Plague Censer.tga"
#spr2 "./Skaven/Plague Censer2.tga"
#name "Pestilens Censer Bearer"
#descr "Only the most deranged and fanatical worshippers of disease are chosen for the honour of carrying a plague censer. These weapons are heavy flails whose spiked heads are filled with burning warpstone incense. The Censer Bearers are fed a special brew laced with warpstone which further enhances their zeal and physical prowess. In battle Censer bearers charge ahead of the ranks of Plague Monks, reciting the Liturgicus Infecticus at a frenzied pitch. They then charge the enemy and begin swinging their heavy censers, releasing a cloud of poisonous gas which is almost as fatal to the Skaven as it is to their foes. This proves to be little deterrent to these fanatic ratmen who scream prayers of thanks to God even as they die, their lungs filled with blood and pus. With the awakening of God, the Censers have become sacred to all Skaven."
#hp 16
#size 2
#prot 5
#mor 12
#mr 10
#enc 3
#str 11
#att 10
#def 11
#prec 8
#mapmove 2
#ap 15
#gcost 25
#rcost 1
#weapon "plague censer"
#weapon 679
#poisonres 85
--poisoncloud 2
--poisonarmor
#stealthy 0
#maxage 30
#berserk 3
#swampsurvival
#holy
#nametype 148
#end


----Council Guard

#newmonster 2148
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Council Guard.tga"
#spr2 "./Skaven/Council Guard2.tga"
#name "Council Guard"
#descr "The albino Guard of the Council of Thirteen are an ever present and intimidating military force in Skavenblight. They are utterly loyal to the Council and when they march it is usually on a mission of great importance. It is rumoured that they were secretly bred and presented to the Council by Clan Moulder in order to ensure their seat. It is not known whether the Council Guard were bred to be mute, or whether they take a vow; all that is known is that they are utterly silent and utterly loyal. These extremely unskavenlike traits have only added to their mystique and they are regarded as sacred amongst the ratmen. They are armed identically to Stormvermin and have similar training, though they are even larger and more skilled in battle."
#hp 13
#size 2
#prot 0
#mor 12
#mr 11
#enc 3
#str 11
#att 12
#def 13
#prec 10
#mapmove 2
#ap 15
#gcost 20
#rcost 1
#armor "Scale Mail Hauberk"
#armor "Half Helmet"
#weapon "glaive"
#holy
#poisonres 50
#stealthy 0
#maxage 30
#siegebonus 1
#nametype 148
#end


----Giant Rat

#newmonster 2149
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Giant Rat.tga"
#spr2 "./Skaven/Giant Rat2.tga"
#name "Moulder Giant Rat"
#descr "Clan Moulder has grown these horrible rat-beasts to the size of wolves, retaining their ferocity and everlasting hunger. Relatively easy to breed, these are the cheapest beasts for Warlord clans to buy and are a common sight amongst any Skaven army. A seething mass of stinking fur and sharp fangs, these creatures can overwhelm even the most disciplined enemies."
#hp 9
#size 2
#prot 2
#mor 7
#mr 5
#enc 3
#str 9
#att 10
#def 12
#prec 4
#mapmove 2
#ap 17
#gcost 3
#rcost 1
#weapon "bite"
#poisonres 40
#stealthy 0
#maxage 16
#animal
#nametype 148
#end



----Poison Wind Globadier

#newmonster 2150
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Globadier.tga"
#spr2 "./Skaven/Globadier2.tga"
#name "Skryre Poison Wind Globadier"
#descr "Globadiers are highly specialised troops armed with deadly poison wind globes. These fragile spheres of glass are filled with toxic warpstone-derived fumes produced by the Warlock Engineers in their secret laboratories. Small groups of Globaiders can often be found scuttling on the flanks of Skaven armies, lobbing their grenades against elite units whose thick armour proves no defence at all. Like most Skryre units they are particularly useful in a siege. Because of the clear risks of their occupation, trained Globadiers demand high pay."
#hp 9
#size 2
#prot 0
#mor 8
#mr 11
#enc 3
#str 9
#att 10
#def 11
#prec 7
#mapmove 2
#ap 15
#gcost 22
#rcost 3
#armor "Ring Mail Cuirass"
#armor "Full Helmet"
#weapon "short sword"
#weapon 688
#poisonres 60
#stealthy 0
#maxage 30
#siegebonus 2
#nametype 148
#end




----Skavenslave Group (3 members)

#newmonster 2151
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/GroupSkavenslaveA.tga"
#spr2 "./Skaven/GroupSkavenslaveA2.tga"
#name "Skavenslaves"
#descr "Masses of slaves are often pushed at the head of Skaven armies as a screen against missile fire or to test the strength of the enemy. Skaven generals send them to be butchered without the slighest hesitation and other Skaven care little for their fate. Often malnourished and weakened, they are still capable of tiring and overwhelming some enemies."
#hp 8
#size 3
#ressize 2
#prot 0
#mor 6
#mr 10
#enc 3
#str 8
#att 8
#def 9
#prec 8
#mapmove 2
#ap 14
#gcost 13
#rcost 4
#armor "leather cuirass"
#weapon "club"
#weapon "club"
#ambidextrous 3
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 2
#secondshape 2152
#nametype 148
#end


----Skavenslave Group (2 members)

#newmonster 2152
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/GroupSkavenslaveB.tga"
#spr2 "./Skaven/GroupSkavenslaveB2.tga"
#name "Skavenslaves"
#descr "Masses of slaves are often pushed at the head of Skaven armies as a screen against missile fire or to test the strength of the enemy. Skaven generals send them to be butchered without the slighest hesitation and other Skaven care little for their fate. Often malnourished and weakened, they are still capable of tiring and overwhelming some enemies."
#hp 8
#size 3
#ressize 2
#prot 0
#mor 6
#mr 10
#enc 3
#str 8
#att 8
#def 9
#prec 8
#mapmove 2
#ap 14
#gcost 9
#rcost 2
#armor "leather cuirass"
#weapon "club"
#weapon "club"
#ambidextrous 3
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#secondshape 2142
#fireres -25
#coldres -25
#nametype 148
#end

---- Moulder Rat Ogre

#newmonster 2153
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Rat Ogre.tga"
#spr2 "./Skaven/Rat Ogre2.tga"
#name "Moulder Rat Ogre"
#descr "Rat Ogres are the masterpiece of Clan Moulder's mad research. They are massive hulking monsters, created from a warped mix of different creatures. Only the strongest Rat Ogres survive the terrible conditions that the Packmasters impose on them from birth, forcing them to compete for food and shelter. The ones that survive to maturity are little more than a mass of sinewy muscles and razor-sharp claws, moved only by their strong instinct to kill. Because they must be 'rented' from clan Moulder, they can be expensive if used in force."
#hp 30
#size 3
#prot 6
#mor 10
#mr 10
#enc 3
#str 17
#att 10
#def 11
#prec 4
#mapmove 2
#ap 17
#gcost 25
#rcost 1
#berserk 1
#weapon 672
#weapon 673
#weapon 673
#ambidextrous 2
#poisonres 50
#stealthy 0
#maxage 20
#nametype 148
#end

---- Skryre Warpfire Thrower

#newmonster 2154
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Warpfire Thrower.tga"
#spr2 "./Skaven/Warpfire Thrower2.tga"
#name "Skryre Warpfire Thrower"
#descr "The Warpfire Thrower is one of Clan Skryre's oldest and most popular inventions, widely employed by all clans in warfare both above and below ground. It is operated by a team of two Skaven; one to aim the nozzle of the Thrower itself and one to haul and tinker with the storage tank full of unstable Warpfire. The thrower is far from accurate, but friendly casualties are entirely accepted amongst the Skaven, particularly when most of them are inflicted upon lowly Skavenslaves. If sufficiently damaged, the Warpfire Thrower will become even more unstable and dangerous to all around it. Warpfire throwers were designed by Skryre to require a continuous supply of replacement parts and can be expensive to maintain."
#hp 10
#size 3
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 10
#def 11
#prec 5
#mapmove 2
#ap 15
#gcost 40
#rcost 1
#armor "Scale mail hauberk"
#armor "Half Helmet"
#weapon "short sword"
#weapon 225
#weapon 225
#weapon 225
#fireres 50
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#secondtmpshape 2155
#nametype 148
#end


---- Damaged Warpfire Thrower

#newmonster 2155
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Warpfire Thrower.tga"
#spr2 "./Skaven/Warpfire Thrower2.tga"
#name "Damaged Warpfire Thrower"
#descr "A Skryre Warpfire Thrower which has been struck and is now even more unstable than usual, blasting the surrounding area with heat and spraying jets of warpfire in all directions as the crew struggle to control it and avoid being immolated. The team are immobile but can still be quite dangerous. The device is too damaged to recover after battle."
#hp 6
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 9
#att 9
#def 9
#prec 1
#mapmove 0
#ap 2
#immobile
#gcost 5
#rcost 1
#armor "Scale mail hauberk"
#armor "Half Helmet"
#weapon "short sword"
#fireshield 6
#heat
#weapon 225
#weapon 225
#weapon 225
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#nametype 148
#end


----Pestilens Plague Rat

#newmonster 2156
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Giant Rat.tga"
#spr2 "./Skaven/Giant Rat2.tga"
#name "Pestilens Plague Rat"
#descr "Clan Moulder do not have a total monopoly on the breeding of deadly creatures; Clan Pestilens developed their own methods for breeding dog sized rats while in the steaming jungles of Lustria. Often unable to militarily overpower their mortal foes, the native Lizardmen, the Plague Priests turned to their extensive knowledge of contagion for answers and refined a bewildering variety of plagues. Their rats made the perfect carriers; fast, vicious and utterly expendable. Upon their return to Skavenblight, the Plague Priests set about developing new contagions and unleashing them upon the world. These rats are at first glance virtually identical to the common Moulder variety; a trait which has often helped the Skaven deliver them into the heart of the enemy ranks with their virulent payload."
#hp 8
#size 2
#prot 2
#mor 7
#mr 5
#enc 3
#str 8
#att 10
#def 12
#prec 4
#mapmove 2
#ap 17
#gcost 4
#rcost 1
#weapon "Plague Bite"
#poisonres 50
#stealthy 0
#maxage 16
#animal
#nametype 148
#end


---- Skryre Warplightning Thrower

#newmonster 2157
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Warplightning Thrower.tga"
#spr2 "./Skaven/Warplightning Thrower2.tga"
#name "Skryre Warplightning Thrower"
#descr "The Warplightning Thrower is Clan Skryre's latest invention, designed and perfected by none other than Master Warlock Ikkit Claw himself. Much like the Warpfire Thrower, it is an unpredictable and devastating weapon powered by specially treated warpstone which is carried into battle by a team of two Skaven. Warplightning throwers were designed by Skryre to require a continuous supply of replacement parts and can be expensive to maintain."
#hp 14
#size 3
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 10
#def 11
#prec 5
#mapmove 2
#ap 15
#gcost 45
#rcost 1
#armor "Scale mail hauberk"
#armor "Half Helmet"
#weapon "Warp Blade"
#weapon "Warplightning Thrower"
#shockres 75
#poisonres 35
#stealthy 0
#maxage 30
#nametype 148
#end


---- Skryre Doomwheel

#newmonster 2158
#spr1 "./Skaven/Doomwheel.tga"
#spr2 "./Skaven/Doomwheel.tga"
#name "Skryre Doomwheel"
#descr "The Doomwheel is perhaps Clan Skryres weirdest war machine; a huge pair of spiked wheels driven by rats constantly jolted into motion with blasts of energy, controlled by nothing more than the frantic and possibly insane Warlock driver and a single guide wheel at the rear. As the Doomwheel tears forward towards the enemy it unleashes energy from its warpstone generators which manifests in warplightning which is cast in the rough direction of the foe. The closer the Doomwheel gets, the stronger the crackling blasts of warplightning become. In addition to this fearsome ranged attack, the Doomwheel is quite capable of simply running over enemy formations, crushing even heavily armoured troops beneath the great wheels."
#hp 12
#size 5
#prot 12
#mor 13
#mr 14
#enc 1
#str 14
#att 10
#def 11
#prec 7
#mapmove 3
#ap 25
#gcost 60
#rcost 1
#mounted
#trample
#armor "reinforced leather cap"
#armor "ringmail cuirass"
#weapon "Warp Blade"
#weapon 683
#weapon 684
#weapon 685
#shockres 100
#poisonres 35
#maxage 30
#nametype 148
#end


-------- Commanders

----Chieftan

#newmonster 2160
#copystats 2170
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Chieftan.tga"
#spr2 "./Skaven/Chieftan2.tga"
#name "Chieftan"
#descr "The leaders of lesser clans, those that can neither claim the title of Warlord or Greater Clan, the chieftans are numerous and somewhat expendable, though with their accompanying slaves and clanrats they can certainly add weight to the teeming hordes that make up a Skaven army. Like most Skaven of any import, they make it their business to lead from the back, pushing their subordinates forward toward enemy lines while prudently avoiding the danger of pitched battle. Chieftans may choose to gather three slaves per month, pushing them into combat ahead of the main force of Clanrats."
#hp 10
#size 2
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 11
#def 12
#prec 8
#mapmove 2
#ap 15
#gcost 45
#rcost 1
#makemonster1 2151
#armor "Scale mail Hauberk"
#armor "Half Helmet"
#weapon "glaive"
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#standard 3
#mountainsurvival
#okleader
#nametype 148
#end



----Warlord

#newmonster 2161
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Warlord.tga"
#spr2 "./Skaven/Warlord2.tga"
#name "Warlord"
#descr "The leaders of the Warlord Clans are cunning Skaven who have fought, schemed, bribed and cheated their way to the top in the traditional manner. While the Greater Clans of Pestilens, Moulder, Eshin and Skryre are undoubtedly far more influential and powerful, with guaranteed seats on the Council of Thirteen, without the numerous Warlord Clans the Skaven could not launch their vast campaigns against the surface world. Warlords are almost always larger Skaven, usually black furred and scarred from countless battles; they are not so foolish as to risk their lives on the frontlines, but their effectiveness as fighters cannot be denied, particularly as they are equipped with the best available arms and armour. Warlords may may personally attract three Clanrats to their banner each month with threats or promises of power."
#hp 15
#size 2
#prot 3
#mor 11
#mr 10
#enc 3
#str 11
#att 12
#def 13
#prec 9
#mapmove 2
#ap 15
#gcost 120
#rcost 1
#armor "Plate Hauberk"
#armor "Half Helmet"
#weapon "falchion"
#weapon "falchion"
#ambidextrous 3
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 3
#standard 6
#makemonster3 2141
#expertleader
#nametype 148
#end

----Moulder Packmaster

#newmonster 2162
#copystats 2170
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Packmaster.tga"
#spr2 "./Skaven/Packmaster2.tga"
#name "Moulder Packmaster"
#descr "Packmasters of Moulder are tasked with the control and breeding of the more common Moulder creatures, such as teeming packs of Giant Rats. They are notorious for their skill with the whip, a symbol of their superiority and quite an incentive to any beast or Skaven too slow in following a command. They may select four Giant Rats each month to accompany the Skaven armies."
#hp 10
#size 2
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 10
#def 11
#prec 8
#mapmove 2
#ap 15
#gcost 85
#rcost 1
#makemonster4 2149
#armor "Ring mail cuirass"
#weapon "whip"
#standard 3
#poisonres 35
#stealthy 0
#maxage 30
#siegebonus 1
#custommagic 16384 25
#okleader
#mountainsurvival
#nametype 148
#end


----Eshin Assassin


#newmonster 2163
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Assassin.tga"
#spr2 "./Skaven/Assassin2.tga"
#name "Eshin Assassin"
#descr "The Assassins of Eshin are true masters of the secret lethal arts the Clan brought back from the East so many centuries ago. They have the reputation of being able to turn invisible, appearing from the shadows only to deliver silent death to their destined victims. Unlike the Gutter Runners they have little need of throwing weapons; instead they use Weeping Blades coated with hellish warpstone poison. With their extensive training, Eshin Assassins may also sabotage and disrupt enemy operations, causing unrest."
#hp 10
#size 2
#prot 2
#mor 13
#mr 10
#enc 3
#str 10
#att 14
#def 15
#prec 12
#mapmove 2
#ap 17
#gcost 90
--custommagic 256 10
#rcost 1
#ressize 1
#armor "Scale mail cuirass"
#weapon "Weeping Blade"
#weapon "Weeping Blade"
#ambidextrous 3
#poisonres 50
#stealthy 20
#assassin
#maxage 30
#spy
#siegebonus 5
#nametype 148
#end


----Plague Chantor

#newmonster 2164
#copystats 2170
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Plague Chantor.tga"
#spr2 "./Skaven/Plague Chantor2.tga"
#name "Pestilens Plague Chantor"
#descr "The Plague Chantors of Clan Pestilens have recently gained importance as servants of the Awakening God and are now found in many incursions to the surface. They chant sermons of corruption and suffering as they lead the Plague Monks into battle, ringing leper bells and calling for the Horned Rat to bless His numerous, pestilent children. Chantors have been through near constant exposure to warpstone incense and have become entirely immune to poison, making them the perfect leaders of the dangerous Plague Censers. Some Chantors have skill in Death magic and may have even picked up the practice of sacrificing slaves in the dark jungles of Lustria. Exposure to both warpstone and virulent strains of disease has altered the physical form of the Chantors, making them considerably tougher than most Skaven."
#hp 15
#size 2
#prot 5
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 11
#prec 8
#mapmove 2
#ap 15
#gcost 75
#rcost 1
#weapon "falchion"
#weapon 679
#poisonres 100
#stealthy 0
#maxage 50
#older -10
#berserk 2
#magicskill 8 1
#custommagic 4096 40
#custommagic 16384 40
#swampsurvival
#mountainsurvival
#holy
#okleader
#nametype 148
#end


----Plague Priest

#newmonster 2165
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Plague Priest.tga"
#spr2 "./Skaven/Plague Priest2.tga"
#name "Pestilens Plague Priest"
#descr "Plague Priests are the leaders of the dreaded Clan Pestilens. They spend their time celebrating the rituals of the Horned Rat in His aspect of Harbinger of Disease, and researching newer and deadlier plagues to unleash upon the surface world. Plague Priests are bloated, fetid creatures, ravaged by plague and mutation. This has left them physically powerful combatants though enough to to survive quite some punishment and strong enough to wield both a large blade and the deadly Plague Scepter with ease. Like the Chantors, many Plague Priests have brought a form of magic from the steaming jungles of Lustria which is fuelled by the sacrifice of slaves. Plague priests may convert two new plague monks per month, swelling the ranks of Clan Pestilens in times of need."
#hp 22
#size 2
#prot 7
#mor 13
#mr 10
#enc 3
#str 12
#att 12
#def 12
#prec 8
#mapmove 2
#ap 15
#gcost 210
#rcost 1
#weapon "falchion"
#weapon "plague scepter"
#ambidextrous 3
#weapon 679
#poisonres 100
#stealthy 0
#berserk 3
#makemonster2 2146
#magicskill 8 2
#magicskill 5 1
#custommagic 4096 45
#custommagic 16384 40
#custommagic 20480 15
#holy
#maxage 60
#older -10
#goodleader
#swampsurvival
#nametype 148
#end

---- Skryre Warlock

#newmonster 2166
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Warlock.tga"
#spr2 "./Skaven/Warlock2.tga"
#name "Skryre Warlock"
#descr "Clan Skryre Warlocks are adept in the art of warpstone based experimental magic and can generally be found in their laboratories tinkering with some new invention or modification. When not researching or indulging in the more traditional Skaven pastime of scheming they may support skaven armies in battle or turn to the construction of the most common Skryre weapons of war."
#hp 9
#size 2
#prot 0
#mor 8
#mr 12
#enc 3
#str 9
#att 9
#def 10
#prec 9
#mapmove 2
#ap 15
#gcost 113
#rcost 3
#armor "Leather Hauberk"
#armor "Iron cap"
#weapon "Warp Blade"
#poisonres 35
#shockres 25
#stealthy 0
#maxage 35
#siegebonus 4
#researchbonus 1
#custommagic 1152 100
#custommagic 5248 80
#nametype 148
#end


---- Skryre Warlock Engineer

#newmonster 2167
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Warlock Engineer.tga"
#spr2 "./Skaven/Warlock Engineer2.tga"
#name "Skryre Warlock Engineer"
#descr "The Warlock Engineers have expert knowledge of the workings of their bizarre weapons of war and are also dangerous mages who supplement their natural magic with warpstone devices. Each Warlock Engineer equips himself with his own creations; power generators, magic deflectors, warpstone blades and all manner of other gadgets. When not experimenting in their laboratory or supporting the troops of the Warlord Clans, Warlock Engineers may oversee the construction of a great many Skryre war machines."
#hp 9
#size 2
#prot 0
#mor 9
#mr 14
#enc 3
#str 11
#att 10
#def 11
#prec 10
#mapmove 2
#ap 15
#gcost 230
#rcost 11
#armor "Ring mail Cuirass"
#armor "Full helmet"
#weapon "Warp Halberd"
#poisonres 35
#shockres 50
#stealthy 0
#maxage 45
#older -10
#researchbonus 1
#siegebonus 10
#magicskill 0 1
#magicskill 3 1
#magicskill 5 1
#custommagic 1152 85
#custommagic 5248 35
#forgebonus 10
#nametype 148
#end


---- Grey Seer

#newmonster 2168
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Grey Seer.tga"
#spr2 "./Skaven/Grey Seer2.tga"
#name "Grey Seer"
#descr "Grey Seers are the chosen intermediaries of the Horned Rat, interpreting his will and desires for the Skaven populace. They advise and coerce the Warlord clans towards fulfilling His will and are also trusted agents of the Council of Thirteen, relaying decrees to the various clans. Any who are judged to be opposing the will of the Horned Rat are branded heretics and usually wiped out by rival clans; as such the Seers wield great influence, though as with any Skaven in a position of power, they must watch their backs at all times. Grey Seers are mages, spiritual leaders, arch-manipulators and generals of considerable status. Grey Seers frequently experience warpstone induced visions of the future and when it serves their interests they may prevent a disaster in the province they are located."
#hp 12
#size 2
#prot 3
#mor 10
#mr 14
#enc 3
#str 10
#att 11
#def 12
#prec 10
#mapmove 2
#ap 15
#gcost 360
#rcost 1
#weapon "quarterstaff"
#poisonres 35
#stealthy 0
#maxage 95
#older -25
#magicskill 5 2
#magicskill 4 2
#magicskill 8 3
#custommagic 6144 100
#holy
#goodleader
#nametype 148
#spy
#nobadevents 20
#end


----Master Moulder

#newmonster 2169
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Master Moulder.tga"
#spr2 "./Skaven/Master Moulder2.tga"
#name "Master Moulder"
#descr "Mutated by many years of exposure to large amounts of warpstone, the Master Moulders are disturbing creatures. They sometimes appear on the battlefield to inspect the impact of their creations and find inspiration on how to make them even more deadly. Their presence instills a great deal of fear and discipline in their minions, and even the most powerful Rat Ogres shy away from these vicious Skaven, a clear testament of their great skill at inflicting pain on all living creatures. Master Moulders are masters at using the infamous Moulder 'Creature Killer', a polearm designed to kill large creatures in a single blow. Each month the Master may handpick a suitable Rat Ogre from the breeding pits to send into battle."
#hp 16
#size 2
#prot 4
#mor 10
#mr 10
#enc 3
#str 11
#att 13
#def 13
#prec 8
#mapmove 2
#ap 15
#gcost 210
#rcost 1
#makemonster1 2153
#armor "Ring mail cuirass"
#weapon "Creature Killer"
#standard 7
#poisonres 50
#stealthy 0
#maxage 45
#siegebonus 1
#magicskill 7 1
#magicskill 3 1
#custommagic 16384 50
#goodleader
#nametype 148
#end



#newmonster 2170
#copystats 1447
#armor "nothing"
#end



---- Screaming Bell

#newmonster 2171
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Screaming Bell.tga"
#spr2 "./Skaven/Screaming Bell2.tga"
#name "Screaming Bell"
#descr "Screaming Bells are unholy altars from which the Grey Seers preach to the Skaven. The Bell is an ever present symbol in the legends describing the creation of the Skaven race, and its sound reaches deep within the evil hearts of the rat-men, inspiring awe and devotion. In battle the ominous sound of the Bell can be heard above the clamour of the fighting; a message of death for the rat-men's enemies and of victory for the Skaven. The Screaming Bell spreads His dominion in much the same fashion as a prophet. Furthermore, the warpstone brazier on the Screaming Bell empowers the Grey Seer and makes him an even more potent spellcaster and accurate farseer."
#hp 18
#size 6
#prot 14
#mor 16
#mr 15
#enc 3
#str 11
#att 11
#def 12
#prec 12
#mapmove 1
#ap 5
#gcost 1
#rcost 1
#mounted
#weapon "falchion"
#poisonres 100
#maxage 125
#older -70
#magicskill 5 3
#magicskill 4 3
#magicskill 8 4
#custommagic 6144 100
#holy
#superiorleader
#spreaddom 1
#standard 15
#fear 2
#nametype 148
#nobadevents 25
#end


-- Warlord Queek

#newmonster 2172
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Hero Queek.tga"
#spr2 "./Skaven/Hero Queek2.tga"
#name "Warlord Queek Head-taker"
#descr "Queek was groomed from birth as the personal champion and lieutenant of Gnawdwell, ruler of Clan Mors and one of the Lords of Decay. Queek has spent most of his time as Warlord fighting Night Goblins and Dwarfs, who he hates with unreasoning ferocity. He takes special pleasure in seeking out the strongest of the enemy heroes and leaders, challenging them to single combat, slaying them then taking their skulls or hands as as a trophy. Queek is famed amongst Skaven for both his vitriolic temper and his immense ego; indeed it is his utter confidence in himself which has arguably allowed him to gain such power in the under-empire. Like most Skaven, Queek is extremely adept at fighting with two weapons at once. As Gnawdwell's champion, Queek can take his pick of elite stormvermin as a personal bodyguard each month."
#hp 20
#size 2
#prot 3
#mor 14
#mr 11
#enc 3
#str 12
#att 15
#def 14
#prec 10
#mapmove 2
#ap 15
#gcost 1
#rcost 1
#armor "Plate Hauberk"
#armor "Half Helmet"
#weapon "falchion"
#weapon "axe"
#ambidextrous 4
#poisonres 35
#stealthy 0
#maxage 50
#older -25
#siegebonus 1
#standard 10
#makemonster3 2143
#superiorleader
#nametype 148
#itemslots 31878
#end


-- Deathmaster Snikch

#newmonster 2174
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Hero Deathmaster.tga"
#spr2 "./Skaven/Hero Deathmaster2.tga"
#name "Deathmaster Snikch"
#descr "Deathmaster Snikch is the chief assassin and prime agent of Lord Sneek, Lord of Decay and Nightlord of Clan Eshin. Snikch's infamy is only exceeded by the mystery which surrounds his whereabouts at any particular time. Lord Sneek ensures that this is the case - as long as no one knows the location of his chief assassin no one can feel safe. Deathmaster Snikch has appeared all over the Old World at one time or another, seldom being seen but always leaving his distinctive symbol traced in blood beside the mutiliated bodies of his victims. Snikch's skills as an assassin are unsurpassed and in single combat he is amongst the most dangerous mortals to have ever walked the earth. Additionally, Snikch has perfected Eastern martial to the degree that he may appear in many places at once, dodge whirling blades with ease and use his tail as a sort of third hand, traditionally grasping a weeping blade."
#hp 16
#size 2
#prot 2
#mor 16
#mr 13
#enc 3
#str 11
#att 17
#def 18
#prec 12
#mapmove 2
#ap 19
#gcost 1
#rcost 1
#armor "Scale Mail Cuirass"
#armor "Reinforced leather cap"
#weapon "Weeping Blade"
#weapon "Weeping Blade"
#weapon "Weeping Blade"
#magicskill 1 1
#ambidextrous 7
#poisonres 50
#stealthy 30
#illusion
#fear 0
#assassin
#maxage 30
#spy
#siegebonus 10
#nametype 148
#goodleader
#itemslots 31886
#end



-- Plaguelord Skrolk

#newmonster 2175
#spr1 "./Skaven/Hero Plaguelord.tga"
#spr2 "./Skaven/Hero Plaguelord2.tga"
#name "Plaguelord Skrolk"
#descr "Lord Skrolk is very old and unutterably evil. By the blessing of the Horned Rat, he has lived many times his ordinary lifespan and unleased unspeakable woes upon the world of Men. To become the festering right hand of the seventh Arch-Plaguelord Nurglitch, he traversed the insanely dangerous Blindwyrm Labyrinth in Lustria and slew countless challengers to his position. He is a powerful warrior whose body has survived the ravages of his God to become a shrine to disease, powered by the diabolic energy of the Harbinger of Disease. Skrolk is extremely difficult to kill and any approaching this terrifying creature must brave a swarm of poisonous flies that constantly surround him. The Plaguelord carries at all times the Liber Bubonicus; an ancient tome which grants him considerable magical prowess. Having clawed out his own eyes long ago, Skrolk now sees the world as it really is; a writhing, decaying mess of putrescence."
#hp 33
#prot 13
#mor 17
#mr 12
#enc 2
#str 14
#att 14
#def 13
#prec 9
#mapmove 2
#ap 14
#gcost 1
#rcost 1
#weapon "Plague Censer"
#weapon "Fly Swarm"
#weapon 679
#magicskill 8 3
#magicskill 7 2
#magicskill 5 3
#ambidextrous 3
#poisonres 100
#stealthy 0
#berserk 5
#makemonster3 2146
#regeneration 10
#fear 3
#holy
#size 3
#blind
#maxage 1313
#older -500
#nametype 148
#expertleader
#swampsurvival
#mountainsurvival
#end



---- Chosen Grey Seer Thanquol

#newmonster 2176
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Hero Thanquol.tga"
#spr2 "./Skaven/Hero Thanquol2.tga"
#name "Chosen Grey Seer Thanquol"
#descr "Thanquol is an extremely dangerous Grey Seer who, employing the most devious tactics in true Skaven fashion, as quickly risen through the ranks of his order. His ruthlessness and cunning are matched only by his extreme paranoia. His great magical skill, covert abilities and sheer cunning has made him a favourite agent of the Council of Thirteen. Though he has as many enemies as allies, Thanquol's survival instincts and powers of farsight have enabled him to survive every attempt on his life, usually at the cost of huge numbers of Skaven under his command. Wishing to reconcile with the powerful Grey Seer, the highest members of Clan Skryre recently gifted Thanquol with a new Rat Ogre bodyguard augmented with advanced Warpstone machinery. Thanquol has named this creation Boneripper in memory of his former bodyguard, slain by his Dwarf nemesis Gotrek Gurnisson."
#hp 13
#size 2
#prot 2
#mor 12
#mr 16
#enc 3
#str 10
#att 10
#def 14
#prec 12
#mapmove 2
#ap 15
#gcost 1
#rcost 1
#weapon "Quarterstaff"
#ambidextrous 3
#poisonres 50
#stealthy 10
#maxage 140
#older -120
#magicskill 5 3
#magicskill 4 4
#magicskill 8 3
#holy
#expertleader
#nametype 148
#spy
#nobadevents 50
#makemonster1 2177
#end


---- Boneripper

#newmonster 2177
#copystats 648
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Hero Boneripper.tga"
#spr2 "./Skaven/Hero Boneripper2.tga"
#name "Rat Ogre Bodyguard"
#descr "Boneripper is a heavily augmented Rat Ogre specially designed to protect Grey Seer Thanquol and follow his every order. Typically Boneripper can be found by the Seer's side, adding to his commanding presence and deterring assailants, both from enemy and friendly forces. Occasionally Thanquol will send Boneripper on an errand, usually one which involves ripping things apart. Clan Skryre has outfitted this hulking beast with a miniature warpfire thrower, an extra blade arm, warpstone enhanced vision and a variety of protective devices. The end result is a true killing machine."
#hp 45
#size 3
#prot 7
#mor 24
#mr 10
#enc 2
#str 21
#att 12
#def 10
#prec 8
#mapmove 2
#ap 16
#gcost 1
#rcost 1
#weapon "Improved bite"
#weapon "Improved Claw"
#weapon "Warp Blade"
#weapon 225
#blind
#ambidextrous 5
#stealthy 0
#poisonres 100
#fireres 50
#shockres 50
#nametype 148
#berserk 4
#regeneration 10
#mountainsurvival
#end


---- Chief Warlock Ikit Claw


#newmonster 2178
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Hero Ikit.tga"
#spr2 "./Skaven/Hero Ikit2.tga"
#name "Chief Warlock Ikit Claw"
#descr "Ikit Claw has dedicated his long life to the study of all forms of magic, even those of Elves and Men. In decades past, Ikit travelled to the far corners of the under-empire, aquiring arcana and artifacts from Cathay, Naggaroth, Lustria an even Albion. Ikit's brilliant mind absorbed all he experienced and in his travels he went further and saw more than any other mortal. By the time he returned to Skavenblight he was already one of the most powerful mages in the known world and he quickly rose to the position of Chief Warlock in Clan Skryre. In addition to his frightening knowledge of magic, Ikit is an engineering prodigy who is credited with the invention of both the Doomwheel and Warplightning Thrower. Ikit was once a tall white furred specimen, the envy of other Skaven, but after being crippled by a catastrophic lab accident he was forced to fashion himself a complex mechanical mask and claw."
#hp 13
#size 2
#prot 4
#mor 16
#mr 15
#enc 3
#str 13
#att 11
#def 11
#prec 12
#mapmove 2
#ap 12
#gcost 1
#rcost 1
Mechanical Claw"
#poisonres 75
#shockres 100
#stealthy 0
#maxage 120
#older -180
#researchbonus 2
#siegebonus 20
#magicskill 0 3
#magicskill 3 3
#magicskill 1 2
#magicskill 4 2
#magicskill 5 2
#magicskill 6 2
#forgebonus 20
#nametype 148
#itemslots 15490
#end


-------- New Pretender


---- Seerlord


#newmonster 2173
#copystats 1010
#clearmagic#clearmagic#clearmagic
#spr1 "./Skaven/Pretender Seerlord.tga"
#spr2 "./Skaven/Pretender Seerlord2.tga"
#name "Skaven Seerlord"
#descr "The Seerlord is a member of the Council of Thirteen, the Lords of Decay. He is the undisputed ruler of the Grey Seer sect and is so clearly favoured by the Horned Rat that he is approaching godhood himself. The current Seerlord has retained his position for hundreds, perhaps thousands of years and is notoriously cautious and wiley, even for a Lord of Decay. If he so wishes, the Seerlord may summon three albino Council Guard each month. Like lesser Grey Seers the Seerlord can often see beyond past and present to predict and avert disasters which are near enough to potentially cause him harm."
#hp 18
#size 2
#prot 5
#mor 30
#mr 18
#enc 2
#str 10
#att 12
#def 13
#prec 11
#mapmove 2
#ap 15
#gcost 30
#rcost 1
#weapon "falchion"
#poisonres 35
#stealthy 0
#magicskill 5 1
#magicskill 4 1
#expertleader
#pathcost 20
#startdom 2
#makemonster3 2148
#restrictedgod 73
#nametype 148
#nobadevents 40
#end


---SPELLS


---- Moulder Pitbreeding

#newspell
#copyspell "cross breeding"
#name "Moulder Pitbreeding"
#descr "Pitbreeding is an experimental process practised by Clan Moulder in which an assortment of spawn, wild creatures, prisoners and failed creations are all dropped into a pit with a group of captured slaves and exposed to huge quantities of warpstone. After a week or so the breeders recover the warpstone and collect the surviving creatures." 
#school 6
#restricted 73
#researchlevel 2
#path 0 7
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 1000
#end


---- Improved Moulder Pitbreeding


#newspell
#copyspell "improved cross breeding"
#name "Improved Moulder Pitbreeding"
#descr "Improved Pitbreeding uses more slaves, stronger warpstone and rarer creatures. The type and power of the creatures is mostly a matter of luck." 
#school 6
#restricted 73
#researchlevel 6
#path 0 7
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 2000
#end


---- Breed Giant Rat Swarm

#newspell
#name "Breed Rat Swarm"
#descr "Clan Moulder breed and select the strongest rats by forcing a constant violent struggle for survival amongst their creations while exposing them to warpstone. Training Giant Rats worthy of the armies of Skavenblight requires the use of live slaves." 
#school 6
#restricted 73
#researchlevel 1
#path 0 7
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#fatiguecost 1300
#damage 2149
#nreff 36
#end


---- Breed Pestilens Plague Rats

#newspell
#name "Breed Pestilens Plague Rats"
#descr "The Plague Priests breed their own variety of Giant Rat which they then infect with a deadly bubonic payload which may be transmitted via the rat's virulent bite. These rats look identical to Moulder Giant Rats and so are often hidden amongst them as a nasty surprise for an enemy army." 
#school 6
#restricted 73
#researchlevel 3
#path 0 7
#path 1 5
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#fatiguecost 1000
#damage 2156
#nreff 10
#end


---- Breed Rat Ogres

#newspell
#name "Breed Rat Ogres"
#descr "As with other Moulder breeding techniques, the production of suitably fierce and strong rat ogres requires the lives of many slaves. Rat Ogres are powerful though rather stupid creatures who are driven by an overwhelming desire to kill." 
#school 6
#restricted 73
#researchlevel 4
#path 0 7
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#fatiguecost 2400
#damage 2153
#nreff 13
#end


---- Construct Globadiers I

#newspell
#name "Outfit Globadiers"
#descr "Given the right materials and motivation, the Warlocks of Clan Skryre are capable of outfitting and training small teams of Poison Wind Globadiers to accompany the armies of the Warlord Clans."
#school 3
#restricted 73
#researchlevel 2
#path 0 3
#path 1 5
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#fatiguecost 400
#damage 2150
#nreff 6
#end


---- Construct Globadiers II


#newspell
#name "Mass Globadier Production"
#descr "Given the right materials and motivation, the Warlocks of Clan Skryre are capable of outfitting and training Poison Wind Globadiers to accompany the armies of the Warlord Clans. The more skilled Warlock Engineers are notorious for the speed with which they can produce entire units of these troops."
#school 3
#restricted 73
#researchlevel 4
#path 0 3
#path 1 5
#pathlevel 0 2
#pathlevel 1 1
#effect 10001
#fatiguecost 1400
#damage 2150
#nreff 24
#end


---- Construct Warpfire Throwers I

#newspell
#name "Outfit Warpfire Throwers"
#descr "Given the right materials and motivation, the Warlocks of Clan Skryre are capable of outfitting and training Warpfire Thrower Teams to accompany the armies of the Warlord Clans."
#school 3
#restricted 73
#researchlevel 3
#path 0 0
#path 1 5
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#fatiguecost 500
#damage 2154
#nreff 2
#end


---- Construct Warpfire Throwers II


#newspell
#name "Mass Warpfire Thrower Production"
#descr "Given the right materials and motivation, the Warlocks of Clan Skryre are capable of outfitting and training Warpfire Thrower Teams to accompany the armies of the Warlord Clans. Warlock Engineers with expertise in Warpfire combustion may quickly produce entire units of these troops. "
#school 3
#restricted 73
#researchlevel 5
#path 0 0
#path 1 5
#pathlevel 0 2
#pathlevel 1 1
#effect 10001
#fatiguecost 2000
#damage 2154
#nreff 8
#end


---- Construct Warplightning Throwers I

#newspell
#name "Outfit Warplightning Throwers"
#descr "Given the right materials and motivation, the Warlocks of Clan Skryre are capable of outfitting and training Warplightning Thrower Teams to accompany the armies of the Warlord Clans."
#school 3
#restricted 73
#researchlevel 4
#path 0 3
#path 1 0
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#fatiguecost 700
#damage 2157
#nreff 2
#end


---- Construct Warplightning Throwers II


#newspell
#name "Mass Warplightning Production"
#descr "Given the right materials and motivation, the Warlocks of Clan Skryre are capable of outfitting and training Warplightning Thrower Teams to accompany the armies of the Warlord Clans. Warlock Engineers with expertise in Warplightning combustion may quickly produce entire units of these troops. "
#school 3
#restricted 73
#researchlevel 6
#path 0 3
#path 1 0
#pathlevel 0 2
#pathlevel 1 1
#effect 10001
#fatiguecost 3200
#damage 2157
#nreff 8
#end



---- Construct Doomwheel

#newspell
#name "Construct Doomwheel"
#descr "The Doomwheel is one of Clan Skryre's most recent, most unpredictable and most destructive inventions. With the right materials and knowledge a Warlock Engineer may construct one and find a young Warlock crazy enough to be the driver." 
#school 3
#restricted 73
#researchlevel 7
#path 0 3
#path 1 0
#pathlevel 0 2
#pathlevel 1 2
#effect 10001
#fatiguecost 1000
#damage 2158
#nreff 1
#end


---- Construct Screaming Bell

#newspell
#name "Construct Screaming Bell"
#descr "Unlike other Skaven constructs the Screaming Bell is not produced by Clan Skyre and requires the Warlocks only when forging the huge bell itself. The work of blessing this huge construction, inscribing it with forbidden lore etched in warpstone and channeling into the bell the maddening power of the Horned Rat Himself is a duty for the Grey Seer fortunate and powerful enough to stand atop it. The Screaming Bell grants the Grey Seer additional powers, marks him with the favour of the Horned Rat and spreads his dominion far and wide. In battle the peals of the Screaming Bell inspire rabid ferocity amongst all Skaven and severely dishearten their foes." 
#school 3
#restricted 73
#researchlevel 8
#path 0 4
#path 1 5
#pathlevel 0 3
#pathlevel 1 2
#effect 10021
#fatiguecost 3300
#damage 2171
#nreff 1
#end



---- Favour of Nurglitch

#newspell
#copyspell "resist poison"
#name "Favour of Nurglitch"
#descr "Crumbling corrupted warpstone in his fist, the caster hisses some words from a forgotten tongue and motions the dust over his troops, granting them the favour of Nurglitch, Lord of Decay. They are given total immunity to all poisons."
#restricted 73
#researchlevel 3
#school 4
#path 0 5
#path 1 8
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 100
#range 13
#aoe 45
#spec 4194304
#end



---- Death Frenzy

#newspell
#copyspell "berserkers"
#name "Death Frenzy"
#descr "The caster consumes a piece of raw warpstone, then turns to his troops, squeaks a single dread command in a forgotten tongue and then points a gnarled claw toward the enemy. The troops are filled with ancient ferocity and begin foaming at the mouth as they charge toward their hated foes."
#restricted 73
#researchlevel 4
#school 4
#path 0 5
#path 1 8
#pathlevel 0 2
#pathlevel 1 2
#fatiguecost 100
#range 13
#aoe 45
#spec 4194304
#end


---- Pestilent Breath

#newspell
#copyspell "breath of the dragon"
#name "Pestilent Breath"
#descr "The caster opens his mouth and releases a stream of foul gas, bile and corruption. The stronger the mage, the more powerful the stream of filth will be."
#restricted 73
#researchlevel 2
#aoe 1003
#range 20
#precision 1
#path 0 5
#path 1 8
#pathlevel 0 1
#pathlevel 1 1
#end




---- Crappy Warp Lightning

#newspell
#copyspell "Lightning Bolt"
#name "Minor Warp Lightning"
#descr "The Warlocks of Clan Skryre have developed a way to unleash the power of warpstone in a crackling blast of lightning which arcs into the sky and rains down upon enemy troops below. As with much of Skryre's technology, warplightning is unpredictable and inaccurate, almost as likely to kill the Skaven troops as their foes. Unlike the stronger warplightning spell, this requires no warpstone to use." 
#restricted 73
#researchlevel 1
#nreff 2
#precision -3
#path 0 3
#pathlevel 0 1
#range 18
#end


---- Warp Lightning

#newspell
#copyspell "Lightning Bolt"
#name "Warp Lightning"
#descr "The Warlocks of Clan Skryre have developed a way to unleash the power of warpstone in a crackling blast of lightning which arcs into the sky and rains down upon enemy troops below. As with much of Skryre's technology, warplightning is unpredictable and inaccurate, almost as likely to kill the Skaven troops as their foes. By using warpstone, even lowly Warlocks can cast this powerful spell, but those lacking the expertise and advanced technology of the Engineers will be left drained. Additionally, more powerful and better equipped Warlock Engineers will be able to channel further power into the spell with their warp coils, blades and condensers." 
#restricted 73
#researchlevel 2
#nreff 1009
#precision -3
#path 0 3
#path 1 0
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 100
#range 22
#end



-------- New sites

#newsite 994
#name "Pillars of Skavenblight"


#path 8
#level 0


#rarity 5

#gems 5 1
#gems 4 1
#homecom 2168
#end



#newsite 995
#name "Council Chambers"


#path 3
#level 0


#rarity 5
#homemon 2148
#end



#newsite 996
#name "Skavenblight"
#path -1
#level 0


#rarity 5

#gems 0 1
#gems 3 2
#end





-------- NEW NAMETYPE

#selectnametype 148
#clear
#addname "Krittisk"
#addname "Ikkit"
#addname "Scab"
#addname "Morskit"
#addname "Bog"
#addname "Snikch"
#addname "Queek"
#addname "Keelik"
#addname "Eekit"
#addname "Scrattisk"
#addname "Miskscab"
#addname "Muskit"
#addname "Ferrit"
#addname "Rattus"
#addname "Gnawdwell"
#addname "Ratskit"
#addname "Raditt"
#addname "Quetch"
#addname "Thanquol"
#addname "Quolisk"
#addname "Pragitt"
#addname "Tchisk"
#addname "Gnawbones"
#addname "Throt"
#addname "Thrask"
#addname "Thraquost"
#addname "Clawdoom"
#addname "Verminsk"
#addname "Longtooth"
#addname "Scrabisk"
#addname "Skrolk"
#addname "Trolsk"
#addname "Skitolk"
#addname "Skritter"
#addname "Scrathosk"
#addname "Cheenisk"
#addname "Deathsqueak"
#addname "Eyeclaws"
#addname "Ratskrat"
#addname "Yellowteeth"
#addname "Redclaws"
#addname "Corpsefinder"
#addname "Pestilisk"
#addname "Kraggit"
#addname "Snaffit"
#addname "Turlisk"
#addname "Thanskat"
#addname "Manbiter"
#addname "Nighteyes"
#addname "Gutterclaws"
#addname "Ripthroat"
#addname "Old Quask"
#addname "Vile Throsk"
#addname "Scurrydoom"
#addname "Dreggit"
#addname "Bogtooth"
#addname "Farchesk"
#addname "Mriska"
#addname "Rat Thing"
#addname "Tunnel King"
#addname "Blighted Thosk"
#addname "Blacktooth"
#addname "Chitterfang"
#addname "Longfur"
#addname "Cankertooth"
#addname "Brassik"
#addname "Madbite"
#end


-------- New nations



#selectnation 73
#clearnation
#clearsites
#name "Skaven"
#epithet "Warhammer Army"
#era 2
#brief "Skaven are evil ratmen who have tunneled under much of the old world."
#descr "The Skaven are a race of malevolent rat-men that inhabit the underground of the Warhammer world. The tunnels of their vast under-empire reach from the steaming jungles of the South Lands to the snow-covered steppes of Kislev, from the Western borders of Estalia and Bretonnia to the lost realms of the Far East. Their capital is the myseterious city of Skavenblight, hidden in the centre of the foul marches lying on the western borders of Tilea. There the mighty Lords of Decay, ruthless rulers of all Skaven, sit in the Council of Thirteen, scheming and planning in preparation for the time when their armies will emerge from their subterranean realm to raze the entire surface world and rule over its ruins. This is the ultimate ambition of the Skaven race, a destiny which is preaced by the Grey Seers, who are powerful wizards and prophets of the Horned Rat - the malevolent Skaven deity."
#summary "Race: Skaven, Rats, Rat-Ogres. Military: Massed infantry, experimental weapons, deadly hybrids and swarms of rats. Magic: Varied, includes Death, Astral, Fire, Earth and Blood. Priests: Strong."
#flag "./Skaven/flag.tga"
#templepic 8
#startsite "Skavenblight"
#startsite "Pillars of Skavenblight"
#startsite "Council Chambers"
#sacrificedom


--Sets what forts they will use.

#startfort 15
#defaultfort 3

#mountainfort 30
#swampfort 5
#forestfort 33




------- Add soldiers

#addrecunit 2151 -- Skavenslave Group (3 members)
#addrecunit 2141 -- Clanrat Spear
#addrecunit 2140 -- Clanrat Sword
#addrecunit 2143 -- Stormvermin
#addrecunit 2146 -- Pestilens Plague Monk
#addrecunit 2147 -- Pestilens Censer Bearer
#addrecunit 2144 -- Eshin Night Runner
#addrecunit 2145 -- Eshin Gutter Runner
--addrecunit 2150 -- Skryre Globadier
--addrecunit 2154 -- Skryre Warpfire Thrower
--addrecunit 2149 -- Giant Rat
--addrecunit 2153 -- Rat Ogre
--addrecunit 2156 -- Pestilens Plague Rat
--addrecunit 2157 -- Warplightning Thrower
--addrecunit 2158 -- Skryre Doomwheel




------- Add leaders

#addreccom 2160 -- Chieftan
#addreccom 2161 -- Warlord
#addreccom 2162 -- Moulder Packmaster
#addreccom 2163 -- Eshin Assassin
#addreccom 2164 -- Pestilens Plague Chantor
#addreccom 2165 -- Pestilens Plague Priest
#addreccom 2166 -- Skryre Warlock
#addreccom 2167 -- Skryre Warlock Engineer
--addreccom 2168 -- Grey Seer
#addreccom 2169 -- Master Moulder
--addreccom 2171 -- Screaming Bell
--addreccom 2172 -- Warlord Queek
--addreccom 2174 -- Deathmaster Snikch
--addreccom 2175 -- Plaguelord Skrolk
--addreccom 2176 -- Thanquol
--addreccom 2178 -- Chief Warlock Ikit Claw



------- Province Defence

--Sets the units to be used in province defense.

#defcom1 2160
#defcom2 2162
#defunit1 2140

#defunit1b 2151
#defunit2 2149
#defunit2b 2141


--Sets how many of the units to appear per point.

#defmult1 12
#defmult1b 10

#defmult2 10
#defmult2b 10


------- Hero Settings

#hero1 2172
#hero2 2174
#hero3 2175
#hero4 2176
#hero5 2178
#multihero1 2171

#idealcold 0
#color 0.5 0.4 0.2


#startcom 2160
#startunittype1 2141
#startunitnbrs1 13
#startunittype2 2140
#startunitnbrs2 13
#startscout 2162
#end

-- ARGA DIS --

--nationslot 78
--weaponslots 646
--armourslots 322
--unitslots 2320-2330, 2354-2374
--siteslots 790, 791, 792



-------- WEAPONS --------


-- Shield Bash

#newweapon 646
#name "Shield Bash"
#rcost 0
#bonus
#att -2
#len 0
#dmg -2
#end


-------- ARMOUR ---------


-- Hoplite Shield

#newarmor 322
#name "Hoplite Shield"
#type 4
#prot 17
#enc 2
#def 4
#rcost 9
#end


-------- UNITS ----------


-- Helgrot chaff

#newmonster 2331
#copyspr 201
#copystats 201
#name "Helgrot"
#descr "The Helgrot are a slave caste who take care of the day to day running of Arga. Any Helgrot with a spark of strength or rebellion in his eyes is given a choice; go into battle and die to facilitate the glory of true Argan warriors, or be fed to the Mares, or worse, the Gilgans."
#mor 8
#str 9
#att 9
#prec 9
#hp 8
#gcost 8
#nametype 107
#end


-- ARGANS

-- Argan Hoplite - Template unit

#newmonster 2321
#spr1 "./Arga Dis/Argan Hoplite.tga"
#spr2 "./Arga Dis/Argan Hoplite2.tga"
#name "Argan Hoplite"
#descr "Raised from birth to fight with shield and spear, to know glory, to taste the blood and hear the clamour of battle; the hoplites of Arga are virtually without equal in combat. All Argan warriors are extremely well trained, disciplined and brave. Furthermore, their unique style of fighting makes them almost as dangerous with their shields as with their spears."
#hp 11
#size 2
#prot 0
#mor 14
#mr 10
#enc 3
#str 12
#att 12
#def 12
#prec 10
#mapmove 2
#ap 10
#gcost 15
#rcost 1
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Spear"
#weapon "Shield Bash"
#nametype 107
#end

-- Argan Myrmidon

#newmonster 2322
#name "Argan Myrmidon"
#spr1 "./Arga Dis/Argan Myrmidon.tga"
#spr2 "./Arga Dis/Argan Myrmidon2.tga"
#descr "The Myrmidons of Arga, nicknamed the blackshields, are a band of fighters who live largely seperate lives from the hoplites and Sworn, favouring the upper reaches of mountains. They are not so heavily armoured as their counterpats in Arcoscephale, but they are still regarded with distrust by other Argan warriors who tend to view such armour as a form of cowardice or sign of weakness. Nonetheless the Blackshields have decided many battles where their protection was decisive and their training at high altitude certainly lends them impressive endurance. They will never have quite the glory or honour of the hoplites, but none can deny they have proven themselves true Argan warriors."
#hp 11
#size 2
#prot 0
#mor 14
#mr 10
#enc 2
#str 12
#att 12
#def 12
#prec 10
#mapmove 2
#ap 12
#gcost 14
#rcost 2
#armor "Bronze Cuirass"
#armor "Hoplite Helmet"
#armor "Shield"
#weapon "Short sword"
#mountainsurvival
#nametype 107
#end

-- Sworn Brother

#newmonster 2323
#spr1 "./Arga Dis/Sworn Brother.tga"
#spr2 "./Arga Dis/Sworn Brother2.tga"
#name "Sworn Brother"
#descr "The Sworn epitomise Argan principles; they are tireless, ruthless, disciplined and possessing of almost inhuman strength. On initiation into this elite band they each swore a battle-oath to the Gilgans and to Arga and saw clearly for the first time the brutal truth of the afterlife, the chaos of Dis. Knowing the endless violent struggle that awaits them beyond the grave the Sworn are driven to prove themselves in life and, when they inevitably fulfill their destiny and die a glorious death, to take as many enemies to Dis with them as possible. This dedication to slaughter makes them extremely hard to stop completely on the battlefield; it is common for Sworn Brothers to fight on after receiving mortal wounds, only to drop dead once the enemy is put to the spear."
#hp 13
#size 2
#prot 0
#mor 16
#mr 11
#enc 3
#str 13
#att 14
#def 13
#prec 11
#mapmove 2
#ap 10
#gcost 26
#rcost 4
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Spear"
#weapon "Shield Bash"
#secondtmpshape 2324
#nametype 107
#end

-- Sworn Brother Slain

#newmonster 2324
#name "Sworn Brother Slain"
#spr1 "./Arga Dis/Sworn Brother Slain.tga"
#spr2 "./Arga Dis/Sworn Brother Slain2.tga"
#descr "It takes a lot to kill an Argan who has seen what awaits him in the afterlife. A sworn brother who has been mortally wounded will fight on until he is well and truly dead, seeking any glory he can before facing the violent turmoil of Dis."
#berserk 5
#hp 11
#size 2
#prot 0
#mor 16
#mr 11
#enc 3
#str 13
#att 14
#def 13
#prec 11
#mapmove 2
#ap 10
#gcost 1
#rcost 1
#armor "leather cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#armor "Hoplite Shield"
#weapon "Spear"
#weapon "Shield Bash"
#nametype 107
#end

-- Sworn Companion

#newmonster 2325
#name "Sworn Companion"
#spr1 "./Arga Dis/Sworn Companion.tga"
#spr2 "./Arga Dis/Sworn Companion2.tga"
#descr "The Sworn Companions are not decided by their relation to nobility, but by their ability to control the volatile maneating mares of Dis; semi-wild horses tainted over the centuries by proximity to the imprisoned Gilgans. Having survived Argan childhood and reached age enough to become Sworn, the glory found in conquering a mare of Dis is tempting indeed. Thousands of promising Argans die attempting such a task, torn to pieces by their savage mounts, but those that survive are a devastating and terrifying force on the battlefield. Like the Sworn brothers they are known to fight on with wounds that would drop a normal human."
#secondtmpshape 2326
#hp 13
#size 3
#ressize 2
#prot 0
#mor 16
#mr 11
#enc 5
#str 13
#att 14
#def 13
#prec 11
#mapmove 3
#ap 24
#mounted
#gcost 95
#rcost 14
#weapon "light lance"
#weapon "bite"
#weapon "hoof"
#armor "shield"
#armor "hoplite helmet"
#armor "leather cuirass"
#nametype 107
#fear 0
#end


-- Sworn Companion Slain

#newmonster 2326
#name "Sworn Companion Slain"
#spr1 "./Arga Dis/Sworn Companion Slain.tga"
#spr2 "./Arga Dis/Sworn Companion Slain2.tga"
#descr "Much like the Sworn Brothers, the Sworn Companions are famed for fighting on despite fatal wounds, seeking to earn as much glory as possible before departing for Dis."
#hp 11
#size 3
#ressize 2
#prot 0
#mor 16
#mr 11
#enc 5
#str 13
#att 14
#def 13
#prec 11
#mapmove 3
#ap 24
#mounted
#gcost 1
#rcost 1
#weapon "light lance"
#weapon "bite"
#weapon "hoof"
#armor "shield"
#armor "hoplite helmet"
#armor "leather cuirass"
#berserk 5
#nametype 107
#fear 0
#end


-- Orphan

#newmonster 2327
#spr1 "./Arga Dis/Orphan.tga"
#spr2 "./Arga Dis/Orphan2.tga"
#name "Orphan"
#descr "When an Argan boy reaches the age of six he is evaluated by the elders, veterans of countless battles who, for whatever reason, are not destined for glorious death. The majority of children pass muster and begin their training but those that are in some way deficient are severed from their family and given to the Gilgans. Those that are mentally unfit to become soldiers of Arga are raised by the Gilgans as fanatic killers full of rage and bloodlust. They fight with a pair of vicious bronze claws and seem to know no pain or fear, though they lack the discipline and training of true Argans."
#berserk 4
#hp 16
#size 2
#prot 3
#mor 18
#mr 10
#enc 3
#str 12
#att 11
#def 11
#prec 9
#mapmove 2
#ap 10
#gcost 13
#rcost 3
#weapon "claw"
#weapon "claw"
#ambidextrous 2
#ap 12
#mapmove 2
#nametype 107
#end 

-- Oathsworn

#newmonster 2328
#spr1 "./Arga Dis/Oathsworn.tga"
#spr2 "./Arga Dis/Oathsworn2.tga"
#name "Oathsworn"
#descr "The Oathsworn are direct descendants of the Argans who first swore the oath, released the Gilgans and spared Arga, only to leave her cursed and overpowered by the brutal Gilgans. They are paradoxical figures in Argan society, being both sacred and shunned by law; only other members of the Oathsworn families may speak with them, or even acknowledge their presence. Unlike the Sworn, who are driven to frenzied violence by a fleeting vision of the afterlife, the Oathsworn are plagued by constant nightmarish apparitions. In battle they are as well trained and deadly as any Argan hoplite, but they are unable to accept their fate and fear death in a way no other Argan can understand. They use longer spears similar to those of the Achilleans."
#holy
#gcost 22
#hp 11
#size 2
#prot 0
#mor 9
#mr 10
#enc 3
#str 12
#att 12
#def 12
#prec 10
#mapmove 2
#ap 10
#rcost 4
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "long Spear"
#weapon "Shield Bash"
#nametype 107
#end


-- Red Achillean

#newmonster 2329
#spr1 "./Arga Dis/Red Achillan.tga"
#spr2 "./Arga Dis/Red Achillan2.tga"
#name "Red Achillean"
#descr "The battleguard of the Gilgans, the Red Achilleans are drenched in blood from the Gilgan's sacrifical wells. This blood is imbued with dark protective power and can deflect almost any blow as though the skin of the warriors were made of iron. The Achillans are notoriously emotionless and focused; they lack the psychotic will to survive and cause mayhem possessed by the Sworn, but they are elite soldiers nonetheless. The key drawback of their 'armour' is that it acts as a conductor for magical energy, leaving the Achillans vulnerable to enemy spellcasters. They are still armed with the traditional combination of shield and spear, but have no use for the heavy hoplite helm. The need for large cauldrons of blood in which to immerse themselves has resulted in the Achilleans being unable to match the marching speed of the regular army on more than one occasion. Like their masters, they boast frightening appetites."
#hp 11
#size 2
#prot 15
#mor 15
#mr 7
#enc 3
#str 12
#att 13
#def 13
#prec 10
#mapmove 1
#ap 10
#gcost 30
#rcost 9
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#weapon "Long Spear"
#weapon "Shield Bash"
#supplybonus -1
#nametype 107
#end



-- Blackwing Rider

#newmonster 2330
#name "Blackwing Rider"
#spr1 "./Arga Dis/Blackwing.tga"
#spr2 "./Arga Dis/Blackwing2.tga"
#descr "The Blackwing are a group of Argan warriors who have allied with the Black Pegasi, creatures descended from the noble steeds of the Arcoscephalean Golden Age. Black Pegasi inhabit the Ash Cliffs of Arga high above the Charnel Cell and unlike the Mares of Dis have suffered little corruption from the imprisoned Gilgans. As such they are far less fearsome creatures, though still a match for any warhorse. The Blackwing were formerly an autonomous unit which roamed the borders of Arga, becoming influenced by other cultures and even adopting use of foreign weapons such as the glaive. Long seen as a distraction from proper Argan methods of warfare they have recently been reined in and assigned to support infantry formations; as such there are no longer any Blackwing Captains."
#hp 11
#size 4
#ressize 2
#prot 0
#mor 14
#mr 11
#enc 5
#str 12
#att 12
#def 12
#prec 10
#mapmove 3
#ap 22
#flying
#mounted
#gcost 70
#rcost 12
#weapon "glaive"
#weapon "hoof"
#armor "shield"
#armor "hoplite helmet"
#armor "leather cuirass"
#nametype 107
#end




------- COMMANDERS


-- Helgrot Scout

#newmonster 2354
#copyspr 201
#copystats 201
#name "Helgrot Scout"
#descr "The Helgrot are a slave caste who take care of the day to day running of Arga. Any Helgrot with a spark of strength or rebellion in his eyes is given a choice; go into battle and die to facilitate the glory of true Argan warriors, or be fed to the Mares, or worse, the Gilgans. Sometimes a particularly cowardly and sneaky Helgrot will be employed as a scout, a profession far below that of a real warrior."
#mor 7
#str 9
#att 9
#prec 9
#hp 8
#gcost 20
#nametype 107
#stealthy 0
#end 


-- Argan Captain

#newmonster 2355
#spr1 "./Arga Dis/Argan Captain.tga"
#spr2 "./Arga Dis/Argan Captain2.tga"
#name "Argan Captain"
#descr "Captains of Arga can match any of their men in single combat and their rallying cries inspire great loyalty amongst the hoplites. They are armed identically to their soldiers."
#hp 12
#size 2
#prot 0
#mor 15
#mr 10
#enc 3
#str 12
#att 13
#def 13
#prec 11
#mapmove 2
#ap 12
#gcost 50
#rcost 4
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Spear"
#weapon "Shield Bash"
#goodleader
#nomagicleader
#noundeadleader
#standard 5
#nametype 107
#end

-- Sworn Captain

#newmonster 2356
#spr1 "./Arga Dis/Sworn Captain.tga"
#spr2 "./Arga Dis/Sworn Captain2.tga"
#name "Sworn Captain"
#descr "The Sworn epitomise Argan principles; they are tireless, ruthless, disciplined and possessing of almost inhuman strength. On initiation into this elite band they each swore a battle-oath to the Gilgans and to Arga and saw clearly for the first time the brutal truth of the afterlife, the chaos of Dis. Knowing the endless violent struggle that awaits them beyond the grave the Sworn are driven to prove themselves in life and, when they inevitably fulfill their destiny and die a glorious death, to take as many enemies to Dis with them as possible. Captains of the Sworn are the greatest warriors in each brotherhood and like the warriors under their command will fight on past the point where a normal man would fall and die."
#hp 14
#size 2
#prot 0
#mor 18
#mr 11
#enc 3
#str 14
#att 15
#def 14
#prec 12
#mapmove 2
#ap 12
#gcost 80
#rcost 6
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "short sword"
#weapon "Shield Bash"
#expertleader
#nomagicleader
#noundeadleader
#standard 10
#secondtmpshape 2357
#nametype 107
#end


-- Sworn Captain Slain

#newmonster 2357
#spr1 "./Arga Dis/Sworn Captain Slain.tga"
#spr2 "./Arga Dis/Sworn Captain Slain2.tga"
#name "Sworn Captain Slain"
#descr "A Sworn Captain who has been mortally wounded."
#hp 13
#size 2
#prot 0
#mor 18
#mr 11
#enc 3
#str 14
#att 15
#def 14
#prec 12
#mapmove 2
#ap 12
#gcost 1
#rcost 1
#armor "hoplite shield"
#armor "hoplite helmet"
#armor "leather cuirass"
#weapon "short sword"
#weapon "Shield Bash"
#expertleader
#nomagicleader
#noundeadleader
#standard 4
#berserk 6
#nametype 107
#end

-- Sworn Companion Captain

#newmonster 2358
#spr1 "./Arga Dis/Sworn Companion Captain.tga"
#spr2 "./Arga Dis/Sworn Companion Captain2.tga"
#name "Sworn Captain"
#descr "The Sworn Companions are not decided by their relation to nobility, but by their ability to control the volatile maneating mares of Dis; semi-wild horses tainted over the centuries by proximity to the imprisoned Gilgans. Having survived Argan childhood and reached age enough to become Sworn, the glory found in conquering a mare of Dis is tempting indeed. Thousands of promising Argans die attempting such a task, torn to pieces by their savage mounts, but those that survive are a devastating and terrifying force on the battlefield. The Captains of the Companions are every bit as dangerous as the men under their command and as Sworn men will fight on despite mortal wounds."
#hp 14
#size 3
#ressize 2
#prot 0
#mor 18
#mr 11
#enc 3
#str 14
#att 15
#def 14
#prec 12
#mapmove 2
#ap 24
#gcost 135
#rcost 17
#weapon "bite"
#weapon "hoof"
#armor "Leather Cuirass"
#armor "Shield"
#armor "Hoplite Helmet"
#weapon "short sword"
#mounted
#expertleader
#nomagicleader
#noundeadleader
#standard 10
#secondtmpshape 2359
#nametype 107
#fear 0
#end

-- Sworn Companion Captain Slain

#newmonster 2359
#spr1 "./Arga Dis/Sworn Companion Captain.tga"
#spr2 "./Arga Dis/Sworn Companion Captain2.tga"
#name "Sworn Captain Slain"
#descr "A Sworn Captain who has been mortally wounded and is hellbent on taking as many foes to Dis with him as possible."
#size 3
#ressize 2
#hp 13
#prot 0
#mor 18
#mr 11
#enc 3
#str 14
#att 15
#def 14
#prec 12
#mapmove 2
#ap 24
#gcost 1
#rcost 1
#weapon "bite"
#weapon "hoof"
#armor "Leather Cuirass"
#armor "Shield"
#armor "Hoplite Helmet"
#weapon "short sword"
#mounted
#expertleader
#nomagicleader
#noundeadleader
#standard 4
#berserk 6
#nametype 107
#fear 0
#end


-- Argan Myrmidon Captain

#newmonster 2360
#spr1 "./Arga Dis/Argan Myrmidon Captain.tga"
#spr2 "./Arga Dis/Argan Myrmidon Captain2.tga"
#name "Argan Captain"
#descr "Myrmidon Captains of Arga can match any of their men in single combat and their rallying cries inspire great loyalty amongst the myrmidons. They are armed identically to their soldiers."
#hp 12
#size 2
#prot 0
#mor 15
#mr 10
#enc 3
#str 12
#att 13
#def 13
#prec 11
#mapmove 2
#ap 12
#gcost 50
#rcost 5
#goodleader
#nomagicleader
#noundeadleader
#standard 5
#armor "Bronze Cuirass"
#armor "Hoplite Helmet"
#armor "Shield"
#weapon "Short sword"
#mountainsurvival
#nametype 107
#end


-- Haimgrot

#newmonster 2361
#copyspr 1640
#name "Haimgrot"
#descr "The Haimgrot are hated servants of the Gilgans whose sole purpose is to collect suitable blood sacrifices and assist in grisly minor rituals. Their ability to track down those with the necessary type of blood is legendary. They are physically weak, cowardly and entirely unfit to lead others into battle."
#hp 9
#size 2
#prot 0
#mor 8
#mr 10
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 2
#ap 12
#gcost 80
#douse 1
#magicskill 7 1
#rcost 1
#noleader
#weapon "dagger"
#nametype 107
#end

-- Gilgan

#newmonster 2362
#spr1 "./Arga Dis/Gilgan.tga"
#spr2 "./Arga Dis/Gilgan2.tga"
#name "Gilgan"
#descr "The Gilgans were a powerful race of mortal blood giants who were imprisoned by a Pretender God of great power countless centuries ago. The city state of Arga was initially established to guard the obliette in which the ageless Gilgans were trapped, but with the swearing of The Oath the blood giants were released and have become, in effect, rulers of all Arga. They are not so powerful as they once were, but are still a match for almost any creature that walks the land. If anything their imprisonment has only increased their appetite for blood, flesh and slaughter. The Gilgans have established themselves as the right hand of the awakening god and act as the head of what passes for religion in Arga."
#hp 54
#prot 6
#mor 16
#mr 16
#enc 4
#str 22
#att 12
#def 11
#prec 10
#ap 14
#goodleader
#magicskill 7 3
#magicskill 8 2
#holy
#fear 1
#size 4
#weapon "flail"
#armor "bronze scale cuirass"
#armor "crown"
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 10
#neednoteat
#supplybonus -8
#rcost 4
#gcost 420
#berserk 6
#maxage 2600
#startage 1370
#nametype 101
#end

-- Misborn

#newmonster 2363
#spr1 "./Arga Dis/Misborn.tga"
#spr2 "./Arga Dis/Misborn2.tga"
#name "Misborn"
#descr "The Misborn are rare Argan children who, being physically deformed and unfit for duty as true Argans, are granted to the Gilgans. Little do the Argans know that such deformities are a result of proximity to the Charnel Cell of the blood giants. These cursed Misborn children are twisted by their masters into creatures that are no longer human; they serve their masters with unwavering loyalty and are granted magical power which varies depending on the extent of their corruption."
#hp 14
#prot 2
#mor 14
#mr 11
#enc 3
#str 12
#att 9
#def 8
#prec 9
#ap 14
#poorleader
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 10
#custommagic 21632 10
#holy
#size 2
#weapon "claws"
#stealthy 0
#rcost 1
#gcost 130
#maxage 65
#startage 40
#nametype 107
#end



---- HEROES

---- HEROES


-- Gilgan Executioner Hero

#newmonster 2364
#spr1 "./Arga Dis/Hero Executioner.tga"
#spr2 "./Arga Dis/Hero Executioner2.tga"
#name "Executioner"
#descr "The Executioner is a powerful Gilgan who took it upon himself to cleanse his kind of any trace of weakness. When the Gilgans were first imprisoned, they despaired, for they had never before tasted defeat in any form. They raged and howled and cursed in vain, unable to escape captivity. In the midst of this chaos the Executioner stood, disgusted at such weakness. He took up a great bronze axe and, without a word, lopped the head off the nearest, most out-of-control Blood Giant. Then he struck another down, then another, until all was silent. "We wait", he boomed. Our fury is not to be spent in the darkness. The time for our rage will come, when we are free. The Executioner has taken to wearing a winged bronze helm, representing the sudden coming of fury and revenge. His power is great indeed and his wrath even greater."
#hp 68
#prot 7
#mor 20
#mr 15
#enc 4
#str 26
#att 13
#def 12
#prec 11
#ap 14
#expertleader
#magicskill 7 3
#magicskill 8 2
#holy
#fear 3
#size 4
#weapon "battleaxe"
#armor "bronze scale hauberk"
#armor "full helmet"
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 100
#custommagic 21632 100
#neednoteat
#supplybonus -12
#rcost 1
#gcost 1
#berserk 12
#maxage 4000
#startage 2310
#nametype 101
#itemslots 31878
#end


-- Blind Myrmite

#newmonster 2365
#spr1 "./Arga Dis/Hero Myrmite.tga"
#spr2 "./Arga Dis/Hero Myrmite2.tga"
#name "Blind Myrmite"
#descr "When a rampaging gorgon took control of an ancient temple of Arga, a bizarre wandering fighter who combined the fighting techniques of the Hoplites and the Myrmidons stepped forward, seeking the reward of a position in the Argan military. The Gilgans emerged to examine this hero and finding him up to the task, offered him an 'advantage'. He accepted and in moments his eyes were burned from his skull in exchange for a ancient vision beyond the real. Thus he was immune to the deadly gaze of the creature and was able to slay it. His 'advantage' does not end there; if any man or beast tries to strike him, they suffer the same fate, their eyes blasted from their heads. He is now a greatly feared commander in the Argan forces."
#hp 17
#size 2
#prot 0
#mor 18
#mr 12
#enc 3
#str 13
#att 14
#def 15
#prec 9
#mapmove 2
#ap 12
#gcost 1
#rcost 4
#eyeloss
#armor "Bronze Cuirass"
#armor "Hoplite Shield"
#armor "Hoplite Helmet"
#weapon "Long Spear"
#weapon "Shield Bash"
#blind
#expertleader
#nomagicleader
#noundeadleader
#nametype 107
#itemslots 31878
#end

-- Immortal King

#newmonster 2366
#spr1 "./Arga Dis/Hero King.tga"
#spr2 "./Arga Dis/Hero King2.tga"
#name "Immortal King"
#descr "The King of all Arga is a warrior to rival the best in the nation and over the years has proven himself entirely unkillable. Should he be struck down in battle his body will simply soak like blood into the earth and mere hours later will run through channels carved into his throne, slowly forming back into the form of the ruler. None can say exactly how this is so, or even whether the King is truly a man, but it has been this way since any can recall. Despite his clear ties with the Gilgans he clashes with them often over matters of state and has time and time again demonstrated that he is as fearless a ruler as a warrior. In battle he favours the equipment of the Sworn Captains, but wears his crown in place of a helmet and hefts a larger sword without any loss of speed or skill."
#hp 24
#size 2
#prot 3
#mor 20
#mr 12
#enc 2
#str 16
#att 15
#def 15
#prec 12
#mapmove 2
#ap 12
#gcost 1
#rcost 6
#immortal
#regeneration 30
#armor "Leather Cuirass"
#armor "Hoplite Shield"
#armor "Crown"
#weapon "broad sword"
#weapon "Shield Bash"
#superiorleader
#okmagicleader
#okundeadleader
#standard 15
#nametype 107
#itemslots 31878
#end


----------- PRETENDER and copies

#newmonster 2367
#spr1 "./Arga Dis/Blood Wind.tga"
#spr2 "./Arga Dis/Blood Wind2.tga"
#name "Blood Wind"
#descr "The Blood Wind is a swirling tempest of rage and hatred born from the collective wrath of the imprisoned Gilgans. In battle it is more than capable of sucking both air and blood from the bodies of its foes and can tear through ranks of soldiers as a maelstrom of destruction."
#hp 40
#size 6
#prot 0
#mor 30
#mr 18
#enc 0
#str 15
#att 16
#def 16
#prec 10
#blind
#trample
#shockres 100
#poisonres 100
#mapmove 3
#ap 30
#gcost 50
#rcost 1
#neednoteat
#lifeless
#flying
#ethereal
#weapon "Lightning Swarm"
#okleader
#poormagicleader
#poorundeadleader
#itemslots 12288
#maxage 8463
#startdom 3
#pathcost 60
#magicskill 7 1
#magicskill 1 1
#restrictedgod 78
#end

----------- cOPIES


--------------------------------------




-------- SPELLS ----------

-------- SITES -----------

#newsite 790

#name "The Charnel Cell"


#path 7
#level 0


#rarity 5
#gems 7 2
#gems 3 1
#gems 0 1
#homecom 2362 -- Gilgan
#end



#newsite 791
#name "Stable of Dis"


#path 5
#gems 5 1
#level 0


#rarity 5

#homecom 2358 -- Sworn Companion Captain
#homemon 2325 -- Sworn Companion
#end


#newsite 792
#name "Cliffs of Ash"
#path 1
#level 0
#rarity 5
#homemon 2330 -- Blackwing Rider
#end


-------- NAMEPOOLS -------


-------- NATIONS ---------

#selectnation 78
#clear
#name "Arga Dis"
#epithet "Blood and Bronze"
#era 2
#idealcold 0
#brief "Arga Dis is a brutal warrior nation which on the brink of annihilation swore an oath to a race of terrible blood giants and ever since has effectively served them."
#descr "A society which venerates war and bloodshed. Their city nation watched over the imprisoned Gilgan blood giants. Following a terrible war it seemed Arga would be razed and forgotten, a terrible fate for a once glorious nation. In their darkest hour the Argans turned to the blood giants and swore an oath in exchange for power that would allow them to save their city and slay their foes. The Gilgan's were freed and not only fought the enemies of Arga but gave a 'gift' to those who swore loyalty to them. This gift was a glimpse of the afterlife, of Dis, a terrible place of brutal conflict where the strong reigned. The newly sworn Argans turned to their foes as changed men and fought like devils, finally defeating them and saving their city. Now Arga is a changed city, more brutal and violent than ever, more focused on slaughter and glory. It is effectively ruled by the Gilgans and with the coming of God they have turned their attentions to the surrounding lands."
#summary "Race: Humans, Misborn and Blood Giants.
Military: Superb medium and heavy infantry, fearsome cavalry, crazed berserkers, slave chaff and flying support.
Magic: Blood, some death, fire and earth.
Priests: Average, can blood sacrifice but not preach."
#flag "./Arga Dis/flag.tga"
#templepic 6
#sacrificedom
#nopreach
#color 0.9 0.5 0.1


---- RECRUITS

#addrecunit 2331 -- Helgrot Chaff
#addrecunit 2321 -- Argan Hoplite
#addrecunit 2322 -- Argan Myrmidon
#addrecunit 2327 -- Sworn Orphan
#addrecunit 2323 -- Sworn Brother
#addrecunit 2329 -- Red Achillan
#addrecunit 2328 -- Oathsworn

---- LEADERS

#addreccom 2354 -- Helgrot Scout
#addreccom 2355 -- Argan Captain
#addreccom 2360 -- Myrmidon Captain
#addreccom 2356 -- Sworn Captain
#addreccom 2361 -- Haimgrot
#addreccom 2363 -- Misborn
--addreccom 2364 -- Gilgan hero
--addreccom 2365 -- Blind hero
--addreccom 2366 -- Immortal King



----- HEROES

#hero1 2364 -- Gilgan Executioner
#hero2 2365 -- Blind Myrmite
#hero3 2366 -- Immortal King

----- STARTSITES

#startsite "Stable of Dis"
#startsite "The Charnel Cell"
#startsite "Cliffs of Ash"

----- FORTS

#startfort 3
#swampfort 11
#farmfort 3
#forestfort 33
#mountainfort 36
#defaultfort 39


------- PROVINCE DEFENCE

--Sets the units to be used in province defense.

#defcom1 2355

#defcom2 2360

#defunit1 2331

#defunit1b 2321
#defunit2 2322


--Sets how many of the units to appear per 10 points.

#defmult1 12
#defmult1b 8
#defmult2 8



------- STARTING UNITS

#startcom 2355
#startscout 2363
#startunittype1 2321
#startunitnbrs1 8
#startunittype2 2322
#startunitnbrs2 8
#end



-- ULM REBORN --

------ The mod uses these new id slots

--Nation 77

--Weapons 690-3

--Armour 321

--Monsters 2978-2983 + 2300-2320

--Sites 990-3




-------- New Weapons

-- Sternhammer

#newweapon 690
#name "Sternhammer"
#twohanded
#magic
#dmg 7
#att 1
#def 0
#len 3
#sound 11
#rcost 10
#secondaryeffect 232
#end

-- White Hammer

#newweapon 691
#name "White Hammer"
#dt_holy
#magic
#armorpiercing
#dmg 9
#att 2
#def 1
#len 2
#sound 11
#rcost 10
#end


-- Spirit Hammers

#newweapon 692
#name "Spirit Hammers"
#ammo 1
#dt_holy
#att 0
#magic
#def 0
#armorpiercing
#dmg 16
#nostr
#flyspr 411 4
#explspr 10220
#nratt 10
#range 50
#rcost 10
#sound 24
#end

-- Absolver Hammer

#newweapon 693
#name "Absolver Hammer"
#magic
#dmg 9
#att 2
#def 1
#len 2
#sound 11
#rcost 10
#secondaryeffect 216
#end



-------- New Armour

#newarmor 321
#name "Whitesteel Plate of Ulm"
#type 5
#prot 23
#def -4
#enc 4
#rcost 35
#end


-------- Units

--UNITS

--Penitent

#newmonster 2978
#copyspr 217
#name "Penitent"
#descr "The new faith offers all a chance for rebirth and many who have fallen from the path of righteousness flock to receive the blessing of the new god and his priests, joining a classless force in society known as the penitent. They make for rabid fighters and their devotion to the iron faith grants them impressive strength but they are not well protected or trained and do not have the lasting power of professional soldiers."
#str 11
#weapon "flail"
#hp 11
#holy
#mor 15
#mr 9
#att 9
#def 9
#ap 12
#prec 8
#enc 3
#gcost 10
#rcost 1
#mapmove 2
#size 2
#nametype 104
#end


--Emergent

#newmonster 2313
#copyspr 217
#name "Emergent"
#descr "The Emergent are Penitent newly released from an anchorite struck open in battle. Reborn into chaos and violence they are filled with fanatical devotion to the Iron Faith and are temporarily charged with spiritual energy lending them great strength and resilience."
#str 14
#weapon "flail"
#hp 15
#prot 5
#holy
#mor 99
#mr 9
#att 9
#def 9
#ap 12
#prec 8
#enc 3
#gcost 8
#rcost 1
#mapmove 2
#size 2
#nametype 104
#firstshape 2978
#end


-- Infantry of Ulm

#newmonster 2300
#copystats 73
#copyspr 73
#name "Infantry of Ulm"
#descr "Although blacksteel armour has become increasingly harder to manufacture since the Civil War the basic infantry of Ulm are still well armoured with heavy chainmail and are well protected from missile fire by their traditional tower shields. Their favoured weapon is the hammer, symbol of the will of the new god and their own iron faith."
#mr 8
#nametype 104
#end

-- Crossbow of Ulm

#newmonster 2301
#copystats 49
#copyspr 417
#name "Crossbow of Ulm"
#descr "The old arbalest design fell out of favour during the long years of the civil war as it took too much training and maintenance to be of use. Modern Ulmish missile support comes from rugged and easily repaired crossbows used by well armoured troops."
#str 11
#hp 12
#mr 8
#nametype 104
#end

-- Pike of Ulm

#newmonster 2302
#copystats 79
#copyspr 79
#name "Pike of Ulm"
#descr "Pike form defensive blocks in the Ulmish army which grind down the enemy and allow time for the priests and templars to smite their blackhearted foes."
#mr 8
#nametype 104
#end

-- Black Zweihander

#newmonster 2303
#copystats 1034
#spr1 "./Ulm Reborn/Black Zwei.tga"
#spr2 "./Ulm Reborn/Black Zwei2.tga"
#name "Black Zweihander"
#descr "These elite infantry are named after the massive two handed swords they wield in combat. They are the only troops in the regular Ulmish army who are granted the prized blacksteel armour and as such they are very well protected. Their only weakness is that they can tire out if drawn into a long grinding battle. They are therefore best used as heavy shock infantry."
#armor "full plate of ulm"
#mr 8
#gcost 15
#nametype 104
#end

-- Anchorite

#newmonster 2304
#copystats 76
#copyspr 76
#name "Anchorite"
#descr "Just as the Aufklarung saved Ulm from itself, so shall criminals, madmen and heretics be given the blessing of rebirth. Anchorites are blessed suits of blacksteel armour which have been animated by the Black Priests and into which a fallen individual is sealed. These suits then march to battle armed with great two handed warhammers, smiting the enemies of Ulm left and right. Though extremely resistant to damage, the anchorites are slow and the spells that animate them are easily disrupted; they are inevitably struck down, but when they fall the occupant is released and, thus reborn, battles on with great fervour. As a fusion of cold emotionless steel and raging devotion they epitomise modern Ulm. Anchorites require a member of the new Iron Clergy to direct them."
#holy
#inanimate
#magicbeing
#coldres 50
#fireres 50
#poisonres 50
#neednoteat
#hp 4
#ap 10
#mor 50
#mr 10
#enc 0
#str 15
#gcost 22
#secondshape 2313
#nametype 104
#startage 25
#maxage 80
#end

-- Black Templar

#newmonster 2305
#copystats 738
#copyspr 738
#descr "The elite order of the Black Knights was very nearly wiped out by the Civil War. The few that survived the years of continuous conflict were dispersed and found themselves working for one local lord or another as mercenaries or petty vassals. The glory and honour of their past order seemed lost forever, but all that was changed by the descent of the Aufklarung. The scattered knights felt a power pulling their very souls towards the capital and were unable to resist. They gathered at the Black Temple and as one they vowed to serve the new Iron Faith as the Black Templars."
#weapon "hammer"
#weapon "lance"
#weapon 56
#nametype 104
#end


-- Neugeboren Guard

#newmonster 2306
#copystats 66
#name "Neugeboren Guard"
#descr "The Neugeboren, or reborn, are an elite band of men who were once known as the Guardians. During the Civil War they fought incredibly hard and no matter what forces attempted to storm the citadel they held their positions. All hope that the siege might be broken in time was soon lost however and the Guardians began to starve. Their legendary morale began to crumble and dark thoughts began to invade their minds via the sharp claws of hunger. When all seemed lost the light of the Aufklarung descended and the Guardians were saved. The Civil War ended almost immediately and when the Guardians emerged it was clear they had become something greater than mere men. They had been reborn; even their ancestral blacksteel plate had changed to reflect their purity."
#spr1 "./Ulm Reborn/Reborn Guard.tga"
#spr2 "./Ulm Reborn/Reborn Guard2.tga"
#holy
#armor "whitesteel plate of ulm"
#mor 15
#gcost 42
#mr 10
#nametype 104
#end


-------- Commanders

-- Hammer of Ulm

#newmonster 2307
#copystats 114
#copyspr 114
#name "Hammer of Ulm"
#descr "The Hammers of Ulm are the most common commanders in the army. They are well respected, capable of leading many men in battle and have been granted coveted blacksteel plate armour."
#armor "full plate of ulm"
#standard 3
#nametype 104
#end

-- Neugeboren Lord

#newmonster 2308
#copystats 113
#name "Neugeboren Lord"
#descr "Though of crucial import to the new faith, the leaders of the Neugeboren have no priestly powers. They are, however, direct representatives of the new god and as such are granted physical prowess beyond that of mere mortals and an aura of valour that allows them to lead a great many men. Their presence on the battlefield not only inspires Ulmish soldiers to acts of great bravery but also greatly unsettles any enemies foolish enough to approach such a figure."
#spr1 "./Ulm Reborn/Reborn Lord.tga"
#spr2 "./Ulm Reborn/Reborn Lord2.tga"
#holy
#armor "whitesteel plate of ulm"
#hp 30
#str 14
#mor 18
#fear 0
#awe 1
#mr 11
#standard 15
#gcost 170
#expertleader
#maxage 100
#nametype 104
#end

-- Black Acolyte

#newmonster 2309
#copystats 739
#copyspr 739
#descr "The Iron Faith of Ulm was initially a powerful cult enforcing perceived justice during the Civil War. When the Aufklarung brought a sudden end to the war the cult realised their full potential and became shepherds and guardians of Ulm. Their rule is absolute and all magical practice outside of the faith is banned. Acolytes serve as the rank and file of the Iron Faith; they do not have the authority to gather forces of penitent, but they are trained to infiltrate enemy lands and spread the will of the awakening god."
#stealthy 0
#gcost 40
#poorleader
#poormagicleader
#nametype 104
#end

-- Black Priest

#newmonster 2310
#copystats 740
#copyspr 740
#descr "The Iron Faith of Ulm was initially a powerful cult meting out perceived justice during the Civil War. When the Aufklarung brought a sudden end to the war the cult realised their full potential and became shepherds and guardians of Ulm. Their rule is absolute and all magical practice outside of the faith is banned. The more powerful Black Priests have some skills in Earth magic and while in the Dominion of the awakening god are able to attract large groups penitent wishing to atone for their actions during the Civil War."
#domsummon2 "penitent"
#okleader
#okmagicleader
#custommagic 1024 30
#gcost 180
#nametype 104
#end

-- Hochmeister

#newmonster 2311
#copystats 1237
#copyspr 1237
#descr "Hochmeisters skilled commanders, warriors, priests and inquisitors trained to lead the Black Templars into battle. They are chosen from amongst the Templar primarily for their fanatical devotion to the Iron Faith and they are highly unlikely to retreat from battle."
#mor 18
#poormagicleader
#weapon "hammer"
#weapon "lance"
#weapon 56
#nametype 104
#end


-- White Priest

#newmonster 2979
#copystats 1646
#copyspr 477
#clearmagic
#clearmagic
#clearmagic
#clearmagic
#name "White Priest"
#descr "During the Civil War the highest leaders of the Iron Cult burdened the responsibility for the actions of their faith alone. When entire villages had to be purged to fend off the encroaching darkness it was they that bore the weight upon their souls. When the Aufklarung descended on Ulm many of them were driven mad and fled into the Black Forest, but some were able to overcome their guilt and were reborn as pristine symbols of spiritual fortitude. They stand apart from the Black Temple and are the true leaders of the new faith. They are powerful priests skilled in both traditional earth magic and the study of the heavens. Although they attract far less penitent than the more grounded Black Priests, it is only the White Priests that may call the Sternkind and only they who can draw on such strong faith as to be unaffected by realms drained of magic."
#hp 9
#mapmove 2
#ap 12
#mr 15
#mor 16
#str 10
#att 8
#def 8
#prec 11
#enc 3
#magicskill 8 3
#magicskill 3 3
#magicskill 4 1
#gcost 290
#holy
#summon1 "penitent"
#goodleader
#okmagicleader
#maxage 100
#startage 85
#awe 1
#nametype 104
#forgebonus 10
#custommagic 2048 15
#end


-- Hoch-Hammer

#newmonster 2982
#spr1 "./Ulm Reborn/Hoch-Hammer.tga"
#spr2 "./Ulm Reborn/Hoch-Hammer2.tga"
#name "Hoch-Hammer"
#descr "Hoch-Hammers are ordinary Black Templar who chose to take sacred hammers from the White Temple and swear an oath of wrath and judgement upon the dark and corrupted world around them. They lack the training that the Hochmeisters receive at the Black Temple but the sheer power of the white hammers they hold make them extremely formidable on the battlefield; they can hurl a swarm of spirit hammers which attract blasts of energy from the mantle of the Aufklarung. Their eyes glowing with sacred energy they strike down the enemies of the Iron Faith from near or far. Hoch-Hammers will never use weapons other than their hammer and shield."
#weapon "White Hammer"
#weapon "Spirit Hammers"
#weapon 56
#armor "Full plate of ulm"
#armor "Full helmet"
#armor "kite shield"
#mounted
#size 3
#mor 18
#mr 11
#enc 5
#prec 12
#att 14
#def 13
#str 14
#hp 25
#gcost 200
#rcost 1
#holy
#mapmove 2
#ap 18
#okleader
#standard 5
#nametype 104
#itemslots 13440
#end

-- White Acolyte

#newmonster 2314
#copystats 1646
#spr1 "./Ulm Reborn/White Acolyte.tga"
#spr2 "./Ulm Reborn/White Acolyte2.tga"
#clearmagic
#clearmagic
#clearmagic
#clearmagic
#name "White Acolyte"
#descr "The Aufklarung brought about not only peace, religious fervour and a strong sense of purpose in Ulm; it also instilled a thirst for knowledge amongst many and drew them to the White Temple to be trained as Acolytes. The White Acolytes spend their time studying tomes of knowledge long thought lost to the Civil War. They make excellent researchers and like the more powerful White Priests they are unaffected by the currents of traditional magic; even in magically drained lands they are entirely effective. Their focus on constant study and catalogue has left them physically weak and they are reluctant to travel long distances. They often have skill in astral and earth magics."
#hp 8
#mapmove 1
#ap 10
#mr 12
#mor 11
#str 9
#att 7
#def 7
#prec 9
#enc 3
#magicskill 8 1
#researchbonus 1
#gcost 100
#holy
#noleader
#maxage 65
#startage 50
#nametype 104
#custommagic 3072 100
#custommagic 3072 10
#end


--------------------------------------


-------- National Summons


-- Sternkind

#newmonster 2980
#spr1 "./Ulm Reborn/Sternkind.tga"
#spr2 "./Ulm Reborn/Sternkind2.tga"
#name "Sternkind"
#descr "Sternheld are souls granted form by the Aufklarung. Their virtuous actions during the Civil War have not been forgotten and they are revered by the Iron Faith; they alone span the gap between the world of man and iron and the heavenly realm of the Aufklarung. These sacred undead warriors carry hammers which release a blast of electrical energy when they strike their target."
#str 11
#att 12
#def 10
#hp 22
#mapmove 3
#enc 3
#prec 11
#ap 12
#flying
#prot 8
#mr 10
#mor 20
#gcost 20
#undead
#holy
#size 3
#shockres 50
#weapon "Sternhammer"
#maxage 900
#startage 10
#nametype 139
#end


-- Sternheld

#newmonster 2981
#spr1 "./Ulm Reborn/Sternheld.tga"
#spr2 "./Ulm Reborn/Sternheld2.tga"
#name "Sternheld"
#descr "Sternheld are the hands of the Aufklarung, spirit beings given form and considerable power who are often found commanding forces of lesser Sternkind. Their black and white wings represent the transitional state of their souls between the mire of the Civil War and the glory of the Aufklarung. They are naturally gifted in air and astral magic."
#undead
#holy
#hp 25
#str 12
#att 13
#def 11
#prot 8
#enc 3
#prec 11
#gcost 300
#flying
#mr 12
#magicskill 4 2
#magicskill 1 2
#mapmove 3
#ap 12
#mor 22
#size 3
#shockres 50
#weapon "sternhammer"
#poorleader
#okundeadleader
#startage 10
#maxage 900
#nametype 139
#end

-- Sturmheld

#newmonster 2312
#spr1 "./Ulm Reborn/Sturmheld.tga"
#spr2 "./Ulm Reborn/Sturmheld2.tga"
#name "Sturmheld"
#descr "The Sturmheld wield a power even greater than the righteous Sternheld. They are undead Ulmic angels of wrath and spite. Like the Sternheld they have one black and one white wing, representing the transitional state of their souls between the earth and the Aufklarung. Unlike the Sternheld they have no gift for astral magic, but are masters of air and lightning. Sternkind have been known to substantiate in areas of great faith just to follow the Sturmheld."
#undead
#domsummon20 2980
#holy
#hp 25
#str 13
#att 14
#def 12
#prot 9
#enc 3
#prec 12
#gcost 500
#flying
#mr 12
#magicskill 1 3
#magicskill 0 2
#mapmove 3
#ap 12
#mor 25
#size 3
#shockres 100
#weapon "sternhammer"
#goodleader
#goodundeadleader
#startage 10
#maxage 900
#nametype 139
#end

-- Grey Shepherd

#newmonster 2983
#spr1 "./Ulm Reborn/Grey Shepherd.tga"
#spr2 "./Ulm Reborn/Grey Shepherd2.tga"
#name "Grey Shepherd"
#descr "The Grey Shepherd is a wandering priest of the Iron Faith who many call the Smith of Souls. It is said he can test the mettle of any man's soul at a glance and, given a few years, cleanse even the darkest native of Ulm from all flaws. The Grey Shepherd has never been heard to speak; he simply appears and with a single nod calls men to his flock. He attracts far more penitent than any other priest alive."
#str 12
#att 10
#def 12
#hp 16
#mapmove 2
#enc 2
#ap 12
#prec 11
#mr 14
#mor 19
#gcost 1
#rcost 1
#holy
#magicskill 8 3
#weapon "quarterstaff"
#domsummon "penitent"
#summon5 "penitent"
#expertleader
#nametype 139
#itemslots 31878
#end

-- Reborn Noble

#newmonster 2315
#spr1 "./Ulm Reborn/Reborn Noble.tga"
#spr2 "./Ulm Reborn/Reborn Noble2.tga"
#name "Reborn Noble"
#descr "This infamous nobleman was responsible for some of the most terrible atrocities of the Civil War; children slaughtered, women raped, entire towns put to the sword. Yet with the coming of the Aufklarung and the awakening god, the noble was reborn. All could see by the light in his eyes that he had changed, but the noble demanded to be tested, given the chance to prove his righteous rebirth. And so he was given up to the Black Temple to be 'tested', then to the White Temple to be purged, then finally to the Keep of the Reborn, to be trained. He emerged something more than a mere man and has become a leader of great standing, loved by the sons of the Iron Faith but feared and despised by their heathen foes."
#holy
#armor "whitesteel plate of ulm"
#weapon "great sword"
#ap 12
#enc 2
#mapmove 2
#att 14
#def 14
#hp 35
#str 15
#mor 20
#fear 2
#awe 2
#mr 13
#standard 20
#gcost 1
#rcost 1
#expertleader
#maxage 100
#nametype 104
#itemslots 31878
#end

-- Confessor

#newmonster 2316
#spr1 "./Ulm Reborn/Confessor.tga"
#spr2 "./Ulm Reborn/Confessor2.tga"
#copystats 2310
#name "Confessor"
#descr "The high ranking Black Priest known only as the Confessor was, in a former life, a member of the Marignese clergy.
Leading a group of soldiers on a crusade into the tumultuous lands of Ulm during the Civil War, he and his band were struck
with the ineffable power of the Aufklarung as strongly as any native of Ulm. He converted immediately to follow the new god
and joined the Iron Faith. He has since become a powerful and influential figure in Ulm who has added his doctrine of cleansing
fire to the redemption offered by the faith."
#clearmagic
#clearmagic
#clearmagic
#weapon "Absolver Hammer"
#itemslots 31878
#magicskill 0 2
#magicskill 8 2
#magicskill 3 2
#end


-------- New Pretender


-------- New Spells


--newspell
--name "Reward the Faithful"
--descr "Holy stardust cascades down from the spreading mantle of the Aufklarung to heal the wounds of a small number of loyal soldiers."
--school 7
--restricted 77
--fatiguecost 0
--researchlevel 0
--path 0 8
--pathlevel 0 1
--range 20
--aoe 1
--effect 13
--flightspr -1
--damage 20
--explspr 10002
--range 30
--precision 70
--nreff 1
--end

#newspell
#copyspell "Lightning Bolt"
#name "Punish the Unjust"
#descr "A crackling blast of holy lightning tears down from the spreading mantle of the Aufklarung and strikes one enemy of Ulm."
#school 7
#restricted 77
#researchlevel 0
#path 0 8
#fatiguecost 20
#pathlevel 0 2
#damage 10
#range 50
#precision 10
#nreff 1
#end

#newspell
#name "Messengers of the Aufklarung"
#descr "The White Priest performs a holy ritual under the mantle of the Aufklarung allowing eight souls of virtue from the Civil War to reform as Sternkind; representatives of the afterlife and messengers of the new faith. They will only follow a commanding Sternheld." 
#school 0
#restricted 77
#researchlevel 3
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10001
#fatiguecost 1300
#damage 2980
#nreff 8
#end

#newspell
#name "Hand of the Aufklarung"
#descr "The prophet performs a holy ritual under the mantle of the Aufklarung which gives form to a single Sternheld, a sacred undead being skilled in air and astral magic." 
#school 0
#restricted 77
#researchlevel 4
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10021
#fatiguecost 1400
#damage 2981
#nreff 1
#end


#newspell
#name "Wrath of the Aufklarung"
#descr "The prophet performs a holy ritual under the mantle of the Aufklarung which gives form to a single Sturmheld, a sacred undead being of considerable power highly skilled in air magic with some knowledge of the fiery arts." 
#school 0
#restricted 77
#researchlevel 5
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10021
#fatiguecost 2000
#damage 2312
#nreff 1
#end



-- Hot fixes for blessing type spells taken from the Black Tome of Alsophocus mod by Doctor Praetorious

#selectspell "Blessing"
#spec 12632064
#end

#selectspell "Divine Blessing"
#spec 12615680
#end

#selectspell 105
#path 0 -1
#school -1
#end

#selectspell 109
#path 0 -1
#school -1
#end

#selectspell 112
#path 0 -1
#school -1
#end


-------- New sites

#newsite 990

#name "Keep of the Reborn"


#path 8
#level 0


#rarity 5
#homemon 2306
#homecom 2308
#end



#newsite 991
#name "White Temple"


#path 8
#gems 4 1
#level 0


#rarity 5

#homecom 2979
#homecom 2982
#end



#newsite 992
#name "Forge of the Faithful"
#path 3
#level 0


#rarity 5
#gems 3 2
#res 30
#end



#newsite 993
#name "Black Temple"
#path 8
#level 0
#rarity 5
#homecom 2311
#homemon 2305
#end


-------- New Namepools


-------- New nations



#selectnation 77
#clear
#name "New Ulm"
#epithet "Iron Faith Reborn"
#era 2
#brief "The malediction never occured. Instead the Civil War was ended by the Aufklarung (enlightenment), a miraculous event heralding the awakening of a new god."
#descr "The malediction never occured. Instead the Civil War was ended by the Aufklarung (enlightenment), a miraculous event heralding the awakening of a new god. The Iron Faith rules all aspects of society both temporal and spirtual under the leadership of those reborn in the Aufklarung. Their White Priests and Acolytes are unaffected by drain dominion."
#summary "Race: Humans. Military: Heavy infantry and cavalry, many sacreds including droves of penitent. Magic: Earth, Astral, access to Air. Priests: Strong, Some attract penitent."
#flag "./Ulm Reborn/flag.tga"
#templepic 9
#castleprod 25
#color 160 160 160


------- Add Soldiers

#addrecunit 2300 -- Infantry with hammer
#addrecunit 2301 -- Crossbow
#addrecunit 2302 -- Pike
#addrecunit 2304 -- Anchorite
#addrecunit 2303 -- Black Zweihander


------- Add leaders

#addreccom 2307 -- Captain Hammer
#addreccom 2309 -- Black Acolyte
#addreccom 2310 -- Black Priest
#addreccom 2314 -- White Acolyte

------- Province Defence

--Sets the units to be used in province defense.

#defcom1 2307 -- Captain Hammer
#defcom2 2309
 -- Black Acolyte
#defunit1 2300 -- Infantry with hammer
#defunit1b 2301 -- Crossbow 
#defunit2 2978 -- Penitent


--Sets how many of the units to appear per point.

#defmult1 10
#defmult1b 10
#defmult2 14

------- Hero Settings

#hero1 2983
#hero2 2315
#hero3 2316
#multihero1 2312

#idealcold 0
#startsite "Forge of the Faithful"
#startsite "Black Temple"
#startsite "Keep of the Reborn"
#startsite "White Temple"
#startfort 3
#swampfort 11
#farmfort 41
#forestfort 35
#mountainfort 9
#defaultfort 7


------- Starting units

#startcom 2307
#startunittype1 2300
#startunitnbrs1 10
#startunittype2 2301
#startunitnbrs2 10
#startscout 2309
#end
