-- Halls of the Underkings mod for Dominions 2, version 1.00
-- Created by Edward Vaughn
-- 2006

-- Updated & Expanded for Dominions 3 by Saulot
-- v 1.00




-- BACKGROUND STORY

-- DESIGN NOTES

	This mod adds the following monsters to Dominions 3 in the range of 2800-2836:
	>	2800 Dwarf Militia (Axe)
	>	2801 Dwarf Crossbowman (Crossbow)
	>	2802 Dwarf Hurler (Throwing Axe)
	>	2803 Dwarf Clansman (Battleaxe)
	>	2804 Dwarf Clansman (Two Axes)
	>	2805 Woad Raider (Battleaxe)
	>	2806 Dwarf Warrior (Axe)
	>	2807 Dwarf Warrior (Hammer)
	>	2808 Stoneguard (Axe)
	>	2809 Stoneguard (Hammer)
	>	2810 Gateguard (Hammer)
	>	2811 Gateguard (Maul)
	>	2812 Rune Paladin (Runed Greataxe, Holy)
	>	2813 Helmsfire Paladin (Helmsfire Greataxe, Holy)
	>	2814 Bolt Thrower (Ballista, Siege)
	>	2815 Dwarf Miner (Two Dwarven Pickaxe, Siege)
	>	2816 Scout (Axe)
	>	2817 Chief (Axe)
	>	2818 Stone Chief (Hammer)
	>	2819 Dwarf Lord (Dwarven Pickaxe)
	>	2820 Rune Priest (Hammer, Earth 2, Priest 2, + Rand)
	>	2821 Helmsfire Keeper (Axe, Fire 2, Earth 1, Priest 2, + Rand)
	>	2822 Mine Foreman (Dwarven Pickaxe, Siege)
	>	2823 Stone King (Pretender)
	>	2824 Underking (Greataxe)
	>	2825 Brewmaster (Club)
	>	2826 Rune Acolyte (Hammer, Earth 1, Priest 1)
	>	2827 King of the Ravens (Claw, Beak, Air 1)
	>	2828 Geomancer (Hammer, Earth 3)
	>	2829 Abandoned Bolt Thrower (None)
	>	2830 Mechanical Dwarf (Axe)
	>	2831 Runic War Machine (Two Flaming Boulders)
	>	2832 Animated Warhammer (Stormhammer)
	>	2833 Battlerager (Two Axes)
	>	2834 Battlemaster (Massive Mace)
	>	2835 Eternal Guardian (Massive Mace)
	>	2836 Templeguard (Morningstar)

	This mod uses the following weapons slots in Dominions 3:
	>	785 Spirit Strike
	>	786 Dwarven Crossbow
	>	787 Dwarven Maul
	>	788 Dwarven Throwing Axe
	>	789 Massive Mace
	>	790 Brand of Earth
	>	791 Brand of Fire
	>	792 Stormhammer
	>	793 Flaming Shrapnel
	>	794 Flaming Boulder
	>	795 Dwarven Pickaxe
	>	796 Small Area Lesser Fear
	>	797 Helmsfire Greataxe
	>	798 Ballista
	>	799 Runed Greataxe

	This mod uses the following armor slots in Dominions 3:
	> 	397 Woad (Armor)
	>	398 Dashing Hat (Helmet)
	>	399 Mithril Mail (Armor)

	This mod uses nametype 148, 149 & magicsites 850, 851

-- GENERAL MOD DATA

#modname "Halls of the Underkings"
#description "MA Dwarf Nation named Underheim."

#icon "./underkings/banner.tga"
#version 1.00
#domversion 3.14

-- NAME DATA

#selectnametype 149
#clear
#addname "Aegir" 
#addname "Alfarinn"
#addname "Alsvartr" 
#addname "Alsvidr"
#addname "Alsvinnr" 
#addname "Alvaldi"
#addname "Amr"
#addname "Andudr"
#addname "Arngrimr"
#addname "Aurgelmir" 
#addname "Aurgrimnir" 
#addname "Aurrekr"
#addname "Balin"
#addname "Baugi"
#addname "Beinvidr"
#addname "Bli"
#addname "Bergelmir"
#addname "Bergfinn"
#addname "Bergporr" 
#addname "Bjrgolfr"
#addname "Blappvari" 
#addname "Brandingi"
#addname "Brimir"
#addname "Bruni"
#addname "Brusi"
#addname "Byleistr"
#addname "Dofri"
#addname "Dumbr"
#addname "Durin"
#addname "Durnir"
#addname "Eimgeitir"
#addname "Eitill"
#addname "Farbauti"
#addname "Fenrir"
#addname "Fjalarr" 
#addname "Fjolsvidr"
#addname "Fjolverkr" 
#addname "Fleggr"
#addname "Fornjotr"
#addname "Fyrnir"
#addname "Galarr"
#addname "Ganglati"
#addname "Gangr"
#addname "Gapi"
#addname "Gaper"
#addname "Gaulnir"
#addname "Gautr"
#addname "Gaut"
#addname "Geirhamdir"
#addname "Geirrodr"
#addname "Geitir"
#addname "Gillingr"
#addname "Gimli"
#addname "Glamr"
#addname "Glaumr" 
#addname "Gljufrageirr"
#addname "Gloin"
#addname "Golnir"
#addname "Grimlingr"
#addname "Grimr"
#addname "Grimulfr"
#addname "Grimnir"
#addname "Gudmundr"
#addname "Gusir"
#addname "Gyllingr"
#addname "Gymir"
#addname "Hallmundr"
#addname "Hardgreipr" 
#addname "Hardverkr"
#addname "Hastigi"
#addname "Hati"
#addname "Heidr"
#addname "Helreginn"
#addname "Hengikjaftr"
#addname "Hergrimr"
#addname "Herkir"
#addname "Hildir"
#addname "Hlbardr"
#addname "Hloi"
#addname "Hraesvelgr"
#addname "Hraudnir"
#addname "Hrimgrimnir"
#addname "Hrimnir"
#addname "Hrimpurs"
#addname "Hripstodr"
#addname "Hroarr"
#addname "Hrodr"
#addname "Hrokkvir"
#addname "Hrongvidr" 
#addname "Hrolfr"
#addname "Hrosspjofr"
#addname "Hrungnir"
#addname "Hrymr"
#addname "Hundalfr"
#addname "Hvalr"
#addname "Hvedrungr"
#addname "Hymir"
#addname "Idi"
#addname "Imr"
#addname "Jarngrimr"
#addname "Jarnhauss"
#addname "Jarnnefr"
#addname "Jarnskjoldr"
#addname "Kaldgrani"
#addname "Kalfr"
#addname "Kottr"
#addname "Kyrmir"
#addname "Leidi"
#addname "Lodinn"
#addname "Lundr"
#addname "Lutr"
#addname "Midi" 
#addname "Midjungr"
#addname "Midvitnir"
#addname "Mimir"
#addname "Mogprasir"
#addname "Nati"
#addname "Norfi" 
#addname "Oflugbardi"
#addname "Ofoti"
#addname "Ogladnir"
#addname "Olvaldi"
#addname "Ondudr"
#addname "Oskrudr" 
#addname "Osgrui"
#addname "Oskrudr"
#addname "Orn"
#addname "Pistillbardi"
#addname "Prigeitir"
#addname "Prudgelmir"
#addname "Rangbeinn"
#addname "Raudfeldr"
#addname "Reginn"
#addname "Rondolfr"
#addname "Rungnir"
#addname "Saekarlsmuli"
#addname "Samendill"
#addname "Samr"
#addname "Selr"
#addname "Skaerir"
#addname "Skerkir" 
#addname "Skorir"
#addname "Skramr" 
#addname "Skrymir"
#addname "Sluggard"
#addname "Sokkmimir"
#addname "Somr"
#addname "Sprettingr"
#addname "Starkadr"
#addname "Stigandi"
#addname "Storverkr"
#addname "Stumi"
#addname "Surtr"
#addname "Suttungr"
#addname "Svadi"
#addname "Svalfangr"
#addname "Svalr"
#addname "Svarangr"
#addname "Svartr"
#addname "Svasudr"
#addname "Tindr"
#addname "Tjosnir"
#addname "Ulfhedinn"
#addname "Ulfr"
#addname "Utgardaloki"
#addname "Vafprudnir"
#addname "Vagnhofdi"
#addname "Valdi"
#addname "Vasudr"
#addname "Vidblindi"
#addname "Vindloni"
#addname "Vindr"
#addname "Vindsvalr"
#addname "Viparr"
#addname "Vornir"
#addname "Ylfingr"
#addname "Ymir"

#addname "Ni"
#addname "Nidi"
#addname "Nordri"
#addname "Sudri"
#addname "Asutri"
#addname "Vestri"
#addname "Althif"
#addname "Dvalin"
#addname "Nr"
#addname "Nin"
#addname "Niping"
#addname "Din"
#addname "Bivr"
#addname "Bavr"
#addname "Bmbur"
#addname "Nori"
#addname "An"
#addname "Anar"
#addname "Ai"
#addname "Midvitnir"
#addname "Veig"
#addname "Gandlf"
#addname "Vindlf"
#addname "Thrin"
#addname "Thekk"
#addname "Thorin"
#addname "Thror"
#addname "Vitr"
#addname "Litr"
#addname "Nr"
#addname "Nrd"
#addname "Regin"
#addname "Rdsvid"
#addname "Fili"
#addname "Kili"
#addname "Fundin"
#addname "Nali"
#addname "Hepti"
#addname "Vili"
#addname "Hanar"
#addname "Svior"
#addname "Billing"
#addname "Bruni"
#addname "Bild"
#addname "Bri"
#addname "Frr"
#addname "Hornbori"
#addname "Frg"
#addname "Lni"
#addname "Aurvang"
#addname "Iari"
#addname "Eikinskialdi"
#addname "Draupnir"
#addname "Dlgthrasir"
#addname "Hr"
#addname "Haugspori"
#addname "Hlvang"
#addname "Gli"
#addname "Skirvir"
#addname "Virvir"
#addname "Skafid"
#addname "Alf"
#addname "Yngvi"
#addname "Fjalar"
#addname "Frosti"
#addname "Finn"
#addname "Ginnar"
#addname "Heri"
#addname "Hggstari"
#addname "Hlidolf"
#addname "Min"
#addname "Lofar"
#end

#selectnametype 148
#clear
#addname "Doombringer"
#end

-- SPELL DATA

#newspell
#copyspell "Astral Window"
#name "Raven Spies"
#descr "Ravens and Dwarves have a long and friendly history together.  These days few of the great ravens remain, but with this spell, a caster can call out to one, and ask it to spy upon an area.  The use of an air gem facilitates the long distance communication, and more air gems allow for the spying to continue longer."
#researchlevel 0
#path 0 1
#pathlevel 0 1
#fatiguecost 100
#restricted 76
#end

#newspell
#copyspell "Barathrus Pact"
#name "Earthfriend"
#descr "The caster crushes several earth gems and uses the dust to summon a mid-sized earth elemental."
#researchlevel 4
#restricted 76
#end

#newspell
#name "Hearthstrike"
#descr "This is a traditional spell of Helmsfire Keepers.  They create a large magical bonfire, sit inside it, and through long incantations from within the flames, are connected to fires throughout the world.  Once a fire is chosen, usually a campfire in an army camp is targetted, though a simple torch will do as well, the fire is brought to life.  This fire flares out and quickly grows into a mid-sized fire elemental, which proceeds to attack a random enemy commander.  Whether successful or not, the magic flames quickly consume whatever life energy the fire elemental has and it dissapears soon afterwards."
#school 0
#researchlevel 6
#path 0 0
#path 1 8
#pathlevel 0 3
#pathlevel 1 2
#damage 596
#effect 10050
#fatiguecost 300
#restricted 76
#end

#newspell
#copyspell "Dome of Arcane Warding"
#name "Runes of Abjuration"
#descr "This is a traditional spell of Rune Priests.  They carve protective runes in a central hall, and then enchant them to keep out malign magic that originates elsewhere.  The magic runes will stay functional for a greater number of months if more earth gems are added to the ritual.  If the caster dies, the runes dissolve instantly.  One out of every two spells will be successfully blocked."
#path 0 3
#path 1 8
#pathlevel 0 2
#pathlevel 1 2
#restricted 76
#end

#newspell
#copyspell "Mechanical Men"
#name "Mechanical Dwarves"
#descr "The caster makes ten Mechanical Dwarves to serve him.  The fragile skeletal structure of the construct is covered with full plate armor and the construct is given a large metal shield and an axe.  The iron dwarves are not affected by heat, cold, shock, or poison.  They are mindless, magical beings that will cease to function when left without magical leadership."
#damage 2830
#fatiguecost 1200
#researchlevel 7
#restricted 76
#end

#newspell
#name "Conjure Stormhammers"
#descr "The caster conjures up several magically animated warhammers to aid him in battle.  They are mentally controlled by the caster, levitate, strike accurately, and are hard to hit and damage.  They are enchanted to unleash a bolt of lightning whenever they strike."
#school 0
#researchlevel 5
#path 0 3
#path 1 1
#pathlevel 0 2
#pathlevel 1 1
#effect 43
#damage 2832
#fatiguecost 80
#nreff 1000
#flightspr -1
#restricted 76
#end

#newspell
#copyspell "Healing Light"
#name "Prayer of Restoration"
#descr "The caster heals the lesser wounds of several units at a distance.  Afflictions however, remain."
#school 7
#researchlevel 0
#path 0 8
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#fatiguecost 0
#restricted 76
#end

#newspell
#copyspell "Legions of Steel"
#name "Mantle of the Enduring Earth"
#descr "The caster enchants one squad of units with stronger armor and temporary invulnerability."
#researchlevel 3
#path 0 3
#path 1 8
#pathlevel 0 2
#pathlevel 1 2
#nextspell "Twist Fate"
#spec 4718592
#restricted 76
#end

#newspell
#copyspell "Dust to Dust"
#name "Requiem of Final Peace"
#descr "The caster sings a magic phrase, and several undead instantly sink into the ground for a hasty burial."
#researchlevel 3
#path 0 3
#path 1 8
#pathlevel 0 1
#pathlevel 1 1
#range 40
#fatiguecost 10
#nextspell "Earth Grip"
#restricted 76
#end

#newspell
#copyspell "Power of the Reborn King"
#name "Battlecry of the Underkings"
#descr "The caster shouts a holy dwarven phrase and enchants all friendly units with the strength and speed to land vicious blows."
#school 4
#researchlevel 6
#path 0 3 
#path 1 8
#pathlevel 0 3
#pathlevel 1 2
#fatiguecost 80
#nextspell "Strength of Giants"
#spec 4718592
#restricted 76
#end

#newspell
#name "Enervation"
#descr "The caster shouts a holy dwarven phrase and all friendly units feel reinvigorated and lose some of their fatigue."
#school 4
#researchlevel 4
#effect 8
#aoe 666
#damage 20
#path 0 3 
#path 1 8
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 100
#flightspr -1
#explspr 10002
#sound 78
#spec 4718720
#restricted 76
#end

#newspell
#name "Call Battlerager"
#descr "The caster journeys to various inns seeking out and eventually locating a Battlerager, and persuades him to serve by offering copious amounts of alcohol."
#school 0
#researchlevel 0
#path 0 3
#pathlevel 0 1
#damage 2833
#effect 10021
#fatiguecost 200
#nreff 1
#restricted 76
#end

#newspell
#name "Forge Battlemaster"
#descr "The caster and a host of smiths use many earth gems to forge a massive suit of mithril armor, and enchant it to permanently house a soul.  After that process is complete, a Dwarf steps forward to cast aside everything from his life but war and defense of the Dwarven lands.  Thus a Battlemaster is made."
#school 3
#researchlevel 9
#path 0 3
#path 1 5
#pathlevel 0 5
#pathlevel 1 1
#damage 2834
#effect 10021
#fatiguecost 7500
#nreff 1
#restricted 76
#end

#newspell
#name "Assign Templeguard"
#descr "The Rune Priest calls for and assigns a group of Templeguards.  Templeguards are sacred troops skilled in fortress defense, who protect Dwarven strongholds and temples with their faith."
#school 0
#researchlevel 0
#path 0 3
#path 1 8
#pathlevel 0 2
#pathlevel 1 2
#damage 2836
#effect 10001
#fatiguecost 1000
#nreff 10
#restricted 76
#end

#newspell
#copyspell "Earth Meld"
#name "Cold Earth's Embrace"
#descr "Causes every enemy unit to sink into the earth, rendering them unable to move.  A unit can break free given sufficient time, but stronger units will not be restrained for long at all."
#aoe 666
#spec 262144
#researchlevel 7
#pathlevel 0 5
#fatiguecost 100
#restricted 76
#end

#newspell
#name "Discover Dwarf Fortress"
#descr "While Dwarves are known enjoy to stability and order, they do from time to time experience wanderlust, to discover mineral wealth or create new Dwarven outposts.  Over the various millenia, many such outposts and fortresses have been constructed, in the timeless and enduring fashion of the Dwarves.  Abandoned either because veins ran dry, or wiped out by foe, disease, or other disaster, they remain extremely well-hidden and for the most part untouched and unknown.  Dwarves have an eye for shaped stone, and with some magical guidance can search out and discover such a fortress with ease.  The caster performs the ritual and searches within the province until an old citadel is rediscovered."
#school 5
#researchlevel 5
#path 0 3
#pathlevel 0 3
#fatiguecost 5000
#effect 10063
#damage 9
#restricted 76
#end

#newspell
#name "Awaken the Fearless Spirit"
#descr "This spell bolsters the morale of a squad of units.  Units may be affected several times by the spell."
#school 5
#researchlevel 3
#path 0 0
#path 1 8
#pathlevel 0 2
#pathlevel 1 2
#effect 17
#damage 2
#aoe 25
#range 5020
#precision 0
#fatiguecost 30
#flightspr -1
#explspr 10042
#sound 29
#spec 4325504
#restricted 76
#end

#newspell
#name "Recover Doombringer"
#descr "Often greatly outnumbered in battle, dwarves rely on powerful war machines to even the odds.  In times of great need, a Rune Priest will dig into the archives and find the location of one of the great dwarven artifacts of power.  Once located, an expedition is sent out to retrieve it.  This is a call to recover Doombringer, an enormous iron and wooden catapult forged in a previous age, and enchanted with runes to move, create ammo, and rain devastation from afar.  Doombringer is enchanted to be indestructible, essentially immune to magic, and most importantly to only be operated by Dwarves."
#school 0
#researchlevel 8
#path 0 3
#pathlevel 0 6
#damage 2838
#effect 10021
#fatiguecost 3500
#nreff 1
#restricted 76
#end




-- ITEM DATA

#newweapon 785
#name "Spirit Strike"
#dmg 8
#att 0
#def 0
#len 6
#magic
#nostr
#armornegating
#nratt 3
#bonus
#rcost 0
#sound 18
#explspr 10206
#secondaryeffectalways 285
#end

#newweapon 786
#name "Dwarven Crossbow"
#ammo 15
#att 3
#dmg 10
#armorpiercing
#flyspr 109 1
#nostr
#twohanded
#nratt -2
#range 35
#sound 13
#rcost 3
#end

#newweapon 787
#name "Dwarven Maul"
#dmg 11
#att 0
#def -1
#len 3
#magic
#rcost 5
#sound 10
#end

#newweapon 788
#name "Dwarven Throwing Axe"
#bonus
#dmg 7
#att -2
#range 12
#ammo 2
#rcost 3
#flyspr 411 4
#sound 10
#end

#newweapon 789
#name "Massive Mace"
#dmg 16
#att 0
#def -1
#len 6
#armorpiercing
#flail
#magic
#sound 10
#rcost 0
#end

#newweapon 790
#name "Brand of Earth"
#att 100
#dmg 8
#armornegating
#nostr
#range 10
#ammo 1
#dt_holy
#dt_paralyze
#bonus
#flyspr -1
#rcost 0
#explspr 10011
#sound 18
#end

#newweapon 791
#name "Brand of Fire"
#att 100
#dmg 12
#fire
#magic
#range 10
#ammo 1
#bonus
#armorpiercing
#flyspr -1
#rcost 0
#explspr 10113
#sound 16
#end

#newweapon 792
#name "Stormhammer"
#dmg 20
#att 0
#def 0
#len 3
#flail
#bonus
#rcost 0
#nostr
#sound 10
#secondaryeffect 243
#end

#newweapon 793
#name "Flaming Shrapnel"
#dmg 12
#aoe 3
#nostr
#sound 16
#secondaryeffect 440
#secondaryeffectalways 221
#end

#newweapon 794
#name "Flaming Boulder"
#dmg 25
#att -2
#def 0
#armorpiercing
#flyspr 362 4
#explspr 10113
#flail
#rcost 0
#nostr
#aoe 1
#nratt -2
#range 75
#sound 13
#ammo 50
#secondaryeffectalways 793
#end

#newweapon 795
#name "Dwarven Pickaxe"
#dmg 3
#att 0
#def -1
#len 1
#armorpiercing
#flail
#rcost 1
#end

#newweapon 796
#name "Small Area Lesser Fear"
#dmg 0
#nostr
#dt_stun
#aoe 1
#secondaryeffectalways 440
#end

#newweapon 797
#name "Helmsfire Greataxe"
#dmg 10
#att 2
#def 0
#len 2
#magic
#secondaryeffect 221
#sound 10
#rcost 13
#end

#newweapon 798
#name "Ballista"
#ammo 12
#att 4
#bonus
#dmg 20
#flail
#armorpiercing
#flyspr 110 1
#nostr
#nratt -2
#range 60
#sound 13
#rcost 0
#secondaryeffect 91
#secondaryeffectalways 796
#end

#newweapon 799
#name "Runed Greataxe"
#dmg 10
#att 1
#def 0
#len 3
#magic
#dt_holy
#sound 10
#rcost 13
#end

#newarmor 397
#name "Woad"
#type 5
#prot 6
#def 1
#enc 0
#rcost 0
#end

#newarmor 398
#name "Dashing Hat"
#type 6
#prot 3
#def 0
#enc 0
#rcost 0
#end

#newarmor 396
#name "Mithril Hauberk"
#type 5
#prot 18
#def 0
#enc 1
#rcost 20
#end



-- MONSTER DATA

#newmonster 2800
#name "Dwarf Militia"
#spr1 "./underkings/recruit_militiaaxe1.tga"
#spr2 "./underkings/recruit_militiaaxe2.tga"
#descr "All dwarves are stocky, resilient folk who are not unused to fighting.  When called to action even the commoners of dwarven society are formidable opponents.  They have tough, caloused skin and can endure much pain."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 3
#att 9
#def 7
#prec 9
#mr 11
#mor 10
#gcost 11
#rcost 3
#weapon "Axe"
#armor "Iron Cap"
#armor "Leather Hauberk"
#armor "Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#okleader
#nomagicleader
#noundeadleader
#older -25
#maxage 250
#nametype 149
#end

#newmonster 2801
#name "Dwarf Crossbowman"
#spr1 "./underkings/recruit_xbow1.tga"
#spr2 "./underkings/recruit_xbow2.tga"
#descr "Dwarves are very fond of machines and complicated devices.  Although they prefer to make battle close-in, cleaving enemies with axes and crushing with hammers, some are equipped with crossbows.  Dwarven crossbows are more accurate and often decorated ornately, but are comparable to other designs in effectiveness."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 2
#att 11
#def 9
#prec 9
#mr 11
#mor 12
#gcost 15
#rcost 3
#weapon "Dwarven Crossbow"
#weapon "Hatchet"
#armor "Iron Cap"
#armor "Chain Mail Hauberk"
#darkvision 75
#mountainsurvival
#poisonres 25
#okleader
#nomagicleader
#noundeadleader
#older -10
#maxage 250
#nametype 149
#end

#newmonster 2802
#name "Dwarf Hurler"
#spr1 "./underkings/recruit_thrower1.tga"
#spr2 "./underkings/recruit_thrower2.tga"
#descr "The axe holds a special place in dwarven society and it is as common among the military class as swords are in other nations.  Some dwarves are more dextrous than others and have honed the art of throwing axes.  Possessing  well-balanced keen axes they can throw with frightening accuracy and gruesome results, and are considered a step above militia."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 3
#att 9
#def 7
#prec 10
#mr 11
#mor 10
#gcost 12
#rcost 3
#weapon "Dwarven Throwing Axe"
#weapon "Hatchet"
#weapon "Hatchet"
#armor "Leather Hauberk"
#darkvision 75
#mountainsurvival
#poisonres 25
#ambidextrous 1
#okleader
#nomagicleader
#noundeadleader
#older 10
#maxage 250
#nametype 149
#end

#newmonster 2803
#name "Clansdwarf"
#spr1 "./underkings/recruit_doubleaxe1.tga"
#spr2 "./underkings/recruit_doubleaxe2.tga"
#descr "Small mountain ranges and isolated peaks are often home to minor dwarven clans.  Although the blood of the Underkings does not flow in the veins of these clansmen, they are still haughty warriors.  Now bound to the new order, the distant clans have sent their own fighters to do battle, and if necessary, to die for the Underkings."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 2
#att 11
#def 9
#prec 9
#mr 11
#mor 12
#gcost 15
#rcost 3
#weapon "Battleaxe"
#armor "Furs"
#darkvision 75
#mountainsurvival
#poisonres 25
#okleader
#nomagicleader
#noundeadleader
#maxage 250
#nametype 149
#end

#newmonster 2804
#name "Clansdwarf"
#spr1 "./underkings/recruit_twoaxes1.tga"
#spr2 "./underkings/recruit_twoaxes2.tga"
#descr "Small mountain ranges and isolated peaks are often home to minor dwarven clans.  Although the blood of the Underkings does not flow in the veins of these clansmen, they are still haughty warriors.  Now bound to the new order, the distant clans have sent their own fighters to do battle, and if necessary, to die for the Underkings."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 2
#att 11
#def 9
#prec 9
#mr 11
#mor 12
#gcost 15
#rcost 3
#weapon "Axe"
#weapon "Axe"
#armor "Furs"
#darkvision 75
#mountainsurvival
#poisonres 25
#ambidextrous 2
#okleader
#nomagicleader
#noundeadleader
#maxage 250
#nametype 149
#end

#newmonster 2805
#name "Woad Raider"
#spr1 "./underkings/recruit_woad1.tga"
#spr2 "./underkings/recruit_woad2.tga"
#descr "Some dwarven clans come from hills that stand above vast swamps.  In the murky darkness of these marshes can be found woad, a magical illuminating substance that hardens when applied to skin and can protect against both weapons and magic.  Dwarves from these regions are known for their ferocity and fearlessness."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 2
#att 11
#def 9
#prec 9
#mr 14
#mor 16
#gcost 18
#rcost 3
#weapon "Battleaxe"
#weapon "Dwarven Throwing Axe"
#armor "Woad"
#darkvision 75
#forestsurvival
#mountainsurvival
#swampsurvival
#poisonres 25
#berserk 4
#okleader
#nomagicleader
#noundeadleader
#older -10
#maxage 250
#nametype 149
#end

#newmonster 2806
#name "Dwarf Warrior"
#spr1 "./underkings/recruit_axeman1.tga"
#spr2 "./underkings/recruit_axeman2.tga"
#descr "The military class of dwarven society is vast and varied.  The youngest, least experience warriors often find themselves at the very front of the line.  These warriors are armed with axes or hammers and wear heavy chain mail armor over their entire bodies.  They are stronger and more reliable than militia or clansmen."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 12
#enc 2
#att 11
#def 9
#prec 9
#mr 11
#mor 13
#gcost 18
#rcost 3
#weapon "Axe"
#armor "Half Helmet"
#armor "Chain Mail Hauberk"
#armor "Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#okleader
#nomagicleader
#noundeadleader
#older -5
#maxage 250
#nametype 149
#end

#newmonster 2807
#name "Dwarf Warrior"
#spr1 "./underkings/recruit_hammer1.tga"
#spr2 "./underkings/recruit_hammer2.tga"
#descr "The military class of dwarven society is vast and varied.  The youngest, least experience warriors often find themselves at the very front of the line.  These warriors are armed with axes or hammers and wear heavy chain mail armor over their entire bodies.  They are stronger and more reliable than militia or clansmen."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 12
#enc 2
#att 11
#def 9
#prec 9
#mr 11
#mor 13
#gcost 18
#rcost 3
#weapon "Hammer"
#armor "Half Helmet"
#armor "Chain Mail Hauberk"
#armor "Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#okleader
#nomagicleader
#noundeadleader
#older -5
#maxage 250
#nametype 149
#end

#newmonster 2808
#name "Highborn"
#spr1 "./underkings/recruit_axeplate1.tga"
#spr2 "./underkings/recruit_axeplate2.tga"
#descr "Within the mountain halls of the Underkings, those Dwarves born to noble or ruling clans are able to equip themselves with superior armor, and are able to devote more of their time to the military arts.  Possessing a lineage with ancestors who are great warriors and legendary craftsmen, they are treated with respect by other Dwarves.  However, Dwarven Highborn have greater responsibility and must prove themselves in battle year after year."
#ap 11
#mapmove 1
#hp 12
#prot 2
#size 1
#str 12
#enc 2
#att 12
#def 10
#prec 9
#mr 11
#mor 14
#gcost 22
#rcost 3
#weapon "Axe"
#armor "Half Helmet"
#armor "Plate Hauberk"
#armor "Tower Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#castledef 1
#okleader
#nomagicleader
#noundeadleader
#older 30
#maxage 250
#nametype 149
#end

#newmonster 2809
#name "Highborn"
#spr1 "./underkings/recruit_hammerplate1.tga"
#spr2 "./underkings/recruit_hammerplate2.tga"
#descr "Within the mountain halls of the Underkings, those Dwarves born to noble or ruling clans are able to equip themselves with superior armor, and are able to devote more of their time to the military arts.  Possessing a lineage with ancestors who are great warriors and legendary craftsmen, they are treated with respect by other Dwarves.  However, Dwarven Highborn have greater responsibility and must prove themselves in battle year after year."
#ap 11
#mapmove 1
#hp 12
#prot 2
#size 1
#str 12
#enc 2
#att 12
#def 10
#prec 9
#mr 11
#mor 14
#gcost 22
#rcost 3
#weapon "Hammer"
#armor "Half Helmet"
#armor "Plate Hauberk"
#armor "Tower Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#castledef 1
#okleader
#nomagicleader
#noundeadleader
#older 30
#maxage 250
#nametype 149
#end

#newmonster 2810
#name "Royal Guard"
#spr1 "./underkings/recruit_greathammersacred1.tga"
#spr2 "./underkings/recruit_greathammersacred2.tga"
#descr "Elite companions to the Underkings and Princes, they join their lieges in battle.  The Royal Guard are hardened veteran fighters of many campaigns and are equipped with enchanted hammers.  They are often used to guard entrances to the deep halls, defend key strongholds, and used as shocktroopers to break strong enemy formations."
#ap 11
#mapmove 1
#hp 13
#prot 2
#size 1
#str 13
#enc 2
#att 13
#def 11
#prec 9
#mr 11
#mor 16
#gcost 30
#rcost 8
#weapon "Dwarven Maul"
#armor "Full Helmet"
#armor "Full Plate Mail"
#darkvision 75
#mountainsurvival
#poisonres 25
#castledef 2
#okleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2811
#name "Royal Guard"
#spr1 "./underkings/recruit_hammersacred1.tga"
#spr2 "./underkings/recruit_hammersacred2.tga"
#descr "Elite companions to the Underkings and Princes, they join their lieges in battle.  The Royal Guard are hardened veteran fighters of many campaigns and are equipped with enchanted hammers.  They are often used to guard entrances to the deep halls, defend key strongholds, and used as shocktroopers to break strong enemy formations."
#ap 11
#mapmove 1
#hp 13
#prot 2
#size 1
#str 13
#enc 2
#att 13
#def 11
#prec 9
#mr 11
#mor 16
#gcost 30
#rcost 9
#weapon "Dwarven Hammer"
#armor "Full Helmet"
#armor "Full Plate Mail"
#armor "Tower Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#castledef 2
#okleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2812
#name "Rune Paladin"
#spr1 "./underkings/hero_paladin1.tga"
#spr2 "./underkings/hero_paladin2.tga"
#descr "The ancient runic faith still has great influence in dwarven society.  Great warriors sometimes dedicated themselves to the Rune Priests seeking an opportunity to show their piety.  In return, they are blessed with the power of the runes: health, strength, endurance, and resistance to magic.  Rune paladins are sacred and wield holy axes enchanted by Runepriests.  They are able call upon their own limited magical abilities to brand enemies at a distance by creating a magical rune on their opponents body."
#ap 11
#mapmove 1
#hp 14
#prot 2
#size 1
#str 14
#enc 2
#att 14
#def 12
#prec 10
#mr 15
#mor 16
#gcost 100
#rcost 4
#weapon "Runed Greataxe"
#weapon "Brand of Earth"
#armor "Full Helmet"
#armor "Full Plate Mail"
#darkvision 75
#mountainsurvival
#poisonres 25
#holy
#reinvigoration 2
#goodleader
#nomagicleader
#noundeadleader
#older 40
#maxage 250
#nametype 149
#end

#newmonster 2813
#name "Helmsfire Paladin"
#spr1 "./underkings/hero_firepaladin1.tga"
#spr2 "./underkings/hero_firepaladin4.tga"
#descr "One sect of dwarven society worships a great fire believed to live in the very heart of the earth.  The helmsfire gives power to an order of priests and warriors that are among the strongest of dwarves.  Paladins of this order have been granted total immunity from fire and are aggressive fighters who always charge quickly into battle.  Helmsfire paladins are sacred and wield flaming axes enchanted by Helmsfire Keepers.  They are able call upon their own limited magical abilities to brand enemies at a distance by creating a magical rune on their opponents body."
#ap 13
#mapmove 1
#hp 14
#prot 2
#size 1
#str 14
#enc 2
#att 14
#def 12
#prec 10
#mr 14
#mor 18
#gcost 100
#rcost 4
#weapon "Helmsfire Greataxe"
#weapon "Brand of Fire"
#armor "Full Helmet"
#armor "Full Plate Mail"
#darkvision 75
#mountainsurvival
#poisonres 25
#holy
#fireres 100
#goodleader
#nomagicleader
#noundeadleader
#older 40
#maxage 250
#nametype 149
#end

#newmonster 2814
#name "Bolt Thrower"
#spr1 "./underkings/recruit_ballista1.tga"
#spr2 "./underkings/recruit_ballista2.tga"
#descr "Dwarves love machines.  In particular, they love machines that are large, complicated, and cause things to be destroyed.  The dwarven bolt thrower is a fine example of such a machine.  It is essentially a giant crossbow that hurls a huge steel-tipped bolt across the battlefield that will impale and severely damage whatever it strikes.  Those near to where the bolt lands learn to fear the bolt thrower.  While the machine is useful in both offense and defense, it is heavy and hard to move quickly.  The most vulnerable part of the machine is the operator, and if the operator is seriously wounded or killed he is replaced."
#ap 8
#mapmove 1
#hp 12
#prot 6
#size 3
#str 11
#enc 2
#att 11
#def 9
#prec 12
#mr 11
#mor 12
#gcost 40
#rcost 74
#weapon "Hatchet"
#weapon 798
#armor "Tower Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#siegebonus 4
#castledef 4
#heal
#secondshape 2829
#noleader
#nomagicleader
#noundeadleader
#maxage 250
#nametype 149
#end

#newmonster 2815
#name "Dwarf Miner"
#spr1 "./underkings/recruit_miner1.tga"
#spr2 "./underkings/recruit_miner2.tga"
#descr "Mining is focal to dwarven industry.  Many commoners are professional miners working for foremen in exchange for a share of a mine's production in precious metals and a steady supply of ale.  Although relatively poor as warriors, dwarven miners can tunnel beneath enemy fortifications and are a great advantage in a siege."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 12
#enc 3
#att 9
#def 8
#prec 9
#mr 11
#mor 10
#gcost 18
#rcost 3
#weapon "Dwarven Pickaxe"
#weapon "Dwarven Pickaxe"
#armor "Leather Cuirass"
#darkvision 75
#mountainsurvival
#poisonres 25
#ambidextrous 2
#siegebonus 6
#poorleader
#nomagicleader
#noundeadleader
#older -25
#maxage 250
#nametype 149
#end

#newmonster 2816
#name "Dwarf Pathfinder"
#spr1 "./underkings/commander_scout1.tga"
#spr2 "./underkings/commander_scout2.tga"
#descr "The Pathfinder Dwarf is a hardy sort who operates independent of other dwarves.  Though traditionally employed underground exploring passages, noting denizens, locations of water, and mineral deposits; they can work almost as well aboveground.  Some of the more unorthodox pathfinders will work directly for clan lords and underkings, employing their personal skills in silence and exploration to move undetected in foreign realms.  Pathfinders are singlehandedly able to construct small boats and rafts, and thus able to sail on lakes below or aboveground as the need arises."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 12
#enc 2
#att 11
#def 9
#prec 9
#mr 11
#mor 12
#gcost 30
#rcost 3
#weapon "Axe"
#weapon "Dwarven Throwing Axe"
#armor "Dashing Hat"
#armor "Leather Cuirass"
#darkvision 75
#mountainsurvival
#poisonres 25
#sailing
#stealthy 10
#noleader
#nomagicleader
#noundeadleader
#older -25
#maxage 250
#nametype 149
#end

#newmonster 2817
#name "Dwarf Chief"
#spr1 "./underkings/commander_axeman1.tga"
#spr2 "./underkings/commander_axeman2.tga"
#descr "The lowest tier of Dwarven military hierarchy are the Chiefs.  Though not of noble blood, they possess some tactical and leadership abilities, and thus command warriors and militia forces.  Chiefs are slightly tougher than the troops they command, but are similarly equipped."
#ap 11
#mapmove 2
#hp 14
#prot 2
#size 1
#str 12
#enc 2
#att 12
#def 10
#prec 9
#mr 11
#mor 12
#gcost 35
#rcost 3
#weapon "Axe"
#armor "Half Helmet"
#armor "Chain Mail Hauberk"
#armor "Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#okleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2818
#name "Dwarf Captain"
#spr1 "./underkings/commander_hammer1.tga"
#spr2 "./underkings/commander_hammer2.tga"
#descr "Captains of the interior guards, the Dwarf Captains are noble-born, battle-hardened, and are equipped as Highborn.  They are stout warriors and capable leaders able to defend fortifications.  Dwarf Captains can command significant numbers of troops, and their presence instills calm and order in the province."
#ap 11
#mapmove 1
#hp 14
#prot 2
#size 1
#str 12
#enc 2
#att 13
#def 11
#prec 9
#mr 13
#mor 15
#gcost 60
#rcost 3
#weapon "Hammer"
#armor "Half Helmet"
#armor "Plate Hauberk"
#armor "Tower Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#castledef 3
#incunrest -1
#goodleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2819
#name "Dwarf Lord"
#spr1 "./underkings/commander_lord1.tga"
#spr2 "./underkings/commander_lord2.tga"
#descr "Princes of the halls, the Dwarf lords are proud and awesome generals, able to rally troops with their mere presence.  Devoting much of their time to art of warfare, they are highly skilled soldiers and possess significant knowledge of fortifications and defensive tactics.  They personally oversee the Royal Guard and are equipped with the heavy plate mail armor of that force.  Their presence instills calm and order in the province."
#ap 11
#mapmove 1
#hp 18
#prot 2
#size 1
#str 14
#enc 2
#att 14
#def 12
#prec 10
#mr 15
#mor 18
#gcost 90
#rcost 3
#weapon "Dwarven Pickaxe"
#armor "Full Helmet"
#armor "Full Plate Mail"
#armor "Tower Shield"
#darkvision 75
#mountainsurvival
#poisonres 25
#standard 10
#castledef 5
#incunrest -2
#expertleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2820
#name "Rune Priest"
#spr1 "./underkings/commander_priest1.tga"
#spr2 "./underkings/commander_priest2.tga"
#descr "Rune Priests are the leaders of the ancient runic cult.  They have extensive knowledge of magical runes and are good Earth mages.  These mage-priests craft magic items and imbue them with power by inscribing runes on their surface.  This magic helps reduce the cost of forging.  Rune Priests maintain the lore and traditions of the Dwarven Kingdoms, and through their extensive libraries are able to perform research more easily.  They are able to assign Templeguards to protect certain locations."
#ap 11
#mapmove 1
#hp 14
#prot 2
#size 1
#str 11
#enc 2
#att 11
#def 9
#prec 11
#mr 16
#mor 14
#gcost 250
#rcost 3
#weapon "Dwarven Hammer"
#armor "Full Helmet"
#armor "Robes"
#darkvision 75
#mountainsurvival
#poisonres 25
#magicskill 3 2
#magicskill 8 2
#custommagic 1024 10
#custommagic 5504 20
#forgebonus 20
#researchbonus 2
#makemonster1 2836
#holy
#okleader
#nomagicleader
#noundeadleader
#older 10
#maxage 250
#nametype 149
#end

#newmonster 2821
#name "Helmsfire Keeper"
#spr1 "./underkings/commander_keeper1.tga"
#spr2 "./underkings/commander_keeper2.tga"
#descr "Leaders of the temple of helmsfire, these keepers are adept mage-priests with skill in both Fire and Earth magic.  Their following grants them total immunity to fire. Their spiritual and magical connection to fire lets them breathe life into flame which they send forth to consume and purify the enemies of the Underkings."
#ap 11
#mapmove 1
#hp 14
#prot 2
#size 1
#str 11
#enc 2
#att 11
#def 9
#prec 11
#mr 16
#mor 14
#gcost 250
#rcost 3
#weapon "Axe"
#armor "Half Helmet"
#armor "Robes"
#darkvision 75
#mountainsurvival
#poisonres 25
#magicskill 0 2
#magicskill 3 1
#magicskill 8 2
#custommagic 128 20
#custommagic 5504 10
#researchbonus 1
#holy
#fireres 100
#okleader
#nomagicleader
#noundeadleader
#older 10
#maxage 250
#nametype 149
#end

#newmonster 2822
#name "Mine Foreman"
#spr1 "./underkings/commander_foreman1.tga"
#spr2 "./underkings/commander_foreman2.tga"
#descr "Mining is focal to dwarven industry.  Many commoners are professional miners working for foremen in exchange for a share of a mine's production in precious metals and a steady supply of ale.  Mine foremen can make a tremendous difference in any sapping effort.  Their knowledge of digging techniques is invaluable in bringing down enemy fortifications."
#ap 11
#mapmove 2
#hp 12
#prot 2
#size 1
#str 11
#enc 3
#att 9
#def 8
#prec 9
#mr 11
#mor 12
#gcost 50
#rcost 3
#weapon "Dwarven Pickaxe"
#armor "Dashing Hat"
#armor "Leather Cuirass"
#darkvision 75
#mountainsurvival
#poisonres 25
#ambidextrous 2
#siegebonus 20
#poorleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2823
#name "Stone King"
#spr1 "./underkings/pretender_stone.tga"
#spr2 "./underkings/pretender_stone.tga"
#descr "The spirit of an ancient dwarven king inhabits this grand statue representing him during a moment of triumph over a hated foe.  Winged, clad in ornate plate, and with axe raised to the heavens in victory, this image commands obedience from dwarves.  Rune Priests covet this statue as the holiest of relics and channel the spirit of the dead king to deliver his will to the people and to carry out divine acts.  The statue is immovable and stands in the inner sanctum of the Underkings.  It has a powerful dominion and can gain great magical power as well.  If touched or approached by the unfaithful, the statue will drain the offender's life force."
#ap 2
#mapmove 0
#hp 50
#prot 25
#size 3
#str 15
#enc 0
#att 5
#def 0
#prec 10
#mr 18
#mor 30
#gcost 0
#rcost 0
#weapon "Soul Leech"
#itemslots 61440
#inanimate
#poisonres 100
#blind
#neednoteat
#startdom 4
#magicskill 3 1
#pathcost 40
#restrictedgod 76
#superiorleader
#nomagicleader
#noundeadleader
#maxage 2400
#nametype 149
#end

#newmonster 2824
#name "Underking"
#spr1 "./underkings/hero_king1.tga"
#spr2 "./underkings/hero_king2.tga"
#descr "The Underkings are dwarves of unparalleled strength, vigor, wisdom, and charisma.  Such a leader is the pinnacle of the nobility and supreme lord of the military class.  Underkings are clad in a hauberk of mithril and swing a huge enchanted battleaxe single-handedly.  They can command and rally large numbers of troops and are considered sacred.  Underkings sometimes attract Royal Guards in areas of strong dominion, and their presence instills calm and order in the province."
#ap 11
#mapmove 2
#hp 20
#prot 2
#size 1
#str 15
#enc 2
#att 16
#def 14
#prec 10
#mr 18
#mor 20
#gcost 1
#rcost 1
#weapon "Runed Greataxe"
#armor "Full Helmet"
#armor "Mithril Hauberk"
#armor "Enchanted Shield"
#holy
#darkvision 75
#mountainsurvival
#poisonres 25
#onebattlespell "Fanaticism"
#standard 20
#siegebonus 5
#castledef 10
#incunrest -3
#domsummon20 2811
#expertleader
#poormagicleader
#noundeadleader
#itemslots 31878
#older 30
#maxage 350
#nametype 149
#end

#newmonster 2825
#copystats 1875
#clearmagic
#name "Brewmaster"
#spr1 "./underkings/commander_brewmaster1.tga"
#spr2 "./underkings/commander_brewmaster2.tga"
#descr "Dwarves love alcohol, and those who brew it are both popular and respected.  Brewmasters are the exceptional professionals and artists of their craft, able to make alcohol for any occasion, and with various unusual and extraordinary properties.  A pint of Pathfinder Mead can satisfy any apetite for a whole day.  Seven Barrel Brew is reputed to cure what ails you, if you drink enough of it.  Rustfire Whisky though bearing a taste halfway between rust and a burning coal, is particularly popular with dwarven soldiers, as one who quaffs it before a battle will enjoy a quick boost of speed.  After more than a century of tasting various brews, they are immune to negative effects of alcohol and poisons.  Though of limited martial value, Brewmasters are useful for any Dwarven expedition of significance, and any province is considered lucky to have a Brewmaster reside there.  Due to increased inebriation surrounding Brewmasters, the local faith as well as unrest tends to be decreased."
#ap 11
#mapmove 2
#hp 14
#prot 2
#size 1
#str 12
#enc 2
#att 12
#def 10
#prec 9
#mr 11
#mor 12
#gcost 120
#rcost 3
#weapon "Club"
#armor "Dashing Hat"
#armor "Leather Hauberk"
#darkvision 75
#mountainsurvival
#poisonres 100
#standard 15
#supplybonus 20
#healer 15
#nobadevents 3
#incunrest -10
#onebattlespell "Haste"
#noleader
#nomagicleader
#noundeadleader
#older 50
#maxage 250
#nametype 149
#end

#newmonster 2826
#name "Rune Acolyte"
#spr1 "./underkings/commander_acolyte1.tga"
#spr2 "./underkings/commander_acolyte2.tga"
#descr "Rune Acolytes are the lesser and younger priests of the ancient runic cult.  They have some knowledge of magical runes and know some Earth magic.  These mage-priests are learning to craft magic items and imbue them with power by inscribing runes on their surface.  This magic helps slightly reduce the cost of forging."
#ap 11
#mapmove 2
#hp 14
#prot 2
#size 1
#str 11
#enc 2
#att 10
#def 10
#prec 12
#mr 15
#mor 14
#gcost 120
#rcost 3
#weapon "Dwarven Hammer"
#armor "Full Helmet"
#armor "Robes"
#darkvision 75
#mountainsurvival
#poisonres 25
#magicskill 3 1
#magicskill 8 1
#forgebonus 10
#researchbonus 1
#holy
#okleader
#nomagicleader
#noundeadleader
#older -15
#maxage 250
#nametype 149
#end

#newmonster 2827
#name "King of the Ravens"
#spr1 "./underkings/hero_raven1.tga"
#spr2 "./underkings/hero_raven2.tga"
#descr "The King of the Ravens has come out of hiding and seclusion to help the cause of the Underkings.  There were once many Kings, but now just one remains.  He is a giant, highly intelligent, and magnificent example of his species, and commands respect of most animals.  He casts no shadow and has the ability to go unseen except by the most observant.  He possesses some minor skill in air magic and can call upon other ravens to spy upon distant lands."
#ap 6
#mapmove 3
#hp 12
#prot 0
#size 2
#str 8
#enc 2
#att 12
#def 12
#prec 14
#mr 12
#mor 14
#gcost 1
#rcost 1
#weapon "Claw"
#weapon "Beak"
#darkvision 50
#forestsurvival
#mountainsurvival
#animal
#animalawe 5
#flying
#magicskill 1 1
#gemprod 1 1
#stealthy 50
#researchbonus 2
#spy
#itemslots 28672
#patrolbonus 20
#okleader
#nomagicleader
#noundeadleader
#maxage 120
#nametype 149
#end

#newmonster 2828
#name "Geomancer"
#spr1 "./underkings/hero_geomancer1.tga"
#spr2 "./underkings/hero_geomancer2.tga"
#descr "The Geomancer is a Dwarf greatly skilled in earth magic who has learned to draw great strength and power simply from being in contact with the earth.  His skin is rock hard, and it seems as if the very earth around him obeys his will."
#ap 11
#mapmove 1
#hp 14
#prot 12
#size 1
#str 15
#enc 2
#att 11
#def 9
#prec 10
#mr 17
#mor 14
#gcost 1
#rcost 1
#weapon "Dwarven Hammer"
#armor "Full Helmet"
#armor "Robes"
#darkvision 75
#mountainsurvival
#poisonres 25
#magicskill 3 3
#gemprod 3 1
#onebattlespell "Summon Lesser Earth Elemental"
#reinvigoration 4
#okleader
#nomagicleader
#noundeadleader
#older 20
#maxage 350
#nametype 149
#end

#newmonster 2829
#name "Abandoned Bolt Thrower"
#spr1 "./underkings/recruit_ballista3.tga"
#spr2 "./underkings/recruit_ballista3.tga"
#descr "The Dwarves that operate this machine are most likely dead, and this machine is currently nonfunctioning. If this machine can be recovered by the dwarves after the battle, new operators will be found, and the machine repaired."
#ap 2
#mapmove 1
#hp 40
#prot 12
#size 3
#str 0
#enc 0
#att 0
#def 0
#prec 0
#mr 10
#mor 50
#gcost 60
#rcost 59
#firstshape 2814
#immobile
#inanimate
#blind
#neednoteat
#noitem
#coldres 50
#poisonres 100
#noleader
#nomagicleader
#noundeadleader
#maxage 250
#nametype 149
#end

#newmonster 2830
#name "Mechanical Dwarf"
#spr1 "./underkings/summon_mech1.tga"
#spr2 "./underkings/summon_mech2.tga"
#descr "A mechanical dwarven soldier in full plate armor, it's inner structure is rather fragile, but it's armor and shield make it almost invulnerable.  The iron dwarves are not affected by heat, cold, shock, or poison.  They are mindless, magical beings that will cease to function if left without magical leadership."
#ap 8
#mapmove 3
#hp 8
#prot 18
#size 1
#str 14
#enc 0
#att 12
#def 10
#prec 5
#mr 12
#mor 50
#gcost 0
#rcost 3
#weapon "Axe"
#armor "Tower Shield"
#magicbeing
#fireres 100
#coldres 100
#shockres 100
#poisonres 100
#pooramphibian
#neednoteat
#inanimate
#blind
#okleader
#poormagicleader
#noundeadleader
#startage 0
#maxage 800
#nametype 149
#end

#newmonster 2831
#name "Runic War Machine"
#spr1 "./underkings/summon_catapult1.tga"
#spr2 "./underkings/summon_catapult1.tga"
#descr "Doombringer requires a dwarven operator to function.  If recovered a new operator can be found, and if lost to the enemy, a new expedition will be required to retrieve it."
#ap 2
#mapmove 1
#hp 160
#prot 25
#size 6
#str 0
#enc 0
#att 0
#def 0
#prec 10
#mr 20
#mor 50
#gcost 0
#rcost 59
#magicbeing
#inanimate
#immobile
#blind
#neednoteat
#noitem
#coldres 50
#poisonres 100
#firstshape 2838
#noleader
#nomagicleader
#noundeadleader
#maxage 2500
#nametype 149
#end

#newmonster 2832
#name "Animated Stormhammer"
#spr1 "./underkings/summon_hammer3.tga"
#spr2 "./underkings/summon_hammer4.tga"
#descr "A large animated warhammer that floats through dwarven magic.  It is difficult to hit, and difficult to damage.  It is enchanted to unleash a bolt of lightning whenever it strikes.  It must be commanded by a mage."
#ap 8
#mapmove 3
#hp 4
#prot 18
#size 1
#str 0
#enc 0
#att 16
#def 16
#prec 5
#mr 12
#mor 50
#gcost 0
#rcost 3
#weapon "Stormhammer"
#flying
#magicbeing
#fireres 100
#coldres 100
#shockres 100
#poisonres 100
#pooramphibian
#neednoteat
#inanimate
#blind
#noleader
#nomagicleader
#noundeadleader
#startage 0
#maxage 800
#nametype 149
#end

#newmonster 2833
#name "Battlerager"
#spr1 "./underkings/commander_rager1.tga"
#spr2 "./underkings/commander_rager2.tga"
#descr "The Battlerager is a powerful and fearless warrior, able to create an insane rage within himself which increases his fighting ability, bestows an unnatural endurance, and a strong resistance to magic.  They live and breath battle, and will always seek it out.  The only magic they care for is a trick of their devising, making vast quantities of alcohol dissapear.  Believed to be touched by an ancient Dwarven deity, Battleragers are held in awe by Dwarves, and with fear by their foes.  They believe that if killed in battle, they will return to the earth, only to be reborn with more power, and so are completely fearless.  They refuse to wear heavy armor, and sometimes lead small groups of Woad Raiders on nearly suicidal attacks."
#ap 11
#mapmove 2
#hp 16
#prot 2
#size 3
#str 14
#enc 1
#att 13
#def 10
#prec 9
#mr 18
#mor 30
#gcost 120
#rcost 3
#weapon "Battleaxe"
#weapon "Dwarven Throwing Axe"
#armor "Woad"
#holy
#onebattlespell "Quicken Self"
#fear 0
#supplybonus -3
#darkvision 75
#forestsurvival
#mountainsurvival
#swampsurvival
#poisonres 25
#berserk 10
#itemslots 14470
#poorleader
#nomagicleader
#noundeadleader
#older 15
#maxage 250
#nametype 149
#end

#newmonster 2834
#name "Battlemaster"
#spr1 "./underkings/battlemaster1.tga"
#spr2 "./underkings/battlemaster2.tga"
#descr "A Battlemaster is a massive suit of animated armor, which holds the soul of a dwarven hero.  Considered the most selfless act amongst Dwarves, a hero can choose to have his soul transferred to a giant enchanted suit of Mithril armor.  This can be done before or after death, but is much easier when the candidate is still alive.  The Battlemaster never eats nor sleeps, and is therefore extremely vigilant.  The newer ritual ensures that the suit requires less maintenance, and is no longer prone to losing control.  The suit is also more robust and durable, nearly immune to all magical attack, and can absorb lightning as energy and occasionally unleash it."
#ap 22
#mapmove 3
#hp 125
#prot 28
#size 6
#str 30
#enc 0
#att 18
#def 11
#prec 9
#mr 20
#mor 30
#gcost 75
#rcost 1
#weapon "Massive Mace"
#weapon "Lightning Strike"
#trample
#blind
#patrolbonus 10
#siegebonus 40
#inanimate
#neednoteat
#noheal
#magicbeing
#mountainsurvival
#shockres 100
#stormpower 2
#poisonres 100
#itemslots 28672
#noleader
#nomagicleader
#noundeadleader
#startage 0
#maxage 4000
#nametype 149
#end

#newmonster 2835
#copystats 1389
#name "Eternal Guardian"
#spr1 "./underkings/battlemaster1.tga"
#spr2 "./underkings/battlemaster2.tga"
#descr "A massive suit of animated armor, which holds the soul of a dwarven hero of ages past.  Considered the most selfless defender of the Dwarves, he managed to deal the deathblow to an evil dragon which nearly wiped out the last major dwarven enclave, but died from his wounds soon after.  After his death, the dwarven peoples mourned for many months, and it was decided that he would be brought back.  Dwarves tend to loathe necromancy and the undead, so a giant suit of mithril armor was forged, and enchanted to hold a soul.  When the soul was brought back it was transferred into the suit, and thus the first Battlemaster was made.  The Eternal Guardian never eats nor sleeps, and is therefore extremely vigilant.  He always patrols the Dwarven capital, and never strays from this duty."
#ap 22
#mapmove 0
#hp 85
#prot 25
#size 6
#str 24
#enc 0
#att 18
#def 11
#prec 9
#mr 18
#mor 30
#gcost 150
#rcost 1
#weapon "Massive Mace"
#armor "Nothing"
#armor "Nothing"
#armor "Nothing"
#trample
#blind
#patrolbonus 30
#inanimate
#neednoteat
#noheal
#magicbeing
#mountainsurvival
#poisonres 100
#itemslots 28672
#noleader
#nomagicleader
#noundeadleader
#maxage 4000
#nametype 149
#end

#newmonster 2836
#name "Templeguard"
#spr1 "./underkings/summon_templeguard3.tga"
#spr2 "./underkings/summon_templeguard4.tga"
#descr "A Templeguard is a female Dwarf who has received intensive military training.  Frequently a weapon specialist with a morningstar, she fights as well as, if not better than most males.  Though not found in all strongholds, Templeguards form an elite fighting force, dedicated to defending the stronghold and temple.  Once assigned to a temple or fortress, they may stay there for the rest of their lives, and they almost never break or run.  Their devotion gives them a sacred status amongst the Dwarves."
#ap 11
#mapmove 0
#hp 12
#prot 2
#size 1
#str 11
#enc 2
#att 13
#def 11
#prec 9
#mr 13
#mor 18
#gcost 15
#rcost 3
#weapon "Morningstar"
#armor "Full Helmet"
#armor "Full Plate Mail"
#armor "Tower Shield"
#holy
#female
#darkvision 75
#mountainsurvival
#poisonres 25
#castledef 2
#okleader
#nomagicleader
#noundeadleader
#older 30
#maxage 250
#nametype 149
#end

#newmonster 2838
#copystats 648
#clearmagic
#name "Runic War Machine"
#spr1 "./underkings/summon_catapult3.tga"
#spr2 "./underkings/summon_catapult4.tga"
#descr "Often greatly outnumbered in battle, dwarves rely on powerful war machines to even the odds.  In times of great need, a Rune Priest will dig into the archives and find the location of one of the great dwarven artifacts of power.  Once located, an expedition is sent out to retrieve it.
 Doombringer is one such artifact, an enormous wooden and iron catapult enchanted with runes to move, create ammo, and fire.  While useless underground, above ground it can rain destruction from afar.  It launches two boulders, set alight, which explode with flaming shrapnel.  The Doombringer requires a skilled Dwarven operator to function.  While the machine is essentially indestructible the operator is physically vulnerable, and if killed the machine will lie inert until a new operator takes control.  It will not respond to non-dwarven beings, and if the machine is lost to the enemy, another expedition will be required to retrieve it."
#ap 6
#mapmove 1
#hp 12
#prot 8
#size 6
#str 12
#enc 2
#att 12
#def 10
#prec 12
#mr 20
#mor 30
#gcost 0
#rcost 1
#weapon "Hatchet"
#weapon "Flaming Boulder"
#weapon "Flaming Boulder"
#armor "Dashing Hat"
#armor "Leather Hauberk"
#armor "Tower Shield"
#siegebonus 50
#castledef 15
#fireres 0
#regeneration 1
#heal
#mountainsurvival
#neednoteat
#noitem
#darkvision 75
#poisonres 25
#secondshape 2831
#noleader
#nomagicleader
#noundeadleader
#maxage 250
#nametype 148
#end

#newmonster 2840
#name "Loremaster"
#spr1 "./underkings/pretender_loremaster1.tga"
#spr2 "./underkings/pretender_loremaster2.tga"
#descr "Centuries ago, there were many loremasters, but they grew far too avaricious in seeking and hoarding knowledge.  When the previous Pantokrator found out that the Dwarves were trying to contact their ancestors to find out how he came to power, he cursed all the loremasters.  From then on, they were continously haunted by their dead ancestors, and never given a moments rest.  All of them were slowly driven insane, and the loremaster order disbanded and died out, all but one.  One was able to figure out what the ancestors were trying to communicate, and eventually learned many secrets.  Though physically frail, the last Loremaster is a mage and scholar of great power.  He is continually haunted, guided, and protected by ancestor spirits of Dwarves which sometimes manifest as corpse candles.  The Loremaster is no longer completely of this world."
#ap 11
#mapmove 1
#hp 15
#prot 2
#size 1
#str 15
#enc 2
#att 10
#def 8
#prec 10
#mr 18
#mor 30
#gcost 75
#rcost 0
#weapon "Magic Staff"
#weapon "Spirit Strike"
#armor "Crown"
#armor "Robes"
#startdom 1
#magicskill 3 1
#magicskill 4 1
#pathcost 40
#ethereal
#onebattlespell "Corpse Candle"
#darkvision 75
#mountainsurvival
#poisonres 25
#researchbonus 8
#itemslots 31878
#restrictedgod 76
#superiorleader
#nomagicleader
#noundeadleader
#older 200
#maxage 500
#nametype 149
#end


#newmonster 2841
#name "Son of Mimir"
#spr1 "./underkings/pretender_mimir1.tga"
#spr2 "./underkings/pretender_mimir2.tga"
#descr "The Son of Mimir is an ancient stone giant of great power related to the Bergrisar, and whose body has the hardness and durability of resilient stone.  He has learned magic, wisdom, and other secrets from his father, whose death came at the hands of the Vanir.  He seeks vengeance against the them, and despises the evil nature of the Jotuns.  He bears the Gjallarhorn, which he drinks from before every battle.  This gives him preternatural knowledge of events to come and allows him to avoid misfortunes and attacks.  He has foreseen the fall of the Pantokrator and now possesses the strength and wisdom to lead the Dwarves and ascend to godhood."
#ap 16
#mapmove 3
#hp 125
#prot 15
#size 6
#str 28
#enc 2
#att 14
#def 14
#prec 12
#mr 18
#mor 30
#gcost 120
#rcost 0
#weapon "Dwarven Hammer"
#armor "Half Helmet"
#armor "Chain Mail Cuirass"
#armor "Enchanted Shield"
#onebattlespell "Personal Luck"
#startdom 2
#magicskill 3 1
#pathcost 50
#itemslots 31878
#darkvision 100
#mountainsurvival
#poisonres 100
#nobadevents 25
#restrictedgod 76
#superiorleader
#nomagicleader
#noundeadleader
#maxage 1000
#nametype 149
#end


-- SITE DATA

#newsite 850
#name "Halls of the Underkings"
#path 3
#level 2
#rarity 5
#gems 3 2
#gems 0 1
#homemon 2812
#homecom 2820
#end

#newsite 851
#name "Helmsfire Order House"
#path 0
#level 2
#rarity 5
#homemon 2813
#homecom 2821
#end

-- NATION DATA
#selectnation 76
#guiframe "./underkings/underkings_gui.tga"
#name "Underheim"
#epithet "Rise of the Underkings"
#era 2
#descr "Hidden in the rough face of great cliffs and disguised as bare rock are the gates into the earth carved by an ancient race.  Beneath the great mountain ranges reside the proud and stout dwarves, a race of short, stocky beings hewn from rock during the making of the world.  They have a great love of things made and cherish a rich tradition of construction and engineering.  Dwarves are potent warriors as well, being much tougher than humans and often just as cunning.  In these days the dwarven clans have come together under the rulership of a noble council of lords, the Underkings.  The council serves the will of a god who has come to place dwarvenkind in its rightful spot, at the pinnacle of the world."
#summary "* Race: Dwarves - small, tough humanoids

* Military: Dwarven medium and heavy infantry, holy paladins, ballistas and constructs

* Magic: Fire, Earth with Strong Forging

* Priests: Moderate"
#brief "The realm within the mountains is ruled by a council of hereditary monarchs, the Underkings.  From their halls deep within the caverns of the earth, dwarves march for war clad in gleaming plate mail and wielding keen-edged axes.  The Underkings bring heavy infantry and potent siege weapons to bear on the battlefield."
#flag "./underkings/underkings_icon.tga"
#color 0.88 0.67 0.04

#clearrec
#addrecunit 2800	-- Dwarf Militia
#addrecunit 2802	-- Dwarf Hurler
#addrecunit 2801	-- Dwarf Crossbowman
--addrecunit 2803	-- Clansdwarf
#addrecunit 2804	-- Clansdwarf
#addrecunit 2805	-- Woad Warrior
#addrecunit 2806	-- Dwarf Warrior
#addrecunit 2807	-- Dwarf Warrior
--addrecunit 2808	-- Highborn
#addrecunit 2809	-- Highborn
#addrecunit 2810	-- Royal Guard
#addrecunit 2811	-- Royal Guard
#addrecunit 2815	-- Dwarf Miner
#addrecunit 2814	-- Bolt Thrower
--addrecunit 2830	-- Mechanical Dwarf
--addrecunit 2831	-- Abandoned Runic War Machine
--addrecunit 2832	-- Animated Stormhammer
--addrecunit 2812	-- Rune Paladin
--addrecunit 2813	-- Helmsfire Paladin
--addrecunit 2836	-- Templeguard
--addrecunit 2838	-- Doombringer


#addreccom 2816		-- Dwarf Pathfinder
#addreccom 2817		-- Dwarf Chief
#addreccom 2818		-- Stone Chief
#addreccom 2819		-- Dwarf Lord
#addreccom 2825		-- Brewmaster
#addreccom 2822		-- Mine Foreman
--addreccom 2833	-- Battlerager
#addreccom 2826		-- Rune Acolyte
--addreccom 2820	-- Rune Priest
--addreccom 2821	-- Helmsfire Keeper
--addreccom 2827
--addreccom 2828		
--addreccom 2824	
--addreccom 2834		
--addreccom 2835
--addreccom 2840
--addreccom 2841

#hero1 2827		-- King of the Ravens
#hero2 2824		-- Underking
#multihero1 2824	-- Underking
#multihero2 2828	-- Geomancer

#defcom1 2817		-- Dwarf chief
#defcom2 2826		-- Rune Acolyte
#defunit1 2800		-- Dwarf Militia
#defunit1b 2802		-- Dwarf Hurler
#defunit2 2801		-- Dwarf Crossbowman
#defunit2b 2814		-- Bolt Thrower
#defmult1 10
#defmult1b 10
#defmult2 15
#defmult2b 2

#startcom 2835
#startscout 2816

#castleprod 25

#startfort 42		-- Mountain City
#defaultfort 40		-- Fortress
#farmfort 41		-- Castle
#mountainfort 42	-- Mountain City
#forestfort 34		-- Forest Fortress
#swampfort 11		-- Swamp Fort

#templepic 7

#clearsites
#startsite "Halls of the Underkings"
#startsite "Helmsfire Order House"
#startsite "Ancient Forge"
#end