#!/usr/bin/python

# addProvinceNo.py
# by jagdpanther
#
# expanded on mapfix.py  by MaxWilson
#   my version also handles maps without #landname lines
# 
# terrain type numbers from Simple Dominions 3 Terrain Calculator  by Ballbarian
#
# provence names from dom3 executable
#		note:  feel free to add to these name files
#
# set tab spacing to 3  
#
# $Id: addProvinceNo.py,v 1.1 2008/05/26 05:02:12 richard Exp $
#

terrainTypesRawLi=['edgemount', 'priest', 'blood', 'nature', 'death', 'astral', \
	'earth', 'water', 'air', 'fire', 'cave', 'deep', 'manysites', 'nostart', \
	'farm', 'forest', 'waste', 'swamp', 'mountain', 'somewater', 'sea', 'large', 'small']
	# terrainTypes are only used if there is no #landname line in the dom3 .map file
	#   I want to try to put the proper type of name on a provence
	#   I use:  cave, sea, mountain, swamp, waste, forest  for naming

terrainTypesLi = [] 		# list of list of <terrain type> numbers and corresponding text names
namesDi = {}				# dictionary of porvence names by terrain type
landnameDi = {}			# dictionary of existing #landname values from mapfile 
								   #  {<terrain number as a string> : '<"name">'

def defineTerrain():
	global terrainTypesLi
	p = 22					# power of 2
	for terrain in terrainTypesRawLi:
		terrainTypesLi.append( [2 ** p, terrain] )
		p -= 1

def loadnames():
	global namesDi
	namesDi['cave']     = open('addProvinceNo-cave.txt', 'r').readlines()
	namesDi['forest']   = open('addProvinceNo-forest.txt', 'r').readlines()
	namesDi['mountain'] = open('addProvinceNo-mountain.txt', 'r').readlines()
	namesDi['plain']    = open('addProvinceNo-plain.txt', 'r').readlines()
	namesDi['sea']      = open('addProvinceNo-sea.txt', 'r').readlines()
	namesDi['swamp']    = open('addProvinceNo-swamp.txt', 'r').readlines()
	namesDi['waste']    = open('addProvinceNo-waste.txt', 'r').readlines()

def landnameDiLoad(filename):
	global landnameLi
	for line in open(filename, 'r').readlines():
		line = line.strip()
		if line[0:9] == '#landname':
			landnameDi[line.split(' ', 2)[1]] = line.split(' ', 2)[2] 

def getType(provTerrain):
	provLi = []
	for terrain in terrainTypesLi:
		if provTerrain >= terrain[0]:	# we have a hit
			provTerrain -= terrain[0]
			provLi.append(terrain[1])
	if provTerrain:
		print "***** ERROR ****"
		print "  #terrain type was too large"
		print "  provTerrain still contains %d" % (provTerrain)
		sys.exit(2)
	# print "--  %s" % provLi
	if provLi.count('sea'):	# in priority order
		return('sea')
	if provLi.count('cave'):
		return('cave')
	if provLi.count('waste'):
		return('waste')
	if provLi.count('swamp'):
		return('swamp')
	if provLi.count('mountain'):
		return('mountain')
	if provLi.count('forest'):
		return('forest')
	return('plain')

def main():
	if len(sys.argv) != 2 or sys.argv[1] == '-h' or sys.argv[1] == '-help' \
			or sys.argv[1] == '--help':
		print "Usage: addProvinceNo.py <filename>"
		sys.exit(1)
	filename = sys.argv[1]
	defineTerrain()				# assign terrain values and create terrainTypesLi
	loadnames()						# create namesDi dictionary with provence names for maps without landnames
	landnameDiLoad(filename)	# createlandnameDi -- dictionary of existing (if any) #landname lines 
	for line in open(filename, 'r').readlines():
		line = line.strip()
		if line[0:9] == '#landname':
			continue					# #landname statements are handeled below with their #terrain statement
		if line[0:10] == '#dom2title':	
			line = line + ' (annotated)'
		if line[0:8] ==  '#terrain':		# #terrain lines arn't modified ... do we need a #landname ?
			provNum = line.split(' ', 2)[1]		# province number as a string
			provTerrain = line.split(' ', 2)[2]	# terran type number from #terrain line
			if landnameDi.has_key(provNum):		# use existing #landname if it exists
				landnameLen = len(landnameDi[provNum])
				print '#landname ' + provNum + ' ' + \
						landnameDi[provNum][0:landnameLen - 1] + ' ' + provNum + \
						landnameDi[provNum][landnameLen -1]
			else:						# no #landname for this #terrain so create one
				terrainType = getType(int(provTerrain))
				print '#landname ' + provNum + ' "' + random.choice(namesDi[terrainType]).strip() + ' ' + provNum + '"'
		print line

if __name__ == "__main__": 
	import sys, random
	main()
