################################################################################
##   Mod Overview and Description
################################################################################
#modname "MYTHEOLOGY 2"
#version 2.05
#domversion 3.17
#icon "./mytheology/mytheology2.tga"

#description "32 new Pretenders including 24 brand new deities and eight Pretenders formally available only as Summons and a few new special monsters.  Also, a whole bunch of tested new spells.  

The new Pretenders include Carrion Lord (Caelum Late), Cthulu (Rlyeh - all) Desire (Middle Man), Toad Demon (CAbysia Late), Fallen Archangel (Marignon Late), Great Egg (Caelum all), Grim Reaper (Ermor All), Monkey King (Kailasa Early, Bandar Log Middle, Patala Late), Morpheus (Arcocephale Late), Pantokrator (All), Shah of Djinn and Ifreet (Marignon Middle), Teratos Rex (C'Tis Early), Thunderbird (Caelum All), Black Dragon (all), Gold Dragon (all), Shadowcat (all), Father of Medicine (all), Great Eye (Earth/Water - all), Great Eye (Fire/Air - all), Great Eye (Astral - all), Menhir of Death (Ermor Early), Menhir of Growth (Marverni Early), Menhir of Courage (Marverni Early), Mother of Assassins (Machaka Middle).  Most of the new pretenders have custom graphics.

The summons Pretenders include Heliophagus (Abysia Late), King of Banefires (Yomi Early), King of Deeper Earth (Argatha Early), Queen of the Sea (Oceania Early), Queen of Thunder (Caelum Early), Tarrasque (New - Pangea Early), Yggdrasil (Maverni Early), Vastness (Ryleh Middle).

The new spells include Shards of Hastur (a large-area paralyze), Bind Toad Demon (self explanatory - an amphibious demon!), Feeding Frenzy (underwater equivalent of Swarm), Man O' War (underwater analogy to Raise Skeleton), Diabolic Brigade (Instant Army O' Imps), Trap Visitor (bind, or steal, the Void Gate Visitor), Banefire Veil (Death version of Dome of Flaming Death), Rite of Ashk'Ente (a souped-up Manifestation), Soul Harvest (farsummon 5 Grim Reapers), Aurora Warriors (Body Ethereal version of Fog Warriors), Soulblades (grants astral blades to some soldiers), Eclipse (farcast blindness on an enemy army), Foreboding (farcast the Battle Fright affliction on enemy troops), Storm of Acid (farcast Rusty Armor on enemy troops), Revelation (search for holy magic sites), Sanctuary (a temporary holy dome), Divine Judgement (a holy version of Flames from Afar), Sea of Scarabs (summon hundreds of beetles), Menhir of Fortune, Menhir of Courage, Menhir of Faith, Menhir of Growth, Menhir of Peace, Summon Wraith King (Nazgul!), Loki's Mirrors (battlefield glamours), Dirge of the Drowned Gods (battlefield-wide Sailor's Death), Aria Discordia (battlefield-wide confusion).

Version 2.03 updated 7/12/07"

################################################################################
##   Custom Armor for Pretenders 
################################################################################
-- all custom armors cause crashiness, I think it's a 3.08 patch error.


################################################################################
##   Custom Weapons for Pretenders 
################################################################################
-- T-bird's weapon
#newweapon 805
#name "Lightning Snake"
#att 4
#armornegating
#aoe 1
#def 0
#dmg 10
#explspr 10219
#flyspr 210
#magic
#sound 24
#range 40
#shock
#nostr
#end

--------------------------------------------------------------------------------
-- T-bird's weapon
#newweapon 804
#name "Thunderclap"
#att 4
#def 4
#dmg 8
#dt_stun
#sound 22
#range 30
#ammo 100
#armorpiercing
#nostr
#bonus
#end

--------------------------------------------------------------------------------
-- Monkey King's Bamboo Staff
#newweapon 803
#name "Gold Band Staff"
#twohanded
#att 4
#def 4
#dmg 8
#len 5
#magic
#nratt 2
#sound 10
#range 50
#ammo 100
#flyspr 110
#end

--------------------------------------------------------------------------------
-- Grim Reaper's piece
#newweapon 802
#name "Soul Scythe"
#aoe 1
#att 6
#armornegating
#def 0
#dmg 999
#len 4
#magic
#nratt 1
#twohanded
#sound 20
#end

--------------------------------------------------------------------------------
-- For T-Rex
#newweapon 801
#name "Crushbite"
#aoe 0
#att 10
#armorpiercing
#bonus
#dmg 20
#nratt 1
#sound 38
#secondaryeffect 53
#end


--------------------------------------------------------------------------------
-- for black dragon.  If only we could make this MR negating, it would be great.
#newweapon 800
#name "Disintegration Breath"
#aoe 5
#bonus
#bonus
#dmg 999
#nratt 1
#sound 38
#range 20
#prec 100
#ammo 10
#magic
#explspr 10206
#flyspr 339
#sound 16
#nostr
#bonus
#end

--------------------------------------------------------------------------------
-- for shadowcat
#newweapon 799
#name "Bite"
#def -1
#att 0
#armorpiercing
#dmg 2
#nratt 1
#sound 38
#magic
#len 0
#end

--------------------------------------------------------------------------------
-- for shadowcat
#newweapon 798
#name "Claws"
#att 0
#dmg 0
#nratt 2
#sound 38
#def 1
#magic
#end

--------------------------------------------------------------------------------
-- for gold dragon.  
#newweapon 797
#name "Word of Might"
#aoe 5
#dmg 10
#nratt 1
#sound 38
#range 30
#prec 100
#ammo 20
#magic
#explspr 10010
#flyspr 141
#sound 24
#nostr
#secondaryeffect 114
#bonus
#end

--------------------------------------------------------------------------------
-- for scarab
#newweapon 796
#name "Tiny Bite"
#def 0
#att 0
#armornegating
#dmg 1
#nratt 1
#sound 38
#len 0
#secondaryeffect 306
#end

--------------------------------------------------------------------------------
-- for clearing copied weapons
#newweapon 795
#name " "
#def 0
#att 0
#dmg 0
#twohands
#nratt 1
#len 0
#dt_cap
#nostr
#ammo 0
#end


################################################################################
##   Custom Summons Units for Pretenders / Spells
################################################################################


--------------------------------------------------------------------------------
#newmonster 2954
#name "Menhir of Peace"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith."
#spr1 "./mytheology/menhir_peace.tga"
#spr2 "./mytheology/menhir_peace.tga"
#incunrest -20
#ap 0
#hp 40
#mapmove 0
#size 4
#prot 22
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#end

--------------------------------------------------------------------------------
#newmonster 2955
#copystats 473
#name "Menhir of Faith"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith."
#spr1 "./mytheology/menhir_faith.tga"
#spr2 "./mytheology/menhir_faith.tga"
#spreaddom 2
#ap 0
#hp 40
#mapmove 0
#size 4
#prot 22
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#awe 0
#sacred
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#end

--------------------------------------------------------------------------------
-- I would like to give this one Blood Vengeance.
-- sadly, copying the Daikini also gives armor and weapons, flying, and demon
-- attributes we cannot get rid of.  Fear too.
#newmonster 2953
#copystats 1714
#clearmagic
#name "Menhir of Courage"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith."
#spr1 "./mytheology/menhir_courage.tga"
#spr2 "./mytheology/menhir_courage.tga"
#standard 30
#ap 0
#hp 40
#mapmove 0
#size 4
#prot 14
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#weapon 795
#weapon 795
#clearmagic
-- kludges - for some reason clearmagic isn't working completely on the first 
-- try.  Perhaps theres a ? magic level in there somewhere.
#magicboost 5 -1
#clearmagic
#end

--------------------------------------------------------------------------------
-- unfortunately, this also gives us the "cornucopia" weapon with no way of 
-- clearing it
#newmonster 2952
#copystats 964
#clearmagic
#name "Menhir of Growth"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith."
#spr1 "./mytheology/menhir_growth.tga"
#spr2 "./mytheology/menhir_growth.tga"
#supplybonus 50
#ap 0
#hp 40
#mapmove 0
#size 4
#prot 22
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#weapon 795
#weapon 795
#nametype 15
#gcost 0
#pathcost 10
#restrictedgod 3
#end

--------------------------------------------------------------------------------
#newmonster 2951
#clearmagic
#name "Menhir of Fortune"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith."
#spr1 "./mytheology/menhir_fortune.tga"
#spr2 "./mytheology/menhir_fortune.tga"
#nobadevents 50
#ap 0
#hp 40
#mapmove 0
#size 4
#prot 22
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#noleader
#noundeadleader
#nomagicleader
#inanimate
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#mindless
#maxage 9999
#poisonres 100
#fireres 100
#coldres 100
#itemslots 1
#nametype 15
#gcost 30
#rcost 20
#end

--------------------------------------------------------------------------------
-- Copying the Lord of the Gates (388) works for summoning shades,
-- but they always run away from the battlefield if no death mage is present.
-- I would rather have this menhir be cheap (10gems) and provide shades 
-- during attacks not dependent upon dominion.  It would probably work if
-- I made the Menhir not inanimate / lifeless ... but what's the point then?
-- so we default to domsummon2 528 (corpse candle), which is unfortunate
-- because they can just keep on piling up....
#newmonster 2950
#copystats 388
#name "Menhir of Death"
#descr "Menhirs are massive monoliths of carven granite, infused with great magic and power to bless its province with fortune, peace, courage, growth, or growing faith.  The Menhir of Death radiates a terrifying aura, and shadows appear when it is disturbed."
#spr1 "./mytheology/menhir_death.tga"
#spr2 "./mytheology/menhir_death.tga"
#immobile
#clearmagic
#clearmagic
#ap 1
#hp 40
#mapmove 0
#size 4
#prot 22
#enc 0
#str 0
#att 0
#def 0
#prec 0
#mr 18
#mor 30
#poorleader
#poorundeadleader
#nomagicleader
#inanimate
#undead
#magicbeing
#amphibian
#neednoteat
#immobile
#noheal
#fear 5
#poisonres 100
#fireres 100
#coldres 100
#weapon 795
#nametype 15
#itemslots 1
#restrictedgod 1
#end




--------------------------------------------------------------------------------
#newmonster 2961
#name "Carrion Mage"
#descr "The Carrion Mage is an undead sorcerer proficient in air and death magic.  It hungers to feed on dying flesh and has an undying hatred of living things."
#copyspr 299
#ap 8
#hp 20
#mapmove 3
#size 2
#prot 5
#enc 0
#str 15
#att 13
#def 13
#prec 12
#mr 16
#mor 30
#magicskill 1 1
#magicskill 5 1
#poorleader
#expertundeadleader
#weapon "Quarterstaff"
#undead
#neednoteat
#poisonres 100
#coldres 100
#pathcost 20
#end


--------------------------------------------------------------------------------
#newmonster 2980
#name "Taoist Master"
#descr "The Taoist Master is an ancient alchemist and priest of considerable power and venerable wisdom."
#copyspr 940
#ap 10
#hp 8
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 12
#mr 16
#mor 30
#itemslots 15494 
#magicboost 51 1
#magicskill 51 1
#pathcost 80
#weapon "Dagger"
#end


--------------------------------------------------------------------------------
#newmonster 2992
#name "Chaos Mage"
#descr "The Chaos Mage is an ancient and evil sorcerer that excels in dark and destructive magics."
#copyspr 339
#ap 10
#hp 10
#mapmove 2
#size 2
#prot 0
#enc 3
#str 10
#att 10
#def 8
#prec 12
#mr 16
#mor 30
#itemslots 15494 
#pathcost 80
#magicskill 4 1
#magicskill 5 1
#poorleader
#weapon "Dagger"
#end


--------------------------------------------------------------------------------
#newmonster 2969
#name "Cytherean Priestess"
#descr "Once in a long while, an exceptionally beautiful maiden is selected to serve the Goddess of Desire.  She becomes a Priestess of Cytherea that can channel the otherworldly beauty of her Goddess.  Enemies find it difficult to strike her physically, and she can stop men in their tracks with merely a seductive glance.  Like her Goddess, a Priestess can occasionally entice enemies to abandon their allegiances to pursue their desire for the Goddess.  The Priestess gives her bodies to the worship of the Goddess, and can be Blessed.  However, she is not a warrior; she cannot wear armor or wield weapons and may flee at the first sign of bloodshed."
#spr1 "./mytheology/cythera.tga"
#spr2 "./mytheology/cythera2.tga"
#ap 8
#hp 4
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 8
#mr 10
#mor 2
#female
#nametype 103
#awe 2
#holy
#itemslots 6146
#maxage 50
#poorleader
#nomagicleader
#noundeadleader
--  weapon "Stun" -- too much, really
#weapon "Enslave Mind"
#seduce 20
#stealthy
#end


--------------------------------------------------------------------------------
#newmonster 2985
#name "Another Monkey King"
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"
#descr "A mischievious and magical copy of the Monkey King pretender."
#ap 10
#hp 10
#mapmove 2
#prot 4
#size 2
#str 8
#enc 1
#att 10
#def 8
#prec 8
#mr 12
#mor 9
#ambidextrous 4
#eyes 2
#forestsurvival
#mountainsurvival
#itemslots 15494
#nametype 129
#reinvigoration 1
#magicskill 1 1
#magicskill 2 1
#holy
#spy
#stealthy
#weapon 7
#armor "Chain Hauburk"
#end


--------------------------------------------------------------------------------
#newmonster 2966
#name "Toad Demon"
#descr "Resembling a toad of monstrous proportions, this demon is a strong mage and a resilient combatant.  While it is at home both above and below the water, it is a glutton for food and supplies."
#spr1 "./mytheology/toaddemon.tga"
#spr2 "./mytheology/toaddemon2.tga"
#ap 10
#mapmove 1
#hp 50
#prot 15
#size 5
#enc 2
#str 20
#att 14
#def 12
#prec 12
#mr 16
#mor 30
#pathcost 50
#restrictedgod 19
#startdom 1
#gcost 80
#supplybonus -15
#neednoteat
#pooramphibian
#poisonarmor
#regeneration 4
#poisonres 100
#fireres 50
#heal
#eyes 2
#itemslots 15494
#okleader
#okmagicleader
#poorundeadleader
#reinvigoration 5
#magicskill 3 1
#magicskill 2 1
#magicskill 7 1
#nametype 140
#demon
#weapon "Swallow"
#end


--------------------------------------------------------------------------------
#newmonster 2978
#copystats 591
#name "Small Fish"
#descr "A small predatory fish."
#spr1 "./mytheology/minnow1.tga"
#spr2 "./mytheology/minnow2.tga"
#hp 1
#str 1
#prot 0
#att 6
#mor 10
#def 10
#mr 3
#prec 10
#enc 5
#aquatic
#animal
#neednoteat
#stealthy
#flying
#itemslots 1
#weapon "Tiny Bite"
#end


--------------------------------------------------------------------------------
#newmonster 2979
#name "Portuguese Man O' War"
#descr "A giant and dangerous jellyfish."
#spr1 "./mytheology/manowar.tga"
#spr2 "./mytheology/manowar.tga"
#hp 10
#str 2
#prot 8
#att 15
#mor 50
#def 10
#mr 8
#prec 10
#enc 5
#ap 6
#mapmove 0
#aquatic
#neednoteat
#magicbeing
#entangle
#blind
#mindless
#shockres 50
#poisonres 50
#poisonarmor
#damage 2997
#itemslots 4096
#weapon 282
#size 3
#end


--------------------------------------------------------------------------------
#newmonster 2962
#name "Scarab"
#descr "A large armored beetle."
#spr1 "./mytheology/scarab1.tga"
#spr2 "./mytheology/scarab2.tga"
#hp 1
#ap 8
#mapmove 1
#str 1
#prot 2
#att 10
#mor 40
#def 5
#size 0
#mr 5
#prec 10
#enc 1
#animal
#fireres -50
#coldres -50
#itemslots 1
#weapon 796
#end

--------------------------------------------------------------------------------
#newmonster 2934
#name "Wraith King"
#descr "Nazgl, a Wraith King."
#spr1 "./mytheology/nazgul1.tga"
#spr2 "./mytheology/nazgul2.tga"
#restrictedgod 1
#ap 15
#hp 60
#mapmove 4
#size 2
#prot 14
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 40
#pathcost 80
#startdom 1
#fear 3
#awe 0
#immortal
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#okleader
#okmagicleader
#expertundeadleader
#weapon 41
#end

--------------------------------------------------------------------------------
#newmonster 2931
#copystats 782 -- giant spider
#name "Assassin Spider"
#descr "The size of a large dog, these giant spiders are astonishingly swift and hunt in packs to bring down their prey."
#spr1 "./mytheology/wolfspider1.tga"
#spr2 "./mytheology/wolfspider2.tga"
#size 1
#hp 6
#ap 18
#mapmove 1
#prot 3
#str 6
#att 10
#def 14
#prec 12
#mr 10
#mor 20
#assassin
#weapon 239 -- venomous fangs, strong poison
#stealthy
#eyes 4
#poisonres 50
#itemslots 4096
#mountainsurvival
#forestsurvival
#noleader
#noundeadleader
#nomagicleader
#nametype 125
#end


--------------------------------------------------------------------------------
#newmonster 2932
#name "Assassin Mother"
#descr "Driven by hatred, this fearsome and monstrous spider craves victims to slake her hunger and feed her children."
#domsummon 2931
#spr1 "./mytheology/spider1.tga"
#spr2 "./mytheology/spider2.tga"
#ap 16
#mapmove 1
#prot 12
#str 13
#enc 2
#att 13
#def 14
#prec 14
#mr 10
#mor 10
#hp 18
#size 3
#holy
#stealthy
#eyes 4
#poisonres 100
#okleader
#noundeadleader
#nomagicleader
#assassin
#mountainsurvival
#forestsurvival
#weapon 65 -- venomous fangs, death poison
#weapon 262 -- web spit
#itemslots 12288
#nametype 125
#end



################################################################################
##   Custom Pretenders 
################################################################################
#newmonster 2971
-- this gives us the storm flight ability but also weapons / armor we don't want
-- copystats 418
#name "Thunderbird"
#descr "The Thunderbird is master of the air and storms.  It appears as a giant bird, and the beating of its enormous wings causes thunder and stirs the storm winds and lightning flashes from its eyes. Once the servant and messenger of the previous Pantokrator, the Thunderbird now rises to claim its place as foremost among the gods.  When the Thunderbird's dominion is high, its lesser cousins will come to do its bidding."
#spr1 "./mytheology/thunderbird.tga"
#spr2 "./mytheology/thunderbird2.tga"
#restrictedgod 9
#gcost 170
#startdom 3
#pathcost 50
#hp 60
#prot 10
#mor 30
#mr 18
#encumbrance 0
#fatigue 0
#str 16
#att 12
#def 15
#prec 20
#mapmove 3
#ap 28
#size 4
#magicskill 1 2
#magicskill 2 1
#nametype 111
#siegebonus 20
#reinvigoration 4
#goodleader
#goodmagicleader
#poorundeadleader
#weapon 805
#weapon 804
#weapon 804
#itemslots 28672
#neednoteat
#shockres 100
#flying
#mountainsurvival
#domsummon2 513
#end


#newmonster 2972
-- this gives us the storm flight ability but also weapons / armor we don't want
-- copystats 418
#name "Thunderbird"
#descr "The Thunderbird is master of the air and storms.  It appears as a giant bird, and the beating of its enormous wings causes thunder and stirs the storm winds and lightning flashes from its eyes. Once the servant and messenger of the previous Pantokrator, the Thunderbird now rises to claim its place as foremost among the gods.  When the Thunderbird's dominion is high, its lesser cousins will come to do its bidding."
#spr1 "./mytheology/thunderbird.tga"
#spr2 "./mytheology/thunderbird2.tga"
#restrictedgod 38
#gcost 170
#startdom 3
#pathcost 50
#hp 60
#prot 10
#mor 30
#mr 18
#encumbrance 0
#fatigue 0
#str 16
#att 12
#def 15
#prec 20
#mapmove 3
#ap 28
#size 4
#magicskill 1 2
#magicskill 2 1
#nametype 111
#siegebonus 20
#reinvigoration 4
#goodleader
#goodmagicleader
#poorundeadleader
#weapon 805
#weapon 804
#weapon 804
#itemslots 28672
#neednoteat
#shockres 100
#flying
#mountainsurvival
#domsummon2 513
#end


#newmonster 2973
-- this gives us the storm flight ability but also weapons / armor we don't want
-- copystats 418
#name "Thunderbird"
#descr "The Thunderbird is master of the air and storms.  It appears as a giant bird, and the beating of its enormous wings causes thunder and stirs the storm winds and lightning flashes from its eyes. Once the servant and messenger of the previous Pantokrator, the Thunderbird now rises to claim its place as foremost among the gods.  When the Thunderbird's dominion is high, its lesser cousins will come to do its bidding."
#spr1 "./mytheology/thunderbird.tga"
#spr2 "./mytheology/thunderbird2.tga"
#restrictedgod 59
#gcost 170
#startdom 3
#pathcost 50
#hp 60
#prot 10
#mor 30
#mr 18
#encumbrance 0
#fatigue 0
#str 16
#att 12
#def 15
#prec 20
#mapmove 3
#ap 28
#size 4
#magicskill 1 2
#magicskill 2 1
#nametype 111
#siegebonus 20
#reinvigoration 4
#goodleader
#goodmagicleader
#poorundeadleader
#weapon 805
#weapon 804
#weapon 804
#itemslots 28672
#neednoteat
#shockres 100
#flying
#mountainsurvival
#domsummon2 513
#end


--------------------------------------------------------------------------------
#newmonster 2975
#name "Great Egg"
#descr "This Pretender manifests as an enormous, rock-hard egg warm with the unknown life inside.  It represents beginnings, youth, potential, mystery and new life.  It speaks with the voices of the thousands of birds which always are found in its presence.  While it is immobile, it would be difficult to destroy."
#spr1 "./mytheology/greategg.tga"
#spr2 "./mytheology/greategg.tga"
#restrictedgod 9
#gcost 0
#startdom 2
#pathcost 20
#hp 30
#prot 20
#mor 30
#mr 18
#enc 0
#str 0
#att 12
#def 0
#prec 10
#mapmove 0
#ap 14
#size 3
#magicskill 3 1
#magicskill 6 1
#nametype 112
#healer 20
#heal
#reinvigoration 2
#poorleader
#poormagicleader
#poorundeadleader
#noeyes
#researchbonus -2
#shockres 50
#poisonres 50
#itemslots 1
#neednoteat
#immobile
#end


#newmonster 2976
#name "Great Egg"
#descr "This Pretender manifests as an enormous, rock-hard egg warm with the unknown life inside.  It represents beginnings, youth, potential, mystery and new life.  It speaks with the voices of the thousands of birds which always are found in its presence.  While it is immobile, it would be difficult to destroy."
#spr1 "./mytheology/greategg.tga"
#spr2 "./mytheology/greategg.tga"
#restrictedgod 38
#gcost 0
#startdom 2
#pathcost 20
#hp 30
#prot 20
#mor 30
#mr 18
#enc 0
#str 0
#att 12
#def 0
#prec 10
#mapmove 0
#ap 14
#size 3
#magicskill 3 1
#magicskill 6 1
#nametype 112
#healer 20
#heal
#reinvigoration 2
#poorleader
#poormagicleader
#poorundeadleader
#noeyes
#researchbonus -2
#shockres 50
#poisonres 50
#itemslots 1
#neednoteat
#immobile
#end


#newmonster 2977
#name "Great Egg"
#descr "This Pretender manifests as an enormous, rock-hard egg warm with the unknown life inside.  It represents beginnings, youth, potential, mystery and new life.  It speaks with the voices of the thousands of birds which always are found in its presence.  While it is immobile, it would be difficult to destroy."
#spr1 "./mytheology/greategg.tga"
#spr2 "./mytheology/greategg.tga"
#restrictedgod 59
#gcost 0
#startdom 2
#pathcost 20
#hp 30
#prot 20
#mor 30
#mr 18
#enc 0
#str 0
#att 12
#def 0
#prec 10
#mapmove 0
#ap 14
#size 3
#magicskill 3 1
#magicskill 6 1
#nametype 112
#healer 20
#heal
#reinvigoration 2
#poorleader
#poormagicleader
#poorundeadleader
#noeyes
#researchbonus -2
#shockres 50
#poisonres 50
#itemslots 1
#neednoteat
#immobile
#end


--------------------------------------------------------------------------------
#newmonster 2958
#name "Carrion Lord"
#descr "The Carrion Lord is the living carcass of an ancient and giant vulture that learned to feed on death itself.  It hungers to feed on dying flesh and has an undying hatred of living things.  The Carrion Lord is able to adopt the shape of a wight mage for spellcasting.  It is a master of death magics, and can extract two death gems each month from the decaying corpses it feeds upon."
#copyspr 1388
#restrictedgod 59
#gcost 110
#startdom 2
#pathcost 20
#hp 90
#prot 12
#mor 30
#mr 14
#encumbrance 0
#fatigue 0
#str 20
#att 12
#def 12
#prec 10
#enc 0
#mapmove 3
#ap 10
#size 3
#shapechange 2961
#nametype 111
#flying
#undead
#poorleader
#poormagicleader
#goodundeadleader
#noeyes
#shockres 50
#poisonres 50
#heal
#gemprod 5 2
#itemslots 15494
#neednoteat
#end



--------------------------------------------------------------------------------
#newmonster 2996
#name "Morpheus"
#descr "Morpheus is the personification of the Dreaming.  As one of the Endless - the embodiments of Desire, Death, Destiny, Delerium, Destruction, and Dream - he is something both more and less than a true god.  This incarnation of the Dream has chosen to walk the path of a pretender god, and extend the realm of the Dreaming over waking lands.  He appears as a tall man with pale skin, black hair, and eyes that burn like stars.  He is the master of illusions and dreams, and his realm touches all planes and times."
#spr1 "./mytheology/morpheus.tga"
#spr2 "./mytheology/morpheus2.tga"
#restrictedgod 49
#ap 10
#hp 10
#mapmove 3
#size 2
#prot 0
#enc 3
#str 9
#att 10
#def 10
#prec 30
#mr 20
#mor 30
#gcost 270
#pathcost 30
#startdom 3
#awe 1
#illusion
#itemslots 15494
#gemprod 4 1
#magicbeing
#magicskill 4 3
#magicskill 1 3
#nametype 100
#researchbonus 5
#poorleader
#expertmagicleader
#noundeadleader
#end


--------------------------------------------------------------------------------
#newmonster 2995
#name "Teratos Rex"
#descr "When the world was young, he was the most vicious and feared of the Firstborn.  The king of all monsters, he dominated the land through his bloodthirst, cruelty and strength.  None could stand against his terrible bite; his teeth were the size of a man's arm and coated with the festering flesh of his countless victims.  Through the blood of his innumerable murdered prey, he achieved a form of immortality.  He has broken free of his bonds beneath the earth, and has risen again to become the true god through the death of all other pretenders."
#spr1 "./mytheology/trex1.tga"
#spr2 "./mytheology/trex2.tga"
#restrictedgod 10
#ap 20
#mapmove 1
#hp 190
#prot 18
#size 6
#enc 1
#str 25
#att 18
#def 12
#prec 12
#mr 14
#mor 30
#gcost 40
#pathcost 70
#startdom 2
#berserk 4
#douse 3
#fear 4
#forestsurvival
#wastesurvival
#swampsurvival
#trample
#heal
#noitem
#eyes 2
#itemslots 28672
#siegebonus 20
#poorleader
#poormagicleader
#poorundeadleader
#magicskill 7 1
#nametype 113
#weapon "Crushbite" 801
#end


--------------------------------------------------------------------------------
#newmonster 2994
#name "Pantokrator"
#descr "The Pantokrator is a metadimensional being that acted as caretaker and overseer of this dimension, guarding it against incursions and threats.  Little is known about the original Pantokrator, but it is surmised that it left this universe for several millenia to join battle with other Pantokrators in the Far Beyond.  Now it has returned to find this plane in disarray with various Pretenders arising to wrest control.  Having lost much of its might to upstart Pretenders, it is still exceptionally powerful and has chosen a nation to help re-establish its strength and eliminate all Pretenders."
#spr1 "./mytheology/pantokrator.tga"
#spr2 "./mytheology/pantokrator2.tga"
#ap 18
#hp 80
#mapmove 4
#size 3
#prot 10
#enc 1
#str 16
#att 12
#def 12
#prec 18
#mr 20
#mor 30
#gcost 350
#pathcost 20
#startdom 3
#awe 1
#itemslots 15494
#nametype 131
#immortal
#neednoteat
#amphibian
#flying
#poisonres 20
#darkvision 20
#fireshield 1
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 3
#magicskill 51 1
#researchbonus 5
#poorleader
#expertmagicleader
#noundeadleader
#maxage 99999 -- kludge
#weapon "Fist"
#weapon "Astral Fetters"
#end


--------------------------------------------------------------------------------
#newmonster 2993
#name "Desire"
#descr "The Goddess of Desire is the manifestation of love, lust, and beauty.  Few mortals are capable of attacking her physically because of her overwhelming physical perfection.  Although she cannot wield weapons or wear armor, enemies may desert their armies to pursue her beauty and she can stun men with merely a lascivious glance.  She can summon suitors to serve her at will, and as her dominion grows her Priestesses will come to her to tend her and help her in battle.  She is a mistress of nature, blood, and water magics, those elements which fuel the surges of desire in mortals.  Her subjects are very loyal, and will fight to the death to protect her."
#spr1 "./mytheology/parvati.tga"
#spr2 "./mytheology/parvati2.tga"
#restrictedgod 30
#ap 8
#hp 18
#mapmove 2
#size 2
#prot 0
#enc 3
#str 8
#att 8
#def 8
#prec 10
#mr 16
#morale 24
#female
#gcost 180
#pathcost 70
#startdom 6
#awe 8
#weapon "Small Area Stun"
#weapon "Enslave Mind"
#itemslots 30848
#heal
#magicskill 7 1
#nametype 108
#domsummon2 2969
#makemonster1 "Knight"
#seduce 150
#stealthy
#standard 20
#superiorleader
#goodmagicleader
#noundeadleader
#end


--------------------------------------------------------------------------------
#newmonster 2991
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#restrictedgod 1
#ap 15
#hp 60
#mapmove 4
#size 2
#prot 10
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 30
#gcost 310
#pathcost 80
#startdom 1
#fear 3
#awe 0
#immortal
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#researchbonus 0
#okleader
#okmagicleader
#expertundeadleader
#weapon 802
#end


#newmonster 2990
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#restrictedgod 28
#ap 15
#hp 60
#mapmove 4
#size 2
#prot 10
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 30
#gcost 310
#pathcost 80
#startdom 1
#fear 3
#awe 0
#immortal
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#researchbonus 0
#okleader
#okmagicleader
#expertundeadleader
#weapon 802
#end


#newmonster 2989
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#restrictedgod 50
#ap 15
#hp 60
#mapmove 4
#size 2
#prot 10
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 30
#gcost 310
#pathcost 80
#startdom 1
#fear 3
#awe 0
#immortal
#undead
#ethereal
#neednoteat
#amphibian
#flying
#stealthy
#assassin
#blind
#coldres 50
#poisonres 100
#itemslots 15494
#magicskill 5 3
#researchbonus 0
#okleader
#okmagicleader
#expertundeadleader
#weapon 802
#end



--------------------------------------------------------------------------------
--Speacial manifestation for summoning, not pretender
#newmonster 2935
#copystats 392
#name "Grim Reaper"
#descr "Azrael, the angel of Death, is the manifestation of the End of All Things.  It appears as a hooded, cloaked skeletal figure bearing a great reaping sickle or black sword, and often with great black wings."
#spr1 "./mytheology/reaper.tga"
#spr2 "./mytheology/reaper2.tga"
#ap 15
#hp 60
#mapmove 4
#size 2
#prot 14
#str 12
#enc 0
#att 15
#def 10
#prec 30
#mr 16
#mor 50
#fear 3
#awe 0
#weapon 802
#end

--------------------------------------------------------------------------------
-- Ever since the v3.08 patch, this pretender's custom armors cause serious 
-- problems.  So I've left them off for now.
#newmonster 2965
#name "Monkey King"
#description "In primordial times, a monkey left the mountains to seek a way to immortality. He sought tutelege under a great Taoist sage who was impressed by his determination and intelligence and taught him the arts of 72 earthly transformations.  Although he learned immortality, he became famous for fighting, being a nuisance, and making trouble in the Heavens and Hells.  He was able to trick the East Sea Dragon King into giving him several magic gifts, including his magic armor and his staff which can be made to grow to any size.  He was sealed under a mountain by the Buddha for 500 years, and now has emerged to unleash his mischief.  His magical abilities include making copies of himself, and performing a 'cloud summersault' that can cover great distances."
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"
#restrictedgod 18
#ap 14
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 15
#def 14
#prec 10
#mr 15
#mor 30
#gcost 150
#pathcost 20
#startdom 1
#ambidextrous 4
#forestsurvival
#mountainsurvival
#nametype 129
#reinvigoration 1
#heal
#spy
#stealthy
#magicskill 1 1
#magicskill 3 1
#researchbonus 8
#weapon 803
#expertleader
#okmagicleader
#poorundeadleader
#end


#newmonster 2987
#name "Monkey King"
#description "In primordial times, a monkey left the mountains to seek a way to immortality. He sought tutelege under a great Taoist sage who was impressed by his determination and intelligence and taught him the arts of 72 earthly transformations.  Although he learned immortality, he became famous for fighting, being a nuisance, and making trouble in the Heavens and Hells.  He was able to trick the East Sea Dragon King into giving him several magic gifts, including his magic armor and his staff which can be made to grow to any size.  He was sealed under a mountain by the Buddha for 500 years, and now has emerged to unleash his mischief.  His magical abilities include making copies of himself, and performing a 'cloud summersault' that can cover great distances."
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"
#restrictedgod 43
#ap 14
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 15
#def 14
#prec 10
#mr 15
#mor 30
#gcost 150
#pathcost 20
#startdom 1
#ambidextrous 4
#forestsurvival
#mountainsurvival
#nametype 129
#reinvigoration 1
#heal
#spy
#stealthy
#magicskill 1 1
#magicskill 3 1
#researchbonus 8
#weapon 803
#expertleader
#okmagicleader
#poorundeadleader
#end


#newmonster 2988
#name "Monkey King"
#description "In primordial times, a monkey left the mountains to seek a way to immortality. He sought tutelege under a great Taoist sage who was impressed by his determination and intelligence and taught him the arts of 72 earthly transformations.  Although he learned immortality, he became famous for fighting, being a nuisance, and making trouble in the Heavens and Hells.  He was able to trick the East Sea Dragon King into giving him several magic gifts, including his magic armor and his staff which can be made to grow to any size.  He was sealed under a mountain by the Buddha for 500 years, and now has emerged to unleash his mischief.  His magical abilities include making copies of himself, and performing a 'cloud summersault' that can cover great distances."
#spr1 "./mytheology/sunwukong1.tga"
#spr2 "./mytheology/sunwukong2.tga"
#restrictedgod 64
#ap 14
#hp 25
#mapmove 4
#prot 4
#size 2
#str 12
#enc 1
#att 15
#def 14
#prec 10
#mr 15
#mor 30
#gcost 150
#pathcost 20
#startdom 1
#ambidextrous 4
#forestsurvival
#mountainsurvival
#nametype 129
#reinvigoration 1
#heal
#spy
#stealthy
#magicskill 1 1
#magicskill 3 1
#researchbonus 8
#weapon 803
#expertleader
#okmagicleader
#poorundeadleader
#end


--------------------------------------------------------------------------------
#newmonster 2970
#name "Black Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The Black Dragon is among the most feared of all dragons because of its terrible disintegration breath weapon.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from."
#spr1 "./mytheology/blackdragon.tga"
#spr2 "./mytheology/blackdragon2.tga"
#itemslots 15494
#gcost 70
#hp 125
#prot 18
#mor 30
#mr 22
#enc 3
#str 25
#att 15
#def 11
#prec 12
#mapmove 3
#ap 10
#size 6
#startdom 1
#pathcost 80
#shapechange 2992
#fear 5
#flying 
#darkvision 50
#poisonres 50
#fireres 50
#coldres 50
#okleader
#poormagicleader
#poorundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 800
#itemslots 12416
#end



--------------------------------------------------------------------------------
-- This is my tribute to David Trampier's "Solomoriah".  If you arent familiar
-- with Trampier's early work in Dragon magazine, be sure to visit an archive
-- at http://www.angelfire.com/wa2/haroog/archive/Archive.htm
-- Also interesting how Jeff Smith's "RockJaw" character also has a passing
-- similarity.
#newmonster 2968
#name "Shadowcat"
#descr "The Shadowcat comes from the time of the dragons, and is known to war with them at every opportunity.  It appears as a winged panther of monstrous size, black as night yet glowing with strange internal lights. The Shadowcat is an ancient master of planar travel and astral magic."
#spr1 "./mytheology/solomoriah1.tga"
#spr2 "./mytheology/solomoriah2.tga"
#gcost 150
#hp 140
#prot 8
#mor 30
#mr 20
#enc 2
#str 25
#att 15
#def 18
#prec 14
#mapmove 4
#ap 14
#size 5
#startdom 1
#pathcost 70
#flying 
#darkvision 50
#itemslots 28800
#okleader
#poormagicleader
#poorundeadleader
#magicskill 4 2
#weapon 799
#weapon 798
#stealthy
#ethereal
#end


--------------------------------------------------------------------------------
#newmonster 2967
#name "Gold Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from.  The Gold Dragon is among the most powerful of dragons, and has an increased ability to cast elemental magic."
#spr1 "./mytheology/lung1.tga"
#spr2 "./mytheology/lung2.tga"
#restrictedgod 5
#itemslots 15494
#gcost 150
#hp 110
#prot 18
#mor 30
#mr 20
#enc 3
#str 25
#att 16
#def 13
#prec 12
#mapmove 3
#ap 10
#size 6
#startdom 1
#pathcost 80
#shapechange 2980
#awe 5
#flying 
#nametype 121
#poisonres 50
#fireres 50
#coldres 50
#expertleader
#expertmagicleader
#noundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 797
#itemslots 28800
#end


#newmonster 2960
#name "Gold Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from.  The Gold Dragon is among the most powerful of dragons, and has an increased ability to cast elemental magic."
#spr1 "./mytheology/lung1.tga"
#spr2 "./mytheology/lung2.tga"
#itemslots 15494
#restrictedgod 34
#gcost 150
#hp 110
#prot 18
#mor 30
#mr 20
#enc 3
#str 25
#att 16
#def 13
#prec 12
#mapmove 3
#ap 10
#size 6
#startdom 1
#pathcost 80
#shapechange 2980
#awe 5
#flying 
#nametype 121
#poisonres 50
#fireres 50
#coldres 50
#expertleader
#expertmagicleader
#noundeadleader
#weapon "Bite"
#weapon "Claw"
#itemslots 28800
#weapon 797
#end

#newmonster 2959
#name "Gold Dragon"
#descr "The Dragon is an ancient reptile of tremendous physical and magical powers.  Born before the history of time, they have grown in might and magical mastery.  They are enormous, scaly, winged beasts capable of breathing fire, poisonous gas, or supernatural frost upon enemies.  Dragons are closely attuned to the magic that brought them into life, and thus focus on mainly one magic Path.  The physical bodies of Dragons are not well suited for spell casting.  Therefore, Dragons tend to adopt human form, but when wounded, they revert to their greater Dragon from.  The Gold Dragon is among the most powerful of dragons, and has an increased ability to cast elemental magic."
#spr1 "./mytheology/lung1.tga"
#spr2 "./mytheology/lung2.tga"
#itemslots 15494
#restrictedgod 55
#gcost 150
#hp 110
#prot 18
#mor 30
#mr 20
#enc 3
#str 25
#att 16
#def 13
#prec 12
#mapmove 3
#ap 10
#size 6
#startdom 1
#pathcost 80
#shapechange 2980
#awe 5
#flying 
#nametype 121
#poisonres 50
#fireres 50
#coldres 50
#expertleader
#expertmagicleader
#noundeadleader
#weapon "Bite"
#weapon "Claw"
#weapon 797
#itemslots 28800
#end


--------------------------------------------------------------------------------
#newmonster 2949
#name "Father of Medicine"
#descr "The Father of Medicine was a mortal whose knowledge of healing, herbs, and medicine was so great that it was said he could cure death itself.  He has the ability to heal his followers with amazing skill, and to heal himself almost completely after every attack.  He carries a staff, around which is coiled a snake which protects him at all times out of gratitude for being brought back from the dead."
#spr1 "./mytheology/asclepios1.tga"
#spr2 "./mytheology/asclepios2.tga"
#gcost 80
#hp 10
#prot 0
#mor 30
#mr 18
#enc 3
#str 10
#att 8
#def 12
#prec 16
#mapmove 3
#ap 12
#size 2
#startdom 1
#pathcost 30
#nametype 107
#poisonres 50
#magicskill 6 1
#regeneration 75
#heal
#healer 50
#goodleader
#okmagicleader
#noundeadleader
#weapon 89
#end


--------------------------------------------------------------------------------
#newmonster 2945
#name "Great Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Great Eye can take different shapes to enhance its magical powers and abilities in the earth and water elements."
#spr1 "./mytheology/greateye_earth.tga"
#spr2 "./mytheology/greateye_earth.tga"
#gcost 60
#startdom 2
#pathcost 30
#hp 20
#prot 10
#mor 30
#mr 18
#enc 1
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 795
#itemslots 28672
#flying
#trample
#magicboost 3 1
#magicskill 2 1
#magicskill 3 1
#pooramphibian
#poisonres 100
#shapechange 2947
#end


--------------------------------------------------------------------------------
#newmonster 2947
#name "Great Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Great Eye can take different shapes to enhance its magical powers and abilities in the elements of earth and water.  Although a master of water magic, the Great Eye has no weapons but its spells."
#spr1 "./mytheology/greateye_water.tga"
#spr2 "./mytheology/greateye_water.tga"
#hp 20
#prot 10
#mor 30
#mr 18
#enc 1
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 795
#itemslots 28672
#flying
#amphibian
#magicboost 2 1
#magicskill 2 1
#magicskill 3 1
#coldres 100
#iceprot 2
#shapechange 2945
#maxage 9999
#end

--------------------------------------------------------------------------------
#newmonster 2942
#name "Great Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Great Eye can take different shapes to enhance its magical powers and abilities in the elements of fire and air.  Although a master of fire magic, the Great Eye has no weapons but its spells."
#spr1 "./mytheology/greateye_fire.tga"
#spr2 "./mytheology/greateye_fire.tga"
#gcost 60
#startdom 2
#pathcost 30
#prot 10
#mor 30
#mr 18
#enc 1
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 795
#itemslots 28672
#flying
#magicboost 0 1
#magicskill 0 1
#magicskill 1 1
#fireres 100
#fireshield 8
#shapechange 2946
#end


--------------------------------------------------------------------------------
#newmonster 2946
#name "Great Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  The Great Eye can take different shapes to enhance its magical powers and abilities in the fire and air elements.  Although a master of air magic, the Great Eye has no weapons but its spells."
#spr1 "./mytheology/greateye_air.tga"
#spr2 "./mytheology/greateye_air.tga"
#hp 20
#prot 10
#mor 30
#mr 18
#enc 1
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 795
#itemslots 28672
#flying
#magicboost 1 1
#magicskill 0 1
#magicskill 1 1
#shockres 100
#illusion
#airshield
#shapechange 2942
#maxage 9999
#end


--------------------------------------------------------------------------------
#newmonster 2939
#name "Great Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  Although the Great Eye is a powerful user of astral magic, it has no weapons but its spells.  Once in each battle the Great Eye can completely recuperate its wounds and become ethereal, but at the cost of much of its magic strength."
#spr1 "./mytheology/greateye_astral.tga"
#spr2 "./mytheology/greateye_astral.tga"
#gcost 70
#startdom 2
#pathcost 30
#hp 20
#prot 10
#mor 30
#mr 18
#enc 1
#str 10
#att 10
#def 10
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#goodmagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 795
#itemslots 28672
#flying
#pooramphibian
#astralshield
#secondshape 2940
-- I'd just rather give a +2 astral magicboost here
#magicskill 4 2
#end


--------------------------------------------------------------------------------
#newmonster 2940
#name "Great Eye"
#descr "This Pretender manifests as a great, terrible, unblinking eye that always watches over its entire dominion.  Although the Great Eye is a powerful user of astral magic, it has no weapons but its spells.  After recovering from battle, the Great Eye loses its ability to become ethereal but regains its magical strength."
#spr1 "./mytheology/greateye_astral.tga"
#spr2 "./mytheology/greateye_astral.tga"
#hp 40
#prot 14
#mor 30
#mr 20
#enc 1
#str 10
#att 8
#def 12
#prec 20
#mapmove 1
#ap 16
#size 3
#okleader
#poormagicleader
#poorundeadleader
#eyes 1
#neednoteat
#weapon 795
#itemslots 28672
#flying
#pooramphibian
#astralshield
#ethereal
#firstshape 2939
-- I'd rather just take away the +2 astral magicboost, but that doesn't work
-- so this does just the opposite - steals 1 level in everything but astral
#magicboost 0 -1
#magicboost 1 -1
#magicboost 2 -1
#magicboost 3 -1
#magicboost 5 -1
#magicboost 6 -1
#magicboost 7 -1
-- the second shape of pretenders don't seem to inherit their agelessness
#maxage 9999
#end

--------------------------------------------------------------------------------
#newmonster 2936
#name "Cthulu"
#descr "Cthulu was the strongest and most feared of the Great Old Ones, the monstrous godlike spawn of entities beyond this plane.  In the time of the previous Pantokrator, Cthulu built R'lyeh and together with his starspawn he struggled with the Pantokrator for this universe.  Although Cthulu was narrowly defeated by the previous Pantokrator, he was too powerful to be killed and was instead imprisoned.  Now, Cthulu again awakens from his ancient dreaming beneath the ocean, and reaches out to twist the world to his insane lust."
#spr1 "./mytheology/cthulu1.tga"
#spr2 "./mytheology/cthulu2.tga"
#restrictedgod 22 --early rlyeh
#ap 14
#hp 101
#mapmove 2
#size 5
#prot 14
#enc 2
#str 24
#att 14
#def 10
#prec 12
#mr 22
#mor 30
#gcost 270
#pathcost 60
#startdom 3
#fear 2
#itemslots 28806 -- head, 2 hands, 3 misc
#nametype 117 
#immortal
#amphibian
#poisonres 50
#darkvision 50
#magicskill 4 4 -- astral
#okleader
#expertmagicleader
#poorundeadleader
#weapon "Claw"
#weapon "Claw"
#weapon "Mind Blast"
#end

#newmonster 2937
#name "Cthulu"
#descr "Cthulu was the strongest and most feared of the Great Old Ones, the monstrous godlike spawn of entities beyond this plane.  In the time of the previous Pantokrator, Cthulu built R'lyeh and together with his starspawn he struggled with the Pantokrator for this universe.  Although Cthulu was narrowly defeated by the previous Pantokrator, he was too powerful to be killed and was instead imprisoned.  Now, Cthulu again awakens from his ancient dreaming beneath the ocean, and reaches out to twist the world to his insane lust."
#spr1 "./mytheology/cthulu1.tga"
#spr2 "./mytheology/cthulu2.tga"
#restrictedgod 47 -- middle
#ap 14
#hp 101
#mapmove 2
#size 5
#prot 14
#enc 2
#str 24
#att 14
#def 10
#prec 12
#mr 22
#mor 30
#gcost 270
#pathcost 60
#startdom 3
#fear 2
#itemslots 28806 -- head, 2 hands, 3 misc
#nametype 117 
#immortal
#amphibian
#poisonres 50
#darkvision 50
#magicskill 4 4 -- astral
#okleader
#expertmagicleader
#poorundeadleader
#weapon "Claw"
#weapon "Claw"
#weapon "Mind Blast"
#end


#newmonster 2938
#name "Cthulu"
#descr "Cthulu was the strongest and most feared of the Great Old Ones, the monstrous godlike spawn of entities beyond this plane.  In the time of the previous Pantokrator, Cthulu built R'lyeh and together with his starspawn he struggled with the Pantokrator for this universe.  Although Cthulu was narrowly defeated by the previous Pantokrator, he was too powerful to be killed and was instead imprisoned.  Now, Cthulu again awakens from his ancient dreaming beneath the ocean, and reaches out to twist the world to his insane lust."
#spr1 "./mytheology/cthulu1.tga"
#spr2 "./mytheology/cthulu2.tga"
#restrictedgod 67 --late
#ap 14
#hp 101
#mapmove 2
#size 5
#prot 14
#enc 2
#str 24
#att 14
#def 10
#prec 12
#mr 22
#mor 30
#gcost 270
#pathcost 60
#startdom 3
#fear 2
#itemslots 28806 -- head, 2 hands, 3 misc
#nametype 117 
#immortal
#amphibian
#poisonres 50
#darkvision 50
#magicskill 4 4 -- astral
#okleader
#expertmagicleader
#poorundeadleader
#weapon "Claw"
#weapon "Claw"
#weapon "Mind Blast"
#end




--------------------------------------------------------------------------------
#newmonster 2933
#name "Empress of Assassins"
#descr "In hidden and dark places, the Empress has grown huge and powerful over the course of millennia.  Now, her seething hunger and hatred have driven her to assume dominion, and she craves to have her children overrun the lands of light."
#restrictedgod 35
#spr1 "./mytheology/lolth1.tga"
#spr2 "./mytheology/lolth2.tga"
#hp 55
#ap 14
#hp 60
#mapmove 1
#size 4
#prot 12
#str 16
#enc 2
#att 16
#def 12
#prec 20
#mr 12
#mor 30
#female
#fear 0
#gcost 50
#pathcost 70
#itemslots 61446
#startdom 2
#magicskill 5 1
#domsummon2 2932
#stealthy 10
#okleader
#poormagicleader
#okundeadleader
#mountainsurvival
#forestsurvival
#poisonres 100
#eyes 6
#assassin
#weapon 262 -- web spit
#weapon 262 -- web spit
#weapon 65 -- venomous fangs, death poison
#incunrest 2
#nametype 125
#end


################################################################################
##   Summons as Pretenders
################################################################################
#newmonster 2984
#copystats 621
#name "Yggdrasil"
#descr "Yggdrasil is the great World Tree, whose trunk pierces the world, upon whose branches rests the heavens, and amongst whose roots lie the underworlds.  Yggdrasil has grown a small branch of itself and invested it with its will and magic, and sent it into the world to destroy all irresponsible Pretenders who may threaten the woods and trees.  Yggdrasil can reawaken Vine Men in great numbers."
#spr1 "./mytheology/treelord1.tga"
#spr2 "./mytheology/treelord2.tga"
#restrictedgod 3
#mor 30
#gcost 100
#startdom 1
#pathcost 50
#str 30
#size 5
#itemslots 61440
#goodleader
#goodmagicleader
#weapon "Branch"
#weapon "Branch"
#weapon "Vine Bow"
#trample
#heal
#end


--------------------------------------------------------------------------------
#newmonster 2982
#copystats 925
#name "Tarrasque"
#descr "The Tarrasque is an ancient, poison-breathing dragon of tremendous size.  It has awakened to claim its place as the One True God, destroying all other Pretenders and threats to his earth and nature kingdom. The Tarrasque regenerates wounds, has an incredibly thick hide, and is constantly surrounded by noxious vapors."
#copyspr 925
#restrictedgod 11
#gcost 50
#mor 30
#startdom 1
#pathcost 70
#goodleader
#poormagicleader
#poorundeadleader
#end



--------------------------------------------------------------------------------
#selectmonster "Heliophagus"
#name "Heliophagus"
#descr "The Heliophagii -- the 'Sun Eaters' -- are the Lords of the Abyss.  They are composed of solid darkness except for their golden claws and horns.  They have the ability to become invisible in shadows, and they are horrible to behold.  They are only four known Heliophagii, and they are all skilled in Blood magic.  He has the ability to summon Fiends of Darkness, and his knowledge of Blood magic is extraordinary."
#restrictedgod 58
#mor 30
#gcost 110
#startdom 2
#pathcost 60
#goodleader
#goodmagicleader
#goodundeadleader
#end



--------------------------------------------------------------------------------
#selectmonster "King of Deeper Earth"
#name "King of Deeper Earth"
#descr "The King of Elemental Earth is a physical manifestation of the wild magic of the Earth.  He has a body of stone and soil and appears as a huge, crowned humanoid.  He is innately skilled in Earth magic and can summon Earth Elementals from the deeper reaches of the world to serve him.  From his body seeps Earth blood that crystallizes into gems of Earth power.  The King draws power from the ground and regenerates his woulds.  Only three Kings of Elemental Earth are known to exist, and one of them has been tainted by Blood magic."
#restrictedgod 12
#mor 30
#gcost 160
#startdom 2
#pathcost 50
#goodleader
#goodmagicleader
#poorundeadleader
#end

--------------------------------------------------------------------------------
#selectmonster "Queen of the Sea"
#name "Queen of the Sea"
#descr "The Queen of Elemental Water is a physical manifestation of the wild magic of the water. She resembles a huge, crowned female being composed of water.  She is innately skilled in Water magic and can summon Undines to serve her.  The Queen's body is composed of water and is very difficult to harm when she is underwater.  Unless she is completely killed during one combat round, she will heal all her wounds.  She cannot leave the sea.  Only three Queens of Elemental Water are known to exist."
#restrictedgod 26
#gcost 170
#mor 30
#startdom 2
#pathcost 50
#goodleader
#goodmagicleader
#poorundeadleader
#end


--------------------------------------------------------------------------------
#selectmonster "Queen of Thunder"
#name "Queen of Thunder"
#descr "The Queen of Elemental Air is a physical manifestation of the wild magic of the air.  She has a body composed of billowing clouds and appears as a huge, crowned female being.  She is innately skilled in Air magic.  She is the Queen of Thunder, and her powers are increased during storms.  Her body is composed of clouds and mist and is difficult to harm.  Only three Queens of Elemental Air are known to exist."
#restrictedgod 9
#gcost 170
#mor 30
#startdom 2
#pathcost 50
#goodleader
#goodmagicleader
#poorundeadleader
#end


--------------------------------------------------------------------------------
#selectmonster "King of Banefires"
#name "King of Banefires"
#descr "The King of Elemental Fire is a physical manifestation of the wild magic of Fire.  Once there were three such kings, but one of them was corrupted with blood magic and the taint of the underworld.  He has broken free of his subservience to the Lord of the Underworld, and seeks to establish himself as the True God.  He has a body of blazing Banefire and appears as a huge, crowned King.  He is innately skilled in Fire and Death magic and is constantly surrounded by a shield of blazing Banefire."
#restrictedgod 19
#gcost 190
#mor 30
#startdom 2
#pathcost 50
#goodleader
#goodmagicleader
#expertundeadleader
#end


--------------------------------------------------------------------------------
#selectmonster "Vastness"
#name "Vastness"
#descr "The Vastness is an otherworldly being of almost godlike power.  It is composed of spheres of stellar lights and shades.  Originating from Beyond, the Vastness has entered this plane in order to make the universe its playground.  The Vastness can blast the minds of lesser beings, and its touch steals the strength of living beings.  Anyone striking at the Vastness is likely to be punished for their arrogance, taking damage themselves instead of harming the Vastness."
#restrictedgod 47
#gcost 280
#mor 30
#startdom 1
#pathcost 60
#goodleader
#goodmagicleader
#poorundeadleader
#itemslots 12288
#end


--------------------------------------------------------------------------------
#newmonster 2983
#name "Shah of Djinn and Ifreet"
#descr "An ancient and powerful lord of Air and Fire, the Shah of all Djinn and Ifriit is a mighty spirit whose subjects were exiled from the world to make room for Man and the Younger Races.  Now that the old Pantokrator has gone, he has finally broken the seals preventing his return.  He is malicious and resentful of the world of Man, and has come to claim the throne of Ruler of the World and become God of both the Old Races and the Young Races alike."
#spr1 "./mytheology/djinn.tga"
#spr2 "./mytheology/djinn2.tga"
#mor 30
#restrictedgod 53
#itemslots 28678
#gcost 340
#hp 50
#prot 3
#morale 30
#mr 20
#enc 0
#str 30
#att 24
#def 19
#prec 19
#mapmove 5
#ap 12
#startdom 2
#pathcost 50
#magicskill 0 2
#magicskill 1 2
#magicskill 4 2
#goodleader
#expertmagicleader
#poorundeadleader
#armor "Crown"
#itemslots 61702
#flying
#neednoteat
#shockres 100
#fireres 100
#amphibian
#size 4
#ethereal
#end




--------------------------------------------------------------------------------
#newmonster 2981
#name "Fallen Archangel"
#descr "The Fallen Archangel was an angelic being that revolted aginst the divine order and was imprisoned in Inferno.  Released from its prison by blood magic, it has seen its chance to become the new One True God.  The Fallen Angel is a powerful user of Fire, Death and Blood magic."
#spr1 "./mytheology/fallen.tga"
#spr2 "./mytheology/fallen2.tga"
#mor 30
#restrictedgod 32
#gcost 250
#startdom 3
#magicskill 0 2
#magicskill 7 2
#magicskill 4 2
#hp 47
#prot 7
#mr 18
#enc 1
#str 14
#att 17
#def 16
#prec 15
#mapmove 3
#ap 16
#pathcost 60
#immortal
#fear 3
#fireres 100
#magicbeing
#neednoteat
#demon
#flying
#goodleader
#goodmagicleader
#goodundeadleader
#end


################################################################################
##   Custom Spells 
################################################################################
#newspell
#name "Trap Visitor"
#descr "This spell lures a Visitor from beyond and binds it with the living silver cords of many blood slaves to serve the caster.  A Visitor can be useful guardians against horrors attracted to a horrormark."
#school 6
#researchlevel 6
#path 0 7
#pathlevel 0 5
#path 1 4
#pathlevel 0 3
#effect 10001
#nreff 1
#fatiguecost 1500
#damage 1406
#end 


--------------------------------------------------------------------------------
#newspell
#name "Diabolic Brigade"
#descr "The caster sacrifices many blood slaves, and receives the service of a brigade of lesser demons."
#school 6
#researchlevel 5
#path 0 7
#pathlevel 0 3
#effect 10001
#nreff 30
#fatiguecost 2000
#damage 303
#end 


--------------------------------------------------------------------------------
#newspell
#name "Feeding Frenzy"
#descr "The caster summons a school of small but voracious fish to harass an enemy target."
#school 1
#researchlevel 4
#path 0 2
#pathlevel 0 1
#effect 1
#nreff 1008
#spec 41943040
#damage 2978
#flightspr -1
#end 


--------------------------------------------------------------------------------
#newspell
#name "Summon Man O' War"
#descr "The caster summons a giant, poisonous jellyfish to the battlefield.  The jellyfish is slow and mindless, but can deliver paralyzing and poisonous attacks."
#school 1
#researchlevel 2
#path 0 2
#pathlevel 0 1
#effect 1
#nreff 1
#fatiguecost 10
#damage 2979
#spec 41943040
#flightspr 10005
#end 


--------------------------------------------------------------------------------
#newspell
#copyspell 659
#name "Shards of Hastur"
#descr "The caster unleashes the raw forces of the infinite beyond upon enemy units across the battlefield.  Unprepared minds are temporarily blasted from their bodies, leaving their bodies unable to attack, defend, or even move until the mind can find its way back to its mortal shell.  The number of targets affected increases with the strength of the caster."
#school 5
#researchlevel 6
#path 0 4
#pathlevel 0 5
#aoe 663
#effect 66
#range 100
#precision 100
#fatiguecost 200
#explspr 10206
#damage 2000
#flightspr -1
#spec 8671360
#end 


--------------------------------------------------------------------------------
#newspell
#name "Bind Toad Demon"
#descr "The caster sacrifices several slaves and binds a monstrous toad demon to the service of their Pretender.  The toad demon is amphibious, a versatile mage of blood, water, and earth magics and a resilient fighter."
#school 6
#researchlevel 5
#path 0 7
#pathlevel 0 4
#path 1 2
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 7700
#damage 2966
#end 


--------------------------------------------------------------------------------
-- This makes the normal "Manifestation" spell a little cheaper and easier to
-- research.  I mean really, Research level 8 Thaumaturgy / Death 5 to cast a 
-- single assassin against an opponent, with risk of backfire?  Rescoping this 
-- spell also helps "Rain of Ashes" to be attainable too.
#selectspell 512
#researchlevel 6
#pathlevel 0 4
#end 


------------------------------------------------------------------------------
#newspell
#copyspell 512
#name "The Rite of AshkEnte"
#descr "Through this dark and forbidden ritual, the caster summons Azrael, the Grim Reaper, and sends him to prematurely claim the life of an enemy commander in a distant province. This ritual should only be undertaken with great care and precaution, as the Angel of Death will claim the caster's life if no suitable target can be found."
#damage 2935
#researchlevel 8
#pathlevel 0 5
#fatiguecost 6000
#spec 8388608
#end 


------------------------------------------------------------------------------
#newspell
#copyspell 521
#name "Soul Harvest"
#descr "Five manifestations of Azrael, the Grim Reaper, attempt to collect all enemy souls in a distant province."
#damage 2935
#nreff 4
#school 0
#researchlevel 9
#path 0 5
#pathlevel 0 6
#fatiguecost 8800
#end 


--------------------------------------------------------------------------------
-- Warning!  This spell is takes advantage of hardcoded actions in the "Dome of
-- Flaming Death" ritual.  The messages the attacker receives will be 
-- "Commander was hit by a powerful fire blast shortly after casting the spell
-- but Commander survived."  
-- It would have been my preference to make the damage do disease afflictions,
-- but this ritual is too hardcoded to allow that apparently.
#newspell
#copyspell 603
#name "Banefire Veil"
#descr "A magical veil is placed over the caster's provice. Enemy spells that attack the protected province will rend the veil and expose the attacker to fiery energies from the realm of Death. While the veil will not stop incoming spells, it may remove the attacker as a threat through injury or death. The Veil fades if the caster dies."
#path 0 5
#spec 8388608
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 534
#name "Soulblades"
#descr "The souls of a group of friendly soldiers infuse their weapons, causing them to shine with a visible aura.  These charged weapons are capable of hitting ethereal creatures and cutting through any armor."
#school 1
#path 0 4
#path 1 8
#pathlevel 1 1
#damage 1048576
#fatiguecost 100
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 534
#name "Aurora Warriors"
#descr "A group of friendly soldiers become ethereal and impervious to normal attacks."
#school 1
#researchlevel 7
#aoe 666
#path 0 4
#pathlevel 0 5
#damage 134217728
#fatiguecost 400
#explspr 10002
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 677
#name "Eclipse"
#descr "The caster temporarily traps all the sunlight in an enemy province, shrouding it in darkness.  When the sunlight is released, the piercing, brilliant rays can permenantly blind up to half the soldiers in that province. (Note: Messages will indicate a 'cloud of disease' instead of the 'blind' affliction.)"
#path 0 0
#path 1 5
#pathlevel 0 5
#pathlevel 1 1
#damage 4096
#nreff 2
#fatigue 3600
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 677
#name "Storm of Acid"
#descr "The caster summons a tremendous alchemical storm in an enemy province that rots metal and armor. (Note: Messages will indicate a 'cloud of disease' instead of the 'Rusty Armor' attribute.)"
#path 0 2
#path 1 0
#pathlevel 0 4
#pathlevel 1 1
#damage 2048
#nreff 4
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 677
#name "Foreboding"
#descr "The caster calls upon dark magics to reveal omens and visions of horrible, looming death for each and every soldier in an enemy province.  Many affected soldiers will lose their courage permenantly, fearing their next battle will be their last. (Note: Messages will indicate a 'cloud of disease' instead of the 'battle fright' affliction.)"
#path 0 1
#path 1 7
#pathlevel 0 4
#pathlevel 1 1
#damage 2097152
#nreff 4
#fatiguecost 800
#end


--------------------------------------------------------------------------------
-- Special nods to Jack_Trowell in the Schrapnel Forums for suggesting this one.
#newspell
#copyspell 425
#name "Revelation"
#descr "Through deep prayer and meditation, the presence of holy sites in a province become revealed to the priest or prophet.  (DO NOT auto-cast 'M' this ritual!)."
--#school 5
#researchlevel 0
#path 0 8
#pathlevel 0 2
#damage 8
#fatiguecost 90
--#spec 276824064
-- 13156352 -- blessing spec
#spec 289980416
#end


--------------------------------------------------------------------------------
-- The dual paths in Divine Magic are intentional.  It's a kludge to make the
-- dome only last one turn (pathlevel 0 = 1), but still require at least a level
-- two priest.  My original intent was to create a dome that would only last for
-- as long as a Priest-2 commander was casting it, which would be a snap with 
-- the auto-cast "M" ritual.  However, every combination I try causes crashiness
-- in auto-casting every holy ritual I've come up with, so it appears that it's
-- a bug in the auto-cast routine for all holy rituals.
#newspell
#copyspell 598
#name "Sanctuary"
#descr "The priest calls the protection of the Pretender over an entire province.  The protection will turn away many enemy spells, but is temporary and must be renewed every month. (Note: Messages will be revealed is if it were an Astral Dome.  DO NOT auto-cast 'M' this ritual!)."
#school 1
#researchlevel 3
#path 0 8
#path 1 8
#pathlevel 0 1
#pathlevel 1 2
#fatiguecost 10
#end


--------------------------------------------------------------------------------
-- probably need to drop the #damage field and keep it on default
#newspell
#copyspell 266
#name "Divine Judgement"
#descr "The priest calls down holy fire upon enemies in a distant province.  Up to half the undead troops may be struck. (DO NOT auto-cast 'M' this ritual!)."
#path 0 8
#pathlevel 0 4
#fatiguecost 90
--  damage 2003
#spec 8392840
#end


--------------------------------------------------------------------------------
-- So, I was watching "the Mummy Returns" with my wife the other night, and
-- was thought "Imhotep has a really useful combat spell with all those nasty
-- scarab beetles.."
-- Gametesting had this work out OK - it kills most independent prov armies 
-- without mages, but I have concerns that a super nature mage may turn out
-- too many beetles.
#newspell
#name "Sea of Scarabs"
#descr "The caster summons hundreds of giant armored beetles to swarm against the enemy.  While slow and easily killed, these insects can overwhelm unprepared armies through their sheer numbers."
#school 0
#researchlevel 7
#path 0 6
#pathlevel 0 4
#path 1 3
#pathlevel 1 1
#effect 1
#fatiguecost 100
#nreff 4400
#damage 2962
#explspr 10141
#flightspr -1
#end 



--------------------------------------------------------------------------------
#newspell
#name "Menhir of Fortune"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring fortune the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 4
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 2000
#damage 2951
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Peace"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring peace to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 2
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 2954
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Faith"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to spread faith and belief from the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 8
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 3000
#damage 2955
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Growth"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring fertility and growth to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 6
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 3000
#damage 2952
#end 


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Courage"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring courage and bravery to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 7
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 2953
#end  


--------------------------------------------------------------------------------
#newspell
#name "Menhir of Death"
#descr "The caster invests tremendous magic into a carven, massive stone of granite, imbuing it with the power to bring courage and bravery to the province in which the stone rests.  The Menhir is lifeless and immobile, but hard to destroy."
#school 1
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 5
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 1000
#damage 2950
#end 


--------------------------------------------------------------------------------
#newspell
#name "Call Wraith King"
#descr "The caster summons a Nazgl, a dread Wraith King."
#school 0
#researchlevel 8
#path 0 5
#pathlevel 0 5
#path 1 1
#pathlevel 1 2
#fatiguecost 6600
#effect 10021
#nreff 1
#damage 2934
#end 


--------------------------------------------------------------------------------
#newspell
#copyspell 343
#name "Loki's Mirrors"
#descr "The caster blesses the entire army with a deceptive glamour from the trickster god of and deceptions, which creates illusionary images around all friendly troops. The more powerful the caster, the more images will appear.  The images will surround each unit and make it harder for enemies to figure out which one to strike.  The spell ends as soon as the unit is wounded."
#school 1
#researchlevel 9
#aoe 666
#pathlevel 0 5
#path 1 4
#pathlevel 1 1
#fatiguecost 500
#damage 16777216
#spec 4194304
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 665
#name "Aria Discordia"
#descr "The caster sings the forbidden words of Eris, the goddess of entropy, to sow chaos and confusion amongst all enemies.  Those affected by the aria often attack their own comrades, mistaking them for enemies."
#researchlevel 9
#aoe 666
#pathlevel 0 6
#spec 262144
#fatiguecost 400
#end


--------------------------------------------------------------------------------
#newspell
#copyspell 652
#name "Dirge of the Drowned Gods"
#descr "As the caster sings the terrible funeral song of the Drowned Gods, unprotected enemies across the battlefield will be compelled to raise their own voices in sympathy, their own throats filling with water.  Weak targets may be killed outright, but any enemy that cannot breathe water will take severe damage.  The stronger the caster, the greater number of targets are affected."
#researchlevel 8
#aoe 663
#pathlevel 0 5
#fatiguecost 200
#spec 545853568
#end


--------------------------------------------------------------------------------
#end



################################################################################
##   ID Assignment
################################################################################
-- Monsters/ Pretenders / Units ---------------
-- 2931 Assassin Spider
-- 2932 Assassin Mother
-- 2933 Empress of Assassins
-- 2934 Wraith King
-- 2935 Grim Reaper (summon)
-- 2936 Cthulu
-- 2937 Cthulu
-- 2938 Cthulu
-- 2939 Great Eye (astral I)
-- 2940 Great Eye (astral II)
-- 2941 Error <created a bug when used>
-- 2942 Great Eye (fire)
-- 2943 Error <created a bug when used>
-- 2944 Error <created a bug when used>
-- 2945 Great Eye (earth)
-- 2946 Great Eye (air)
-- 2947 Great Eye (water)
-- 2948 Error <created a bug when used>
-- 2949 Father of Medicine
-- 2950 Menhir of Death
-- 2951 Menhir of Fortune
-- 2952 Menhir of Growth 
-- 2953 Menhir of Courage 
-- 2954 Menhir of Peace 
-- 2955 Menhir of Faith 
-- 2956 Error <created a bug when used>
-- 2957 Error <created a bug when used>
-- 2958 Error <created a bug when used>
-- 2959 Gold Dragon
-- 2960 Gold Dragon 
-- 2961 Carrion Mage
-- 2962 Scarab
-- 2965 Monkey King
-- 2966 Toad Demon
-- 2967 Gold Dragon
-- 2968 Shadowcat
-- 2969 Cytherean Priestess
-- 2970 Black Dragon
-- 2971 Thunderbird
-- 2972 Thunderbird
-- 2973 Thunderbird
-- 2974 Carrion Lord
-- 2975 Great Egg
-- 2976 Great Egg
-- 2977 Great Egg
-- 2978 Small Fish
-- 2979 Portuguese Man O' War
-- 2980 Taoist Master
-- 2981 Fallen Archangel
-- 2982 Tarrasque
-- 2983 Shah of Djinn and Ifreet
-- 2984 Yggdrasil
-- 2985 Monkey King (Clone)
-- 2986 Error <creates a bug when used>
-- 2987 Monkey King
-- 2988 Monkey King
-- 2989 Grim Reaper
-- 2990 Grim Reaper
-- 2991 Grim Reaper
-- 2993 Desire
-- 2994 Pantokrator
-- 2995 Teratos Rex
-- 2996 Morpheus

-- Weapons ---------------------------------------
-- 805 Lightning Snake 
-- 804 Thunderclap
-- 803 Gold Band Staff
-- 802 Soul Scythe
-- 801 Crushbite
-- 800 Disintegration Breath
-- 799 Bite (magic)
-- 709 Claws (magic)
-- 797 Word of Might
-- 796 Tiny Bite (weakness)
-- 795 Nothing (for clearing copystats)



################################################################################
##   To Do List
################################################################################

-- other future experiments:
-- "Hand of Destiny" - chained battlefield spell that picks one random unit, and gives it Gift of Nature, regen, Army of Lead, Berserk and a few other superbuffs

-- mass phoenix pyre.  Effect 23, damage 134217728, copy fog warriors, 
-- cause fire suscept on friendlies: #spec 8404992 (this worked by accident)

-- future spell experiments - casting permabuffs on friendly provinces, just
-- the way leprosy and the above spells cast permanent mallus on enemy provs

-- scatter - #effect 20 spell that sends your units all over the field.  Probably useful for some strategy, like Howl only with your buffed troops.
-- http://www.shrapnelcommunity.com/threads/showflat.php?Cat=&Board=d3smm&Number=477135&Forum=f195&Words=blink&Searchpage=0&Limit=25&Main=477135&Search=true&where=bodysub&Name=&daterange=1&newerval=5&newertype=y&olderval=&oldertype=&bodyprev=#Post477135
-- ,maybe something that uses the "sorcery" or "elemental" paths as path
-- requirements just to be interesting
-- an underwater version of Sea of Scarabs to be fair?

-- Future pretender Ideas?
-- more dragons!
-- Merchant god... low on powers but increased growth/ $ and spread dominion?
-- The Great Kong!  My island worshippers, let me show you them.

-- someday when custom magic items are implemented...
	-- a conjuration, thaum, enchantment version of Dwarven hammer
	-- maybe a fire version of Dwarven hammer, less powerful - True Fire?


################################################################################
##   Custom Armor for Pretenders ( custom armors cause errors in current patch)
################################################################################
-newarmor 398
-name "Red Feather Cap"
-type 6
-prot 14
-def -1
-enc 0
-end

--------------------------------------------------------------------------------
-newarmor 399
-name "Golden Chain Mail"
-type 5
-prot 14
-def -2
-enc 0
-end

--------------------------------------------------------------------------------
-- for clearing armors left from copystats
-newarmor 250
-name " "
-type 5
-prot 0
-def 0
-enc 0
-end
