
#include "borderizer.hpp"

Borderizer::Borderizer(const char *pic,const char *map, int numprovince,bool draw)
{
    picture = load_bitmap(pic,0);
    bitmasks = load_bitmap(map,0);
    num_provinces = numprovince;
    draw_borders = draw;
}
void Borderizer::PlaceProvinces()
{
    srand ( time(NULL) );
    provinces = new Province[num_provinces];
    double res_ratio = ((double)picture->h)/picture->w;
    int height_provinces = sqrt(num_provinces*res_ratio);
    int width_provinces = sqrt(num_provinces/res_ratio);
    int diff = num_provinces - height_provinces*width_provinces;
    double diff_adder = ((double)diff) / height_provinces;

    int max_height_random = picture->h / height_provinces - 1;
    int max_width_random = picture->w / (width_provinces+1) - 1;

    int i,j;
    int tempx,tempy;
    int provinces_counter=0;
    double diff_counter=0;
    bool still_good=true;

    for (i=0;((i<height_provinces)&&(still_good));++i)
    {
        diff_counter+=diff_adder;
        if (diff_adder>1)
        {
            diff_adder-=1;
            for (j=0;((j<width_provinces+1)&&(still_good));++j)
            {
                tempx = j * max_width_random - max_width_random/2 + rand() / (RAND_MAX / max_width_random);
                tempy = i * max_height_random - max_height_random/2 + rand() / (RAND_MAX / max_height_random);
                provinces[provinces_counter].x = tempx;
                provinces[provinces_counter].y = tempy;
                provinces[provinces_counter].mask = getpixel(bitmasks,tempx,tempy);
                putpixel(picture,tempx,tempy,makecol(255,255,255));
                provinces_counter++;
                if (provinces_counter>=num_provinces)
                    still_good=false;
            }
        }
        else
        {
            for (j=0;((j<width_provinces)&&(still_good));++j)
            {
                tempx = j * max_width_random - max_width_random/2 + rand() / (RAND_MAX / max_width_random);
                tempy = i * max_height_random - max_height_random/2 + rand() / (RAND_MAX / max_height_random);
                provinces[provinces_counter].x = tempx;
                provinces[provinces_counter].y = tempy;
                provinces[provinces_counter].mask = getpixel(bitmasks,tempx,tempy);
                putpixel(picture,tempx,tempy,makecol(255,255,255));
                provinces_counter++;
                if (provinces_counter>=num_provinces)
                    still_good=false;
            }
        }
    }
    final_num_provinces=provinces_counter;
}
int Borderizer::PaintPoint(int x,int y,int mask,int pnum)
{
    if (x<0)
        x+=picture->w;
    if (y<0)
        y+=picture->h;
    if (x>=picture->w)
        x-=picture->w;
    if (y>=picture->h)
        y-=picture->h;
    if (getpixel(bitmasks,x,y)==mask)
    {
        if (getpixel(province_map,x,y)==0)
        {
            putpixel(province_map,x,y,pnum);
            return -1;
        }
        return getpixel(province_map,x,y);
    }
    return -2;
}

#define MAKE \
result = PaintPoint(x+provinces[i].x,y+provinces[i].y,provinces[i].mask,i); \
if (result==-1) \
{ \
    still_alive = true; \
    counter++; \
} \
if (result==-2) \
{ \
    if (draw_borders) \
    { \
        if (quarter==1) \
        { \
            XX = x+provinces[i].x+1; \
            YY = y+provinces[i].y-1; \
        } \
        if (quarter==2) \
        { \
            XX = x+provinces[i].x-1; \
            YY = y+provinces[i].y-1; \
        } \
        if (quarter==3) \
        { \
            XX = x+provinces[i].x-1; \
            YY = y+provinces[i].y+1; \
        } \
        if (quarter==4) \
        { \
            XX = x+provinces[i].x+1; \
            YY = y+provinces[i].y+1; \
        } \
        if (getpixel(province_map,XX,YY)==i) \
            circlefill(picture,x+provinces[i].x,y+provinces[i].y,1, red); \
    } \
} \
if (result>0) \
{ \
    if (result==i) \
    { \
        if ((previous_result!=result)&&(previous_result>0)) \
        { \
            connections[i][result]=true; \
            connections[result][i]=true; \
            if (draw_borders) \
                circlefill(picture,x+provinces[i].x,y+provinces[i].y,2, red); \
        } \
    } \
    else \
    { \
        if ((previous_result!=result)&&(previous_result>=0)) \
        { \
            connections[i][result]=true; \
            connections[result][i]=true; \
            if (draw_borders) \
                circlefill(picture,x+provinces[i].x,y+provinces[i].y,2, red); \
        } \
    } \
} \
previous_result=result;
//TEMPPRINT();

void Borderizer::MakeBorders()
{
    province_map = create_bitmap(picture->w,picture->h);
    clear_to_color(province_map,0);
    connections = new bool * [final_num_provinces];
    int Z;
    for (int k=0;k<final_num_provinces;++k)
    {
        connections[k] = new bool [final_num_provinces];
        for (Z=0;Z<final_num_provinces;++Z)
            connections[k][Z] = false;
    }
    clear_bitmap(province_map);
    int active_provinces=final_num_provinces;
    int i;
    int r=1;
    int result;
    int previous_result;
    int quarter;
    int XX,YY;

    int x,y;

    bool still_alive;

    int red = makecol(255,0,0);

    int counter;

    while (active_provinces>0)
    {
        for (i=0;i<final_num_provinces;++i)
        {
            if (provinces[i].alive)
            {
                counter=0;
                still_alive = false;
                ///CIRCLE
                //MAKE
                x=-r;
                y=0;
                quarter=1;
                previous_result = PaintPoint(x+1+provinces[i].x,y+provinces[i].y,provinces[i].mask,i);
                while (x<0)
                {
                    do
                    {
                        MAKE
                        ++y;
                    }
                    while (x*x+y*y < r*r+1);
                    --y;
                    ++x;
                }
                x=0;
                y=r;
                quarter=2;
                while (y>0)
                {
                    do
                    {
                        MAKE
                        ++x;
                    }
                    while (x*x+y*y < r*r+1);
                    --x;
                    --y;
                }
                x=r;
                y=0;
                quarter=3;
                while (x>0)
                {
                    do
                    {
                        MAKE
                        --y;
                    }
                    while (x*x+y*y < r*r+1);
                    ++y;
                    --x;
                }
                x=0;
                y=-r;
                quarter=4;
                while (y<0)
                {
                    do
                    {
                        MAKE
                        --x;
                    }
                    while (x*x+y*y < r*r+1);
                    ++x;
                    ++y;
                }

                if (counter < (AL_PI * r)/4 )
                    still_alive=false;

                if (!still_alive)
                {
                    active_provinces--;
                    provinces[i].alive=false;
                }
            }
        }
        r++;
    }
    blit(province_map,screen,0,0,0,0,province_map->w,province_map->h);
}
void Borderizer::BinaryEroder()
{
    BITMAP *temp =create_bitmap(province_map->w,province_map->h);
    int i,j,k,l,x,y,max,maxin;
    int *possibilities = new int[final_num_provinces];
    for (i=0;i<province_map->w;++i)
    {
        for (j=0;j<province_map->h;++j)
        {
            for (k=0;k<final_num_provinces;++k)
                possibilities[k]=0;
            for (k=i-1;k<i+2;++k)
            {
                for (l=j-1;l<j+2;++l)
                {
                    y = l%province_map->h;
                    if (y<0)
                        y+=province_map->h;
                    x = k%province_map->w;
                    if (x<0)
                        x+=province_map->w;
                    possibilities[getpixel(province_map,x,y)]+=1;
                }
            }
            max=0;
            maxin=getpixel(province_map,i,j);
            for (k=1;k<final_num_provinces;++k)
            {
                if (possibilities[k]>max)
                {
                    max=possibilities[k];
                    maxin=k;
                }
            }
            putpixel(temp,i,j,maxin);
        }
    }

    blit(temp,province_map,0,0,0,0,temp->w,temp->h);
    destroy_bitmap(temp);
}
void Borderizer::DrawBordersLong()
{
    int col1,col2,red=makecol(255,0,0);
    int i,j;
    for (i=0;i<province_map->w-1;++i)
    {
        for (j=0;j<province_map->h-1;++j)
        {
            col1=getpixel(province_map,i,j);
            col2=getpixel(province_map,i+1,j);
            if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
            {
                    circlefill(picture,i,j,2,red);
            }
            else
            {
                col1=getpixel(province_map,i,j);
                col2=getpixel(province_map,i,j+1);
                if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
                {
                    circlefill(picture,i,j,2,red);
                }
            }
        }
        col1=getpixel(province_map,i,j);
        col2=getpixel(province_map,0,j);
        if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
        {
            circlefill(picture,i,j,2,red);
        }
        else
        {
            col1=getpixel(province_map,i,j);
            col2=getpixel(province_map,i,j+1);
            if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
            {
                circlefill(picture,i,j,2,red);
            }
        }
    }
    j=province_map->h-1;
    for (i=0;i<province_map->w-1;++i)
    {
        col1=getpixel(province_map,i,j);
        col2=getpixel(province_map,i+1,j);
        if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
        {
            circlefill(picture,i,j,2,red);
        }
        else
        {
            col1=getpixel(province_map,i,j);
            col2=getpixel(province_map,i,0);
            if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
            {
                circlefill(picture,i,j,2,red);
            }
        }
    }
    col1=getpixel(province_map,province_map->w,province_map->h);
    col2=getpixel(province_map,0,province_map->h);
    if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
    {
        circlefill(picture,i,j,2,red);
    }
    else
    {
        col1=getpixel(province_map,province_map->w,province_map->h);
        col2=getpixel(province_map,province_map->w,0);
        if ((col1!=col2)&&((col1!=0)&&(col2!=0)))
        {
            circlefill(picture,i,j,2,red);
        }
    }
}
/*if ((col1==0)||(col2==0))
                    putpixel(picture,i,j,red);
                else*/
