-- Adds the DRN (Dominions Random Number) system.
-- This is essentially an open ended 2d6 roll.
-- This means that two six sided dice are rolled, any of the two dice
-- that come up as six are rerolled and the new roll added to the total.
-- If rerolls are sixes they are further rolled again, ad infinitum.

-- The two functions could easily be combined into one.  At the time
-- I wrote this I was simply struggling with how to make and open
-- ended roll work at all.

-- This function performs one open ended six sided roll.
function rng.open()
	local t
	local r

	t = 0
	r = rng(6)
	t = r
	while r == 6 do
		r = rng(6)
		t = t + r - 1
	end

	return t
end

-- This function invokes the function to do one open ended six sided roll twice and adds the results.
function rng.drn()
	local die1 = rng.open()
	local die2 = rng.open()
	local drn = die1 + die2
	return drn
end

