-- This file takes care of the schools of magic

declare_global_constants
{
	"SCHOOL_DEVICE",
	"make_breath",
	"increase_mana",
}

-- This returns a nil value on functions calling for mana.
-- This is required since mana isn't used in dominion's system
-- and no mana calculating functions are enabled.  However, the
-- spell system isn't very modular, and requires values for all
-- the things that the original angband spell systems used.
-- Unfortunately, a 'minimum' failure rate of 5% is hardcoded, and
-- I havn't been able to get around it yet.
function player.csp() return 0 end
function increase_mana() return end
function player.spell_chance_get_fails()
	local fail_adj = 0
	local fail_min = 0
	return fail_adj, fail_min
end

-- Create the schools
SCHOOL_DEVICE = add_school
{
	name = "Device",
	skill = "SKILL_NONE",
}

-- Functions to automate breath, ball and bolt spells and add trap info
-- for balls and bolts. trap damage is now scaled with level, and may be
-- too powerful at high depths. I have generally made max trap damage
-- equal to max breath damage of the same type, with exception to some
-- of the irresistable types which are more powerful as traps than as
-- breaths. no irresistable traps do more than 600 damage.

-- This is a good example, but it isn't really used at the moment.
-- Perhaps it will be someday.
function make_breath(type)
	local name = get_dam_type_info(type, "desc")
	add_monster_spell
	{
		name	= "Breathe "..name,
		action	= "@Source@ breathes "..name.." at @target@.",
		spell	= function()
			local ret, dir = get_aim_dir()
			if not ret then return SPELL_NOTHING end
			local dam = get_cast_level(100)
			fire_cone(%type, dir, dam, 1 + get_cast_level(3))
			return true
		end,
	}
end
make_breath(dam.FIRE)
make_breath(dam.COLD)

-- Add the Spells
load_spells("astral.lua")
load_spells("death.lua")