-- The fatigue subsystem
--
-- counter.FATIGUE is the player fatigue counter
-- counter.MONST_FAT is the monster fatigue counter
-- decrease_fatigue() and increase_fatigue() are functions to decrease
-- and increase the counter respectively.
--
-- player.cfat() and player.mfat() are functions to return the player's
-- current counter value and the maximum counter value respectively.
--
-- monst.cfat() and monst.mfat() are functions to return the monster's
-- current counter value and maximum coutner value respectively
--
-- both player and monster counters also handle killing the player
-- or monster when fatigue goes over a certain amount

declare_global_constants
{
	"decrease_fatigue",
	"increase_fatigue",
	"decrease_monst_fat",
	"increase_monst_fat",
	"monst",
}


-- Player fatigue counter

new_flag("REINVIG")
new_flag("EXHAUST")

hook.new_hook_type("PLAYER_INCREASE_FATIGUE")
counter.create
{
	name = "FATIGUE"
	min = 0
	max = 200
	reset = "min"

	-- the following function will happen each time the counter decreases
	on_decrease = function(value, modif, reason)
		local ret, new_modif = hook.process(hook.PLAYER_INCREASE_FATIGUE, value, modif)
		if ret then
			modif = new_modif
		end

		player.redraw[FLAG_PR_FATIGUE] = true
		player.window[FLAG_PW_PLAYER] = true
		return true, modif
	end

	-- the following function will happen each time the counter increases
	on_increase = function(value, modif, reason)

		-- Check to see if player died from fatigue
		if value + modif > 200 then
			message(color.RED, "You die.")
			kill_player(reason)
		end
		
		player.redraw[FLAG_PR_FATIGUE] = true
		player.window[FLAG_PW_PLAYER] = true
	end

	-- this reinvigorates the player's fatigue over time
	auto_regen = function()
		local nb = player.reinvig()
		if nb ~= 0 then
			local amt  = nb / 1000
			local im   = imod(abs(nb), 1000)

			if im ~= 0 then
				if imod(turn / 10, 1000 / im) == 0 then
					local sign = nb / abs(nb)
					amt = amt + (1 * sign)
				end
			end

			if amt ~= 0 then

				-- Ensure fatigue doesn't go negative
				local cur = counter.get(counter.FATIGUE)
				if cur + amt < 0 then
					amt = -cur
				end

				if cur == -amt and cur > 0 then
					term.disturb(0, 0)
				end					

				return amt
			end
		end
	end
}

function decrease_fatigue(reinvig)
	counter.dec(counter.FATIGUE, reinvig)
end

function increase_fatigue(exh, die_from)
	counter.inc(counter.FATIGUE, exh, die_from)
end

function player.cfat(val)
	if val then counter.set(counter.FATIGUE, val, "setting fatigue") end
	return counter.get(counter.FATIGUE)
end

function player.mfat(val)
	return counter.max(counter.FATIGUE, val)
end

function player.reinvig()
	return player.intrinsic(FLAG_REINVIG) - player.intrinsic(FLAG_EXHAUST)
end


-- Monster fatigue counter

--new_flag("MONST_REINVIG")
--new_flag("MONST_EXHAUST")

monst = {}

hook.new_hook_type("MONST_INCREASE_FATIGUE")
counter.create
{
	name = "MONST_FATIGUE"
	min = 0
	max = 200
	reset = "min"

	on_decrease = function(value, modif, m_idx)
		return true, modif
	end
	on_increase = function(value, modif, m_idx)

		-- get the monster
		local monst = monster(m_idx)

		-- Check to see if its dead
		if value + modif > 200 then
			project(WHO_PLAYER, 0, monst.fy, monst.fx, 999, dam.PURE, PROJECT_JUMP | PROJECT_HIDE | PROJECT_HIDE_BLAST | PROJECT_STOP | PROJECT_KILL | PROJECT_NO_REFLECT)
		end
	end

--[[ -- no regen for monsters yet

	auto_regen = function()
		local nb = monst.reinvig()
		if nb ~= 0 then
			local amt  = nb / 1000
			local im   = imod(abs(nb), 1000)

			if im ~= 0 then
				if imod(turn / 10, 1000 / im) == 0 then
					local sign = nb / abs(nb)
					amt = amt + (1 * sign)
				end
			end

			if amt ~= 0 then
				-- Ensure fatigue doesn't go negative
				local cur = counter.get(counter.MONST_FATIGUE)
				if cur + amt < 0 then
					amt = -cur
				end

				if cur == -amt and cur > 0 then
					term.disturb(0, 0)
				end					

				return amt
			end
		end
	end
]]
}

function counter.m_inc(cnt, val, m_idx)
	-- get monster
	local monst = monster(m_idx)
	
	-- set the counter
	monst.cfat(monst.flags[FLAG_MONST_FAT])
	
	-- Check to see if the counter should be processing on_increase
	-- or on_decrease commands
	if val < 0 then
		if counter.__counters[cnt].on_decrease then
			local ret, new_val
			ret, new_val = counter.__counters[cnt].on_decrease(counter.__state[cnt].cur, val, unpack(arg))
			if ret then val = new_val end
		end
	else
		if counter.__counters[cnt].on_increase then
			local ret, new_val
			ret, new_val = counter.__counters[cnt].on_increase(counter.__state[cnt].cur, val, unpack(arg))
			if ret then val = new_val end
		end
	end

	if val == 0 then return end

	-- increase the counter
	counter.__state[cnt].cur = counter.__state[cnt].cur + val
	if counter.__state[cnt].cur < counter.__state[cnt].min then
		counter.__state[cnt].cur = counter.__state[cnt].min
	elseif counter.__state[cnt].cur > counter.__state[cnt].max then
		counter.__state[cnt].cur = counter.__state[cnt].max
	end
	
	-- set the monster's new fatigue setting
	monst.flags[FLAG_MONST_FAT] = counter.__state[cnt].cur

	return true
end

function counter.m_dec(cnt, val, m_idx)
	return counter.m_inc(cnt, -val, m_idx)
end


function decrease_monst_fat(reinvig, m_idx)
	counter.m_dec(counter.MONST_FATIGUE, reinvig, m_idx)
end

function increase_monst_fat(exh, m_idx)
	counter.inc(counter.MONST_FATIGUE, exh, m_idx)
end

function monst.cfat(val)
	if val then counter.set(counter.MONST_FATIGUE, val, "setting fatigue") end
	return counter.get(counter.MONST_FATIGUE)
end

function monst.mfat(val)
	return counter.max(counter.MONST_FATIGUE, val)
end

--[[
function monst.reinvig()
	return monster(m_idx).intrinsic(FLAG_MONST_REINVIG) - monster(m_idx).intrinsic(FLAG_MONST_EXHAUST)
end
]]
