-- Dominions target functions

function target.deviate(y, x, dist, prec)
-- y is target y
-- x is target x
-- dist is source to target distance
-- prec is the precision of the source

	if dist > ((prec / 2) - 2) then
		local dev = (dist * (5 / 4)) / prec
		local vy = rng(-dev, dev)
		local vx = rng(-dev, dev)
		local cov = 0

		-- count diagonal steps
		-- don't divide by zero
		if vy < 0 and vx < 0 then
			if vy <= vx then
				cov = abs(vy) / abs(vx)
			else
				cov = abs(vx) / abs(vy)
			end
		else
				cov = 0
		end
		local div = (cov * (1 / 2)) + 1

		-- modify where the missile was dropped to make it a circle
		vy = vy / div
		vx = vx / div

		-- set the new y, x
		y = y + vy
		x = x + vx
	end

	-- return y, x
	return y, x
end

--[[
function target.multi()
	local ret, dir = get_aim_dir
	local y, x = target.get_coords(dir)
	if ret then
		return ret, y, x
	end

-- Clear out old targeting info when current target dies
hook(hook.MONSTER_DEATH,
function(m_idx, who)
	if getn(old_target_who) > 0 then
		if old_target_who[1] == m_idx then
			old_target_who[1] = -1
			old_target_col[1] = -1
			old_target_row[1] = -1
		end
	elseif target_who == m_idx then
		target_who = -1
		target_col = -1
		target_row = -1
	end
end)
]]