-- Here we define items and their defaults
-- The wild_slot flag allows to define in whcih equipment slots the
-- item will go
-- & = a/an
-- ~ = pluralisation(s or not)

new_item_kinds
{
	[TV_UNARMED] =
	{
		color = color.WHITE
		name = "Unarmed"
		desc =
		{
			"Natural weapons.",
		}
		defaults = 
		{
			flags =
			{ 
				WEAPON		= true
				WIELD_SLOT	= INVEN_UNARMED
			}
		}
		[SV_FIST] =
		{
			name = "& fist~"
			display = '.' color = color.WHITE
			desc =
			{
				"fist.",
			}
			level = 0 weight = 0 cost = 0
			allocation =
			{
				{0,200}
			}
			flags =
			{
				DAM	= getter.damages{MELEE={-2,-2}}
				ITEM_ATT	= -1
				ITEM_DEF	= -1
			}
		}
	}
	[TV_WEAPON] =
	{
		color = color.WHITE
		name = "Weapons"
		desc =
		{
			"Weapons.",
		}
		defaults = 
		{
			flags =
			{ 
				WEAPON		= true
				WIELD_SLOT	= INVEN_MAINHAND
			}
		}
		[SV_DAGGER] =
		{
			name = "& dagger~"
			display = '|' color = color.WHITE
			desc =
			{
				"A short bladed weapon.",
			}
			level = 0 weight = 1 cost = 0
			allocation =
			{
				{0,1}, {1,1}
			}
			flags =
			{
				DAM	= getter.damages{MELEE={2,2}}
				ITEM_ATT	= 1
				ITEM_DEF	= 0
				ITEM_LEN	= 0
			}
		}
		[SV_SHORT_SWORD] =
		{
			name = "& short sword~"
			display = '|' color = color.WHITE
			desc =
			{
				"A bladed weapon.",
			}
			level = 0 weight = 1 cost = 0
			allocation =
			{
				{0,1}, {1,1}
			}
			flags =
			{
				DAM	= getter.damages{MELEE={5,5}}
				ITEM_ATT	= 0
				ITEM_DEF	= 1
				ITEM_LEN	= 1
			}
		}
	}
	[TV_BOW] =
	{
		color = color.UMBER
		name = "bows"
		desc = "Used for firing projectiles."
		symbol = '}'
		defaults =
		{
			display = '}' color = color.UMBER
			flags =
			{
				WIELD_SLOT	= INVEN_OFFHAND
				MISSILE		= true
			}
		}
		[SV_SHORT_BOW] =
		{
			name = "& short bow~"
			desc =
			{
				"A short bow"
			}
			level = 0 weight = 1 cost = 0			
			allocation =
			{
				{0,1}
			}
			flags =
			{
				DAM = getter.damages{MISSILE = {12,12}}
				BASE_RANGE	= 25
				COULD2H		= obvious(true)
				AMMO_CURRENT= obvious(999)
				AMMO_MAX	= obvious(999)
			}
		}
	}
	[TV_ARMOR] =
	{
		color = color.SLATE
		name = "Armor"
		desc =
		{
			"Armor.",
		}
		defaults =
		{
			flags =
			{
				WIELD_SLOT	= INVEN_BODY
			}
		}
		[SV_ROBES] =
		{
			name = "& robe~"
			display = '(' color = color.BLUE
			desc =
			{
				"A full-length garment which can be worn on the body. It is not really",
				"armour, but mages often wear them as they are very light and don't hinder",
				"movement much."
			}
			level = 0 weight = 1 cost = 0
			allocation =
			{
				{0,1}
			}
			ac = 2
			flags =
			{
				ENCUM	= 0
			}
		}
		[SV_LEATHER_CUIRASS] =
		{
			name = "& leather cuirass~"
			display = '(' color = color.LIGHT_UMBER
			desc =
			{
				"Leather cuirass"
			}
			level = 0 weight = 1 cost = 0
			allocation =
			{
				{1,1}
			}
			ac = 6
			flags =
			{
				ENCUM	= 0
			}
		}
	}
	[TV_CORPSE] =
	{
		color = color.LIGHT_UMBER
		name = "Corpse"
		desc =
		{
			"Something has died, leaving this empty husk behind,",
			"and going on to someplace better than this foul world.",
		}
		[SV_CORPSE_CORPSE] =
		{
			name = "corpse"
			display = '~' color = color.RED
			desc =
			{
				"Whatever happened with this one, it wasn't pretty."
			}
			level = 0 weight = 80 cost = 0
			allocation = { {0,200} }
			flags =
			{
				DECAY	= true
			}
		}
	}
--
--
--
	[TV_LITE] =
	{
		color = color.YELLOW
		name = "lites"
		desc =
		{
			"These may enable you to see in the depths of the dungeon.",
		}
		symbol = '~'
		defaults =
		{
			flags =
			{
				WIELD_SLOT	= INVEN_LITE
			}
		}

		[SV_LANTERN] =
		{
			name = "& lantern~"
			display = '~' color = color.LIGHT_RED
			level = 1 weight = 50 cost = 2500
			allocation = { {1,1} }
			flags =
			{
				LITE  = obvious(2)
				EASY_KNOW = true
			}
		}
	}
	[TV_FOOD] =
	{
		color = color.LIGHT_UMBER
		name = "Food"
		desc =
		{
			"Edible items may have mysteries effects. Or maybe",
			"just something to much on when you get hungry",
		}
		[SV_FOOD_RATION] = {
			name = "& ration~ of food"
			display = ',' color = color.LIGHT_UMBER
			desc =
			{
				"Lightweight and filling. Not an incredible taste experience, but that'd be asking a bit much.",
				"You can 'E'at it."
			}
			level = 0 weight = 10 cost = 3
			allocation = { {0,1}, {5,1}, {10,1} }
			flags =
			{
			}
		}
	}
	[TV_GOLD] =
	{
		color = color.YELLOW
		name = "Gold"
		desc =
		{
			"All that gliters is not go..mhh..all that gliters is MINE MINE MINE!!",
		}
		[1] =
		{
			name = "gold"
			display = '$' color = color.UMBER
			level = 1 weight = 0 cost = 1
			flags =
			{
				GOLD_VALUE	= 10
			}
		}
	}
}

-- not using these at the moment
--[[		[SV_FIRE_BRAND] =
		{
			name = "& Fire Brand~"
			display = '|' color = color.RED
			desc =
			{
				"Fire Brand.",
			}
			level = 0 weight = 1 cost = 0
			allocation =
			{
				{0,10}
			}
			flags =
			{
				DAM			= getter.damages{MELEE={12,12}}
				ITEM_MOR	= 2
				ITEM_ATT	= 4
				ITEM_DEF	= 1
--				ITEM_LEN	= 2
				AP			= true
--				FIRE_RESIST	= 50
--				ON_TARGET	= FIRE
			}
		}
	}]]
--[[	[TV_ARROW] =
	{
		color = color.UMBER
		name = "arrows"
		desc =
		{
			"Ammunition for anybody who has a bow.",
		}
		symbol = '{'
		defaults =
		{
			flags =
			{
				WEAPON	   = obvious(true)
				WIELD_SLOT = INVEN_AMMO
				BREAKAGE_CHANCE = 25
			}
			display = '{' color = color.UMBER
		}

		[SV_ARROW] =
		{
			name = "& arrow~"
			desc =
			{
				"A pointy arrow"
			}
			level = 1 weight = 2 cost = 1
			allocation = { {1,1} }
			flags =
			{
				DAM = getter.damages{PIERCE = {1,4}}
			}
		}
	}
]]
--[[
		[SV_MARBLE_ARMOR] =
		{
			name = "& Marble Armor~"
			display = ']' color = color.LIGHT_UMBER
			desc =
			{
				"Marble Armor"
			}
			level = 1 weight = 20 cost = 4
			allocation =
			{
				{1,10}
			}
			ac = 23
			flags =
			{
				ENCUM		= 3
				ITEM_DEF	= -1
--				ITEM_STONE	= true
			}
		}
]]