-- The Dominions melee combat subsystem

-- Load the basic combat system.  It contains things that all combat systems may use.
load_subsystem("combat")

constant("COMBAT_WEAPON", add_combat_system
{
	name = "Weapon fighting",
	desc = "Uses various weapons to inflict pain and suffering.",
	skill = "SKILL_NONE",
	energy = function() return get_player_energy(SPEED_WEAPON) end,
	info = function() return "???" end,
	available = function() return true end,

	attack = function(y, x, max)
		-- Only attack if there is a monster
		local m_idx = cave(y,x).m_idx
		if m_idx == 0 then return end

		-- Get the monster.
		local monst = monster(m_idx)
		
		-- Increase fatigue.
		local encum = player.get_encum()
		increase_fatigue(encum)
		
		-- Do DRN rolls for attack and defense.
		local attroll = rng.drn()
		local defroll = rng.drn()
		
		-- Add attack and defense skills and weapon modifiers to the rolls
		attroll = attroll + player.stat(A_ATTACK) + player.get_weap(FLAG_ITEM_ATT)
		defroll = defroll + monst.flags[FLAG_MONST_DEF]
		
		-- Subtract fatigue penalties from attack and defense rolls
		attroll = attroll - (player.cfat() / 20)
		defroll = defroll - (monst.flags[FLAG_MONST_FAT] / 10)
		
		
		-- Compare the rolls and see if a hit occurs.
		if attroll > defroll then

			-- We hit.  First check for a critical hit.
			local ac = monst.ac
			local critroll = rng.drn()
			if (critroll - (monst.flags[FLAG_MONST_FAT] / 15 )) < 2 then

				-- We critical hit.  Halve monster protection.
				ac = ac / 2
			end	
		
			-- Now do DRN rolls for damage and protection
			local damroll = rng.drn()
			local protroll = rng.drn()
			
			-- Get the weapon damage and type
			local weapon = player.get_weap(FLAG_DAM)
			local typ = flag_max_key(weapon)
			
			-- Add strength/weapon damage and monster protection to rolls
			damroll = damroll + player.stat(A_STRENGTH) + (rng(flag_get(weapon, typ), flag_get2(weapon, typ)))
			protroll = protroll + ac

			-- Compare the rolls and see if damage was inflicted.
			local dam = damroll - protroll
			if dam > 0 then

				-- We did damage.
				project(WHO_PLAYER, 0, y, x, dam, typ, PROJECT_JUMP | PROJECT_HIDE | PROJECT_STOP | PROJECT_KILL | PROJECT_NO_REFLECT)
			
			-- If damage > protection, then the function will jump to the end,
			-- this avoids healing through projecting 'negative damage'
			end

		-- If the attack roll failed, then the function will jump to the end,
		-- and no damage will be computed
		end
	end,

	hooks	=
	{
	},
})