#    Copyright 2008 Chandler "Omnirizon" Armstrong
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import string
import pygame
import pygame.font
from pygame.locals import *

class glyph():


	def __init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos):

		self.screen					= screen
		self.font					= font
		self.bg						= bg
		self.margin					= margin
		self.linew					= linew
		self.lineh					= lineh
		self.vr						= vr
		self.vrectpos				= vrectpos
		self.vpge					= 0
		self.pgew					= self.linew - self.margin
		self.pge					= 0
		self.txth					= 0
		self.txt					= {}
		self.txt[self.pge]			= {}
			

	def wrap(self, pge):

		lines = pge.split('\n')
		pge = []

		for line in lines:

			if self.font.size(line)[0] > self.pgew:
				words = line.split(' ')
				for w in words:

					if self.font.size(w)[0] >= self.pgew:
						print("The word " + w + " is " + str((self.font.size(w)[0] - self.pgew)) + " pixels too long to fit in the rect passed.")

				line = ""

				for w in words:
					test = line + w + " "   

					if self.font.size(test)[0] < self.pgew:
						line = test

					else:
						pge.append(line)
						line = w + " "

				pge.append(line)

			else:
				pge.append(line)

		return pge



class scroller(glyph):


	def __init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos):
		glyph.__init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos)
		self.vpos		= vr
		self.vmin		= vr
		

	def input(self, txt, color):

		txt = txt.split('\f')
		addpge = 0

		for pge in txt:
			pge = self.wrap(pge)

			for line in pge:
				line = self.font.render(line, 0, color)
				pos = (self.margin, self.txth)
				self.txth = self.txth + self.lineh
				self.txt[self.pge][pos] = line
				self.vpos = self.vpos - self.lineh

			if addpge == 1:
				self.txth = 0
				self.pge = self.pge + 1
				self.txt[self.pge] = {}

			addpge = 1

			self.vmin = self.vpos


	def output(self, scroll = 0, pge = 0):
		v = pygame.Surface((self.linew, self.vr))
		v.fill(self.bg)

		surf = pygame.Surface((self.linew, self.txth))
		surf.fill(self.bg)

		self.vpge = self.vpge + pge

		for pos in self.txt[self.vpge].iterkeys():
			line = self.txt[self.vpge][pos]
			surf.blit(line, pos)

		self.vpos = self.vpos + scroll

		if scroll != 0:
			print(self.vmin)
			print(self.vpos)
			print(self.vr)

		if self.vpos < self.vmin or self.vpos > self.vr:
			self.vpos = self.vpos - scroll

		v.blit(surf, (0, self.vpos))

		self.screen.blit(v, self.vrectpos)



class pager(glyph):


	def __init__(self, screen, font, color, bg, margin, linew, lineh, pgeh, vr, vrectpos):
		glyph.__init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos)
		self.color	= color
		self.pgeh	= pgeh
		self.vpos	= 0


	def input(self, txt):

		txt = txt.split('\f')

		for pge in txt:
			pge = self.wrap(pge)

			for line in pge:
				line = self.font.render(line, 0, self.color)
				pos = (self.margin, self.txth)
				self.txth = self.txth + self.lineh

				if self.txth <= self.pgeh:
					self.txt[self.pge][pos] = line

				else:
					self.txth = 0
					self.pge = self.pge + 1
					self.txt[self.pge] = {}
					pos = (self.margin, self.txth)
					self.txt[self.pge][pos] = line
					self.txth = self.txth + self.lineh

			self.txth = 0
			self.pge = self.pge + 1
			self.txt[self.pge] = {}


	def output(self, pge = 0, scroll = 0):

		v = pygame.Surface((self.linew, self.vr))
		v.fill(self.bg)

		surf = pygame.Surface((self.linew, self.pgeh))
		surf.fill(self.bg)

		self.vpge = self.vpge + pge

		if self.vpge == -1 or self.vpge > self.pge:
			self.vpge = self.vpge - pge

		for pos in self.txt[self.vpge].iterkeys():
			line = self.txt[self.vpge][pos]
			surf.blit(line, pos)

		self.vpos = self.vpos + scroll
		v.blit(surf, (0, self.vpos))

		self.screen.blit(v, self.vrectpos)



class selecter(glyph):


	def __init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos):
		glyph.__init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos)
		self.vpos				= 0
		self.select				= {}
		self.select[self.pge]	= {}


	def input(self, txt, coloroff, coloron, bg = None):

		txt = txt.split('\f')
		addpge = 0

		for pge in txt:
			pge = self.wrap(pge)

			for line in pge:
				lineoff = self.font.render(line, 0, coloroff)
				lineon = self.font.render(line, 0, coloron, bg)
				pos = (self.margin, self.txth)
				self.txth = self.txth + self.lineh
				self.txt[self.pge][pos] = {}
				self.txt[self.pge][pos][0] = lineoff
				self.txt[self.pge][pos][1] = lineon
				self.select[self.pge][pos] = line

			if addpge == 1:
				self.txth = 0
				self.pge = self.pge + 1
				self.txt[self.pge] = {}
				self.select[self.pge]	= {}

			addpge = 1


	def output(self, mpos, scroll = 0, pge = 0, sel = None, selpos = None):

		v = pygame.Surface((self.linew, self.vr))
		v.fill(self.bg)

		surf = pygame.Surface((self.linew, self.txth))
		surf.fill(self.bg)

		self.vpge = self.vpge + pge

		for pos in self.txt[self.vpge].iterkeys():

			line = self.txt[self.vpge][pos][0]
			rpos = (self.vrectpos[0], (pos[1] + self.vrectpos[1]))
			rsize = line.get_size()
			rect = pygame.rect.Rect(rpos, rsize)

			if rect.collidepoint(mpos):
				line = self.txt[self.vpge][pos][1]
				surf.blit(line, pos)
				sel = self.select[self.vpge][pos]
				selpos = self.vpge, pos

			else:
				surf.blit(line, pos)

		self.vpos = self.vpos + scroll
		v.blit(surf, (0, self.vpos))

		self.screen.blit(v, self.vrectpos)

		return sel, selpos


	def update(self, input, pos, coloroff, coloron, bg = None):

		lineoff = self.font.render(input, 0, coloroff)
		lineon = self.font.render(input, 0, coloron, bg)

		self.txt[pos[0]][pos[1]] = {}
		self.txt[pos[0]][pos[1]][0] = lineoff
		self.txt[pos[0]][pos[1]][1] = lineon
		self.select[pos[0]][pos[1]] = input



class editor(glyph):


	def __init__(self, screen, font, color, bg, margin, linew, lineh, pgeh, vr, vrectpos):
		glyph.__init__(self, screen, font, bg, margin, linew, lineh, vr, vrectpos)
		self.color	= color
		self.pgeh	= pgeh
		self.char	= self.margin
		self.vpos	= 0
		self.input	= []


	def edit(self, event, pge = 0, scroll = 0):

		if event.type == KEYDOWN:

			if event.key == K_RETURN:
				self.input.append('\n')
				self.txth = self.txth + self.lineh
				self.char = self.margin

				if self.txth >= self.pgeh:
					self.txth = 0
					self.pge = self.pge + 1
					self.txt[self.pge] = {}

			elif event.key == K_BACKSPACE:

				self.input = self.input[0:-1]

				if self.txth == 0 and self.char == 0:
					del self.txt[self.pge]
					if self.page != 0:
						self.pge = self.pge - 1
					self.txth, self.char = max([(b, a) for a, b in self.txt[self.pge]])

				else:
					self.txth, self.char = max([(b, a) for a, b in self.txt[self.pge]])
					pos = (self.char, self.txth)
					del self.txt[self.pge][pos]

			else:
				self.input.append(event.unicode.encode("ascii"))
				char = self.font.render(event.unicode.encode("ascii"), 0, self.color)
				pos = (self.char, self.txth)
				self.char = self.char + self.font.size(self.input[-1])[0]

				if (self.char + (self.margin * 2)) < self.pgew:
					self.txt[self.pge][pos] = char

				else:
					self.char = self.margin
					self.txth = self.txth + self.lineh
					pos = (self.char, self.txth)

					if self.txth <= self.pgeh:
						self.txt[self.pge][pos] = char

					else:
						self.txth = 0
						self.pge = self.pge + 1
						pos = (self.char, self.txth)
						self.txt[self.pge] = {}
						self.txt[self.pge][pos] = char

		v = pygame.Surface((self.linew, self.vr))
		v.fill(self.bg)

		surf = pygame.Surface((self.linew, self.pgeh))
		surf.fill(self.bg)

		self.vpge = self.vpge + pge

		if self.vpge == -1 or self.vpge > self.pge:
			self.vpge = self.vpge - pge

		for pos in self.txt[self.vpge].iterkeys():
			char = self.txt[self.vpge][pos]
			surf.blit(char, pos)

		self.vpos = self.vpos + scroll
		v.blit(surf, (0, self.vpos))

		self.screen.blit(v, self.vrectpos)