using System;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Windows.Forms;


namespace LOLGameServer
{
	public class GameServerAccess : Base_GameServer
	{
		public System.Windows.Forms.RichTextBox Messages;

		public GameServerAccess(RichTextBox messages)
		{
			Messages = messages;

			base.StartServer();
		}

		public override void LogMessage(string message) 
		{
			if (Messages.Text.Length>0)
			{
				Messages.AppendText(System.Environment.NewLine);
			}
			Messages.AppendText(message);
			Messages.Select();
			Messages.SelectionStart=Messages.Text.Length;
			Messages.ScrollToCaret();
		}

		public override void Dispose()
		{
			base.Dispose();
		}

		public override void ShutDown()
		{
			base.ShutDown();
		}
	}

	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class LOLGameServer : System.Windows.Forms.Form
	{

		#region Static Methods
		#endregion

		#region Static Variables
		#endregion
	    
		#region Constants
		#endregion
	    
		#region private member variables
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private GameServerAccess _gameServer;

		private System.Windows.Forms.RichTextBox Messages;
		private System.Windows.Forms.Button ShutDown;
		#endregion

		#region Constructor
		public LOLGameServer()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//let's make the game server start listening for internet connections
			_gameServer = new GameServerAccess(Messages);
		}

		#endregion

		#region Dispose / Destructor
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			_gameServer.Dispose();

			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{

			this.Messages = new System.Windows.Forms.RichTextBox();
			this.ShutDown = new System.Windows.Forms.Button();

			// 
			// Messages
			// 
			this.Messages.Location = new System.Drawing.Point(32, 32);
			this.Messages.Name = "Messages";
			this.Messages.ReadOnly = true;
			this.Messages.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
			this.Messages.Size = new System.Drawing.Size(736, 400);
			this.Messages.TabIndex = 0;
			this.Messages.Text = "";

			// 
			// ShutDown
			// 
			this.ShutDown.Location = new System.Drawing.Point(648, 452);
			this.ShutDown.Name = "ShutDown";
			this.ShutDown.Size = new System.Drawing.Size(120, 32);
			this.ShutDown.TabIndex = 2;
			this.ShutDown.Text = "Shut Down";
			this.ShutDown.Click += new System.EventHandler(this.ShutDown_Click);

			// 
			// LOLGameServerForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(792, 566);
			this.Name = "LOLGameServerForm";
			this.Text = "Land of Legends -- Game Server";
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.ShutDown,
																		  this.Messages});

		}
		#endregion

		#region Main
		[STAThread]
		static void Main() 
		{
			Application.Run(new LOLGameServer());
		}
		#endregion

		#region Public Properties
		#endregion

		#region Public Methods
		#endregion

		private void ShutDown_Click(object sender, System.EventArgs e)
		{
			_gameServer.ShutDown();
			Application.Exit();
		}
	}
}