using System;
using System.Collections;
using System.IO;
using SI_DBQuery;
using LobbyServer;

namespace SI_MiddleTier
{
	public class MiddleTier
	{
		public struct GameList
		{
			public int ID;
			public string Status;
			public string StartTime;
			public int GameTypeID;
			public int ChallengerUserID;
			public int ChallengedUserID;
		};

		private DBQuery _dbquery = null;

		#region Public Static Functions
		public static void RecordMessageToErrorFile(string __errorText) 
		{
			try 
			{
				StreamWriter __errorFile = File.AppendText("c:\\inetpub\\lol\\thservers\\ErrorLog.txt");
				__errorFile.Write("Date/Time:  " + DateTime.Now.ToString() + System.Environment.NewLine + System.Environment.NewLine);
				__errorFile.Write(__errorText);
				__errorFile.Write(System.Environment.NewLine + System.Environment.NewLine + "---------------------------------------------------------------------" + System.Environment.NewLine + System.Environment.NewLine);
				__errorFile.Close();
			} 
			catch {}
		}
		public static void RecordExceptionToErrorFile(string serverName, Exception e) 
		{
			RecordExceptionToErrorFile(serverName, e, "");
		}
		public static void RecordExceptionToErrorFile(string serverName, Exception e, string extraMessage) 
		{
			string __errorMessageText = "";
			__errorMessageText += "Server Name:  " + serverName + System.Environment.NewLine + System.Environment.NewLine;
			__errorMessageText += "Error Message:  " + e.Message + System.Environment.NewLine + System.Environment.NewLine;
			__errorMessageText += "Method:  " + e.TargetSite  + System.Environment.NewLine;
			__errorMessageText += "Component:  " + e.Source + System.Environment.NewLine + System.Environment.NewLine;
			if (extraMessage!="") 
			{
				__errorMessageText += "Extra Info:  " + extraMessage + System.Environment.NewLine + System.Environment.NewLine;
			
			}
			__errorMessageText += "Stack Trace:  " + System.Environment.NewLine + e.StackTrace;

			RecordMessageToErrorFile(__errorMessageText);

			//        StreamWriter __errorFile = File.AppendText("ErrorLog.txt");
			//        __errorFile.Write(__errorMessageText);
			//        __errorFile.Write("---------------------------------------------------------------------");
			//        __errorFile.Close();

		}
		#endregion

		public MiddleTier(string databaseName)
		{
			_dbquery = new DBQuery(databaseName);
		}

		public void Dispose()
		{
			if (_dbquery != null)
			{
				_dbquery.Dispose();
			}
		}

		public LobbyServer.LobbyMessageType AuthenticateUser(string username, string password, 
			bool doLogin, out int userID)
		{
			userID = AuthenticateUser(username, password, doLogin);

			if (userID == -1)
			{
				return LobbyServer.LobbyMessageType.InvalidUser;
			}
			else if (userID == 0)
			{
				int __testIsNotActive = _dbquery.AuthQuery("User", new string[] {"User_Username", "User_Password"}, 
					new string[] {username, password}, "UserID");

				if (__testIsNotActive > 0)
				{
					return LobbyServer.LobbyMessageType.UserNotValidated;
				}
				else
				{
					return LobbyServer.LobbyMessageType.InvalidPassword;
				}
			}
			else
			{
				// The user has authenticated and we already have the userid set
				if (doLogin)
				{
					return LobbyServer.LobbyMessageType.LoginSuccess;
				}
				else
				{
					return LobbyServer.LobbyMessageType.AuthenticatedOnly;
				}
			}
		}

		public int AuthenticateUser(string username, string password, bool doLogin)
		{
			// -1 = The user was not found
			//  0 = Bad username or password combo (or other criteria for found user was not met)
			// >0 = The user was authenticated

			//DBSTUB:  this should be a simple matter of uncommenting this and commenting out the random UserID, but you're better suited than me to be sure of that.
			//UNSTUBBED: yes, that's right, and i also added an overload for this that gets the result enum type
			int __userID = _dbquery.AuthQuery("User", new string[] {"User_Username", "User_Password", "User_IsActive"}, 
				new string[] {username, password, "1"}, "UserID");
			//            Random __random = new Random();
			//
			//            int __userID=__random.Next();

			if (doLogin && (__userID >= 1) )
			{
				// Passing null IP address, if we have this info and want it logged, replace null here
				LoginUser(__userID, null);
			}

			return __userID;
		}

		public int FindUser(string username)
		{
			return FindUser(username, false);
		}

		public int FindUser(string username, bool isActiveOnly)
		{
			int __userID = -1;
    			
			if (isActiveOnly)
			{
				try
				{
					__userID = int.Parse(_dbquery.GetCell("User", new string[] {"User_Username", "User_IsActive"}, 
						new string[] {username, "1"}, "UserID"));
				}
				catch {}
			}
			else
			{
				try
				{
					__userID = int.Parse(_dbquery.GetCell("User", "User_Username", username, "UserID"));
				}
				catch {}
			}

			return __userID;
		}

		public int CreateUser(string username, string password)
		{
			int __userID = -1;

			if (FindUser(username) >= 0)
			{
				return __userID;
			}

			__userID = _dbquery.InsertRow("User", new string[] {"1", DBQuery.NULL(), 
																   username, DBQuery.PASSWORD(password), "1", DBQuery.NOW(), DBQuery.NULL()});

			return __userID;
		}

		private int LoginUser(int userID, string ipAddress)
		{
			if (ipAddress == null)
			{
				ipAddress = DBQuery.NULL();
			}

			string[] __cols = new string[2] {"User_LastLoginTime", "User_LastIPAddress"};
			string[] __vals = new string[2] {DBQuery.NOW(), ipAddress};

			int __result = _dbquery.UpdateRow("User", "UserID", userID.ToString(), __cols, __vals);

			return __result;
		}

		public bool IsValidGameVersion(string gameName, string version)
		{
			object[] __result = _dbquery.GetRows("GameType", "GameTypeID", 
				DBQuery.LITERAL("GameTypeID"), new string[] {"GameType_Name", "GameType_Version"});

			if (__result != null)
			{
				foreach (string[] s in __result)
				{
					if ( (s[0] == gameName) && (s[1] == version) )
					{
						return true;
					}
				}
			}
            
			return false;
		}

		public int GetGameTypeIDs(out int[] typeIDs, out string[] typeNames)
		{
			object[] __result = _dbquery.GetRows("GameType", "GameTypeID", 
				DBQuery.LITERAL("GameTypeID"), new string[2] {"GameTypeID", "GameType_Name"});

			if (__result == null)
			{
				typeIDs = null;
				typeNames = null;

				return 0;
			}
			else
			{
				int __count = __result.Length;
				typeIDs = new int[__count];
				typeNames = new string[__count];
				int i = 0;

				foreach (string[] s in __result)
				{
					typeIDs[i] = int.Parse(s[0]);
					typeNames[i] = s[1];
					i ++;
				}

				return __count;
			}
		}

		public int CreateNewGame(int challengerID, int challengedID, int gameTypeID, bool isRated)
		{
			int __result = _dbquery.InsertRow("Game", new string[] {"1", null, challengerID.ToString(), 
																	   challengedID.ToString(), null, gameTypeID.ToString(), DBQuery.BOOL(isRated), 
																	   DBQuery.BOOL(true), "reserved", null, null, null, null, null});

			return __result;
		}

		public int CancelNewGame(int gameID)
		{
			string[] __cols = new string[1] {"Game_Status"};
			string[] __vals = new string[1] {"cancelled"};

			int __result = _dbquery.UpdateRow("Game", "GameID", gameID.ToString(), __cols, __vals);

			return __result;
		}

		public int StartNewGame(int gameID, bool isChallengerPlayer1, string gameSetupString)
		{
			string[] __cols = new string[4] {"Game_Status", "Game_ChallengerIsP1", "Game_StartTime", "Game_SetupInfo"};
			string[] __vals = new string[4] {"started", DBQuery.BOOL(isChallengerPlayer1), DBQuery.NOW(), gameSetupString};

			int __result = _dbquery.UpdateRow("Game", "GameID", gameID.ToString(), __cols, __vals);

			return __result;
		}

		public int AppendTurnToGame(int gameID, string turnInfo)
		{
			string[] __cols = new string[1] {"Game_ActionList"};
			string[] __vals = new string[1] {DBQuery.APPEND("Game_ActionList", turnInfo)};

			int __result = _dbquery.UpdateRow("Game", "GameID", gameID.ToString(), __cols, __vals);

			return __result;
		}

		public int EndGame(int gameID, string winningUsername)
		{
			return EndGame(gameID, winningUsername, null);
		}

		public int EndGame(int gameID, int winningPlayerID)
		{
			return EndGame(gameID, winningPlayerID, null);
		}

		public int EndGame(int gameID, string winningUsername, string victoryCondition)
		{
			return EndGame(gameID, FindUser(winningUsername), victoryCondition);
		}

		public int EndGame(int gameID, int winningPlayerID, string victoryCondition)
		{
			string[] __cols = new string[4] {"Game_Winner_UserID", "Game_StopTime", "Game_Status", 
												"Game_VictoryCondition"};
			string[] __vals = new string[4] {DBQuery.LITERAL("IFNULL(Game_Winner_UserID," + 
												winningPlayerID.ToString() + ")"), DBQuery.NOW(), "over", 
												DBQuery.LITERAL("IFNULL(Game_VictoryCondition," + DBQuery.ValidateInput(victoryCondition) + ")")};

			int __result = _dbquery.UpdateRow("Game", "GameID", gameID.ToString(), __cols, __vals);

			return __result;
		}

		public string GetGameStatus(int gameID)
		{
			string __result = _dbquery.GetCell("Game", "GameID", gameID.ToString(), "Game_Status");

			return __result;
		}

		public static string GetPlayerStatEntry(string[] entries, string statType)
		{
			foreach (string r in entries)
			{
				string[] __fields = r.Split(new char[] {','}, 3);

				if (__fields[0].ToLower() == statType)
				{
					return __fields[1];
				}
			}

			return "";
		}

		public string[] GetPlayerStats(int playerID)
		{
			string[] __cols = new string[3] {"GameStat_Type", "GameStat_Value", "GameStat_EntryTime"};

			string[] __result = _dbquery.GetList("GameStat", "GameStat_UserID", playerID.ToString(),  
				DBQuery.APPENDCOLS(__cols, ","), "GameStat_EntryTime", true);

			return __result;
		}

		public void GetPlayerWinsAndLosses(int playerID, ref int wins, ref int losses)
		{
			object[] __result = _dbquery.RowsQuery("SELECT Game_Challenger_UserID, Game_Challenged_UserID, IFNULL(Game_Winner_UserID,0) " + 
				"FROM Game WHERE Game_Challenger_UserID = " + playerID.ToString() + " OR Game_Challenged_UserID = " + playerID.ToString());

			wins = 0;
			losses = 0;

			if (__result != null)
			{
				foreach (string[] __cols in __result)
				{
					int __winner = Convert.ToInt32(__cols[2]);

					if (__winner == playerID)
					{
						wins ++;
					}
					else if (__winner > 0)
					{
						losses ++;
					}
				}
			}
		}

		public void AddPlayerStat(int playerID, string statType, string statValue)
		{
			_dbquery.InsertRow("GameStat", new string[] {"1", "NULL", playerID.ToString(), statType, statValue, DBQuery.NOW()});
		}

		public string GetUsername(int playerID)
		{
			string[] __userCols = new string[2] {"User_Username", "User_IsActive"};

			string[] userInfo = _dbquery.GetRow("User", "UserID", playerID.ToString(), __userCols);

			if (userInfo != null)
			{
				if (userInfo[1] == "1")
				{
					return userInfo[0];
				}
			}

			return "";
		}

		public void GetPlayerInfo(int playerID, out string[] userInfo, out string[] contactInfo, 
			out string[] licenseInfo)
		{
			string[] __userCols = new string[3] {"User_Username", "User_IsActive", "User_LastLoginTime"};
			string[] __contactCols = new string[4] {"Contact_FirstName", "Contact_LastName", "Contact_Email", 
													   "Contact_Country"};
			string[] __licenseCols = new string[2] {"GameLicense_GameTypeID", "GameLicense_StartDate"};

			userInfo = _dbquery.GetRow("User", "UserID", playerID.ToString(), __userCols);
			contactInfo = _dbquery.GetRow("Contact", "Contact_UserID", playerID.ToString(), __contactCols);
			licenseInfo = _dbquery.GetRow("GameLicense", "GameLicense_UserID", playerID.ToString(), __licenseCols);
		}

		public GameList GetGameInfo(int gameID)
		{
			string[] __cols = new string[6] {"GameID", "Game_Status", "Game_StartTime", "Game_GameTypeID", 
												"Game_Challenger_UserID", "Game_Challenged_UserID"};

			string[] __game = _dbquery.GetRow("Game", "GameID", gameID.ToString(), __cols);
			GameList __result = new GameList();

			if (__game != null)
			{
				__result.ID = int.Parse(__game[0]);
				__result.Status = __game[1];
				__result.StartTime = __game[2];
				__result.GameTypeID = int.Parse(__game[3]);
				__result.ChallengerUserID = int.Parse(__game[4]);
				__result.ChallengedUserID = int.Parse(__game[5]);
			}

			return __result;
		}

		public GameList[] GetActiveGames()
		{
			string[] __cols = new string[6] {"GameID", "Game_Status", "Game_StartTime", "Game_GameTypeID", 
												"Game_Challenger_UserID", "Game_Challenged_UserID"};

			object[] __games = _dbquery.GetRows("Game", "Game_Status", "started", __cols);
			GameList[] __result = new GameList[__games.Length];
			int i = 0;

			foreach (string[] s in __games)
			{
				GameList g;
				g.ID = int.Parse(s[0]);
				g.Status = s[1];
				g.StartTime = s[2];
				g.GameTypeID = int.Parse(s[3]);
				g.ChallengerUserID = int.Parse(s[4]);
				g.ChallengedUserID = int.Parse(s[5]);

				__result[i] = g;
				i ++;
			}

			return __result;
		}

		public int[] GetPlayersActiveGames(int playerID)
		{
			GameList[] __rawGameList = GetActiveGames();
			ArrayList __list = new ArrayList();

			foreach (GameList g in __rawGameList)
			{
				if ( (g.ChallengedUserID == playerID) || (g.ChallengerUserID == playerID) )
				{
					__list.Add(g.ID);
				}
			}

			int[] __gameIDs = new int[__list.Count];

			for (int i = 0; i < __list.Count; i ++)
			{
				__gameIDs[i] = (int) __list[i];
			}

			return __gameIDs;
		}

		public GameList[] GetActiveGames(int daysOld)
		{
			GameList[] __rawGameList = GetActiveGames();
			ArrayList __list = new ArrayList();

			System.DateTime __today = System.DateTime.Now;

			foreach (GameList g in __rawGameList)
			{
				System.DateTime d = System.DateTime.Parse(g.StartTime);

				if (d.Add(TimeSpan.FromDays(daysOld)).CompareTo(__today) >= 0)
				{
					__list.Add(g);
				}
			}

			GameList[] __result = new GameList[__list.Count];

			for (int i = 0; i < __list.Count; i ++)
			{
				__result[i] = (GameList) __list[i];
			}

			return __result;
		}
	}
}



